/*
 * Decompiled with CFR 0.152.
 */
package org.edna.datamodel.transformations.workflow;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xtext.mwe.UriFilter;

public class TargetUriFilter
implements UriFilter {
    private URI uri;

    public boolean matches(URI uri) {
        String currentFileName;
        String sourceFileName;
        String uriAsString = uri.toString();
        if (!uriAsString.contains("datamodel")) {
            return false;
        }
        if (uriAsString.contains("/.svn/")) {
            return false;
        }
        if (!uri.lastSegment().endsWith(".edml")) {
            return false;
        }
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            if (uri.isPlatformResource()) {
                if (!EcorePlugin.getWorkspaceRoot().getProject(uri.segment(1)).isOpen()) {
                    return false;
                }
            } else if (uri.isFile()) {
                boolean uriIsFromOpenProject = false;
                for (String projectName : EcorePlugin.getPlatformResourceMap().keySet()) {
                    URI projectUri = (URI)EcorePlugin.getPlatformResourceMap().get(projectName);
                    if (!uriAsString.startsWith(projectUri.toString()) || !EcorePlugin.getWorkspaceRoot().getProject(projectName).isOpen()) continue;
                    uriIsFromOpenProject = true;
                    break;
                }
                if (!uriIsFromOpenProject) {
                    return false;
                }
            }
        }
        boolean result = !(sourceFileName = this.uri.lastSegment().substring(0, this.uri.lastSegment().lastIndexOf(46))).equals(currentFileName = uri.lastSegment().substring(0, uri.lastSegment().lastIndexOf(46))) && "XSDataCommon".equals(currentFileName);
        return result;
    }

    public void setUri(String uri) {
        this.uri = URI.createURI((String)uri);
    }
}

