/*
 * Decompiled with CFR 0.152.
 */
package org.edna.datamodel.transformations.m2m;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDSwitch;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.edna.datamodel.datamodel.ComplexType;
import org.edna.datamodel.datamodel.DatamodelFactory;
import org.edna.datamodel.datamodel.DatamodelPackage;
import org.edna.datamodel.datamodel.ElementDeclaration;
import org.edna.datamodel.datamodel.Model;
import org.edna.datamodel.datamodel.Package;
import org.edna.datamodel.datamodel.PrimitiveType;
import org.edna.datamodel.transformations.m2m.AbstractDatamodelTransformation;
import org.edna.datamodel.transformations.m2m.Comparators;
import org.edna.datamodel.transformations.m2m.EmfCreateFunction;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xsd2DslTransformation
extends AbstractDatamodelTransformation<XSDSchema, Model> {
    private EmfCreateFunction<XSDTypeDefinition, ComplexType> createComplexType = new EmfCreateFunction<XSDTypeDefinition, ComplexType>(DatamodelPackage.Literals.COMPLEX_TYPE){
        private Map<String, ComplexType> types;
        {
            this.types = null;
        }

        @Override
        protected ComplexType find(XSDTypeDefinition source) {
            if (this.types == null) {
                this.types = Maps.newTreeMap(Comparators.stringComparator);
                for (IResourceDescription desc : Xsd2DslTransformation.this.index.getAllResourceDescriptions()) {
                    for (IEObjectDescription objDesc : desc.getExportedObjects(DatamodelPackage.eINSTANCE.getComplexType())) {
                        ComplexType t = (ComplexType)objDesc.getEObjectOrProxy();
                        this.types.put(t.getName(), t);
                    }
                }
            }
            return this.types.get(source.getName());
        }

        @Override
        public ComplexType configure(XSDTypeDefinition source, ComplexType target) {
            XSDAnnotation a;
            XSDElementDeclaration elementDeclaration;
            this.types.put(source.getName(), target);
            target.setName(source.getName());
            if (source.getBaseType() != null && !"anyType".equals(source.getBaseType().getName())) {
                Object _baseType = Xsd2DslTransformation.this.getType(source.getBaseType());
                if (!(_baseType instanceof ComplexType)) {
                    throw new IllegalArgumentException("Base type of " + source.getName() + " is a Primitive Type, which is not supported!");
                }
                ComplexType baseType = (ComplexType)Xsd2DslTransformation.this.getType(source.getBaseType());
                if (baseType != null) {
                    target.setBaseType(baseType);
                }
            }
            if ((elementDeclaration = ((XSDSchema)Xsd2DslTransformation.this.sourceModel).resolveElementDeclaration(source.getName())) != null && (a = elementDeclaration.getAnnotation()) != null && a.getUserInformation(null) != null && !a.getUserInformation(null).isEmpty()) {
                String doc = ((Element)a.getUserInformation(null).get(0)).getTextContent();
                target.setDoc(doc);
            }
            return target;
        }
    };
    private EmfCreateFunction<XSDParticle, ElementDeclaration> createElementDeclaration = new EmfCreateFunction<XSDParticle, ElementDeclaration>(DatamodelPackage.Literals.ELEMENT_DECLARATION){

        @Override
        public ElementDeclaration configure(XSDParticle source, ElementDeclaration target) {
            Object type;
            XSDAnnotation a;
            XSDElementDeclaration element = (XSDElementDeclaration)source.getTerm();
            target.setName(element.getName());
            target.setMultiple(source.getMaxOccurs() != 1);
            target.setOptional(source.getMinOccurs() == 0);
            if (element.getAnnotation() != null && (a = element.getAnnotation()).getUserInformation(null) != null) {
                String doc = ((Element)a.getUserInformation(null).get(0)).getTextContent();
                target.setDoc(doc);
            }
            if ((type = Xsd2DslTransformation.this.getType(element.getType())) != null) {
                if (type instanceof PrimitiveType) {
                    target.setType((PrimitiveType)type);
                } else {
                    target.setRef((ComplexType)type);
                }
            }
            return target;
        }
    };

    @Override
    public Model transform(XSDSchema sourceModel) {
        this.sourceModel = sourceModel;
        this.targetModel = DatamodelFactory.eINSTANCE.createModel();
        ((Model)this.targetModel).setTargetNamespace(this.nsUri);
        this.loadIncludes();
        new XSDSwitch<EObject>(){
            private Stack<Package> packageStack = new Stack();

            public EObject caseXSDSchema(XSDSchema object) {
                ArrayList types = Lists.newArrayList((Iterable)object.getTypeDefinitions());
                Collections.sort(types, Comparators.nameResolverComparator);
                for (EObject obj : types) {
                    this.doSwitch(obj);
                }
                return object;
            }

            public EObject caseXSDComplexTypeDefinition(XSDComplexTypeDefinition object) {
                Package currentPackage;
                if (Xsd2DslTransformation.this.monitor.isCanceled()) {
                    return null;
                }
                Xsd2DslTransformation.this.monitor.subTask(object.getName());
                ComplexType type = (ComplexType)Xsd2DslTransformation.this.createComplexType.apply(object);
                Package package_ = currentPackage = this.packageStack.isEmpty() ? null : this.packageStack.peek();
                if (currentPackage != null) {
                    currentPackage.getTypes().add((Object)type);
                } else {
                    ((Model)Xsd2DslTransformation.this.targetModel).getTypes().add((Object)type);
                }
                Xsd2DslTransformation.this.monitor.worked(1);
                return object;
            }
        }.doSwitch((EObject)sourceModel);
        new XSDSwitch<EObject>(){

            public EObject caseXSDSchema(XSDSchema object) {
                for (XSDTypeDefinition type : object.getTypeDefinitions()) {
                    this.doSwitch((EObject)type);
                }
                return object;
            }

            public EObject caseXSDComplexTypeDefinition(XSDComplexTypeDefinition source) {
                ComplexType target = (ComplexType)Xsd2DslTransformation.this.createComplexType.apply(source);
                XSDParticle complexTypeContent = (XSDParticle)source.getContent();
                XSDModelGroup sequenceForAttributes = (XSDModelGroup)complexTypeContent.getContent();
                for (XSDParticle p : sequenceForAttributes.getContents()) {
                    ElementDeclaration element = (ElementDeclaration)Xsd2DslTransformation.this.createElementDeclaration.apply(p);
                    target.getElements().add((Object)element);
                }
                return target;
            }
        }.doSwitch((EObject)sourceModel);
        return (Model)this.targetModel;
    }

    private Object getType(XSDTypeDefinition xsdType) {
        return new XSDSwitch<Object>(){

            public Object caseXSDComplexTypeDefinition(XSDComplexTypeDefinition object) {
                return Xsd2DslTransformation.this.createComplexType.apply(object);
            }

            public Object caseXSDSimpleTypeDefinition(XSDSimpleTypeDefinition object) {
                PrimitiveType primitiveType = Xsd2DslTransformation.this.getPrimitiveType(object.getName());
                if (primitiveType != null) {
                    return primitiveType;
                }
                return Xsd2DslTransformation.this.createComplexType.apply(object);
            }
        }.doSwitch((EObject)xsdType);
    }

    private PrimitiveType getPrimitiveType(String name) {
        if ("string".equals(name)) {
            return PrimitiveType.STRING;
        }
        if ("integer".equals(name)) {
            return PrimitiveType.INTEGER;
        }
        if ("float".equals(name)) {
            return PrimitiveType.FLOAT;
        }
        if ("double".equals(name)) {
            return PrimitiveType.DOUBLE;
        }
        if ("boolean".equals(name)) {
            return PrimitiveType.BOOLEAN;
        }
        return null;
    }

    private void loadIncludes() {
        for (XSDInclude include : Iterables.filter((Iterable)((XSDSchema)this.sourceModel).getContents(), XSDInclude.class)) {
            include.getSchemaLocation();
            String[] stringArray = this.includePaths;
            int n = this.includePaths.length;
            int n2 = 0;
            while (n2 < n) {
                String includePath = stringArray[n2];
                File f = new File(String.valueOf(includePath) + "/" + include.getSchemaLocation());
                if (f.exists()) {
                    URI uri = URI.createFileURI((String)f.getPath());
                    this.getResourceSet().getResource(uri, true);
                    URI dslUri = URI.createURI((String)uri.toString().replace(".xsd", ".edml"));
                    this.getResourceSet().getResource(dslUri, true);
                }
                ++n2;
            }
        }
    }

    @Override
    protected int getAmountOfWork(XSDSchema sourceModel) {
        int numberOfClasses = EcoreUtil2.eAllOfType((EObject)sourceModel, ComplexType.class).size();
        return numberOfClasses + 2;
    }
}

