/*
 * Decompiled with CFR 0.152.
 */
package org.edna.datamodel.transformations.m2m;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLSwitch;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xtext.EcoreUtil2;
import org.edna.datamodel.transformations.m2m.AbstractDatamodelTransformation;
import org.edna.datamodel.transformations.m2m.Comparators;
import org.edna.datamodel.transformations.m2m.EmfCreateFunction;
import org.edna.datamodel.transformations.util.JavaExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Uml2XsdTransformation
extends AbstractDatamodelTransformation<Model, XSDSchema> {
    private static final Set<String> IGNORED_RESOURCES = Sets.newHashSet((Object[])new String[]{"XSDPrimitiveTypes.uml", "Standard.profile.uml", "Ecore.profile.uml", "UML.metamodel.uml", "Ecore.metamodel.uml", "UMLPrimitiveTypes.library.uml"});
    private EmfCreateFunction<Class, XSDComplexTypeDefinition> createXSDComplexTypeDefinition = new EmfCreateFunction<Class, XSDComplexTypeDefinition>(XSDPackage.eINSTANCE.getXSDComplexTypeDefinition()){

        @Override
        public XSDComplexTypeDefinition configure(Class source, XSDComplexTypeDefinition target) {
            target.setName(source.getName());
            if (!source.getSuperClasses().isEmpty()) {
                XSDTypeDefinition baseType = Uml2XsdTransformation.this.getTypeDefinition((Type)source.getSuperClasses().get(0));
                target.setBaseTypeDefinition(baseType);
                target.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
            }
            XSDParticle complexTypeContent = XSDFactory.eINSTANCE.createXSDParticle();
            target.setContent((XSDComplexTypeContent)complexTypeContent);
            XSDModelGroup sequenceForAttributes = XSDFactory.eINSTANCE.createXSDModelGroup();
            complexTypeContent.setContent((XSDParticleContent)sequenceForAttributes);
            sequenceForAttributes.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
            for (Property p : Iterables.concat((Iterable)source.getOwnedAttributes(), Uml2XsdTransformation.this.getNavigableAssociationEnds(source))) {
                XSDParticle particle = (XSDParticle)Uml2XsdTransformation.this.createXSDParticle.apply(p);
                sequenceForAttributes.getContents().add((Object)particle);
            }
            return target;
        }
    };
    private EmfCreateFunction<Property, XSDParticle> createXSDParticle = new EmfCreateFunction<Property, XSDParticle>(XSDPackage.eINSTANCE.getXSDParticle()){

        @Override
        public XSDParticle configure(Property source, XSDParticle target) {
            target.setMaxOccurs(source.upperBound());
            target.setMinOccurs(source.getLower());
            XSDElementDeclaration content = (XSDElementDeclaration)Uml2XsdTransformation.this.createXSDElementDeclarationForProperty.apply(source);
            target.setContent((XSDParticleContent)content);
            String documentation = JavaExtensions.getDocumentationText((Element)source);
            if (documentation != null) {
                XSDAnnotation doc = JavaExtensions.createDocumentation(content, documentation);
                content.setAnnotation(doc);
            }
            return target;
        }
    };
    private EmfCreateFunction<Class, XSDElementDeclaration> createXSDElementDeclarationForClass = new EmfCreateFunction<Class, XSDElementDeclaration>(XSDPackage.eINSTANCE.getXSDElementDeclaration()){

        @Override
        public XSDElementDeclaration configure(Class from, XSDElementDeclaration target) {
            target.setName(from.getName());
            target.setTypeDefinition((XSDTypeDefinition)Uml2XsdTransformation.this.createXSDComplexTypeDefinition.apply(from));
            return target;
        }
    };
    private EmfCreateFunction<Property, XSDElementDeclaration> createXSDElementDeclarationForProperty = new EmfCreateFunction<Property, XSDElementDeclaration>(XSDPackage.eINSTANCE.getXSDElementDeclaration()){

        @Override
        public XSDElementDeclaration configure(Property source, XSDElementDeclaration target) {
            target.setName(source.getName());
            target.setTypeDefinition(Uml2XsdTransformation.this.getTypeDefinition(source.getType()));
            return target;
        }
    };
    private List<Class> allClasses;

    @Override
    public XSDSchema transform(Model sourceModel) {
        this.sourceModel = sourceModel;
        this.targetModel = XSDFactory.eINSTANCE.createXSDSchema();
        ((XSDSchema)this.targetModel).getQNamePrefixToNamespaceMap().put(null, this.nsUri);
        ((XSDSchema)this.targetModel).getQNamePrefixToNamespaceMap().put("xs", "http://www.w3.org/2001/XMLSchema");
        ((XSDSchema)this.targetModel).setSchemaForSchemaQNamePrefix("xs");
        ((XSDSchema)this.targetModel).setTargetNamespace(this.nsUri);
        this.createIncludes();
        for (Class cls : this.allClasses()) {
            XSDElementDeclaration clsElement = (XSDElementDeclaration)this.createXSDElementDeclarationForClass.apply(cls);
            ((XSDSchema)this.targetModel).getContents().add((Object)clsElement);
            ((XSDSchema)this.targetModel).getContents().add((Object)((XSDSchemaContent)this.createXSDComplexTypeDefinition.apply(cls)));
            this.monitor.worked(1);
        }
        this.transformDocumentation(sourceModel);
        return (XSDSchema)this.targetModel;
    }

    protected void transformDocumentation(Model sourceModel) {
        for (Class cls : this.allClasses()) {
            if (JavaExtensions.getDocumentationText((Element)cls) != null) {
                XSDElementDeclaration xsdElement = (XSDElementDeclaration)this.createXSDElementDeclarationForClass.apply(cls);
                JavaExtensions.createDocumentation(xsdElement, JavaExtensions.getDocumentationText((Element)cls));
            }
            for (Property p : Iterables.concat((Iterable)cls.getOwnedAttributes(), this.getNavigableAssociationEnds(cls))) {
                if (JavaExtensions.getDocumentationText((Element)p) == null) continue;
                XSDElementDeclaration xsdElement = (XSDElementDeclaration)this.createXSDElementDeclarationForProperty.apply(p);
                JavaExtensions.createDocumentation(xsdElement, JavaExtensions.getDocumentationText((Element)p));
            }
        }
        this.monitor.worked(1);
    }

    private XSDTypeDefinition getTypeDefinition(Type type) {
        return (XSDTypeDefinition)new UMLSwitch<XSDTypeDefinition>(){

            public XSDTypeDefinition caseClass(Class object) {
                return (XSDTypeDefinition)Uml2XsdTransformation.this.createXSDComplexTypeDefinition.apply(object);
            }

            public XSDTypeDefinition casePrimitiveType(PrimitiveType object) {
                return JavaExtensions.resolvePrimitiveTypeDefinition((XSDSchema)Uml2XsdTransformation.this.targetModel, object.getName());
            }
        }.doSwitch((EObject)type);
    }

    private void createIncludes() {
        final Resource sourceResource = ((Model)this.sourceModel).eResource();
        Iterable resources = Iterables.filter((Iterable)sourceResource.getResourceSet().getResources(), (Predicate)new Predicate<Resource>(){

            public boolean apply(Resource input) {
                return input.getURI().lastSegment().endsWith(".xsd") && !input.getURI().lastSegment().equals(sourceResource.getURI().lastSegment()) && !IGNORED_RESOURCES.contains(input.getURI().lastSegment());
            }
        });
        HashSet includes = Sets.newHashSet();
        for (Resource r : resources) {
            XSDInclude include = XSDFactory.eINSTANCE.createXSDInclude();
            String path = r.getURI().lastSegment().replace("uml", ".xsd");
            include.setSchemaLocation(path);
            includes.add(include);
        }
        ((XSDSchema)this.targetModel).getContents().addAll((Collection)includes);
    }

    private Iterable<Class> allClasses() {
        if (this.allClasses == null) {
            this.allClasses = Lists.newArrayList();
            for (EObject o : EcoreUtil2.eAllOfType((EObject)((EObject)this.sourceModel), Class.class)) {
                this.allClasses.add((Class)o);
            }
            Collections.sort(this.allClasses, Comparators.namedElementComparator);
        }
        return this.allClasses;
    }

    protected Iterable<Property> getNavigableAssociationEnds(final Class cls) {
        ArrayList result = Lists.newArrayList();
        for (Association assoc : cls.getAssociations()) {
            Iterable ends = Iterables.filter((Iterable)assoc.getMemberEnds(), (Predicate)new Predicate<Property>(){

                public boolean apply(Property input) {
                    return input.isNavigable() && input.getType() != cls;
                }
            });
            for (Property p : ends) {
                result.add(p);
            }
        }
        return result;
    }

    @Override
    public Resource loadSourceModel() {
        Resource res = super.loadSourceModel();
        EcoreUtil.resolveAll((Resource)res);
        ArrayList toLoad = Lists.newArrayList();
        for (Resource r : res.getResourceSet().getResources()) {
            URI xsdUri;
            if (!r.getURI().lastSegment().endsWith(".uml") || (xsdUri = URI.createURI((String)r.getURI().toString().replace(".uml", ".xsd"))).equals((Object)this.targetUri)) continue;
            toLoad.add(xsdUri);
        }
        for (URI xsdUri : toLoad) {
            try {
                res.getResourceSet().getResource(xsdUri, true);
            }
            catch (WrappedException e) {
                this.LOG.debug((Object)e.getMessage());
            }
        }
        return res;
    }

    @Override
    protected int getAmountOfWork(Model sourceModel) {
        int numberOfClasses = EcoreUtil2.eAllOfType((EObject)sourceModel, Class.class).size();
        return numberOfClasses + 1;
    }
}

