/*
 * Decompiled with CFR 0.152.
 */
package org.edna.datamodel.transformations.m2m;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.Strings;
import org.edna.datamodel.datamodel.ComplexType;
import org.edna.datamodel.datamodel.ElementDeclaration;
import org.edna.datamodel.datamodel.Model;
import org.edna.datamodel.datamodel.util.DatamodelSwitch;
import org.edna.datamodel.transformations.m2m.AbstractDatamodelTransformation;
import org.edna.datamodel.transformations.m2m.Comparators;
import org.edna.datamodel.transformations.m2m.EmfCreateFunction;
import org.edna.datamodel.transformations.m2m.NamingUtil;
import org.edna.datamodel.transformations.util.JavaExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dsl2UmlTransformation
extends AbstractDatamodelTransformation<Model, org.eclipse.uml2.uml.Model> {
    private ModelTraverser modelTraverser = new ModelTraverser();
    private EmfCreateFunction<org.edna.datamodel.datamodel.Package, Package> createPackage = new EmfCreateFunction<org.edna.datamodel.datamodel.Package, Package>(UMLPackage.eINSTANCE.getPackage()){

        @Override
        protected Package configure(org.edna.datamodel.datamodel.Package source, Package newInstance) {
            newInstance.setName(NamingUtil.normalize(source.getName()));
            return null;
        }
    };
    private EmfCreateFunction<ElementDeclaration, Property> createProperty = new EmfCreateFunction<ElementDeclaration, Property>(UMLPackage.eINSTANCE.getProperty()){

        @Override
        public Property configure(ElementDeclaration source, Property target) {
            target.setName(source.getName());
            target.setLower(source.isOptional() ? 0 : 1);
            target.setUpper(source.isMultiple() ? -1 : 1);
            if (source.getRef() != null) {
                Class type = (Class)Dsl2UmlTransformation.this.createClass.apply(source.getRef());
                target.setType((Type)type);
            } else {
                PrimitiveType type = null;
                for (PrimitiveType t : JavaExtensions.getXsdPrimitiveTypes()) {
                    if (!t.getName().equals(source.getType().getName())) continue;
                    type = t;
                    break;
                }
                if (type == null) {
                    throw new IllegalStateException("Unknown primitive type " + source.getType().getName());
                }
                target.setType(type);
            }
            return target;
        }
    };
    private EmfCreateFunction<ElementDeclaration, Association> createAssociation = new EmfCreateFunction<ElementDeclaration, Association>(UMLPackage.eINSTANCE.getAssociation()){

        @Override
        protected Association configure(ElementDeclaration source, Association newInstance) {
            ComplexType type = (ComplexType)source.eContainer();
            newInstance.setName("A_<" + Strings.toFirstLower((String)type.getName()) + ">_<" + Strings.toFirstLower((String)source.getRef().getName()) + ">");
            return newInstance;
        }
    };
    private EmfCreateFunction<ComplexType, Class> createClass = new EmfCreateFunction<ComplexType, Class>(UMLPackage.eINSTANCE.getClass_()){

        @Override
        public Class find(ComplexType source) {
            return (Class)Dsl2UmlTransformation.this.allClasses().get(source.getName());
        }

        @Override
        public Class configure(ComplexType source, Class target) {
            target.setName(source.getName());
            if (source.getBaseType() != null) {
                Class baseType = (Class)Dsl2UmlTransformation.this.createClass.apply(source.getBaseType());
                Generalization general = UMLFactory.eINSTANCE.createGeneralization();
                general.setGeneral((Classifier)baseType);
                target.getGeneralizations().add((Object)general);
            }
            for (ElementDeclaration p : source.getElements()) {
                Property property = (Property)Dsl2UmlTransformation.this.createProperty.apply(p);
                if (p.getRef() == null || Dsl2UmlTransformation.this.isDataTypeWrapper(p.getRef())) {
                    target.getOwnedAttributes().add((Object)property);
                    continue;
                }
                Association assoc = (Association)Dsl2UmlTransformation.this.createAssociation.apply(p);
                property.setAssociation(assoc);
                assoc.getOwnedEnds().add((Object)property);
                property.setIsNavigable(true);
                Property backRefProperty = UMLFactory.eINSTANCE.createProperty();
                backRefProperty.setName(Strings.toFirstLower((String)target.getName()));
                backRefProperty.setLower(1);
                backRefProperty.setUpper(1);
                backRefProperty.setAssociation(assoc);
                backRefProperty.setIsNavigable(false);
                backRefProperty.setType((Type)target);
                assoc.getOwnedEnds().add((Object)backRefProperty);
                Dsl2UmlTransformation.this.modelTraverser.currentPackage().getPackagedElements().add((Object)assoc);
            }
            return target;
        }
    };
    private Map<String, Class> allClasses;

    @Override
    public org.eclipse.uml2.uml.Model transform(Model sourceModel) {
        this.sourceModel = sourceModel;
        this.targetModel = UMLFactory.eINSTANCE.createModel();
        EcoreUtil.resolveAll((Resource)sourceModel.eResource());
        this.modelTraverser.doSwitch((EObject)sourceModel);
        this.transformDocumentation(sourceModel);
        this.monitor.worked(1);
        if (this.monitor.isCanceled()) {
            return null;
        }
        return (org.eclipse.uml2.uml.Model)this.targetModel;
    }

    protected void transformDocumentation(Model sourceModel) {
        for (ComplexType cls : EcoreUtil2.getAllContentsOfType((EObject)sourceModel, ComplexType.class)) {
            if (cls.getDoc() != null) {
                Comment c = UMLFactory.eINSTANCE.createComment();
                c.setBody(cls.getDoc());
                Class target = (Class)this.createClass.apply(cls);
                target.getOwnedComments().add((Object)c);
            }
            for (ElementDeclaration element : cls.getElements()) {
                if (element.getDoc() == null) continue;
                Comment c = UMLFactory.eINSTANCE.createComment();
                c.setBody(element.getDoc());
                Property target = (Property)this.createProperty.apply(element);
                target.getOwnedComments().add((Object)c);
            }
        }
    }

    private boolean isDataTypeWrapper(ComplexType type) {
        return Iterables.all((Iterable)type.getElements(), (Predicate)new Predicate<ElementDeclaration>(){

            public boolean apply(ElementDeclaration input) {
                return input.getRef() == null;
            }
        });
    }

    private Map<String, Class> allClasses() {
        if (this.allClasses == null) {
            this.allClasses = Maps.newTreeMap(Comparators.stringComparator);
            for (Resource r : this.getResourceSet().getResources()) {
                if (r.getURI().lastSegment().equals(this.getTargetUri().lastSegment()) || !r.getURI().lastSegment().endsWith("uml") || r.getContents().isEmpty()) continue;
                for (Class cls : EcoreUtil2.eAllOfType((EObject)((EObject)r.getContents().get(0)), Class.class)) {
                    this.allClasses.put(cls.getName(), cls);
                }
            }
        }
        return this.allClasses;
    }

    @Override
    protected int getAmountOfWork(Model sourceModel) {
        int numberOfClasses = EcoreUtil2.eAllOfType((EObject)sourceModel, ComplexType.class).size();
        return numberOfClasses + 1;
    }

    @Override
    public Resource loadSourceModel() {
        final Resource sourceResource = super.loadSourceModel();
        Iterable resources = Iterables.filter((Iterable)sourceResource.getResourceSet().getResources(), (Predicate)new Predicate<Resource>(){

            public boolean apply(Resource input) {
                return !input.getURI().lastSegment().equals(sourceResource.getURI().lastSegment()) && input.getURI().lastSegment().endsWith("edml");
            }
        });
        for (Resource r : Lists.newArrayList((Iterable)resources)) {
            URI uriToLoad = URI.createURI((String)r.getURI().toString().replace(".edml", ".uml"));
            for (String projectName : EcorePlugin.getPlatformResourceMap().keySet()) {
                URI projectUri = (URI)EcorePlugin.getPlatformResourceMap().get(projectName);
                if (EcorePlugin.IS_ECLIPSE_RUNNING) {
                    if (!uriToLoad.toString().startsWith(projectUri.toString()) || !EcorePlugin.getWorkspaceRoot().getProject(projectName).isOpen()) continue;
                    uriToLoad = URI.createPlatformResourceURI((String)("/" + projectName + uriToLoad.toString().substring(uriToLoad.toString().indexOf(projectName) + projectName.length())), (boolean)true);
                    break;
                }
                if (!uriToLoad.toString().startsWith(projectUri.toString())) continue;
                uriToLoad = URI.createPlatformResourceURI((String)("/" + projectName + uriToLoad.toString().substring(uriToLoad.toString().indexOf(projectName) + projectName.length())), (boolean)true);
            }
            sourceResource.getResourceSet().getResource(uriToLoad, true);
        }
        return sourceResource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelTraverser
    extends DatamodelSwitch<EObject> {
        private Stack<Package> packageStack = new Stack();

        private ModelTraverser() {
        }

        public EObject caseModel(Model object) {
            this.packageStack.push((Package)Dsl2UmlTransformation.this.targetModel);
            for (EObject obj : object.eContents()) {
                this.doSwitch(obj);
            }
            this.packageStack.pop();
            return (EObject)Dsl2UmlTransformation.this.targetModel;
        }

        public EObject caseComplexType(ComplexType object) {
            if (Dsl2UmlTransformation.this.monitor.isCanceled()) {
                return null;
            }
            Dsl2UmlTransformation.this.monitor.subTask(object.getName());
            Class type = (Class)Dsl2UmlTransformation.this.createClass.apply(object);
            this.currentPackage().getPackagedElements().add((Object)type);
            Dsl2UmlTransformation.this.monitor.worked(1);
            return type;
        }

        public EObject casePackage(org.edna.datamodel.datamodel.Package object) {
            Package target = (Package)Dsl2UmlTransformation.this.createPackage.apply(object);
            this.currentPackage().getPackagedElements().add((Object)target);
            this.packageStack.push(target);
            for (EObject obj : object.eContents()) {
                this.doSwitch(obj);
            }
            this.packageStack.pop();
            return target;
        }

        public Package currentPackage() {
            return this.packageStack.peek();
        }
    }
}

