/*
 * Decompiled with CFR 0.152.
 */
package org.edna.datamodel.transformations.workflow;

import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.mwe.Reader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReaderExt
extends Reader {
    private String includePaths;
    private String resourceSetSlot = "resourceSet";
    private WorkflowContext ctx;

    public void setResourceSetSlot(String resourceSetSlot) {
        this.resourceSetSlot = resourceSetSlot;
    }

    protected void checkConfigurationInternal(Issues issues) {
        this.checkRequiredConfigProperty("resourceSetSlot", this.resourceSetSlot, issues);
        if (this.includePaths != null && !"".equals(this.includePaths)) {
            String[] stringArray = this.includePaths.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                this.addPath(path.trim());
                ++n2;
            }
        }
        super.checkConfigurationInternal(issues);
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        try {
            this.ctx = ctx;
            super.invokeInternal(ctx, monitor, issues);
            ctx.set("injectors", (Object)this.getInjectors());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void populateResourceSet(ResourceSet set, Multimap<String, URI> uris) {
        HashSet values = Sets.newHashSet((Iterable)uris.values());
        for (URI uri : values) {
            set.getResource(uri, true);
        }
        this.ctx.set(this.resourceSetSlot, (Object)set);
    }

    public void setIncludePaths(String includePaths) {
        this.includePaths = includePaths;
    }

    public String getIncludePaths() {
        return this.includePaths;
    }

    protected PathTraverser getPathTraverser() {
        return new PathTraverser(){

            public Set<URI> findAllResourceUris(String path, Predicate<URI> isValidPredicate) {
                String userDir = System.getProperty("user.dir");
                if (userDir != null && userDir.equals(path)) {
                    return Sets.newHashSet();
                }
                String homeDir = System.getenv("HOME");
                if (homeDir != null && homeDir.equals(path)) {
                    return Sets.newHashSet();
                }
                return super.findAllResourceUris(path, isValidPredicate);
            }

            protected Set<URI> traverseDir(File file, Predicate<URI> isValidPredicate) {
                HashSet result = Sets.newHashSet();
                File[] files = file.listFiles();
                if (files != null) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        if (f.isDirectory()) {
                            result.addAll(this.traverseDir(f, isValidPredicate));
                        } else {
                            URI uri = URI.createFileURI((String)f.getAbsolutePath());
                            if (isValidPredicate.apply((Object)uri)) {
                                result.add(uri);
                            }
                        }
                        ++n2;
                    }
                }
                return result;
            }
        };
    }
}

