/*
 * Decompiled with CFR 0.152.
 */
package org.edna.datamodel.transformations.m2m;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLSwitch;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.parsetree.reconstr.XtextSerializationException;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.edna.datamodel.datamodel.ComplexType;
import org.edna.datamodel.datamodel.DatamodelFactory;
import org.edna.datamodel.datamodel.DatamodelPackage;
import org.edna.datamodel.datamodel.ElementDeclaration;
import org.edna.datamodel.datamodel.Model;
import org.edna.datamodel.datamodel.PrimitiveType;
import org.edna.datamodel.transformations.m2m.AbstractDatamodelTransformation;
import org.edna.datamodel.transformations.m2m.Comparators;
import org.edna.datamodel.transformations.m2m.EmfCreateFunction;
import org.edna.datamodel.transformations.m2m.NamingUtil;
import org.edna.datamodel.transformations.util.JavaExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Uml2DslTransformation
extends AbstractDatamodelTransformation<org.eclipse.uml2.uml.Model, Model> {
    private EmfCreateFunction<Package, org.edna.datamodel.datamodel.Package> createPackage = new EmfCreateFunction<Package, org.edna.datamodel.datamodel.Package>(DatamodelPackage.eINSTANCE.getPackage()){

        @Override
        protected org.edna.datamodel.datamodel.Package configure(Package source, org.edna.datamodel.datamodel.Package newInstance) {
            newInstance.setName(NamingUtil.normalize(source.getName()));
            return null;
        }
    };
    private EmfCreateFunction<Class, ComplexType> createComplexType = new EmfCreateFunction<Class, ComplexType>(DatamodelPackage.eINSTANCE.getComplexType()){
        private Map<String, ComplexType> types;
        {
            this.types = null;
        }

        @Override
        public ComplexType find(Class source) {
            if (this.types == null) {
                this.types = Maps.newTreeMap(Comparators.stringComparator);
                for (IResourceDescription desc : Uml2DslTransformation.this.index.getAllResourceDescriptions()) {
                    for (IEObjectDescription objDesc : desc.getExportedObjects(DatamodelPackage.eINSTANCE.getComplexType())) {
                        ComplexType t = (ComplexType)objDesc.getEObjectOrProxy();
                        this.types.put(t.getName(), t);
                    }
                }
            }
            if (source.eIsProxy()) {
                throw new IllegalStateException("Proxy not resolved: " + source);
            }
            return this.types.get(source.getName());
        }

        @Override
        public ComplexType configure(Class source, ComplexType target) {
            target.setName(source.getName());
            if (!source.getSuperClasses().isEmpty()) {
                ComplexType baseType = (ComplexType)this.apply((Class)source.getSuperClasses().get(0));
                target.setBaseType(baseType);
            }
            ArrayList properties = Lists.newArrayList((Iterable)Iterables.concat((Iterable)source.getOwnedAttributes(), Uml2DslTransformation.this.getNavigableAssociationEnds(source)));
            Collections.sort(properties, Comparators.namedElementComparator);
            for (Property p : properties) {
                ElementDeclaration element = (ElementDeclaration)Uml2DslTransformation.this.createElementDeclaration.apply(p);
                target.getElements().add((Object)element);
            }
            target.setDoc(JavaExtensions.getDocumentationText((Element)source));
            Uml2DslTransformation.this.addXmiId((EObject)source, Uml2DslTransformation.this.getXmiId((EObject)source));
            return target;
        }
    };
    private EmfCreateFunction<Property, ElementDeclaration> createElementDeclaration = new EmfCreateFunction<Property, ElementDeclaration>(DatamodelPackage.eINSTANCE.getElementDeclaration()){

        @Override
        public ElementDeclaration configure(Property source, ElementDeclaration target) {
            target.setName(source.getName());
            target.setMultiple(source.upperBound() != 1);
            target.setOptional(source.getLower() == 0);
            if (source.getType() instanceof Class) {
                ComplexType refType = (ComplexType)Uml2DslTransformation.this.createComplexType.apply((Class)source.getType());
                target.setRef(refType);
            } else if (source.getType() instanceof org.eclipse.uml2.uml.PrimitiveType) {
                target.setType(Uml2DslTransformation.this.getPrimitiveType(source.getType().getName()));
            }
            target.setDoc(JavaExtensions.getDocumentationText((Element)source));
            return target;
        }
    };

    @Override
    public Model transform(org.eclipse.uml2.uml.Model sourceModel) {
        this.sourceModel = sourceModel;
        this.targetModel = DatamodelFactory.eINSTANCE.createModel();
        ((Model)this.targetModel).setTargetNamespace(this.nsUri);
        new UMLSwitch<EObject>(){
            private Stack<org.edna.datamodel.datamodel.Package> packageStack = new Stack();

            public EObject caseModel(org.eclipse.uml2.uml.Model object) {
                ArrayList packagedElements = Lists.newArrayList((Iterable)object.getPackagedElements());
                Collections.sort(packagedElements, Comparators.namedElementComparator);
                for (EObject obj : packagedElements) {
                    this.doSwitch(obj);
                }
                return object;
            }

            public EObject caseClass(Class object) {
                org.edna.datamodel.datamodel.Package currentPackage;
                if (Uml2DslTransformation.this.monitor.isCanceled()) {
                    return null;
                }
                Uml2DslTransformation.this.monitor.subTask(object.getName());
                ComplexType type = (ComplexType)Uml2DslTransformation.this.createComplexType.apply(object);
                org.edna.datamodel.datamodel.Package package_ = currentPackage = this.packageStack.isEmpty() ? null : this.packageStack.peek();
                if (currentPackage != null) {
                    currentPackage.getTypes().add((Object)type);
                } else {
                    ((Model)Uml2DslTransformation.this.targetModel).getTypes().add((Object)type);
                }
                Uml2DslTransformation.this.monitor.worked(1);
                return object;
            }

            public EObject casePackage(Package object) {
                org.edna.datamodel.datamodel.Package currentPackage;
                org.edna.datamodel.datamodel.Package target = (org.edna.datamodel.datamodel.Package)Uml2DslTransformation.this.createPackage.apply(object);
                org.edna.datamodel.datamodel.Package package_ = currentPackage = this.packageStack.isEmpty() ? null : this.packageStack.peek();
                if (currentPackage != null) {
                    currentPackage.getPackages().add((Object)target);
                } else {
                    ((Model)Uml2DslTransformation.this.targetModel).getPackages().add((Object)target);
                }
                this.packageStack.push(target);
                ArrayList packagedElements = Lists.newArrayList((Iterable)object.getPackagedElements());
                Collections.sort(packagedElements, Comparators.namedElementComparator);
                for (EObject obj : packagedElements) {
                    if (Uml2DslTransformation.this.monitor.isCanceled()) {
                        return null;
                    }
                    this.doSwitch(obj);
                }
                this.packageStack.pop();
                return object;
            }
        }.doSwitch((EObject)sourceModel);
        if (this.monitor.isCanceled()) {
            return null;
        }
        return (Model)this.targetModel;
    }

    private String getXmiId(EObject obj) {
        if (obj.eResource() instanceof XMLResource) {
            return ((XMLResource)obj.eResource()).getID(obj);
        }
        return null;
    }

    private void addXmiId(EObject ctx, String xmiId) {
        if (xmiId != null) {
            String qualifiedName = this.nameProvider.getQualifiedName(ctx);
            this.targetProperties.put(String.valueOf(qualifiedName) + ".uuid", xmiId);
        }
    }

    private PrimitiveType getPrimitiveType(String name) {
        if ("string".equals(name)) {
            return PrimitiveType.STRING;
        }
        if ("integer".equals(name)) {
            return PrimitiveType.INTEGER;
        }
        if ("float".equals(name)) {
            return PrimitiveType.FLOAT;
        }
        if ("double".equals(name)) {
            return PrimitiveType.DOUBLE;
        }
        if ("boolean".equals(name)) {
            return PrimitiveType.BOOLEAN;
        }
        return null;
    }

    protected Iterable<Property> getNavigableAssociationEnds(final Class cls) {
        ArrayList result = Lists.newArrayList();
        for (Association assoc : cls.getAssociations()) {
            Iterable ends = Iterables.filter((Iterable)assoc.getMemberEnds(), (Predicate)new Predicate<Property>(){

                public boolean apply(Property input) {
                    return input.isNavigable() && input.getType() != cls;
                }
            });
            for (Property p : ends) {
                result.add(p);
            }
        }
        return result;
    }

    @Override
    public Resource writeTargetResource() throws IOException {
        try {
            return super.writeTargetResource();
        }
        catch (WrappedException e) {
            if (e.getCause() instanceof XtextSerializationException) {
                if (e.getCause().getMessage().contains("Could not serialize cross reference")) {
                    throw new RuntimeException("Cross reference serialization problem. This indicates that the project containing a base model (e.g. XSDataCommon.edml) is not referenced. Please check the project references settings.", e.getCause());
                }
                throw e;
            }
            throw e;
        }
    }

    @Override
    protected int getAmountOfWork(org.eclipse.uml2.uml.Model sourceModel) {
        int numberOfClasses = EcoreUtil2.eAllOfType((EObject)sourceModel, Class.class).size();
        return numberOfClasses;
    }
}

