/*
 * Decompiled with CFR 0.152.
 */
package org.edna.datamodel.transformations.m2m;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.utils.SingleGlobalResourceSet;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceSetBasedResourceDescriptions;
import org.edna.datamodel.DatamodelRuntimeModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatamodelTransformation<SOURCE, TARGET>
implements Function<SOURCE, TARGET> {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected SOURCE sourceModel;
    protected TARGET targetModel;
    protected String nsUri;
    protected URI sourceUri;
    protected URI targetUri;
    protected String[] includePaths;
    protected Injector injector;
    @Inject
    private ResourceSet resourceSet;
    private Resource sourceResource;
    private Resource targetResource;
    protected Properties sourceProperties = new Properties();
    protected Properties targetProperties = new Properties();
    protected ProgressMonitor monitor;
    @Inject
    protected IResourceDescriptions index;
    @Inject
    protected IQualifiedNameProvider nameProvider;

    public AbstractDatamodelTransformation() {
        this.injector = Guice.createInjector((Module[])new Module[]{new DatamodelRuntimeModule()});
        this.injector.injectMembers((Object)this);
    }

    public SOURCE getSourceModel() {
        return this.sourceModel;
    }

    public void setSourceModel(SOURCE sourceModel) {
        this.sourceModel = sourceModel;
    }

    public TARGET getTargetModel() {
        return this.targetModel;
    }

    public void setTargetModel(TARGET targetModel) {
        this.targetModel = targetModel;
    }

    public String getNsUri() {
        return this.nsUri;
    }

    public void setNsUri(String nsUri) {
        this.nsUri = nsUri;
    }

    public URI getSourceUri() {
        return this.sourceUri;
    }

    public void setSourceUri(String sourceUri) {
        this.sourceUri = URI.createURI((String)sourceUri);
    }

    public URI getTargetUri() {
        return this.targetUri;
    }

    public void setTargetUri(String targetUri) {
        this.targetUri = URI.createURI((String)targetUri);
    }

    public Resource getSourceResource() {
        return this.sourceResource;
    }

    public void setSourceResource(Resource sourceResource) {
        this.sourceResource = sourceResource;
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = SingleGlobalResourceSet.get();
            this.resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.RESOURCE_SET_ONLY", Boolean.TRUE);
        }
        return this.resourceSet;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public void setTargetResource(Resource targetResource) {
        this.targetResource = targetResource;
    }

    protected Resource getTargetResource() {
        if (this.targetResource == null) {
            this.targetResource = this.getResourceSet().createResource(this.targetUri);
        }
        return this.targetResource;
    }

    public void setIncludePaths(String paths) {
        this.includePaths = paths.split(",");
        int i = 0;
        while (i < this.includePaths.length) {
            this.includePaths[i] = this.includePaths[i].trim();
            ++i;
        }
    }

    public TARGET apply(SOURCE sourceModel) {
        this.monitor.beginTask("Transforming " + this.sourceUri.lastSegment() + " to " + this.targetUri.lastSegment(), this.getAmountOfWork(sourceModel));
        ResourceSetBasedResourceDescriptions descs = (ResourceSetBasedResourceDescriptions)this.index;
        descs.setContext((Notifier)sourceModel);
        TARGET target = this.transform(sourceModel);
        return target;
    }

    public abstract TARGET transform(SOURCE var1);

    public Resource loadSourceModel() {
        if (this.sourceResource == null) {
            this.LOG.info((Object)("Loading source file " + this.sourceUri.lastSegment()));
            this.sourceResource = this.getResourceSet().getResource(this.sourceUri, true);
        }
        return this.sourceResource;
    }

    public Resource writeTargetResource() throws IOException {
        this.LOG.info((Object)("Writing target file " + this.targetUri.lastSegment()));
        Resource target = this.getTargetResource();
        if (!target.getContents().contains(this.getTargetModel())) {
            target.getContents().add((Object)((EObject)this.getTargetModel()));
        }
        try {
            this.getTargetResource().save((Map)Maps.newHashMap());
            this.targetProperties.isEmpty();
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        return this.getTargetResource();
    }

    public void setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }

    protected abstract int getAmountOfWork(SOURCE var1);
}

