/*
 * Decompiled with CFR 0.152.
 */
package org.edna.datamodel.transformations.ui.actions;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitorAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.containers.IAllContainersState;
import org.edna.datamodel.transformations.ui.Activator;
import org.edna.datamodel.transformations.ui.util.WorkflowRunnerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransformAction
extends ActionDelegate
implements IObjectActionDelegate {
    protected ISelection selection;
    protected IAction action;
    protected IWorkbenchPart targetPart;
    @Inject
    protected IResourceDescriptions index;
    @Inject
    protected XtextResourceSet resourceSet;
    @Inject
    protected IAllContainersState containerState;

    public void run(IAction action) {
        final IFile file = this.getFile();
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        final URI targetFile = this.getTargetFileUri(fileURI);
        Job j = new Job("EDNA Transformation"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    WorkflowRunnerAdapter wfRunner = new WorkflowRunnerAdapter();
                    HashMap<String, String> args = new HashMap<String, String>();
                    TransformAction.this.configureArguments(args);
                    IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int n = iProjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject p = iProjectArray[n2];
                        if (p.isOpen()) {
                            EcorePlugin.getPlatformResourceMap().put(p.getName(), URI.createFileURI((String)p.getLocation().toString()));
                        }
                        ++n2;
                    }
                    boolean executionResult = wfRunner.run(TransformAction.this.getWorkflowFile(), (ProgressMonitor)new ProgressMonitorAdapter(monitor), args, null);
                    if (executionResult) {
                        String message = "Transformed " + file.getName() + " to " + targetFile.lastSegment() + ".";
                        Activator.getDefault().getLog().log((IStatus)new Status(0, "org.edna.datamodel.transformations.ui", message));
                        file.getParent().refreshLocal(1, null);
                        return Status.OK_STATUS;
                    }
                    String message = "Transformation of " + file.getName() + " failed.";
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.edna.datamodel.transformations.ui", message));
                    return Status.CANCEL_STATUS;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Status.CANCEL_STATUS;
                }
            }
        };
        j.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (event.getResult() == Status.OK_STATUS) {
                            String message = "Transformed " + file.getName() + " to " + targetFile.lastSegment() + ".";
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"EDNA Datamodel Transformation", (String)message);
                        } else {
                            String message = "Transformation of " + file.getName() + " failed.";
                            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"EDNA Datamodel Transformation", (String)(String.valueOf(message) + "Please check the Error Log view (Window -> Show view -> Other... -> Error Log)."));
                        }
                    }
                });
            }
        });
        j.schedule();
    }

    protected abstract String getWorkflowFile();

    protected abstract URI getTargetFileUri(URI var1);

    protected void configureArguments(HashMap<String, String> args) {
        IFile file = this.getFile();
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        URI targetFile = this.getTargetFileUri(fileURI);
        args.put("modelSlot", "model");
        args.put("standalone", "false");
        args.put("nsUri", "http://www.edna-site.org");
        args.put("modelFile", fileURI.toString());
        args.put("targetFile", targetFile.toString());
        String includePathsValue = this.getDslIncludePaths();
        args.put("includePaths", includePathsValue);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.action = action;
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public IFile getFile() {
        return (IFile)((IStructuredSelection)this.selection).getFirstElement();
    }

    protected String getDslIncludePaths() {
        String projectPath = this.getFile().getProject().getFullPath().toString();
        HashSet includePaths = Sets.newHashSet();
        for (String handle : this.containerState.getVisibleContainerHandles(projectPath)) {
            for (URI containerUri : this.containerState.getContainedURIs(handle)) {
                IResource containerResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(containerUri.toPlatformString(true)));
                includePaths.add(containerResource.getParent().getLocation());
            }
        }
        String includePathsValue = ((Object)includePaths).toString();
        includePathsValue = includePathsValue.substring(1, includePathsValue.length() - 1);
        return includePathsValue;
    }
}

