/*
 * Decompiled with CFR 0.152.
 */
package org.edna.datamodel.transformations.ui.actions;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.core.WorkflowFacade;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.containers.IAllContainersState;
import org.edna.datamodel.datamodel.DatamodelPackage;
import org.edna.datamodel.datamodel.Model;
import org.edna.datamodel.transformations.ui.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSLGenerateDatabindingsAction
extends ActionDelegate
implements IObjectActionDelegate {
    protected ISelection selection;
    protected IAction action;
    protected IWorkbenchPart targetPart;
    @Inject
    protected IResourceDescriptions index;
    @Inject
    protected Provider<ResourceSet> resourceSetProvider;
    @Inject
    protected IAllContainersState containerState;

    public void run(IAction action) {
        final IFile file = this.getFile();
        final URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        final URI targetFile = this.getTargetFileUri(fileURI);
        Job j = new Job("EDNA Generate Data Bindings"){

            protected IStatus run(IProgressMonitor monitor) {
                ResourceSet resourceSet = (ResourceSet)DSLGenerateDatabindingsAction.this.resourceSetProvider.get();
                try {
                    boolean executionResult;
                    HashMap<String, String> args = new HashMap<String, String>();
                    DSLGenerateDatabindingsAction.this.configureArguments(args);
                    WorkflowFacade wfFacade = new WorkflowFacade(DSLGenerateDatabindingsAction.this.getWorkflowFile(), args);
                    IResourceDescription resDesc = DSLGenerateDatabindingsAction.this.index.getResourceDescription(fileURI);
                    if (resDesc == null) {
                        String message = "Resource " + fileURI.lastSegment() + " not found in Xtext index. Is the Xtext nature set and was the project built?";
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.edna.datamodel.transformations.ui", message));
                        return Status.CANCEL_STATUS;
                    }
                    HashMap<String, Model> slotContents = new HashMap<String, Model>();
                    Model model = (Model)((IEObjectDescription)resDesc.getExportedObjects(DatamodelPackage.Literals.MODEL).iterator().next()).getEObjectOrProxy();
                    for (IResourceDescription rd : DSLGenerateDatabindingsAction.this.index.getAllResourceDescriptions()) {
                        resourceSet.createResource(rd.getURI());
                    }
                    model = (Model)EcoreUtil.resolve((EObject)model, (ResourceSet)resourceSet);
                    slotContents.put("sourceModel", model);
                    Issues issues = wfFacade.run(slotContents);
                    boolean bl = executionResult = !issues.hasErrors();
                    if (executionResult) {
                        String message = "Generated Data Bindings for " + file.getName() + " to " + targetFile.lastSegment() + ".";
                        Activator.getDefault().getLog().log((IStatus)new Status(0, "org.edna.datamodel.transformations.ui", message));
                        file.getParent().getParent().refreshLocal(2, null);
                        return Status.OK_STATUS;
                    }
                    String message = "Transformation of " + file.getName() + " failed.";
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.edna.datamodel.transformations.ui", message));
                    return Status.CANCEL_STATUS;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Status.CANCEL_STATUS;
                }
            }
        };
        j.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (event.getResult() == Status.OK_STATUS) {
                            String message = "Generated Data Bindings for " + file.getName() + " to " + targetFile.lastSegment() + ".";
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"EDNA Datamodel Transformation", (String)message);
                        } else {
                            String message = "Transformation of " + file.getName() + " failed.";
                            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"EDNA Data Bindings", (String)(String.valueOf(message) + "Please check the Error Log view (Window -> Show view -> Other... -> Error Log)."));
                        }
                    }
                });
            }
        });
        j.schedule();
    }

    protected URI getTargetFileUri(URI sourceFile) {
        return URI.createURI((String)sourceFile.toString().replaceFirst("\\.edml", ".py"));
    }

    protected void configureArguments(HashMap<String, String> args) {
        IFile file = this.getFile();
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        URI targetFile = this.getTargetFileUri(fileURI);
        args.put("standalone", "false");
        args.put("model", fileURI.toString());
        args.put("targetFile", targetFile.lastSegment());
        args.put("targetDir", this.getTargetDir(file).getAbsolutePath());
        args.put("includePaths", this.getDslIncludePaths());
    }

    private File getTargetDir(IFile sourceFile) {
        File srcDir = new File(new File(sourceFile.getLocation().toFile().getParent()).getParent(), "src");
        File pluginsDir = new File(new File(sourceFile.getLocation().toFile().getParent()).getParent(), "plugins");
        if (srcDir.exists()) {
            return srcDir;
        }
        if (pluginsDir.exists()) {
            return pluginsDir;
        }
        return new File(sourceFile.getLocation().toFile().getParent());
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.action = action;
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public IFile getFile() {
        return (IFile)((IStructuredSelection)this.selection).getFirstElement();
    }

    protected String getDslIncludePaths() {
        String projectPath = this.getFile().getProject().getFullPath().toString();
        HashSet includePaths = Sets.newHashSet();
        for (String handle : this.containerState.getVisibleContainerHandles(projectPath)) {
            for (URI containerUri : this.containerState.getContainedURIs(handle)) {
                IResource containerResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(containerUri.toPlatformString(true)));
                includePaths.add(containerResource.getParent().getLocation());
            }
        }
        String includePathsValue = ((Object)includePaths).toString();
        includePathsValue = includePathsValue.substring(1, includePathsValue.length() - 1);
        return includePathsValue;
    }

    protected String getWorkflowFile() {
        return "org/edna/datamodel/transformations/ui/actions/EDGenerateDS_dsl_plugin.mwe";
    }
}

