/*
 * Decompiled with CFR 0.152.
 */
package org.edna.datamodel.generateds;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.edna.datamodel.datamodel.ComplexType;
import org.edna.datamodel.datamodel.ElementDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaExtensions {
    public static String getTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("EEE MMM d hh:mm::ss yyyy", Locale.ENGLISH);
        return df.format(new Date());
    }

    public static String getResourceName(EObject obj) {
        if (obj.eResource() == null) {
            return null;
        }
        String resource = obj.eResource().getURI().lastSegment();
        return resource.substring(0, resource.lastIndexOf(46));
    }

    public static List<ComplexType> sortComplexTypes(List<ComplexType> types) {
        ArrayList<ComplexType> result = new ArrayList<ComplexType>(types);
        Collections.sort(result, new Comparator<ComplexType>(){

            @Override
            public int compare(ComplexType t1, ComplexType t2) {
                if (t1 == t2) {
                    return 0;
                }
                if (t1.getBaseType() != null && t2.getBaseType() == null) {
                    return 1;
                }
                if (t1.getBaseType() == null && t2.getBaseType() != null) {
                    return -1;
                }
                int hierarchy = JavaExtensions.getHierarchyLevel(t1).compareTo(JavaExtensions.getHierarchyLevel(t2));
                if (hierarchy != 0) {
                    return hierarchy;
                }
                if (JavaExtensions.hasReferenceTo(t1, t2)) {
                    return 1;
                }
                if (JavaExtensions.hasReferenceTo(t2, t1)) {
                    return -1;
                }
                if (JavaExtensions.getResourceName((EObject)t1) != null && !JavaExtensions.getResourceName((EObject)t1).equals(JavaExtensions.getResourceName((EObject)t2))) {
                    return JavaExtensions.getResourceName((EObject)t1).compareTo(JavaExtensions.getResourceName((EObject)t2));
                }
                return t1.getName().compareTo(t2.getName());
            }
        });
        return result;
    }

    private static boolean hasReferenceTo(ComplexType source, ComplexType target) {
        ComplexType currentBaseType = source.getBaseType();
        while (currentBaseType != null && !currentBaseType.eIsProxy()) {
            if (currentBaseType == target) {
                return true;
            }
            currentBaseType = currentBaseType.getBaseType();
        }
        for (ElementDeclaration element : source.getElements()) {
            if (element.getRef() == null || element.getRef() != target) continue;
            return true;
        }
        return false;
    }

    private static Integer getHierarchyLevel(ComplexType t) {
        int level = 0;
        ComplexType baseType = t.getBaseType();
        while (baseType != null && !baseType.eIsProxy()) {
            ++level;
            baseType = baseType.getBaseType();
        }
        return level;
    }

    public static void resolveAllInResource(EObject ctx) {
        EcoreUtil.resolveAll((ResourceSet)ctx.eResource().getResourceSet());
    }
}

