! FDMNES subroutines
! Paquet contenant divers tableaux

!***********************************************************************

! Selection de l'energie de seuil et du travail de sortie de l'element

      subroutine esdata(nbseuil,numat,workf,mpirank)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      parameter(nassm=103, nm1=18, nm4=30, nn1=36, nn4=48, nn6=58,
     &          no1=54, no4=80, np1=86, np2=87)

      logical old_reference

      real(kind=db), dimension(nassm):: ek1, el1, el2, el3, 
     &                                  workfct, workref
      real(kind=db), dimension(nm1:nassm):: em1, em2, em3
      real(kind=db), dimension(nm4:nassm):: em4, em5
      real(kind=db), dimension(nn1:nassm):: en1, en2, en3
      real(kind=db), dimension(nn4:nassm):: en4, en5
      real(kind=db), dimension(nn6:nassm):: en6, en7
      real(kind=db), dimension(no1:nassm):: eo1, eo2, eo3
      real(kind=db), dimension(no4:nassm):: eo4, eo5
      real(kind=db), dimension(np1:nassm):: ep1
      real(kind=db), dimension(np2:nassm):: ep2, ep3

      common/eseuil/ eseuil(2)
      common/icheck/ icheck(24)
      common/lseuil/ jseuil, lseuil, nseuil
      common/old_reference/ old_reference

! Handbook of chemistry and physics, E-82
! Pour les gaz rares et H, F, N, O, Cl, les seuils sont par rapport au
! niveau du vide. On prend donc le travail de sortie a zero.

      data workfct/ 0.00,   0.00,    2.28,     3.92,    4.50,    ! 5
     &              4.81,   0.00,    0.00,     0.00,    0.00,    ! 10
     &              2.28,   3.68,    4.08,     4.37,    4.00,    ! 15
     &              4.00,   0.00,    0.00,     2.24,    2.706,   ! 20
     &              4.00,   3.95,    3.77,     4.37,    3.76,    ! 25
     &              4.70,   3.90,    5.01,     4.00,    3.08,    ! 30
     &              4.00,   4.29,    4.72,     4.62,    4.00,    ! 35
     &              0.00,   2.09,    2.74,     4.00,    3.73,    ! 40
     &              2.29,   4.15,    4.00,     4.00,    4.57,    ! 45
     &              4.97,   4.73,    4.07,     4.00,    4.38,    ! 50
     &              4.01,   4.04,    4.00,     0.00,    4.70,    ! 55
     &              2.48,   4.00,    2.84,     4.00,    4.00,    ! 60
     &              4.00,   4.00,    4.00,     4.00,    4.00,    ! 65
     &              4.00,   4.00,    4.00,     4.00,    4.00,    ! 70
     &              4.00,   4.00,    4.05,     4.49,    5.00,    ! 75
     &              4.00,   4.00,    4.09,     4.82,    4.53,    ! 80
     &              3.68,   3.97,    4.25,     4.00,    4.00,    ! 85
     &              0.00,   4.00,    4.00,     4.00,    3.38,    ! 90
     &              0.00,   3.63,    4.00,     4.00,    4.00,    ! 95
     & 0.00, 4.00, 4.00, 4.00, 4.00, 4.00,     4.00,    4.00/    ! 103

! Valeurs references calculees par le programme sur les elements simples
! donnant le niveau de Fermi servant d'origine pour l'energie.
! Pour les gaz rares et H, F, N, O, Cl, les seuils sont par rapport au
! niveau du vide. On prend donc l'origine a zero.

      data workref/ 0.00,   0.00,    8.78,    15.92,   17.50,    ! 5
     &              8.81,   0.00,    0.00,     0.00,    0.00,    ! 10
     &              5.48,   7.68,    4.08,     4.37,    7.30,    ! 15
     &              7.00,   0.00,    0.00,     3.54,    5.306,   ! 20
     &              7.00,  10.35,   11.57,    12.17,   11.26,    ! 25
     &             11.80,  12.35,   12.81,    10.00,   15.08,    ! 30
     &              8.30,   8.09,    8.22,     5.82,    5.20,    ! 35
     &              0.00,   5.09,    5.74,     5.80,    7.03,    ! 40
     &             10.49,  10.95,   11.00,    11.20,   11.17,    ! 45
     &             11.07,  11.63,   10.07,     1.70,    6.78,    ! 50
     &              4.31,   4.44,    5.20,     0.00,    4.70,    ! 55
     &              2.48,   4.00,    2.84,     4.00,    4.00,    ! 60
     &              4.00,   4.00,    4.00,     4.00,    4.00,    ! 65
     &              4.00,   4.00,    4.00,     4.00,    4.00,    ! 70
     &              4.00,   4.00,    4.05,     4.49,    5.00,    ! 75
     &              4.00,   4.00,    4.09,     4.82,    4.53,    ! 80
     &              3.68,   3.97,    4.25,     4.00,    4.00,    ! 85
     &              0.00,   4.00,    4.00,     4.00,    3.38,    ! 90
     &              0.00,   3.63,    4.00,     4.00,    4.00,    ! 95
     & 0.00, 4.00, 4.00, 4.00, 4.00, 4.00,     4.00,    4.00/   ! 100

! Compile par Gwyn Williams,
! http://xray.uu.se/hypertext/EBindEnergies.html

      data ek1/     13.6,    24.6,    54.7,   111.5,   188.0,    !  5
     &             284.2,   409.9,   543.1,   696.7,   870.2,    ! 10
     &            1070.8,  1303.0,  1559.0,  1839.0,  2145.5,    ! 15
     &            2472.0,  2822.4,  3205.9,  3608.4,  4038.5,    ! 20
     &            4492.0,  4966.0,  5465.0,  5989.0,  6539.0,    ! 25
     &            7112.0,  7709.0,  8333.0,  8979.0,  9659.0,    ! 30
     &           10367.0, 11103.0, 11867.0, 12658.0, 13474.0,    ! 35
     &           14326.0, 15200.0, 16105.0, 17038.0, 17998.0,    ! 40
     &           18986.0, 20000.0, 21044.0, 22117.0, 23220.0,    ! 45
     &           24350.0, 25514.0, 26711.0, 27940.0, 29200.0,    ! 50
     &           30491.0, 31814.0, 33169.0, 34561.0, 35985.0,    ! 55
     &           37441.0, 38925.0, 40443.0, 41991.0, 43569.0,    ! 60
     &           45184.0, 46834.0, 48519.0, 50239.0, 51996.0,    ! 65
     &           53789.0, 55618.0, 57486.0, 59390.0, 61332.0,    ! 70
     &           63314.0, 65351.0, 67416.0, 69525.0, 71676.0,    ! 75
     &           73871.0, 76111.0, 78395.0, 80725.0, 83102.0,    ! 80
     &           85530.0, 88005.0, 90526.0, 93105.0, 95730.0,    ! 85
     &           98404.0,101137.0,103922.0,106755.0,109651.0,    ! 90
     &          112601.0,115606.0,119000.0,     0.0,     0.0,    ! 95
     &               0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0/    ! 103

      data el1/      0.0,     0.0,     0.0,     0.0,     0.0,
     &               0.0,    37.3,    41.6,     0.0,    48.5,    ! 10
     &              63.5,    88.6,   117.8,   149.7,   189.0,    ! 15
     &             230.9,   270.0,   326.3,   378.6,   438.4,    ! 20
     &             498.0,   560.9,   626.7,   696.0,   769.1,    ! 25
     &             844.6,   925.1,  1008.6,  1096.7,  1196.2,    ! 30
     &            1299.0,  1414.6,  1527.0,  1652.0,  1782.0,
     &            1921.0,  2065.0,  2216.0,  2373.0,  2532.0,
     &            2698.0,  2866.0,  3043.0,  3224.0,  3412.0,
     &            3604.0,  3806.0,  4018.0,  4238.0,  4465.0,
     &            4698.0,  4939.0,  5188.0,  5453.0,  5714.0,
     &            5989.0,  6266.0,  6548.0,  6835.0,  7126.0,
     &            7428.0,  7737.0,  8052.0,  8376.0,  8708.0,
     &            9046.0,  9394.0,  9751.0, 10116.0, 10486.0,
     &           10870.0, 11271.0, 11682.0, 12100.0, 12527.0,
     &           12968.0, 13419.0, 13880.0, 14353.0, 14839.0,
     &           15347.0, 15861.0, 16388.0, 16939.0, 17493.0,
     &           18049.0, 18639.0, 19237.0, 19840.0, 20472.0,    ! 90
     &           21105.0, 21757.0, 22400.0, 23104.0,     0.0,    ! 95
     &               0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0/    ! 103

      data el2/      0.0,     0.0,     0.0,     0.0,     0.0,    ! 5
     &               0.0,     0.0,     0.0,     0.0,    21.7,    ! 10
     &              30.4,    49.6,    72.9,    99.8,   136.0,    ! 15
     &             163.6,   202.0,   250.6,   297.3,   349.7,    ! 20
     &             403.6,   460.2,   519.8,   583.8,   649.9,    ! 25
     &             719.9,   793.2,   870.0,   952.3,  1044.9,    ! 30
     &            1143.2,  1248.1,  1359.1,  1474.3,  1596.0,    ! 35
     &            1730.9,  1864.0,  2007.0,  2156.0,  2307.0,    ! 40
     &            2465.0,  2625.0,  2793.0,  2967.0,  3146.0,    ! 45
     &            3330.0,  3524.0,  3727.0,  3938.0,  4156.0,    ! 50
     &            4380.0,  4612.0,  4852.0,  5107.0,  5359.0,    ! 55
     &            5624.0,  5891.0,  6164.0,  6440.0,  6722.0,    ! 60
     &            7013.0,  7312.0,  7617.0,  7930.0,  8252.0,    ! 65
     &            8581.0,  8918.0,  9264.0,  9617.0,  9978.0,    ! 70
     &           10349.0, 10739.0, 11136.0, 11544.0, 11959.0,    ! 75
     &           12385.0, 12824.0, 13273.0, 13734.0, 14209.0,    ! 80
     &           14698.0, 15200.0, 15711.0, 16244.0, 16785.0,    ! 85
     &           17337.0, 17907.0, 18484.0, 19083.0, 19693.0,    ! 90
     &           20314.0, 20948.0, 21580.0, 22270.0,     0.0,    ! 95
     &               0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0/    ! 103

      data el3/      0.0,     0.0,     0.0,     0.0,     0.0,
     &               0.0,     0.0,     0.0,     0.0,    21.6,
     &              30.5,    49.2,    72.5,    99.2,   135.0,
     &             162.5,   200.0,   248.4,   294.6,   346.2,
     &             398.7,   453.8,   512.1,   574.1,   638.7,
     &             706.8,   778.1,   852.7,   932.7,  1021.8,
     &            1116.4,  1217.0,  1323.6,  1433.9,  1550.0,
     &            1678.4,  1804.0,  1940.0,  2080.0,  2223.0,
     &            2371.0,  2520.0,  2677.0,  2838.0,  3004.0,
     &            3173.0,  3351.0,  3538.0,  3730.0,  3929.0,
     &            4132.0,  4341.0,  4557.0,  4786.0,  5012.0,
     &            5247.0,  5483.0,  5723.0,  5964.0,  6208.0,
     &            6459.0,  6716.0,  6977.0,  7243.0,  7510.0,
     &            7790.0,  8071.0,  8358.0,  8648.0,  8944.0,
     &            9244.0,  9561.0,  9881.0, 10207.0, 10535.0,
     &           10871.0, 11215.0, 11564.0, 11919.0, 12284.0,
     &           12658.0, 13035.0, 13419.0, 13814.0, 14214.0,
     &           14619.0, 15031.0, 15444.0, 15871.0, 16300.0,    ! 90
     &           16733.0, 17166.0, 17610.0, 18057.0, 18510.0,    ! 95
     &           18970.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0/    ! 103

      data em1/                       29.3,    34.8,    44.3,    ! 18-20
     &              51.1,    58.7,    66.3,    74.1,    82.3,    ! 25
     &              91.3,   101.0,   110.8,   122.5,   139.8,    ! 30
     &             159.5,   180.1,   204.7,   229.6,   257.0,    ! 35
     &             292.8,   326.7,   358.7,   392.0,   430.3,    ! 40
     &             466.6,   506.3,   544.0,   586.1,   628.1,    ! 45
     &             671.6,   719.0,   772.0,   827.2,   884.7,    ! 50
     &             940.0,  1006.0,  1072.0,  1148.7,  1211.0,    ! 55
     &            1293.0,  1362.0,  1436.0,  1511.0,  1575.0,    ! 60
     &               0.0,  1723.0,  1800.0,  1881.0,  1968.0,    ! 65
     &            2047.0,  2128.0,  2206.0,  2307.0,  2398.0,    ! 70
     &            2491.0,  2601.0,  2708.0,  2820.0,  2932.0,    ! 75
     &            3049.0,  3174.0,  3296.0,  3425.0,  3562.0,    ! 80
     &            3704.0,  3851.0,  3999.0,  4149.0,  4317.0,    ! 85
     &            4482.0,  4652.0,  4822.0,  5002.0,  5182.0,    ! 90
     &            5367.0,  5548.0,  5738.0,     0.0,     0.0,    ! 95
     &               0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0/    ! 103

      data em2/                       15.9,    18.3,    25.4,    ! 18-20
     &              28.3,    32.6,    37.2,    42.2,    47.2,    ! 25
     &              52.7,    58.9,    68.0,    77.3,    91.4,    ! 30
     &             103.5,   124.9,   146.2,   166.5,   189.0,    ! 35
     &             222.2,   248.7,   280.3,   310.6,   343.5,    ! 40
     &             376.1,   411.6,   447.6,   483.3,   521.3,    ! 45
     &             559.9,   603.8,   652.6,   703.2,   756.5,    ! 50
     &             812.7,   870.8,   931.0,  1002.1,  1071.0,    ! 55
     &            1137.0,  1209.0,  1274.0,  1337.0,  1403.0,    ! 60
     &            1471.4,  1541.0,  1614.0,  1688.0,  1768.0,    ! 65
     &            1842.0,  1923.0,  2006.0,  2090.0,  2173.0,    ! 70
     &            2264.0,  2365.0,  2469.0,  2575.0,  2682.0,    ! 75
     &            2792.0,  2909.0,  3027.0,  3148.0,  3279.0,    ! 80
     &            3416.0,  3554.0,  3696.0,  3854.0,  4008.0,    ! 85
     &            4159.0,  4327.0,  4490.0,  4656.0,  4830.0,    ! 90
     &            5001.0,  5182.0,  5372.0,     0.0,     0.0,    ! 95
     &               0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0/    ! 103

      data em3/                       15.7,    18.3,    25.4,    ! 18-20
     &              28.3,    32.6,    37.2,    42.2,    47.2,    ! 25
     &              52.7,    59.9,    66.2,    75.1,    88.6,    ! 30
     &             100.0,   120.8,   141.2,   160.7,   182.0,    ! 35
     &             214.4,   239.1,   270.0,   298.8,   329.8,    ! 40
     &             360.6,   394.0,   417.7,   461.5,   496.5,    ! 45
     &             532.3,   573.0,   618.4,   665.3,   714.6,    ! 50
     &             766.4,   820.8,   875.0,   940.6,  1003.0,    ! 55
     &            1063.0,  1128.0,  1187.0,  1242.0,  1297.0,    ! 60
     &            1357.0,  1419.8,  1481.0,  1544.0,  1611.0,    ! 65
     &            1676.0,  1741.0,  1812.0,  1885.0,  1950.0,    ! 70
     &            2024.0,  2107.0,  2194.0,  2281.0,  2367.0,    ! 75
     &            2457.0,  2551.0,  2645.0,  2743.0,  2847.0,    ! 80
     &            2957.0,  3066.0,  3177.0,  3302.0,  3426.0,    ! 85
     &            3538.0,  3663.0,  3792.0,  3909.0,  4046.0,    ! 90           
     &            4174.0,  4303.0,  4430.0,     0.0,     0.0,    ! 95
     &               0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0/    ! 103

      data em4/                                         10.2,    ! 30
     &              18.7,    29.8,    41.7,    55.5,    70.0,    ! 35
     &              95.0,   113.0,   136.0,   157.7,   181.1,    ! 40
     &             205.0,   231.1,   257.6,   284.2,   311.9,    ! 45
     &             340.5,   374.0,   411.9,   451.4,   493.2,    ! 50
     &             537.5,   583.4,   630.8,   689.0,   740.5,    ! 55
     &             795.7,   853.0,   902.4,   948.3,  1003.3,    ! 60
     &            1052.0,  1110.9,  1158.6,  1221.9,  1276.9,    ! 65
     &            1333.0,  1392.0,  1453.0,  1515.0,  1576.0,    ! 70
     &            1639.0,  1716.0,  1793.0,  1949.0,  1949.0,    ! 75
     &            2031.0,  2116.0,  2202.0,  2291.0,  2385.0,    ! 80
     &            2485.0,  2586.0,  2688.0,  2798.0,  2909.0,    ! 85
     &            3022.0,  3136.0,  3248.0,  3370.0,  3491.0,    ! 90
     &            3611.0,  3728.0,  3846.0,     0.0,     0.0,    ! 95
     &               0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0/    ! 103
   
      data em5/                                         10.1,    ! 30
     &              18.7,    29.2,    41.7,    54.6,    69.0,    ! 35
     &              93.8,   112.0,   134.2,   155.8,   178.8,    ! 40
     &             202.3,   227.9,   253.9,   280.0,   307.2,    ! 45
     &             335.2,   368.3,   405.2,   443.9,   484.9,    ! 50
     &             528.2,   573.0,   619.3,   676.4,   726.6,    ! 55
     &             780.5,   836.0,   883.8,   928.8,   980.4,    ! 60
     &            1027.0,  1083.4,  1127.5,  1189.6,  1241.1,    ! 65
     &            1292.0,  1351.0,  1409.0,  1468.0,  1528.0,    ! 70
     &            1589.0,  1662.0,  1735.0,  1809.0,  1883.0,    ! 75
     &            1960.0,  2040.0,  2122.0,  2206.0,  2295.0,    ! 80
     &            2389.0,  2484.0,  2580.0,  2683.0,  2787.0,    ! 85
     &            2892.0,  3000.0,  3105.0,  3219.0,  3332.0,    ! 90
     &            3442.0,  3552.0,  3662.0,     0.0,     0.0,    ! 95
     &               0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0/    ! 103

      data en1/     27.5,    30.5,    38.9,    43.8,    50.6,    ! 36-40
     &              56.4,    63.2,    69.5,    75.0,    81.4,    ! 45
     &              87.1,    97.0,   109.8,   122.9,   137.1,    ! 50
     &             153.2,   169.4,   186.0,   213.2,   232.3,    ! 55
     &             253.5,   274.7,   291.0,   304.5,   319.2,    ! 60
     &               0.0,   347.2,   360.0,   378.6,   396.0,    ! 65
     &             414.2,   432.4,   449.8,   470.9,   480.5,    ! 70
     &             506.8,   538.0,   563.4,   594.1,   625.4,    ! 75
     &             658.2,   691.1,   725.4,   762.1,   802.2,    ! 80
     &             846.2,   891.8,   939.0,   995.0,  1042.0,    ! 85
     &            1097.0,  1153.0,  1208.0,  1269.0,  1330.0,    ! 90
     &            1387.0,  1439.0,     0.0,     0.0,     0.0,    ! 95
     &               0.0,     0.0,     0.0,     0.0,     0.0,    ! 100
     &               0.0,     0.0,     0.0/

      data en2/     14.1,    16.3,    21.6,    24.4,    28.5,    ! 36-40
     &              32.6,    37.6,    42.3,    46.3,    50.5,    ! 45
     &              55.7,    63.7,    63.9,    73.5,    83.6,    ! 50
     &              95.6,   103.3,   123.0,   146.7,   172.4,    ! 55
     &             192.0,   205.8,   223.2,   236.3,   243.3,    ! 60
     &             242.0,   265.6,   284.0,   286.0,   322.4,    ! 65
     &             333.5,   343.5,   366.2,   385.9,   388.7,    ! 70
     &             412.4,   438.2,   463.4,   490.4,   518.7,    ! 75
     &             549.1,   577.8,   609.1,   642.7,   680.2,    ! 80
     &             720.5,   761.9,   805.2,   851.0,   886.0,    ! 85
     &             929.0,   980.0,  1058.0,  1080.0,  1168.0,    ! 90
     &            1224.0,  1271.0,     0.0,     0.0,     0.0,    ! 95
     &               0.0,     0.0,     0.0,     0.0,     0.0,    ! 100
     &               0.0,     0.0,     0.0/

      data en3/     14.1,    15.3,    20.1,    23.1,    27.1,    ! 36-40
     &              30.8,    35.5,    39.9,    43.2,    47.3,    ! 45
     &              50.9,    58.3,    63.9,    73.5,    83.6,    ! 50
     &              95.6,   103.3,   123.0,   145.5,   161.3,    ! 55
     &             178.6,   196.0,   206.5,   217.6,   224.6,    ! 60
     &             242.0,   247.4,   257.0,   271.0,   284.1,    ! 65
     &             293.2,   308.2,   320.2,   332.6,   339.7,    ! 70   
     &             359.2,   380.7,   400.9,   423.6,   446.8,    ! 75
     &             470.7,   495.8,   519.4,   546.3,   576.6,    ! 80
     &             609.5,   643.5,   678.8,   705.0,   740.0,    ! 85
     &             768.0,   810.0,   879.0,   890.0,   966.4,    ! 90
     &            1007.0,  1043.0,     0.0,     0.0,     0.0,    ! 95
     &               0.0,     0.0,     0.0,     0.0,     0.0,    ! 100
     &               0.0,     0.0,     0.0/

      data en4/                       11.7,    17.7,    24.9,    ! 48-50
     &              33.3,    41.9,    50.6,    69.5,    79.8,    ! 55
     &              92.6,   105.3,   109.0,   115.1,   120.5,    ! 60
     &             120.0,   129.0,   133.0,     0.0,   150.5,    ! 65
     &             153.6,   160.0,   167.6,   175.5,   191.2,    ! 70
     &             206.1,   220.0,   237.9,   255.9,   273.9,    ! 75
     &             293.1,   311.9,   331.6,   353.2,   378.2,    ! 80
     &             405.7,   434.3,   464.0,   500.0,   533.0,    ! 85
     &             567.0,   603.0,   636.0,   675.0,   712.1,    ! 90
     &             743.0,   778.3,     0.0,     0.0,     0.0,    ! 95
     &               0.0,     0.0,     0.0,     0.0,     0.0,    ! 100
     &               0.0,     0.0,     0.0/

      data en5/                       10.7,    16.9,    23.9,    ! 48-50
     &              32.1,    40.4,    48.9,    67.5,    77.5,    ! 55
     &              89.9,   102.5,     0.0,   115.1,   120.5,    ! 60
     &             120.0,   129.0,   127.7,   142.6,   150.5,    ! 65
     &             153.6,   160.0,   167.6,   175.5,   182.4,    ! 70
     &             196.3,   211.5,   226.4,   243.5,   260.5,    ! 75
     &             278.5,   296.3,   314.6,   335.1,   358.8,    ! 80
     &             385.0,   412.2,   440.1,   473.0,   507.0,    ! 85
     &             541.0,   577.0,   603.0,   639.0,   675.2,    ! 90
     &             708.0,   736.2,     0.0,     0.0,     0.0,    ! 95
     &               0.0,     0.0,     0.0,     0.0,     0.0,    ! 100
     &               0.0,     0.0,     0.0/

      data en6/                        0.1,     2.0,     1.5,    ! 58-60
     &               0.0,     5.2,     0.0,     8.6,     7.7,    ! 65
     &               8.0,     8.6,     0.0,     0.0,     2.5,    ! 70
     &               8.9,    15.9,    23.5,    33.6,    42.9,    ! 75
     &              53.4,    63.8,    74.5,    87.6,   104.0,    ! 80
     &             122.2,   141.7,   162.3,   184.0,   210.0,    ! 85
     &             238.0,   268.0,   299.0,   319.0,   342.4,    ! 90
     &             371.0,   388.2,     0.0,     0.0,     0.0,    ! 95
     &               0.0,     0.0,     0.0,     0.0,     0.0,    ! 100
     &               0.0,     0.0,     0.0/

      data en7/                        0.1,     2.0,     1.5,    ! 58-60
     &               0.0,     5.2,     0.0,     8.6,     2.4,    ! 65
     &               4.3,     5.2,     4.7,     4.6,     1.3,    ! 70
     &               7.5,    14.2,    21.6,    31.4,    40.5,    ! 75
     &              50.7,    60.8,    71.2,    83.9,    99.9,    ! 80
     &             117.8,   136.9,   157.0,   184.0,   210.0,    ! 85
     &             238.0,   268.0,   299.0,   319.0,   333.1,    ! 90
     &             360.0,   377.4,     0.0,     0.0,     0.0,    ! 95
     &               0.0,     0.0,     0.0,     0.0,     0.0,    ! 100
     &               0.0,     0.0,     0.0/

      data eo1/                            23.3,   22.7,         ! 54-55
     &             30.3,   34.3,   37.8,   37.4,   37.5,         ! 60
     &              0.0,   37.4,   32.0,   36.0,   45.6,         ! 65
     &             49.9,   49.3,   50.6,   54.7,   52.0,         ! 70
     &             57.3,   64.2,   69.7,   75.6,   83.0,         ! 75
     &             84.0,   95.2,  101.7,  107.2,  127.0,         ! 80
     &            136.0,  147.0,  159.3,  177.0,  195.0,         ! 85
     &            214.0,  234.0,  254.0,  272.0,  290.0,         ! 90
     &            310.0,  321.0,    0.0,    0.0,    0.0,         ! 95
     &              0.0,    0.0,    0.0,    0.0,    0.0,         ! 100
     &              0.0,    0.0,    0.0/

      data eo2/                            13.4,   14.2,         ! 54-55
     &             17.0,   19.3,   19.8,   22.3,   21.1,         ! 60
     &              0.0,   21.3,   22.0,   20.0,   28.7,         ! 65
     &             26.3,   30.8,   31.4,   31.8,   30.3,         ! 70
     &             33.6,   38.0,   42.2,   45.3,   45.6,         ! 75
     &             58.0,   63.0,   65.3,   74.2,   83.1,         ! 80
     &             94.6,  106.4,  119.0,  132.0,  148.0,         ! 85
     &            164.0,  182.0,  200.0,  215.0,  229.0,         ! 90
     &            232.0,  257.0,    0.0,    0.0,    0.0,         ! 95
     &              0.0,    0.0,    0.0,    0.0,    0.0,         ! 100
     &              0.0,    0.0,    0.0/

      data eo3/                            12.1,   12.1,         ! 54-55
     &             14.8,   16.8,   17.0,   22.3,   21.1,         ! 60
     &              0.0,   21.3,   22.0,   20.0,   22.6,         ! 65
     &             26.3,   24.1,   24.7,   25.0,   24.1,         ! 70
     &             26.7,   29.9,   32.7,   36.8,   34.6,         ! 75
     &             44.5,   48.0,   51.7,   57.2,   64.5,         ! 80
     &             73.5,   83.3,   92.6,  104.0,  115.0,         ! 85
     &            127.0,  140.0,  153.0,  167.0,  182.0,         ! 90
     &            232.0,  192.0,    0.0,    0.0,    0.0,         ! 95
     &              0.0,    0.0,    0.0,    0.0,    0.0,         ! 100
     &              0.0,    0.0,    0.0/
 
      data eo4/                                     9.6,         ! 80
     &             14.7,   20.7,   26.9,   31.0,   40.0,         ! 85
     &             48.0,   58.0,   68.0,   80.0,   92.5,         ! 90
     &             94.0,  102.8,    0.0,    0.0,    0.0,         ! 95
     &              0.0,    0.0,    0.0,    0.0,    0.0,         ! 100
     &              0.0,    0.0,    0.0/                                 

      data eo5/                                     7.8,         ! 80
     &             12.5,   18.1,   23.8,   31.0,   40.0,         ! 85
     &             48.0,   58.0,   68.0,   80.0,   85.4,         ! 90
     &             94.0,   94.2,    0.0,    0.0,    0.0,         ! 95
     &              0.0,    0.0,    0.0,    0.0,    0.0,         ! 100
     &              0.0,    0.0,    0.0/                                 

      data ep1/    26.0,   34.0,   44.0,    0.0,   41.4,         ! 86-90
     &              0.0,   43.9,    0.0,    0.0,    0.0,         ! 95
     &              0.0,    0.0,    0.0,    0.0,    0.0,         ! 100
     &              0.0,    0.0,    0.0/       

      data ep2/            15.0,   19.0,    0.0,   24.5,         ! 87-90
     &              0.0,   26.8,    0.0,    0.0,    0.0,         ! 95
     &              0.0,    0.0,    0.0,    0.0,    0.0,         ! 100
     &              0.0,    0.0,    0.0/       

      data ep3/            15.0,   19.0,    0.0,   16.6,         ! 87-90
     &              0.0,   16.8,    0.0,    0.0,    0.0,         ! 95
     &              0.0,    0.0,    0.0,    0.0,    0.0,         ! 100
     &              0.0,    0.0,    0.0/ 

      if( icheck(3) > 0 ) write(3,100) 
      eseuil(:) = 0._db

      if( numat > nassm .and. mpirank == 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,105) numat
        end do
        stop
      endif

      select case(nseuil)

        case(1)
          eseuil(1) = ek1( numat )

        case(2)
          select case(jseuil)
            case(1)
              eseuil(1) = el1( numat )
            case(2)
              eseuil(1) = el2( numat )
              if( nbseuil == 2 ) eseuil(2) = el3( numat )
            case(3)
              eseuil(1) = el3( numat )
          end select

        case(3)
          if( ( numat >= nm1 .and. jseuil < 4 ) .or.
     &        ( numat >= nm4 .and. jseuil >= 4 ) ) then  
            select case(jseuil)
              case(1)
                eseuil(1) = em1( numat )
              case(2)
                eseuil(1) = em2( numat )
                if( nbseuil == 2 ) eseuil(2) = em3( numat )
              case(3)
                eseuil(1) = em3( numat )
              case(4)
                eseuil(1) = em4( numat )
                if( nbseuil == 2 ) eseuil(2) = em5( numat )
              case(5)
                eseuil(1) = em5( numat )
            end select
          endif

        case(4)
          if( ( numat >= nn1 .and. jseuil < 4 ) .or.
     &        ( numat >= nn4 .and. jseuil >= 4 .and. jseuil < 6) .or.
     &        ( numat >= nn6 .and. jseuil >= 6 ) ) then  
            select case(jseuil)
              case(1)
                eseuil(1) = en1( numat )
              case(2)
                eseuil(1) = en2( numat )
                if( nbseuil == 2 ) eseuil(2) = en3( numat )
              case(3)
                eseuil(1) = en3( numat )
              case(4)
                eseuil(1) = en4( numat )
                if( nbseuil == 2 ) eseuil(2) = en5( numat )
              case(5)
                eseuil(1) = en5( numat )
              case(6)
                eseuil(1) = en6( numat )
                if( nbseuil == 2 ) eseuil(2) = en7( numat )
              case(7)
                eseuil(1) = en7( numat )
            end select
          endif

        case(5)
          if( ( numat >= no1 .and. jseuil < 4 ) .or.
     &        ( numat >= no4 .and. jseuil >= 4 ) ) then  
            select case(jseuil)
              case(1)
                eseuil(1) = eo1( numat )
              case(2)
                eseuil(1) = eo2( numat )
                if( nbseuil == 2 ) eseuil(2) = eo3( numat )
              case(3)
                eseuil(1) = eo3( numat )
              case(4)
                eseuil(1) = eo4( numat )
                if( nbseuil == 2 ) eseuil(2) = eo5( numat )
              case(5)
                eseuil(1) = eo5( numat )
            end select
          endif

        case(6)
          if( ( numat >= np1 .and. jseuil < 2 ) .or.
     &        ( numat >= np2 .and. jseuil >= 2 ) ) then  
            select case(jseuil)
              case(1)
                eseuil(1) = ep1( numat )
              case(2)
                eseuil(1) = ep2( numat )
                if( nbseuil == 2 ) eseuil(2) = ep3( numat )
              case(3)
                eseuil(1) = ep3( numat )
            end select
          endif

      end select

      if( eseuil(1) < eps10 .and. mpirank == 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,120)
        end do
        stop
      endif

      if( old_reference ) then
        workf = workfct( numat )
      else
        workf = workref( numat )
      endif

      if( mpirank == 0 ) then
        do ipr = 3,6,3
          if( ipr == 3 .and. icheck(3) == 0 ) cycle
          if( nbseuil == 1 ) then
            write(ipr,150) eseuil(1), workf
          else
            write(ipr,160) eseuil(1:nbseuil), workf
          endif
        end do
      endif

      eseuil(1:nbseuil) = eseuil(1:nbseuil) / rydb
      workf = workf / rydb

      return
  100 format(/' ---- Esdata -------',100('-'))
  105 format(//' Z =',i4,' > nassm in routine esdata !'//)
  120 format(//' Threshold non included in the data of the routine',
     &         ' Esdata in the file general.f !',//
     &         ' It may be that it does not exist !'//)
  150 format(/' E_edge =',f9.2,' eV, WorkF =',f7.2,' eV')
  160 format(/' E_edge(1) =',f9.2,' eV, E_edge(2) =',f9.2,' eV,',
     &        ' WorkF =',f7.2,' eV')
      end

!***********************************************************************

! Determination du sous groupe ayant toutes les representations utiles 
! de dimension 1.

      function igrpt_sg_so(igrpt)

      select case(igrpt)
        case(39,40)
          igrpt_sg_so = 4
        case(41)
          igrpt_sg_so = 1  ! A ameliorer plus tard...
        case(44)
          igrpt_sg_so = 5
        case(45,46)
          igrpt_sg_so = 16
        case(48)
          igrpt_sg_so = 21
        case(53,58,67)
          igrpt_sg_so = 11
        case(60)
          igrpt_sg_so = 10
        case(70)
          igrpt_sg_so = 17
        case(73,78)
          igrpt_sg_so = 22
        case(84)
          igrpt_sg_so = 23
        case default
          igrpt_sg_so = igrpt
      end select

      return
      end

! **********************************************************************

      function igrpt_sg_cmp(igrpt)

      select case(igrpt)
        case(16)
          igrpt_sg_cmp = 1
        case(9,10,22)
          igrpt_sg_cmp = 4 
        case(21)
          igrpt_sg_cmp = 3
        case(11,23)
          igrpt_sg_cmp = 5 
        case(17)
          igrpt_sg_cmp = 2 
        case default
          igrpt_sg_cmp = igrpt
      end select

      return
      end

! **********************************************************************

      integer function iordresym(is)

      implicit none

      integer:: is
      integer, dimension(64):: ior

      data ior/1,18,21,24,25,28,31,42,49,50,51,52,53,54,55,56,
     &         10,11,22,23,40,41,45,48,57,58,59,60,61,62,63,64, 
     &         2,3,4,5,6,7,8,9,12,13,14,15,16,17,19,20,26,27,29,30,32,
     &         33,34,35,36,37,38,39,43,44,46,47/

      iordresym = ior(is)

      return
      end

!*********************************************************************

! Nom des operations de symetrie

      function nomsym(isym)

      character(len=9):: nomsym
      character(len=9), dimension(64):: nsym

      data nsym/
     & '        E','   C3_111','  -C3_111','  C3_1-11',' -C3_1-11',     
     & '  C3_-111',' -C3_-111','  C3_11-1',' -C3_11-1','   C2_110',     
     & '  C2_-110','   C2_101','  C2_-101','   C2_011','  C2_0-11',     
     & '      C4x','      C4y','      C4z','     -C4x','     -C4y',     
     & '     -C4z','      C2x','      C2y','      C2z','        i',     
     & '      S4x','      S4y','      S4z','     -S4x','     -S4y',     
     & '     -S4z','  iC3_111',' -iC3_111',' iC3_1-11','-iC3_1-11',     
     & ' iC3_-111','-iC3_-111',' iC3_11-1','-iC3_11-1','       mx',     
     & '       my','       mz','    d_011','    d_101','    d_110',
     & '   d_01-1','   d_10-1','   d_1-10','      C3z','     -C3z',     
     & '      C6z','     -C6z','      S3z','     -S3z','      S6z',     
     & '     -S6z','    d_030','   C2_030','    d_060','   C2_060',     
     & '    d_120','   C2_120','    d_150','   C2_150'/     

      nomsym = nsym(isym)

      return
      end

!*********************************************************************

      function ptgrname_int_nomag(igrpt)
 
      parameter( ngrptm = 32, ngrpt_compm = 11, ngrptmagm = 90,
     &           ngrptmag_compm = 10 )

      character(len=8):: ptgrname_int_nomag
      character(len=8), dimension(ngrptm+ngrpt_compm):: ptgrname_int_t

      data ptgrname_int_t/
     &    '1       ','-1      ','m       ','2       ','2/m     ',
     &    'mm      ','222     ','mmm     ','4       ','-4      ',
     &    '4/m     ','4mm     ','-42m    ','422     ','4/mmm   ',
     &    '3       ','-3      ','3m      ','32      ','-3m     ',
     &    '-6      ','6       ','6/m     ','-6m2    ','6mm     ',
     &    '622     ','6/mmm   ','23      ','m3      ','-43m    ',
     &    '432     ','m3m     ',
     &    'mx      ','my      ','2x      ','2y      ','2/mx    ',
     &    '2/my    ','2mm     ','m2m     ','32v     ','dd      ',
     &    '3mv     '/

      ptgrname_int_nomag = ptgrname_int_t(igrpt)

      return
      end

!***********************************************************************

      function ptgrname_int(igrpt)
 
      parameter( ngrptm = 32, ngrptmagm = 90, ngrptmag_compm = 10 )

      character(len=8):: ptgrname_int, ptgrname_int_nomag
      character(len=8), dimension(ngrptm+1:ngrptmagm+ngrptmag_compm)::
     &                                               ptgrname_mag_t

      data ptgrname_mag_t/
     &    "-1'     ","2'      ","m'      ","2/m'    ","2'/m    ",
     &    "2'/m'   ","22'2'   ","2m'm'   ","2'm'm   ","m'm'm'  ",
     &    "mmm'    ","m'm'm   ","32'     ","3m'     ","-6'     ",
     &    "-6m'2'  ","-6'm2'  ","-6'm'2  ","4'      ","-4'     ",
     &    "42'     ","4'2     ","4/m'    ","4'/m'   ","4'/m    ",
     &    "4m'm'   ","4'mm'   ","-42'm'  ","-4'2m'  ","-4'2'm  ",
     &    "4/m'm'm'","4/m'mm  ","4'/mmm  ","4'/m'm'm","4/mm'm' ",
     &    "6'      ","-3'     ","-3m'    ","-3'm    ","-3'm'   ",
     &    "62'     ","6'2     ","6/m'    ","6'/m'   ","6'/m    ",
     &    "6m'm'   ","6'mm'   ","6'/mm'm ","6'/m'm'm","6/mm'm' ",
     &    "6/m'mm  ","6/mm'm' ","m'3     ","-4'3m'  ","4'3     ",
     &    "m'3m'   ","m'3m    ","m3m'    ",
     &    "22'2'   ","2'22'   ","2'mm'   ","m'mm    ","mm'm    ",
     &    "mm'm'   ","m'mm'   ","4'm'm   ","6'2d    ","6'm'm   "/

      if( igrpt > ngrptm ) then 
        ptgrname_int = ptgrname_mag_t(igrpt)
      else
        ptgrname_int = ptgrname_int_nomag(igrpt)
      endif
 
      return
      end

!***********************************************************************

      function ptgrname_sch(igrpt)
 
      parameter( ngrptm = 32, ngrpt_compm = 11)

      character(len=8):: ptgrname_sch
      character(len=8), dimension(ngrptm+ngrpt_compm):: ptgrname_sch_t

      data ptgrname_sch_t/'C1   ','Ci   ','Cs   ','C2   ','C2h  ',
     &                  'C2v  ','D2   ','D2h  ','C4   ','S4   ',
     &                  'C4h  ','C4v  ','D2d  ','D4   ','D4h  ',
     &                  'C3   ','S6   ','C3v  ','D3   ','D3d  ',
     &                  'C3h  ','C6   ','C6h  ','D3h  ','C6v  ',
     &                  'D6   ','D6h  ','T    ','Th   ','Td   ',
     &                  'O    ','Oh   ',
     &    'Csx     ','Csy     ','C2x     ','C2y     ','C2hx    ',
     &    'C2hy    ','C2vx    ','C2vy    ','D3v     ','C2d     ',
     &    'C3d     '/

      ptgrname_sch = ptgrname_sch_t(igrpt)
 
      return
      end

!***********************************************************************

! Table du nombre des operations de symetrie de chaque groupe ponctuel

      function numbops(is)

      parameter( ngrptm = 32, ngrpt_compm = 11 )

      integer, dimension(ngrptm+ngrpt_compm):: no_tab

      data no_tab/ 1, 2, 2, 2, 4, 4, 4, 8, 4, 4,
     &             8, 8, 8, 8,16, 3, 6, 6, 6,12,
     &             6, 6,12,12,12,12,24,12,24,24,
     &            24,48,
     &             2, 2, 2, 2, 4, 4, 4, 4, 6, 4,
     &             6/

      numbops = no_tab(is)

      return
      end

!***********************************************************************

! Table des operations de symetrie de chaque groupe ponctuel

      function ios(is)

      integer, dimension(332+40):: os_tab

! L'ordre correspond a celui des tables de caractere.

      data os_tab/ 
     & 1,                               ! C1   1    1
     & 1, 25,                           ! Ci  -1    2
     & 1, 42,                           ! Cs   m    3
     & 1, 24,                           ! C2   2    4
     & 1, 24, 25, 42,                   ! C2h  2/m  5
     & 1, 24, 41, 40,                   ! C2v  mm   6
     & 1, 22, 24, 23,                   ! D2   222  7
     & 1, 24, 23, 22, 25, 42, 41, 40,   ! D2h  mmm  8
     & 1, 24, 18, 21,                   ! C4   4    9
     & 1, 24, 28, 31,                   ! S4  -4    10
     & 1, 18, 24, 21, 25, 31, 42, 28,   ! C4h  4/m  11
     & 1, 24, 18,21, 40,41, 45,48,      ! C4v  4mm  12
     & 1, 24, 28,31, 22,23, 45,48,      ! D2d -42m  13    
     & 1, 24, 18,21, 22,23, 10,11,      ! D4   422  14
     & 1, 18,21, 24, 22,23, 10,11, 25, 28,31, 42, 40,41,
     &                                           45,48,  ! D4h 4/mmm 15 
     & 1, 49, 50,                                        ! C3   3    16
     & 1, 49, 50, 25, 56, 55,                            ! S6  -3    17
     & 1, 49,50, 40,57,63,                               ! C3v  3m   18
     & 1, 49,50, 22,60,62,                               ! D3   32   19
     & 1, 49,50, 22,60,62, 25, 55,56, 57,40,63,          ! D3d -3m   20
     & 1, 49, 50, 42, 53, 54,                            ! C3h -6    21
     & 1, 49, 50, 24, 52, 51,                            ! C6   6    22
     & 1, 51, 49, 24, 50, 52, 25, 54, 56, 42, 55, 53,    ! C6h  6/m  23
     & 1, 49,50, 58,23,64, 42, 53,54, 57,40,63,          ! D3h -6m2  24
     & 1, 24, 49,50, 51,52, 41,59,61, 57,40,63,          ! C6v  6mm  25
     & 1, 49,50, 22,60,62, 24, 51,52, 58,23,64,          ! D6   622  26  
     & 1, 51,52, 49,50, 24, 22,60,62, 58,23,64, 25,
     &            53,54, 55,56, 42, 57,40,63, 41,59,61,  ! D6h 6/mmm 27 
     & 1, 22,23,24, 2,4,6,8, 3,5,7,9,                    ! T    23   28
     & 1, 2,4,6,8, 3,5,7,9, 22,23,24, 25, 33,35,37,39,
     &                  32,34,36,38, 40,41,42,           ! Th   m3   29
     & 1, 2,3,4,5,6,7,8,9, 22,23,24, 43,44,45,46,47,48,
     &                  26,27,28,29,30,31,               ! Td  -43m  30
     & 1, 2,3,4,5,6,7,8,9, 22,23,24, 10,11,12,13,14,15,
     &                  16,17,18,19,20,21,               ! O    432  31
     & 1, 2,3,4,5,6,7,8,9, 10,11,12,13,14,15, 16,17,18,19,20,21,  
     &    22,23,24, 25, 32,33,34,35,36,37,38,39, 
     &    43,44,45,46,47,48, 26,27,28,29,30,31, 40,41,42,  ! Oh m3m  32
     & 1, 40,                        ! Csx   mx   33
     & 1, 41,                        ! Csy   my   34
     & 1, 22,                        ! C2x   2x   35
     & 1, 23,                        ! C2y   2y   36
     & 1, 22, 25, 40,                ! C2hx  2/mx 37
     & 1, 23, 25, 41,                ! C2hy  2/my 38
     & 1, 22, 41, 42,                ! C2vx  2mm  39
     & 1, 23, 40, 42,                ! C2vy  m2m  40
     & 1, 49,50, 58,23,64,           ! D3v   32v  41
     & 1, 24, 45, 48,                ! C2d   dd   42
     & 1, 49,50, 41,59,61/           ! C3d   3mv  43

      ios = os_tab(is)

      return
      end

!***********************************************************************

      function Chemical_Symbol(Z)

      Integer:: Z

      character(len=2):: Chemical_Symbol 
      character(len=2), dimension(103):: Symbol

      data Symbol/ 
     &    'H ','He','Li','Be','B ','C ','N ','O ','F ','Ne',    ! 10
     &    'Na','Mg','Al','Si','P ','S ','Cl','Ar','K ','Ca',    ! 20
     &    'Sc','Ti','V ','Cr','Mn','Fe','Co','Ni','Cu','Zn',    ! 30
     &    'Ga','Ge','As','Se','Br','Kr','Rb','Sr','Y ','Zr',    ! 40
     &    'Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd','In','Sn',    ! 50
     &    'Sb','Te','I ','Xe','Cs','Ba','La','Ce','Pr','Nd',    ! 60
     &    'Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb',    ! 70
     &    'Lu','Hf','Ta','W ','Re','Os','Ir','Pt','Au','Hg',    ! 80
     &    'Tl','Pb','Bi','Po','At','Rn','Fr','Ra','Ac','Th',    ! 90
     &    'Pa','U ','Np','Pu','Am','Cm','Bk','Cf','Es','Fm',    ! 100
     &    'Md','No','Lw'/

      Chemical_Symbol = Symbol(Z)

      return
      end

!***********************************************************************

      function Chemical_Name(Z)

      Integer:: Z

      character(len=13):: Chemical_Name 
      character(len=13), dimension(103):: Name

      data Name/ 
     & 'Hydrogen     ','Helium       ','Lithium      ','Beryllium    ',
     & 'Boron        ','Carbon       ','Nitrogen     ','Oxygen       ',
     & 'Fluorine     ','Neon         ','Sodium       ','Magnesium    ',
     & 'Aluminium    ','Silicon      ','Phosphorus   ','Sulfur       ',
     & 'Chlorine     ','Argon        ','Potassium    ','Calcium      ',  ! 20
     & 'Scandium     ','Titanium     ','Vanadium     ','Chromium     ',
     & 'Manganesen   ','Iron         ','Cobalt       ','Nickel       ',
     & 'Copper       ','Zinc         ','Gallium      ','Germanium    ',
     & 'Arsenic      ','Selenium     ','Bromine      ','Krypton      ',
     & 'Rubidium     ','Strontium    ','Yttrium      ','Zirconium    ',  ! 40
     & 'Niobium      ','Molybdenum   ','Technetium   ','Ruthenium    ',
     & 'Rhodium      ','Palladium    ','Silver       ','Cadmium      ',
     & 'Indium       ','Tin          ','Antimony     ','Tellurium    ',
     & 'Iodine       ','Xenon        ','Cesium       ','Barium       ',
     & 'Lanthanum    ','Cerium       ','Praeseodymium','Neodymium    ',  ! 60
     & 'Promethium   ','Samarium     ','Europium     ','Gadolinium   ',
     & 'Terbium      ','Dysprosium   ','Holmium      ','Erbium       ',
     & 'Thulium      ','Ytterbium    ','Lutetium     ','Hafnium      ',
     & 'Tantalum     ','Tungsten     ','Rhenium      ','Osmium       ',
     & 'Iridium      ','Platinum     ','Gold         ','Mercury      ',  ! 80
     & 'Thallium     ','Lead         ','Bismuth      ','Polonium     ',
     & 'Astatine     ','Radon        ','Francium     ','Radium       ',
     & 'Actinium     ','Thorium      ','Protactinium ','Uranium      ',
     & 'Neptunium    ','Plutonium    ','Americium    ','Curium       ',
     & 'Berkelium    ','Californium  ','Einsteinium  ','Fermium      ',  ! 100
     & 'Mendelevium  ','Nobelium     ','Lawrencium   '/

      Chemical_Name = Name(Z)

      return
      end

!*********************************************************************

! Table contenant l'indice l de l'orbitale sur laquelle s'applique
! la correction de Hubbard

      function l_hubbard(Z)

      Integer:: Z
      Integer, dimension(103):: lh

      data lh/ 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,              !10     H - Ne
     &         0, 0, 1, 1, 1, 1, 1, 1, 0, 0,              !20    Na - Ca
     &         2, 2, 2, 2, 2, 2, 2, 2, 2, 2,              !30    Sc - Zn
     &         1, 1, 1, 1, 1, 1, 0, 0,                    !38    Ga - Sr
     &         2, 2, 2, 2, 2, 2, 2, 2, 2, 2,              !48     Y - Cd
     &         1, 1, 1, 1, 1, 1, 0, 0,                    !56    In - Ba
     &         3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,  !70    La - Yb
     &         2, 2, 2, 2, 2, 2, 2, 2, 2, 2,              !80    Lu - Hg
     &         1, 1, 1, 1, 1, 1, 0, 0,                    !88    Tl - Ra
     &         3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,  !102   Ac - No
     &         1/                                         !103   Lw

      l_hubbard = lh(Z)

      return
      end

!*********************************************************************
! Oana:
! Table qui contient le nombre d'orbitales de valence qui sont accesibles
! pour toutes les espces chimiques: (nonrelativistes, on en a besoin pour nlat)

      function nvnonrel(Z)
      
      integer Z
      integer, dimension(103):: nvnr
      
      data nvnr / 
     &   1,                                                 1, ! 1-2  
     &   2, 2,                               2, 2, 2, 2, 2, 2, ! 3-10 
     &   2, 2,                               2, 2, 2, 2, 2, 2, ! 11-18
     &   3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, ! 19-36 
     &   3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, ! 37-54 
     &   4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,       ! 55-70 
     &         4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,  ! 71-86
     &   4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 /    ! 99-103
     
      nvnonrel = nvnr(Z)
      
      return
      end  
!*********************************************************************
! Oana:
! Table qui contient le nombre d'orbitales de valence qui sont accesibles
! pour toutes les espces chimiques: (relativistes)

      function nvrel(Z)
      
      integer Z
      integer, dimension(103):: nvr
      
      data nvr / 
     &   1,                                                 1, !
     &   2, 2,                               2, 2, 2, 2, 2, 2, 
     &   2, 2,                               2, 2, 2, 2, 2, 2,  
     &   3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,  
     &   5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,  
     &   7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,        
     &         7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,  
     &   7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 /   
     
      nvrel = nvr(Z)
      
      return
      end      
      
!*********************************************************************

       function n_orb_base(Z)
       
       integer Z
       integer, dimension(103):: n
       
       data n/ 
     &  1,                                                 1,  !  1-2
     &  2, 2,                               3, 3, 3, 3, 3, 3,  !  3-10
     &  4, 4,                               5, 5, 5, 5, 5, 5,  ! 11-18
     &  6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8,  ! 19-36
     &  9, 9,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,  ! 37-54
     & 12,12,13,14,14,14,14,14,14,14,14,14,14,14,14,14,        ! 55-70
     &       14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,  ! 71-86
     & 16,16,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18/     ! 87-103
       
       n_orb_base = n(Z)
       
       return
       end       
       
!*********************************************************************
! Oana:  
     
      function n_orb_coeur(Z)
       
      integer Z
      integer, dimension(103):: nc

! ordre d'occupation des orbitales:1s[He]2s2p[Ne]3s3p[Ar]4s3d4p[Kr]5s4d5p[Xe]6s4f5d6p[Rn]7s6d5f
! inversion: 6s2 4f0 5d1 puis on remplit les 4f puis les 6p
                              
      data nc/ 
      
     &   0,                                                 0,  ! 1-2
     &   1, 1,                               1, 1, 1, 1, 1, 1,  ! 3-10: 1s
     &   3, 3,                               3, 3, 3, 3, 3, 3,  !11-18: [He]2s2p
     &   5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,  !19-36: [Ne]3s3p
     &   8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,  !37-54: [Ar]4s3d4p
     &  10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,        !55-70: [Kr]5s4d5p
     &        11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,  !71-86: [Kr]5s4d5p
     &  15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15/     !87-103:[Xe]6s4f5d6p
      
      n_orb_coeur = nc(Z) 
      
! pour 56 et 57: la 5p on la compte parmi les orbitales de valence
      
      return
      end

!*********************************************************************

! Orbitale de valence partiellement rempli par defaut.
     
      function l_level_val(Z)
       
      integer Z, l_level_val

      select case( Z )
        case(1,2,3,4,11,12,19,20,37,38,55,56,87,88)
          l_level_val = 0
        case(5,6,7,8,9,13,14,15,16,17,18,31,32,33,34,35,36,
     &       49,50,51,52,53,54,81,82,83,84,85,86)
          l_level_val = 1
        case(21,22,23,24,25,26,27,28,29,30,39,40,41,42,43,44,45,
     &       46,47,48,57,72,73,74,75,76,77,78,79,80,89)
          l_level_val = 2
        case default
          l_level_val = 3
      end select
      
      return
      end

