! Fdmnes subroutines

      subroutine atom(chg_val_ref,clementi,com,icom,it0,itype,lcoeur,
     &      lvval,mpinodes,mpirank,ncoeur,ngroup,nlat,nlatm,
     &      nomfile_atom,nonexc,nrato,nrato_dirac,nrato_lapw,nrm,nspin,
     &      ntype,numat,nvval,pop_level,popatc,popats,popatv,
     &      popexc,popval,psi_coeur,psii,psi_level,
     &      psival,r0_lapw,rato,rho_coeur,rhoit,rlapw,rmt)

      use declarations
      implicit real(kind=db) (a-h,o-z)
      include 'mpif.h'

      character(len=3) :: mot3
      character(len=35), dimension(it0:ntype) :: com
      character(len=132), dimension(it0:ntype) :: nomfile_atom

      integer, dimension(ngroup):: itype
      integer, dimension(it0:ntype):: icom, nlat, nrato, nrato_lapw,  
     &                                numat
      integer, dimension(2,it0:ntype):: lcoeur, ncoeur 
      integer, dimension(it0:ntype,nlatm):: lvval, nvval

      logical clementi, nonexc

      real(kind=db), dimension(it0:ntype) :: popatc, r0_lapw, rlapw, rmt
      real(kind=db), dimension(nrm):: psii, rr
      real(kind=db), dimension(ngroup,nlatm,nspin):: popats
      real(kind=db), dimension(nnlm,nspin):: popexc
      real(kind=db), dimension(it0:ntype,nlatm) :: popatv
      real(kind=db), dimension(it0:ntype,nlatm,nspin):: popval
      real(kind=db), dimension(0:nrm,it0:ntype):: rato, rhoit, rho_coeur
      real(kind=db), dimension(0:nrm,nlatm,it0:ntype):: psival
      real(kind=db), dimension(0:nrm,it0:ntype,2):: psi_level
      real(kind=db), dimension(it0:ntype,2):: pop_level
	real(kind=db), dimension(0:nrm,it0:ntype):: psi_level_val
	real(kind=db), dimension(it0:ntype):: pop_level_val
      real(kind=db), dimension(0:nrm,2,it0:ntype):: psi_coeur       

      common/icheck/ icheck(24)

      if( clementi ) then
        do it = 1,ntype
          if( icom(it) == 1 .and. numat(it) < 55 ) then
            com(it) = ' Clementi and Roetti'
            icom(it) = 2
          endif
        end do
      endif

      do it = 1,ntype
        if( icom(it) /= 4 .and. it == 0 ) cycle 
        if( numat(it) == 0 ) cycle
        select case( icom(it) )

          case(1)

            call dirgen(chg_val_ref,it,it0,0,lcoeur,lvval,mpirank,
     &        ncoeur,nlat,nlatm,nonexc,nr,nrato_dirac,nrm,nspin,
     &        ntype,nvval,pop_level_val,popatc,popatv,popexc,popval,
     &        psi_coeur,
     &        psii,psi_level_val,psival,rr,rho_coeur,rhoit,numat(it))

            psi_level(:,:,1) = psi_level_val(:,:)                ! atome neutre
            pop_level(:,1) = pop_level_val(:)
            nrato(it) = nr
            rato(1:nr,it) = rr(1:nr)
            rato(0,it) = 0._db

            do igr = 1,ngroup
              if( abs( itype(igr) ) /= it ) cycle
              do l = 1,nlat(it)
                do ispin = 1,nspin
                  if( itype(igr) > 0 .or. nspin == 1 ) then
                    popats(igr,l,ispin) = popval(it,l,ispin)
                  else
                    popats(igr,l,3-ispin) = popval(it,l,ispin)
                  endif
                end do
              end do
            end do

          case(2)

            call clem(it,it0,0,lvval,mpirank,nlat,nlatm,nonexc,nr,nrm,
     &             ntype,nvval,popatc,popatv,psii,psival,rr,rhoit,
     &             numat(it))
            nrato(it) = nr
            rato(1:nr,it) = rr(1:nr)
            rato(0,it) = 0._db

          case(3)

            nrato(it) = nrato_lapw(it)
            if( nrato(it) > nrm .and. mpirank == 0 ) then
              call write_error
              do ipr = 3,9,3
                write(ipr,110) nrato(it), nrm
              end do
              stop
            endif
            dx = log( rlapw(it) / r0_lapw(it) ) / ( nrato_lapw(it) - 1 )
            do j = 1,nrato_lapw(it)
              rato(j,it) = r0_lapw(it) * exp( ( j - 1 ) * dx )
            enddo
            rato(0,it) = 0._db
            dr = rato(nrato(it),it) - rato(nrato(it)-1,it)
            n = rato(nrato(it),it) / dr
            nrato(it) = nrato(it) + n
            if( nrato(it) > nrm .and. mpirank == 0 ) then
              call write_error
              do ipr = 3,9,3
                write(ipr,120) nrato(it), nrm
              end do
              stop
            endif
            do ir = nrato(it) - n + 1, nrato(it)
              rato(ir,it) = rato(ir-1,it) + dr
            end do

          case(4)

            if( mpirank == 0 ) then
              open(8, file=nomfile_atom(it), status='old',iostat=istat)
              do i = 1,100000
                read(8,'(A)') mot3
                if(mot3 == '---') exit
              end do
              read(8,*) 
              read(8,*) nrato(it)
              read(8,*)
              rato(0,it) = 0._db
              do ir = 1,nrato(it)
                if( it == 0 ) then
                  read(8,*) rato(ir,it), rhoit(ir,it),
     &                      (psival(ir,l,it),l = 1,nlat(it)), psii(ir)
                else
                  read(8,*) rato(ir,it), rhoit(ir,it),
     &                       (psival(ir,l,it), l = 1,nlat(it))
                endif
              end do
              rato(1:nrato(it),it) = rato(1:nrato(it),it) / bohr
              Close(8)
            endif

            if( mpinodes > 1 ) then
              call MPI_BARRIER(MPI_COMM_WORLD,mpierr) 
              do io = 1,nlat(it)
                call MPI_Bcast(popatv(it,io),1,MPI_REAL8,0,
     &                                           MPI_COMM_WORLD,mpierr) 
              end do
              do io = 1,nlat(it)
                do ir = 0,nrato(it)
                  call MPI_Bcast(psival(ir,io,it),1,MPI_REAL8,0,
     &                                           MPI_COMM_WORLD,mpierr) 
                end do
              end do
              do ir = 0,nrato(it)
                call MPI_Bcast(rato(ir,it),1,MPI_REAL8,0,
     &                                           MPI_COMM_WORLD,mpierr) 
                call MPI_Bcast(rhoit(ir,it),1,MPI_REAL8,0,
     &                                           MPI_COMM_WORLD,mpierr) 
              end do
              if( it == 0 ) call MPI_Bcast(psii,nrm,MPI_REAL8,0,
     &                                           MPI_COMM_WORLD,mpierr)  
            endif

        end select   

      end do     ! fin de la boucle sur les esp�ces chimiques

      write(98,'(a15,i3)') ' atom, mpirank=',mpirank ! Erreur MPI
      rmt_H = 0.3_db
      rmt_Ti = 1.0_db
      do it = 1,ntype
        if( abs(rmt(it)) > eps10 ) cycle
        if( numat(it) == 0 ) then
          rmt(it) = 0._db
        elseif( numat(it) == 1 ) then
          rmt(it) = rmt_H
        elseif( numat(it) > 21 ) then
          rmt(it) = rmt_Ti
        else
          p1 = ( numat(it) - 1._db ) / 21._db  
          rmt(it) = p1 * rmt_Ti + (1 - p1) * rmt_H
        endif 
      end do

      if( icheck(3) > 0 ) write(3,140) rmt(1:ntype)
      rmt(:) = rmt(:) / bohr

      return
  110 format(/' nrato =',i6,' > ndm =',i6,' !',
     &       /' Increase the value of ndm in the parameter',
     &        ' in lectur and dirac')
  120 format(/' nrato =',i6,' > ndm =',i6,' after extrapolation !',
     &       /' Increase the value of ndm in the parameter',
     &        ' in lectur and dirac')
  140 format(/' FDM atom radius =',10f6.3)
      end
     
!***********************************************************************

! Calcul des atomes selon Clementi et Roetti

!  References :
!   HS  F. Herman and S. Skillman "Atomic Structure Calculations"
!       Prentice Hall 1963
!   CR  E. Clementi and C. Roetti "Atomic Data and Nuclear Data Tables"
!       Vol.14,(3-4) [1974] p.177-478

!   NPRIN Principal quantum number
!   NAZIM Azimuthal quantum number
!   NCONF Number of electrons occupying this orbital
!   NTERM Number of radial basis functions
!   NEXP  Ni for the basis functions (See Clementi Roetti book)
!   ESP   Exponential constant for the basis function
!   CON   Coefficient which multiplies the basis function
!
      subroutine clem(it,it0,itabs,lvval,mpirank,nlat,nlatm,nonexc,
     &            nrato,nrm,ntype,nvval,popatc,popatv,psii,psival,rato,
     &            rhoit,Z)

      use declarations
      implicit real(kind=db) (a-h,o-z)


      parameter(norbm=11,ntrm=11)

      integer Z, Zp
      integer, dimension(norbm):: nazim, nazim0, nconf, nconf0, nprin,
     &                             nprin0, nterm, nterm0
      integer, dimension(norbm,ntrm) :: nexp, nexp0
      integer, dimension(it0:ntype):: nlat
      integer, dimension(it0:ntype,nlatm):: lvval, nvval

      logical nonexc

      real(kind=db), dimension(6):: nfact
      real(kind=db), dimension(nrm):: psii, rato
      real(kind=db), dimension(norbm,ntrm):: esp, esp0, con, con0, onor
      real(kind=db), dimension(it0:ntype):: popatc
      real(kind=db), dimension(it0:ntype,nlatm):: popatv
      real(kind=db), dimension(0:nrm,it0:ntype):: rhoit
      real(kind=db), dimension(0:nrm,nlatm,it0:ntype):: psival

      common/icheck/ icheck(24)
      common/lseuil/ jseuil, lseuil, nseuil

      if( icheck(2) > 1 ) write(3,100) it, Z

! Rayons
      r0 = 0.00005_db / bohr
      rmax = 10._db / bohr
      delta = 1.02_db
      rato(1) = r0
      rr = r0
      f = log( delta )
      do ir = 2,1000000
       rr = rr + r0 * exp( ( ir - 1) * f )
       if( ir > nrm ) cycle
       rato(ir) = rr
       if( rato(ir) > rmax ) exit
      end do
      nrato = ir
      nr = nrato
      if( nr > nrm .and. mpirank == 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,105) nr, nrm
        end do
        stop
      endif

! Factoriels
      Nfact(1) = sqrt( 2._db )
      do i = 2,6
        Nfact(i) = Nfact(i-1) * sqrt( 2._db * i * ( 2 * i - 1 ) )
      end do

! Pour l'absorbeur, on calcule l'atome excite (Z+1) et l'atome non
! excite
      if( it == itabs .and. .not. nonexc ) then
        ncalc = 2
      else
        ncalc = 1
      endif

      do icalc = 1,ncalc

        Zp = Z + icalc - 1 ! Approximation Z + 1

        if( Zp < 30 ) then
          call clempar1(Zp,norb,nprin,nazim,nconf,nterm,nexp,esp,con)
        elseif( Z < 50 ) then
          call clempar2(Zp,norb,nprin,nazim,nconf,nterm,nexp,esp,con)
        else
          call clempar3(Zp,norb,nprin,nazim,nconf,nterm,nexp,esp,con)
        endif

        if( it == itabs .and. icalc == 1 ) then
          ch = 0._db
          do io = 1,norb
            if( nprin(io) == nseuil .and. nazim(io) == lseuil ) exit
          end do
          do i = 1,Nterm(io)
            alfa =  ( 2 * esp(io,i) )**( nexp(io,i) + 0.5_db )
            onor(io,i) =  alfa / Nfact(nexp(io,i))
          end do
          do ir = 1,nr
            phi = 0._db
            do j = 1,nterm(io)
              arg = esp(io,j) * rato(ir)
              if( arg > 100._db ) cycle
              phi = phi + onor(io,j) * con(io,j)
     &                  * rato(ir)**nexp(io,j) * exp( - arg )
            end do
            psii(ir) = phi
            ch = ch + phi**2 * ( rato(ir+1) - rato(ir) )
          end do
          if( icheck(2) > 1 ) write(3,120) io, nprin(io), nazim(io),
     &                                     nconf(io), ch
          if( nvval(1,1) == - 1 ) return
        endif

        if( it == itabs .and. .not. nonexc ) then
          if( icalc == 1 ) then
            norb0 = norb
            nprin0(1:norb) = nprin(1:norb)
            nazim0(1:norb) = nazim(1:norb)
            nconf0(1:norb) = nconf(1:norb)
            nterm0(1:norb) = nterm(1:norb)
            nexp0(1:norb,:) = nexp(1:norb,:)
            esp0(1:norb,:) = esp(1:norb,:)
            con0(1:norb,:) = con(1:norb,:)
          else
            do io = 1,norb
              if( nprin(io) == nseuil .and. nazim(io) == lseuil )
     &          nconf(io) = nconf(io) - 1
              if( nprin(io) > nseuil .or.
     &         ( nprin(io) == nseuil .and. nazim(io) >= lseuil ) ) cycle
              do io0 = 1,norb0
                if( nprin0(io0) /= nprin(io)
     &              .or. nazim0(io0) /= nazim(io) ) cycle
                nconf(io) = nconf0(io0)
                nterm(io) = nterm0(io0)
                nexp(io,:) = nexp0(io0,:)
                esp(io,:) = esp0(io0,:)
                con(io,:) = con0(io0,:)
                exit
              end do
            end do
          endif
        endif

      end do

      do io = 1,nlat(it)
        do i = 1,norb
          if( nprin(i) == nvval(it,io) .and. nazim(i) == lvval(it,io))
     &       exit
        end do
        if( i == norb+1 .and. mpirank == 0 ) then
          call write_error
          do ipr = 3,9,3
            write(ipr,110) it, nvval(it,io), lvval(it,io)
          end do
          stop
        endif
        popatv(it,io) = 1._db * nconf(i)
      end do

      popatc(it) = 1._db * sum( nconf(1:norb) )
      do io = 1,nlat(it)
        popatc(it) = popatc(it) - popatv(it,io)
      end do

!  Calculate normalization coefficients
!  (see CR p.180, equation (6))

      do io = 1,norb
        do i = 1,Nterm(io)
          alfa =  ( 2 * esp(io,i) )**( nexp(io,i) + 0.5_db )
          onor(io,i) =  alfa / Nfact(nexp(io,i))
        end do
      end do

      rhoit(:,it) = 0._db
      do io = 1,norb
        do iv = 1,nlat(it)
          if( nprin(io) == nvval(it,iv) .and.
     &                         nazim(io) == lvval(it,iv) ) exit
        end do
        if( iv == nlat(it)+1 ) iv = 0
        ch = 0._db
        do ir = 1,nr
          phi = 0._db
          do j = 1,nterm(io)
            arg = esp(io,j) * rato(ir)
            if( arg > 100._db ) cycle
            phi = phi + onor(io,j) * con(io,j) * rato(ir)**nexp(io,j)
     &                * exp( - arg )
          end do
          if( iv > 0 ) psival(ir,iv,it) = phi
          rhoit(ir,it) = rhoit(ir,it)
     &                 + nconf(io) * ( phi / rato(ir) )**2
          ch = ch + phi**2 * ( rato(ir+1) - rato(ir) )
        end do
        if( icheck(2) > 1 ) write(3,120) io, nprin(io), nazim(io),
     &                                   nconf(io), ch
      end do
      rhoit(1:nr,it) = rhoit(1:nr,it) / quatre_pi

      return
  100 format(/' it =',i2,'  Z =',i4)
  105 format(/' Number of radius =',i6,' > ndm =',i6,//
     &        ' Increase this dimension the parameter in',
     &        ' lectur and dirac !'/)
  110 format(///' Orbital not found in the Clementi and',
     &' Roetti bases :',/'   it =',i2,',  n =',i2,'  l =',i2)
  120 format(' io, nprin, nazim, nconf =',4i3,' ch =',f10.7)
      end

!*********************************************************************

! Recherche des atomes equivalents a l'absorbeur et calcul de leur
! symetrie relative.

      subroutine symsite(absauto,Atom_mag_gr,Atom_nsph,Axe_atom_gr,
     &        base_ortho,Biology,flapw,iabsm,iscratch,it0,itype,
     &        magnetic,matper,mpirank,n_atom_proto,n_multi_run_e,ngroup,
     &        nlat,nlatm,nspin,ntype,numat,numat_abs,popats,posn)

      use declarations
      implicit real(kind=db) (a-h,o-z)
      
      character(len=5):: struct
      character(len=9):: nomsym
      character(len=11):: nomt

      integer, dimension(ngroup,nopsm*nspin):: isymeqa
      integer, dimension(it0:ntype):: nlat, numat
      integer, dimension(ngroup):: itype, nsequ
      integer, dimension(n_multi_run_e):: iabsm  
      integer, dimension(ngroup):: igreq, isymq, itypegen  
      integer, dimension(ntype,ngroup):: igreq_far  
      integer, dimension(ntype):: itequ, neq_far 
      integer, dimension(:), allocatable:: iabsmm  

      logical absauto, Atom_nonsph, base_ortho, Biology, flapw, 
     &        Group_close, magnetic, matper, mspinor
      logical, dimension(ngroup):: Atom_nsph, ok, Far_atom
      logical, dimension(0:ngroup):: Atom_mag_gr

      real(kind=db), dimension(3):: Axe_atom_c, ps, spini,
     &                             vspin, vspini, wspin, wspini
      real(kind=db), dimension(3,3):: matopsym 
      real(kind=db), dimension(3,ngroup):: Axe_atom_gr, Axe_atom_s,
     &                                    pos, posg, posn, poss
      real(kind=db), dimension(ngroup,nlatm,nspin):: popats

      common/Atom_nonsph/ Atom_nonsph
      common/axyz/ axyz(3), angxyz(3)
      common/cubmat/ cubmat(3,3), cubmati(3,3)
      common/dcosxyz/ dcosxyz(3)
      common/icheck/ icheck(24)
      common/orthmat/ orthmat(3,3), orthmati(3,3)
      common/struct/ struct

      neq_far(:) = 0

      rad = pi / 180
      dcosxyz(:) = 2 * cos( angxyz(:) * rad )
      if( abs( dcosxyz(1) ) < eps10 .and. abs( dcosxyz(2) ) < eps10
     &    .and. abs( dcosxyz(3) ) < eps10 ) then
        base_ortho = .true.
      else
        base_ortho = .false.
      endif

      ok(:) = .false.

      do it = 1,ntype
        itequ(it) = it
      end do
      
      do ita = 1,ntype
        na = numat(ita)
        nla = nlat(ita) 
        do igra = 1,ngroup
          if( abs(itype(igra)) == ita ) exit 
        end do
        if( igra > ngroup ) cycle
        do itb = ita+1,ntype
          if( itequ(itb) /= itb ) cycle
          nb = numat(itb)
          if( nb /= na ) cycle
          nlb = nlat(itb) 
          if( nlb /= nla ) cycle
          do igrb = 1,ngroup
            if( abs(itype(igrb)) == itb ) exit 
          end do
          if( igrb > ngroup ) cycle

          dpop = 0._db
          do io = 1,nlb
            do isp = 1,nspin
              dpop = dpop
     &             + abs( popats(igra,io,isp) - popats(igrb,io,isp) )
            end do
          end do
          if( dpop < eps6 ) then
            itequ(itb) = ita
          elseif( nspin > 1 ) then
            dpop = 0._db
            do io = 1,nlb
              do isp = 1,nspin
                dpop = dpop + abs( popats(igra,io,isp)
     &                           - popats(igrb,io,nspin-isp+1) )
              end do
            end do
            if( dpop < eps6 ) itequ(itb) = -ita
          endif

        end do
      end do

      do igr = 1,ngroup
        it = abs( itype(igr) )
        itypegen(igr) = itequ(it)
        if( magnetic .and. ( nlat(it) > 0 .or. flapw ) ) then
          if( flapw ) then
            Atom_mag_gr(igr) = .true.
          else
            dpop = sum( abs( popats(igr,1:nlat(it),nspin)
     &                              - popats(igr,1:nlat(it),1) ) )
            if( dpop < eps6 ) then
              Atom_mag_gr(igr) = .false.
            else
              Atom_mag_gr(igr) = .true.
            endif
          endif
        else
          Atom_mag_gr(igr) = .false.
        endif
      end do

      n_atom_proto = 0

! Liste des atomes absorbeurs
      if( absauto ) then
        nabs = 0
        do igr = 1,ngroup
          if( numat( abs( itype(igr) ) ) == numat_abs ) nabs = nabs+1 
        end do
        allocate( iabsmm(nabs) )
        ia = 0
        do igr = 1,ngroup
          if( numat( abs( itype(igr) ) ) /= numat_abs ) cycle
          ia = ia + 1
          iabsmm(ia) = igr 
        end do
      else
        nabs = n_multi_run_e
        allocate( iabsmm(n_multi_run_e) )
        iabsmm(:) = iabsm(:)
      endif

! Parametres servant a limiter le calcul du nombre d'atomes non
! equivalents
      if( Biology ) then

        distm_neq = 2.6_db / bohr

        do igr = 1,ngroup

          Far_atom(igr) = .true.
          do ia = 1,nabs
            ps(:) = posn(:,iabsmm(ia)) - posn(:,igr)
            if( matper ) then
              where( ps > 0.5_db ) ps = ps - 1._db 
              where( ps < -0.5_db ) ps = ps + 1._db
            endif
            ps(:) = ps(:) * axyz(:)
            dist = vnorme(ps)
            if( dist <= distm_neq ) then
              Far_atom(igr) =  .false.
              exit
            endif
          end do

        end do

      else

        Far_atom(:) = .false.

      endif

      open(iscratch, status='scratch')

      boucle_jgr: do jgr = 1,ngroup

        if( ok(jgr) ) cycle

        numat_jgr = numat( abs( itype(jgr) ) )

        n_atom_proto = n_atom_proto + 1

        ps(:) = posn(:,jgr)
        do ia = 1,ngroup
          posg(:,ia) = posn(:,ia) - ps(:)
        end do

        if( matper ) call inmesh(posg,ngroup)

        neq = 1
        isymq(1) = 1
        nsequ(1) = 1
        igreq(1) = jgr
        isymeqa(1,1) = 1
        ok(jgr) = .true. 

        boucle_igr: do igr = 1,ngroup

          if( ok(igr) ) cycle boucle_igr

          if( itypegen(igr) /= itypegen(jgr) ) cycle boucle_igr

! Pour les atomes loins des atomes absorbeurs, on ne verifie pas la
! symetrie.
          if( Far_atom(igr) .and. Far_atom(jgr) ) then
            ok(igr) = .true.
            neq = neq + 1
            igreq(neq) = igr
            isymq(neq) = 1
            isymeqa(neq,1) = 1
            cycle boucle_igr
          endif

          do ia = 1,ngroup
            pos(:,ia) = posg(:,ia) - posg(:,igr)
          end do
          if( matper ) call inmesh(pos,ngroup)

! Recherche des symetries qui rendent les atomes equivalents.
          ns = 0
          boucle_is: do is = 1,nopsm

            call opsym(is,matopsym)
            if( struct /= 'cubic' ) then
              matopsym = matmul(matopsym,cubmat)
              matopsym = matmul(cubmati,matopsym)
            endif

            do ia = 1,ngroup
              ps(:) = posg(:,ia) * axyz(:)
              ps = matmul( matopsym, ps )
              poss(:,ia) = ps(:) / axyz(:)
            end do
            if( matper ) call inmesh(poss,ngroup)

            if( magnetic .or. Atom_nonsph ) then 
              do ia = 1,ngroup
                Axe_atom_c(:) = Axe_atom_gr(:,ia)
                if( abs(Axe_atom_c(1)) < eps6 ) then
                  wspin(1) = 1._db;  wspin(2:3) = 0._db
                else
                  wspin(3) = 1._db;  wspin(1:2) = 0._db
                endif
                call prodvec( vspin, Axe_atom_c, wspin )
                vspin = vspin / vnorme( vspin ) 
                call prodvec( wspin, Axe_atom_c, vspin ) 

                vspini(:) = axyz(:) * vspin(:)
                vspini = matmul( matopsym, vspini )
                vspini(:) = vspini(:) / axyz(:)
                wspini(:) = axyz(:) * wspin(:)
                wspini = matmul( matopsym, wspini )
                wspini(:) = wspini(:) / axyz(:)
                call prodvec(spini,vspini,wspini)
                Axe_atom_s(:,ia) = spini 
              end do
            endif

            boucle_irev: do irev = 1,nspin    ! 1 identite,
                                              ! 2 renversement du temps
              boucle_ia: do ia = 1,ngroup

                boucle_ib: do ib = 1,ngroup

                  if( abs( pos(1,ia) - poss(1,ib) ) > epspos .or.
     &                abs( pos(2,ia) - poss(2,ib) ) > epspos .or.
     &                abs( pos(3,ia) - poss(3,ib) ) > epspos )
     &                                                   cycle boucle_ib

                  if( abs(itypegen(ia)) /= abs(itypegen(ib)) )
     &                                                   cycle boucle_is

                  if( .not. Atom_mag_gr(ia) .and. .not. Atom_mag_gr(ib)
     &                .and.
     &                .not. Atom_nsph(ia) .and. .not. Atom_nsph(ib) )
     &                                                   cycle boucle_ia

                  if( ( Atom_mag_gr(ia) .and. .not. Atom_mag_gr(ib) )
     &                 .or.
     &                ( .not. Atom_mag_gr(ia) .and. Atom_mag_gr(ib) )
     &                 .or.
     &                ( Atom_nsph(ia) .and. .not. Atom_nsph(ib) ) .or.
     &                ( .not. Atom_nsph(ia) .and. Atom_nsph(ib) ) )
     &                                                   cycle boucle_is

                  mspinor = itypegen(ia) == itypegen(ib)
                  if( Atom_mag_gr(ia) ) then
  
                    if( ( irev == 1 .and. mspinor ) .or. 
     &                  ( irev == 2 .and. .not. mspinor ) ) then

                      if( abs( Axe_atom_gr(1,ia) - Axe_atom_s(1,ib) )
     &                                                     > epspos .or.
     &                    abs( Axe_atom_gr(2,ia) - Axe_atom_s(2,ib) )
     &                                                     > epspos .or.
     &                    abs( Axe_atom_gr(3,ia) - Axe_atom_s(3,ib) )
     &                                      > epspos ) cycle boucle_irev
                    else

                      if( abs( Axe_atom_gr(1,ia) + Axe_atom_s(1,ib) )
     &                                                     > epspos .or.
     &                    abs( Axe_atom_gr(2,ia) + Axe_atom_s(2,ib) )
     &                                                     > epspos .or.
     &                    abs( Axe_atom_gr(3,ia) + Axe_atom_s(3,ib) )
     &                                      > epspos ) cycle boucle_irev
                    endif

                  else

                     pp1 = sum( abs( Axe_atom_gr(:,ia)
     &                             - Axe_atom_s(:,ib) ) )
                     pp2 = sum( abs( Axe_atom_gr(:,ia)
     &                             + Axe_atom_s(:,ib) ) ) 
                     if( pp1 > epspos .and. pp2 > epspos )
     &                                             cycle boucle_irev
                  endif
             
                  cycle boucle_ia

                end do boucle_ib

                cycle boucle_is

              end do boucle_ia

! Cette symetrie est la bonne
              ns = ns + 1
              if( irev == 2 ) then
                js = - is
              else
                js = is
              endif
              if( ns == 1 ) then
                neq = neq + 1
                ok(igr) = .true.
                igreq(neq) = igr
                isymq(neq) = js
              endif
              nsequ(neq) = ns
              isymeqa(neq,ns) = js

            end do boucle_irev

          end do boucle_is

        end do boucle_igr

        Group_close = .false.
        do i = 1,neq
          if( Far_atom( igreq(i) ) ) cycle
          Group_close = .true.
          exit
        end do

        if( Group_close ) then
          write(iscratch,*) neq
          do i = 1,neq
            write(iscratch,*) igreq(i), posn(:,igreq(i)), isymq(i)
          end do
          if( icheck(4) > 0 ) then
            if( n_atom_proto == 1 ) write(3,110)
            write(3,120) n_atom_proto, numat_jgr, neq
            do ia = 1,neq
              nomt = '         '
              nomt(3:11) = nomsym( abs(isymq(ia)) )
              if(isymq(ia) < 0 ) then
                long = len_trim( adjustl( nomsym(abs(isymq(ia))) ) )
                nomt(10-long:11-long) = 'T.'
              endif
              igra = igreq(ia)
              if( icheck(4) == 1 ) then
                write(3,130) igreq(ia), posn(:,igra), nomt,
     &                       isymeqa(ia,1)
              else
                write(3,130) igreq(ia), posn(:,igra), nomt,
     &                        ( isymeqa(ia,is), is = 1,nsequ(ia) )
              endif
            end do
          endif
        else
          n_atom_proto = n_atom_proto - 1
          it = abs( itypegen( igreq(1) ) )
          neq_far(it) = neq_far(it) + neq
          igreq_far(it,neq_far(it)-neq+1:neq_far(it)) = igreq(1:neq) 
        endif

      end do boucle_jgr

      do it = 1,ntype
        if( neq_far(it) == 0 ) cycle
        n_atom_proto = n_atom_proto + 1
        write(iscratch,*) neq_far(it)
        is = 1
        do i = 1,neq_far(it)
          write(iscratch,*) igreq_far(it,i), posn(:,igreq_far(it,i)), is
        end do
        if( icheck(4) > 0 ) then
          numat_it = numat( abs( itype(igreq_far(it,1)) ) )
          write(3,115) n_atom_proto, numat_it, neq_far(it)
          write(3,125) igreq_far(it,1:neq_far(it))
        endif      
      end do

      deallocate( iabsmm )

      return
  110 format(/' ---- Symsite ------',100('-'))
  115 format(/3x,'ipr =',i3,', Z =',i3,', natomsym =',i6//,'  igr...')
  120 format(/3x,'ipr =',i3,', Z =',i3,', natomsym =',i6//,
     &       '  igr      posx     posy     posz          sym    code')
  125 format(20i6)
  130 format(i5,2x,3f9.5,2x,a11,3x,129i3)
      end

!*********************************************************************

      subroutine inmesh(pos,ngroup)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      real(kind=db) pos(3,ngroup)

      do igr = 1,ngroup
        do k = 1,3
          if( pos(k,igr) > 1._db - eps10 ) then
            m = int( pos(k,igr) + eps10 )
            pos(k,igr) = pos(k,igr) - m
          elseif( pos(k,igr) < - eps10 ) then
            m = 1 - int( pos(k,igr) + eps10 )
            pos(k,igr) = pos(k,igr) + m
          endif
        end do
      end do

      return
      end

!*********************************************************************

      subroutine pop_proto(chargat,chargm,flapw,iabsm,igreq,ipr0,
     &      it0,itype,mpirank,n_atom_proto,n_multi_run,ngreq,ngreqm,
     &      ngroup,nlat,nlatm,nspin,ntype,numat,popatc,popatm,
     &      popats,run_done)

      use declarations
      implicit real(kind=db) (a-h,o-z)
 
      integer, dimension(it0:ntype) :: nlat, numat
      integer, dimension(ngroup):: itype
      integer, dimension(n_multi_run):: iabsm, ngreqm  
      integer, dimension(ipr0:n_atom_proto):: ngreq 
      integer, dimension(ipr0:n_atom_proto,ngroup):: igreq 

      logical flapw
      logical, dimension(n_multi_run):: run_done

      real(kind=db), dimension(ngroup):: chargatg 
      real(kind=db), dimension(it0:ntype):: popatc 
      real(kind=db), dimension(ipr0:n_atom_proto):: chargat 
      real(kind=db), dimension(ipr0:n_atom_proto,nlatm,nspin):: popatm 
      real(kind=db), dimension(ngroup,nlatm,nspin):: popats

      call pop_group(chargatg,chargm,flapw,it0,itype,mpirank,
     &      ngroup,nlat,nlatm,nspin,ntype,numat,popatc,popats)
      
      do ipr = 1,n_atom_proto
        igr = igreq(ipr,1) 
        chargat(ipr) = chargatg(igr)
        do l = 1,nlat(abs(itype(igr)))
          popatm(ipr,l,1:nspin) = popats(igr,l,1:nspin)
        end do
      end do

      boucle_multi: do multi_run = 1,n_multi_run

        boucle_ipr: do ipr = 1,n_atom_proto
          do i = 1,ngreq(ipr)
            if( igreq(ipr,i) == iabsm(multi_run) ) exit boucle_ipr 
          end do
        end do boucle_ipr

        ngreqm(multi_run) = ngreq(ipr)

        do im = 1,multi_run - 1
          do i = 1,ngreq(ipr)
            if( iabsm(im) /= igreq(ipr,i) ) cycle
            run_done(multi_run) = .true.
            cycle boucle_multi
          end do
        end do

      end do boucle_multi

      return
      end

!*********************************************************************

! Sousprogramme elaborant la grille en energie pour le calcul de XANES

      subroutine grille_xanes(eeient,eimag,eimagent,egamme,energ,
     &      lin_gam,ngamme,neimagent,nenerg)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      real(kind=db), dimension(neimagent) :: eeient, eimagent
      real(kind=db), dimension(nenerg) :: energ, eimag
      real(kind=db), dimension(ngamme) :: egamme

      common/icheck/ icheck(24)

! Calcul de la grille en energie.
      energ(1) = egamme(1)

      if( lin_gam == 1 ) then            ! 'rangel'
        def = 10 / rydb
        do ie = 2,nenerg                 
          r = 1 + energ(ie-1) / def
          r = max( r, 0.25_db )
          de = sqrt( r ) * egamme(2)
          energ(ie) = energ(ie-1) + de
        end do
      else
        ngc = 2
        do ie = 2,nenerg
          energ(ie) = energ(ie-1) + egamme(ngc)
          if( energ(ie) >= egamme(ngc+1) - eps10 ) ngc = ngc + 2
        end do
      endif

      eimag(1:nenerg) = 0._db
      if( neimagent > 0 ) then
        do ie = 1,nenerg
          if( energ(ie) >= eeient(neimagent) ) then
            eimag(ie) = eimagent(neimagent)
          elseif( energ(ie) <= eeient(1) ) then
            eimag(ie) = eimagent(1)
          else
            do i = 2,neimagent
              if( eeient(i) >= energ(ie) ) exit
            end do
          p1 = ( energ(ie) - eeient(i-1) ) / ( eeient(i) - eeient(i-1) )
            eimag(ie) = p1 * eimagent(i) + (1 - p1) * eimagent(i-1)
          endif
        end do
      endif

      if( icheck(3) > 1 .and. neimagent > 0 ) then
        write(3,110)
        write(3,120)
        do ie = 1,nenerg
          write(3,130) energ(ie)*rydb, eimag(ie)*rydb
        end do
      endif

      return
  110 format(/' ---- Grille_xanes -',100('-'))
  120 format(/'   energie    eimag      en eV')
  130 format(4f9.3)
      end

!***********************************************************************

      real(kind=db) function extract_v0bdcF(nom_fich_extract)

      use declarations
      implicit real(kind=db) (a-h,o-z)
 
      character(len=132) mot, nom_fich_extract

      open(1, file = nom_fich_extract, status='old', iostat=istat) 
      if( istat /= 0 ) call write_open_error(nom_fich_extract,istat,1)

      do l = 1,1000000
        read(1,'(A)' ) mot
        if( mot(3:7) == 'VmoyF' ) then
          backspace(1)
          read(1,'(9x,f10.3)') v0bdcF
          exit
        elseif( mot(6:10) == 'VmoyF' ) then
          backspace(1)
          read(1,'(12x,f10.3)') v0bdcF
          exit
        endif
      end do

      Close(1)

      extract_v0bdcF = v0bdcF / rydb

      return
      end

!***********************************************************************

      real(kind=db) function extract_Epsii(nom_fich_extract)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      character(len=132) mot, nom_fich_extract

      open(1, file = nom_fich_extract, status='old', iostat=istat) 
      if( istat /= 0 ) call write_open_error(nom_fich_extract,istat,1)

      do l = 1,1000000
        read(1,'(A)' ) mot
        if( mot(3:7) == 'Epsii' ) then
          backspace(1)
          read(1,'(9x,f10.3)') epsii
          exit
        elseif( mot(6:10) == 'Epsii' ) then
          backspace(1)
          read(1,'(12x,f10.3)') epsii
          exit
        endif
      end do

      Close(1)

      extract_Epsii = epsii / rydb

      return
      end

!***********************************************************************

      function extract_green(nom_fich_extract)

      use declarations
      implicit real(kind=db) (a-h,o-z)
 
      character(len=132) mot, nom_fich_extract

      logical green_s, extract_green

      open(1, file = nom_fich_extract, status='old', iostat=istat) 
      if( istat /= 0 ) call write_open_error(nom_fich_extract,istat,1)

      do l = 1,100000
        read(1,'(A)' ) mot
        if( mot(2:20) == 'Multiple scattering' ) then
          green_s = .true.
          exit
        elseif( mot(2:25) == 'Finite difference method' ) then
          green_s = .false.
          exit
        endif
      end do

      Close(1)

      extract_green = green_s

      return
      end

!***********************************************************************

      function extract_E_cut(nom_fich_extract)

      use declarations
      implicit real(kind=db) (a-h,o-z)
 
      character(len=132) mot, nom_fich_extract

      open(1, file = nom_fich_extract, status='old', iostat=istat) 
      if( istat /= 0 ) call write_open_error(nom_fich_extract,istat,1)

      E_cut = -5._db / Rydb

      do l = 1,100000
        read(1,'(A)',err=1005,end=1005) mot
        if( mot(2:6) /= 'E_cut' ) cycle
        backspace(1)
        read(1,'(8x,f11.5)') E_cut
        exit
      end do
 1005 continue

      Close(1)

      extract_E_cut = E_cut / Rydb

      return
      end

!***********************************************************************

      function extract_nenerg(nbseuil,nom_fich_extract)

      use declarations
      implicit real(kind=db) (a-h,o-z)
      character(len=132) mot, nom_fich_extract

      integer extract_nenerg

      open(1, file = nom_fich_extract, status='old', iostat=istat) 
      if( istat /= 0 ) call write_open_error(nom_fich_extract,istat,1)

      is = 0
      nenerg = 0
      boucle_je: do je = 1,100000
        do l = 1,10000
          read(1,'(A)',err=1005,end=1005) mot
          if( mot(7:11) == 'Coabs' ) then
            is = is + 1
            if( is == nbseuil ) then
              nenerg = nenerg + 1
              is = 0
              exit
            endif
          endif
        end do
      end do boucle_je
 1005 continue

      Close(1)

      extract_nenerg = nenerg

      return
      end

!***********************************************************************

      subroutine init_run(chg_val_ref,com,ecrantage,Epsii,
     &    extract,force_ecr,hubb,iabsorbeur,
     &    iabsorig,icom,it0,itabs,itype,lcoeur,lecrantage,
     &    lvval,mpinodes,mpirank,n_multi_run,ncoeur,necrantage,
     &    ngroup,nlat,nlatm,nom_fich_extract,nomfich_s,nomfichbav,
     &    nompsii,nonexc,nrato,nrato_dirac,nrm,nspin,ntype,numat,
     &    nvval,pop_level,popatc,popats,popatv,popexc,
     &    popval,psi_coeur,psii,psi_level,psival,
     &    rato,rchimp,rho_coeur,rhoit,rmt,rmtimp,V_hubbard)
 
      use declarations
      implicit real(kind=db) (a-h,o-z)

      character(len=132) mot, nom_fich_extract, nomfich_s,  
     &           nomfichbav, nomfichnew, nompsii
      character(len=35), dimension(it0:ntype) :: com

      integer, dimension(ngroup):: itype
      integer, dimension(it0:ntype):: icom, nlat, nrato, numat
      integer, dimension(2,it0:ntype):: lcoeur, ncoeur
      integer, dimension(it0:ntype,nlatm):: lvval, nvval

      logical extract, force_ecr, nonexc
      logical, dimension(it0:ntype):: hubb

      real(kind=db), dimension(it0:ntype):: popatc, rchimp, rmt, rmtimp,
     &                                     V_hubbard
      real(kind=db), dimension(nspin):: ecrantage
      real(kind=db), dimension(nnlm,nspin):: popexc
      real(kind=db), dimension(it0:ntype,nlatm):: popatv
      real(kind=db), dimension(ngroup,nlatm,nspin):: popats
      real(kind=db), dimension(it0:ntype,nlatm,nspin):: popval
      real(kind=db), dimension(nrm):: psii
      real(kind=db), dimension(0:nrm,it0:ntype):: rato, rhoit, rho_coeur
      real(kind=db), dimension(0:nrm,nlatm,it0:ntype):: psival
      real(kind=db), dimension(0:nrm,it0:ntype,2):: psi_level
	real(kind=db), dimension(it0:ntype,2):: pop_level
      real(kind=db), dimension(0:nrm,2,it0:ntype):: psi_coeur       

      common/icheck/ icheck(24)

      if( icheck(1) > 0 ) then
        if( n_multi_run > 1 ) then
          l = len_trim(nomfich_s)
          nomfich_s(l+1:l+1) = '_'
          call ad_number(iabsorig,nomfich_s,132)
          write(6,'(3x,A)') nomfich_s
          nomfichnew = nomfich_s
          long = len_trim(nomfich_s)
          nomfichnew(long+1:long+8) = '_bav.txt'
          i = sum( icheck(:) )
          if( i > 0 ) then
            Close(3)
            open(3, file = nomfichnew, status='unknown',iostat=istat)
            if( istat /= 0 ) call write_open_error(nomfichnew,istat,1)
          endif
          open(1, file = nomfichbav, status = 'old' )
          do i = 1,10000
            read(1,'(A)',err=1000,end=1000) mot
            write(3,'(A)') mot
          end do
 1000     Close(1)
        endif
        write(3,110)
        if( extract ) then
          write(3,120) nom_fich_extract
          write(6,120) nom_fich_extract
          write(3,130) Epsii * rydb
        endif
      endif

      call type_work(chg_val_ref,com,ecrantage,force_ecr,hubb,
     &      iabsorbeur,icom,it0,itabs,itype,lcoeur,lecrantage,
     &      lvval,mpinodes,mpirank,ncoeur,necrantage,ngroup,nlat,nlatm,
     &      nompsii,nonexc,nrato,nrato_dirac,nrm,nspin,ntype,numat,
     &      nvval,pop_level,popexc,popatc,popats,popatv,popval,
     &      psi_coeur,psii,psi_level,psival,rato,rchimp,
     &      rho_coeur,rhoit,rmt,rmtimp,V_hubbard)

      return
  110 format(/' ---- Init_run ------',100('-'))
  120 format(/' Tensors extracted from the file :'/,A,/) 
  130 format(/'  Epsii =',f10.3,' eV')
      end

!*********************************************************************

      subroutine type_work(chg_val_ref,com,ecrantage,force_ecr,hubb,
     &      iabsorbeur,icom,it0,itabs,itype,lcoeur,lecrantage,
     &      lvval,mpinodes,mpirank,ncoeur,necrantage,ngroup,nlat,nlatm,
     &      nompsii,nonexc,nrato,nrato_dirac,nrm,nspin,ntype,numat,
     &      nvval,pop_level,popexc,popatc,popats,popatv,popval,
     &      psi_coeur,psii,psi_level,psival,rato,rchimp,
     &      rho_coeur,rhoit,rmt,rmtimp,V_hubbard) 
     
      use declarations
      implicit real(kind=db) (a-h,o-z)
      include 'mpif.h'

      character(len=35), dimension(it0:ntype) :: com
      character(len=132) :: nompsii

      integer, dimension(ngroup):: itype
      integer, dimension(it0:ntype):: icom, nlat, nrato, numat
      integer, dimension(it0:ntype,nlatm):: lvval, nvval
      integer, dimension(2,it0:ntype):: lcoeur, ncoeur
      logical, dimension(it0:ntype):: hubb

      logical force_ecr, nonexc

      real(kind=db), dimension(it0:ntype) :: popatc, rchimp, rmt,
     &                                       rmtimp,V_hubbard
      real(kind=db), dimension(nspin) :: ecrantage
      real(kind=db), dimension(nrm):: psii, psiit, rr
      real(kind=db), dimension(ngroup,nlatm,nspin):: popats
      real(kind=db), dimension(nnlm,nspin):: popexc
      real(kind=db), dimension(it0:ntype,nlatm) :: popatv
      real(kind=db), dimension(it0:ntype,nlatm,nspin):: popval
      real(kind=db), dimension(0:nrm,it0:ntype):: rato, rhoit, rho_coeur
      real(kind=db), dimension(0:nrm,nlatm,it0:ntype):: psival
      real(kind=db), dimension(0:nrm,it0:ntype,2):: psi_level
	real(kind=db), dimension(0:nrm,it0:ntype):: psi_level_val
      real(kind=db), dimension(it0:ntype,2):: pop_level
	real(kind=db), dimension(it0:ntype):: pop_level_val
      real(kind=db), dimension(0:nrm,2,it0:ntype):: psi_coeur       

      common/icheck/ icheck(24)

      itabs = abs( itype(iabsorbeur) )

      if( numat(itabs) == 0 .and. mpirank == 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,110) iabsorbeur
        end do
        stop
      endif

      if( .not. nonexc ) then
        rmt(it0) = rmt(itabs)
        numat(it0) = numat( itabs )
        nlat(it0) = nlat( itabs )
        nvval(it0,:) = nvval(itabs,:)
        ncoeur(:,it0) = ncoeur(:,itabs)
        lcoeur(:,it0) = lcoeur(:,itabs)
        lvval(it0,:) = lvval(itabs,:)
        popval(it0,:,:) = popval(itabs,:,:)
        psi_level(:,it0,1) = psi_level(:,itabs,1)
        pop_level(it0,1) = pop_level(itabs,1)
        com(it0) = com(itabs)
        icom(it0) = icom(itabs)
        rchimp(it0) = rchimp(itabs)
        rmtimp(it0) = rmtimp(itabs)
        hubb(it0) = hubb(itabs)        
        V_hubbard(it0) = V_hubbard(itabs)

        call screendef(ecrantage,force_ecr,it0,itype(iabsorbeur),
     &      lecrantage,lvval,mpirank,necrantage,nlat,nlatm,nspin,
     &      ntype,nvval,popexc,popval,numat(itabs))

        itabs = 0

      endif

! Il faut recalculer cette partie meme en nonexc pour avoir psii.

      if( icom(itabs) == 2 .or. nompsii == 'clementi' ) then

        call clem(itabs,it0,itabs,lvval,mpirank,nlat,nlatm,
     &        nonexc,nr,nrm,ntype,nvval,popatc,popatv,psii,psival,rr,
     &        rhoit,numat(itabs))

      elseif( icom(itabs) == 1 .or. nompsii == 'dirac') then 

        call dirgen(chg_val_ref,itabs,it0,itabs,lcoeur,lvval,mpirank,
     &       ncoeur,nlat,nlatm,nonexc,nr,nrato_dirac,nrm,
     &       nspin,ntype,nvval,pop_level_val,popatc,popatv,popexc,
     &       popval,psi_coeur,
     &       psii,psi_level_val,psival,rr,rho_coeur,rhoit,numat(itabs))

        psi_level(:,:,2) = psi_level_val(:,:)             ! atome excite
        pop_level(:,2) = pop_level_val(:)  
          
! popats pour l'absorbeur        
        do igr = 1,ngroup
          if( abs( itype(igr) ) /= itabs ) cycle
          do l = 1,nlat(itabs)
            do ispin = 1,nspin
              if( itype(igr) > 0 .or. nspin == 1 ) then
                popats(igr,l,ispin) = popval(itabs,l,ispin)
              else
                popats(igr,l,3-ispin) = popval(itabs,l,ispin)
              endif
            end do
          end do
        end do

      elseif( icom(itabs) == 3 .and. nompsii /= 'clementi' 
     &              .and. nompsii /= 'dirac' ) then
        if( mpirank == 0 ) then
          open(8, file = nompsii, status='old', iostat=istat) 
          if( istat /= 0 ) call write_open_error(nompsii,istat,1)
          read(8,*) nr
          do ir = 1,nr
            read(8,*) rr(ir), psii(ir)
          end do
          close(8)
        endif
        if( mpinodes > 1 ) then
          call MPI_Bcast(nr,1,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
          call MPI_Bcast(rr,nrm,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
          call MPI_Bcast(psii,nrm,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
          call MPI_BARRIER(MPI_COMM_WORLD,mpierr)
        endif 
      endif   

! ici on fait les atributions pour l'absorbeur rato(:,0)

      if( icom(itabs) /= 3 ) then
        nrato(itabs) = nr
        rato(0,itabs) = 0._db
        rato(1:nr,itabs) = rr(1:nr)
      endif

      if( icom(itabs) == 3 .and. 
     &     ( nompsii == 'clementi' .or. nompsii == 'dirac' ) ) then
        psiit(1:nr) = psii(1:nr)
! Interpolation pour avoir la fct d'onde initiale de coeur dans les
! rayons FLAPW
        psii(:) = 0._db
        do ir = 1,nrato(itabs)
          do irt = 2,nr
            if( rr(irt) > rato(ir,itabs) ) goto 1040
          end do
          exit
 1040     p1 = ( rato(ir,itabs) -  rr(irt-1) ) / ( rr(irt) - rr(irt-1) )
          p2 = 1 - p1
          psii(ir) = p1*psiit(irt) + p2*psiit(irt-1)
        end do
      endif

      if( icheck(1) > 0 ) then
        write(3,120)
        do it = it0,ntype
          write(3,130) it, com(it), numat(it), ( nvval(it,l), 
     &                 lvval(it,l), popatv(it,l), l = 1,nlat(it))
        end do
         write(3,140) necrantage, lecrantage, 
     &                               ecrantage(1:nspin)
      endif
      if( icheck(1) > 1 ) then
        write(3,150)
        write(3,160) ( rato(ir,itabs)*bohr, psii(ir),
     &                                            ir = 1,nrato(itabs) )
      endif
 
      return
  110 format(//' The absorbing atom cannot be the number',i3,
     &          ' because it is a vaccum sphere !'//)
  120 format(/' Atom type',21x,'Z  n  l  popatv')
  130 format(i3,1x,a25,i3,8(2i3,f6.2))
  140 format(/' Default or imposed orbital screening :',/
     &'      When default is used, if the screening orbital is full,',/
     &'      it is the next one which is filled',/
     &'   n_screening_orbital =',i2,/'   l_screening_orbital =',
     &       i2,/'   Screening =',2f6.3)
  150 format(/' Core wave function after interpolation' )
  160 format(f12.8,f11.7)
      end

!***********************************************************************

! Calcul de la configuration electronique de l'atome excite

      subroutine screendef(ecrantage,force_ecr,it0,itabs,
     &      lecrantage,lvval,mpirank,necrantage,nlat,nlatm,nspin,ntype,
     &      nvval,popexc,popval,Z)

      use declarations
      implicit real(kind=db) (a-h,o-z)
 
      integer Z
      integer, dimension(it0:ntype):: nlat
      integer, dimension(it0:ntype,nlatm):: lvval, nvval

      logical force_ecr

      real(kind=db), dimension(nnlm):: nel, rqn 
      real(kind=db), dimension(it0:ntype,nlatm,nspin):: popval
      real(kind=db), dimension(nspin) :: dp, dpp, ecrantage
      real(kind=db), dimension(nnlm,nspin):: popexc

      common/icheck/ icheck(24)
      common/lseuil/ jseuil, lseuil, nseuil
      common/noexc/ lqnexc(nnlm), n_orbexc, nqnexc(nnlm)

      if( .not. force_ecr ) then
        select case( Z )
          case(1,2,3)
            necrantage = 2
            lecrantage = 0
          case(4,5,6,7,8,9)
            necrantage = 2
            lecrantage = 1
          case(10,11)
            necrantage = 3
            lecrantage = 0
          case(12,13,14,15,16,17)
            necrantage = 3
            lecrantage = 1
          case(18,19,20)
            necrantage = 4
            lecrantage = 0
          case(21,22,23,24,25,26,27,28,29,30)
            necrantage = 3
            lecrantage = 2
          case(31,32,33,34,35)
            necrantage = 4
            lecrantage = 1
          case(36,37,38)
            necrantage = 5
            lecrantage = 0
          case(39,40,41,42,43,44,45,46,47,48)
            necrantage = 4
            lecrantage = 2
          case(49,50,51,52,53)
            necrantage = 5
            lecrantage = 1
          case(54,55,56)
            necrantage = 6
            lecrantage = 0
          case(57,58,59,60,61,62,63,64,65,66,67,68,69,70,71)
            necrantage = 4
            lecrantage = 3
          case(72,73,74,75,76,77,78,79,80)
            necrantage = 5
            lecrantage = 2
          case(81,82,83,84,85)
            necrantage = 6
            lecrantage = 1
          case(86,87,88)
            necrantage = 7
            lecrantage = 0
          case(89,90,91,92,93,94,95,96,97,98,99,100,101)
            necrantage = 5
            lecrantage = 3
        end select
      endif

      irel = 0
      call config(Z,irel,n_coeur,n_orbexc,nqnexc,lqnexc,rqn,nel)

      do ispin = 1,nspin
        popexc(1:n_orbexc,ispin) = nel(1:n_orbexc) / nspin
      end do 
 
      it = abs( itabs )

! On enl�ve l'�lectron de coeur
      do io = 1,n_orbexc
        if( nqnexc(io) /= nseuil .or. lqnexc(io) /= lseuil ) cycle
        do ispin = 1,nspin
          popexc(io,ispin) = popexc(io,ispin) - 1._db / nspin
        end do
        exit 
      end do

! On modifie la configuration electronique, compte tenu des entr�es
      boucle_io: do io = 1,nlat(it)
        do ip = 1,n_orbexc
          if( nqnexc(ip) /= nvval(it,io) 
     &                  .or. lqnexc(ip) /= lvval(it,io)) cycle
          if( itabs < 0 ) then
            do ispin = 1,nspin
              popexc(ip,nspin-ispin+1) = popval(it,io,ispin)
            end do
          else
            popexc(ip,1:nspin) = popval(it,io,1:nspin)
          endif
          cycle boucle_io 
        end do
 ! On doit constuire une orbitale suppl�mentaire
        n_orbexc = n_orbexc + 1     
        if( n_orbexc > nnlm .and. mpirank == 0 ) then
          call write_error
          do ipr = 3,9,3
            write(ipr,103)
          end do
          close(9)
          stop
        endif       
        nqnexc(n_orbexc) = nvval(it,io) 
        lqnexc(n_orbexc) = lvval(it,io) 
        popexc(n_orbexc,1:nspin) = popval(it,io,1:nspin)
      end do boucle_io

! On ajoute l'ecrantage

      if( force_ecr ) then

        do io = 1,n_orbexc
          if( necrantage /= nqnexc(io) .or. lecrantage /= lqnexc(io) )
     &      cycle
          popexc(io,1:nspin) = popexc(io,1:nspin) + ecrantage(1:nspin)
          goto 1010
        end do

        n_orbexc = n_orbexc + 1
        nqnexc(n_orbexc) = necrantage
        lqnexc(n_orbexc) = lecrantage
        popexc(n_orbexc,1:nspin) = ecrantage(1:nspin)

 1010   continue

      else

        dp(1:nspin) = ecrantage(1:nspin)

        boucle_i: do i = 1,2
          do io = 1,n_orbexc
            if( nqnexc(io) < nseuil .or.
     &       ( nqnexc(io) == nseuil .and. lqnexc(io) <= lseuil ) ) cycle

            if( i == 1 .and. ( necrantage /= nqnexc(io) .or.
     &                           lecrantage /= lqnexc(io) ) ) cycle
            if( i == 2 .and. ( necrantage == nqnexc(io) .and.
     &                           lecrantage == lqnexc(io) ) ) cycle

            elmax = ( 2 + 4. * lqnexc(io) ) / nspin
            do ispin = 1,nspin
              dpp(ispin) = min(elmax - popexc(io,ispin), dp(ispin) )
              popexc(io,ispin) = popexc(io,ispin) + dpp(ispin)
              dp(ispin) = dp(ispin) - dpp(ispin)
            end do
            if( sum( dp(:) ) < eps10 ) exit boucle_i
            if( sum( popexc(io,:) ) < nspin * elmax - eps10 ) then
              dpp(1) = min(elmax - popexc(io,1), dp(nspin) )
              dpp(nspin) = min(elmax - popexc(io,nspin), dp(1) )
              popexc(io,:) = popexc(io,:) + dpp(:)
              dp(1) = dp(1) - dpp(nspin)
              dp(nspin) = dp(nspin) - dpp(1)
            endif
            if( sum( dp(:) ) < eps10 ) exit boucle_i
            if( i == 1 ) exit
          end do
        end do boucle_i

        if( dp(1) > eps10 .or. dp(nspin) > eps10 ) then
          nmax = 0
          do io = 1,n_orbexc
            nmax = max(nqnexc(io),nmax)
          end do
          if( nmax == 1 ) then
            iaug = 1
          else
            iaug = 0          
            do io = 1,n_orbexc
              if( nqnexc(io) == nmax .and. lqnexc(io) == 1 ) then
                iaug = 1
                exit
              endif
            end do
          endif          
          n_orbexc = n_orbexc + 1
          if( iaug == 1 ) then
            nqnexc(n_orbexc) = nmax + 1
            lqnexc(n_orbexc) = 0
          else
            nqnexc(n_orbexc) = nmax
            lqnexc(n_orbexc) = 1
          endif
          do ispin = 1,nspin
            if( dp(ispin) > eps10 ) then
              popexc(n_orbexc,ispin) = dp(ispin)
            else
              popexc(n_orbexc,ispin) = 0._db
            endif
          end do
        endif
      endif

      if( icheck(2) > 1 ) then
        write(3,120) 
        do io = 1,n_orbexc
          write(3,130) nqnexc(io), lqnexc(io), popexc(io,1:nspin)
        end do
      endif

      return
  103 format(///'   n_orb < nnlm ',//
     &          ' Increase nnlm in routine of general.f !')
  120 format(/'  n  l popexc')
  130 format(2i3,2f7.3)
      end

!***********************************************************************

      subroutine extract_energ(nbseuil,energ_s,
     &                                        nenerg_s,nom_fich_extract)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      character(len=132) mot, nom_fich_extract

      real(kind=db), dimension(nenerg_s):: energ_s

      common/eseuil/ eseuil(2)

      open(1, file = nom_fich_extract, status='old', iostat=istat) 
      if( istat /= 0 ) call write_open_error(nom_fich_extract,istat,1)

      boucle_ie: do ie = 1,nenerg_s

        boucle_is: do is = 1,nbseuil
          do l = 1,10000
            read(1,'(A)') mot
            if( mot(7:11) == 'Coabs' ) then
              if( is == nbseuil ) exit boucle_is
              exit
            endif
          end do
        end do boucle_is

        do l = 1,100000
          read(1,'(A)') mot
          if( mot(6:10) == 'energ' .or. mot(5:10) == 'Energy' ) then
            read(1,*) energ_s(ie)
            energ_s(ie) = energ_s(ie) / rydb
            cycle boucle_ie
          endif
        end do

      end do boucle_ie

      if( energ_s(nenerg_s) > Eseuil(nbseuil) ) then
        do ie = 1,nenerg_s
          energ_s(ie) = energ_s(ie) - Eseuil(nbseuil)
        end do
      endif

      Close(1)

      return
      end

!***********************************************************************

! Charge et population de chaque atome de la maille

      subroutine pop_group(chargatg,chargm,flapw,it0,itype,mpirank,
     &      ngroup,nlat,nlatm,nspin,ntype,numat,popatc,popats)

      use declarations
      implicit real(kind=db) (a-h,o-z)
      integer, dimension(it0:ntype) :: nlat, numat
      integer, dimension(ngroup):: itype

      logical flapw

      real(kind=db), dimension(ngroup):: chargatg
      real(kind=db), dimension(it0:ntype):: popatc
      real(kind=db), dimension(ngroup,nlatm,nspin):: popats

      common/icheck/ icheck(24)
      common/ichlib/ ichlib
      common/noexc/ lqnexc(nnlm), n_orbexc, nqnexc(nnlm)

      if( icheck(3) > 1 ) write(3,110) 

      if( flapw ) then
        chargatg(:) = 0
        return
      endif
        
      do igr = 1,ngroup
        it = abs( itype(igr) )
        if( nlat(it) > 0 ) then
            chargatg(igr) = numat(it) - popatc(it)
     &                    - sum( popats(igr,1:nlat(it),1:nspin) )
        else
          chargatg(igr) = numat(it) - popatc(it)
        endif
      end do

      if( icheck(3) > 1 ) then
        if( nspin == 1 ) then
          write(3,130)
        else
          write(3,140)
        endif
        do igr = 1,ngroup
          it = abs( itype(igr) )
          write(3,150) igr, chargatg(igr), ( popats(igr,l,1:nspin),
     &                                          l = 1,nlat(it) )
        end do
      endif

! Test sur la neutralite de la maille ou de la molecule
      chargm = sum( chargatg( 1:ngroup ) )
      if( abs(chargm) > 0.0001 .and. mpirank == 0 ) then
        write(3,120) chargm
        write(6,120) chargm
        if( ichlib == 0 ) then
          call write_error
          write(9,120) chargm
          stop
        endif
      endif

      return
  110 format(/' ---- Pop_group ----',100('-'))
  120 format(/' Unit mesh or molecule charge =',f8.4)
  130 format(/'  igr    charge   popats(1)  popats(2)')
  140 format(/'  igr    charge   popats(1,up)  popats(1,dn) ...')
  150 format(i4,11f11.5)
      end

!***********************************************************************

! Construction de la matrice de parametres

      subroutine screening(chargat,chargm,flapw,iabsorbeur,igreq,ipr0,
     &      isymqa,it0,itabs,iprabs,itype,itypepr,lvval,n_atom_proto,
     &      ngreq,ngroup,nlat,nlatm,nonexc,nspin,ntype,numat_abs,
     &      nvval,popatm,popexc)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer, dimension(ngroup):: itype
      integer, dimension(ipr0:n_atom_proto):: itypepr, ngreq
      integer, dimension(ipr0:n_atom_proto,ngroup):: igreq, isymqa 
      integer, dimension(it0:ntype):: nlat
      integer, dimension(it0:ntype,nlatm):: lvval, nvval

      logical flapw, nonexc

      real(kind=db), dimension(ipr0:n_atom_proto):: chargat 
      real(kind=db), dimension(ipr0:n_atom_proto,nlatm,nspin):: popatm 
      real(kind=db), dimension(nnlm,nspin):: popexc

      common/icheck/ icheck(24)
      common/noexc/ lqnexc(nnlm), n_orbexc, nqnexc(nnlm)

      boucle_iprabs: do iprabs = 1,n_atom_proto
        do igrabs = 1,ngreq(iprabs)
          if( igreq(iprabs,igrabs) == iabsorbeur ) exit boucle_iprabs
        end do
      end do boucle_iprabs

      if( flapw .or. nonexc ) then

        do ipr = 1,n_atom_proto
          itypepr(ipr) = abs( itype( igreq(ipr,1) ) )
        end do 
      
      else
        
        itypepr(0) = itabs
        do ipr = 1,n_atom_proto
          itypepr(ipr) = abs( itype( igreq(ipr,1) ) )
        end do 

        igreq(0,1) = igreq(iprabs,igrabs)
        isymqa(0,1) = isymqa(iprabs,igrabs)
        ngreq(0) = 1

        chargat(0) = numat_abs - sum( popexc(1:n_orbexc,1:nspin) ) 

        do io = 1,nlat(itabs)
          do jo = 1,n_orbexc
            if( nvval(itabs,io) /= nqnexc(jo) .or. 
     &                           lvval(itabs,io) /= lqnexc(jo) ) cycle
            popatm(0,io,1:nspin) = popexc(jo,1:nspin)
            exit 
          end do
        end do
 
        chargm = chargm + chargat(0) - chargat(iprabs)

      endif

      if( icheck(3) > 0 ) then
        write(3,120) iprabs
        if( nspin == 1 ) then
          write(3,130)
        else
          write(3,140)
        endif
        do ipr = ipr0,n_atom_proto
          nl = nlat( itypepr(ipr) )
          write(3,150) ipr, itypepr(ipr), chargat(ipr),
     &                       ( popatm(ipr,l,1:nspin), l = 1,nl )
        end do
      endif

      return
  120 format(/' ---- Screening ----',100('-')//,' iprabs =', i3)
  130 format(/'  ipr  it    charge   popatm(1)  popatm(2)')
  140 format(/'  ipr  it    charge   popatm(1,up)  popatm(1,dn) ...')
  150 format(2i4,11f11.5)
      end

!*********************************************************************

! Elaboration de l'agregat (celui qui sert au calcul du potentiel)
! evaluation de la dimension des tableaux  qu'on va utiliser dans
! le sousprogramme agregat

      subroutine natomp_cal(Biology,chargat,d_ecrant,flapw,iabsorbeur,
     &         igreq,ipr0,itabs,itype,matper,mpirank,multrmax,
     &         n_atom_proto,natomeq_s,natomeq_coh,natomp,ngreq,ngroup, 
     &         noncentre,posn,Proto_all,r_self,rsorte_s,rmax,rpotmax,
     &         self_cons)      

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer:: ipr0, itabs, n_atom_proto, mpirank, multrmax,
     &          natomeq_coh, natomeq_s, natomp, ngroup
 
      integer, dimension(ngroup):: itype
      integer, dimension(ipr0:n_atom_proto):: ngreq
      integer, dimension(ipr0:n_atom_proto,ngroup):: igreq 

      logical base_ortho, Biology,flapw, matper, noncentre, Proto_all,
     &        self_cons
      logical, dimension(n_atom_proto):: ipr_ok

      real(kind=db):: r_self, rsorte_s, rmax, rpotmax
      real(kind=db), dimension(3):: ps, v
      real(kind=db), dimension(3,ngroup):: posg, posn
      real(kind=db), dimension(ipr0:n_atom_proto):: chargat 

      common/axyz/ axyz(3), angxyz(3)
      common/base_ortho/ base_ortho
      common/centre/ centre(3)
      common/dcosxyz/ dcosxyz(3)
      common/deccent/ deccent(3)
      common/dpos/ dpos(3)
      common/icheck/ icheck(24)
 
      rad = pi / 180
      dcosxyz(:) = 2 * cos( angxyz(:) * rad )
      if( abs( dcosxyz(1) ) < eps10 .and. abs( dcosxyz(2) ) < eps10
     &    .and. abs( dcosxyz(3) ) < eps10 ) then
        base_ortho = .true.
      else
        base_ortho = .false.
      endif

      if( .not. noncentre ) then
! L'atome absorbeur est mis au centre
        deccent(1:3) = posn(1:3,iabsorbeur) * axyz(1:3)
      else
        deccent(1:3) = centre(1:3) * axyz(1:3)
      endif

      do igr = 1,ngroup
        posg(1:3,igr) = posn(1:3,igr) * axyz(1:3) - deccent(1:3)
      end do

      if( rpotmax > eps4 ) then
        rmax = rpotmax
      else  
        rmax = rsorte_s + multrmax * 2.5 / bohr 
      endif
           
      vaxyz = vnorme( axyz )
      if( vaxyz <= 2 * rmax ) rmax = max( rmax, vaxyz )
        
      if( matper ) then
        nxmaille = nint( rmax / axyz(1) ) + 3
        nymaille = nint( rmax / axyz(2) ) + 3
        nzmaille = nint( rmax / axyz(3) ) + 3
      else
        nxmaille = 0
        nymaille = 0
        nzmaille = 0
      endif

      natomeq_s = 0
      natomeq_coh = 0
      natomp = 0
      ipr_ok(:) = .false.

      do ix = -nxmaille,nxmaille
        v(1) = ix * axyz(1)
        do iy = -nymaille,nymaille
          v(2) = iy * axyz(2)
          do iz = -nzmaille,nzmaille
            v(3) = iz * axyz(3)
            do igr = 1,ngroup
              ps(1:3) = posg(1:3,igr) + v(1:3)
              dist = vnorme(ps) 
              if( dist <= r_self + eps10 ) then
                natomeq_coh = natomeq_coh + 1
                boucle_ipr: do ipr = 1,n_atom_proto
                  do jgr = 1,ngreq(ipr)
                    if( igreq(ipr,jgr) /= igr ) cycle
                    ipr_ok(ipr) = .true.
                    exit boucle_ipr
                  end do 
                end do boucle_ipr
              endif           
              if( dist <= rsorte_s + eps10 ) natomeq_s = natomeq_s + 1 
              if( dist <= rmax + eps10 ) natomp = natomp + 1
            end do
          end do
        end do
      end do

      Proto_all = .true.
      do ipr = 1,n_atom_proto
        if( ipr_ok(ipr) ) cycle
        Proto_all = .false.
        exit
      end do
      
      if( .not. flapw .and. matper ) then
        rsortm = max( r_self, rsorte_s )
        call reduc_natomp(axyz,chargat,d_ecrant,deccent,dpos,
     &             iabsorbeur,icheck(4),igreq,ipr0,itabs,itype,matper,
     &             mpirank,n_atom_proto,natomp,natomr,ngreq,ngroup,
     &             noncentre,posn,rmax,rsortm)
        natomp = natomr
      endif

      if( mpirank == 0 ) then

        if( icheck(4) > 0 ) write(3,110)

! Test sur les atomes trop proches
        if( biology ) then
          dist_min = 1e-06_db
        else
          dist_min = 0.99_db
        endif
        istop = 0
        do igr1 = 1,ngroup
          do igr2 = igr1+1,ngroup
            ps(1:3) = posg(1:3,igr1) - posg(1:3,igr2)
            r = vnorme( ps )
            if( r < dist_min ) then
              if( istop == 0 ) call write_error
              do iprint = 3,9,3
                if( istop == 0 ) write(iprint,120)
                write(iprint,130) igr1, posn(1:3,igr1), igr2,
     &                            posn(1:3,igr2), r*bohr
              end do
              istop = 1
            endif
          end do
        end do
        if( istop == 1 ) then
          do iprint = 3,9,3
            write(iprint,140)
          end do
          stop
        endif

        do ipr = 3,6,3
          if( icheck(4) == 0 .and. ipr == 3 ) cycle
          if( .not. self_cons .or. abs(rsorte_s - r_self) < eps10 ) then 
            write(ipr,150) rsorte_s*bohr, natomeq_s
          else
            write(ipr,160) rsorte_s*bohr, natomeq_s
            if( self_cons ) write(ipr,170) r_self*bohr, natomeq_coh
          endif      
          if( ipr == 3 ) write(ipr,180) rmax*bohr, natomp
        end do
      endif

      return
  110 format(/' ---- Natomp_cal ----',100('-'),/)
  120 format(//' Error in the indata file,',
     &' the following atoms are too close:',/)
  130 format(' Atoms',i5,' at p =',3f7.3,/'   and',i5,' at p =',3f7.3,
     &', distance =',f7.3,' A')
  140 format(/' This can come from:'/
     &2x,'- Two atoms set at the same position,'/,
     &2x,'- Two atoms too close,'/,
     &2x,'- An unsufficient number of digit for the atom position when',
     &    ' it is 1/3, 2/3...'/
     &2x,' One must write them with 10 digits,'/,
     &2x,' for example 0.3333333333 and not 0.3333 !'//)
  150 format(' Cluster radius =',f5.2,' A, nb. of atom =',i4)
  160 format(' Absorption calculation   : cluster radius =',f5.2,
     &       ' A, nb. of atom =',i4)
  170 format(' Fermi energy calculation : cluster radius =',f5.2,
     &       ' A, nb. of atom =',i4)
  180 format(' Potential sup calculation: cluster radius =',f5.2,
     &       ' A, nb. of atom =',i4)
       end

!*********************************************************************

      subroutine reduc_natomp(axyz,chargat,d_ecrant,deccent,dpos,
     &             iabsorbeur,icheck,igreq,ipr0,itabs,itype,matper,
     &             mpirank,n_atom_proto,natomp,natomr,ngreq,ngroup,
     &             noncentre,posn,rmax,rsortm)

      use declarations
      implicit none

      integer:: ia, iaabs, iabsorbeur, icheck, igr, ipr, ipr0, itabs, 
     &          mpirank, n_atom_proto, na, natomp, natomq, natomr,
     &          ngroup
      integer, dimension(natomp):: iaproto, igroup, itypep
      integer, dimension(ngroup):: itype
      integer, dimension(ipr0:n_atom_proto):: ngreq 
      integer, dimension(ipr0:n_atom_proto,ngroup):: igreq 

      logical:: matper, noncentre

      real(kind=db):: ch, ch_min, ch_test, chagreg, chg, d_ecrant,
     &                rmax, rsortm           
      real(kind=db), dimension(3):: axyz, deccent, dpos
      real(kind=db), dimension(natomp):: dista
      real(kind=db), dimension(3,ngroup):: posn
      real(kind=db), dimension(3,natomp):: pos
      real(kind=db), dimension(ipr0:n_atom_proto):: chargat 

      matper = .true.
      call clust(axyz,deccent,dista,dpos,iaabs,iabsorbeur,igroup,
     &                 itabs,itype,itypep,matper,mpirank,natomp,ngroup,
     &                 noncentre,pos,posn,rmax)

      do ia = 1,natomp
        boucle_i: do ipr = 1,n_atom_proto
          do igr = 1,ngreq(ipr)
            if( igroup(ia) == igreq(ipr,igr) ) exit boucle_i
          end do
        end do boucle_i
        iaproto(ia) = ipr
      end do

! Calcul de la charge de l'agregat :
      chagreg = 0._db
      do ia = 1,natomp
        ipr = iaproto(ia)
        chagreg = chagreg + chargat( ipr )
      end do

      if( abs( chagreg ) < eps10 ) then
        natomr = natomp
        return
      endif

      do ia = 1,natomp-1
        if( dista(ia+1) > rsortm ) exit
      end do
      natomq = ia

      na = natomq

      ch = chagreg
      do ia = natomp-1,natomq,-1
        ipr = iaproto(ia+1)
        ch = ch - chargat(ipr)
        if( abs( dista(ia+1) - dista(ia) ) > eps10 ) then
          if( abs( ch - d_ecrant ) > eps10  ) cycle
          na = ia
          chg = ch
          goto 1050
        endif
      end do

      na = natomp
      ch_min = chagreg - d_ecrant
      chg = chagreg
      do ia = natomp-1,natomq,-1
        ipr = iaproto(ia+1)
        chg = chg - chargat(ipr)
        if( abs( dista(ia+1) - dista(ia) ) < eps10 ) cycle
        ch_test = chg - d_ecrant
        if( abs(ch_test) > abs(ch_min) - eps10 ) cycle
        ch_min = ch_test
        na = ia
      end do

 1050 continue

      if( na > natomq .and. na < natomp ) then
        natomr = na
        chagreg = chg
        if( icheck > 0 ) write(3,110) na, dista(na)*bohr
        rmax = dista(natomr) + eps10 
      else
        natomr = natomp        
      endif

      return
  110 format(/' natomp diminished at =',i4,', dista(natomp) =',f11.5)
      end

!*********************************************************************

      subroutine clust(axyz,deccent,dista,dpos,iaabs,iabsorbeur,igroup,
     &                 itab,itype,itypep,matper,mpirank,natomp,ngroup,
     &                 noncentre,pos,posn,rmax)

      use declarations
      implicit none

      integer:: ia, ia1, ia2, iaabs, iabsorbeur, igr, igr12, ipr, itab, 
     &          ity12, ix, iy, iz, mpirank, natomp, ngroup, nxmaille,
     &          nymaille, nzmaille
      integer, dimension(natomp):: igroup, itypep
      integer, dimension(ngroup):: itype

      logical:: noncentre, matper

      real(kind=db):: dist, dist12, rmax, vnorme
      real(kind=db), dimension(3):: axyz, deccent, dpos, ps, v
      real(kind=db), dimension(natomp):: dista
      real(kind=db), dimension(3,ngroup):: posg, posn
      real(kind=db), dimension(3,natomp):: pos

      do igr = 1,ngroup
        posg(1:3,igr) = posn(1:3,igr) * axyz(1:3) - deccent(1:3)
      end do

      if( matper ) then
        nxmaille = nint( rmax / axyz(1) ) + 3
        nymaille = nint( rmax / axyz(2) ) + 3
        nzmaille = nint( rmax / axyz(3) ) + 3
      else
        nxmaille = 0
        nymaille = 0
        nzmaille = 0
      endif

      iaabs = 0
      ia = 0
      do ix = -nxmaille,nxmaille
        v(1) = ix * axyz(1)
        do iy = -nymaille,nymaille
          v(2) = iy * axyz(2)
          do iz = -nzmaille,nzmaille
            v(3) = iz * axyz(3)
            do igr = 1,ngroup
              ps(1:3) = posg(1:3,igr) + v(1:3)
              dist = vnorme(ps)
              if( dist > rmax + eps10 ) cycle
              ia = ia + 1
              pos(1:3,ia) = ps(1:3)
              igroup(ia) = igr
              if( igr == iabsorbeur .and. ix == 0 .and. iy == 0
     &              .and. iz == 0 ) then
                itypep(ia) = itab
                iaabs = ia
              else
                itypep(ia) = abs( itype(igr) )
              endif
            end do
          end do
        end do
      end do

      if( iaabs == 0 .and. mpirank == 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,110)
        end do
        stop
      endif

      if( noncentre ) then
        pos(:,iaabs) = pos(:,iaabs) + dpos(:)
      else
        do ia = 1,natomp
          if( ia /= iaabs ) pos(:,ia) = pos(:,ia) - dpos(:)
        end do
      endif

! Mise en ordre par distance croissante au centre
      do ia = 1,natomp
        v(:) = pos(:,ia)
        dista(ia) = vnorme(v)
      end do
      do ia1 = 1,natomp
        do ia2 = ia1+1,natomp
          if( dista(ia1) < dista(ia2)+eps10 ) cycle
          dist12 = dista(ia1)
          dista(ia1) = dista(ia2)
          dista(ia2) = dist12
          igr12 = igroup(ia1)
          igroup(ia1) = igroup(ia2)
          igroup(ia2) = igr12
          ity12 = itypep(ia1)
          itypep(ia1) = itypep(ia2)
          itypep(ia2) = ity12
          v(:) = pos(:,ia1)
          pos(:,ia1) = pos(:,ia2)
          pos(:,ia2) = v(:)
          if( ia1 == iaabs ) then
            iaabs = ia2
          elseif( ia2 == iaabs ) then
            iaabs = ia1
          endif
        end do
      end do

      return
  110 format(/' There is no absorbing atom in the calculation sphere !')
      end

!*********************************************************************

! Elaboration de l'agregat.

      subroutine agregat(Atom_mag_gr,Atom_nsph,Axe_atom_clu,Axe_atom_gr,
     &      chargat,chargm,dista,flapw,green,hubbard,iaabs,iabsorbeur,
     &      iaproto,iapot,igreq,igroup,igrpt_nomag,ipr0,it0,itab,
     &      itype,itypep,l_val_max,magnetic,matper,mpirank,n_atom_proto,
     &      natomp,nb_rep,nb_sym_op,ngreq,ngroup,nlat,nlatm,
     &      noncentre,non_exc_g,nspin,ntype,numat,popats,pos,
     &      posn,rmax,self_non_exc,spinorbite,Rot_Atom_gr)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      character(len=8) PointGroup, PointGroup_name, 
     &                 PointGroup_nomag_name, PointGroup_Sch,
     &                 PointSubGroup_name, PointSubGroup_Sch
      character(len=5) struct

      complex(kind=db), dimension(nopsm,nrepm):: karact

      integer:: igrpt, igrpt_nomag, igrpt_sg, igrpt_sg_cal
      integer, dimension(natomp):: iaproto, igroup, itypep
      integer, dimension(it0:ntype):: nlat, numat
      integer, dimension(ipr0:n_atom_proto):: iapot, ngreq 
      integer, dimension(ngroup):: itype
      integer, dimension(ipr0:n_atom_proto,ngroup):: igreq 

      logical Atom_mag_cal, Atom_nonsph, base_hexa, base_ortho, flapw,
     &        green, hubbard, magnetic, matper, noncentre, non_exc_g,
     &        PointGroup_Auto, self_non_exc, spinorbite, sym_4,
     &        sym_cubic, symmol
      logical, dimension(ngroup):: Atom_nsph
      logical, dimension(0:ngroup):: Atom_mag_gr

      real(kind=db), dimension(3):: Axe_spin, Axe_spin_0, p, v
      real(kind=db), dimension(3,3):: orthmatt, rot_un, rotmat,
     &                               rot_so, rot_tem, rotspin
      real(kind=db), dimension(natomp):: dista
      real(kind=db), dimension(3,natomp):: Axe_atom_clu, pos
      real(kind=db), dimension(3,ngroup):: Axe_atom_gr, posn
      real(kind=db), dimension(ngroup,nlatm,nspin) :: popats
      real(kind=db), dimension(ipr0:n_atom_proto):: chargat 
      real(kind=db), dimension(3,3,ngroup):: Rot_Atom_gr

      common/Atom_nonsph/ Atom_nonsph
      common/axyz/ axyz(3), angxyz(3)
      common/base_hexa/ base_hexa
      common/base_ortho/ base_ortho
      common/centre/ centre(3)
      common/cubmat/ cubmat(3,3), cubmati(3,3)
      common/dcosxyz/ dcosxyz(3)
      common/deccent/ deccent(3)
      common/dpos/ dpos(3)
      common/icheck/ icheck(24)
      common/igrpt0/ igrpt0
      common/iopsymc/ iopsymc(nopsm)
      common/iopsymr/ iopsymr(nopsm)
      common/karact/ karact
      common/orthmat/ orthmat(3,3), orthmati(3,3)
      common/PointGroup/ PointGroup
      common/PointGroup_Auto/ PointGroup_Auto
      common/PointGroup_name/ PointGroup_name, PointGroup_nomag_name
      common/PointGroup_Sch/ PointGroup_Sch
      common/PointSubGroup_name/ PointSubGroup_name, PointSubGroup_Sch
      common/rot_int/ rot_int(3,3)
      common/struct/ struct
      common/sym_cubic/ sym_4, sym_cubic
      common/symmol/ symmol
      common/vsphere/ vsphere

      if( icheck(4) > 0 ) write(3,110)

      rad = pi / 180
      dcosxyz(:) = 2 * cos( angxyz(:) * rad )
      if( abs( dcosxyz(1) ) < eps10 .and. abs( dcosxyz(2) ) < eps10
     &    .and. abs( dcosxyz(3) ) < eps10 ) then
        base_ortho = .true.
      else
        base_ortho = .false.
      endif

      call clust(axyz,deccent,dista,dpos,iaabs,iabsorbeur,igroup,
     &                 itab,itype,itypep,matper,mpirank,natomp,ngroup,
     &                 noncentre,pos,posn,rmax)

      if( icheck(4) > 0 ) write(3,130) iaabs

      call cal_iaeqrmt(iaabs,iaproto,iapot,igreq,igroup,ipr0,
     &         n_atom_proto,natomp,ngreq,ngroup,non_exc_g,self_non_exc)

      if( magnetic .or. Atom_nonsph ) then
        do igr = 1,ngroup
          v(:) = Axe_atom_gr(:,igr) * axyz(:)
          do ia = 1,natomp
            if( igroup(ia) == igr ) Axe_atom_clu(:,ia) = v(:)
          end do
        end do
      else
        Axe_atom_clu(:,:) = 0._db
      endif

! On passe en repere orthogonal
      if( struct /= 'cubic' ) then
        do ia = 1,natomp
          v(:) = pos(:,ia)
          do k = 1,3
            pos(k,ia) = sum( cubmat(k,1:3) * v(1:3) )
          end do
        end do
        if( magnetic .or. Atom_nonsph ) then
          do ia = 1,natomp
            v(:) = Axe_atom_clu(:,ia)
            do k = 1,3
              Axe_atom_clu(k,ia) = sum( cubmat(k,1:3) * v(1:3) )
            end do
          end do
        endif
        dcosxyz(:) = 0._db
        base_ortho = .true.
      endif

      orthmatt = 0._db
      do k = 1,3
        orthmatt(k,k) = axyz(k)
      end do
      orthmatt = matmul( cubmat, orthmatt )

      orthmat = orthmatt

      rot_un = 0._db
      do i = 1,3
        rot_un(i,i) = 1._db
      end do
      rotspin(:,:) = rot_un(:,:)
      rotmat(:,:) = rot_un(:,:)

      Axe_spin(:) = 0._db
      Atom_mag_gr(0) = .false.
      if( magnetic .or. Atom_nonsph ) then
        do ia = 1,natomp
          igr = igroup(ia)
          if( dista(ia) > eps10 .or. ( .not. Atom_mag_gr(igr)
     &                           .and. .not. Atom_nsph(igr) ) ) cycle
          if( magnetic ) Atom_mag_gr(0) = .true.
          Axe_spin(:) = Axe_atom_clu(:,ia)
          rotspin(:,:) = Rot_Atom_gr(:,:,igr)
          rotspin = transpose( rotspin )
          exit
        end do
      endif

! Rotation de la base interne en cas d'axe de spin n'etant pas selon Oz
      if( Atom_mag_gr(0) .or. Atom_nonsph ) then

        orthmat = matmul( rotspin, orthmat )

        do ia = 1,natomp
          v(:) = pos(:,ia)
          v = matmul( rotspin, v )
          pos(:,ia) = v(:)
        end do

        do ia = 1,natomp
          v(:) = Axe_atom_clu(:,ia)
          v = matmul( rotspin, v )
          Axe_atom_clu(:,ia) = v(:)
        end do

        Axe_spin = matmul( rotspin, Axe_spin )
 
      endif

! Determination des symetries du groupe ponctuel (iopsymc)
 
      if( PointGroup_Auto ) then

        if( spinorbite) then
          rot_so = rot_un
          Axe_spin_0 = Axe_spin
        endif
 
        do i = 1,2

          call sym_cluster(Atom_mag_gr,Atom_nsph,Axe_atom_clu,iaabs,
     &               igroup,iopsymc,it0,itype,itypep,natomp,
     &               ngroup,nlat,nlatm,nspin,ntype,numat,popats,pos)

          call cluster_rot(iopsymc,rot_tem)

          if( sum( abs( rot_tem(:,:) - rot_un(:,:) ) ) < eps10  ) exit

! En cas de spin-orbite, on n'utilise pas la symetrie pour l'instant.
! A corriger plus tard...

          orthmat = matmul( rot_tem, orthmat )
          rotmat = matmul( rot_tem, rotmat )

          do ia = 1,natomp
            v(:) = pos(:,ia)
            v = matmul( rot_tem, v )
            pos(:,ia) = v(:)
          end do
          if( magnetic .or. Atom_nonsph ) then
            do ia = 1,natomp
              v(:) = Axe_atom_clu(:,ia)
              v = matmul( rot_tem, v )
              Axe_atom_clu(:,ia) = v(:)
            end do
            Axe_spin = matmul( rot_tem, Axe_spin )
          endif
          if( spinorbite .and.
     &      sum( abs( axe_spin(:) - axe_spin_0(:) ) ) > eps10 )
     &      rot_so = matmul( rot_so, transpose(rot_tem) )

        end do

        call sym_cluster(Atom_mag_gr,Atom_nsph,Axe_atom_clu,iaabs,
     &              igroup,iopsymc,it0,itype,itypep,
     &              natomp,ngroup,
     &              nlat,nlatm,nspin,ntype,numat,popats,pos)

        call numgrpt(iopsymc,igrpt,igrpt_nomag,mpirank)

        if( spinorbite) then
          orthmat = matmul( rot_so, orthmat )
          rotmat = matmul( rot_so, rotmat )

          do ia = 1,natomp
            v(:) = pos(:,ia)
            v = matmul( rot_so, v )
            pos(:,ia) = v(:)
          end do
          if( magnetic .or. Atom_nonsph ) then
            do ia = 1,natomp
              v(:) = Axe_atom_clu(:,ia)
              v = matmul( rot_so, v )
              Axe_atom_clu(:,ia) = v(:)
            end do
            Axe_spin = matmul( rot_so, Axe_spin )
          endif
          call sym_cluster(Atom_mag_gr,Atom_nsph,Axe_atom_clu,iaabs,
     &              igroup,iopsymc,it0,itype,itypep,
     &              natomp,ngroup,
     &              nlat,nlatm,nspin,ntype,numat,popats,pos)
        endif

      else

        call grp_opsym_imp(iopsymc,igrpt,igrpt_nomag,mpirank)

      endif

! iopsymc est la symetrie vraie.
! iopsymr est la symetrie correspondant utilisee pour le calcul de la stucture
! electronique. Il correspond au sous-groupe pour lequel les
! representations a calculer sont unidimensionnelles.

      if( icheck(4) > 0 ) then
        npr1 = 3
      else
        npr1 = 6
      endif

      if( mpirank == 0 ) then
        do ipr = npr1,6,3      
          if( igrpt > 32 ) then      
            write(ipr,140) PointGroup_name, igrpt
            write(ipr,150) PointGroup_nomag_name, PointGroup_Sch 
            if( PointGroup_Auto ) write(ipr,160) PointSubgroup_name,
     &                                           PointSubgroup_Sch 
          else
            write(ipr,170) PointGroup_name, PointGroup_Sch 
          endif
        end do
        if( icheck(4) > 0 ) then
          write(3,175)
          call write_iopsym(iopsymc,3)
        endif
      endif

! On prend un sous-groupe.
      sym_cubic = .false.
      sym_4 = .false.
      if( PointGroup_Auto ) then
        igrpt_sg = igrpt_sg_cal(green,igrpt,igrpt_nomag,l_val_max)
      else
        igrpt_sg = igrpt
      endif
      if( green .and. spinorbite ) igrpt_sg = 1

      if( igrpt_sg /= 1 ) then
        if( igrpt_nomag > 27 ) then
          sym_cubic = .true.
        elseif( igrpt_nomag >= 12 .and. igrpt_nomag <= 15 ) then
          sym_4 = .true.
        endif
      endif  

      if( igrpt_sg /= igrpt_nomag ) then 
        PointGroup = 'SousGr'
        igrpt_nomag = igrpt_sg
        iopsymr(:) = iopsymc(:)
        call grp_opsym_imp(iopsymr,igrpt,igrpt_nomag,mpirank)
        ired = 1
      else
        iopsymr(:) = iopsymc(:)
        ired = 0
      endif
      if( spinorbite ) then
        igrpt_sg = igrpt_sg_so(igrpt)
        if( igrpt_sg /= igrpt_nomag ) then 
          PointGroup = 'SousGr'
          igrpt_nomag = igrpt_sg
          iopsymr(:) = iopsymc(:)
          call grp_opsym_imp(iopsymr,igrpt,igrpt_nomag,mpirank)
          ired = 1
        endif
      endif
      if( hubbard ) then
        igrpt_sg = igrpt_sg_cmp(igrpt)
        if( igrpt_sg /= igrpt_nomag ) then 
          PointGroup = 'SousGr'
          igrpt_nomag = igrpt_sg
          iopsymr(:) = iopsymc(:)
          call grp_opsym_imp(iopsymr,igrpt,igrpt_nomag,mpirank)
          ired = 1
        endif
      endif

      Atom_mag_gr(0) = Atom_mag_cal(igrpt)

! igrpt0 est transporte dans la routine point_group_atom 
      igrpt0 = igrpt

      if( ired == 1 .and. mpirank == 0 ) then 
        do ipr = npr1,6,3      
          if( igrpt > 32 ) then      
            write(ipr,180) PointGroup_name, igrpt
            write(ipr,150) PointGroup_nomag_name, PointGroup_Sch 
            if( PointGroup_Auto ) write(ipr,160) PointSubgroup_name,
     &                                           PointSubgroup_Sch 
          else
            write(ipr,182) Pointgroup_name, Pointgroup_Sch 
          endif
        end do
        if( icheck(4) > 0 ) then
          write(3,183)
          call write_iopsym(iopsymr,3)
        endif
      endif

      call character_table(igrpt_nomag,nb_rep)

      call invermat(orthmat,orthmati)

      rotmat = matmul( rotmat, rotspin )
      call invermat(rotmat,rot_int)

! Nombre d'operations de symetrie du groupe utilise.
      nb_sym_op = sum( abs( iopsymr(:) ) )

      if( icheck(4) > 0 ) then
        write(3,185)
        write(3,187)
        write(3,200) ( orthmatt(i,1:3), i = 1,3 )
        write(3,190)
        write(3,200) ( cubmat(i,1:3), i = 1,3 )
        write(3,202)
        write(3,200) ( rotmat(i,1:3), i = 1,3 )
        write(3,203)
        write(3,200) ( rot_int(i,1:3), i = 1,3 )
        write(3,206)
        write(3,200) ( orthmat(i,1:3), i = 1,3 )
        write(3,207)
        write(3,200) ( orthmati(i,1:3), i = 1,3 )
        write(3,210)
        do ia = 1,natomp
          ipr = iaproto(ia)
          it = itypep(ia)
          write(3,220) numat(it), pos(:,ia)*bohr, dista(ia)*bohr, ia,  
     &                 igroup(ia), it, ipr, chargat( ipr )
        end do
        write(3,230)
        do ipr = ipr0,n_atom_proto
          write(3,240) ipr, iapot(ipr)
        end do

! Angle des liasons autour de l'absorbeur
        write(3,'(/A)') ' ia ib Za Zb   Angle(a,O,b)'
        rad = 180 / pi
        Dist_max = 2.5_db / bohr
        do ia = 2,natomp
          if( dista(ia) > Dist_max ) exit
          do ib = ia + 1, natomp
            if( dista(ib) > Dist_max ) exit
            Prod = sum( pos(:,ia) * pos(:,ib) ) 
     &           / ( dista(ia) * dista(ib) )
            if( Prod < -1._db + eps10 ) then
              Angle = 180._db
            elseif( Prod > 1._db - eps10 ) then 
              Angle = 0._db
            else
              Angle = rad * acos( Prod )
            endif
            write(3,250) ia, ib, numat(itypep(ia)), numat(itypep(ib)),
     &                   Angle
          end do
        end do
      endif

      p(1:3) = pos(1:3,iaabs)
      if( vnorme( p ) > epspos ) then
        noncentre = .true.
      else
        noncentre = .false.
      endif

! En cas d'axe 3, maillage hexagonal. 
      if( abs(iopsymc(49)) == 1 .or. abs(iopsymc(53)) == 1 ) then
        base_hexa = .true.
      else
        base_hexa = .false.
      endif

! Calcul de la charge de l'agregat :
      if( .not. flapw .and. matper ) then
        chagreg = 0._db
        do ia = 1,natomp
          ipr = iaproto(ia)
          chagreg = chagreg + chargat( ipr )
        end do
! On met une charge opposee sur la sphere a dista(natomp) du centre
        if( natomp > 1 ) then
          vsphere = 2 * ( chagreg - chargm ) / dista(natomp)
        else
          vsphere = 0._db
        endif
        if( icheck(4) > 0 ) write(3,260) chagreg, vsphere * rydb
      else
        vsphere = 0._db
      endif

      return
  110 format(/' ---- Agregat ------',100('-'))
  130 format(/' Index of the absorbing atom, iaabs =',i3)
  140 format(/' Point group : ',a8,'     number =',i3)
  150 format(
     & '   Non magnetic corresponding point group   : ',a8,' (',a5,')')
  160 format(
     & '   Subgroup not multiplied by time reversal : ',a8,' (',a5,')')
  170 format(/' Point group : ',a8,' (',a5,')')
  175 format(/' iopsymc =')
  180 format(/' Point group used : ',a8,'     number =',i3)
  182 format(/' Point group used : ',a8,' (',a5,')')
  183 format(/' iopsymr =')
  185 format(/' Transformation matrices :',/
     &'    R1 : internal orthonormal bases with z along c,',
     &' x along b x c',/
     &'         but for trigonal symmetry where z is along the',
     &' hexagonal axis,',
     &/'         used for the tensorial expansion.',/
     &'    R2 : internal orthonormal bases used for the electronic',
     &' structure calculation') 
  187 format(/' Transformation Crystal Bases - Bases R1 :')
  190 format(/' Transformation Crystal Normalized Bases - Bases R1 :')
  200 format(3x,3f9.5)
  202 format(/' Rotation Bases R1 - Bases R2 :')
  203 format(/' Inverse matrix :')
  206 format(/' Transformation Crystal Bases - Bases R2 :')
  207 format(/' Inverse matrix :')
  210 format(/' Atom positions in order, in the internal R2 bases',/
     & '   Z      posx       posy       posz          dista  ',
     & '  ia   igr ity ipr  chargat')
  220 format(i4,3f11.6,'   ! ',f11.6,i4,i6,2i4,f9.5)
  230 format(/' ipr   iapot')
  240 format(i4,i6)
  250 format(4i3,f13.3) 
  260 format(/' Cluster charge =',f11.5,'  Vsphere =',f11.5,' eV')
      end

! **********************************************************************

! Determination du sous groupe ayant toutes les representations utiles 
! de dimension 1.

! En cas de green on prend dans certains cas une symetrie plus basse
! a cause d'une erreur non trouvee dans la symetrisation (peut-etre
! calcul de Cmat dans la routine mat).

      integer function igrpt_sg_cal(green,igrpt,igrpt_nomag,l_val_max)

      implicit none

      integer:: igrpt, igrpt_nomag, igrpt_sg, l_val_max

      logical green

      igrpt_sg = igrpt_nomag

      select case(igrpt_nomag)
        case(12)
          igrpt_sg = 6
        case(13,14,28)
          igrpt_sg = 7
        case(15,29)
          if( igrpt /= igrpt_nomag ) then
            igrpt_sg = 11
          else
            igrpt_sg = 8
          endif
        case(18,19)
          igrpt_sg = 16
        case(20)
          igrpt_sg = 17
        case(24)
          igrpt_sg = 21
        case(25,26)
          igrpt_sg = 22
        case(27)
          igrpt_sg = 23
        case(30)
          if( l_val_max > 2 .or. green ) then
!          if( l_val_max > 2 ) then
            igrpt_sg = 7   ! D2
          else
            igrpt_sg = 13  ! D2d
          endif
        case(31)
          if( l_val_max > 2 .or. green ) then
!          if( l_val_max > 2 ) then
            igrpt_sg = 7   ! D2
          else
            igrpt_sg = 14  ! D4
          endif
        case(32)
          if( l_val_max > 2 .or. green ) then
!          if( l_val_max > 2 ) then
            igrpt_sg = 8   ! D2h
          else
            igrpt_sg = 15  ! D4h
          endif
      end select

      igrpt_sg_cal = igrpt_sg

      return
      end

!*********************************************************************

      subroutine write_iopsym(iopsym,ipr)

      use declarations

      character(len=9):: mot9, nomsym
      character(len=42):: mot

      integer, dimension(nopsm):: iopsym

      i1 = 1
      do ligne = 1,20
        select case(ligne)
          case(1,9)
            ni = 1
          case(4,5,6,7,8,10,11,14,15,16)
            ni = 3
          case(2,3,12,13,17,18,19,20)
            ni = 4
        end select
        i2 = i1 + ni - 1
        mot = ' '
        do i = i1,i2
          l = len_trim(mot)
          l = l + 1
          mot9 = adjustl( nomsym(i) ) 
          ln = len_trim( mot9 )
          mot(l+1:l+ln) = mot9(1:ln)
          if( i < i2 ) mot(l+ln+1:l+ln+1) = ','
        end do
        write(ipr,110) adjustr(mot),iopsym(i1:i2)
        i1 = i2 + 1  
      end do

      return
  110 format(a,' : ',8i2)
      end

!*********************************************************************

      real(kind=db) function vnorme(v)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      logical base_ortho
      real(kind=db), dimension(3):: v

      common/base_ortho/ base_ortho
      common/dcosxyz/ dcosxyz(3)

      if( base_ortho ) then
        vnorme = sqrt( sum( v(:)**2 ) )
      else
        vnorme = sqrt( sum( v(:)**2 ) + v(1)*v(2)*dcosxyz(3)
     &              + v(1)*v(3)*dcosxyz(2) + v(2)*v(3)*dcosxyz(1) )
      endif

      return
      end

!*********************************************************************

! Sous-programme calculant la rotation a effectuer pour se ramener
! a un groupe ponctuel standard.

      subroutine cluster_rot(iopsym,rotmat)

      use declarations
      implicit real(kind=db) (a-h,o-z)
 
      integer, dimension(nopsm):: iops, iopsym

      real(kind=db), dimension(3):: k, v, w, x
      real(kind=db), dimension(3,3):: rotmat

      iops(:) = abs( iopsym(:) )

      rotmat(:,:) = 0._db
      rotmat(1,1) = 1._db; rotmat(2,2) = 1._db; rotmat(3,3) = 1._db;

      n_opsym_3 = sum( iops(2:9) )
      if( n_opsym_3 == 8 ) return

      r2 = 1 / sqrt( 2._db ) 
      v(:) = 0._db
      k(1) = 0._db; k(2) = 0._db; k(3) = 1._db
 
      n_opsym_2 = sum( iops(10:15) ) + sum( iops(22:24) ) 
     &          + sum( iops(58:64:2) )
      if( n_opsym_2 == 1 ) then
        do i = 10,15
          if( iops(i) == 1 ) i2 = i
        end do
        do i = 22,24
          if( iops(i) == 1 ) i2 = i
        end do
        do i = 58,64,2
          if( iops(i) == 1 ) i2 = i
        end do
      else
        i2 = 0
      endif  

      n_opsym_s = sum( iops(40:48) ) + sum( iops(57:63:2) ) 
      if( n_opsym_s == 1 ) then
        do i = 40,48
          if( iops(i) == 1 ) is = i
        end do
        do i = 57,63,2
          if( iops(i) == 1 ) is = i
        end do
      else
        is = 0
      endif  

      if( n_opsym_2 == 1 .or. n_opsym_s == 1 ) then

        if( i2 == 10 .or. is == 48 ) then
          v(1) = 1._db; v(2) = 1._db; v(3) = 0._db
        elseif( i2 == 11 .or. is == 45 ) then
          v(1) = -1._db; v(2) = 1._db; v(3) = 0._db
        elseif( i2 == 12 .or. is == 47 ) then
          v(1) = 1._db; v(2) = 0._db; v(3) = 1._db
        elseif( i2 == 13 .or. is == 44 ) then
          v(1) = -1._db; v(2) = 0._db; v(3) = 1._db
        elseif( i2 == 14 .or. is == 46 ) then
          v(1) = 0._db; v(2) = 1._db; v(3) = 1._db
        elseif( i2 == 15 .or. is == 43 ) then
          v(1) = 0._db; v(2) = -1._db; v(3) = 1._db
        elseif( i2 == 22 .or. is == 40 )then
          v(1) = 1._db; v(2) =  0._db; v(3) = 0._db
        elseif( i2 == 23 .or. is == 41 )then
          v(1) = 0._db; v(2) =  1._db; v(3) = 0._db
        elseif( i2 == 58 .or. is == 61 ) then
          v(1) = 0.866025403784439_db; v(2) = 0.5_db; v(3) = 0._db
        elseif( i2 == 60 .or. is == 63 ) then
          v(1) = 0.5_db; v(2) = 0.866025403784439_db; v(3) = 0._db
        elseif( i2 == 62 .or. is == 57 ) then
          v(1) = -0.5_db; v(2) = 0.866025403784439_db; v(3) = 0._db
        elseif( i2 == 64 .or. is == 59 ) then
          v(1) = -0.866025403784439_db; v(2) = 0.5_db; v(3) = 0._db
        endif

! Axes 4 horizontaux
      elseif( ( iops(18) == 0 .and. iops(28) == 0 ) .and. 
     &        ( iops(16) == 1 .or. iops(26) == 1 ) ) then
        v(1) = 1._db; v(2) =  0._db; v(3) = 0._db

      elseif( ( iops(18) == 0 .and. iops(28) == 0 ) .and. 
     &        ( iops(17) == 1 .or. iops(27) == 1 ) ) then
        v(1) = 0._db; v(2) =  1._db; v(3) = 0._db

! Abaissement depuis cubique
      elseif( iops(24) == 0 .and.
     &      ( iops(2) == 1 .or. iops(32) == 1 ) ) then
        v(1) = 1._db; v(2) = 1._db; v(3) = 1._db

      elseif( iops(24) == 0 .and.
     &      ( iops(4) == 1 .or. iops(34) == 1 ) ) then
        v(1) = 1._db; v(2) = -1._db; v(3) = 1._db

      elseif( iops(24) == 0 .and.
     &      ( iops(6) == 1 .or. iops(36) == 1 ) ) then
        v(1) = -1._db; v(2) = 1._db; v(3) = 1._db

      elseif( iops(24) == 0 .and.
     &      ( iops(8) == 1 .or. iops(38) == 1 ) ) then
        v(1) = 1._db; v(2) = 1._db; v(3) = -1._db

! Autour de Ox
      elseif( ( ( iops(41) == 0 . and. iops(42) == 0 ) 
     & .and. ( iops(43) == 1 .or. iops(46) == 1 ) ) .or.
     &    ( ( iops(23) == 0 . and. iops(24) == 0 ) .and.
     &     ( iops(14) == 1 .or. iops(15) == 1 ) ) ) then
          v(1) = 0._db; v(2) = 1._db; v(3) = 1._db

! Autour de Oy
      elseif( ( ( iops(42) == 0 . and. iops(40) == 0 ) 
     & .and. ( iops(44) == 1 .or. iops(47) == 1 ) ) .or.
     &    ( ( iops(22) == 0 . and. iops(24) == 0 ) .and.
     &     ( iops(12) == 1 .or. iops(13) == 1 ) ) ) then
          v(1) = 1._db; v(2) = 0._db; v(3) = 1._db

      endif

      vn = sqrt( sum(v(:)**2) )

      if( vn > eps10 ) then
      
        v(:) = v(:) / vn
        call prodvec(w,v,k)
        wn = sqrt( sum(w(:)**2) )
        w(:) = w(:) / wn
        call prodvec(x,v,w)
        rotmat(1,:) = w(:)
        rotmat(2,:) = x(:)
        rotmat(3,:) = v(:)

! Rotations autour de Oz

! Rotation de + 45 degres en cas D2d ou D2h
      elseif( iops(49) == 0 .and. iops(2) == 0 .and.
     &          ( ( iops(40) == 1 .and. iops(41) == 1 .and.  
     &              iops(45) == 0 .and. iops(48) == 0 .and.  
     &              iops(22) == 0 .and. iops(23) == 0 .and.  
     &              iops(10) == 1 .and. iops(11) == 1  ) .or.
     &            ( iops(40) == 0 .and. iops(41) == 0 .and.
     &              iops(22) == 0 .and. iops(23) == 0 .and.
     &            ( iops(45) == 1 .or. iops(48) == 1 .or. 
     &              iops(10) == 1 .or. iops(11) == 1 ) ) ) ) then
        rotmat(1,1) =   r2;  rotmat(1,2) =   r2; rotmat(1,3) = 0._db
        rotmat(2,1) =  -r2;  rotmat(2,2) =   r2; rotmat(2,3) = 0._db
        rotmat(3,1) = 0._db;  rotmat(3,2) = 0._db; rotmat(3,3) = 1._db

! Rotation de 30 degres en cas d'axe 3 selon Oz
      elseif( ( iops(58) == 1 .and. iops(22) == 0 .and. 
     &          iops(57) == 0 ) .or.
     &    ( iops(49) == 1 .and. iops(41) == 1 .and. iops(22) == 1 .and.
     &      iops(57) == 0 .and. iops(58) == 0 ) .or.
     &    ( iops(57) == 0 .and. iops(61) == 0 .and. 
     &      iops(59) == 1 .and. iops(63) == 1 ) .or.
     &    ( iops(58) == 0 .and. iops(62) == 0 .and. 
     &      iops(60) == 1 .and. iops(64) == 1 ) ) then

        cs = cos( pi / 6 )
        sn = sin( pi / 6 )
        rotmat(1,1) =   cs;  rotmat(1,2) =  -sn; rotmat(1,3) = 0._db
        rotmat(2,1) =   sn;  rotmat(2,2) =   cs; rotmat(2,3) = 0._db
        rotmat(3,1) = 0._db;  rotmat(3,2) = 0._db; rotmat(3,3) = 1._db

      elseif( ( iops(58) == 1 .and. iops(62) == 1 .and. 
     &          iops(60) == 0 .and. iops(64) == 1 ) .or.
     &        ( iops(57) == 1 .and. iops(61) == 1 .and. 
     &          iops(59) == 0 .and. iops(63) == 0 ) ) then

        cs = cos( pi / 6 )
        sn = - sin( pi / 6 )
        rotmat(1,1) =   cs;  rotmat(1,2) =  -sn; rotmat(1,3) = 0._db
        rotmat(2,1) =   sn;  rotmat(2,2) =   cs; rotmat(2,3) = 0._db
        rotmat(3,1) = 0._db;  rotmat(3,2) = 0._db; rotmat(3,3) = 1._db

      elseif( n_opsym_s == 3 .and. iops(49) == 1 .and. iops(59) == 1)
     &        then

        cs = cos( pi / 6 )
        sn = sin( pi / 6 )
        rotmat(1,1) =   cs;  rotmat(1,2) =  -sn; rotmat(1,3) = 0._db
        rotmat(2,1) =   sn;  rotmat(2,2) =   cs; rotmat(2,3) = 0._db
        rotmat(3,1) = 0._db;  rotmat(3,2) = 0._db; rotmat(3,3) = 1._db

      endif     

      return
      end

!***********************************************************************

! Sous-programme calculant la symetrie ponctuelle de l'agregat

      subroutine sym_cluster(Atom_mag_gr,Atom_nsph,Axe_atom_clu,iaabs,
     &              igroup,iopsym,it0,itype,itypep,natomp,
     &              ngroup,nlat,nlatm,nspin,ntype,numat,popats,pos)

      use declarations
      implicit real(kind=db) (a-h,o-z)
 
      integer, dimension(natomp):: igroup, itypep
      integer, dimension(ngroup):: itype
      integer, dimension(it0:ntype):: itequ, nlat, numat
      integer, dimension(ngroup):: itypegen  
      integer, dimension(nopsm):: iopsym  

      logical::symmol
      logical, dimension(ngroup):: Atom_nsph
      logical, dimension(0:ngroup):: Atom_mag_gr

      real(kind=db), dimension(3):: Axe_atom_c, Axe_atom_s, ps, pt, 
     &                             vspin, vspini, wspin, wspini
      real(kind=db), dimension(3,3):: matopsym
      real(kind=db), dimension(ngroup,nlatm,nspin) :: popats
      real(kind=db), dimension(3,natomp):: Axe_atom_clu, pos

      common/symmol/ symmol

      do it = it0,ntype
        itequ(it) = it
      end do
      
      do ita = it0,ntype
        na = numat(ita)
        nla = nlat(ita) 
        do igra = 1,ngroup
          if( abs(itype(igra)) == ita ) exit 
        end do
        if( igra > ngroup ) cycle
        do itb = ita+1,ntype
          if( itequ(itb) /= itb ) cycle
          nb = numat(itb)
          if( nb /= na ) cycle
          nlb = nlat(itb) 
          if( nlb /= nla ) cycle
          do igrb = 1,ngroup
            if( abs(itype(igrb)) == itb ) exit 
          end do
          if( igrb > ngroup ) cycle

          dpop = 0._db
          do io = 1,nlb
            do isp = 1,nspin
              dpop = dpop
     &             + abs( popats(igra,io,isp) - popats(igrb,io,isp) )
            end do
          end do
          if( dpop < eps6 ) then
            itequ(itb) = ita
          elseif( nspin > 1 ) then
            dpop = 0._db
            do io = 1,nlb
              do isp = 1,nspin
                dpop = dpop + abs( popats(igra,io,isp)
     &                           - popats(igrb,io,nspin-isp+1) )
              end do
            end do
            if( dpop < eps6 ) itequ(itb) = -ita
          endif

        end do
      end do

      do igr = 1,ngroup
        it = abs( itype(igr) )
        itypegen(igr) = itequ(it)
      end do

      iopsym(1) = 1; iopsym(2:nopsm) = 0

      boucle_sym: do is = 2,nopsm

        call opsym(is,matopsym)

        boucle_exter: do ispin = 1,nspin

          if( ispin == 1 ) then
            isg = 1
          else
            isg = - 1
          endif

          do ia = 1,natomp
            ita = itypep(ia)
            igra = igroup(ia)
            ps(:) = pos(:,ia)
            pt = matmul( matopsym, ps )
            iok = 0
            if( Atom_mag_gr(igra) .or. Atom_nsph(igra) ) then 
              Axe_atom_c(:) = Axe_atom_clu(:,ia)
              if( abs(Axe_atom_c(1)) < eps6 ) then
                wspin(1) = 1._db;  wspin(2:3) = 0._db
              else
                wspin(3) = 1._db;  wspin(1:2) = 0._db
              endif
              call prodvec( vspin, Axe_atom_c, wspin )
              vspin = vspin / vnorme( vspin ) 

              call prodvec( wspin, Axe_atom_c, vspin ) 

              vspini = matmul( matopsym, vspin )
              wspini = matmul( matopsym, wspin )
              call prodvec(Axe_atom_s,vspini,wspini)
              if( ispin == 2 ) Axe_atom_s(:) = - Axe_atom_s(:) 

            endif

            do ib = 1,natomp
              if( .not. symmol ) then
                if( ( ia == iaabs .and. ib /= iaabs ) .or.
     &              ( ia /= iaabs .and. ib == iaabs ) ) cycle
              endif
              if( abs( pos(1,ib) - pt(1) ) > epspos .or.
     &            abs( pos(2,ib) - pt(2) ) > epspos .or.
     &            abs( pos(3,ib) - pt(3) ) > epspos ) cycle
              igrb = igroup(ib)
              if( abs(itypegen(igrb)) /= abs(itypegen(igra)) ) 
     &                                               cycle boucle_sym

              if( .not. Atom_mag_gr(igra) .and. .not. Atom_mag_gr(igrb) 
     &            .and. .not. Atom_nsph(igra)
     &            .and. .not. Atom_nsph(igrb) ) then
                iok = 1
                exit
              endif

              if( ( Atom_mag_gr(igra) .and. .not. Atom_mag_gr(igrb) )
     &        .or. ( .not. Atom_mag_gr(igra) .and. Atom_mag_gr(igrb) )
     &        .or. ( Atom_nsph(igra) .and. .not. Atom_nsph(igrb) )
     &        .or. ( .not. Atom_nsph(igra) .and. Atom_nsph(igrb) ) )
     &                                              cycle boucle_exter

              if( Atom_mag_gr(igra) ) then 

                if( itypegen(igra) == itypegen(igrb) ) then
                  if( abs( Axe_atom_clu(1,ib) - Axe_atom_s(1) )
     &                                                  > epspos .or.
     &                abs( Axe_atom_clu(2,ib) - Axe_atom_s(2) )
     &                                                  > epspos .or.
     &                abs( Axe_atom_clu(3,ib) - Axe_atom_s(3) )
     &                                  > epspos ) cycle boucle_exter
                else

                  if( abs( Axe_atom_clu(1,ib) + Axe_atom_s(1) )
     &                                                  > epspos .or.
     &                abs( Axe_atom_clu(2,ib) + Axe_atom_s(2) )
     &                                                  > epspos .or.
     &                abs( Axe_atom_clu(3,ib) + Axe_atom_s(3) )
     &                                  > epspos ) cycle boucle_exter
                endif

              else

                if(
     &          ( abs( Axe_atom_clu(1,ib) - Axe_atom_s(1) ) > epspos
     &     .and.  abs( Axe_atom_clu(1,ib) + Axe_atom_s(1) ) > epspos )
     &     .or. ( abs( Axe_atom_clu(2,ib) - Axe_atom_s(2) ) > epspos
     &     .and.  abs( Axe_atom_clu(2,ib) + Axe_atom_s(2) ) > epspos )
     &     .or. ( abs( Axe_atom_clu(3,ib) - Axe_atom_s(3) ) > epspos
     &     .and.  abs( Axe_atom_clu(3,ib) + Axe_atom_s(3) ) > epspos ) )
     &                                        cycle boucle_sym

              endif

              iok = 1
              exit

            end do

            if( iok == 0 ) cycle boucle_exter

          end do

          iopsym(is) = isg
          exit

        end do boucle_exter

      end do boucle_sym

      return
      end

!*********************************************************************

! Sousprogramme contenant les operations de symetries.

      subroutine opsym(is,matopsym)

      use declarations
      implicit real(kind=db) (a-h,o-z)
 
      real(kind=db):: matsym1(3,3,6), matsym2(3,3,7:12),
     &               matsym3(3,3,13:18), matsym4(3,3,19:24),
     &               matsym5(3,3,25:30), matsym6(3,3,31:36),
     &               matsym7(3,3,37:42), matsym8(3,3,43:48),
     &               matsym9(3,3,49:54), matsym10(3,3,55:60),
     &               matsym11(3,3,61:nopsm), matopsym(3,3)

      data matsym1/
!      1  : identite
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db,
!      2 : rot 2*pi/3 autour de (1,1,1)
     &             0.0_db, 0.0_db, 1.0_db,
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
!      3 : rot 4*pi/3 autour de (1,1,1)
     &             0.0_db, 1.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db,
     &             1.0_db, 0.0_db, 0.0_db,
!      4 : rot 2*pi/3 autour de (1,-1,1)
     &             0.0_db,-1.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db,
     &             1.0_db, 0.0_db, 0.0_db,
!      5 : rot 4*pi/3 autour de (1,-1,1)
     &             0.0_db, 0.0_db, 1.0_db,
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
!      6 : rot 2*pi/3 autour de (-1,1,1)
     &             0.0_db,-1.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db,
     &            -1.0_db, 0.0_db, 0.0_db/
      data matsym2/
!      7 : rot 4*pi/3 autour de (-1,1,1)
     &             0.0_db, 0.0_db,-1.0_db,
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
!      8 : rot 2*pi/3 autour de (1,1,-1)
     &             0.0_db, 1.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db,
     &            -1.0_db, 0.0_db, 0.0_db,
!      9 : rot 4*pi/3 autour de (1,1,-1)
     &             0.0_db, 0.0_db,-1.0_db,
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
!      10 : rot 2*pi/2 autour de (1,1,0)
     &             0.0_db, 1.0_db, 0.0_db,
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db,
!      11 : rot 2*pi/2 autour de (-1,1,0)
     &             0.0_db,-1.0_db, 0.0_db,
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db,
!      12 : rot 2*pi/2 autour de (1,0,1)
     &             0.0_db, 0.0_db, 1.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
     &             1.0_db, 0.0_db, 0.0_db/
      data matsym3/
!      13 : rot 2*pi/2 autour de (-1,0,1)
     &             0.0_db, 0.0_db,-1.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
     &            -1.0_db, 0.0_db, 0.0_db,
!      14 : rot 2*pi/2 autour de (0,1,1)
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
!      15 : rot 2*pi/2 autour de (0,-1,1)
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
!      16 : C4x, rot 2*pi/4 selon 0x
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
!      17 : C4y, rot 2*pi/4 selon 0y
     &             0.0_db, 0.0_db, 1.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
     &            -1.0_db, 0.0_db, 0.0_db,
!      18 : C4z, rot 2*pi/4 selon 0z
     &             0.0_db,-1.0_db, 0.0_db,
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db/
      data matsym4/
!      19 : -C4x, rot -2*pi/4 selon 0x
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
!      20 : -C4y, rot -2*pi/4 selon 0y
     &             0.0_db, 0.0_db,-1.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
     &             1.0_db, 0.0_db, 0.0_db,
!      21 : -C4z, rot -2*pi/4 selon 0z
     &             0.0_db, 1.0_db, 0.0_db,
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db,
!      22 : rot 2*pi/2 selon 0x
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db,
!      23 : rot 2*pi/2 selon 0y
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db,
!      24 : rot 2*pi/2 selon 0z
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db/
      data matsym5/
!      25 : inversion
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db,
!      26 : S4x, rot 2*pi/4 selon 0x et miroir
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
!      27 : S4y, rot 2*pi/4 selon 0y et miroir
     &             0.0_db, 0.0_db, 1.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
     &            -1.0_db, 0.0_db, 0.0_db,
!      28 : S4z, rot 2*pi/4 selon 0z et miroir
     &             0.0_db,-1.0_db, 0.0_db,
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db,
!      29 : -S4x, rot -2*pi/4 selon 0x et miroir
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
!      30 : -S4y, rot -2*pi/4 selon 0y et miroir
     &             0.0_db, 0.0_db,-1.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
     &             1.0_db, 0.0_db, 0.0_db/
      data matsym6/
!      31 : -S4z, rot -2*pi/4 selon 0z et miroir
     &             0.0_db, 1.0_db, 0.0_db,
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db,
!      32 : rot 2*pi/3 autour de (1,1,1) et inversion
     &             0.0_db, 0.0_db,-1.0_db,
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
!      33 : rot 4*pi/3 autour de (1,1,1) et inversion
     &             0.0_db,-1.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db,
     &            -1.0_db, 0.0_db, 0.0_db,
!      34 : rot 2*pi/3 autour de (1,-1,1) et inversion
     &             0.0_db, 1.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db,
     &            -1.0_db, 0.0_db, 0.0_db,
!      35 : rot 4*pi/3 autour de (1,-1,1) et inversion
     &             0.0_db, 0.0_db,-1.0_db,
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
!      36 : rot 2*pi/3 autour de (-1,1,1) et inversion
     &             0.0_db, 1.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db,
     &             1.0_db, 0.0_db, 0.0_db/
      data matsym7/
!      37 : rot 4*pi/3 autour de (-1,1,1) et inversion
     &             0.0_db, 0.0_db, 1.0_db,
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
!      38 : rot 2*pi/3 autour de (1,1,-1) et inversion
     &             0.0_db,-1.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db,
     &             1.0_db, 0.0_db, 0.0_db,
!      39 : rot 4*pi/3 autour de (1,1,-1) et inversion
     &             0.0_db, 0.0_db, 1.0_db,
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
!      40 : plan perpendiculaire a 0x
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db,
!      41 : plan perpendiculaire a 0y
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db,
!      42 : plan perpendiculaire a 0z
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db/
      data matsym8/
!      43 : plan diagonal y = z contenant 0x
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
!      44 : plan diagonal x = z contenant 0y
     &             0.0_db, 0.0_db, 1.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
     &             1.0_db, 0.0_db, 0.0_db,
!      45 : plan diagonal x = y contenant 0z
     &             0.0_db, 1.0_db, 0.0_db,
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db,
!      46 : plan diagonal y = -z contenant 0x
     &             1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db,-1.0_db,
     &             0.0_db,-1.0_db, 0.0_db,
!      47 : plan diagonal x = -z contenant 0y
     &             0.0_db, 0.0_db,-1.0_db,
     &             0.0_db, 1.0_db, 0.0_db,
     &            -1.0_db, 0.0_db, 0.0_db,
!      48 : plan diagonal x = -y contenant Oz,
     &             0.0_db,-1.0_db, 0.0_db,
     &            -1.0_db, 0.0_db, 0.0_db,
     &             0.0_db, 0.0_db, 1.0_db/
      data matsym9/
!      49 : rot 2*pi/3 autour de 0z
     &   -0.5_db,               -0.866025403784439_db, 0.0_db,
     &    0.866025403784439_db, -0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,               1.0_db,
!      50 : rot 4*pi/3 autour de 0z
     &   -0.5_db,                0.866025403784439_db, 0.0_db,
     &   -0.866025403784439_db, -0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,               1.0_db,
!      51 : rot 2*pi/6 autour de 0z
     &    0.5_db,               -0.866025403784439_db, 0.0_db,
     &    0.866025403784439_db,  0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,               1.0_db,
!      52 : rot 10*pi/6 autour de 0z
     &    0.5_db,                0.866025403784439_db, 0.0_db,
     &   -0.866025403784439_db,  0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,               1.0_db,
!      53 : rot 2*pi/3 autour de 0z, axe negatif
     &   -0.5_db,               -0.866025403784439_db, 0.0_db,
     &    0.866025403784439_db, -0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,              -1.0_db,
!      54 : rot 4*pi/3 autour de 0z, axe negatif
     &   -0.5_db,                0.866025403784439_db, 0.0_db,
     &   -0.866025403784439_db, -0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,              -1.0_db/
      data matsym10/
!      55 : rot 2*pi/6 autour de 0z, axe negatif
     &    0.5_db,               -0.866025403784439_db, 0.0_db,
     &    0.866025403784439_db,  0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,              -1.0_db,
!      56 : rot 10*pi/6 autour de 0z, axe negatif
     &    0.5_db,                0.866025403784439_db, 0.0_db,
     &   -0.866025403784439_db,  0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,              -1.0_db,
!      57 : plan de sym contenant Oz, a phi = 30 degres
     &    0.5_db,                0.866025403784439_db, 0.0_db,
     &    0.866025403784439_db, -0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,               1.0_db,
!      58 : Axe 2 perpendiculaire a Oz, a phi = 30 degres
     &    0.5_db,                0.866025403784439_db, 0.0_db,
     &    0.866025403784439_db, -0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,              -1.0_db,
!      59 : plan de sym contenant Oz, a phi = 60 degres
     &   -0.5_db,                0.866025403784439_db, 0.0_db,
     &    0.866025403784439_db,  0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,               1.0_db,
!      60 : Axe 2 perpendiculaire a Oz, a phi = 60 degres
     &   -0.5_db,                0.866025403784439_db, 0.0_db,
     &    0.866025403784439_db,  0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,              -1.0_db/
      data matsym11/
!      61 : plan de sym contenant Oz, a phi = 120 degres
     &   -0.5_db,               -0.866025403784439_db, 0.0_db,
     &   -0.866025403784439_db,  0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,               1.0_db,
!      62 : Axe 2 perpendiculaire a Oz, a phi = 120 degres
     &   -0.5_db,               -0.866025403784439_db, 0.0_db,
     &   -0.866025403784439_db,  0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,              -1.0_db,
!      63 : plan de sym contenant Oz, a phi = 150 degres
     &    0.5_db,               -0.866025403784439_db, 0.0_db,
     &   -0.866025403784439_db, -0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,               1.0_db,
!      64 : Axe 2 perpendiculaire a Oz, a phi = 150 degres
     &    0.5_db,               -0.866025403784439_db, 0.0_db,
     &   -0.866025403784439_db, -0.5_db,               0.0_db,
     &    0.0_db,                0.0_db,              -1.0_db/

      if( is <= 6 ) then
        matopsym(:,:) = matsym1(:,:,is)
      elseif( is <= 12 ) then
        matopsym(:,:) = matsym2(:,:,is)
      elseif( is <= 18 ) then
        matopsym(:,:) = matsym3(:,:,is)
      elseif( is <= 24 ) then
        matopsym(:,:) = matsym4(:,:,is)
      elseif( is <= 30 ) then
        matopsym(:,:) = matsym5(:,:,is)
      elseif( is <= 36 ) then
        matopsym(:,:) = matsym6(:,:,is)
      elseif( is <= 42 ) then
        matopsym(:,:) = matsym7(:,:,is)
      elseif( is <= 48 ) then
        matopsym(:,:) = matsym8(:,:,is)
      elseif( is <= 54 ) then
        matopsym(:,:) = matsym9(:,:,is)
      elseif( is <= 60 ) then
        matopsym(:,:) = matsym10(:,:,is)
      else
        matopsym(:,:) = matsym11(:,:,is)
      endif

! Car les data du fortran boucle sur les colonnes a l'interieur des
! lignes
      matopsym = transpose( matopsym)

      return
      end


!***********************************************************************

      subroutine numgrpt(iopsym,igrpt,igrpt_nomag,mpirank)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      parameter( ngrptm = 32, ngrptmagm = 90)

      character(len=8) PointGroup_name, PointGroup_nomag_name,   
     &                 PointGroup_Sch, PointSubGroup_name, 
     &                 PointSubGroup_Sch, ptgrname_int,
     &                 ptgrname_int_nomag, ptgrname_sch 

      integer, dimension(nopsm):: iopsymc, iopsym

      common/PointGroup_name/ PointGroup_name, PointGroup_nomag_name
      common/PointGroup_Sch/ PointGroup_Sch
      common/PointSubGroup_name/ PointSubGroup_name, PointSubGroup_Sch

! La sphere est transformee en m3m
      if( sum( abs(iopsym(:)) ) == 64 ) iopsym(49:64) = 0
! Le cylindre est transformee en 6/mmm
      if( abs(iopsym(51)) == 1 .and. abs(iopsym(45)) == 1 ) then
        iopsym(10:11) = 0
        iopsym(18:21:3) = 0
        iopsym(28:31:3) = 0
        iopsym(45:48:3) = 0
      endif

      boucle_grpt: do igrpt = 1,ngrptmagm

        call grp_opsym(igr_sg,igrpt,igrpt_nomag,iopsymc,nb_ord)

        do k = 1,nopsm
          if( iopsym(k) /= iopsymc(k) ) cycle boucle_grpt
        end do

        PointGroup_name = ptgrname_int(igrpt)
        if( igrpt > ngrptm ) then 
          PointSubGroup_name = ptgrname_int_nomag(igr_sg)
          PointSubGroup_Sch = ptgrname_Sch(igr_sg)
        endif
        PointGroup_nomag_name = ptgrname_int_nomag(igrpt_nomag) 
        PointGroup_Sch = ptgrname_sch(igrpt_nomag)
    
        return

      end do boucle_grpt

      if( mpirank == 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,'(/A)') ' Point group not found !'
          write(ipr,170)
          call write_iopsym(iopsym,ipr)
        end do
        stop
      endif

      return
  170 format(/' iopsymc =')
      end

!***********************************************************************

      subroutine grp_opsym_imp(iopsymc,igrpt,igrpt_nomag,mpirank)

      use declarations
      implicit real(kind=db) (a-h,o-z)
 
      parameter( ngrptm = 32, ngrptmagm = 90)

      character(len=8) PointGroup, PointGroup_name, 
     &                 PointGroup_nomag_name, PointGroup_Sch,
     &                 ptgrname_int, ptgrname_sch 

      integer, dimension(nopsm):: iopsymc, iopsymt

      common/PointGroup/ PointGroup
      common/PointGroup_name/ PointGroup_name, PointGroup_nomag_name
      common/PointGroup_Sch/ PointGroup_Sch

      if( PointGroup == 'SousGr' ) then

        boucle_grpt1: do igrptt = 1,ngrptmagm

          call grp_opsym(igr_sg,igrptt,igrpt_nomagt,iopsymt,nb_ord)

          if( igrpt_nomagt /= igrpt_nomag ) cycle

          do k = 1,nopsm
            if( iopsymt(k) == 0 ) cycle
            if( iopsymt(k) /= iopsymc(k) ) cycle boucle_grpt1
          end do

          exit

        end do boucle_grpt1

        igrpt = igrptt
        igrpt_nomag = igrpt_nomagt
        iopsymc(:) = iopsymt(:)

        PointGroup_name = ptgrname_int(igrpt)
        PointGroup_nomag_name = ptgrname_int(igrpt_nomag) 
        PointGroup_Sch = ptgrname_sch(igrpt_nomag)    

        return

      else
 
        boucle_grpt: do igrpt = 1,ngrptmagm

          if( PointGroup /= ptgrname_int(igrpt) ) then 
            if( igrpt > ngrptm ) cycle
            if( PointGroup /= ptgrname_sch(igrpt) ) cycle
          endif

          call grp_opsym(igr_sg,igrpt,igrpt_nomag,iopsymc,nb_ord)

          PointGroup_name = ptgrname_int(igrpt)
          PointGroup_nomag_name = ptgrname_int(igrpt_nomag) 
          PointGroup_Sch = ptgrname_sch(igrpt_nomag)    

          return

        end do boucle_grpt

      endif

      if( mpirank == 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,'(/A)') ' Point group not found !'
        end do
        stop
      endif

      return
      end

!***********************************************************************

      subroutine grp_opsym(igr_sg,igrpt,igrpt_nomag,iopsymc,nb_ord)

      use declarations
      implicit real(kind=db) (a-h,o-z)
 
      parameter( ngrptm = 32, ngrpt_compm = 11, ngrptmagm = 90,
     &           ngrptmag_compm = 10 ) 

      integer, dimension(ngrptm+1:ngrptmagm+ngrptmag_compm)::ngref,ngnmg
      integer, dimension(nopsm):: iopsymc

! Numero de groupe non magnetique reference pour les groupes magnetiques
      data ngref/ 2, 4, 3, 5, 5, 5, 7, 6, 6, 8,
     &            8, 8,19,18,21,24,24,24, 9,10,
     &           14,14,11,11,11,12,12,13,13,13,
     &           15,15,15,15,15,22,17,20,20,20,
     &           26,26,23,23,23,25,25,27,27,27, 
     &           27,27,29,30,31,32,32,32,
     &            7, 7, 6, 8, 8, 8, 8,12,26,25/

! Numero du sous-groupe non magnetique non multiplie par le renversement
! du temps pour les groupes magnetiques
      data ngnmg/ 1, 1, 1, 2, 3, 4, 4, 4,34, 7,
     &            6, 5,16,16,16,21,18,41, 4, 4,
     &            9, 7, 9,10, 5, 9, 6,10, 7,42,
     &           14,12, 8,13,11,16,16,19,18,17,
     &           22,19,22,17,21,22,18,24,20,23,
     &           26,25,28,28,28,31,30,29,
     &           35,36,33,39,40,37,38,42,41,43/       

      iopsymc(:) = 0

      if( igrpt > ngrptm ) then
        igrpt_nomag = ngref(igrpt) 
      else
        igrpt_nomag = igrpt 
      endif

      nb_ord = numbops( igrpt_nomag )

      ideb = 0
      do is = 1,igrpt_nomag - 1 
        ideb = ideb + numbops(is)
      end do

      do is = 1,nb_ord
        iopsymc( ios(ideb+is) ) = 1
      end do
     
! Groupes magnetiques : on met un signe negatif pour les operations
! multipliees par le renversement du temps.

      if( igrpt > ngrptm ) then

! Sous-groupe contenant les operations non multiplies par le
! renversement du temps
        igr_sg = ngnmg(igrpt)
        nb_ord_sg = numbops(igr_sg)  
        jdeb = 0
        do is = 1,igr_sg - 1 
          jdeb = jdeb + numbops(is)
        end do
        boucle_is: do is = 1,nb_ord
          do js = 1,nb_ord_sg
            if( ios(ideb+is) == ios(jdeb+js) ) cycle boucle_is
          end do
          iopsymc( ios(ideb+is) ) = - iopsymc( ios(ideb+is) )
        end do boucle_is 

      endif

      return
      end

!***********************************************************************

      subroutine character_table(igrpt_nomag,nb_rep)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      parameter( nclasm=12, ngrptm = 32, ngrpt_compm = 11 )

      character(len=8) PointGroup_name, PointGroup_nomag_name
      character(len=9) nomsym
      character(len=36), dimension(12) :: ch
      character(len=144):: mot

      complex(kind=db), dimension(nclasm,nrepm):: kar
      complex(kind=db), dimension(nopsm,nrepm):: karact

      integer, dimension(ngrptm) :: nb_cla_table, nb_rep_table
      integer, dimension(nopsm) :: nb_sympcl(nclasm)

      logical inversion, jexp, kexp

      common/icheck/ icheck(24)
      common/karact/ karact
      common/PointGroup_name/ PointGroup_name, PointGroup_nomag_name

      data nb_cla_table/1,2,2,2,4,4,4,8,4,4,
     &                  8,5,5,5,10,3,6,3,3,6,
     &                  6,6,12,6,6,6,12,4,6,5,
     &                  5,10/

      data nb_rep_table/1,2,2,2,4,4,4,8,3,3,
     &                  6,5,5,5,10,2,4,3,3,6,
     &                  4,4,8,6,6,6,12,3,6,5,
     &                  5,10/

      nb_cla = nb_cla_table(igrpt_nomag)
      nb_rep = nb_rep_table(igrpt_nomag)

      inversion = .false.

      select case(PointGroup_nomag_name)

        case('1')                      ! C1 1
          ch(1) = '  1' 

        case('-1','m','2')             ! Ci, Cs, C2, 2 3 4
          inversion = .true.
          ch(1) = '  1' 

        case('2/m','mm','222')         ! C2h, C2v, D2 5 6 7
          inversion = .true.
          ch(1) = '  1  1' 
          ch(2) = '  1 -1' 

        case('mmm')                    ! D2h 8
          inversion = .true.
          ch(1) = '  1  1  1  1' 
          ch(2) = '  1  1 -1 -1' 
          ch(3) = '  1 -1  1 -1' 
          ch(4) = '  1 -1 -1  1' 

        case('4','-4')                 ! C4, S4 9 10
          ch(1) = '  1  1  1  1' 
          ch(2) = '  1  1 -1 -1' 
          ch(3) = '  1 -1  i -i' 

        case('4/m')                    ! C4h 11
          inversion = .true.
          ch(1) = '  1  1  1  1' 
          ch(2) = '  1 -1  1 -1' 
          ch(3) = '  1  i -1 -i' 

        case('4mm','-42m','422')       ! C4v, D2d, D4   12 13 14
          ch(1) = '  1  1  1  1  1' 
          ch(2) = '  1  1  1 -1 -1' 
          ch(3) = '  1  1 -1  1 -1' 
          ch(4) = '  1  1 -1 -1  1' 
          ch(5) = '  2 -2  0  0  0' 

        case('4/mmm')                  ! D4h  15
          inversion = .true.
          ch(1) = '  1  1  1  1  1' 
          ch(2) = '  1  1  1 -1 -1' 
          ch(3) = '  1 -1  1  1 -1' 
          ch(4) = '  1 -1  1 -1  1' 
          ch(5) = '  2  0 -2  0  0' 

        case('3')                      ! C3  16
          ch(1) = '  1  1  1' 
          ch(2) = '  1  j j2' 

        case('-3','-6','6')            ! S6, C3h, C6   17 21 22
          inversion = .true.
          ch(1) = '  1  1  1' 
          ch(2) = '  1  j j2' 

        case('3m','32')                ! C3v D3  18 19
          ch(1) = '  1  1  1' 
          ch(2) = '  1  1 -1' 
          ch(3) = '  2 -1  0' 

        case('-3m','-6m2','6mm','622') ! D3d D3h C6v D6  20 24 25 26  
          inversion = .true.
          ch(1) = '  1  1  1' 
          ch(2) = '  1  1 -1' 
          ch(3) = '  2 -1  0' 

        case('6/m')                    ! C6h  23
          inversion = .true.
          ch(1) = '  1  1  1  1  1  1' 
          ch(2) = '  1 -1  1 -1  1 -1' 
          ch(3) = '  1  k  j -1 j2 k5' 
          ch(4) = '  1  j j2  1  j j2' 

        case('6/mmm')                  ! D6h 27
          inversion = .true.
          ch(1) = '  1  1  1  1  1  1' 
          ch(2) = '  1  1  1  1 -1 -1' 
          ch(3) = '  1 -1  1 -1  1 -1' 
          ch(4) = '  1 -1  1 -1 -1  1' 
          ch(5) = '  2  1 -1 -2  0  0' 
          ch(6) = '  2 -1 -1  2  0  0' 

        case('23')                     ! T 28
          ch(1) = '  1  1  1  1' 
          ch(2) = '  1  1  j j2' 
          ch(3) = '  3 -1  0  0' 

        case('m3')                     ! Th 29
          inversion = .true.
          ch(1) = '  1  1  1  1' 
          ch(2) = '  1  j j2  1' 
          ch(3) = '  3  0  0 -1'  

        case('-43m','432')             ! Td, O  30 31
          ch(1) = '  1  1  1  1  1' 
          ch(2) = '  1  1  1 -1 -1' 
          ch(3) = '  2 -1  2  0  0' 
          ch(4) = '  3  0 -1 -1  1' 
          ch(5) = '  3  0 -1  1 -1' 

        case('m3m')                    ! Oh 32
          inversion = .true.
          ch(1) = '  1  1  1  1  1' 
          ch(2) = '  1  1 -1 -1  1' 
          ch(3) = '  2 -1  0  0  2' 
          ch(4) = '  3  0 -1  1 -1' 
          ch(5) = '  3  0  1 -1 -1' 

      end select

      if( inversion ) then
        nc = nb_cla / 2 
        nr = nb_rep / 2 
      else
        nc = nb_cla 
        nr = nb_rep 
      endif

      if( inversion ) then
        do irep = 1,nr
          mot = ch(irep)
          l = len_trim(mot)
          mot(l+1:2*l) = mot(1:l)
          ch(irep) = mot
          do ic = nc+1, nb_cla
            j = 3*ic-1
            select case( mot(j:j) )
              case(' ')
                mot(j:j) = '-'
              case('-')
                mot(j:j) = ' '
              case('j')
                mot(j:j+1) = ' k'
              case('k')
                mot(j:j+1) = ' j'
            end select
          end do
          ch(irep+nr) = mot
        end do
      endif

      r = sqrt(3._db)/2

      do j = 1,nr
        jc = -3
        mot = ch(j)
        do i = 1,nc
          jc = jc + 3
                
          select case(mot(jc+2:jc+3))
            case(' 0')
              kar(i,j) = (0._db,0._db)
            case(' 1')
              kar(i,j) = (1._db,0._db)
            case('-1')
              kar(i,j) = (-1._db,0._db)
            case(' 2')
              kar(i,j) = (2._db,0._db)
            case('-2')
              kar(i,j) = (-2._db,0._db)
            case(' 3')
              kar(i,j) = (3._db,0._db)
            case('-3')
              kar(i,j) = (-3._db,0._db)
            case(' i')
              kar(i,j) = (0._db,1._db)
            case('-i')
              kar(i,j) = (0._db,-1._db)
            case(' j')
              kar(i,j) = cmplx(-0.5_db,r,db)
            case('j2')
              kar(i,j) = cmplx(-0.5_db,-r,db)
            case(' k')
              kar(i,j) = cmplx(0.5_db,r,db)
            case('k5')
              kar(i,j) = cmplx(0.5_db,-r,db)
          end select
        end do
      end do

      if( inversion ) then
        do j = 1,nc
          kar(j+nc,1:nr) = kar(j,1:nr)
        end do
        do i = 1,nr
          kar(1:nc,i+nr) = kar(1:nc,i)
          kar(nc+1:nb_cla,i+nr) = - kar(nc+1:nb_cla,i)
        end do
      endif

      nb_sympcl(1:nc) = 1

      select case(PointGroup_nomag_name)

        case('4mm  ','-42m ','422  ')
          nb_sympcl(3:5) = 2

        case('4/mmm')
          nb_sympcl(2) = 2; nb_sympcl(4:5) = 2

        case('3m','32','-3m','-6m2','6mm','622')
          nb_sympcl(2) = 2; nb_sympcl(3) = 3

        case('23')
          nb_sympcl(2) = 3; nb_sympcl(3) = 4; nb_sympcl(4) = 3

        case('m3')
          nb_sympcl(2) = 4; nb_sympcl(3) = 4; nb_sympcl(4) = 3

        case('-43m','432')
          nb_sympcl(2) = 8; nb_sympcl(3) = 3; nb_sympcl(4:5) = 6

        case('m3m')
          nb_sympcl(2) = 8; nb_sympcl(3:4) = 6; nb_sympcl(5) = 3

      end select

      if( inversion ) then
        do j = 1,nc
          nb_sympcl(j+nc) = nb_sympcl(j)
        end do
      endif

      ideb = 0
      do is = 1,igrpt_nomag - 1 
        ideb = ideb + numbops(is)
      end do

      karact(:,:) = (0._db,0._db)

      boucle_is: do is = 1,numbops( igrpt_nomag )

        k= 0
        do i = 1,nb_cla
          do j = 1,nb_sympcl(i)
            k = k + 1
            if( k == is ) then
              karact(ios(ideb+is),1:nb_rep) = kar(i,1:nb_rep)
              cycle boucle_is
            endif
          end do
        end do

      end do boucle_is

      if( icheck(4) > 0 ) then
        ifin = 0
        do is = 1,igrpt_nomag
          ifin = ifin + numbops(is)
        end do
        write(3,110)
        write(3,'(5x,48i3)') ( ios(is), is = ideb+1,ifin )
        do irep = 1,nb_rep
          mot = ch(irep)
          ic = 0
          do i = 1,nb_cla
            ic = ic + 3
            if( nb_sympcl(i) > 1 ) then
              id = 3 * nb_sympcl(i) - 3 
              l = len_trim(mot)
              mot(ic+1+id:l+id) = mot(ic+1:l)
              mot(ic+1:ic+id) = ' '
              ic = ic + id
            endif
          end do 
          write(3,'(5x,a)') mot
        end do
        jexp = .false.; kexp = .false.
        do i = 1,len_trim(mot)
          if( mot(i:i) == 'j' ) jexp = .true.
          if( mot(i:i) == 'k' ) kexp = .true.
        end do
        if( jexp .or. kexp ) then
          write(3,'(/A)') ' Symmetry code      Character code'
        else
          write(3,'(/A)') ' Symmetry code:'
        endif
        do is = ideb+1,ifin
          if( is == ideb+1 .and. jexp ) then
            write(3,120) ios(is), nomsym(ios(is)) 
          elseif( is == ideb+1 .and. kexp ) then
            write(3,130) ios(is), nomsym(ios(is)) 
          elseif( is == ideb+2 .and. jexp .and. kexp ) then
            write(3,130) ios(is), nomsym(ios(is))
          else 
            write(3,140) ios(is), nomsym(ios(is))
          endif
        end do
      endif

      return
  110 format(/' Character table :')
  120 format(2x,i3,a9,'     j = exp(2.i.pi/3)')
  130 format(2x,i3,a9,'     k = exp(2.i.pi/6)')
  140 format(2x,i3,a9)
      end

!*********************************************************************

! Sousprogramme calculant la forme des tenseurs

      subroutine Tensor_shape(Atom_mag_gr,Atom_nsph,Axe_atom_clu,green,
     &             iaabs,igroup,it0,itype,itypep,magnetic,natomp,
     &             ngroup,nlat,nlatm,nspin,ntype,numat,octupole,popats,
     &             pos,quadrupole,rot_atom_abs,spinorbite)

      use declarations
      implicit real(kind=db) (a-h,o-z)
      integer, dimension(nopsm):: irotiops, iopsymt
      integer, dimension(natomp):: igroup, itypep
      integer, dimension(ngroup):: itype
      integer, dimension(it0:ntype):: nlat, numat

      logical:: Atom_comp, Atom_comp_cal, Atom_mag, Atom_mag_cal,
     &          comp_dd, comp_md, comp_do, comp_dq,
     &          comp_dqe, comp_mm, comp_qq, green, magnet, magnetic, 
     &          octupole, quadrupole, spinorbite 
      logical, dimension(0:ngroup):: Atom_mag_gr
      logical, dimension(ngroup):: Atom_nsph

      real(kind=db), dimension(3):: ps
      real(kind=db), dimension(3,3):: rot_atom_abs, rot_tem
      real(kind=db), dimension(3,natomp):: Axe_atom_clu, pos
      real(kind=db), dimension(ngroup,nlatm,nspin):: popats

      common/comp_dd/ comp_dd, comp_md, comp_do, comp_dq,comp_mm,comp_qq 
      common/comp_dqe/ comp_dqe 
      common/icheck/ icheck(24)
      common/igrpt0/ igrpt0
      common/iopsym_abs/ iopsym_abs(nopsm)
      common/iopsymc/ iopsymc(nopsm)
      common/iopsymr/ iopsymr(nopsm)
      common/ldipimp/ ldipimp(3), lquaimp(3,3)
      common/ldip/ ldip(3), loct(3,3,3), lqua(3,3)
      common/lseuil/ jseuil, lseuil, nseuil
      common/msym/ msymdd(3,3), msymddi(3,3), msymdq(3,3,3), 
     &             msymdqi(3,3,3), msymdo(3,3,3,3), msymdoi(3,3,3,3),
     &             msymqq(3,3,3,3), msymqqi(3,3,3,3)
      common/rot_int/ rot_int(3,3)

      if( icheck(5) > 0 ) write(3,100)

! Evaluation de la symetrie de l'atome absorbeur
      if( magnetic ) then
        Atom_mag = Atom_mag_cal(igrpt0)
      else
        Atom_mag = .false.
      endif
      Atom_comp = Atom_comp_cal(igrpt0)

      ps(:) = pos(:,iaabs)
      if( nspin == 1 .and. sum( abs( pos(:,iaabs) ) ) < eps10 ) then
        iopsym_abs(:) = iopsymc(:)
      else  
        call point_group_atom(Atom_comp,Atom_mag,Atom_mag_gr,
     &      Atom_nsph,Axe_atom_clu,iaabs,iaabs,igroup,igroup(iaabs),
     &      igrpt,iopsym_abs,iopsymc,it0,itype,itypep,magnetic,
     &      mpirank,natomp,ngroup,nlat,nlatm,nspin,ntype,
     &      numat,popats,pos,ps,rot_atom_abs,spinorbite)
      endif
! La rotation est calcule avec la symetrie utilisee (iopsymr)
      call point_group_atom(Atom_comp,Atom_mag,Atom_mag_gr,
     &    Atom_nsph,Axe_atom_clu,iaabs,iaabs,igroup,igroup(iaabs),
     &    igrpt,iopsymt,iopsymr,it0,itype,itypep,magnetic,
     &    mpirank,natomp,ngroup,nlat,nlatm,nspin,ntype,
     &    numat,popats,pos,ps,rot_atom_abs,spinorbite)

      if( spinorbite .or. ( nspin == 2 .and. lseuil > 0 ) ) then
        magnet = .true.
      else
        magnet = .false.
      endif

      do ical = 1,2
        if( ical == 1 ) then
          rot_tem = transpose( matmul( rot_int,transpose(rot_atom_abs)))
          if( abs( rot_tem(1,1) - 1 ) < eps10 .and.
     &        abs( rot_tem(2,2) - 1 ) < eps10 .and.
     &        abs( rot_tem(3,3) - 1 ) < eps10 ) cycle 
          call iop_rot(irotiops,rot_tem)
          where( irotiops /= 0 ) irotiops = iopsym_abs(irotiops)
        else
          irotiops = iopsym_abs
        endif 

! Calcul des tenseurs
        if( comp_dd ) call tensdd(irotiops,magnet)
        if( comp_dqe ) call tensdq(irotiops,magnet)
        if( comp_qq ) call tensqq(irotiops,magnet)
        if( comp_do ) call tensdo(irotiops,magnet)

! Terme d'interference dipole - quadrupole
        comp_dq = comp_dqe
        if( comp_dqe ) then
          n = maxval( abs(msymdq) )
          n = max( n, maxval( abs(msymdqi) ) )
          if( n == 0 ) comp_dq = .false.
        endif

        if( icheck(5) > 0 ) then
          if( ical == 1 ) then
            write(3,102)
          else
            write(3,104)
          endif
          if( magnet ) then
            if( comp_dd ) then
              write(3,110)
              do i = 1,3
                write(3,120) ( msymdd(i,k), msymddi(i,k), k = 1,3)
              end do
            endif
            if( comp_dqe ) then
              write(3,130)
              do j = 1,3
                write(3,120) ( ( msymdq(i,j,k), msymdqi(i,j,k), k =1,3),
     &                       i = 1,3 )
              end do
            endif
            if( comp_qq ) then
              write(3,140)
              do i = 1,3
                write(3,150) i, i, i
                do k = 1,3
                  write(3,120) ( ( msymqq(i,j,k,l), msymqqi(i,j,k,l), 
     &                            l = 1,3), j = 1,3 )
                end do
              end do
            endif
            if( comp_do ) then
              write(3,160)
              do i = 1,3
                write(3,150) i, i, i
                do k = 1,3
                  write(3,120) ( (msymdo(i,j,k,l), msymdoi(i,j,k,l), 
     &                            l = 1,3 ), j = 1,3 )
                end do
              end do
            endif
          else
            if( comp_dd ) then
              write(3,110)
              do i = 1,3
                write(3,170) msymdd(i,:)
              end do
            endif
            if( comp_dqe ) then
              write(3,180)
              do j = 1,3
                write(3,170) (msymdq(i,j,:), i = 1,3)
              end do
            endif
            if( comp_qq ) then
              write(3,140)
              do i = 1,3
                write(3,190) i, i, i
                do k = 1,3
                  write(3,170) (msymqq(i,j,k,:), j = 1,3)
                end do
              end do
            endif
            if( comp_do ) then
            write(3,160)
              do i = 1,3
                write(3,190) i, i, i
                do k = 1,3
                  write(3,170) (msymdo(i,j,k,:), j = 1,3)
                end do
              end do
            endif
          endif
        endif

      end do

! Determination des operateurs a calculer
      ldip = 0
      lqua = 0
      loct = 0

      n = maxval( abs(msymdd) )
      n = max( n, maxval( abs(msymddi) ) )
      do i = 1,n
        boucle_dip: do ke = 3,1,-1
          do ks = 3,1,-1
            if( abs(msymdd(ke,ks)) == i .or. 
     &          abs(msymddi(ke,ks)) == i ) exit boucle_dip
          end do
        end do boucle_dip
        ldip(ke) = 1
        ldip(ks) = 1
      end do

      if( quadrupole ) then
        n = maxval(abs(msymqq))
        n = max( n, maxval( abs(msymqqi) ) )
        do i = 1,n
          boucle_qua: do ke = 1,3
            do ks = 1,3
              do je = 1,3
                do js = 1,3
                  if( abs(msymqq(ke,je,ks,js)) == i .or.
     &                abs(msymqqi(ke,je,ks,js)) == i) exit boucle_qua
                end do
              end do
            end do
          end do boucle_qua
          kk = min(ke,je)
          jj = max(ke,je)
          lqua(kk,jj) = 1
          kk = min(ks,js)
          jj = max(ks,js)
          lqua(kk,jj) = 1
        end do
      endif

! Terme d'interference dipole - quadrupole
      if( comp_dq ) then
        n = maxval(abs(msymdq))
        n = max( n, maxval( abs(msymdqi) ) )
        do i = 1,n
          boucle_int: do ke = 3,1,-1
            do ks = 3,1,-1
              do js = 3,1,-1
                if( abs(msymdq(ke,ks,js)) == i .or.
     &              abs(msymdqi(ke,ks,js)) == i ) exit boucle_int
              end do
            end do
          end do boucle_int
          ldip(ke) = 1
          kk = min(ks,js)
          jj = max(ks,js)
          lqua(kk,jj) = 1
        end do
      endif

      if( octupole ) then
        n = maxval(abs(msymdo))
        n = max( n, maxval( abs(msymdoi) ) )
        do i = 1,n
          boucle_oct: do ke = 3,1,-1
            do ks = 3,1,-1
              do j1 = 3,1,-1
                do j2 = 3,1,-1
                  if( abs(msymdo(ke,ks,j1,j2)) == i .or.
     &                abs(msymdoi(ke,ks,j1,j2)) == i ) exit boucle_oct
                end do
              end do
            end do
          end do boucle_oct
          ldip(ke) = 1
          kk = min(ks,j1,j2)
          jj2 = max(ks,j1,j2)
          if( (ks == kk .and. j1 == jj2) .or.
     &        (j1 == kk .and. ks == jj2) ) then
            jj1 = j2
          elseif( (ks == kk .and. j2 == jj2) .or.
     &            (j2 == kk .and. ks == jj2) ) then
            jj1 = j1
          else
            jj1 = ks
          endif
          loct(kk,jj1,jj2) = 1
        end do
      endif

      if( icheck(5) > 0 ) write(3,210) ldip(1:3)

      if( ldipimp(1) /= -1 .and. .not. green ) then
        ldip(:) = ldipimp(:)
        if( icheck(5) > 0 ) write(3,215) ldip(1:3)
      endif

      if( quadrupole .or. octupole ) then
        if( icheck(5) > 0 ) write(3,220) (lqua(i,1:3), i = 1,3)

        if( lquaimp(1,1) /= -1  .and. .not. green ) then
          lqua(:,:) = 0
          do i = 1,3
            do j = 1,3
              if( lquaimp(i,j) == 0 ) cycle
              ii = min(i,j)
              jj = max(i,j)
              lqua(ii,jj) = 1
            end do
          end do
          if( icheck(5) > 0 ) write(3,225) (lqua(i,1:3), i = 1,3)
        endif
      endif

      if( icheck(5) > 0 .and. octupole )
     &               write(3,230) ( (loct(i,j,1:3), j = 1,3 ), i = 1,3 )

      return
  100 format(//' ---- Tensor_shape --------',100('-'))
  102 format(/'  Internal basis, z along c :')
  104 format(/'  Absorbing atom basis :')
  110 format(/'  Dipole-dipole matrix shape :'/)
  120 format(3(3x,3(i4,i3)))
  130 format(/'  Dipole-quadrupole matrix shape :'/,/
     & 11x,'(1,j,k)',17x,'(2,j,k)',17x,'(3,j,k)')
  140 format(/'  Quadrupole-quadrupole matrix shape :'/)
  150 format(
     & 10x,'(',i1,',1,k,l)',15x,'(',i1,',2,k,l)',15x,'(',i1,',3,k,l)')
  160 format(/'  Dipole-Octupole matrix shape :'/)
  170 format(3(3x,3i3))
  180 format(/'  Dipole-quadrupole matrix shape :'/,/
     &  5x,'(1,j,k)     (2,j,k)     (3,j,k)')
  190 format(/'    (',i1,',1,k,l)   (',i1,',2,k,l)   (',i1,',3,k,l)')
  210 format(/' ldip = (',3i2,')')
  215 format(/' ldip = (',3i2,'), apres imposition')
  220 format(/' lqua = (',3i2,')',2(/8x,'(',3i2,')'))
  225 format(/' lqua = (',3i2,'), apres imposition',2(/8x,'(',3i2,')'))
  230 format(/' loct = ',3('(',3i2,')  '),2(/8x,3('(',3i2,')  ')))
      end

!*********************************************************************

! Calcul du tenseur dipole-dipole

      subroutine tensdd(iopsymt,magnet)

      use declarations
      integer im(3), iopsymt(nopsm)

      logical magnet
      logical, dimension(9):: impos, imposi      

      real(kind=db):: matopsym(3,3)

      common/msym/ msymdd(3,3), msymddi(3,3), msymdq(3,3,3), 
     &             msymdqi(3,3,3), msymdo(3,3,3,3), msymdoi(3,3,3,3),
     &             msymqq(3,3,3,3), msymqqi(3,3,3,3)

      msymdd(:,:) = 0;  msymddi(:,:) = 0;
      impos(:) = .false.
      if( magnet ) then
       imposi(:) = .false. 
      else
       imposi(:) = .true.  
      endif

      kkk = 0
      do i = 1,3
        do j = i,3
          if( msymdd(i,j) /= 0 .or. msymddi(i,j) /= 0 ) cycle
          kkk = kkk + 1
          msymdd(i,j) = kkk
          msymdd(j,i) = kkk
          if( i /= j ) then
            msymddi(i,j) = kkk
            msymddi(j,i) = - kkk
          endif 

          do iss = 2,min(48,nopsm)

            is = iordresym(iss)
            if( iopsymt(is) == 0 ) cycle
            isgmag = iopsymt(is)
!            isgmag = ismag(is)
            call opsym(is,matopsym)
            do ii = 1,3
              do jj = 1,3
                if( abs(matopsym(jj,ii)) < 0.0001_db ) cycle
                im(ii) = jj * nint( matopsym(jj,ii) )
                exit
              end do
            end do
            ii = abs( im(i) )
            iis = ii / im(i)
            jj = abs( im(j) )
            jjs = jj / im(j)
            isg = iis * jjs
            isgi = isg * isgmag

            if( ( isg > 0 .and. msymdd(ii,jj) == - kkk ) .or.
     &      ( isg < 0 .and. msymdd(ii,jj) == kkk ) ) impos(kkk) = .true.
            if( .not. impos(kkk) ) then 
              msymdd(ii,jj) = isg * kkk
              msymdd(jj,ii) = isg * kkk
            endif
            if( ii == jj ) cycle
            if( is /= 51 .and. is /= 52 .and. is < 55 ) then
              if( ( isgi > 0 .and. msymddi(ii,jj) == - kkk ) .or.
     &            ( isgi < 0 .and. msymddi(ii,jj) == kkk ) ) 
     &                                               imposi(kkk) =.true.
              if( .not. imposi(kkk) .and. isgmag /= 0 ) then 
                msymddi(ii,jj) = isgi * kkk
                msymddi(jj,ii) = - isgi * kkk
              endif
            endif

          end do

        end do
      end do

      kkkmax = kkk
      kk = 0
      do kkk = 1,kkkmax
        kk = kk + 1
        if( impos(kkk) ) where( abs(msymdd) == kk ) msymdd = 0
        if( imposi(kkk) ) where( abs(msymddi) == kk ) msymddi = 0
        if( impos(kkk) .and. imposi(kkk) ) then
          where( abs(msymdd) > kk ) msymdd = msymdd - abs(msymdd)/msymdd
          where( abs(msymddi) > kk ) msymddi = msymddi
     &                                       - abs(msymddi) / msymddi
          kk = kk - 1
        endif
      end do

      n = maxval( abs(msymdd) )
      boucle_i: do i = 1,n
        do ke = 1,3
          do ks = 1,3
            if( abs(msymdd(ke,ks)) == i .or. 
     &          abs(msymddi(ke,ks)) == i ) cycle boucle_i
          end do
        end do
        where( abs(msymdd) > i ) msymdd = msymdd - abs(msymdd) / msymdd
        where( abs(msymddi) > i ) msymddi = msymddi
     &                                       - abs(msymddi) / msymddi
      end do boucle_i
 
      return
      end

!*********************************************************************

      function ismag(is)

      select case(is)

        case(1,18,21,24,25,28,31,42,49,50,51,52,53,54,55,56)
          ismag = 1

        case(2,3,4,5,6,7,8,9,12,13,14,15,16,17,19,20,26,27,29,30,32,33,
     &       34,35,36,37,38,39,43,44,46,47)
          ismag = 0

        case(10,11,22,23,40,41,45,48,57,58,59,60,61,62,63,64)
          ismag = -1

      end select

      return
      end

!*********************************************************************

      subroutine tensdq(iopsymt,magnet)

      use declarations
      integer im(3), iopsymt(nopsm)

      logical magnet
      logical, dimension(27):: impos, imposi     
      real(kind=db):: matopsym(3,3)

      common/msym/ msymdd(3,3), msymddi(3,3), msymdq(3,3,3), 
     &             msymdqi(3,3,3), msymdo(3,3,3,3), msymdoi(3,3,3,3),
     &             msymqq(3,3,3,3), msymqqi(3,3,3,3)

      msymdq(:,:,:) = 0; msymdqi(:,:,:) = 0 
      impos(:) = .false.
      if( magnet ) then
       imposi(:) = .false. 
      else
       imposi(:) = .true.  
      endif

      kkk = 0
      do i = 1,3
        do j = 1,3
          do k = j,3
            if( msymdq(i,j,k) /= 0 .or. msymdqi(i,j,k) /= 0 ) cycle
            kkk = kkk + 1
            msymdq(i,j,k) = kkk
            msymdq(i,k,j) = kkk
            msymdqi(i,j,k) = kkk
            msymdqi(i,k,j) = kkk

            do iss = 2,min(48,nopsm)

              is = iordresym(iss)
              if( is > 48 ) cycle
              if( iopsymt(is) == 0 ) cycle
              isgmag = iopsymt(is)
              call opsym(is,matopsym)
              do ii = 1,3
                do jj = 1,3
                  if( abs(matopsym(jj,ii)) < 0.0001_db ) cycle
                  im(ii) = jj * nint( matopsym(jj,ii) )
                  exit
                end do
              end do
              ii = abs( im(i) )
              iis = ii / im(i)
              jj = abs( im(j) )
              jjs = jj / im(j)
              kk = abs( im(k) )
              kks = kk / im(k)
              isg = iis * jjs * kks
              isgi = isg * isgmag

              if( ( isg > 0 .and. msymdq(ii,jj,kk) == - kkk ) .or.
     &            ( isg < 0 .and. msymdq(ii,jj,kk) == kkk ) )
     &                                               impos(kkk) = .true.
              if( ( isgi > 0 .and. msymdqi(ii,jj,kk) == - kkk ).or.
     &            ( isgi < 0 .and. msymdqi(ii,jj,kk) == kkk ) ) 
     &                                               imposi(kkk) =.true.

              if( .not. impos(kkk) ) then 
                msymdq(ii,jj,kk) = isg * kkk
                msymdq(ii,kk,jj) = isg * kkk
              endif
              if( .not. imposi(kkk) .and. isgmag /= 0 ) then 
                msymdqi(ii,jj,kk) = isgi * kkk
                msymdqi(ii,kk,jj) = isgi * kkk
              endif

            end do

          end do
        end do
      end do

      kkkmax = kkk

      kk = 0
      do kkk = 1,kkkmax
        kk = kk + 1
        if( impos(kkk) ) where( abs(msymdq) == kk ) msymdq = 0
        if( imposi(kkk) ) where( abs(msymdqi) == kk ) msymdqi = 0
        if( impos(kkk) .and. imposi(kkk) ) then
          where( abs(msymdq) > kk ) msymdq = msymdq - abs(msymdq)/msymdq
          where( abs(msymdqi) > kk ) msymdqi = msymdqi
     &                                       - abs(msymdqi) / msymdqi
          kk = kk - 1
        endif
      end do

      n = maxval( abs(msymdq) )
      boucle_i: do i = 1,n
        do k = 1,3
          do l = 1,3
            do m = 1,3
              if( abs(msymdq(k,l,m)) == i .or. 
     &            abs(msymdqi(k,l,m)) == i ) cycle boucle_i
            end do
          end do
        end do
        where( abs(msymdq) > i ) msymdq = msymdq - abs(msymdq) / msymdq
        where( abs(msymdqi) > i ) msymdqi = msymdqi
     &                                       - abs(msymdqi) / msymdqi
      end do boucle_i
 
      return
      end

!*********************************************************************

! Calcul du tenseur quadrupole-quadrupole

      subroutine tensqq(iopsymt,magnet)

      use declarations
      integer im(3), iopsymt(nopsm)

      logical magnet
      logical, dimension(81):: impos, imposi      

      real(kind=db):: matopsym(3,3)

      common/msym/ msymdd(3,3), msymddi(3,3), msymdq(3,3,3), 
     &             msymdqi(3,3,3), msymdo(3,3,3,3), msymdoi(3,3,3,3),
     &             msymqq(3,3,3,3), msymqqi(3,3,3,3)

      msymqq(:,:,:,:) = 0; msymqqi(:,:,:,:) = 0
      impos(:) = .false.
      if( magnet ) then
       imposi(:) = .false. 
      else
       imposi(:) = .true.  
      endif

      kkk = 0
      do i = 1,3
        do j = i,3
          do k = 1,3
            do l = k,3
              if( msymqq(i,j,k,l) /= 0 .or. msymqqi(i,j,k,l) /= 0) cycle
              kkk = kkk + 1
              msymqq(i,j,k,l) = kkk
              msymqq(j,i,k,l) = kkk
              msymqq(i,j,l,k) = kkk
              msymqq(j,i,l,k) = kkk
              msymqq(k,l,i,j) = kkk
              msymqq(l,k,i,j) = kkk
              msymqq(k,l,j,i) = kkk
              msymqq(l,k,j,i) = kkk
              if( i /= k .or. j /= l ) then
                msymqqi(i,j,k,l) = kkk
                msymqqi(j,i,k,l) = kkk
                msymqqi(i,j,l,k) = kkk
                msymqqi(j,i,l,k) = kkk
                msymqqi(k,l,i,j) = - kkk
                msymqqi(l,k,i,j) = - kkk
                msymqqi(k,l,j,i) = - kkk
                msymqqi(l,k,j,i) = - kkk
              endif 

              do iss = 2,min(48,nopsm)

                is = iordresym(iss)
                if( is > 48 ) cycle
                if( iopsymt(is) == 0 ) cycle
                isgmag = iopsymt(is)
                call opsym(is,matopsym)
                do ii = 1,3
                  do jj = 1,3
                    if( abs(matopsym(jj,ii)) < 0.0001_db ) cycle
                    im(ii) = jj * nint( matopsym(jj,ii) )
                    exit
                  end do
                end do
                ii = abs( im(i) )
                iis = ii / im(i)
                jj = abs( im(j) )
                jjs = jj / im(j)
                kk = abs( im(k) )
                kks = kk / im(k)
                ll = abs( im(l) )
                lls = ll / im(l)
                isg = iis * jjs * kks * lls
                isgi = isg * isgmag

                if( ( isg > 0 .and. msymqq(ii,jj,kk,ll) == - kkk ) .or.
     &              ( isg < 0 .and. msymqq(ii,jj,kk,ll) == kkk ) )
     &                                               impos(kkk) = .true.
                if( ( isgi > 0 .and. msymqqi(ii,jj,kk,ll) == - kkk ).or.
     &            ( isgi < 0 .and. msymqqi(ii,jj,kk,ll) == kkk ) )  
     &                                               imposi(kkk) =.true.

                if( .not. impos(kkk) ) then 
                  msymqq(ii,jj,kk,ll) = isg * kkk
                  msymqq(jj,ii,kk,ll) = isg * kkk
                  msymqq(ii,jj,ll,kk) = isg * kkk
                  msymqq(jj,ii,ll,kk) = isg * kkk
                  msymqq(kk,ll,ii,jj) = isg * kkk
                  msymqq(ll,kk,ii,jj) = isg * kkk
                  msymqq(kk,ll,jj,ii) = isg * kkk
                  msymqq(ll,kk,jj,ii) = isg * kkk
                endif

                if( .not. imposi(kkk) .and. isgmag /= 0 ) then 
                  msymqqi(ii,jj,kk,ll) = isgi * kkk
                  msymqqi(jj,ii,kk,ll) = isgi * kkk
                  msymqqi(ii,jj,ll,kk) = isgi * kkk
                  msymqqi(jj,ii,ll,kk) = isgi * kkk
                  msymqqi(kk,ll,ii,jj) = - isgi * kkk
                  msymqqi(ll,kk,ii,jj) = - isgi * kkk
                  msymqqi(kk,ll,jj,ii) = - isgi * kkk
                  msymqqi(ll,kk,jj,ii) = - isgi * kkk
                endif

              end do

            end do
          end do
        end do
      end do

      kkkmax = kkk
      kk = 0
      do kkk = 1,kkkmax
        kk = kk + 1
        if( impos(kkk) ) where( abs(msymqq) == kk ) msymqq = 0
        if( imposi(kkk) ) where( abs(msymqqi) == kk ) msymqqi = 0
        if( impos(kkk) .and. imposi(kkk) ) then
          where( abs(msymqq) > kk ) msymqq = msymqq - abs(msymqq)/msymqq
          where( abs(msymqqi) > kk ) msymqqi = msymqqi
     &                                       - abs(msymqqi) / msymqqi
          kk = kk - 1
        endif
      end do

      n = maxval( abs(msymqq) )
      boucle_i: do i = 1,n
        do j = 1,3
          do k = 1,3
            do l = 1,3
              do m = 1,3
                if( abs(msymqq(j,k,l,m)) == i .or. 
     &              abs(msymqqi(j,k,l,m)) == i ) cycle boucle_i
              end do
            end do
          end do
        end do
        where( abs(msymqq) > i ) msymqq = msymqq - abs(msymqq) / msymqq
        where( abs(msymqqi) > i ) msymqqi = msymqqi
     &                                       - abs(msymqqi) / msymqqi
      end do boucle_i
 
      return
      end

!*********************************************************************

! Calcul du tenseur dipole-octupole

      subroutine tensdo(iopsymt,magnet)

      use declarations
      integer im(3), iopsymt(nopsm)

      logical magnet
      logical, dimension(81):: impos, imposi      

      real(kind=db):: matopsym(3,3)

      common/msym/ msymdd(3,3), msymddi(3,3), msymdq(3,3,3), 
     &             msymdqi(3,3,3), msymdo(3,3,3,3), msymdoi(3,3,3,3),
     &             msymqq(3,3,3,3), msymqqi(3,3,3,3)

      msymdo(:,:,:,:) = 0; msymdoi(:,:,:,:) = 0 
      impos(:) = .false.
      if( magnet ) then
       imposi(:) = .false. 
      else
       imposi(:) = .true.  
      endif

      kkk = 0
      do i = 1,3
        do j = 1,3
          do k = j,3
            do l = k,3
              if( msymdo(i,j,k,l) /= 0 .or. msymdoi(i,j,k,l) /= 0 )cycle
              kkk = kkk + 1
              msymdo(i,j,k,l) = kkk
              msymdo(i,j,l,k) = kkk
              msymdo(i,k,j,l) = kkk
              msymdo(i,l,j,k) = kkk
              msymdo(i,k,l,j) = kkk
              msymdo(i,l,k,j) = kkk
              msymdoi(i,j,k,l) = kkk
              msymdoi(i,j,l,k) = kkk
              msymdoi(i,k,j,l) = kkk
              msymdoi(i,l,j,k) = kkk
              msymdoi(i,k,l,j) = kkk
              msymdoi(i,l,k,j) = kkk

              do iss = 2,min(48,nopsm)

                is = iordresym(iss)

                if( iopsymt(is) == 0 ) cycle
                isgmag = iopsymt(is)
                call opsym(is,matopsym)
                do ii = 1,3
                  do jj = 1,3
                    if( abs(matopsym(jj,ii)) < 0.0001_db ) cycle
                    im(ii) = jj * nint( matopsym(jj,ii) )
                    exit
                  end do
                end do
                ii = abs( im(i) )
                iis = ii / im(i)
                jj = abs( im(j) )
                jjs = jj / im(j)
                kk = abs( im(k) )
                kks = kk / im(k)
                ll = abs( im(l) )
                lls = ll / im(l)
                isg = iis * jjs * kks * lls
                isgi = isg * isgmag

                if( ( isg > 0 .and. msymdo(ii,jj,kk,ll) == - kkk ) .or.
     &              ( isg < 0 .and. msymdo(ii,jj,kk,ll) == kkk ) )
     &                                               impos(kkk) = .true.
                if( ( isgi > 0 .and. msymdoi(ii,jj,kk,ll) == - kkk ).or.
     &              ( isgi < 0 .and. msymdoi(ii,jj,kk,ll) == kkk ) ) 
     &                                               imposi(kkk) =.true.


                if( .not. impos(kkk) ) then 
                  msymdo(ii,jj,kk,ll) = isg * kkk
                  msymdo(ii,jj,ll,kk) = isg * kkk
                  msymdo(ii,kk,jj,ll) = isg * kkk
                  msymdo(ii,ll,jj,kk) = isg * kkk
                  msymdo(ii,kk,ll,jj) = isg * kkk
                  msymdo(ii,ll,kk,jj) = isg * kkk
                endif

                if( .not. impos(kkk) .and. isgmag /= 0 ) then 
                  msymdoi(ii,jj,kk,ll) = isgi * kkk
                  msymdoi(ii,jj,ll,kk) = isgi * kkk
                  msymdoi(ii,kk,jj,ll) = isgi * kkk
                  msymdoi(ii,ll,jj,kk) = isgi * kkk
                  msymdoi(ii,kk,ll,jj) = isgi * kkk
                  msymdoi(ii,ll,kk,jj) = isgi * kkk
                endif

              end do

            end do
          end do
        end do
      end do

      kkkmax = kkk
      kk = 0
      do kkk = 1,kkkmax
        kk = kk + 1
        if( impos(kkk) ) where( abs(msymdo) == kk ) msymdo = 0
        if( imposi(kkk) ) where( abs(msymdoi) == kk ) msymdoi = 0
        if( impos(kkk) .and. imposi(kkk) ) then
          where( abs(msymdo) > kk ) msymdo = msymdo - abs(msymdo)/msymdo
          where( abs(msymdoi) > kk ) msymdoi = msymdoi
     &                                       - abs(msymdoi) / msymdoi
          kk = kk - 1
        endif
      end do

      n = maxval( abs(msymdo) )
      boucle_i: do i = 1,n
        do j = 1,3
          do k = 1,3
            do l = 1,3
              do m = 1,3
                if( abs(msymdo(j,k,l,m)) == i .or. 
     &              abs(msymdoi(j,k,l,m)) == i ) cycle boucle_i
              end do
            end do
          end do
        end do
        where( abs(msymdo) > i ) msymdo = msymdo - abs(msymdo) / msymdo
        where( abs(msymdoi) > i ) msymdoi = msymdoi
     &                                       - abs(msymdoi) / msymdoi
      end do boucle_i
 
      return
      end

!***********************************************************************

      subroutine prodvec(u,v,w)

      use declarations
      real(kind=db), dimension(3):: u, v, w

      u(1) = v(2) * w(3) - v(3) * w(2)
      u(2) = v(3) * w(1) - v(1) * w(3)
      u(3) = v(1) * w(2) - v(2) * w(1)

      return
      end

!***********************************************************************

      subroutine prodvec_cp(u,v,w)

      use declarations
      complex(kind=db), dimension(3):: u, v, w

      u(1) = v(2) * w(3) - v(3) * w(2)
      u(2) = v(3) * w(1) - v(1) * w(3)
      u(3) = v(1) * w(2) - v(2) * w(1)

      return
      end

!***********************************************************************

! Calcul direct de l'inverse d'une matrice 3 x 3

      subroutine invermat(a,b)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      real(kind=db), dimension(3,3):: a, b, cofac
      real(kind=db), dimension(2,2):: c

      n = 3

      do i = 1,n
        do j = 1,n

          do i1 = 1,n
            do j1 = 1,n
              if( i1 == i .or. j1 == j) cycle
              if( i1 < i ) then
                i2 = i1
              else
                i2 = i1 - 1
              endif
              if( j1 < j ) then
                j2 = j1
              else
                j2 = j1 - 1
              endif
              c(i2,j2) = a(i1,j1)
            end do
          end do
          cofac(i,j) = ( c(1,1)*c(2,2) - c(1,2)*c(2,1) ) * (-1)**(i+j)

        end do
      end do

      det = sum( a(1,:) * cofac(1,:) )

      b = transpose( cofac ) / det

      return
      end

!*********************************************************************

      subroutine cal_iaeqrmt(iaabs,iaproto,iapot,igreq,igroup,ipr0,
     &         n_atom_proto,natomp,ngreq,ngroup,non_exc_g,self_non_exc)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer, dimension(natomp):: igroup, iaproto
      integer, dimension(ipr0:n_atom_proto):: iapot, ngreq 
      integer, dimension(ipr0:n_atom_proto,ngroup):: igreq 

      logical non_exc_g, self_non_exc

      iapot(:) = 0
! Choix des atomes prototypiques dont le potentiel sera calcule
      if( ipr0 == 0 ) iapot(ipr0) = iaabs
      do ipr = 1,n_atom_proto
        iapot(ipr) = 0
        boucle_ia: do ia = 1,natomp
          if( ia == iaabs .and. .not. self_non_exc ) cycle
          do igr = 1,ngreq(ipr)
            if( igroup(ia) == igreq(ipr,igr) ) then
              iapot(ipr) = ia
              exit boucle_ia
            endif
          end do
        end do boucle_ia
      end do

      do ia = 1,natomp
        boucle_i: do ipr = 1,n_atom_proto
          do igr = 1,ngreq(ipr)
            if( igroup(ia) == igreq(ipr,igr) ) exit boucle_i
          end do
        end do boucle_i
        iaproto(ia) = ipr
      end do

      if( .not. non_exc_g ) iaproto(iaabs) = ipr0

      return
      end

!*********************************************************************

! Calcul de l'absorption avant seuil

      real(kind=db) function fpp_cal(icheck,ipr0,it0,itypepr,
     &              n_atom_proto,ngreq,ntype,numat,self_abs,Taux_ipr)

      use declarations
      implicit none

      integer icheck, ipr, ipr0, it0, n_atom_proto, ntype, Z
      integer, dimension(it0:ntype):: numat
      integer, dimension(ipr0:n_atom_proto):: itypepr, ngreq

      logical self_abs
      
      real(kind=db):: Ea, fpp_avantseuil, x
      real(kind=db), dimension(2):: eseuil
      real(kind=db), dimension(n_atom_proto):: fppa, Taux_ipr

      common/eseuil/ eseuil

      do ipr = 1,n_atom_proto
        Z = numat( itypepr( ipr ) )
        Ea = eseuil(1) - 1.
        call fprime(Z,Ea,fppa(ipr),x)
        fpp_avantseuil = fpp_avantseuil + Taux_ipr(ipr) * ngreq(ipr)
     &                                  * fppa(ipr) 
      end do

      if( icheck > 0 ) then
        write(3,310)
        do ipr = 1,n_atom_proto
          write(3,320) ipr, numat( itypepr(ipr) ), fppa(ipr) 
        end do
        write(3,330) fpp_avantseuil 
      endif   

      if( self_abs ) then
        fpp_cal = fpp_avantseuil
      else
        fpp_cal = 0._db
      endif

      return

  310 format(/' Absorption before the edge :',/
     &        ' Site  Z      fpp (per atom)')
  320 format(2i4,1p,e13.5)
  330 format(/' Total :',1p,e13.5,' nbr. of electron')
      end

!*********************************************************************

! Sousprogramme effectuant certaines preparations pour le DAFS

      subroutine prepdafs(angpoldafs,Axe_atom_gr,
     &        hkl_dafs,igreq,ipr0,iprabs,isigpi,it0,itabs,
     &        itypepr,lvval,magnetic,mpirank,n_atom_proto,natomsym,
     &        ngreq,ngrm,ngroup,nlat,nlatm,nphim,npldafs,nrato,nrm,
     &        nspin,ntype,numat,phdafs,phdf0t,phdf0tscan,phdt,phdtscan,
     &        poldafse,poldafsei,poldafss,poldafssi,poldafsescan,
     &        poldafssscan,popatm,posn,psival,
     &        quadrupole,rato,Taux_oc,temp,vecdafse,vecdafss,
     &        vecdafsescan,vecdafssscan)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      character(len=4) elemv
      character(len=2) Chemical_symbol

      complex(kind=db):: cfac  
      complex(kind=db), dimension(3):: vec_a, vec_b, pe, ps
      complex(kind=db), dimension(npldafs):: phdf0t, phdt, v_vec_a,
     &                                      v_vec_b
      complex(kind=db), dimension(npldafs,nphim):: phdf0tscan, phdtscan
      complex(kind=db), dimension(natomsym,npldafs):: phdafs 
      complex(kind=db), dimension(n_atom_proto,ngrm,npldafs):: Bragg
      complex(kind=db), dimension(:,:,:), allocatable :: phd_fmo,phd_fms
      complex(kind=db), dimension(n_atom_proto,npldafs):: phd, phd_f0,
     &                  phd_fan, phd_fmag   
      complex(kind=db), dimension(3,npldafs,nphim):: poldafsescan,
     &                                              poldafssscan 

      integer, dimension(it0:ntype) :: nlat, nrato, numat
      integer, dimension(it0:ntype,nlatm):: lvval
      integer, dimension(3,npldafs) :: hkl_dafs
      integer, dimension(npldafs,2) :: isigpi
      integer, dimension(ipr0:n_atom_proto):: itypepr, ngreq
      integer, dimension(ipr0:n_atom_proto,ngroup):: igreq 
      integer, dimension(ngroup):: igr_tem 

      logical magnetic, quadrupole
      logical, dimension(npldafs):: scan

      real(kind=sg):: getf0, s
      real(kind=db):: det(0:3), konde, mat(3,3)
      real(kind=db), dimension(3):: ang, cosdir, hklred, qi, qj,
     &      qk, v, vpie, vpe, vps, vpis, vsig, vx, vy, vz, w,
     &      we, ws, wx, wy, wz
      real(kind=db), dimension(3,npldafs):: angpoldafs
      real(kind=db), dimension(ngroup):: Taux_oc
      real(kind=db), dimension(3,ngroup):: Axe_atom_g, Axe_atom_gr, posn
      real(kind=db), dimension(3,npldafs):: poldafse, poldafsei,
     &  poldafss, poldafssi, vecdafse, vecdafss
      real(kind=db), dimension(3,npldafs,nphim):: vecdafsescan,
     &                                           vecdafssscan 
      real(kind=db), dimension(0:nrm,it0:ntype):: rato
      real(kind=db), dimension(0:nrm,nlatm,it0:ntype):: psival
      real(kind=db), dimension(n_atom_proto):: fp, fpp
      real(kind=db), dimension(n_atom_proto,npldafs):: Debye, f_ms, 
     &                                                f_mo, f0
      real(kind=db), dimension(ipr0:n_atom_proto,nlatm,nspin):: popatm 

      common/axyz/ axyz(3), angxyz(3)
      common/eseuil/ eseuil(2)
      common/f_no_res/ f_no_res_mag, f_no_res_mom
      common/icheck/ icheck(24)
      common/orthmat/ orthmat(3,3), orthmati(3,3)
      common/Vec_orig/ Vec_orig(3)

      if( icheck(3) > 0 ) write(3,110)

      poldafssi(:,:) = 0._db
      poldafsei(:,:) = 0._db

! Calcul des termes de Bragg
      deuxpi = 2 * pi
      do ipr = 1,n_atom_proto
        it = itypepr( ipr ) 
        if( numat( it ) == 0 ) cycle
        igr_tem(:) = igreq(ipr,:) 
        do ipl = 1,npldafs
          do igr = 1,ngreq(ipr)
            jgr = igr_tem(igr)
            arg = deuxpi * sum( posn(:,jgr) * hkl_dafs(:,ipl) )
            Bragg(ipr,igr,ipl) = Taux_oc(jgr)
     &                         * cmplx( cos(arg), sin(arg), db )
            if( ipr == iprabs ) phdafs(igr,ipl) = Bragg(ipr,igr,ipl)
          end do
          phd(ipr,ipl) = sum( Bragg(ipr,1:ngreq(ipr),ipl) )
          if( ipr == iprabs ) phdt(ipl) = phd(ipr,ipl)
        end do
      end do

! lambda = 2 * pi / k = 2 * d * sintheta
      alfa = 0.0072973531
! En S.I. vecond = k = E*alfa*4*pi*epsilon0 / (e*e)
! En ua et rydb : k = 0.5 * alfa * E
      konde = 0.5_db * alfa * eseuil(1)    ! exact que pour nbseuil = 1

      istop = 0
      cosdir(:) = cos( angxyz(:) * pi / 180 )

      do ipl = 1,npldafs

        if( hkl_dafs(1,ipl) == 0 .and. hkl_dafs(2,ipl) == 0 .and.
     &      hkl_dafs(3,ipl) == 0 ) then

          dhkl = 0._db
          thetabragg = 0._db

        else
 
          hklred(:) = hkl_dafs(:,ipl) / axyz(:)
          do i = 0,3
            do j = 1,3
              mat(j,j) = 1._db
            end do
            mat(1,2) = cosdir(3)
            mat(1,3) = cosdir(2)
            mat(2,3) = cosdir(1)
            mat(2,1) = mat(1,2)
            mat(3,1) = mat(1,3)
            mat(3,2) = mat(2,3)
            if( i > 0 ) mat(:,i) = hklred(:)
            det(i) = detmat(mat)
          end do
! Distance interplan
          dhkl = sqrt( det(0) / sum( hklred(1:3) * det(1:3) ) )
          fac = abs( pi / ( konde * dhkl ) )

          if( fac > 1._db .and. mpirank == 0 ) then
            if( istop == 0 ) call write_error
            do ipr = 3,9,3
              write(ipr,120) ipl, hkl_dafs(:,ipl)
            end do
            istop = 1
            cycle
          endif

          thetabragg = asin( pi / ( konde * dhkl ) )

        endif

! Quand angpoldafs(3,ipl) = 10000, polarisation et veconde sont imposes 
        if( angpoldafs(3,ipl) < 9999._db ) then

          sinb = sin( thetabragg )
          cosb = cos( thetabragg )

! Vecteur diffraction dans la base orthogonale interne
          vx(:) = orthmat(:,1)
          vy(:) = orthmat(:,2)
          vz(:) = orthmat(:,3)

! wx, wy, wz : base du reseau reciproque
          call prodvec(wx,vy,vz)

          vol = sum( wx(:) * vx(:) )
          wx(:) = wx(:) / vol
          call prodvec(wy,vz,vx)
          wy(:) = wy(:) / vol
          call prodvec(wz,vx,vy)
          wz(:) = wz(:) / vol

          qk(:) = hkl_dafs(1,ipl) * wx(:) + hkl_dafs(2,ipl) * wy(:)
     &          + hkl_dafs(3,ipl) * wz(:)
          qkn = sqrt( sum( qk(:)**2 ) )
          if( abs(qkn) > eps10 ) then
            qk(:) = qk(:) / qkn
          else
! Cas speculaire
            qk(1:2) = 0._db; qk(3) = 1._db
          endif
! On prend l'origine de l'azimut selon le plan (Q,Vec_orig)
! si pas possible, on prend selon (Q,Ox) ou (Q,Oz).
          do i = 1,3
            select case(i)
              case(1)
                v(:) = Vec_orig(:)
              case(2)
                v(1) = 1._db; v(2:3) = 0._db
              case(3)
                v(1:2) = 0._db; v(3) = 1._db
            end select
            v = matmul( orthmat, v )
            call prodvec(w,qk,v)
            wn = sqrt( dot_product(w,w) )
            if( wn > eps10 ) exit
          end do
          w(:) = w(:) / wn
          call prodvec(qi,w,qk)
          call prodvec(qj,qk,qi)

          if( icheck(3) > 1 ) then
            write(3,130) hkl_dafs(:,ipl)
            write(3,140) ( wx(i)/bohr, wy(i)/bohr, wz(i)/bohr, i = 1,3 )
            write(3,150) ( qi(i), qj(i), qk(i), i = 1,3 )
          endif

          if( angpoldafs(1,ipl) < -9999._db .or. 
     &        angpoldafs(2,ipl) < -9999._db .or. 
     &        angpoldafs(3,ipl) < -9999._db ) then 
            scan(ipl) = .true.
            nphit = nphim
            dp = 2 * pi / nphim
          else
            scan(ipl) = .false.
            nphit = 1
          endif

          if( angpoldafs(1,ipl) > -9999._db ) then 
            cos_pe = cos( angpoldafs(1,ipl) )
            sin_pe = sin( angpoldafs(1,ipl) )
          endif
          if( angpoldafs(2,ipl) > -9999._db ) then 
            cos_ps = cos( angpoldafs(2,ipl) )
            sin_ps = sin( angpoldafs(2,ipl) )
          endif

          do ip = 1,nphit

            if( angpoldafs(1,ipl) < -9999._db ) then 
              angle = ( ip - 1 ) * dp
              cos_pe = cos( angle )
              sin_pe = sin( angle )
            elseif( angpoldafs(2,ipl) < -9999._db ) then 
              angle = ( ip - 1 ) * dp
              cos_ps = cos( angle )
              sin_ps = sin( angle )
            endif
            if( angpoldafs(3,ipl) < -9999._db ) then
              psi = ( ip - 1 ) * dp
            else
              psi = angpoldafs(3,ipl)
            endif

            if( ip == 1 .or. angpoldafs(3,ipl) < -9999._db ) then
              sinp = sin( psi )
              cosp = cos( psi )
              v(1) = cosb * cosp
              v(2) = cosb * sinp
              v(3) = - sinb
              we(:) = v(1) * qi(:) - v(2) * qj(:) + v(3) * qk(:)
              ws(:) = v(1) * qi(:) - v(2) * qj(:) - v(3) * qk(:)
              vsig(:) = sinp * qi(:) + cosp * qj(:)
              call prodvec(vpie,we,vsig)
              call prodvec(vpis,ws,vsig)
            endif

            vpe(:) = cos_pe * vsig(:) + sin_pe * vpie(:)
            vps(:) = cos_ps * vsig(:) + sin_ps * vpis(:)

            if( scan(ipl) ) then
              select case( isigpi(ipl,1) )
                case(3)
                  poldafsescan(:,ipl,ip) = cmplx( vsig(:), vpie(:), db)
     &                                   / sqrt(2._db)
                case(4)
                  poldafsescan(:,ipl,ip) = cmplx( vsig(:),-vpie(:), db)
     &                                   / sqrt(2._db)
                case default
                  poldafsescan(:,ipl,ip) = cmplx( vpe(:), 0._db, db)
              end select
              vecdafsescan(:,ipl,ip) = we(:)

              select case( isigpi(ipl,2) )
                case(3)
                  poldafssscan(:,ipl,ip) = cmplx( vsig(:), vpis(:), db)
     &                                   / sqrt(2._db)
                case(4)
                  poldafssscan(:,ipl,ip) = cmplx( vsig(:),-vpis(:), db)
     &                                   / sqrt(2._db)
                case default
                  poldafssscan(:,ipl,ip) = cmplx( vps(:), 0._db, db)
              end select
              vecdafssscan(:,ipl,ip) = ws(:)
            endif

            if( ip == 1 ) then
              select case( isigpi(ipl,1) )
                case(3)
                  poldafse(:,ipl) = vsig(:) / sqrt(2._db)
                  poldafsei(:,ipl) = vpie(:) / sqrt(2._db)
                case(4)
                  poldafse(:,ipl) = vsig(:) / sqrt(2._db)
                  poldafsei(:,ipl) = - vpie(:) / sqrt(2._db)
                case default
                  poldafse(:,ipl) = vpe(:)
              end select
              v = matmul( orthmati, we )
              vecdafse(:,ipl) = v(:)

              select case( isigpi(ipl,2) )
                case(3)
                  poldafss(:,ipl) = vsig(:) / sqrt(2._db)
                  poldafssi(:,ipl) = vpis(:) / sqrt(2._db)
                case(4)
                  poldafss(:,ipl) = vsig(:) / sqrt(2._db)
                  poldafssi(:,ipl) = - vpis(:) / sqrt(2._db)
                case default
                  poldafss(:,ipl) = vps(:)
              end select
              v = matmul( orthmati, ws )
              vecdafss(:,ipl) = v(:)

              v(:) = poldafse(:,ipl) 
              v = matmul( orthmati, v )
              poldafse(:,ipl) = v(:) 
              v(:) = poldafsei(:,ipl) 
              v = matmul( orthmati, v )
              poldafsei(:,ipl) = v(:) 
              v(:) = poldafss(:,ipl) 
              v = matmul( orthmati, v )
              poldafss(:,ipl) = v(:) 
              v(:) = poldafssi(:,ipl) 
              v = matmul( orthmati, v )
              poldafssi(:,ipl) = v(:) 

            endif

          end do

        endif

        if( hkl_dafs(1,ipl) == 0 .and. hkl_dafs(2,ipl) == 0 .and.
     &      hkl_dafs(3,ipl) == 0 ) then
          v(:) = vecdafse(:,ipl)          
          v = matmul( orthmat, v )
          w(:) = vecdafss(:,ipl)
          w = matmul( orthmat, w )
          if( mpirank == 0 .and. 
     &     ( sum(abs(v(:))) < eps10 .or. sum(abs(w(:))) < eps10 ) ) then
            call write_error
            do ipr = 3,9,3
              write(ipr,160)
            end do
            stop
          endif
! ThetaBragg is here the scattering angle 
          dot_p = min( dot_product(v,w), 1._db ) 
          thetabragg = 0.5_db * acos( dot_p )
          deltak = 2 * sin( thetabragg ) * konde 
        else
          deltak = 2 * pi / dhkl
        endif
        s = deltak / ( 4 * pi )      ! = sin(theta) / lambda
        s = s / bohr                 ! on le veut en angstroem - 1

! Debut modif Oana, attenuation due aux vibrations thermiques

        if( temp > 0.00001_db ) then

          deltak_A = deltak / bohr   ! on le veut en angstroem - 1

          temp = max (1._db, temp)      ! le cas defaut: T = 1 K

          Deb = DW(deltak_A,numat(it0),temp) 

          do ia = 1,natomsym
            phdafs(ia,ipl) = phdafs(ia,ipl) * Deb
          end do

          phdt(ipl) = phdt(ipl) * Deb

          do ipr = 1,n_atom_proto
            it = itypepr(ipr)
            Debye(it,ipl) = DW(deltak_A,numat(it),temp) 
            do igr = 1,ngreq(ipr)
              Bragg(ipr,igr,ipl) = Bragg(ipr,igr,ipl) * Debye(it,ipl)
            end do
            phd(ipr,ipl) = phd(ipr,ipl) * Debye(it,ipl)
          end do 

        endif

! Facteur de structure atomique
        do ipr = 1,n_atom_proto

          it = itypepr( ipr )
          elemv = ' ' 
          elemv(1:2) = Chemical_Symbol(numat(it))
          f0(ipr,ipl) = getf0(elemv,s)

! Diffusion magnetique non resonante
! Le moment orbital est pris parralele a l'axe de spin...          
          if( magnetic ) then
            call get_fmag(deltak,fmo,fms,ipr,ipr0,it,it0,lvval,
     &            n_atom_proto,nlat(it),nlatm,nrato(it),nrm,nspin,ntype,
     &            popatm,psival,rato) 
! Emc2 = ( 9.1093897 * 2.99792458**2 / 1.602) * 10000 / Rydb
            Emc2 = 37561.88242_db  
            f_ms(ipr,ipl) = - ( eseuil(1) / Emc2 ) * f_no_res_mag * fms
            if( f_no_res_mom < -99._db ) then 
              f_mo(ipr,ipl) = -( eseuil(1) / Emc2 ) * f_no_res_mag * fmo
            else
! Facteur 2 car f_ms correspond a S et non a 2S.
              f_mo(ipr,ipl) = 2 * f_no_res_mom * f_ms(ipr,ipl) 
            endif
          endif  
        end do

        if( icheck(3) > 0 ) then
          if( ipl == 1 ) write(3,170)
          rad = 180 / pi
          do i = 1,3
            if( angpoldafs(i,ipl) < -9999._db ) then
              ang(i) = 0._db
            else
              ang(i) = angpoldafs(i,ipl)
            endif
          end do
          write(3,180) hkl_dafs(:,ipl), thetabragg * rad,
     &             dhkl * bohr, ang(1:3)*rad,
     &             ( poldafse(i,ipl), poldafsei(i,ipl),
     &             vecdafse(i,ipl),poldafss(i,ipl), poldafssi(i,ipl),
     &             vecdafss(i,ipl), i = 1,3)
        endif

      end do

      if( istop == 1 ) stop

      if( magnetic ) then
        allocate( phd_fmo(n_atom_proto,ngrm,npldafs) )
        allocate( phd_fms(n_atom_proto,ngrm,npldafs) )
      endif

      do ipr = 1,n_atom_proto
        n = numat( itypepr( ipr ) )
! On ne tient pas compte de l'anomale de l'atome absorbeur puisqu'il est
! calcule dans le programme !
        if( n /= numat(itabs) ) then 
          call fprime(n,eseuil(1),fpp(ipr),fp(ipr))
        else
          fp(:) = 0._db; fpp(ipr) = 0._db
        endif
        do ipl = 1,npldafs
          phd_f0(ipr,ipl) = phd(ipr,ipl) * f0(ipr,ipl)
          phd_fan(ipr,ipl) = phd(ipr,ipl) * cmplx(fp(ipr), fpp(ipr), db)

          if( magnetic ) then
            if( abs(f_ms(ipr,ipl)) > eps10 ) then 
              do igr = 1,ngreq(ipr)
! Les signes moins sont pour transformer vers la convention cristallo
! (Green moins), les formules de Gibbs. Ces donnees sont utilisees dans
! la routine convolution a un endroit ou on est en Green -.
! Bragg est deja en Green -.
                phd_fms(ipr,igr,ipl) = - img * Bragg(ipr,igr,ipl)
     &                                       * f_ms(ipr,ipl)
                phd_fmo(ipr,igr,ipl) = - img * Bragg(ipr,igr,ipl)
     &                                      * f_mo(ipr,ipl)
              end do
            else
              phd_fms(ipr,:,ipl) = (0._db,0._db)
              phd_fmo(ipr,:,ipl) = (0._db,0._db)
            endif
          endif
        end do

      end do

! On repasse en base interne
      poldafse = matmul( orthmat, poldafse )
      poldafsei = matmul( orthmat, poldafsei )
      poldafss = matmul( orthmat, poldafss )
      poldafssi = matmul( orthmat, poldafssi )
      vecdafse = matmul( orthmat, vecdafse )
      vecdafss = matmul( orthmat, vecdafss )

      do ipl = 1,npldafs
        phdf0t(ipl) = sum( phd_f0(1:n_atom_proto,ipl) )
     &              + sum( phd_fan(1:n_atom_proto,ipl) )
      end do

! Multplication par epsilon_e * espilon_s
      do ipl = 1,npldafs
        if( scan(ipl) ) then
          np = nphim
        else
          np = 1
        endif
        do ip = np,1,-1
          if( ip == 1 ) then
            pe(:) = cmplx( poldafse(:,ipl), poldafsei(:,ipl), db )   
            ps(:) = cmplx( poldafss(:,ipl), poldafssi(:,ipl), db )   
          else
            pe(:) = poldafsescan(:,ipl,ip)   
            ps(:) = poldafssscan(:,ipl,ip)   
          endif
          cfac = sum( conjg( ps(:) ) * pe(:) )
          if( np > 1 ) then
            phdf0tscan(ipl,ip) = cfac * phdf0t(ipl)
            phdtscan(ipl,ip) = cfac * phdt(ipl)
          endif
          if( ip == 1 ) then
            do ipr = 1,n_atom_proto
              phd_f0(ipr,ipl) = cfac * phd_f0(ipr,ipl)
              phd_fan(ipr,ipl) = cfac * phd_fan(ipr,ipl)
            end do
            phdt(ipl) = cfac * phdt(ipl)
            phdf0t(ipl) = cfac * phdf0t(ipl)
          endif
        end do
      end do

! Voir M. Blume and Doon Gibbs, PRB, 37, 1779 (1988)
      phd_fmag(:,:) = (0._db,0._db)
      if( magnetic ) then
        Axe_atom_g = matmul( orthmat, Axe_atom_gr ) 
        do ipl = 1,npldafs
          if( scan(ipl) ) then
            np = nphim
          else
            np = 1
          endif
          do ip = np,1,-1
            if( ip == 1 ) then
              pe(:) = cmplx( poldafse(:,ipl), poldafsei(:,ipl), db )   
              ps(:) = cmplx( poldafss(:,ipl), poldafssi(:,ipl), db )   
              we(:) = vecdafse(:,ipl)   
              ws(:) = vecdafss(:,ipl)   
            else
              pe(:) = poldafsescan(:,ipl,ip)   
              ps(:) = poldafssscan(:,ipl,ip)   
              we(:) = vecdafsescan(:,ipl,ip)   
              ws(:) = vecdafssscan(:,ipl,ip)   
            endif
! Approximation pour le moment orbital pris oriente parallelement a lui.
! Voir aussi appendix de G. T. Trammell, PR 92, 1387 (1953)
            call get_vec_b(pe,ps,vec_b,we,ws)
            call get_vec_a(pe,ps,vec_a,we,ws)
            do ipr = 1,n_atom_proto 
              do igr = 1,ngreq(ipr)
                jgr = igreq(ipr,igr)
                v(:) = Axe_atom_g(:,jgr)
                v_vec_b(ipl) = dot_product(v,vec_b) 
                v_vec_a(ipl) = dot_product(v,vec_a)
                if( icheck(3) > 1 ) then
                  write(3,182) ipl
                  do i = 1,3
                    write(3,185) v(i), vec_b(i), vec_a(i)
                  end do
                  write(3,187) v_vec_b(ipl), v_vec_a(ipl)
                endif
                if( np > 1 ) phdf0tscan(ipl,ip) = phdf0tscan(ipl,ip)
     &              + v_vec_a(ipl) * phd_fmo(ipr,igr,ipl)
     &              + v_vec_b(ipl) * phd_fms(ipr,igr,ipl)
                if( ip == 1 ) then
                  phd_fmag(ipr,ipl) = phd_fmag(ipr,ipl)
     &                          + v_vec_a(ipl) * phd_fmo(ipr,igr,ipl)
     &                          + v_vec_b(ipl) * phd_fms(ipr,igr,ipl) 
                endif
              end do
            end do
          end do

          phdf0t(ipl) = phdf0t(ipl) + sum( phd_fmag(1:n_atom_proto,ipl))

        end do

      endif

      if( magnetic ) then
        deallocate( phd_fmo )
        deallocate( phd_fms )
      endif

! On passe en base cristal
      poldafse = matmul( orthmati, poldafse )
      poldafsei = matmul( orthmati, poldafsei )
      poldafss = matmul( orthmati, poldafss )
      poldafssi = matmul( orthmati, poldafssi )
      vecdafse = matmul( orthmati, vecdafse )
      vecdafss = matmul( orthmati, vecdafss )

      if( icheck(3) > 0 ) then

        if( icheck(3) > 1 ) then
          dpdeg = dp * 180 / pi
          do ipl = 1,npldafs
            if( .not. scan(ipl) ) cycle
            write(3,210) hkl_dafs(:,ipl), isigpi(ipl,:)
            do ip = 1,nphim
              pe(:) = poldafsescan(:,ipl,ip)   
              ps(:) = poldafssscan(:,ipl,ip)   
              we(:) = vecdafsescan(:,ipl,ip)   
              ws(:) = vecdafssscan(:,ipl,ip)   
              pe = matmul( orthmati, pe )
              ps = matmul( orthmati, ps )
              we = matmul( orthmati, we )
              ws = matmul( orthmati, ws )
              write(3,220)  ( ip - 1 ) * dpdeg,
     &                     real( pe(:), db ), aimag( pe(:) ),
     &                     real( ps(:), db ), aimag( ps(:) ),
     &                     we(:), ws(:)
            end do
          end do
        endif

        write(3,230)
        do ipl = 1,npldafs
          write(3,240) hkl_dafs(:,ipl), phdafs(1:natomsym,ipl)
        end do

        if( magnetic ) then
          write(3,245) f_no_res_mag
          ipl = 1  ! le rapport ne depend pas de la reflexion.
          do ipr = 1,n_atom_proto
            if( abs( f_ms(ipr,ipl) ) > eps10 ) then  
              rap_lsur2s = 0.5_db * f_mo(ipr,ipl) / f_ms(ipr,ipl)
            else
              rap_lsur2s = 0._db
            endif 
            write(3,246) ipr, rap_lsur2s 
          end do
        endif

        write(3,250)
        do ipr = 1,n_atom_proto
          if( nspin == 1 ) then
            write(3,260) ipr, numat( itypepr(ipr) )
            do ipl = 1,npldafs
              write(3,270) hkl_dafs(:,ipl), f0(ipr,ipl), fp(ipr),
     &         fpp(ipr), phd(ipr,ipl), phd_f0(ipr,ipl), phd_fan(ipr,ipl)
            end do
          else
            write(3,280) ipr, numat( itypepr(ipr) )
            do ipl = 1,npldafs
              write(3,290) hkl_dafs(:,ipl), f0(ipr,ipl), fp(ipr),
     &          fpp(ipr), f_ms(ipr,ipl), f_mo(ipr,ipl), phd(ipr,ipl),
     &          phd_f0(ipr,ipl), phd_fan(ipr,ipl),
     &          phd_fmag(ipr,ipl), v_vec_b(ipl), v_vec_a(ipl) 
            end do
          endif
        end do

        if( temp > 0.00001_db ) then
          write(3,'(/A)') ' ( h, k, l)   Z   Debye-Waller Attenuation' 
          do ipl = 1,npldafs
            do it = 1,ntype
              write(3,165) hkl_dafs(1:3,ipl), numat(it), Debye(it,ipl) 
            end do
          end do
        endif

        write(3,300)
        do ipl = 1,npldafs
          write(3,270) hkl_dafs(:,ipl), phdf0t(ipl)
        end do

      endif   

      if( .not. quadrupole ) then
        vecdafse(:,:) = 0._db
        vecdafss(:,:) = 0._db
        vecdafsescan(:,:,:) = 0._db
        vecdafssscan(:,:,:) = 0._db
      endif
 
      return
  110 format(/' ---- Prepdafs -----',100('-'))
  120 format(//' The reflection number',i3,' : (h,k,l) = (',3i3,')',
     &           ' does not exist at this energy !'//)
  130 format(/' (h,k,l) = (',3i3,')')
  140 format('  Reciprocal mesh base (A-1) :',/5x,'X',8x,'Y',8x,'Z',
     3          3(/3f9.5))
  150 format('  Local base (A-1) :',/5x,'I',8x,'J',8x,'Q',
     3          3(/3f9.5))
  160 format(' Calculations with (h,k,l) = (0,0,0) ',
     &      ' need non zero values for the  incoming and outgoing'/,
     &      ' wave vector in order to calculate the scattering angle !')
  165 format(1x,3i3,i5,10x,f9.5)
  170 format(/'  (h,k,l) ThetaBragg  d_hkl (A)',4x,
     &    'Polarization angles        poldafse',5x,
     &    'vecdafse',7x,'poldafss',5x,'vecdafss'/)
  180 format(3i3,2f10.3,2x,3f8.3,2(2x,2f8.5,2x,f8.5)/,
     &     2(55x,2(2x,2f8.5,2x,f8.5)/))
  182 format(/' ipl =',i3,//'  Spin_axis          vec_b',17x,'vec_a')
  185 format(f10.5,2(2x,2f10.5))
  187 format(/' V.Vec_b =',2f10.5,',  V.Vec_a =',2f10.5)
  210 format(/' (h,k,l) = (',3i3,'),  isigpi =',2i3,/' angle',
     &7x,'real(Poldafse)',12x,'imag(Poldafse)',10x,'real(Poldafss)',11x,
     &    'imag(Poldafse)',14x,'vecdafse',14x,'vecdafss')
  220 format(f6.1, 6(1x,3f8.4))
  230 format(/'  (h,k,l)  exp(i*Q.R_ia) (ia = 1,natomsym)')
  240 format(3i3,1p,48(1x,2e13.5))
  245 format(/' Attenuation factor for non resonant magnetic structure',
     &  ' factor :'/,'      General : fma =',f7.3,/
     &  '      Orbital : Site    L/2S     (f_orb = (L/S)*f_spin)')
  246 format(10x,i9,f9.3)
  250 format(/' Value of the structure factors per atom site :')
  260 format(/' Site =',i3,', Z =',i3,//,
     $  '  (h,k,l)',6x,'f0',14x,'fp',10x,'fpp',10x,'Ph = Sum(exp(iQR))',
     &  10x,'Ph*f0*(eps_e.eps_s)     Ph*(fp+i*fpp)*(eps_e.eps_s)')
  270 format(3i3,1p,e13.5,2x,2e13.5,5(2x,2e13.5))
  280 format(/' Site =',i3,', Z =',i3,//,
     $  '  (h,k,l)',6x,'f0',14x,'fp',10x,'fpp',11x,'f_spin',9x,
     &  'f_orb',10x,'Ph = Sum(exp(iQR))',10x,'Ph*f0*(eps_e.eps_s)',
     &  '    Ph*(fp+i*fpp)*(eps_e.eps_s)',
     &  ' i*Ph_m*fma*(f_spin*vs+f_orb*vo)   vs = spin.vec_b',13x,
     &  'vo = spin.vec_a')
  290 format(3i3,1p,e13.5,2x,2e13.5,2(2x,e13.5),6(2x,2e13.5))
  300 format(/'  (h,k,l)   Total Structure factor')

      end

!***********************************************************************

      real(kind=db) function detmat(mat)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      real(kind=db), dimension(3,3):: mat

      detmat = mat(1,1) * ( mat(2,2)*mat(3,3) - mat(3,2)*mat(2,3) )
     &       - mat(2,1) * ( mat(1,2)*mat(3,3) - mat(3,2)*mat(1,3) )
     &       + mat(3,1) * ( mat(1,2)*mat(2,3) - mat(2,2)*mat(1,3) )

      return
      end

!***********************************************************************

      function nomat(numat)

      character(len=4) nomat
      character(len=2) Chemical_Symbol

      nomat = ' '
      nomat(1:2) = Chemical_Symbol(numat)

      return
      end

!***********************************************************************

      subroutine get_fmag(deltak,fmo,fms,ipr,ipr0,it,it0,lvval,
     &      n_atom_proto,nl,nlatm,nr,nrm,nspin,ntype,popatm,psival,rato)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer, dimension(it0:ntype,nlatm):: lvval

      real(kind=db), dimension(0:nrm,it0:ntype):: rato
      real(kind=db), dimension(ipr0:n_atom_proto,nlatm,nspin):: popatm 
      real(kind=db), dimension(0:nrm,nlatm,it0:ntype):: psival

      fms = 0._db
      fmo = 0._db

      do io = 1,nl

        popt = popatm(ipr,io,1) + popatm(ipr,io,nspin)     
        spin = 0.5_db * ( popatm(ipr,io,1) - popatm(ipr,io,nspin) )     
        pop = abs( popatm(ipr,io,1) - popatm(ipr,io,nspin) )     
        
        if( abs(spin) < eps10 ) cycle

        l = lvval(it,io)
        hund_mo = ( pop * l - pop * ( pop - 1 ) / 2 ) / ( 2 * spin )
        if( popt < 2 * l + 1 ) hund_mo = - hund_mo  

        f = 0._db
! psival est en fait sqrt(4*pi)*r*psi
        do ir = 2,nr-1
          dr = rato(ir+1,it) - rato(ir-1,it)  
          f = f + ( psival(ir,io,it)**2 / rato(ir,it) )
     &          * sin( deltak * rato(ir,it) ) * dr
        end do
        f = 0.5_db * f / deltak

        fms = fms + spin * f 
        fmo = fmo + hund_mo * 2 * spin * f 

      end do

! Facteur empirique
      fmo = 0.2_db * fmo

      return
      end

!*********************************************************************

      subroutine get_vec_b(pe,ps,vec_b,we,ws)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db), dimension(3):: vec_b, kve, kvs, p, pe, ps, q,  
     &                                ve, vs

      real(kind=db), dimension(3) :: we, ws

      common/orthmat/ orthmat(3,3), orthmati(3,3)

      ve(:) = cmplx( we(:), 0._db, db )
      vs(:) = cmplx( ws(:), 0._db, db )
      ! do i = 1, 3
      !   ve(i) = cmplx( we(i), 0._db, db )
      !   vs(i) = cmplx( ws(i), 0._db, db )
      !end do
      call prodvec_cp( kve, ve, pe )
      call prodvec_cp( kvs, vs, ps )
      call prodvec_cp( p, ps, pe )
      call prodvec_cp( q, kvs, kve )

      vec_b(:) = p(:) + dot_product(vs,pe) * kvs(:)
     &         - dot_product(ve,ps) * kve(:) - q(:)

      return
      end

!*********************************************************************

! Calcul de A" dans la formule de Blume et Gibbs, PRB 37,1779 (1988).

      subroutine get_vec_a(pe,ps,vec_a,we,ws)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db), dimension(3):: vec_a, kve, kvs, p, pe, ps,
     &                                ve, vs, vv

      real(kind=db), dimension(3):: we, ws

      common/orthmat/ orthmat(3,3), orthmati(3,3)

      ve(:) = cmplx( we(:), 0._db, db )
      vs(:) = cmplx( ws(:), 0._db, db )

      vv = dot_product(ve,vs)

      call prodvec_cp( kve, ve, pe )
      call prodvec_cp( kvs, vs, ps )
      call prodvec_cp( p, ps, pe )

      vec_a(:) = 2 * ( 1 - vv ) * p(:) - dot_product(ve,ps) * kve(:)
     &         + dot_product(vs,pe) * kvs(:)

      return
      end

!*********************************************************************

      !Oana Bunau 15 avril 2007
     
      function DW(q,Z,temp)

      use declarations      
      implicit none
      
      integer Z,nassm
      parameter (nassm =103) 

      real(kind=db), dimension(nassm):: TD, mass
       
! source: Ashcroft and Mermin; the Debye temperatures correspond to the
! free element
! Unknown Debye temperatures are taken as 1
       
      data  TD / 110,  26, 400,1000,1250,1860,  79,  46,   1,  63,  !10
     &           150, 318, 394, 625,   1,   1,   1,  85, 100, 230,  !20
     &           359, 380, 390, 460, 400, 420, 385, 375, 315, 234,  !30
     &           240, 360, 285, 150,   1,  73,  56, 147, 256, 250,  !40
     &           275, 380,   1, 382, 350, 275, 215, 120, 129, 170,  !50
     &           200, 139,   1,  55,  40, 110, 132, 139, 152, 157,  !60
     &             1, 160, 107, 176, 188, 186, 191, 196, 200, 118,  !70
     &           207,   1, 225, 310, 416, 400, 430, 230, 170, 100,  !80
     &            96,  88, 120,   1,   1,   1,   1,   1,   1, 100,  !90
     &             1, 210, 188, 150,   1,   1,   1,   1,   1,   1,  !100
     &             1,   1,   1/                                     !103

       !atomic mass units 

      data  mass / 1.0079, 4.0026, 6.941,  9.0122, 10.81,     !5
     &            12.01,  14.007, 15.999, 18.998,  20.18,     !10
     &            22.9898,24.305, 26.982, 28.086,  30.974,    !15
     &            32.064, 35.453, 39.948, 39.09,   40.08,     !20
     &            44.956, 47.90,  50.942, 52.,     54.938,    !25
     &            55.85,  58.93,  58.71,  63.55,   65.38,     !30
     &            69.72,  72.59,  74.922, 78.96,   79.91,     !35
     &            83.8,   85.47,  87.62,  88.91,   91.22,     !40
     &            92.91,  95.94,  98.91, 101.07,  102.9,      !45
     &           106.4,  107.87, 112.4,  114.82,  118.69,     !50
     &           121.75, 127.6,  126.9,  131.3,   132.91,     !55
     &           137.34, 138.91, 140.12, 140.91,  144.24,     !60
     &           145,    150.35, 151.96, 157.25,  158.92,     !65
     &           162.5,  164.93, 167.26, 168.93,  173.04,     !70
     &           174.97, 178.49, 180.95, 183.85,  186.2,      !75
     &           190.2,  192.22, 195.09, 196.97,  200.59,     !80
     &           204.37, 207.19, 208.98, 210,     210,        !85
     &           222,    223,    226,    227,     232.04,     !90
     &           231,    238.03, 237.05, 244,     243,        !95
     &           247,    247,    251,    254,     257,        !100
     &           256,    254,    257/                         !103

 ! fonction de Debye, facteur de Debye Waller
      real(kind=db) Debye_function, DW, FD
 ! vecteur transfert d'impuls, en 1/A  
      real(kind=db) q                       
      real(kind=db) temp, x                  !bohr = 5.29177*10**(-11)m
                                               
      real(kind=db):: kb = 1.38054_db         !kb = 1.38054*10**(-23)J/K
      real(kind=db):: hbar = 1.05459_db       !hbar = 1.05459*10**(-34)Js

      FD = Debye_function(temp,TD(Z))

 !1 uam = 1.66053*10**(-27)kg
      x = (-3)*q**2*hbar**2*FD*10**2 / ( mass(Z) * 1.66053 *kb * TD(Z) )
      DW = EXP(x)

      ! Ecriture dans le fichier d'erreur

      if( abs(TD(Z)) < eps10 ) then
        call write_error
        write(9,*) ' Debye temperature is not available for the',
     &  ' element with Z =', Z
        stop
      end if

      end

!*********************************************************************

      function Debye_function(m,n)

      use declarations
      real(kind=db) m,n,dx,a,x,Debye_function
      integer i,imax
      Debye_function = 0._db

      a = n/m
      dx = 0.0001_db
      imax = Nint(a/dx)
      dx = a/imax
      x = dx/2

      do i = 1,imax
       x = x + dx
       Debye_function = Debye_function + ( dx*x /( EXP(x)-1 ) )
      end do
      
      Debye_function = (m/n)**2 * Debye_function + 0.25_db
      
      end

!*********************************************************************

! Sousprogramme �valuant les orbitales sond�es par les r�gles de 
! s�lection des transitions

      subroutine etafin(Atom_comp_abs,lmoins1,lplus1,mpirank,nb_rep,
     &              nbseuil,ngrph,nspino,spinorbite,state_all)

      use declarations
      implicit real(kind=db) (a-h,o-z)
 
      complex(kind=db):: gnt

      integer, dimension(2):: ninitl
      integer, dimension(6):: loperat, moperat
      integer, dimension(nlfm):: iselec, lselec, mselec

      logical Atom_comp_abs, comp_dd, comp_md, comp_do, comp_dq, 
     &        comp_mm, comp_qq, lmoins1, lplus1,   
     &        spinorbite, state_all, sym_4, sym_cubic

      real(kind=db):: jinitl(2), jzinitl

      common/comp_dd/ comp_dd, comp_md, comp_do, comp_dq,comp_mm,comp_qq 
      common/icheck/ icheck(24)
      common/ldip/ ldip(3), loct(3,3,3), lqua(3,3)
      common/lseuil/ jseuil, lseuil, nseuil
      common/msym/ msymdd(3,3), msymddi(3,3), msymdq(3,3,3), 
     &             msymdqi(3,3,3), msymdo(3,3,3,3), msymdoi(3,3,3,3),
     &             msymqq(3,3,3,3), msymqqi(3,3,3,3)
      common/sym_cubic/ sym_4, sym_cubic

      if( icheck(5) > 0 )  write(3,110)

      linitl = lseuil

! Calcul du (l,m) = (linitl,minitl) de l'etat initial
      select case(jseuil)
        case(1,3,5,7)
          isinitl = 1
        case default
          isinitl = -1
      end select

      do iseuil = 1,nbseuil
        if( iseuil == 2 ) isinitl = - isinitl
        jinitl(iseuil) = linitl + 0.5_db * isinitl
        ninitl(iseuil) = nint( 2 * jinitl(iseuil) + 1 )
      end do

      if( Atom_comp_abs ) then
        nsm = 2
      else
        nsm = 1
      endif

! Calcul des (l,m) = (lselec,mselec) des etats d'arrivee
      lf = 0
! Boucle sur toutes les transitions possibles, on est dans la base de
! l'atome absorbeur.
      do kv2 = 0,3
      do kvo = 0,3
      do kpl = 1,3
        if( kvo == 0 ) then
          if( ldip(kpl) == 0 ) cycle
        else
          if( kvo < kpl ) cycle
        endif
        if( kv2 == 0 ) then
          if( kvo > 0 ) then
            if( lqua(kpl,kvo) == 0 ) cycle
          endif
        else
          if( kv2 < kvo .or. kvo == 0 ) cycle
          if( loct(kpl,kvo,kv2) == 0 ) cycle
        endif

! Calcul du (l,m) = (loperat,moperat) de la transition
        call lmtrans(kpl,kvo,kv2,noperat,loperat,moperat,spinorbite)
        if( icheck(5) > 1 ) then
          if( kvo == 0 ) then
            write(3,130) kpl
          elseif( kv2 == 0 ) then
            write(3,140) kpl, kvo
          else
            write(3,150) kpl, kvo, kv2
          endif
          do iop = 1,noperat
            write(3,160) loperat(iop), moperat(iop)
          end do
        endif

        do iseuil = 1,nbseuil

          do initl = 1,ninitl(iseuil)
            jzinitl = - jinitl(iseuil) + initl - 1

            do ispin = 1,2
              m_initl = nint( jzinitl + ispin - 1.5_db ) 
              jspin = min(ispin,nspino) 
              if( m_initl > linitl .or. m_initl < -linitl ) cycle

              do iop = 1,noperat
                lo = loperat(iop)
                mo = moperat(iop)

                lf1 = abs( linitl - lo )
                lf2 = linitl + lo
                if( lplus1 ) lf1 = lf2
                if( lmoins1 ) lf2 = lf1

                m = mo + m_initl

                boucle_ll: do l = lf1,lf2,2
      
                  if( m > l .or. m < -l ) cycle
!                    lq = l + 4
!                  else
!                    lq = l
!                  endif                  

                  if( spinorbite .or. Atom_comp_abs ) then

                    boucle_ism: do ism = 1,nsm
                      if( ism == 1 ) then
                        mm = m
                      else
                        if( m == 0 ) cycle
                        mm = - m
                      endif
                      do lg = 1,lf
                        if( lselec(lg) == l .and. mselec(lg) == mm 
     &                      .and. iselec(lg) == jspin ) cycle boucle_ism
                      end do 
                      lf = lf + 1
                      if( lf > nlfm ) cycle
                      lselec(lf) = l
                      mselec(lf) = mm
                      iselec(lf) = jspin
                    end do boucle_ism

                  else  ! on passe en base reelle

                    do ms = -1,1,2  
                      if( m_initl == 0 .and. ms == 1 ) exit
                      mi = ms * abs( m_initl )
                      gnt = gauntc(l,m,lo,mo,linitl,mi)
                      if( abs(gnt) < eps6 ) cycle
                      do lg = 1,lf
                        if( lselec(lg) == l .and. mselec(lg) == m )
     &                                                 cycle boucle_ll
                      end do 
                      lf = lf + 1
                      if( lf > nlfm ) cycle
                      lselec(lf) = l
                      mselec(lf) = m
                      iselec(lf) = jspin
                    end do

                  endif

                end do boucle_ll
              end do

            end do  ! fin de la boucle sur les operateurs

           end do
        end do
      end do
      end do
      end do
      nselec = lf

      if( sym_cubic ) then
        do lf = 1,nselec
          if( lselec(lf) == 2 ) exit       
        end do
        if( lf < nselec + 1 ) then
          do lg = lf,nselec
            if( lselec(lg) == 2 .and. mselec(lg) == - 2 ) exit
          end do
          if( lg == nselec + 1 ) then
            nselec = nselec + 1
            lselec(nselec) = 2 
            mselec(nselec) = -2 
            iselec(nselec) = 1
          endif 
        endif
      endif

      if( nselec > nlfm .and. mpirank == 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,170) nselec, nlfm
        end do
        stop
      endif

      if( state_all ) then
        call irep_util_all(nb_rep,ngrph,nspino,spinorbite)
      else
        call cal_irep(iselec,lselec,mselec,nb_rep,ngrph,nselec,
     &              nspino,spinorbite)
      endif

      return
  110 format(/' ---- Etafin -------',100('-'))
  130 format(/' Dipole, kpl =',i2)
  140 format(/' Quadrupole, kpl =',i2,', kvo =',i2)
  150 format(/' Octupole, kpl =',i2,', kvo =',i2,', kv2 =',i2)
  160 format('   (loperat,moperat) = (',2i2,')')
  170 format(/' nselec =',i2,' > nlfm =',i2,', Increase this parameter',
     &  ' in nesparam.inc !'//)
      end

!*********************************************************************

      subroutine cal_irep(iselec,lselec,mselec,nb_rep,ngrph,nselec,
     &              nspino,spinorbite) 

      use declarations
      implicit real(kind=db) (a-h,o-z)

      character(len=9):: nomsym

      complex(kind=db), dimension(nopsm,nrepm):: karact
      complex(kind=db), dimension(nopsm):: kopsymo

      integer, dimension(nrepm):: nlmrep
      integer, dimension(nlfm):: irepo, lass
      integer, dimension(nrepm,nlfm):: lmrep
      integer, dimension(nlfm):: iselec, lselec, mselec

      logical spinorbite
      logical, dimension(nlfm):: fait

      common/irep_util/ irep_util(nrepm,2)
      common/icheck/ icheck(24)
      common/iopsymr/ iopsymr(nopsm)
      common/karact/ karact

      if( icheck(5) > 1 ) then
        write(3,110)
        write(3,120)
        call write_iopsym(iopsymr,3)
      endif

      irepo(:) = 0
      lass(:) = 0
      fait(:) = .false.
      do lf = 1,nselec

        if( fait(lf) ) cycle

        l = lselec(lf)
        m = mselec(lf)
        ispin = iselec(lf)
        fait(lf) = .true.

        do isp = 1,nspino

          if( isp == 2 ) then
            if( ispin == 1 ) then
              m = m + 1
            else
              m = m - 1
            endif
            ispin = 3 - ispin
            if( m > l .or. m < -l ) cycle 
!            if( m > l .or. m < -l ) then 
!              lq = l + 4
!            else
!              lq = l
!            endif
            do lg = 1,nselec
              if( fait(lg) ) cycle
              if( lselec(lg) == l .and. mselec(lg) == m .and. 
     &            iselec(lg) == ispin ) exit
            end do
            fait(lg) = .true.
            lass(lf) = lg
            lass(lg) = lf
          endif

! Calcul des characteres des orbitales d'arrivee :
! Dans la base de l'atome absorbeur
          call symorb(l,m,kopsymo)

! Recherche de la representation a laquelle appartient l'orbitale
          boucle_irep: do irep = 1,nb_rep

            do is = 1,nopsm
              if( iopsymr(is) == 0 ) cycle
              if( abs( karact(is,irep) - kopsymo(is) ) > eps10 ) 
     &          cycle boucle_irep
            end do
            if( isp == 1 ) then
              irepo(lf) = irep
            else
              irepo(lg) = irep
            endif
            exit 

          end do boucle_irep

          if( irep == nb_rep + 1 .and. icheck(5) > 0 ) write(3,130) l, m
        end do
      end do

      if( spinorbite ) then
        do lf = 1,nselec
          l = lselec(lf) 
          m = - mselec(lf) 
          if( irepo(lf) /= 0 ) cycle
          do lg = 1,nselec
            if( l == lselec(lg) .and. m == mselec(lg) ) exit
          end do
          if( lg == nselec + 1 ) then 
            call symorb(l,m,kopsymo)
            boucle_irep2: do irep = 1,nb_rep
              do is = 1,nopsm
                if( iopsymr(is) == 0 ) cycle
                if( abs( karact(is,irep) - kopsymo(is) ) > eps10 ) 
     &            cycle boucle_irep2
              end do
              irepo(lf) = - irep
            end do boucle_irep2
          else             
            irepo(lf) = - irepo(lg)
          endif             
        end do
      endif

      if(icheck(5) > 1 .and. lf <= nlfm ) then
        write(3,'(/A)') '  lselec mselec iselec  irep   lass'
        do lf = 1,nselec
          write(3,190) lselec(lf), mselec(lf), iselec(lf), irepo(lf),
     &                 lass(lf)
        end do
      endif

      ngrph = 0
      irep_util(:,:) = 0

      if( nb_rep == 1 ) then
        ngrph = 1
        irep_util(ngrph,:) = 1
      else
        boucle_l: do lf = 1,nselec
          if( irepo(lf) == 0 ) cycle 
          lg = lass(lf)
          ispin = iselec(lf)
          isp = nspino + 1 - ispin
          do igrph = 1,ngrph
            if( lg /= 0 .and. irep_util(igrph,isp) /= 0 ) then
              if( irep_util(igrph,ispin) == irepo(lf) .and.
     &            irep_util(igrph,isp) == irepo(lg) ) cycle boucle_l
            else
              if( irep_util(igrph,ispin) == irepo(lf) ) then
                if( lg /= 0 ) irep_util(ngrph,isp) = irepo(lg)
                cycle boucle_l
              endif
            endif
          end do
          ngrph = ngrph + 1
          irep_util(ngrph,ispin) = irepo(lf)
          if( lg /= 0 ) irep_util(ngrph,isp) = irepo(lg)
        end do boucle_l
      endif

      nlmrep(:) = 0
      boucle_igrph: do igrph = 1,ngrph
        do lf = 1,nselec
          if( irepo(lf) /= irep_util(igrph,iselec(lf)) ) cycle
          nlmrep(igrph) = nlmrep(igrph) + 1
          lmrep(igrph,nlmrep(igrph)) = lf 
        end do
      end do boucle_igrph

! Cas ou aucune fonction n'a ete trouve pour une des 2 representations
      if( spinorbite ) then
        do igrph = 1,ngrph
          do lf = 1,nselec
            if( irep_util(igrph,1) /= 0 .and. 
     &                            irep_util(igrph,nspino) /= 0 ) cycle
            lm = lmrep(igrph,1) 
            isp = iselec(lm)
            l = lselec(lm) 
            m = mselec(lm)

            if( isp == 1 ) then
              m = m + 1
            else
              m = m - 1
            endif
            l = l + 4

            boucle_isg: do isg = 1,-1,-2
              m = isg * m
              call symorb(l,m,kopsymo)

              boucle_irep3: do irep = 1,nb_rep

                do is = 1,nopsm
                  if( iopsymr(is) == 0 ) cycle
                  if( abs( karact(is,irep) - kopsymo(is) ) > eps10 ) 
     &              cycle boucle_irep3 
                end do
                irep_util(igrph,nspino+1-isp) = isg * irep
                exit boucle_isg 

              end do boucle_irep3
            end do boucle_isg
          end do
        end do
      endif

      if( icheck(5) > 0 ) then
        do igrph = 1,ngrph
          write(3,220) igrph
          if( spinorbite ) then
            write(3,230) irep_util(igrph,1:nspino)
          else
            write(3,240) irep_util(igrph,1:nspino)
          endif
          write(3,'(/A)') '   Orbital belonging to the representation :'
          if( spinorbite ) then 
            write(3,250) ( lselec(lmrep(igrph,lm)), 
     &         mselec(lmrep(igrph,lm)), iselec(lmrep(igrph,lm)),
     &         lm = 1,nlmrep(igrph) )
          else
            write(3,260) ( lselec(lmrep(igrph,lm)), 
     &         mselec(lmrep(igrph,lm)), lm = 1,nlmrep(igrph) )
          endif 
          write(3,'(/A)') '     is  Symmetry    Character'
          do isp = 1,nspino
            irep = abs(irep_util(igrph,isp))
            if( irep == 0 ) cycle 
            do is = 1,nopsm
              if( abs( karact(is,irep) ) < eps10 ) cycle
              if( irep_util(igrph,isp) > 0 ) then 
                write(3,270) is, nomsym(is), karact(is,irep)
              else
                write(3,270) is, nomsym(is), conjg( karact(is,irep) )
              endif
            end do
          end do
        end do
      endif

      return
  110 format(/' ---- Cal_irep -------',100('-'))
  120 format(/' iopsymr =')
  130 format(/' Representation not found for (l,m) = (',i2,',',i2,')')
  190 format(5i7)
  220 format(/' Useful representation number',i3,' :')
  230 format(/'   Number of the corresponding representation :',i2,
     & ' x',i2)
  240 format(/'   Number of the corresponding representation :',i2)
  250 format(30(2x,3i3))
  260 format(30(2x,2i3))
  270 format(i7,a9,13(1x,2f7.3))
      end

!*********************************************************************

! Stockage dans irep_util de toutes les representations
! Utilisee dans le cas d'un calcul autocoherent car pour calculer
! la densite totale, il faut avoir toutes les representations.

      subroutine irep_util_all(nb_rep,ngrph,nspino,spinorbite)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer, dimension(nlfm):: iselec, lselec, mselec

      logical spinorbite

      nselec = 0

      do l = 0,3
        do m = -l,l
          do isp = 1,nspino
            nselec = nselec + 1
            lselec(nselec) = l
            mselec(nselec) = m
            iselec(nselec) = isp
          end do
        end do
      end do

      call cal_irep(iselec,lselec,mselec,nb_rep,ngrph,nselec,nspino,
     &              spinorbite) 

      return
      end

!*********************************************************************

! Sousprogramme calculant les valeurs des vecteurs polarisation et onde

      subroutine polond(angpoldafs,green_plus,hkl_dafs,isigpi,
     &      Length_word,
     &      ltypcal,moyenne,mpirank,ncolm,ncolr,ncolrd,ncolt,nomabs,
     &      nphim,nple,nplei,nplt,npltm,npldafs,nplr,nxanout,
     &      octupole,pdp,pdpolar,ple,pls,polar_e,poldafse_e,poldafsei_e,
     &      poldafsescan,poldafss_e,poldafssscan,poldafssi_e,
     &      quadrupole,self_abs,vecdafse_e,vecdafsescan,vecdafss_e,
     &      vecdafssscan,veconde_e,voe,vos,xan_atom)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      character(len=Length_word) nomab
      character(len=Length_word), dimension(ncolm):: nomabs
      character(len=13), dimension(npltm):: ltypcal

      complex(kind=db), dimension(3):: vc, wc
      complex(kind=db), dimension(3,npltm):: ple, pls
      complex(kind=db), dimension(3,npldafs,nphim):: poldafsescan,
     &                                              poldafssscan 

      integer, dimension(3) :: ipol, kpol
      integer, dimension(3,npldafs) :: hkl_dafs
      integer, dimension(npldafs,2) :: isigpi

      logical base_spin, green_plus, moyenne, self_abs, octupole,
     &        polarise, quadrupole, xan_atom

      real(kind=db), dimension(3,npldafs) :: angpoldafs
      real(kind=db), dimension(3,2) :: pl, vo
      real(kind=db), dimension(3) :: v, v1, v2, w
      real(kind=db), dimension(3,nple) :: polar, polar_e, veconde,
     &                                   veconde_e
      real(kind=db), dimension(nple,2) :: pdpolar
      real(kind=db), dimension(3,npldafs) :: poldafse, poldafsei,
     &  poldafss, poldafssi, vecdafse, vecdafss
      real(kind=db), dimension(3,npldafs) :: poldafse_e, poldafsei_e,
     &  poldafss_e, poldafssi_e, vecdafse_e, vecdafss_e
      real(kind=db), dimension(3,npltm) :: voe, vos
      real(kind=db), dimension(ncolm,2) :: pdp
      real(kind=db), dimension(3,npldafs,nphim):: vecdafsescan, 
     &                                           vecdafssscan 

      common/base_spin/ base_spin
      common/icheck/ icheck(24)
      common/msym/ msymdd(3,3), msymddi(3,3), msymdq(3,3,3), 
     &             msymdqi(3,3,3), msymdo(3,3,3,3), msymdoi(3,3,3,3),
     &             msymqq(3,3,3,3), msymqqi(3,3,3,3)
      common/orthmat/ orthmat(3,3), orthmati(3,3)
      common/polarise/ polarise
      common/rot_int/ rot_int(3,3)

      if( icheck(5) > 0 ) write(3,100)

! recopie pour eviter l'ecrasement en cas de plusieurs sites
      polar = polar_e
      veconde = veconde_e
      poldafse = poldafse_e
      poldafsei = poldafsei_e
      poldafss = poldafss_e
      poldafssi = poldafssi_e
      vecdafse = vecdafse_e
      vecdafss = vecdafss_e

      nxanout = 1

! Si aucune polarisation n'est defini en entree, on en construit par
! defaut
      if( nplei == 0 ) then

        if( .not. polarise ) nxanout = - 1

! On les definit dans le repere orthonorme interne.
        polar(:,:) = 0._db
        veconde(:,:) = 0._db
        pdpolar(:,:) = 0._db
        ipl = 0

        if( quadrupole ) then
          boucle_ij: do i = 1,3
            j = mod(i,3) + 1
            do ii = 1,i-1
              jj = mod(ii,3) + 1
              if( abs(msymdd(i,i)) == abs(msymdd(ii,ii)) .and. 
     &            abs(msymqq(i,j,i,j)) == abs(msymqq(ii,jj,ii,jj) ) )
     &             cycle boucle_ij
            end do
            ipl = ipl + 1
            polar(i,ipl) = 1._db
            veconde(j,ipl) = 1._db
            ipl = ipl + 1
            polar(i,ipl) = 1._db / sqrt( 2._db )
            veconde(i,ipl) = 1._db / sqrt( 2._db )
            polar(j,ipl) = 1._db / sqrt( 2._db )
            veconde(j,ipl) = - 1._db / sqrt( 2._db )
            do ii = 1,3
              jj = mod(ii,3) + 1 
              if( abs(msymdd(i,i)) == abs(msymdd(ii,ii)) .and.
     &           abs(msymqq(i,j,i,j)) == abs(msymqq(ii,jj,ii,jj)) ) then
                pdpolar(ipl-1,1) = pdpolar(ipl-1,1) + 1._db
                pdpolar(ipl-1,2) = pdpolar(ipl-1,2) + 1.5_db
                pdpolar(ipl,2) = pdpolar(ipl,2) + 1._db
              endif
            end do
          end do boucle_ij
        else
          boucle_exter: do i = 1,3
            do ii = 1,i-1
              if( abs(msymdd(i,i)) == abs(msymdd(ii,ii)) )
     &             cycle boucle_exter
            end do
            ipl = ipl + 1
            polar(i,ipl) = 1._db
            do ii = 1,3
              if( abs(msymdd(i,i)) == abs(msymdd(ii,ii)) ) 
     &                           pdpolar(ipl,1) = pdpolar(ipl,1) + 1._db
            end do
          end do boucle_exter
        endif

        nplr1 = ipl
        pdt = sum( pdpolar(1:nplr1,1) )
        pdpolar(1:nplr1,1) = pdpolar(1:nplr1,1) / pdt
        if( quadrupole ) then
          pdt = sum( pdpolar(1:nplr1,2) )
          pdpolar(1:nplr1,2) = pdpolar(1:nplr1,2) / pdt
        endif

! On se place dans la base cristallograhique
        do ipl = 1,nplr1
          v(:) = polar(:,ipl)
          w = matmul( orthmati, v)
          polar(:,ipl) = w(:)
          v(:) = veconde(:,ipl)
          w = matmul( orthmati, v)
          veconde(:,ipl) = w(:)
        end do

      else

        nplr1 = nplei

      endif

! Determination des noms des colonnes de resultats dans les fichiers de
! sortie

      jpl = 0

      do ipl = 1,nplr1

        plmin = 1._db
        do k = 1,3
          pp = abs( polar(k,ipl) )
          if( pp > eps4 ) plmin = min(plmin,pp)
        end do
        ipol(1:3) = nint( polar(1:3,ipl) / plmin )
        plmin = 1._db
        do k = 1,3
          pp = abs( veconde(k,ipl) )
          if( pp > eps4 ) plmin = min(plmin,pp)
        end do
        kpol(1:3) = nint( veconde(1:3,ipl) / plmin )

        jpl = jpl + 1
        if( ipol(1) == 0 .and. ipol(2) == 0 .and. ipol(3) == 0 ) then
          nomabs(jpl) = '   left_pol  '
          pdp(jpl,:) = 0.5_db * pdpolar(ipl,:)
          jpl = jpl + 1
          nomabs(jpl) = '  right_pol  '
          pdp(jpl,:) = 0.5_db * pdpolar(ipl,:)
          jpl = jpl + 1
          nomab = ' dic('
          j = 5
          call trnom(j,kpol,Length_word,nomab)
          j = j + 1
          if( j <= Length_word ) nomab(j:j) = ')'
          nomabs(jpl) = nomab
          pdp(jpl,:) = 0._db
        else
          j = 0
          nomab = ' '
          call trnom(j,ipol,Length_word,nomab)
          if( ( kpol(1) /= 0 .or. kpol(2) /= 0 .or. kpol(3) /= 0 )
     &         .and. ( quadrupole .or. octupole ) ) then
            j = j + 1
            nomab(j:j) = ','
            call trnom(j,kpol,Length_word,nomab)
          endif
          nj = j
          if( nj < Length_word-2 ) nomab(nj+1:nj+1) = ')'
          if( nj < Length_word-1 ) then
            nomab(1:Length_word) = '(' // nomab(1:Length_word-1)
          else
            nomab(1:Length_word) = ' ' // nomab(1:Length_word-1)
          endif
          nomabs(jpl) = nomab
          pdp(jpl,:) = pdpolar(ipl,:)
        endif
      end do


      pp1 = sum( pdp(1:jpl,1) )
      pp2 = sum( pdp(1:jpl,2) )
      if( nplr1 > 1 .and. ( abs(pp1) > eps4 .or. abs(pp2) > eps4) ) then
        pdp(1:jpl,1) = pdp(1:jpl,1) / pp1
        if( quadrupole ) pdp(1:jpl,2) = pdp(1:jpl,2) / pp2
        moyenne = .true.
        jpl = jpl + 1
        nomabs(jpl) = '    <xanes>  '
      else
        moyenne = .false.
      endif

      if( nxanout == - 1 ) then
        nomabs(jpl) = '    <xanes>  '
        nxanout = jpl
      else
        nxanout = 1
      endif

      if( xan_atom ) then
        jpl = jpl + 1
        nomabs(jpl) = '  XANES_atom '
      endif

 ! ncolr correspond au nombre de colonnes pour le xanes (d'absorption
 ! reelle)
      ncolr = jpl

      if( self_abs ) then
        ncolrd = ncolr + 2 * npldafs
      else
        ncolrd = ncolr
      endif

      do ipldafs = 1,npldafs
        jpl = jpl + 1
        kpol(:) = hkl_dafs(1:3,ipldafs)
        nomab = ' r('
        j = 3
        call trnom(j,kpol,Length_word,nomab)
        j = j + 1
        if( j < Length_word-1 ) nomab(j:j) = ')'
        do i = 1,2
          j = j + 1
          if( i == 1 ) k = j
          if( j > Length_word ) exit
          select case( isigpi(ipldafs,i) )
            case(1)
              nomab(j:j) = 's'
            case(2)
              nomab(j:j) = 'p'
            case(3)
              nomab(j:j) = 'd'
            case(4)
              nomab(j:j) = 'g'
            case default
              nomab(j:j) = 'a'
          end select
        end do
        j = j + 1
        if( j < Length_word-1 ) then        
          nomab(j:j) = '_'
          if( abs( angpoldafs(3,ipldafs) ) < 9999._db ) then
            a = angpoldafs(3,ipldafs) * 180 / pi
          else
            a = 0._db
          endif  
          index = nint( a )
          call ad_number(index,nomab,Length_word)
        endif
        nomabs(jpl) = nomab
        jpl = jpl + 1
        nomab(2:2) = 'i'
        nomabs(jpl) = nomab
        if( self_abs ) then
          jpl = jpl + 1
          nomab(2:2) = 'A'
          if( k < Length_word ) nomab(k:k+1) = 'in'  
          if( k == Length_word ) nomab(k:k) = 'i'  
          nomabs(jpl) = nomab
          jpl = jpl + 1
          if( k < Length_word ) nomab(k:k+1) = 'ou'  
          if( k == Length_word ) nomab(k:k) = 'o'  
          nomabs(jpl) = nomab
        endif
      end do

 ! ncolt correspond au nombre de colonnes total (d'absorption reelle ou
 ! virtuelle)
      ncolt = jpl
      if( ncolt > ncolm .and. mpirank == 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,105) ncolt, ncolm
        end do
        stop
      endif

! On passe en base interne (orthonormee)
      do ipl = 1,nplr1

        v(:) = polar(:,ipl)
        pp = sum( v(:)**2 )
        if( abs(pp) > eps6 ) then
          call trvec(mpirank,v,w)
          polar(:,ipl) = w(:)
        endif
        v(:) = veconde(:,ipl)
        pp = sum( v(:)**2 )
        if( pp > eps4 ) then
          v(:) = veconde(:,ipl)
          call trvec(mpirank,v,w)
          veconde(:,ipl) = w(:)
          pp = sum( veconde(:,ipl) * polar(:,ipl) )
          if( quadrupole .and. abs(pp) > eps4 .and. mpirank == 0 ) then
            call write_error
            do ipr = 3,9,3
              write(ipr,110) ipl, polar(:,ipl), veconde(:,ipl)
            end do
            stop
          endif
        endif

      end do

      do ipl = 1,npldafs
        vc(:) = cmplx(poldafse(:,ipl), poldafsei(:,ipl), db)
        pp = sum( abs(vc(:))**2 )
        if( abs(pp) > eps6 ) then
          call tivec(mpirank,vc,wc)
          poldafse(:,ipl) = real( wc(:), db )
          poldafsei(:,ipl) = aimag( wc(:) )
        endif
        vc(:) = cmplx(poldafss(:,ipl), poldafssi(:,ipl), db)
        pp = sum( abs(vc(:))**2 )
        if( abs(pp) > eps6 ) then
          call tivec(mpirank,vc,wc)
          poldafss(:,ipl) = real( wc(:), db )
          poldafssi(:,ipl) = aimag( wc(:) )
        endif

        v(:) = vecdafse(:,ipl)
        if( abs(v(1)) > eps4 .or. abs(v(2)) > eps4
     &                       .or. abs(v(3)) > eps4) then
          call trvec(mpirank,v,w)
          vecdafse(:,ipl) = w(:)
          pp = abs( sum( vecdafse(:,ipl) * poldafse(:,ipl) )
     &            + sum( vecdafse(:,ipl) * poldafsei(:,ipl) ) )
          if( quadrupole .and. pp > eps4 .and. mpirank == 0 ) then
            call write_error
            do ipr = 3,9,3
              write(ipr,110) ipl, poldafse(:,ipl), vecdafse(:,ipl)
              write(ipr,110) ipl, poldafsei(:,ipl), vecdafse(:,ipl)
            end do
            stop
          endif
        endif
        v(:) = vecdafss(:,ipl)
        if( abs(v(1)) > eps4 .or. abs(v(2)) > eps4
     &                       .or. abs(v(3)) > eps4) then
          call trvec(mpirank,v,w)
          vecdafss(:,ipl) = w(:)
          pp = abs( sum( vecdafss(:,ipl) * poldafss(:,ipl) )
     &            + sum( vecdafss(:,ipl) * poldafssi(:,ipl) ) )
          if( quadrupole .and. abs(pp) > eps4 .and. mpirank == 0 ) then
            call write_error
            do ipr = 3,9,3
              write(ipr,120) ipl, poldafss(:,ipl), vecdafss(:,ipl)
              write(ipr,120) ipl, poldafssi(:,ipl), vecdafss(:,ipl)
            end do
            stop
          endif
        endif
      end do

! Determination des vecteurs polarisations et vecteurs d'onde pour tous
! les calculs

      ple = (0._db,0._db)
      pls = (0._db,0._db)
      voe = 0._db
      vos = 0._db

      jpl = 0
      do ipl = 1,nplr1+npldafs

        if( ipl > nplr1 ) then
          ipldafs = ipl - nplr1
          pl(1:3,1) = poldafse(1:3,ipldafs)
          vo(1:3,1) = vecdafse(1:3,ipldafs)
          pl(1:3,2) = poldafss(1:3,ipldafs)
          vo(1:3,2) = vecdafss(1:3,ipldafs)
        else
          pl(1:3,1) = polar(1:3,ipl)
          vo(1:3,1) = veconde(1:3,ipl)
          pl(1:3,2) = polar(1:3,ipl)
          vo(1:3,2) = veconde(1:3,ipl)
        endif

        jpl = jpl + 1

! Si le vecteur polarisation est nul, la polarisation est circulaire
        jpl0 = jpl
        rac_2 = sqrt( 2._db )
        do ies = 1,2
          jpl = jpl0
          r = sum( pl(:,ies)**2 )
          if( r < eps6 ) then
            w(:) = vo(:,ies)
            do i = 1,3
              if( abs(w(i)) > eps4 ) exit
            end do
            j = i - 1
            if( j == 0 ) j = 3
            v(:) = 0._db
            v(j) = 1._db
            call prodvec(v1,v,w)
            r = sqrt( sum( v1(:)**2 ) )
            v1(:) = v1(:) / r
            call prodvec(v2,w,v1)
            if( ies == 1 ) then
              if( ipl > nplr1 ) then
                if( isigpi(ipldafs,1) == 3 ) then
                  ple(:,jpl) = cmplx( v1(:), - v2(:), db ) / rac_2
                else
                  ple(:,jpl) = cmplx( v1(:), v2(:), db ) / rac_2
                endif
              else
                ple(:,jpl) = cmplx( v1(:), v2(:), db ) / rac_2
              endif
              voe(:,jpl) = w(:)
            else
              if( ipl > nplr1 ) then
                if( isigpi(ipldafs,2) == 3 ) then
                  pls(:,jpl) = cmplx( v1(:), - v2(:), db ) / rac_2
                else
                  pls(:,jpl) = cmplx( v1(:), v2(:), db ) / rac_2
                endif
              else
                pls(:,jpl) = cmplx( v1(:), v2(:), db ) / rac_2
              endif
              vos(:,jpl) = w(:)
            endif
            if( ipl > nplr1 ) then
              ltypcal(jpl) = 'dafs circul'
              cycle
            else
              ltypcal(jpl) = 'xanes circ g'
            endif
            jpl = jpl + 1
            if( ies == 1 ) then
              ple(:,jpl) = cmplx( v1(:), - v2(:), db ) / rac_2
              voe(:,jpl) = w(:)
            else
              pls(:,jpl) = cmplx( v1(:), - v2(:), db ) / rac_2
              vos(:,jpl) = w(:)
            endif
            ltypcal(jpl) = 'xanes circ d'
          else
            if( ies == 1 ) then
              if( ipl > nplr1 ) then
               ple(:,jpl) = cmplx(pl(1:3,ies),poldafsei(1:3,ipldafs),db)  !ERR
              else
                ple(:,jpl) = cmplx(pl(1:3,ies), 0._db, db)
              endif
              voe(:,jpl) = vo(:,ies)
            else
              if( ipl > nplr1 ) then
               pls(:,jpl) = cmplx(pl(1:3,ies),poldafssi(1:3,ipldafs),db)  !ERR
              else
                pls(:,jpl) = cmplx(pl(1:3,ies), 0._db, db)
              endif
              vos(:,jpl) = vo(:,ies)
            endif
            if( ipl > nplr1 ) then
              if( ies == 2 ) cycle
              if( isigpi(ipldafs,2) == 3 .or.
     &            isigpi(ipldafs,2) == 4 ) then
                ltypcal(jpl) = 'dafs circul'
              else
                ltypcal(jpl) = 'dafs rectil'
              endif
            else
              ltypcal(jpl) = 'xanes rectil'
            endif
          endif
        end do

        if( ipl > nplr1 .and. self_abs ) then
          do ies = 1,2
            jpl = jpl + 1
            if( ies == 1 ) then
              ple(:,jpl) = ple(:,jpl-ies) 
              pls(:,jpl) = ple(:,jpl-ies) 
              voe(:,jpl) = voe(:,jpl-ies)
              vos(:,jpl) = voe(:,jpl-ies)
            else
              ple(:,jpl) = pls(:,jpl-ies) 
              pls(:,jpl) = pls(:,jpl-ies) 
              voe(:,jpl) = vos(:,jpl-ies)
              vos(:,jpl) = vos(:,jpl-ies)
            endif
            if( isigpi(ipldafs,ies) == 3 ) then
              ltypcal(jpl) = 'xanes circ d'
            elseif( isigpi(ipldafs,ies) == 4 ) then
              ltypcal(jpl) = 'xanes circ g'
            else
              ltypcal(jpl) = 'xanes rectil'
            endif
          end do
        endif

! nombre de polarisations pour absorption reelle
        if( ipl == nplr1) nplr = jpl

      end do

      if( .not. green_plus ) then
        ple(:,:) = conjg( ple(:,:) )
        pls(:,:) = conjg( pls(:,:) )
      endif

! nombre de polarisations pour absorption reelle ou virtuelle
      nplt = jpl

! On passe en base R1
      pp  = abs( rot_int(1,1) - 1._db ) + abs( rot_int(2,2) - 1._db )
     &    + abs( rot_int(3,3) - 1._db )
      if( .not. base_spin .and.  pp > eps10 ) then
        do ipl = 1,nplt

          v(:) = real( ple(:,ipl), db )
          v = matmul( rot_int, v )

          w(:) = aimag( ple(:,ipl) )
          w = matmul( rot_int, w )
          ple(:,ipl) = cmplx( v(:), w(:), db )

          v(:) = real( pls(:,ipl), db )
          v = matmul( rot_int, v )
          w(:) = aimag( pls(:,ipl) )
          w = matmul( rot_int, w )
          pls(:,ipl) = cmplx( v(:), w(:), db )

          v(:) = voe(:,ipl)
          v = matmul( rot_int, v )
          voe(:,ipl) = v(:)

          v(:) = vos(:,ipl)
          v = matmul( rot_int, v )
          vos(:,ipl) = v(:)
        end do

        do ipl = 1,npldafs
          if( angpoldafs(1,ipl) > -9999._db .and.
     &        angpoldafs(2,ipl) > -9999._db .and.
     &        angpoldafs(3,ipl) > -9999._db ) cycle
          do ip = 1,nphim
            v(:) = real( poldafsescan(:,ipl,ip), db )
            v = matmul( rot_int, v )
            w(:) = aimag( poldafsescan(:,ipl,ip) )
            w = matmul( rot_int, w )
            poldafsescan(:,ipl,ip) = cmplx( v(:), w(:), db )

            v(:) = real( poldafssscan(:,ipl,ip), db )
            v = matmul( rot_int, v )
            w(:) = aimag( poldafssscan(:,ipl,ip) )
            w = matmul( rot_int, w )
            poldafssscan(:,ipl,ip) = cmplx( v(:), w(:), db )

            v(:) = vecdafsescan(:,ipl,ip)
            v = matmul( rot_int, v )
            vecdafsescan(:,ipl,ip) = v(:)

            v(:) = vecdafssscan(:,ipl,ip)
            v = matmul( rot_int, v )
            vecdafssscan(:,ipl,ip) = v(:)
          end do
        end do
      endif

      if( icheck(5) > 0 ) then
        if( base_spin ) then
          write(3,150)
        else
          write(3,155)
        endif
        do ipl = 1,nplt
          write(3,160)
          if( ipl <= nplr ) then
            write(3,160) ple(1,ipl), voe(1,ipl), pls(1,ipl), vos(1,ipl),
     &                   ltypcal(ipl), pdp(ipl,:)
          else
            write(3,160) ple(1,ipl), voe(1,ipl), pls(1,ipl), vos(1,ipl),
     &                   ltypcal(ipl)
          endif
          do i= 2,3
            write(3,160) ple(i,ipl), voe(i,ipl), pls(i,ipl), vos(i,ipl)
          end do
        end do
      endif
      if( icheck(5) > 1 ) then
        iwrite = 1
        do ipl = 1,npldafs
          if( angpoldafs(1,ipl) > -9999._db .and.
     &        angpoldafs(2,ipl) > -9999._db .and.
     &        angpoldafs(3,ipl) > -9999._db ) cycle
          if( iwrite == 1 ) then
            if( base_spin ) then
              write(3,170)
            else
              write(3,175)
            endif
            iwrite = 0
          endif
          write(3,176) ipl
          do ip = 1,nphim
            write(3,*)
            do i = 1,3
             write(3,180) poldafsescan(i,ipl,ip),vecdafsescan(i,ipl,ip),
     &                   poldafssscan(i,ipl,ip), vecdafssscan(i,ipl,ip)
            end do
          end do
        end do
      endif

      return
  100 format(/' ---- Polond -----',100('-'))
  105 format(/' ncolt =',i3,' > ncolm = ',i3,
     &/' Bug in the program !')
  110 format(/' The incoming wave vector and the polarization must be',
     &  ' perpendicular !'/,' ipl =',i3,'   pol =',3f10.5/
     &  12x,'vec =',3f10.5)
  120 format(/' The outcoming wave vector and the polarization must be',
     &  ' perpendicular !'/,' ipl =',i3,'   pol =',3f10.5/
     &  12x,'vec =',3f10.5)
  150 format(/'  Polarization and wave vectors in the internal basis',
     & ' R4 ( orthogonal basis, z along spin direction )',//
     &        '         ple            voe           pls',12x,'vos',
     & '        type      weight_d weight_q')
  155 format(/'  Polarization and wave vectors in the internal basis',
     & ' R1 ( orthogonal basis, z along c crystal )',//
     &        '         ple            voe           pls',12x,'vos',
     & '        type      weight_d weight_q')
  160 format(2(2f9.5,1x,f9.5,1x),2x,a12,2f9.5)
  170 format(/'  Polarization and wave vectors in the internal basis',
     & ' R4 ( orthogonal basis, z along spin direction )',//
     &        '         ple            voe           pls',12x,'vos')
  175 format(/'  Polarization and wave vectors in the internal basis',
     & ' R1 ( orthogonal basis, z along c crystal )',//
     &        '         ple            voe           pls',12x,'vos')
  176 format(/' ipl = ',i5)
  180 format(2(2f9.5,1x,f9.5,1x))
      end

!***********************************************************************

      subroutine trnom(j,ind,Length_word,nomab)

      character(len=Length_word) nomab, nomac

      integer ind(3)

      nomac = ' '
      nomac(1:Length_word-1) = nomab(1:Length_word-1)
      do k = 1,3
        call ad_number(ind(k),nomac,Length_word)
      end do
      nomab(1:Length_word-1) = nomac(1:Length_word-1)
      j = len_trim(nomab)

      return
      end

!***********************************************************************

      subroutine trvec(mpirank,ve,vs)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      real(kind=db), dimension(3):: ve, vs, w

      common/orthmat/ orthmat(3,3), orthmati(3,3)

! On se place en base orthonormee
      w = matmul( orthmat, ve )

! Normalisation
      pp = sqrt( sum( w(:)**2 ) )
      if( pp > eps4 ) then
        w(:) = w(:) / pp
      elseif( mpirank == 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,110)
        end do
        stop
      endif

      vs(:) = w(:)

      return
  110 format(//' The polarisation vector is zero in routine trvec !'/)
      end

!***********************************************************************

      subroutine tivec(mpirank,ve,vs)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db), dimension(3):: ve, vs, w

      common/orthmat/ orthmat(3,3), orthmati(3,3)

! On se place en base orthonormee
      w = matmul( orthmat, ve )

! Normalisation
      pp = sqrt( sum( abs(w(:))**2 ) )
      if( pp > eps4 ) then
        w(:) = w(:) / pp
      elseif( mpirank == 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,110)
        end do
        stop
      endif

      vs(:) = w(:)

      return
  110 format(//' The polarisation vector is zero in routine tivec !'/)
      end

!***********************************************************************

! Calcul du (l,m) = (loperat,moperat) de la transition

      subroutine lmtrans(kpl,kvo,kv2,noperat,loperat,moperat,spinorbite)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer, dimension(6) :: loperat, moperat
      logical spinorbite

! dipole
      if( kvo == 0 ) then

        noperat = 1
        loperat(1) = 1
        select case(kpl)
          case(1)
            moperat(1) = 1
          case(2)
            moperat(1) = -1
          case(3)
            moperat(1) = 0
        end select

! quadrupole
      elseif( kv2 == 0 ) then

        kprod = kpl * kvo

        select case(kprod)
          case(2)
            noperat = 1
            loperat(1) = 2
            moperat(1) = -2
          case(6)
            noperat = 1
            loperat(1) = 2
            moperat(1) = -1
          case(3)
            noperat = 1
            loperat(1) = 2
            moperat(1) = 1
          case(1,4)
            noperat = 3
            loperat(1) = 0
            moperat(1) = 0
            loperat(2:3) = 2
            moperat(2) = 0
            moperat(3) = 2
          case(9)
            noperat = 2
            loperat(1) = 0
            moperat(1) = 0
            loperat(2) = 2
            moperat(2) = 0
        end select

! octupole
      else

        kprod = kpl * kvo * kv2
    
        select case(kprod)
          case(6)
            noperat = 1
            loperat(1) = 3
            moperat(1) = -2
          case(2)
            noperat = 3
            loperat(1) = 1
            moperat(1) = -1
            loperat(2:3) = 3
            moperat(2) = -3
            moperat(3) = -1
          case(4)
            noperat = 3
            loperat(1) = 1
            moperat(1) = 1
            loperat(2:3) = 3
            moperat(2) = 3
            moperat(3) = 1
          case(3,12)
            noperat = 3
            loperat(1) = 1
            moperat(1) = 0
            loperat(2:3) = 3
            moperat(2) = 0
            moperat(3) = 2
          case(18)
            noperat = 2
            loperat(1) = 1
            moperat(1) = -1
            loperat(2) = 3
            moperat(2) = -1
          case(9)
            noperat = 2
            loperat(1) = 1
            moperat(1) = 1
            loperat(2) = 3
            moperat(2) = 1
          case(1)
            noperat = 3
            loperat(1) = 1
            moperat(1) = 1
            loperat(2:3) = 3
            moperat(2) = 3
            moperat(3) = 1
          case(8)
            noperat = 3
            loperat(1) = 1
            moperat(1) = -1
            loperat(2:3) = 3
            moperat(2) = -3
            moperat(3) = -1
          case(27)
            noperat = 2
            loperat(1) = 1
            moperat(1) = 0
            loperat(2) = 3
            moperat(2) = 0
        end select

      endif

      if( spinorbite ) then
        jop = noperat
        do iop = 1,noperat
          if( moperat(iop) == 0 ) cycle
          jop = jop + 1 
          loperat(jop) = loperat(iop)
          moperat(jop) = - moperat(iop)
        end do
        noperat = jop
      endif

      return
      end

!***********************************************************************

! Clebsch-gordan coefficient  eq. 3.18, Rose

      function cgc(l1,l2,l3,m1,m2)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer, dimension(5):: nd, num

      cgc = 0._db

      m3 = m1 + m2

! Arguments of factorials
      num( 1 ) = l3 + l1 - l2
      num( 2 ) = l3 - l1 + l2
      num( 3 ) = l1 + l2 - l3
      num( 4 ) = l3 + m3
      num( 5 ) = l3 - m3
      nd( 1 ) = l1 + l2 + l3 + 1
      nd( 2 ) = l1 - m1
      nd( 3 ) = l1 + m1
      nd( 4 ) = l2 - m2
      nd( 5 ) = l2 + m2

! Check triangle and projection conditions
      do i = 1, 5
        if( num(i) < 0 .or. nd(i) < 0 ) return
      end do

      nff = 0
      nmin = max( 0, l2 + m3 - l1 )
      ff = 1.0_db

! Two sets of factorial products
      n = 5
      do nfac = 1, 2
        n1 = n - 1
! Arrange arguments in descending order
        do i = 1, n1
          inum = i
          id = i
          i1 = i + 1
          do j = i1, n
            if( num( j ) > num( inum ) ) inum = j
            if( nd( j ) > nd( id ) ) id = j
          end do
          ntemp = num( i )
          num( i ) = num( inum )
          num( inum ) = ntemp
          ntemp = nd( i )
          nd( i ) = nd( id )
          nd( id ) = ntemp
        end do
! Compute factorial ratios
        do i = 1, n
          if( num( i ) < nd( i ) ) then
            jm = nd( i )
            if( jm == 1 ) cycle
            j0 = num( i ) + 1
            if( num( i ) == 0 ) j0 = 2
            do j = j0, jm
              if( abs ( ff ) < 1.0e-20_db ) then
                ff = ff * 1.e20_db
                nff = nff - 2
              endif
              ff = ff / j
            end do
          elseif( num( i ) > nd( i ) ) then
            jm = num( i )
            if( jm == 1 ) cycle
            j0 = nd( i ) + 1
            if( nd( i ) == 0 ) j0 = 2
            do j = j0, jm
              if( abs ( ff ) > 1.0e20_db ) then
                ff = ff / 1.0e20_db
                nff = nff + 2
              endif
              ff = j * ff
            end do
          endif
        end do

        if ( nfac == 2 ) exit

        nff = nff / 2
        ff = sqrt( ( 2 * l3 + 1 ) * ff )

! Second set of factorial arguments
        num( 1 ) = l2 + l3 + m1 - nmin
        num( 2 ) = l1 - m1 + nmin
        num( 3 ) = 0
        nd( 1 ) = nmin
        if( nmin == 0 ) nd( 1 ) = l1 - l2 - m3
        nd( 2 ) = l3 - l1 + l2 - nmin
        nd( 3 ) = l3 + m3 - nmin
        n = 3
      end do

      if( mod( nmin + l2 + m2, 2 ) /= 0 ) ff = - ff
      ff = ff * 1.0e10_db**nff
      cgcp = ff
      nmax = min( l3 - l1 + l2, l3 + m3 )

      do nu = nmin+1, nmax
        ff= - ff * ( (l1-m1+nu) * (l3-l1+l2-nu+1) * (l3+m3-nu+1) )
     &      / real( nu * (nu+l1-l2-m3) * (l2+l3+m1-nu+1), db )
        cgcp = cgcp + ff
      end do

      cgc = cgcp

      return
      end

!***********************************************************************

      subroutine symorb(l,m,kopsymo)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db), dimension(nopsm):: kopsymo

      integer, dimension(nopsm):: iopsymo

      logical lpair, pair

      if( l == 0 ) then
        kopsymo(:) = (1._db, 0._db)
        return
      endif

      iopsymo(:) = 0
      iopsymo(1) = 1
      lpair = mod(l,2) == 0

! Axes 2
      im = abs( m )
      do is = 22,24
        select case(is)
          case(22)   ! Axe 2 Ox
            mm = mod(l+im,2)
            pair = (mm == 0 .and. m >= 0) .or. (mm == 1 .and. m < 0)
          case(23)   ! Axe 2 Oy
            mm = mod(l+2*im,2)
            pair = (mm == 0 .and. m >= 0) .or. (mm == 1 .and. m < 0)
          case(24)   ! Axe 2 Oz
            mm = mod(im,2)
            pair = mm == 0
        end select
        if( pair ) then
          iopsymo(is) = 1
        else
          iopsymo(is) = -1
        endif
      end do

! Axes 2 selon (110) et (1-10)
      m4 = mod(im,4)
      mlm = mod(l+im,2)
      if( ( m >= 0 .and. ( ( m4 == 0 .and. mlm == 0 )
     &                  .or. ( m4 == 2 .and. mlm == 1 ) ) )
     & .or. ( m < 0 .and. ( ( m4 == 2 .and. mlm == 0 )
     &                  .or. ( m4 == 0 .and. mlm == 1 ) ) ) ) then
        iopsymo(10:11) = 1
      elseif( ( m >= 0 .and. ( ( m4 == 0 .and. mlm == 1 )
     &                  .or. ( m4 == 2 .and. mlm == 0 ) ) )
     & .or. ( m < 0 .and. ( ( m4 == 2 .and. mlm == 1 )
     &                  .or. ( m4 == 0 .and. mlm == 0 ) ) ) ) then
        iopsymo(10:11) = -1
      endif

! Axe 3 Oz
! Quand la valeur est differente de 1 ou - 1, le chiffre represente n
! pour le caractere egal a exp(n*i*pi/12).
      mm = m
      do
        if( mm >= 0 ) exit
        mm = mm + 3
      end do
      mm = mod(mm,3)
      select case(mm)
        case(0)
          iopsymo(49:50) = 1
        case(1)
          iopsymo(49) = 4; iopsymo(50) = 8 
        case(2)
          iopsymo(49) = 8; iopsymo(50) = 4
      end select 
! Axes 3 negatif
      if( mod(l+m,2) == 0 ) then
        iopsymo(53:54) = iopsymo(49:50)
      else
        select case(mm)
          case(0)
            iopsymo(53:54) = -1
          case(1)
            iopsymo(53) = 10; iopsymo(54) = 2 
          case(2)
            iopsymo(53) = 2;  iopsymo(54) = 10
        end select 
      endif

! Axe 4 Oz
      mm = m
      do
        if( mm >= 0 ) exit
        mm = mm + 4
      end do
      mm = mod(mm,4)
      select case(mm)
        case(0)
          iopsymo(18:21:3) = 1
        case(1)
          iopsymo(18) = 3; iopsymo(21) = 9 
        case(2)
          iopsymo(18:21:3) = -1
        case(3)
          iopsymo(18) = 9; iopsymo(21) = 3 
      end select
! Axes S4 
      if( mod(l+m,2) == 0 ) then
        iopsymo(28:31:3) = iopsymo(18:21:3)
      else
        select case(mm)
          case(0)
            iopsymo(28:31:3) = -1
          case(1)
            iopsymo(28) = 9; iopsymo(31) = 3 
          case(2)
            iopsymo(28:31:3) = 1
          case(3)
            iopsymo(28) = 3; iopsymo(31) = 9 
          end select 
      endif

! Axe 6 Oz
      mm = m
      do
        if( mm >= 0 ) exit
        mm = mm + 6
      end do
      mm = mod(mm,6)
      select case(mm)
        case(0)
          iopsymo(51:52) = 1
        case(1)
          iopsymo(51) = 2; iopsymo(52) = 10 
        case(2)
          iopsymo(51) = 4; iopsymo(52) = 8 
        case(3)
          iopsymo(51:52) = -1
        case(4)
          iopsymo(51) = 8; iopsymo(52) = 4 
        case(5)
          iopsymo(51) = 10; iopsymo(52) = 2 
      end select
! Axes 6 negatif
      if( mod(l+m,2) == 0 ) then
        iopsymo(55:56) = iopsymo(51:52)
      else
        select case(mm)
          case(0,3)
            iopsymo(55:56) = - iopsymo(51:52)
          case default
            do is = 51,52 
              if( iopsymo(is) < 6 ) then
                iopsymo(is+4) = iopsymo(is) + 6
              else
                iopsymo(is+4) = iopsymo(is) - 6
              endif
            end do
        end select 
      endif

! Centrosymmetie
      if( lpair ) then
        iopsymo(25) = 1
      else
        iopsymo(25) = - 1
      endif

! Plans de symetrie
      m2 = mod(im,2)

      if( (m > 0 .and. m2 == 1) .or. (m < 0 .and. m2 == 0) ) then
        iopsymo(40) = -1
      else
        iopsymo(40) = 1
      endif
      if( m < 0 ) then
        iopsymo(41) = -1
      else
        iopsymo(41) = 1
      endif
      if( mod(l+m,2) == 1 ) then
        iopsymo(42) = -1
      else
        iopsymo(42) = 1
      endif

! Plans diagonaux contenant Oz
      m4 = mod(abs(m),4)
      if( (m4 == 0 .and. m >= 0) .or. (m4 == 2 .and. m < 0) ) then
        iopsymo(45:48:3) = 1
      elseif((m4 == 0 .and. m < 0) .or. (m4 == 2 .and. m >= 0)) then
        iopsymo(45:48:3) = -1
      else
        iopsymo(45:48:3) = 0
      endif

! Quand la valeur est differente de 1 ou - 1, le chiffre represente n
! pour le caractere egal a exp(n*i*pi/12).
      do is = 1,nopsm
        select case( iopsymo(is) )
          case(0)
            kopsymo(is) = (0._db, 0._db)
          case(1)
            kopsymo(is) = (1._db, 0._db)
          case(-1)
            kopsymo(is) = (-1._db, 0._db)
          case default
            kopsymo(is) = exp( iopsymo(is) * img * pi / 6 ) 
        end select
      end do

      return
      end

!***********************************************************************

      function natome_cal(igrpt_nomag,mpirank,natomeq,natomp,pos)
 
      use declarations                                                       
      implicit real(kind=db) (a-h,o-z)

      real(kind=db), dimension(3):: dp, ps
      real(kind=db), dimension(3,natomp):: pos

      common/iopsymr/ iopsymr(nopsm)

      natome = 0
      do ia = 1,natomeq
        ps(:) = pos(:,ia)
        call posequiv(mpirank,ps,iopsymr,isym,igrpt_nomag)
        dp(:) = abs( ps(:) - pos(:,ia) )
        if( dp(1) > epspos .or. dp(2) > epspos .or. dp(3) > epspos )
     &        cycle
        natome = natome + 1
      end do
      natome_cal = natome

      return
      end

!***********************************************************************

! Selection des atomes du petit agregat
! Evaluation de leur groupe ponctuel dans cet agregat.

      subroutine Atom_selec(Atom_comp,Atom_mag_gr,Atom_nsph,
     &         Atom_occ_mat,Axe_atom_clu,Axe_Atom_clui,
     &         dista,distai,Full_atom,hubbard,ia_eq,ia_eq_inv,
     &         ia_eq_sym,ia_rep,iaabs,iaabsi,iaproto,iaprotoi,
     &         Int_dens_all,igreq,igroup,igrpt_nomag,  
     &         iopsym_atom,iord,ipr0,is_eq,it0,itype,itypei,itypep,
     &         itypepr,
     &         magnetic,m_hubb,mpirank,natome,n_atom_0,n_atom_ind,
     &         n_atom_proto,natomeq,natomp,nb_eq,nb_rpr,
     &         nb_rep_t,nb_sym_op,ngroup,nlat,nlatm,nspin,ntype,numat,
     &         nx,occ_mat_gr,overad,popats,pos,posi,rmt,
     &         rot_atom,roverad,rsort,rsorte,spinorbite,Ylm_complex)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      character(len=8):: ptgrname_int

      integer, dimension(nopsm):: iopsyma
      integer, dimension(nopsm,natome):: iopsym_atom
      integer, dimension(natome):: iaprotoi, iatomp, igroupi, igrpt,
     &                             itypei, nb_eq
      integer, dimension(ipr0:n_atom_proto,ngroup):: igreq
      integer, dimension(natomeq):: ia_eq_inv
      integer, dimension(nb_sym_op,natome):: ia_eq, ia_eq_sym, is_eq
      integer, dimension(nb_sym_op,natome,natome):: ia_rep, nb_rep_t
      integer, dimension(natome,natome):: nb_rpr
      integer, dimension(natomp):: iaproto, igroup, itypep
      integer, dimension(ngroup):: itype
      integer, dimension(it0:ntype):: nlat, numat
      integer, dimension(ipr0:n_atom_proto):: itypepr

      logical Atom_comp_cal, Atom_mag_cal, Atom_nonsph, Atom_occ_mat,
     &        Full_atom, hubbard, magnetic, overad, spinorbite, 
     &        Ylm_complex
      logical, dimension(nb_sym_op):: Fait
      logical, dimension(0:natome):: Atom_comp, Atom_mag
      logical, dimension(ngroup):: Atom_nsph
      logical, dimension(0:ngroup):: Atom_mag_gr

      real(kind=db), dimension(3):: dp, ps, v
      real(kind=db), dimension(3,3):: matopsym, rot_a
      real(kind=db), dimension(it0:ntype) :: rmt
      real(kind=db), dimension(3,natome):: Axe_atom_clui, posi
      real(kind=db), dimension(natome):: distai
      real(kind=db), dimension(natomp):: dista
      real(kind=db), dimension(14,ngroup):: occ_mat_gr
      real(kind=db), dimension(3,natomp):: Axe_atom_clu, pos
      real(kind=db), dimension(3,3,natome):: rot_atom
      real(kind=db), dimension(ngroup,nlatm,nspin):: popats
      real(kind=db), dimension(-m_hubb:m_hubb,-m_hubb:m_hubb,nspin,
     &                         n_atom_0:n_atom_ind):: Int_dens_all
      common/ad/ ad
      common/adimp/ adimp
      common/Atom_nonsph/ Atom_nonsph
      common/axyz/ axyz(3), angxyz(3)
      common/icheck/ icheck(24)
      common/igrpt0/ igrpt0
      common/iopsym_abs/ iopsym_abs(nopsm)
      common/iopsymc/ iopsymc(nopsm)
      common/iopsymr/ iopsymr(nopsm)

      if( icheck(6) > 0) write(3,110)

! Selection des atomes ou on effectue un developpement en harmoniques
! spheriques.

      iaabsi = 0

      ib = 0
      do ia = 1,natomeq
        ps(:) = pos(:,ia)
        call posequiv(mpirank,ps,iopsymr,isym,igrpt_nomag)
        dp(:) = abs( ps(:) - pos(:,ia) )
        if( dp(1) > epspos .or. dp(2) > epspos .or. dp(3) > epspos )
     &      cycle
        ib = ib + 1
        iatomp(ib) = ia
        iaprotoi(ib) = iaproto(ia)
        itypei(ib) = itypep(ia)
        igroupi(ib) = igroup(ia)
        posi(:,ib) = pos(:,ia)
        Axe_atom_clui(:,ib) = Axe_atom_clu(:,ia)
        distai(ib) = dista(ia)
        if( ia == iaabs ) iaabsi = ib
      end do

      do iapr = n_atom_0, n_atom_ind
        if( Atom_occ_mat .and. hubbard ) then
          if( Full_atom ) then
            igr = igroupi(iapr)
            it = itypei(iapr)
          else
            igr = igreq(iapr,1)
            ipr = iaprotoi(igr)
            it = itypepr(ipr)
          end if
          l = l_hubbard(numat(it))
          i = 0
          do m = -l, l
            do ispin = 1, nspin
              i = i + 1
              Int_dens_all(m,m,ispin,iapr) = occ_mat_gr(i,igr)
            end do
          end do
        end if
      end do

! Elaboration de la liste d'atomes equivalents
! On met en premier l'atome representant.
      nb_eq(:) = 0
      do ia = 1,natomeq
        ps(:) = pos(:,ia)
        call posequiv(mpirank,ps,iopsymr,isym,igrpt_nomag)
        if( abs(isym) /= 1 ) cycle
        do ib = 1,natome
          dp(:) = abs( ps(:) - posi(:,ib) )
          if( dp(1) > epspos .or. dp(2) > epspos .or. dp(3) > epspos )
     &        cycle
          nb_eq(ib) = nb_eq(ib) + 1
          ia_eq( nb_eq(ib), ib ) = ia
          is_eq( nb_eq(ib), ib ) = isym
          exit
        end do 
      end do
      do ia = 1,natomeq
        ps(:) = pos(:,ia)
        call posequiv(mpirank,ps,iopsymr,isym,igrpt_nomag)
        if( abs(isym) == 1 ) cycle
        do ib = 1,natome
          dp(:) = abs( ps(:) - posi(:,ib) )
          if( dp(1) > epspos .or. dp(2) > epspos .or. dp(3) > epspos )
     &        cycle
          nb_eq(ib) = nb_eq(ib) + 1
          ia_eq( nb_eq(ib), ib ) = ia
          is_eq( nb_eq(ib), ib ) = isym
          exit
        end do 
      end do

      do ib = 1,natome
        do i = 1,nb_eq(ib)
          ia_eq_inv( ia_eq( i, ib ) ) = ib 
        end do
      end do

      do ia = 1,natome
        js = 0
        do is = 1,nopsm
          if( iopsymr(is) == 0 ) cycle
          js = js + 1
          call opsym(is,matopsym)
          ps(:) = posi(:,ia)
          v = matmul( matopsym, ps )
          do i = 1,nb_eq(ia)
            ie = ia_eq(i,ia)
            dp(:) = abs( v(:) - pos(:,ie) )
            if( dp(1) > epspos .or. dp(2) > epspos
     &             .or. dp(3) > epspos ) cycle
            ia_eq_sym(js,ia) = i
            exit     
          end do
        end do
      end do

! Calcul du nombre d'atomes n' tels que S(n0) = n0 et S(n1) = n'
! et evaluation des n1
      nb_rpr(:,:) = 0
      nb_rep_t(:,:,:) = 0
      do ia = 1,natome
        do ib = 1,natome

          Fait(:) = .false.
          ind_rep = 0

          do i = 1,nb_eq(ib)

!          Fait(:) = .false.
            ie = ia_eq(i,ib)
            if( Fait(i) ) cycle  ! i est d�j� represente ou representant

            ind_rep = ind_rep + 1
            ia_rep(ind_rep,ia,ib) = ie 

            do is = 1,nopsm
              if( iopsymr(is) == 0 ) cycle
              call opsym(is,matopsym)
              ps(:) = posi(:,ia)
              v = matmul( matopsym, ps )
              dp(:) = abs( v(:) - ps(:) )
              if( dp(1) > epspos .or. dp(2) > epspos
     &             .or. dp(3) > epspos ) cycle         ! S(ia) /= ia

              ps(:) = pos(:,ie)
              ps = matmul( matopsym, ps )

              do j = 1,nb_eq(ib)   ! recherche du n' = S(n1)
                if( Fait(j) ) cycle
                ig = ia_eq(j,ib) 
                dp(:) = abs( pos(:,ig) - ps(:) )
                if( dp(1) > epspos .or. dp(2) > epspos 
     &              .or. dp(3) > epspos ) cycle
                nb_rep_t(ind_rep,ia,ib) = nb_rep_t(ind_rep,ia,ib) + 1
                Fait(j) = .true.
              end do
!              Fait(j) = .true.
!              Fait(i) = .true. 

            end do

          end do

          nb_rpr(ia,ib) = ind_rep  
        end do
      end do

      if( magnetic ) then
        Atom_mag(0) = Atom_mag_cal(igrpt0)
      else
        Atom_mag(0) = .false.
      endif
      if( Ylm_complex ) then
        Atom_comp(0) = .true.
      else        
        Atom_comp(0) = Atom_comp_cal(igrpt0)
      endif 

! Evaluation de la symetrie locale
      do ia = 1,natome
        if( icheck(6) > 1 ) write(3,130) ia
        ps(:) = posi(:,ia)
        call point_group_atom(Atom_comp(ia),Atom_mag(ia),Atom_mag_gr,
     &      Atom_nsph,Axe_atom_clu,iaabs,iatomp(ia),igroup,igroupi(ia),
     &      igrpt(ia),iopsyma,iopsymr,it0,itype,itypep,magnetic,
     &      mpirank,natomp,ngroup,nlat,nlatm,nspin,ntype,
     &      numat,popats,pos,ps,rot_a,spinorbite)

        Atom_comp(ia) = Atom_comp(ia) .or. Atom_comp(0) 
        if( magnetic ) then
          Axe_atom_clui(:,ia) = rot_a(:,3) 
        else
          Atom_mag(ia) = .false.
        endif 
        if( .not. Atom_comp(0) ) Atom_comp(ia) = .false. 
        iopsym_atom(:,ia) = iopsyma(:)
        rot_atom(:,:,ia) = rot_a(:,:)
      end do

! Parametres du maillage
      ad = adimp
      it = itypei(natome)
      if( overad ) then
        rm = distai(natome) + rmt(it) + roverad
      else
        rm = distai(natome) + rmt(it) + ad
      endif
      rsort = max( rsorte, rm )
      rmax = ( rsort / ad + sqrt(2._db) * ( iord / 2 ) + epspos )
     &     / cos( pi / 6 )
      nx = nint( rmax )

      if( icheck(6) > 0) then
        write(3,140) rsort*bohr
        write(3,150) nx
        write(3,160) natome, igrpt0, Atom_comp(0), Atom_mag(0)
        if( magnetic .or. Atom_nonsph ) then
          write(3,170)
        else
          write(3,180)
        endif
        do ia = 1,natome
          it = itypei(ia) 
          if( atom_mag(ia) ) then
            write(3,190) ia, numat(it), it, igroupi(ia), iaprotoi(ia),
     &                  iatomp(ia), posi(1:3,ia)*bohr,
     &                  igrpt(ia), ptgrname_int(igrpt(ia)),
     &                  Atom_comp(ia), Atom_mag(ia), Axe_atom_clui(:,ia)
          else
            write(3,190) ia, numat(it), it, igroupi(ia), iaprotoi(ia),
     &                  iatomp(ia), posi(1:3,ia)*bohr,
     &                  igrpt(ia), ptgrname_int(igrpt(ia)),
     &                  Atom_comp(ia), Atom_mag(ia)
          endif
        end do
        write(3,'(/A)') ' Atom rotation matrices :'
        na_ligne = 4
        do iga = 1,(natome-1)/na_ligne + 1
          na1 = na_ligne * iga - na_ligne + 1
          na2 = min(na1+na_ligne-1,natome)
          write(3,200) (ia, ia = na1,na2) 
          do i = 1,3
            write(3,210) ( rot_atom(i,:,ia), ia = na1,na2) 
          end do
        end do

        write(3,220)
        do ia = 1,natome
          write(3,230) ia, ( ia_eq(i,ia), is_eq(i,ia), i = 1,nb_eq(ia) )
        end do  
      endif

      if( icheck(6) > 1) then
        write(3,232)
        do ia = 1,natomeq
          write(3,230) ia, ia_eq_inv(ia)
        end do  
        write(3,240) ( ia, ia = 1,natome )
        js = 0
        do is = 1,nopsm
          if( iopsymr(is) == 0 ) cycle
          js = js + 1
          write(3,250) is, ( ia_eq_sym(js,ia), ia = 1,natome )
        end do  
        write(3,260)
        do ia = 1,natome
          do ib = 1,natome
          write(3,270) ia, ib, ( ia_rep(i,ia,ib), nb_rep_t(i,ia,ib),
     &                           i = 1,nb_rpr(ia,ib) )  
          end do
        end do
      endif

! L'elaboration du reseau s'effectuant autour de chaque atome, en
! definissant la zone atomique par la sphere muffin-tin, il est
! necessaire d'avoir des rayons muffin-tin laissant l'espace a au moins
! un point entre les atomes.

      do ia1 = 1,natome
        it1 = itypei(ia1)
        do ia2 = ia1+1,natome
          it2 = itypei(ia2)
          v(:) = posi(:,ia1) - posi(:,ia2)
          dist = vnorme(v)
          if( dist < rmt(it1) + rmt(it2) - ad .and. mpirank == 0) then
            call write_error
            do ipr = 3,9,3
              write(ipr,280) ia1, numat(itypei(ia1)), igroupi(ia1), ia2,
     &                       numat(itypei(ia2)), igroupi(ia2), dist*bohr
            end do
            stop
          endif
        end do
      end do

      if( iaabsi == 0 .and. mpirank == 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,290)
        end do
        stop
      endif

      return
  110 format(/' ---- Atom_selec --',100('-'))
  130 format(/' Atome',i3,', with working cluster sub-point group')
  140 format(/'  Rsort = ',f8.3,' A')
  150 format('  nx =',i3)
  160 format('  natome =',i4,', igrpt =',i4,', Cluster_comp =',l2,
     &', Cluster_mag =',l2)
  170 format(/' ia   Z  it  igr ipr iap     posx      posy',
     &'      posz   igrpt PtGrName  Atom_comp  Atom_mag',9x,'Axe_atom')
  180 format(/' ia   Z  it  igr ipr iap     posx      posy',
     &'      posz   igrpt PtGrName  Atom_comp  Atom_mag')
  190 format(i3,2i4,i5,2i4,3f10.5,i5,6x,a8,l3,l10,3f10.5)
  200 format(/'  Atom :',4x,i3,3(21x,i3))
  210 format(4(3x,3f7.3))
  220 format(/' Atom  ia_eq  is_eq')
  230 format(i4,3x,48(1x,2i3))
  232 format(/' Atom  ia_eq_inv')
  240 format(/' ia_sym_eq (index of the representative atom)',
     &       /' Sym \ ia ',1x,48i3)
  250 format(i4,7x,48i3)
  260 format(/' Atom Atom ia_rep, nb_rep_t ')
  270 format(i4,i5,3x,96i3)
  280 format(//' The atoms',i3,' (Z =',i3,', igr =',i5,') and',i3,
     &' (Z =',i3,', igr =',i5,')',/
     &' inside the cluster of calculation, are too close !',/
     &' Their distance is',f8.5,' Angstroem')
  290 format(//' The absorbing atom is outside the calculation sphere !'
     &       //)
      end

!***********************************************************************

! Cherche le point equivalent a l'interieur de la zone de calcul
! compte tenu des symmetries.

      subroutine posequiv(mpirank,pos,iopsym,isym,igrpt_nomag)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer, dimension(nopsm):: iopsym

      logical d6, d6p, dpn12, dp13, d3p12, d3pn12,gdiag, symok 
      logical, dimension(3):: pnul, ppn, ppos
      logical, dimension(2):: p3nul, p3pn, p3pos

      real(kind=db), dimension(3):: p, pos, v
      real(kind=db), dimension(3,3):: matopsym

      isym = 1

      do k = 1,3
        pnul(k) = abs(pos(k)) < epspos
      end do
      if( pnul(1) .and. pnul(2) .and. pnul(3) ) return

      do is = 1,nopsm
        if( iopsym(is) == 0 ) cycle

        call opsym(is,matopsym)
        v = matmul( matopsym, pos )
        do k = 1,3
          pnul(k) = abs(v(k)) < epspos
          ppos(k) = v(k) > epspos
          ppn(k) = ppos(k) .or. pnul(k)
        end do
        dpn12 = v(1) > v(2) - epspos
        dp13 = v(1) > v(3) + epspos
        gdiag = ppn(1) .and. ( abs(v(1)-v(2)) < epspos )
     &                 .and. ( abs(v(1)-v(3)) < epspos )

 ! Cas des groupes trigo et hexagonal

        if( igrpt_nomag > 15 .and. igrpt_nomag < 28 ) then
          r3 = sqrt(3._db)
          f = 1 / r3 
          p(1) = v(1) + f * v(2)
          p(2) = 2 * f * v(2)
          p(3) = v(3)
          do k = 1,2
            p3nul(k) = abs(p(k)) < epspos
            p3pos(k) = p(k) > epspos
            p3pn(k) = p3pos(k) .or. p3nul(k)
          end do
          d3p12 = (p(1) > p(2) + epspos) .or. ( pnul(1) .and. pnul(2) ) 
          d3pn12 = p(1) > p(2) - epspos
          d6 = v(1) > abs( r3 * v(2) ) - epspos
          d6p = ( ( v(1) > - sqrt(3._db) * v(2) + epspos ) .and.
     &            (  v(1) > r3 * v(2) - epspos ) ) .or.
     &           ( pnul(1) .and. pnul(2) ) 
        endif

        select case(igrpt_nomag)

          case(1)
            goto 1020

          case(2)
            if( ppos(3) .or.
     &        ( pnul(3) .and.  ppos(1) ) .or.
     &        ( pnul(3) .and.  pnul(1) .and. ppn(2) ) ) goto 1020

          case(3)
            if( ppn(3) ) goto 1020

          case(4)
            if( ppos(1) .or. ( pnul(1) .and.  ppn(2) ) ) goto 1020

          case(5)
            if( ppn(3) .and.
     &        ( ppos(1) .or. ( pnul(1) .and.  ppn(2) ) ) ) goto 1020

          case(6)
            if( ppn(1) .and. ppn(2) ) goto 1020

          case(7)
            if( ( ppos(1) .and. ppos(2) ) .or.
     &          ( pnul(1) .and. ppn(2) .and. ppn(3) ) .or.
     &          ( pnul(2) .and. ppn(1) .and. ppn(3) ) ) goto 1020

          case(8)
            if( ppn(1) .and. ppn(2) .and. ppn(3) ) goto 1020

          case(9)
            if( ( ppos(1) .and. ppn(2) ) .or.
     &          ( pnul(1). and. pnul(2) ) ) goto 1020

          case(10)
            if( ( ppos(1) .and. ppn(2) ) .or.
     &          ( pnul(1). and. pnul(2) .and. ppn(3) ) ) goto 1020

          case(11)
            if( ( ppn(3) .and. ppos(1) .and. ppn(2) ) .or.
     &          ( ppn(3). and. pnul(1). and. pnul(2) ) ) goto 1020

          case(12)
            if( ppn(2) .and. dpn12 ) goto 1020

          case(13)
            if( ( ppos(2) .and. dpn12 ) .or.
     &          ( pnul(2) .and. ppn(1) . and. ppn(3) ) ) goto 1020

          case(14)
            if( ( ppos(2) .and. dpn12 ) .or.
     &          ( pnul(2) .and. dpn12 . and. ppn(3) ) ) goto 1020

          case(15)
            if( ppn(2) .and. dpn12 . and. ppn(3)) goto 1020

          case(16)  ! C3
            if( ( p3pos(1) .and. p3pn(2) ) .or.
     &          ( p3nul(1) .and. p3nul(2) ) ) goto 1020

          case(17)  ! S6
            if( ( p3pos(1) .and. p3pn(2) .and. ppos(3) ) .or.
     &          ( p3nul(1) .and. p3nul(2).and. ppn(3) ) .or.
     &          ( d3p12 .and. p3pn(1) .and. p3pn(2) .and. pnul(3) ) )
     &                     goto 1020

          case(18)  ! C3v
            if( d6 ) goto 1020

          case(19)
            if( ( (  ( p3pos(1) .and. p3pn(2) ) .or.
     &          ( pnul(1). and. pnul(2) )  ) .and. ppos(3) )  .or.
     &           ( pnul(3) .and. p3pos(1) .and. d3pn12   )) goto 1020

          case(20)
            if( d6p ) goto 1020

          case(21)  ! C3h
            if( ( p3pos(1) .and. p3pn(2) .and. ppn(3) ) .or.
     &          ( p3nul(1) .and. p3nul(2).and. ppn(3) ) ) goto 1020

          case(22)   ! C6
            if( p3pn(1) .and. p3pn(2) .and. d3p12 ) goto 1020

          case(23)   ! C6h
            if( p3pn(1) .and. p3pn(2) .and. d3p12 .and. ppn(3) ) 
     &                goto 1020

          case(24)
            if( d6 .and. ppn(3) ) goto 1020

          case(25)
            if( d6p .and. ppn(2) ) goto 1020

          case(26)
            if( ( ppn(2) .and. d3p12 .and. ppos(3) ).or.
     &          ( d6 .and. ppn(2) .and. pnul(3) ) ) goto 1020

          case(27)
            if( d6 .and. ppn(2) .and. ppn(3) ) goto 1020

          case(28)
            a3 = abs( v(3) )
            if( ppn(2) .and. (( dpn12 . and. v(1) > a3+epspos )
     & .or. ( abs(v(1)-v(2)) < epspos .and. abs(v(1)-a3) < epspos ) ))
     &                                                    goto 1020

          case(29) ! m3
            if( ppn(2) .and. ppn(3) .and.
     &        ( ( dpn12 . and. dp13 ) .or. gdiag ) ) goto 1020

          case(30) ! -43m
            a3 = abs( v(3) )
            if( dpn12 . and.  v(2) > a3-epspos ) goto 1020

          case(31) ! 432
            if( ( ppn(3) .and. ppos(2) .and. dpn12 . and. dp13 )
     &           .or. ( ppn(1) .and. pnul(2) .and. pnul(3) )
     &           .or. gdiag ) goto 1020

          case(32) ! m3m
            a3 = abs( v(3) )
            if( ppn(3) .and.
     &       ( dpn12 . and. v(2) > a3-epspos ) ) goto 1020

          case(35)
            if( ppn(1) .and.
     &        ( ppos(3) .or. ( pnul(3) .and. ppn(2) ) ) ) goto 1020

          case default

            symok = .false.

            select case(is)

              case(10)        ! Axe 2 diagonal (110)
                if( ppos(3) .or. (pnul(3) .and. dpn12) ) symok = .true.

              case(11)        ! Axe 2 diagonal (1-10)
                if( ppos(3) .or. ( pnul(3)
     &              .and. pos(2) < - pos(1) + epspos ) ) symok = .true.

              case(22,23,24)  ! Axes 2
                k = is - 21
                k2 = 1 + mod(k,3)
                k3 = 1 + mod(k+1,3)
                if( ppos(k2) .or.
     &            ( pnul(k2) .and. ppn(k3) ) ) symok = .true.

              case(25)        ! Centrosymetrie
                if( ppos(3) .or. ( pnul(3) .and.  ppos(1) ) .or.
     &          ( pnul(3) .and.  pnul(1) .and. ppn(2) ) ) symok = .true.

              case(40,41,42)  ! Plans de symetrie principaux
                k = is - 39
                if( ppn(k) ) symok = .true.

              case(45)        ! Plan diagonal
                if( dpn12 ) symok = .true.

              case(48)        ! Plan diagonal
                if( pos(2) < -pos(1)+epspos ) symok = .true.

            end select

          if( symok ) pos = v

        end select

      end do

      if( is > nopsm .and. mpirank == 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,120) igrpt_nomag, pos(1:3)
          call write_iopsym(iopsym,ipr)
        end do
        stop
      endif

 1020 pos = v

      isym = iopsym(is) * isym_inv(is)

      return
  120 format(/' Probleme dans posequiv : symetrie mal programmee !'/
     &        ' igrpt_nomag =',i3,', pos =',3f7.3,//' iopsym =')
      end

!***********************************************************************

! Determination de l'op�ration de symmetrie inverse.

      function isym_inv(is)
 
      select case(is)
        case(2,4,6,8,32,34,36,38,49,51,53,55)
          isym_inv = is + 1
        case(3,5,7,9,33,35,37,39,50,52,54,56)
          isym_inv = is - 1
        case(16,17,18,26,27,28)
          isym_inv = is + 3
        case(19,20,21,29,30,31)
          isym_inv = is - 3
        case default
          isym_inv = is
      end select

      return
      end

!***********************************************************************

      subroutine point_group_atom(Atom_comp,Atom_mag,Atom_mag_gr,
     &        Atom_nsph,Axe_atom_clu,iaabs,iap,igroup,igra,igrpt,
     &        iopsym,iopsymr,it0,itype,itypep,magnetic,
     &        mpirank,natomp,ngroup,nlat,nlatm,nspin,ntype,numat,
     &        popats,pos,posi,rot_atom,spinorbite)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer, dimension(natomp):: igroup, itypep
      integer, dimension(nopsm):: iopsym, iopsymr, irotiops
      integer, dimension(ngroup):: itype
      integer, dimension(it0:ntype):: nlat, numat

      logical Atom_comp, Atom_comp_cal, Atom_mag, Atom_mag_cal,
     &        Atom_nonsph, magnetic, spinorbite
      logical, dimension(ngroup):: Atom_nsph
      logical, dimension(0:ngroup):: Atom_mag_gr

      real(kind=db), dimension(3):: posi, px, py, pz, v
      real(kind=db), dimension(3,3):: rot_atom, rot_tem, rot_un
      real(kind=db), dimension(3,natomp):: Axe_atom_clu, Axe_atom_clut,
     &                                    p, pos
      real(kind=db), dimension(ngroup,nlatm,nspin):: popats

      common/Atom_nonsph/ Atom_nonsph
      common/icheck/ icheck(24)
      common/igrpt0/ igrpt0

      rot_un = 0._db
      do i = 1,3
        rot_un(i,i) = 1._db
      end do

      rot_atom(:,:) = rot_un(:,:)
      Axe_atom_clut(:,1:natomp) = Axe_atom_clu(:,1:natomp)

      if( abs( posi(1) ) < eps10 .and. 
     &   abs( posi(2) ) < eps10 .and. abs( posi(3) ) < eps10 ) then

        iopsym = iopsymr(:)
        igrpt = igrpt0

      else

        do ib = 1,natomp
          p(:,ib) = pos(:,ib) - posi(:)
        end do

! Determination des symmetries du groupe ponctuel (iopsymc)
        do i = 1,2

          call sym_cluster(Atom_mag_gr,Atom_nsph,Axe_atom_clut,iaabs,
     &            igroup,iopsym,it0,itype,itypep,natomp,
     &            ngroup,nlat,nlatm,nspin,ntype,numat,popats,p)

! Le groupe ponctuel de l'atome doit etre un sous-groupe du groupe
! de l'agregat.
          call iop_rot(irotiops,transpose(rot_atom))
          where( irotiops /= 0 ) irotiops = iopsymr(irotiops)
          where( irotiops == 0 ) iopsym = 0

          call cluster_rot(iopsym,rot_tem)

          if( sum( abs( rot_tem(:,:) - rot_un(:,:) ) ) < eps10  ) exit

          rot_atom(:,:) = matmul( rot_tem, rot_atom )

          do ib = 1,natomp
            v(:) = p(:,ib)
            v = matmul( rot_tem, v )
            p(:,ib) = v(:)
          end do
          if( magnetic .or. Atom_nonsph ) then
            do ib = 1,natomp
              v(:) = Axe_atom_clut(:,ib)
              v = matmul( rot_tem, v )
              Axe_atom_clut(:,ib) = v(:) 
            end do
          endif

        end do

        call numgrpt(iopsym,igrpt,igrpt_nomag,mpirank)

      endif

      if( magnetic ) then
        Atom_mag = Atom_mag_cal(igrpt)
      else
        Atom_mag = .false.
      endif

      if( spinorbite ) then
         
        if( Atom_mag .and. .not. Atom_mag_gr(igra) ) then
          call Axe_mag_cal(igrpt,pz)
        else
          pz = Axe_atom_clut(:,iap)
        endif

        if( abs( pz(2) - 1._db ) < epspos ) then
          px(1:2) = 0._db
          px(3) = - 1._db
          call prodvec(py,pz,px)
        elseif( abs( pz(2) + 1._db ) < epspos ) then
          px(1:2) = 0._db
          px(3) = 1._db
          call prodvec(py,pz,px)
        else
          py(1:3:2) = 0._db
          py(2) = 1._db
          call prodvec(px,py,pz)
          pp = sqrt( sum( px(:)**2 ) )
          px(:) = px(:) / pp
          call prodvec(py,pz,px)
        endif

        rot_tem(1,1:3) = px(1:3)
        rot_tem(2,1:3) = py(1:3)
        rot_tem(3,1:3) = pz(1:3)
        rot_atom(:,:) = matmul( rot_tem, rot_atom )

        call iop_rot(irotiops,transpose(rot_tem))
        where( irotiops /= 0 ) iopsym = iopsym(irotiops)
           
      endif 

      Atom_comp = Atom_comp_cal(igrpt)

      if( icheck(6) > 1 ) then
        if( Atom_mag ) then
          write(3,110) igrpt
        else
          write(3,120) igrpt
        endif
        write(3,130)
        call write_iopsym(iopsym,3)
        write(3,150) rot_atom(:,:)
      endif

      return
  110 format(/' Local point group number',i3,', magnetic atom.')
  120 format(/' Local point group number',i3,', non-magnetic atom.')
  130 format(/' iopsym =')
  150 format(/' Atomic rotation matrix :',3(/,3f10.5))
      end

!***********************************************************************

! Pour certains groupes magnetique, l'atome central ne peut pas etre
! magn�tique

      function Atom_mag_cal(igrpt)

      logical Atom_mag_cal  

      select case(igrpt)
        case(1,2,3,4,5,9,10,11,16,17,21,22,23,35,39,40,41,44,45,46,48,
     &       53,58,60,67,70,73,78,84)
          Atom_mag_cal = .true.
        case default
          Atom_mag_cal = .false.
      end select

      return
      end

!***********************************************************************

! Pour certains groupes magnetique, l'atome central ne peut pas etre
! magn�tique

      subroutine Axe_mag_cal(igrpt,Axe)

      use declarations
      real(kind=db), dimension(3):: Axe  

      Axe(1:3) = 0._db

      select case(igrpt)
        case(34,35,41)
          Axe(2) = 1._db
        case default
          Axe(3) = 1._db
      end select

      return
      end

!***********************************************************************

! Pour certains groupes la base commode est la base des Y(l,m) complexes

      function Atom_comp_cal(igrpt)

      logical Atom_comp_cal  

      select case(igrpt)
        case(9,10,11,16,17,21,22,23,47,51,52,55,56,57,68,69,75,76,77)
          Atom_comp_cal = .true.
        case default
          Atom_comp_cal = .false.
      end select

      return
      end

!***********************************************************************

! Calcul du nombre de point du maillage.

      subroutine nbpoint(green,iaabs,igrpt_nomag,iord,mpirank,
     &                   natomp,npoint,npso,nx,pos,rsort)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      logical base_hexa, green

      real(kind=db), dimension(3):: p, v, w
      real(kind=db), dimension(3,natomp):: pos

      common/ad/ ad
      common/axyz/ axyz(3), angxyz(3)
      common/base_hexa/ base_hexa
      common/icheck/ icheck(24)
      common/iopsymr/ iopsymr(nopsm)
  
      f = sqrt(3._db)/2

      if( green ) then
        dcour = rsort
        do ia = 1,natomp
          if( ia == iaabs ) cycle
          p(:) = pos(:,ia) - pos(:,iaabs)
          dcour = min(dcour,vnorme(p))
        end do
        rmax = min(dcour,rsort) / ad + epspos
      else
        rmax = rsort / ad + sqrt(2._db) * iord / 2 + epspos
      endif

      p(:) = pos(:,iaabs) / ad
      npoint = 0
      npso = 0
      do ix = -nx,nx
        do iy = -nx,nx
          if( base_hexa ) then
            v(1) = ix - 0.5_db * iy 
            v(2) = f * iy
          else
            v(1) = 1._db * ix
            v(2) = 1._db * iy
          endif
          do iz = -nx,nx
            v(3) = 1._db * iz
            if( green ) then
              w(:) = v(:) - p(:)
              dist = vnorme(w)
            else
              dist = vnorme(v)
            endif
            if( dist > rmax ) cycle
            w(:) = v(:)
            call posequiv(mpirank,w,iopsymr,isym,igrpt_nomag)
            w(:) = abs( (v(:) - w(:) ) )
            if( w(1) > epspos .or. w(2) > epspos .or. w(3) > epspos )
     &                                                           cycle
            npso = npso + 1
            if( dist*ad <= rsort + epspos ) npoint = npoint + 1
         end do
        end do
      end do

      return
      end

!***********************************************************************

! Elaboration du maillage.

      subroutine reseau(green,iaabs,igrpt_nomag,indice,iord,it0,itypei,
     &                 mpirank,mpres,natome,natomp,nim,npoint,
     &                 npr,npso,npsom,ntype,numia,nx,pos,
     &                 posi,rmt,rsort,rvol,xyz)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer, dimension(natome):: itypei
      integer, dimension(npsom,3):: indice
      integer, dimension(npsom):: numia
      integer, dimension(-nx:nx,-nx:nx,-nx:nx):: mpres

      logical base_hexa, green

      real(kind=db), dimension(3):: p, x, v, w
      real(kind=db), dimension(nim):: rvol
      real(kind=db), dimension(it0:ntype) :: rmt
      real(kind=db), dimension(3,natome):: posi
      real(kind=db), dimension(3,natomp):: pos
      real(kind=db), dimension(4,npsom):: xyz

      common/ad/ ad
      common/axyz/ axyz(3), angxyz(3)
      common/base_hexa/ base_hexa
      common/icheck/ icheck(24)
      common/iopsymr/ iopsymr(nopsm)
 
      if( icheck(7) > 0 ) write(3,100)

      mpres(:,:,:) = 0
      f = sqrt(3._db)/2

      if( green ) then
        dcour = rsort
        do ia = 1,natomp
          if( ia == iaabs ) cycle
          p(:) = pos(:,ia) - pos(:,iaabs)
          dcour = min(dcour,vnorme(p))
        end do
        rmax = min(dcour,rsort) / ad + epspos
      else
        rmax = rsort / ad + sqrt(2._db) * iord / 2 + epspos
      endif

      p(:) = pos(:,iaabs) / ad
      i = 0
      do ix = -nx,nx
        do iy = -nx,nx
          if( base_hexa ) then
            v(1) = ix - 0.5_db * iy 
            v(2) = f * iy
          else
            v(1) = 1._db * ix
            v(2) = 1._db * iy
          endif
          do iz = -nx,nx
            v(3) = 1._db * iz
            if( green ) then
              w(:) = v(:) - p(:)
              dist = vnorme(w)
            else
              dist = vnorme(v)
            endif
            if( dist > rmax ) cycle
            w(:) = v(:)
            call posequiv(mpirank,w,iopsymr,isym,igrpt_nomag)
            if( abs(v(1)-w(1)) < epspos .and. abs(v(2)-w(2)) < epspos
     &                           .and. abs(v(3)-w(3)) < epspos ) then
              i = i + 1
              indice(i,1) = ix
              indice(i,2) = iy
              indice(i,3) = iz
              xyz(4,i) = ad * dist
            endif
          end do
        end do
      end do
      npso = i

! Mise en ordre par rapport a la distance au centre de l'agregat.
      do i = 1,npso
        do j = i+1,npso
          if( xyz(4,i) < xyz(4,j) + epspos ) cycle
          xyzij = xyz(4,i)
          xyz(4,i) = xyz(4,j)
          xyz(4,j) = xyzij
          indi1 = indice(i,1)
          indi2 = indice(i,2)
          indi3 = indice(i,3)
          indice(i,1:3) = indice(j,1:3)
          indice(j,1) = indi1
          indice(j,2) = indi2
          indice(j,3) = indi3
        end do
      end do

      do i = 1,npso
        if( base_hexa ) then
          xyz(1,i) = ( indice(i,1) - 0.5_db * indice(i,2) ) * ad 
          xyz(2,i) = f * indice(i,2) * ad
          xyz(3,i) = indice(i,3) * ad
        else
          xyz(1:3,i) = indice(i,1:3) * ad
        endif
      end do

! Nombre de points a l'interieur de la zone de calcul :
      do i = 1,npso
        if( xyz(4,i) > rsort + epspos ) exit
      end do
      npoint = i - 1
      numia(1:npoint) = 0
      if( npoint < npso ) numia(npoint+1:npso) = -2

      do i = 1,npso
        mpres(indice(i,1),indice(i,2),indice(i,3)) = i
      end do

! Liste des points qui sont dans un atome.
      do ia = 1,natome
        it = itypei(ia)
        p(1:3) = posi(1:3,ia)
        do i = 1,npoint
          x(1:3) = xyz(1:3,i)
          call posrel(x,p,v,dr,isym)
          if( dr < rmt(it) + epspos ) numia(i) = ia
        end do
      end do
      npr = npoint
      do i = 1,npoint
        if( numia(i) /= 0 ) npr = npr - 1
      end do

! Calcul du volume des points.

      f3 = 1 / sqrt(3._db)
      df3 = 2 * f3
      istop = 0
      p(:) = pos(:,iaabs) / ad
      rvol(:) = 0._db
      do ix = -nx,nx
        do iy = -nx,nx
          if( base_hexa ) then
            v(1) = ix - 0.5_db * iy 
            v(2) = f * iy
          else
            v(1) = 1._db * ix
            v(2) = 1._db * iy
          endif
          do iz = -nx,nx
            v(3) = 1._db * iz
            if( green ) then
              w(:) = v(:) - p(:)
              dist = vnorme(w)
            else
              dist = vnorme(v)
            endif
            if( dist > rmax ) cycle
            w(:) = v(:)
            call posequiv(mpirank,w,iopsymr,isym,igrpt_nomag)
            if( base_hexa ) then
              ix1 = nint( w(1) + f3 * w(2) )
              iy1 = nint( df3 * w(2) )
            else
              ix1 = nint( w(1) )
              iy1 = nint( w(2) )
            endif
            iz1 = nint( w(3) )
            i = mpres(ix1,iy1,iz1)
            if( i > npoint ) cycle
            if( i == 0 .and. mpirank == 0 ) then
              if( istop == 0 ) call write_error
              do ipr = 3,9,3
                write(ipr,130) ix, iy, iz, ix1, iy1, iz1
              end do
              istop = 1
              goto 1020
            endif
            rvol(i) = rvol(i) + 1
          end do
        end do
      end do

      rvmax = 1._db
      do i = 1,npoint
        rvmax = max(rvmax,rvol(i))
      end do
      rvol(1:npoint) = rvol(1:npoint) / rvmax

 1020 if( icheck(7) > 0 ) then
        write(3,150) npr, npoint, npso
        write(3,160) natome
      endif
      if( icheck(7) > 1 .or. istop == 1 ) then
        if( base_hexa ) then
          write(3,170)
        else
          write(3,175)
        endif
        do i = 1,npoint
          write(3,180) i, indice(i,1:3), numia(i), xyz(1:4,i)*bohr,
     &                 rvol(i)
        end do
        do i = npoint+1,npso
          write(3,180) i, indice(i,1:3), numia(i), xyz(1:4,i)*bohr
        end do
        if( istop == 1 ) stop
      endif

      return
  100 format(/' ---- Reseau -------',100('-'))
  130 format(//' Pour ix, iy, iz =',3i3,', point equivalent en',
     &         ' ix1, iy1, iz1 =',3i3,/' non trouve dans reseau !'/ )
  150 format(/' npr =',i6,', npoint =',i6,', npso =',i6)
  160 format(' natome =',i4)
  170 format(/ ' Point index along hexagonal mesh',//
     &'    i  ix  iy  iz  ia   xval    yval    zval    ',
     &'rval    rvol')
  175 format(/'    i  ix  iy  iz  ia    xval    yval    zval    ',
     &'rval    rvol')
  180 format(i5,4i4,5f8.4)
      end

!***********************************************************************

      subroutine posrel(x,a,u,dr,isym)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      real(kind=db), dimension(3):: a, b, x, u, v, w
      real(kind=db), dimension(3,3):: matopsym

      common/iopsymr/ iopsymr(nopsm)

      u(:) = x(:) - a(:)
      dr = vnorme(u)
      isym = 1

      do is = 2,nopsm
        select case(is)
          case(2,4,6,8,32,34,36,38,49,51,53,55)
            isi = is + 1
          case(3,5,7,9,33,35,37,39,50,52,54,56)
            isi = is - 1
          case(16,17,18,26,27,28)
            isi = is + 3
          case(19,20,21,29,30,31)
            isi = is - 3
          case default
            isi = is
        end select
        if( iopsymr(is) == 0 ) cycle
        call opsym(is,matopsym)
        b = matmul( matopsym, a )
        w(1:3) = x(1:3) - b(1:3)
        call opsym(isi,matopsym)
        v = matmul( matopsym, w )
        dr1 = vnorme(v)
        if( dr1 < dr-epspos ) then
          u(:) = v(:)
          dr = dr1
          isym = is * iopsymr(is)   ! pour avoir le signe
        endif
      end do

      return
      end

!***********************************************************************

! Routine calculant les coefficients du laplacien.

      subroutine laplac(cgrad,clapl,igrpt_nomag,indice,iord,
     &                ivois,isvois,mpirank,mpres,npso,
     &                npsom,nvois,nx)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer, dimension(3):: la
      integer, dimension(0:nvois,3):: indpro
      integer, dimension(npsom,3):: indice
      integer, dimension(npsom,nvois):: ivois, isvois
      integer, dimension(-nx:nx,-nx:nx,-nx:nx):: mpres

      logical base_hexa

      real(kind=db), dimension(2):: coeford 
      real(kind=db), dimension(3):: v 
      real(kind=db), dimension(nvois):: cgrad
      real(kind=db), dimension(0:nvois):: clapl

      common/ad/ ad
      common/base_hexa/ base_hexa
      common/icheck/ icheck(24)
      common/iopsymr/ iopsymr(nopsm)

      if( icheck(8) > 0 ) write(3,110)

! Coefficients du laplacien :

      indpro = 0

      ad2 = ad**2
      coeford(1) = 1._db
      if( iord == 2 ) then
        cl = 1._db / ad2
      else
        cl = ( 4._db / 3._db ) / ad2
        coeford(2) = - 1._db / 16
      endif

      d3 = 2._db / 3
      iv = 0
      do io = 1,iord/2

        do i = 1,3
          do is = -1,1,2
            iv = iv + 1
            clapl(iv) = coeford(io) * cl
            if( base_hexa .and. ( i == 1 .or. i == 2 ) )
     &                                 clapl(iv) = clapl(iv) * d3
            indpro(iv,i) = is * io
          end do
        end do

        if( base_hexa ) then
          do is = -1,1,2
            iv = iv + 1
            clapl(iv) = coeford(io) * cl * d3
            indpro(iv,1:2) = is * io
          end do
        endif

      end do

      clapl(0) = - sum( clapl(1:nvois) )

! Coefficients du gradient

      coeford(1) = 1._db
      if( iord == 2 ) then
        cd = 1 / ( 2 * ad )
      else
        cd = (4._db/3._db) / ( 2 * ad )
        coeford(2) = - 1._db/8
      endif
      f = 1 /sqrt(3._db)

      iv = 0
      do io = 1,iord/2
        if( base_hexa ) then
          do i = 1,4
            do is = -1,1,2
              iv = iv + 1
              cgrad(iv) = is * coeford(io) * cd
! i = 4 correspond a la direction (110)
              if( i == 2 .or. i == 4 ) cgrad(iv) = cgrad(iv) * f
            end do
          end do
        else
          do i = 1,3
            do is = -1,1,2
              iv = iv + 1
              cgrad(iv) = is * coeford(io) * cd
            end do
          end do
        endif
      end do

      if( icheck(8) > 0 ) then
        write(3,130) nvois
        write(3,140)
        do iv = 0,nvois
          write(3,150) iv, indpro(iv,:), clapl(iv) * ad2
        end do
        write(3,160)
        do iv = 1,nvois
          write(3,150) iv, indpro(iv,:), cgrad(iv) * ad
        end do
      endif

      f = sqrt(3._db) / 2
      f3 = 1 / sqrt(3._db)
      df3 = 2 * f3
      do i = 1,npso
        do  iv = 1,nvois

          la(1:3) = indice(i,1:3) + indpro(iv,1:3)
          if( base_hexa ) then
            v(1) = la(1) - 0.5_db * la(2)
            v(2) = f * la(2)
            v(3) = 1._db * la(3)
          else
            v(1:3) = 1._db * la(1:3)
          endif

! Si le voisin tombe en dehors de la maille, on le ramene dedans par
! la symetrie eventuelle.
          call posequiv(mpirank,v,iopsymr,isym,igrpt_nomag)
          if( base_hexa ) then
            la(1) = nint( v(1) + f3 * v(2) )
            la(2) = nint( df3 * v(2) )
            la(3) = nint( v(3) )
          else
            la(1:3) = nint( v(1:3) )
          endif

          if( abs(la(1)) <= nx .and. abs(la(2)) <= nx .and.
     &        abs(la(3)) <= nx ) then
            ivois(i,iv) = mpres(la(1),la(2),la(3))
            isvois(i,iv) = isym
          else
            ivois(i,iv) = 0
            isvois(i,iv) = 0
          endif

        end do
      end do

      if( icheck(8) > 1 ) then
        write(3,170)
        do i = 1,npso
          write(3,180) i, ( ivois(i,iv), isvois(i,iv),
     &                      iv = 1,nvois )
        end do
      endif

      return
  110 format(/' ---- Laplac -------',100('-'))
  130 format(/' nvois =',i3)
  140 format(/' iv  indpro  clapl * ad2')
  150 format(4i3,f12.6)
  160 format(/' iv  indpro  cgrad * ad')
  170 format(/'    i  ivois, isvois')
  180 format(i6,16(i6,i4))
      end

!***********************************************************************

! Routine effectuant la selection des points en bordure des spheres
! muffin-tin, et calculant les distances relatives de ces points au
! centre de l'atome correspondant.

      subroutine bordure(green,iord,iscratch,ivois,
     &           mpirank,natome,nbm,nbtm,nim,
     &           npoint,npso,npsom,nsm,nstm,numia,
     &           nvois,posi,rvol,xyz)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer, dimension(natome):: ibp, nbord, nbordf
      integer, dimension(npsom):: numia
      integer, dimension(npsom,nvois):: ivois
      integer, dimension(:), allocatable:: isrt
      integer, dimension(:,:), allocatable:: ibord, isbord

      logical green

      real(kind=db), dimension(3):: p, v, x
      real(kind=db), dimension(natome):: pdharm
      real(kind=db), dimension(nim):: rvol
      real(kind=db), dimension(3,natome):: posi
      real(kind=db), dimension(4,npsom):: xyz
      real(kind=db), dimension(:), allocatable :: poidso
      real(kind=db), dimension(:,:), allocatable :: poidsa

      common/ad/ ad
      common/icheck/ icheck(24)

! De ib = 1 a nbordf, on stocke les points frontiere exterieurs,
! de ib = nbordf+1 a nbord, les points interieurs.
      nbordf(1:natome) = 0
      nsortf = 0
      ibp(1:natome) = 0
      iss = 0
! Calcul des dimensions

      nv = 2 * nvois / iord

      do i = 1,npoint
        if( numia(i) /= 0 ) cycle
        do iv = 1,nv
          j = ivois(i,iv)
          if( j == 0 ) cycle
          ia = numia(j)
          if( ia == -2 ) then
            if( iss /= i ) nsortf = nsortf + 1
            iss = i
          elseif( ia > 0 .and. .not. green ) then
            if( ibp(ia) /= i ) nbordf(ia) = nbordf(ia) + 1
            ibp(ia) = i
          endif
        end do
      end do

      nbord(1:natome) = nbordf(1:natome)
      if( .not. green ) then
        do i = 1,npoint
          ia = numia(i)
          if( ia < 1 ) cycle
          do iv = 1,nvois
            j = ivois(i,iv)
            if( j == 0 .and. mpirank == 0 ) then
              call write_error
              do ipr = 3,9,3
                write(ipr,110) i, ia, iv
              end do
              stop
            endif
            if( numia(j) /= 0 ) cycle
            nbord(ia) = nbord(ia) + 1
            exit
          end do
        end do
      endif

      nsort = nsortf
      do i = npoint+1,npso
        do iv = 1,nvois
          j = ivois(i,iv)
          if( j == 0 ) cycle
          if( numia(j) /= 0 ) cycle
          nsort = nsort + 1
          exit
        end do
      end do

      do ia = 1,natome
        nbtm = max( nbtm, nbord(ia) )
        nbm = max( nbm, nbordf(ia) )
      end do
      nstm = max( nstm, nsort )
      nsm = max( nsm, nsortf )

      allocate( ibord(nbtm,natome) )
      allocate( isbord(nbtm,natome) )
      allocate( isrt(nsort) )
      allocate( poidsa(nbm,natome) )
      allocate( poidso(nsortf) )
      
      nbordf(1:natome) = 0
      nsortf = 0
      pdsort = 0._db
      pdharm(1:natome) = 0._db
      ibp(1:natome) = 0

! Les points en bordures sont seulement les points voisins dans les
! directions cristallographiques.
      do i = 1,npoint
        if( numia(i) /= 0 ) cycle
        do iv = 1,nv
          j = ivois(i,iv)
          if( j == 0 ) cycle
          ia = numia(j)
          if( ia == -2 ) then
            if( iss /= i ) then
              pdsort = pdsort + rvol(i)
              nsortf = nsortf + 1
              isrt(nsortf) = i
            endif
            iss = i
          elseif( ia > 0 .and. .not. green ) then
            if( ibp(ia) /= i ) then
              pdharm(ia) = pdharm(ia) + rvol(i)
              nbordf(ia) = nbordf(ia) + 1
              p(1:3) = posi(1:3,ia)
              x(1:3) = xyz(1:3,i)
              call posrel(x,p,v,dr,isym)
              ibord(nbordf(ia),ia) = i
              isbord(nbordf(ia),ia) = isym
            endif
            ibp(ia) = i
          endif
        end do
      end do

      nbord(1:natome) = nbordf(1:natome)
      if( .not. green ) then
        do i = 1,npoint
          ia = numia(i)
          if( ia < 1 ) cycle
          do iv = 1,nvois
            j = ivois(i,iv)
            if( j == 0 .and. mpirank == 0 ) then
              call write_error
              do ipr = 3,9,3
                write(ipr,110) i, ia, iv
              end do
              stop
            endif
            if( numia(j) /= 0 ) cycle

            nbord(ia) = nbord(ia) + 1
            p(1:3) = posi(1:3,ia)
            x(1:3) = xyz(1:3,i)
            call posrel(x,p,v,dr,isym)
            ibord(nbord(ia),ia) = i
            isbord(nbord(ia),ia) = isym
            exit
          end do
        end do
      endif

      nsort = nsortf
      do i = npoint+1,npso
        do iv = 1,nvois
          j = ivois(i,iv)
          if( j == 0 ) cycle
          if( numia(j) /= 0 ) cycle
          nsort = nsort + 1
          isrt(nsort) = i
          exit
        end do
      end do

      do ia = 1,natome
        if( nbordf(ia) > 0 ) fac = quatre_pi / pdharm(ia)
        do ib = 1,nbordf(ia)
          poidsa(ib,ia) = fac * rvol( ibord(ib,ia) )
        end do
      end do
      if( nsortf > 0 ) then
        fac = quatre_pi / pdsort
        do ib = 1,nsortf
          poidso(ib) = fac * rvol( isrt(ib) )
        end do
      endif

      if( mpirank == 0 ) then
        open(iscratch, status='SCRATCH')
        do ia = 1,natome
          write(iscratch,*) nbordf(ia), nbord(ia)
          if( nbord(ia) > 0 ) then
            write(iscratch,*) ibord(1:nbord(ia),ia)
            write(iscratch,*) isbord(1:nbord(ia),ia)
          endif
          if( nbordf(ia) > 0 ) write(iscratch,*) poidsa(1:nbordf(ia),ia)
        end do
        write(iscratch,*) nsortf, nsort
        if( nsort > 0 ) write(iscratch,*) isrt(1:nsort)
        if( nsortf > 0 ) write(iscratch,*) poidso(1:nsortf)
      endif

      if( icheck(9) > 0 ) then
        write(3,120)
        if( .not. green ) then
          do ia = 1,natome
            write(3,130) ia, nbordf(ia), nbord(ia)
            if( nbordf(ia) > 0 .and. icheck(9) > 1 ) then
              write(3,140)
              do ib = 1,nbordf(ia)
                write(3,150) ibord(ib,ia), isbord(ib,ia), poidsa(ib,ia)
              end do
            endif
            if( nbord(ia) > nbordf(ia) .and. icheck(9) > 1) then
              do ib = nbordf(ia)+1,nbord(ia)
                write(3,150) ibord(ib,ia), isbord(ib,ia)
              end do
            endif
          end do
        endif
        write(3,160) nsortf, nsort
        if( nsortf > 0 .and. icheck(9) > 1 ) then
          write(3,165)
          write(3,170) (isrt(ib), poidso(ib), ib = 1,nsortf)
          if( nsort > nsortf ) write(3,180)
     &                          (isrt(ib), ib = nsortf+1,nsort)
        endif
      endif

      deallocate( ibord )
      deallocate( isbord )
      deallocate( isrt )
      deallocate( poidsa )
      deallocate( poidso )

      return
  110 format(//' Erreur dans bordure pour i, ia, iv =',3i6/)
  120 format(/' ---- Bordure ------',100('-')/)
  130 format('     Atome',i3,', nbordf =',i5,', nbord =',i5)
  140 format('  ibord  isbord   poidsa')
  150 format(2i6,f12.5)
  160 format(' Outer sphere, nsortf =',i5,', nsort =',i5)
  165 format('   isrt  poidso')
  170 format(10(i6,f10.5))
  180 format(10(i6,10x))
      end


!***********************************************************************

      subroutine recup_bordure(ibord,isbord,iscratch,isrt,
     &      mpinodes,mpirank,natome,nbord,nbordf,nbm,nbtm,nsm,
     &      nsort,nsortf,nstm,poidsa,poidso)

      use declarations
      implicit real(kind=db) (a-h,o-z)
      include 'mpif.h'

      integer, dimension(nstm):: isrt
      integer, dimension(natome):: nbord, nbordf
      integer, dimension(nbtm,natome):: ibord, isbord

      real(kind=db), dimension(nsm):: poidso
      real(kind=db), dimension(nbm,natome):: poidsa

      if( mpirank == 0 ) then
        rewind(iscratch)
        do ia = 1,natome
          read(iscratch,*) nbordf(ia), nbord(ia)
          if( nbord(ia) > 0 ) then
            read(iscratch,*) ibord(1:nbord(ia),ia)
            read(iscratch,*) isbord(1:nbord(ia),ia)
          endif
          if( nbordf(ia) > 0 ) read(iscratch,*) poidsa(1:nbordf(ia),ia)
        end do
        read(iscratch,*) nsortf, nsort
        if( nsort > 0 ) read(iscratch,*) isrt(1:nsort)
        if( nsortf > 0 ) read(iscratch,*) poidso(1:nsortf)
        Close(iscratch)
      endif
      if( mpinodes > 1 ) then
        ndim = nbtm * natome
        call MPI_BARRIER(MPI_COMM_WORLD,mpierr)
        call MPI_Bcast(nbordf,natome,MPI_INTEGER,0,MPI_COMM_WORLD,
     &                 mpierr)
        call MPI_Bcast(nbord,natome,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
        call MPI_Bcast(ibord,ndim,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
        call MPI_Bcast(isbord,ndim,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
        call MPI_Bcast(poidsa,nbm*natome,MPI_REAL8,0,MPI_COMM_WORLD,
     &                 mpierr)
        call MPI_Bcast(nsortf,1,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
        call MPI_Bcast(nsort,1,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
        call MPI_Bcast(isrt,nstm,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
        call MPI_Bcast(poidso,nsm,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
      endif

      return
      end

!***********************************************************************

      subroutine enrgseuil(epsii,flapw,it0,itabs,itexc,mpirank,nrato,
     &          nrm,ntype,psii,rato,v_abs_i)
    
      use declarations
      implicit real(kind=db) (a-h,o-z)

      logical flapw

      integer, dimension(it0:ntype):: nrato

      real(kind=db), dimension(nrm):: psii, psiit
      real(kind=db), dimension(0:nrm):: r, v_abs_i, pot 
      real(kind=db), dimension(0:nrm,it0:ntype):: rato

      common/eseuil/ eseuil(2)
      common/icheck/ icheck(24)
      common/lseuil/ jseuil, lseuil, nseuil

      it = itexc

      if( .not. flapw ) then
        psiit(:) = psii(:)
      else
! Interpolation pour avoir la fct d'onde initiale de coeur dans les
! rayons de l'atome substitue
        psiit(:) = 0._db
        do ir = 1,nrato(it)
          do irt = 2,nrato(itabs)
            if( rato(irt,itabs) > rato(ir,it) ) goto 1010
          end do
          exit
 1010     p1 = ( rato(ir,it) -  rato(irt-1,itabs) )
     &       / ( rato(irt,itabs) - rato(irt-1,itabs) )
          p2 = 1 - p1
          psiit(ir) = p1*psii(irt) + p2*psii(irt-1)
        end do
      endif

      r(:) = rato(:,it)
      l2 = lseuil**2 + lseuil
      pot(1:nrm) = v_abs_i(1:nrm) + l2 / rato(1:nrm,it)**2

      epsii = - psiHpsi(nrato(it),nrm,pot,pp,psiit,r)
  
      if( icheck(13) > 0 ) write(3,110) epsii * rydb, pp
      if( mpirank == 0 ) write(6,120) epsii * rydb

      return
  110 format(/'     Epsii =',f10.3,' eV,  psi*psi =',f7.3)
  120 format(/'     Epsii =',f10.3,' eV')
      end

!***********************************************************************

      function psiHpsi(nr,nrm,pot,pp,psi,r)

      use declarations    
      implicit none

      integer:: ir,nr,nrm

      real(kind=db), dimension(0:nrm):: pot,psi,r
      real(kind=db):: clm,clp,cl0,dr,php,pp
      real(kind=db):: psiHpsi

      php = 0._db
      pp = 0._db
 
      do ir = 2, nr-1
        dr = 0.5_db * ( r(ir+1) - r(ir-1) )
        clm = 1 / ( ( r(ir) - r(ir-1) ) * dr )
        clp = 1 / ( ( r(ir+1) - r(ir) ) * dr )
        cl0 = - clm - clp
 ! Ici psi_coeur est deja multipliee par r * sqrt(4*pi)
        if( ir == 1 ) then           
          php = php + psi(ir) * (                             
     &        - clp * psi(ir+1) + (- cl0 + pot(ir) ) * psi(ir) ) * dr
        else
          php = php + psi(ir) * (  - clm * psi(ir-1)                           
     &        - clp * psi(ir+1) + (- cl0 + pot(ir) ) * psi(ir) ) * dr
        end if
        pp = pp + ( psi(ir)**2 ) * dr
      end do

      psiHpsi =  php / pp  ! les valeus sont negatives

      end

!***********************************************************************

! Calcul des (l,m) de chaque representation

      subroutine lmrep(green,iaprotoi,iato,iopsym_atom,ipr0,iso,lato,
     &           lmaxat,lmaxso,lso,mato,mpirank,mso,n_atom_proto,
     &           natome,nbordf,ngrph,nlmsa0,nlmsam,nlmso0,
     &           nso1,nsortf,nspino,posi,rot_atom)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db), dimension(nopsm):: kopsymo
      complex(kind=db), dimension(nopsm,nrepm):: karact

      integer, dimension(natome):: iaprotoi 
      integer, dimension(ngrph):: nlmso0
      integer, dimension(ipr0:n_atom_proto):: lmaxat
      integer, dimension(nopsm):: iopsyma, irotiops
      integer, dimension(nopsm,natome):: iopsym_atom
      integer, dimension(natome,ngrph):: nlmsa0
      integer, dimension(natome):: nbordf
      integer, dimension(nso1,ngrph):: iso, lso, mso
      integer, dimension(nlmsam,natome,ngrph):: iato, lato, mato

      logical green

      real(kind=db), dimension(3):: p
      real(kind=db), dimension(3,natome):: posi
      real(kind=db), dimension(3,3):: rot_a
      real(kind=db), dimension(3,3,natome):: rot_atom

      common/icheck/ icheck(24)
      common/iopsymr/ iopsymr(nopsm)
      common/irep_util/ irep_util(nrepm,2)
      common/karact/ karact
      common/orthmat/ orthmat(3,3), orthmati(3,3)

      if( icheck(15) > 1 ) write(3,110)

      nlmso0(:) = 0
      nlmsa0(:,:) = 0

      do ia = 0,natome

        if( ia == 0 ) then

          if( green ) cycle
          lmax = lmaxso
          iopsyma(:) = iopsymr(:)
          do is = 1,nopsm
            irotiops(is) = is
          end do

        else

          ipr = iaprotoi(ia)
          lmax = lmaxat(ipr)
          if( icheck(15) > 1 .or. (ia == 1 .and. icheck(15) == 2) ) then
            do k = 1,3
              p(k) = sum( orthmati(k,1:3) * posi(1:3,ia) )
            end do
            write(3,130) ia, p(1:3)
          endif
          p(1:3) = posi(1:3,ia)
          iopsyma(:) = iopsym_atom(:,ia)
          rot_a(:,:) = rot_atom(:,:,ia)
          call iop_rot(irotiops,rot_a)
        endif

        do l = 0,lmax
          do m = -l,l
            do ispin = 1,nspino

              call symorb(l,m,kopsymo)

! Recherche de la representation a laquelle appartient l'orbitale
              boucle_irep: do igrph = 1,ngrph
                irep = abs( irep_util(igrph,ispin) )
                if( irep == 0 ) cycle
                do is = 1,nopsm
                  js = irotiops(is)
                  if( js == 0 ) cycle
                  if( iopsymr(is) == 0 .or. iopsyma(js) == 0 ) cycle
                  if( irep_util(igrph,ispin) > 0 ) then
                    if( abs( karact(is,irep) - kopsymo(js) ) > eps10 ) 
     &                cycle boucle_irep
                  else
                    if( abs( conjg(karact(is,irep)) - kopsymo(js) )  
     &                          > eps10 ) cycle boucle_irep
                  endif
                end do

                if( ia == 0 ) then
                  nlmso0(igrph) = nlmso0(igrph) + 1
                  iso( nlmso0(igrph), igrph ) = ispin
                  lso( nlmso0(igrph), igrph ) = l
                  mso( nlmso0(igrph), igrph ) = m
                else
                  nlmsa0(ia,igrph) = nlmsa0(ia,igrph) + 1
                  iato( nlmsa0(ia,igrph), ia, igrph ) = ispin
                  lato( nlmsa0(ia,igrph), ia, igrph ) = l
                  mato( nlmsa0(ia,igrph), ia, igrph ) = m
                endif

              end do boucle_irep

            end do
          end do
        end do

        if( icheck(15) > 1 ) then

          if( ia == 0 ) then

            do igrph = 1,ngrph
              write(3,170) lmax, nlmso0(igrph), igrph
              write(3,180)
              write(3,190) (lm, lso(lm,igrph), mso(lm,igrph),
     &                      iso(lm,igrph), lm = 1,nlmso0(igrph))
            end do

          else

            do igrph = 1,ngrph
              write(3,175) ia, lmax, nlmsa0(ia,igrph), igrph
              write(3,180)
              write(3,190) (lm, lato(lm,ia,igrph), mato(lm,ia,igrph),
     &                   iato(lm,ia,igrph), lm = 1,nlmsa0(ia,igrph))
            end do

          endif

        endif

      end do

      if( .not. green ) then

        istop = 0
        do igrph = 1,ngrph

          nsp = nspino * nsortf 
          if( nlmso0(igrph) > nsp .and. mpirank == 0 ) then
            if( istop == 0 ) call write_error
            do ipr = 3,9,3
              write(ipr,200) nlmso0(igrph), nsp
            end do
            istop = 1
          endif

          do ia = 1,natome
            nsp = nspino * nbordf(ia) 
            if( nlmsa0(ia,igrph) > nsp .and. mpirank == 0 ) then
              if( istop == 0 ) call write_error
              do ipr = 3,9,3
                write(ipr,210) ia, nlmsa0(ia,igrph), nsp
              end do
              istop = 1
            endif
          end do

        end do

        if( istop == 1 ) stop

      endif

      return
  110 format(/' ---- lmrep --------',100('-'))
  130 format(/' Atome ia =',i3,', position =',3f7.3)
  170 format(/' lmax =',i3,', nlm =',i3,', igrph =',i2)
  175 format(/'  ia = ',i3,', lmax =',i3,', nlm =',i3,', igrph =',i2)
  180 format(/'   lm    l    m    is')
  190 format(4i5)
  200 format(///'   nlmso0 =',i4,' > nspino*nsortf =',i4,
     &//' Solution :',/'  Diminish the maximum energy or ',/
     &  '  Diminish the outersphere lmax using the lmaxso keyword or',/
     &  '  Diminish the interpoint distance using the keyword adimp'//)
  210 format(///'   nlmsa0(ia=',i2,') =',i4,' > nspino*nbordf =',i4,
     &//' Solution :',/'  Diminish the maximum energy or ',/
     &  '  Diminish the atomic lmax using the lmax keyword or',/
     &  '  Diminish the interpoint distance using the keyword adimp'//)
      end

!***********************************************************************

! Reduction de la symetrie compte tenu de la position de l'atome
! Rotation de la base locale tel que Oz inchange et Ox direction
! radiale.

      subroutine iop_rot(irotiops,rot_atom)

      use declarations
      implicit real(kind=db) (a-h,o-z)
 
      integer, dimension(nopsm):: irotiops

      real(kind=db), dimension(3,3):: matopsym, rot_atom, rot_tem

      common/icheck/ icheck(24)

      irotiops(:) = 0

      do is = 1,nopsm
        call opsym(is,matopsym)
        rot_tem = matmul( transpose(rot_atom), 
     &                    matmul( matopsym, rot_atom ) )
        do js = 1,nopsm 
          call opsym(js,matopsym)
          if( sum( abs( matopsym(:,:) - rot_tem(:,:) ) ) > eps6 ) cycle
          irotiops(js) = is
          exit 
        end do
      end do

      if( icheck(15) > 1 ) write(3,110) irotiops(:)
 
      return
  110 format(/' irotiops =',/ 4(1x,5i3) )
      end

!***********************************************************************

! Calcul du nombre d'harmoniques pour l'energie courante.

      subroutine clmax(energ,r,lmax0,lmax,Z,lmaxfree)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer Z

      logical lmaxfree

      if( energ > 0._db .and. r > eps10 ) then
        rk = sqrt( energ ) * r
      else
        rk = 0._db 
      endif
      rk2 = rk**2
      if( lmax0 < 0 ) then
        lmax = int( 0.5_db + 0.5_db * sqrt(1 + 4*rk2) ) - lmax0
      else
        lmax = lmax0
        return
      endif
      if( rk < 1._db ) then
        lmax = min(6,lmax)
      elseif( rk < 1.7_db ) then
        lmax = min( nint(4.30*rk+0.30),lmax )
      else
        lmax = min( nint(3.04*rk+3.83),lmax )
      endif
      if( Z == 1 ) then
        lmax = 2
      elseif( Z > 54 ) then
        lmax = max( 3,lmax )
      else
        lmax = max( 2,lmax )
      endif

      if( .not. lmaxfree ) then
        if( Z < 3 ) then
          lmax = min(lmax,3)
        elseif( Z < 19 ) then
          lmax = min(lmax,4)
        elseif( Z < 37 ) then
          lmax = min(lmax,5)
        elseif( Z < 55 ) then
          lmax = min(lmax,6)
        elseif( Z < 87 ) then
          lmax = min(lmax,7)
        else
          lmax = min(lmax,db)
        endif
      endif

      return
      end

!***********************************************************************

! Calcul des Ylm et des distances au centre de l'atome de chaque point.

      subroutine ylmpt(iaprotoi,ibord,ipr0,isrt,lmaxat,lmaxso,
     &             n_atom_proto,natome,nbord,nbtm,nlmmax,nlmomax,
     &             nsort,nstm,npsom,posi,rot_atom,rot_atom_abs,xyz,
     &             ylmato,ylmso)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db), dimension(:), allocatable :: ylmc

      integer, dimension(ipr0:n_atom_proto):: lmaxat
      integer, dimension(nstm):: isrt
      integer, dimension(natome):: iaprotoi, nbord
      integer, dimension(nbtm,natome):: ibord

      real(kind=db), dimension(nbtm,nlmmax,natome):: ylmato
      real(kind=db), dimension(nsort,nlmomax):: ylmso
      real(kind=db), dimension(3):: p, v, w
      real(kind=db), dimension(3,3):: rot_a, rot_atom_abs
      real(kind=db), dimension(3,3,natome):: rot_atom
      real(kind=db), dimension(3,natome):: posi
      real(kind=db), dimension(4,npsom):: xyz
      real(kind=db), dimension(:), allocatable :: ylmr

      common/icheck/ icheck(24)
      common/orthmat/ orthmat(3,3), orthmati(3,3)

      if( icheck(15) > 1 ) write(3,110)

      do ia = 0,natome

        if( ia > 0 ) then
          ipr = iaprotoi(ia)
          lmax = lmaxat(ipr)
          np = nbord(ia) 
          p(1:3) = posi(1:3,ia)
! Changement de base :
          rot_a(:,:) = rot_atom(:,:,ia)
        else
          p(:) = 0._db
          lmax = lmaxso
          np = nsort 
          rot_a(:,:) = rot_atom_abs(:,:)
        endif
        nlmr = ( lmax + 1 )**2
        nlmc = ( ( lmax + 1 ) * ( lmax + 2 ) ) / 2
        allocate( ylmc(nlmc) )
        allocate( ylmr(nlmr) )
        
        do ib = 1,np
          if( ia == 0 ) then
            i = isrt(ib)
          else
            i = ibord(ib,ia)
          endif
          w(1:3) = xyz(1:3,i)
          call posrel(w,p,v,r,isym)
          w = matmul( rot_a, v )
          call cylm(lmax,w,r,ylmc,nlmc)
! Conversion en Ylm reels
          call ylmcr(lmax,nlmc,nlmr,ylmc,ylmr)
          if( ia == 0 ) then
            ylmso(ib,1:nlmr) = ylmr(1:nlmr)
          else
            ylmato(ib,1:nlmr,ia) = ylmr(1:nlmr)
          endif
        end do

        if( icheck(15) > 2 ) then
          write(3,120) ia
          lm = 0
          do l = 0,lmax
            do m = -l,l
              write(3,130) l, m
              lm = lm + 1
              if( ia == 0 ) then
                write(3,140) ylmso(1:np,lm)
              else
                write(3,140) ylmato(1:np,lm,ia)
              endif
            end do
          end do
        endif

        deallocate( ylmc )
        deallocate( ylmr )

      end do

      return
  110 format(/' ---- Ylmpt --------',100('-'))
  120 format(/'    Ylm,  Atom',i3)
  130 format(/' l, m =',2i3)
  140 format(1p,8f10.3)
      end

!***********************************************************************

! Calcul des Ylm complexes

      subroutine cylm(lmax,v,r,ylmc,nlm)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db):: ylmc(nlm), exphi, sint_exphi

      real(kind=db), dimension(3):: v

      if( r > eps6 ) then
        cost = v(3) / r
      else
        cost = 1._db
      endif

      den = sqrt( v(1)**2 + v(2)**2 )
      if( den > eps6 ) then
        exphi = cmplx( v(1), v(2), db ) / den
        sint = sqrt( 1 - cost**2 )
        sint_exphi = cmplx( v(1), v(2), db ) / r
        cott = cost / sint
      else
        exphi = (1._db,0._db)
        sint = 0._db
        sint_exphi = (0._db,0._db)
      endif

! Calcul de Y(0,0) :
      ylmc(1) = 1 / sqrt( quatre_pi )

! Calcul des Y(l,l) :
      do l = 1,lmax
        lm = ((l+1)*(l+2)) / 2
        lm1 = (l*(l+1)) / 2
        f = - sqrt(1 + 0.5_db/l)
        ylmc(lm) = f * sint_exphi * ylmc(lm1)
      end do

! Calcul de Y(1,0) :
      if( lmax > 0 ) ylmc(2) = sqrt( 3 / quatre_pi ) * cost

! Calcul des Y(l,l-1) :
      do l = 2,lmax
        lm = ( ( l + 1 ) * ( l + 2 ) ) / 2 - 1
        lm1 = ( l**2 + l ) / 2 - 1
        f = - sqrt( (2*l + 1._db) / (2*l - 2) )
        ylmc(lm) = f * sint_exphi * ylmc(lm1)
      end do

! Calcul des Y(l,m) :
      exphi = conjg( exphi )

      do l = 2,lmax
        lm0 = ( l**2 + l ) / 2
        do m = l-2,1,-1
          lm = lm0 + m + 1
          f = - 2 * (m + 1._db) / sqrt( l*(l+1._db) - m*(m+1._db) )
          g = - sqrt( ( l*(l+1._db) - (m+1._db)*(m+2._db) )
     &              / ( l*(l+1._db) - m*(m+1._db) ) )
          if( abs(sint) > eps10 ) then
            ylmc(lm) = exphi*( cott*f*ylmc(lm+1) + exphi*g*ylmc(lm+2) )
          else
            ylmc(lm) = (0._db,0._db)
          endif
        end do
      end do

! Calcul des Y(l,0) :
      do l = 2,lmax
        lm = ( l * (l+1) ) / 2 + 1
        lm1 = ( (l-1)*l ) / 2 + 1
        lm2 = ( (l-2)*(l-1) ) / 2 + 1
        f = sqrt( (2*l + 1._db) / (2*l - 1._db) ) * (2*l - 1._db) / l
        g = - sqrt( (2*l + 1._db) / (2*l - 3._db) ) * (l - 1._db) / l
        ylmc(lm) = f * cost * ylmc(lm1) + g * ylmc(lm2)
      end do

      return
      end

!***********************************************************************

! Conversion des Ylm complexes en Ylm reels.

      subroutine ylmcr(lmax,nlmc,nlmr,ylmc,ylmr)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db), dimension(nlmc):: ylmc
      real(kind=db), dimension(nlmr):: ylmr

      rac_2 = sqrt(2._db)

      lm = 0
      do l = 0,lmax

        l2 = ( l**2 + l ) / 2 + 1

        do m = -l,l

          lm = lm + 1
          lm0 = l2 + abs(m)

          if( m < 0 ) then
            ylmr(lm) = rac_2 * aimag( ylmc(lm0) )
          elseif( m == 0 ) then
            ylmr(lm) = real( ylmc(lm0), db )
          else
            ylmr(lm) = rac_2 * real( ylmc(lm0), db )
          endif

        end do
      end do

      return
      end

!***********************************************************************

! Selection des harmoniques spheriques compte tenu des symetries

      subroutine ylmsym(iopsym,lmax,lv,mpirank,mv,nlms,nlmtot)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer iops(nopsm), iopsym(nopsm), lv(nlms), mv(nlms)
      logical imparite, parite, parrot, parsym

      iops(:) = abs( iopsym(:) )

      lm = 0

      do l = 0,lmax
        do m = -l,l

! Centrosymetrie
          if( iops(25) == 1 ) then
            parsym = iopsym(25) == 1
            parite = mod(l+2*abs(m),2) == 0
            if( (parsym .and. .not. parite) .or.
     &          (.not. parsym .and. parite)  ) cycle
          endif

! Plan Ox
          if( iops(40) == 1 ) then
            parsym = iopsym(40) == 1
            m2 = mod(abs(m),2)
            parite = (m >= 0 .and. m2 == 0) .or. (m < 0 .and. m2 == 1)
            if( (parsym .and. .not. parite) .or.
     &          (.not. parsym .and. parite)  ) cycle
          endif

! Plan Oy
          if( iops(41) == 1 ) then
            parsym = iopsym(41) == 1
            parite = m >= 0
            if( (parsym .and. .not. parite) .or.
     &          (.not. parsym .and. parite)  ) cycle
          endif

! Plan Oz
          if( iops(42) == 1 ) then
            parsym = iopsym(42) == 1
            parite = mod(l+abs(m),2) == 0
            if( (parsym .and. .not. parite) .or.
     &          (.not. parsym .and. parite)  ) cycle
          endif

! Plan diagonal 0z
          if( iops(44) == 1 .or. iops(45) == 1 ) then
            parsym = ( iopsym(44) == 1 .or. iopsym(45) == 1 )
            m4 = mod(abs(m),4)
            parite = (m4 == 0 .and. m >= 0) .or. (m4 == 2 .and. m < 0)
            imparite = (m4 == 2 .and. m >= 0) .or. (m4 == 0 .and. m < 0)
            if( ( (parsym .and. .not. parite) .or.
     &          (.not. parsym .and. .not. imparite) )
     &           .and. .not. ( (m4 == 1 .or. m4 == 3) .and.
     &                (m > 0) .and. iops(18) /= 1 ) ) cycle
          endif

! Axes de rotation selon Oz
          if( iops(51) == 1 ) then
            irot = 6
            parsym = iopsym(51) == 1
          elseif( iops(55) == 1 ) then
            irot = 6
            parsym = iopsym(55) == 1
          elseif( iops(18) == 1 ) then
            irot = 4
            parsym = iopsym(18) == 1
          elseif( iops(28) == 1 ) then
            irot = 4
            parsym = iopsym(28) == 1
          elseif( iops(49) == 1 ) then
            irot = 3
            parsym = iopsym(49) == 1
          elseif( iops(53) == 1 ) then
            irot = 3
            parsym = iopsym(53) == 1
          elseif( iops(24) == 1 ) then
            irot = 2
            parsym = iopsym(24) == 1
          else
            irot = 1
          endif

          if( irot > 1) then
            mr = mod(abs(m),irot)
            ml = mod(l+abs(m),2)
            parrot = mod(irot,2) == 0
            if( abs(iopsym(28)) == 1 .and. iopsym(18) == 0 ) then
              parite = ( mr == 0 .and. ml == 0 ) .or.
     &                 ( mr == 2 .and. ml == 1 )
              imparite = ( mr == 2 .and. ml == 0 ).or.
     &                   ( mr == 0 .and. ml == 1 )
            else
              parite = mr == 0
              imparite = parrot .and. mr == irot/2
            endif
            if( (parsym .and. .not. parite) .or.
     &          (.not. parsym .and. .not. imparite)  ) cycle
          endif

! Axe 2 selon 0x
          if( iops(22) == 1 ) then
            parsym = iopsym(22) > 0
            parite = (m >= 0 .and. mod(l+m,2) == 0) .or.
     &               (m < 0 .and. mod(l-m,2) == 1)
            if( (parsym .and. .not. parite) .or.
     &          (.not. parsym .and. parite)  ) cycle
          endif

! Axe 2 selon 0y
          if( iops(23) == 1 ) then
            parsym = iopsym(23) > 0
            parite = (m >= 0 .and. mod(l+2*m,2) == 0) .or.
     &               (m < 0 .and. mod(l-2*m,2) == 1)
            if( (parsym .and. .not. parite) .or.
     &          (.not. parsym .and. parite)  ) cycle
          endif

! Axes 4 selon 0x ou 0y
          if( mpirank == 0 .and. ( iops(16) == 1 .or. iops(17) == 1
     &   .or. iops(26) == 1 .or. iops(27) == 1 ) ) then
            call write_error
            do ipr = 3,9,3
              write(ipr,110)
            end do
            stop
          endif

          lm = lm + 1
          if( lm > nlms .and. mpirank == 0 ) then
            call write_error
            do ipr = 3,9,3
              write(ipr,120) lm, nlms
            end do
            stop
          endif
          lv(lm) = l
          mv(lm) = m

        end do
      end do

      nlmtot = lm

      return
  110 format(/' Les axes 4 selon Ox et Oy ne sont pas programmes !')
  120 format(/' lm =',i4,' > nlms =',i4)
      end

!*********************************************************************

! Calcul des fonctions d'onde emergeantes en sortie.

      subroutine phiso(bessel,ecinetic,eclie,eimag,
     &             eneg,energ,enervide,etatlie,isp,isrt,lmaxso,mpirank,
     &             nbn1,nbn2,nbn3,neuman,npsom,nsort,nstm,
     &             rydberg,rsort,vmoy,xyz)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      parameter( nptrm = 2000 )

      complex(kind=db) bs(0:lmaxso), fnormc, konde, nm(0:lmaxso), z
      complex(kind=db), dimension(nbn1,0:nbn2,nbn3):: bessel, neuman
      complex(kind=db), dimension(:), allocatable:: f12
      complex(kind=db), dimension(:,:), allocatable:: rbs, rnm, u

      integer, dimension(nstm):: isrt
      logical calcomp, eneg, etatlie, rydberg

      real(kind=db) bsr(0:lmaxso), konder, p(3), nmr(0:lmaxso)
!ecpx   complex(kind=db)
      real(kind=db), dimension(4,npsom):: xyz
      real(kind=db), dimension(:), allocatable:: f1, f2, f12r, r, v
      real(kind=db), dimension(:,:), allocatable:: rbsr, rnmr, ur

      common/ad/ ad
      common/icheck/ icheck(24)
      common/rrydb/ rrydb

      if( icheck(17) > 1 .and. isp == 1 ) write(3,110) energ * rydb,
     &                                                 lmaxso

      if( abs( eimag ) > eps10 .or. ecinetic < eps10 ) then
        calcomp = .true.
      else
        calcomp = .false.
      endif

      if( calcomp ) then
        konde = sqrt( cmplx( ecinetic, eimag, db ) )
        if( abs( konde ) < eps10 ) konde = cmplx( eps10, 0._db, db ) 
        konder = real( konde, db )
        fnorm = cal_norm(ecinetic,eimag)
        fnormc = cmplx( fnorm, 0._db, db)
      else
        konder = sqrt( ecinetic )
        konde = cmplx( konder, 0._db, db )
        if( konder < eps10 .and. mpirank == 0 ) then
          call write_error
          do ipr = 3,9,3
            write(ipr,120)
          end do
          stop
        endif
        fnorm = sqrt( konder / pi )
        fnormc = sqrt( konde / pi )
      endif

      if( rydberg ) then

        if( abs( enervide ) < eps10 ) then
          ee = eps10
        else
          ee = enervide
        endif
        if( ee < eps10 ) then
          rmax = - 2 / ee + rrydb
        else
          rmax = 100. / bohr
        endif
        if( rmax < rsort ) goto 1010
        deltar = rmax - rsort + ad + eps10
        dr = 0.05 / bohr
        nr = nint( deltar / dr ) + 1

        allocate( r(0:nr) )
        allocate( v(0:nr) )
        allocate( f1(0:nr) )
        allocate( f2(0:nr) )

        dr = deltar / ( nr - 1 )
        do ir = nr,0,-1
          r(ir) = rmax - ( ir - 1 ) * dr
        end do
        v(0:nr) = - 2 / r(0:nr)
        do ir = nr,0,-1
          v(ir) = max( v(ir), vmoy ) 
        end do

! Pour eviter la discontinuite
        if( ee >= eps10 ) then
          pp = - v(0) / ( r(0) - r(nr) ) 
          do ir = 0,nr
            v(ir) = v(ir) + ( r(ir) - r(nr) ) * pp 
          end do
        endif

        if( calcomp ) then
          allocate( f12(0:nr) )
          allocate( u(-1:nr,2) )
          allocate( rnm(2,0:lmaxso) )
          allocate( rbs(2,0:lmaxso) )
        else
          allocate( f12r(0:nr) )
          allocate( ur(-1:nr,2) )
          allocate( rnmr(2,0:lmaxso) )
          allocate( rbsr(2,0:lmaxso) )
        endif

        ec = enervide - v(0)
        if( etatlie .and. .not. eneg ) ec = max( ec, eclie )
        if( calcomp ) then
          konde = sqrt( cmplx( ec, eimag, db ) )
          konder = real( konde, db )
        else
          konder = sqrt( ec )
          konde = cmplx( konder, 0._db, db )
        endif
        if( konder < eps10 .and. mpirank == 0 ) then
          call write_error
          do ipr = 3,9,3
            write(ipr,120)
          end do
          stop
        endif
        if( calcomp ) then
          fnorm = cal_norm(ecinetic,eimag)
          fnormc = cmplx( fnorm, 0._db, db)
        else
          fnorm = sqrt( konder / pi )
          fnormc = sqrt( konde / pi )
        endif

        do i = 1,2
          rr = rmax + i * dr
          if( calcomp ) then
            z = konde * rr
            call cbessneu(fnormc,z,lmaxso,lmaxso,bs,nm)
            rnm(i,0:lmaxso) = nm(0:lmaxso) * rr
            rbs(i,0:lmaxso) = bs(0:lmaxso) * rr
          else
            zr = konder * rr
            call cbessneur(fnorm,zr,lmaxso,lmaxso,bsr,nmr)
            rnmr(i,0:lmaxso) = nmr(0:lmaxso) * rr
            rbsr(i,0:lmaxso) = bsr(0:lmaxso) * rr
          endif
        end do

        clapl = 1 / dr**2
        clapl0 = - 2 * clapl
        f2(0:nr) = 1 / r(0:nr)**2
        f1(0:nr) = - clapl0 + v(0:nr) - enervide

        do l = 0,lmaxso
          l2 = l**2 + l

          if( calcomp ) then
            f12(0:nr) = cmplx( f1(0:nr) + l2 * f2(0:nr), -eimag, db )
     &                / clapl
            u(0,1) = rnm(1,l)
            u(-1,1) = rnm(2,l)
            u(0,2) = rbs(1,l)
            u(-1,2) = rbs(2,l)
            do inb = 1,2
              do ir = 0,nr-1
                u(ir+1,inb) = f12(ir) * u(ir,inb) - u(ir-1,inb)
              end do
              u(0:nr,inb) = u(0:nr,inb) / r(0:nr)
            end do
          else
            f12r(0:nr) = ( f1(0:nr) + l2 * f2(0:nr) ) / clapl
            ur(0,1) = rnmr(1,l)
            ur(-1,1) = rnmr(2,l)
            ur(0,2) = rbsr(1,l)
            ur(-1,2) = rbsr(2,l)
            do inb = 1,2
              do ir = 0,nr-1
                ur(ir+1,inb) = f12r(ir) * ur(ir,inb) - ur(ir-1,inb)
              end do
              ur(0:nr,inb) = ur(0:nr,inb) / r(0:nr)
            end do
          endif

          do ib = 1,nsort
            i = isrt(ib)
            p(1:3) = xyz(1:3,i)
            rr = vnorme(p)
            do ir = nr-1,2,-1
              if( r(ir) > rr ) exit
            end do
            p1 = ( rr - r(ir) ) / ( r(ir+1) - r(ir) )
            p2 = 1 - p1

            if( calcomp ) then
              neuman(ib,l,isp) = p1 * u(ir+1,1) + p2 * u(ir,1)
              bessel(ib,l,isp) = p1 * u(ir+1,2) + p2 * u(ir,2)
            else
              rn = p1 * ur(ir+1,1) + p2 * ur(ir,1)
              neuman(ib,l,isp) = cmplx( rn, 0._db, db )
              rn = p1 * ur(ir+1,2) + p2 * ur(ir,2)
              bessel(ib,l,isp) = cmplx( rn, 0._db, db )
            endif

          end do

          if( icheck(17) > 2 ) then
            write(3,126) l
            do ir = nr,0,-1
              if( calcomp ) then
                write(3,127) r(ir)*bohr, v(ir)*rydb, u(ir,1:2)
              else
                write(3,127) r(ir)*bohr, v(ir)*rydb, ur(ir,1:2)
              endif
            end do
          endif

        end do

        deallocate( r )
        deallocate( v )
        deallocate( f1 )
        deallocate( f2 )
        if( calcomp ) then
          deallocate( f12 )
          deallocate( u )
          deallocate( rnm )
          deallocate( rbs )
        else
          deallocate( f12r )
          deallocate( ur )
          deallocate( rnmr )
          deallocate( rbsr )
        endif

        goto 1020
      endif

 1010 continue

! Calcul des fonctions de bessel et neuman.
      do ib = 1,nsort
        i = isrt(ib)
        p(1:3) = xyz(1:3,i)
        if( calcomp ) then
          z = konde * vnorme(p)
          call cbessneu(fnormc,z,lmaxso,lmaxso,bs,nm)
          neuman(ib,0:lmaxso,isp) = nm(0:lmaxso)
          bessel(ib,0:lmaxso,isp) = bs(0:lmaxso)
        else
          zr = konder * vnorme(p)
          call cbessneur(fnorm,zr,lmaxso,lmaxso,bsr,nmr)
          neuman(ib,0:lmaxso,isp) = cmplx( nmr(0:lmaxso), 0._db, db )
          bessel(ib,0:lmaxso,isp) = cmplx( bsr(0:lmaxso), 0._db, db )
        endif
      end do

 1020 continue
      if( icheck(17) > 2 ) then
        do l = 0,lmaxso
          if( calcomp ) then
            write(3,130) l, isp, konde
            do ib = 1,nsort
              i = isrt(ib)
              p(1:3) = xyz(1:3,i)
              rr = vnorme(p) 
              z = konde * rr
              write(3,140) isrt(ib), rr*bohr, bessel(ib,l,isp),
     &                     neuman(ib,l,isp)
            end do
          else
            write(3,150) l, isp, konder
            do ib = 1,nsort
              i = isrt(ib)
              p(1:3) = xyz(1:3,i)
              rr = vnorme(p) 
              zr = konder * rr
              write(3,140) isrt(ib), rr*bohr, real(bessel(ib,l,isp),db),
     &                     real( neuman(ib,l,isp), db )
            end do
          endif
        end do
      endif

      return
  110 format(/' ---- Phiso --------',100('-')//,
     &  20x,' energ =',f10.5,' eV,  lmaxso =',i3)
  120 format(//' The wave vector is zero, what is forbidden !'/)
  126 format(/'    radius      v            bess-coul             ',
     &  'neuman-coul     l =',i3)
  127 format(2f10.3,1p,4e12.4)
  130 format(/' isrt     r',13x,'bessel',18x,'neuman',9x,
     &        'l =',i3,', isp =',i2,', konde =',1p,2e12.4)
  140 format(i5,f8.3,1x,1p,4e12.4)
  150 format(/' isrt     r',7x,'bessel      neuman',5x,
     &         'l =',i3,', isp =',i2,', konder =',1p,e12.4)
      end

!***********************************************************************

! Calcul de la racine de la densite d'etats avec energie complexe.
! Prise comme la convolution par une lorenzienne de la densite d'etats
! du vide.

      function cal_norm(Energ,Eimag)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      real(kind=db):: k

      Eimag2 = Eimag**2
      de_int = Eimag / 20
      Delta_E = 500 * Eimag
      E1 = Energ - Delta_E
      E2 = Energ + Delta_E
      je1 = nint( E1 / de_int )
      je1 = max( 1, je1 )
      je2 = nint( E2 / de_int )
      je2 = max( je2, 10 )

      rint = 0._db

      do je = je1,je2
        e = ( je - 0.5 ) * de_int
        k = sqrt( e )
        fac = de_int / ( ( Energ - e )**2 + Eimag2 ) 
        rho = rho + k * fac
        rint = rint + fac
      end do
      rho = rho * Eimag / pi**2

      rint = rint * Eimag / pi
      if( Energ > 0.0000001_db ) then
        rho_0 = sqrt( Energ ) / pi
      else
        rho_0 = 0._db
      endif

      cal_norm = sqrt( rho )
       
!      write(2,110) Energ*rydb, rho, rho_0, rho_1

!  110 format(4f13.7)
      end

!***********************************************************************

! Calcul des fonctions de bessel et neuman.

      subroutine cbess(fnorm,z,lmax,lmaxm,bessel)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db):: bessel(0:lmaxm), fnorm, z

      if( abs( z ) < eps10 ) then
        bessel(0) = fnorm
      else
        bessel(0) = fnorm * sin(z) / z
      endif

      if( lmax == 0 ) return

      if( abs( z ) < eps10 ) then

        bessel(1:lmax) = (0._db, 0._db)

      else        

        bessel(1) = bessel(0) / z - fnorm * cos(z) / z

        do l = 2,lmax
          l1 = 2*l - 1
          bessel(l) = l1 * bessel(l-1) / z - bessel(l-2)
        end do

      endif

      return
      end
!***********************************************************************

! Calcul des fonctions de bessel et neuman.

      subroutine cbessneu(fnorm,z,lmax,lmaxm,bessel,neuman)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db):: bessel(0:lmaxm), fnorm, neuman(0:lmaxm), z

      neuman(0) = - fnorm * cos(z) / z
      bessel(0) = fnorm * sin(z) / z

      if( lmax == 0 ) return

      neuman(1) = neuman(0) / z - bessel(0)
      bessel(1) = bessel(0) / z + neuman(0)

      do l = 2,lmax
        l1 = 2*l - 1
        neuman(l) = l1 * neuman(l-1) / z - neuman(l-2)
        bessel(l) = l1 * bessel(l-1) / z - bessel(l-2)
      end do

      return
      end

!***********************************************************************

! Calcul des fonctions de bessel et neuman.

      subroutine cbessneur(fnorm,z,lmax,lmaxm,bessel,neuman)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      real(kind=db):: bessel(0:lmaxm), neuman(0:lmaxm), z

      neuman(0) = - fnorm * cos(z) / z
      bessel(0) = fnorm * sin(z) / z

      neuman(1) = neuman(0) / z - bessel(0)
      bessel(1) = bessel(0) / z + neuman(0)

      do l = 2,lmax
        l1 = 2*l - 1
        neuman(l) = l1 * neuman(l-1) / z - neuman(l-2)
        bessel(l) = l1 * bessel(l-1) / z - bessel(l-2)
      end do

      return
      end

!***********************************************************************

! Calcul de l'integrale de 0 a Radius de f. f(0) = 0.
! L'integrale est calcul�e avec un polynome d'interpolation d'ordre deux
! r: contient les valeurs des rayons pour les points qu'on integre
! nr: nombre de points qu'on integre
 
      real(kind=db) function f_integr(r,fct,nr,ir0,nrm,Radius)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      real(kind=db), dimension(ir0:nrm):: fct, r

      tiers = 1._db / 3

      f_integr = 0._db

      do i = 1,nr-1
        r0 = r(i)
        if( i == 1 ) then
          rm = 0._db
          fm = 0._db
          x1 = 0._db
        else
          rm = r(i-1)
          fm = fct(i-1)
          x1 = 0.5_db * ( rm + r0 )
        endif
        rp = r(i+1)
        if( rp > Radius ) then
          x2 = Radius
        else
          f0 = fct(i)
          fp = fct(i+1)
          if( i == nr - 1 ) then
            x2 = rp
          else
            x2 = 0.5_db * ( rp + r0 )
          endif
          if( abs(fp) < 1e-20_db .and. abs(f0) < 1e-20_db
     &                        .and. abs(fm) < 1e-20_db ) cycle
  
          dp0 = rp - r0
          dpm = rp - rm
          d0m = r0 - rm
          a = ( fm * dp0 - f0 * dpm + fp * d0m ) / ( d0m * dp0 * dpm )
          b = ( f0 - fm ) / d0m - a * ( r0 + rm )
          c = f0 - a * r0**2 - b * r0
        endif

        f_integr = f_integr
     &           + ( tiers * a * ( x1**2 + x1 * x2  + x2**2 )
     &             + 0.5_db * b * ( x1 + x2 ) + c ) * ( x2 - x1 )

        if( rp > Radius ) exit

      end do

      return
      end

!***********************************************************************

! Calcul de l'integrale de 0 a Radius de f. f(0) = 0.
! L'integrale est calcul�e avec un polynome d'interpolation d'ordre 3
! r: contient les valeurs des rayons pour les points qu'on integre
! nr: nombre de points qu'on integre
 
      real(kind=db) function f_integr3(r,fct,nr,ir0,nrm,Radius)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      logical This_is_the_end

      real(kind=db), dimension(ir0:nrm):: fct, r

      tiers = 1._db / 3
      This_is_the_end = .false.
      f_integr3 = 0._db

      do i = 1,nr-1
        if( i == 1 ) then
          r1 = 0._db
          f1 = 0._db
          r2 = r(i)
          f2 = fct(i)
          r3 = r(i+1)
          f3 = fct(i+1)
          r4 = r(i+2)
          f4 = fct(i+2)
          rm = 0._db
          rp = r3
        elseif( i == nr-1 ) then
          rm = r(i)
          rp = r(nr)
        else
          r1 = r(i-1)
          f1 = fct(i-1)
          r2 = r(i)
          f2 = fct(i)
          r3 = r(i+1)
          f3 = fct(i+1)
          r4 = r(i+2)
          f4 = fct(i+2)
          rm = r2
          rp = r3
        endif
        if( rp > Radius ) then
          rp = Radius
          This_is_the_end = .true.
        endif
        if( abs(f2) < 1e-20_db .and. abs(f3) < 1e-20_db ) cycle
  
        rap14 = (f1 - f4) / (r1 - r4) 
        rap24 = (f2 - f4) / (r2 - r4) 
        rap34 = (f3 - f4) / (r3 - r4) 
        fac1 = ( rap14 - rap34 ) / (r1 - r3)
        fac2 = ( rap24 - rap34 ) / (r2 - r3)
        a = ( fac1 - fac2 ) / ( r1 - r2 )
        b = fac1 - a * ( r1 + r3 + r4 )
        c = rap14 - a * ( r1**2 + r1 * r4 + r4**2 )
     &    - b * ( r1 + r4 )
        d = f1 - ( a * r1**2 + b * r1 + c ) * r1

        f_integr3 = f_integr3
     &           + ( 0.25_db * ( rm + rp ) * ( rm**2 + rp**2 ) * a
     &             + tiers * ( rm**2 + rm*rp + rp**2 ) * b
     &             + 0.5_db * ( rm + rp ) * c + d ) * ( rp - rm )

        if( This_is_the_end ) exit

      end do

      return
      end

!***********************************************************************

      real(kind=db) function finterp2(um,u0,up,rm,r0,rp,r)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      rp0 = rp - r0
      rpm = rp - rm
      r0m = r0 - rm

      a = ( um * rp0 - u0 * rpm + up * r0m ) / ( r0m * rp0 * rpm )
      b = ( u0 - um ) / r0m - a * ( r0 + rm )
      c = u0 - a * r0**2 - b * r0

      finterp2 = a * r**2 + b * r + c

      return
      end
!***********************************************************************

      subroutine cnlmmax(lmax,lv,nlmam,nlm)

      integer lv(nlmam)

      do lm = nlmam,1,-1
        if( lv(lm) <= lmax ) exit
      end do
      nlm = lm

      return
      end

!****************************************************************************************************
! Sousroutine qui evalue si le calcul en parallele, compte tenu du
! nombre de processeurs utilises, est plus rapide que son homologue
! sequentiel

! Contexte: ce que l'on gagne par la parallelisation de la boucle sur les energie (chaque
!           processeur resout un point en energie) on risque de perdre a cause du temps
!           necessaire a l'echange des messages entre les processeurs 

! Evaluation crue: parallelisation de la boucle <=> gain d'un facteur N
!                  communication <=> perte d'un facteur exp(N)
!                  ou N = nombre de processeurs 

      subroutine timeopt(je,mpinodes,nenerg,nge,time_en,time_comm,
     &                   timetip,tpps)

      use declarations
      implicit none
      integer i, ie, ie0, je, mpinodes, nge, nenerg
      logical timetip
      real(kind=db) tpseq, tppar, tpps
      real(kind=db), dimension(nenerg,0:mpinodes-1)::time_en
      real(kind=db), dimension(nge)::time_comm


      tpseq = 0._db; tppar = 0._db

! Si sequentiel (l'ordinateur central a deja collecte tous les temps):

      ie0 = ( je - 1 ) * mpinodes
      tpseq = sum( time_en( (ie0+1):(ie0+mpinodes),0) )

! Si paralel: (remarque: le temps du calcul depend de l'energie de travail
!                         moi j utilise la moyenne)

      tppar = tpseq / mpinodes + time_comm(je) 
      write(6,*) tppar, tpseq
      if( tppar < tpseq ) then
        tpps = tpps + tpseq - tppar
        if( je == nge .and. timetip ) then
          write(3,100)
          write(3,250) tpps
         end if  
         return
      else if( je == 1 ) then
         write(3,100)
         do i = 3, 6, 3
            write(i,*) 'Paralel computation is inefficient from the',
     &               ' very first energy. Decrease the number of CPU !'
         end do
         timetip = .false.
         return
      else
         write(3,100)
         ie = ( je - 1 ) * mpinodes + 1
         do i = 3, 6, 3
           write(i,150) ie
         end do
         timetip = .false.
      end if

      return
  100 format(/' ---- Timeopt ------',100('-'))
  150 format(/'Paralel computation has become inefficient at the ',i5,
     &      'th point in energy. You should consider decreasing ',
     &      ' the number of CPUs')
  250 format(/'Paralel computing saved you ',f10.1,' seconds as ',
     &      'compared to the sequential calculation')            
      end
