! Fdmnes subroutine
! Calculation of the atomic electronic densities using dirac-slater or
! Hartree-Fock Slater.

      subroutine dirgen(chg_val_ref,it,it0,itabs,lcoeur,lvval,
     &      mpirank,ncoeur,nlat,nlatm,nonexc,nrato,nrato_dirac,nrm,
     &      nspin,ntype,nvval,pop_level_val,popatc,popatv,popexc,
     &      popval,psi_coeur,psii,psi_level_val,psival,
     &      rato,rho_coeur,rhoit,Z)

      use declarations 
      implicit real(kind=db) (a-h,o-z)

      parameter(ndm=600)
      integer, dimension(nnlm):: lqn, nqn
      integer, dimension(2,it0:ntype):: lcoeur, ncoeur
      integer, dimension(it0:ntype):: nlat
      integer, dimension(it0:ntype,nlatm):: lvval, nvval

      logical nonexc, test

      integer Z

      real(kind=db), dimension(nnlm):: nel, pop, rqn
      real(kind=db), dimension(nrm):: psii, psiit, rato 
      real(kind=db), dimension(ndm):: ray, rho 
      real(kind=db), dimension(ndm,nnlm):: psi
      real(kind=db), dimension(it0:ntype):: popatc
      real(kind=db), dimension(it0:ntype,nlatm):: popatv
      real(kind=db), dimension(it0:ntype,nlatm,nspin):: popval
      real(kind=db), dimension(nnlm,nspin):: popexc
      real(kind=db), dimension(0:nrm,it0:ntype):: rhoit, rho_coeur
      real(kind=db), dimension(0:nrm,nlatm,it0:ntype):: psival
      real(kind=db), dimension(0:nrm,it0:ntype):: psi_level_val
      real(kind=db), dimension(it0:ntype):: pop_level_val
      real(kind=db), dimension(0:nrm,2,it0:ntype):: psi_coeur       

      common/icheck/ icheck(24)
      common/lseuil/ jseuil, lseuil, nseuil
      common/noexc/ lqnexc(nnlm), n_orbexc, nqnexc(nnlm)

      if( icheck(2) > 1 ) write(3,110) it, Z

! Pour changer nrato_dirac, c'est dans lectur.
! Il faut alors aussi changer ndm dans dirac et dans lectur
      n_ray = nrato_dirac ! Number of radius in the radial mesh
      ray_max = 20._db   ! Maximum radius (au)
      h_ray = n_ray * 54._db / 600     ! log step

      if( n_ray > nrm .and. mpirank == 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,120) n_ray, nrm
        end do
        stop
      endif
      if( nrm /= ndm .and. mpirank == 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,125) nrm, ndm
        end do
        stop
      endif
      iout = 3

      if( it == itabs ) then
        select case(jseuil)
          case(1,2,4,6)
            mseuil = 1
          case default
            mseuil = 2
        end select
      endif

      if( Z > 36 ) then
        irel = 1
      else
        irel = 0
        rqn(:) = 0._db
      endif
      if( irel == 0 ) mseuil = 1

      call config(Z,irel,n_coeur,n_orb,nqn,lqn,rqn,nel)

      pop(1:n_orb) = nel(1:n_orb)
       
! On remplace les population par defaut par celles qui sont donn�es en entr�e 
      boucle_io: do io = 1,nlat(it)
        popt = sum( popval(it,io,1:nspin) ) 
        do ip = 1,n_orb
          if(nqn(ip) /= nvval(it,io) .or. lqn(ip) /= lvval(it,io)) cycle
          if( irel == 0 .or. lqn(ip) == 0 ) then
            pop(ip) = popt
          else
            pop(ip) = ( lqn(ip) / ( 2*lqn(ip)+1. ) ) * popt
            pop(ip+1) = popt - pop(ip)
          endif
          cycle boucle_io 
        end do
! Si en entr�e on trouve une orbitale qui normalement n'existe pas:     
        n_orb = n_orb + 1
        if( n_orb > nnlm ) then
          call write_error
          do ipr = 3,9,3
            write(ipr,130) 
          end do 
          stop
        endif       
        nqn(n_orb) = nvval(it,io) 
        lqn(n_orb) = lvval(it,io)
        if( lvval(it,io) == 0 ) then
          rqn(n_orb) = 0.5_db
        else  
          rqn(n_orb) = lvval(it,io) - 0.5_db
        endif 
        if( irel == 0 ) then
          pop(n_orb) = popt
        else
          pop(n_orb) = ( lqn(n_orb) / ( 2*lqn(n_orb)+1. ) ) * popt
          if( lqn(n_orb) /= 0 ) then
            n_orb = n_orb + 1            ! si relativiste la nouvelle orbitale trouv�e a un splitting
            if( n_orb > nnlm ) then
              call write_error
              do ipr = 3,9,3
                write(ipr,130) 
              end do 
              stop
            endif       
            nqn(n_orb) = nvval(it,io) 
            lqn(n_orb) = lvval(it,io) 
            rqn(n_orb) = lvval(it,io) + 0.5_db 
            pop(n_orb) = popt - pop(n_orb-1)
          endif
        endif
      end do boucle_io

! construction de l'atome neutre (le calcul des niveaux atomiques se
! fait avec des atomes neutres)
     
      charge = Z - sum( pop(1:n_orb) )
      if( charge > eps6 ) then
        dp = charge
        do io = 1,n_orb
          if( ( nqn(io) <= nseuil .and. it == itabs ) 
     &                                   .or. lqn(io) > 1 ) cycle
          if( irel == 0 .or. lqn(io) == 0 ) then
            elmax = 2 + 4. * lqn(io)
            if( pop(io) > elmax - eps6 ) cycle

            do j = 1,nlat(it)
              if(nqn(io) /= nvval(it,j) .or. lqn(io)/=lvval(it,j)) cycle
              exit
            end do
            if( j == nlat(it)+1 ) then  
              nlat(it) = nlat(it) + 1
              if( nlat(it) > nlatm ) then
                call write_error
                do ipr = 3,9,3
                  write(ipr,140) nlat(it), nlatm
                end do
                stop
              endif
              nvval(it,nlat(it)) = nqn(io)
              lvval(it,nlat(it)) = lqn(io)
              popval(it,nlat(it),1:nspin) = pop(io) / nspin
            endif

            pop(io) = pop(io) + dp
            dp = pop(io) - elmax
            if( dp < eps6 ) exit 
            pop(io) = elmax
          else
            if( lqn(io-1) == lqn(io) ) cycle
            elmax = 2 + 4. * lqn(io)
            if( sum(pop(io:io+1)) > elmax - eps6 ) cycle

            do j = 1,nlat(it)
              if(nqn(io) /= nvval(it,j) .or. lqn(io)/=lvval(it,j)) cycle
              exit
            end do
            if( j == nlat(it)+1 ) then  
              nlat(it) = nlat(it) + 1
              if( nlat(it) > nlatm ) then
                call write_error
                do ipr = 3,9,3
                  write(ipr,140) nlat(it), nlatm
                end do
                stop
              endif
              nvval(it,nlat(it)) = nqn(io)
              lvval(it,nlat(it)) = lqn(io)
              popval(it,nlat(it),1:nspin) = sum(pop(io:io+1)) / nspin
            endif

            p = lqn(ip) / ( 2 * lqn(ip) + 1. ) 
            pop(io) = pop(io) + p * dp
            pop(io+1) = pop(io+1) + ( 1 - p ) * dp
            dp = sum( pop(io:io+1) ) - elmax
            if( dp < eps6 ) exit 
            pop(io) = 2. * lqn(io)
            pop(io+1) = 2 + 2. * lqn(io)
          endif
        end do
        if( dp > eps6 ) then
          nmax = 0
          do io = 1,n_orb
            nmax = max(nqn(io),nmax)
          end do

          if( nmax == 1 ) then
            iaug = 1
          else
            iaug = 0          
            do io = 1,n_orb
              if( nqn(io) == nmax .and. lqn(io) == 1 ) then
                iaug = 1
                exit
              endif
            end do
          endif          
          n_orb = n_orb + 1
          if( n_orb > nnlm ) then
            call write_error
            do ipr = 3,9,3
              write(ipr,130) 
            end do 
            stop
          endif       
          if( iaug == 1 ) then
            nqn(n_orb) = nmax + 1
            lqn(n_orb) = 0
            pop(n_orb) = dp
            if( irel == 1 ) rqn(n_orb) = 0.5 
          else
            nqn(n_orb) = nmax
            lqn(n_orb) = 1
            if( irel == 0 ) then
              pop(n_orb) = dp
            else
              rqn(n_orb) = 0.5
              pop(n_orb) = dp / 3
              n_orb = n_orb + 1
              if( n_orb > nnlm ) then
                call write_error
                do ipr = 3,9,3
                  write(ipr,130) 
                end do 
                stop
              endif       
              nqn(n_orb) = nmax
              lqn(n_orb) = 1
              rqn(n_orb) = 1.5
              pop(n_orb) = 2 * dp / 3
            endif 
          endif
          nlat(it) = nlat(it) + 1
          if( nlat(it) > nlatm ) then
            call write_error
            do ipr = 3,9,3
              write(ipr,140) nlat(it), nlatm
            end do
            stop
          endif
          nvval(it,nlat(it)) = nqn(n_orb)
          lvval(it,nlat(it)) = lqn(n_orb)
          popval(it,nlat(it),1:nspin) = 0._db
        endif

      elseif( charge < - eps6 ) then

        do io = n_orb,1,-1
          dp = charge
          if( ( nqn(io) <= nseuil .and. it == itabs ) 
     &                                       .or. lqn(io) > 1 ) cycle

          do j = 1,nlat(it)
            if(nqn(io) /= nvval(it,j) .or. lqn(io)/=lvval(it,j)) cycle
            exit
          end do
          if( j == nlat(it)+1 ) then  
            nlat(it) = nlat(it) + 1
            if( nlat(it) > nlatm ) then
              call write_error
              do ipr = 3,9,3
                write(ipr,140) nlat(it), nlatm
              end do
              stop
            endif
            nvval(it,nlat(it)) = nqn(io)
            lvval(it,nlat(it)) = lqn(io)
            if( irel == 0 .or. lqn(io) == 0 ) then
              popval(it,nlat(it),1:nspin) = pop(io) / nspin
            else
              popval(it,nlat(it),1:nspin) = sum(pop(io-1:io)) / nspin
            endif
          endif

          if( irel == 0 .or. lqn(io) == 0 ) then
            pop(io) = pop(io) + dp
          else
            pop(io) = pop(io) + 2 * dp / 3
            pop(io-1) = pop(io-1) + dp / 3
          endif
          exit
        end do

      endif

! Remplissage de popatv: ces populations correspondent � l'atome neutre

      if( it /= itabs .or. nonexc ) then
        do io = 1,nlat(it)
          do j = 1,n_orb
            if(nqn(j) /= nvval(it,io) .or. lqn(j) /= lvval(it,io)) cycle
            if( irel == 0 .or. lqn(j) == 0 ) then
              popatv(it,io) = pop(j) 
            else
              popatv(it,io) = pop(j) + pop(j+1) 
            endif
            exit
          end do
        end do
      endif

      if( icheck(2) > 0 .and. it /= 0 ) then
        if( irel == 0 ) then
          write(3,150) it, Z 
          do io = 1,n_orb
            if( Z > 18 .and. nqn(io) < 3 ) cycle 
            if( Z > 36 .and. nqn(io) < 4 ) cycle 
            if( Z > 86 .and. nqn(io) < 5 ) cycle 
            write(3,160) nqn(io), lqn(io), pop(io)
          end do
        else
          write(3,170) it, Z 
          do io = 1,n_orb
            if( Z > 18 .and. nqn(io) < 3 ) cycle 
            if( Z > 36 .and. nqn(io) < 4 ) cycle 
            if( Z > 86 .and. nqn(io) < 5 ) cycle 
            write(3,180) nqn(io), lqn(io), rqn(io), pop(io)
          end do
        endif
      endif
      
! Influence par ce qu'on lui indique en entree, mais
! n�anmoins pop �taient modifiees de ce que l'atome soit neutre      

      call dirac(Z,icheck(2),irel,n_orb,nqn,lqn,rqn,pop,
     &             nrato,ray,rho,psi,iout,n_ray,ray_max,h_ray)


! Recuperation de la fonction d'onde de l'orbitale de valence potentiellement occupee; 
! sert a referencer le niveau de Fermi




! psii: la fonction d'onde pour l'orbitale de d�part
! epsii: l'�nergie de l'orbitale du d�part (calcul� dans le programme)

! ici on recupere la fonction d'onde de l'orbitale du depart (appel en init_run)


      if( it == itabs ) then

        do j = 1,n_orb
          if( nqn(j) /= nseuil .or. lqn(j) /= lseuil ) cycle
          if( lqn(j) == 0 .or. mseuil == 1 ) then
            psii(1:nrato) = psi(1:nrato,j) 
          else
            psii(1:nrato) = psi(1:nrato,j+1) 
          endif
          exit
        end do

        l = l_level_val(Z)

 ! il est correct de calculer cela avec la config excitee d'init run ?
       
        do io = n_orb,1,-1
          if( lqn(io) /= l ) cycle
          if( irel == 0 ) then
            chg_val_ref = pop(io)
          else
            chg_val_ref = sum( pop(io-1:io) )
          endif
          exit
        end do


      endif

! ici on construit l'atome excite (appel en init_run):

      if( it == itabs .and. .not. nonexc ) then

        jo = 0
        ko = 0

        do io = 1,n_orbexc

          if( jo < nnlm ) jo = jo + 1
          ko = ko + 1

          nqn(jo) = nqnexc(io)
          lqn(jo) = lqnexc(io)
          ptot = sum( popexc(io,1:nspin) ) 

          if( irel == 0 .or. lqn(jo) == 0 ) then
            pop(jo) = ptot
            if( irel == 1 ) rqn(jo) = 0.5_db
          else
            if( nqn(jo) == nseuil .and. lqn(jo) == lseuil ) 
     &        ptot = ptot + 1
            p = lqn(jo) / ( 2 * lqn(jo) + 1. ) 
            pop(jo) = p * ptot
            if( nqn(jo) == nseuil .and. lqn(jo) == lseuil 
     &                      .and. mseuil == 1 ) pop(jo) = pop(jo) - 1.
            nqn(jo) = nqnexc(io)
            lqn(jo) = lqnexc(io)
            rqn(jo) = lqn(jo) - 0.5
            jo = jo + 1
            nqn(jo) = nqnexc(io)
            lqn(jo) = lqnexc(io)
            rqn(jo) = lqn(jo) + 0.5
            pop(jo) = ( 1 - p ) * ptot
            if( nqn(jo) == nseuil .and. lqn(jo) == lseuil 
     &                      .and. mseuil == 2 ) pop(jo) = pop(jo) - 1.
          endif
          
        end do
         
        n_orb = jo        ! norbexc relativist

        if( ko > nnlm ) then
          call write_error
          do ipr = 3,9,3
            write(ipr,130) 
          end do 
          stop
        endif       

        charge = Z - sum( pop(1:n_orb) )
        if( charge > eps6 ) then
          dp = charge
          do io = 2,n_orb
            if( nqn(io) <= nseuil .or. lqn(io) > 1 
     &                            .or. lqn(io-1) == lqn(io) ) cycle
            if( irel == 0 .or. lqn(io) == 0 ) then
              elmax = 2 + 4. * lqn(io)
              if( pop(io) > elmax - eps6 ) cycle
              ppp = pop(io)
              pop(io) = min( pop(io) + dp, elmax )
              dp = dp - pop(io) + ppp
            else
              elmax = 2 + 4. * lqn(io)
              if( sum(pop(io:io+1)) > elmax - eps6 ) cycle
              p = lqn(io) / ( 2 * lqn(io) + 1. ) 
              ppp = sum( pop(io:io+1) )
              pop(io) = min( pop(io) + p * dp, elmax*p )
              pop(io+1) = min( pop(io+1) + ( 1 - p ) * dp, elmax*(1-p) )
              dp = dp - sum( pop(io:io+1) ) + ppp
            endif
            if( dp < eps6 ) exit 
          end do
          if( dp > eps6 ) then
            nmax = 0
            do io = 1,n_orb
              nmax = max(nqn(io),nmax)
            end do
            iaug = 0          
            do io = 1,n_orb
              if( nqn(io) == nmax .and. lqn(io) == 1 ) then
                iaug = 1
                exit
              endif
            end do          
            if( iaug == 1 ) then
              n_orb = n_orb + 1
              if( n_orb > nnlm ) then
                call write_error
                do ipr = 3,9,3
                  write(ipr,130) 
                end do 
                stop
              endif       
              nqn(n_orb) = nmax + 1
              lqn(n_orb) = 0
              pop(n_orb) = dp
              if( irel == 1 ) rqn(n_orb) = 0.5 
            else
              n_orb = n_orb + 1
              nqn(n_orb) = nmax
              lqn(n_orb) = 1
              if( irel == 0 ) then
                pop(n_orb) = dp
              else
                rqn(n_orb) = 0.5
                pop(n_orb) = dp / 3
                n_orb = n_orb + 1
                if( n_orb > nnlm ) then
                  call write_error
                  do ipr = 3,9,3
                    write(ipr,130) 
                  end do 
                  stop
                endif       
                nqn(n_orb) = nmax
                lqn(n_orb) = 1
                rqn(n_orb) = 1.5
                pop(n_orb) = 2 * dp / 3
              endif 
            endif
          endif

        elseif( charge < - eps6 ) then

          do io = n_orb,2,-1
            dp = charge
            if( nqn(io) <= nseuil .or. lqn(io) > 1 ) cycle
            if( irel == 0 .or. lqn(io) == 0 ) then
              pop(io) = pop(io) + dp
            else
              pop(io) = pop(io) + 2 * dp / 3
              pop(io-1) = pop(io-1) + dp / 3
            endif
            exit
          end do

        endif

        do io = 1,nlat(it)
          do j = 1,n_orb
            if(nqn(j) /= nvval(it,io) .or. lqn(j) /= lvval(it,io)) cycle
            if( irel == 0 .or. lqn(j) == 0 ) then
              popatv(it,io) = pop(j) 
            else
              popatv(it,io) = pop(j) + pop(j+1) 
            endif
            exit
          end do
        end do

        if( icheck(2) > 0 ) then
          if( irel == 0 ) then
            write(3,165) Z 
            do io = 1,n_orb
              if( Z > 18 .and. nqn(io) < 3 ) cycle 
              if( Z > 36 .and. nqn(io) < 4 ) cycle 
              if( Z > 86 .and. nqn(io) < 5 ) cycle 
              write(3,160) nqn(io), lqn(io), pop(io)
            end do
          else
            write(3,175) Z 
            do io = 1,n_orb
              if( Z > 18 .and. nqn(io) < 3 ) cycle 
              if( Z > 36 .and. nqn(io) < 4 ) cycle 
              if( Z > 86 .and. nqn(io) < 5 ) cycle 
              write(3,180) nqn(io), lqn(io), rqn(io), pop(io)
            end do
          endif
        endif

 ! ici l'appel se fait � partir de type_work, pour l'atome excit�

        call dirac(Z,icheck(2),irel,n_orb,nqn,lqn,rqn,pop,
     &             nrato,ray,rho,psi,iout,n_ray,ray_max,h_ray)

      endif   ! fin de la partie appel type_work

        jo = 0
        l = l_level_val(Z)
        psi_level_val(0,it) = 0._db

! ici n_orb et n_coeur sont deja relativistes, apparement

        do io = 1, n_orb
            if( io <= n_coeur .or. lqn(io) /= l ) cycle
            if( irel == 1 .and. lqn(io) /= 0 ) then
              psi_level_val(1:nrato,it) = 0.5_db 
     &                        * ( psi(1:nrato,io) + psi(1:nrato,io-1) )
	        pop_level_val(it) = pop(io) + pop(io-1)
            else
              psi_level_val(1:nrato,it) = psi(1:nrato,io)
	        pop_level_val(it) = pop(io)
	      end if
        end do


      test = .false.

      if( test ) then

        drmax = 0.005_db / bohr
        rato(1) = ray(1) 
        do ir = 2,nrato
          if( ray(ir) - ray(ir-1) > drmax ) exit
          rato(ir) = ray(ir)
        end do
        nrlin = ir
        do ir = nrlin,nrato
          rato(ir) = rato(ir-1) + drmax
        end do  

      else
        nrlin = nrato + 1
        rato(1:nrato) = ray(1:nrato)
      endif

      if( test ) then

        psiit(:) = psii(:) 

        do ir = nrlin,nrato
          do jr = nrlin,nrato
            if( ray(jr) > rato(ir) ) exit
          end do
          p1 = ( rato(ir) - ray(jr-1) ) / ( ray(jr) - ray(jr-1) )
          p2 = 1._db - p1

          if( it == itabs ) then
            psii(ir) = p1 * psiit(jr) + p2 * psiit(jr-1) 
          endif

          rhoit(ir,it) = p1 * rho(jr) + p2 * rho(jr-1)    

! Les fonctions d'onde psi sont multipli�es par r * racine(4*pi)
          rho_coeur(ir,it) = 0._db
          do io = 1,n_coeur
            rho_coeur(ir,it) = rho_coeur(ir,it)
     &        + pop(io) * ( p1 * psi(jr,io)**2 + p2 * psi(jr-1,io)**2 )
          end do
          rho_coeur(ir,it) = rho_coeur(ir,it)
     &                     / ( quatre_pi * rato(ir)**2 )
      
! Oana: tous les tableaux que je fais sortir vers le main devraient etre remplis
! apres la construction de l'atome excite; si l'appel se fait a partir de atom cela 
! ne gene pas, car on ne construit pas l'excite; si l'appel se fait � partir de type_work
! on aurait deja eu toutes les quantites pour it = itabs    
      
! ici on stoque les fonctions d'onde (nonrelativistes, on tient pas compte du spin) pour les orbitales de valence 
     
          do io = 1,nlat(it)
            do j = 1,n_orb
              if( nqn(j) /= nvval(it,io) .or. lqn(j) /= lvval(it,io) )
     &          cycle
              if( irel == 0 .or. lqn(j) == 0 ) then
                psival(ir,io,it) = p1 * psi(jr,j) + p2 * psi(jr-1,j) 
              else
                psival(ir,io,it) = p1 * 0.5 * sum( psi(jr,j:j+1) )
     &                           + p2 * 0.5 * sum( psi(jr-1,j:j+1) )
              endif
              exit
            end do
          end do

 
 ! Recuperation des fonctions d'onde de la derni�re orbitale de coeur
 ! et de la premi�re orbitale de valence  
 
          select case (Z)
            case(1,2)
              do i = 1,2
                psi_coeur(ir,i,it) = p1 * psi(jr,1) + p2 * psi(jr-1,1)
              end do
            case default   
              do i = 1,2
                if( i == 1 ) then
                  io = n_coeur
                else
                 io = n_coeur + 1
                 if( irel == 1 .and. lqn(io) /= 0 ) io = io + 1 
                endif
                if( irel == 1 .and. lqn(io) /=0 ) then
                  psi_coeur(ir,i,it)
     &                 = p1 * 0.5_db * ( psi(jr,io) + psi(jr,io-1) )
     &                 + p2 * 0.5_db * ( psi(jr-1,io) + psi(jr-1,io-1) )  !ERR
                else 
                  psi_coeur(ir,i,it) = p1 * psi(jr,io) + p2*psi(jr-1,io)
                end if
              end do
          end select

        end do

      endif

      nratt = nrlin - 1

      rhoit(1:nratt,it) = rho(1:nratt)    ! la vraie densit�

! Les fonctions d'onde psi sont multipli�es par r * racine(4*pi)
      rho_coeur(1:nratt,it) = 0._db
      do io = 1,n_coeur
        rho_coeur(1:nratt,it) = rho_coeur(1:nratt,it)
     &                        + pop(io) * psi(1:nratt,io)**2 
      end do

      rho_coeur(1:nratt,it) = rho_coeur(1:nratt,it)
     &                      / ( quatre_pi * ray(1:nratt)**2 )
      
! Extrapolation au centre de l'atome.
      p1 = rato(2) / ( rato(2) - rato(1) )
      p2 = 1 - p1
      rho_coeur(0,it) = p1 * rho_coeur(1,it) + p2 * rho_coeur(2,it)
            
! Oana: tous les tableaux que je fais sortir vers le main devraient �tre remplis
! apr�s la construction de l'atome excit�; si l'appel se fait � partir de atom cela 
! ne g�ne pas, car on ne construit pas l'excit�; si l'appel se fait � partir de type_work
! on aurait dej� eu toutes les quantit�s pour it = itabs    
      
! ici on stoque les fonctions d'onde (nonrelativistes, on tient pas compte du spin) pour les orbitales de valence 
     
      do io = 1,nlat(it)
        do j = 1,n_orb
          if( nqn(j) /= nvval(it,io) .or. lqn(j) /= lvval(it,io) ) cycle
          if( irel == 0 .or. lqn(j) == 0 ) then
            psival(1:nratt,io,it) = psi(1:nratt,j) 
          else
            do ir = 1,nratt
              psival(ir,io,it) = 0.5 * sum( psi(ir,j:j+1) )
            end do                       
          endif
          exit
        end do
      end do

 ! Recuperation des fonctions d'onde de la derni�re orbitale de coeur
 ! et de la premi�re orbitale de valence  
 
      select case (Z)
        case(1,2)
           do i = 1,2
             psi_coeur(1:nratt,i,it) = psi(1:nratt,1)
             lcoeur(i,it) = lqn(1)
             ncoeur(i,it) = nqn(1)
           end do
        case default   
           do i = 1,2
             if( i == 1 ) then
               io = n_coeur
             else
              io = n_coeur + 1
              if( irel == 1 .and. lqn(io) /= 0 ) io = io + 1 
             endif
             lcoeur(i,it) = lqn(io)
             ncoeur(i,it) = nqn(io)
             if( irel == 1 .and. lqn(io) /=0 ) then
               psi_coeur(1:nratt,i,it) = 0.5_db*(psi(1:nratt,io)
     &                                        + psi(1:nratt,io-1) ) 
             else 
               psi_coeur(1:nratt,i,it) = psi(1:nratt,io)
             end if
             psi_coeur(0,i,it) = 0._db
           end do
      end select

      if( icheck(2) > 2 ) then
        write(3,135) it, ( ncoeur(i,it), lcoeur(i,it), i = 1,2 )
         do ir = 1, nrato
            write(3,137) ( psi_coeur(ir,i,it),i = 1,2 )
         end do
      end if      
! on prend en compte la charge eventuelle de l'atome

      popatc(it) = 1._db * Z
      do io = 1,nlat(it)
        popatc(it) = popatc(it) - popatv(it,io)
      end do

      if( icheck(2) > 1 ) then
         write(3,210) popatc(it)
         do l = 1,nlat(it)
           if( l == 1 ) write(3,215)
           write(3,220) nvval(it,l), lvval(it,l), popatv(it,l)
         end do

         if( it == itabs ) then
           write(3,230) ( nvval(it,l), lvval(it,l), l = 1,nlat(it) ),
     &                    nseuil, lseuil
           do ir = 1,nrato
             if( nlat(it) > 0 ) then
               write(3,240) rato(ir) * bohr, rhoit(ir,it), 
     &                  ( psival(ir,l,it), l = 1,nlat(it) ), psii(ir)
             else
               write(3,240) rato(ir) * bohr, rhoit(ir,it), psii(ir)
             endif
           end do
        else
           write(3,230) ( nvval(it,l), lvval(it,l), l = 1,nlat(it) )
           do ir = 1,nrato
             if( nlat(it) > 0 ) then
               write(3,240) rato(ir) * bohr, rhoit(ir,it),
     &                    ( psival(ir,l,it), l = 1,nlat(it) )
             else
               write(3,240) rato(ir) * bohr, rhoit(ir,it)
             endif
           end do
        endif
      endif

      return
  110 format(/' ---- Dirac --------',100('-')//' it =',i2,'  Z =',i4)
  120 format(///'   n_ray =',i5,' > nrm =',i4,/
     &          ' Increase the parameter ndm in lectur and dirac ')
  125 format(///'   nrm =',i5,' /= ndm =',i5,/
     &          ' Change the value of ndm in Dirac routines '/)
  130 format(///'   n_orb < nnlm ',//
     &          ' Increase nnlm in all routines of dirac.f !')
  135 format(/'  it =',i3,3x,'n_coeur =',i1,3x,'l_coeur =',i1,3x,
     &                                   'n_val =',i1,3x,'l_val =',i1/)
  137 format(1p,2e14.6)   
  140 format(//' nlat =',i3,' > nlatm =',i3)
  150 format(/' Atom type',i3,',  Z =',i3,
     &'   Non relativistic atomic calculation',/'   n  l     pop')
  160 format(i4,i3,f9.3)
  165 format(/' Excited atom, type 0',',  Z =',i3,
     &'   Non relativistic atomic calculation',/'   n  l     pop')
  170 format(/' Atom type',i3,',  Z =',i3,
     &'   Relativistic atomic calculation',/'   n  l   j      pop')
  175 format(/' Excited atom, type 0',',  Z =',i3,
     &'   Relativistic atomic calculation',/'   n  l   j      pop')
  180 format(i4,i3,f5.1,2f9.3)
  210 format(/'  Popatc =',f9.4)
  215 format(/'  n  l  Popatv')
  220 format(2i3,f8.4)
  230 format(/'     rato          rho',10(7x,2i3))
  240 format(1p,10e13.5)
      end

!***********************************************************************

! PROGRAM DIRAC

! DIRAC, A COMPUTER PROGRAM TO CARRY OUT BOTH NONRELATIVISTIC AND
! RELATIVISTIC SELF CONSISTENT FIELD CALCULATIONS FOR ATOMS AND IONS

! THE PROGRAM CONSISTS OUT OF THE FOLLOWING ROUTINES

!       DIRAC - CONTROL PROGRAM
!       DINPT - INPUT ROUTINE
!       DIPOT - GENERATES POTENTIAL
!       DIDIF - SOLVES DIRAC-SLATER DIFFERENTIAL EQUATIONS
!       DIDF1 - INTEGRATES INNER PART OF DIRAC SLATER EQUATIONS
!       HSDIF - SOLVES HARTREE-FOCK-SLATER DIFFERENTIAL EQUATIONS
!       DIOUT - PRINTED OUTPUT ROUTINE
!       DIADL - ROUTINE FOR NUMERICAL INTEGRATION
!       DIDEN - DENSITY ANALYSIS PROGRAM

! WRITTEN AND/OR MODIFIED FROM LOS ALAMOS PROGRAM BY
! P. ROS AND D.E. ELLIS, CHEMISTRY DEPARTMENT
! FREE UNIVERSITY OF AMSTERDAM, HOLLAND.
! MOD.BY.ELLIS AND JANSEN(1977)FOR EFG AND DIPOLE INTEGRALS.
! MOD. BY G.A. BENESH FOR CONTINUUM ORBITALS..OCT78
! MODIFIED TO GENERATE BASIS FUNCTIONS AND CHARGE DENSITIES FOR THE
! NON-RELATIVISTIC AND RELATIVISTIC MOLECULAR PROGRAMS
! Modified by Tapio T Rantala to include different exchange and
! correlation potentials by implementing the routine XC(     ).
! 1985-11-06. The changes are done in DIPOT.
! A. Rosen found that it was some error for spinpolarized calc.
! This was corrected by Bengt Lindgren and A. Rosen Dec 1987.

      subroutine dirac(Z,icheck,irel,n_orb,nqn,lqn,rqn,pop,nr,ray,
     &                 rho,psi,ibav,n_ray,ray_max,h_ray)

      use declarations
      implicit real(kind=db) (a-h,o-z)
      parameter(ndm=600)
      parameter(aaz = 0.5_db, abz = 0._db, acz = 2._db,  
     &          aez = 1._db, afz = 0.25_db, agz = 0.75_db, 
     &          ahz = 1.e-10)

      integer:: Z 
      integer, dimension(nnlm):: lqn, nqn 
      real(kind=db), dimension(ndm):: ray, rho
      real(kind=db), dimension(ndm,nnlm):: psi
      real(kind=db), dimension(nnlm):: pop, rqn 

      common/iblock/ n, j, nc1, npts, iout, idirc, jspn, last
      common/rblock/ rn, h, zeff, zn, xion, phi, eps, del, delrv,
     & xalph, xlatt, rnuc, convr, fn, fl, fj, e, q, ev, ez, ey, v0, et3,
     & summa, da(5), dbb(5), a0(15), b0(15), voc(5), anuc, sumel, zndif,
     & fdll, vs(ndm), vr(ndm), rh(ndm), a(ndm), b(ndm), rad(ndm),
     & y(ndm), rj(ndm), rhd(ndm), rbar, rba2, vbar, h3, fk, cs, g, q11,
     & q22, tcs, ex, ec, xte
      common/xnljez/ xn(nnlm), xl(nnlm), xj(nnlm), xe(nnlm), xz(nnlm),
     &               xdell(nnlm) 

      iout = ibav
      isav = 66
      open(isav, form='UNFORMATTED', status='SCRATCH') 

! FCN ASSUMED ZERO FOR B > EPX
      ec = 0.e0
      last = 0
      rewind(isav) 

      call dinpt(icheck,ph,Z,irel,n_orb,nqn,lqn,rqn,pop,ray,n_ray,
     &                 ray_max,h_ray)
      h1 = aez / h

! ITERATION TIE POINT HERE...
      do ncycl = nc1,0,-1

! RH=ELECTR.DENS. RJ=SPIN.DENS. VR=R*POT.
        call dipot(icheck, rh, rj, vr, 1)
        if( (convr < delrv) .or. (ncycl <= 0) ) then
          last = 1
          znef = zn - zndif
          write(isav) n, j, rn, h1, znef, xion, rbar, vbar, rnuc
          write(isav) ( vr(i), i = 1,n )
        endif
        nr = n
        summa = abz
        ps = aez - ph
        if( icheck > 2 .or. (icheck > 1 .and. last == 1 ) )
     &                                    write(iout,20) ncycl, ph
        rh(1:n) = ps * rh(1:n)

        do i = 1, j
          fn = xn(i)
          fl = xl(i)
          fj = xj(i)
          nl2j = nint( xn(i) * 100 + xl(i) * 10 + xj(i) * 2 )
          e = xe(i)
          fdll = xdell(i)
          if( i == jspn + 1 ) then
            call dipot(icheck, rh, rj, vr, 2)
            rj(1:n) = ps * rj(1:n)
          endif
! SKIP UNOCCUPIED STATES UNTIL LAST CYCLE.
          if ( (xz(i) < ahz) .and. (last /= 1) ) cycle
          if( idirc == 0 ) then
            call hsdif(icheck)
            y(1:n) = ph * xz(i) * a(1:n)**2
          else
            call didif(icheck)
            y(1:n) = ph * xz(i) * ( a(1:n)**2 + b(1:n)**2 )
          endif
          rh(1:n) = rh(1:n) + y(1:n)
          if( i > jspn ) rj(1:n) = rj(1:n) + y(1:n)
          summa = summa + xz(i) * e
          xe(i) = e
          xdell(i) = fdll
          if( last /= 1) cycle
          if( idirc == 0 ) then
            write(isav) nl2j, xz(i), xe(i), npts, ( a(k), k = 1,npts )
          else
            write(isav) nl2j, xz(i), xe(i), npts,
     &                                    ( a(k), b(k), k = 1,npts )
          endif
          if( icheck > 2 ) then
            write(iout,24) v0, ( a0(k), k = 1,5 )
            if( idirc > 0 ) write(iout,24) v0, (b0(k), k = 1,5)
          endif
        end do

! Changes in total energy dec 87
!      ET3=SUMMA-AAZ*(EV-EZ+AAZ*EY)
        et3 = summa - aaz * (ev - ez) - ey + ex
        pv3 = et3 + summa - ev + acz * (ey - ex - xte) - ex - (ec / afz)
        if( icheck > 2 ) write(iout,23) pv3, ey, ev, ez, summa,et3,rh(1)
        if( ncycl < 21 ) ph = (afz * phi) + (agz * ph)
        if( last == 1 ) exit

      end do

      call diout(isav,icheck,rho,psi)
      call diden(icheck)

      Close(isav)

      return
   20 format(' CYCLE ',i5,'  DENSITY AVERAGING ',f10.7)
   23 format(' Q3PV,EY,EV,EZ,ESUM,ETOT,RHO',7e14.6)
   24 format(6e20.8)
      end

!***********************************************************************

      subroutine diden(icheck)
      
      use declarations
      implicit real(kind=db) (a-h,o-z)
      
      parameter(ndm=600)

      character(len=6), dimension(80):: dlj

      integer, dimension(nnlm):: nist 

      real(kind=db), dimension(nnlm):: c00, c20, 
     &                                           den, gkap, rhon   !!!ERR: den is not initialised
      real(kind=db), dimension(nnlm,15):: rhoi

      common/iblock/ n, j, nc1, npts, iout, idirc, jspn, last
      common/rblock/ rn, h, zeff, zn, xion, phi, eps, del, delrv,
     & xalph, xlatt, rnuc, convr, fn, fl, fj, e, q, ev, ez, ey, v0, et3,
     & summa, da(5), dbb(5), a0(15), b0(15), voc(5), anuc, sumel, zndif,
     & fdll, vs(ndm), vr(ndm), rh(ndm), a(ndm), b(ndm), rad(ndm),
     & y(ndm), rj(ndm), rhd(ndm), rbar, rba2, vbar, h3, fk, cs, g, q11,
     & q22, tcs, ex, ec, xte
      common/xnljez/ xn(nnlm), xl(nnlm), xj(nnlm), xe(nnlm), xz(nnlm),
     &               xdell(nnlm) 
      common/labs/ dlj

      equivalence (y(1), rhoi(1,1)), (vs(1), den(1)), (rh(61), rhon(1))
      equivalence (rh(241), c00(1)), (rh(181), c20(1)), (rh(241), gkap(1
     &))
      parameter (c = 137.037d0, p4 = 0.0795774715d0)
      parameter (ismax = 15)
      parameter (aaz = .5_db, abz = 2._db, acz = .0_db, adz = 1._db, 
     & aez = 3._db, afz = 25._db, agz = .208e-4, ahz = 51.001_db, 
     & aiz = 1.501_db)
      ra = rad(1)

      do i = 1, j
        if( idirc == 0 ) then
          nist(i) = aaz * xn(i) * (xn(i) - adz) + xl(i) + ahz
        else
          nist(i) = xn(i) * (xn(i) - abz) + xl(i) + xj(i) + aiz
        endif
      end do

      if( rnuc <= acz ) rnuc = agz * ( anuc**(adz/aez) )
      if( rnuc <= acz ) rnuc = ra
      if( icheck > 2 ) write(iout,50) ra, rnuc, anuc

      if( idirc /= 0 ) then

        tc = c + c
        tcr = tc * ra
        q21 = voc(1)
        do i = 1, j
          fl = xl(i)
          fj = xj(i)
          fk = abz * (fl - fj) * (fj + aaz)
          g = sqrt( fk**2 - q21**2 )
          gkap(i) = g
          if( fk < 0._db ) then
            a0(1) = g - fk
            b0(1) = q21
          else
            a0(1) = - q21
            b0(1) = g + fk
          endif
          voc(2) = voc(5) + ((xe(i) * ra) / c)
          fis = acz
          do is = 2, ismax
            fis = fis + adz
            suma = acz
            sumb = acz
            ismx = min0(is,4)
            do it = 2, ismx
              itm = (is - it) + 1
              suma = suma - voc(it) * ( b0(itm) * (fis + g - fk) -voc(1)
     &             * a0(itm))
              sumb = sumb + voc(it) * ( a0(itm) * (fis + g + fk) -voc(1)
     &             * b0(itm))
            end do
            fac = fis * ((fis + g) + g)
            a0(is) = (- tcr * (fis + g - fk) * b0(is - 1) + suma ) /fac
            b0(is) = (- tcr * voc(1) * b0(is - 1) + sumb ) / fac
          end do

          sumb = acz
          do is = 1, ismax
            suma = acz
            do it = 1, is
              itm = (is - it) + 1
              suma = (suma + a0(it)*a0(itm)) + b0(it)*b0(itm)
            end do
            rhoi(i,is) = suma
            sumb = sumb + suma
          end do

          sumb = sumb * (ra ** ((g + g) - abz))
          scale = den(i) / sumb
          scala = sqrt(scale)
          do is = 1, ismax
            a0(is) = a0(is) * scala
            b0(is) = b0(is) * scala
            rhoi(i,is) = rhoi(i,is) * scale
          end do

          ni = nist(i)
          if( icheck > 2 ) then
            write(iout,60) dlj(ni), g
            write(iout,70) (a0(is),is = 1,ismax)
            write(iout,80) (b0(is),is = 1,ismax)
            write(iout,90) (rhoi(i,is),is = 1,ismax)
          endif

        end do

      else

! NON-RELATIVISTIC

        do i = 1,j
          a0(1) = adz
          voc(2) = voc(5) - (xe(i) * ra)
          do is = 1, 4
            b0(is) = abz * voc(is)
          end do
          fis = adz
          fl = xl(i)
          flp = fl + adz
          tflp = flp + flp
          ffl = tflp
          gkap(i) = flp
          do is = 2, ismax
            suma = acz
            ismx = min0(is,5)
            do it = 2, ismx
              itm = (is - it) + 1
              suma = suma + (b0(it - 1) * a0(itm))
            end do
            a0(is) = (ra * suma) / (fis * ffl)
            fis = fis + adz
            ffl = ffl + adz
          end do
          sumb = acz
          do is = 1, ismax
            suma = acz
            do it = 1, is
              itm = (is - it) + 1
              suma = suma + (a0(it) * a0(itm))
            end do
            rhoi(i,is) = suma
            sumb = sumb + suma
          end do

          sumb = sumb * (ra ** (tflp - abz))
          scale = den(i) / sumb
          scala = sqrt(scale)
          do is = 1, ismax
            a0(is) = a0(is) * scala
            rhoi(i,is) = rhoi(i,is) * scale
          end do
          ni = nist(i)
          if( icheck > 2 ) then
            write(iout,60) dlj(ni), flp
            write(iout,100) (a0(is),is = 1, ismax)
            write(iout,90) (rhoi(i,is),is = 1, ismax)
          endif

        end do

      endif

!     COMPUTE VARIOUS PROPERTIES

      suma = acz
      sumb = acz
      sumc = acz
      tn = rnuc / ra

      do i = 1, j
        g = gkap(i)
        fa = g + g
        fb = fa + adz
        fc = fb + abz
        fd = fc + abz
        fe = fa - abz
        rb = rnuc ** fe
        rc = rnuc ** fa
        ta = adz
        sa = acz
        sb = acz
        sc = acz
        do is = 1, ismax
          de = rhoi(i,is)
          sa = sa + (de * ta / fb)
          sb = sb + (de * ta / (fa * fb * fc))
          if( g > adz ) sc = sc + (de * ta / (fc * fd * fe))
          fa = fa + adz
          fb = fb + adz
          fc = fc + adz
          fd = fd + adz
          fe = fe + adz
          ta = ta * tn
        end do
        rhon(i) = rb * sa * aez
        c00(i) = - rc * sb * aez 
        c20(i) = - rc * sc * afz
        suma = suma + rhon(i) * xz(i)
        sumb = sumb + c00(i) * xz(i)
        sumc = sumc + c20(i) * xz(i)
      end do

      if( icheck > 2 ) then
        write(iout,110) 
        do i = 1,j
          ni = nist(i)
          write(iout,120) dlj(ni), rhon(i), c00(i), c20(i)
        end do
        write(iout,130) suma, sumb, sumc
      endif

      return 
   50 format(/' SCALING RADIUS =',e18.8,' NUCLEAR RADIUS =',e18.8,
     &' ATOMIC WEIGHT =',e18.8)
   60 format(//' EXPANSION COEFFICIENTS FOR THE  ',a6,'ORBITAL'/,
     &' KAPPA =',f14.8)
   70 format(/' THE MAJOR COMPONENT EXPANSION COEFFICIENTS ARE',/6e20.8)
   80 format(/' THE MINOR COMPONENT EXPANSION COEFFICIENTS ARE',/6e20.8)
   90 format(/' THE DENSITY EXPANSION COEFFICIENTS ARE',/6e20.8)
  100 format(/' THE WAVE FUNCTION EXPANSION COEFFICIENTS ARE',/6e20.8)
  110 format(//' ORBITAL',10x,'RHO-NUC(AVER)',10x,'MONOPOLE-CORR',10x,
     &'QUADRUPOLE-CORR'/)
  120 format(2x,a6,10x,e15.8,10x,e15.8,10x,e15.8)
  130 format(//' THE TOTAL DENSITY AVERAGED OVER THE NUCLEAR VOLUME IS',
     &e16.8,/' THE TOTAL MONOPOLE CORRECTION IS',21x,e16.8/,
     &' THE TOTAL QUADRUPOLE CORRECTION IS',19x,e16.8)
      end

!***********************************************************************

!   DIOUT PRINTS DATA FROM THE CALCULATION. 
!   DIOUT ALSO COMPUTES AND PRINTS (1/R) AND (1/R**3)- INTEGRALS

      subroutine diout(isav,icheck,rho,psi)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      parameter(ndm=600)
      parameter( n3m=1000 )
      parameter(auev = 27.21165d0,p4 = 0.0795774715d0)
      parameter(aaz = 2._db, abz = 1.501_db, acz = 1._db, 
     &          adz = .501_db, aez = 3._db, afz = 0._db,
     &          agz = .5_db, ahz = 51.001_db)

      character(len=6), dimension(80):: nlj

      real(kind=db), dimension(ndm):: ak, bk, rho, rhs
      real(kind=db), dimension(ndm,nnlm):: psi
      real(kind=db), dimension(n3m):: r1int, r3int

      dimension nist(nnlm), den(20,5)

      common/iblock/ n, j, nc1, npts, iout, idirc, jspn, last
      common/labs/ nlj
      common/rblock/ rn, h, zeff, zn, xion, phi, eps, del, delrv,
     & xalph, xlatt, rnuc, convr, fn, fl, fj, e, q, ev, ez, ey, v0, et3,
     & summa, da(5), dbb(5), a0(15), b0(15), voc(5), anuc, sumel, zndif,
     & fdll, vs(ndm), vr(ndm), rh(ndm), a(ndm), b(ndm), rad(ndm),
     & y(ndm), rj(ndm), rhd(ndm), rbar, rba2, vbar, h3, fk, cs, g, q11,
     & q22, tcs, ex, ec, xte
      common/xnljez/ xn(nnlm), xl(nnlm), xj(nnlm), xe(nnlm), xz(nnlm),
     &               xdell(nnlm) 
      equivalence (vs(1), rhs(1))
      equivalence (vr(1), den(1,1)), (vr(101), r1int(1)), (vr(201), 
     &             r3int(1))

      if( icheck > 2 ) write(iout,13) xalph, rnuc
      if( icheck > 1 ) write(iout,12)

      rstp = - rad(2) / rad(1)
      do i = 1, j
        if( idirc == 0 )  then
          nist(i) = agz * xn(i) * (xn(i) - acz) + xl(i) + ahz
        else
          nist(i) = xn(i) * (xn(i) - aaz) + xl(i) + xj(i) + abz
        endif
      end do
      if( icheck > 1 ) then
        do i = 1, j
          ni = nist(i)
          xev = auev * xe(i)
          write(iout,14) nlj(ni), nint(xn(i)), nint(xl(i)), xj(i),
     &                   xz(i), xev
        end do
      endif
      ekin = ((summa - ev) - ey) - xte
      ez = ev - ez
      if( icheck > 1 ) write(iout,15) zn, q, summa, et3, ekin, ev, ez,ex
      rewind(isav) 
      read(isav) n, j, rn, h1, zn, xion, rbar, vbar, rnuc
!   PATCH TO REMOVE NUCLEAR CHARGE
      if( nc1 <= -10 ) zn = afz

      read(isav) (a(i),i = 1, n)

      do k = 1, j
        if( idirc == 0 ) then
          read(isav) nl2j, xz(k), xe(k), npts, (a(i),i = 1, npts)
        else
          read(isav) nl2j, xz(k), xe(k), npts, (a(i), b(i), i=1,npts)
        endif
      end do

      do k = 1, n
        s = acz / rad(k)
        y(k) = p4 * rh(k) * s * s
        b(k) = p4 * s * s * (rh(k) - aaz * rj(k))
        a(k) = rh(k) * rad(k)
      end do
      rho(1:n) = y(1:n) 
      if( icheck > 2 ) then
        write(iout,23) rn, n, h
        write(iout,17) (rad(k),k = 1, n)
        write(iout,16) 
! LIST DENSITY...
        write(iout,17) (y(k),k = 1, n)
        call squint(iout,icheck, y, rad(1), rstp, n)
        if( jspn < j ) then
          write(iout, fmt=21) 
          write(iout, fmt=17) (b(k),k = 1, n)
          call squint(iout,icheck, b, rad(1), rstp, n)
        endif
! LIST POTENTIAL
        write(iout, fmt=22) 
        a(1:n) = (acz * vr(1:n)) / rad(1:n)
        write(iout, fmt=17) (a(k),k = 1, n)
        call squint(iout,icheck, a, rad(1), rstp, n)
      endif

      rewind(isav) 
      read(isav) 
! PREPARE R**(-3)AND R**(-1) DIAGONAL MTX.
      read(isav) 
      ist = 1
      do k = 1,j
        if( idirc == 0 ) then
          read(isav) nl2j, xz(k), xe(k), npts, (a(i),i = 1, npts)
        else
          read(isav) nl2j, xz(k), xe(k), npts, (a(i),b(i),i=1,npts)
        endif
        ni = nist(k)
        if( idirc == 0 ) then 
          y(1:npts) = ( a(1:npts)**2 ) / rad(1:npts)
        else
          y(1:npts) = ( a(1:npts)**2 + b(1:npts)**2 ) / rad(1:npts)
        endif
        r1int(k) = diadl(rad,y,npts,h,2,xp)
! SAVE VALUE AT R1 FOR NORMALIZATION IN DIDEN...
        den(1:20,ist) = y(1:20) * p4 / rad(1:20)
        rhs(k) = y(1) / rad(1)
        if( ( idirc == 0 .and. xl(k) >= acz ) .or.
     &      ( idirc /= 0 .and. xj(k) > adz ) ) then
          y(1:npts) = y(1:npts) / rad(1:npts)**2
          r3int(k) = diadl(rad,y,npts,h,2,xp)
        else
          r3int(k) = afz
        endif
        if( k >= j .or. ist >= 5 ) ist = 0
        ist = ist + 1
      end do
! PRINT R**(-3)AND R**(-1) DIAGONAL MTX.
      if( icheck > 2 ) then
        write(iout,55)
        do k = 1, j
          ni = nist(k)
          write(iout,56) nlj(ni), r3int(k), r1int(k)
        end do
      endif 

! PREPARE R**(1)AND R**(-3) MATRIX ELEMENTS...
! SKIP HEADER RECDS (ISAV)
      rewind(isav) 
      read(isav) idm
      read(isav) xdum
      kdex = 0
      kdx1 = 0
      do k = 1, j
        if (idirc == 0) then
          read(isav) idm, xdm, xdm, npt1, (a(i),i = 1,npt1)
        else
          read(isav) idm, xdm, xdm, npt1, (a(i), b(i), i = 1,npt1)
        endif
        rewind(isav) 
        read(isav) idm
        read(isav) xdum

        do 480 kk = 1, k

        if (idirc) 410, 405, 410

  410   read(isav) idm, xdm, xdm, npt2, (ak(i), bk(i),i = 1, npt2)
                        npts = min0(npt1,npt2)
        if ((xj(k) + xj(kk)) - aaz) 465, 415, 415
  415   do 420 i = 1, npts
  420   y(i) = (a(i) * ak(i) + b(i) * bk(i)) / (rad(i) ** 3)
        goto 440

  405   read(isav) idm, xdm, xdm, npt2, (ak(i),i = 1, npt2)
        npts = min0(npt1,npt2)

        if ((xl(k) + xl(kk)) - aaz) 445, 425, 425

  425   amxl = mod(abs(xl(k) - xl(kk)),2.d0)
        if ((amxl .gt. .001) .and. (amxl .lt. 1.999)) goto 445
        do 430 i = 1, npts
  430   y(i) = a(i) * ak(i) / (rad(i) ** 3)

  440   kdex = kdex + 1
        r3int(kdex) = diadl(rad,y,npts,h,2,xp)
!       R1 - INT  NON-REL

        if (idirc) 465, 445, 465

  445   amxl = mod(xl(k) + xl(kk),2.d0)
        if (abs(amxl - 1.) .gt. 0.001) goto 480
        if (abs(xl(k) - xl(kk)) .gt. 1.001) goto 480
        do 450 i = 1, npts
  450   y(i) = a(i) * ak(i) * rad(i)
!    R1 - INT  REL
        goto 475

  465   amxl = mod(xl(k) + xl(kk),2.d0)
        if (abs(amxl - 1.) .gt. 0.001) goto 480
        do 470 i = 1, npts
  470   y(i) = (a(i) * ak(i) + b(i) * bk(i)) * rad(i)

  475   kdx1 = kdx1 + 1
        r1int(kdx1) = diadl(rad,y,npts,h,2,xp)

  480   continue

      end do

      if( icheck > 2 ) then
        write(iout,492) ( r3int(i), i = 1,kdex )
        write(iout,494) ( r1int(i), i = 1,kdx1 )
      endif 

      rewind(isav) 
      read(isav) n, j, rn, h1, zn, xion, rbar, vbar, rnuc
! LIST RADIAL WAVEFNS.
      read(isav) ( vri, i = 1,n )
      do k = 1,j
        ni = nist(k)
        if( idirc /= 0 ) then
          read(isav) nl2j, xz(k), xe(k), npts, (a(i),b(i),i=1,npts)
          if( icheck > 2 ) then
            write(iout,18) nlj(ni)
            write(iout,17) (a(i),i = 1, npts)
            if( icheck > 3 ) call squint(iout,icheck,a,rad(1),rstp,npts)
            write(iout,19) nlj(ni)
            write(iout,17) (b(i),i = 1, npts)
            if( icheck > 3 ) call squint(iout,icheck,b,rad(1),rstp,npts)
          endif
        else
          read(isav) nl2j, xz(k), xe(k), npts, (a(i),i = 1, npts)
          if( icheck > 2 ) then
            write(iout,35) nlj(ni)
            write(iout,17) (a(i),i = 1, npts)
            if( icheck > 3 ) call squint(iout,icheck,a,rad(1),rstp,npts)
          endif
        endif
        psi(:,k) = 0._db
        psi(1:npts,k) = a(1:npts)
      end do
      rewind(isav) 

   12 format(/' Orbital  n  l  j    Electron  Eigenvalue(eV)')
   13 format(' EXCHANGE COEFFICIENT = ',f10.7,10x,' NUCLEAR RADIUS =', 
     &         e10.3)
   14 format(a6,i5,i3,f4.1,f10.3,3f15.3)
   15 format(/' Nuclear charge                =',f12.6/,
     &        ' Integral of charge density    =',f12.6/,
     &        ' Sum of the energy eigenvalues =',f12.4/,
     &        ' Total energy                  =',f12.4/,
     &        ' Kinetic energy                =',f12.4/,
     &        ' Total Coulomb energy          =',f12.4/,
     &        ' Potential energy              =',f12.4/,
     &        ' Exchange energy               =',f12.4)
   16 format(53x,'RHO(R)'/)
   17 format(2x,8e14.7)
   18 format(21x,'R TIMES MAJOR COMPONENT OF THE',a6,' ORBITAL'/)
   19 format(21x,'R TIMES MINOR COMPONENT OF THE',a6,' ORBITAL'/)
   21 format(30x,' SPIN (MOMENT) DENSITY')
   22 format(' POTENTIAL FUNCTIONS'/)
   23 format(' TABLE OF RADII. RN=RMAX. EXP((N-NMAX).H).,  RMAX ='
     &,f8.4,', NMAX =',i5,', H =',f10.8/)
   35 format(20x,' R TIMES WAVE FUNCTION OF THE ',a6,'ORBITAL'/)
   55 format(21x,' ORBITAL',10x,'(1/R..3)INTEGRAL',10x,'(1/R)INTEGRAL'/)
   56 format(24x,a6,8x,e17.7,10x,e14.7)
  492 format('R-MIN3-INTEGRALS'/,(6f20.7))
  494 format('R1-INTEGRALS'/,(6f20.7))
      end

!***********************************************************************

! FOR DE.GT.0 LINEAR INCREMENT PRINTED
! FOR  DE.LT.0 LOG INCREMENT PRINTED
! HISTOGRAM PRINTER PLOTTER ROUTINE.

      subroutine squint(iout,icheck,q,eb,de,ne)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      parameter (dp50 = 1.e33)

      character(len=1):: x, blnk
      character(len=1), dimension(100):: bar
      real(kind=db), dimension(ne):: q

! FIND MAXIMUM AND MINIMUM VALUES IN Q()
      data hndrd / 100.d0 /
      data rnd / .49d0 /
      data blnk / ' ' /
      data x / '*' /
! oana
      ncn = 0
      nhp = 0
! fin            
      qmin = dp50
      qmx = - dp50
      do j = 1, ne
        qmin = min(qmin,q(j))
        qmx = max(qmx,q(j))
      end do
      qmx = qmx - qmin
      if( qmx <= 0._db ) goto 500
      rsc = hndrd / qmx
      e = eb
      if( icheck > 3 ) write(iout,4) 
      j = 0
  100 j = j + 1
      if (j > ne) return
      bar(1:100) = blnk
      nh = (rsc * (q(j) - qmin)) + rnd
      k = 0
  200 k = k + 1
      if (k .gt. nh) goto 250
      bar(k) = x
      goto 200
  250 ncn = ncn + 1
      if( nh /= nhp ) ncn = 0
! SKIP PRINT, IF OUTPUT CONST FOR MORE THAN 10 LINES
      nhp = nh
      if( ncn <= 10 .and. icheck > 3 ) write(iout,2) e, bar
      e = e * abs(de)
      goto 100
  500 if( icheck > 3 ) write(iout,3) 

      return 
    2 format(5x,f7.3,'  I',100a1)
    3 format(/////30x,' NO VALUE GREATER THAN ZERO IN HISTO.')
    4 format(//10('1234567890'))
      end

!***********************************************************************

!  INTEGRATES OUTWARD TO CLASSICAL TURNING POINT, COUNTS NODES IN THE
!  MAJOR COMPONENT OF THE RADIAL WAVE FUNCTION.

      subroutine didf1(ki,fn1)
      
      use declarations
      implicit real(kind=db) (a-h,o-z)
      
      parameter(ndm=600)
      parameter(aaz = 0._db, abz = 0.5_db, acz = 1._db)

      common/ha/ ha1, ha2, ha3, ha4, ha5, ha6, ha7, ha8, ha9 
      common/iblock/ n, j, nc1, npts, iout, idirc, jspn, last
      common/rblock/ rn, h, zeff, zn, xion, phi, eps, del, delrv,
     & xalph, xlatt, rnuc, convr, fn, fl, fj, e, q, ev, ez, ey, v0, et3,
     & summa, da(5), dbb(5), a0(15), b0(15), voc(5), anuc, sumel, zndif,
     & fdll, vs(ndm), vr(ndm), rh(ndm), a(ndm), b(ndm), rad(ndm),
     & y(ndm), rj(ndm), rhd(ndm), rbar, rba2, vbar, h3, fk, cs, g, q11,
     & q22, tcs, ex, ec, xte

!  STARTS OUTWARD INTEGRATION WITH A POWER SERIES.
      ra = rad(1)
      tcr = tcs * ra
      voc(2) = voc(5) + ((e * ra) / cs)
      fis = aaz
      do is = 2, 11
        fis = fis + acz
        suma = aaz
        sumb = aaz
        ismx = min0(is,4)
        do it = 2, ismx
          itm = (is - it) + 1
          suma = suma - (voc(it) * ((b0(itm) * (fis + g - fk)) - (voc(1)
     &         * a0(itm))))
          sumb = sumb + (voc(it) * ((a0(itm) * (fis + g + fk)) - (voc(1)
     &         * b0(itm))))
        end do
        fac = fis * (fis + g + g)
        a0(is) = ((- (tcr * (fis + g - fk) * b0(is - 1))) + suma) / fac
        b0(is) = ((- (tcr * voc(1) * b0(is - 1))) + sumb) / fac
      end do
      do k = 1, 5
        r = rad(k)
        ta = r / ra
        suma = aaz
        sumb = aaz
        tpow = acz
        do is = 1, 11
          suma = suma + a0(is) * tpow
          sumb = sumb + b0(is) * tpow
          tpow = tpow * ta
        end do
        a(k) = suma
        b(k) = sumb
        rp21 = ((e * r) - vr(k)) / cs
        rp12 = (- rp21) - (tcs * r)
        da(k) = (q11 * a(k)) + (rp12 * b(k))
        dbb(k) = (q22 * b(k)) + (rp21 * a(k))
      end do

      da(1) = da(2)
      dbb(1) = dbb(2)
      da(2) = da(3)
      dbb(2) = dbb(3)
      da(3) = da(4)
      dbb(3) = dbb(4)
      fn1 = acz + fl
      m = n - 10
      do k = 11,m
        km = n - k
        if( e*rad(km) > vr(km) ) exit
      end do
      ki = km + 1
      do k = 5, ki
        rp21 = ((e * rad(k)) - vr(k)) / cs
        rp12 = (- rp21) - (tcs * rad(k))
        akk = a(k - 4) + (ha1 * ((da(3) - (abz * da(2))) + da(1)))
        bkk = b(k - 4) + (ha1 * ((dbb(3) - (abz * dbb(2))) + dbb(1)))
        da(4) = (q11 * akk) + (rp12 * bkk)
        dbb(4) = (q22 * bkk) + (rp21 * akk)
        a(k) = a(k-1) + ha2*da(4) + ha3*da(3) - ha4*da(2) + ha5*da(1)
        b(k) = b(k-1) + ha2*dbb(4) + ha3*dbb(3) - ha4*dbb(2)+ha5*dbb(1)
        da(1) = da(2)
        dbb(1) = dbb(2)
        da(2) = da(3)
        dbb(2) = dbb(3)
        da(3) = (q11 * a(k)) + (rp12 * b(k))
        dbb(3) = (q22 * b(k)) + (rp21 * a(k))
        if( a(k)*a(k-1) < 0._db ) fn1 = fn1 + acz
      end do

      return 
      end

!***********************************************************************

! DIPOT COMPUTES THE SELF-CONSISTENT FIELD POTENTIAL FUNCTION FROM
! THE CHARGE DENSITY
! MODIFIED FOR RELATIVISTIC EXCHANGE...SEE 'SQK','QRELX'
! POINT ION ONLY OPTION FOR RHO(1).LT.0

      subroutine dipot(icheck,rho, rhu, ur, isw)

      use declarations
      implicit real(kind=db) (a-h,o-z)
      
      parameter(ndm=600)
      parameter(cl = 137.037, pi4 = 4. * pi)
      parameter(aaz = .333333, abz = 1.5, acz = 0.75, adz = 1., aez = 
     &   4., afz = 3., agz = .5, ahz = 0., aiz = .666667, epslol = 0.1)

      common/iblock/ n, j, nc1, npts, iout, idirc, jspn, last
      common/rblock/ rn, h, zeff, zn, xion, phi, eps, del, delrv,
     & xalph, xlatt, rnuc, convr, fn, fl, fj, e, q, ev, ez, ey, v0, et3,
     & summa, da(5), dbb(5), a0(15), b0(15), voc(5), anuc, sumel, zndif,
     & fdll, vs(ndm), vr(ndm), rh(ndm), a(ndm), b(ndm), rad(ndm),
     & y(ndm), rj(ndm), rhd(ndm), rbar, rba2, vbar, h3, fk, cs, g, q11,
     & q22, tcs, ex, ec, xte

      real(kind=db), dimension(15):: dc
      real(kind=db), dimension(30):: uerr
      real(kind=db), dimension(ndm):: c, rho, rhu, ur, y2

      equivalence (a0(1), dc(1)), (y(1), c(1))

      if(rho(1) <= ahz) then

        if(rho(2) <= ahz) then
          do k = 1, n
!   FUNNEL = 0 IF NO FUNNEL POTENTIAL
            ur(k) = - zn + funnel(rad(k),rbar,rba2,vbar)
          end do
        else
          ur(1:n) = rh(1:n)
        endif
        convr = ahz
        ev = ahz
        ey = ahz
        ez = ahz
!     NORMAL ENTRY
        goto 949

      endif

      nerro = 0
      do k = 1, n
        s2 = vr(k)
        vr(k) = vs(k)
        vs(k) = s2
      end do
      if (isw .gt. 1) goto 1007
      s2 = log(rho(2) / rho(1)) / h
      s3 = s2 + adz
      do k = 1,2
        r = rad(k)
        a(k) = (rho(k) * r) / s3
        b(k) = rho(k) / s2
        dbb(k) = h3 * rho(k)
        da(k) = dbb(k) * r
      end do
      nc = 0
      do k = 3,n
        r = rad(k)
        dbb(3) = h3 * rho(k)
        da(3) = dbb(3) * r
        a(k) = ((a(k - 2) + da(3)) + (aez * da(2))) + da(1)
        b(k) = ((b(k - 2) + dbb(3)) + (aez * dbb(2))) + dbb(1)
        if( r <= rnuc ) nc = k
        da(1) = da(2)
        dbb(1) = dbb(2)
        da(2) = da(3)
        dbb(2) = dbb(3)
      end do
      nc = nc + 1
!...RENORMALIZE TOTAL CHARGE
      q = a(n)
      ren = sumel / q
!...FORM AND SAVE COULOMB POTENTIAL...
      bn = b(n)
      do k = 1, n
        r = rad(k)
        if(r < rnuc ) then
          x = r / rnuc
          rvn = - ((zn * x) * (abz - ((agz * x) * x)))
        else
          rvn = - zn
          rho(k) = ren * rho(k)
        endif
        rhd(k) = (ren * (a(k) + (r * (bn - b(k))))) + rvn
      end do
      ev = diadl(rho,rhd,n,h,2,xp)

!.OPTION FOR FUNNEL POTENTIAL
      ez = - (zn * bn)
      do k = 1, n
! FUNNEL=0 IF NO FUNNEL POTENTIAL
        rshft = funnel(rad(k),rbar,rba2,vbar)
        rhd(k) = rhd(k) + rshft
        a(k) = rshft
      end do
      xte = diadl(rho,a,n,h,1,xp)
! INTERACTION POTENTIAL INSIDE NUCLEUS
      if (rnuc) 2, 2, 240
  240 kk = nc + 2
      s5 = s2 + afz
      do k = 1, 2
        rr3 = rho(k) * (rad(k) ** 3)
        c(k) = rr3 / s5
        dc(k) = h3 * rr3
      end do
      do k = 3, kk
        dc(3) = (h3 * rho(k)) * (rad(k) ** 3)
        c(k) = ((c(k - 2) + dc(3)) + (aez * dc(2))) + dc(1)
        dc(1) = dc(2)
        dc(2) = dc(3)
      end do
!...CUBIC INTERPOLATION
      anc = ahz
      bnc = ahz
      cnc = ahz
      do k = nc, kk
        rr3 = adz
        do i = nc, kk
          if( k /= i ) rr3 = rr3 * (rnuc - rad(i)) / (rad(k) - rad(i))
        end do
        anc = anc + (a(k) * rr3)
        bnc = bnc + (b(k) * rr3)
        cnc = cnc + (c(k) * rr3)
      end do

      ez = ez - zn * ( ( ( abz * anc / rnuc) - bnc )
     &               - ( agz * cnc / (rnuc**3) ) )

    2 do k = 1, n
        pi4r2 = pi4 * (rad(k) ** 2)
        rhok = rho(k) / pi4r2
        if( j <= jspn ) then
          spnk = 0.d0
        else
          spnk = (rho(k) - 2._db * rhu(k)) / pi4r2
        end if
        call xc(xalph, rhok, spnk, vxc1, vxc2, exc)
        y(k) = vxc1 * rad(k)
        y2(k) = vxc2 * rad(k)
        a(k) = rho(k) - rhu(k)
        b(k) = exc * rad(k)
      end do

      if (j .le. jspn) then
        ey = diadl(rho,y,n,h,2,xp)
      else
        ey = diadl(a,y,n,h,2,xp)
      end if
!      SEPARATION OF EXCHANGE AND CORR IN OLD VERSION
      ex = diadl(rho,b,n,h,2,xp)

 1007 if (isw .gt. 1) then
        do 330 k = 1, n
  330   y(k) = y2(k)
        ey = ey + diadl(rhu,y,n,h,2,xp)
      end if
!     ASSEMBLE POTENTIAL , LOCATE MAX ERROR
      epslo = ahz
      do k = 1, n
        rv = rhd(k) + y(k)
        error = abs(rv - ur(k))
        iflag = (k / 20) - ((k - 1) / 20)
        if ( icheck > 3 .and. iflag == 1 ) then
          iflag1 = k / 20
          uerr(iflag1) = rv - ur(k)
        endif
        if (error - epslo) 16, 16, 15
   15   epslo = error
        nerro = k
   16   ur(k) = rv
      end do
      convr = abs(epslo)
      if( icheck > 2 ) write(iout, fmt=20) epslo, nerro
      if ( icheck > 3 ) then
        write(iout, fmt=22) (uerr(k),k = 2, 15)
        write(iout, fmt=22) (ur(20 * k),k = 2, 15)
        if ( convr < delrv ) then
          write(iout, fmt=23) rhd
          write(iout, fmt=23) y
        endif
      endif

!     COMPUTE POTENTIAL EXPANSION COEFFICIENTS FOR SMALL R

      del = min((epslo * epslol) * epslol,epslol)

  949 ra = rad(1)
      rb = rad(2) / ra
      rc = rad(3) / ra

!     POINT NUCLEUS
      if (rnuc) 50, 50, 60
   50 voc(1) = - zn
      ta = ur(1) + zn
      tb = (ur(2) + zn) / rb
      tc = (ur(3) + zn) / rc

!     FINITE NUCLEUS

      goto 70
   60 voc(1) = ahz
      ta = ur(1)
      tb = ur(2) / rb
      tc = ur(3) / rc
   70 ra = adz
      deta = rb * rc * (rc - rb)
      detb = ra * rc * (ra - rc)
      detc = ra * rb * (rb - ra)
      det = deta + detb + detc
!     TEMPORARILY STORED IN VOC(5) UNTIL E CAN BE ADDED
      voc(5) = ( ta * deta + tb * detb + tc * detc ) / det
      deta = ra * ra
      detb = rb * rb
      detc = rc * rc
      voc(3) = ( ta * (detb - detc) + tb * (detc - deta) 
     &         + tc * (deta - detb) ) / det
      voc(4) = (ta * (rc - rb) + tb * (ra - rc) + tc * (rb - ra)) / det
      if( idirc /= 0 ) voc(1:5) = - voc(1:5) / cl

      if( icheck > 2 ) write(iout,21) voc(1), voc(5), voc(3:4)

      return 
   20 format(' MAX ERROR IN R.V(R) IS ** ',e10.2,' AT THE ',i4,
     &'TH POINT ')
   21 format(//' POTENTIAL EXPANSION COEFFICIENTS',/' V0C(1)= ',e18.8,
     &', V0C(2)= ',e18.8,', V0C(3)= ',e18.8,', V0C(4)= ',e18.8/)
   22 format(1x,15e8.1)
   23 format(6x,8e14.7)
      end

!***********************************************************************

!   CALCULATES FUNNEL POTENTIAL R*SHIFT

      function funnel(r, rbar, rba2, vbar)

      use declarations
      implicit real(kind=db) (a-h,o-z)
      
      parameter (ahz = 0., abz = 1.5, agz = 0.5)

      funnel = ahz
      if( (rbar .le. ahz) .or. (r .gt. rba2) ) return 
      funnel = vbar
      if (r > rbar) funnel = (((vbar * (r - rba2)) * (r - rba2)) * ((
     &r - (abz * rbar)) + (agz * rba2))) / (((rbar - rba2) * (rbar - 
     &rba2)) * ((agz * rba2) - (agz * rbar)))
      funnel = r * funnel

      return 
      end

!***********************************************************************

! BLOCKDATA LABELS FOR DIOUT AND DIDEN

      block data 

      use declarations
      implicit real(kind=db) (a-h,o-z)

      character(len=6), dimension(28):: alj
      character(len=6), dimension(22):: blj
      character(len=6), dimension(30):: clj

      common/labs/ alj, blj, clj

      data alj / ' 1S1/2', ' 2S1/2', ' 2P1/2', ' 2P3/2', ' 3S1/2', 
     &' 3P1/2', ' 3P3/2', ' 3D3/2', ' 3D5/2', ' 4S1/2', ' 4P1/2', 
     &' 4P3/2', ' 4D3/2', ' 4D5/2', ' 4F5/2', ' 4F7/2', ' 5S1/2', 
     &' 5P1/2', ' 5P3/2', ' 5D3/2', ' 5D5/2', ' 5F5/2', ' 5F7/2', 
     &' 5G7/2', ' 5G9/2', ' 6S1/2', ' 6P1/2', ' 6P3/2' /
      data blj / ' 6D3/2', ' 6D5/2', ' 6F5/2', ' 6F7/2', ' 6G7/2', 
     &' 6G9/2', ' 6H9/2', '6H11/2', ' 7S1/2', ' 7P1/2', ' 7P3/2', 
     &' 7D3/2', ' 7D5/2', ' 7F5/2', ' 7F7/2', ' 7G7/2', ' 7G9/2', 
     &' 7H9/2', '7H11/2', '7I11/2', '7I13/2', ' 8S1/2' /
      data clj / '1S', '2S', '2P', '3S', '3P', '3D', '4S', '4P', '4D', 
     &'4F', '5S', '5P', '5D', '5F', '5G', '6S', '6P', '6D', '6F', '6G', 
     &'6H', '7S', '7P', '7D', '7F', '7G', '7H', '7I', '8S', '8P' /

      end

!***********************************************************************

!  CONTROL SUBROUTINE FOR THE INTEGRATION OF THE DIRAC-SLATER EQUATIONS.
!  FINDS EIGENVALUES. NORMALIZES ORBITAL FUNCTIONS.

      subroutine didif(icheck)

      use declarations
      implicit real(kind=db) (a-h,o-z)
      
      parameter(ndm=600)
      parameter(ga1 = 251., ga2 = 646., ga3 = 264., ga4 = 106., ga5 = 
     &19., ga6 = 116., ga7 = 496., ga8 = 96., ga9 = 16., ga10 = 4., ga11
     & = 81., ga12 = 306., ga13 = 216., ga14 = 126., ga15 = 9., ga16 = 
     &56., ga17 = 256., ga18 = 96., ga19 = 256., ga20 = 56.)
      parameter(c = 137.037d0, acut = 1d-10)
      parameter(delt = 0.1, delk = 0.01, efac = 0.6)
      parameter(aaz = 1.2, abz = 0.5, acz = .1e-4, adz = 2., aez = 1., 
     &          afz = 0., agz = 2., ahz = 3., aiz = 1.e-33)

      common/ha/ ha1, ha2, ha3, ha4, ha5, ha6, ha7, ha8, ha9 
      common/iblock/ n, j, nc1, npts, iout, idirc, jspn, last
      common/rblock/ rn, h, zeff, zn, xion, phi, eps, del, delrv,
     & xalph, xlatt, rnuc, convr, fn, fl, fj, e, q, ev, ez, ey, v0, et3,
     & summa, da(5), dbb(5), a0(15), b0(15), voc(5), anuc, sumel, zndif,
     & fdll, vs(ndm), vr(ndm), rh(ndm), a(ndm), b(ndm), rad(ndm),
     & y(ndm), rj(ndm), rhd(ndm), rbar, rba2, vbar, h3, fk, cs, g, q11,
     & q22, tcs, ex, ec, xte

      eold = e
      ntest = 0
      fdll = delt * fdll
      etest = del * (aez - e)
      dels = max(fdll,etest)
      de = afz
      emin = (- ((abz * (aez + (zn / c))) * ((zn / fn) ** 2))) + vbar
      emax = - acz
      if( e > emax .or. e < emin ) e = abz * (emax + emin)
!   PREPARE CONSTANTS USED FOR THIS ORBITAL
      fk = adz * (fl - fj) * (fj + abz)
      cs = c
      tcs = c + c
      q21 = voc(1)
      g = sqrt((fk * fk) - (q21 * q21))
      q11 = - g - fk
      q22 = - g + fk
      if( fk < 0._db ) then
        a0(1) = g - fk
        b0(1) = q21
      else
        a0(1) = - q21
        b0(1) = g + fk
      endif
      dg = exp(h * g)

      rst = (rn ** g) / (dg ** n)
    1 call didf1(ki, fn1)
c  FN1 = NUMBER OF NODES + L+ 1. FN1 SHOULD EQUAL FN.
      if( icheck > 3 ) write(iout,18) fn, fl, fj, emin, e, emax
c  TOO MANY NODES.
      if (fn - fn1) 2, 4, 13
    2 if (e .lt. emax) emax = ((agz * emax) + e) / ahz
      dele = max(e,emin - e)
      e = e + (abz * dele)
      dl1 = abs(emax - emin) / (abs(e) + aez)
      if (dl1 - delk) 3, 1, 1
    3 if( icheck > 2 ) write(iout,15) fn1, fn, fl, fj, emin, e, emax
      emin = aaz * emin

c  CORRECT NUMBRR OF NODES
      goto 1
    4 ra = a(ki)
      rb = b(ki)
      do i = 1, ki
        a(i) = a(i) / ra
        b(i) = b(i) / ra
      end do
c  STARTS INWARD INTEGRATION. OUTER BOUNDARY CONDITION IS SET HERE.
      kj = ki + 4
      kk1 = ki + 4
      if (kk1 .gt. n) goto 1920
      do 401 k = kk1, n
      r = rad(k)
      if (eps + (r * ((e * r) - vr(k)))) 402, 401, 401
  401 kj = k
c  ISOLATED ATOM BOUNDARY CONDITIONS.
      kj = n
  402 rz = - (vr(kj) / r)
      do k = kj, n
        a(k) = afz
        b(k) = afz
      end do
      rl = (fl + abz) / r
      rk = fk / r
      p = (- (adz * (e + rz))) + (rl * rl)
      if( p < 0._db .and. icheck > 1 ) write(iout,19) 
      apa = - sqrt(p) + ((abz * (rz - (rl * rl))) / (r * p))
      a(kj) = aez
      b(kj) = (cs * (apa + rk)) / (- cs * tcs - e - rz)
      do l = 1,4
        k = kj - l
        a(k) = a(kj)
        b(k) = b(kj)
      end do

      do i = 1, 4
        k = kj + 1
        do l = 1, 5
          k = k - 1
          rp21 = ((e * rad(k)) - vr(k)) / cs
          rp12 = (- rp21) - (tcs * rad(k))
          da(l) = (q11 * a(k)) + (rp12 * b(k))
          dbb(l) = (q22 * b(k)) + (rp21 * a(k))
        end do
        a(kj-1) = a(kj) - ((ga1 * da(1) + ga2 * da(2) - ga3 * da(3) 
     &                    + ga4 * da(4) - ga5 * da(5)) * ha6)
        b(kj-1) = b(kj) - ((ga1 * dbb(1) + ga2 * dbb(2) - ga3 * dbb(3) 
     &                    + ga4 * dbb(4) - ga5 * dbb(5)) * ha6)
        a(kj-2) = a(kj) - ((ga6 * da(1) + ga7 * da(2) + ga8 * da(3) 
     &                    + ga9 * da(4) - ga10 * da(5)) * ha7)
        b(kj-2) = b(kj) - ((ga6 * dbb(1) + ga7 * dbb(2) + ga8 * dbb(3) 
     &                    + ga9 * dbb(4) - ga10 * dbb(5)) * ha7)
        a(kj-3) = a(kj) - ((ga11 * da(1) + ga12 * da(2) + ga13 * da(3)
     &                    + ga14 * da(4) - ga15 * da(5)) * ha8)
        b(kj-3) = b(kj) - ((ga11 * dbb(1) + ga12 * dbb(2) + ga13 *dbb(3)
     &                    + ga14 * dbb(4) - ga15 * dbb(5)) * ha8)
        a(kj-4) = a(kj) - ((ga16 * da(1) + ga17 * da(2) + ga18 * da(3)
     &                    + ga19 * da(4) + ga20 * da(5)) * ha9)
        b(kj-4) = b(kj) - ((ga16 * dbb(1) + ga17 * dbb(2) + ga18 *dbb(3)
     &                    + ga19 * dbb(4) + ga20 * dbb(5)) * ha9)
      end do

      k = kj - 3
      da(1) = da(2)
      dbb(1) = dbb(2)
      da(2) = da(3)
      dbb(2) = dbb(3)
      da(3) = da(4)
      dbb(3) = dbb(4)
  480 k = k - 1
      rp21 = ((e * rad(k)) - vr(k)) / cs
      rp12 = (- rp21) - (tcs * rad(k))
      akk = a(k + 4) - (ha1 * ((da(3) - (abz * da(2))) + da(1)))
      bkk = b(k + 4) - (ha1 * ((dbb(3) - (abz * dbb(2))) + dbb(1)))
      da(4) = (q11 * akk) + (rp12 * bkk)
      dbb(4) = (q22 * bkk) + (rp21 * akk)
      a(k) = (((a(k + 1) - (ha2 * da(4))) - (ha3 * da(3))) + (ha4 * da(2
     &))) - (ha5 * da(1))
      b(k) = (((b(k + 1) - (ha2 * dbb(4))) - (ha3 * dbb(3))) + (ha4 * 
     &dbb(2))) - (ha5 * dbb(1))
      da(1) = da(2)
      dbb(1) = dbb(2)
      da(2) = da(3)
      dbb(2) = dbb(3)
      da(3) = (q11 * a(k)) + (rp12 * b(k))
      dbb(3) = (q22 * b(k)) + (rp21 * a(k))
      if (k - ki) 490, 490, 480
  490 rc = a(ki)
      rb = rb / b(ki)
      do 5 k = ki, kj
      a(k) = a(k) / rc
    5 b(k) = b(k) / rc
      rg = rst
      do 6 k = 1, kj
      rg = rg * dg
      a(k) = a(k) * rg
    6 b(k) = b(k) * rg
      do 9 k = 1, n
    9 y(k) = (a(k) * a(k)) + (b(k) * b(k))
c...ESTIMATE CHANGE IN ENERGY FOR CONTINUOUS DERIVATIVE......
      w = diadl(rad,y,n,h,3,(adz * g) + aez)
      de = (((cs * a(ki)) * b(ki)) * (aez - ((rb * rc) / ra))) / w
  218 dl1 = abs(emax - emin) / (abs(e) + aez)
      dl = abs(de)
      dll = min(dl,- (abz * e))
      if ((dl .gt. delk) .and. (dl1 .lt. delk)) goto 12
      if (de) 250, 260, 240
  240 emin = e
      de = dll
      goto 260
  250 emax = ((agz * e) + emax) / ahz
      de = - dll
  260 e = e + de
      dell = del
      if( last /= 1 ) dell = max(dell,delt * abs(eold - e),dels)
      if( icheck > 3 ) write(iout,18) fn, fl, fj, emin, e,emax, de, dell 
      if(dl - dell) 10, 270, 270
  270 if(e - emax) 290, 290, 280
  280 e = abz * ((e - de) + emax)
  290 if(e - emin) 300, 1, 1
  300 e = abz * ((e - de) + emin)
c  ...NORMALIZE ORBITAL...
      goto 1
   10 x = aez / sqrt(w)
      npts = 0
      do 11 k = 1, n
      a(k) = a(k) * x
      if (abs(a(k)) .gt. acut) npts = npts + 1
   11 b(k) = b(k) * x
      fdll = abs(eold - e)
      v0 = x / ra
      return 
c===>REDUCE DE AND TRY AGAIN......
   12 if( icheck > 2 ) write(iout,16) fn, fl, fj, emin, e, emax, de
      de = abz * de

c  TOO FEW NODES
      goto 218
   13 if (e - emin) 330, 330, 320
  320 emin = e
  330 e = abz * (e + emax)
      dl1 = abs(emax - emin) / (abs(e) + aez)
      if (dl1 - delk) 14, 1, 1
   14 if( icheck > 2 ) write(iout,17) fn1, fn, fl, fj, emin, e, emax
      if( ntest /= 0 ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,30)
        end do
        stop
      endif 
      ntest = 1
      emax = - acz
      e = abz * (e + emax)

      goto 1
 1920 if( icheck > 1 ) write(iout,20) ki, n
      call write_error
      do ipr = 3,9,3
        write(ipr,20) ki, n
      end do
      stop 

   15 format(' TOO MANY NODES',4f4.1,3e15.7)
   16 format(' DE TOO LARGE',3f4.1,4e15.7)
   17 format(' TOO FEW NODES',4f4.1,3e15.7)
   18 format(3f5.1,e15.5,e19.9,e15.5,2e13.3)
   19 format(' THE TURNING POINT IS BEYOND RN. A LARGER VALUE OF RN',
     &       ' MAY BE NEEDED.')
   20 format(' NO ROOM FOR TAIL..',2i5)
   30 format(//' ntest /= 0')
      end

!**********************************************************************

!     SUBROUTINE FOR THE INTEGRATION OF THE HARTREE-FOCK-SLATER EQUATION
!     FINDS EIGENVALUES. NORMALIZES ORBITAL FUNCTIONS.
!     USES HAMMING'S PREDICTOR-CORRECTOR INTEGRATION SCHEME (MODIFIED)
!     MODIFIED FOR CONTINUUM STATES 1978....GREG BENESH...

      subroutine hsdif(icheck)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      parameter(ndm=600)
      parameter(delt = 0.01, delk = 0.01, efac = 0.6, acut = 1.e-10)
      parameter(aaz = 1., abz = 0.5, acz = 0.1e-4, adz = 1.2, aez = 2.
     &, afz = .1e-20, agz = .25, ahz = 0., aiz = 1.125, ajz = 0.125, 
     &xcut = 60., xtay = 1.e-30, akz = 24., alz = 9., amz = 19., anz = 
     &5., aoz = 3., apz = 4., abb = 1.02, fmodc = .92561983, fcorc = 
     &.07438017)
      parameter(epx = 625., smset = 1.e20)

      real(kind=db):: chi(ndm), chix(5), ax(5)

      common/ha/ ha1, ha2, ha3, ha4, ha5, ha6, ha7, ha8, ha9 
      common/iblock/ n, j, nc1, npts, iout, idirc, jspn, last
      common/rblock/ rn, h, zeff, zn, xion, phi, eps, del, delrv,
     & xalph, xlatt, rnuc, convr, fn, fl, fj, e, q, ev, ez, ey, v0, et3,
     & summa, da(5), dbb(5), a0(15), b0(15), voc(5), anuc, sumel, zndif,
     & fdll, vs(ndm), vr(ndm), rh(ndm), a(ndm), b(ndm), rad(ndm),
     & y(ndm), rj(ndm), rhd(ndm), rbar, rba2, vbar, h3, fk, cs, g, q11,
     & q22, tcs, ex, ec, xte

      de = ahz
      eold = e
      smin = smset
      niter = 0
c.....EXTRA SHIFT ACCOMODATES HYDROGENIC CASE.....
      emin = ((- (abz * ((zn / fn) ** 2))) + vbar) - abz
      emax = - acz
      flp = fl + aaz
      tlpo = flp + fl
      tflp = flp + flp
      nomax = (fn - flp) + acz
      cont = ahz
      if (emax - e) 115, 110, 100
  100 if (e - emin) 110, 120, 120
  110 e = abz * (emax + emin)
      goto 120

  115 cont = aaz
  120 a0(1) = aaz
      dg = exp(h * flp)
c===>BEGIN OUTWARD INTEGRATION....
      rst = (rn ** flp) / (dg ** n)
  140 ra = rad(1)
      iflag = 0
      voc(2) = voc(5) - (e * ra)
      do 1000 i = 1, 4
 1000 b0(i) = aez * voc(i)
      fis = aaz
      ffl = tflp
      do 1100 is = 1, 10
      suma = ahz
      ismx = min0(is,4)
      do it = 1, ismx
        itm = (is - it) + 1
        suma = suma + (b0(it) * a0(itm))
      end do
      a0(is + 1) = (ra * suma) / (fis * ffl)
      fis = fis + aaz
      ffl = ffl + aaz
 1100 continue
      do 1105 i = 1, n
      r = rad(i)
      b(i) = (aez * r) * (vr(i) - (r * e))
      if (cont .eq. ahz) goto 1105
      chi(i) = - ((fl * flp) + b(i))
 1105 continue
      do i = 1, 4
        r = rad(i)
        ta = r / ra
        suma = ahz
        sumb = ahz
        fis = ahz
        tpow = aaz
        do is = 1, 11
          suma = suma + (a0(is) * tpow)
          sumb = sumb + ((fis * a0(is)) * tpow)
          fis = fis + aaz
          tpow = tpow * ta
        end do
        a(i) = suma
        da(i) = sumb
        dbb(i) = (- (tlpo * da(i))) + (b(i) * a(i))
        end do
      nodes = 0
      m = n - 10
      do 1200 k = 11, m
      km = n - k
      if (b(km)) 1210, 1200, 1200
 1200 continue
 1210 if (cont == ahz) goto 1216
      nm3 = n - 3
      do is = 1, nm3
        if (chi(is) > ahz) exit
      end do
      do 1214 i = is, n
      if( chi(i) >= ahz ) goto 1214
      if( icheck > 3 ) write(iout,3000) i, chi(i)
 3000 format(' ]]]]] TP1 ',i5,e15.5)
      chi(i) = ahz
 1214 chi(i) = sqrt(chi(i))
      if( icheck > 3 ) write(iout,15) is, chi(is), rad(is)
      km = n - 1
 1216 ki = km + 1
      adif = ahz
      bdif = ahz
      do 1300 k = 5, ki
      r = rad(k)
      bpred = da(1) + (ha1 * ((dbb(4) - (abz * dbb(3))) + dbb(2)))
      apred = a(k - 4) + (ha1 * ((da(4) - (abz * da(3))) + da(2)))
      bmode = bpred + (fmodc * bdif)
      amode = apred + (fmodc * adif)
      fmode = (- (tlpo * bmode)) + (b(k) * amode)
      bcorr = ((aiz * da(4)) - (ajz * da(2))) + (ha2 * ((fmode + (aez * 
     &dbb(4))) - dbb(3)))
      acorr = ((aiz * a(k - 1)) - (ajz * a(k - 3))) + (ha2 * ((bmode + (
     &aez * da(4))) - da(3)))
      adif = acorr - apred
      bdif = bcorr - bpred
      a(k) = acorr - (fcorc * adif)
      da(5) = bcorr - (fcorc * bdif)
      dbb(5) = (- (tlpo * da(5))) + (b(k) * a(k))
      da(1) = da(2)
      da(2) = da(3)
      da(3) = da(4)
      da(4) = da(5)
      dbb(2) = dbb(3)
      dbb(3) = dbb(4)
      dbb(4) = dbb(5)
      asq = a(k) * a(k - 1)
      if (asq) 1220, 1300, 1300
 1220 nodes = nodes + 1
 1300 continue
c===>CONTINUUM STATE BY WKB ,FITTED TO OUTWARD INTEGRATION...
      if (cont .eq. ahz) goto 145
      b(is) = ahz
      b(is + 1) = (h / akz) * ((((alz * chi(is)) + (amz * chi(is + 1)))
     & - (anz * chi(is + 2))) + chi(is + 3))
      in = is + 2
      do 141 i = in, n
  141 b(i) = ((h / aoz) * ((chi(i - 2) + (apz * chi(i - 1))) + chi(i)))
     & + b(i - 2)
      do 130 i = is, n
      if (chi(i) .ge. ahz) goto 130
      if( icheck > 2 ) write(iout,3001) i, chi(i)
 3001 format(' ]]]]] TP2 ',i5,e15.5)
      chi(i) = ahz
  130 chi(i) = sqrt(chi(i) / rad(i))
      nm4 = n - 4
      do 143 i = is, nm4
      r1 = ((rad(i) ** flp) * a(i)) * chi(i)
      r2 = ((rad(i + 2) ** flp) * a(i + 2)) * chi(i + 2)
      dp = b(i + 2) - b(i)
      arg = atan((aaz / tan(dp)) - ((r2 / r1) / sin(dp)))
      beth = b(i) - arg
      facts = r1 / cos(b(i) - beth)
      i4 = i + 4
      sumsq = ahz
      rg = rst * (dg ** i)
      do 142 k = i, i4
      chix((k + 1) - i) = ((facts / chi(k)) * cos(b(k) - beth)) / rad(k)
      ax((k + 1) - i) = (rg * a(k)) / rad(k)
      rg = rg * dg
  142 sumsq = sumsq + ((chix((k + 1) - i) - ax((k + 1) - i)) ** 2)
      if (i .eq. is) goto 144
      if (sumsq .ge. smin) goto 143
  144 smin = sumsq
      fact = facts
      isi = i
      beta = beth
      argg = arg
      dpp = dp
      r11 = r1
      r21 = r2
  143 continue
      if( icheck > 3 ) then
        write(iout,11) r11, r21
        write(iout,12) fact, argg, dpp
        write(iout,14) beta, isi
      endif
      rg = rst * (dg ** isi)
      do 135 k = isi, n
  135 a(k) = (fact / chi(k)) * cos(b(k) - beta)
      kj = isi - 1
      goto 515
  145 if( icheck > 3 ) write(iout,18) fn, fl, emin, e, emax

c     TOO MANY NODES

      if (nomax - nodes) 200, 400, 300
  200 if (e - emax) 210, 220, 220
  210 emax = e
  220 e = e + (abz * max(e + e,emin - e))
      dl1 = abs(emax - emin) / (abs(e) + aaz)
c===>ERROR,TIGHT BOUNDS,BUT WRONG NR OF NODES....
      if (dl1 - delk) 230, 140, 140
  230 if( icheck > 2 ) write(iout,20) nodes, nomax
      if( icheck > 2 ) write(iout,18) fn, fl, emin, e, emax
      emin = adz * emin

c     TOO FEW NODES

      goto 140
  300 if (e - emin) 320, 320, 310
  310 emin = e
  320 e = abz * (e + emax)
      dl1 = abs(emax - emin) / (abs(e) + aaz)
      if (dl1 - delk) 330, 140, 140
  330 if( icheck > 2 ) write(iout, fmt=20) nodes, nomax
      if( icheck > 2 ) write(iout, fmt=18) fn, fl, emin, e, emax
      if (e .lt. (- acz)) goto 350
      if( icheck > 2 ) write(iout, fmt=19) fn, fl
      goto 700
  350 continue
      e = emax
c===>CORRECT NO.OF NODES. BEGIN INWARD INTEGRATION.
      goto 140
  400 ra = a(ki)
      rb = da(5)
      kj = (n - ki) - 4
      do 410 i = 1, kj
      k = (n + 1) - i
      if (epx - b(k)) 410, 410, 420
  410 a(k) = ahz
c===>AYMPTOTIC SOLUTION FOR OUTER 4 POINTS...
c===>CORR OCT79,NOTE R**(L+1) SCALING ON A(K)
c....AND DP/DT, WHERE T=LN(R)...............
  420 kj = k
      do 450 i = 1, 4
      if (b(k) .ge. ahz) goto 3002
      if( icheck > 2 ) write(iout, fmt=3003) k, b(k)
 3003 format(' ]]]]] TP3 ',i5,e15.5)
      b(k) = ahz
 3002 continue
      r = rad(k)
      alfr = sqrt(b(k))
      a(k) = exp(- alfr) / (r ** flp)
      da(i) = - ((flp + (alfr * r)) * a(k))
      dbb(i) = (- (tlpo * da(i))) + (b(k) * a(k))
      k = k - 1
  450 continue
      adif = ahz
      bdif = ahz
  460 bpred = da(1) - (ha1 * ((dbb(4) - (abz * dbb(3))) + dbb(2)))
      apred = a(k + 4) - (ha1 * ((da(4) - (abz * da(3))) + da(2)))
      bmode = bpred + (fmodc * bdif)
      amode = apred + (fmodc * adif)
      fmode = (- (tlpo * bmode)) + (b(k) * amode)
      bcorr = ((aiz * da(4)) - (ajz * da(2))) - (ha2 * ((fmode + (aez * 
     &dbb(4))) - dbb(3)))
      acorr = ((aiz * a(k + 1)) - (ajz * a(k + 3))) - (ha2 * ((bmode + (
     &aez * da(4))) - da(3)))
      adif = acorr - apred
      bdif = bcorr - bpred
      a(k) = acorr - (fcorc * adif)
      da(5) = bcorr - (fcorc * bdif)
      dbb(5) = (- (tlpo * da(5))) + (b(k) * a(k))
      if (k - ki) 500, 500, 470
  470 k = k - 1
      da(1) = da(2)
      da(2) = da(3)
      da(3) = da(4)
      da(4) = da(5)
      dbb(2) = dbb(3)
      dbb(3) = dbb(4)
      dbb(4) = dbb(5)
      goto 460
  500 ra = ra / a(ki)
      do 510 k = ki, kj
  510 a(k) = a(k) * ra
      rc = da(5) * ra
  515 rg = rst
      do 520 k = 1, kj
      rg = rg * dg
  520 a(k) = a(k) * rg
      do 560 k = 1, n
  560 y(k) = a(k) * a(k)
c===>CONTINUUM STATE NORMALIZED ON SPHERE RADIUS RBAR....
      if (cont .eq. ahz) goto 565
      do 562 k = 1, n
      if (rad(k) .lt. rbar) goto 562
      nrb = k
      goto 563
  562 continue
  563 w = diadl(rad,y,nrb,h,3,(aez * flp) + aaz)
      goto 700
  565 w = diadl(rad,y,n,h,3,(aez * flp) + aaz)
c===>SET NEW ENERGY AND ADJUST BOUNDS....
      de = - ((((abz * (rad(ki) ** fl)) * a(ki)) * (rc - rb)) / w)
      if (de) 600, 610, 590
  590 emin = e
      goto 610
  600 emax = e
  610 chkbd = abs(de) + (ajz * (e - acz))
      if (chkbd) 614, 614, 612
  612 iflag = 1
      if( icheck > 3 )  write(iout,21) fn, fl
c===>TEXT FOR ENERGY CONVERGENCE....
  614 e = e + de
      dell = del
      if (last .ne. 1) dell = max(dell,delt * abs(eold - e))
      if( icheck > 3 )  write(iout, fmt=18) fn, fl, emin, e, emax, 
     &de, dell
      if (e - emax) 640, 630, 630
  630 e = abz * ((e - de) + emax)
      if (iflag .eq. 1) e = (ajz * e) + ((aaz - ajz) * emax)
      goto 658
  640 if (e - emin) 650, 650, 658
  650 e = abz * ((e - de) + emin)
      goto 658
  658 niter = niter + 1
      if ((dell .gt. abs(de)) .and. (iflag .eq. 0)) goto 700
      if (niter .lt. 10) goto 140

c     NORMALIZE

      if( icheck > 2 ) write(iout,13) fn, fl, emin, e, emax
  700 continue
      if (w .gt. ahz) goto 3004
      if( icheck > 2 ) write(iout, fmt=3005) w
 3005 format(' ]]]]] TP4 ',e15.5)
      w = aaz
 3004 x = aaz / sqrt(w)
      npts = 0
      do 710 k = 1, n
      a(k) = a(k) * x
      if (abs(a(k)) .gt. acut) npts = npts + 1
  710 continue
      v0 = x
      fdll = abs(eold - e)

      return 
   11 format(' R1 AND R2 ARE',2f10.5)
   12 format(//' FACTS,ARG,DP ARE',3f10.5)
   13 format(' 10 E TRYALS EXCEEDED, PROCEEDING  ',2f5.1,4x,4e15.5)
   14 format(' THE FIRST BETH IS',f10.5,' AT I EQUAL TO',i5)
   15 format(' IS,CHI,RAD ARE',i5,2f10.7)
   18 format(2f4.1,4x,e15.5,e19.9,e15.5,e13.3,e13.3)
   19 format(2f4.1,'...LEVEL NOT BOUND,PROCEEDING..BEWARE')
   20 format(' EMAX-EMIN TOO SMALL, NUMBER OF NODES FOUND=',i5,
     &' NUMBER  NODES REQUIRED=',i5/)
   21 format(' *** DE LARGE ***   ',2f4.1)
      end

!***********************************************************************

      subroutine ucor(rs, s, uc1, uc2, ec)
 
      use declarations
      implicit real(kind=db) (a-h,o-z)

      parameter(third = .333333, fothi = 1.d0 + third)

      data ap / .0621814d0 /
      data xp0 / -.10498d0 /
      data bp / 3.72744d0 /
      data cp / 12.9352d0 /
      data qp / 6.1519908d0 /
      data cp1 / 1.2117833d0 /
      data cp2 / 1.1435257d0 /
      data cp3 / -.031167608d0 /
      data af / .0310907d0 /
      data xf0 / -.325d0 /
      data bf / 7.06042d0 /
      data cf / 18.0578d0 /
      data qf / 4.7309269d0 /
      data cf1 / 2.9847935d0 /
      data cf2 / 2.7100059d0 /
      data cf3 / -.1446006d0 /

      x = sqrt(rs)
      xpx = ((x * x) + (bp * x)) + cp
      xfx = ((x * x) + (bf * x)) + cf
      s4 = (s ** 4) - 1.
      fs = ((((1. + s) ** fothi) + ((1. - s) ** fothi)) - 2.) / ((2. ** 
     &fothi) - 2.)
      beta = 1. / (((2.74208 + (3.182 * x)) + ((.09873 * x) * x)) + (
     &.18268 * (x ** 3)))
      dfs = (fothi * (((1. + s) ** third) - ((1. - s) ** third))) / ((2.
     & ** fothi) - 2.)
      dbeta = - ((((.27402 * x) + .09873) + (1.591 / x)) * (beta ** 2))
      atnp = datan(qp / ((2. * x) + bp))
      atnf = datan(qf / ((2. * x) + bf))
      ecp = ap * ((log((x * x) / xpx) + (cp1 * atnp)) - (cp3 * (log(((x
     &    - xp0) ** 2) / xpx) + (cp2 * atnp))))
      ecf = af * ((log((x * x) / xfx) + (cf1 * atnf)) - (cf3 * (log(((x
     &    - xf0) ** 2) / xfx) + (cf2 * atnf))))
      ec = ecp + ((fs * (ecf - ecp)) * (1. + (s4 * beta)))
      tp1 = ((x * x) + (bp * x)) / xpx
      tf1 = ((x * x) + (bf * x)) / xfx
      ucp = ecp - ((ap / 3.) * ((1. - tp1) - (cp3 * (((x / (x - xp0)) - 
     &      tp1) - ((xp0 * x) / xpx)))))
      ucf = ecf - ((af / 3.) * ((1. - tf1) - (cf3 * (((x / (x - xf0)) - 
     &      tf1) - ((xf0 * x) / xfx)))))
      uc0 = ucp + ((ucf - ucp) * fs)
      uc10 = uc0 - (((ecf - ecp) * (s - 1.)) * dfs)
      uc20 = uc0 - (((ecf - ecp) * (s + 1.)) * dfs)
      duc = ((((ucf - ucp) * beta) * s4) * fs) + (((((ecf - ecp) * (- (
     &      rs / 3.))) * dbeta) * s4) * fs)
      duc1 = duc - ((((ecf - ecp) * beta) * (s - 1.)) * (((4. * (s ** 3)
     &       ) * fs) + (s4 * dfs)))
      duc2 = duc - ((((ecf - ecp) * beta) * (s + 1.)) * (((4. * (s ** 3)
     &      ) * fs) + (s4 * dfs)))
      uc1 = uc10 + duc1
      uc2 = uc20 + duc2

      return 
      end

!***********************************************************************

! INTEGRATES THE PRODUCT X*Y, OPTION TO CALC.END CORRECTION
! SIMPSON'S RULE INTEGRATION FROM R(1) TO INFINITY
! WEIGHTS H*(1 4 2 4 2 4 2 4 2 1)/3,INTEGRAND ASSUMED 0 PAST R(N)
! INTEGRAL 0 TO R(1) MAY BE OMITTED OR CALCULATED BY 1 TERM.
! EXPONENT MAY BE SPECIFIED,OR COMPUTED BY FIT HERE.

      function diadl(x, y, n, h, nmx, dx)

      use declarations
      implicit real(kind=db) (a-h,o-z)
 
      parameter (ff1 = 2._db,ff2 = 4._db,ff3 = 0._db,ff4 = 3._db)

      real(kind=db), dimension(n):: x, y

      goto (10, 20, 30), nmx
   10 beg = ff3
      goto 40
   20 dx = log( x(2) * y(2) / (x(1) * y(1)) ) / h
   30 beg = x(1) * y(1) / dx
   40 sa = ff3
      sb = ff3
      do k = 2, n, 2
        sa = sa + x(k-1) * y(k-1)
        sb = sb + x(k) * y(k)
      end do
      diadl = ((h * (ff1 * sa + ff2 * sb - x(1) * y(1))) / ff4) + beg

      return 
      end

! *********************************************************************

! INPUT ROUTINE FOR DIRAC PROGRAM
! FOR INPUT SPECIFICATIONS, SEE MAIN PROGRAM DIRAC

      subroutine dinpt(icheck,ph,Z,irel,n_orb,nqn,lqn,rqn,pop,ray,n_ray,
     &                 ray_max,h_ray)

      use declarations
      implicit real(kind=db) (a-h,o-z)
      parameter(ndm=600)

      integer:: Z 
      integer, dimension(nnlm):: lqn, nqn 
      real(kind=db), dimension(nnlm):: pop, rqn 
      real(kind=db), dimension(ndm):: ray 

      common/ha/ ha1, ha2, ha3, ha4, ha5, ha6, ha7, ha8, ha9 
      common/iblock/ n, j, nc1, npts, iout, idirc, jspn, last
      common/rblock/ rn, h, zeff, zn, xion, phi, eps, del, delrv,
     & xalph, xlatt, rnuc, convr, fn, fl, fj, e, q, ev, ez, ey, v0, et3,
     & summa, da(5), dbb(5), a0(15), b0(15), voc(5), anuc, sumel, zndif,
     & fdll, vs(ndm), vr(ndm), rh(ndm), a(ndm), b(ndm), rad(ndm),
     & y(ndm), rj(ndm), rhd(ndm), rbar, rba2, vbar, h3, fk, cs, g, q11,
     & q22, tcs, ex, ec, xte
      common/xnljez/ xn(nnlm), xl(nnlm), xj(nnlm), xe(nnlm), xz(nnlm),
     &               xdell(nnlm) 

      parameter (aaz = 0., abz = 60., acz = 32., adz = 0.3, aez = .25e4
     &, afz = .1d-6, agz = .1e-4, ahz = 1._db, aiz = 3., ajz = 8.,    !ERR
     &akz =1.125, alz = 2.375, amz = .625, anz = .125, aoz = 240., 
     &apz = 120., aqz = 80., arz = .208e-4, asz = .5, atz = 2.,   
     &auz = 33.,avz =.1)

      zn = 1._db * Z ! ATOMIC NUMBER
! IDIRC= ZERO FOR HARTREE-FOCK-SLATER, NONZERO FOR DIRAC-SLATER
      idirc = irel

      j = n_orb     ! NUMBER OF SHELLS

      nc1 = 199     ! MAXIMUM NUMBER OF CYCLES
      n = n_ray     ! NUMBER OF POINTS IN RADIAL MESH
      rn = ray_max  ! MAXIMUM RADIUS
      h = h_ray     ! INTERVAL OF LOGARITHMIC MESH
! ATOMIC WEIGHT, ANUC MUST BE SPECIFIED FOR PROPER VOLUME
! AVERAGING(DIDEN)
      anuc = 0._db 
      xion = 0._db   ! IONIC CHARGE

      voc(2) = aaz

! OPTION TO INSERT POTL WELL - VBAR NEGATIVE
      ph = 0.3     ! INITIAL DENSITY ITERATION AVERAGING FACTORS
      phi = 0.3    ! FINAL DENSITY ITERATION AVERAGING FACTORS
      eps = 0._db   ! PARAMETER USED TO DETERMINE THE PRACTICAL INFINETY
!                  OF EACH ORBITAL ( EXP(- SQRT(EPS)) IS SET TO ZERO)
      del = 0._db   ! ABSOLUTE ACCURACY CRITERIUM FOR EIGENVALUES
      delrv = 0._db ! ABSOLUTE ACCURACY CRITERIUM FOR POTENTIAL

!         PARAMETERS TO GENERATE EXTENDED BASIS SETS
      rbar = 0._db  ! RADIUS FOR THE POTENTIAL WELL  (ATOMIC UNITS )
      vbar = 0._db  ! VBAR = POTENTIAL WELL DEPTH        ( ATOMIC UNITS )
      rba2 = 0._db
      zndif = 0._db ! = ZN - ZNEF
! RBA2 IS OUTER LIMIT OF FUNNEL WELL,DEFAULT IS RN
! SET DEFAULT VALUES OF  MISSING PARAMETERS

      if( rn == 0._db ) rn = abz
      if( phi == 0._db ) then
        phi = adz
        ph = phi
      endif
      if( eps == 0._db ) eps = aez
      if( del == 0._db ) del = afz
      if( delrv <= aaz ) delrv = agz
      if( rba2 <= aaz ) rba2 = rn
! THE ABOVE VALUES OF N, RN,H, ETC. SUFFICE FOR MOST ATOMS AND IONS.
      if( h < agz ) h = auz - (avz * Z)
      if( icheck > 1 ) then
        write(iout,110) 
        write(iout,120) n, j, rn, h, zn, xion, anuc
      endif
      if( icheck > 2 ) then
        write(iout,130) 
        write(iout,140) ph, phi, eps, del, delrv
        write(iout,150) rbar, vbar, rba2, zndif
      endif

      rh(1:n) = aaz
      rj(1:n) = aaz
      jspn = 0
      if( jspn <= 0 ) jspn = j
      if( nc1 == 0 ) nc1 = 30
      if( icheck > 2 ) then
        write(iout,160) 
        write(iout,170) idirc, nc1, jspn
      endif

! XALPH = SLATER EXCHANGE COEFFICIENT
! XALPH = 2 GIVES HEDIN-LUNDQUIST EXCHANGE
      xalph = 2.01

! DEFINE H-CONSTANTS FOR DIFFER  START1,2  DIFF1,2
      h = ahz / h
      h3 = h / aiz
      ha1 = ajz * h3
      ha2 = akz * h3
      ha3 = alz * h3
      ha4 = amz * h3
      ha5 = anz * h3
      ha6 = h3 / aoz
      ha7 = h3 / apz
      ha8 = h3 / aqz
      ha9 = h3 / abz

! RNUC = NUCLEAR RADIUS IN BOHR RADII, IF SET TO 1. OR LARGER
!        RNUC IS COMPUTED AS  .0000208*ANUC**(1/3) Fermis
      rnuc = 0._db
      if( rnuc > 0._db ) then
        if( rnuc >= ahz ) rnuc = arz * (anuc ** (ahz / aiz))
        r = rn * exp(- (n - 3) * h)
        if( rnuc < r ) then
          if( icheck > 2 ) write(iout,180) 
        endif
      endif
      sum = aaz
      if( icheck > 2 ) then
        write(iout,190) xalph, rnuc
        write(iout,200)
      endif 
      zbar = zn

      do i = 1, j
! XN = RADIAL QUANTUM NUMBER
! XL = ORBITAL ANGULAR MOMENTUM (OF MAJOR COMPONENT IN DIRAC-S
! XJ = TOTAL ANGULAR MOMENTUM ( NOT USED IN H-F-S, READ ZERO)
! XE = ORBITAL ENERGY ( OR ESTIMATE) IN ATOMIC UNITS
! XZ = NUMBER OF ELECTRONS IN SHELL
! XDELL = ACCURACY ESTIMATE OF ORBITAL ENERGY( READ ZERO IF NOT K
        xn(i) = 1._db * nqn(i)   
        xl(i) = 1._db * lqn(i)   
        xj(i) = rqn(i)          
        xe(i) = 0._db            
        xz(i) = pop(i)          
        xdell(i) = 0._db         
        zbar = max( adz, zbar - xz(i) )
        if( abs(xe(i)) < afz ) xe(i) = - asz * (zbar / xn(i))**2 + vbar
        if( idirc == 0 ) xj(i) = aaz
        if( icheck > 2 ) write(iout,210) xn(i), xl(i), xj(i), xe(i),
     &                                  xz(i), xdell(i)
        if( xn(i) < ahz-eps6 ) exit
        sum = sum + xz(i)
        if( (xn(i) - xl(i)) < ahz-eps6 ) exit
        if( idirc == 0 ) cycle
        if( abs( abs(xl(i) - xj(i)) - asz ) > eps6 ) exit
        if( (atz * xj(i)) + ahz < xz(i)-eps6 ) exit
      end do

      if( i <= j ) then
        call write_error
        do ipr = 3,9,3
          write(ipr,220) i
          write(ipr,225) xn(i), xl(i)
          if( idirc /= 0 ) write(ipr,227) xj(i), xz(i)
        end do
        stop
      endif

      sumel = sum
      sum = zn - sum
      if( icheck > 2 ) write(iout,230) xion, sum
      xion = sum

!  RH(I),I=1,5  (5E14.7)
!     **  RH(I)= RADIAL CHARGE DENSITY IN THE I-TH POINT
!                IF RH(1) IS ZERO, CHARGE DENSITY IS ESTIMATED BY PROGRA
!                IF RH(1) IS NONZERO, READ 8
!                IF RH(1) NEGATIVE, HYDROGENIC POINT ION SOLVED.
!  RH(I),I=6,N  (5E14.7)   ONLY IF RH(1) IS NONZERO, SEE 8
!      read(unit=input, fmt=20) (rh(i),i = 1, 5)
!      if (rh(1)) 441, 450, 440
!  NOTE NEG. RH(1) INDICATES HYDROGENIC PROBLEM WANTED...
!  IF ALSO RH(2)<0 READ FULL POTENTIAL INSTEAD OF CHG.DENS.
!  441 if (rh(2) .ge. aaz) goto 450
!  440 read(unit=input, fmt=20) (rh(i),i = 6, n)
!      if( jspn >= j ) goto 450
!      rj(1:n) = aaz
!      read(unit=input, fmt=20) (rj(i),i = 1, 5)
!      if( rj(1) ) 445, 450, 445
!  445 read(unit=input, fmt=20) (rj(i),i = 6, n)
!  450 continue

      d = exp(h)
      r = rn / (d ** n)
      do k = 1, n
        r = r * d
        rad(k) = r
        vr(k) = aaz
        vs(k) = aaz
      end do
      ray(1:n) = rad(1:n)
      if( icheck > 2 ) write(iout,240) rad(1), d, rnuc
! ANALYTIC APPROXIMATION TO CHARGE DENSITY
      if( rh(1) == 0._db ) then
        a(1:j) = aaz
        njm = 0
        do k = 1, j
          b(k) = sqrt(ajz * abs(xe(k)))
          njm = atz * ( xn(k) - xl(k) ) + afz
          dfac = ahz
          do nk = 1, njm
            fnk = nk
            dfac = dfac * fnk
          end do
          a(k) = ( b(k)**(njm + 1) ) / dfac
        end do
        do i = 1, n
          rv = rad(i)
          sum = aaz
          dfac = aaz
          do k = 1, j
            val = rv * b(k)
            if( val >= acz ) cycle
            njm = atz * (xn(k) - xl(k)) + afz
            fnk = xz(k) * a(k) * exp(- val) * (rv ** njm)
            if( k > jspn ) dfac = dfac + fnk
            sum = sum + fnk
          end do
          rj(i) = dfac
          rh(i) = sum
        end do
      endif

! SET STARTING SPIN DENSITY = .5*CHARGE DENS.
      if( rj(1) == 0._db ) rj(1:n) = asz * rh(1:n)

      if( icheck > 3 ) then
        write(iout,250) 
        write(iout,260) (rh(i),i = 1, n)
        if( j <= jspn ) return 
        write(iout,250) 
        write(iout,260) (rj(i),i = 1, n)
      endif

      return 
  110 format(/'   N    J    RN      H     ZN    XION   ANUC')
  120 format(2i5,5f7.3)
  130 format('  PH   PHI     EPS        DEL        DELRVR')
  140 format(2f6.2,f12.2,2f12.8)
  150 format(/' PARAMTERS TO GENRT ADDTNL BASIS FNS ',
     &' RADIUS OF POTL WELL',f12.8,' ITS DEPTH',f12.8/,' CUTOFF', 
     & f12.8/,' ZNDIF = ZN - ZNEF =',f10.5)
  160 format('  DIRC CYCL' )
  170 format(5i5)
  180 format(/' LESS THAN THREE MESH POINTS INSIDE NUCLEUS')
  190 format('  XALPHA = ',e20.8,', RNUC = ',e20.8)
  200 format('   XN   XL   XJ      XE          XZ      XDELL')
  210 format(3f5.1,2f10.3,f10.5)
  220 format(//' Problem in Dirac routine ! :'//,
     &         ' ERROR ON EIGENVALUE CARD',i5)
  225 format(/' Check the values :'/,3x,' n = ',f7.3,/3x,' l = ',f7.3)
  227 format(/3x,' j = ',f7.3,/3x,' number of electron = ',f7.3)
  230 format(' XION was = ',f12.5,',and is = ',f12.5)
  240 format(' R(1) =',e15.7,', D =',e15.7,', RNUC =',e15.7)
  250 format(' CHARGE DENSITY')
  260 format(1x,8e15.7)
      end

!***********************************************************************

      subroutine xc(alfa, rho, spn, vxc1, vxc2, exc)

!       RHO =TOTAL ELECTRON DENSITY, SPN =SPIN DENSITY (RHO(1)-RHO(2))
!       VXC1,VXC2 = EXCHANGE POTENTIALS
!       EXC = EXCHANGE ENERGY DENSITY, TOTAL ENERGY CONTRIBUTION IS
!             OBTAINED BY THE INTEGRAL (RHO*EXC)
!.......CODE FOR SOME EXCHANGE-CORRELATION POTENTIALS AND ENERGIES
!         0 .LE. ALFA .LE.  1.   XALFA FOR ALFA
!                ALFA .EQ.  2.   VON BARTH - HEDIN
!                ALFA .EQ.  3.   VOSKO ET AL. - MANNINEN
!                ALFA .EQ. -1.   EXCHANGE ONLY
!                ALFA .LE. -2.   CORRELATION ONLY FOR ABS(ALFA)
!.......1985-11-06 T.T. RANTALA
!                 PI= 4.*DATAN(1.D0),         A= (4./9./PI)**THIRD

      use declarations
      implicit real(kind=db) (a-h,o-z)


!                 AA= 0.5**THIRD,           AA1= 1./AA
      parameter (a = 0.5210617624919189d0)
!                GAMMA= 4*AA/(3*(1-AA))
      parameter (aa = 0.7937005358554975d0, aa1 = 1.259921034225006d0)
      parameter (gamma = 5.129763111742258d0, third = .333333)
!......VON BARTH-HEDIN - HEDIN-LUNDQVIST PARAMETERS:
!     PARAMETER ( CP= 0.0504D0, RP= 30.D0, CF=0.0254,RF= 75.D0)
      parameter (pi75 = 0.75d0/pi, pia = pi * a)
!     PARAMETER ( CP= 0.0225D0, RP= 21.D0, CF= CP/2, RF= RP*2*AA1)
!     PARAMETER ( CP= 0.0368D0, RP= 21.D0, CF= CP/2, RF= RP*2*AA1)
      parameter (cp = 0.0225, rp = 21.d0, cf = cp/2, rf = 2*rp*aa1 )

!     VON BARTH-HEDIN - HEDIN-LUNDQVIST PARAMETERS IN AU:
!           removes some "0.5" calculations!!  
!      IF (RS.LE.0.) PRINT *,' *** WARNING: RS OUT OF RANGE ***'

      ff(z) = (1 + z**3) * log(1d0 + (1d0 / z))  + 0.5*z - z**2 - (1/3.)
      absxa = dabs(alfa)
      exc = 0.d0
      vxc1 = 0.d0
      vxc2 = 0.d0
      if( rho <= 0 ) return 
      s = spn / rho
! *********************************
! * * * EXCHANGE CONTRIBUTION * * *
! * * * A. PARAMAGNETIC

      rs = (pi75 / rho) ** third
      vxc1 = - (1 / (pia * rs))
      vxc2 = vxc1

! * * * B. FERROMAGNETIC
      exc = 0.75 * vxc1

      if (s .ne. 0.) then
        if (s .lt. (-1.)) s = -1.
        if (s .gt. 1.) s = 1.
        s1 = 1 + s
        s2 = 1 - s
        if ((s1 .le. 0) .or. (s2 .le. 0)) return 
        s13 = s1 ** third
        s23 = s2 ** third
        gs = ((s1 * s13) + (s2 * s23)) * 0.5
        vxc1 = vxc1 * s13
        vxc2 = vxc2 * s23
        exc = exc * gs
!   *  EXCHANGE ONLY OPTION
      end if

! ************************************
! * * * CORRELATION CONTRIBUTION * * *
!   *  CORRELATION ONLY OPTION
      if( (alfa < 0._db) .and. (absxa < 2._db) ) return 
      if( alfa < -1._db ) then
        vxc1 = 0.
        vxc2 = 0.
        exc = 0.
      end if

!   *  XALFA "CORRELATION"
      if (absxa < 2._db ) then
        xalfa = 1.5 * alfa
        vxc1 = xalfa * vxc1
        vxc2 = xalfa * vxc2
        exc = xalfa * exc
        return
      endif

! * * *  VON BARTH - HEDIN CORRELATION
! * * * A. PARAMAGNETIC

      if( absxa < 3._db ) then

        ecp = - (cp * ff(rs / rp))
!       VCP  = UCP
        ucp = - (cp * log(1 + (rp / rs)))
        exc = exc + ecp
        vxc1 = vxc1 + ucp

! * * * B. FERROMAGNETIC

        vxc2 = vxc2 + ucp
        if( s /= 0._db ) then
          ecf = - (cf * ff(rs / rf))
          ucf = - (cf * log(1 + (rf / rs)))
          decf = ecf - ecp
          vc = gamma * decf
          tc = (ucf - ucp) - ((4 * decf) / 3.)
          fx = (gs - 1) / (aa1 - 1)
          exc = exc + (decf * fx)
          vxc1 = (vxc1 + (vc * (s13 - 1))) + (tc * fx)
          vxc2 = (vxc2 + (vc * (s23 - 1))) + (tc * fx)
        end if

        return 
      endif

! * * *  VOSKO ET AL. - MANNINEN CORRELATION

      call ucor(rs, s, uc1, uc2, ec)
      exc = exc + ec * 0.5
      vxc1 = vxc1 + uc1 * 0.5
      vxc2 = vxc2 + uc2 * 0.5

      return 
      end

!***********************************************************************

      subroutine config(Z,irel,n_coeur,n_orb,nqn,lqn,rqn,nel)        
  
      use declarations
      implicit real(kind=db) (a-h,o-z)

      parameter(nzm=103)

      integer Z, n_orb, n_coeur
      integer, dimension(nnlm):: lqn, nqn 
      real(kind=db), dimension(nnlm):: nel, rqn 

      if( Z > nzm) then
        call write_error
        do ipr = 3,9,3
          write(ipr,110) Z, nzm
        end do
        stop
      endif

! modifications Oana

      n_coeur = n_orb_coeur(Z) 
      n_orb = n_orb_base(Z)

! fin modifications Oana

      do io = 1,n_orb
        ip = 0
        boucle_n: do n = 1,7
          do l = 0,n-1
            ip = ip + 1
            if( ip == io ) then
              nqn(io) = n 
              lqn(io) = l
              exit boucle_n
            endif  
          end do
        end do boucle_n
      end do

      Select Case(Z)
        Case(19,20)
          nqn(n_orb) = 4;   lqn(n_orb) = 0
        Case(21,22,23,24,25,26,27,28,29,30)
          nqn(n_orb-1) = 4; lqn(n_orb-1) = 0
          nqn(n_orb) = 3;   lqn(n_orb) = 2
        Case(37,38)
          nqn(n_orb) = 5; lqn(n_orb) = 0
        Case(39,40,41,42,43,44,45,46,47,48)
          nqn(n_orb-1) = 5; lqn(n_orb-1) = 0
          nqn(n_orb) = 4;   lqn(n_orb) = 2
        Case(49,50,51,52,53,54)          
          nqn(n_orb-1) = 5; lqn(n_orb-1) = 0
          nqn(n_orb) = 5;   lqn(n_orb) = 1
        Case(55,56)
          nqn(n_orb-2) = 5; lqn(n_orb-2) = 0
          nqn(n_orb-1) = 5; lqn(n_orb-1) = 1
          nqn(n_orb) = 6;   lqn(n_orb) = 0
        Case(57) ! La ne converge pas avec 4f1
          nqn(n_orb-3) = 5; lqn(n_orb-3) = 0
          nqn(n_orb-2) = 5; lqn(n_orb-2) = 1
          nqn(n_orb-1) = 6; lqn(n_orb-1) = 0
          nqn(n_orb) = 5;   lqn(n_orb) = 2
        Case(58,59,60,61,62,63,64,65,66,67,68,69,70,71) ! converge pas
          nqn(n_orb-4) = 5; lqn(n_orb-4) = 0            ! avec 5d0
          nqn(n_orb-3) = 5; lqn(n_orb-3) = 1
          nqn(n_orb-2) = 6; lqn(n_orb-2) = 0
          nqn(n_orb-1) = 5; lqn(n_orb-1) = 2
          nqn(n_orb) = 4; lqn(n_orb) = 3
        Case(72,73,74,75,76,77,78,79,80)
          nqn(n_orb-1) = 6; lqn(n_orb-1) = 0
          nqn(n_orb) = 5;   lqn(n_orb) = 2
        Case(81,82,83,84,85,86)
          nqn(n_orb-1) = 6; lqn(n_orb-1) = 0
          nqn(n_orb) = 6;   lqn(n_orb) = 1
        Case(87,88)
          nqn(n_orb-2) = 6; lqn(n_orb-2) = 0
          nqn(n_orb-1) = 6; lqn(n_orb-1) = 1
          nqn(n_orb) = 7;   lqn(n_orb) = 0
        Case(89)
          nqn(n_orb-3) = 6; lqn(n_orb-3) = 0
          nqn(n_orb-2) = 6; lqn(n_orb-2) = 1
          nqn(n_orb-1) = 7; lqn(n_orb-1) = 0
          nqn(n_orb) = 6; lqn(n_orb) = 2
        Case(90,91,92,93,94,95,96,97,98,99,100,101,102,103)
          nqn(n_orb-4) = 6; lqn(n_orb-4) = 0
          nqn(n_orb-3) = 6; lqn(n_orb-3) = 1
          nqn(n_orb-2) = 7; lqn(n_orb-2) = 0
          nqn(n_orb-1) = 6; lqn(n_orb-1) = 2
          nqn(n_orb) = 5;   lqn(n_orb) = 3
      end select

      nel(1:n_orb) = 4 * lqn(1:n_orb) + 2._db  ! orbitale pleine
      nel(n_orb) = nel(n_orb) + Z - sum( nel(1:n_orb) )

      if( Z > 57 .and. Z < 67 ) then
        nel(n_orb) = Z - 57._db 
        nel(n_orb-1) = 1._db 
      elseif( Z > 66 .and. Z < 72 ) then   
! 58:  5s5p6s ocup�es + 2 el sur 5d
        nel(n_orb) = Z - 58._db             
        nel(n_orb-1) = 2._db                
      elseif( Z > 89 .and. Z <= nzm ) then
        nel(n_orb) = Z - 89._db 
        nel(n_orb-1) = 1._db 
      endif

      if( irel == 1 ) then
        n_orb_rel = n_orb

        do io = 1,n_orb
          if( lqn(io) /= 0 ) n_orb_rel = n_orb_rel + 1
        end do 

! modification Oana: cas calcul atomique relativiste
        n_coeur_rel = n_coeur         
        do io = 1,n_coeur
          if( lqn(io) /= 0 ) n_coeur_rel = n_coeur_rel + 1
        end do 
        n_coeur = n_coeur_rel
! la boucle doit �tre plac�e avant le changement des configurations

! passage de la base l,s,ml,ms � l,s,j,mj

        jo = n_orb_rel + 1
        do io = n_orb,1,-1
          jo = jo - 1
          nqn(jo) = nqn(io)
          lqn(jo) = lqn(io)
          rqn(jo) = lqn(jo) + 0.5     ! mj
          if( lqn(jo) == 0 ) then
            nel(jo) = nel(io)
          elseif( nel(io) == 4 * lqn(io) + 2 ) then   ! cas d'une couche pleine
            nel(jo) = 2 * ( lqn(jo) + 1._db )
          else
            nel(jo) = ( (lqn(jo)+1.) / (2*lqn(jo)+1.) ) * nel(io) 
          endif  
          if( lqn(jo) == 0 ) cycle
          jo = jo - 1
          nqn(jo) = nqn(io)
          lqn(jo) = lqn(io)
          rqn(jo) = lqn(jo) - 0.5     ! mj
          if( nel(io) == 4 * lqn(io) + 2 ) then
            nel(jo) = 2._db * lqn(jo)
          else
            nel(jo) = nel(io) - nel(jo+1) 
          endif  
        end do
        n_orb = n_orb_rel
      endif 

      return
 110  format(//' Atomic number =',i6,' > ',i3,' in routine config !'//) 
      end


