! FDMNES subroutines
! Post treatment of the spectra calculated by FDMNES
! 1) Sommation with energy shift of varius spectra
! 2) Integration over the energy, that is convolution by
! a lorentzienne for XANES
!              L(x) = (1/(pi*b)) * 1 / ( 1 + ( (x-a)/b )**2 )lor

! or something similar for DAFS.

      subroutine convolution(conv_done,
     &           convolution_out,fit_cal,green_plus,ical,
     &           indice_par,iscratchconv,itape1,kw_conv,length_line,
     &           Length_word,ngroup_par,nkw_conv,nomfich,npar,
     &           nparm,param,typepar,ncal)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      parameter( Length15 = 15, nassm = 103 )

      character(len=1):: rep
      character(len=9):: keyword, mot9
      character(len=9), dimension(nkw_conv) :: kw_conv
      character(len=9), dimension(ngroup_par,nparm) :: typepar
      character(len=Length_word):: nomab, nomac
      character(len=132):: chemin, convolution_out, fichscanout,  
     &                     identmot, mot, mots, nomfich
      character(len=length_line):: motl
      character(len=Length15), dimension(:), allocatable:: nomxan,
     &                                                Title, word
      character(len=132), dimension(:), allocatable:: fichin, fichscanin

      complex(kind=db):: cf
      complex(kind=db), dimension(1):: cdum
      complex(kind=db), dimension(:), allocatable :: dampl, dph, dpht,
     &                                 phdtscan, f0, f0_th, f0scan
      complex(kind=db), dimension(:,:), allocatable :: Ad, Adafs,    
     &                                              Adafsm, As, Asm

      integer, dimension(ngroup_par) :: npar
      integer, dimension(ngroup_par,nparm) :: indice_par
      integer, dimension(:), allocatable:: i_done, ic, indf, ne, nphi,
     &                                     nsup

      logical arc, dafs, check_conv, chem, conv_done, cut, decferm,   
     &        En_fermi_man, En_fermi_new, energphot, Epsii_ref_man,
     &        extrap, Fermip, fit_cal, forbidden, fprim,
     &        fprime_atom, gamma, gamma_var, magn, no_extrap, no_normal,
     &        nxan_lib, Photo_emission, scan_true, seah, self_abs,
     &        Shift_auto,tenseur,tenseur_car, Thomson,
     &        green_plus
      logical, dimension(:), allocatable:: fichdone, run_done, Skip_run

      real(kind=db), dimension(ngroup_par,nparm) :: param 
      real(kind=db), dimension(:), allocatable:: angle, bb, betalor, 
     &      decal, e1, e2, Efermip, Elor, En_fermi, Energ, Ephoton,
     &      Epsii, Es, Eseuil, fi, fr, lori, lorix, lorr, Pds, p1f, p2f,   
     &      Tens, Yr, Yi
      real(kind=db), dimension(:,:), allocatable:: Ef, Xa, Xanes, Xs

! njp : Points au dela de la gamme pour diminuer les effets de bord de
! la convolution  
      parameter(njp=500)

      arc = .false.
      asea = 0.2_db  ! pente de gamma a l'origine
      chem = .false.
      check_conv = .false.
      convolution_out = ' '
      cut = .true.
      dafs = .false.
      decferm = .false.
      deltar = 0._db
      Ecent = 30._db
      Efermi = -5._db ! valeur par defaut utile pour les lectures de fichiers anciens
      Elarg = 30._db
      En_fermi_man = .false.
      En_fermi_new = .false.
      Epsii_ref_man = .false.
      Estart = 100000.
      eintmax = 1000000.
      Fermip = .false.
      forbidden = .false.
      fprim = .false.
      fprime_atom = .false.
      Gamma_hole = 0.
      gamma_var = .false.
      Gamma_max = 15._db
      igamhole = 0
      magn = .true.
      lseuil = 0
      nelor = 0
      ndafs = 0
      nfich = 0
      no_extrap = .false.
      nseuil = -1 
      nxan_lib = .false.
      Photo_emission = .false.
      S0_2 = 1._db
      scan_true = .false.
      seah = .false.
      self_abs = .false.
      Shift_auto = .true.
      tenseur = .false.
      tenseur_car = .false.
      Thomson = .false.
      no_normal = .false.
      vibration = 0._db

! -- Lecture --------------------------------------------

      Rewind(itape1)

      boucle_ii: do ii = 1,1000

        n = nnombre(itape1,132)
        read(itape1,'(A)',end=1010) mot

        keyword = identmot(mot,9)

        if( keyword == 'calculati' ) then
          nfich = 0
          do i = 1,1000
            n = nnombre(itape1,132)
            read(itape1,'(A)',end=1010) mots
            mot9 = identmot(mots,9)
            do j = 1,nkw_conv
              if( mot9 == kw_conv(j) ) exit boucle_ii
            end do
            if( mot9 == 'run_done' ) exit boucle_ii
            if( n == 0 ) nfich = nfich + 1
          end do
        endif

      end do boucle_ii

 1010 rewind(itape1)

      allocate( run_done(nfich) )
      allocate( skip_run(nfich) )
      allocate( i_done(nfich) )
      run_done(:) = .false.
      Skip_run(:) = .false.
      do ifich = 1,nfich
        i_done(ifich) = ifich
      end do
      mfich = nfich

      do ii = 1,1000
        n = nnombre(itape1,132)
        read(itape1,'(A)',err=1015,end=1015) mot
        keyword = identmot(mot,9)
        k = 0
        if( keyword == 'run_done' ) then
          do i = 1,mfich
            read(itape1,*,err=1015,end=1015) j, is
            if( j == 0 ) then
              run_done(i) = .true.
            else
              k = k + 1
              if( is == 0 ) Skip_run(k) = .true.
            endif
            if( run_done(i) ) then
              nfich = nfich - 1
              do j = i+1,mfich
                i_done(j) = i_done(j) - 1
              end do
            endif
          end do
          exit
        endif
      end do

 1015 rewind(itape1)

      if( nfich == 0 ) then
        nfich = 1
        mfich = 1
        allocate( fichin(nfich) )
        mot = ' '
        mot = nomfich
        l = len_trim(mot)
        mot(l+1:l+4) = '.txt'
        fichin(1) = mot
      else
        allocate( fichin(nfich) )
      endif

      allocate( decal(nfich) )
      allocate( Efermip(nfich) )
      allocate( En_fermi(nfich) )
      allocate( Epsii(nfich) )
      allocate( Eseuil(nfich) )
      allocate( fichscanin(nfich) )
      allocate( ne(nfich) ) 
      allocate( nsup(nfich) )
      allocate( Pds(nfich) ) 

      Pds(1) = 1.
      decal(1) = 0.
      Efermip(1) = 0.
      Epsii(:) = 0._db

      if( ncal > 1 .and. ical == 1 ) then
        do jfich = 1,mfich
          iscr = 100 + jfich
          open( iscr, status = 'scratch' )
        end do
      endif

      long = 0
      do ii = 1,1000

        n = nnombre(itape1,132)
        read(itape1,'(A)',end=1020) mot

        keyword = identmot(mot,9)

        select case(keyword)

          case('run_done')
            exit

          case('calculati')

            ifich = 0
            do i = 1,mfich
              n = nnombre(itape1,132)
              if( run_done(i) ) then
                read(itape1,*)                
                n = nnombre(itape1,132)
                if( n /= 0 ) read(itape1,*)
                cycle
              endif
              ifich = ifich + 1
              read(itape1,'(A)') fichin(ifich)
              fichin(ifich) = adjustl( fichin(ifich) )
              n = nnombre(itape1,132)
              if( n == 0 ) then
                Pds(ifich) = 1.
                decal(ifich) = 0.
              elseif( n == 1 ) then
                read(itape1,*,err=9999) Pds(ifich)
                decal(ifich) = 0.
              elseif( n == 2 ) then
                read(itape1,*,err=9999) Pds(ifich), decal(ifich)
                Shift_auto = .false.
              else
                Fermip = .true.
                read(itape1,*,err=9999) Pds(ifich), decal(ifich),
     &                                  Efermip(ifich)
                Shift_auto = .false.
              endif
            end do

          case('check_con')
            check_conv = .true.

          case('conv_out')

            n = nnombre(itape1,132)
            read(itape1,'(A)') convolution_out
            convolution_out = adjustl( convolution_out )

          case('gaussian')

            n = nnombre(itape1,132)
            if( n == 1 ) then
              read(itape1,*,err=9999) deltar
              vibration = 0._db
            else
              read(itape1,*,err=9999) deltar, vibration
            endif

          case('fprime')

            fprim = .true.

          case('forbidden')

            forbidden = .true.

          case('estart')

            n = nnombre(itape1,132)
            read(itape1,*,err=9999) Estart

          case('scan')

            scan_true = .true.
            do ifich = 1,nfich
              n = nnombre(itape1,132)
              read(itape1,'(A)') fichscanin(ifich)
              fichscanin(ifich) = adjustl( fichscanin(ifich) )
            end do
            read(itape1,'(A)') fichscanout
            fichscanout = adjustl( fichscanout )

          case('directory')

            chem = .true.
            n = nnombre(itape1,132)
            read(itape1,'(A)') chemin
            chemin = chemin

          case('nocut' )

            cut = .false.

          case('seah')

            seah = .true.
            n = nnombre(itape1,132)
            select case(n)
              case(0)
                continue
              case(1)
                read(itape1,*,err=9999) asea
              case(2)
                read(itape1,*,err=9999) asea, Gamma_max
              case(3)
                read(itape1,*,err=9999) asea, Gamma_max, Gamma_hole
                igamhole = 1
              case default
                read(itape1,*,err=9999) asea, Gamma_max, Gamma_hole,
     &                                  Efermi
                igamhole = 1
                En_fermi_man = .true.
            end select

          case('convoluti')

            arc = .true.
            n = nnombre(itape1,132)
            select case(n)
              case(0)
                continue
              case(1)
                read(itape1,*,err=9999) Ecent
              case(2)
                read(itape1,*,err=9999) Ecent, Elarg
              case(3)
                read(itape1,*,err=9999) Ecent, Elarg, Gamma_max
              case(4)
                read(itape1,*,err=9999) Ecent, Elarg, Gamma_max,
     &                                  Gamma_hole
                igamhole = 1
              case default
                read(itape1,*,err=9999) Ecent, Elarg, Gamma_max,
     &                                  Gamma_hole, Efermi
                igamhole = 1
                En_fermi_man = .true.
            end select

          case('table')

            n = nnombre(itape1,132)
            if( n == 1 ) read(itape1,*)
            nelor = 0
            do ie = 1,10000
              n = nnombre(itape1,132)
              if( n == 0 ) exit
              read(itape1,*)
              nelor = nelor + 1 
            end do
            rewind(itape1)
            do i = 1,10000
              read(itape1,'(A)') mots
              mot9 = identmot(mots,9) 
              if( mot9 == 'table' ) exit
            end do 
            n = nnombre(itape1,132)
            if( n == 1 ) then
              read(itape1,*,err=9999) Efermi
              En_fermi_man = .true.
            endif
            allocate( Elor(nelor) )
            allocate( betalor(nelor) )
            do ie = 1,nelor
              n = nnombre(itape1,132)
              read(itape1,*,err=9999) Elor(ie), betalor(ie) 
            end do
            Elor(:) = Elor(:) / rydb
            betalor(:) = betalor(:) / rydb

          case('eintmax')

            n = nnombre(itape1,132)
            read(itape1,*,err=9999) eintmax

          case('efermi')

            n = nnombre(itape1,132)
            read(itape1,*,err=9999) Efermi
            En_fermi_man = .true.

          case('ecent')

            n = nnombre(itape1,132)
            read(itape1,*,err=9999) Ecent

          case('elarg')

            n = nnombre(itape1,132)
            read(itape1,*,err=9999) Elarg

          case('gamma_hol')

            n = nnombre(itape1,132)
            igamhole = 1
            read(itape1,*,err=9999) Gamma_hole 

          case('gamma_max')

            n = nnombre(itape1,132)
            read(itape1,*,err=9999) Gamma_max 

          case('gamma_fix')
            gamma_var = .false.

          case('gamma_var')
            gamma_var = .true.

! Pour faire le decallage avant la convolution.
          case('dec')

            decferm = .true. 

          case('no_extrap')

            no_extrap = .true.

          case('no_normal')

            no_normal = .true.

          case('fprime_at')

            fprime_atom = .true.

          case('nxan_lib')

            nxan_lib = .true. 

          case('thomson')

            Thomson = .true. 
            ndafs_th = nnombre(itape1,Length_line) / 2
            allocate( fr(ndafs_th) )
            allocate( fi(ndafs_th) )
            allocate( f0_th(ndafs_th) )
            read(itape1,*,err=9999) (fr(ipl), fi(ipl), ipl = 1,ndafs_th)
            f0_th(:) = cmplx( fr(:), fi(:),db) 
            deallocate( fr )
            deallocate( fi )

          case('s0_2')

            read(itape1,*,err=9999)  S0_2
 
          case('photo_emi')

            Photo_emission = .true. 

          case('epsii')
            n = nnombre(itape4,132)
            read(itape1,*,err=9999) Epsii_ref
            Epsii_ref = abs( Epsii_ref )
            Epsii_ref_man = .true.

          case default

            call write_error
            do ipr = 6,9,3
              write(ipr,110) mot
            end do
            stop

        end select

      end do
 1020 continue

      if( chem ) then
        long = len_trim(chemin)
        do ifich = 1,nfich
          mot = fichin(ifich)
          longf = len_trim(mot)
          fichin(ifich) = chemin(1:long) // mot(1:longf)
        end do
        if( convolution_out /= ' ' ) then
          longf = len_trim(convolution_out)
          convolution_out = chemin(1:long) // convolution_out(1:longf)
        endif
        if( scan_true ) then
          do ifich = 1,nfich
            mot = fichscanin(ifich)
            longf = len_trim(mot)
            fichscanin(ifich) = chemin(1:long) // mot(1:longf)
          end do
          if( convolution_out /= ' ' ) then
            longf = len_trim(fichscanout)
            fichscanout = chemin(1:long) // fichscanout(1:longf)
          endif
        endif
      endif

      if( convolution_out == ' ' ) then
        if( nomfich == 'fdmnes_out' ) then
          mot = fichin(1)
          l = len_trim(mot) - 3
          if( mot(l-2:l-2) == '_' ) then
            l = l - 2
          elseif( mot(l-3:l-3) == '_' ) then
            l = l - 3
          endif
        else
          mot = nomfich
          l = len_trim(mot) + 1
        endif
        mot(l:l+8) = '_conv.txt'
        convolution_out = mot
        if( scan_true ) then
          mot(l:l+13) = '_scan_conv.txt'
          fichscanout = mot
        endif
      endif

      if( .not. ( seah .or. arc ) .and. nelor == 0 ) then
        nelor = 1
        allocate( Elor(nelor) )
        allocate( betalor(nelor) )
        Elor(1) = 0._db
        betalor(1) = 0._db
      endif

      do ifich = 1,nfich
        if( convolution_out /= fichin(ifich) ) cycle
        write(6,120) 
        read(5,*) rep
        if( rep /= 'y' .and. rep /= 'Y' .and. rep /= 'o' .and.
     &      rep /= 'O' ) stop
      end do
      
! -- Dimensionnement des tableaux -------------------------------------

      do ifich = 1,nfich
        open(2, file = fichin(ifich), status='old', iostat=istat) 
        if( istat /= 0 ) call write_open_error(fichin(ifich),istat,1)
        n = nnombre(2,132)
        v0muf = 10._db 
        Select case(n)
          Case(1)
            read(2,*) Eseuil(ifich)
            numat = 1
          Case(2)
            read(2,*) Eseuil(ifich), numat
          Case(4)
            read(2,*) Eseuil(ifich), numat, nseuil, lseuil
          Case(5)
            read(2,*) Eseuil(ifich), numat, nseuil, lseuil, v0muf
          Case(6)
            read(2,*) Eseuil(ifich), numat, nseuil, lseuil,
     &                fpp_avantseuil, v0muf
            self_abs = .true.
          Case(7)
            read(2,*) Eseuil(ifich), numat, nseuil, lseuil,
     &                fpp_avantseuil, v0muf, En_fermi(ifich)
            En_fermi_new = .true.
            if( fpp_avantseuil > 1.e-10_db ) self_abs = .true.
          Case(8)
            read(2,*) Eseuil(ifich), numat, nseuil, lseuil,
     &                fpp_avantseuil, v0muf, En_fermi(ifich),
     &                Epsii(ifich)
            En_fermi_new = .true.
            if( fpp_avantseuil > 1.e-10_db ) self_abs = .true.
        end select
        n = nnombre(2,Length_line)
        if( n > 0 ) then
          ndafs = n / 2
          read(2,*)
          read(2,*) 
        endif
        read(2,'(10x,a13)') nomab
        nt = nnombre(2,Length_line) - 1
        if( n > 0 ) then
          nxan = nt - 2 * ndafs
          if( self_abs ) then
            nplr = nxan - 2 * ndafs
          else
            nplr = nxan
          endif
        else
          nomab = adjustl( nomab )
          if( nomab(1:5) == 'D(00)' ) then
            tenseur = .true.
          elseif( nomab(1:5) == 'D_xx_r' ) then
            tenseur = .true.
            tenseur_car = .true.
          endif
          if( tenseur ) then
            fprim = .true.
            nxan = 0
          endif
          if( tenseur_car ) then
            if( nt == 6 .or. nt == 27 .or. nt == 45 ) then
              magn = .false.
              ndafs = nt 
            else
              magn = .true.
              ndafs = nt / 2 
            endif
          elseif( tenseur ) then
            magn = .false.
            ndafs = nt
          else
            nxan = nt
          endif
          nplr = nxan
        endif 

        if( ifich == 1 ) then
          nxan1 = nxan
          ndafs1 = ndafs
        else
          if( nxan_lib ) nxan = min(nxan1,nxan)
          if( nxan1 /= nxan .or. ndafs1 /= ndafs ) then
            call write_error
            do ipr = 6,9,3
              write(ipr,130) nxan1, ndafs1, ifich, nxan, ndafs
            end do
            stop
          endif
        endif

        do ie = 1,10000
          Read(2,*,err=1030,end=1030) eph
          if( ie == 1 ) eph1 = eph
          if( eph > eintmax ) exit
        end do
 1030   ne(ifich) = ie - 1

        if( eph > Eseuil(ifich) ) then
          Estartm = Estart + Eseuil(ifich)
        else
          Estartm = Estart
        endif
        if( eph1 > Estartm - 1.e-10_db ) then
          pasdeb = 0.5_db
          nsup(ifich) = nint( ( eph1 - Estartm ) / pasdeb )
          ne(ifich) = ne(ifich) + nsup(ifich)
        else
          nsup(ifich) = 0
        endif 

        if( ne(ifich) < 2 ) then
          call write_error
          do ipr = 6,9,3
            write(ipr,140) fichin(ifich)
          end do
          stop
        endif
        Close(2)
      end do

      nemax = maxval( ne )

      if( .not. ( lseuil == 0 .or. ( lseuil == 1 .and. numat > 48 ) ) )
     &   no_extrap = .true.

      if( nseuil > -1 .and. igamhole == 0 ) 
     &          call tab_width(Eseuil(1),Gamma_hole,lseuil,nseuil,numat)

! Modification en cas de fit.
      if( fit_cal ) then

        do igr = 2,ngroup_par
          istop = 0
          do ipar = 1,npar(igr)
            if( typepar(igr,ipar) /= 'shift' .and.
     &          typepar(igr,ipar) /= 'weight' ) cycle
            if( indice_par(igr,ipar) > nfich ) then
              call write_error
              do ipr = 6,9,3
                write(ipr,145) typepar(igr,ipar), indice_par(igr,ipar),
     &                         nfich
              end do
              istop = 1
             endif
          end do
        end do
        if( istop == 1 ) stop

        do igr = 2,ngroup_par
          do ipar = 1,npar(igr)
            select case( typepar(igr,ipar) )
              case('aseah')
                asea = param(igr,ipar)
              case('ecent')
                Ecent = param(igr,ipar)
              case('gaussian')
                deltar = param(igr,ipar)
              case('vibr')
                vibration = param(igr,ipar)
              case('elarg')
                Elarg = param(igr,ipar)
              case('gamma_max')
                Gamma_max = param(igr,ipar)
              case('gamma_hol')
                Gamma_hole = param(igr,ipar)
              case('efermi')
                Efermi = param(igr,ipar)
                En_fermi_man = .true.
              case('shift')
                if( .not. run_done( indice_par(igr,ipar) ) ) then
                  ifich = i_done( indice_par(igr,ipar) )
                  decal( ifich ) = param(igr,ipar)
                  Shift_auto = .false.
                endif
              case('weight')
                if( .not. run_done( indice_par(igr,ipar) ) ) then
                  ifich = i_done( indice_par(igr,ipar) )
                  Pds( ifich ) = param(igr,ipar)
                endif
            end select
          end do
        end do
      endif

      deallocate( i_done )

      Esmin = Eseuil(1)
      do ifich = 2,nfich
        Esmin = min( Esmin, Eseuil(ifich) )
      end do
      do ifich = 1,nfich
        decal(ifich) = decal(ifich) + Eseuil(ifich) - Esmin
      end do

      if( Epsii_ref_man ) then
        Epsii_moy = Epsii_ref
      elseif( Shift_auto ) then
        Epsii_moy = sum( Epsii(:) ) / nfich
      endif
      if( Epsii_ref_man .or. Shift_auto ) then
        do ifich = 1,nfich
          decal(ifich) = decal(ifich) + Epsii(ifich) - Epsii_moy
        end do
      endif

      if( tenseur .and. magn ) then
        allocate( nomxan(0:nxan+4*ndafs) )
      elseif( tenseur .and. .not. magn ) then
        allocate( nomxan(0:nxan+2*ndafs) )
      elseif( fprim ) then
        allocate( nomxan(0:nxan+3*ndafs) )
      else
        allocate( nomxan(0:nxan+ndafs) )
      endif

      if( ndafs > 0 ) then
        dafs = .true.
        allocate( dph(ndafs) )
        allocate( dpht(ndafs) )
        dpht(:) = (0._db,0._db)            
        allocate( fr(ndafs) ); allocate( fi(ndafs) )
        allocate( f0(ndafs) )
        allocate( nphi(ndafs) )

        if( Thomson ) then
          n = min( ndafs, ndafs_th )
          f0(1:n) = f0_th(1:n)
          deallocate( f0_th )
        else  
          f0(:) = (0._db, 0._db )
          Pdt = 0._db
          do ifich = 1,nfich
            if( Skip_run(ifich) ) cycle
            open(2, file = fichin(ifich), status='old', iostat=istat) 
            if( istat /= 0) call write_open_error(fichin(ifich),istat,1)
            read(2,*)
            n = nnombre(2,Length_line)
            if( n > 0 ) then
              read(2,*) ( fr(ipl), fi(ipl), ipl = 1,ndafs )
              f0(:) = f0(:) + Pds(ifich) * cmplx( fr(:), fi(:),db) 
              Pdt = Pdt + Pds(ifich) 
            endif
            Close(2)
          end do
          if( abs(Pdt) > 1e-10_db ) f0(:) = f0(:) / Pdt 
        endif

      endif

      deltar = deltar / sqrt( 8 * log(2._db) )
      vibration = vibration / sqrt( 8 * log(2._db) )

      Efermi = Efermi / rydb
      if( En_fermi_new ) En_fermi(:) = En_fermi(:) / rydb
      Esmin = Esmin / rydb
      Epsii(:) = Epsii(:) / rydb
      Eseuil(:) = Eseuil(:) / rydb
      v0muf = v0muf / rydb
      Gamma_max = Gamma_max / rydb
      Gamma_hole = Gamma_hole / rydb
      deltar = deltar / rydb
      if( arc ) then
        Ecent = Ecent / rydb
        Elarg = Elarg / rydb
      endif
      decal(1:nfich) = decal(1:nfich) / rydb
      if( Fermip ) Efermip(1:nfich) = Efermip(1:nfich) / rydb

      if( .not. arc .and. .not. seah ) then
        if( En_fermi_new .and. .not. En_fermi_man ) then
          Elor(:) = Elor(:) - En_fermi(1)
        else
          Elor(:) = Elor(:) - Efermi
        endif
      endif

! Elaboration de la grille en energie

      allocate( Ef(nemax,nfich) )

      do ifich = 1,nfich
        open(2, file = fichin(ifich), status='old', iostat=istat) 
        if( istat /= 0 ) call write_open_error(fichin(ifich),istat,1)
        read(2,*)
        n = nnombre(2,Length_line)
        if( n > 0 ) then
          read(2,*)
          read(2,*)
        endif
        read(2,*)  
        do ie = nsup(ifich)+1,ne(ifich)
          Read(2,*) Ef(ie,ifich)
        end do
        do ie = nsup(ifich),1,-1
          Ef(ie,ifich) = Ef(ie+1,ifich) - pasdeb
        end do
        Ef(1:ne(ifich),ifich) = Ef(1:ne(ifich),ifich) / rydb
        Close(2)
      end do

      energphot = .false.
      do ifich = 1,nfich
        if( Ef(ne(ifich),ifich) <= Eseuil(ifich) ) cycle
        energphot = .true.
        Ef(1:ne(ifich),ifich) = Ef(1:ne(ifich),ifich) - Eseuil(ifich)
      end do

      do ifich = 1,nfich
        Ef(1:ne(ifich),ifich) = Ef(1:ne(ifich),ifich) + decal(ifich)
      end do

! Pour les seuils L23 ou M45, on prend l'union et pas l'intersection
      do ifich = 2,nfich
        if( abs( Eseuil(ifich) - Eseuil(1) ) < 0.1_db ) cycle 
        cut = .false.
        exit
      end do

      Emin = Ef(1,1)
      Emax = Ef(ne(1),1)
      if( cut ) then
        do ifich = 2,nfich
          Emin = max( Ef(1,ifich), Emin )
          Emax = min( Ef(ne(ifich),ifich), Emax )
        end do
      else
        do ifich = 2,nfich
          Emin = min( Ef(1,ifich), Emin )
          Emax = max( Ef(ne(ifich),ifich), Emax )
        end do
      endif

      allocate( fichdone(nfich) )

      nes = 10000

      do i = 1,2

        fichdone(:) = .false.

        do ifich = 1,nfich
          if( abs( Ef(1,ifich) - Emin ) < 1.e-10_db ) exit 
        end do
        ifichref = ifich
        fichdone(ifichref) = .true.

        je = 0
        do ie = 1,nes
          je = je + 1
          E = Ef(je,ifichref)
          if( i == 2 ) Es(ie) = E
          if( E > Emax - 1.e-10_db ) exit
          if( je == ne(ifichref) ) then 
            do ifich = 1,nfich
              if( Ef(ne(ifich),ifich) > E + 1.e-10_db ) then
                do je = ne(ifich),1,-1
                  if( Ef(je,ifich) < E - 1.e-10_db ) exit
                end do 
                ifichref = ifich
                fichdone(ifichref) = .true.
                exit
              endif  
            end do
          endif  
          do ifich = 1,nfich
            if( fichdone(ifich) ) cycle
            if( E > Ef(1,ifich) + 1.e-10_db ) then
              do je = 1,ne(ifich)
                if( Ef(je,ifich) > E + 1.e-10_db ) exit
              end do 
              je = je - 1
              ifichref = ifich
              fichdone(ifichref) = .true.
              exit
            endif
          end do
        end do

        if( i == 1 ) then
          if( E > Emax + 1.e-10_db ) then
            nes = ie - 1
          else
            nes = ie
          endif
          allocate( Es(nes) )
        endif

      end do

      deallocate( fichdone )

      if( nes == 0 ) then
        call write_error
        do ipr = 6,9,3
          write(ipr,147) 
        end do
        stop
      endif

! La preparation est terminee.

      ifich = 0
      do jfich = 1,mfich
        if( run_done(jfich) ) cycle
        ifich = ifich + 1

        nenerg = ne(ifich) 

        if( .not. scan_true ) then
          allocate( Adafs(nenerg,ndafs) )
          if( tenseur .and. magn ) allocate( Adafsm(nenerg,ndafs) )
        endif 
        allocate( Xanes(nenerg,nxan) )
 
        if( Fermip ) then
          EFermi = Efermip(ifich)
        elseif( En_fermi_new .and. .not. En_fermi_man ) then
          EFermi = En_fermi(ifich)
        endif 

! -- Lecture -----------------------------------------------------------

        open(2, file = fichin(ifich), status='old', iostat=istat) 
        if( istat /= 0 ) call write_open_error(fichin(ifich),istat,1)
 
        read(2,*)
 
        n = nnombre(2,Length_line)
        if( n > 0 ) then
          read(2,*) ( fr(ipl), fi(ipl), ipl = 1,ndafs )
          read(2,*) ( fr(ipl), fi(ipl), ipl = 1,ndafs)
          dph(:) = cmplx( fr(:), fi(:),db )
          dpht(:) = dpht(:) + Pds(ifich) * dph(:)
        elseif( tenseur ) then
          f0(:) = ( 0._db, 0._db ) 
          dph(:) = ( 0._db, 0._db )
          dph(1) = ( 1._db, 0._db )
          if( tenseur_car ) then
            dph(4) = ( 1._db, 0._db )
            dph(6) = ( 1._db, 0._db )
          endif 
          dpht(:) = dpht(:) + Pds(ifich) * dph(:)
        endif

        read(2,'(A)') motl
        n_dim = 1 + nxan + 2 * ndafs
        n_word = n_dim 
        allocate( word(n_dim) )

        call extract_word(length_line,Length15,motl,word,n_word,
     &                    n_dim)

        if( self_abs ) then
          nomxan(0:nplr) = word(1:nplr+1)
          j = nplr
          k = nplr
          do ipldafs = 1,ndafs
            do i = 1,4
              j = j + 1
              if( i == 2 ) cycle
              k = k + 1
              nomxan(k) = word(j+1)
            end do
          end do
        else
          nomxan(0:nxan) = word(1:nxan+1)
          if( ndafs > 0 ) then
            if( tenseur .and. .not. magn) then
              nomxan(nxan+1:nxan+ndafs) = word(nxan+2:nxan+ndafs+1) 
            else
              do i = 1,ndafs
                nomxan(nxan+i) = word(nxan+1+2*i) 
              end do
            endif
          endif
        endif
        deallocate( word )

        allocate( Energ(nenerg) )

        if( dafs ) then

          nphi(:) = 1

          if( .not. scan_true ) Adafs = (0._db,0._db)
          if( tenseur .and. magn ) Adafsm = (0._db,0._db) 
          do ie = nsup(ifich)+1,nenerg
            if( tenseur .and. .not. magn ) then
              Read(2,*) Energ(ie), (fr(ipl), ipl = 1,ndafs)
              if( .not. scan_true ) Adafs(ie,:) = cmplx(fr(:), 0._db,db)
            elseif( nxan > 0 ) then
              if( self_abs ) then
                Read(2,*) Energ(ie), ( Xanes(ie,ipl), ipl = 1,nplr ),  
     &            ( fr(ipl), fi(ipl), Xanes(ie,nplr+2*ipl-1), 
     &              Xanes(ie,nplr+2*ipl), ipl = 1,ndafs )
              else
                Read(2,*) Energ(ie), ( Xanes(ie,ipl), ipl = 1,nxan ),  
     &            ( fr(ipl), fi(ipl), ipl = 1,ndafs )
              endif
              if( .not. scan_true ) Adafs(ie,:) = cmplx(fr(:), fi(:),db)
            else
              if( self_abs ) then
                Read(2,*) Energ(ie),  
     &            ( fr(ipl), fi(ipl), Xanes(ie,2*ipl-1), 
     &              Xanes(ie,2*ipl), ipl = 1,ndafs )
              else
                Read(2,*) Energ(ie), ( fr(ipl), fi(ipl), ipl = 1,ndafs )
              endif
              if( .not. scan_true ) Adafs(ie,:) = cmplx(fr(:), fi(:),db)
            endif
          end do

        else

          do ie = nsup(ifich)+1,nenerg
            Read(2,*) Energ(ie), ( Xanes(ie,ipl), ipl = 1,nxan )
          end do

        endif

        close(2)

        do ie = nsup(ifich),1,-1
          Energ(ie) = Energ(ie+1) - pasdeb
        end do

        nf0 = 1
        if( scan_true ) then
          open(2, file = fichscanin(ifich), status='old', iostat=istat) 
          if( istat /= 0 )
     &      call write_open_error(fichscanin(ifich),istat,1)
          ndafst = 0
          n = nnombre(2,Length_line)
          do ipl = 1,ndafs
            if( n == 1 ) then
              read(2,*) nphi(ipl)
            else
              read(2,*) nphi(ipl), nf0
            endif
            ndafst = ndafst + nphi(ipl)
          end do

          if( ifich == 1 ) then
            nphim = nphi(1)
            do ipl = 2,ndafs
              nphim= max( nphim, nphi(ipl) )
            end do
            allocate( angle(nphim) )
            allocate( f0scan(ndafst) )
            allocate( phdtscan(ndafst) )
          endif

          allocate( Adafs(nenerg,ndafst) )
          if( tenseur .and. magn ) allocate( Adafsm(nenerg,ndafst) )

          Adafs = (0._db,0._db)
          if( tenseur .and. magn ) Adafsm = (0._db,0._db)
          do ie = nsup(ifich)+1,nenerg
            read(2,*)
            jpl = 0
            do ipl = 1,ndafs
              read(2,*)
              do i = 1,nphi(ipl)
                jpl = jpl + 1
                if( nf0 == 1 .or. nphi(ipl) == 1 ) then
                  read(2,*) angle(i), a, b
                  a1 = 0._db; b1 = 0._db
                  a2 = 1._db; b2 = 0._db
                else
                  read(2,*) angle(i), a, b, a1, b1, a2, b2
                endif
                Adafs(ie,jpl) = cmplx( a, b,db)
                f0scan(jpl) = cmplx( a1, b1,db)
                phdtscan(jpl) = cmplx( a2, b2,db)
              end do
            end do
          end do
          close(2)

        else

          ndafst = ndafs

        endif

        Energ(:) = Energ(:) / rydb

        if( Energ(nenerg) > Eseuil(ifich) )
     &               Energ(1:nenerg) = Energ(1:nenerg) - Eseuil(ifich)
        if( decferm ) Energ(1:nenerg) = Energ(1:nenerg) + decal(ifich)

        if( ifich == 1 ) then
          allocate( p1f(nes) )
          allocate( p2f(nes) )
          allocate( indf(nes) )
        endif
        do ie = 1,nes
          if( decferm ) then
            E = Es(ie)
          else
            E = Es(ie) - decal(ifich)
          endif
          E = max(E ,Energ(1) )
          E = min(E ,Energ(nenerg) )
          do i = 2,nenerg
            if( Energ(i) > E - 1.e-10_db ) exit
          end do
          p1 = ( E - Energ(i-1) ) / ( Energ(i) - Energ(i-1) )
          p2 = 1 - p1
          p1f(ie) = Pds(ifich) * p1
          p2f(ie) = Pds(ifich) * p2
          indf(ie) = i
        end do

        if( ifich == 1 ) then
          allocate( Xs(nes,nxan) )
          Xs(:,:) = 0._db
          if( dafs ) then
            allocate( As(nes,ndafst) ) 
            As(:,:) = (0._db,0._db)
            if( tenseur .and. magn ) then
              allocate( Asm(nes,ndafst) ) 
              Asm(:,:) = (0._db,0._db)
            endif
          endif
        endif

        if( conv_done .or. Skip_run(ifich) ) goto 1040

        nenerge = nenerg + njp
        allocate( Ad(nenerg,ndafst) )
        allocate( Xa(nenerge,nxan) )

        if( seah .or. arc ) then
          nelor = nenerg
          allocate( Elor(nelor) )
          allocate( betalor(nelor) )
          Elor(:) = Energ(:)
        endif

        if( Photo_emission ) then 
          betalor(:) = 0._db
        elseif( seah ) then 
          call seahdench(asea,Efermi,Gamma_max,nelor,Elor,betalor)
        elseif( arc ) then
          call gammarc(Ecent,Elarg,Gamma_max,Efermi,nelor,Elor,betalor)
        endif

        betalor(:) = betalor(:) + Gamma_hole

        if( ifich == 1 ) then
          if( check_conv ) then
            Open(3, file = 'fdm_gamma.txt')
            ipr1 = 3
          else
            ipr1 = 6
          endif
          if( ncal == 1 ) then
            ipr2 = 6
          else
            ipr2 = 3
          endif
          do ipr = ipr1,ipr2,3
            if( seah ) then
              Write(ipr,*) ' Seah-Dench model'
              Write(ipr,150) asea, Gamma_max*rydb, Efermi*rydb
            elseif( arc ) then
              Write(ipr,*) ' Arctangent model'
              Write(ipr,160) Ecent*rydb, Elarg*rydb, Gamma_max*rydb
            endif
            Write(ipr,170) Gamma_hole*rydb, Efermi*rydb 
          end do
          de_obj = ( Elor(nelor) - Elor(1) ) / 15
          E_obj = Elor(1) - 0.00001_db 
          do ie = 1,nelor
            E = Elor(ie) - v0muf
            Gamm = betalor(ie) - Gamma_hole 
            if( Gamm > 0._db ) then
              alambda = sqrt( 2 / ( sqrt( E**2 + Gamm**2 ) - E ) ) 
            else
              alambda = 100000._db / bohr
            endif
            do ipr = ipr1,ipr2,3
              if( ipr == 6 ) then
                if( Elor(ie) < E_obj .and. ie /= nelor ) cycle
                E_obj = E_obj + de_obj
              endif
              Write(ipr,180) Elor(ie) * Rydb, betalor(ie) * Rydb, 
     &                       alambda * bohr
            end do
          end do
          if( check_conv ) Close(3)
        else
          Write(6,190) Gamma_hole*rydb, Efermi*rydb, ifich 
        endif

        allocate( dampl(nenerg) )

        allocate( bb(nenerge) )
        allocate( Ephoton(nenerge) )
        allocate( e1(nenerge) )
        allocate( e2(nenerge) )
        Ephoton(:) = 0._db
        allocate( lori(nenerge) )
        allocate( lorix(nenerge) )
        if( dafs ) allocate( lorr(nenerge) )

        call cflor(bb,betalor,Efermi,Ephoton,Elor,Energ,ie1,ie2,nef,
     &                 nelor,nenerg,nenerge,Photo_emission)
        Ephoton(:) = Ephoton(:) + Eseuil(ifich)

        extrap = .false.
        if( dafs ) then
          if( .not. no_extrap ) then
            do ipl = 1,ndafs
              if( abs( dph(ipl) ) > 1.e-10_db ) then
                extrap = .true.
                exit
              endif
            end do
          endif
        endif

        if( extrap .or. fprime_atom) call extrapat(bb(nenerg),
     &        convolution_out,dampl,Energ,Eseuil(ifich),extrap,fpp0,
     &        fprime_atom,numat,nenerg)

! Convolution par la lorentzienne

        if( dafs ) Ad(1:nenerg,1:ndafst) = Adafs(1:nenerg,1:ndafst)

        do ipl = 1,nxan
          Xa(1:nenerg,ipl) = Xanes(1:nenerg,ipl)
! Extrapolation
          do ie = nenerg+1,nenerge 
            Xa(ie,ipl) = Xa(nenerg,ipl)
          end do
        end do

        gamma = .false.
        do ie = nef,nenerge
          if( abs( bb(ie) ) > 1.e-10_db ) then
            gamma = .true.
            exit
          endif
        end do

        ne2 = ie2

        do ie = ie1,ie2
          if( ie == ie1 ) then
            if( Photo_emission ) then
              e1(ie) = 1.5 * Ephoton(1) - 0.5 * Ephoton(2)
            else
              e1(ie) = Efermi + Eseuil(ifich)
              if( decferm ) e1(ie) = e1(ie) + decal(ifich)
              if( ie == 1 ) then
                e1m = 1.5 * Ephoton(1) - 0.5 * Ephoton(2)
                e1(ie) = max( e1(ie), e1m )
              endif
            endif
          else
            e1(ie) = 0.5 * ( Ephoton(ie) + Ephoton(ie-1) )
          endif
          if( ie == ne2 ) then
            e2(ie) = 1.5 * Ephoton(ne2) - 0.5 * Ephoton(ne2-1)
          else 
            e2(ie) = 0.5 * ( Ephoton(ie) + Ephoton(ie+1) )
          endif
        end do

        if( Photo_emission ) then
          nen2 = ie2
        else
          nen2 = nenerg
        endif

        if( gamma ) then

          do ie = 1,nenerg
  
            do j = ie1,ne2

              if( .not. Gamma_var ) then 
                bba = bb(ie)
                if( bba >= 0._db ) then
                  bbb = max( bba, 1.E-08_db )
                else
                  bbb = bba
                endif
                de2 = ( e2(j) - Ephoton(ie) ) / bbb
                de1 = ( e1(j) - Ephoton(ie) ) / bbb
                lorix(j) = atan( de1 ) - atan( de2 )
              endif
              if( dafs .or. Gamma_var ) then 
                bba = bb(j)
                if( bba >= 0._db ) then
                  bbb = max( bba, 1.E-08_db )
                else
                  bbb = bba
                endif
                de2 = ( e2(j) - Ephoton(ie) ) / bbb
                de1 = ( e1(j) - Ephoton(ie) ) / bbb
                lori(j) = atan( de1 ) - atan( de2 )
                if( Gamma_var ) lorix(j) = lori(j)
                if( dafs .and. j <= nenerg )
     &            lorr(j) = 0.5 * log( (1 + de1**2) / (1 + de2**2) )
              endif
            end do

            do ipl = 1,nxan
              Xanes(ie,ipl) = - sum( lorix(ie1:ne2)
     &                      * Xa(ie1:ne2,ipl) ) / pi
              write(98,*) Xanes(ie,ipl)   ! erreur MPI 
            end do

            if( .not. green_plus ) lori(ie1:nen2) = - lori(ie1:nen2) 

            if( tenseur ) then
              do ipl = 1,ndafst
                Adafs(ie,ipl) = sum( 
     &                  cmplx( lorr(ie1:nen2), lori(ie1:nen2),db ) 
     &                 * real( Ad(ie1:nen2,ipl),db ) )
                if( magn ) Adafsm(ie,ipl) = sum( 
     &                  cmplx( lorr(ie1:nen2), lori(ie1:nen2),db ) 
     &                 * aimag( Ad(ie1:nen2,ipl) ) )
!!!                write(98,*) Adafs(ie,ipl)   ! erreur MPI 
              end do
            else
              do ipl = 1,ndafst
                Adafs(ie,ipl) = sum( 
     &                      cmplx(lorr(ie1:nen2),lori(ie1:nen2),db)
     &                    * Ad(ie1:nen2,ipl) )
!!!                write(98,*) Adafs(ie,ipl)   ! erreur MPI 
              end do
            endif

! On passe en convention cristallo avec f" positif (equivaut a Green_moins)
            if( green_plus ) then
              do ipl = 1,ndafst
                Adafs(ie,ipl) = conjg( Adafs(ie,ipl) )
                if( tenseur .and. magn ) Adafsm(ie,ipl)
     &                                       = conjg( Adafsm(ie,ipl) ) 
              end do
            endif

          end do

        else

          if( dafs ) then

            do ie = 1,nenerg

              do j = ie1,nen2
                de2 = e2(j) - Ephoton(ie)
                de1 = e1(j) - Ephoton(ie)
                if( j == ie ) then
                  if( abs( de2 + de1 ) < 1.e-10_db ) then
                    lorr(j) = 0._db     
                  elseif( abs( de1 ) < 1.e-10_db ) then
                    lorr(j) = - log( 4._db )     
                  else
                    lorr(j) = log( - de1 / de2 )
                  endif
                else
                  lorr(j) = log( de1 / de2 ) 
                endif
              end do

              if( tenseur ) then
                do ipl = 1,ndafst
                  Adafs(ie,ipl) =
     &          sum( lorr(ie1:nen2) * real( Ad(ie1:nen2,ipl),db ) ) 
                  if( ie >= ie1 ) Adafs(ie,ipl) = Adafs(ie,ipl)
     &                     + img * pi * real( Ad(ie,ipl),db )
                  if( magn ) Adafsm(ie,ipl) =
     &              sum( lorr(ie1:nen2) * aimag( Ad(ie1:nen2,ipl) ) ) 
                  if( ie >= ie1 .and. magn ) Adafsm(ie,ipl) 
     &                     = Adafsm(ie,ipl) 
     &                     + img * pi * aimag( Ad(ie,ipl) )
                end do
              else
                do ipl = 1,ndafst
                  Adafs(ie,ipl) =
     &                     sum( lorr(ie1:nen2) * Ad(ie1:nen2,ipl) ) 
                  if( ie >= ie1 ) Adafs(ie,ipl) = Adafs(ie,ipl)
     &                                          + img * pi * Ad(ie,ipl)
                end do
              endif

            end do

          endif

          if( Photo_emission ) then
            do ipl = 1,nxan
              Xanes(nef+1:nenerg,ipl) = 0._db
            end do
          else
            do ipl = 1,nxan
              Xanes(1:nef-1,ipl) = 0._db
            end do
          endif

        endif 

        if( extrap ) then
          jpl = 0
          do ipl = 1,ndafs
            do iphi = 1,nphi(ipl)
              jpl = jpl + 1
              if( iphi == 1 ) then
                cf = dph(ipl)
              else
                cf = phdtscan(jpl)
              endif
              do ie = 1,nenerg
                Adafs(ie,jpl) = Adafs(ie,jpl)
     &                        + ( dampl(ie) + img * fpp0 ) * cf
              end do
            end do 
          end do 
        endif 

        if( ncal > 1 ) then
          iscr = 100 + jfich
          rewind( iscr )
          do ie = 1,nenerg
            write(iscr,*) Xanes(ie,1:nxan)
          end do
          if( dafs ) then
            do ie = 1,nenerg
              write(iscr,*) Adafs(ie,1:ndafst)
            end do
          endif
          if( tenseur .and. magn ) then
            do ie = 1,nenerg
              write(iscr,*) Adafsm(ie,1:ndafst)
            end do
          endif
        endif

        deallocate( Ad )
        deallocate( bb )
        deallocate( dampl )
        deallocate( Ephoton )
        deallocate( e1 )
        deallocate( e2 )
        deallocate( lori )
        deallocate( lorix )
        if( dafs ) deallocate( lorr )
        deallocate( Xa )
        if( seah .or. arc ) then
          deallocate( Elor )
          deallocate( betalor )
        endif

 1040   if( conv_done .or. Skip_run(ifich)  ) then
          iscr = 100 + jfich
          rewind( iscr )
          do ie = 1,nenerg
            read(iscr,*) Xanes(ie,1:nxan)
          end do
          if( dafs ) then
            do ie = 1,nenerg
              read(iscr,*) Adafs(ie,1:ndafst)
            end do
          endif
          if( tenseur .and. magn ) then
            do ie = 1,nenerg
              read(iscr,*) Adafsm(ie,1:ndafst)
            end do
          endif
        endif

        do ie = 1,nes
          i = indf(ie)
          if( dafs) As(ie,1:ndafst) = As(ie,1:ndafst)
     &                              + p2f(ie) * Adafs(i-1,1:ndafst)
     &                              + p1f(ie) * Adafs(i,1:ndafst)
          if( tenseur .and. magn ) Asm(ie,1:ndafst) = Asm(ie,1:ndafst)
     &                              + p2f(ie) * Adafsm(i-1,1:ndafst)
     &                              + p1f(ie) * Adafsm(i,1:ndafst)
          do ipl = 1,nxan
            Xs(ie,ipl) = Xs(ie,ipl)  + p2f(ie) * Xanes(i-1,ipl)
     &                               + p1f(ie) * Xanes(i,ipl)
          end do
        end do

        deallocate( Adafs )
        if( tenseur .and. magn ) deallocate( Adafsm )
        deallocate( Xanes )
        deallocate( Energ )

      end do

      deallocate( run_done )
      if( .not. ( seah .or. arc ) ) then
        deallocate( Elor )
        deallocate( betalor )
      endif
      deallocate( Skip_run )

      if( .not. forbidden .and. dafs ) then
        jpl = 0
        do ipl = 1,ndafs
          do ip = 1,nphi(ipl)
            jpl = jpl + 1
            if( nf0 == 1 .or. nphi(ipl) == 1 ) then
              As(:,jpl) = S0_2 * As(:,jpl) + f0(ipl)
            else
              As(:,jpl) = S0_2 * As(:,jpl) + f0scan(jpl)
            endif
          end do 
        end do 
      endif

      if( self_abs ) then
        do ie = 1,nes
          eph = Es(ie) + Esmin
          fac = 1 / ( conv_mbarn_nelec( eph ) * pi )
          Xs(ie,nplr+1:nplr+2*ndafs) = Xs(ie,nplr+1:nplr+2*ndafs)
     &                               + fpp_avantseuil * fac
        end do 
      endif

! Convolution par une gaussienne
      if( abs(deltar) > 1.e-10_db .or. abs(vibration) > 1.e-10_db ) then
        allocate( Yr(nes) )
        allocate( Yi(nes) )
        do ipl = 1,nxan
          Yr(:) = Xs(:,ipl)  
          call gaussi(deltar,Efermi,Es,nes,vibration,Yr)
          Xs(:,ipl) = Yr(:)  
        end do
        do ipl = 1,ndafst
          Yr(:) = real(As(:,ipl),db)  
          call gaussi(deltar,Efermi,Es,nes,vibration,Yr)
          Yi(:) = aimag(As(:,ipl))  
          call gaussi(deltar,Efermi,Es,nes,vibration,Yi)
          As(:,ipl) = cmplx( Yr(:), Yi(:),db )  
        end do
        if( tenseur .and. magn ) then
          do ipl = 1,ndafst
            Yr(:) = real(Asm(:,ipl),db)  
            call gaussi(deltar,Efermi,Es,nes,vibration,Yr)
            Yi(:) = aimag(Asm(:,ipl))  
            call gaussi(deltar,Efermi,Es,nes,vibration,Yi)
            Asm(:,ipl) = cmplx( Yr(:), Yi(:),db )  
          end do
        endif
        deallocate( Yr )
        deallocate( Yi )
      endif

!---- Ecriture -------------------------------------------------

      if( tenseur ) then
        if( magn ) then
          nm = 4
        else
          nm = 2
        endif
        ncols = nxan + nm * ndafs
        do ipl = ndafs,1,-1
          jpl = nxan + nm * ipl
          nomxan(jpl) = nomxan(nxan+ipl)
          nomab = nomxan(jpl)
          l = len_trim( nomab )
          if( magn ) then 
            nomab(l+1:l+2) = 'sm'
            nomxan(jpl) = nomab 
            nomab(l+1:l+2) = 'pm'
            nomxan(jpl-1) = nomab
          endif
          nomab(l+1:l+1) = 's'
          nomxan(jpl-2-nm+4) = nomab 
          nomab(l+1:l+1) = 'p'
          nomxan(jpl-3-nm+4) = nomab
        end do
      else
        if( fprim ) then
          ncols = nxan + 3 * ndafs
        else
          ncols = nxan + ndafs
        endif
        jpl = nxan + ndafs + 1
        kpl = jpl
        if( fprim ) jpl = jpl + 2 * ndafs  
        do ipl = ndafs,1,-1
          if( self_abs ) then
            do i = 1,2
              jpl = jpl - 1
              kpl = kpl - 1
              nomxan(jpl) = nomxan(kpl)
            end do
          endif
          kpl = kpl - 1
          nomab = nomxan(kpl)
          if( nomab(1:1) == ' ' ) then
            l = len_trim( nomab ) - len_trim( adjustl(nomab) ) + 1
          else
            l = 1
          endif
          if( nomab(l:l) /= 'r' .and. nomab(l:l) /= 'i' ) then  
            ll = len_trim( nomab )
            nomac = ' '
            nomac(l+1:ll) = nomab(l:ll-1)
            if( nomac(ll:ll) == '_' ) nomac(ll:ll) = ' '
            nomab = nomac  
          endif
          if( fprim ) then
            nomab = adjustl( nomab )
            nomab(1:1) = ' '
            l = len_trim( nomab ) + 1
            nomab(l:l) = 's'
            jpl = jpl - 1
            nomxan(jpl) = nomab 
            nomab(l:l) = 'p'
            jpl = jpl - 1
            nomxan(jpl) = nomab 
            nomab(l:l) = ' '
          endif
          jpl = jpl - 1
          nomab(1:1) = 'I'
          nomxan(jpl) = nomab
        end do 
      endif

      allocate( Tens(ncols) )
      allocate( Title(ncols) )

      if( dafs ) then
        allocate( ic(ndafs) )
        ic(1) = 1
        do ipl = 2,ndafs
          ic(ipl) = 1 + sum( nphi(1:ipl-1) )
        end do
      endif        
      if( fprim ) then
        do ipl = 1,ndafs
          if( abs( dpht(ipl) ) > 1.e-10_db ) cycle 
          dpht(ipl) = (1._db,0._db)
        end do
      endif

      Title(1:ncols) = nomxan(1:ncols)

      if( energphot ) Es(:) = Es(:) + Esmin 

      do ie = 1,nes

        if( tenseur .or. no_normal ) then
          if( energphot ) then
            eph = Es(ie)
          else
            eph = Es(ie) + Esmin
          endif
          if( no_normal ) then
            ptrans = 1
  ! alfa = e*e/(2*epsilon0*h*c) = 0.0072973531 = 1/137.036 est la
  ! constante de structure fine.
            alfa = 0.0072973531
            cst = 4 * pi**2 * ptrans * alfa * eph
  ! le resultat etait en megabarn (10E-18 cm2)
            cst = 100 * bohr**2 * cst
          endif
          if( tenseur ) ct_nelec = conv_mbarn_nelec(eph)
        endif 

        do ipl = 1,nplr
          Tens(ipl) = Xs(ie,ipl) 
          if( no_normal ) Tens(ipl) = Tens(ipl) / cst 
        end do

        jpl = nplr

        do ipl = 1,ndafs
          if( tenseur ) then
            jpl = jpl + 1
            Tens(jpl) = real( As(ie,ic(ipl)),db ) 
            jpl = jpl + 1
            Tens(jpl) = aimag( As(ie,ic(ipl)) ) 
            if( magn ) then
              jpl = jpl + 1
              Tens(jpl) = real( Asm(ie,ic(ipl)),db ) 
              jpl = jpl + 1
              Tens(jpl) = aimag( Asm(ie,ic(ipl)) )
            endif 
          else
            jpl = jpl + 1
            Tens(jpl) = abs( As(ie,ic(ipl)) )**2
            if( fprim ) then
!              cf = As(ie,ic(ipl)) / dpht(ipl)
              cf = As(ie,ic(ipl))
              jpl = jpl + 1
              Tens(jpl) = real( cf,db )
              jpl = jpl + 1
              Tens(jpl) = aimag( cf )
            endif
            if( self_abs ) then
              do i = 1,2
                jpl = jpl + 1
                Tens(jpl) = Xs(ie,nplr+2*ipl-2+i)
                if( no_normal ) Tens(jpl) = Tens(jpl) / cst
              end do 
            endif
          endif
        end do

! On veut f' et f" en nombre d'electrons
        if( tenseur_car) Tens(:) = ct_nelec * Tens(:)

        if( fit_cal ) then
! Commande l'ecriture dans un fichier temporaire
          n = -iscratchconv  
        else
          n = 0
        endif
        call write_out(0._db,Efermi,Es(ie),
     &                 0._db,0._db,ie,Length_word,0,
     &                 ncols,jpl,convolution_out,Title,1,0,0,n,
     &                 cdum,cdum,Tens,v0muf)

      end do

      Close(3)

      deallocate( Tens )
      deallocate( Title )

      if( scan_true ) then
 
        Open(7, file = fichscanout)

        do ie = 1,nes
          Write(7,*)
          Write(7,200) Es(ie) * rydb 
          icol = 0
          jpl = nplr
          do ipl = 1,ndafs
            do i = 1,5
              jpl = jpl + 1
              nomab = nomxan(jpl)
              if( nomab(1:1) == 'I' ) exit
            end do
            Write(7,*) nomxan(jpl)
            do ip = 1,nphi(ipl)
              icol = icol + 1
              Write(7,210) angle(ip),
     &                   real(As(ie,icol),db)**2 + aimag(As(ie,icol))**2
            end do
          end do
        end do

        Close(7)

      endif

      if( dafs) deallocate( As )
      if( tenseur .and. magn ) deallocate( Asm )
      deallocate( decal )
      deallocate( indf )
      deallocate( Ef ) 
      deallocate( En_fermi ) 
      deallocate( Epsii ) 
      deallocate( Eseuil ) 
      deallocate( fichin )
      deallocate( Es ) 
      deallocate( Efermip )
      deallocate( fichscanin )
      deallocate( ne ) 
      deallocate( nomxan )
      deallocate( nsup )
      deallocate( Pds )
      deallocate( p1f )
      deallocate( p2f )
      deallocate( Xs )
      if( dafs ) then
        deallocate( dph )
        deallocate( dpht )
        deallocate( fr ); deallocate( fi ) 
        deallocate( f0 )
        deallocate( nphi )
        if( scan_true ) then
          deallocate( angle )   
          deallocate( phdtscan )   
          deallocate( f0scan )   
        endif 
      endif 

      if( ncal > 1 .and. ical == ncal+1 ) then
        do jfich = 1,mfich
          iscr = 100 + jfich
          Close( iscr )
        end do
      endif

      return

 9999 call write_err_form(itape1,keyword)

      return
  110 format(///' Line not understood in the indata file :'//1x,A//,
     &        ' If it is supposed to be a keyword check the spelling.',/
     &        ' Tabulations are forbidden.'/
     &        ' If it is a line containing numbers, check:'/
     &        '   - How many numbers are supposed to be there.'/
     &        '   - Numbers must be separated by spaces.'/
     &      '   - Are there extra characters (points, tabulations...'//)
  120 format(///' The output file has the same name than one of the ',
     &          ' input files.',/
     &          ' This last will be overwritten !',//
     &          ' Are you sure you want to continue ? (y/n) :')
  130 format(///'     Input files are different,'/
     &          '  file 1 : nxan =',i2,', ndafs =',i2,/
     &          '  file ',i2,' : nxan =',i2,', ndafs =',i2)
  140 format(//' For the convolution, the number of energy must be',
     &         ' greater than one !'/,
     &         ' It is not the case in the file:'//A//)
  145 format(///' Error under the keyword Par_',a6,'in the indata file:'
     &       //' The wanted file is the number',i3,' !',/
     &         ' There are only',i3,' files in the job !'//)
  147 format(///' Taking into account the energy shifts, there is no',
     &       ' overlap between',/
     &   ' the energy ranges of the different absorbing atoms !',/
     &   ' No summation and convolution are possible !' //)
  150 format('    Aseah =',f7.2,', Gamma_max =',f6.2)
  160 format('    Ecent =',f7.2,', Elarg =',f7.2,', Gamma_max =',f7.2)
  170 format('    Gamma_hole =',f7.2,', Efermi =',f7.2,//
     &  6x,'E_(eV)    Width_(eV) lambda_(A)')
  180 format(3f12.3)
  190 format('    Gamma_hole =',f7.2,', Efermi =',f7.2,', site',i3)
  200 format(f10.3,1p,240e13.5)
  210 format(f7.1,1p,3e13.5)
      end

!***********************************************************************

      subroutine tab_width(Eseuil,Gamma_hole,lseuil,nseuil,numat)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      if( nseuil == 1 ) then  ! seuil K
          Gamma_hole = 0.13007 + 0.00011544 * Eseuil
     &            + 9.2262E-09 * Eseuil**2 - 3.2344E-14 * Eseuil**3
      elseif( lseuil == 0 ) then   ! Seuil L1
        if( numat <= 20 ) then
          p = ( numat - 1 ) / 19.
          Gamma_hole = (1 - p ) * 0.07 + p * 4.
        elseif( numat <= 35 ) then
          p = ( numat - 20 ) / 15.
          Gamma_hole = (1 - p ) * 4. + p * 7.
        elseif( numat <= 50 ) then
          p = ( numat - 35 ) / 15.
          Gamma_hole = (1 - p ) * 7. + p * 4.
        elseif( numat <= 75 ) then
          p = ( numat - 50 ) / 25.
          Gamma_hole = (1 - p ) * 4. + p * 8.
        else
          p = ( numat - 75 ) / 20.
          Gamma_hole = (1 - p ) * 8. + p * 19.
        endif
      else    ! Seuil L2 et les autres...
        if( numat <= 26 ) then
          p = ( numat - 1 ) / 25.
          Gamma_hole = (1 - p ) * 0.001 + p * 1.7
        elseif( numat <= 31 ) then
          p = ( numat - 26 ) / 5.
          Gamma_hole = (1 - p ) * 1.7 + p * 0.8
        elseif( numat <= 60 ) then
          p = ( numat - 31 ) / 29.
          Gamma_hole = (1 - p ) * 0.8 + p * 3.5
        elseif( numat <= 80 ) then
          p = ( numat - 60 ) / 20.
          Gamma_hole = (1 - p ) * 3.5 + p * 5.
        else
          p = ( numat - 80 ) / 15.
          Gamma_hole = (1 - p ) * 5. + p * 10.
        endif
      endif

      return
      end

!***********************************************************************

      subroutine seahdench(A,Efermi,Gamma_max,nelor,Elor,betalor)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      real(kind=db):: Elor(nelor), betalor(nelor), lambda

      do ie = 1,nelor
        E = Elor(ie) - Efermi
        Ep = E
        if( E > 0._db .and. Ep > 0._db .and.
     &                      ( A > 0._db .or. Gamma_max > 0._db ) ) then
          lambda = 0._db
          if( A > 0._db ) lambda = lambda + 1 / ( A * sqrt(Ep) )
          if( Gamma_max > 0._db ) lambda = lambda + sqrt(Ep) / Gamma_max
          betalor(ie) = sqrt(E) / lambda
        else
          betalor(ie) = 0.
        endif
      end do

      return
      end

!***********************************************************************

      subroutine gammarc(Ecent,Elarg,Gamma_max,Efermi,nelor,
     &                   Elor,betalor)
     
      use declarations
      implicit none

      integer ie, nelor

      real(kind=db):: E, Ec, Ecent, Efermi, El, Elarg, Gamma_max, p
      real(kind=db), dimension(nelor):: Elor, betalor
 
      Ec = max( Ecent, 1.E-10_db ) 
      El = max( Elarg, 1.E-10_db ) 
      p = ( pi / 3 ) * Gamma_max / El

      do ie = 1,nelor
        E = Elor(ie) - Efermi
        if ( E <= 0._db ) then
          betalor(ie) = 0._db
        else
          betalor(ie) = Gamma_max
     &                * ( 0.5 + atan( p*(E/Ec - (Ec/E)**2)) / pi)
        endif 
      end do

      return
      end

!***********************************************************************

! Convolution par une gaussienne

      subroutine gaussi(deltar,Efermi,Energ,nenerg,vibration,Y)

      use declarations    
      implicit real(kind=db) (a-h,o-z)

! nj : Points au dela de la gamme pour diminuer les effets de bord de la
! convolution  
      parameter(nj=10,n1m=1-nj)
      real(kind=db) de(n1m:nenerg+nj), Ef(n1m:nenerg+nj), Energ(nenerg), 
     &             gaus(n1m:nenerg+nj), Y(nenerg), 
     &             Xa(n1m:nenerg+nj)

      Ef(1:nenerg) = Energ(1:nenerg)
      Xa(1:nenerg) = Y(1:nenerg)

! Creation des points au dela de la gamme 
      ne1 = 1 - nj
!      ne2 = nenerg + nj
      def = Ef(2) - Ef(1)
      do ie = 0,ne1,-1 
        Ef(ie) = Ef(ie+1) - def
        Xa(ie) = Xa(1)
      end do
!      def = Ef(nenerg) - Ef(nenerg-1)
!      do ie = nenerg+1,ne2 
!        Ef(ie) = Ef(ie-1) + def
!        Xa(ie) = Xa(nenerg)
!      end do
      ne2 = nenerg

      de(ne1) = Ef(ne1+1) - Ef(ne1) 
      do ie = ne1+1,ne2-1
        de(ie) = 0.5 * ( Ef(ie+1) - Ef(ie-1) )
      end do 
      de(ne2) = ( Ef(ne2) - Ef(ne2-1) ) 

!      fnorm = 1 / ( b * sqrt( 2 * pi ) )

      if( abs(deltar) < 1.e-10_db .and. abs(vibration) < 1.e-10_db )
     &  return

      do ie = 1,nenerg

        vib = 2 * vibration * ( Ef(ie) - Efermi + 0.5_db )
        vib = max( 0._db, vib )
        b = deltar + vib
        if( abs(b) < 1.e-10_db ) then
          Y(ie) = Xa(ie)
          cycle
        endif
             
        gaus(:) = 0._db
        Pdt = 0._db
        do je = ne1,ne2
          n = max( int( 10 * de(je) / b ), 1 )
          pas = de(je) / ( n + 1 )
          if ( je == ne1 ) then
            E = Ef(je) - 0.5 * ( Ef(je+1) -  Ef(je) )
          else
            E = Ef(je) - 0.5 * ( Ef(je) -  Ef(je-1) )
          endif 
          do i = 1,n
            E = E + pas
            if( ( E < Ef(je) .and. je /= ne1 ) .or. je == ne2 ) then
              p = ( E - Ef(je-1) ) / ( Ef(je) - Ef(je-1) )
              Yint = (1 - p ) * Xa(je-1) + p * Xa(je)
            else
              p = ( E - Ef(je) ) / ( Ef(je+1) - Ef(je) )
              Yint = (1 - p ) * Xa(je) + p * Xa(je+1)
            endif
            fac = -0.5 * ( ( E - Ef(ie) ) / b )**2
            if( fac > -600._db ) then
              efac = exp( fac )
              gaus(je) = gaus(je) + efac * Yint
              Pdt = Pdt + efac * de(je) / n
            endif
          end do 
          gaus(je) = ( gaus(je) / n ) * de(je)
        end do
        Y(ie) = sum( gaus(ne1:ne2) ) / Pdt

      end do

      return
      end

!***********************************************************************

! Calcul des coefficients de la lorentzienne

      subroutine cflor(bb,betalor,Efermi,Eph,Elor,Energ,ie1,ie2,nef,
     &                 nelor,nenerg,nenerge,Photo_emission)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      logical:: Photo_emission

      real(kind=db):: bb(nenerge), betalor(nelor), Elor(nelor),  
     &               Energ(nenerg), Eph(nenerge)

      Eph(1:nenerg) = Energ(1:nenerg)

! Creation des points au dela de la gamme 
      def = Eph(2) - Eph(1)
      def = Eph(nenerg) - Eph(nenerg-1)
      do ie = nenerg+1,nenerge 
        Eph(ie) = Eph(ie-1) + def
      end do

! Les etats en dessous de Fermi sont occupes
      do ie = 1,nenerge
        if( Eph(ie) > Efermi - 1.e-10_db ) exit
      end do
      nef = ie

      if( Photo_emission ) nef = max(1, nef-1)

      if( Photo_emission ) then
        ie1 = 1
        ie2 = nef
      else
        ie1 = nef
        ie2 = nenerge
      endif

      do ie = 1,nenerge
        if( Eph(ie) <= Elor(1) ) then
          bb(ie) = betalor(1) 
        elseif( Eph(ie) >= Elor(nelor) ) then
          bb(ie) = betalor(nelor)
        else 
          do j = 2,nelor
            if( Elor(j) >= Eph(ie) ) exit
          end do
          p = ( Eph(ie) - Elor(j-1) ) / ( Elor(j) - Elor(j-1) )
          bb(ie) = p * betalor(j) + ( 1 - p ) * betalor(j-1)
        endif
        bb(ie) = 0.5 * bb(ie) ! bb est en fait Gamma / 2
      end do

      return
      end

!***********************************************************************

! Calcul de l'extrapolation atomique

      subroutine extrapat(bb_nenerg,convolution_out,dampl,
     &                    Energ,Eseuil,extrap,fpp0,
     &                    fprime_atom,numat,nenerg)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      parameter(nim=10000)

      complex(kind=db):: dampl(nenerg)
      character(len=132):: convolution_out, fprime_out 
      logical extrap, fprime_atom

      real(kind=db):: ei(nim), ei1(nim), ei2(nim), Energ(nenerg),
     &               fppn(nim)

      if( fprime_atom ) then
        l = len_trim( convolution_out )
        fprime_out = convolution_out
        fprime_out(l-3:l+11) = '_fprime_ato.txt'
        ephoton = max( Eseuil - 200 / rydb, 10 / rydb )
        dde = 0.5 /rydb
        ephm = Eseuil + 5000. / rydb
        ephi = Eseuil + 500. / rydb
        open(9,file = fprime_out)       
        write(9,'(A)') '   Energy_ev      fprim       fsecond'
        do i = 1,nim
          if( ephoton < ephi ) then
            ephoton = ephoton + dde
          else
            ephoton = ephoton + 10 * dde
          endif 
          if( ephoton > ephm ) exit
          call fprime(numat,ephoton,fpp,fp)
          write(9,'(3f13.6)') ephoton*rydb, fp, fpp
        end do
        Close(9)
        if( .not. extrap ) return
      endif

      ephoton = Eseuil - 2 / rydb
      call fprime(numat,ephoton,fpp0,fp)

      ephoton = Eseuil + Energ(nenerg)
      ephm = Eseuil + 10000. / rydb
      if( nenerg > 1 ) then
        dde = Energ(nenerg) - Energ(nenerg-1)
      else
        dde = 2 / rydb
      endif

      alfa = 1.02
      f = 0.5 * alfa
      do i = 1,nim
        dde = alfa * dde
        ephoton = ephoton + dde 
        if( ephoton > ephm ) exit
        call fprime(numat,ephoton,fpp,fp)
        ei(i) = ephoton
        ei2(i) = ei(i) + f * dde
        ei1(i) = ei(i) - 0.5 * dde
        fppn(i) = - ( fpp - fpp0 ) / pi 
      end do
      ni = min(i-1,nim)

      bb2 = bb_nenerg**2

      do ie = 1,nenerg
        e1 = Energ(ie) + Eseuil
        if( abs(bb_nenerg) < 1.e-10_db ) then
          dampl(ie) = sum( fppn(1:ni)
     &    * log( ( ei2(1:ni) - e1 ) / (ei1(1:ni) - e1 ) ) )
        else
!            dampl(ie) = sum( fppn(1:ni)
!     &                * log( ( ei2(1:ni) - e1 + img * bb_nenerg ) 
!     &                     / ( ei1(1:ni) - e1 + img * bb_nenerg ) ) )
          dampl(ie) = sum( fppn(1:ni)
     &          * ( 0.5*log( ( ( ei2(1:ni) - e1 )**2 + bb2 ) 
     &                     / ( ( ei1(1:ni) - e1 )**2 + bb2 ) ) 
     &            - img * ( atan( ( ei2(1:ni) - e1 ) / bb_nenerg )
     &                    - atan( ( ei1(1:ni) - e1 ) / bb_nenerg ) ) ) )  
        endif
      end do

      return
      end

!***********************************************************************

      subroutine extract_word(length,length_word,mot,word,n_word,n_dim)

      character(len=length):: mot
      character(len=length_word):: mota
      character(len=length_word), dimension(n_dim):: word

      n_word = 0
      i = 0
      do ii = 1,length
        i = i + 1
        if( i > length ) exit
        if( mot(i:i) == ' ' ) cycle
        n_word = n_word + 1
        mota = ' '
        do j = i,length          
          if( mot(j:j) == ' ' ) exit
          mota(j-i+1:j-i+1) = mot(j:j)
        end do
        i = j
        word(n_word) = mota          
      end do

      return
      end

