! Fdmnes subroutine
! Calculate the absorption cross sections and the RXS amplitudes

      subroutine write_coabs(allsite,angpoldafs,
     &          dafs,E_cut,energ,energphot,extract,Epsii,
     &          fpp_avantseuil,green_plus,hkl_dafs,ie,ie_computer,
     &          Int_tens,isigpi,isymeq,length_word,ltypcal,
     &          moyenne,mpinodee,natomsym,nbseuil,ncolm,
     &          ncolr,ncolrd,ncolt,nenerg,nomabs, 
     &          nomfich_cal_convt,nomfich_s,npldafs,nphim,nplr,nplt,
     &          npltm,nspin,nspinr,numat_abs,nxanout,pdp,phdafs,
     &          phdf0t,phdf0tscan,phdt,phdtscan,ple,pls,poldafsescan,
     &          poldafssscan,sec_atom,secdd_a,secdq_a,secdo_a,secmd_a,
     &          secmm_a,secqq_a,self_abs,spinorbite,Taux_eq,v0muf,
     &          vecdafsescan,vecdafssscan,voe,vos,xan_atom)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      parameter( n_tens_dd=9, n_tens_dq=15, n_tens_qq=25,
     &           n_tens_t = n_tens_dd + n_tens_dq + n_tens_qq,
     &           n_tens_max = 8 + 2 * n_tens_t + 2 * n_tens_dq ) 

      character(len=3), dimension(2):: seuil_ext
      character(len=length_word):: nomab
      character(len=length_word), dimension(ncolm):: nomabs, title
      character(len=13), dimension(npltm):: ltypcal
      character(len=132) nomfich_s, nomfichdafst, nomficht,
     &                   nomfich1
      character(len=152) mot
      character(len=132), dimension(nbseuil):: nomfich_cal_convt

      complex(kind=db):: cf, ph, sec
      complex(kind=db), dimension(3):: plae, plas
      complex(kind=db), dimension(6):: compnum
      complex(kind=db), dimension(3,3):: secdd, secmd, secmm
      complex(kind=db), dimension(3,3,3):: secdq, secdqia_mag
      complex(kind=db), dimension(3,3,3,3):: secdo, secqq
      complex(kind=db), dimension(3,3,0:natomsym):: secddia, secmdia,
     &                                             secmmia
      complex(kind=db), dimension(3,3,3,0:natomsym):: secdqia
      complex(kind=db), dimension(3,3,3,3,0:natomsym):: secdoia, secqqia
      complex(kind=db), dimension(3,3,nbseuil,nspinr,0:mpinodee-1):: 
     &                                        secdd_a, secmd_a, secmm_a
      complex(kind=db), dimension(3,3,3,nbseuil,nspinr,0:mpinodee-1)::
     &                                        secdq_a
      complex(kind=db), dimension(3,3,3,3,nbseuil,nspinr,0:mpinodee-1)::
     &                                        secdo_a, secqq_a
      complex(kind=db), dimension(npldafs):: phdf0t, phdt, phdtem
      complex(kind=db), dimension(3,npltm):: ple, pls
      complex(kind=db), dimension(npldafs,nphim):: phdf0tscan, phdtscan 
      complex(kind=db), dimension(natomsym,npldafs):: phdafs 
      complex(kind=db), dimension(3,npldafs,nphim):: poldafsescan,
     &                                              poldafssscan 
     
      complex(kind=db), dimension(:,:), allocatable :: ampldafs,
     &  ampldafsdd, ampldafsdo,  ampldafsdq, ampldafsqq 
      complex(kind=db), dimension(:,:,:), allocatable :: ampldafsscan,
     &  ampldafsscandd, ampldafsscando, ampldafsscandq, ampldafsscanqq

      integer, dimension(natomsym):: isymeq
      integer, dimension(3,npldafs) :: hkl_dafs
      integer, dimension(npldafs,2) :: isigpi

      logical allsite, base_spin, cartesian_tensor, comp_dd, comp_do,
     &        comp_md, comp_mm, comp_dq, comp_qq, dafs, 
     &        dipmag, energphot, extract, green_int, green_plus,    
     &        idafs, magn_sens, moyenne, scan_true, self_abs,   
     &        spherical_tensor, spinorbite, tens_comp, xan_atom
 
      real(kind=db), dimension(3,npldafs) :: angpoldafs
      real(kind=db), dimension(3):: voae, voas
      real(kind=db), dimension(3,3):: matopsym
      real(kind=db), dimension(nenerg) :: energ
      real(kind=db), dimension(nbseuil) :: sec_atom
      real(kind=db), dimension(3,npltm) :: voe, vos
      real(kind=db), dimension(ncolm,2) :: pdp
      real(kind=db), dimension(ncolm) :: tens
      real(kind=db), dimension(natomsym) :: Taux_eq
      real(kind=db), dimension(n_tens_max,0:natomsym):: Int_tens
      real(kind=db), dimension(ncolrd,0:natomsym):: secabs, secabsdd, 
     &                                secabsdq, secabsdo, secabsqq
      real(kind=db), dimension(3,npldafs,nphim):: vecdafsescan, 
     &                                           vecdafssscan 
     
      common/base_spin/ base_spin
      common/cartesian/ cartesian_tensor 
      common/dipmag/ dipmag
      common/eseuil/ eseuil(2)
      common/green_int/ green_int
      common/icheck/ icheck(24)
      common/lseuil/ jseuil, lseuil, nseuil
      common/comp_dd/ comp_dd, comp_md, comp_do, comp_dq,comp_mm,comp_qq 
      common/rot_int/ rot_int(3,3)
      common/seuil_ext/ seuil_ext
      common/spheric/ spherical_tensor 

      scan_true = .false.
      if( ( lseuil > 0 .and. nspin == 2 ) .or. spinorbite .or. comp_mm
     &   .or. comp_md ) then
        magn_sens = .true.
      else
        magn_sens = .false.
      endif

      if( allsite ) then
        na = natomsym
        nb = natomsym
      else
        na = 0
        nb = 1
      endif

      do iseuil = 1,nbseuil       ! ----------> Boucle sur les seuils

        if( icheck(21) > 0 ) then
          write(3,120)
          write(3,130) achar(nseuil+74) // achar(jseuil+iseuil+47) 
        endif

        ephseuil = energ(ie)
        ephoton = ephseuil + eseuil(iseuil)
        if( energphot ) ephseuil = ephoton

        ct_nelec = conv_mbarn_nelec(ephoton) 
        eph2 = 0.5 * ephoton**2
! Pour avoir les tenseurs et sections efficace en Megabarn
        cst = eph2 / ct_nelec

! Les tenseurs sont convertis en megabarn
        if( .not. extract ) then
          if( xan_atom ) sec_atom(iseuil) = sec_atom(iseuil) * cst 
          if( comp_dd ) secdd_a(:,:,iseuil,:,ie_computer)
     &                   = secdd_a(:,:,iseuil,:,ie_computer) * cst
          if( comp_dq ) secdq_a(:,:,:,iseuil,:,ie_computer)
     &                   = secdq_a(:,:,:,iseuil,:,ie_computer) * cst 
          if( comp_qq ) secqq_a(:,:,:,:,iseuil,:,ie_computer)
     &                   = secqq_a(:,:,:,:,iseuil,:,ie_computer) * cst 
          if( comp_do ) secdo_a(:,:,:,:,iseuil,:,ie_computer)
     &                   = secdo_a(:,:,:,:,iseuil,:,ie_computer) * cst 
! Pour les termes diople magnetique, il y a une normalisation en plus
! La division par hbar a deja ete faite dans tens_ab.
          if( comp_md ) secmd_a(:,:,iseuil,:,ie_computer)
     &            = - secmd_a(:,:,iseuil,:,ie_computer) * cst / ephoton
          if( comp_mm ) secmm_a(:,:,iseuil,:,ie_computer)
     &            = secmm_a(:,:,iseuil,:,ie_computer) * cst / ephoton**2
        endif

! Correction du terme magnetique en cas de green_moins.
        if( .not. green_plus ) then
          if( comp_dd ) secdd_a(:,:,iseuil,:,ie_computer)
     &                     = conjg( secdd_a(:,:,iseuil,:,ie_computer) )
! Comme dans convolution, on prend le complexe conjugue, le cas 
! green_plus est a prendre avant le img facteur du vecteur d'onde dans
! l'operateur quadrupolaire.
          if( comp_dq ) secdq_a(:,:,:,iseuil,:,ie_computer)
     &                  = conjg( secdq_a(:,:,:,iseuil,:,ie_computer) ) 
          if( comp_qq ) secqq_a(:,:,:,:,iseuil,:,ie_computer)
     &                  = conjg( secqq_a(:,:,:,:,iseuil,:,ie_computer) ) 
          if( comp_do ) secdo_a(:,:,:,:,iseuil,:,ie_computer)
     &                  = conjg( secdo_a(:,:,:,:,iseuil,:,ie_computer) ) 
          if( comp_md ) secmd_a(:,:,iseuil,:,ie_computer)
     &                  = conjg( secmd_a(:,:,iseuil,:,ie_computer) )
          if( comp_mm ) secmm_a(:,:,iseuil,:,ie_computer)
     &                  = conjg( secmm_a(:,:,iseuil,:,ie_computer) )
        endif

        do ispinr = 1,nspinr   ! ---> boucle pour sortie resolue en spin

          nomfich1 = nomfich_s
          long = len_trim(nomfich1)
          if( nbseuil == 2 ) then
            nomfich1(long+1:long+4) = seuil_ext(iseuil)
            long = long + 3
          endif
          if( nspinr == 2 ) then
            if( ispinr == 1 ) then
              nomfich1(long+1:long+3) = '_up'
            else
              nomfich1(long+1:long+3) = '_dn'
            endif
          endif

          do ia = 1,natomsym

            isym = abs( isymeq(ia) )
            call opsym(isym,matopsym)
            if( base_spin ) then
              matopsym = matmul( matopsym, rot_int )
              matopsym = matmul( transpose(rot_int), matopsym )
            endif

            if( comp_dd ) then
              secdd(:,:) = secdd_a(:,:,iseuil,ispinr,ie_computer)
              if( isym /= 1 ) call rot_tensor_2( secdd, matopsym )
              if( isymeq(ia) < 0 ) secdd(:,:) = conjg( secdd(:,:) )
              secddia(:,:,ia) = secdd(:,:)
            endif

            if( comp_dq ) then
              secdq(:,:,:) = secdq_a(:,:,:,iseuil,ispinr,ie_computer)
              if( isym /= 1 ) call rot_tensor_3( secdq, matopsym )
              if( isymeq(ia) < 0 ) secdq(:,:,:) = conjg( secdq(:,:,:) )
              secdqia(:,:,:,ia) = secdq(:,:,:)
            endif

            if( comp_qq ) then
              secqq(:,:,:,:) =secqq_a(:,:,:,:,iseuil,ispinr,ie_computer)
              if( isym /= 1 ) call rot_tensor_4( secqq, matopsym )
              if( isymeq(ia) < 0 ) secqq(:,:,:,:) =conjg(secqq(:,:,:,:))
              secqqia(:,:,:,:,ia) = secqq(:,:,:,:)
            endif

            if( comp_do ) then
              secdo(:,:,:,:) =secdo_a(:,:,:,:,iseuil,ispinr,ie_computer)
              if( isym /= 1 ) call rot_tensor_4( secdo, matopsym )
              if( isymeq(ia) < 0 ) secdo(:,:,:,:) =conjg(secdo(:,:,:,:))
              secdoia(:,:,:,:,ia) = secdo(:,:,:,:)
            endif

            if( comp_md ) then
              secmd(:,:) = secmd_a(:,:,iseuil,ispinr,ie_computer)
              if( isym /= 1 ) call rot_tensor_2( secmd, matopsym )
              if( isymeq(ia) < 0 ) secmd(:,:) = conjg( secmd(:,:) )
              secmdia(:,:,ia) = secmd(:,:)
            endif

            if( comp_mm ) then
              secmm(:,:) = secmm_a(:,:,iseuil,ispinr,ie_computer)
              if( isym /= 1 ) call rot_tensor_2( secmm, matopsym )
              if( isymeq(ia) < 0 ) secmm(:,:) = conjg( secmm(:,:) )
              secmmia(:,:,ia) = secmm(:,:)
            endif

          end do

          if( dafs ) then

            allocate( ampldafs(npldafs,0:natomsym) )
            if( comp_dd ) allocate( ampldafsdd(npldafs,0:natomsym) )
            if( comp_dq ) allocate( ampldafsdq(npldafs,0:natomsym) )
            if( comp_qq ) allocate( ampldafsqq(npldafs,0:natomsym) )
            if( comp_do ) allocate( ampldafsdo(npldafs,0:natomsym) )
         
            do ipl = 1,npldafs
              if( angpoldafs(1,ipl) > -9999._db .and. 
     &            angpoldafs(2,ipl) > -9999._db .and.
     &            angpoldafs(3,ipl) > -9999._db ) cycle
              scan_true = .true.
              exit
            end do

            if( scan_true ) then
              allocate( ampldafsscan(npldafs,nphim,0:natomsym) )
              if( comp_dd )
     &          allocate( ampldafsscandd(npldafs,nphim,0:natomsym) )
              if( comp_dq )
     &          allocate( ampldafsscandq(npldafs,nphim,0:natomsym) )
              if( comp_qq )
     &          allocate( ampldafsscanqq(npldafs,nphim,0:natomsym) )
              if( comp_do )
     &          allocate( ampldafsscando(npldafs,nphim,0:natomsym) )
            endif

          endif

          ipldafs = 0
          jpl = 0

          do ixandafs = 1,2
          do ipl = 1,nplt

            if( ltypcal(ipl) == 'dafs rectil'
     &         .or. ltypcal(ipl) == 'dafs circul' ) then
              idafs = .true.
            else
              idafs = .false.
            endif
            tens_comp = magn_sens .or. green_int .or. idafs

            if( ( idafs .and. ixandafs == 1 ) .or.
     &          ( .not. idafs .and. ixandafs == 2 ) ) cycle
  
            if( idafs ) then
              ipldafs = ipldafs + 1
            else
              if( ipl > nplr .and. jpl <= ncolr ) jpl = ncolr 
              jpl = jpl + 1
            endif

            if( idafs .and. ipldafs > 1 ) then
              if( ( hkl_dafs(1,ipldafs) == hkl_dafs(1,ipldafs-1) ) 
     &          .and. ( hkl_dafs(2,ipldafs) == hkl_dafs(2,ipldafs-1) )
     &          .and. ( hkl_dafs(3,ipldafs) == hkl_dafs(3,ipldafs-1) ) )
     &          goto 1010
            endif
            if( ipl > 1 .and. .not. idafs ) goto 1010
            
            secddia(:,:,0) = (0._db,0._db)
            secdqia(:,:,:,0) = (0._db,0._db)
            secdqia_mag(:,:,:) = (0._db,0._db)
            secqqia(:,:,:,:,0) = (0._db,0._db)
            secdoia(:,:,:,:,0) = (0._db,0._db)
            secmdia(:,:,0) = (0._db,0._db)
            secmmia(:,:,0) = (0._db,0._db)

            do ia = 1,natomsym

              if( idafs ) then
                if( green_plus ) then
! Le exp(iQr) est converti. On recupere le complexe conjugue dans convolution.
                  ph = conjg( phdafs(ia,ipldafs) )
                else
                  ph = phdafs(ia,ipldafs)
                endif
              else
                ph = (1._db, 0._db) * Taux_eq(ia)
              endif
                      
              if( comp_dd ) secddia(:,:,0) = secddia(:,:,0) 
     &                                     + ph * secddia(:,:,ia)

              if( comp_dq ) secdqia(:,:,:,0) = secdqia(:,:,:,0) 
     &                               + ph * real( secdqia(:,:,:,ia), db)

      !             if( comp_dq .and. magn_sens ) secdqia_mag(:,:,:) = 
      !&        secdqia_mag(:,:,:) + img * ph*aimag( secdqia(:,:,:,ia) )

              if( comp_qq ) secqqia(:,:,:,:,0) = secqqia(:,:,:,:,0)
     &                                        + ph * secqqia(:,:,:,:,ia)

              if( comp_do ) secdoia(:,:,:,:,0) = secdoia(:,:,:,:,0)
     &                                        + ph * secdoia(:,:,:,:,ia)

              if( comp_md ) secmdia(:,:,0) = secmdia(:,:,0)
     &                                     + ph * secmdia(:,:,ia)

              if( comp_mm ) secmmia(:,:,0) = secmmia(:,:,0)
     &                                     + ph * secmmia(:,:,ia)

            end do

 1010       continue

            if( icheck(21) > 0 .or. cartesian_tensor ) then
              if( icheck(21) /= 0 .and. nspinr == 2 .and. ipl == 1) then
                if( ispinr == 1 ) then
                  write(3,140)
                else
                  write(3,145)
                endif
              endif
              do ib = 0,nb
                if( natomsym == 1 .and. ib > 0 ) cycle
                if( ib == 0 ) then
                  ia = 1
                elseif( ib == 1 ) then
                  ia = 0
                else
                  ia = ib
                endif
                if( ia /= 0 .and. ipl > 1 ) cycle
                if( ipl > 1 .and. .not. idafs ) cycle
                if( cartesian_tensor )
     &            call write_cartesian_tensor(E_cut,ephseuil,
     &               Epsii,Eseuil(iseuil),
     &               ia,ie,ipldafs,length_word,magn_sens,natomsym,
     &               nomfich1,numat_abs,secddia,secdqia,secdqia_mag,
     &               secqqia,secmdia,tens_comp,v0muf)
                if( icheck(21) == 0 ) cycle
                if( idafs .and. icheck(21) < 3 ) cycle
                if( ipl > 1 ) write(3,146) ipldafs
                if( comp_dd ) then
                  if( ia == 1 ) then
                    write(3,147)
                  elseif( ia == 0 ) then
                    write(3,148)
                  else
                    write(3,149) ia
                  endif
                  do ke = 1,3
                    if( tens_comp ) then
                      write(3,150) secddia(ke,:,ia)
                    else
                      write(3,150) real( secddia(ke,:,ia) )
                    endif
                  end do
                endif
                if( comp_dq ) then
                  do ke = 1,3
                    if( ia == 1 ) then
                      write(3,160) ke
                    elseif( ia == 0 ) then
                      if( magn_sens ) then
                        write(3,161) ke
                      else
                        write(3,162) ke
                      endif
                    else
                      write(3,163) ia, ke
                    endif
                    do ks = 1,3
                      if( magn_sens .and. ia == 0 ) then
                        write(3,150) secdqia(ke,ks,:,ia),
     &                               secdqia_mag(ke,ks,:)
                      elseif( tens_comp ) then
                        write(3,150) secdqia(ke,ks,:,ia)
                      else
                        write(3,150) real(secdqia(ke,ks,:,ia),db)
                      endif
                    end do
                  end do
                endif
                if( comp_qq ) then
                  do js = 1,3
                    do ks = 1,3
                      if( ia == 1 ) then
                        write(3,170) ks, js
                      elseif( ia == 0 ) then
                        write(3,171) ks, js
                      else
                        write(3,172) ia, ks, js
                      endif
                      do ke = 1,3
                        if( tens_comp ) then
                          write(3,150) secqqia(ke,1:3,ks,js,ia)
                        else
                          write(3,150) real(secqqia(ke,1:3,ks,js,ia),db)
                        endif
                      end do
                    end do
                  end do
                endif
                if( comp_do ) then
                  do ke = 1,3
                    do ks = 1,3
                      if( ia == 1 ) then
                        write(3,180) ke, ks
                      elseif( ia == 0 ) then
                        write(3,181) ke, ks
                      else
                        write(3,182) ia, ke, ks
                      endif
                      do j1 = 1,3
                        if( tens_comp ) then
                          write(3,150) secdoia(ke,ks,j1,:,ia)
                        else
                          write(3,150) real( secdoia(ke,ks,j1,:,ia),db)
                        endif
                      end do
                    end do
                  end do
                endif
                if( comp_md ) then
                  if( ia == 1 ) then
                    write(3,183)
                  elseif( ia == 0 ) then
                    write(3,184)
                  else
                    write(3,185) ia
                  endif
                  do ke = 1,3
                    if( tens_comp ) then
                      write(3,150) secmdia(ke,:,ia)
                    else
                      write(3,150) real( secmdia(ke,:,ia),db )
                    endif
                  end do
                endif
                if( comp_mm ) then
                  if( ia == 1 ) then
                    write(3,186)
                  elseif( ia == 0 ) then
                    write(3,187)
                  else
                    write(3,188) ia
                  endif
                  do ke = 1,3
                    if( tens_comp ) then
                      write(3,150) secmmia(ke,:,ia)
                    else
                      write(3,150) real( secmmia(ke,:,ia),db )
                    endif
                  end do
                endif
              end do
            endif

            np = 1
            if( idafs ) then
              if( angpoldafs(1,ipldafs) < -9999._db .or.
     &            angpoldafs(2,ipldafs) < -9999._db .or.
     &            angpoldafs(3,ipldafs) < -9999._db ) np = nphim
            endif

            do ip = 1,np
        
              if( ip > 1 ) then
                plae(:) = poldafsescan(:,ipldafs,ip)
                plas(:) = poldafssscan(:,ipldafs,ip)
              else
                plae(:) = ple(:,ipl)
                plas(:) = pls(:,ipl)
              endif
              if( green_plus .and. idafs ) then
! Dans convolution on reprend le complexe conjugue de l'ensemble
! polarisation x diffusion
                plae(:) = conjg( plae(:) )
                plas(:) = conjg( plas(:) )
              endif

              if( comp_dq .or. comp_qq .or. comp_do ) then
                if( ip > 1 ) then
                  voae(:) = vecdafsescan(:,ipldafs,ip)
                  voas(:) = vecdafssscan(:,ipldafs,ip)
                else
                  voae(:) = voe(:,ipl)
                  voas(:) = vos(:,ipl)
                endif
              endif

              do ia = 0,na

                if( comp_dd ) then
                  sec = (0._db,0._db)
                  do ke = 1,3
                    sec = sec + plae(ke) 
     &                  * sum( conjg( plas(:) ) * secddia(:,ke,ia) )
                  end do
! Il manque un facteur pi qui a deja ete pris en compte dans le calcul
! du tenseur dans la routine Tens_ab.
                  if( idafs ) then
                    if( ip == 1 ) ampldafsdd(ipldafs,ia) = sec
                    if( np > 1 ) ampldafsscandd(ipldafs,ip,ia) = sec
                  else
                    secabsdd(jpl,ia) = real( sec,db )
                  endif
                endif

                if( comp_dq ) then
                  sec = (0._db,0._db)
                  do ke = 1,3
                    do ks = 1,3
                      if( ia == 0 ) then
                        sec = sec + conjg( plas(ks) ) * plae(ke)
     &                      * sum( voae(:) * secdqia(ks,ke,:,ia)
     &                           - voas(:) * secdqia(ke,ks,:,ia) )
                        if( magn_sens )     
     &                    sec = sec + conjg( plas(ks) ) * plae(ke)
     &                        * sum( voae(:) * secdqia_mag(ks,ke,:)
     &                             + voas(:) * secdqia_mag(ke,ks,:) )
                      else
                        sec = sec + conjg( plas(ks) ) * plae(ke)
     &                      * sum( voae(:) * secdqia(ks,ke,:,ia)
     &                      - voas(:) * conjg( secdqia(ke,ks,:,ia) ) )
                      endif
                    end do
                  end do

                  if( green_plus .and. idafs ) then
                    sec = - img * sec  
                  else
                    sec = img * sec      ! C'est ici qu'on recupere le img
                  endif
                  if( idafs ) then
                    if( ip == 1 ) ampldafsdq(ipldafs,ia) = sec
                    if( np > 1 ) ampldafsscandq(ipldafs,ip,ia) = sec
                  else
                    secabsdq(jpl,ia) = real( sec,db )
                  endif
                endif

                if( comp_qq ) then
                  sec = (0._db,0._db)
                  do ke = 1,3
                    do je = 1,3
                      do ks = 1,3
                        sec = sec
     &                      + conjg( plas(ks) ) * plae(ke) * voae(je)
     &                      * sum( voas(:) * secqqia(ks,:,ke,je,ia) )
                      end do
                    end do
                  end do
                  if( idafs ) then
                    if( ip == 1 ) ampldafsqq(ipldafs,ia) = sec
                    if( np > 1 ) ampldafsscanqq(ipldafs,ip,ia) = sec
                  else
                    secabsqq(jpl,ia) = real( sec,db )
                  endif
                endif

                if( comp_do ) then
                  sec = (0._db,0._db)
                  do ke = 1,3
                    do ks = 1,3
                      do j1 = 1,3
                        sec = sec + conjg( plas(ks) ) * plae(ke)
     & * ( voae(j1) * sum( voae(:) * secdoia(ks,ke,j1,:,ia) )
     &   + voas(j1) * sum( voas(:) * conjg( secdoia(ke,ks,j1,:,ia) ) ) )
                      end do
                    end do
                  end do
                  if( idafs ) then
                    if( ip == 1 ) ampldafsdo(ipldafs,ia) = sec
                    if( np > 1 ) ampldafsscando(ipldafs,ip,ia) = sec
                  else
                    secabsdo(jpl,ia) = real( sec,db )
                  endif
                endif

              end do   ! Fin de la boucle sur les atomes

              if( ltypcal(ipl) == 'xanes circ d' ) jpl = jpl + 1

            end do

            if( spherical_tensor .and. ( ipl == 1 .or. ipl > nplr) ) 
     &        call spherical_tensor_cal(ct_nelec,E_cut,energ,
     &          ephseuil,Epsii,eseuil(iseuil),
     &          ie,Int_tens,ipl,Length_word,magn_sens,
     &          moyenne,natomsym,nb,ncolm,nenerg,nomfich1,npldafs,
     &          nplr,nplt,npltm,numat_abs,pdp,phdf0t,phdt,ple,pls,
     &          secddia,secdqia,secdqia_mag,secqqia,v0muf,voe,vos)

          end do   ! Fin de la boucle sur les polarisation
          end do   

          do ia = 0,na

            if( moyenne ) then
              if( xan_atom ) then
                np = ncolr - 2
                i = ncolr - 1
              else
                np = ncolr - 1
                i = ncolr
              endif
              if( comp_dd ) secabsdd(i,ia)
     &                          = sum( pdp(1:np,1) * secabsdd(1:np,ia) )
              if( comp_dq ) secabsdq(i,ia) = (0._db,0._db)
              if( comp_qq ) secabsqq(i,ia) 
     &                          = sum( pdp(1:np,2) * secabsqq(1:np,ia) )
              if( comp_do ) secabsdo(i,ia)
     &                          = sum( pdp(1:np,1) * secabsdo(1:np,ia) )
            endif

            jpl = 0
            do ipl = 1,nplr
              jpl = jpl + 1
              if( ltypcal(ipl) /= 'xanes circ d' ) cycle
              jpl = jpl + 1
              ig = jpl - 1
              id = jpl - 2
              if( comp_dd ) secabsdd(jpl,ia) = secabsdd(id,ia)
     &                                       - secabsdd(ig,ia)
              if( comp_dq ) secabsdq(jpl,ia) = secabsdq(id,ia)

     &                                       - secabsdq(ig,ia)
              if( comp_qq ) secabsqq(jpl,ia) = secabsqq(id,ia)
     &                                       - secabsqq(ig,ia)
              if( comp_do ) secabsdo(jpl,ia) = secabsdo(id,ia)
     &                                       - secabsdo(ig,ia)
            end do

            if( xan_atom ) then
              if( ia == 0 ) then
                secabsdd(ncolr,ia) = sec_atom(iseuil) * natomsym
              else
                secabsdd(ncolr,ia) = sec_atom(iseuil)
              endif 
            endif

            secabs(:,ia) = 0._db
            if( comp_dd ) secabs(:,ia) = secabs(:,ia) + secabsdd(:,ia)
            if( comp_dq ) secabs(:,ia) = secabs(:,ia) + secabsdq(:,ia)
            if( comp_qq ) secabs(:,ia) = secabs(:,ia) + secabsqq(:,ia)
            if( comp_do ) secabs(:,ia) = secabs(:,ia) + secabsdo(:,ia)

            if( dafs ) then
              ampldafs(:,ia) = (0._db,0._db)
              if( comp_dd ) ampldafs(:,ia) = ampldafs(:,ia)
     &                                     + ampldafsdd(:,ia)
              if( comp_dq ) ampldafs(:,ia) = ampldafs(:,ia) 
     &                                     + ampldafsdq(:,ia)
              if( comp_qq ) ampldafs(:,ia) = ampldafs(:,ia) 
     &                                     + ampldafsqq(:,ia)
              if( comp_do ) ampldafs(:,ia) = ampldafs(:,ia)
     &                                     + ampldafsdo(:,ia)
            endif

            if( scan_true ) then
              ampldafsscan(:,:,ia) = (0._db,0._db)
              if( comp_dd ) ampldafsscan(:,:,ia) = ampldafsscan(:,:,ia)
     &                                          + ampldafsscandd(:,:,ia)
              if( comp_dq ) ampldafsscan(:,:,ia) = ampldafsscan(:,:,ia)
     &                                          + ampldafsscandq(:,:,ia)
              if( comp_qq ) ampldafsscan(:,:,ia) = ampldafsscan(:,:,ia)
     &                                          + ampldafsscanqq(:,:,ia)
              if( comp_do ) ampldafsscan(:,:,ia) = ampldafsscan(:,:,ia)
     &                                          + ampldafsscando(:,:,ia)
            endif

! Conversion en nombre d'electrons
            if( dafs ) then
              ampldafs(:,ia) = ct_nelec * ampldafs(:,ia)
              if( comp_dd ) ampldafsdd(:,ia) = ct_nelec*ampldafsdd(:,ia)
              if( comp_dq ) ampldafsdq(:,ia) = ct_nelec*ampldafsdq(:,ia)
              if( comp_qq ) ampldafsqq(:,ia) = ct_nelec*ampldafsqq(:,ia)
              if( comp_do ) ampldafsdo(:,ia) = ct_nelec*ampldafsdo(:,ia)
            endif
            if( scan_true ) then
              ampldafsscan(:,:,ia) = ct_nelec * ampldafsscan(:,:,ia)
              if( comp_dd ) ampldafsscandd(:,:,ia) = ct_nelec
     &                                          * ampldafsscandd(:,:,ia)
              if( comp_dq ) ampldafsscandq(:,:,ia) = ct_nelec 
     &                                          * ampldafsscandq(:,:,ia)
              if( comp_qq ) ampldafsscanqq(:,:,ia) = ct_nelec 
     &                                          * ampldafsscanqq(:,:,ia)
              if( comp_do ) ampldafsscando(:,:,ia) = ct_nelec 
     &                                          * ampldafsscando(:,:,ia)
            endif

            if( icheck(21) > 0 ) then
              if( ia == 0 ) write(3,283) ct_nelec * pi
              if( ia == 0 ) then
                write(3,285)
              else
                write(3,290) ia
              endif
              do ipl = 1,ncolt
                nomab = nomabs(ipl)
                call center_word(nomab,13)
                nomabs(ipl) = nomab
              end do
              nccm = 20
              nl = 1 + ( ncolr - 1 ) / nccm
              do i = 1,nl
                ic1 = 1 + ( i - 1 ) * nccm
                ic2 = min( i * nccm, ncolr )
                write(3,300) nomabs(ic1:ic2)
                write(3,310) ephseuil*rydb, secabs(ic1:ic2,ia)
                if( comp_dd .and. ( comp_dq .or. comp_qq .or. comp_do ))
     &            write(3,320) secabsdd(ic1:ic2,ia)
                if( comp_dq .and. ( comp_dd .or. comp_qq .or. comp_do ))
     &            write(3,330) secabsdq(ic1:ic2,ia)
                if( comp_qq .and. ( comp_dd .or. comp_qq .or. comp_do ))
     &            write(3,340) secabsqq(ic1:ic2,ia)
                if( comp_do .and. ( comp_dd .or. comp_dq .or. comp_qq ))
     &            write(3,350) secabsdo(ic1:ic2,ia)
              end do
              if( dafs ) then
                if( self_abs ) then
                  nc = 4
                else
                  nc = 2
                endif
                nl = 1 + ( nc * npldafs - 1 ) / nccm
                do i = 1,nl
                  icn1 = 1 + ( i - 1 ) * nccm
                  icn2 = min( i * nccm, nc * npldafs )
                  ic1 = 1 + ( i - 1 ) * (nccm/nc)
                  ic2 = min( i * (nccm/nc), npldafs )
                  write(3,360) nomabs(ncolr+icn1:ncolr+icn2)
                  if( self_abs ) then
                    write(3,370) ( ampldafs(ic,ia), 
     &                secabs(ncolr+2*ic-1:ncolr+2*ic,ia), ic = ic1,ic2 )
                    if( comp_dd .and. ( comp_dq .or.comp_qq.or.comp_do))
     &                write(3,320) ( ampldafsdd(ic,ia), 
     &                secabsdd(ncolr+2*ic-1:ncolr+2*ic,ia), ic =ic1,ic2)
                    if( comp_dq .and. ( comp_dd .or.comp_qq.or.comp_do))
     &                write(3,330) ( ampldafsdq(ic,ia), 
     &                secabsdq(ncolr+2*ic-1:ncolr+2*ic,ia), ic =ic1,ic2)
                    if( comp_qq .and. ( comp_dd .or.comp_qq.or.comp_do))
     &                write(3,340) ( ampldafsqq(ic,ia), 
     &                secabsqq(ncolr+2*ic-1:ncolr+2*ic,ia), ic =ic1,ic2)
                    if( comp_do .and. ( comp_dd .or.comp_dq.or.comp_qq))
     &                write(3,350) ( ampldafsdo(ic,ia), 
     &                secabsdo(ncolr+2*ic-1:ncolr+2*ic,ia), ic =ic1,ic2)
                  else
                    write(3,370) ampldafs(ic1:ic2,ia)
                    if( comp_dd .and. ( comp_dq .or.comp_qq.or.comp_do))
     &                write(3,320) ampldafsdd(ic1:ic2,ia)
                    if( comp_dq .and. ( comp_dd .or.comp_qq.or.comp_do))
     &                write(3,330) ampldafsdq(ic1:ic2,ia)
                    if( comp_qq .and. ( comp_dd .or.comp_qq.or.comp_do))
     &                write(3,340) ampldafsqq(ic1:ic2,ia)
                    if( comp_do .and. ( comp_dd .or.comp_dq.or.comp_qq))
     &                write(3,350) ampldafsdo(ic1:ic2,ia)
                  endif
                end do
              endif
            endif

            if( ie == 1 .and. iseuil == 1 .and. ispinr == 1 
     &                  .and. ia == 0) write(6,392) nenerg

            nomficht = nomfich1
            nomfichdafst = nomfich1

            if( ia > 0 ) then
              long = len_trim(nomficht)
              nomficht(long+1:long+5) = '_atom'
              call ad_number(ia,nomficht,132)
              nomfichdafst(long+1:long+5) = '_atom'
              call ad_number(ia,nomfichdafst,132)
            endif
            long = len_trim(nomficht)
            nomficht(long+1:long+4) = '.txt'
            nomfichdafst(long+1:long+9) = '_scan.txt'

            if( ie == 1 .and. ispinr == 1 )
     &        nomfich_cal_convt(iseuil) = nomficht

            title(1:ncolt-nxanout+1) = nomabs(nxanout:ncolt)
            ipl = ncolr - nxanout + 1
            Tens(1:ipl) = secabs(nxanout:ncolr,ia) 
            do ipldafs = 1,npldafs
              if( ia == 0 ) then
                cf = ampldafs(ipldafs,ia) 
              else
                if( green_plus ) then
! Le exp(iQr) est converti. On recupere le complexe conjugue dans convolution.
                  cf = conjg( phdafs(ia,ipldafs) ) *ampldafs(ipldafs,ia)
                else
                  cf = phdafs(ia,ipldafs) * ampldafs(ipldafs,ia)
                endif
              endif
              ipl = ipl + 1
              Tens(ipl) = real( cf,db )
              ipl = ipl + 1
              Tens(ipl) = aimag( cf )
              if( self_abs ) then
                ipl = ipl + 1
                Tens(ipl) = secabs(ncolr+2*ipldafs-1,ia)
                ipl = ipl + 1
                Tens(ipl) = secabs(ncolr+2*ipldafs,ia)
              endif
            end do

            n_tens = ipl
            if( ia == 0 ) then
              phdtem(:) = phdt(:)
            else
              phdtem(:) = phdafs(ia,:)
            endif

            call write_out(fpp_avantseuil,E_cut,ephseuil,
     &             Epsii,eseuil(iseuil),ie,Length_word,
     &             lseuil,ncolm,n_tens,nomficht,title,
     &             npldafs,npldafs,nseuil,numat_abs,phdtem,phdf0t,
     &             tens,v0muf)

            if( ia == 0 ) then
              if( iseuil == 1 .and. ispinr == 1 ) then
                call write_out(fpp_avantseuil,E_cut,ephseuil,
     &               Epsii,eseuil(iseuil),ie,Length_word,
     &               lseuil,ncolm,n_tens,nomficht,title,npldafs,npldafs,
     &               nseuil,-1,phdtem,phdf0t,tens,v0muf)
              else
                call write_out(fpp_avantseuil,E_cut,ephseuil,
     &               Epsii,eseuil(iseuil),2,Length_word,
     &               lseuil,ncolm,n_tens,nomficht,title,npldafs,npldafs,
     &               nseuil,-1,phdtem,phdf0t,tens,v0muf)
              endif
            endif

            if( npldafs > 0 ) then
              if( scan_true ) then
                if( ie == 1 ) then
                  open(7, file = nomfichdafst)
                  do ipl = 1,npldafs
                    if( angpoldafs(1,ipl) > -9999._db .and.
     &                  angpoldafs(2,ipl) > -9999._db .and.
     &                  angpoldafs(3,ipl) > -9999._db ) then
                      np = 1
                    else
                      np = nphim
                    endif
                    write(7,400) np
                  end do
                else
                  open(7, file = nomfichdafst, position='append')
                endif
                mot = ' '
                mot(6:16) = 'Amplitude'
                i = 23
                mot(i+1:i+26) = '   Non-resonant Amplitude '
                i = i + 26
                mot(i+1:i+26) = ' e_s.e_i * Somme_exp(iQR) '
                i = i + 26
                if( comp_dd .and. ( comp_dq .or. comp_qq .or.
     &              comp_do ) ) then
                  mot(i+1:i+26) = '       Dipole-Dipole      '
                  i = i + 26
                endif
                if( comp_dq ) then
                  mot(i+1:i+26) = '     Dipole-Quadrupole    '
                  i = i + 26
                endif
                if( comp_qq ) then
                  mot(i+1:i+26) = '  Quadrupole-Quadrupole   '
                  i = i + 26
                endif
                if( comp_do ) then
                  mot(i+1:i+26) = '      Dipole-Octupole     '
                  i = i + 26
                endif
                write(7,405) ephseuil*rydb, mot
                do ipl = 1,npldafs
                  write(7,410) hkl_dafs(:,ipl), isigpi(ipl,:)
                  if( angpoldafs(1,ipl) > -9999._db .and.
     &                angpoldafs(2,ipl) > -9999._db .and.
     &                angpoldafs(3,ipl) > -9999._db ) then
                    if( ia == 0 ) then 
                      write(7,420) ampldafs(ipl,ia)
                    else
                      if( green_plus ) then
! Le exp(iQr) est converti. On recupere le complexe conjugue dans convolution.
                        write(7,420) conjg( phdafs(ia,ipl) )
     &                                  * ampldafs(ipl,ia)
                      else
                        write(7,420) phdafs(ia,ipl) * ampldafs(ipl,ia)
                      endif
                   endif
                  else
                    dang = 360. / nphim
                    do ip = 1,nphim
                      ang = ( ip - 1 ) * dang
                      if( ia == 0 ) then
                        cf = (1._db,0._db)
                      else
                        cf = phdafs(ia,ipl)
                        if( green_plus ) cf = conjg( cf )
                      endif
                      nw = 1
                      compnum(nw) = cf * ampldafsscan(ipl,ip,ia)
                      nw = nw + 1
                      compnum(nw) = phdf0tscan(ipl,ip)
                      nw = nw + 1
                      compnum(nw) = phdtscan(ipl,ip)
                      if( comp_dd .and. ( comp_dq .or. comp_qq .or.
     &                    comp_do ) ) then
                        nw = nw + 1
                        compnum(nw) = cf * ampldafsscandd(ipl,ip,ia)
                      endif
                      if( comp_dq ) then
                        nw = nw + 1
                        compnum(nw) = cf * ampldafsscandq(ipl,ip,ia)
                      endif
                      if( comp_qq ) then
                        nw = nw + 1
                        compnum(nw) = cf * ampldafsscanqq(ipl,ip,ia)
                      endif
                      if( comp_do) then
                        nw = nw + 1
                        compnum(nw) = cf * ampldafsscando(ipl,ip,ia)
                      endif
                      write(7,430) ang, compnum(1:nw)
                    end do
                  endif
                end do
                close(7)
              endif
            endif

          end do

          if( dafs ) then
            deallocate( ampldafs )
            if( comp_dd ) deallocate( ampldafsdd )
            if( comp_dq ) deallocate( ampldafsdq )
            if( comp_qq ) deallocate( ampldafsqq )
            if( comp_do ) deallocate( ampldafsdo )
            if( scan_true ) then
              deallocate( ampldafsscan )
              if( comp_dd ) deallocate( ampldafsscandd )
              if( comp_dq ) deallocate( ampldafsscandq )
              if( comp_qq ) deallocate( ampldafsscanqq )
              if( comp_do ) deallocate( ampldafsscando )
            endif
          endif

        end do  ! ------> Fin de la boucle sur la sortie resolue en spin

      end do ! Fin de la boucle sur les seuil

      return
  120 format(/' ---- Coabs --------',100('-'))
  130 format(/' Threshold ',a3)
  140 format(/' Spin Up')
  145 format(/' Spin Down')
  146 format(/8x,' RXS polarization number',i3)
  147 format(/' Tensor_dd(ke,ks), prototypical atom (Mbarn)')
  148 format(/' Crystal Tensor_dd(ke,ks) (Mbarn)')
  149 format(/' Atom ',i3,' Tensor_dd(ke,ks) (Mbarn)')
  150 format(1p,2(6e18.10,2x))
  160 format(/' Tensor_dq(',i1,',ks,j2), prototypical atom')
  161 format(/' Crystal Tensor_dq(',i1,',ks,j2)',20x,
     &        'Non magnetic part',95x,'Magnetic part')
  162 format(/' Crystal Tensor_dq(',i1,',ks,j2)')
  163 format(/' Atom ',i3,' Tensor_dq(',i1,',ks,j2)')
  170 format(/' Tensor_qq(ke,je,',i1,',',i1,'), prototypical atom')
  171 format(/' Crystal Tensor_qq(ke,je,',i1,',',i1,')')
  172 format(/' Atom ',i3,' Tensor_qq(ke,je,',i1,',',i1,')')
  180 format(/' Tensor_do(',i1,',',i1,',j1,j2), prototypical atom')
  181 format(/' Crystal Tensor_do(',i1,',',i1,',j1,j2)')
  182 format(/' Atom ',i3,' Tensor_do(',i1,',',i1,',j1,j2)')
  183 format(/' Tensor_md(ke,ks), prototypical atom (Mbarn)')
  184 format(/' Crystal Tensor_md(ke,ks) (Mbarn)')
  185 format(/' Atom ',i3,' Tensor_md(ke,ks) (Mbarn)')
  186 format(/' Tensor_mm(ke,ks), prototypical atom (Mbarn)')
  187 format(/' Crystal Tensor_mm(ke,ks) (Mbarn)')
  188 format(/' Atom ',i3,' Tensor_mm(ke,ks) (Mbarn)')
  283 format(/' Convertion factor =',f10.5,' (numb. of electron/Mbarn)')
  285 format(/'   Total signal')
  290 format(/'   Signal atom',i3)
  300 format(/4x,'Energy',240a13)
  310 format(f10.3,1p,240e13.5)
  320 format('   dip-dip',1p,240e13.5)
  330 format('   dip-qua',1p,240e13.5)
  340 format('   qua-qua',1p,240e13.5)
  350 format('   dip-oct',1p,240e13.5)
  360 format(/10x,1p,240a13)
  370 format('  Ampldafs',1p,240e13.5)
  392 format(' Number of energies =',i5)
  400 format(i5,4x,'2 = Number of angles')
  405 format(f10.3,A)
  410 format(' (h,k,l) = ',3i3,', sigpi =',2i3)
  420 format('    0.0',1p,240e13.5)
  430 format(f7.1,1p,240e13.5)
      end

!***********************************************************************

! Calcul du facteur de conversion Mbarn --> nbr. d'elec ( divise par pi )

      function conv_mbarn_nelec(ephoton)

      use declarations
      implicit real(kind=db) (a-h,o-z)

! Calcul de la constante multiplicative.
  ! ptrans = S02 fixe a 1.
      ptrans = 1
  ! alfa = e*e/(2*epsilon0*h*c) = 0.0072973531 = 1/137.036 est la
  ! constante de structure fine.
      alfa = 0.0072973531
      cst = quatre_pi * pi * ptrans * alfa * ephoton
  ! pour avoir le resultat en megabarn (10E-18 cm2)
      cst = 100 * bohr**2 * cst

      eph2 = 0.5 * ephoton**2
! Constante multiplication pour avoir le resultat en nombre d'electron
      conv_mbarn_nelec = eph2 / cst

      return
      end

!***********************************************************************

      subroutine write_cartesian_tensor(E_cut,ephseuil,Epsii,eseuil,
     &               ia,ie,ipldafs,Length_word,magn_sens,natomsym,
     &               nomfich1,numat_abs,secddia,secdqia,secdqia_mag,
     &               secqqia,secmdia,tens_comp,v0muf)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      parameter( n_dim=168+12 )

      character(len=132) nomficht, nomfich1
      character(len=Length_word) mot
      character(len=Length_word), dimension(n_dim):: nomtens

      complex(kind=db), dimension(1):: cdum
      complex(kind=db), dimension(3,3,0:natomsym):: secddia, secmdia
      complex(kind=db), dimension(3,3,3):: secdqia_mag
      complex(kind=db), dimension(3,3,3,0:natomsym):: secdqia
      complex(kind=db), dimension(3,3,3,3,0:natomsym):: secqqia
      
      logical comp_dd, comp_md, comp_do, comp_dq, comp_mm, comp_qq,
     &        magn_sens, tens_comp

      real(kind=db), dimension(n_dim):: Tens

      common/lseuil/ jseuil, lseuil, nseuil
      common/comp_dd/ comp_dd, comp_md, comp_do, comp_dq,comp_mm,comp_qq 

      nomficht = nomfich1
      long = len_trim(nomficht)
      if( ia == 0 ) then
        nomficht(long+1:long+9) = '_car_xtal'
        if( ipldafs > 0 ) then
          nomficht(long+10:long+13) = '_rxs'
          call ad_number(ipldafs,nomficht,132)
        endif
      else
        nomficht(long+1:long+9) = '_car_atom'
        call ad_number(ia,nomficht,132)
      endif
      long = len_trim(nomficht)
      nomficht(long+1:long+4) = '.txt'

      index = 0
      mot = ' '
      mot(1:2) = 'D_'
      do i = 1,3
        mot(3:3) = achar(i+119) 
        do j = i,3
          index = index + 1
          mot(4:4) = achar(j+119) 
          if( tens_comp ) mot(5:6) = '_r'
          Tens(index) = real( secddia(i,j,ia),db ) 
          nomtens(index) = mot
          if( tens_comp ) then
            index = index + 1 
            mot(6:6) = 'i'
            nomtens(index) = mot
            Tens(index) = aimag( secddia(i,j,ia) ) 
          endif 
        end do
      end do
      if( comp_dq ) then
        mot(1:2) = 'I_'
        do i = 1,3
          mot(3:3) = achar(i+119) 
          do j = 1,3
            mot(4:4) = achar(j+119) 
            do k = j,3
              mot(5:5) = achar(k+119)
              index = index + 1 
              if( tens_comp ) mot(6:7) = '_r'
              nomtens(index) = mot
              Tens(index) = real( secdqia(i,j,k,ia),db ) 
              if( tens_comp ) then
                index = index + 1 
                mot(7:7) = 'i'
                nomtens(index) = mot
                Tens(index) = aimag( secdqia(i,j,k,ia) ) 
              endif
              if( ia == 0 .and. magn_sens ) then
                index = index+1
                mot(7:11) = 'r_mag'
                nomtens(index) = mot
                Tens(index) = real( secdqia_mag(i,j,k),db ) 
                index = index+1
                mot(7:7) = 'i'
                nomtens(index) = mot
                mot(7:11) = '    '
                Tens(index) = aimag( secdqia_mag(i,j,k) ) 
              endif 
            end do
          end do
        end do
      endif
      if( comp_qq ) then
        mot = ' '
        mot(1:2) = 'Q_'
        do i = 1,3
          mot(3:3) = achar(i+119)
          do j = i,3
            mot(4:4) = achar(j+119)
            do k = j,3
              mot(5:5) = achar(k+119)
              do l = k,3
                mot(6:6) = achar(l+119)
                index = index + 1
                if( tens_comp ) mot(7:8) = '_r'
                nomtens(index) = mot
                Tens(index) = real( secqqia(i,j,k,l,ia),db ) 
                if( tens_comp ) then
                  index = index + 1 
                  mot(8:8) = 'i'
                  nomtens(index) = mot
                  Tens(index) = aimag( secqqia(i,j,k,l,ia) ) 
                endif 
              end do
            end do
          end do
        end do
        mot(3:5) = 'xzy'
        do i = 1,3
          mot(6:6) = achar(i+119)
          index = index + 1
          if( tens_comp ) mot(7:8) = '_r'
          nomtens(index) = mot
          if( tens_comp ) then
            index = index + 1 
            mot(8:8) = 'i'
            nomtens(index) = mot
          endif 
        end do
        do i = 1,2
          mot(3:3) = achar(i+119)
          mot(5:5) = achar(i+119)
          do j = i+1,3
            mot(4:4) = achar(j+119)
            mot(6:6) = achar(j+119)
            index = index + 1
            if( tens_comp ) mot(7:8) = '_r'
            nomtens(index) = mot
            if( tens_comp ) then
              index = index + 1 
              mot(8:8) = 'i'
              nomtens(index) = mot
            endif 
          end do
        end do
      endif
      if( comp_mm ) then
        mot = ' '
        mot(1:2) = 'M_'
        do i = 1,3
          mot(3:3) = achar(i+119) 
          do j = i,3
            index = index + 1
            mot(4:4) = achar(j+119) 
            if( tens_comp ) mot(5:6) = '_r'
            Tens(index) = real( secmdia(i,j,ia),db ) 
            nomtens(index) = mot
            if( tens_comp ) then
              index = index + 1 
              mot(6:6) = 'i'
              nomtens(index) = mot
              Tens(index) = aimag( secmdia(i,j,ia) ) 
            endif 
          end do
        end do
      endif
      n_tens = index

      call write_out(0._db,E_cut,ephseuil,
     &               Epsii,eseuil,ie,Length_word,
     &               lseuil,n_dim,n_tens,nomficht,nomtens,1,0,nseuil,
     &               numat_abs,cdum,cdum,tens,v0muf)

      return
      end

!***********************************************************************

      subroutine write_out(fpp_avantseuil,E_cut,ephseuil,
     &      Epsii,eseuil,ie,Length_word,
     &      lseuil,n_dim,n_tens,nomficht,title,np,npp,
     &      nseuil,numat,ph1,ph2,tens,v0muf)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      parameter(n_tens_max = 240)

      character(len=132) nomficht
      character(len=Length_word):: mot
      character(len=Length_word), dimension(n_dim):: title
      character(len=10+(n_tens-2*npp)*Length_word):: dummy

      complex(kind=db), dimension(np):: ph1, ph2

      real(kind=db), dimension(n_dim):: Tens

      dummy = ' '

      if( numat == -1 ) then
        ipr = 6
      elseif( numat < -1 ) then
        ipr = - numat 
      else
        ipr = 4
      endif

      if( ipr == 6 ) then
        n = min(n_tens,4)
      else
        n = n_tens
      endif

      if( n_tens > n_tens_max ) then
        call write_error
        do ipr = 6,9,3
          write(ipr,105) n_tens
        end do
        stop
      endif

      if( ie == 1 ) then
        if( numat >= 0 ) then
          open(ipr, file = nomficht)
        elseif( numat < -1 ) then
          open(ipr, status='scratch')
        endif
        if( numat > 0 ) write(ipr,110) eseuil*rydb, numat, nseuil, 
     &                     lseuil, fpp_avantseuil, v0muf*rydb,
     &                     E_cut*rydb, Epsii*rydb
        if( npp > 0 .and. numat >= 0 ) then
          select case(Length_word)
            case(11)
              write(ipr,121) dummy, ph2(1:npp)
              write(ipr,121) dummy, ph1(1:npp)
            case(12)
              write(ipr,122) dummy, ph2(1:npp)
              write(ipr,122) dummy, ph1(1:npp)
            case(13)
              write(ipr,123) dummy, ph2(1:npp)
              write(ipr,123) dummy, ph1(1:npp)
            case(14)
              write(ipr,124) dummy, ph2(1:npp)
              write(ipr,124) dummy, ph1(1:npp)
            case(15)
              write(ipr,125) dummy, ph2(1:npp)
              write(ipr,125) dummy, ph1(1:npp)
            case(16)
              write(ipr,126) dummy, ph2(1:npp)
              write(ipr,126) dummy, ph1(1:npp)
            case(17)
              write(ipr,127) dummy, ph2(1:npp)
              write(ipr,127) dummy, ph1(1:npp)
            case default
              call write_error
              do ipr = 6,9,3
                write(ipr,130) Length_word
              end do
              stop
          end select
        endif
        do i = 1,n
          mot = title(i) 
          call center_word( mot, Length_word )
          title(i) = mot 
        end do
        write(ipr,140) title(1:n)
      elseif( numat >= 0 ) then
        open(ipr, file = nomficht, position='append')
      endif

      select case(Length_word)
        case(11)
          write(ipr,151) ephseuil*rydb, Tens(1:n)
        case(12)
          write(ipr,152) ephseuil*rydb, Tens(1:n)
        case(13)
          write(ipr,153) ephseuil*rydb, Tens(1:n)
        case(14)
          write(ipr,154) ephseuil*rydb, Tens(1:n)
        case(15)
          write(ipr,155) ephseuil*rydb, Tens(1:n)
        case(16)
          write(ipr,156) ephseuil*rydb, Tens(1:n)
        case(17)
          write(ipr,157) ephseuil*rydb, Tens(1:n)
        case default
          call write_error
          do ipr = 6,9,3
            write(ipr,130) Length_word
          end do
          stop
      end select

      if( numat >= 0 ) close(ipr)

      return
  105 format(//' The number of column to be written is ',i5,//
     &         ' This is greater than the maximum possible value',
     &         ' given in the routine write_out in the file coabs.f !',
     &        /' To change that you must modify the formats 121 up to',
     &         ' 157 in this routine and compile again.'//)
  110 format(f10.3,i5,2i3,3f12.5,f13.3,' = E_edge, Z, n_edge, l_edge,',
     &  ' Abs_before_edge, VO_interstitial, E_Fermi, Epsii')
  121 format(A,1p,240e11.3)
  122 format(A,1p,240e12.4)
  123 format(A,1p,240e13.5)
  124 format(A,1p,240e14.6)
  125 format(A,1p,240e15.7)
  126 format(A,1p,240e16.8)
  127 format(A,1p,240e17.9)
  130 format(//' Length_word =',i3,
     &         ' This parameter must be set between 11 and 17 !'//)
  140 format('    Energy',240A)
  151 format(f10.3,1p,240e11.3)
  152 format(f10.3,1p,240e12.4)
  153 format(f10.3,1p,240e13.5)
  154 format(f10.3,1p,240e14.6)
  155 format(f10.3,1p,240e15.7)
  156 format(f10.3,1p,240e16.8)
  157 format(f10.3,1p,240e17.9)
      end

!***********************************************************************

      subroutine center_word( mot, Length_word )

      character(len=*) mot
      character(len=Length_word) mot2

      mot2 = ' '
      mot = adjustl( mot )
      l = len_trim( mot )
      lshift = ( Length_word - l + 1 ) / 2
      lshift = max( 0, lshift )
      lm = min( l, Length_word ) 
      mot2(1+lshift:lm+lshift) = mot(1:lm)
      mot = mot2

      return
      end

!***********************************************************************

      subroutine ad_number(ib,nomfich,Length)

      character(len=Length) nomfich

      l = len_trim(nomfich)

      if( ib < 0 ) then
        l = l + 1
        if( l <= Length ) nomfich(l:l) = '-' 
      endif

      i = abs(ib)

      do iu = 2,10
        if( i / 10**(iu-1) < 1 ) exit
      end do
      iumax = iu - 1

      do iu = iumax,1,-1

        ipuis = 10**(iu-1)

        in = i / ipuis

! S'il n'y a pas la place on ecrit que les derniers chiffres
        if( l + iu <= Length ) then
          l = l + 1
          nomfich(l:l) = achar(in+48)
        elseif( l + iu == Length-1 .and. nomfich(l:l) == '_' ) then
          nomfich(l:l) = achar(in+48)
        endif

        i = i - ipuis * in

      end do

      return
      end

!***********************************************************************

      subroutine spherical_tensor_cal(ct_nelec,E_cut,energ,
     &      ephseuil,Epsii,eseuil,
     &      ie,Int_tens,kpl,Length_word,magn_sens,
     &      moyenne,natomsym,nb,ncolm,nenerg,nomfich1,npldafs,
     &      nplr,nplt,npltm,numat_abs,pdp,phdf0t,phdt,ple,pls,
     &      secddia,secdqia,secdqia_mag,secqqia,v0muf,voe,vos)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      parameter( n_tens_dd=9, n_tens_dq=15, n_tens_qq=25,
     &           n_tens_t = n_tens_dd + n_tens_dq + n_tens_qq,
     &           n_tens_max = 8 + 2 * n_tens_t + 2 * n_tens_dq ) 

      character(len=132) nomfich1

      complex(kind=db), dimension(n_tens_dd):: Sph_tensor_dd
      complex(kind=db), dimension(n_tens_dq):: Sph_tensor_dq,
     &                                        Sph_tensor_dq_mag
      complex(kind=db), dimension(n_tens_qq):: Sph_tensor_qq
      complex(kind=db), dimension(3,3):: secdd
      complex(kind=db), dimension(3,3,0:natomsym):: secddia
      complex(kind=db), dimension(3,3,3):: secdq, secdqia_mag
      complex(kind=db), dimension(3,3,3,0:natomsym):: secdqia
      complex(kind=db), dimension(3):: plae, plas
      complex(kind=db), dimension(3,3,3,3):: secqq
      complex(kind=db), dimension(3,3,3,3,0:natomsym):: secqqia
      complex(kind=db), dimension(3,npltm):: ple, pls
      complex(kind=db), dimension(0:nplt,n_tens_dd):: Tensor_pol_dd
      complex(kind=db), dimension(0:nplt,2*n_tens_dq):: Tensor_pol_dq
      complex(kind=db), dimension(0:nplt,n_tens_qq):: Tensor_pol_qq
      complex(kind=db), dimension(npldafs):: phdf0t, phdt 

      logical comp_dd, comp_md, comp_do, comp_dq, comp_mm, comp_qq,
     &        magn_sens, moyenne, writbav, writout 

      real(kind=db), dimension(3):: voae, voas
      real(kind=db), dimension(nenerg) :: energ
      real(kind=db), dimension(3,npltm):: voe, vos
      real(kind=db), dimension(ncolm,2) :: pdp
      real(kind=db), dimension(n_tens_max,0:natomsym):: Int_tens

      common/icheck/ icheck(24)
      common/comp_dd/ comp_dd, comp_md, comp_do, comp_dq,comp_mm,comp_qq 

      if( kpl == 1 ) then
        ipl1 = 1
        ipl2 = nplr
      else
        ipl1 = kpl
        ipl2 = kpl
      endif

      do ipl = ipl1,ipl2

        plae(:) = ple(:,ipl)
        plas(:) = pls(:,ipl)
        voae(:) = voe(:,ipl)
        voas(:) = vos(:,ipl)

        if( comp_dd ) call Tensor_pol_dd_cal(ipl,n_tens_dd,nplt,
     &                             plae,plas,Tensor_pol_dd)

        if( comp_dq ) call Tensor_pol_dq_cal(ipl,n_tens_dq,nplt,
     &                             plae,plas,voae,voas,Tensor_pol_dq)

        if( comp_qq ) call Tensor_pol_qq_cal(ipl,n_tens_qq,nplt,
     &                             plae,plas,voae,voas,Tensor_pol_qq)
      end do

      if( kpl == 1 .and. moyenne ) then
        ipl0 = 0
        if( comp_dd ) then
          do i = 1,n_tens_dd 
            Tensor_pol_dd(0,i) = sum( pdp(ipl1:ipl2,1)
     &                              * Tensor_pol_dd(ipl1:ipl2,i) )
          end do
        endif
        if( comp_dq ) then
          do i = 1,2*n_tens_dq 
            Tensor_pol_dq(0,i) = (0._db,0._db)
          end do
        endif
        if( comp_qq ) then 
          do i = 1,n_tens_qq 
            Tensor_pol_qq(0,i) = sum( pdp(ipl1:ipl2,2)
     &                              * Tensor_pol_qq(ipl1:ipl2,i) )
          end do
        endif
      else
        ipl0 = ipl1
      endif

      if( icheck(21) > 1 .and. ie == 1 ) then 
        if( comp_dd ) then 
          if( kpl > nplr ) then
            write(3,110) 'Dipole-dipole', kpl - nplr
          else
            if( ipl0 == 0 ) then
              write(3,120) 'Dipole-dipole'
            else
              write(3,125) 'Dipole-dipole'
            endif
          endif 
          do i = 1,n_tens_dd 
            write(3,130) i, Tensor_pol_dd(ipl0:ipl2,i)
          end do
        endif

        if( comp_dq ) then 
          if( kpl > nplr ) then
            write(3,110) 'Dipole-quadrupole', kpl - nplr
          else
            if( ipl0 == 0 ) then
              write(3,120) 'Dipole-quadrupole'
            else
              write(3,125) 'Dipole-quadrupole'
            endif
          endif 
          do i = 1,2*n_tens_dq 
            write(3,130) i, Tensor_pol_dq(ipl0:ipl2,i)
          end do
        endif

        if( comp_qq ) then 
          if( kpl > nplr ) then
            write(3,110) 'Quadrupole-quadrupole', kpl - nplr
          else
            if( ipl0 == 0 ) then
              write(3,120) 'Quadrupole-quadrupole'
            else
              write(3,125) 'Quadrupole-quadrupole'
            endif
          endif 
          do i = 1,n_tens_qq 
            write(3,130) i, Tensor_pol_qq(ipl0:ipl2,i)
          end do
        endif
      endif

      do ia = 0,nb

        writout = ia == 0 .or. kpl == 1
        writbav = icheck(21) > 1 .and. writout

        if( writbav ) then
          if( ia == 0 ) then
            if( kpl == 1 ) then
              write(3,142)
            else
              write(3,143) kpl - nplr
            endif
          else 
            write(3,144) ia
          endif
        endif

        if( comp_dd ) then
          secdd(:,:) = secddia(:,:,ia)
          call Sph_tensor_dd_cal(n_tens_dd,secdd,Sph_tensor_dd)
          Sph_tensor_dd(:) = ct_nelec * Sph_Tensor_dd(:)
          if( writbav ) then
            write(3,148) 
            if( ipl0 <= 1 ) then
              write(3,150) Real( Sph_tensor_dd(:) )
            else
              write(3,155) Sph_tensor_dd(:)
            endif 
          endif
        endif

        if( comp_dq ) then
          secdq(:,:,:) = secdqia(:,:,:,ia)
          call Sph_tensor_dq_cal(n_tens_dq,secdq,Sph_tensor_dq)
          Sph_tensor_dq(:) = ct_nelec * Sph_Tensor_dq(:)
          if( ia == 0 .and. magn_sens ) then
            secdq(:,:,:) = secdqia_mag(:,:,:)
            call Sph_tensor_dq_cal(n_tens_dq,secdq,Sph_tensor_dq_mag)
            Sph_tensor_dq_mag(:) = ct_nelec * Sph_Tensor_dq_mag(:)
          endif
          if( writbav ) then
            write(3,158) 
            if( ipl0 <= 1 .and. ia == 0 .and. magn_sens ) then
              write(3,165) ( Real( Sph_tensor_dq(i) ), 
     &                       Real( Sph_tensor_dq_mag(i) ), i = 1,3 )
              write(3,175) ( Real( Sph_tensor_dq(i) ),
     &                       Real( Sph_tensor_dq_mag(i) ), i = 4,8 ) 
              write(3,185) ( Real( Sph_tensor_dq(i) ),
     &                       Real( Sph_tensor_dq_mag(i) ), i = 9,15 )
            elseif( ia == 0 .and. magn_sens ) then
              write(3,166) ( Sph_tensor_dq(i), Sph_tensor_dq_mag(i),
     &                       i = 1,3 )
              write(3,176) ( Sph_tensor_dq(i), Sph_tensor_dq_mag(i),
     &                       i = 4,8 ) 
              write(3,186) ( Sph_tensor_dq(i), Sph_tensor_dq_mag(i),
     &                       i = 9,15 )
            elseif( ipl0 <= 1 ) then
              write(3,160) Real( Sph_tensor_dq(1:3) )
              write(3,170) Real( Sph_tensor_dq(4:8) ) 
              write(3,180) Real( Sph_tensor_dq(9:15) )
            else
              write(3,162) Sph_tensor_dq(1:3)
              write(3,172) Sph_tensor_dq(4:8) 
              write(3,182) Sph_tensor_dq(9:15)
            endif
          endif
        endif

        if( comp_qq ) then
          secqq(:,:,:,:) = secqqia(:,:,:,:,ia)
          call Sph_tensor_qq_cal(n_tens_qq,secqq,Sph_tensor_qq)
          Sph_tensor_qq(:) = ct_nelec * Sph_Tensor_qq(:)
          if( writbav ) then
            write(3,188) 
            if( ipl0 <= 1 ) then
              write(3,190) Real( Sph_tensor_qq(1:9) ) 
              write(3,200) Real( Sph_tensor_qq(10:n_tens_qq) )
            else
              write(3,210) Sph_tensor_qq(1:9) 
              write(3,220) Sph_tensor_qq(10:n_tens_qq)
            endif
          endif
        endif

        call write_phys(ct_nelec,E_cut,energ,ephseuil,
     &      Epsii,eseuil,ia,ie,
     &      Int_tens,ipl0,ipl2,Length_word,magn_sens,n_tens_dd,
     &      n_tens_dq,n_tens_max,n_tens_qq,n_tens_t,natomsym,nenerg,
     &      nomfich1,npldafs,nplr,nplt,numat_abs,phdf0t,phdt,
     &      Sph_tensor_dd,Sph_tensor_dq,Sph_tensor_dq_mag,
     &      Sph_tensor_qq,Tensor_pol_dd,Tensor_pol_dq,Tensor_pol_qq,
     &      v0muf,writout)

      end do

      return
  110 format(/1x,A,' polarisation tensor for the RXS:',
     &       /'  i ',5x,' Reflection number',i3)
  120 format(/1x,A,' polarisation tensor for the xanes:',
     &     /'  i        <xanes>           ipl = 0, 1, 2...')
  125 format(/1x,A,' polarisation tensor for the xanes:',
     &     /'  i        ipl = 0, 1, 2...')
  130 format(i3,25(1x,2f9.5))
  142 format(/' Spherical tensors for the unit cell')
  143 format(/' Spherical tensors for the unit cell for the RXS',
     &  ' (num. of electron), reflection number',i3)
  144 format(/' Spherical tensors (numb. of electron) for the atom',
     &        ' number :',i3)
  148 format(/' Dipole-dipole spherical tensor (numb. of',
     &        ' electron):')
  150 format(/1p,
     & ' rank 0, non-magnetic scalar :',/
     & '    D(00)                      =',e13.5,//
     & ' rank 1, magnetic dipole :',/
     & '    D(10)                 = lz =',e13.5,/
     & '   (D(11)-D(1-1))/sqrt(2) =-lx =',e13.5,/
     & ' -i(D(11)+D(1-1))/sqrt(2) = ly =',e13.5,//
     & ' rank 2, non-magnetic quadrupole :',/
     & '    D(20)                      =',e13.5,/
     & '   (D(21)-D(2-1))/sqrt(2)      =',e13.5,/
     & ' -i(D(21)+D(2-1))/sqrt(2)      =',e13.5,/
     & ' -i(D(22)-D(2-2))/sqrt(2)      =',e13.5,/
     & '   (D(22)+D(2-2))/sqrt(2)      =',e13.5)
  155 format(1p,
     & ' rank 0, non-magnetic scalar :',/
     & '    D(00)                      =',2e13.5,//
     & ' rank 1, magnetic dipole :',/
     & '    D(10)                 = lz =',2e13.5,/
     & '   (D(11)-D(1-1))/sqrt(2) =-lx =',2e13.5,/
     & ' -i(D(11)+D(1-1))/sqrt(2) = ly =',2e13.5,//
     & ' rank 2, non-magnetic quadrupole :',/
     & '    D(20)                      =',2e13.5,/
     & '   (D(21)-D(2-1))/sqrt(2)      =',2e13.5,/
     & ' -i(D(21)+D(2-1))/sqrt(2)      =',2e13.5,/
     & ' -i(D(22)-D(2-2))/sqrt(2)      =',2e13.5,/
     & '   (D(22)+D(2-2))/sqrt(2)      =',2e13.5)
  158 format(/' Dipole-quadrupole spherical tensor (numb. of',
     &        ' electron):')
  160 format(/42x,'non-magnetic ',/ ' rank 1 :',1p,/
     & '    I(10)                          = nz =',e13.5,/
     & '   (I(11)-I(1-1))/sqrt(2)          = nx =',e13.5,/
     & ' -i(I(11)+I(1-1))/sqrt(2)          = ny =',e13.5)
  162 format(/42x,'non-magnetic ',/ ' rank 1 :',1p,/
     & '    I(10)                          = nz =',2e13.5,/
     & '   (I(11)-I(1-1))/sqrt(2)          = nx =',2e13.5,/
     & ' -i(I(11)+I(1-1))/sqrt(2)          = ny =',2e13.5)
  165 format(/37x,'non-magnetic ',25x,'magnetic',/' rank 1 :',1p,/
     & '    I(10)                          = nz =',e13.5,
     &                              '              Toroiz =',e13.5,/
     & '   (I(11)-I(1-1))/sqrt(2)          = nx =',e13.5,
     &                              '              Toroix =',e13.5,/
     & ' -i(I(11)+I(1-1))/sqrt(2)          = ny =',e13.5,
     &                              '              Toroiy =',e13.5)
  166 format(/49x,'non-magnetic ',37x,'magnetic',/' rank 1 :',1p,/
     & '    I(10)                          = nz =',2e13.5,
     &                              '              Toroiz =',2e13.5,/
     & '   (I(11)-I(1-1))/sqrt(2)          = nx =',2e13.5,
     &                              '              Toroix =',2e13.5,/
     & ' -i(I(11)+I(1-1))/sqrt(2)          = ny =',2e13.5,
     &                              '              Toroiy =',2e13.5)
  170 format(/' rank 2 :',1p,/
     & '  -iI(20)                  =  lz*Toroiz =',e13.5,/
     & ' -i(I(21)-I(2-1))/sqrt(2)  = (l,Toroi)2 =',e13.5,/
     & '   (I(21)+I(2-1))/sqrt(2)  = (l,Toroi)2 =',e13.5,/
     & '   (I(22)-I(2-2))/sqrt(2)  = (l,Toroi)2 =',e13.5,/
     & ' -i(I(22)+I(2-2))/sqrt(2)  = (l,Toroi)2 =',e13.5)
  172 format(/' rank 2 :',1p,/
     & '  -iI(20)                  =  lz*Toroiz =',2e13.5,/
     & ' -i(I(21)-I(2-1))/sqrt(2)  = (l,Toroi)2 =',2e13.5,/
     & '   (I(21)+I(2-1))/sqrt(2)  = (l,Toroi)2 =',2e13.5,/
     & '   (I(22)-I(2-2))/sqrt(2)  = (l,Toroi)2 =',2e13.5,/
     & ' -i(I(22)+I(2-2))/sqrt(2)  = (l,Toroi)2 =',2e13.5)
  175 format(/' rank 2 :',1p,/
     & '  -iI(20)                  =  lz*Toroiz =',e13.5,
     &                              '               nz*lz =',e13.5,/
     & ' -i(I(21)-I(2-1))/sqrt(2)  = (l,Toroi)2 =',e13.5,
     &                              '              (n,l)2 =',e13.5,/
     & '   (I(21)+I(2-1))/sqrt(2)  = (l,Toroi)2 =',e13.5,
     &                              '              (n,l)2 =',e13.5,/
     & '   (I(22)-I(2-2))/sqrt(2)  = (l,Toroi)2 =',e13.5,
     &                              '              (n,l)2 =',e13.5,/
     & ' -i(I(22)+I(2-2))/sqrt(2)  = (l,Toroi)2 =',e13.5,
     &                              '              (n,l)2 =',e13.5)
  176 format(/' rank 2 :',1p,/
     & '  -iI(20)                  =  lz*Toroiz =',2e13.5,
     &                              '               nz*lz =',2e13.5,/
     & ' -i(I(21)-I(2-1))/sqrt(2)  = (l,Toroi)2 =',2e13.5,
     &                              '              (n,l)2 =',2e13.5,/
     & '   (I(21)+I(2-1))/sqrt(2)  = (l,Toroi)2 =',2e13.5,
     &                              '              (n,l)2 =',2e13.5,/
     & '   (I(22)-I(2-2))/sqrt(2)  = (l,Toroi)2 =',2e13.5,
     &                              '              (n,l)2 =',2e13.5,/
     & ' -i(I(22)+I(2-2))/sqrt(2)  = (l,Toroi)2 =',2e13.5,
     &                              '              (n,l)2 =',2e13.5)
  180 format(/' rank 3 :',1p,/
     & '    I(30)              = nz*(3lz2 - l2) =',e13.5,/
     & '   (I(31)-I(3-1))/sqrt(2) = (n,(l,l)2)3 =',e13.5,/
     & ' -i(I(31)+I(3-1))/sqrt(2) = (n,(l,l)2)3 =',e13.5,/
     & ' -i(I(32)-I(3-2))/sqrt(2) = (n,(l,l)2)3 =',e13.5,/
     & '   (I(32)+I(3-2))/sqrt(2) = (n,(l,l)2)3 =',e13.5,/
     & '   (I(33)-I(3-3))/sqrt(2) = (n,(l,l)2)3 =',e13.5,/
     & ' -i(I(33)+I(3-3))/sqrt(2) = (n,(l,l)2)3 =',e13.5)
  182 format(/' rank 3 :',1p,/
     & '    I(30)              = nz*(3lz2 - l2) =',2e13.5,/
     & '   (I(31)-I(3-1))/sqrt(2) = (n,(l,l)2)3 =',2e13.5,/
     & ' -i(I(31)+I(3-1))/sqrt(2) = (n,(l,l)2)3 =',2e13.5,/
     & ' -i(I(32)-I(3-2))/sqrt(2) = (n,(l,l)2)3 =',2e13.5,/
     & '   (I(32)+I(3-2))/sqrt(2) = (n,(l,l)2)3 =',2e13.5,/
     & '   (I(33)-I(3-3))/sqrt(2) = (n,(l,l)2)3 =',2e13.5,/
     & ' -i(I(33)+I(3-3))/sqrt(2) = (n,(l,l)2)3 =',2e13.5)
  185 format(/' rank 3 :',1p,/
     & '    I(30)              = nz*(3lz2 - l2) =',e13.5,
     &                              '  Toroiz*(3lz2 - l2) =',e13.5,/
     & '   (I(31)-I(3-1))/sqrt(2) = (n,(l,l)2)3 =',e13.5,
     &                              '     (Toroi,(l,l)2)3 =',e13.5,/
     & ' -i(I(31)+I(3-1))/sqrt(2) = (n,(l,l)2)3 =',e13.5,
     &                              '     (Toroi,(l,l)2)3 =',e13.5,/
     & ' -i(I(32)-I(3-2))/sqrt(2) = (n,(l,l)2)3 =',e13.5,
     &                              '     (Toroi,(l,l)2)3 =',e13.5,/
     & '   (I(32)+I(3-2))/sqrt(2) = (n,(l,l)2)3 =',e13.5,
     &                              '     (Toroi,(l,l)2)3 =',e13.5,/
     & '   (I(33)-I(3-3))/sqrt(2) = (n,(l,l)2)3 =',e13.5,
     &                              '     (Toroi,(l,l)2)3 =',e13.5,/
     & ' -i(I(33)+I(3-3))/sqrt(2) = (n,(l,l)2)3 =',e13.5,
     &                              '     (Toroi,(l,l)2)3 =',e13.5)
  186 format(/' rank 3 :',1p,/
     & '    I(30)              = nz*(3lz2 - l2) =',2e13.5,
     &                              '  Toroiz*(3lz2 - l2) =',2e13.5,/
     & '   (I(31)-I(3-1))/sqrt(2) = (n,(l,l)2)3 =',2e13.5,
     &                              '     (Toroi,(l,l)2)3 =',2e13.5,/
     & ' -i(I(31)+I(3-1))/sqrt(2) = (n,(l,l)2)3 =',2e13.5,
     &                              '     (Toroi,(l,l)2)3 =',2e13.5,/
     & ' -i(I(32)-I(3-2))/sqrt(2) = (n,(l,l)2)3 =',2e13.5,
     &                              '     (Toroi,(l,l)2)3 =',2e13.5,/
     & '   (I(32)+I(3-2))/sqrt(2) = (n,(l,l)2)3 =',2e13.5,
     &                              '     (Toroi,(l,l)2)3 =',2e13.5,/
     & '   (I(33)-I(3-3))/sqrt(2) = (n,(l,l)2)3 =',2e13.5,
     &                              '     (Toroi,(l,l)2)3 =',2e13.5,/
     & ' -i(I(33)+I(3-3))/sqrt(2) = (n,(l,l)2)3 =',2e13.5,
     &                              '     (Toroi,(l,l)2)3 =',2e13.5)
  188 format(/' Quadrupole-quadrupole spherical tensor (numb. of',
     &        ' electron) :')
  190 format(/' rank 0, scalar :',1p,/
     & '    Q(00)                      =',e13.5,//
     & ' rank 1, magnetic dipole :',/
     & '    Q(10)                 = lz =',e13.5,/
     & '   (Q(11)-Q(1-1))/sqrt(2) =-lx =',e13.5,/
     & ' -i(Q(11)+Q(1-1))/sqrt(2) = ly =',e13.5,//
     & ' Rank 2, non-magnetic quadrupole :',/
     & '    Q(20)                      =',e13.5,/
     & '   (Q(21)-Q(2-1))/sqrt(2)      =',e13.5,/
     & ' -i(Q(21)+Q(2-1))/sqrt(2)      =',e13.5,/
     & ' -i(Q(22)-Q(2-2))/sqrt(2)      =',e13.5,/
     & '   (Q(22)+Q(2-2))/sqrt(2)      =',e13.5,/)
  200 format(' Rank 3, magnetic octupole :',/
     & '    Q(30)                      =',e13.5,/
     & '   (Q(31)-Q(3-1))/sqrt(2)      =',e13.5,/
     & ' -i(Q(31)+Q(3-1))/sqrt(2)      =',e13.5,/
     & ' -i(Q(32)-Q(3-2))/sqrt(2)      =',e13.5,/
     & '   (Q(32)+Q(3-2))/sqrt(2)      =',e13.5,/
     & ' -i(Q(33)-Q(3-3))/sqrt(2)      =',e13.5,/
     & ' -i(Q(33)+Q(3-3))/sqrt(2)      =',e13.5,//
     & ' Rank 4, non-magnetic hexadecapole :',/
     & '    Q(40)                      =',e13.5,/
     & '   (Q(41)-Q(4-1))/sqrt(2)      =',e13.5,/
     & ' -i(Q(41)+Q(4-1))/sqrt(2)      =',e13.5,/
     & ' -i(Q(42)-Q(4-2))/sqrt(2)      =',e13.5,/
     & '   (Q(42)+Q(4-2))/sqrt(2)      =',e13.5,/
     & '   (Q(43)-Q(4-3))/sqrt(2)      =',e13.5,/
     & ' -i(Q(43)+Q(4-3))/sqrt(2)      =',e13.5,/
     & ' -i(Q(44)-Q(4-4))/sqrt(2)      =',e13.5,/
     & '   (Q(44)+Q(4-4))/sqrt(2)      =',e13.5)
  210 format(/1p,
     & ' rank 0, scalar :',/
     & '    Q(00)                      =',2e13.5,//
     & ' rank 1, magnetic dipole :',/
     & '    Q(10)                 = lz =',2e13.5,/
     & '   (Q(11)-Q(1-1))/sqrt(2) =-lx =',2e13.5,/
     & ' -i(Q(11)+Q(1-1))/sqrt(2) = ly =',2e13.5,//
     & ' Rank 2, non-magnetic quadrupole :',/
     & '    Q(20)                      =',2e13.5,/
     & '   (Q(21)-Q(2-1))/sqrt(2)      =',2e13.5,/
     & ' -i(Q(21)+Q(2-1))/sqrt(2)      =',2e13.5,/
     & ' -i(Q(22)-Q(2-2))/sqrt(2)      =',2e13.5,/
     & '   (Q(22)+Q(2-2))/sqrt(2)      =',2e13.5,/)
  220 format(
     & ' Rank 3, magnetic octupole :',/
     & '    Q(30)                      =',2e13.5,/
     & '   (Q(31)-Q(3-1))/sqrt(2)      =',2e13.5,/
     & ' -i(Q(31)+Q(3-1))/sqrt(2)      =',2e13.5,/
     & ' -i(Q(32)-Q(3-2))/sqrt(2)      =',2e13.5,/
     & '   (Q(32)+Q(3-2))/sqrt(2)      =',2e13.5,/
     & ' -i(Q(33)-Q(3-3))/sqrt(2)      =',2e13.5,/
     & ' -i(Q(33)+Q(3-3))/sqrt(2)      =',2e13.5,//
     & ' Rank 4, non-magnetic hexadecapole :',/
     & '    Q(40)                      =',2e13.5,/
     & '   (Q(41)-Q(4-1))/sqrt(2)      =',2e13.5,/
     & ' -i(Q(41)+Q(4-1))/sqrt(2)      =',2e13.5,/
     & ' -i(Q(42)-Q(4-2))/sqrt(2)      =',2e13.5,/
     & '   (Q(42)+Q(4-2))/sqrt(2)      =',2e13.5,/
     & '   (Q(43)-Q(4-3))/sqrt(2)      =',2e13.5,/
     & ' -i(Q(43)+Q(4-3))/sqrt(2)      =',2e13.5,/
     & ' -i(Q(44)-Q(4-4))/sqrt(2)      =',2e13.5,/
     & '   (Q(44)+Q(4-4))/sqrt(2)      =',2e13.5)
      end

!***********************************************************************

      subroutine Sph_tensor_dd_cal(n_tens_dd,secdd,Sph_tensor_dd)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db), dimension(n_tens_dd):: Sph_tensor_dd
      complex(kind=db), dimension(3,3):: secdd

! Tenseur 0

      Sph_tensor_dd(1) = ( 1 / sqrt(3._db) )
     &                 * ( secdd(1,1) + secdd(2,2) + secdd(3,3) )

! Tenseur 1
! Les composantes de ce tenseur sont en cas de seuil K : -lx, ly et lz.
      fac = 1 / sqrt( 2._db )

! Multiplie par - img, equivalent a prendre la partie imaginaire quand
! il n'y a pas de multiplication par le terme de Bragg.
! lz = D(01)
      Sph_tensor_dd(2) = - img * fac * ( secdd(1,2) - secdd(2,1) )

! -lx = (1/sqrt(2))*(D(11)-D(-11))
      Sph_tensor_dd(3) = img * fac * ( secdd(2,3) - secdd(3,2) )

! ly = (-i/sqrt(2))*(D(-11)+D(11))
      Sph_tensor_dd(4) = - img * fac * ( secdd(1,3) - secdd(3,1) )

! Tenseur 2

! D02 = (1/sqrt(6))*(2*Dzz-Dxx-Dyy)
      fac = 1 / sqrt( 6._db )
      Sph_tensor_dd(5) = fac
     &                 * ( 2*secdd(3,3) - secdd(1,1)  - secdd(2,2) )

      fac = 1 / sqrt( 2._db ) 

! (1/sqrt(2))*(D(12) - D(-12))
      Sph_tensor_dd(6) = - fac * ( secdd(1,3) + secdd(3,1) )

! (-i/sqrt(2))*(D(12) + D(-12))
      Sph_tensor_dd(7) = - fac * ( secdd(2,3) + secdd(3,2) )

! (-i/sqrt(2))*(D(22) - D(-22))
      Sph_tensor_dd(8) = fac * ( secdd(1,2) + secdd(2,1) )

! (1/sqrt(2))*(D(22) + D(-22))
      Sph_tensor_dd(9) = fac * ( secdd(1,1) - secdd(2,2) )

      return
      end

!***********************************************************************

      subroutine Sph_tensor_dq_cal(n_tens_dq,secdq,Sph_tensor_dq)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db), dimension(3,3,3):: secdq
      complex(kind=db), dimension(n_tens_dq):: Sph_tensor_dq

! Tenseur 1

  ! I(10)
      Sph_tensor_dq(1) = - ( 1 / sqrt(15._db) )
     &   * ( 3 * secdq(1,1,3) + 3 * secdq(2,2,3)
     &     + 2 * secdq(3,3,3) - secdq(3,1,1) - secdq(3,2,2) )

      fac = 2 / sqrt(60._db)

! (1/sqrt(2))*(I(11) - I(1-1))
      Sph_tensor_dq(2) = fac
     &   * ( 2 * secdq(1,1,1) - secdq(1,2,2) - secdq(1,3,3)
     &     + 3 * ( secdq(2,1,2) + secdq(3,1,3) ) )

! (-i/sqrt(2))*(I(11) + I(-1-1))
      Sph_tensor_dq(3) = fac
     &   * ( 2 * secdq(2,2,2) - secdq(2,1,1) - secdq(2,3,3)
     &     + 3 * ( secdq(1,1,2) + secdq(3,2,3) ) )

! Tenseur 2

  ! -i*I(20)
      Sph_tensor_dq(4) = secdq(1,2,3) - secdq(2,1,3)

      fac = 1 / sqrt(3._db)

  ! (-i/sqrt(2))*(I(21) - I(2-1))
      Sph_tensor_dq(5) = fac
     &   * ( secdq(2,1,1) - secdq(2,3,3) - secdq(1,1,2) + secdq(3,2,3) )

  ! (1/sqrt(2))*(I(21) + I(2-1))
      Sph_tensor_dq(6) = fac
     &   * ( secdq(1,2,2) - secdq(1,3,3) - secdq(2,1,2) + secdq(3,1,3) )

      Sph_tensor_dq(7) = fac
     &   * ( secdq(1,1,3) - secdq(2,2,3) - secdq(3,1,1) + secdq(3,2,2) )

  ! (-i/sqrt(2))*(I(22) + I(2-2))
      Sph_tensor_dq(8) = fac
     &   * ( secdq(1,2,3) + secdq(2,1,3) - secdq(3,1,2) - secdq(3,2,1) )

! Tenseur 3

      Sph_tensor_dq(9) = 1 / sqrt(10._db)
     &           * ( 2 * secdq(3,3,3) - 2 * secdq(1,1,3) - secdq(3,1,1) 
     &             - 2 * secdq(2,2,3) - secdq(3,2,2) )

      fac = 1 / sqrt(60._db)

      Sph_tensor_dq(10) = fac
     &           * ( 3 * secdq(1,1,1) + secdq(1,2,2) + 2 * secdq(2,1,2) 
     &             - 4 * secdq(1,3,3) - 8 * secdq(3,1,3) )

  ! (-i/sqrt(2))*(I(31) + I(3-1))
      Sph_tensor_dq(11) = fac
     &           * ( 3 * secdq(2,2,2) + secdq(2,1,1) + 2 * secdq(1,2,1) 
     &             - 4 * secdq(2,3,3) - 8 * secdq(3,2,3) )

      fac = 1 / sqrt(6._db)

  ! (-i/sqrt(2))*(I(32) - I(3-2))
      Sph_tensor_dq(12) = 2 * fac
     &                  * ( secdq(1,2,3) + secdq(2,1,3) + secdq(3,1,2) ) 

      Sph_tensor_dq(13) = fac
     &                  * ( 2 * secdq(1,1,3) - 2 * secdq(2,2,3)
     &                        + secdq(3,1,1) - secdq(3,2,2) ) 

      fac = 0.5_db

      Sph_tensor_dq(14) = fac
     &             * ( secdq(1,2,2) + 2 * secdq(2,1,2) - secdq(1,1,1) ) 

  ! (-i/sqrt(2))*(I(33) + I(3-3))
      Sph_tensor_dq(15) = - fac
     &             * ( secdq(2,1,1) + 2 * secdq(1,2,1) - secdq(2,2,2) ) 

      return
      end

!***********************************************************************

      subroutine Sph_tensor_qq_cal(n_tens_qq,secqq,Sph_tensor_qq)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db), dimension(3,3,3,3):: secqq
      complex(kind=db), dimension(n_tens_qq):: Sph_tensor_qq

! La multiplication par - img correspond a la partie imaginaire quand le
! tenseur n'est pas multiplie par le terme de Bragg.

! Tenseur 0, scalaire, signal isotropique quadrupolaire

      fac = 2 / sqrt(45._db) 
  ! Q(00)
      Sph_tensor_qq(1) = fac
     &      * ( 3 * ( secqq(1,3,1,3) + secqq(2,3,2,3) + secqq(1,2,1,2) )
     &              + secqq(1,1,1,1) + secqq(2,2,2,2) + secqq(3,3,3,3)
     &      - 0.5 * ( secqq(1,1,2,2) + secqq(1,1,3,3) + secqq(3,3,2,2)  
     &            + secqq(2,2,1,1) + secqq(3,3,1,1) + secqq(2,2,3,3) ) )  

! Tenseur 1, vecteur, lz, lx, ly, magnetique

      fac = 2 / sqrt(10._db) 

  ! Q(10)
      Sph_tensor_qq(2) = img * fac
     &           * ( secqq(2,1,1,1) - secqq(1,2,2,2) + secqq(2,3,1,3)
     &             - secqq(1,1,2,1) + secqq(2,2,1,2) - secqq(1,3,2,3) )

  ! (1/sqrt(2)) * ( Q(11) - Q(1-1) )
      Sph_tensor_qq(3) = - img * fac
     &           * ( secqq(3,2,2,2) - secqq(2,3,3,3) + secqq(3,1,2,1)
     &             - secqq(2,2,3,2) + secqq(3,3,2,3) - secqq(2,1,3,1) )

  ! -i * (1/sqrt(2)) * ( Q(11) + Q(1-1) )
      Sph_tensor_qq(4) = - img * fac
     &           * ( secqq(1,3,3,3) - secqq(3,1,1,1) + secqq(1,2,3,2)
     &             - secqq(3,3,1,3) + secqq(1,1,3,1) - secqq(3,2,1,2) )

! Tenseur 2 : quadrupole non magnetique

      fac = 2 / ( 3 * sqrt(14._db) ) 
  ! Q(20)
      Sph_tensor_qq(5) = fac
     &       * ( 6 * secqq(1,2,1,2) - 3 * secqq(1,3,1,3)
     &         - 3 * secqq(2,3,2,3) + secqq(1,1,1,1) + secqq(2,2,2,2) 
     &         - 2 * secqq(1,1,2,2) - 2 * secqq(2,2,1,1)
     &         - 2 * secqq(3,3,3,3) 
     &         + secqq(1,1,3,3) + secqq(2,2,3,3) 
     &         + secqq(3,3,1,1) + secqq(3,3,2,2) ) 

      fac = 2 / sqrt(42._db) 

  ! (1/sqrt(2)) * ( Q(21) - Q(2-1) )
      Sph_tensor_qq(6) = fac
     &                 * ( 3 * secqq(2,3,1,2) + secqq(3,3,1,3) 
     &                   + secqq(1,1,1,3) - 2 * secqq(2,2,1,3)
     &                   + 3 * secqq(1,2,2,3) + secqq(1,3,3,3) 
     &                   + secqq(1,3,1,1) - 2 * secqq(1,3,2,2) )

  ! (-i/sqrt(2)) * ( Q(21) + Q(2-1) )
      Sph_tensor_qq(7) = fac
     &                 * ( 3 * secqq(1,3,1,2) + secqq(3,3,2,3) 
     &                       + secqq(2,2,2,3) - 2 * secqq(1,1,2,3)
     &                   + 3 * secqq(1,2,1,3) + secqq(2,3,3,3) 
     &                       + secqq(2,3,2,2) - 2 * secqq(2,3,1,1) )

      fac = 2 / sqrt( 42._db ) 

  ! (-i/sqrt(2)) * ( Q(22) - Q(2-2) )
      Sph_tensor_qq(8) = fac
     &         * ( 2 * secqq(3,3,1,2) - secqq(1,1,1,2) - secqq(2,2,2,1) 
     &           - 3 * secqq(1,3,2,3)
     &           + 2 * secqq(1,2,3,3) - secqq(1,2,1,1) - secqq(2,1,2,2) 
     &           - 3 * secqq(2,3,1,3) )

  ! (1/sqrt(2)) * ( Q(22) + Q(2-2) )
      Sph_tensor_qq(9) = fac
     &         * ( secqq(3,3,1,1) - secqq(3,3,2,2)
     &           + secqq(1,1,3,3) - secqq(2,2,3,3) 
     &           + secqq(2,2,2,2) - secqq(1,1,1,1)
     &           + 3 * secqq(2,3,2,3) - 3 * secqq(1,3,1,3) )

! Tenseur 3 : octupole magnetique

      fac = 1 / sqrt(10._db) 

  ! Q(30)
      Sph_tensor_qq(10) = img * fac
     &       * ( secqq(1,2,1,1) - secqq(2,1,2,2) + 4 * secqq(1,3,2,3)
     &         - secqq(1,1,1,2) + secqq(2,2,2,1) - 4 * secqq(2,3,1,3) )

      fac = 0.5_db / sqrt(15._db)

  ! (1/sqrt(2)) * ( Q(31) - Q(3-1) )
      Sph_tensor_qq(11) = img *  fac
     &                  * ( 6 * secqq(1,2,1,3) + 4 * secqq(3,3,2,3)
     &                    - 5 * secqq(1,1,2,3) + secqq(2,2,2,3)
     &                    - 6 * secqq(1,3,1,2) - 4 * secqq(2,3,3,3)
     &                    + 5 * secqq(2,3,1,1) - secqq(2,3,2,2) )

  ! (-i/sqrt(2)) * ( Q(31) + Q(3-1) )
      Sph_tensor_qq(12) = - img * fac
     &                  * ( 6 * secqq(1,2,2,3) + 4 * secqq(3,3,1,3)
     &                    - 5 * secqq(2,2,1,3) + secqq(1,1,1,3)
     &                    - 6 * secqq(2,3,1,2) - 4 * secqq(1,3,3,3)
     &                    + 5 * secqq(1,3,2,2) - secqq(1,3,1,1) )

      fac = 1 / sqrt(6._db)

  ! (-i/sqrt(2)) * ( Q(32) - Q(3-2) )
      Sph_tensor_qq(13) = - img * fac
     &           * ( secqq(1,1,3,3) + secqq(2,2,1,1) + secqq(3,3,2,2)
     &             - secqq(3,3,1,1) - secqq(1,1,2,2) - secqq(2,2,3,3) )

  ! (1/sqrt(2)) * ( Q(32) + Q(3-2) )
      Sph_tensor_qq(14) = img * fac
     &       * ( 2 * secqq(1,2,3,3) - secqq(1,2,1,1) - secqq(1,2,2,2)
     &         - 2 * secqq(3,3,1,2) + secqq(1,1,1,2) + secqq(2,2,1,2) )

      fac = 0.5_db

  ! (1/sqrt(2)) * ( Q(33) - Q(3-3) )
      Sph_tensor_qq(15) = img * fac
     &       * ( secqq(2,3,1,1) - secqq(2,3,2,2) + 2 * secqq(1,3,1,2)
     &         - secqq(1,1,2,3) + secqq(2,2,2,3) - 2 * secqq(1,2,1,3) )

  ! (-i/sqrt(2)) * ( Q(33) + Q(3-3) )
      Sph_tensor_qq(16) = - img * fac
     &       * ( secqq(1,3,1,1) - secqq(1,3,2,2) + 2 * secqq(2,1,3,2)
     &         - secqq(1,1,1,3) + secqq(2,2,1,3) - 2 * secqq(3,2,2,1) )

! Tenseur 4 : hexadecapole non magnetique

      fac = 1 / ( 2. * sqrt(70._db) ) 

  ! Q(40)
      Sph_tensor_qq(17) = fac
     &   * ( 3 * secqq(1,1,1,1) + 3 * secqq(2,2,2,2)
     &         + 8 * secqq(3,3,3,3) + secqq(1,1,2,2) + secqq(2,2,1,1)
     &         - 4 * secqq(3,3,1,1) - 4 * secqq(3,3,2,2)
     &         - 4 * secqq(1,1,3,3) - 4 * secqq(2,2,3,3)
     &         + 4 * secqq(1,2,1,2)
     &        - 16 * secqq(1,3,1,3) - 16 * secqq(2,3,2,3) )

      fac = 0.5_db / sqrt(7._db) 

  ! (1/sqrt(2)) * ( Q(41) - Q(4-1) )
      Sph_tensor_qq(18) = fac
     &      * ( 3 * secqq(1,3,1,1) + secqq(1,3,2,2) - 4 * secqq(3,3,1,3) 
     &        + 2 * secqq(2,3,1,2)
     &        + 3 * secqq(1,1,1,3) + secqq(2,2,1,3) - 4 * secqq(1,3,3,3) 
     &        + 2 * secqq(1,2,2,3) )

  ! (-i/sqrt(2)) * ( Q(41) + Q(4-1) )
      Sph_tensor_qq(19) = fac
     &      * ( 3 * secqq(2,3,2,2) + secqq(2,3,1,1) - 4 * secqq(2,3,3,3) 
     &        + 2 * secqq(1,3,1,2)
     &        + 3 * secqq(2,2,2,3) + secqq(1,1,2,3) - 4 * secqq(3,3,2,3) 
     &        + 2 * secqq(1,2,1,3) )

      fac = 0.5_db / sqrt(14._db) 

  ! (-i/sqrt(2)) * ( Q(42) - Q(4-2) )
      Sph_tensor_qq(20) = 2 * fac
     &      * ( 2 * secqq(3,3,1,2) - secqq(1,1,1,2) - secqq(2,2,2,1) 
     &        + 4 * secqq(1,3,2,3)
     &        + 2 * secqq(1,2,3,3) - secqq(1,2,1,1) - secqq(2,1,2,2) 
     &        + 4 * secqq(2,3,1,3) )

  ! (1/sqrt(2)) * ( Q(42) + Q(4-2) )
      Sph_tensor_qq(21) = fac
     &    * ( 2 * secqq(3,3,1,1) - 2 * secqq(3,3,2,2)  
     &      + 2 * secqq(1,1,3,3) - 2 * secqq(2,2,3,3) 
     &      - 2 * secqq(1,1,1,1) + 2 * secqq(2,2,2,2) 
     &      + 8 * secqq(1,3,1,3) - 8 * secqq(2,3,2,3) )

      fac = 0.5_db 

  ! (1/sqrt(2)) * ( Q(43) - Q(4-3) )
      Sph_tensor_qq(22) = fac
     &       * ( secqq(1,3,2,2) - secqq(1,3,1,1) + 2 * secqq(2,3,1,2) 
     &         + secqq(2,2,1,3) - secqq(1,1,1,3) + 2 * secqq(1,2,2,3) ) 

  ! (-i/sqrt(2)) * ( Q(43) + Q(4-3) )
      Sph_tensor_qq(23) = fac
     &       * ( secqq(2,3,2,2) - secqq(2,3,1,1) - 2 * secqq(1,3,1,2)
     &         + secqq(2,2,2,3) - secqq(1,1,2,3) - 2 * secqq(1,2,1,3) ) 

      fac = 1 / sqrt(2._db) 

  ! (-i/sqrt(2)) * ( Q(44) - Q(4-4) )
      Sph_tensor_qq(24) = fac * ( secqq(1,2,1,1) - secqq(1,2,2,2)
     &                          + secqq(1,1,1,2) - secqq(2,2,1,2) ) 

  ! (1/sqrt(2)) * ( Q(44) + Q(4-4) )
      Sph_tensor_qq(25) = 0.5_db * fac
     &         * ( secqq(1,1,1,1) + secqq(2,2,2,2) - secqq(1,1,2,2)
     &           - secqq(2,2,1,1) - 4 * secqq(1,2,1,2) ) 

      return
      end

!***********************************************************************

      subroutine Tensor_pol_dd_cal(ipl,n_tens_dd,nplt,pe,ps,
     &                             Tensor_pol_dd)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db) Px, Py, Pz, Qx, Qy, Qz
      complex(kind=db), dimension(3):: pe, ps
      complex(kind=db), dimension(n_tens_dd):: Tens
      complex(kind=db), dimension(0:nplt,n_tens_dd):: Tensor_pol_dd
 
      Px = Pe(1); Qx = conjg( Ps(1) )
      Py = Pe(2); Qy = conjg( Ps(2) )
      Pz = Pe(3); Qz = conjg( Ps(3) )

      fac = 1 / sqrt(3._db)

      Tens(1) = fac * ( Qx*Px + Qy*Py + Qz*Pz ) 

      fac = 1 / sqrt(2._db)

      Tens(2) = - img * fac * ( Qx*Py - Qy*Px ) 

      Tens(3) = img * fac * ( Qy*Pz - Qz*Py ) 

      Tens(4) = fac * ( Qx*Pz - Qz*Px ) 

      fac = 1 / sqrt(6._db)

      Tens(5) = fac * ( 2*Qz*Pz - Qx*Px - Qy*Py ) 

      fac = 1._db / sqrt( 2._db )

      Tens(6) = - fac * ( Qx*Pz + Qz*Px ) 

      Tens(7) = - fac * img * ( Qy*Pz + Qz*Py ) 

      Tens(8) = fac * img * ( Qx*Py + Qy*Px ) 

      Tens(9) = fac * ( Qx*Px - Qy*Py )  

      Tensor_pol_dd(ipl,:) = Tens(:)

      return
      end

!***********************************************************************

      subroutine Tensor_pol_dq_cal(ipl,n_tens_dq,nplt,pe,ps,ve,vs,
     &                             Tensor_pol_dq)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db) Px, Py, Pz, Qx, Qy, Qz
      complex(kind=db), dimension(3):: pe, ps
      complex(kind=db), dimension(2*n_tens_dq):: Tens
      complex(kind=db), dimension(0:nplt,2*n_tens_dq):: Tensor_pol_dq
 
      real(kind=db), dimension(3):: ve, vs

      Px = Pe(1); Qx = conjg( Ps(1) )
      Py = Pe(2); Qy = conjg( Ps(2) )
      Pz = Pe(3); Qz = conjg( Ps(3) )
      
      Vx = Ve(1); Wx = Vs(1)
      Vy = Ve(2); Wy = Vs(2)
      Vz = Ve(3); Wz = Vs(3)

      Tens(:) = 0._db

      j = 0

      do i = 1,2

        if( i == 2 ) then
          Wx = - Wx; Wy = - Wy; Wz = - Wz
          j = n_tens_dq
        endif

  ! T(10)
        Tens(j+1) = - ( 1 / sqrt(15._db) ) 
     &     * ( ( 1.5*Qx*Px + 1.5*Qy*Py + 2*Qz*Pz ) * ( Vz - Wz )
     &       + ( 1.5*Qx*Pz - Qz*Px ) * Vx - ( 1.5*Qz*Px - Qx*Pz ) * Wx 
     &       + ( 1.5*Qy*Pz - Qz*Py ) * Vy - ( 1.5*Qz*Py - Qy*Pz ) * Wy ) 

      fac = 1 / sqrt( 60._db )

  ! (T(11)-T(1-1))/sqrt(2)
        Tens(j+2) = fac 
     &     * ( ( 4*Qx*Px + 3*Qy*Py + 3*Qz*Pz ) * ( Vx - Wx )
     &       + ( 3*Qy*Px - 2*Qx*Py ) * Vy - ( 3*Qx*Py - 2*Qy*Px ) * Wy
     &       + ( 3*Qz*Px - 2*Qx*Pz ) * Vz - ( 3*Qx*Pz - 2*Qz*Px ) * Wz )

  ! (T(11)+T(1-1))/sqrt(2)
        Tens(j+3) = fac * img 
     &     * ( ( 4*Qy*Py + 3*Qx*Px + 3*Qz*Pz ) * ( Vy - Wy )
     &       + ( 3*Qx*Py - 2*Qy*Px ) * Vx - ( 3*Qy*Px - 2*Qx*Py ) * Wx
     &       + ( 3*Qz*Py - 2*Qy*Pz ) * Vz - ( 3*Qy*Pz - 2*Qz*Py ) * Wz )

  ! T(20)
       Tens(j+4) = 0.5_db * img 
     &        * ( ( Qx*Py - Qy*Px ) * ( Vz + Wz )
     &            - Qy*Pz*Vx + Qz*Py*Wx + Qx*Pz*Vy - Qz*Px*Wy ) 

        fac = 1 / sqrt( 12._db )

  ! (T(21)-T(2-1))/sqrt(2)
        Tens(j+5) = fac * img 
     &        * ( ( Qz*Pz - Qx*Px ) * ( Vy - Wy )
     &          + ( Qz*Py - 2*Qy*Pz ) * Vz - ( Qy*Pz - 2*Qz*Py ) * Wz
     &          + ( 2*Qy*Px - Qx*Py ) * Vx - ( 2*Qx*Py - Qy*Px ) * Wx )

  ! (T(21)+T(2-1))/sqrt(2)
        Tens(j+6) = fac 
     &        * ( ( Qz*Pz - Qy*Py ) * ( Vx - Wx )
     &          + ( Qz*Px - 2*Qx*Pz ) * Vz - ( Qx*Pz - 2*Qz*Px ) * Wz
     &          + ( 2*Qx*Py - Qy*Px ) * Vy - ( 2*Qy*Px - Qx*Py ) * Wy )

  ! (T(22)-T(2-2))/sqrt(2)
        Tens(j+7) = fac 
     &        * ( ( Qx*Px - Qy*Py ) * ( Vz - Wz )
     &          + ( Qx*Pz - 2*Qz*Px ) * Vx - ( Qz*Px - 2*Qx*Pz ) * Wx
     &          + ( 2*Qz*Py - Qy*Pz ) * Vy - ( 2*Qy*Pz - Qz*Py ) * Wy )

  ! (T(22)+T(2-2))/sqrt(2)
        Tens(j+8) = fac * img 
     &        * ( ( Qx*Py + Qy*Px ) * ( Vz - Wz )
     &          + ( Qx*Pz - 2*Qz*Px ) * Vy - ( Qz*Px - 2*Qx*Pz ) * Wy
     &          - ( 2*Qz*Py - Qy*Pz ) * Vx + ( 2*Qy*Pz - Qz*Py ) * Wx )

  ! T(30)
        Tens(j+9) = ( 1 / sqrt(10._db) )  
     &        * ( ( 2*Qz*Pz - Qx*Px - Qy*Py ) * ( Vz - Wz )
     &                    - ( Qx*Pz + Qz*Px ) * ( Vx - Wx ) 
     &                    - ( Qy*Pz + Qz*Py ) * ( Vy - Wy ) ) 

        fac = 1 / sqrt( 60._db )

  ! (T(31)-T(3-1))/sqrt(2)
        Tens(j+10) = fac 
     &        * ( ( 3*Qx*Px + Qy*Py - 4*Qz*Pz ) * ( Vx - Wx )
     &                      + ( Qx*Py + Qy*Px ) * ( Vy - Wy ) 
     &                  - 4 * ( Qx*Pz + Qz*Px ) * ( Vz - Wz ) ) 

  ! (T(31)+T(3-1))/sqrt(2)
        Tens(j+11) = fac * img 
     &        * ( ( 3*Qy*Py + Qx*Px - 4*Qz*Pz ) * ( Vy - Wy )
     &                      + ( Qx*Py + Qy*Px ) * ( Vx - Wx ) 
     &                  - 4 * ( Qy*Pz + Qz*Py ) * ( Vz - Wz ) ) 

        fac = 1 / sqrt( 6._db )

  ! (T(32)-T(3-2))/sqrt(2)
        Tens(j+12) = fac * img * ( ( Qx*Py + Qy*Px ) * ( Vz - Wz )
     &                           + ( Qx*Pz + Qz*Px ) * ( Vy - Wy ) 
     &                           + ( Qy*Pz + Qz*Py ) * ( Vx - Wx ) ) 

  ! (T(32)+T(3-2))/sqrt(2)
        Tens(j+13) = fac  * ( ( Qx*Px - Qy*Py ) * ( Vz - Wz )
     &                      + ( Qx*Pz + Qz*Px ) * ( Vx - Wx ) 
     &                      - ( Qy*Pz + Qz*Py ) * ( Vy - Wy ) )

  ! (T(33)-T(3-3))/sqrt(2)
        Tens(j+14) = 0.5_db * ( ( Qy*Py - Qx*Px ) * ( Vx - Wx )
     &                       + ( Qy*Px + Qx*Py ) * ( Vy - Wy ) ) 

  ! (T(33)+T(3-3))/sqrt(2)
        Tens(j+15) = 0.5_db * img * ( ( Qy*Py - Qx*Px ) * ( Vy - Wy )
     &                             - ( Qy*Px + Qx*Py ) * ( Vx - Wx ) ) 

      end do

      Tensor_pol_dq(ipl,:) = Tens(:) 

      return
      end

!***********************************************************************

      subroutine Tensor_pol_qq_cal(ipl,n_tens_qq,nplt,pe,ps,ve,vs,
     &                             Tensor_pol_qq)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db) Px, Py, Pz, Qx, Qy, Qz
      complex(kind=db), dimension(3):: pe, ps
      complex(kind=db), dimension(n_tens_qq):: Tens
      complex(kind=db), dimension(0:nplt,n_tens_qq):: Tensor_pol_qq
 
      real(kind=db), dimension(3):: ve, vs

      Px = Pe(1); Qx = conjg( Ps(1) ) 
      Py = Pe(2); Qy = conjg( Ps(2) )
      Pz = Pe(3); Qz = conjg( Ps(3) )
      
      Vx = Ve(1); Wx = Vs(1)
      Vy = Ve(2); Wy = Vs(2)
      Vz = Ve(3); Wz = Vs(3)

      fac = 1 / ( 3 * sqrt( 5._db ) )

! Scalaire

      Tens(1) = 1.5 * fac 
     &   * ( Qx*Wz*Px*Vz + Qx*Wz*Pz*Vx + Qz*Wx*Px*Vz + Qz*Wx*Pz*Vx 
     &     + Qy*Wz*Py*Vz + Qy*Wz*Pz*Vy + Qz*Wy*Py*Vz + Qz*Wy*Pz*Vy 
     &     + Qx*Wy*Px*Vy + Qx*Wy*Py*Vx + Qy*Wx*Px*Vy + Qy*Wx*Py*Vx )
      Tens(1) = Tens(1) + 2 * fac 
     &   * ( Qx*Wx*Px*Vx + Qy*Wy*Py*Vy + Qz*Wz*Pz*Vz )
     &        - fac 
     &   * ( Qx*Wx*Py*Vy + Qy*Wy*Px*Vx + Qx*Wx*Pz*Vz + Qz*Wz*Px*Vx 
     &     + Qy*Wy*Pz*Vz + Qz*Wz*Py*Vy ) 

! Dipole magnetique

      fac = 1 / sqrt(10._db)

      Tens(2) = fac * img 
     &   * ( Qx*Wy*Px*Vx + Qy*Wx*Px*Vx - Qx*Wy*Py*Vy - Qy*Wx*Py*Vy 
     &     - Qx*Wx*Px*Vy - Qx*Wx*Py*Vx + Qy*Wy*Px*Vy + Qy*Wy*Py*Vx ) 
     &        + 0.5 * fac * img 
     &   * ( Qy*Wz*Px*Vz + Qy*Wz*Pz*Vx + Qz*Wy*Px*Vz + Qz*Wy*Pz*Vx 
     &     - Qx*Wz*Py*Vz - Qx*Wz*Pz*Vy - Qz*Wx*Py*Vz - Qz*Wx*Pz*Vy ) 

      Tens(3) = 0.5 * fac * img 
     &   * ( Qx*Wy*Px*Vz + Qx*Wy*Pz*Vx + Qy*Wx*Px*Vz + Qy*Wx*Pz*Vx 
     &     - Qx*Wz*Px*Vy - Qx*Wz*Py*Vx - Qz*Wx*Px*Vy - Qz*Wx*Py*Vx ) 
     &        - fac * img 
     &   * ( Qz*Wz*Py*Vz + Qz*Wz*Pz*Vy - Qy*Wy*Py*Vz - Qy*Wy*Pz*Vy 
     &     - Qy*Wz*Pz*Vz - Qz*Wy*Pz*Vz + Qy*Wz*Py*Vy + Qz*Wy*Py*Vy ) 

      Tens(4) = 0.5 * fac 
     &   * ( Qx*Wy*Py*Vz + Qx*Wy*Pz*Vy + Qy*Wx*Py*Vz + Qy*Wx*Pz*Vy 
     &     - Qy*Wz*Px*Vy - Qy*Wz*Py*Vx - Qz*Wy*Px*Vy - Qz*Wy*Py*Vx ) 
     &        - fac 
     &   * ( Qz*Wz*Px*Vz + Qz*Wz*Pz*Vx - Qx*Wx*Px*Vz - Qx*Wx*Pz*Vx 
     &     - Qx*Wz*Pz*Vz - Qz*Wx*Pz*Vz + Qx*Wz*Px*Vx + Qz*Wx*Px*Vx ) 

! Quadrupole non-magnetique

      fac = 1 / ( 3 * sqrt(14._db) )

      Tens(5) = 3 * fac 
     &   * ( Qx*Wy*Px*Vy + Qx*Wy*Py*Vx + Qy*Wx*Px*Vy + Qy*Wx*Py*Vx ) 
     &        - 1.5 * fac 
     &   * ( Qx*Wz*Px*Vz + Qx*Wz*Pz*Vx + Qz*Wx*Px*Vz + Qz*Wx*Pz*Vx 
     &     + Qy*Wz*Py*Vz + Qy*Wz*Pz*Vy + Qz*Wy*Py*Vz + Qz*Wy*Pz*Vy ) 
     &        + 2 * fac 
     &   * ( Qx*Wx*Px*Vx + Qy*Wy*Py*Vy + Qx*Wx*Pz*Vz + Qz*Wz*Px*Vx 
     &     + Qy*Wy*Pz*Vz + Qz*Wz*Py*Vy) 
     &        - 4 * fac 
     &   * ( Qx*Wx*Py*Vy + Qy*Wy*Px*Vx + Qz*Wz*Pz*Vz ) 

      fac = 1 / sqrt( 42._db )

      Tens(6) = 1.5 * fac 
     &   * ( Qy*Wz*Px*Vy + Qz*Wy*Px*Vy + Qy*Wz*Py*Vx + Qz*Wy*Py*Vx 
     &     + Qx*Wy*Py*Vz + Qx*Wy*Pz*Vy + Qy*Wx*Py*Vz + Qy*Wx*Pz*Vy ) 
     &        + fac 
     &   * ( Qz*Wz*Px*Vz + Qz*Wz*Pz*Vx + Qx*Wx*Px*Vz + Qx*Wx*Pz*Vx 
     &     + Qx*Wz*Pz*Vz + Qz*Wx*Pz*Vz + Qx*Wz*Px*Vx + Qz*Wx*Px*Vx ) 
     &        - 2 * fac 
     &   * ( Qy*Wy*Px*Vz + Qy*Wy*Pz*Vx + Qx*Wz*Py*Vy + Qz*Wx*Py*Vy )

      Tens(7) = 1.5 * fac * img 
     &   * ( Qx*Wz*Px*Vy + Qx*Wz*Py*Vx + Qz*Wx*Px*Vy + Qz*Wx*Py*Vx 
     &     + Qx*Wy*Px*Vz + Qx*Wy*Pz*Vx + Qy*Wx*Px*Vz + Qy*Wx*Pz*Vx ) 
     &        + fac * img 
     &   * ( Qz*Wz*Py*Vz + Qz*Wz*Pz*Vy + Qy*Wy*Py*Vz + Qy*Wy*Pz*Vy 
     &     + Qy*Wz*Pz*Vz + Qz*Wy*Pz*Vz + Qy*Wz*Py*Vy + Qz*Wy*Py*Vy ) 
     &        - 2 * fac * img 
     &   * ( Qx*Wx*Py*Vz + Qx*Wx*Pz*Vy + Qy*Wz*Px*Vx + Qz*Wy*Px*Vx )

      fac = 1 / sqrt( 42._db )

      Tens(8) = - fac * img 
     &   * ( Qx*Wx*Px*Vy + Qx*Wx*Py*Vx + Qy*Wy*Px*Vy + Qy*Wy*Py*Vx 
     &     + Qx*Wy*Px*Vx + Qy*Wx*Px*Vx + Qx*Wy*Py*Vy + Qy*Wx*Py*Vy ) 
     &        + 2 * fac * img
     &   * ( Qz*Wz*Px*Vy + Qz*Wz*Py*Vx + Qx*Wy*Pz*Vz + Qy*Wx*Pz*Vz )   
     &        - 1. 5 * fac * img 
     &   * ( Qx*Wz*Py*Vz + Qx*Wz*Pz*Vy + Qz*Wx*Py*Vz + Qz*Wx*Pz*Vy 
     &     + Qy*Wz*Px*Vz + Qy*Wz*Pz*Vx + Qz*Wy*Px*Vz + Qz*Wy*Pz*Vx ) 

      Tens(9) = 2 * fac 
     &   * ( Qz*Wz*Px*Vx - Qz*Wz*Py*Vy + Qx*Wx*Pz*Vz - Qy*Wy*Pz*Vz 
     &     + Qy*Wy*Py*Vy - Qx*Wx*Px*Vx ) 
     &        + 1. 5 * fac 
     &   * ( Qy*Wz*Py*Vz + Qy*Wz*Pz*Vy + Qz*Wy*Py*Vz + Qz*Wy*Pz*Vy 
     &     - Qx*Wz*Px*Vz - Qx*Wz*Pz*Vx - Qz*Wx*Px*Vz - Qz*Wx*Pz*Vx ) 

! Octupole magnetique

      fac = 1 / sqrt( 10._db )

      Tens(10) = 0.5 * fac * img 
     &   * ( Qx*Wy*Px*Vx - Qx*Wy*Py*Vy + Qy*Wx*Px*Vx - Qy*Wx*Py*Vy 
     &     - Qx*Wx*Px*Vy + Qy*Wy*Px*Vy - Qx*Wx*Py*Vx + Qy*Wy*Py*Vx )
     &         + fac * img 
     &   * ( Qx*Wz*Py*Vz + Qx*Wz*Pz*Vy + Qz*Wx*Py*Vz + Qz*Wx*Pz*Vy 
     &     - Qy*Wz*Px*Vz - Qz*Wy*Px*Vz - Qy*Wz*Pz*Vx - Qz*Wy*Pz*Vx ) 

      fac = 1 / ( 4 * sqrt( 15._db ) )

      Tens(11) = 3 * fac * img 
     &   * ( Qx*Wy*Px*Vz + Qx*Wy*Pz*Vx + Qy*Wx*Px*Vz + Qy*Wx*Pz*Vx 
     &     - Qx*Wz*Px*Vy - Qx*Wz*Py*Vx - Qz*Wx*Px*Vy - Qz*Wx*Py*Vx ) 
     &         + 4 * fac * img 
     &   * ( Qz*Wz*Py*Vz + Qz*Wz*Pz*Vy - Qy*Wz*Pz*Vz - Qz*Wy*Pz*Vz ) 
     &         + 5 * fac * img 
     &   * ( Qy*Wz*Px*Vx + Qz*Wy*Px*Vx - Qx*Wx*Py*Vz - Qx*Wx*Pz*Vy ) 
     &         + fac * img 
     &   * ( Qy*Wy*Py*Vz + Qy*Wy*Pz*Vy - Qy*Wz*Py*Vy - Qz*Wy*Py*Vy ) 

      Tens(12) = 3 * fac 
     &   * ( Qx*Wy*Py*Vz + Qx*Wy*Pz*Vy + Qy*Wx*Py*Vz + Qy*Wx*Pz*Vy 
     &     - Qy*Wz*Px*Vy - Qy*Wz*Py*Vx - Qz*Wy*Px*Vy - Qz*Wy*Py*Vx ) 
     &         + 4 * fac 
     &   * ( Qz*Wz*Px*Vz + Qz*Wz*Pz*Vx - Qx*Wz*Pz*Vz - Qz*Wx*Pz*Vz ) 
     &         + 5 * fac 
     &   * ( Qx*Wz*Py*Vy + Qz*Wx*Py*Vy - Qy*Wy*Px*Vz - Qy*Wy*Pz*Vx ) 
     &         + fac 
     &   * ( Qx*Wx*Px*Vz + Qx*Wx*Pz*Vx - Qx*Wz*Px*Vx - Qz*Wx*Px*Vx ) 

      fac = 1 / sqrt( 6._db )

      Tens(13) = fac 
     &   * ( Qx*Wx*Pz*Vz - Qz*Wz*Px*Vx + Qy*Wy*Px*Vx - Qx*Wx*Py*Vy 
     &     + Qz*Wz*Py*Vy - Qy*Wy*Pz*Vz ) 

      Tens(14) = fac * img 
     &   * ( Qx*Wy*Pz*Vz + Qy*Wx*Pz*Vz - Qz*Wz*Px*Vy - Qz*Wz*Py*Vx ) 
     &         + 0.5 * fac * img 
     &   * ( Qx*Wx*Px*Vy + Qx*Wx*Py*Vx + Qy*Wy*Px*Vy + Qy*Wy*Py*Vx 
     &     - Qx*Wy*Px*Vx - Qy*Wx*Px*Vx - Qx*Wy*Py*Vy - Qy*Wx*Py*Vy ) 

      fac = 0.25_db

      Tens(15) = fac * img 
     &   * ( Qy*Wz*Px*Vx - Qy*Wz*Py*Vy + Qz*Wy*Px*Vx - Qz*Wy*Py*Vy 
     &     + Qx*Wz*Px*Vy + Qx*Wz*Py*Vx + Qz*Wx*Px*Vy + Qz*Wx*Py*Vx 
     &     - Qx*Wx*Py*Vz + Qy*Wy*Py*Vz - Qx*Wx*Pz*Vy + Qy*Wy*Pz*Vy 
     &     - Qx*Wy*Px*Vz - Qy*Wx*Px*Vz - Qx*Wy*Pz*Vx - Qy*Wx*Pz*Vx ) 

      Tens(16) = fac 
     &   * ( Qx*Wz*Px*Vx - Qx*Wz*Py*Vy + Qz*Wx*Px*Vx - Qz*Wx*Py*Vy 
     &     - Qy*Wz*Px*Vy - Qy*Wz*Py*Vx - Qz*Wy*Px*Vy - Qz*Wy*Py*Vx 
     &     - Qx*Wx*Px*Vz + Qy*Wy*Px*Vz - Qx*Wx*Pz*Vx + Qy*Wy*Pz*Vx 
     &     + Qx*Wy*Py*Vz + Qy*Wx*Py*Vz + Qx*Wy*Pz*Vy + Qy*Wx*Pz*Vy ) 

! Hexadecapole non-magnetique

      fac = 1 / ( 2 * sqrt( 70._db ) ) 

      Tens(17) = 3 * fac 
     &   * ( Qx*Wx*Px*Vx + Qy*Wy*Py*Vy ) 
     &         + fac
     &   * ( Qx*Wx*Py*Vy + Qy*Wy*Px*Vx + Qx*Wy*Px*Vy + Qx*Wy*Py*Vx 
     &     + Qy*Wx*Px*Vy + Qy*Wx*Py*Vx ) 
     &         + 8 * fac
     &   * Qz*Wz*Pz*Vz 
     &         - 4 * fac
     &   * ( Qz*Wz*Px*Vx + Qz*Wz*Py*Vy + Qx*Wx*Pz*Vz + Qy*Wy*Pz*Vz 
     &     + Qx*Wz*Px*Vz + Qx*Wz*Pz*Vx + Qz*Wx*Px*Vz + Qz*Wx*Pz*Vx 
     &     + Qy*Wz*Py*Vz + Qy*Wz*Pz*Vy + Qz*Wy*Py*Vz + Qz*Wy*Pz*Vy ) 

      fac = 1 / ( 4 * sqrt( 7._db ) ) 

      Tens(18) = 3 * fac 
     &   * ( Qx*Wz*Px*Vx + Qz*Wx*Px*Vx + Qx*Wx*Px*Vz + Qx*Wx*Pz*Vx ) 
     &         + fac
     &   * ( Qx*Wz*Py*Vy + Qz*Wx*Py*Vy + Qy*Wy*Px*Vz + Qy*Wy*Pz*Vx  
     &     + Qy*Wz*Px*Vy + Qy*Wz*Py*Vx + Qz*Wy*Px*Vy + Qz*Wy*Py*Vx 
     &     + Qy*Wx*Pz*Vy + Qx*Wy*Pz*Vy + Qx*Wy*Py*Vz + Qy*Wx*Py*Vz ) 
     &         - 4 * fac
     &   * ( Qz*Wz*Px*Vz + Qz*Wz*Pz*Vx + Qx*Wz*Pz*Vz + Qz*Wx*Pz*Vz ) 

      Tens(19) = 3 * fac * img 
     &   * ( Qy*Wz*Py*Vy + Qz*Wy*Py*Vy + Qy*Wy*Py*Vz + Qy*Wy*Pz*Vy ) 
     &         + fac * img
     &   * ( Qy*Wz*Px*Vx + Qz*Wy*Px*Vx + Qx*Wx*Py*Vz + Qx*Wx*Pz*Vy  
     &     + Qx*Wz*Px*Vy + Qx*Wz*Py*Vx + Qz*Wx*Px*Vy + Qz*Wx*Py*Vx 
     &     + Qx*Wy*Px*Vz + Qx*Wy*Pz*Vx + Qy*Wx*Px*Vz + Qy*Wx*Pz*Vx ) 
     &         - 4 * fac * img
     &   * ( Qy*Wz*Pz*Vz + Qz*Wy*Pz*Vz + Qz*Wz*Pz*Vy + Qz*Wz*Py*Vz ) 

      fac = 1 / sqrt( 14._db ) 

      Tens(20) = fac * img 
     &   * ( Qz*Wz*Px*Vy + Qz*Wz*Py*Vx + Qx*Wy*Pz*Vz + Qy*Wx*Pz*Vz  
     &     + Qx*Wz*Py*Vz + Qx*Wz*Pz*Vy + Qz*Wx*Py*Vz + Qz*Wx*Pz*Vy 
     &     + Qy*Wz*Px*Vz + Qy*Wz*Pz*Vx + Qz*Wy*Px*Vz + Qz*Wy*Pz*Vx ) 
     &         - 0.5 * fac * img
     &   * ( Qx*Wx*Px*Vy + Qx*Wx*Py*Vx + Qy*Wy*Px*Vy + Qy*Wy*Py*Vx  
     &     + Qx*Wy*Px*Vx + Qy*Wx*Px*Vx + Qx*Wy*Py*Vy + Qy*Wx*Py*Vy ) 

      Tens(21) = fac 
     &   * ( Qz*Wz*Px*Vx - Qz*Wz*Py*Vy - Qx*Wx*Px*Vx + Qy*Wy*Py*Vy  
     &     + Qx*Wx*Pz*Vz - Qy*Wy*Pz*Vz + Qx*Wz*Px*Vz + Qx*Wz*Pz*Vx 
     &     + Qz*Wx*Px*Vz + Qz*Wx*Pz*Vx - Qy*Wz*Py*Vz - Qy*Wz*Pz*Vy
     &     - Qz*Wy*Py*Vz - Qz*Wy*Pz*Vy ) 

      fac = 0.25_db 

      Tens(22) = - fac 
     &   * ( Qx*Wz*Px*Vx - Qx*Wz*Py*Vy + Qz*Wx*Px*Vx - Qz*Wx*Py*Vy  
     &     - Qy*Wz*Py*Vx - Qy*Wz*Px*Vy - Qz*Wy*Py*Vx - Qz*Wy*Px*Vy 
     &     - Qx*Wy*Pz*Vy + Qx*Wx*Px*Vz - Qy*Wy*Px*Vz + Qx*Wx*Pz*Vx
     &     - Qy*Wy*Pz*Vx - Qy*Wx*Py*Vz - Qx*Wy*Py*Vz - Qy*Wx*Pz*Vy ) 

      Tens(23) = - fac * img 
     &   * ( Qy*Wz*Px*Vx - Qy*Wz*Py*Vy + Qz*Wy*Px*Vx - Qz*Wy*Py*Vy  
     &     + Qx*Wz*Px*Vy + Qx*Wz*Py*Vx + Qz*Wx*Px*Vy + Qz*Wx*Py*Vx 
     &     + Qy*Wx*Pz*Vx + Qx*Wx*Py*Vz - Qy*Wy*Py*Vz + Qx*Wx*Pz*Vy
     &     - Qy*Wy*Pz*Vy + Qx*Wy*Px*Vz + Qy*Wx*Px*Vz + Qx*Wy*Pz*Vx ) 

      fac = 1 / ( 2 * sqrt( 2._db ) ) 

      Tens(24) = fac * img 
     &   * ( Qx*Wy*Px*Vx - Qx*Wy*Py*Vy + Qy*Wx*Px*Vx - Qy*Wx*Py*Vy  
     &     + Qx*Wx*Px*Vy + Qx*Wx*Py*Vx - Qy*Wy*Px*Vy - Qy*Wy*Py*Vx ) 

      Tens(25) = fac 
     &   * ( Qx*Wx*Px*Vx + Qy*Wy*Py*Vy - Qx*Wx*Py*Vy - Qy*Wy*Px*Vx  
     &     - Qx*Wy*Px*Vy - Qx*Wy*Py*Vx - Qy*Wx*Px*Vy - Qy*Wx*Py*Vx ) 

      Tensor_pol_qq(ipl,:) = Tens(:) 

      return
      end

!***********************************************************************

! Ecriture des fonctions physiques

      subroutine write_phys(ct_nelec,E_cut,energ,ephseuil,Epsii,
     &      eseuil,ia,
     &      ie,Int_tens,ipl0,ipl2,Length_word,magn_sens,n_tens_dd,
     &      n_tens_dq,n_tens_max,n_tens_qq,n_tens_t,natomsym,nenerg,
     &      nomfich1,npldafs,nplr,nplt,numat_abs,phdf0t,phdt,
     &      Sph_tensor_dd,Sph_tensor_dq,Sph_tensor_dq_mag,
     &      Sph_tensor_qq,Tensor_pol_dd,Tensor_pol_dq,Tensor_pol_qq,
     &      v0muf,writout)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      character(len=Length_word) mot
      character(len=132) nomfich1, nomficht
      character(len=8), dimension(49):: nomtens
      character(len=Length_word), dimension(n_tens_max):: nomten

      complex(kind=db):: cf, cg, Ten, Ten_mag
      complex(kind=db), dimension(1):: cdum
      complex(kind=db), dimension(n_tens_dd):: Sph_tensor_dd
      complex(kind=db), dimension(n_tens_dq):: Sph_tensor_dq,
     &                                        Sph_tensor_dq_mag
      complex(kind=db), dimension(n_tens_qq):: Sph_tensor_qq
      complex(kind=db), dimension(0:nplt,n_tens_dd):: Tensor_pol_dd
      complex(kind=db), dimension(0:nplt,2*n_tens_dq):: Tensor_pol_dq
      complex(kind=db), dimension(0:nplt,n_tens_qq):: Tensor_pol_qq
      complex(kind=db), dimension(npldafs):: phdf0t, phdt
      complex(kind=db), dimension(n_tens_max):: ph0, phtem, Resul

      logical comp_dd, comp_md, comp_do, comp_dq, comp_mm, comp_qq,
     &        magn_sens, polarise, spherical_signal, writout 

      real(kind=db), dimension(n_tens_max,0:natomsym):: Int_tens
      real(kind=db), dimension(n_tens_max):: Int_tenst, Tens
      real(kind=db), dimension(nenerg):: energ

      common/comp_dd/ comp_dd, comp_md, comp_do, comp_dq,comp_mm,comp_qq 
      common/lseuil/ jseuil, lseuil, nseuil
      common/polarise/ polarise
      common/spherical_signal/ spherical_signal

      data nomtens/ 
     &  '  D(00) ','  lz_dd ',' -lx_dd ','  ly_dd ','  D(20) ',
     &  '  D(21)d','-iD(21)s','-iD(22)d','  D(22)s',
     &  '  I(10) ','  I(11)d','-iI(11)s','-iI(20) ','-iI(21)d',
     &  '  I(21)s','  I(22)d','-iI(22)s','  I(30) ','  I(31)d',
     &  '  I(31)s','-iI(32)d',' I(32)s ','  I(33)d','-iI(33)s',
     &  '  Q(00) ','  lz_qq ',' -lx_qq ','  ly_qq ','  Q(20) ',
     &  '  Q(21)d','-iQ(21)s','-iQ(22)d','  Q(22)s','  Q(30) ',
     &  '  Q(31)d','-iQ(31)s','-iQ(32)d','  Q(32)s','-iQ(33)d',
     &  '-iQ(33)s','  Q(40) ','  Q(41)d','  Q(41)s','-iQ(42)d',
     &  '  Q(42)s','  Q(43)d','-iQ(43)s','-iQ(44)d','  Q(44)s'/

      if( writout ) then

        j = 0
        do itens = 1,n_tens_t

          if( itens <= n_tens_dd ) then

            if( .not. comp_dd ) cycle
            i = itens
            if( i == 1 ) then
! On divise la premiere composante du tenseur spherique par rac(3)
! (premiere composante du tenseur de polarisation) pour obtenir le
! terme de diffusion isotrope
              Ten = Sph_tensor_dd(i) / sqrt(3._db)
            elseif( i >= 2 .and. i <= 4 ) then
! On divise les composantes 2, 3 et 4 du tenseur spherique par rac(2)
! (composantes du tenseur de polarisation) pour obtenir le
! moment magnetique
              Ten = Sph_tensor_dd(i) / sqrt(2._db)
            else
              Ten = Sph_tensor_dd(i)
            endif

          elseif( itens > n_tens_dd 
     &                    .and. itens <= n_tens_dd + n_tens_dq ) then

            if( .not. comp_dq ) cycle
            i = itens - n_tens_dd
            Ten = Sph_tensor_dq(i)
            if( ia == 0 .and. magn_sens ) Ten_mag = Sph_tensor_dq_mag(i)

          elseif(  itens > n_tens_dd + n_tens_dq) then

            if( .not. comp_qq ) cycle
            i = itens - n_tens_dd - n_tens_dq
            if( i == 1 ) then
! On divise la premiere composante du tenseur spherique par rac(3)
! (premiere composante du tenseur de polarisation) pour obtenir le
! terme de diffusion isotrope
              Ten = Sph_tensor_qq(i) / sqrt(3._db)
            elseif( i >= 2 .and. i <= 4 ) then
! On divise les composantes 2, 3 et 4 du tenseur spherique par rac(2)
! (composantes du tenseur de polarisation) pour obtenir le
! moment magnetique
              Ten = Sph_tensor_qq(i) / sqrt(2._db)
            else
              Ten = Sph_tensor_qq(i)
            endif

          endif

          j = j + 1
          Tens(j) = real( Ten,db ) 
          if( ipl0 > 1 .or. ( magn_sens .and. itens > n_tens_dd 
     &                    .and. itens <= n_tens_dd + n_tens_dq ) ) then
            mot = nomtens(itens) 
            mot = adjustl( mot )
            l = len_trim( mot )
            mot(l+1:l+2) = '_r'
            nomten(j) = mot
            j = j + 1
            Tens(j) = aimag( Ten )
            mot(l+2:l+2) = 'i'
            nomten(j) = mot
          else 
            nomten(j) = nomtens(itens)
          endif
          if( ia == 0 .and. magn_sens .and. itens > n_tens_dd 
     &                    .and. itens <= n_tens_dd + n_tens_dq ) then
            j = j + 1
            Tens(j) = real( Ten_mag,db ) 
            mot(l+2:l+3) = 'rm' 
            nomten(j) = mot
            j = j + 1
            Tens(j) = aimag( Ten_mag ) 
            mot(l+2:l+3) = 'im' 
            nomten(j) = mot
          endif

        end do

        n_tens = j

        nomficht = nomfich1
        long = len_trim(nomficht)
        nomficht(long+1:long+4) = '_sph'
        if( ia > 0 ) then
          nomficht(long+5:long+9) = '_atom'
          call ad_number(ia,nomficht,132)
        else
          nomficht(long+5:long+9) = '_xtal'
        endif
        if( ipl0 > 1 ) then
          long = len_trim(nomficht)
          nomficht(long+1:long+4) = '_rxs'
          ipldafs = ipl0 - nplr
          call ad_number(ipldafs,nomficht,132)
        endif
        long = len_trim(nomficht)
        nomficht(long+1:long+4) = '.txt'

        call write_out(0._db,E_cut,ephseuil,
     &                 Epsii,eseuil,ie,Length_word,
     &                 lseuil,n_tens_max,n_tens,nomficht,nomten,1,0,
     &                 nseuil,numat_abs,cdum,cdum,Tens,v0muf)

      endif

! Integrale
      if( nenerg > 1 .and. ipl0 <= 1 .and. writout ) then
        nomficht = nomfich1
        long = len_trim(nomficht)
        nomficht(long+1:long+4) = '_sph'
        if( ia > 0 ) then
          nomficht(long+5:long+9) = '_atom'
          call ad_number(ia,nomficht,132)
        else
          nomficht(long+5:long+9) = '_xtal'
        endif
        long = len_trim(nomficht)
        nomficht(long+1:long+8) = '_int.txt'

        if( ie == 1 ) then
          do i = 1,n_tens
            mot = nomten(i)
            mot = adjustl( mot )
            long = len_trim( mot )
            if( long < Length_word - 2 ) then
              mot(1:Length_word) = 'I_' // mot(1:Length_word-2)
            elseif( long == Length_word - 2 ) then
              mot(1:Length_word-1) = 'I' // mot(1:Length_word-1)
            endif 
            nomten(i) = mot
          end do
          de = energ(2) - energ(1) 
          Int_tens(1:n_tens,ia) = de * Tens(1:n_tens)
        else
          if( ie == nenerg ) then
            de = energ(ie) - energ(ie-1) 
          else 
            de = 0.5 * ( energ(ie+1) -  energ(ie-1) ) 
          endif
          Int_tens(1:n_tens,ia) = Int_tens(1:n_tens,ia)
     &                          + de * Tens(1:n_tens)
        endif

        Int_tenst(1:n_tens) = Int_tens(1:n_tens,ia) 
        call write_out(0._db,E_cut,ephseuil,
     &               Epsii,eseuil,ie,Length_word,
     &               lseuil,n_tens_max,n_tens,nomficht,nomten,1,0,
     &               nseuil,numat_abs,cdum,cdum,Int_tenst,v0muf)

      endif

      if( .not. spherical_signal ) return

! Calcul des tenseurs appliques aux reflexions RXS et au xanes

      if( comp_dd .and. comp_dq .and. comp_qq ) then
        j0 = 4
      elseif( ( comp_dd .and. comp_dq ) .or. ( comp_dd .and. comp_qq )
     &   .or. ( comp_dq .and. comp_qq ) ) then
        j0 = 3
      else
        j0 = 1
      endif
      jdd = 0; jdq = 0; jqq = 0
      if( comp_dd ) jdd = min(j0,2)
      if( comp_dq ) then
        if( comp_qq ) then      
          jdq = j0 - 1
        else
          jdq = j0
        endif
      endif
      if( comp_qq ) jqq = j0

      if( polarise ) then
        iplf = ipl2
      else
        iplf = ipl0
      endif

      do ipl = ipl0,iplf

        Resul(:) = (0._db,0._db)

        j = j0
        if( ipl > nplr ) then
          jj = 2 * j
        else
          jj = j
        endif  
        do itens = 1,n_tens_t

          if( itens <= n_tens_dd ) then
            if( .not. comp_dd ) cycle
            i = itens
            j = j + 1
            Resul(j) = Tensor_pol_dd(ipl,i) * Sph_tensor_dd(i)

! Devant le produit, il faut mettre un signe -1 devant les tenseurs
! impairs
            if( i >= 2 .and. i <= 4 ) Resul(j) = - Resul(j)   
! On recupere le img omis dans les tenseurs imaginaires
            if( i == 4 .or. i == 7 .or. i == 8 ) Resul(j) = img*Resul(j)
! On recupere le -1 devant les tenseurs differences
            if( i == 3 .or. i == 6 .or. i == 8 ) Resul(j) = - Resul(j)
! On recupere le (-1)**m
            if( i == 3 .or. i == 4 .or. i == 6 .or. i == 7)
     &                                         Resul(j) = - Resul(j)

            Resul(jdd) = Resul(jdd) + Resul(j)

          elseif( itens > n_tens_dd 
     &                   .and. itens <= n_tens_dd + n_tens_dq ) then

            if( .not. comp_dq ) cycle
            i = itens - n_tens_dd
            do is = 1,2
              if( is == 2 .and. .not. ( ia == 0 .and. magn_sens ) ) exit  
              j = j + 1
! Les parties reelles et imaginaires sont a considerer avant la
! multiplication par le img eventuel.
              if( is == 1 ) then
                Resul(j) = Sph_tensor_dq(i) * Tensor_pol_dq(ipl,i) 
              else
                Resul(j) = Sph_tensor_dq_mag(i)
     &                   * Tensor_pol_dq(ipl,i+n_tens_dq)
              endif

! Devant le produit, il faut mettre un signe -1 devant les tenseurs
! impairs
              if( i >= 4 .and. i <= 8 ) Resul(j) = - Resul(j)
! On recupere le img omis dans les tenseurs
              if( i == 3 .or. i == 4 .or. i == 5 .or. i == 8 
     &         .or. i == 11 .or. i == 12 .or. i == 15 ) 
     &                                  Resul(j) = img * Resul(j)

! On multiplie par -1 devant les tenseurs differences
              if( i == 2 .or. i == 5 .or. i == 7 .or. i == 10
     &          .or. i == 12 .or. i == 14 ) Resul(j) = - Resul(j)
! On multiplie par (-1)**m
              if( i == 2 .or. i == 3 .or. i == 5 .or. i == 6
     &         .or. i == 10 .or. i == 11 .or. i == 14 .or. i == 15 )
     &                                      Resul(j) = - Resul(j)
! On recupere le img exterieur au tenseur propre au dipole-quadrupole
              Resul(j) = img * Resul(j) 

              Resul(jdq) = Resul(jdq) + Resul(j)

            end do

          elseif( itens > n_tens_dd + n_tens_dq ) then

            if( .not. comp_qq ) cycle
            i = itens - n_tens_dd - n_tens_dq
            j = j + 1

            Resul(j) = Tensor_pol_qq(ipl,i) * Sph_tensor_qq(i)
! Devant le produit, il faut mettre un signe -1 devant les tenseurs
! impairs
            if( ( i >= 2 .and. i <= 4 ) .or. ( i >= 10 .and. i <= 16 ) )
     &          Resul(j) = - Resul(j)
! On recupere le img omis dans les tenseurs imaginaires
            if( i == 4 .or. i == 7 .or. i == 8 .or. i == 12 
     &         .or. i == 13 .or. i == 16 .or. i == 19 .or. i == 20  
     &          .or. i == 23 .or. i == 24 ) Resul(j) = img * Resul(j)
! On multiplie par -1 devant les tenseurs differences
            if( i == 3 .or. i == 6 .or. i == 8 .or. i == 11 .or. i == 13
     &         .or. i == 15 .or. i == 18 .or. i == 20 .or. i == 22
     &         .or. i == 24 ) Resul(j) = - Resul(j)
! On multiplie par (-1)**m
            if( i == 3 .or. i == 4 .or. i == 6 .or. i == 7
     &         .or. i == 11 .or. i == 12 .or. i == 15  .or. i == 16
     &         .or. i == 18 .or. i == 19 .or. i == 22  .or. i == 23 )
     &                       Resul(j) = - Resul(j)

            Resul(jqq) = Resul(jqq) + Resul(j)

          endif

          mot = nomtens(itens)
          l = len_trim( mot )
          jj = jj + 1
          if( itens > n_tens_dd 
     &                   .and. itens <= n_tens_dd + n_tens_dq
     &          .and. ia == 0 .and. magn_sens ) then
            if( ipl > nplr ) then
              mot(l+1:l+2) = '_r'
              nomten(jj) = mot
              tens(jj) = real( Resul(j-1),db )
              jj = jj + 1
              mot(l+1:l+2) = '_i'
              nomten(jj) = mot
              tens(jj) = aimag( Resul(j-1) )
              jj = jj + 1
              mot(l+1:l+3) = '_mr'
              nomten(jj) = mot
              tens(jj) = real( Resul(j),db )
              jj = jj + 1
              mot(l+1:l+3) = '_mi'
              nomten(jj) = mot
              tens(jj) = aimag( Resul(j) )
            else
              nomten(jj) = mot
              tens(jj) = real( Resul(j-1),db )
              jj = jj + 1
              mot(l+1:l+2) = '_m'
              nomten(jj) = mot
              tens(jj) = real( Resul(j),db )
            endif
          else
            if( ipl > nplr ) then
              mot(l+1:l+2) = '_r'
              nomten(jj) = mot
              tens(jj) = real( Resul(j),db )
              jj = jj + 1
              mot(l+1:l+2) = '_i'
              nomten(jj) = mot
              tens(jj) = aimag( Resul(j) )
            else
              nomten(jj) = mot
              tens(jj) = real( Resul(j),db )
            endif
          endif

        end do

        n_tens = jj

        if( j0 > 1 ) Resul(1) = sum( Resul(2:j0) )

        i = 0
        j = 0
        do it = 1,j0
          i = i + 1
          if( it == jdd ) then
            nomten(i) = 'Sum_dd'
          elseif( it == jdq ) then
            nomten(i) = 'Sum_dq'
          elseif( it == jqq ) then
            nomten(i) = 'Sum_qq'
          else
            nomten(i) = 'Sum_tot'
          endif
          j = j + 1
          Tens(i) = real( Resul(j),db )
          if( ipl > nplr ) then
            mot = nomten(i)
            l = len_trim( mot )
            mot(l+1:l+2) = '_r'
            nomten(i) = mot
            i = i + 1
            mot(l+1:l+2) = '_i'
            nomten(i) = mot
            Tens(i) = aimag( Resul(j) )
          endif
        end do

! On donne le Xanes en Megabarns
        if( ipl <= nplr ) then
          do i = 1,n_tens
             if( abs(Tens(i)) > 1e-20_db ) Tens(i) = Tens(i) / ct_nelec
           end do
        endif

! Ecriture des tenseurs appliques aux reflexions RXS et au xanes

        nomficht = nomfich1

        long = len_trim(nomficht)
        nomficht(long+1:long+11) = '_sph_signal'
        if( ia > 0 ) then
          nomficht(long+12:long+16) = '_atom'
          call ad_number(ia,nomficht,132)
        endif
        long = len_trim(nomficht)
        if( ipl > nplr ) then
          nomficht(long+1:long+4) = '_rxs'
          call ad_number(ipl-nplr,nomficht,132)
        elseif( ipl == 0 ) then
          nomficht(long+1:long+4) = '_xan'
        else
          nomficht(long+1:long+4) = '_pol'
          call ad_number(ipl,nomficht,132)
        endif
        long = len_trim(nomficht)
        nomficht(long+1:long+4) = '.txt'

        if( ipl > nplr ) then
          if( ia == 0 ) then
            cf = phdt(ipl-nplr)
            cg = phdf0t(ipl-nplr) 
          else
            cf = (1._db,0._db)
            cg = (0._db,0._db)
          endif 
          phtem(:) = cf
          ph0(:) = cg 
          n_tens2 = n_tens / 2
          call write_out(0._db,E_cut,ephseuil,
     &           Epsii,eseuil,ie,Length_word,
     &           lseuil,n_tens_max,n_tens,nomficht,nomten,n_tens_max,
     &           n_tens2,nseuil,numat_abs,phtem,ph0,Tens,v0muf)
        else
          call write_out(0._db,E_cut,ephseuil,
     &                 Epsii,eseuil,ie,Length_word,
     &                 lseuil,n_tens_max,n_tens,nomficht,nomten,1,
     &                 0,nseuil,numat_abs,cdum,cdum,Tens,v0muf)
        endif

      end do

      return
      end

!***********************************************************************

! Calculs de donnees intermediaires

      subroutine cal_data(cal_xanes,drho_self,Full_atom,hubbard,
     &            iaabsi,iaprotoi,id0,id,ipr0,it0,itypei,itypepr,
     &            lla2_state,lmaxat,mpinodes,mpirank,n_atom_0,
     &            n_atom_0_self,n_atom_ind,n_atom_ind_self,n_atom_proto,
     &            natome,nlmmax,nrato,nrm,nrm_self,
     &            nspin,nspino,ntype,numat,rato,rhov_self,rmtsd,
     &            rofsd,sing_self,singulsd,solsing,solsing_only,
     &            spinorbite,state_all,statedens,taull)

      use declarations  
      implicit none
 
      integer ia, iaabsi, iapr, id, id0, ipr, ipr0, ir, isp, isq, isr,
     &        it, it0, l, ll, lla2_state, lm, lm0, lmq, lmr, lms,
     &        m, m1, mf, mpinodes, mpirank, mq, mr, n_atom_0,
     &        n_atom_0_self, n_atom_ind, n_atom_ind_self, 
     &        n_atom_proto, natome, nlmmax, nr, nrm,
     &        nrm_self, nspin, nspino, ntype, Z

      complex(kind=db), dimension(nlmmax,nspin,nlmmax,nspin,natome)::
     &                                                          taull
      complex(kind=db), dimension(0:nrm_self,id0:id,nspin,nspino,
     &            nspino,n_atom_0_self:n_atom_ind_self):: rhov_self
      complex(kind=db), dimension(n_atom_0:n_atom_ind,nlmmax,nspin, 
     &                           nspino,nspino):: rofsd

      integer, dimension(it0:ntype):: nrato, numat
      integer, dimension(ipr0:n_atom_proto):: itypepr, lmaxat
      integer, dimension(natome):: iaprotoi, itypei

      logical:: Absorbeur, cal_xanes, Full_atom, hubbard,
     &          solsing, solsing_only, spinorbite, state_all
      logical, dimension(n_atom_0:n_atom_ind):: iapr_done 
 
      real(kind=db):: spinq, spinr
      real(kind=db), dimension(ipr0:n_atom_proto) :: rmtsd 
      real(kind=db), dimension(lla2_state,nspin,n_atom_0:n_atom_ind,
     &                               0:mpinodes-1):: statedens
      real(kind=db), dimension(0:nrm,it0:ntype):: rato
      real(kind=db), dimension(0:nrm_self,nspin,
     &          n_atom_0_self:n_atom_ind_self,0:mpinodes-1):: drho_self
      real(kind=db), dimension(0:nrm_self,id0:id,nspin, 
     &                       n_atom_0_self:n_atom_ind_self):: sing_self
      real(kind=db), dimension(nlmmax,nspin,n_atom_0:n_atom_ind):: 
     &                                                         singulsd
     
      if( .not. cal_xanes ) drho_self(:,:,:,mpirank) = 0._db
      statedens(:,:,:,mpirank) = 0._db
      iapr_done(:) = .false.

      boucle_ia: do ia = 1,natome  

        Absorbeur = ia == iaabsi
        if( cal_xanes .and. .not. ( state_all .or. Absorbeur ) ) cycle
  
        ipr = iaprotoi(ia)

        Z = numat( itypepr(ipr) )
        if( Z < 19 ) then
          ll = min(2,lmaxat(ipr))
        elseif( Z > 18 .and. Z < 55 ) then
          ll = min(3,lmaxat(ipr))
        else
          ll = min(4,lmaxat(ipr))
        endif 

        if( Full_atom ) then
          iapr = ia
        else
          iapr = ipr
          if( iapr_done(iapr) ) cycle 
        endif
        it = itypei(ia)
               
        do ir = 1,nrato(it)
          if( rato(ir,it) > Rmtsd(ipr) + eps10 ) exit
        end do
        nr = ir

        do l = 0,ll
          if( spinorbite ) then
            m1 = - l - 1
            lm0 = l**2 + l + 1
          else
            m1 = - l
          endif
          do m = m1,l
            if( .not. solsing_only ) then
              do isp = 1,nspin

                if( spinorbite ) then
                  mf = m - 1 + isp
                  if( mf < -l .or. mf > l ) cycle
                  lm = lm0 + mf
                  do isq = 1,2
                    spinq = 1.5 - isq
                    mq = m + nint( 0.5 - spinq )
                    if( mq < -l .or. mq > l ) cycle
                    lmq = lm0 + mq 
                    do isr = 1,2
                      spinr = 1.5 - isr
                      mr = m + nint( 0.5 - spinr ) 
                      if( mr < -l .or. mr > l ) cycle
                      lmr = lm0 + mr
                      statedens(lm,isp,iapr,mpirank)
     &                  = statedens(lm,isp,iapr,mpirank) - aimag( 
     &                        rofsd(iapr,lm,isp,isq,isr)
     &                       * taull(lmq,isq,lmr,isr,ia) )

                      if( .not. cal_xanes ) 
     &                  drho_self(1:nr,isp,iapr,mpirank)
     &                = drho_self(1:nr,isp,iapr,mpirank) - aimag(
     &                   rhov_self(1:nr,lm,isp,isq,isr,iapr)
     &                   * taull(lmq,isq,lmr,isr,ia) )
                    end do
                  end do
                else
                  lm = l**2 + l + 1 + m
                  if( hubbard ) then
                    lms = lm
                  else 
                    lms = l
                  endif
                  statedens(lm,isp,iapr,mpirank)
     &               = statedens(lm,isp,iapr,mpirank) - aimag(
     &                              rofsd(iapr,lm,isp,1,1)
     &                           * taull(lm,isp,lm,isp,ia) )

                  if( .not. cal_xanes )
     &                    drho_self(1:nr,isp,iapr,mpirank)
     &                  = drho_self(1:nr,isp,iapr,mpirank) - aimag(
     &                    rhov_self(1:nr,lms,isp,1,1,iapr)
     &                  * taull(lm,isp,lm,isp,ia) )
                endif

              end do
            endif

            if( solsing ) then
              do isp = 1,nspin

                if( spinorbite ) then
                  mf = m - 1 + isp
                  if( mf < -l .or. mf > l ) cycle
                  lm = lm0 + mf
                  lms = lm
                else
                  lm = l**2 + l + 1 + m
                  if( hubbard ) then
                    lms = lm
                  else 
                    lms = l
                  endif
                endif

                statedens(lm,isp,iapr,mpirank)
     &                            = statedens(lm,isp,iapr,mpirank)
     &                            + singulsd(lm,isp,iapr)

                if( .not. cal_xanes )
     &            drho_self(1:nr,isp,iapr,mpirank)
     &                              = drho_self(1:nr,isp,iapr,mpirank)
     &                              + sing_self(1:nr,lms,isp,iapr)

              end do   ! boucle spin
            endif

          end do
        end do
        
        iapr_done(iapr) = .true.

      end do boucle_ia
         
      return
      end

!***********************************************************************

! Calculs de donnees intermediaires pour Hubbard

      subroutine cal_data_hub(Full_atom,hubb,i_self,
     &            iaprotoi,icheck,it0,itypei,
     &            m_hubb,mpinodes,n_atom_0,
     &            n_atom_ind,natome,n_atom_0_self,n_atom_ind_self,
     &            natome_self,nlmmax,nspin,nspino,ntype,
     &            numat,rofsd_hd,rot,singulsd,solsing,statedens_hd,
     &            spinorbite,taull)

      use declarations  
      implicit none

      integer i_self, ia, iapr, icheck, ior, ioq, ipr,
     &        isp, it, it0, lhubb, l_hubbard, lm, lm1, lm2, lmq,
     &        lmr, m, m_hubb, m1, m1f, m2, m2f, mpinodes, mq,
     &        mr, n_atom_0, n_atom_0_self, n_atom_ind, n_atom_ind_self, 
     &        natome, natome_self, nlmmax, nspin,
     &        nspino, ntype, Z

      complex(kind=db), dimension(nlmmax,nspin,nlmmax,nspin,natome)::
     &                                                         taull
      complex(kind=db), dimension(-m_hubb:m_hubb,nspino,-m_hubb:m_hubb,
     &        nspino,nspin,n_atom_0_self:n_atom_ind_self,0:mpinodes-1) 
     &                                                    :: rofsd_hd
      integer, dimension(it0:ntype):: numat
      integer, dimension(natome):: iaprotoi, itypei

      logical:: Full_atom, solsing, spinorbite
      logical, dimension(it0:ntype):: hubb
      logical, dimension(n_atom_0_self:n_atom_ind_self):: iapr_done
 
      real(kind=db), dimension(-m_hubb:m_hubb,-m_hubb:m_hubb,nspin, 
     &       n_atom_0_self:n_atom_ind_self,0:mpinodes-1):: statedens_hd
      real(kind=db), dimension(nlmmax,nspin,n_atom_0:n_atom_ind):: 
     &                                                    singulsd
     
! Declarations pour les rotations hubbard:     
      complex(kind=db), dimension(-m_hubb:m_hubb,-m_hubb:m_hubb, 
     &                    nspin,n_atom_0_self:n_atom_ind_self):: rot
      real(kind=db), dimension(:,:), allocatable:: b
      complex(kind=db), dimension(:,:), allocatable:: a

      iapr_done(:) = .false.

      boucle_ia: do ia = 1,natome  
       
        ipr = iaprotoi(ia)
        it = itypei(ia)

        Z = numat( it )

        if( Full_atom ) then
          iapr = ia
        else
          iapr = ipr
        endif

        if( .not. hubb(it) .or. ia > natome_self .or. iapr_done(iapr) )
     &                                                       cycle                                            

        lhubb = l_hubbard( Z ) 
 
 ! il n'existe pas d'etat croise en spin pour la matrice d'occupation,
 !             les 2 etant ortogonaux

        statedens_hd(:,:,:,iapr,mpinodes) = 0._db

        if( spinorbite ) then

         do isp = 1, nspin
           do m1 = -lhubb-1, lhubb
             m1f = m1 + isp - 1
             if( m1f > lhubb .or. m1f < -lhubb ) cycle
             do m2 = -lhubb-1, lhubb
               m2f = m2 + isp - 1
               if( m2f > lhubb .or. m2f < -lhubb ) cycle
               do ior = 1,2
                 mr = m1 + ior - 1
                 if( mr > lhubb .or. mr < -lhubb ) cycle
                 lmr = lhubb**2 + lhubb + 1 + mr
                 do ioq = 1,2
                   mq = m2 + ioq - 1
                   if( mq > lhubb .or. mq < -lhubb ) cycle
                   lmq = lhubb**2 + lhubb + 1 + mq
                   statedens_hd(m1f,m2f,isp,iapr,mpinodes) = 
     &                statedens_hd(m1f,m2f,isp,iapr,mpinodes) - aimag(
     &                rofsd_hd(m1f,ior,m2f,ioq,isp,iapr,mpinodes) *
     &                taull(lmr,ior,lmq,ioq,ia) ) 
                 end do
               end do
             end do
           end do 
         end do

        else

          do isp = 1, nspin
            do m1 = -lhubb, lhubb
              lm1 = lhubb**2 + lhubb + 1 + m1
              do m2 = -lhubb, lhubb
                lm2 = lhubb**2 + lhubb + 1 + m2
                statedens_hd(m1,m2,isp,iapr,mpinodes) = - aimag(
     &                rofsd_hd(m1,1,m2,1,isp,iapr,mpinodes) *
     &                taull(lm1,isp,lm2,isp,ia) ) 
              end do
            end do
          end do

        end if

! On enleve la solution singuliere
        if( solsing ) then
          do m = -lhubb, lhubb
            lm = lhubb**2 + lhubb + m + 1
            statedens_hd(m,m,:,iapr,mpinodes)
     &            = statedens_hd(m,m,:,iapr,mpinodes)
     &            + singulsd(lm,:,iapr)
          end do
        end if

! jusqu'ici je suis dans une mauvaise base, si i_self > 1
        if( icheck > 0 ) then
           do isp = 1, nspin
             write(3,120) iapr, isp
             do m = -lhubb, lhubb
               write(3,130) statedens_hd(m,-lhubb:lhubb,isp,iapr,
     &                      mpinodes)
             end do     
           end do
        end if
! Partie rotation Hubbard, pour repasser a la bonne:

        if_rot: if( i_self > 1 ) then
          allocate( a(-lhubb:lhubb,-lhubb:lhubb) )
          allocate( b(-lhubb:lhubb,-lhubb:lhubb) )
          do isp = 1,nspin
            a(:,:) = (0._db,0._db); b(:,:) = 0._db
            a(:,:) = rot(:,:,isp,iapr)
            b(:,:) = statedens_hd(:,:,isp,iapr,mpinodes)
            b = matmul( transpose(a),matmul(b,a) )
            statedens_hd(:,:,isp,iapr,mpinodes) = b(:,:)
            if( icheck > 0 ) then
              write(3,140) iapr, isp
              do m = -lhubb, lhubb
                write(3,130) 
     &             statedens_hd(m,-lhubb:lhubb,isp,iapr,mpinodes)
              end do     
            end if
          end do
          deallocate( a ); deallocate( b )
        end if if_rot

        iapr_done(iapr) = .true.

      end do boucle_ia
         
      return
  120 format('Statedens_hd in the rotated base for ia = ',i2,
     & '  isp = ', i1)
  130 format(1p,14e13.5)
  140 format('Statedens_hd in the initial base for ia = ',i2,
     & '  isp = ', i1)
      end

!***********************************************************************

! Ecriture de la densite d'etat et calcul du niveau de Fermi

      subroutine write_state(chg_cluster,chg_val_p,
     &              chg_val_ref,cal_xanes,chargat_self,
     &              d_ecrant,drho_self,E_cut,
     &              E_level_val_abs,E_level_val_exc,energ,energphot,
     &              En_fermi,enragr,Energ_self,ephseuil,
     &              fermi,Full_atom,hubb,iaabsi,iaprotoi,
     &              ie,ie_computer,Int_dens_all,Int_statedens,ipr0,
     &              i_self,it0,itypei,itypepr,lamstdens,
     &              Level_val_abs,Level_val_exc,lla_state,lla2_state,
     &              lmaxat,m_hubb,mpinodes,n_atom_0,n_atom_0_self,
     &              n_atom_ind,n_atom_ind_self,
     &              n_atom_proto,natome,nb_eq,nenerg,
     &              ngreq,nomfich_s,non_exc_g,nrato,nrm,nrm_self,nspin,
     &              ntype,numat,pop_orb_val,rato,rho_self,rmtsd,
     &              state_all,state_dens,statedens,statedens_hd)

      use declarations  
      implicit real(kind=db) (a-h,o-z)
 
      character(len=13):: mot13
      character(len=13), dimension(nspin):: nomtIn
      character(len=13), dimension(0:lla_state,nspin):: nomln, nomlIn
      character(len=13),
     &  dimension(0:lla_state,-lla_state:lla_state,nspin):: nomn, nomIn
      character(len=132) nomfich_s, nomficht

      integer Z
      integer, dimension(it0:ntype):: nrato, numat
      integer, dimension(ipr0:n_atom_proto):: itypepr, la_ipr, ll_ipr,
     &                                        lmaxat, ngreq
      integer, dimension(natome):: iaprotoi, itypei, nb_eq

      logical:: cal_xanes, debug, energphot, fermi, Full_atom, 
     &          Level_val_abs, Level_val_exc, non_exc_g, state_all,
     &          state_dens
      logical, dimension(ipr0:n_atom_proto):: proto_done
      logical, dimension(it0:ntype):: hubb
 
      real(kind=db):: int_all
      real(kind=db), dimension(nenerg):: energ
      real(kind=db), dimension(ipr0:n_atom_proto):: rmtsd 
      real(kind=db), dimension(0:nrm_self,nspin,
     &           n_atom_0_self:n_atom_ind_self,0:mpinodes-1):: drho_self
      real(kind=db), dimension(-m_hubb:m_hubb,-m_hubb:m_hubb,nspin, 
     &                    n_atom_0_self:n_atom_ind_self):: Int_dens_all
      real(kind=db), dimension(lla2_state,nspin,n_atom_0:n_atom_ind)::
     &                                                     Int_statedens 
      real(kind=db), dimension(lla2_state,nspin,n_atom_0:n_atom_ind,
     &                                0:mpinodes-1):: statedens
      real(kind=db), dimension(-m_hubb:m_hubb,-m_hubb:m_hubb,nspin, 
     &                     n_atom_0_self:n_atom_ind_self):: statedens_hd
      real(kind=db), dimension(0:lla_state,nspin,n_atom_0:n_atom_ind)::
     &                                                   Int_statedens_l
      real(kind=db), dimension(0:lla_state,nspin):: statedens_l
      real(kind=db), dimension(nspin,n_atom_0:n_atom_ind)::
     &                                                 Int_statedens_t  
      real(kind=db), dimension(n_atom_0_self:n_atom_ind_self):: ch_ia,  
     &           ch_ia_s, chargat_self, chargat_self_s, Energ_self,
     &           Energ_self_s, pop_orb_val_s, pop_orb_val 
      real(kind=db), dimension(0:nrm):: r, rh
      real(kind=db), dimension(0:nrm,it0:ntype):: rato
      real(kind=db), dimension(0:nrm_self,nspin,
     &            n_atom_0_self:n_atom_ind_self):: rho_self, rho_self_s
     
      common/icheck/ icheck(24)
      common/eseuil/ eseuil(2)

! Ecriture de la densit d'etat pour tous les atomes pendant le calcul self consistent

      debug = .false.

      if( ( icheck(21) > 0 .and. ie == 1 .and. .not. Cal_xanes ) 
     &                    .or. icheck(21) > 2 )  write(3,110)

! stockage des tableaux de l'iteration precedante, utilises pour l'interpolation:
      if( .not. cal_xanes ) then
        ch_ia(:) = 0._db
        rho_self_s(:,:,:) = rho_self(:,:,:)
        enragr_s = enragr
        Energ_self_s(:) = Energ_self(:)
        pop_orb_val_s(:) = pop_orb_val(:)
      endif

      proto_done(:) = .false.
      
      if( nenerg == 1 ) then
        de = 1._db
      elseif( ie == 1 ) then
        de = energ(2) - energ(1)
      elseif( ie == nenerg ) then
        de = energ(ie) - energ(ie-1)
      else 
        de = 0.5 * ( energ(ie+1) -  energ(ie-1) )
      endif

      if( nspin == 1 ) then
        ds = 2 * de
      else
        ds = de
      endif
        
      do ipr = ipr0,n_atom_proto
        if( lamstdens > -1 ) then 
          la = min(lamstdens,lmaxat(ipr))
        else
          Z = numat( itypepr(ipr) )
          if( Z < 19 ) then
            la = min(1,lmaxat(ipr))
            ll = min(2,lmaxat(ipr))
          elseif( Z > 18 .and. Z < 55 ) then
            la = min(2,lmaxat(ipr))
            ll = min(3,lmaxat(ipr))
          else
            la = min(3,lmaxat(ipr))
            ll = min(4,lmaxat(ipr))
          endif 
        end if      
        la_ipr(ipr) = la    ! nombre maximal d'harmoniques pour l'ecriture de la densite d'etat
        ll_ipr(ipr) = ll    ! nombre maximal d'harmoniques pour le calcul  de la densite d'etat
      end do 

      int_all = 0._db 

      boucle_ia: do ia = 1,natome  
       
        ipr = iaprotoi(ia)
        la = la_ipr(ipr)
        ll = ll_ipr(ipr)

        if( ia == iaabsi ) iprabs = ipr

        if( Full_atom ) then
          iapr = ia
        else
          iapr = ipr
        endif
        it = itypei(ia)
        Z = numat(it)

        if( proto_done(ipr) .and. .not. Full_atom ) cycle boucle_ia
        if( cal_xanes .and. .not. 
     &      ( ( ia == iaabsi .and. state_dens ) .or. state_all ) ) cycle

! Partie Hubbard

        if_hubb: if( hubb(it).and..not. cal_xanes 
     &                               .and. iapr <= n_atom_ind_self) then                                            
          lhubb = l_hubbard( Z ) 
 
          do isp = 1, nspin
            do m1 = -lhubb, lhubb
              do m2 = -lhubb, lhubb
                Int_dens_all(m1,m2,isp,iapr)
     &                             = Int_dens_all(m1,m2,isp,iapr)
     &                             + ds * statedens_hd(m1,m2,isp,iapr)
              end do
            end do
          end do

        end if if_hubb   
                 
! Calcul de la densite d'etat integree jusqu'au rayon Rmstd de l'atome
        
        do ir = 1,nrato(it)
          if( rato(ir,it) > Rmtsd(ipr) + eps10 ) exit
        end do
        nr = ir

        if( .not. cal_xanes .and. ie == 1 ) then
          chargat_self(iapr) = Real( Z,db )
          do ispin = 1, nspin
            r(:) = rato(:,it)
            rh(0:nr) = rho_self(0:nr,ispin,iapr) * r(0:nr)**2
            res = quatre_pi * f_integr3(r,rh,nr,0,nrm,Rmtsd(ipr))
            chargat_self(iapr) = chargat_self(iapr) - res
          end do

          if( icheck(21) > 1 ) write(3,150) iapr, chargat_self(iapr)
          if( icheck(21) > 2 ) then
            write(3,160) iapr, Z
            do ir = 1,nr
              write(3,170) rato(ir,it)*bohr, quatre_pi * rato(ir,it)**2
     &                                         * rho_self(ir,:,iapr)
            end do    
          end if
        endif

        if( .not. cal_xanes .and. .not. fermi ) then
          do isp = 1,nspin
            rho_self(1:nr,isp,iapr) = rho_self(1:nr,isp,iapr)
     &                      + ds * drho_self(1:nr,isp,iapr,ie_computer )
          end do
        endif

        if( hubb(it) .and. i_self > 1 ) then

! On recalcule la densite d'etat dans la bonne base, en ecrasant la mauvaise:
! a reflechir qu'est ce que ca donne si r_cons < r_xanes

          do m = -lhubb, lhubb
            lm = lhubb**2 + lhubb + m + 1
            do isp = 1, nspin
              if( statedens_hd(m,m,isp,iapr) < 0 ) then
                write(6,*) 'neg',m,isp, iapr
                write(3,*) 'neg',m,isp,iapr
                summ = 0._db
                do i = -lhubb, lhubb
                  summ = summ + statedens_hd(i,i,isp,iapr)  
                end do
                write(3,*) 'trace statedens_hd = ', summ
                write(3,111) (statedens_hd(i,i,isp,iapr),
     &                             i =-lhubb,lhubb) 
  111 format(1p,5e13.5)
                summ = 0._db
                do lmi = lhubb**2 + 1, (lhubb + 1)**2
                  summ = summ + statedens(lmi,isp,iapr,ie_computer)  
                end do
                write(3,111) (statedens(lmm,isp,iapr,ie_computer), 
     &                               lmm = lhubb**2 + 1, (lhubb + 1)**2)
                write(3,*) 'trace statedens = ', summ 
              end if
             end do
           end do

           do m = -lhubb, lhubb
             lm = lhubb**2 + lhubb + m + 1
             statedens(lm,:,iapr,ie_computer) = statedens_hd(m,m,:,iapr)
           end do

        end if
          
        lma = (ll + 1)**2

        do l = 0,la
          lm1 = l**2 + 1
          lm2 = ( l + 1 )**2
          do isp = 1,nspin
            statedens_l(l,isp)
     &           = sum( statedens(lm1:lm2,isp,iapr,ie_computer) ) 
          end do
        end do
        if( nspin == 1 ) then
          statedens_l(0:la,1) = 2 * statedens_l(0:la,1) 
        end if

! Integrale de la densite d'etats
        Int_statedens(1:lma,:,iapr) = Int_statedens(1:lma,:,iapr)
     &                        + de * statedens(1:lma,:,iapr,ie_computer)
        do l = 0,ll
          lm1 = l**2 + 1
          lm2 = ( l + 1 )**2
          do ispin = 1,nspin                
            Int_statedens_l(l,ispin,iapr)
     &                         = sum(Int_statedens(lm1:lm2,ispin,iapr))
          end do  
          if( nspin == 1 ) then
           Int_statedens_l(l,1,iapr) = 2 * Int_statedens_l(l,1,iapr)
          end if 
        end do

        do ispin = 1,nspin
          Int_statedens_t(ispin,iapr) = 
     &                          sum( Int_statedens_l(0:la,ispin,iapr) )
        end do 
               
        if( icheck(21) > 2 ) then
          write(3,180) iapr
          lm = 0
          do l = 0,ll
            do m = -l,l
              lm = lm + 1
              do isp = 1,nspin
                write(3,190) l, m, isp,
     &                          statedens(lm,isp,iapr,ie_computer),
     &                          Int_statedens(lm,isp,iapr)
              end do
            end do
          end do
          write(3,200)
          do l = 0,la
            write(3,210) l, Int_statedens_l(l,1:nspin,iapr)
          end do
          write(3,220) Int_statedens_t(1:nspin,iapr)
        endif

        if( .not. cal_xanes ) then
          do ispin = 1, nspin
            D_energ = ds * energ(ie)
     &                 * sum( statedens(1:lma,ispin,iapr,ie_computer) )  
            Energ_self(iapr) =  Energ_self(iapr) + D_energ
            if( Full_atom ) then
              enragr = enragr + nb_eq(iapr) * D_energ
            else
              enragr = enragr + ngreq(iapr) * D_energ
            endif
          end do
          l = l_level_val(Z)
          pop_orb_val(iapr) = sum( Int_statedens_l(l,:,iapr) )        
! On somme sur tous les atomes, on est a l'interieur de la boucle sur les ia
! int_all doit etre initialise pour chaque energie
          int_all = int_all + sum( Int_statedens_t(1:nspin,iapr) )
  
! Calcul de la charge
    ! chargat_self = charge atomique a l'iteration courrante
    ! chargat_self_s = charge atomique a l'iteration precedente
    ! ch_ia = nombre total d'electrons (y compris de coeur) a l'iteration courrante, pour l'atome ia
    ! ch_ia_s = meme chose a l'iteration precedente
          chargat_self(iapr) = Real( Z,db )
          do ispin = 1, nspin
            r(:) = rato(:,it)
            rh(0:nr) = rho_self(0:nr,ispin,iapr) * r(0:nr)**2
            res = quatre_pi * f_integr3(r,rh,nr,0,nrm,Rmtsd(ipr))
            ch_ia(iapr) = ch_ia(iapr) + res
          end do
          chargat_self(iapr) = chargat_self(iapr) - ch_ia(iapr)

          if( icheck(21) > 2 ) then
            write(3,230) iapr, chargat_self(iapr),
     &                       Int_statedens_t(1:nspin,iapr)
            write(3,160) iapr, Z
            do ir = 1,nr
              write(3,170) rato(ir,it)*bohr,  quatre_pi
     &                        * ( rato(ir,it)**2 ) * rho_self(ir,:,iapr)
            end do    
          end if 
        endif

        proto_done(ipr) = .true.
        
        if( .not. debug .and. .not. (  
     &        ( ia == iaabsi .and. state_dens ) .or. state_all ) ) cycle

        if( .not. cal_xanes .and. icheck(21) < 2 ) cycle
     
        nomficht = nomfich_s
        long = len_trim(nomfich_s)
        nomficht(long+1:long+3) = '_sd'
        if( cal_xanes ) then
          if( Full_atom .and. iapr == 1 ) then
            iaa = 0
          else
            iaa = iapr
          endif
          call ad_number(iaa,nomficht,132)
        else 
          call ad_number(i_self,nomficht,132)
          if( debug ) then
            long = len_trim(nomficht)
            nomficht(long+1:long+4) = '_ia='
            call ad_number(ia,nomficht,132)
          end if
        endif
        long = len_trim(nomficht)
        nomficht(long+1:long+4) = '.txt'

        if( ie == 1 ) then

          if( nspin == 1 ) then
            nomtIn(1) = '     Int_t   '  
          else
            nomtIn(1) = '   Int_t(u)  '  
            nomtIn(nspin) = '   Int_t(d)  '  
          endif
          do l = 0,la
            mot13 = 'n_l('
            mot13(5:5) = achar(l+48)
            if( nspin == 1 ) then
              mot13(6:6) = ')'
              nomln(l,1) = '   ' // mot13(1:6)
              nomlIn(l,1) = '  Int' // mot13(1:6)
            else
              mot13(6:8) = ',u)'
              nomln(l,1) = '   ' // mot13(1:8)
              nomlIn(l,1) = '  Int' // mot13(1:8)
              mot13(6:8) = ',d)'
              nomln(l,nspin) = '   ' // mot13(1:8)
              nomlIn(l,nspin) = '  Int' // mot13(1:8)
            endif
            do m = -l,l
              mot13 = 'n('
              call ad_number(l,mot13,13)
              mot13(4:4) = ','
              call ad_number(m,mot13,13)
              i = len_trim(mot13)
              if( nspin == 1 ) then
                mot13(i+1:i+1) = ')'
                nomn(l,m,1) = '    ' // mot13(1:7)
                nomIn(l,m,1) = '   Int' // mot13(1:7)
              else
                mot13(i+1:i+3) = ',u)'
                nomn(l,m,1) = '   ' // mot13(1:9)
                nomIn(l,m,1) = ' Int' // mot13(1:9)
                mot13(i+2:i+2) = 'd'
                nomn(l,m,nspin) = '   ' // mot13(1:9)
                nomIn(l,m,nspin) = ' Int' // mot13(1:9)
              endif
            end do
          end do

          open(4, file = nomficht )

          write(4,240) (nomtIn(isp), isp = 1,nspin), 
     &      ( ( ( nomn(l,m,isp), nomIn(l,m,isp), isp = 1,nspin),
     &                         m = -l,l ),
     &      ( nomln(l,isp), nomlIn(l,isp), isp = 1,nspin ), l = 0,la )

        else

          open(4, file = nomficht, position='append')

        endif
                
        ephseuil = energ(ie)
        ephoton = ephseuil + eseuil(1)
        if( energphot ) ephseuil = ephoton
        
        write(4,250) ephseuil*rydb,(Int_statedens_t(isp,iapr),
     &    isp = 1,nspin ),(((statedens(l**2+l+1+m,isp,iapr,ie_computer),
     &    Int_statedens(l**2+l+1+m,isp,iapr), isp = 1,nspin),
     &    m = -l,l ),(statedens_l(l,isp),  
     &    Int_statedens_l(l,isp,iapr),isp = 1,nspin ), 
     &    l = 0,la )
        close(4)            
    
      end do boucle_ia
        
 ! Interpolation: 
 ! E_f = E_i*(ch_ref - ch_i-1)/(ch_i-ch_i-1) + E_i-1*(ch_i - ch_ref)/(ch_i-ch_i-1)
      ! ch_s, enragr = nombre total d'electrons et l'energie de l'agregat a l'iteration precedente
      ! ch, enr = nombre total d'electrons et energie courrantes
      ! chg_cluster = la charge qu'on va comparer avec la reference
 
 ! Evaluation du niveau de Fermi: 
      ! il faut se placer en dehors de la boucle sur les atomes,
      ! pour etre sur qu'on a somme sur tout l'agregat     
    
      if( .not. cal_xanes ) then

        Z = numat( itypei(iaabsi) )
        l = l_level_val(Z)

        ch_t = 0._db 
        chg_ref = chg_cluster
        Numat_tot = 0                 
        do iapr = n_atom_0_self,n_atom_ind_self
          if( Full_atom ) then
            n = nb_eq(iapr)
            Z = numat( itypei(iapr) )
            ch_abs = sum( Int_statedens_l(l,1:nspin,iaabsi) )
          else
            n = ngreq(iapr)
            Z = numat( itypepr(iapr) )
            ch_abs = sum( Int_statedens_l(l,1:nspin,iprabs) )
          endif 
          ch_t = ch_t + n * ch_ia(iapr)
          Numat_tot = Numat_tot + n * Z
        end do

        if( icheck(21) > 0 .and. ie == 1 ) write(3,260)
     &                                           Numat_tot, chg_ref
        if( icheck(21) > 1 ) write(3,270) energ(ie)*rydb, ch  
 
        do i = 0,2

          select case(i)
            case(0)
              if( Level_val_abs ) cycle
              ch = ch_abs
              chg_lim = chg_val_ref
            case(1)
              if( Level_val_exc .or. non_exc_g ) cycle
              ch = ch_abs
              chg_lim = chg_val_ref + 1 - d_ecrant
            case(2)
              ch = ch_t
              chg_lim = chg_ref
          end select
 
! Evaluation du niveau de Fermi
          if( ch > chg_lim ) then

            if( i == 0 ) then
              Level_val_abs = .true.
              if( non_exc_g ) Level_val_exc = .true.  
            elseif( i == 1 ) then
              Level_val_exc = .true.
            elseif( i == 2 ) then  
              fermi = .true.
            endif

! Interpolation, une fois qu'on a atteint le niveau de Fermi:
            if( i == 2 ) then
              ch_s = 0._db                         
              do iapr = n_atom_0_self,n_atom_ind_self
                if( Full_atom) then
                  ipr = iaprotoi(iapr)
                  if( i == 0 .and. iapr /= iaabsi ) cycle
                  n = nb_eq(iapr) 
                else
                  ipr = iapr
                  if( i == 0 .and. ipr /= iprabs ) cycle
                  n = ngreq(ipr) 
                endif
                it = itypepr(ipr)
                nr = nrato(it)
                ch_ia_s(iapr) = 0._db
                do ispin = 1,nspin
                  rh(0:nr) = rho_self_s(0:nr,ispin,iapr) * r(0:nr)**2
                  res = quatre_pi * f_integr3(r,rh,nr,0,nrm,Rmtsd(ipr))
                  ch_ia_s(iapr) = ch_ia_s(iapr) + res
                end do
                chargat_self_s(iapr) = Real( numat(it),db )
     &                               - ch_ia_s(iapr)
                ch_s = ch_s + n * ch_ia_s(iapr)
              end do
            else
              ch_s = chg_val_p
            endif
            poids = ( chg_lim - ch_s ) / ( ch - ch_s )

            if( ie == 1 ) then 
              en_f = energ(ie)
            else                
              en_f = energ(ie) * poids + energ(ie-1) * ( 1 - poids )
            end if
    
            if( i == 0 ) then
              E_level_val_abs = en_f
              if( non_exc_g ) E_level_val_exc = en_f  
              chg_val_p = ch
              cycle
            elseif( i == 1 ) then
              E_level_val_exc = en_f
              chg_val_p = ch
              cycle
            endif

            En_fermi = en_f
            if( Level_val_exc ) then
              E_cut = E_level_val_exc
            else
              E_cut = En_fermi
            endif

            chargat_self(:) = chargat_self(:) * poids 
     &                      + chargat_self_s(:) * ( 1 - poids )
            rho_self(:,:,:) = rho_self(:,:,:) * poids 
     &                      + rho_self_s(:,:,:) * ( 1 - poids )
            enragr = enragr * poids + enragr_s * ( 1 - poids )
            Energ_self(:) = Energ_self(:) * poids
     &                    + Energ_self_s(:) * ( 1 - poids )
            pop_orb_val(:) = pop_orb_val(:) * poids 
     &                     + pop_orb_val_s(:) * ( 1 - poids )

            do iprint = 3,6,3
              if( icheck(21) == 0 .and. iprint == 3 ) cycle
              write(iprint,290) i_self, En_fermi*rydb, enragr*rydb
              if( Level_val_exc ) then
                write(iprint,292) E_level_val_exc*rydb
                write(iprint,293) E_level_val_abs*rydb
              else
                if( Level_val_abs ) then
                  write(iprint,293) E_level_val_abs*rydb
                else
                  write(iprint,294) chg_val_p
                endif
              endif
              if( iprint == 3 ) write(iprint,295)
              write(iprint,300)
              do iapr = n_atom_0_self,n_atom_ind_self
                if( Full_atom ) then
                  ipr = iaprotoi(iapr)
                else
                  ipr = iapr
                endif
                Z = numat( itypepr(ipr) )
                l = l_level_val(Z)
                write(iprint,310) iapr, Z, Energ_self(iapr)*rydb, 
     &                 chargat_self(iapr), pop_orb_val(iapr), l,
     &                 Rmtsd(ipr)*bohr
              end do
            end do
            if( icheck(21) > 1 ) then
              do iapr = n_atom_0_self,n_atom_ind_self
                if( Full_atom ) then
                  ipr = iaprotoi(iapr)
                else
                  ipr = iapr
                endif
                it = itypepr(ipr)
                Z = numat( it )
                write(3,160) iapr, Z
                do ir = 1,nr
                  write(3,170) rato(ir,it)*bohr, quatre_pi
     &                        * (rato(ir,it)**2) * rho_self(ir,:,iapr)
                end do    
              end do
            endif

          elseif( i == 0 .or. i == 1 ) then

            chg_val_p = ch

          endif

        end do 
      endif 
 
      return
  110 format(/' ---- Write_state --------',100('-'))
  150 format(/'  Before integration:  ia = ',i3,'  charge_self = ',
     &       f10.5)
  160 format(/' ia =',i3,', Z =',i3/
     &        '   Radius_(A) 4*pi*r2*Rho_self')
  170 format(1p,3e13.5)
  180 format(/'  l  m is  Density of states   Integral    ia =',i3)
  190 format(3i3,3f15.7)
  200 format(/'    l   sum_m(Integral)')
  210 format(i5,2f15.7)
  220 format(' Total =',f12.7,f15.7)
  230 format(/'  Charge_self(ia =',i3,') =',f10.5,', Int_state_t =',
     &           2f10.5)
  240 format(4x,'Energy',200a13)
  250 format(f10.4,1p,200e13.5)
  260 format(/' Sum of atomic numbers =',i5,', Reference charge =',
     &          f10.3)
  270 format(15x,' Energy =',f10.3,' eV,   Charge =',f10.3)
  290 format(/' Cycle',i3,',   Fermi energy =',f8.3,' eV',
     &                    ',  Cluster Energy_KS =',f11.3,' eV')
  292 format(9x,'Level val excite =',f8.3,' eV')
  293 format(9x,'Level val absorb =',f8.3,' eV')
  294 format(9x,'Popul val absorb =',f8.3)
  295 format(/'  At the Fermi level :')
  300 format(/11x,'  ia   Z   Energy_KS      Charge  pop_orb_val(l)',
     &            '   l    Radius')
  310 format(11x,2i4,3f12.3,i8,f10.5)
      end
