/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                      elements.c                               $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: elements.c,v 1.5 2007/03/16 13:50:44 wilcke Exp $

****************************************************************************/
/*
Update 06/03/2007 R. Wilcke (wilcke@esrf.fr)
                  get_coeff(): made "co" an array with variable first dimension;
                  get_element_number(): made "elements" an array with variable
                  first dimension, then calculate the number of elements
                  "numelem" and use this as the upper bound in the routine;
Update 21/12/2000 E. Vlieg (vlieg@sci.kun.nl)
                  Added scattering factors for Nd.
*/
/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#include <ctype.h>
#include "rod.h"



/***************************************************************************/
int     el_equal(char el1[3], char el2[3])
/***************************************************************************/

    /*
    Compare two element symbols and return
	1       if equal
	0       otherwise
    */

    {

    char        temp1[3],temp2[3];
    int i;

    /* Convert to lowercase */

    for (i = 0; i < 3; i++)
	{
	temp1[i] = tolower(el1[i]);
	temp2[i] = tolower(el2[i]);
	}

    /* Compare the two */

    return(!strncmp(temp1,temp2,2));

    }

/***************************************************************************/
float *get_coeff(char el[3], float coeff[9])
/***************************************************************************/

    /*
    Assigns the coefficients for an analytical approximation of the
    atomic scattering factor of a specificied element.
    The coefficients are taken from "International Tables for X-ray
    Crystallography, Vol IV", p. 99-101.

    Returns a pointer to the coefficients, if found, and fills coeff[]

    */

    {

    static float        co[][9] =
	{
	{0.493002,10.5109,0.322912,26.1257,0.140191,3.14236,
	 0.040810,57.7997,0.003038},                             /* H */
	{0,0,0,0,0,0,0,0,0},                                     /* He */
	{0,0,0,0,0,0,0,0,0},                                     /* Li */
	{1.5919,43.6427,1.1278,1.8623,0.5391,103.483,
	 0.7029,0.542,0.0385},                                   /* Be */
	{2.0545,23.2185,1.3326,1.021,1.0979,60.3498,
	 0.7068,0.1403,-0.1932},                                 /* B */
	{2.31,20.8439,1.02,10.2075,1.5886,0.5687,
	 0.865,51.6512,0.2156},                                  /* C */
	{12.2126,0.0057,3.1322,9.8933,2.0125,28.9975,
	 1.1663,0.5826,-11.529},                                 /* N */
	{3.0485,13.2771,2.2868,5.7011,1.5463,0.3239,
	 0.867,32.9089,0.2508},                                  /* O */
	{3.5392,10.2825,2.6412,4.2944,1.517,0.2615,
	 1.0243,26.1476,0.2776},                                 /* F */
	{0,0,0,0,0,0,0,0,0},                                     /* Ne */
	{4.7626,3.285,3.1736,8.8422,1.2674,0.3136,
	 1.1128,129.424,0.676},                                  /* Na */
	{5.4204,2.8275,2.1735,79.2611,1.2269,0.3808,
	 2.3073,7.1937,0.8584},                                  /* Mg */
	{6.4202,3.0387,1.9002,0.7426,1.5936,31.5472,
	 1.9646,85.0886,1.1151},                                 /* Al */
	{6.2915,2.4386,3.0353,32.3337,1.9891,0.6785,
	 1.541,81.6937,1.1407},                                  /* Si */
	{6.4345,1.9067,4.1791,27.157,1.78,0.526,1.4908,
	 68.1645,1.1149},                                        /* P */
	{6.9053,1.4679,5.2034,22.2151,1.4379,0.2536,
	 1.5863,56.172,0.8669},                                  /* S */
	{11.4604,0.0104,7.1964,1.1662,6.2556,18.5194,
	 1.6455,47.7784,-9.5574},                                /* Cl */
	{0,0,0,0,0,0,0,0,0},                                     /* Ar */
	{8.2186,12.7949,7.4398,0.7748,1.0519,213.187,
	 0.8659,41.6841,1.4228},                                 /* K */
	{8.6266,10.4421,7.3873,0.6599,1.5899,85.7484,
	 1.0211,178.437,1.3751},                                 /* Ca */
	{0,0,0,0,0,0,0,0,0},                                     /* Sc */
	{9.7595,7.8508,7.3558,0.5,1.6991,35.6338,
	 1.9021,116.105,1.2807},                                 /* Ti */
	{0,0,0,0,0,0,0,0,0},                                     /* V */
	{10.6406,6.1038,7.3537,0.392,3.324,20.2626,
	 1.4922,98.7399,1.1832},                                 /* Cr */
	{0,0,0,0,0,0,0,0,0},                                     /* Mn */
	{11.7695, 4.7611, 7.3573, 0.3072, 3.5222, 15.3535,       /* Fe */
	 2.3045, 76.8805, 1.0369},
	{12.2841,4.2791,7.3409,0.2784,4.0034,13.5359,
	 2.3488,71.1692,1.0118},                                 /* Co*/
	{12.8376,3.8785,7.292,0.2565,4.4438,12.1763,
	 2.38,66.3421,1.0341},                                   /* Ni */
	{13.338,3.5828,7.1676,0.247,5.6158,11.3966,
	 1.6735,64.8126,1.191},                                  /* Cu */
	{14.0743,3.2655,7.0318,0.2333,5.1652,10.3163,
	 2.41,58.7097,1.3041},                                   /* Zn */
	{15.2354,3.0669,6.7006,0.2412,4.3591,10.7805,
	 2.9623,61.4135,1.7189},                                 /* Ga */
	{16.0816,2.8509,6.3747,0.2516,3.7068,11.4468,
	 3.683,54.7625,2.1313},                                  /* Ge */
	{16.6723,2.6345,6.0701,0.2647,3.4313,12.9479,
	 4.2779,47.7972,2.531},                                  /* As */
	{0,0,0,0,0,0,0,0,0},                                     /* Se */
	{17.1789,2.1723,5.2358,16.5796,5.6377,0.2609,
	 3.9851,41.4328,2.9557},                                 /* Br */
	{0,0,0,0,0,0,0,0,0},                                     /* Kr */
	{0,0,0,0,0,0,0,0,0},                                     /* Rb */
	{17.5663,1.5564,9.8184,14.0988,5.422,0.1664,
	 2.6694,132.376,2.5064},                                 /* Sr */
	{0,0,0,0,0,0,0,0,0},                                     /* Y */
	{0,0,0,0,0,0,0,0,0},                                     /* Zr */
	{17.6142,1.18865,12.0144,11.766,4.04183,0.204785,
	 3.53346,69.7957,3.75591},                               /* Nb */
	{3.7025, 0.2772, 17.2356, 1.0958, 12.8876, 11.0040,
	 3.7429, 61.6584, 4.3875 },                              /* Mo */
	{0,0,0,0,0,0,0,0,0},                                     /* Tc */
	{0,0,0,0,0,0,0,0,0},                                     /* Ru */
	{0,0,0,0,0,0,0,0,0},                                     /* Rh */
	{19.3319,0.698655,15.5017,7.98929,5.29537,25.2052,
	 0.605844,76.8986,5.26593},                              /* Pd */
	{19.2808,0.6446,16.6885,7.4726,4.8045,24.6605,
	 1.0463,99.8156,5.179},                                  /* Ag */
	{0,0,0,0,0,0,0,0,0},                                     /* Cd */
	{19.1624,0.5476,18.5596,6.3776,4.2948,25.8499,
	 2.0396,92.8029,4.9391},			         /* In */
	{19.1889,5.8303,19.1005,0.5031,4.4585,26.8909,
	 2.4663,83.9571,4.7821},                                 /* Sn */
	{19.6418,5.3034,19.0455,0.4607,5.0371,27.9074,
	 2.6827,75.2825,4.5909},                                 /* Sb */
	{0,0,0,0,0,0,0,0,0},                                     /* Te */
	{20.1472,4.347,18.9949,0.3814,7.5138,27.766,
	 2.2735,66.8776,4.0712},                                 /* I */
	{0,0,0,0,0,0,0,0,0},                                     /* Xe */
	{20.3892,3.569,19.1062,0.3107,10.662,24.3879,
	 1.4953,213.904,3.3352},                                 /* Cs */
	{20.3361,3.216,19.297,0.2756,10.888,20.2073,
	 2.6959,167.202,2.7731},                                 /* Ba */
	{0,0,0,0,0,0,0,0,0},                                     /* La */
	{0,0,0,0,0,0,0,0,0},                                     /* Ce */
	{0,0,0,0,0,0,0,0,0},                                     /* Pr */
	{22.6845,2.66248,19.6847,0.210628,12.774,15.8850,
	 2.85137,137.903,1.98486},                               /* Nd */
	{0,0,0,0,0,0,0,0,0},                                     /* Pm */
	{0,0,0,0,0,0,0,0,0},                                     /* Sm */
	{0,0,0,0,0,0,0,0,0},                                     /* Eu */
	{25.0709, 2.2534, 19.0798, 0.1820, 13.8518, 12.9331,
	 3.5455, 101.398, 2.4196},                               /* Gd */
	{0,0,0,0,0,0,0,0,0},                                     /* Tb */
	{0,0,0,0,0,0,0,0,0},                                     /* Dy */
	{0,0,0,0,0,0,0,0,0},                                     /* Ho */
	{27.6563,2.07356,16.4285,0.223545,14.9779,               /* Er */
	 11.3604,2.98233,105.703,5.92046},
//      {26.7222, 1.84659, 19.7748, 0.137290, 12.1506,           /* Er3+ */
//       8.36225, 5.17379, 17.8974, 1.71613},
	{0,0,0,0,0,0,0,0,0},                                     /* Tm */
	{0,0,0,0,0,0,0,0,0},                                     /* Yb */
	{0,0,0,0,0,0,0,0,0},                                     /* Lu */
	{0,0,0,0,0,0,0,0,0},                                     /* Hf */
	{29.2024,1.77333,15.2293,9.37046,14.5135,0.295977,
	 4.76492,63.3644,9.24354},                               /* Ta */
	{29.0818,1.72029,15.43,9.2259,14.4327,0.321703,
	 5.11982,57.056,9.8875},                                 /* W */
	{0,0,0,0,0,0,0,0,0},                                     /* Re */
	{0,0,0,0,0,0,0,0,0},                                     /* Os */
	{0,0,0,0,0,0,0,0,0},                                     /* Ir */
	{27.0059,1.51293,17.7639,8.81174,15.7131,0.424593,
	 5.7837,38.6103,11.6883},                                /* Pt */
	{16.8819,0.4611,18.5913,8.6216,25.5582,1.4826,
	 5.86,36.3956,12.0658},                                  /* Au */
	{0,0,0,0,0,0,0,0,0},                                     /* Hg */
	{0,0,0,0,0,0,0,0,0},                                     /* Tl */
	{31.0617,0.6902,13.0637,2.3576,18.442,8.618,
	 5.9696,47.2579,13.4118},                                /* Pb */
	{33.3689,0.704,12.951,2.9238,16.5877,8.7937,
	 6.4692,48.0093,13.5782},                                /* Bi */
	{0,0,0,0,0,0,0,0,0},                                     /* Po */
	{0,0,0,0,0,0,0,0,0},                                     /* At */
	{0,0,0,0,0,0,0,0,0},                                     /* Rn */
	{0,0,0,0,0,0,0,0,0},                                     /* Fr */
	{0,0,0,0,0,0,0,0,0},                                     /* Ra */
	{0,0,0,0,0,0,0,0,0},                                     /* Ac */
	{0,0,0,0,0,0,0,0,0},                                     /* Th */
	{0,0,0,0,0,0,0,0,0},                                     /* Pa */
	{0,0,0,0,0,0,0,0,0},                                     /* U */
	{0,0,0,0,0,0,0,0,0},                                     /* Np */
	{0,0,0,0,0,0,0,0,0},                                     /* Pu */
	{0,0,0,0,0,0,0,0,0},                                     /* Am */
	{0,0,0,0,0,0,0,0,0},                                     /* Cm */
	{0,0,0,0,0,0,0,0,0},                                     /* Bk */
	{0,0,0,0,0,0,0,0,0},                                     /* Cf */
	};

    int i,j;

    /* Find element number */

    i = get_element_number(el);

    if (i == -1)
	{
	sprintf(STRING,"ERROR element '%s' not recognized",el);
	errtype(STRING);
	for (j = 0; j < 9; j++) coeff[j] = 0.;
	return NULL;
	}
    else
	{
        i--;
	for (j = 0; j < 9; j++) coeff[j] = co[i][j];
	}

    if (coeff[0] == 0.)
	{
	sprintf(STRING,"ERROR, coefficients of element '%s' not in list",el);
	errtype(STRING);
	}

    return co[i];

    }

/***************************************************************************/
int   get_element_number(char el[3])
/***************************************************************************/

    /*
    Finds element number for given element label "el".
    Returns -1 if "el" is unknown.
    Element 1 is H, element 2 He, and so forth
    */

    {
    static char elements[][3] =
	{
	"H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg",
	"Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr",
	"Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br",
	"Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd",
	"Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La",
	"Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er",
	"Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au",
	"Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th",
	"Pa","U","Np","Pu","Am","Cm","Bk","Cf"
	};

    /* number of elements in "elements" table */
    int numelem = sizeof(elements) / sizeof(elements[0]);

    int i;

    /* Find element number */

    for (i = 0; i < numelem; i++)
	{
	if (el_equal(el,elements[i])) break;
	}

    if (i==numelem)
        {
        return -1;
        }
    else
        {
	sprintf(el,"%s",elements[i]);
        return i+1;
        }

    }

