/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$$$$$$                      menu.h                         $$$$$$$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: menu.h,v 1.16 2006/03/28 15:39:32 wilcke Exp $

****************************************************************************/

/*
Update 22/03/2006 R. Wilcke (wilcke@esrf.fr)
                  removed check for __CYGWIN__ since __unix is now defined
                  in Cygwin 1.X.
Update 25/09/2001 O. Svensson (svensson@esrf.fr)
                  Moved definition of GLOBAL_PROMPT to menu.y, added
                  #ifndef _MENU_H_ etc.
Update 10/01/2001 R. Wilcke (wilcke@esrf.fr)
                  re-ordered the "update" comments in descending chronological
                  order;
                  define macro "JMPBUF_TYPE" to declare the variable type for
                  the "setjmp / longjmp" buffer variable in function of the
                  operating system.
Update 12/07/2000 R. Wilcke (wilcke@esrf.fr)
                  redefine FILENAME_MAX if it is too small.
Update 21/06/2000 R. Wilcke (wilcke@esrf.fr)
                  replace UNIX by __unix (is defined by CPP on UNIX systems).
Update 15/06/2000 R. Wilcke (wilcke@esrf.fr)
                  move definition of SCROLL here from the ana.h file and
                  define SCROLL for UNIX and __CYGWIN__ only if READLINE is not
                  defined.
Update 06/04/2000 R. Wilcke (wilcke@esrf.fr)
                  moved include of "readline/readline.h" from this file into
                  "menu.y";
                  clean up the "#ifdef UNDERSCORES" section to make it agree
                  with the function declarations further down.
Update 31/03/2000 R. Wilcke (wilcke@esrf.fr)
                  for non-VMS systems, include <setjmp.h>;
                  clean up function declarations;
                  add declarations for init_menu() and end_menu().
Update 20/03/2000 R. Wilcke (wilcke@esrf.fr)
                  define TRUE and FALSE only if they are not yet defined.
Update 17/03/2000 R. Wilcke (wilcke@esrf.fr)
                  replaced test for "defined(CYGWIN)" by "defined(__CYGWIN__)";
                  clean up definitions for ROWS and COLUMNS and treat __CYGWIN__
                  like UNIX for defining ROWS and COLUMNS.
*/

#ifndef _MENU_H_
#define _MENU_H_

/***************************************************************************/
/*  Include extra header files                                             */
/***************************************************************************/

#if !defined(VMS)
#include <setjmp.h>
#endif

/***************************************************************************/
/*  Define global variables                                                */
/***************************************************************************/

/*  General globals */

/* #define UNDERSCORES */

/*
 * Under POSIX, the setjmp() / longjmp() routines are not guaranteed to
 * restore the signal mask, which means that further occurences of signals
 * may be blocked after the first longjmp() call.
 *
 * To restore the signal mask, the sigsetjmp() / siglongjmp() routines
 * should be used under POSIX.
 *
 * For other systems (e.g. MSDOS), the availability of sigsetjmp() /
 * siglongjmp() is not known to us. Keep the old calls for the time being.
 *
 * The buffer used by sigsetjmp() / siglongjmp() has a different variable type
 * than the one for setjmp() / longjmp(). Define the macro JMPBUF_TYPE to have
 * the correct variable type in functin of the operating system.
 */
#if defined(__unix)
#define JMPBUF_TYPE sigjmp_buf
#else
#define JMPBUF_TYPE jmp_buf
#endif /* defined(__unix) */

/*
 * The macro "FILENAME_MAX" is supposed to contain the maximum lenght for a
 * filename (ISO-C definition). However, on some systems this value is very
 * small (e.g. on HP-UX it is 14). Thus it gets redefined here if it is too
 * small (i.e. smaller then 1024).
 */
#if (FILENAME_MAX < 1024)
#undef FILENAME_MAX
#define FILENAME_MAX 1024
#endif

#if defined(__unix)
/* char * GLOBAL_PROMPT; */
#define max(a,b) (a>b?a:b)
#endif /* defined(__unix) */

#if !(defined(TRUE))
#define TRUE    1
#endif
#if !(defined(FALSE))
#define FALSE   0
#endif

#if (defined(__unix) && !defined(READLINE))
#define SCROLL            /* Set scrolling region at low screen half */
#endif /* (defined(__unix) && !defined(READLINE)) */

#if (defined(MSDOS) || defined(OS2)) && defined(__BORLANDC__)
#define ROWS 		get_rows()	/* Borland compiler can get */
#define COLUMNS		get_columns()   /* these from DOS - OS/2 */
#elif defined(__unix)
#define ROWS		get_rows()
#define COLUMNS		get_columns()
#else
#if defined(VMS)
#define ROWS		24	/* Number of rows on text screen */
#else
#define ROWS		25	/* Number of rows on text screen */
#endif /* VMS */
#define COLUMNS 	80	/* Number of columns on text screen */
#endif /* (MSDOS || OS2) && __BORLANDC__ */

/*  Globals defining menus  */

#define CMND_LENGTH 11              /* length of command */
#define CMNT_LENGTH 41              /* length of comment */

struct  MENU                        /* command menu */
	{
	char    COMMAND[CMND_LENGTH];   /* a single command (lower case!) */
	int     SIGNIF_CHAR;            /* # of significant chars in command */
	int     RET_NR;                 /* return code number of command */
	char    COMMENT[CMNT_LENGTH];   /* comments explaining the command */
	};

/***************************************************************************/
/*  Function prototypes                                                    */
/***************************************************************************/

#ifdef UNDERSCORES

#define init_menu            _init_menu
#define end_menu             _end_menu
#define add_extension        _add_extension
#define clear_command        _clear_command
#define clear_screen         _clear_screen
#define close_macro          _close_macro
#define cmnd_match           _cmnd_match
#define cmnd_match_err       _cmnd_match_err
#define del_extension        _del_extension
#define errtype              _errtype
#define get_extension        _get_extension
#define get_int              _get_int
#define get_real             _get_real
#define get_string           _get_string
#define get_dstring          _get_dstring
#define get_token            _get_token
#define maths_in_token       _maths_in_token
#if !defined(VMS)
#define install_exc_handler  _install_exc_handler
#endif /* !defined(VMS) */
#define list_menu            _list_menu
#define list_menus           _list_menus
#define nomore_commands      _nomore_commands
#define opsys                _opsys
#define put_command          _put_command
#define replace_extension    _replace_extension
#define restore_line         _restore_line
#define run_macro            _run_macro
#define save_line            _save_line
#define set_cursor           _set_cursor
#define set_scroll           _set_scroll
#define skip_white           _skip_white
#define string_tolower       _string_tolower
#define type_line            _type_line
#define type_list            _type_list
#define type_line_no_journal _type_line_no_journal
#define typeoff              _typeoff
#define typeon               _typeon
#define video_highlight      _video_highlight
#define video_normal         _video_normal
#define video_reverse        _video_reverse
#define yesno                _yesno
#define yesnostr             _yesnostr
#define cursor_big           _cursor_big
#define get_cursor_position  _get_cursor_position
#define set_cursor_position  _set_cursor_position
#if defined(__BORLANDC__) || defined(__unix)
#define get_rows             _get_rows
#define get_columns          _get_columns
#endif /* defined(__BORLANDC__) || defined(__unix) */
#define get_term_line        _get_term_line
#if defined(__unix)
#define strlwr               _strlwr
#define strupr               _strupr
#endif /* defined(__unix) */

#endif /* UNDERSCORES */

int     init_menu(void);
int     end_menu(void);
void    add_extension(char filename[], char extension[]);
void    clear_command(void);
void    clear_screen(void);
int     close_macro(void);
int     cmnd_match(char token[], struct MENU menu[], int length);
int     cmnd_match_err(char command[], struct MENU menu[], int menu_length,
            int err_flag);
void    del_extension(char filename[]);
void    errtype(char message[]);
void    get_extension(char filename[], char extension[]);
int     get_int(int dflt, char prompt[]);
double  get_real(double dflt, char prompt[]);
void    get_string(char string[], char prompt[]);
void    get_dstring(char string[], char dflt[], char prompt[]);
int     get_token(char token[], char prompt[]);
void    maths_in_token(char * string);
#if !defined(VMS)
int     install_exc_handler(jmp_buf jumpaddr);
#endif /* !defined(VMS) */
void    list_menu(char title[], struct MENU menu[], int length);
void    list_menus(char title[], struct MENU menu[], int length, int scroll);
int     nomore_commands(void);
void    opsys(void);
void    put_command(char string[]);
void    replace_extension(char filename[], char extension[]);
int     restore_line(char *saveline);
int     run_macro(void);
void    save_line(char *saveline);
void    set_cursor(int column, int row);
void    set_scroll(int start_line, int end_line);
void    skip_white(void);
void    string_tolower(char string[]);
void    type_line(char line[]);
void    type_list(char tline[], int length);
void    type_line_no_journal(char tline[]);
void    typeoff(void);
void    typeon(void);
void    video_highlight(void);
void    video_normal(void);
void    video_reverse(void);
int     yesno(int dflt, char prompt[]);
char    *yesnostr(int flag);
void    cursor_big(int flag);
void    get_cursor_position(int *row, int *column);
void    set_cursor_position(int row, int col);
#if defined(__BORLANDC__) || defined(__unix)
int     get_rows(void);
int     get_columns(void);
#endif /* defined(__BORLANDC__) || defined(__unix) */
void    get_term_line(char *term_line);
#ifndef __CYGWIN__
void    strlwr(char string[]);
void    strupr(char string[]);
#endif /* defined(__CYGWIN__) */

#endif /* _MENU_H_ */
