/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                   manipulate.c                               $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: manipula.c,v 1.2 2001/07/09 12:45:31 svensson Exp $

****************************************************************************/

/*
Update 05/07/2001 E. Vlieg (vlieg@sci.kun.nl)
                  Changed menus to follow Rainer's scheme.
*/

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#define EXT extern
#include "ave.h"
#undef EXT

/***************************************************************************/
void    manipulate(void)
/***************************************************************************/

    /*
    Manipulate the structure factor data
    */

    {

    /* define mani_menu */

#define mani_length 5      /* number of commands in mani menu */

    static struct   MENU mani_menu[mani_length] =
	{
	"scanselect",1, 1,  "Multiply f for range of scan #'s",
	"hkselect", 2,  2,  "Multiply f for specific {hk}",
	"lselect",  2,  3,  "Multiply f for specific |l|",
	"help",     1,  20, "Display menu",
	"return",   1,  21, "Return to main menu"
	};

    int     stop = FALSE,i;
    char    token[100];
    int firstscan,lastscan,h,k;
    float       l,factor;

    while (!stop)
	{
	if (!get_token(token,"AVE.MANIPULATE>")) break;
	switch (cmnd_match(token,mani_menu,mani_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		firstscan = get_int(1,"First scannumber: ");
		lastscan = get_int(1,"Last scannumber: ");
		factor = get_real(1,
				  "Multiplication factor for raw data [1]: ");
		for (i = 0; i < NIN; i++)
		    {
		    if ((REFIN[i].ID >= firstscan) &&
			(REFIN[i].ID <= lastscan))
			{
			REFIN[i].F *= factor;
			REFIN[i].SIG *= factor;
			}
		    }
		break;
	    case 2:
		h = get_int(1,"Selected Miller index h: ");
		k = get_int(1,"Selected Miller index k: ");
		factor = get_real(1,
				  "Multiplication factor for averaged data [1]: ");
		for (i = 0; i < NAVE; i++)
		    {
		    if ((REFAVE[i].H == h) && (REFAVE[i].K == k))
			{
			REFAVE[i].F *= factor;
			REFAVE[i].SIG1 *= factor;
			REFAVE[i].SIG2 *= factor;
			}
		    }
		break;
	    case 3:
		l = get_real(1,
			     "Selected absolute value for Miller index l: ");
		l = fabs(l);
		factor = get_real(1,
				  "Multiplication factor for averaged data [1]: ");
		for (i = 0; i < NAVE; i++)
		    {
		    if (fabs(fabs(REFAVE[i].L)-l) < L_SEPARATION  == h)
			{
			REFAVE[i].F *= factor;
			REFAVE[i].SIG1 *= factor;
			REFAVE[i].SIG2 *= factor;
			}
		    }
		break;
	    case 20:
		list_menu("MANIPULATE MENU",mani_menu,mani_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    }
