/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                          set.c                                $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: set.c,v 1.7 2004/01/19 16:55:04 wilcke Exp $

****************************************************************************/
/*
Update 19/01/2004 R. Wilcke (wilcke@esrf.fr) 
                  removed declarations of fopen() (is declared in "stdio.h").
Update 05/07/2001 E. Vlieg (vlieg@sci.kun.nl)
                  Changed menus to follow Rainer's scheme.
Update 20/12/2000 E. Vlieg (vlieg@sci.kun.nl)
		  Small changes in menu help texts
Update 15/12/2000 E. Vlieg (vlieg@sci.kun.nl)
		  Add DUBBLE spec file type.
		  Add 2+3 mode.
Update 12/12/2000 E. Vlieg (vlieg@sci.kun.nl)
                  Added input for linear gamma table and transmissions.
*/
/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#define EXT	extern
#include "ana.h"
#undef EXT

/***************************************************************************/
void    set(void)
/***************************************************************************/

    /*
    Menu to set various parameters.
    */

    {

    /* define set_menu */

#define set_length 8       /* number of commands in set menu */

    static struct   MENU set_menu[set_length] =
	{
	"read",      3,  1,  "Set read parameters",
	"fit",       1,  2,  "Set fit parameters",
	"general",   1,  3,  "Set general parameters",
	"loop",      2,  4,  "Set loop strings",
	"integrate", 1,  5,  "Set numerical integration parameters",
	"correct",   1,  6,  "Set correction parameters",
	"help",      1,  20, "Display menu",
	"return",    1,  21, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];

    while (!stop)
	{
	type_header(0);
	if (!get_token(token,"ANA.SET>")) return;
	switch (cmnd_match(token,set_menu,set_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		set_read();
		break;
	    case 2:
		set_fit();
		break;
	    case 3:
		set_general();
		break;
	    case 4:
		set_loop();
		break;
	    case 5:
		set_integrate();
		break;
	    case 6:
		set_corrections();
		break;
	    case 20:
		list_menus("SET PARAMETERS",set_menu,set_length,
			   ROWS-MAX_SPECTRUM-3);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    set_corrections(void)
/***************************************************************************/

    /*
    Set parameters used for area, beamprofile, polarization and lorentz
    correction factors.
    */

    {

    /* define set_cor_menu */

    enum i_set_cor 
	{
	i_zero,
	i_nocorrect,
	i_zaxis,
	i_twoptwo,
	i_twopthree,
	i_refrock,
	i_beamcor,
	i_gammafix,
	i_lingamma,
	i_rscan,
	i_hklscan,
	i_dslit,
	i_hslit,
	i_vslit,
	i_hbeam,
	i_vbeam,
	i_radius,
	i_hpolar,
	i_transin,
	i_transout,
	i_list,
	i_help,
	i_return
	};


    static struct   MENU set_cor_menu[i_return] =
	{
	"nocorrect", 2,i_nocorrect, "No correction factors applied",
	"zaxis",     2,i_zaxis,	 "Z-axis diffractometer",
	"twoptwo",   2,i_twoptwo,"(2+2)-type diffractometer",
	"twopthree", 6,i_twopthree,"(2+3)-type diffractometer",
	"refrock",   3,i_refrock,"Reflectivity rocking scan",
	"beamcor",   1,i_beamcor,"Beam profile correction yes/no",
	"gammafix",  1,i_gammafix,"Detector angle gamma at the SRS",
	"lingamma",  3,i_lingamma,"Linear gamma table yes/no",
	"rscan",     2,i_rscan,  "Spectrum is angular scan",
	"hklscan",   2,i_hklscan,"Spectrum is diffraction-index scan",
	"dslit",     1,i_dslit,  "In-plane width of detector slits",
	"hslit",     2,i_hslit,  "Horizontal slit width of incoming beam",
	"vslit",     2,i_vslit,  "Vertical slit width of incoming beam",
	"hbeam",     2,i_hbeam,  "Horizontal fwhm of incoming beam",
	"vbeam",     2,i_vbeam,  "Vertical fwhm of incoming beam",
	"radius",    2,i_radius,  "Sample radius (only round samples)",
	"hpolar",    2,i_hpolar,  "Horizontal polarisation fraction",
	"tin",       2,i_transin, "Transmission of incoming beam",
	"tout",      2,i_transout,"Transmission of outgoing beam",
	"list",      1,i_list, "List current values",
	"help",      1,i_help, "Display menu",
	"return",    1,i_return, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];

    while (!stop)
	{
	type_header(0);
	if (!get_token(token,"ANA.SET.COR>")) return;
	switch (cmnd_match(token,set_cor_menu,i_return))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case i_nocorrect:
		CORRECTMODE = NOCORRECT;
		break;
	    case i_zaxis:
		CORRECTMODE = ZAXIS;
		break;
	    case i_twoptwo:
		CORRECTMODE = TWOPTWO;
		break;
	    case i_twopthree:
		CORRECTMODE = TWOPTHREE;
		break;
	    case i_refrock:
		CORRECTMODE = REFROCK;
		break;
	    case i_gammafix:
		sprintf(STRING, "Detector angle gamma (ONLY SRS !) [%.3f]: ", GAMMA_FIX);
		GAMMA_FIX = get_real(GAMMA_FIX, STRING);
		break;
	    case i_lingamma:
		sprintf(STRING,
			"Linear gamma table (on 6-circle diffractometer)? [%s]: ",
			yesnostr(LINEARGAMMA));
		LINEARGAMMA = yesno(LINEARGAMMA,STRING);
		break;
	    case i_rscan:
		RSCAN = TRUE;
		break;
	    case i_hklscan:
		RSCAN = FALSE;
		break;
	    case i_hslit:
		sprintf(STRING,
			"Horizontal width of incoming beam slits [%4.2f mm]: ",
			HORSLIT);
		HORSLIT = get_real(HORSLIT,STRING);
		break;
	    case i_vslit:
		sprintf(STRING,
			"Vertical width of incoming beam slits [%4.2f mm]: ",
			VERSLIT);
		VERSLIT = get_real(VERSLIT,STRING);
		break;
	    case i_dslit:
		sprintf(STRING,"Width of detector slits [%3.1f mm]: ",
			DSLIT);
		DSLIT = get_real(DSLIT,STRING);
		break;
	    case i_hbeam:
		sprintf(STRING,"Horizonal fwhm of beam [%4.2f mm]: ",
			HORBEAM);
		HORBEAM = get_real(HORBEAM,STRING);
		break;
	    case i_vbeam:
		sprintf(STRING,"Vertical fwhm of beam [%4.2f mm]: ",
			VERBEAM);
		VERBEAM = get_real(VERBEAM,STRING);
		break;
	    case i_radius:
		sprintf(STRING,"Sample radius [%3.1f mm]: ",
			RADIUS);
		RADIUS = get_real(RADIUS,STRING);
		break;
	    case i_hpolar:
		sprintf(STRING,"Horizontal polarisation fraction [%5.3f]: ",
			HPOLAR);
		HPOLAR = get_real(HPOLAR,STRING);
		break;
	    case i_transin:
		sprintf(STRING,
			"Transmission of incoming beam at zero angles [%5.3f]: ",
			TRANSIN);
		TRANSIN = get_real(TRANSIN,STRING);
		break;
	    case i_transout:
		sprintf(STRING,
			"Transmission of outgoing beam at zero angles [%5.3f]: ",
			TRANSOUT);
		TRANSOUT = get_real(TRANSOUT,STRING);
		break;
	    case i_beamcor:
		sprintf(STRING,"Beamprofile correction [%s]: ",
			yesnostr(BEAMCOR));
		BEAMCOR = yesno(BEAMCOR,STRING);
		break;
	    case i_list:
		if (CORRECTMODE == NOCORRECT)
		    type_line("No correction factors applied\n");
		if (CORRECTMODE == ZAXIS)
		    type_line("Z-axis diffractometer\n");
		if (CORRECTMODE == TWOPTWO)
		    type_line("(2+2)-type diffractometer\n");
		if (CORRECTMODE == TWOPTHREE)
		    type_line("(2+3)-type diffractometer\n");
		if (CORRECTMODE == REFROCK)
		    type_line("Reflectivity rocking scan\n");
		sprintf(STRING,"Beam profile correction: %s\n",
			yesnostr(BEAMCOR));
		type_line(STRING);
		sprintf(STRING,"Fixed detector angle gamma (SRS): %.3f\n", GAMMA_FIX);
		type_line(STRING);
		sprintf(STRING,"Linear gamma table: %s\n",
			yesnostr(LINEARGAMMA));
		type_line(STRING);
		if (RSCAN)
		    type_line("Angular scan\n");
		else
		    type_line("HKL scan\n");
		sprintf(STRING,"In-plane detector slit width = %4.2f mm\n",DSLIT);
		type_line(STRING);
		sprintf(STRING,"Horizontal beam slit width   = %4.2f mm\n",
			HORSLIT);
		type_line(STRING);
		sprintf(STRING,"Vertical beam slit width     = %4.2f mm\n",
			VERSLIT);
		type_line(STRING);
		sprintf(STRING,"Horizontal beam fwhm (Gauss) = %4.2f mm\n",
			HORBEAM);
		type_line(STRING);
		sprintf(STRING,"Vertical beam fwhm (Gauss)   = %4.2f mm\n",
			VERBEAM);
		type_line(STRING);
		sprintf(STRING,"Sample radius                = %3.1f mm\n",
			RADIUS);
		type_line(STRING);
		sprintf(STRING,"Horiz. polarization fraction = %5.3f\n",
			HPOLAR);
		type_line(STRING);
		sprintf(STRING,"Transmission incoming beam   = %5.3f\n",
			TRANSIN);
		type_line(STRING);
		sprintf(STRING,"Transmission outcoming beam  = %5.3f\n",
			TRANSOUT);
		type_line(STRING);
		break;
	    case i_help:
		list_menus("SET CORRECTION PARAMETERS",
			   set_cor_menu,i_return,ROWS-MAX_SPECTRUM-3);
		break;
	    case i_return:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    set_fit(void)
/***************************************************************************/

    /*
    Set parameters used during while fitting.
    */

    {

    /* define set_fit_menu */

#define set_fit_length 7       /* number of commands in set_fit menu */

    static struct   MENU set_fit_menu[set_fit_length] =
	{
	"open",      1,  1,  "Open file for fit results",
	"close",     2,  2,  "Close fit output file",
	"standard",  1,  3,  "Use standard deviation weights in fit",
	"unit",      1,  4,  "Use unit weights in fit",
	"list",      1,  10, "List parameter values",
	"help",      1,  20, "Display menu",
	"return",    1,  21, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];

    while (!stop)
	{
	type_header(0);
	if (!get_token(token,"ANA.SET.FIT>")) return;
	switch (cmnd_match(token,set_fit_menu,set_fit_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		if (OUTFIT)
		    {
		    sprintf(STRING,
			    "WARNING, file '%s' already open, new file? [no]: ",
			    FFILENAME);
		    if (yesno(FALSE,STRING))
			{
			fclose(FITFILE);
			}
		    else
			{
			break;
			}
		    }
		while (!get_token(FFILENAME,
				  "Give name of fit output file: "));
		if ((FITFILE = fopen(FFILENAME,"w")) == NULL)
		    {
		    sprintf(STRING,"Failed to open '%s'",FFILENAME);
		    errtype(STRING);
		    OUTFIT = FALSE;
		    break;
		    }
		else
		    {
		    OUTFIT = TRUE;
		    FITSWRITTEN = 0;
		    }
		break;
	    case 2:
		if (OUTFIT)
		    {
		    fclose(FITFILE);
		    OUTFIT = FALSE;
		    }
		break;
	    case 3:
		WEIGHTMODE = 0;
		break;
	    case 4:
		WEIGHTMODE = 1;
		break;
	    case 10:
		if (OUTFIT)
		    {
		    sprintf(STRING,"Fit output to file '%s'\n",FFILENAME);
		    type_line(STRING);
		    }
		else
		    {
		    type_line("No fit output to file\n");
		    }
		if (WEIGHTMODE == 0)
		    type_line("Use standard deviation for weighting\n");
		else if (WEIGHTMODE == 1)
		    type_line("Use unit weights\n");
		break;
	    case 20:
		list_menus("SET FIT PARAMETERS",
			   set_fit_menu,set_fit_length,ROWS-MAX_SPECTRUM-3);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    set_general(void)
/***************************************************************************/

    /*
    Set some general parameters.
    */

    {

    /* define set_gen_menu */

#define set_gen_length 6       /* number of commands in set_gen menu */

    static struct   MENU set_gen_menu[set_gen_length] =
	{
	"onscreen",  2,  1,  "Screen output on",
	"offscreen", 2,  2,  "Screen output off",
	"datarun",   1,  3,  "Set data run mode",
	"list",      1,  20, "List parameter values",
	"help",      1,  21, "Display menu",
	"return",    1,  22, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];

    while (!stop)
	{
	type_header(0);
	if (!get_token(token,"ANA.SET.GENERAL>")) return;
	switch (cmnd_match(token,set_gen_menu,set_gen_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		typeon();
		break;
	    case 2:
		typeoff();
		break;
	    case 3:
		sprintf(STRING,"Data run mode [%s]: ",yesnostr(DATARUN));
		DATARUN = yesno(DATARUN,STRING);
		break;
	    case 20:
		sprintf(STRING,"Data run mode: %s\n",yesnostr(DATARUN));
		type_line(STRING);
		break;
	    case 21:
		list_menu("SET GENERAL PARAMETERS",
			  set_gen_menu,set_gen_length);
		break;
	    case 22:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    set_integrate(void)
/***************************************************************************/

    /*
    Set parameters used in numerical peak integration.
    */

    {

    /* define set_int_menu */

#define set_int_length 9       /* number of commands in set_int menu */

    static struct   MENU set_int_menu[set_int_length] =
	{
	"open",      1,  1,  "Open output file for integration results",
	"close",     2,  2,  "Close output file with integr. results",
	"transmat",  1,  3,  "Set elements of transformation matrix",
	"nbackgr",   2,  4,  "# left/right background points",
	"autoback",  1,  5,  "Automatic background calculation yes/no",
	"range",     2,  6,  "Integration range (*fitted FWHM)",
	"list",      1,  20, "List parameter values",
	"help",      1,  21, "Display menu",
	"return",    1,  22, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];

    while (!stop)
	{
	type_header(0);
	if (!get_token(token,"ANA.SET.INT>")) return;
	switch (cmnd_match(token,set_int_menu,set_int_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		if (OUTINT)
		    {
		    sprintf(STRING,
			    "WARNING, file '%s' already open, new file? [no]: ",
			    IFILENAME);
		    if (yesno(FALSE,STRING))
			{
			fclose(INTFILE);
			}
		    else
			{
			break;
			}
		    }
		while (!get_token(IFILENAME,
			  "Give name of integration output file (.int): "));
		add_extension(IFILENAME,"int");
		if ((INTFILE = fopen(IFILENAME,"w")) == NULL)
		    {
		    sprintf(STRING,"Failed to open '%s'",IFILENAME);
		    errtype(STRING);
		    OUTINT = FALSE;
		    break;
		    }
		else
		    {
		    OUTINT = TRUE;
		    SCANSWRITTEN = 0;
		    }
		break;
	    case 2:
		if (OUTINT)
		    {
		    fclose(INTFILE);
		    OUTINT = FALSE;
		    }
		break;
	    case 3:
		sprintf(STRING,"Matrix element 11 [%4.2f]: ",T11);
		T11 = get_real(T11,STRING);
		sprintf(STRING,"Matrix element 12 [%4.2f]: ",T12);
		T12 = get_real(T12,STRING);
		sprintf(STRING,"Matrix element 13 [%4.2f]: ",T13);
		T13 = get_real(T13,STRING);
		sprintf(STRING,"Matrix element 21 [%4.2f]: ",T21);
		T21 = get_real(T21,STRING);
		sprintf(STRING,"Matrix element 22 [%4.2f]: ",T22);
		T22 = get_real(T22,STRING);
		sprintf(STRING,"Matrix element 23 [%4.2f]: ",T23);
		T23 = get_real(T23,STRING);
		sprintf(STRING,"Matrix element 31 [%4.2f]: ",T31);
		T31 = get_real(T31,STRING);
		sprintf(STRING,"Matrix element 32 [%4.2f]: ",T32);
		T32 = get_real(T32,STRING);
		sprintf(STRING,"Matrix element 33 [%4.2f]: ",T33);
		T33 = get_real(T33,STRING);
		break;
	    case 4:
		sprintf(STRING,
			"Number of left and right background points [%1d]: ",
			NBACK);
		NBACK = get_int(NBACK,STRING);
		break;
	    case 5:
		sprintf(STRING,"Automatic background calculation [%s]: ",
			yesnostr(AUTO_BACK));
		AUTO_BACK = yesno(AUTO_BACK,STRING);
		break;
	    case 6:
		sprintf(STRING,
			"Integration range (*fitted FWHM), 0 for full range [%.2f]: ",
			INT_RANGE);
		INT_RANGE = get_real(INT_RANGE,STRING);
		break;
	    case 20:
		if (OUTINT)
		    {
		    sprintf(STRING,"Integration output to file '%s'\n",
			    IFILENAME);
		    type_line(STRING);
		    }
		else
		    {
		    type_line("No integration output to file\n");
		    }
		sprintf(STRING,"%22s %5.2f %5.2f %5.2f\n","",T11,T12,T13);
		type_line(STRING);
		sprintf(STRING,"%22s %5.2f %5.2f %5.2f\n",
			"Transformation matrix:",T21,T22,T23);
		type_line(STRING);
		sprintf(STRING,"%22s %5.2f %5.2f %5.2f\n","",T31,T32,T33);
		type_line(STRING);
		sprintf(STRING,"Background points: %1d\n",NBACK);
		type_line(STRING);
		sprintf(STRING,"Automatic background calculation: %s\n",
			yesnostr(AUTO_BACK));
		type_line(STRING);
		sprintf(STRING,"Integration range: %.2f\n",INT_RANGE);
		type_line(STRING);
		break;
	    case 21:
		list_menus("SET INTEGRATION PARAMETERS",
			   set_int_menu,set_int_length,ROWS-MAX_SPECTRUM-3);
		break;
	    case 22:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    set_loop(void)
/***************************************************************************/

    /*
    Set loop strings.
    */

    {

    /* define set_loop_menu */

#define set_loop_length 7       /* number of commands in set_loop menu */

    static struct   MENU set_loop_menu[set_loop_length] =
	{
	"before",    1,  1,  "Set string before file number",
	"after",     1,  2,  "Set string after file number",
	"shownumber",1,  3,  "Show scan number during looping",
        "increment", 1,  4,  "Run number increment in loop",
	"list",      1,  10, "List parameters",
	"help",      1,  20, "Display menu",
	"return",    1,  21, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];

    while (!stop)
	{
	type_header(0);
	if (!get_token(token,"ANA.SET.LOOP>")) return;
	switch (cmnd_match(token,set_loop_menu,set_loop_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		get_string(LOOP1,"Before: ");
		break;
	    case 2:
		get_string(LOOP2,"After: ");
		break;
	    case 3:
		sprintf(STRING,"Show scan number while looping [%s]: ",
			yesnostr(SHOWCOUNTER));
		SHOWCOUNTER = yesno(SHOWCOUNTER,STRING);
		break;
            case 4:
            	sprintf(STRING,"Run number increment [%1d]: ",
			LOOP_INCREMENT);
                LOOP_INCREMENT = get_int(LOOP_INCREMENT,STRING);
                if (LOOP_INCREMENT < 1 ) LOOP_INCREMENT = 1;
                break;
	    case 10:
		sprintf(STRING,"Before: %s \n",LOOP1);
		type_line(STRING);
		sprintf(STRING,"After : %s \n",LOOP2);
		type_line(STRING);
		sprintf(STRING,"Show scan number while looping: %s\n",
			yesnostr(SHOWCOUNTER));
		type_line(STRING);
                sprintf(STRING,"Run number increment = %1d\n",
			LOOP_INCREMENT);
                type_line(STRING);
		break;
	    case 20:
		list_menu("SET LOOP STRINGS",
			  set_loop_menu,set_loop_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    set_read(void)
/***************************************************************************/

    /*
    Set read parameters.
    Depending on file type, a certain subset of the variables is used:
    SRS:	XCOL,YCOL,MONCOL,MONITOR_NORM,HEADER_LINES,SOLID_CORR,
    			YCOLNAME
    SUPER:	XCOL,YCOL,MONITOR_NORM,DATAFILE,YCOLNAME,PATHNAME,
			NAUTOSUB
    COLUMN:	XCOL,YCOL,ECOL,HEADER_LINES
    XYE:	none
    */

    {

    /* define set_read_menu */

#define set_read_length 19      /* number of commands in set_read menu */

    static struct   MENU set_read_menu[set_read_length] =
	{
	"xcolumn",   1,  1,  "Column number of x values",
	"ycolumn",   1,  2,  "Column number of y values",
	"mcolumn",   1,  3,  "Column number of monitor values",
	"ecolumn",   1,  4,  "Column number of error values",
	"norm",      1,  5,  "Normalization value for monitor counts",
	"header",    3,  6,  "Number of header lines (obsolete ...)",
	"filename",  1,  7,  "Name of data file",
	"solidstate",1,  8,  "Solid-state detector correction (SRS)",
	"yname",     2,  9,  "Name of column of y values in data file",
	"pathname",  1,  10, "Pathname of SUPER file",
	"nautosub",  2,  11, "# of files in automatic subdir. (SUPER)",
        "srs",       2,  12, "Standard srs scan settings",
	"aes",       2,  13, "Standard VSW-AES scan settings",
	"id03",      4,  14, "Spec file of ID03 type",
	"id32",      4,  15, "Spec file of ID32 type",
	"dubble",    2,  16, "Spec file of DUBBLE type",
	"list",      1,  20, "List parameter values",
	"help",      1,  21, "Display menu",
	"return",    1,  22, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];
    char    t;

    while (!stop)
	{
	type_header(0);
	if (!get_token(token,"ANA.SET.READ>")) return;
	switch (cmnd_match(token,set_read_menu,set_read_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		sprintf(STRING,
			"Column number of x values (< 0: ask name; 0: ennumerate) [%1d]: ",
			XCOL);
		XCOL = get_int(XCOL,STRING);
		break;
	    case 2:
		sprintf(STRING,
			"Column number of y values [%1d]: ",YCOL);
		YCOL = get_int(YCOL,STRING);
		break;
	    case 3:
		sprintf(STRING,
			"Column number of monitor values (0 for no normalization) [%1d]: ",
			MCOL);
		MCOL = get_int(MCOL,STRING);
		break;
	    case 4:
		sprintf(STRING,
			"Column number of error-values (0 for no errors) [%1d]: ",
			ECOL);
		ECOL = get_int(ECOL,STRING);
		break;
	    case 5:
		sprintf(STRING,"Value for normalizing monitor counts [%6.0e]: ",
			MONITOR_NORM);
		MONITOR_NORM = get_real(MONITOR_NORM,STRING);
		break;
	    case 6:
		sprintf(STRING,
			"Number of header lines in file [%1d]: ",HEADER_LINES);
		HEADER_LINES = get_int(HEADER_LINES,STRING);
		break;
	    case 7:
		while (!get_token(DATAFILE,"File name: "));
		break;
	    case 8:
		sprintf(STRING,"Solid state detector correction [%s]: ",
			yesnostr(SOLID_CORR));
		SOLID_CORR = yesno(SOLID_CORR,STRING);
		break;
	    case 9:
		while (!get_token(YCOLNAME,
				  "Name of y-column in data file: "));
		string_tolower(YCOLNAME);
		break;
	    case 10:
		while (!get_token(PATHNAME,"Pathname of SUPER input file: "));
		break;
	    case 11:
		sprintf(STRING,
			"Number of files in subdirectory (0 for automode off) [%1d]: ",
			NAUTOSUB);
		NAUTOSUB = get_int(NAUTOSUB,STRING);
		break;
            case 12:
                XCOL = 1;
                YCOL = 5;
                ECOL = 0;
                MCOL = 3;
                HEADER_LINES = 28;
                break;
            case 13:
                XCOL = 1;
                YCOL = 2;
                ECOL = 0;
                MCOL = 0;
                HEADER_LINES = 12;
		break;
	    case 14:
		SPECTYPE = ID03;
		break;
	    case 15:
		SPECTYPE = ID32;
		break;
	    case 16:
		SPECTYPE = DUBBLE;
		break;
	    case 20:
		sprintf(STRING,"   x-column number      = %1d\n",XCOL);
		type_line(STRING);
		sprintf(STRING,"   y-column number      = %1d\n",YCOL);
		type_line(STRING);
		sprintf(STRING,"   monitor-column number= %1d\n",MCOL);
		type_line(STRING);
		sprintf(STRING,"   error-column number  = %1d\n",ECOL);
		type_line(STRING);
		sprintf(STRING,"   norm of monitor      = %7.1e\n",
			MONITOR_NORM);
		type_line(STRING);
		sprintf(STRING,"   # of header lines    = %1d\n",
			HEADER_LINES);
		type_line(STRING);
		sprintf(STRING,"   input file           = %s\n",DATAFILE);
		type_line(STRING);
		sprintf(STRING,"   solid-state detector correction: %s\n",
			yesnostr(SOLID_CORR));
		type_line(STRING);
		sprintf(STRING,"   y-column name        = %s\n",
			YCOLNAME);
		type_line(STRING);
		sprintf(STRING,"   path name            = %s\n",PATHNAME);
		type_line(STRING);
		sprintf(STRING,"   nauto sub-directory  = %4d\n",NAUTOSUB);
		type_line(STRING);
		if (SPECTYPE == ID03)
		    type_line("   spec file of ID03 type\n");
		if (SPECTYPE == ID32)
		    type_line("   spec file of ID32 type\n");
		if (SPECTYPE == DUBBLE)
		    type_line("   spec file of DUBBLE type\n");
		break;
	    case 21:
		list_menus("SET READ PARAMETERS",
			   set_read_menu,set_read_length,ROWS-MAX_SPECTRUM-3);
		break;
	    case 22:
		stop = TRUE;
	    }
	}
    }


