/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                         ana.h                                 $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: ana.h,v 1.12 2006/03/28 15:32:08 wilcke Exp $

****************************************************************************/

/*
Update 22/03/2006 R. Wilcke (wilcke@esrf.fr)
                  removed check for __CYGWIN__ since __unix is now defined
                  in Cygwin 1.X.
Update 22/02/2006 R. Wilcke (wilcke@esrf.fr)
                  modified code for MacIntosh MACOSX using predefined macro
                  __APPLE__ for this architecture.
Update 08/06/2001 E. Vlieg (vlieg@sci.kun.nl)
		  Add FILETYPE to store most recent file type.
Update 21/12/2000 O. Svensson (svensson@esrf.fr)
                  Reversed the order of the update comments.
Update 15/12/2000 E. Vlieg (vlieg@sci.kun.nl)
		  Add DUBBLE specfile type.
		  Add 2+3 diffractometer type for correction factors.
Update 09/10/2000 E. Vlieg (vlieg@sci.kun.nl)
                  Include corrections factors for linear gamma table and
                  transmission.
                  Allow exit from fit parameter menu without actual fit.
                  Function despike() added.
                  Use fwhm instead of hwhm in Gauss and Lorentz: new GAUSIG
                  and GCONST.
Update 13/09/2000 R. Wilcke (wilcke@esrf.fr)
                  set dimension of TITLE in structure DATA_BLOCK to 
                  TITLE_LENGTH + 1 to allow for terminating 0;
                  introduce new parameter TITINFLN = 100 and use it to set the
                  dimensions of DATATITLE and DATAINFO.
Update 19/07/2000 R. Wilcke (wilcke@esrf.fr)
                  replaced the buffer size for FFILENAME, IFILENAME and DATAFILE
                  by the ISO-C defined macro FILENAME_MAX.
Update 21/06/2000 R. Wilcke (wilcke@esrf.fr)
                  replace UNIX by __unix (is defined by CPP on UNIX systems).
Update 15/06/2000 R. Wilcke (wilcke@esrf.fr)
                  move definition of SCROLL to the file menu.h.
Update 07/05/2000 R. Wilcke (wilcke@esrf.fr)
                  added function declaration for read_spec() to "read.c";
                  corrected name in function declaration from read_colomn() to
                  read_column().
Update 17/03/2000 R. Wilcke (wilcke@esrf.fr)
                  replaced test for "defined(CYGWIN)" by "defined(__CYGWIN__)";
                  define SCROLL for UNIX and __CYGWIN__.
*/

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#include <stdio.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <platform.h>
#if defined(MSDOS) || defined(OS2)
#include <menu.h>
#include <myplot.h>
#elif defined(__unix) || defined(__APPLE__)
#include <menu.h>
#include <PGmyplot.h>
#elif defined(VMS)
#include "menu.h"
#include "myeg.h"
#endif /* defined(MSDOS) || defined(OS2) */

/***************************************************************************/
/*      global parameters                                                  */
/***************************************************************************/

typedef double  MATRIX[3][3];

#define DO3D    	  	/* Enable 3D plotting options yes/no */

#ifndef MSDOS
#define far
#endif

#define INITFILE "ana_init.mac"
#define INLLEN  512         	/* Length of input buffer */
#define RAD     57.29577951
#define	PI	3.141592654
#ifdef MSDOS
#define MAX_DATA        1010    /* Maximum spectrum size */
#else
#define MAX_DATA        5000
#endif /* MSDOS */
#define TITINFLN     100  /* Length of Title and Info buffer for data */
#define MAX_SPECTRUM    5       /* Number of spectra */
#define TITLE_LENGTH    40      /* Length of spectrum title */
#define DATACOLUMNS 25  /* Maximum number of data columns in a data file */
#define INIT    0       /* Flag in function call to denote initialization */
#define CALC    1       /* Flag in function call to denote calculation */
#define DERV    2       /* Flag to denote fitting with derivative calc. */
#define	PEAK	3	/* Flag to denote peak integration */
//#define GAUSIG  0.69315 /* To ensure HWHM as parameter in Gaussians */
#define GAUSIG2 2.77259 /* 4*ln(2): for FWHM in Gaussian profiles */
//#define	GCONST	2.12893	/* sqrt(PI/ln(2)): for peak interation */
#define GCONST2 1.06447 /* 0.5*sqrt(PI/ln(2)): for peak integration */
#define MAXPAR  10      /* Maximum number of parameters in theory */
#define TH_LENGTH  30   /* Length of titles in theory */
#define S_LENGTH    6   /* Length of short parameter name */
#define	MAXPEAK	    2	/* Maximum number of peaks in theory */
#define	STEPSIZE  0.01	/* Normalizing step size in peak integration */
#define NLEVELING 4	/* # left and right background points to level
			   a spectrum */

EXT char    INLINE[INLLEN];         /* Input buffer for general purposes */
EXT char    STRING[INLLEN];            /* Another general in/output buffer */

/* data block parameters, to be allocated dynamically */

typedef struct                  /* spectrum structure */
    {
    float       X[MAX_DATA];    /* x-values of spectrum */
    float       Y[MAX_DATA];    /* y-values of spectrum */
    float       E[MAX_DATA];    /* errors in y-values */
    int         NPNT;           /* number of points in spectrum */
    float       MINY;           /* minimum y-value in spectrum */
    float       MAXY;           /* maximum y-value in spectrum */
    char        TITLE[TITLE_LENGTH+1];    /* title of spectrum */
    } DATA_BLOCK ;


EXT DATA_BLOCK far *DATA;       /* allocated in main file */

/* dummy spectrum used for temporary storage during spectrum manipulation */

EXT float   XD[MAX_DATA];
EXT float   YD[MAX_DATA];
EXT float   ED[MAX_DATA];

/* Parameters for reading files */

EXT int	XCOL;		/* Column number of x values*/
EXT int	YCOL;		/* Column number of y values*/
EXT int	MCOL;		/* Column number of monitor values*/
EXT int	ECOL;		/* Column number of error values */
EXT float MONITOR_NORM;	/* Monitor normalization signal */
EXT int   HEADER_LINES;	/* Number of header lines in data file */
EXT char  DATAFILE[FILENAME_MAX];   /* Name of data file */
EXT int   SOLID_CORR;	/* Flag denoting solid-state detector correction */
EXT char  YCOLNAME[10]; /* Name of y-column in SUPER file */
EXT char  PATHNAME[50]; /* Pathname of SUPER file (needed in case of
			   automatic subdirectories */
EXT int   NAUTOSUB;     /* Number of scan files before next subdirectory
			   is opened for data files */
EXT int   SPECTYPE;	/* Flag denoting the type of Spec file */
#define ID03 0
#define ID32 1
#define DUBBLE  2
EXT char    FILETYPE[15]; /* The most recently read in file type */

/* Stored data file parameters */

EXT int     SCANNR;         /* Scan number of data file */
EXT int     READSPEC;       /* Number of last spectrum read in */
EXT char  DATATITLE[TITINFLN];    /* Line with title/comment of most recent data
                                     file */
EXT char  DATAINFO[TITINFLN];     /* Line with more info of most recent data
                                     file */
EXT char    XCOLNAME[50];   /* Title of x-axis read from data file */
EXT float   HMIL;           /* Miller index h of last spectrum read in */
EXT float   KMIL;           /* Miller index k of last spectrum read in */
EXT float   LMIL;           /* Miller index l of last spectrum read in */
EXT float   DELTA;          /* Delta angle of most recent scan read in */
EXT float   BETAIN;         /* Angle of incidence of last spectrum read in */
EXT float   ALPHA;          /* Rotary-table setting of last spectrum read in */
EXT float   GAMMA;          /* out-of-plane detector angle gamma */

/* Parameters for theoretical curves */

EXT struct                  /* Structure defining a theory */
    {
    char        TITLE[TH_LENGTH];       /* Name of theory */
    int         NPAR;                   /* Number of parameters in theory */
    float       PAR[MAXPAR];            /* Parameter values */
    float       ERR[MAXPAR];            /* Errors in parameter values */
    float       MIN[MAXPAR];            /* Lower bound on parameter values */
    float       MAX[MAXPAR];            /* Upper bound on parameter values */
    char        NAME[MAXPAR][TH_LENGTH];/* Name of parameters */
    char        SHORT[MAXPAR][S_LENGTH];/* Short name of parameters */
    int         FIX[MAXPAR];            /* TRUE if parameter fixed */
    int		NPEAK;			/* Number of peaks in theory */
    float	PEAKINT[MAXPEAK];	/* Integrated peak intensity */
    float	PEAKERR[MAXPEAK];	/* Error in integr. peak intensity */
    }
    TH;

/* Pointer to current theory */

EXT void far (*F_PTR)(float x, float a[], float *y, float dyda[], int mode);

/* parameters for fitting */

EXT int     FITSPEC;        /* Spectrum number to be fitted */
EXT int     FITOUTSP;       /* Output spectrum number of fit */
EXT float   WEIGHT[MAX_DATA];       /* Weight of data points */
EXT int     OUTFIT;         /* Flag to determine whether fit results goto file */
EXT FILE    *FITFILE;       /* Pointer to fit output file */
EXT char    FFILENAME[FILENAME_MAX];  /* Name of fit output file */
EXT float   CHISQR;         /* Normalized chi square value of last fit */
EXT int     WEIGHTMODE;     /* Flag to denote mode of weighting in a fit */

/* Numerical integration parameters*/

EXT int     OUTINT;         /* Flag denoting whether integration output goes to
			to a file or not */
EXT FILE    *INTFILE;       /* Pointer to integration output file */
EXT char    IFILENAME[FILENAME_MAX];  /* Name of integration output file */
EXT int     NBACK;          /* # left and right points used for background,
			these are not used in numerical integration */
EXT int	    AUTO_BACK;	 /* Flag to denote automatic background calculation */
EXT float   T11,T12,T13; /* Matrix elements for hkl transformation on output */
EXT float   T21,T22,T23;
EXT float   T31,T32,T33;
EXT int     RSCAN;      /* Flag denoting whether scan is angular scan or
			Miller index scan */
EXT float   INT_RANGE;	/* Numerical integration goes over INT_RANGE times
			the FWHM of the fitted peak. Ignored if 0 */

/* Correction parameters */

EXT float   GAMMA_FIX;      /* fixed out-of-plane detector angle gamma for SRS */
EXT float   LINEARGAMMA;  /* Flag to denote whether gamma circle (on 6-circle
			  diffractometer) is implemented as linear table */
EXT int     SCANSWRITTEN; /* number count of files written to int. file */
EXT int	    FITSWRITTEN;  /* number count of fits written to fit file */

EXT float   BEAMCOR;	/* Flag to denote beamprofile correction */
EXT float   VERSLIT; 	/* Vertical slit width of incoming beam */
EXT float   HORSLIT;    /* Horizontal slit width of incoming beam */
EXT float   DSLIT; 	/* Width of in-plane detector slits */
EXT float   HORBEAM;	/* Horizontal FWHM of beam */
EXT float   VERBEAM;	/* Vertical FWHM of beam */
EXT float   RADIUS;	/* Sample radius (round samples) */
EXT float   HPOLAR;	/* Horizontal polarisation fraction in beam */
EXT float   TRANSIN;	/* Transmission of incoming beam */
EXT float   TRANSOUT;   /* Transmission of outgoing beam */
#define	LIMIT	40	/* Half of maximum integration area over sample
			[mm] */
#define	STEP	0.02	/* Area integration step size [mm] */
EXT int	CORRECTMODE;	/* Flag denoting type of correction factors used */
#define NOCORRECT   0
#define ZAXIS	1
#define TWOPTWO 2
#define TWOPTHREE 3
#define REFROCK 4

/* And some other parameters */

EXT int     DATARUN;    /* Flag to denote auto plotting with extra header */
EXT int	    LOOP;  	/* Flag to denote whether command loop mode in on */
EXT int	    SHOWCOUNTER;/* Flag to denote the display of loop counter */
EXT char    LOOP1[512]; /* First half of string to be repeated */
EXT char    LOOP2[512]; /* Second half of string to be repeated */
EXT int	LOOP_INCREMENT;	/* Increment in loop counter */

/***************************************************************************/
/*      function prototypes                                                */
/***************************************************************************/

/* in ana.c */

void    auto_plot(void);
void    clear_data(void);
char *  get_init_fname(void);
void    initialize(void);
void    list_spectrum(void);
void    plot(void);
void	plot_3d(void);
void    run_loop(void);
void    write_initmac(void);

/* in correct.c */

void	comp_cor(float *lorentz, float *polarization, float *intercept,
	float *area, float *transmission);
void	comp_cor_zaxis(float *lorentz, float *polarization, float *intercept,
	float *area, float *transmission);
void	comp_cor_refl(float *lorentz, float *polarization, float *intercept,
	float *area, float *transmission);
void	comp_cor_2p2or3(float *lorentz, float *polarization, float *intercept,
	float *area, float *transmission);
void	comp_cor_ridge(float beta_in, float *lorentz, float *polarization,
	float *area, float *transmission);
float	f_beam(float x, float z);
float	f_onsample(float x, float y);
float	f_detector(float x);

/* in fit.c */

float   fcn(float a[]);
void    model(double *y, int ipoint, int partial_flag);
void    fit(void);
void    ffit(float x, float a[], float *y, float dyda[], int ma,
	    int derivatives);
void    guess_fit(int nspec, float *background, float *slope,
	    float *position, float *height, float *width);
void    guess_fit2(int nspec, float *bgr, float *ebgr, float *pos,
	    float *epos, float *hgt, float *ehgt, float *wdt, float *ewdt);
int     set_anafitpar(void);

/* in operate.c */

void    add(void);
void    append(void);
void	auto_merge(void);
void    center(void);
void    cutoff(void);
void    delete_points(void);
void    despike(void);
void	differentiate(void);
void    divide(void);
void    fit_subtract(void);
void    integrate(void);
void	level(void);
void    lump(void);
void    merge(void);
void    multiply(void);
void    operate(void);
void    ref_integrate(void);
void    ref_to_f(void);
void    scale(void);
void    shift(void);
void	split(void);
void    sum(void);
void    wrap(void);
void	ylog10(void);

/* in read.c */

void    read_colomn(void);
void    read_ftascom(void);
void	read_spec(void);
void	read_srs(int version);
void    read_super(int old);
void    read_type(void);
void    read_xye(void);

/* in set.c */

void    set(void);
void	set_corrections(void);
void    set_fit(void);
void    set_general(void);
void    set_integrate(void);
void    set_read(void);
void    set_loop(void);

/* in theory.c */

void    gauss_double(float x, float a[], float *y, float dyda[], int mode);
void    gauss_lorentz(float x, float a[], float *y, float dyda[], int mode);
void    gauss_single(float x, float a[], float *y, float dyda[], int mode);
void    lorentz_gauss(float x, float a[], float *y, float dyda[], int mode);
void    lorentz_double(float x, float a[], float *y, float dyda[], int mode);
void    lorentz_single(float x, float a[], float *y, float dyda[], int mode);
void    power(float x, float a[], float *y, float dyda[], int mode);
void    pseudo_voigt(float x, float a[], float *y, float dyda[], int mode);
void    slit(float x, float a[], float *y, float dyda[], int mode);
void    theory(void);
void    theory_type(void);

/* in util.c */

void	file_transfer();
void    get_2inoutspec(int *in_spec1, int *in_spec2, int *out_spec);
void    get_in2outspec(int *in_spec, int *out_spec1, int *out_spec2);
void    get_inoutspec(int *in_spec, int *out_spec);
void    get_inspec(int *in_spec);
void    set_cursor(int horizontal, int vertical);
void	set_scroll(int start_line, int end_line);
double  sqr(double value);
void    type_header(int flag);

