/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$$$$$$                    lsqfit.h                         $$$$$$$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: lsqfit.h,v 1.6 2007/06/28 16:27:59 wilcke Exp $

****************************************************************************/

/*
Update 28/06/2007 R. Wilcke (wilcke@esrf.fr)
                  remove all code associated with the COOL preprocessor macro,
                  as this methode has now been replaced by ASA.
Update 15/03/2007 R. Wilcke (wilcke@esrf.fr)
                  added "#ifndef _LSQFIT_H" etc.;
                  move definition of LSQ_FNAMETERMINAL to file "lsqfit.c";
                  move definition of DEBUG and EXPORT here from file "lsqfit.c";
                  move macro DELTA here from "lsqfit.c" and rename it to
                  DELTASTP to avoid confusion with variable name in ANA;
                  move declaration of DERIV here from "lsqfit.c";
                  include "stdio.h" (needed for FILE type of FIT_LOGFILE);
                  remove numerous commented-out variable declarations;
                  remove declaration of FIT_LOGFILE_NAME (is already declared
                  in "lsqfit.c" and only used there);
                  remove declaration of ACCEPTED_LIMIT (not used);
                  remove test for macro LSQFIT (was only really used to avoid 
                  "external" declaration of variables FIT_LOGFILE and LOGFILE
                  for "lsqfit.c". That is not necessary, thus it is not needed
                  and also no longer defined in "lsqfit.c");
                  add function type declarations for "numrec.c": covsrt(),
                  gammln(), gaussj(), gcf(), gser(), gammq(), mrqcof(),
                  mrqmin(), nrerror(), vector(), ivector(), matrix(),
                  free_vector(), free_ivector(), free_matrix();
                  add function type declarations for "random.c":
                  initialize_rng(), myrand(), randflt(), ran3(), ranvector().
*/

#ifndef _LSQFIT_H_
#define _LSQFIT_H_

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#include <stdio.h>

/***************************************************************************/
/*      global parameters                                                  */
/***************************************************************************/

/* Defines */

/* #define DEBUG */

#ifdef DLL                /* make dynamic link library under OS/2 */
#define EXPORT _export _syscall
#else
#define EXPORT
#endif /* DLL */

#define	LSQ_NOFIT         0
#define LSQ_LEVENBERG     1
#define LSQ_COOLDOWN      2
#define LSQ_BREAK_RESTORE 3
#define LSQ_ASA           4

#define DELTASTP 0.001         /* Relative stepsize used in numerical estimate
                                  of derivative (lsqfit() only) */

#define ASA

/* Type definitions */

/*
    The function type "FitFunction" is used by lsqfit() and cooldown() for
    computing the model function f(x).

    Arguments are as follows:
	float           x-value for which the function should be computed
	float *         array of parameter values
	float *         pointer to y-value to be computed

    The following arguments are optional and only used by lsqfit():

	float *         pointer to computed analytical derivatives dy/da
	int             total number of parameters (needed for comp. of deriv.)
	int             flag denoting whether analytical derivatives should
			be computed.

    The function type "FitFunctionASA is required for the ASA function
    minimisation. The required format is rather different, thus a second
    function type seemed the best way to support ASA.
*/

typedef void (*FitFunction)(float, float *, float *, float *, int, int);
#ifdef ASA
typedef float (*FitFunctionASA)(float *, int *);
typedef double (*RandomASA)(void);
#endif /* ASA */

/* global variables */

extern FILE *FIT_LOGFILE;   /* File with summary of fit results */
extern int LOGFILE;         /* Flag to denote whether logfile is kept yes/no */
extern int DERIV;           /* Flag to denote whether fitted function has
                               analytical derivatives or not */

#ifdef ASA
extern int      TEMPERATURE_ANNEAL_SCALE;
extern long int	LIMIT_ACCEPTANCES;         /* ASA: max number of acceptances */
extern float    TEMPERATURE_RATIO_SCALE;
extern float    COST_PARAMETER_SCALE;
extern int      TESTING_FREQUENCY_MODULUS;
extern int      ASA_NPRINT;                /* printing line frequency */
extern int      USER_INITIAL_PARAMETERS;
#endif /* ASA */

/***************************************************************************/
/*      function prototypes                                                */
/***************************************************************************/

/* Exported functions of lsqfit.c */

/* levenberg is called directly by ana */
int levenberg(float x[], float y[], float wgt[], int ndata,
    float a[], int ma, int lista[], int mfit, float asig[],
    float amin[], float amax[], float apen[], float *chisqr,
    FitFunction funcs,
    int derivatives);

/* lsqfit is called by rod; it allows various minimization schemes */
int lsqfit(float x[], float y[], float wgt[], int ndata,
    float a[], int ma, int lista[], int mfit, float asig[],
    float amin[], float amax[], float apen[], float *chisqr,
    FitFunction funcs,
#ifdef ASA
    FitFunctionASA funcsasa,
#endif /* ASA */
    char *fittxt, int txtlength,
    int derivatives, int method, int calcquality);

void lsq_breakcontrol(int command, FitFunction funcs, float *a, int na);
int set_fitpar(char *prompt, int npar,
    float *fpar, float *fmin, float *fmax,
    int *check, int *fix, char *names, int namelength,
    float *xdata, float *ydata, float *wgtdata,
    int ndata, FitFunction funcs);
float ffit_asa(float a[], int *cost_flag);
float calc_chisq(float x[], float y[], float wgt[], int ndata,
    float a[], int ma, FitFunction funcs);

void set_controlpars(char *prompt);

/* Exported functions of numrec.c */

int covsrt(float **covar, int ma, int lista[], int mfit);
double gammln(float);
int gaussj(float **a, int n, float **b, int m);
void gcf(float *,float,float,float *);
void gser(float *,float,float,float *);
float gammq(float,float);
int mrqcof(float x[], float y[], float wgt[], int ndata,
    float a[], int ma, int lista[], int mfit,
    float amin[], float amax[], float apen[],
    float **alpha, float beta[], float *chisq,
    FitFunction funcs);
int mrqmin(float x[], float y[], float wgt[], int ndata,
    float a[], int ma, int lista[], int mfit, float amin[],
    float amax[], float apen[], float **covar, float **alpha,
    float *chisq,
    FitFunction funcs,
    float *alamda);
void nrerror(char error_text[]);
float *vector(int nl, int nh);
int *ivector(int nl, int nh);
float **matrix(int nrl, int nrh, int ncl,int nch);
void free_vector(float *v, int nl, int nh);
void free_ivector(int *v, int nl,int nh);
void free_matrix(float **m, int nrl, int nrh, int ncl, int nch);

/* Exported functions of random.c */
/* random number functions only needed for ASA */
#ifdef ASA
void initialize_rng(void);
double myrand(void);
double randflt(void);
#endif /* ASA */

#endif /* _LSQFIT_H_ */
