/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                        Walker.c                             $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: walker.c,v 1.13 2004/01/19 16:56:10 wilcke Exp $

****************************************************************************/

/***************************************************************************

   	- activates/deactivate Walker's extension
	- for this extension :
               - Util menu

****************************************************************************/

/*
Update 19/01/2004 R. Wilcke (wilcke@esrf.fr) 
                  removed declarations of fopen() (is declared in "stdio.h").
Update 26/03/2002 R. Wilcke (wilcke@esrf.fr)
                  walker(), walker_set_menu(), and walker_set_rasmol(): changed
                  abbreviations for menu commands to the agreed set.
Update 13/11/2000 O.Svensson (svensson@esrf.fr)
                  Added re-definiton of "perror" (called in sockhelp.c).
                  Re-intened the whole file, added new function 
		  "walker_write_xyz", renamed all functions to start with 
		  "walker_", added two new menu times to "walker_rasmol_menu":
		  "list" and "write".
Update 30/10/2000 O.Svensson (svensson@esrf.fr)
                  Fixed some bugs in the set_xyz method.
Update 27/10/2000 O.Svensson (svensson@esrf.fr)
                  Renaming of some phases in the set xyz menu after suggestions
                  from Chris Walker.
Update 25/10/2000 O.Svensson (svensson@esrf.fr)
                  Added new function walker_init().
		  Added new setxyz menu items zcells and second.
		  Modified the call to calc_atoms_orth_coord(), now
		  is passed the number of bulk cells and which of the 
		  two surface cell that should be output.
		  Modified walker_write_initmac, the ckeck if Walker's
		  extension is activated is now done in rod.c 
		  write_initmac().
Update 02/10/2000 O.Svensson (svensson@esrf.fr)
                  Spelling mistake correction, desactivte -> deactivate
Update 25/09/2000 Christopher J. Walker <cjw20@leicester.ac.uk>
                  Close xyz file before attempting to open it using rasmol. This 
		  should fix the problem of only half the atoms being read into
		  rasmol sometimes.
Update 09/08/2000 Christopher J. Walker <cjw20@leicester.ac.uk>
                  Reindent code 
		  Reorder menus slightly so we have 
		  WAL.SET.RASMOL> WAL.SET.XYZ> to set rasmol and xyz parameters
		  and WAL.RASMOL> to display structures in rasmol
		  convert to using enums for menu definitions. 
Update 19/07/2000 R. Wilcke (wilcke@esrf.fr)
                  replaced everywhere the buffer size for filenames by
                  the ISO-C defined macro FILENAME_MAX.

*/

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#include <ctype.h>
#define SET
#include "rod.h"

#ifdef EXTENSIONS /* Walker */


/***************************************************************************/
void perror(const char *text)
/***************************************************************************/
    /* 
     * Redefinition of perror in order not to bypass ncurses.
     *
     */
    {
    errtype((char*)text);
    }


/* main part */

/***************************************************************************/
void    walker(void)
/***************************************************************************/

/*    Walker's extension menu.    */
    {
    /* define Walker menu */
    enum i_walker_menu 
	{
	i_walker_null,
	i_walker_activate,
	i_walker_set,
	i_walker_rasmol_menu,
	i_walker_list,
	i_walker_help,
	i_walker_return, 
	i_walker_length=i_walker_return
	};
    


    static struct MENU walker_menu[i_walker_length] =
	{
	"activate",1,i_walker_activate,"Activate/deactivate Walker's extension",
	"set",     1,i_walker_set,     "Set parameters for Walker extensions",
	"rasmol",  2,i_walker_rasmol_menu, "Rasmol menu",
	"list",    1,i_walker_list,    "List state of Walker's extensions",
	"help",    1,i_walker_help,    "Display menu",
	"return",  1,i_walker_return,  "Return to main menu"
	};

    int     stop = FALSE;
    float               lstep;
    static float        hstart,hend,hstep,kstart,kend,kstep,l;
    int                 i,j,jj,atom1,atom2,atom3;
    FILE    *listfile;
    int     terminal;
    char    filename[FILENAME_MAX],extension[10];
    int     switch_code;
    int     nxyz, xcell, ycell;
    char    token[100], comments[100];

    while (!stop)
	{
	if (!get_token(token,"ROD.EXT.WAL>")) break;
	switch (cmnd_match(token,walker_menu,i_walker_length))
	    {
	    case -1:
		break;
	    case i_walker_null:
		break;
	    case i_walker_activate:
		sprintf(STRING,"Activate Walker's extensions ? [%s]: ", 
			yesnostr(walker_flag));
		walker_flag = yesno(walker_flag,STRING);
		sprintf(RASMOL_HOST, "localhost");
		sprintf(RASMOL_PORT, "21069");
		sprintf(RASMOL_FILE, "rod_rasmol.xyz");
		break;
	    case i_walker_set:
		if (walker_flag == 0)
		    {
		    errtype("ERROR, Walker's extension deactivated");
		    clear_command();
		    } else
			{
			walker_set_menu();
			}
		break;
	    case i_walker_rasmol_menu:
		if (walker_flag == 0)
		    {
		    errtype("ERROR, Walker's extension deactivated");
		    clear_command();
		    } else
			{
			walker_rasmol_menu();
			}
		break;
	    case i_walker_list:
		if (walker_flag ==TRUE)
		    {
		    sprintf(STRING,"Walker's extensions: YES\n");
		    type_line(STRING);
		    } 
		else
		    {
		    sprintf(STRING,"Walker's extensions: NO\n");
		    type_line(STRING);
		    }
		break;
	    case i_walker_help:
		list_menu("WALKER MENU",walker_menu,i_walker_return);
		break;
	    case i_walker_return:
		stop = TRUE;
	    }
	}
    }


/***************************************************************************/
void    walker_init(void)
/***************************************************************************/
    {

    WALKER_NXCELLS = 2;
    WALKER_NYCELLS = 2;
    WALKER_NZCELLS = 1;
    WALKER_SECOND = 1;
    sprintf(RASMOL_HOST, "localhost");
    sprintf(RASMOL_PORT, "21069");
    sprintf(RASMOL_FILE, "rod_rasmol.xyz");
    }


/***************************************************************************/
void    walker_set_xyz(void)
/***************************************************************************/

    /*
    Set xyz menu. Originally written by Olof Svensson.
    */

    {

    /* define set_xyz_menu */

    enum i_set_xyz_menu 
	{
	i_set_xyz_null,
	i_set_xyz_xcells,
	i_set_xyz_ycells,
	i_set_xyz_zcells,
	i_set_xyz_second,
	i_set_xyz_list,
	i_set_xyz_help,
	i_set_xyz_return,
	set_xyz_length=i_set_xyz_return
	};

    static struct   MENU set_xyz_menu[set_xyz_length] =
	{
	"xcells", 1, i_set_xyz_xcells, "No. cells in x direction",
	"ycells", 1, i_set_xyz_ycells, "No. cells in y direction",
	"zcells", 1, i_set_xyz_zcells, "No. bulk cells in z direction",
	"second", 1, i_set_xyz_second, "Output of first or second surface cell",
	"list",   1, i_set_xyz_list,   "List parameters",
	"help",   1, i_set_xyz_help,   "Display menu",
	"return", 1, i_set_xyz_return, "Return to main menu"
	};

    int     stop = FALSE, tmp;
    char    token[100];

    while (!stop)
	{
	if (!get_token(token,"ROD.EXT.WAL.SET.XYZ>")) break;
	switch (cmnd_match(token,set_xyz_menu,set_xyz_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case i_set_xyz_xcells:
		sprintf(STRING,"Number of cells in x-direction [%1d]: ",
			WALKER_NXCELLS);
		WALKER_NXCELLS = get_int(WALKER_NXCELLS,STRING);
		break;
	    case i_set_xyz_ycells:
		sprintf(STRING,"Number of cells in y-direction [%1d]: ",
			WALKER_NYCELLS);
		WALKER_NYCELLS = get_int(WALKER_NYCELLS,STRING);
		break;
	    case i_set_xyz_zcells:
		sprintf(STRING,"Number of bulk cells in z-direction [%1d]: ",
			WALKER_NZCELLS);
		WALKER_NZCELLS = get_int(WALKER_NZCELLS,STRING);
		break;
	    case i_set_xyz_second:
		sprintf(STRING,"Select surface cell to display: 1=first, 2=second [%1d]: ", 
			WALKER_SECOND);
		tmp = WALKER_SECOND;
		WALKER_SECOND = get_int(WALKER_SECOND,STRING);
		while ((WALKER_SECOND < 1) || (WALKER_SECOND > 2))
		    {
		    WALKER_SECOND = tmp;
		    errtype("ERROR! Value must be 1 or 2");
		    WALKER_SECOND = get_int(WALKER_SECOND,STRING);
		    }
		break;
	    case i_set_xyz_list:
		sprintf(STRING,"Number of cells in x-direction: %d\n",
			WALKER_NXCELLS);
		type_line(STRING);
		sprintf(STRING,"Number of cells in y-direction: %d\n",
			WALKER_NYCELLS);
		type_line(STRING);
		sprintf(STRING,"Number of bulk cells in z-direction: %d\n",
			WALKER_NZCELLS);
		type_line(STRING);
		switch (WALKER_SECOND)
		    {
		    case 1:
			type_line("Output of first unit cell.\n");
			break;
		    case 2:
			type_line("Output of second unit cell.\n");
			break;
			/*
			  case 3:
			  type_line("Output of both first and second surface cells.\n");
			  break;
			*/
		    }
		break;
	    case i_set_xyz_help:
		list_menu("SET XYZ MENU",set_xyz_menu,set_xyz_length);
		break;
	    case i_set_xyz_return:
		stop = TRUE;
	    }
	}
    }



/***************************************************************************/
int walker_write_xyz(char *filename)
/***************************************************************************/
    {
    /* 
     * If filename == NULL writes the xyz co-ordinates to the screen, otherwis
     * opens a file with name "filename" and writes the co-ordinates to this
     * file.
     *
     * Written by Olof Svensson after a suggestion from Christopher J. Walker 
     * November 2000
     *
     */
    
    int     i, terminal;
    char    comments[100];
    FILE    *listfile;
    
    if (filename == NULL) 
	{
	terminal = TRUE;
	type_list("", 0);
	}
    else
	{
	terminal = FALSE;
	if ((listfile = fopen(filename,"w")) == NULL)
	    {
	    sprintf(STRING,"Error, failed to open '%s'",filename);
	    errtype(STRING);
	    clear_command();
	    return 1;
	    }
	}

    /* First line of xyz file is a comment line */
    sprintf(comments, "temp xyz file from rod for reading in to rasmol");
       
    switch (WALKER_SECOND)
	{
	case 1:
	    calc_atoms_orth_coord(WALKER_NXCELLS, 
				  WALKER_NYCELLS, 
				  WALKER_NZCELLS, 1);
	    break;
	case 2:
	    if ((NSURF2 > 0) || (NGROUPSS2 != 0))
		calc_atoms_orth_coord(WALKER_NXCELLS, 
				      WALKER_NYCELLS, 
				      WALKER_NZCELLS, 2);
	    else
		{
		errtype("ERROR - no atoms in the second surface cell.");
		return;
		}
	    break;
	}
    
    sprintf(STRING, "%d\n", NORTHONORMAL);
    
    if (terminal)
	type_list(STRING,ROWS);
    else
	{
	fprintf(listfile,"%s",STRING);
	fprintf(listfile,"%s\n",comments);
	}
    
    for (i=0; i<NORTHONORMAL; i++)
	{
	sprintf(STRING,
		"%2s %8.5f  %8.5f  %8.5f \n",
		ELEMENT[TORTHONORMAL[i]],
		XORTHONORMAL[i],
		YORTHONORMAL[i],
		ZORTHONORMAL[i]);
	if (terminal) type_list(STRING,ROWS);
	else fprintf(listfile,"%s",STRING);
	}
    
    if (!terminal) fclose(listfile);
    
    return 0;

    }

/***************************************************************************/
void walker_send_xyz_to_rasmol(void)
/***************************************************************************/
    {

    /* Write temporary file */

    if (walker_write_xyz(RASMOL_FILE))
	{
	errtype("ERROR, couldn't write to temporary xyz file"); 
	return;
	}

    /* Now send commands to rasmol */

    if (walker_send_cmd_to_rasmol("zap\n") == -1)
	{
	clear_command();
	return;
	}
    sprintf(STRING, "load xyz %s\n", RASMOL_FILE);
    if( walker_send_cmd_to_rasmol(STRING) == -1)
	{
	clear_command();
	return;
	}
    }


/***************************************************************************/
void    walker_set_menu(void)
/***************************************************************************/   
    /*
      Walker extension set menu
    */
     
    {
    enum walker_set 
	{
	i_walker_set_null,
	i_walker_set_rasmol,
	i_walker_set_xyz,
	i_walker_set_help,
	i_walker_set_return,
	walker_set_length=i_walker_set_return
	};
    
    int     stop = FALSE;
    char    token[100], comments[100];
    static struct   MENU walker_set_menu[walker_set_length] =
	{
	"rasmol",   2,  i_walker_set_rasmol,  "Setup of Rasmol connection",
	"xyz",      1,  i_walker_set_xyz,     "setup of xyz output",
	"help",     1,  i_walker_set_help,    "Display menu",
	"return",   1,  i_walker_set_return,  "Return to main menu"
	};

    while (!stop)
	{
	if (!get_token(token,"ROD.EXT.WAL.SET>")) break;
	switch (cmnd_match(token,walker_set_menu,walker_set_length))
	    {
	    case -1:
		break;
	    case i_walker_set_null:
		break;
	    case i_walker_set_rasmol:
		walker_set_rasmol();
		break;
	    case i_walker_set_xyz:
		walker_set_xyz();
		break;
	    case i_walker_set_help:
		list_menu("WALKER MENU",walker_set_menu,walker_set_length);
		break;
	    case i_walker_set_return:
		stop = TRUE;
	    }
	}
    }



/***************************************************************************/
void    walker_rasmol_menu(void)
/***************************************************************************/   
    /*
      Rasmol menu
    */
     
    {
    enum i_rasmol_menu 
	{
	i_rasmol_null,
	i_rasmol_list,
	i_rasmol_write,
	i_rasmol_display,
	i_rasmol_command,
	i_rasmol_help,
	i_rasmol_return,
	i_rasmol_length=i_rasmol_return
	};
    

    int     stop = FALSE;
    char    token[100], comments[100];
    static struct   MENU rasmol_menu[i_rasmol_length] =
	{
	"list",     1,  i_rasmol_list,    "List structure",
	"write",    1,  i_rasmol_write,   "Write structure to xyz file",
	"display",  1,  i_rasmol_display, "Display structure in rasmol",
	"command",  1,  i_rasmol_command, "Send command to rasmol",
	"help",     1,  i_rasmol_help,    "Display menu",
	"return",   1,  i_rasmol_return,  "Return to main menu"
	};

    while (!stop)
	{
	if (!get_token(token,"ROD.EXT.WAL.RAS>")) break;
	switch (cmnd_match(token,rasmol_menu,i_rasmol_length))
	    {
	    case -1:
		break;
	    case i_rasmol_null:
		break;
	    case i_rasmol_list:
		walker_write_xyz(NULL);
		break;
	    case i_rasmol_write:
		walker_write_xyz(RASMOL_FILE    );
		break;
	    case i_rasmol_display:
		walker_send_xyz_to_rasmol();
		break;
	    case i_rasmol_command:
		walker_rasmol_cmd();
		break;
	    case i_rasmol_help:
		list_menu("RASMOL MENU",rasmol_menu,i_rasmol_length);
		break;
	    case i_rasmol_return:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    walker_set_rasmol(void)
/***************************************************************************/

    /*
    Set rasmol menu.
    */

    {
    enum i_s_menu 
	{
	i_s_rasmol_null,
	i_s_rasmol_filename,
	i_s_rasmol_host,
	i_s_rasmol_port,
	i_s_rasmol_list,
	i_s_rasmol_help,
	i_s_rasmol_return,
	i_s_rasmol_length=i_s_rasmol_return
	};


    static struct MENU set_rasmol_menu[i_s_rasmol_length] =
	{
	"filename",1,i_s_rasmol_filename,"Name of temp xyz file read into rasmol",
	"host",  2, i_s_rasmol_host,"Hostname of rasmol (usually localhost)",
	"port",  1, i_s_rasmol_port,"Port to connect to rasmol (usually 21069)",
	"list",  1, i_s_rasmol_list, "List rasmol parameters",
	"help",  1, i_s_rasmol_help, "Help",
	"return",1, i_s_rasmol_return, "Return to last menu"
	};


    int     stop = FALSE;
    char    token[100];

    while (!stop)
	{
	if (!get_token(token,"ROD.EXT.WAL.SET.RASMOL>")) break;
	switch (cmnd_match(token,set_rasmol_menu,i_s_rasmol_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case i_s_rasmol_filename:
		sprintf(STRING,"Rasmol temp file name [%s]: ", RASMOL_FILE);
		get_string(RASMOL_FILE, STRING);
		break;
	    case i_s_rasmol_host:
		sprintf(STRING,"Host rasmol is running on [%s]: ", RASMOL_HOST);
		get_string(RASMOL_HOST, STRING);
		break;
	    case i_s_rasmol_port:
		sprintf(STRING,"Port rasmol listens on [%1s]: ", RASMOL_PORT);
		get_string(RASMOL_PORT, STRING);
		break;
	    case i_s_rasmol_list:
		/* list menu parameters */
		sprintf(STRING, "rasmol host: %s\n", RASMOL_HOST);
		type_line(STRING);

		sprintf(STRING,
			"rasmol port: %s\n",RASMOL_PORT);
		type_line(STRING);
		sprintf(STRING, "Rasmol xyz file: %s\n", RASMOL_FILE);
		type_line(STRING);
		break;

	    case i_s_rasmol_help:
		list_menu("SET RASMOL MENU",set_rasmol_menu,i_s_rasmol_length);
		break;
	    case i_s_rasmol_return:
		stop = TRUE;
		break;
	    }
	}
    }



/***************************************************************************/
void walker_rasmol_cmd(void)
/***************************************************************************/
    {
    int   terminal = FALSE;
    char  command_line[129];
    char  STRING[200];

    get_string(command_line,"ROD.EXT.WAL.RAS.CMD>");
    if (strlen(command_line) != 0)
	strcpy(STRING,command_line);
    
    /* now send command to rasmol with standard routine */
  
    walker_send_cmd_to_rasmol(STRING);
    }


/***************************************************************************/
int walker_send_cmd_to_rasmol(char *rasmol_command)
/***************************************************************************/
    {
    /* sent a string on the input.
       returns -1 for error 
       returns  length of command for success
       input char * rasmol_command - the command you want to send to rasmol
    */
    int sock;
    int connected = 1;
    int sockwriteresult;  
    char *host = RASMOL_HOST;
    char *port = RASMOL_PORT;
    

    ignore_pipe();
    sock = make_connection(port, SOCK_STREAM, host);
    if (sock == -1) {
    errtype("ERROR, Can't find running rasmol");
    errtype("ERROR, Start rasmol in the same dir as rod.\n");
    return sock;
    }

    sockwriteresult= sock_puts(sock,rasmol_command);
    close(sock);
    return sock;
    }

/***************************************************************************/
int walker_write_initmac(FILE *init_mac)
/***************************************************************************/
    {
    /* Write Walker extensions parameters to initialisation macro 
       This means I don't have to keep activating the walker extensions
       Every time I use rod
    */
    /* Return TRUE if there are no problems
       should probably return false (or -1?)
       if problems, but havn't implemented this yet.
    */

    /* Rasmol parameters */
    fprintf(init_mac, "! Activate Walker's extension\n");
    fprintf(init_mac, "ext walker activate yes set rasmol ");
    fprintf(init_mac, "file %s \n ", RASMOL_FILE);
    fprintf(init_mac, "port %s \n", RASMOL_PORT);
    fprintf(init_mac, "host %s \n", RASMOL_HOST);
    fprintf(init_mac, "return return return return\n");
    /* now do xyz format */
    fprintf(init_mac, "ext walker set xyz ");
    fprintf(init_mac, "xcells %d ycells %d zcells %d second %d\n", 
	    WALKER_NXCELLS, WALKER_NYCELLS, WALKER_NZCELLS, WALKER_SECOND);
    fprintf(init_mac, "return return return return\n");

    return TRUE;
    }


#endif /* EXTENSIONS Walker */

