/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$$$$$$                 svensson.h                          $$$$$$$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: svensson.h,v 1.13 2007/03/16 16:35:20 wilcke Exp $

****************************************************************************/

/*

Update 18/09/2003 O. Svensson (svensson@esrf.fr)
                  Added code written by Michael Dore for the "svensson"
                  extension (deformation of groups).
Update 17/09/2001 O. Svensson (svensson@esrf.fr)
                  Added missing function header for "svensson_init()".
Update 24/04/2001 O.Svensson (svensson@esrf.fr)
                  Added occupancy four groups.
Update 25/10/2000 O.Svensson (svensson@esrf.fr)
                  Added "#ifndef _SVENSSON_H_" etc.
                  Added function header for svensson_write_initmac.
		  Increased the maximum number of orthonormal atoms
		  from MAXATOMS to 10000 (MAXORTHONORMALATOMS).
Update 20/10/2000 O.Svensson (svensson@esrf.fr)
                  Increased the max number of atoms in a group to 1000.
                  Added declaration of PATFILNAME.
Update 29/09/2000 O.Svensson (svensson@esrf.fr)
                  Added dummy function headers for set_svensson,
                  set_svensson_parameters and svensson_update_model.
Update 20/09/2000 O.Svensson (svensson@esrf.fr)
                  Added NGROUPSS2 to represent the number of groups in
                  the second unit cell.

*/

#ifndef _SVENSSON_H_
#define _SVENSSON_H_

SET int svensson_flag; /* flag for using Svensson's extensions of ROD*/

PLOT char PATFILENAME[128];       /* Patterson output file */

#define MAXGROUPS          10     /* Max no of bulk or surface groups */
#define MAXATOMSPERGROUP 1000     /* Max no of atoms per group */

SET int NGROUPSS;                 /* No of groups */
SET int NGROUPSS2;                /* No of groups in second surface cell */

SET float XGROUPS[MAXGROUPS];     /* X-coordinates of surface groups */
SET float YGROUPS[MAXGROUPS];     /* Y-coordinates of surface groups */
SET float ZGROUPS[MAXGROUPS];     /* Z-coordinates of surface groups */
SET float PHIGROUPS[MAXGROUPS];   /* phi-coordinates of surface groups */
SET float CHIGROUPS[MAXGROUPS];   /* chi-coordinates of surface groups */
SET float THGROUPS[MAXGROUPS];    /* th-coordinates of surface groups */

SET float XGROUPSFIT[MAXGROUPS];  /* fitted X-coordinates of surface groups */
SET float YGROUPSFIT[MAXGROUPS];  /* fitted Y-coordinates of surface groups */
SET float ZGROUPSFIT[MAXGROUPS];  /* fitted Z-coordinates of surface groups */
SET float PHIGROUPSFIT[MAXGROUPS];/* fitted phi-coordinates of surface groups */
SET float CHIGROUPSFIT[MAXGROUPS];/* fitted chi-coordinates of surface groups */
SET float THGROUPSFIT[MAXGROUPS]; /* fitted th-coordinates of surface groups */

SET int NXDISGROUPS[MAXGROUPS];   /* X-coordinates of surface groups */
SET int NYDISGROUPS[MAXGROUPS];   /* Y-coordinates of surface groups */
SET int NZDISGROUPS[MAXGROUPS];   /* Z-coordinates of surface groups */
SET int NPHIDISGROUPS[MAXGROUPS]; /* phi-coordinates of surface groups */
SET int NCHIDISGROUPS[MAXGROUPS]; /* chi-coordinates of surface groups */
SET int NTHDISGROUPS[MAXGROUPS];  /* th-coordinates of surface groups */

SET char  NAMEOFGROUPS[MAXGROUPS][TITLE_LENGTH];     /* Name of groups */
SET int NATOMSINGROUPS[MAXGROUPS];                   /* No of atoms in groups */
SET float ORIGINOFATOMSINGROUPS[MAXGROUPS][3];       /* Origin of rotation */
SET char  ELSURFGROUPS[MAXGROUPS][TITLE_LENGTH][3];  /* Name of atoms in group */
SET int TATOMINGROUPS[MAXGROUPS][MAXATOMSPERGROUP];  /* atom type no */
SET float XATOMINGROUPS[MAXGROUPS][MAXATOMSPERGROUP]; /* x-coordinates of atoms */
SET float YATOMINGROUPS[MAXGROUPS][MAXATOMSPERGROUP]; /* y-coordinates of atoms */
SET float ZATOMINGROUPS[MAXGROUPS][MAXATOMSPERGROUP]; /* z-coordinates of atoms */
SET int NDWSATOMINGROUPS[MAXGROUPS][MAXATOMSPERGROUP]; /* Serial numbers of surface group Debye-Waller parameter */
SET float OCCUPANCYOFGROUPS[MAXGROUPS];  /* Occupancy factor */

FIT float DISPLGROUPS[MAXPAR];         /* Values of displacement parameters */
FIT float DISPLLIMGROUPS[MAXPAR][2];   /* Limits of displacement parameters */
FIT int	  DISPLPENGROUPS[MAXPAR];      /* Penalty factors for displacement
                                          parameters */
FIT int   NDISGROUPSTOT;               /* Total number of displacement
                                          parameters */
FIT float DEBWALGROUPS[MAXPAR];        /* Parallel Debye-Waller parameters */
FIT float DEBWALLIMGROUPS[MAXPAR][2];  /* Limits of DW parameters */
FIT int	  DEBWALPENGROUPS[MAXPAR];     /* Penalty factors of DW's */
FIT int   NDWGROUPSTOT;                /* Total no. of paral. DW params */

/* Cylinders */

#define   MAXCYLINDERS    10         /* Max no of cylinders */

SET int NCYLINDERS;                  /* No of cylinders */

SET float XCYLINDERS[MAXCYLINDERS];   /* X-coordinates of cylinders */
SET float YCYLINDERS[MAXCYLINDERS];   /* Y-coordinates of cylinders */
SET float ZCYLINDERS[MAXCYLINDERS];   /* Z-coordinates of cylinders */
SET float TCYLINDERS[MAXCYLINDERS];   /* t(tilt)-coordinates of cylinders */
SET float PSICYLINDERS[MAXCYLINDERS]; /* psi(azimut)-coordinates of cylinders */

SET float XCYLINDERSFIT[MAXCYLINDERS]; /* fitted X-coordinates of cylinders */
SET float YCYLINDERSFIT[MAXCYLINDERS]; /* fitted Y-coordinates of cylinders */
SET float ZCYLINDERSFIT[MAXCYLINDERS]; /* fitted Z-coordinates of cylinders */
SET float TCYLINDERSFIT[MAXCYLINDERS]; /* fitted t-coordinates of cylinders */
SET float PSICYLINDERSFIT[MAXCYLINDERS];/* fitted psi-coordinates of cylinders */

SET char  NAMEOFCYLINDERS[MAXCYLINDERS][TITLE_LENGTH]; /* Name of cylinder */
SET float ORIGINOFCYLINDERS[MAXCYLINDERS];  /* z-coordinate for origin of rotation */
SET float CHARGEOFCYLINDERS[MAXCYLINDERS];  /* No of electrons in cylinder */
SET float LENGTHOFCYLINDERS[MAXCYLINDERS];    /* Length of cylinder */
SET float RADIUSOFCYLINDERS[MAXCYLINDERS];    /* Radius of cylinder */
SET float SOFTNESSOFCYLINDERS[MAXCYLINDERS];  /* Softness of cylinder */
SET float OCCUPOFCYLINDERS[MAXCYLINDERS];  /* Softness of cylinder */

SET float LENGTHOFCYLINDERSFIT[MAXCYLINDERS];    /* Length of cylinder */
SET float RADIUSOFCYLINDERSFIT[MAXCYLINDERS];    /* Radius of cylinder */
SET float SOFTNESSOFCYLINDERSFIT[MAXCYLINDERS];  /* Softness of cylinder */
SET float OCCUPOFCYLINDERSFIT[MAXCYLINDERS];     /* Occupancy of cylinder */

SET int NXDISCYLINDERS[MAXCYLINDERS];      /* X-displacement serial numbers */
SET int NYDISCYLINDERS[MAXCYLINDERS];      /* Y-displacement serial numbers */
SET int NZDISCYLINDERS[MAXCYLINDERS];      /* Z-displacement serial numbers */
SET int NTDISCYLINDERS[MAXCYLINDERS];      /* CHI-displacement serial numbers */
SET int NPSIDISCYLINDERS[MAXCYLINDERS];    /* TH-displacement serial numbers */
SET int NLENGTHOFCYLINDERS[MAXCYLINDERS];  /* Length serial number */
SET int NRADIUSOFCYLINDERS[MAXCYLINDERS];  /* Radius serial number */
SET int NSOFTNESSOFCYLINDERS[MAXCYLINDERS];/* Softness serial number */
SET int NOCCUPOFCYLINDERS[MAXCYLINDERS];   /* Occupancy serial number */

FIT float DISPLCYLINDERSPAR[MAXPAR];               /* Values of displacement
                                                      parameters */
FIT float DISPLLIMCYLINDERSPAR[MAXPAR][2];         /* Limits of displacement
                                                      parameters */
FIT int	  DISPLPENCYLINDERSPAR[MAXPAR];            /* Penalty factors for
                                                      displacement pars */
FIT int   NDISCYLINDERSTOT;                        /* Total number of
                                                      displacement parameters */
FIT float CHARGEDENSITYOFCYLINDERSPAR[MAXPAR];     /* Length of cylinder */ 
FIT float CHARGEDENSITYLIMCYLINDERSPAR[MAXPAR][2]; /* Limits of lengths */
FIT int	  CHARGEDENSITYPENCYLINDERSPAR[MAXPAR];    /* Penalty factors of
                                                      lengths */
FIT int   NCHARGEDENSITYCYLINDERSTOT;              /* Total no. of lengths */


/* Ellipsoids */

#define   MAXELLIPSOIDS    10         /* Max no of ellipsoids */

SET int NELLIPSOIDS;                  /* No of ellipsoids */

SET float XELLIPSOIDS[MAXELLIPSOIDS];   
SET float YELLIPSOIDS[MAXELLIPSOIDS];   
SET float ZELLIPSOIDS[MAXELLIPSOIDS];   
SET float PHIELLIPSOIDS[MAXELLIPSOIDS]; 
SET float CHIELLIPSOIDS[MAXELLIPSOIDS]; 
SET float THELLIPSOIDS[MAXELLIPSOIDS];  

SET float XELLIPSOIDSFIT[MAXELLIPSOIDS]; 
SET float YELLIPSOIDSFIT[MAXELLIPSOIDS]; 
SET float ZELLIPSOIDSFIT[MAXELLIPSOIDS]; 
SET float PHIELLIPSOIDSFIT[MAXELLIPSOIDS];
SET float CHIELLIPSOIDSFIT[MAXELLIPSOIDS];
SET float THELLIPSOIDSFIT[MAXELLIPSOIDS];

SET char  NAMEOFELLIPSOIDS[MAXELLIPSOIDS][TITLE_LENGTH]; 
SET float CHARGEOFELLIPSOIDS[MAXELLIPSOIDS];  
SET float ALENGTHOFELLIPSOIDS[MAXELLIPSOIDS];    
SET float BLENGTHOFELLIPSOIDS[MAXELLIPSOIDS];    
SET float CLENGTHOFELLIPSOIDS[MAXELLIPSOIDS];    
SET float SOFTNESSOFELLIPSOIDS[MAXELLIPSOIDS];  
SET float OCCUPOFELLIPSOIDS[MAXELLIPSOIDS];  

SET float ALENGTHOFELLIPSOIDSFIT[MAXELLIPSOIDS];    
SET float BLENGTHOFELLIPSOIDSFIT[MAXELLIPSOIDS];    
SET float CLENGTHOFELLIPSOIDSFIT[MAXELLIPSOIDS];    
SET float SOFTNESSOFELLIPSOIDSFIT[MAXELLIPSOIDS];  
SET float OCCUPOFELLIPSOIDSFIT[MAXELLIPSOIDS];  

SET int NXDISELLIPSOIDS[MAXELLIPSOIDS];   
SET int NYDISELLIPSOIDS[MAXELLIPSOIDS];   
SET int NZDISELLIPSOIDS[MAXELLIPSOIDS];   
SET int NPHIDISELLIPSOIDS[MAXELLIPSOIDS]; 
SET int NCHIDISELLIPSOIDS[MAXELLIPSOIDS]; 
SET int NTHDISELLIPSOIDS[MAXELLIPSOIDS];  
SET int NALENGTHOFELLIPSOIDS[MAXELLIPSOIDS];    
SET int NBLENGTHOFELLIPSOIDS[MAXELLIPSOIDS];    
SET int NCLENGTHOFELLIPSOIDS[MAXELLIPSOIDS];    
SET int NSOFTNESSOFELLIPSOIDS[MAXELLIPSOIDS];  
SET int NOCCUPOFELLIPSOIDS[MAXELLIPSOIDS];  

FIT float   DISPLELLIPSOIDSPAR[MAXPAR];          
FIT float   DISPLLIMELLIPSOIDSPAR[MAXPAR][2];    
FIT int	    DISPLPENELLIPSOIDSPAR[MAXPAR];       
FIT int     NDISELLIPSOIDSTOT;                   
FIT float   CHARGEDENSITYOFELLIPSOIDSPAR[MAXPAR];       
FIT float   CHARGEDENSITYLIMELLIPSOIDSPAR[MAXPAR][2];   
FIT int	    CHARGEDENSITYPENELLIPSOIDSPAR[MAXPAR];      
FIT int     NCHARGEDENSITYELLIPSOIDSTOT;                


SET float MMATRIX[3][3];        /* Matrix for coordinate transformations */
SET float MINVMATRIX[3][3];     /* Matrix for coordinate transformations */
SET float MSTARINVMATRIX[3][3]; /* Matrix for reciprocal coordinate transformations */
SET float RMATRIX[3][3];        /* Matrix for rotation */
SET float RINVMATRIX[3][3];     /* Matrix for inverse rotation */


/* Symmetry cards */

#define ATOMEPS           0.001  /* Distance at which atoms are considered */
                               /* to be overlapped */
#define MAXSYMMCARDS      48

SET  int NSYMMCARDS;
SET  int NORTHONORMAL;           /* Number of orthonormalized atoms */

SET float SYMMATOMS[MAXSYMMCARDS][3];
SET int   SYMMTABLEXYZ[MAXSYMMCARDS][3];
SET float SYMMTABLEADD[MAXSYMMCARDS][3];

#define MAXORTHONORMALATOMS 10000

SET float XORTHONORMAL[MAXORTHONORMALATOMS];
SET float YORTHONORMAL[MAXORTHONORMALATOMS];
SET float ZORTHONORMAL[MAXORTHONORMALATOMS];
SET int TORTHONORMAL[MAXORTHONORMALATOMS];

/*
LFLAGS void calculate_transformation_matrices();
LFLAGS void calculate_rotation_matrix(float phi, float chi, float th);
LFLAGS void calculate_inverse_rotation_matrix(float phi, float chi, float th);
LFLAGS void calc_orthogonal_coordinates(float xa, float yb, float zc, 
    float *x, float *y, float *z);
LFLAGS void calc_crystal_coordinates(float x, float y, float z, 
    float *xa, float *yb, float *zc);
LFLAGS void calc_rotated_coordinates(float x_atom, float y_atom, float z_atom,
    float *x_rot, float *y_rot, float *z_rot);

LFLAGS float cylinder_scattering_factor(float qx, float qy, float qz, 
    float chi, float theta,
    float charge, float length, 
    float radius, float softness, float occupancy);

LFLAGS float ellipsoid_scattering_factor(float qx, float qy, float qz, 
    float phi, float chi, float theta,
    float charge, float a_axis, float b_axis,
    float c_axis, float softness, float occupancy);
LFLAGS int calc_symm_coord(float x_frac, float y_frac, float z_frac);
LFLAGS void calc_atoms_orth_coord(int xcell, int ycell, int zcell, int cell);
*/


void svensson(void);
void set_svensson(void);
void svensson_init(void);
void calculate_transformation_matrices();
void calculate_rotation_matrix(float phi, float chi, float th);
void calculate_inverse_rotation_matrix(float phi, float chi, float th);
void calc_orthogonal_coordinates(float xa, float yb, float zc, 
    float *x, float *y, float *z);
void calc_crystal_coordinates(float x, float y, float z, 
    float *xa, float *yb, float *zc);
void calc_reciprocal_orthogonal_coordinates(float h, float k, float l, 
    float *qx, float *qy, float *qz);
void calc_rotated_coordinates(float x_atom, float y_atom, float z_atom, 
    float *x_rot, float *y_rot, float *z_rot);
float cylinder_scattering_factor(float h, float k, float l, 
    float t, float psi,
    float charge, float length, 
    float radius, float softness, float occupancy);
float ellipsoid_scattering_factor(float h, float k, float l, 
    float phi, float chi, float th,
    float charge, float a, float b, float c, 
    float softness, float occupancy);
int calc_symm_coord(float x_frac, float y_frac, float z_frac);
void calc_atoms_orth_coord(int xcell, int ycell, int zcell, int cell);
int get_ngroup(char *prompt);
int get_natom_group(char *prompt, int ngroup);
int get_ncylinder(char *prompt);
int get_nellipsoid(char *prompt);
void set_group(void);
void set_cylinder(void);
void set_ellipsoid(void);
void set_xyz(void);

void bulk_mult(void);
void overlap_check(void);
void symm_info(void);

int signum(int value);
void read_cylinder_fit(FILE *infile, char *cylinder_name);
void read_ellipsoid_fit(FILE *infile, char *ellipsoid_name);
void read_group_fit(FILE *infile, char *group_name,
		    float xorg, float yorg, float zorg, float occupancy);
int parse_symmetry_card();
void read_ellipsoid_surf(FILE *infile, char *ellipsoid_name);
void read_cylinder_surf(FILE *infile, char *cylinder_name);
void read_group_surf(FILE *infile, char *group_name,
		    float xorg, float yorg, float zorg, float occupancy);
void list_symm_cards(int terminal, FILE *listfile);
void list_groups_cylindes_ellipsoids_smodel(int terminal, FILE *listfile);
void list_groups_cylindes_ellipsoids_fit(int terminal, FILE *listfile);
void util_symm_info();
void    f_surf_svensson(float h, float k, float l, float fat[],
			float dw_par[], float dw_perp[], float dw[], float dw_group[],
			int cell, float re_surf[], float im_surf[]);
void set_svensson_parameters(void);
void svensson_update_model(void);
int svensson_write_initmac(FILE *init_mac);

/**************************  mik part  *****************************/

SET float XATOMINGROUPSFIT[MAXGROUPS][MAXATOMSPERGROUP];
/* fitted x-coordinates of atom */
SET float YATOMINGROUPSFIT[MAXGROUPS][MAXATOMSPERGROUP];
/* fitted y-coordinates of atom */
SET float ZATOMINGROUPSFIT[MAXGROUPS][MAXATOMSPERGROUP];
/* fitted z-coordinates of atom */
SET float ORIGINOFATOMSINGROUPSFIT[MAXGROUPS][3];
/* fitted coordinates of the origin of rotation */

SET int SNEXPX[MAXGROUPS];    /* serial number of x-expansion of group */
SET int SNEXPY[MAXGROUPS];    /* serial number of y-expansion of group */
SET int SNEXPZ[MAXGROUPS];    /* serial number of z-expansion of group */
SET int SNSHEARXY[MAXGROUPS]; /* serial number of xy-shearing of group */
SET int SNSHEARZX[MAXGROUPS]; /* serial number of zx-shearing of group */
SET int SNSHEARYZ[MAXGROUPS]; /* serial number of yz-shearing of group */

void mik(void);
void mik_deform_group(void);

void replace_originofatoms(int ngroup);
void replace_atoms(int ngroup);
float center_atoms_group(int ngroup,int comp);
float max_dist(float center,int ngroup,int comp);
float calc_comp_th(int choice,int ngroup,float d1,float d2);

SET int consvolexpan[MAXGROUPS];
SET int choicecenterexpan;
SET float exp_center[MAXGROUPS][3]; /* center of the expansion */

FIT int NEXPANGROUPSTOT;  /* total number of expansion */
FIT int NSHEARGROUPSTOT;  /* total number of shearing */

FIT struct
 {
  float defgroups[MAXPAR];
  float deflimgroups[MAXPAR][2];
  int defpengroups[MAXPAR];
  }
  func_deform[2];	
/*
func_deform[0] = expansion
func_deform[1] = shearing
*/

#endif /* _SVENSSON_H_ */
