
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                        svensson.c                             $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: svensson.c,v 1.24 2004/01/19 16:56:10 wilcke Exp $

****************************************************************************/

/*
Update 19/01/2004 R. Wilcke (wilcke@esrf.fr) 
                  removed declarations of fopen() (is declared in "stdio.h").
Update 18/09/2003 O. Svensson (svensson@esrf.fr)
                  Added code written by Michael Dore for the "svensson"
                  extension (deformation of groups).
Update 9/11/2002  C.J.Walker <walker@esrf.fr>
                  Changed h k  in bulk multiplicity to a and b.
Update 26/03/2002 R. Wilcke (wilcke@esrf.fr)
                  set_svensson(), set_cylinder(): changed abbreviations for menu
                  commands to the agreed set.
Update 24/04/2001 O.Svensson (svensson@esrf.fr)
                  Added occupancy four groups.
Update 15/02/2001 O.Svensson (svensson@esrf.fr)
                  Fixed bug in overlap_check().
		  Removed 'lrange', changed "type_line(STRING)" to
		  "type_list(STRING,ROWS)" in simulation output.
Update 30/10/2000 O.Svensson (svensson@esrf.fr)
                  Changed "type_line(STRING)" to "type_list(STRING,ROWS)"
                  in "set_group" where I missed to change.
Update 27/10/2000 O.Svensson (svensson@esrf.fr)
                  Changed "type_line(STRING)" to "type_list(STRING,ROWS)"
                  in listings for set_group, set_cylinders and 
                  set_ellipsoids.
Update 25/10/2000 O.Svensson (svensson@esrf.fr)
                  Added new functions svensson_init() and 
		  svensson_write_initmac().
                  Modified the call to calc_atoms_orth_coord(), now
		  is passed the number of bulk cells and which of the 
		  two surface cell that should be output.
Update 02/10/2000 O.Svensson (svensson@esrf.fr)
                  Spelling mistake correction, desactivte -> deactivate
Update 29/09/2000 O.Svensson (svensson@esrf.fr)
                  Added "set" sub-menu, moved the "groups", "ellipsoids"
		  and "cylinders" to this menu. Added new menu
		  "set_svensson_parameters", added function
		  "svensson_update_model".
Update 26/09/2000 O.Svensson (svensson@esrf.fr)
                  Fixed simulation output, re-indented the whole file.
                  Changed "unit cell" to "surface cell" in listings
                  of groups.
Update 20/09/2000 O.Svensson (svensson@esrf.fr)
                  Added the possibility of having different groups in the
                  first and second surface cells.
Update 12/09/2000 O.Svensson (svensson@esrf.fr)
                  Fixed a couple of bugs in the "bulk_mult" procedure.
Update 19/07/2000 R. Wilcke (wilcke@esrf.fr)
                  replaced everywhere the buffer size for filenames by
                  the ISO-C defined macro FILENAME_MAX.

*/

/***************************************************************************

   	- activates/deactivate Svensson's extension
	- for this extension :
            * Groups
            * Cylinders
            * Ellipsoids
            * Bulk multiplicity
            * Overlap check  

****************************************************************************/

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#include <ctype.h>
#include <stdio.h>
#define SET
#include "rod.h"

#ifdef EXTENSIONS

/* main part */

/***************************************************************************/
void    svensson(void)
/***************************************************************************/

/*    Svensson's extension menu.    */
    {
    /* define svensson menu */
	
    static struct MENU svensson_menu[] =
	{
	"activate", 1,  1,  "activate/deactivate Svensson's extension",
	"set",      1,  2,  "Set parameters for Svensson's extension",
        "bulkmult", 1,  3,  "Expand bulk unit cell",
        "overlap",  1,  4,  "Check for overlapping atoms",
/*	"lrange",   2,  5,  "Calculate f's for range of h, k and l",  */
	"simdata",  2,  6,  "Sum output for simulation",
	"help",     1, 20,  "Display menu",
	"return",   1, 21,  "Return to main menu"
	};

    /* number of commands in svensson menu */
    int svensson_length = sizeof(svensson_menu) / 
	sizeof(svensson_menu[0]);

    int     stop = FALSE;
    float               lstep;
    static float        hstart,hend,hstep,kstart,kend,kstep,l;
    int                 i,j,jj,atom1,atom2,atom3;
    FILE    *listfile;
    int     terminal;
    char    filename[FILENAME_MAX],extension[10];
    int     switch_code;
    int     nxyz, xcell, ycell;
    char    token[100], comments[100];

    while (!stop)
	{
	if (!get_token(token,"ROD.EXT.SVE>")) break;
	switch (cmnd_match(token,svensson_menu,svensson_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		sprintf(STRING,"Activate Svensson's extensions ? [%s]: ", 
			yesnostr(svensson_flag));
		svensson_flag = yesno(svensson_flag,STRING);
		break;
	    case 2:
		if (svensson_flag == 0)
		    {
		    errtype("ERROR, Svensson's extension deactivated");
		    clear_command();
		    } else
			{
			set_svensson();
			}
		break;
	    case 3:
		if (svensson_flag == 0)
		    {
		    errtype("ERROR, Svensson's extension deactivated");
		    clear_command();
		    } else
			{
			bulk_mult();
			}
		break;
	    case 4:
		if (svensson_flag == 0)
		    {
		    errtype("ERROR, Svensson's extension deactivated");
		    clear_command();
		    } else
			{
			overlap_check();
			}
		break;
	    case 5:     /* Calculate structure factors for range of h,k and l*/
		if (svensson_flag == 0)
		    {
		    errtype("ERROR, Svensson's extension deactivated");
		    clear_command();
		    break;
		    }
		else
		    {

		    /* Input range of h and k */

		    sprintf(STRING,"Start value of Miller index h [%3.1f]: ",
			    hstart);
		    hstart = get_real(hstart,STRING);
		    sprintf(STRING,"End value of Miller index h [%3.1f]: ",hend);
		    hend = get_real(hend,STRING);
		    sprintf(STRING,"Step size of Miller index h [%3.1f]: ",
			    hstep);
		    hstep = get_real(hstep,STRING);
		    if (fabs(hstep) < 0.1)
			{
			errtype("ERROR, too small step size");
			clear_command();
			break;
			}
		    sprintf(STRING,"Start value of Miller index k [%3.1f]: ",
			    kstart);
		    kstart = get_real(kstart,STRING);
		    sprintf(STRING,"End value of Miller index k [%3.1f]: ",kend);
		    kend = get_real(kend,STRING);
		    sprintf(STRING,"Step size of Miller index k [%3.1f]: ",
			    kstep);
		    kstep = get_real(kstep,STRING);
		    if (fabs(kstep) < 0.1)
			{
			errtype("ERROR, too small step size");
			clear_command();
			break;
			}
		    lstep = (LEND-LSTART)/(NL-1);

		    /* loop through the range */

		    NTH = 0;
		    for (i = 0; (i <= (int) fabs((hend-hstart)/hstep+0.5))
			     && (NTH < MAXTHEO); i++)
			{
			for (j = 0; (j <= (int) fabs((kend-kstart)/kstep+0.5))
				 && (NTH < MAXTHEO); j++)
			    {
			    for (jj = 0; jj < NL; jj++)
				{
				HTH[NTH] = hstart+hstep*i;
				KTH[NTH] = kstart+kstep*j;
				LTH[NTH] = LSTART+lstep*jj;
				f_calc(HTH[NTH],KTH[NTH],LTH[NTH],ATTEN,LBRAGG,
				       &FTH[0][NTH],&FTH[1][NTH],&FTH[2][NTH],&PHASE[NTH]);
				NTH++;
				//if ((fabs(HTH[NTH]) < 0.1) && (fabs(KTH[NTH]) < 0.1))
				//  NTH--;
				}
			    }
			}
		    }
		break;
	    case 6:   /* list simulation output */
		if (svensson_flag == 0)
		    {
		    errtype("ERROR, Svensson's extension deactivated");
		    clear_command();
		    break;
		    }
		else
		    {
		    /* Ask for filename */
		    sprintf(extension, "dat");
		    sprintf(STRING,"Filename (.%s) (type 't' or <return> for terminal): ",
			    extension);
		    if (!get_token(filename,STRING))
			{
			terminal = TRUE;
			}
		    else if (((filename[0] == 't') || (filename[0] == 'T')) &&
			     (filename[1] == '\0'))
			{
			terminal = TRUE;
			}
		    else
			{
			terminal = FALSE;
			add_extension(filename,"dat");
			if ((listfile = fopen(filename,"w")) == NULL)
			    {
			    sprintf(STRING,"Error, failed to open '%s'",filename);
			    errtype(STRING);
			    clear_command();
			    return;
			    }
			else
			    {
			    get_string(STRING,"Comments: ");
			    if (switch_code != 10) fprintf(listfile,"%s\n",STRING);
			    else fprintf(listfile,"!%s\n",STRING);
			    }
			}
		    
		    /* Do the actual listing */
		    
		    if (terminal) type_list(STRING,0);

		    if (terminal)
			{
			sprintf(STRING,"%6s %6s %6s %11s %8s\n",
				"h","k","l","f-sum","sqrt(f-sum)");
			type_list(STRING,ROWS);
			}
		    for (i = 0; i < NTH; i++)
			{
			sprintf(STRING,"%6.3f %6.3f %6.3f %11.5f %8.2f\n",
				HTH[i],KTH[i],LTH[i],FTH[2][i],sqrt(FTH[2][i]));
			if (terminal) type_list(STRING,ROWS);
			else fprintf(listfile,"%s",STRING);
			}
		    }
		break;
	    
	    case 20:
		list_menu("SVENSSON MENU",svensson_menu,svensson_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    }


/***************************************************************************/
void    svensson_init(void)
/***************************************************************************/
    {

    NGROUPSS = 0;
    NCYLINDERS = 0;
    NELLIPSOIDS = 0;
    NSYMMCARDS = 1;
    NDISGROUPSTOT = 0;
    NDWGROUPSTOT = 0;
    NDISCYLINDERSTOT = 0;
    NCHARGEDENSITYCYLINDERSTOT = 0;
    NDISELLIPSOIDSTOT = 0;
    NCHARGEDENSITYELLIPSOIDSTOT = 0;
    NEXPANGROUPSTOT=0;
    NSHEARGROUPSTOT=0;
    SYMMTABLEXYZ[0][0] = +1;
    SYMMTABLEXYZ[0][1] = +2;
    SYMMTABLEXYZ[0][2] = +3;
    SYMMTABLEADD[0][0] = 0.0;
    SYMMTABLEADD[0][1] = 0.0;
    SYMMTABLEADD[0][2] = 0.0;

    sprintf(PATFILENAME,"pat");
    }


/***************************************************************************/
void    set_svensson(void)
/***************************************************************************/

    /*
    Set menu.
    */

    {

    /* define set_svensson_menu */

    static struct   MENU set_svensson_menu[] =
	{
	"group",     1,  1,  "Model par. for fitting group(s)",
	"cylinder",  2,  2,  "Model par. for fitting cylinder(s)",
	"ellipsoid", 1,  3,  "Model par. for fitting ellipsoid(s)",
	"parameters",2,  4,  "Values of fit parameters",
	"deform",    1,  5,  "Deformation",    
	"help",      1,  20, "Display menu",
	"return",    1,  21, "Return to main menu"
	};

    /* number of commands in set_svensson menu */
    int set_svensson_length = sizeof(set_svensson_menu) / 
	sizeof(set_svensson_menu[0]);

    int     stop = FALSE;
    char    token[100];

    while (!stop)
	{
	if (!get_token(token,"ROD.EXT.SVE.SET>")) break;
	switch (cmnd_match(token,set_svensson_menu,set_svensson_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		set_group();
		break;
	    case 2:
		set_cylinder();
		break;
	    case 3:
		set_ellipsoid();
		break;
	    case 4:
		set_svensson_parameters();
		break;
	    case 5:
	      if (svensson_flag == 0)
		    {
		    errtype("ERROR, Svensson's extension deactivated");
		    clear_command();
		    break;
		    } else
		      {
		      mik();
		      }
	      break;
	    case 20:
		list_menu("SET MENU",set_svensson_menu,set_svensson_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    }


/***************************************************************************/
void  calculate_transformation_matrices()
/***************************************************************************/

     /*
      This function calculates the coordination matrices needed for
      ransformations between the crystallographic space and the
      orthogonal space.
      */

    {
    float a,b,c,a_star,b_star,c_star;
    float alfa,beta,gamma,alfa_star,beta_star,gamma_star;
    float V;

    a =       DLAT[0];
    b =       DLAT[1];
    c =       DLAT[2];
    alfa =    DLAT[3];
    beta =    DLAT[4];
    gamma =   DLAT[5];

    calc_rlat(DLAT,RLAT);

    a_star =       RLAT[0];
    b_star =       RLAT[1];
    c_star =       RLAT[2];
    alfa_star =    RLAT[3];
    beta_star =    RLAT[4];
    gamma_star =   RLAT[5];

    MMATRIX[0][0] =  1/a;
    MMATRIX[0][1] =  0;
    MMATRIX[0][2] =  0;
    MMATRIX[1][0] = -cos(gamma)/(a*sin(gamma));
    MMATRIX[1][1] =  1/(b*sin(gamma));
    MMATRIX[1][2] =  0;
    MMATRIX[2][0] =  a_star*cos(beta_star);
    MMATRIX[2][1] =  b_star*cos(alfa_star);
    MMATRIX[2][2] =  c_star;

    MINVMATRIX[0][0] =  a;
    MINVMATRIX[0][1] =  0;
    MINVMATRIX[0][2] =  0;
    MINVMATRIX[1][0] =  b*cos(gamma);
    MINVMATRIX[1][1] =  b*sin(gamma);
    MINVMATRIX[1][2] =  0;
    MINVMATRIX[2][0] =  c*cos(beta);
    MINVMATRIX[2][1] = -c*sin(beta)*cos(alfa_star);
    MINVMATRIX[2][2] =  1/c_star;

    }


/***************************************************************************/
void  calculate_rotation_matrix(float phi, float chi, float th)
/***************************************************************************/

     /*
      This function calculates the rotation matrix needed for
      rotation of group molecules.
      */

    {
    RMATRIX[0][0] =  cos(phi)*cos(th) - cos(chi)*sin(phi)*sin(th);
    RMATRIX[0][1] = -cos(th)*sin(phi) - cos(chi)*cos(phi)*sin(th);
    RMATRIX[0][2] =  sin(chi)*sin(th);
    RMATRIX[1][0] =  cos(chi)*cos(th)*sin(phi) + cos(phi)*sin(th);
    RMATRIX[1][1] =  cos(chi)*cos(phi)*cos(th) - sin(phi)*sin(th);
    RMATRIX[1][2] = -cos(th)*sin(chi);
    RMATRIX[2][0] =  sin(chi)*sin(phi);
    RMATRIX[2][1] =  cos(phi)*sin(chi);
    RMATRIX[2][2] =  cos(chi);
    }


/***************************************************************************/
void  calculate_inverse_rotation_matrix(float phi, float chi, float th)
/***************************************************************************/

     /*
      This function calculates the inverse rotation matrix needed for
      rotation of the reciprocal space
      */

    {
    RINVMATRIX[0][0] =  cos(phi)*cos(th) - cos(chi)*sin(phi)*sin(th);
    RINVMATRIX[0][1] =  cos(chi)*cos(th)*sin(phi)+cos(phi)*sin(th);
    RINVMATRIX[0][2] =  sin(chi)*sin(phi);
    RINVMATRIX[1][0] = -cos(th)*sin(phi)-cos(chi)*cos(phi)*sin(th); 
    RINVMATRIX[1][1] =  cos(chi)*cos(phi)*cos(th) - sin(phi)*sin(th);
    RINVMATRIX[1][2] =  cos(phi)*sin(chi);
    RINVMATRIX[2][0] =  sin(chi)*sin(th);
    RINVMATRIX[2][1] = -sin(chi)*cos(th);
    RINVMATRIX[2][2] =  cos(chi);
    }


/***************************************************************************/
void  calc_orthogonal_coordinates(float xa, float yb, float zc, 
				  float *x, float *y, float *z)
/***************************************************************************/

     /*
      Calculates the orthogonal coordinates in angstroms for a set of
      fractional crystal coordinates.
      */

    {

    *x = MINVMATRIX[0][0]*xa + MINVMATRIX[1][0]*yb +MINVMATRIX[2][0]*zc;
    *y = MINVMATRIX[0][1]*xa + MINVMATRIX[1][1]*yb +MINVMATRIX[2][1]*zc;
    *z = MINVMATRIX[0][2]*xa + MINVMATRIX[1][2]*yb +MINVMATRIX[2][2]*zc;

    }

/***************************************************************************/
void  calc_crystal_coordinates(float x, float y, float z, 
			       float *xa, float *yb, float *zc)
/***************************************************************************/

     /*
      Calculates the fractional crystal coordinates for a set of orthogonal 
      coordinates in angstroms 
      */

    {

    *xa = MMATRIX[0][0]*x + MMATRIX[1][0]*y +MMATRIX[2][0]*z;
    *yb = MMATRIX[0][1]*x + MMATRIX[1][1]*y +MMATRIX[2][1]*z;
    *zc = MMATRIX[0][2]*x + MMATRIX[1][2]*y +MMATRIX[2][2]*z;

    }

/***************************************************************************/
void  calc_reciprocal_orthogonal_coordinates(float h, float k, float l, 
					     float *qx, float *qy, float *qz)
/***************************************************************************/

     /*
      Calculates the reciprical orthogonal coordinates in reciprocal 
      angstroms for a set of reciprocal coordinates given in hkl-space
      */

    {

    *qx = 2*M_PI*(MMATRIX[0][0]*h + MMATRIX[1][0]*k + MMATRIX[2][0]*l);   
    *qy = 2*M_PI*(MMATRIX[0][1]*h + MMATRIX[1][1]*k + MMATRIX[2][1]*l);   
    *qz = 2*M_PI*(MMATRIX[0][2]*h + MMATRIX[1][2]*k + MMATRIX[2][2]*l);

    }

/***************************************************************************/
void  calc_rotated_coordinates(float x_atom, float y_atom, float z_atom, 
			       float *x_rot, float *y_rot, float *z_rot)
/***************************************************************************/

     /*
      This function calculates the result of rotation of a group atom.
      */

    {
    *x_rot = x_atom*RMATRIX[0][0] + y_atom*RMATRIX[0][1] + z_atom*RMATRIX[0][2];
    *y_rot = x_atom*RMATRIX[1][0] + y_atom*RMATRIX[1][1] + z_atom*RMATRIX[1][2];
    *z_rot = x_atom*RMATRIX[2][0] + y_atom*RMATRIX[2][1] + z_atom*RMATRIX[2][2];
    }


/***************************************************************************/
float  cylinder_scattering_factor(float h, float k, float l, 
				  float t, float psi,
				  float charge, float length, 
				  float radius, float softness, float occupancy)
/***************************************************************************/

     /*
      This function calculates the "atomic" scattering factor for a cylinder
      */

    {
    float u, f, S, R, L, v, a, qx, qy, qz, Qx, Qy, Qz;

    L = length;
    a = radius*2;

    calc_reciprocal_orthogonal_coordinates(h, k, l, &qx, &qy, &qz);
    Qx =   qx*cos(psi) - qy*sin(psi);
    Qy =   qx*sin(psi) + qy*cos(psi);
    Qz = qz;

    u = (Qz*cos(-t)-Qx*sin(-t))*L/2;
    S = sin(u)/u;

    v = a*sqrt( Qy*Qy + (Qx*cos(-t)+Qz*sin(-t))*(Qx*cos(-t)+Qz*sin(-t)) );
    R = 1/(1+v*v);
     
    f = occupancy*charge*S*R;

    return f;

    }


/***************************************************************************/
float  ellipsoid_scattering_factor(float h, float k, float l, 
				   float phi, float chi, float th,
				   float charge, float a, float b, float c, 
				   float softness, float occupancy)
/***************************************************************************/

     /*
      This function calculates the "atomic" scattering factor for a ellipsoid
      */

    {
    float qx, qy, qz, Qx, Qy, Qz, f;

    calculate_inverse_rotation_matrix(phi, chi, th);
    calc_reciprocal_orthogonal_coordinates(h, k, l, &qx, &qy, &qz);

    Qx = RINVMATRIX[0][0]*qx + RINVMATRIX[1][0]*qy +RINVMATRIX[2][0]*qz;
    Qy = RINVMATRIX[0][1]*qx + RINVMATRIX[1][1]*qy +RINVMATRIX[2][1]*qz;
    Qz = RINVMATRIX[0][2]*qx + RINVMATRIX[1][2]*qy +RINVMATRIX[2][2]*qz;

    f = charge*occupancy*exp(-(a*a*Qx*Qx+b*b*Qy*Qy+c*c*Qz*Qz)/2.0);

    return f;

    }


/***************************************************************************/
int calc_symm_coord(float x_frac, float y_frac, float z_frac)
/***************************************************************************/

     /*
        Utility for calculating symmetry related atom positions
     */

    {
    int i, noSymmAtoms = 0, nsym;
    float xnew, ynew, znew;

    if (NSYMMCARDS == 0) return 0;

    for (nsym = 0; nsym < NSYMMCARDS; nsym++)
	{
	switch (abs(SYMMTABLEXYZ[nsym][0]))
	    {
	    case 1:
		xnew = x_frac*signum(SYMMTABLEXYZ[nsym][0]);
		break;
	    case 2:
		xnew = y_frac*signum(SYMMTABLEXYZ[nsym][0]);
		break;
	    case 3:
		xnew = z_frac*signum(SYMMTABLEXYZ[nsym][0]);
		break;
	    } 
	switch (abs(SYMMTABLEXYZ[nsym][1]))
	    {
	    case 1:
		ynew = x_frac*signum(SYMMTABLEXYZ[nsym][0]);
		break;
	    case 2:
		ynew = y_frac*signum(SYMMTABLEXYZ[nsym][0]);
		break;
	    case 3:
		ynew = z_frac*signum(SYMMTABLEXYZ[nsym][0]);
		break;
	    } 
	switch (abs(SYMMTABLEXYZ[nsym][2]))
	    {
	    case 1:
		znew = x_frac*signum(SYMMTABLEXYZ[nsym][0]);
		break;
	    case 2:
		znew = y_frac*signum(SYMMTABLEXYZ[nsym][0]);
		break;
	    case 3:
		znew = z_frac*signum(SYMMTABLEXYZ[nsym][0]);
		break;
	    } 

	xnew += SYMMTABLEADD[nsym][0];
	ynew += SYMMTABLEADD[nsym][1];
	znew += SYMMTABLEADD[nsym][2];
		
	/*
	  if (xnew < -0.5) xnew += 1.0;
	  else if (xnew > 1.5) xnew -= 1.0;
    
	  if (ynew < -0.5) ynew += 1.0;
	  else if (ynew > 1.5) ynew -= 1.0;
      
	  if (znew < -0.5) znew += 1.0;
	  else if (znew > 1.5) znew -= 1.0;
	*/

	if  (!((fabs(xnew-x_frac) < ATOMEPS) &&
	       (fabs(ynew-y_frac) < ATOMEPS) &&
	       (fabs(znew-z_frac) < ATOMEPS)))
	    {
	    SYMMATOMS[noSymmAtoms][0] = xnew;
	    SYMMATOMS[noSymmAtoms][1] = ynew;
	    SYMMATOMS[noSymmAtoms][2] = znew;
	    noSymmAtoms++;
	    } 
	}
    return noSymmAtoms;
    }


/***************************************************************************/
void    calc_atoms_orth_coord(int xcell, int ycell, int zcell, int cell)
/***************************************************************************/

     /*
       Utility for calculating orthonormal positions for all atoms.
       Used for the "xyz" list format and for the distance check function.
     */
    {
    int i, j, jj, istart, iend, noSymmAtoms, x, y, z;
    float xx, yy, zz, xa, yb, zc, xnew, ynew, znew;

    calculate_transformation_matrices();
    NORTHONORMAL = 0;
    for (x = 0; x < xcell; x++)
	for (y = 0; y < ycell; y++)
	    {
	    for (z = 0; z < zcell; z++)
		for (i = 0; i < NBULK; i++)
		    {
		    calc_orthogonal_coordinates(XB[i]+x,
						YB[i]+y,
						ZB[i]-z, 
						&xx,  &yy, &zz);
		    XORTHONORMAL[NORTHONORMAL] = xx;
		    YORTHONORMAL[NORTHONORMAL] = yy;
		    ZORTHONORMAL[NORTHONORMAL] = zz;
		    TORTHONORMAL[NORTHONORMAL] = TB[i];
		    NORTHONORMAL++;
		    }
	    if (cell == 1)
		{
		istart = 0;
		iend = NSURF;
		}
	    else if (cell == 2)
		{
		istart = NSURF;
		iend = NSURF+NSURF2;
		}
	    for (i = istart; i < iend; i++)
		{
		calc_orthogonal_coordinates(XSFIT[i]+x,
					    YSFIT[i]+y,
					    ZSFIT[i], 
					    &xx,  &yy, &zz);
		XORTHONORMAL[NORTHONORMAL] = xx;
		YORTHONORMAL[NORTHONORMAL] = yy;
		ZORTHONORMAL[NORTHONORMAL] = zz;
		TORTHONORMAL[NORTHONORMAL] = TS[i];
		NORTHONORMAL++;
/*
		noSymmAtoms = calc_symm_coord(XSFIT[i], YSFIT[i], ZSFIT[i]);
		for (j=0; j<noSymmAtoms; j++)
		    {
		    calc_orthogonal_coordinates(SYMMATOMS[j][0]+xcell,
		    SYMMATOMS[j][1]+ycell,
		    SYMMATOMS[j][2], 
		    &xx,  &yy, &zz);
		    XORTHONORMAL[NORTHONORMAL] = xx;
		    YORTHONORMAL[NORTHONORMAL] = yy;
		    ZORTHONORMAL[NORTHONORMAL] = zz;
		    TORTHONORMAL[NORTHONORMAL] = TS[i];
		    NORTHONORMAL++;
		    }
*/
		}
	    if (cell == 1)
		{
		istart = 0;
		iend = NGROUPSS - NGROUPSS2;
		}
	    else if (cell == 2)
		{
		istart = NGROUPSS - NGROUPSS2;
		iend = NGROUPSS;
		}
	    for (i = istart; i < iend; i++)
		{
		calculate_rotation_matrix(PHIGROUPS[i], CHIGROUPS[i], THGROUPS[i]);
		for (j = 0; j < NATOMSINGROUPS[i]; j++)
		    {
		    calc_rotated_coordinates(XATOMINGROUPS[i][j]-ORIGINOFATOMSINGROUPS[i][0],
					     YATOMINGROUPS[i][j]-ORIGINOFATOMSINGROUPS[i][1],
					     ZATOMINGROUPS[i][j]-ORIGINOFATOMSINGROUPS[i][2],
					     &xx, &yy, &zz);
		    calc_crystal_coordinates(xx,yy,zz,&xa,&yb,&zc);
		    xa += XGROUPS[i];
		    yb += YGROUPS[i];
		    zc += ZGROUPS[i];
		    calc_orthogonal_coordinates(xa+x,
						yb+y,
						zc, 
						&xx,  &yy, &zz);
		    XORTHONORMAL[NORTHONORMAL] = xx;
		    YORTHONORMAL[NORTHONORMAL] = yy;
		    ZORTHONORMAL[NORTHONORMAL] = zz;
		    TORTHONORMAL[NORTHONORMAL] = TATOMINGROUPS[i][j];
		    NORTHONORMAL++;
/*
                    noSymmAtoms = calc_symm_coord(xa, yb, zc);
		    for (jj=0; jj<noSymmAtoms; jj++)
			{
			calc_orthogonal_coordinates(SYMMATOMS[jj][0]+x,
						    SYMMATOMS[jj][1]+y,
						    SYMMATOMS[jj][2], 
						    &xx,  &yy, &zz);
			XORTHONORMAL[NORTHONORMAL] = xx;
			YORTHONORMAL[NORTHONORMAL] = yy;
			ZORTHONORMAL[NORTHONORMAL] = zz;
			TORTHONORMAL[NORTHONORMAL] = TATOMINGROUPS[i][j];
			NORTHONORMAL++;
			}
*/
		    }
		}
	    }
    }


/*************************************************************************/
void     mik(void)
/************************************************************************/

/*
set values of the deformation fit parameters
*/

     /* mik's menu*/
{
  /* define mik menu */

static struct MENU mik_menu[]=
      
      {	"parameter", 1, 1,"Model par. for fitting group(s)",
	"expansion",1, 2, "Value of group expansion parameter",
	"shearing", 1, 3, "Value of group shearing parameter",
	"lparam"  , 2, 18,"List parameter", 
	"latoms"  , 2, 19,"List atoms",
	"help"    , 1, 20,"Help",
	"return"  , 1, 21,"Close menu/no deformation"
      };

 /* number of commands in mik  menu */

    int mik_length = sizeof(mik_menu)/sizeof(mik_menu[0]);

    int     stop = FALSE;
    char    token[100];
    int i,j,npar,ngroup;
    
    while (!stop)

	{
	if (!get_token(token,"ROD.EXT.SVE.SET.DEF>")) break;
	switch (cmnd_match(token,mik_menu,mik_length))
	    {
	    case 1:
	      mik_deform_group();
	      break;
	      
	    case 2:
	      npar = get_int(1,
		    "Serial number of group expansion parameter: ");
		if ((npar < 1) || (npar > NEXPANGROUPSTOT))
		    {
		    errtype("ERROR, no such serial number in model");
		    break;
		    }
		sprintf(STRING,
		    "Value of expansion parameter %1d [%6.3f]: ",
		    npar,func_deform[0].defgroups[npar-1]);
		func_deform[0].defgroups[npar-1] = get_real(func_deform[0].defgroups[npar-1],STRING);
		sprintf(STRING,
		    "Lower limit of expansion %1d [%6.3f]: ",
		    npar,func_deform[0].deflimgroups[npar-1][0]);
		func_deform[0].deflimgroups[npar-1][0] = 
		  get_real(func_deform[0].deflimgroups[npar-1][0],STRING);
		sprintf(STRING,
		    "Upper limit of expansion %1d [%6.3f]: ",
		    npar,func_deform[0].deflimgroups[npar-1][1]);
		func_deform[0].deflimgroups[npar-1][1] = 
		  get_real(func_deform[0].deflimgroups[npar-1][1],STRING);
		sprintf(STRING,
		    "Range checking on expansion %1d [%s]: ",
		    npar,yesnostr(func_deform[0].defpengroups[npar-1]));
		func_deform[0].defpengroups[npar-1] = yesno(func_deform[0].defpengroups[npar-1],STRING);
		break;
	      
	    case 3:
	      npar = get_int(1,
		    "Serial number of group shearing parameter: ");
		if ((npar < 1) || (npar > NSHEARGROUPSTOT))
		    {
		    errtype("ERROR, no such serial number in model");
		    break;
		    }
		sprintf(STRING,
		    "Value of shearing parameter %1d [%6.3f]: ",
		    npar,func_deform[1].defgroups[npar-1]);
		func_deform[1].defgroups[npar-1] = get_real(func_deform[1].defgroups[npar-1],STRING);
		sprintf(STRING,
		    "Lower limit of shearing %1d [%6.3f]: ",
		    npar,func_deform[1].deflimgroups[npar-1][0]);
		func_deform[1].deflimgroups[npar-1][0] = 
		  get_real(func_deform[1].deflimgroups[npar-1][0],STRING);
		sprintf(STRING,
		    "Upper limit of shearing %1d [%6.3f]: ",
		    npar,func_deform[1].deflimgroups[npar-1][1]);
		func_deform[1].deflimgroups[npar-1][1] = 
		  get_real(func_deform[1].deflimgroups[npar-1][1],STRING);
		sprintf(STRING,
		    "Range checking on shearing %1d [%s]: ",
		    npar,yesnostr(func_deform[1].defpengroups[npar-1]));
		func_deform[1].defpengroups[npar-1] = yesno(func_deform[1].defpengroups[npar-1],STRING);
		break;
	    
	    case 18:
	    	ngroup = get_ngroup("Group number : ");
		if (ngroup)
			{
			if ((NEXPANGROUPSTOT==0) &&  (NSHEARGROUPSTOT==0))
				{
				sprintf(STRING,"Not deformation !!\n");
				type_line(STRING);
				}
			else
			{	
	    		for (i = 0; i < NEXPANGROUPSTOT; i++)
				{
				sprintf(STRING,"%2d Group Expan = %8.4f [%8.4f , %8.4f]",i+1,func_deform[0].defgroups[i],func_deform[0].deflimgroups[i][0],func_deform[0].deflimgroups[i][1]); 
	    			type_line(STRING);
				
				if (func_deform[0].defpengroups[i]==1)
					type_line("  cheked ");
				else
					type_line("         ");
				type_list("\n",ROWS);
				}
				
			for (i = 0; i < NSHEARGROUPSTOT; i++)		
				{
				sprintf(STRING,"%2d Group Shear = %8.4f [%8.4f , %8.4f]",i+1+NEXPANGROUPSTOT,func_deform[1].defgroups[i],func_deform[1].deflimgroups[i][0],func_deform[1].deflimgroups[i][1]); 
	    			type_line(STRING);
				
				if (func_deform[1].defpengroups[i]==1)
					type_line("  cheked ");
				else
					type_line("         ");	
	    			type_list("\n",ROWS);
				}
			}
		}
		break;
		
	    case 19:
		if (!NGROUPSS) type_line("No groups defined.\n");
		else
		    {
		    clear_screen();
		    for (i = 0; i < NGROUPSS; i++)
		        {
			if (NGROUPSS2 && (i == 0)) 
			    type_list("First surface cell:\n",ROWS);
			if (NGROUPSS2 && (i == NGROUPSS-NGROUPSS2)) 
			    {
			    type_list("-------------------------------------------------------------------------------\n",ROWS);
			    type_list("Second surface cell:\n",ROWS);
			    }
			sprintf(STRING,
				"%2s %10s %7s %2s %7s %2s %7s %2s %7s %2s %7s %2s %7s %2s\n", 
				"#","group name",
				"x +","d",
				"y +","d",
				"z +","d",
				"phi +","d",
				"chi +","d",
				"th +","d");
			type_list(STRING,ROWS);
			sprintf(STRING,
				"%2d %10s %7.4f %2d %7.4f %2d %7.4f %2d %7.4f %2d %7.4f %2d %7.4f %2d\n",
				i+1, NAMEOFGROUPS[i],
				XGROUPS[i], NXDISGROUPS[i],
				YGROUPS[i], NYDISGROUPS[i],
				ZGROUPS[i], NZDISGROUPS[i],
				PHIGROUPS[i]*RAD, NPHIDISGROUPS[i],
				CHIGROUPS[i]*RAD, NCHIDISGROUPS[i],
				THGROUPS[i]*RAD, NTHDISGROUPS[i]);
			type_list(STRING,ROWS);
			sprintf(STRING, "Origin of atoms: %7.4f %7.4f %7.4f  Occupancy: %7.4f\n",
				ORIGINOFATOMSINGROUPSFIT[i][0],
				ORIGINOFATOMSINGROUPSFIT[i][1],
				ORIGINOFATOMSINGROUPSFIT[i][2],
				OCCUPANCYOFGROUPS[i]);
			type_list(STRING,ROWS);
			sprintf(STRING, "%2s %2s %7s %7s %7s %2s\n",
				"#","el", "x +", "y +", "z +", "B");
			type_list(STRING,ROWS);
			for ( j = 0; j < NATOMSINGROUPS[i]; j++)
			    {
			    sprintf(STRING, "%2d %2s %7.4f %7.4f %7.4f %2d\n",
				    j+1, ELEMENT[TATOMINGROUPS[i][j]],
				    XATOMINGROUPSFIT[i][j],
				    YATOMINGROUPSFIT[i][j],
				    ZATOMINGROUPSFIT[i][j],
				    NDWSATOMINGROUPS[i][j]);
			    type_list(STRING,ROWS);
			    }
			}
		    }
		break;  
	    
	    case 20:
	      list_menu("MIK MENU",mik_menu,mik_length);
	      break;
	    case 21:
	      stop=TRUE;
	    }
	}
	 update_model(); 
}

/***************************************************************************/
	void mik_deform_group(void)
/***************************************************************************/
{
/*
Set fit parameters of group deformation
*/

    /* define mik_deform_group_menu */

    static struct   MENU mik_deform_group_menu[] =
	{
	"centerexp",  2,  1,  "Center of expansion",
	"conservol",  2,  11, "Conservation of the volume for the expan",  
	"xexpan",     2,  2,  "Serial number of x-expansion parameter",
	"yexpan",     2,  3,  "Serial number of y-expansion parameter",
	"zexpan",     2,  4,  "Serial number of z-expansion parameter",
	"xyshear",    2,  5,  "Serial number of xy-shear parameter",
	"zxshear",    2,  6,  "Serial number of xz-shear parameter",
	"yzshear",    2,  7,  "Serial number of yz-shear parameter",
	"help",       1,  31, "Display menu",
	"return",     1,  32, "Return to main menu"
	};

    int mik_deform_group_length = sizeof(mik_deform_group_menu) / sizeof(mik_deform_group_menu[0]);

    int     stop = FALSE;
    char    token[30];
    int     ngroup;

    while (!stop)
	{
	if (!get_token(token,"ROD.EXT.SVE.SET.DEF.PAR>")) break;
	switch (cmnd_match(token,mik_deform_group_menu,mik_deform_group_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,"The expansion's center : \n\n");
		    type_list(STRING,ROWS);
		    sprintf(STRING,"\t 1/ Center of the atoms group.\n");
		    type_list(STRING,ROWS);
		    sprintf(STRING,"\t 2/ Origin of rotation.\n");
		    type_list(STRING,ROWS);
		    sprintf(STRING,"\t 3/ Enter the center.\n\n");
		    type_list(STRING,ROWS); 
		    choicecenterexpan++;
		    sprintf(STRING,"Enter your choice [%d] : ",choicecenterexpan); 
		    choicecenterexpan=get_int(choicecenterexpan,STRING)-1;	
	
		if (choicecenterexpan==0)
			{
			exp_center[ngroup-1][0]=center_atoms_group(ngroup-1,0);
			exp_center[ngroup-1][1]=center_atoms_group(ngroup-1,1);
			exp_center[ngroup-1][2]=center_atoms_group(ngroup-1,2);
			}
		else if (choicecenterexpan==1)
			{
			exp_center[ngroup-1][0]=ORIGINOFATOMSINGROUPS[ngroup-1][0];
			exp_center[ngroup-1][1]=ORIGINOFATOMSINGROUPS[ngroup-1][1];
			exp_center[ngroup-1][2]=ORIGINOFATOMSINGROUPS[ngroup-1][2];
			}
		else if (choicecenterexpan==2)
			{	
			sprintf(STRING,"Enter the x center of the expansion [%5.3f]: ",exp_center[ngroup-1][0]);	
			exp_center[ngroup-1][0]=get_real(exp_center[ngroup-1][0],STRING);
			sprintf(STRING,"Enter the y center of the expansion [%5.3f]: ",exp_center[ngroup-1][1]);	
			exp_center[ngroup-1][1]=get_real(exp_center[ngroup-1][1],STRING);
			sprintf(STRING,"Enter the z center of the expansion [%5.3f]: ",exp_center[ngroup-1][2]);	
			exp_center[ngroup-1][2]=get_real(exp_center[ngroup-1][2],STRING);
			}
		else return;

		    }
		break;
	
	    case 11:
	        ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,"Conserving of the volume ? [%s]: ",yesnostr(consvolexpan[ngroup-1]));
		    consvolexpan[ngroup-1]=yesno(consvolexpan[ngroup-1],STRING);
		    
		    if (consvolexpan[ngroup-1]==1)
		    	{
			if ((SNEXPX[ngroup-1]>0)&&(SNEXPY[ngroup-1]>0)&&(SNEXPZ[ngroup-1]>0))
				{
				sprintf(STRING,"Error, impossible to conserve the volume.\n");
				type_list(STRING,ROWS); 
		    		consvolexpan[ngroup-1]=0;
				}
			}
		    }
		break;
		
	    case 2:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,
			    "Serial number of x-expansion parameter [%1d]: ",
			    SNEXPX[ngroup-1]);
		    SNEXPX[ngroup-1] = get_int(SNEXPX[ngroup-1],STRING);
		    if (SNEXPX[ngroup-1] > NEXPANGROUPSTOT) 
			NEXPANGROUPSTOT = SNEXPX[ngroup-1];
		    }
		break;
	    
	    case 3:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,
			    "Serial number of y-expansion parameter [%1d]: ",
			    SNEXPY[ngroup-1]);
		    SNEXPY[ngroup-1] = get_int(SNEXPY[ngroup-1],STRING);
		    if (SNEXPY[ngroup-1] > NEXPANGROUPSTOT) 
			NEXPANGROUPSTOT = SNEXPY[ngroup-1];
		    }
		break;
		    
	    case 4:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,
			    "Serial number of z-expansion parameter [%1d]: ",
			    SNEXPZ[ngroup-1]);
		    SNEXPZ[ngroup-1] = get_int(SNEXPZ[ngroup-1],STRING);
		    if (SNEXPZ[ngroup-1] > NEXPANGROUPSTOT) 
			NEXPANGROUPSTOT = SNEXPZ[ngroup-1];
		    }
		break;
		
	    case 5:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,
			    "Serial number xy-shear parameter [%1d]: ",
			    SNSHEARXY[ngroup-1]);
		    SNSHEARXY[ngroup-1] = get_int(SNSHEARXY[ngroup-1],STRING);
		    if (SNSHEARXY[ngroup-1] > NSHEARGROUPSTOT) 
			NSHEARGROUPSTOT = SNSHEARXY[ngroup-1];
		    }
		break;
	    
	    case 6:
	        ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,
			    "Serial number zx-shear parameter [%1d]: ",
			    SNSHEARZX[ngroup-1]);
		    SNSHEARZX[ngroup-1] = get_int(SNSHEARZX[ngroup-1],STRING);
		    if (SNSHEARZX[ngroup-1] > NSHEARGROUPSTOT) 
			NSHEARGROUPSTOT = SNSHEARZX[ngroup-1];
		    }
		break;
		
	    case 7:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,
			    "Serial number yz-shear parameter [%1d]: ",
			    SNSHEARYZ[ngroup-1]);
		    SNSHEARYZ[ngroup-1] = get_int(SNSHEARYZ[ngroup-1],STRING);
		    if (SNSHEARYZ[ngroup-1] > NSHEARGROUPSTOT) 
			NSHEARGROUPSTOT = SNSHEARYZ[ngroup-1];
		    }
		break;
	    
	    case 31:
		list_menu("DEFORMATION PARAMETERS", mik_deform_group_menu,mik_deform_group_length);
		break;
		
	    case 32:
		stop = TRUE;
	    }
	}
    update_model();
    }

/***************************************************************************/
	void mik_update_model(void)
/***************************************************************************/

{
int i,j;
float exp_temp;

for (i=0 ; i<NGROUPSS ; i++)
	{
	ORIGINOFATOMSINGROUPSFIT[i][0]=ORIGINOFATOMSINGROUPS[i][0];
	ORIGINOFATOMSINGROUPSFIT[i][1]=ORIGINOFATOMSINGROUPS[i][1];
	ORIGINOFATOMSINGROUPSFIT[i][2]=ORIGINOFATOMSINGROUPS[i][2];
	
	for (j=0 ; j<NATOMSINGROUPS[i] ; j++)
		{
		XATOMINGROUPSFIT[i][j]=XATOMINGROUPS[i][j];
		YATOMINGROUPSFIT[i][j]=YATOMINGROUPS[i][j];
		ZATOMINGROUPSFIT[i][j]=ZATOMINGROUPS[i][j];
		}
		
	if ((SNEXPX[i]>0)&&(SNEXPY[i]==0)&&(SNEXPZ[i]==0))
		{
		for (j=0 ; j<NATOMSINGROUPS[i] ; j++)
			{
			XATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPX[i]-1]/100*(XATOMINGROUPS[i][j]-exp_center[i][0]);
			}
		ORIGINOFATOMSINGROUPSFIT[i][0]+=
		func_deform[0].defgroups[SNEXPX[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][0]-exp_center[i][0]);
	
		}
		
	if ((SNEXPX[i]==0)&&(SNEXPY[i]>0)&&(SNEXPZ[i]==0))
		{
		for (j=0 ; j<NATOMSINGROUPS[i] ; j++)
			{
			YATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPY[i]-1]/100*(YATOMINGROUPS[i][j]-exp_center[i][1]);
			}
		ORIGINOFATOMSINGROUPSFIT[i][1]+=
		func_deform[0].defgroups[SNEXPY[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][1]-exp_center[i][1]);
	
		}
	
	if ((SNEXPX[i]==0)&&(SNEXPY[i]==0)&&(SNEXPZ[i]>0))
		{
		for (j=0 ; j<NATOMSINGROUPS[i] ; j++)
			{
			ZATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPZ[i]-1]/100*(ZATOMINGROUPS[i][j]-exp_center[i][2]);
			}
		ORIGINOFATOMSINGROUPSFIT[i][2]+=
		func_deform[0].defgroups[SNEXPZ[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][2]-exp_center[i][2]);
	
		}
	
	if ((SNEXPX[i]>0)&&(SNEXPY[i]>0)&&(SNEXPZ[i]>0))
		{
		for (j=0 ; j<NATOMSINGROUPS[i] ; j++)
			{
			XATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPX[i]-1]/100*(XATOMINGROUPS[i][j]-exp_center[i][0]);
			YATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPY[i]-1]/100*(YATOMINGROUPS[i][j]-exp_center[i][1]);
			ZATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPZ[i]-1]/100*(ZATOMINGROUPS[i][j]-exp_center[i][2]);
			}
		ORIGINOFATOMSINGROUPSFIT[i][0]+=
		func_deform[0].defgroups[SNEXPX[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][0]-exp_center[i][0]);
		ORIGINOFATOMSINGROUPSFIT[i][1]+=
		func_deform[0].defgroups[SNEXPY[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][1]-exp_center[i][1]);
		ORIGINOFATOMSINGROUPSFIT[i][2]+=
		func_deform[0].defgroups[SNEXPZ[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][2]-exp_center[i][2]);
	
		}
	
	if ((SNEXPX[i]>0)&&(SNEXPY[i]>0)&&(SNEXPZ[i]==0)&&(consvolexpan[i]==0))
		{
		for (j=0 ; j<NATOMSINGROUPS[i] ; j++)
			{
			YATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPY[i]-1]/100*(YATOMINGROUPS[i][j]-exp_center[i][1]);
			XATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPX[i]-1]/100*(XATOMINGROUPS[i][j]-exp_center[i][0]);
			}
		ORIGINOFATOMSINGROUPSFIT[i][0]+=
		func_deform[0].defgroups[SNEXPX[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][0]-exp_center[i][0]);
		ORIGINOFATOMSINGROUPSFIT[i][1]+=
		func_deform[0].defgroups[SNEXPY[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][1]-exp_center[i][1]);
	
		}
	
	if ((SNEXPX[i]==0)&&(SNEXPY[i]>0)&&(SNEXPZ[i]>0)&&(consvolexpan[i]==0))
		{
		for (j=0 ; j<NATOMSINGROUPS[i] ; j++)
			{
			YATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPY[i]-1]/100*(YATOMINGROUPS[i][j]-exp_center[i][1]);
			ZATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPZ[i]-1]/100*(ZATOMINGROUPS[i][j]-exp_center[i][2]);
			}
		ORIGINOFATOMSINGROUPSFIT[i][2]+=
		func_deform[0].defgroups[SNEXPZ[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][2]-exp_center[i][2]);
		ORIGINOFATOMSINGROUPSFIT[i][1]+=
		func_deform[0].defgroups[SNEXPY[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][1]-exp_center[i][1]);
	
		}
	
	if ((SNEXPX[i]>0)&&(SNEXPY[i]==0)&&(SNEXPZ[i]>0)&&(consvolexpan[i]==0))
		{
		for (j=0 ; j<NATOMSINGROUPS[i] ; j++)
			{
			ZATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPZ[i]-1]/100*(ZATOMINGROUPS[i][j]-exp_center[i][2]);
			XATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPX[i]-1]/100*(XATOMINGROUPS[i][j]-exp_center[i][0]);
		}
		ORIGINOFATOMSINGROUPSFIT[i][0]+=
		func_deform[0].defgroups[SNEXPX[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][0]-exp_center[i][0]);
		ORIGINOFATOMSINGROUPSFIT[i][2]+=
		func_deform[0].defgroups[SNEXPZ[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][2]-exp_center[i][2]);
	
		}
	
	if ((SNEXPX[i]>0)&&(SNEXPY[i]>0)&&(SNEXPZ[i]==0)&&(consvolexpan[i]==1))
		{
		exp_temp=calc_comp_th(1,i,func_deform[0].defgroups[SNEXPX[i]-1],func_deform[0].defgroups[SNEXPY[i]-1]);
		
		for (j=0 ; j<NATOMSINGROUPS[i] ; j++)
			{
			YATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPY[i]-1]/100*(YATOMINGROUPS[i][j]-exp_center[i][1]);
			XATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPX[i]-1]/100*(XATOMINGROUPS[i][j]-exp_center[i][0]);
			ZATOMINGROUPSFIT[i][j]+=exp_temp/100*(ZATOMINGROUPS[i][j]-exp_center[i][2]);
			}
		
		ORIGINOFATOMSINGROUPSFIT[i][0]+=
		func_deform[0].defgroups[SNEXPX[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][0]-exp_center[i][0]);
		ORIGINOFATOMSINGROUPSFIT[i][1]+=
		func_deform[0].defgroups[SNEXPY[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][1]-exp_center[i][1]);
		ORIGINOFATOMSINGROUPSFIT[i][2]+=exp_temp*(ORIGINOFATOMSINGROUPS[i][2]-exp_center[i][2]);
	
		replace_atoms(i);
		}
	
	if ((SNEXPX[i]==0)&&(SNEXPY[i]>0)&&(SNEXPZ[i]>0)&&(consvolexpan[i]==1))
		{
		exp_temp=calc_comp_th(2,i,func_deform[0].defgroups[SNEXPZ[i]-1],func_deform[0].defgroups[SNEXPY[i]-1]);
		
		for (j=0 ; j<NATOMSINGROUPS[i] ; j++)
			{
			YATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPY[i]-1]/100*(YATOMINGROUPS[i][j]-exp_center[i][1]);
			ZATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPZ[i]-1]/100*(ZATOMINGROUPS[i][j]-exp_center[i][2]);
			XATOMINGROUPSFIT[i][j]+=exp_temp/100*(XATOMINGROUPS[i][j]-exp_center[i][0]);
			}
			
		ORIGINOFATOMSINGROUPSFIT[i][2]+=
		func_deform[0].defgroups[SNEXPZ[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][2]-exp_center[i][2]);
		ORIGINOFATOMSINGROUPSFIT[i][1]+=
		func_deform[0].defgroups[SNEXPY[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][1]-exp_center[i][1]);
		ORIGINOFATOMSINGROUPSFIT[i][0]+=exp_temp*(ORIGINOFATOMSINGROUPS[i][0]-exp_center[i][0]);
	
		}
	
	if ((SNEXPX[i]>0)&&(SNEXPY[i]==0)&&(SNEXPZ[i]>0)&&(consvolexpan[i]==1))
		{
		exp_temp=calc_comp_th(3,i,func_deform[0].defgroups[SNEXPX[i]-1],func_deform[0].defgroups[SNEXPZ[i]-1]);
		
		for (j=0 ; j<NATOMSINGROUPS[i] ; j++)
			{
			ZATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPZ[i]-1]/100*(ZATOMINGROUPS[i][j]-exp_center[i][2]);
			XATOMINGROUPSFIT[i][j]+=
			func_deform[0].defgroups[SNEXPX[i]-1]/100*(XATOMINGROUPS[i][j]-exp_center[i][0]);
			YATOMINGROUPSFIT[i][j]+=exp_temp/100*(YATOMINGROUPS[i][j]-exp_center[i][1]);
			}
	
		ORIGINOFATOMSINGROUPSFIT[i][0]+=
		func_deform[0].defgroups[SNEXPX[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][0]-exp_center[i][0]);
		ORIGINOFATOMSINGROUPSFIT[i][2]+=
		func_deform[0].defgroups[SNEXPZ[i]-1]/100*(ORIGINOFATOMSINGROUPS[i][2]-exp_center[i][2]);
		ORIGINOFATOMSINGROUPSFIT[i][1]+=exp_temp*(ORIGINOFATOMSINGROUPS[i][1]-exp_center[i][1]);
	
		}
	
	if (SNSHEARXY[i]>0)
	{
		for (j=0 ; j<NATOMSINGROUPS[i] ; j++)
			{
			XATOMINGROUPSFIT[i][j]+= 0.5*func_deform[1].defgroups[SNSHEARXY[i]-1]*YATOMINGROUPS[i][j];
			YATOMINGROUPSFIT[i][j]+= 0.5*func_deform[1].defgroups[SNSHEARXY[i]-1]*XATOMINGROUPS[i][j];
			}
		ORIGINOFATOMSINGROUPSFIT[i][0]+= 0.5*func_deform[1].defgroups[SNSHEARXY[i]-1]*ORIGINOFATOMSINGROUPS[i][1];
		ORIGINOFATOMSINGROUPSFIT[i][1]+= 0.5*func_deform[1].defgroups[SNSHEARXY[i]-1]*ORIGINOFATOMSINGROUPS[i][0];
		
	}
	
	if (SNSHEARZX[i]>0)
	{
		for (j=0 ; j<NATOMSINGROUPS[i] ; j++)
			{
			XATOMINGROUPSFIT[i][j]+= 0.5*func_deform[1].defgroups[SNSHEARZX[i]-1]*ZATOMINGROUPS[i][j];
			ZATOMINGROUPSFIT[i][j]+= 0.5*func_deform[1].defgroups[SNSHEARZX[i]-1]*XATOMINGROUPS[i][j];
			}
		ORIGINOFATOMSINGROUPSFIT[i][0]+= 0.5*func_deform[1].defgroups[SNSHEARZX[i]-1]*ORIGINOFATOMSINGROUPS[i][2];
		ORIGINOFATOMSINGROUPSFIT[i][2]+= 0.5*func_deform[1].defgroups[SNSHEARZX[i]-1]*ORIGINOFATOMSINGROUPS[i][0];
		
	}
	 	
	if (SNSHEARYZ[i]>0)
	{
		for (j=0 ; j<NATOMSINGROUPS[i] ; j++)
			{
			YATOMINGROUPSFIT[i][j]+= 0.5*func_deform[1].defgroups[SNSHEARYZ[i]-1]*ZATOMINGROUPS[i][j];
			ZATOMINGROUPSFIT[i][j]+= 0.5*func_deform[1].defgroups[SNSHEARYZ[i]-1]*YATOMINGROUPS[i][j];
			}
		ORIGINOFATOMSINGROUPSFIT[i][2]+= 0.5*func_deform[1].defgroups[SNSHEARYZ[i]-1]*ORIGINOFATOMSINGROUPS[i][1];
		ORIGINOFATOMSINGROUPSFIT[i][1]+= 0.5*func_deform[1].defgroups[SNSHEARYZ[i]-1]*ORIGINOFATOMSINGROUPS[i][2];
		
	}
	
	
}
}

/***************************************************************************/
     void     replace_originofatoms(int ngroup)
/***************************************************************************/

{

int j;
float xtranslate,ztranslate,ytranslate;

xtranslate=ORIGINOFATOMSINGROUPS[ngroup][0]-ORIGINOFATOMSINGROUPSFIT[ngroup][0];
ytranslate=ORIGINOFATOMSINGROUPS[ngroup][1]-ORIGINOFATOMSINGROUPSFIT[ngroup][1];
ztranslate=ORIGINOFATOMSINGROUPS[ngroup][2]-ORIGINOFATOMSINGROUPSFIT[ngroup][2];

	for (j=0 ; j<NATOMSINGROUPS[ngroup] ; j++)
			{
			XATOMINGROUPSFIT[ngroup][j]+=xtranslate;
			YATOMINGROUPSFIT[ngroup][j]+=ytranslate; 
			ZATOMINGROUPSFIT[ngroup][j]+=ztranslate;
			}

ORIGINOFATOMSINGROUPSFIT[ngroup][0]=ORIGINOFATOMSINGROUPS[ngroup][0];
ORIGINOFATOMSINGROUPSFIT[ngroup][1]=ORIGINOFATOMSINGROUPS[ngroup][1];
ORIGINOFATOMSINGROUPSFIT[ngroup][2]=ORIGINOFATOMSINGROUPS[ngroup][2];

}

/***************************************************************************/
     void     replace_atoms(int ngroup)
/***************************************************************************/

{

int j,ind;
float zcenter,ztranslate,tmp,maxdist;

zcenter=center_atoms_group(ngroup,2);

maxdist=0;

for (j=0 ; j<NATOMSINGROUPS[ngroup] ; j++)
		{
		tmp=(ZATOMINGROUPSFIT[ngroup][j]-zcenter);
		
		if ((tmp < 0) && (fabs(tmp)>maxdist))
			{
			maxdist=tmp;
			ind=j;
			}
		}
		
ztranslate=ZATOMINGROUPS[ngroup][ind]-ZATOMINGROUPSFIT[ngroup][ind];

if (ztranslate > 0 )
	{
	ORIGINOFATOMSINGROUPSFIT[ngroup][2]+=ztranslate;

	for (j=0 ; j<NATOMSINGROUPS[ngroup] ; j++)
			{ 
			ZATOMINGROUPSFIT[ngroup][j]+=ztranslate;
			}
	}

}

/***************************************************************************/
     float    center_atoms_group(int ngroup, int comp)
/***************************************************************************/

{
/*
Compute the center of the atoms
*/

int j;
float sum;

sum = 0;

if (comp==0)
	{
	for (j=0 ; j<NATOMSINGROUPS[ngroup] ; j++)
		{ 
		sum +=XATOMINGROUPS[ngroup][j];
		}
	}
if (comp==1)
	{
	for (j=0 ; j<NATOMSINGROUPS[ngroup] ; j++)
		{
		sum +=YATOMINGROUPS[ngroup][j];
		}
	}
if (comp==2)
	{
	for (j=0 ; j<NATOMSINGROUPS[ngroup] ; j++)
		{
		sum +=ZATOMINGROUPS[ngroup][j];
		}
	}
		
return (sum/NATOMSINGROUPS[ngroup]);
}

/***************************************************************************/
     float     calc_comp_th(int choice, int ngroup, float d1, float d2)
/***************************************************************************/

{

float OXmax,OYmax,OZmax,OXmax2,OYmax2,OZmax2,xcenter,ycenter,zcenter,comp;

	xcenter=center_atoms_group(ngroup,0);
	ycenter=center_atoms_group(ngroup,1);
	zcenter=center_atoms_group(ngroup,2);
	
	OXmax=max_dist(xcenter,ngroup,0);
	OYmax=max_dist(ycenter,ngroup,1);
	OZmax=max_dist(zcenter,ngroup,2);
	
if (choice==1)
	{
	
	OXmax2=(d1/100*((OXmax+xcenter)-exp_center[ngroup][0]))+OXmax;
	OYmax2=(d2/100*((OYmax+ycenter)-exp_center[ngroup][1]))+OYmax;
	OZmax2=(OXmax*OYmax*OZmax)/(OXmax2*OYmax2);
	
	comp=(OZmax2-OZmax)*100/OZmax;		
	}
if (choice==2)
	{
		
	OZmax2=(d1/100*((OZmax+zcenter)-exp_center[ngroup][2]))+OZmax;
	OYmax2=(d2/100*((OYmax+ycenter)-exp_center[ngroup][1]))+OYmax;
	OXmax2=(OXmax*OYmax*OZmax)/(OZmax2*OYmax2);
	
	comp=(OXmax2-OXmax)*100/OXmax;				
	}
if (choice==3)
	{
		
	OXmax2=(d1/100*((OXmax+xcenter)-exp_center[ngroup][0]))+OXmax;
	OZmax2=(d2/100*((OZmax+zcenter)-exp_center[ngroup][2]))+OZmax;
	OYmax2=(OXmax*OYmax*OZmax)/(OXmax2*OZmax2);
			
	comp=(OYmax2-OYmax)*100/OYmax;				
	}
	
return comp;

}

/***************************************************************************/
     float max_dist(float center, int ngroup, int comp)
/***************************************************************************/

{
/*
compute the maximum distance between the center and the 
atoms of the group on the axis x, y or z
*/

float maxdist,tmp;
int j;

maxdist=0;


if (comp==0)
	{
	for (j=0 ; j<NATOMSINGROUPS[ngroup] ; j++)
		{ 
		tmp=fabs(XATOMINGROUPS[ngroup][j]-center);
		
		if (tmp > maxdist)
			{
			maxdist=tmp;
			}
		}
	}
if (comp==1)
	{
	for (j=0 ; j<NATOMSINGROUPS[ngroup] ; j++)
		{
		tmp=fabs(YATOMINGROUPS[ngroup][j]-center);
		
		if (tmp > maxdist)
			{
			maxdist=tmp;
			}
		}
	}
if (comp==2)
	{
	for (j=0 ; j<NATOMSINGROUPS[ngroup] ; j++)
		{
		tmp=fabs(ZATOMINGROUPS[ngroup][j]-center);
		
		if (tmp > maxdist)
			{
			maxdist=tmp;
			}
		}
	}

return maxdist;
}


/***************************************************************************/
int     get_ngroup(char *prompt)
/***************************************************************************/

    /*
    Get group serial number within allowed range
    */

    {

    int ngroup;


    /* Check if there is any model read in */

    if (NGROUPSS < 1)
	{
	errtype("ERROR, no groups in surface model");
	return(0);
	}

    while (TRUE)
	{
	ngroup = get_int(1,prompt);
	if ((ngroup < 1) || (ngroup > NGROUPSS))
	    {
	    errtype("ERROR, illegal group number");
	    }
	else
	    {
	    return(ngroup);
	    }
	}
    }


/***************************************************************************/
int     get_ncylinder(char *prompt)
/***************************************************************************/

    /*
    Get cylinder serial number within allowed range
    */

    {

    int ncylinder;


    /* Check if there is any model read in */

    if (NCYLINDERS < 1)
	{
	errtype("ERROR, no cylinders in surface model");
	return(0);
	}

    while (TRUE)
	{
	ncylinder = get_int(1,prompt);
	if ((ncylinder < 1) || (ncylinder > NCYLINDERS))
	    {
	    errtype("ERROR, illegal cylinder number");
	    }
	else
	    {
	    return(ncylinder);
	    }
	}
    }


/***************************************************************************/
int     get_nellipsoid(char *prompt)
/***************************************************************************/

    /*
    Get ellipsoid serial number within allowed range
    */

    {

    int nellipsoid;


    /* Check if there is any model read in */

    if (NELLIPSOIDS < 1)
	{
	errtype("ERROR, no ellipsoids in surface model");
	return(0);
	}

    while (TRUE)
	{
	nellipsoid = get_int(1,prompt);
	if ((nellipsoid < 1) || (nellipsoid > NELLIPSOIDS))
	    {
	    errtype("ERROR, illegal ellipsoid number");
	    }
	else
	    {
	    return(nellipsoid);
	    }
	}
    }


/***************************************************************************/
int     get_natom_group(char *prompt, int ngroup)
/***************************************************************************/

    /*
    Get group atom serial number within allowed range
    */

    {

    int natom;


    /* Check if there is any model read in */

    if (NATOMSINGROUPS[ngroup] < 1)
	{
	errtype("ERROR, no atoms in group model");
	return(0);
	}

    while (TRUE)
	{
	natom = get_int(1,prompt);
	if ((natom < 1) || (natom > NATOMSINGROUPS[ngroup]))
	    {
	    errtype("ERROR, illegal atom number");
	    }
	else
	    {
	    return(natom);
	    }
	}
    }


/***************************************************************************/
void    set_group(void)
/***************************************************************************/

    /*
    Set fit parameters of group(s) and group atoms.
    */

    {

    /* define set_group_menu */

    static struct   MENU set_group_menu[] =
	{
	"name",     1,  1,  "Group name",
	"xstart",   1,  2,  "Start x-position",
	"xdisplace",2,  3,  "Serial number of x-displacement parameter",
	"ystart",   1,  4,  "Start y-position",
	"ydisplace",2,  5,  "Serial number of y-displacement parameter",
	"zstart",   1,  6,  "Start z-position",
	"zdisplace",2,  7,  "Serial number of z-displacement parameter",
	"phistart", 1,  8,  "Start phi-position",
	"phidispl", 4,  9,  "Serial number of phi-displacement par.",
	"chistart", 1, 10,  "Start chi-position",
	"chidispl", 4, 11,  "Serial number of chi-displacement par.",
	"thstart",  1, 12,  "Start th-position",
	"thdispl",  3, 13,  "Serial number of th-displacement par.",
	"origin",   2, 23,  "Origin of group atoms",
	"occup",    2, 25,  "Group occupancy",
	"addgroup", 4, 14,  "Add a group",         
	"delgroup", 4, 15,  "Delete a group",           
        "ngroups1", 2, 24,  "No groups in the first surface cell",
	"element",  1, 16,  "Element type of group atom",
	"xatom",    2, 17,  "X-coordinate of group atom",
	"yatom",    2, 18,  "Y-coordinate of group atom",
	"zatom",    2, 19,  "Z-coordinate of group atom",
	"b",        1, 20,  "Serial # of group atom Debye-Waller par",
	"addatom",  4, 21,  "Add an atom to group",
	"delatom",  4, 22,  "Delete an atom from group",
	"list",     1, 30,  "List atoms",
	"help",     1, 31,  "Display menu",
	"return",   1, 32,  "Return to main menu"
	};

    /* number of commands in set_group menu */
    int set_group_length = sizeof(set_group_menu) / sizeof(set_group_menu[0]);

    int     stop = FALSE;
    char    token[100];
    int     ngroup,natom,i,j,newtype;
    char    name[TITLE_LENGTH], element[3];

    while (!stop)
	{
	if (!get_token(token,"ROD.EXT.SVE.SET.GROUP>")) break;
	switch (cmnd_match(token,set_group_menu,set_group_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING, "Group name[%10s]: ", NAMEOFGROUPS[ngroup-1]);
		    get_token(name, STRING);
		    strcpy(NAMEOFGROUPS[ngroup-1], name);
		    }
		break;
	    case 2:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,"Start x-position of group [%5.3f]: ",
			    XGROUPS[ngroup-1]);
		    XGROUPS[ngroup-1] = get_real(XGROUPS[ngroup-1],STRING);
		    }
		break;
	    case 3:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,
			    "Serial number of x-displacement parameter [%1d]: ",
			    NXDISGROUPS[ngroup-1]);
		    NXDISGROUPS[ngroup-1] = get_int(NXDISGROUPS[ngroup-1],STRING);
		    if (NXDISGROUPS[ngroup-1] > NDISGROUPSTOT) 
			NDISGROUPSTOT = NXDISGROUPS[ngroup-1];
		    }
		break;
	    case 4:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,"Start y-position of group [%5.3f]: ",
			    XGROUPS[ngroup-1]);
		    YGROUPS[ngroup-1] = get_real(YGROUPS[ngroup-1],STRING);
		    }
		break;
	    case 5:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,
			    "Serial number of y-displacement parameter [%1d]: ",
			    NYDISGROUPS[ngroup-1]);
		    NYDISGROUPS[ngroup-1] = get_int(NYDISGROUPS[ngroup-1],STRING);
		    if (NYDISGROUPS[ngroup-1] > NDISGROUPSTOT) 
			NDISGROUPSTOT = NYDISGROUPS[ngroup-1];
		    }
		break;
	    case 6:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,"Start z-position of group [%5.3f]: ",
			    XGROUPS[ngroup-1]);
		    ZGROUPS[ngroup-1] = get_real(ZGROUPS[ngroup-1],STRING);
		    }
		break;
	    case 7:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,
			    "Serial number of z-displacement parameter [%1d]: ",
			    NZDISGROUPS[ngroup-1]);
		    NZDISGROUPS[ngroup-1] = get_int(NZDISGROUPS[ngroup-1],STRING);
		    if (NZDISGROUPS[ngroup-1] > NDISGROUPSTOT) 
			NDISGROUPSTOT = NZDISGROUPS[ngroup-1];
		    }
		break;
	    case 8:
	        ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,"Start phi-angle of group [%5.3f]: ",
			    PHIGROUPS[ngroup-1]*RAD);
		    PHIGROUPS[ngroup-1] = get_real(PHIGROUPS[ngroup-1],STRING);
		    PHIGROUPS[ngroup-1] /= RAD;
		    }
		break;
	    case 9:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,
			    "Serial number of phi-angle parameter [%1d]: ",
			    NPHIDISGROUPS[ngroup-1]);
		    NPHIDISGROUPS[ngroup-1] = get_int(NPHIDISGROUPS[ngroup-1],STRING);
		    if (NPHIDISGROUPS[ngroup-1] > NDISGROUPSTOT) 
			NDISGROUPSTOT = NPHIDISGROUPS[ngroup-1];
		    }
		break;
	    case 10:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,"Start chi-angle of group [%5.3f]: ",
			    CHIGROUPS[ngroup-1]*RAD);
		    CHIGROUPS[ngroup-1] = get_real(CHIGROUPS[ngroup-1],STRING);
		    CHIGROUPS[ngroup-1] /= RAD;
		    }
		break;
	    case 11:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,
			    "Serial number of chi-angle parameter [%1d]: ",
			    NCHIDISGROUPS[ngroup-1]);
		    NCHIDISGROUPS[ngroup-1] = get_int(NCHIDISGROUPS[ngroup-1],STRING);
		    if (NCHIDISGROUPS[ngroup-1] > NDISGROUPSTOT) 
			NDISGROUPSTOT = NCHIDISGROUPS[ngroup-1];
		    }
		break;
	    case 12:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,"Start theta-angle of group [%5.3f]: ",
			    THGROUPS[ngroup-1]*RAD);
		    THGROUPS[ngroup-1] = get_real(THGROUPS[ngroup-1],STRING);
		    THGROUPS[ngroup-1] /= RAD;
		    }
		break;
	    case 13:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,
			    "Serial number of theta-angle parameter [%1d]: ",
			    NTHDISGROUPS[ngroup-1]);
		    NTHDISGROUPS[ngroup-1] = get_int(NTHDISGROUPS[ngroup-1],STRING);
		    if (NTHDISGROUPS[ngroup-1] > NDISGROUPSTOT) 
			NDISGROUPSTOT = NTHDISGROUPS[ngroup-1];
		    }
		break;
	    case 14:
		if (NGROUPSS == MAXGROUPS)
		    {
		    errtype("Maximum number of groups in model reached");
		    break;
		    }
		NGROUPSS++;

		/* Initialize parameters for new group */

		sprintf(STRING, "group%d", NGROUPSS);
		strcpy(NAMEOFGROUPS[NGROUPSS-1],STRING);
		XGROUPS[NGROUPSS-1] = 0;
		NXDISGROUPS[NGROUPSS-1] = 0;
		YGROUPS[NGROUPSS-1] = 0;
		NYDISGROUPS[NGROUPSS-1] = 0;
		ZGROUPS[NGROUPSS-1] = 0;
		NZDISGROUPS[NGROUPSS-1] = 0;
		PHIGROUPS[NGROUPSS-1] = 0;
		NPHIDISGROUPS[NGROUPSS-1] = 0;
		CHIGROUPS[NGROUPSS-1] = 0;
		NCHIDISGROUPS[NGROUPSS-1] = 0;
		THGROUPS[NGROUPSS-1] = 0;
		NTHDISGROUPS[NGROUPSS-1] = 0;
		NATOMSINGROUPS[NGROUPSS-1] = 0;
		OCCUPANCYOFGROUPS[NGROUPSS-1] = 1.0;
		sprintf(STRING,"New group added, group no = %d\n", NGROUPSS);
		type_line(STRING);
		break;
	    case 15:
		ngroup = get_ngroup("Group number: ");

		if (ngroup)
		    {
		    /* Shift groups with higher serial numbers */

		    for (i = ngroup-1; i < NGROUPSS-1; i++)
			{
			strcpy(NAMEOFGROUPS[i], NAMEOFGROUPS[i+1]);
			XGROUPS[i] = XGROUPS[i+1];
			NXDISGROUPS[i] = NXDISGROUPS[i+1];
			YGROUPS[i] = YGROUPS[i+1];
			NYDISGROUPS[i] = NYDISGROUPS[i+1];
			ZGROUPS[i] = ZGROUPS[i+1];
			NZDISGROUPS[i] = NZDISGROUPS[i+1];
			PHIGROUPS[i] = PHIGROUPS[i+1];
			NPHIDISGROUPS[i] = NPHIDISGROUPS[i+1];
			CHIGROUPS[i] = CHIGROUPS[i+1];
			NCHIDISGROUPS[i] = NCHIDISGROUPS[i+1];
			THGROUPS[i] = THGROUPS[i+1];
			NTHDISGROUPS[i] = NTHDISGROUPS[i+1];
			NATOMSINGROUPS[i] = NATOMSINGROUPS[i+1];
			for ( j = 0; j < NATOMSINGROUPS[i+1]; j++)
			    {
			    TATOMINGROUPS[i][j] = TATOMINGROUPS[i+1][j];
			    XATOMINGROUPS[i][j] = XATOMINGROUPS[i+1][j];
			    YATOMINGROUPS[i][j] = YATOMINGROUPS[i+1][j];
			    ZATOMINGROUPS[i][j] = ZATOMINGROUPS[i+1][j];
			    NDWSATOMINGROUPS[i][j] = NDWSATOMINGROUPS[i+1][j];
			    }
			}
		    NGROUPSS--;
		    sprintf(STRING,"Group no %d deleted\n", ngroup);
		    type_line(STRING);
		    }
		break;
	    case 16:
	        ngroup = get_ngroup("Group number:");
		if (ngroup)
		    {
		    natom = get_natom_group("Atom number: ", ngroup-1);
		    if (natom)
		        {		    
			get_token(element,"Element type: ");
			toupper(element[0]);
			tolower(element[1]);

			/* Check whether this is a new element type */
			
			newtype = TRUE;
			for (i = 0; i < NTYPES; i++)
			    {
			    if (el_equal(element,ELEMENT[i]))
			        {
				newtype = FALSE;
				TATOMINGROUPS[ngroup-1][natom-1] = i;
				}
			    }
			if (newtype)
			    {
			    if (NTYPES == MAXTYPES)
			        {
				errtype("ERROR, too many atom types");
				break;
				}
			    NTYPES++;
			    get_coeff(element,F_COEFF[NTYPES-1]);
			    if (F_COEFF[NTYPES-1][0] == 0.)
			        {
				NTYPES--;
				TS[natom-1] = 0;
				}
			    else
			        {
				sprintf(ELEMENT[NTYPES-1],"%s",element);
				TATOMINGROUPS[ngroup-1][natom-1] = NTYPES-1;
				}
			    }
			}
		    }
		break;
	    case 17:
	        ngroup = get_ngroup("Group number:");
		if (ngroup)
		    {
		    natom = get_natom_group("Atom number: ", ngroup-1);
		    if (natom)
		        {
		        sprintf(STRING,"X-position of group atom [%5.3f]: ",
				XATOMINGROUPS[ngroup-1][natom-1]);
			XATOMINGROUPS[ngroup-1][natom-1] = 
			    get_real(XATOMINGROUPS[ngroup-1][natom-1],STRING);
			}
		    }
		break;
	    case 18:
	        ngroup = get_ngroup("Group number:");
		if (ngroup)
		    {
		    natom = get_natom_group("Atom number: ", ngroup-1);
		    if (natom)
		        {
			sprintf(STRING,"Y-position of group atom [%5.3f]: ",
				YATOMINGROUPS[ngroup-1][natom-1]);
			YATOMINGROUPS[ngroup-1][natom-1] = 
			    get_real(YATOMINGROUPS[ngroup-1][natom-1],STRING);
			}
		    }
		break;
	    case 19:
	        ngroup = get_ngroup("Group number:");
		if (ngroup)
		    {
		    natom = get_natom_group("Atom number: ", ngroup-1);
		    if (natom)
		        {
			sprintf(STRING,"Z-position of group atom [%5.3f]: ",
				ZATOMINGROUPS[ngroup-1][natom-1]);
			ZATOMINGROUPS[ngroup-1][natom-1] = 
			    get_real(ZATOMINGROUPS[ngroup-1][natom-1],STRING);
			}
		    }
		break;
	    case 20:
	        ngroup = get_ngroup("Group number:");
		if (ngroup)
		    {
		    natom = get_natom_group("Atom number: ", ngroup-1);
		    if (natom)
		        {
			sprintf(STRING,"Serial # of Debye-Waller parameter [%d]: ",
				NDWSATOMINGROUPS[ngroup-1][natom-1]);
			NDWSATOMINGROUPS[ngroup-1][natom-1] = 
			    get_int(NDWSATOMINGROUPS[ngroup-1][natom-1],STRING);
			}
		    }
		break;
	    case 21:
	        ngroup = get_ngroup("Group number:");
		if (ngroup)
		    {
		    if (NATOMSINGROUPS[ngroup-1] == MAXATOMSPERGROUP)
		        {
			errtype("Maximum number of atoms in group reached");
			break;
			}
		    NATOMSINGROUPS[ngroup-1]++;

		    /* Initialize parameters for new atom */

		    XATOMINGROUPS[ngroup-1][NATOMSINGROUPS[ngroup-1]-1] = 0.0;
		    YATOMINGROUPS[ngroup-1][NATOMSINGROUPS[ngroup-1]-1] = 0.0;
		    ZATOMINGROUPS[ngroup-1][NATOMSINGROUPS[ngroup-1]-1] = 0.0;
		    NDWSATOMINGROUPS[ngroup-1][NATOMSINGROUPS[ngroup-1]-1] = 0.0;
		    sprintf(STRING,"New atom added in group # %d, atom no = %d\n", 
			    ngroup, NATOMSINGROUPS[ngroup-1]);
		    type_line(STRING);
		    }
		break;
	    case 22:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    natom = get_natom_group("Atom number: ", ngroup-1);
		    if (natom)
		        {

			/* Shift atoms with higher serial numbers */

			for (i = natom-1; i < NATOMSINGROUPS[ngroup-1]-1; i++)
			    {
			    TATOMINGROUPS[ngroup-1][i] = TATOMINGROUPS[ngroup-1][i+1];
			    XATOMINGROUPS[ngroup-1][i] = XATOMINGROUPS[ngroup-1][i+1];
			    YATOMINGROUPS[ngroup-1][i] = YATOMINGROUPS[ngroup-1][i+1];
			    ZATOMINGROUPS[ngroup-1][i] = ZATOMINGROUPS[ngroup-1][i+1];
			    NDWSATOMINGROUPS[ngroup-1][i] = NDWSATOMINGROUPS[ngroup-1][i+1];
			    }
			NATOMSINGROUPS[ngroup-1]--;
			sprintf(STRING,"Atom no %d in group no %d deleted\n", natom, ngroup);
			type_line(STRING);
			}
		    }
		break;
	    case 23:
		ngroup = get_ngroup("Group number: ");
		if (ngroup)
		    {
		    sprintf(STRING,"X-position of origin [%5.3f]: ",
			    ORIGINOFATOMSINGROUPS[ngroup-1][0]);
		    ORIGINOFATOMSINGROUPS[ngroup-1][0] = 
			get_real(ORIGINOFATOMSINGROUPS[ngroup-1][0],STRING);
		    sprintf(STRING,"Y-position of origin [%5.3f]: ",
			    ORIGINOFATOMSINGROUPS[ngroup-1][1]);
		    ORIGINOFATOMSINGROUPS[ngroup-1][1] = 
			get_real(ORIGINOFATOMSINGROUPS[ngroup-1][1],STRING);
		    sprintf(STRING,"Z-position of origin [%5.3f]: ",
			    ORIGINOFATOMSINGROUPS[ngroup-1][2]);
		    ORIGINOFATOMSINGROUPS[ngroup-1][2] = 
			get_real(ORIGINOFATOMSINGROUPS[ngroup-1][2],STRING);
		    }
		break;
	    case 24:
		sprintf(STRING, "Number of groups in first surface cell [%d]: ", NGROUPSS-NGROUPSS2); 
		ngroup = get_ngroup(STRING);
		if (ngroup)
		    {
		    NGROUPSS2 = NGROUPSS-ngroup;
		    }
		break;
	    case 25:
		ngroup = get_ngroup("Group number: ");
		sprintf(STRING, "Occupancy of group [%d]: ", ngroup); 
		if (ngroup)
		    {
		    sprintf(STRING,"Occupancy [%5.3f]: ",
			    OCCUPANCYOFGROUPS[ngroup-1]);
		    OCCUPANCYOFGROUPS[ngroup-1] = 
			get_real(OCCUPANCYOFGROUPS[ngroup-1],STRING);
		    }
		break;
   	    case 30:
		if (!NGROUPSS) type_line("No groups defined.\n");
		else
		    {
		    clear_screen();
		    for (i = 0; i < NGROUPSS; i++)
		        {
			if (NGROUPSS2 && (i == 0)) 
			    type_list("First surface cell:\n",ROWS);
			if (NGROUPSS2 && (i == NGROUPSS-NGROUPSS2)) 
			    {
			    type_list("-------------------------------------------------------------------------------\n",ROWS);
			    type_list("Second surface cell:\n",ROWS);
			    }
			sprintf(STRING,
				"%2s %10s %7s %2s %7s %2s %7s %2s %7s %2s %7s %2s %7s %2s\n", 
				"#","group name",
				"x +","d",
				"y +","d",
				"z +","d",
				"phi +","d",
				"chi +","d",
				"th +","d");
			type_list(STRING,ROWS);
			sprintf(STRING,
				"%2d %10s %7.4f %2d %7.4f %2d %7.4f %2d %7.4f %2d %7.4f %2d %7.4f %2d\n",
				i+1, NAMEOFGROUPS[i],
				XGROUPS[i], NXDISGROUPS[i],
				YGROUPS[i], NYDISGROUPS[i],
				ZGROUPS[i], NZDISGROUPS[i],
				PHIGROUPS[i]*RAD, NPHIDISGROUPS[i],
				CHIGROUPS[i]*RAD, NCHIDISGROUPS[i],
				THGROUPS[i]*RAD, NTHDISGROUPS[i]);
			type_list(STRING,ROWS);
			sprintf(STRING, "Origin of atoms: %7.4f %7.4f %7.4f  Occupancy: %7.4f\n",
				ORIGINOFATOMSINGROUPS[i][0],
				ORIGINOFATOMSINGROUPS[i][1],
				ORIGINOFATOMSINGROUPS[i][2],
				OCCUPANCYOFGROUPS[i]);
			type_list(STRING,ROWS);
			sprintf(STRING, "%2s %2s %7s %7s %7s %2s\n",
				"#","el", "x +", "y +", "z +", "B");
			type_list(STRING,ROWS);
			for ( j = 0; j < NATOMSINGROUPS[i]; j++)
			    {
			    sprintf(STRING, "%2d %2s %7.4f %7.4f %7.4f %2d\n",
				    j+1, ELEMENT[TATOMINGROUPS[i][j]],
				    XATOMINGROUPS[i][j],
				    YATOMINGROUPS[i][j],
				    ZATOMINGROUPS[i][j],
				    NDWSATOMINGROUPS[i][j]);
			    type_list(STRING,ROWS);
			    }
			}
		    }
		break;
	    case 31:
		list_menu("GROUP MODEL PARAMETERS",
			  set_group_menu,set_group_length);
		break;
	    case 32:
		stop = TRUE;
	    }
	}
    update_model();
    }


/***************************************************************************/
void    set_cylinder(void)
/***************************************************************************/

    /*
    Set fit parameters of cylinder(s).
    */

    {

    /* define set_cylinder_menu */

#define set_cylinder_length 27      /* number of commands in set_cylnder menu */

    static struct   MENU set_cylinder_menu[set_cylinder_length] =
	{
	"name",     1,  1,  "Cylinder name",
	"xstart",   1,  2,  "Start x-position",
	"xdisplace",2,  3,  "Serial number of x-displacement parameter",
	"ystart",   1,  4,  "Start y-position",
	"ydisplace",2,  5,  "Serial number of y-displacement parameter",
	"zstart",   1,  6,  "Start z-position",
	"zdisplace",2,  7,  "Serial number of z-displacement parameter",
	"tstart",   1, 10,  "Start t-angle",
	"tdispl",   2, 11,  "Serial number of t-angle par.",
	"psistart", 1, 12,  "Start psi-angle",
	"psidispl", 4, 13,  "Serial number of psi-angle par.",
	"origin",   2, 25,  "Centre of rotation of cylinder",
	"addcylind",1, 14,  "Add a cylinder",         
	"delcylind",1, 15,  "Delete a cylinder",           
	"charge",   2, 16,  "Total charge of a cylinder",
	"length",   2, 17,  "Length of a cylinder",
	"slength",  2, 18,  "Serial no of length",
	"radius",   2, 19,  "Radius of a cylinder",
	"sradius",  2, 20,  "Serial no of radius",
	"softness", 1, 21,  "Softness of a cylinder",
	"ssoftness",2, 22,  "Serial no of softness",
	"occup",    1, 23,  "Occupancy of a cylinder",
	"soccup",   3, 24,  "Serial no of occupancy",
	"list",     1, 30,  "List cylinders",
	"help",     1, 31,  "Display menu",
	"return",   1, 32,  "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];
    int     ncylinder,i;
    char    name[TITLE_LENGTH];

    while (!stop)
	{
	if (!get_token(token,"ROD.EXT.SVE.SET.CYLINDER>")) break;
	switch (cmnd_match(token,set_cylinder_menu,set_cylinder_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		ncylinder = get_ncylinder("Cylinder number: ");
		if (ncylinder)
		    {
		    sprintf(STRING, "Cylinder name[%10s]: ", NAMEOFCYLINDERS[ncylinder-1]);
		    get_token(name, STRING);
		    strcpy(NAMEOFCYLINDERS[ncylinder-1], name);
		    }
		break;
	    case 2:
		if (ncylinder)
		    {
		    ncylinder = get_ncylinder("Cylinder number: ");
		    sprintf(STRING,"Start x-position of cylinder [%5.3f]: ",
			    XCYLINDERS[ncylinder-1]);
		    XCYLINDERS[ncylinder-1] = get_real(XCYLINDERS[ncylinder-1],STRING);
		    }
		break;
	    case 3:
		ncylinder = get_ncylinder("Cylinder number: ");
		if (ncylinder)
		    {
		    sprintf(STRING,
			    "Serial number of x-displacement parameter [%1d]: ",
			    NXDISCYLINDERS[ncylinder-1]);
		    NXDISCYLINDERS[ncylinder-1] = get_int(NXDISCYLINDERS[ncylinder-1],STRING);
		    if (NXDISCYLINDERS[ncylinder-1] > NDISCYLINDERSTOT) 
			NDISCYLINDERSTOT = NXDISCYLINDERS[ncylinder-1];
		    }
		break;
	    case 4:
		ncylinder = get_ncylinder("Cylinder number: ");
		if (ncylinder)
		    {
		    sprintf(STRING,"Start y-position of cylinder [%5.3f]: ",
			    XCYLINDERS[ncylinder-1]);
		    YCYLINDERS[ncylinder-1] = get_real(YCYLINDERS[ncylinder-1],STRING);
		    }
		break;
	    case 5:
		ncylinder = get_ncylinder("Cylinder number: ");
		if (ncylinder)
		    {
		    sprintf(STRING,
			    "Serial number of y-displacement parameter [%1d]: ",
			    NYDISCYLINDERS[ncylinder-1]);
		    NYDISCYLINDERS[ncylinder-1] = get_int(NYDISCYLINDERS[ncylinder-1],STRING);
		    if (NYDISCYLINDERS[ncylinder-1] > NDISCYLINDERSTOT) 
			NDISCYLINDERSTOT = NYDISCYLINDERS[ncylinder-1];
		    }
		break;
	    case 6:
		ncylinder = get_ncylinder("Cylinder number: ");
		if (ncylinder)
		    {
		    sprintf(STRING,"Start z-position of cylinder [%5.3f]: ",
			    XCYLINDERS[ncylinder-1]);
		    ZCYLINDERS[ncylinder-1] = get_real(ZCYLINDERS[ncylinder-1],STRING);
		    }
		break;
	    case 7:
		ncylinder = get_ncylinder("Cylinder number: ");
		if (ncylinder)
		    {
		    sprintf(STRING,
			    "Serial number of z-displacement parameter [%1d]: ",
			    NZDISCYLINDERS[ncylinder-1]);
		    NZDISCYLINDERS[ncylinder-1] = get_int(NZDISCYLINDERS[ncylinder-1],STRING);
		    if (NZDISCYLINDERS[ncylinder-1] > NDISCYLINDERSTOT) 
			NDISCYLINDERSTOT = NZDISCYLINDERS[ncylinder-1];
		    }
		break;
	    case 8:
		break;
	    case 9:
		break;
	    case 10:
		ncylinder = get_ncylinder("Cylinder number: ");
		if (ncylinder)
		    {
		    sprintf(STRING,"Start t-angle of cylinder [%5.3f]: ",
			    TCYLINDERS[ncylinder-1]*RAD);
		    TCYLINDERS[ncylinder-1] = get_real(TCYLINDERS[ncylinder-1],STRING);
		    TCYLINDERS[ncylinder-1] /= RAD;
		    }
		break;
	    case 11:
		ncylinder = get_ncylinder("Cylinder number: ");
		if (ncylinder)
		    {
		    sprintf(STRING,
			    "Serial number of psi-angle parameter [%1d]: ",
			    NTDISCYLINDERS[ncylinder-1]);
		    NTDISCYLINDERS[ncylinder-1] = get_int(NTDISCYLINDERS[ncylinder-1],STRING);
		    if (NTDISCYLINDERS[ncylinder-1] > NDISCYLINDERSTOT) 
			NDISCYLINDERSTOT = NTDISCYLINDERS[ncylinder-1];
		    }
		break;
	    case 12:
		ncylinder = get_ncylinder("Cylinder number: ");
		if (ncylinder)
		    {
		    sprintf(STRING,"Start theta-angle of cylinder [%5.3f]: ",
			    PSICYLINDERS[ncylinder-1]*RAD);
		    PSICYLINDERS[ncylinder-1] = get_real(PSICYLINDERS[ncylinder-1],STRING);
		    PSICYLINDERS[ncylinder-1] /= RAD;
		    }
		break;
	    case 13:
		ncylinder = get_ncylinder("Cylinder number: ");
		if (ncylinder)
		    {
		    sprintf(STRING,
			    "Serial number of theta-angle parameter [%1d]: ",
			    NPSIDISCYLINDERS[ncylinder-1]);
		    NPSIDISCYLINDERS[ncylinder-1] = get_int(NPSIDISCYLINDERS[ncylinder-1],STRING);
		    if (NPSIDISCYLINDERS[ncylinder-1] > NDISCYLINDERSTOT) 
			NDISCYLINDERSTOT = NPSIDISCYLINDERS[ncylinder-1];
		    }
		break;
	    case 14:
		if (NCYLINDERS == MAXCYLINDERS)
		    {
		    errtype("Maximum number of cylinders in model reached");
		    break;
		    }
		NCYLINDERS++;

		/* Initialize parameters for new cylinder */

		strcpy(NAMEOFCYLINDERS[NCYLINDERS-1],"");
		XCYLINDERS[NCYLINDERS-1] = 0;
		NXDISCYLINDERS[NCYLINDERS-1] = 0;
		YCYLINDERS[NCYLINDERS-1] = 0;
		NYDISCYLINDERS[NCYLINDERS-1] = 0;
		ZCYLINDERS[NCYLINDERS-1] = 0;
		NZDISCYLINDERS[NCYLINDERS-1] = 0;
		TCYLINDERS[NCYLINDERS-1] = 0;
		NTDISCYLINDERS[NCYLINDERS-1] = 0;
		PSICYLINDERS[NCYLINDERS-1] = 0;
		NPSIDISCYLINDERS[NCYLINDERS-1] = 0;
		ORIGINOFCYLINDERS[i] = 0;
		CHARGEOFCYLINDERS[NCYLINDERS-1] = 0.0;
		LENGTHOFCYLINDERS[NCYLINDERS-1] = 0.0;
		NLENGTHOFCYLINDERS[NCYLINDERS-1] = 0;
		RADIUSOFCYLINDERS[NCYLINDERS-1] = 0.0;
		NRADIUSOFCYLINDERS[NCYLINDERS-1] = 0;
		SOFTNESSOFCYLINDERS[NCYLINDERS-1] = 0.0;
		NSOFTNESSOFCYLINDERS[NCYLINDERS-1] = 0;
		OCCUPOFCYLINDERS[NCYLINDERS-1] = 1.0;
		NOCCUPOFCYLINDERS[NCYLINDERS-1] = 0;
		sprintf(STRING,"New cylinder added, cylinder no = %d\n", NCYLINDERS);
		type_line(STRING);
		break;
	    case 15:
		ncylinder = get_ncylinder("Cylinder number: ");

		if (ncylinder)
		    {
		    /* Shift cylinders with higher serial numbers */

		    for (i = ncylinder-1; i < NCYLINDERS-1; i++)
			{
			strcpy(NAMEOFCYLINDERS[i], NAMEOFCYLINDERS[i+1]);
			XCYLINDERS[i] = XCYLINDERS[i+1];
			NXDISCYLINDERS[i] = NXDISCYLINDERS[i+1];
			YCYLINDERS[i] = YCYLINDERS[i+1];
			NYDISCYLINDERS[i] = NYDISCYLINDERS[i+1];
			ZCYLINDERS[i] = ZCYLINDERS[i+1];
			NZDISCYLINDERS[i] = NZDISCYLINDERS[i+1];
			TCYLINDERS[i] = TCYLINDERS[i+1];
			NTDISCYLINDERS[i] = NTDISCYLINDERS[i+1];
			PSICYLINDERS[i] = PSICYLINDERS[i+1];
			NPSIDISCYLINDERS[i] = NPSIDISCYLINDERS[i+1];
			ORIGINOFCYLINDERS[i] = ORIGINOFCYLINDERS[i+1];
			CHARGEOFCYLINDERS[i] = CHARGEOFCYLINDERS[i+1];
			LENGTHOFCYLINDERS[i] = LENGTHOFCYLINDERS[i+1];
			NLENGTHOFCYLINDERS[i] = NLENGTHOFCYLINDERS[i+1]; 
			RADIUSOFCYLINDERS[i] = RADIUSOFCYLINDERS[i+1]; 
			NRADIUSOFCYLINDERS[i] = NRADIUSOFCYLINDERS[i+1];
			SOFTNESSOFCYLINDERS[i] = SOFTNESSOFCYLINDERS[i+1];
			NSOFTNESSOFCYLINDERS[i] = NSOFTNESSOFCYLINDERS[i+1];
			OCCUPOFCYLINDERS[i] = OCCUPOFCYLINDERS[i+1];
			NOCCUPOFCYLINDERS[i] = NOCCUPOFCYLINDERS[i+1];
			}
		    NCYLINDERS--;
		    sprintf(STRING,"Cylinder no %d deleted\n", ncylinder);
		    type_line(STRING);
		    }
		break;
	    case 16:
	        ncylinder = get_ncylinder("Cylinder number:");
		if (ncylinder)
		    {
		    sprintf(STRING,"Total charge of cylinder [%5.3f]: ",
			    CHARGEOFCYLINDERS[ncylinder-1]);
		    CHARGEOFCYLINDERS[ncylinder-1] = 
			get_real(CHARGEOFCYLINDERS[ncylinder-1],STRING);
		    }
		break;
	    case 17:
	        ncylinder = get_ncylinder("Cylinder number:");
		if (ncylinder)
		    {
		    sprintf(STRING,"Length of cylinder [%5.3f]: ",
			    LENGTHOFCYLINDERS[ncylinder-1]);
		    LENGTHOFCYLINDERS[ncylinder-1] = 
			get_real(LENGTHOFCYLINDERS[ncylinder-1],STRING);
		    }
		break;
	    case 18:
		ncylinder = get_ncylinder("Cylinder number: ");
		if (ncylinder)
		    {
		    sprintf(STRING,
			    "Serial number of length [%1d]: ",
			    NLENGTHOFCYLINDERS[ncylinder-1]);
		    NLENGTHOFCYLINDERS[ncylinder-1] = get_int(NLENGTHOFCYLINDERS[ncylinder-1],STRING);
		    if (NLENGTHOFCYLINDERS[ncylinder-1] > NCHARGEDENSITYCYLINDERSTOT) 
			NCHARGEDENSITYCYLINDERSTOT = NLENGTHOFCYLINDERS[ncylinder-1];
		    }
		break;
	    case 19:
	        ncylinder = get_ncylinder("Cylinder number:");
		if (ncylinder)
		    {
		    sprintf(STRING,"Radius of cylinder [%5.3f]: ",
			    RADIUSOFCYLINDERS[ncylinder-1]);
		    RADIUSOFCYLINDERS[ncylinder-1] = 
			get_real(RADIUSOFCYLINDERS[ncylinder-1],STRING);
		    }
		break;
	    case 20:
		ncylinder = get_ncylinder("Cylinder number: ");
		if (ncylinder)
		    {
		    sprintf(STRING,
			    "Serial number of radius [%1d]: ",
			    NRADIUSOFCYLINDERS[ncylinder-1]);
		    NRADIUSOFCYLINDERS[ncylinder-1] = get_int(NRADIUSOFCYLINDERS[ncylinder-1],STRING);
		    if (NRADIUSOFCYLINDERS[ncylinder-1] > NCHARGEDENSITYCYLINDERSTOT) 
			NCHARGEDENSITYCYLINDERSTOT = NRADIUSOFCYLINDERS[ncylinder-1];
		    }
		break;
	    case 21:
	        ncylinder = get_ncylinder("Cylinder number:");
		if (ncylinder)
		    {
		    sprintf(STRING,"Softness of cylinder [%5.3f]: ",
			    SOFTNESSOFCYLINDERS[ncylinder-1]);
		    SOFTNESSOFCYLINDERS[ncylinder-1] = 
			get_real(SOFTNESSOFCYLINDERS[ncylinder-1],STRING);
		    }
		break;
	    case 22:
		ncylinder = get_ncylinder("Cylinder number: ");
		if (ncylinder)
		    {
		    sprintf(STRING,
			    "Serial number of softness[%1d]: ",
			    NSOFTNESSOFCYLINDERS[ncylinder-1]);
		    NSOFTNESSOFCYLINDERS[ncylinder-1] = get_int(NSOFTNESSOFCYLINDERS[ncylinder-1],STRING);
		    if (NSOFTNESSOFCYLINDERS[ncylinder-1] > NCHARGEDENSITYCYLINDERSTOT) 
			NCHARGEDENSITYCYLINDERSTOT = NSOFTNESSOFCYLINDERS[ncylinder-1];
		    }
		break;
	    case 23:
	        ncylinder = get_ncylinder("Cylinder number:");
		if (ncylinder)
		    {
		    sprintf(STRING,"Occupancy of cylinder [%5.3f]: ",
			    OCCUPOFCYLINDERS[ncylinder-1]);
		    OCCUPOFCYLINDERS[ncylinder-1] = 
			get_real(OCCUPOFCYLINDERS[ncylinder-1],STRING);
		    }
		break;
	    case 24:
		ncylinder = get_ncylinder("Cylinder number: ");
		if (ncylinder)
		    {
		    sprintf(STRING,
			    "Serial number of occupancy[%1d]: ",
			    NOCCUPOFCYLINDERS[ncylinder-1]);
		    NOCCUPOFCYLINDERS[ncylinder-1] = 
			get_int(NOCCUPOFCYLINDERS[ncylinder-1],STRING);
		    if (NOCCUPOFCYLINDERS[ncylinder-1] > NCHARGEDENSITYCYLINDERSTOT) 
			NCHARGEDENSITYCYLINDERSTOT = NOCCUPOFCYLINDERS[ncylinder-1];
		    }
		break;
	    case 25:
		ncylinder = get_ncylinder("Cylinder number: ");
		if (ncylinder)
		    {
		    sprintf(STRING,"Z-position of centre of rotation[%5.3f]: ",
			    ORIGINOFCYLINDERS[ncylinder-1]);
		    ORIGINOFCYLINDERS[ncylinder-1] = 
			get_real(ORIGINOFCYLINDERS[ncylinder-1],STRING);
		    }
		break;
	    case 30:
		if (!NCYLINDERS) type_line("No cylinders defined.\n");
		else
		    {
		    clear_screen();
		    for (i = 0; i < NCYLINDERS; i++)
		        {
			sprintf(STRING,
				"%2s %10s %7s %2s %7s %2s %7s %2s %7s %2s %7s %2s\n", 
				"#","name",
				"x +","d",
				"y +","d",
				"z +","d",
				"t +","d",
				"psi +","d");
			type_list(STRING,ROWS);
			sprintf(STRING,
				"%2d %10s %7.4f %2d %7.4f %2d %7.4f %2d %7.4f %2d %7.4f %2d\n",
				i+1, NAMEOFCYLINDERS[i],
				XCYLINDERS[i], NXDISCYLINDERS[i],
				YCYLINDERS[i], NYDISCYLINDERS[i],
				ZCYLINDERS[i], NZDISCYLINDERS[i],
				TCYLINDERS[i]*RAD, NTDISCYLINDERS[i],
				PSICYLINDERS[i]*RAD, NPSIDISCYLINDERS[i]);
			type_list(STRING,ROWS);
			sprintf(STRING,
				"%2s %7s %2s %7s %2s %7s %2s %7s %2s %7s %2s %7s %2s\n", 
				"",
				"z-orig.", "",
				"charge", "",
				"length","d",
				"radius","d",
				"softn.","d",
				"occup.","d");
			type_list(STRING,ROWS);
			sprintf(STRING,
				"%2s %7.4f %2s %7.4f %2s %7.4f %2d %7.4f %2d %7.4f %2d %7.4f %2d\n", 
				"",
				ORIGINOFCYLINDERS[i], "",
				CHARGEOFCYLINDERS[i], "",
				LENGTHOFCYLINDERS[i], NLENGTHOFCYLINDERS[i],
				RADIUSOFCYLINDERS[i], NRADIUSOFCYLINDERS[i],
				SOFTNESSOFCYLINDERS[i], NSOFTNESSOFCYLINDERS[i],
				OCCUPOFCYLINDERS[i], NOCCUPOFCYLINDERS[i]);
			type_list(STRING,ROWS);
			}
		    }
		break;
	    case 31:
		list_menu("CYLINDER MODEL PARAMETERS",
			  set_cylinder_menu,set_cylinder_length);
		break;
	    case 32:
		stop = TRUE;
	    }
	}
    update_model();
    }


/***************************************************************************/
void    set_ellipsoid(void)
/***************************************************************************/

    /*
    Set fit parameters of ellipsoid(s).
    */

    {

    /* define set_ellipsoid_menu */

#define set_ellipsoid_length 29      /* number of commands in set_cylnder menu */

    static struct   MENU set_ellipsoid_menu[set_ellipsoid_length] =
	{
	"name",     1,  1,  "Ellipsoid name",
	"xstart",   1,  2,  "Start x-position",
	"xdisplace",2,  3,  "Serial number of x-displacement parameter",
	"ystart",   1,  4,  "Start y-position",
	"ydisplace",2,  5,  "Serial number of y-displacement parameter",
	"zstart",   1,  6,  "Start z-position",
	"zdisplace",2,  7,  "Serial number of z-displacement parameter",
	"phistart", 1,  8,  "Start phi-position",
	"phidispl", 4,  9,  "Serial number of phi-displacement par.",
	"chistart", 1, 10,  "Start chi-position",
	"chidispl", 4, 11,  "Serial number of chi-displacement par.",
	"thstart",  1, 12,  "Start th-position",
	"thdispl",  3, 13,  "Serial number of th-displacement par.",
	"addcylind",1, 14,  "Add an ellipsoid",         
	"delcylind",1, 15,  "Delete an ellipsoid",           
	"charge",   2, 16,  "Total charge of an ellipsoid",
	"alength",  2, 17,  "Length of a half axis",
	"aserial",  2, 18,  "Serial number of a half axis",
	"blength",  2, 19,  "Length of b half axis",
	"bserial",  2, 20,  "Serial number of b half axis",
	"clength",  2, 21,  "Length of c half axis",
	"cserial",  2, 22,  "Serial number of c half axis",
	"softness", 1, 23,  "Softness of an ellipsoid",
	"ssoftness",2, 24,  "Serial number of softness",
	"occupancy",1, 25,  "Occupancy of an ellipsoid",
	"soccup",   3, 26,  "Serial number of occupancy",
	"list",     1, 30,  "List ellipsoids",
	"help",     1, 31,  "Display menu",
	"return",   1, 32,  "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];
    int     nellipsoid,i;
    char    name[TITLE_LENGTH];

    while (!stop)
	{
	if (!get_token(token,"ROD.EXT.SVE.SET.ELLIPSOID>")) break;
	switch (cmnd_match(token,set_ellipsoid_menu,set_ellipsoid_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING, "Ellipsoid name[%10s]: ", NAMEOFELLIPSOIDS[nellipsoid-1]);
		    get_token(name, STRING);
		    strcpy(NAMEOFELLIPSOIDS[nellipsoid-1], name);
		    }
		break;
	    case 2:
		if (nellipsoid)
		    {
		    nellipsoid = get_nellipsoid("Ellipsoid number: ");
		    sprintf(STRING,"Start x-position of ellipsoid [%5.3f]: ",
			    XELLIPSOIDS[nellipsoid-1]);
		    XELLIPSOIDS[nellipsoid-1] = get_real(XELLIPSOIDS[nellipsoid-1],STRING);
		    }
		break;
	    case 3:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,
			    "Serial number of x-displacement parameter [%1d]: ",
			    NXDISELLIPSOIDS[nellipsoid-1]);
		    NXDISELLIPSOIDS[nellipsoid-1] = get_int(NXDISELLIPSOIDS[nellipsoid-1],STRING);
		    if (NXDISELLIPSOIDS[nellipsoid-1] > NDISELLIPSOIDSTOT) 
			NDISELLIPSOIDSTOT = NXDISELLIPSOIDS[nellipsoid-1];
		    }
		break;
	    case 4:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,"Start y-position of ellipsoid [%5.3f]: ",
			    XELLIPSOIDS[nellipsoid-1]);
		    YELLIPSOIDS[nellipsoid-1] = get_real(YELLIPSOIDS[nellipsoid-1],STRING);
		    }
		break;
	    case 5:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,
			    "Serial number of y-displacement parameter [%1d]: ",
			    NYDISELLIPSOIDS[nellipsoid-1]);
		    NYDISELLIPSOIDS[nellipsoid-1] = get_int(NYDISELLIPSOIDS[nellipsoid-1],STRING);
		    if (NYDISELLIPSOIDS[nellipsoid-1] > NDISELLIPSOIDSTOT) 
			NDISELLIPSOIDSTOT = NYDISELLIPSOIDS[nellipsoid-1];
		    }
		break;
	    case 6:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,"Start z-position of ellipsoid [%5.3f]: ",
			    XELLIPSOIDS[nellipsoid-1]);
		    ZELLIPSOIDS[nellipsoid-1] = get_real(ZELLIPSOIDS[nellipsoid-1],STRING);
		    }
		break;
	    case 7:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,
			    "Serial number of z-displacement parameter [%1d]: ",
			    NZDISELLIPSOIDS[nellipsoid-1]);
		    NZDISELLIPSOIDS[nellipsoid-1] = get_int(NZDISELLIPSOIDS[nellipsoid-1],STRING);
		    if (NZDISELLIPSOIDS[nellipsoid-1] > NDISELLIPSOIDSTOT) 
			NDISELLIPSOIDSTOT = NZDISELLIPSOIDS[nellipsoid-1];
		    }
		break;
	    case 8:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,"Start phi-angle of ellipsoid [%5.3f]: ",
			    PHIELLIPSOIDS[nellipsoid-1]*RAD);
		    PHIELLIPSOIDS[nellipsoid-1] = get_real(PHIELLIPSOIDS[nellipsoid-1],STRING);
		    PHIELLIPSOIDS[nellipsoid-1] /= RAD;
		    }
		break;
	    case 9:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,
			    "Serial number of PHI-angle parameter [%1d]: ",
			    NPHIDISELLIPSOIDS[nellipsoid-1]);
		    NPHIDISELLIPSOIDS[nellipsoid-1] = get_int(NPHIDISELLIPSOIDS[nellipsoid-1],STRING);
		    if (NPHIDISELLIPSOIDS[nellipsoid-1] > NDISELLIPSOIDSTOT) 
			NDISELLIPSOIDSTOT = NPHIDISELLIPSOIDS[nellipsoid-1];
		    }
		break;
	    case 10:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,"Start chi-angle of ellipsoid [%5.3f]: ",
			    CHIELLIPSOIDS[nellipsoid-1]*RAD);
		    CHIELLIPSOIDS[nellipsoid-1] = get_real(CHIELLIPSOIDS[nellipsoid-1],STRING);
		    CHIELLIPSOIDS[nellipsoid-1] /= RAD;
		    }
		break;
	    case 11:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,
			    "Serial number of chi-angle parameter [%1d]: ",
			    NCHIDISELLIPSOIDS[nellipsoid-1]);
		    NCHIDISELLIPSOIDS[nellipsoid-1] = get_int(NCHIDISELLIPSOIDS[nellipsoid-1],STRING);
		    if (NCHIDISELLIPSOIDS[nellipsoid-1] > NDISELLIPSOIDSTOT) 
			NDISELLIPSOIDSTOT = NCHIDISELLIPSOIDS[nellipsoid-1];
		    }
		break;
	    case 12:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,"Start theta-angle of ellipsoid [%5.3f]: ",
			    THELLIPSOIDS[nellipsoid-1]*RAD);
		    THELLIPSOIDS[nellipsoid-1] = get_real(THELLIPSOIDS[nellipsoid-1],STRING);
		    THELLIPSOIDS[nellipsoid-1] /= RAD;
		    }
		break;
	    case 13:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,
			    "Serial number of theta-angle parameter [%1d]: ",
			    NTHDISELLIPSOIDS[nellipsoid-1]);
		    NTHDISELLIPSOIDS[nellipsoid-1] = get_int(NTHDISELLIPSOIDS[nellipsoid-1],STRING);
		    if (NTHDISELLIPSOIDS[nellipsoid-1] > NDISELLIPSOIDSTOT) 
			NDISELLIPSOIDSTOT = NTHDISELLIPSOIDS[nellipsoid-1];
		    }
		break;
	    case 14:
		if (NELLIPSOIDS == MAXELLIPSOIDS)
		    {
		    errtype("Maximum number of ellipsoids in model reached");
		    break;
		    }
		NELLIPSOIDS++;

		/* Initialize parameters for new ellipsoid */

		strcpy(NAMEOFELLIPSOIDS[NELLIPSOIDS-1],"");
		XELLIPSOIDS[NELLIPSOIDS-1] = 0;
		NXDISELLIPSOIDS[NELLIPSOIDS-1] = 0;
		YELLIPSOIDS[NELLIPSOIDS-1] = 0;
		NYDISELLIPSOIDS[NELLIPSOIDS-1] = 0;
		ZELLIPSOIDS[NELLIPSOIDS-1] = 0;
		NZDISELLIPSOIDS[NELLIPSOIDS-1] = 0;
		PHIELLIPSOIDS[NELLIPSOIDS-1] = 0;
		NPHIDISELLIPSOIDS[NELLIPSOIDS-1] = 0;
		CHIELLIPSOIDS[NELLIPSOIDS-1] = 0;
		NCHIDISELLIPSOIDS[NELLIPSOIDS-1] = 0;
		THELLIPSOIDS[NELLIPSOIDS-1] = 0;
		NTHDISELLIPSOIDS[NELLIPSOIDS-1] = 0;
		CHARGEOFELLIPSOIDS[NELLIPSOIDS-1] = 0.0;
		ALENGTHOFELLIPSOIDS[NELLIPSOIDS-1] = 0.0;
		NALENGTHOFELLIPSOIDS[NELLIPSOIDS-1] = 0;
		BLENGTHOFELLIPSOIDS[NELLIPSOIDS-1] = 0.0;
		NBLENGTHOFELLIPSOIDS[NELLIPSOIDS-1] = 0;
		CLENGTHOFELLIPSOIDS[NELLIPSOIDS-1] = 0.0;
		NCLENGTHOFELLIPSOIDS[NELLIPSOIDS-1] = 0;
		SOFTNESSOFELLIPSOIDS[NELLIPSOIDS-1] = 0.0;
		NSOFTNESSOFELLIPSOIDS[NELLIPSOIDS-1] = 0;
		OCCUPOFELLIPSOIDS[NELLIPSOIDS-1] = 1.0;
		NOCCUPOFELLIPSOIDS[NELLIPSOIDS-1] = 0;
		sprintf(STRING,"New ellipsoid added, ellipsoid no = %d\n", NELLIPSOIDS);
		type_line(STRING);
		break;
	    case 15:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");

		if (nellipsoid)
		    {
		    /* Shift ellipsoids with higher serial numbers */

		    for (i = nellipsoid-1; i < NELLIPSOIDS-1; i++)
			{
			strcpy(NAMEOFELLIPSOIDS[i], NAMEOFELLIPSOIDS[i+1]);
			XELLIPSOIDS[i] =            XELLIPSOIDS[i+1];
			NXDISELLIPSOIDS[i] =        NXDISELLIPSOIDS[i+1];
			YELLIPSOIDS[i] =            YELLIPSOIDS[i+1];
			NYDISELLIPSOIDS[i] =        NYDISELLIPSOIDS[i+1];
			ZELLIPSOIDS[i] =            ZELLIPSOIDS[i+1];
			NZDISELLIPSOIDS[i] =        NZDISELLIPSOIDS[i+1];
			PHIELLIPSOIDS[i] =          PHIELLIPSOIDS[i+1];
			NPHIDISELLIPSOIDS[i] =      NPHIDISELLIPSOIDS[i+1];
			CHIELLIPSOIDS[i] =          CHIELLIPSOIDS[i+1];
			NCHIDISELLIPSOIDS[i] =      NCHIDISELLIPSOIDS[i+1];
			THELLIPSOIDS[i] =           THELLIPSOIDS[i+1];
			NTHDISELLIPSOIDS[i] =       NTHDISELLIPSOIDS[i+1];
			CHARGEOFELLIPSOIDS[i] =     CHARGEOFELLIPSOIDS[i+1];
			ALENGTHOFELLIPSOIDS[i] =    ALENGTHOFELLIPSOIDS[i+1];
			NALENGTHOFELLIPSOIDS[i] =   NALENGTHOFELLIPSOIDS[i+1]; 
			BLENGTHOFELLIPSOIDS[i] =    BLENGTHOFELLIPSOIDS[i+1];
			NBLENGTHOFELLIPSOIDS[i] =   NBLENGTHOFELLIPSOIDS[i+1]; 
			CLENGTHOFELLIPSOIDS[i] =    CLENGTHOFELLIPSOIDS[i+1];
			NCLENGTHOFELLIPSOIDS[i] =   NCLENGTHOFELLIPSOIDS[i+1]; 
			SOFTNESSOFELLIPSOIDS[i] =   SOFTNESSOFELLIPSOIDS[i+1];
			NSOFTNESSOFELLIPSOIDS[i] =  NSOFTNESSOFELLIPSOIDS[i+1];
			OCCUPOFELLIPSOIDS[i] =      OCCUPOFELLIPSOIDS[i+1];
			NOCCUPOFELLIPSOIDS[i] =     NOCCUPOFELLIPSOIDS[i+1];
			}
		    NELLIPSOIDS--;
		    sprintf(STRING,"Ellipsoid no %d deleted\n", nellipsoid);
		    type_line(STRING);
		    }
		break;
	    case 16:
	        nellipsoid = get_nellipsoid("Ellipsoid number:");
		if (nellipsoid)
		    {
		    sprintf(STRING,"Total charge of ellipsoid [%5.3f]: ",
			    CHARGEOFELLIPSOIDS[nellipsoid-1]);
		    CHARGEOFELLIPSOIDS[nellipsoid-1] = 
			get_real(CHARGEOFELLIPSOIDS[nellipsoid-1],STRING);
		    }
		break;
	    case 17:
	        nellipsoid = get_nellipsoid("Ellipsoid number:");
		if (nellipsoid)
		    {
		    sprintf(STRING,"Length of a axis [%5.3f]: ",
			    ALENGTHOFELLIPSOIDS[nellipsoid-1]);
		    ALENGTHOFELLIPSOIDS[nellipsoid-1] = 
			get_real(ALENGTHOFELLIPSOIDS[nellipsoid-1],STRING);
		    }
		break;
	    case 18:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,
			    "Serial number of a axis[%1d]: ",
			    NALENGTHOFELLIPSOIDS[nellipsoid-1]);
		    NALENGTHOFELLIPSOIDS[nellipsoid-1] = get_int(NALENGTHOFELLIPSOIDS[nellipsoid-1],STRING);
		    if (NALENGTHOFELLIPSOIDS[nellipsoid-1] > NCHARGEDENSITYELLIPSOIDSTOT) 
			NCHARGEDENSITYELLIPSOIDSTOT = NALENGTHOFELLIPSOIDS[nellipsoid-1];
		    }
		break;
	    case 19:
	        nellipsoid = get_nellipsoid("Ellipsoid number:");
		if (nellipsoid)
		    {
		    sprintf(STRING,"Length of b axis [%5.3f]: ",
			    BLENGTHOFELLIPSOIDS[nellipsoid-1]);
		    BLENGTHOFELLIPSOIDS[nellipsoid-1] = 
			get_real(BLENGTHOFELLIPSOIDS[nellipsoid-1],STRING);
		    }
		break;
	    case 20:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,
			    "Serial number of b axis[%1d]: ",
			    NBLENGTHOFELLIPSOIDS[nellipsoid-1]);
		    NBLENGTHOFELLIPSOIDS[nellipsoid-1] = get_int(NBLENGTHOFELLIPSOIDS[nellipsoid-1],STRING);
		    if (NBLENGTHOFELLIPSOIDS[nellipsoid-1] > NCHARGEDENSITYELLIPSOIDSTOT) 
			NCHARGEDENSITYELLIPSOIDSTOT = NBLENGTHOFELLIPSOIDS[nellipsoid-1];
		    }
		break;
	    case 21:
	        nellipsoid = get_nellipsoid("Ellipsoid number:");
		if (nellipsoid)
		    {
		    sprintf(STRING,"Length of c axis [%5.3f]: ",
			    CLENGTHOFELLIPSOIDS[nellipsoid-1]);
		    CLENGTHOFELLIPSOIDS[nellipsoid-1] = 
			get_real(CLENGTHOFELLIPSOIDS[nellipsoid-1],STRING);
		    }
		break;
	    case 22:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,
			    "Serial number of c axis[%1d]: ",
			    NCLENGTHOFELLIPSOIDS[nellipsoid-1]);
		    NCLENGTHOFELLIPSOIDS[nellipsoid-1] = get_int(NCLENGTHOFELLIPSOIDS[nellipsoid-1],STRING);
		    if (NCLENGTHOFELLIPSOIDS[nellipsoid-1] > NCHARGEDENSITYELLIPSOIDSTOT) 
			NCHARGEDENSITYELLIPSOIDSTOT = NCLENGTHOFELLIPSOIDS[nellipsoid-1];
		    }
		break;
	    case 23:
	        nellipsoid = get_nellipsoid("Ellipsoid number:");
		if (nellipsoid)
		    {
		    sprintf(STRING,"Softness of ellipsoid [%5.3f]: ",
			    SOFTNESSOFELLIPSOIDS[nellipsoid-1]);
		    SOFTNESSOFELLIPSOIDS[nellipsoid-1] = 
			get_real(SOFTNESSOFELLIPSOIDS[nellipsoid-1],STRING);
		    }
		break;
	    case 24:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,
			    "Serial number of softness[%1d]: ",
			    NSOFTNESSOFELLIPSOIDS[nellipsoid-1]);
		    NSOFTNESSOFELLIPSOIDS[nellipsoid-1] = get_int(NSOFTNESSOFELLIPSOIDS[nellipsoid-1],STRING);
		    if (NSOFTNESSOFELLIPSOIDS[nellipsoid-1] > NCHARGEDENSITYELLIPSOIDSTOT) 
			NCHARGEDENSITYELLIPSOIDSTOT = NSOFTNESSOFELLIPSOIDS[nellipsoid-1];
		    }
		break;
	    case 25:
	        nellipsoid = get_nellipsoid("Ellipsoid number:");
		if (nellipsoid)
		    {
		    sprintf(STRING,"Occupancy of ellipsoid [%5.3f]: ",
			    OCCUPOFELLIPSOIDS[nellipsoid-1]);
		    OCCUPOFELLIPSOIDS[nellipsoid-1] = 
			get_real(OCCUPOFELLIPSOIDS[nellipsoid-1],STRING);
		    }
		break;
	    case 26:
		nellipsoid = get_nellipsoid("Ellipsoid number: ");
		if (nellipsoid)
		    {
		    sprintf(STRING,
			    "Serial number of occupancy[%1d]: ",
			    NOCCUPOFELLIPSOIDS[nellipsoid-1]);
		    NOCCUPOFELLIPSOIDS[nellipsoid-1] = get_int(NOCCUPOFELLIPSOIDS[nellipsoid-1],STRING);
		    if (NOCCUPOFELLIPSOIDS[nellipsoid-1] > NCHARGEDENSITYELLIPSOIDSTOT) 
			NCHARGEDENSITYELLIPSOIDSTOT = NOCCUPOFELLIPSOIDS[nellipsoid-1];
		    }
		break;
	    case 30:
		if (!NELLIPSOIDS) type_line("No ellipsoids defined.\n");
		else
		    {
		    clear_screen();
		    for (i = 0; i < NELLIPSOIDS; i++)
		        {
			sprintf(STRING,
				"%2s %10s %7s %2s %7s %2s %7s %2s %7s %2s %7s %2s %7s %2s\n", 
				"#","name",
				"x +","d",
				"y +","d",
				"z +","d",
				"phi +","d",
				"chi +","d",
				"th +","d");
			type_list(STRING,ROWS);
			sprintf(STRING,
				"%2d %10s %7.4f %2d %7.4f %2d %7.4f %2d %7.4f %2d %7.4f %2d %7.4f %2d\n",
				i+1, NAMEOFELLIPSOIDS[i],
				XELLIPSOIDS[i], NXDISELLIPSOIDS[i],
				YELLIPSOIDS[i], NYDISELLIPSOIDS[i],
				ZELLIPSOIDS[i], NZDISELLIPSOIDS[i],
				PHIELLIPSOIDS[i]*RAD, NPHIDISELLIPSOIDS[i],
				CHIELLIPSOIDS[i]*RAD, NCHIDISELLIPSOIDS[i],
				THELLIPSOIDS[i]*RAD, NTHDISELLIPSOIDS[i]);
			type_list(STRING,ROWS);
			sprintf(STRING,
				"%2s %10s %7s %2s %7s %2s %7s %2s %7s %2s %7s %2s %7s %2s\n", 
				"", "",
				"charge", "",
				"a axis","d",
				"b axis","d",
				"c axis","d",
				"softn.","d",
				"occup.","d");
			type_list(STRING,ROWS);
			sprintf(STRING,
				"%2s %10s %7.4f %2s %7.4f %2d %7.4f %2d %7.4f %2d %7.4f %2d %7.4f %2d\n", 
				"", "",
				CHARGEOFELLIPSOIDS[i], "",
				ALENGTHOFELLIPSOIDS[i],  NALENGTHOFELLIPSOIDS[i],
				BLENGTHOFELLIPSOIDS[i],  NBLENGTHOFELLIPSOIDS[i],
				CLENGTHOFELLIPSOIDS[i],  NCLENGTHOFELLIPSOIDS[i],
				SOFTNESSOFELLIPSOIDS[i], NSOFTNESSOFELLIPSOIDS[i],
				OCCUPOFELLIPSOIDS[i],    NOCCUPOFELLIPSOIDS[i]);
			type_list(STRING,ROWS);
			}
		    }
		break;
	    case 31:
		list_menu("ELLIPSOID MODEL PARAMETERS",
			  set_ellipsoid_menu,set_ellipsoid_length);
		break;
	    case 32:
		stop = TRUE;
	    }
	}
    update_model();
    }



/***************************************************************************/
void    bulk_mult(void)
/***************************************************************************/
     
 /*
   Utilility for expanding bulk unit cells.
 */

    {
    int amult = 1, bmult = 1, i, a, b, index;
    float  xbnew, ybnew;
    int     tb_tmp[MAXATOMS];
    float   xb_tmp[MAXATOMS];
    float   yb_tmp[MAXATOMS];
    float   zb_tmp[MAXATOMS];
    int     ndwb_tmp[MAXATOMS];


    if (NBULK > 0)
	{
	for (i = 0; i < NBULK; i++)
	    {
	    tb_tmp[i]   = TB[i];
	    xb_tmp[i]   = XB[i];
	    yb_tmp[i]   = YB[i];
	    zb_tmp[i]   = ZB[i];
	    ndwb_tmp[i] = NDWB[i];
	    }

	sprintf(STRING,"Bulk multiplicity in a direction[%d]:", amult);
	amult = get_int(amult,STRING);
	sprintf(STRING,"Bulk multiplicity in b direction[%d]:", bmult);
	bmult = get_int(bmult,STRING);

	if ((NBULK*amult*bmult) < MAXATOMS)
	    {
	    if ((NSURF+NCYLINDERS+NELLIPSOIDS)==0)
		{
		DLAT[0] = DLAT[0]*amult;
		DLAT[1] = DLAT[1]*bmult;
		}
	    index = 0;
	    for (i = 0; i < NBULK; i++)
		for (a = 0; a < amult; a++)
		    for (b = 0; b < bmult; b++)
			{
			TB[index]   = tb_tmp[i];
			XB[index]   = (xb_tmp[i]+(float)a)/(float)amult;
			YB[index]   = (yb_tmp[i]+(float)b)/(float)bmult;
			ZB[index]   = zb_tmp[i];
			NDWB[index] = ndwb_tmp[i];
			index++;
			}
	    NBULK = NBULK*amult*bmult;
	    sprintf(STRING,"\nNumber of atoms in expanded bulk unit cell: %d\n",NBULK);
	    type_line(STRING);
	    sprintf(STRING,"New lattice parameters:\n%4.8f %4.8f %4.8f %4.8f %4.8f %4.8f\n",
		    DLAT[0], DLAT[1], DLAT[2], DLAT[3]*RAD, DLAT[4]*RAD, DLAT[5]*RAD);
	    type_line(STRING);
	    sprintf(STRING,"Don't forget to save this expanded bulk unit cell in a \".bul\" file.\n");
	    type_line(STRING);
	    } else {
	    sprintf(STRING, "ERROR, maximum number of atoms allowed in bulk unit cell exceeded (MAXATOMS=%d.\n", MAXATOMS); 
	    errtype(STRING);
	    }
	} else {
	errtype("ERROR, no atoms in bulk model.");
	}

    }



/***************************************************************************/
void overlap_check(void)
/***************************************************************************/

    {
    int i, j, cell=1;
    float x1, y1, z1, x2, y2, z2, dist, minDist;
    float dx, dy, dz;  

    if (NSURF2)
	{
	sprintf(STRING,"Select surface cell: 1=first, 2=second [%1d]: ", 
		cell);
	cell = get_int(WALKER_SECOND,STRING);
	while ((cell < 1) || (cell > 2))
	    {
	    cell = 1;
	    errtype("ERROR! Value must be 1 or 2");
	    cell = get_int(cell,STRING);
	    }
	}
    minDist = 1.0E7;
    calc_atoms_orth_coord(2, 2, 2, cell);
    if (NORTHONORMAL > 1)
	{
	for (i=0; i<NORTHONORMAL-1; i++)
	    for (j=i+1; j<NORTHONORMAL; j++)
		{
		x1 = XORTHONORMAL[i];
		y1 = YORTHONORMAL[i];
		z1 = ZORTHONORMAL[i];
		x2 = XORTHONORMAL[j];
		y2 = YORTHONORMAL[j];
		z2 = ZORTHONORMAL[j];
		dx = x1-x2;
		dy = y1-y2;
		dz = z1-z2;
		dist = sqrt(dx*dx+dy*dy+dz*dz);
		if (dist < 0.5)
		    {
		    sprintf(STRING, "Warning! Distance = %f [A] between following atoms:\n", dist);
		    type_line(STRING);
		    sprintf(STRING,"%2s %11.5f %11.5f %11.5f\n",
			    ELEMENT[TORTHONORMAL[i]],x1,y1,z1);
		    type_line(STRING);
		    sprintf(STRING,"%2s %11.5f %11.5f %11.5f\n",
			    ELEMENT[TORTHONORMAL[j]],x2,y2,z2);
		    type_line(STRING);
		    }
		if (dist < minDist) minDist = dist;
		}
	sprintf(STRING, "Minimum distance between atoms: %f [A]\n", minDist);
	type_line(STRING);
	} 
    else 
	{
	errtype("ERROR, no atoms in model.");
	}

    }


/***************************************************************************/
int signum(int value)
/***************************************************************************/
    {
    if (value > 0)
	return 1;
    else
	return -1;
    }

/***************************************************************************/
void read_cylinder_fit(FILE *infile, char *cylinder_name)
/***************************************************************************/
    {
    int cylinder_index;

    /* Read cylinder coordinates */
    NCYLINDERS++;
    cylinder_index = NCYLINDERS-1;
    strcpy(NAMEOFCYLINDERS[cylinder_index],cylinder_name);
    fgets(INLINE,INLLEN,infile);
    sscanf(INLINE,"%f%d%f%d%f%d%f%d%f%d",
	   &XCYLINDERS[cylinder_index],
	   &NXDISCYLINDERS[cylinder_index],
	   &YCYLINDERS[cylinder_index], 
	   &NYDISCYLINDERS[cylinder_index], 
	   &ZCYLINDERS[cylinder_index],
	   &NZDISCYLINDERS[cylinder_index],
	   &TCYLINDERS[cylinder_index],
	   &NTDISCYLINDERS[cylinder_index],
	   &PSICYLINDERS[cylinder_index],
	   &NPSIDISCYLINDERS[cylinder_index]);
    TCYLINDERS[cylinder_index] /= RAD;
    PSICYLINDERS[cylinder_index]  /= RAD;
    fgets(INLINE,INLLEN,infile);
    sscanf(INLINE,"%f%f%d%f%d%f%d%f%d%f",
	   &CHARGEOFCYLINDERS[cylinder_index],
	   &LENGTHOFCYLINDERS[cylinder_index], 
	   &NLENGTHOFCYLINDERS[cylinder_index], 
	   &RADIUSOFCYLINDERS[cylinder_index],
	   &NRADIUSOFCYLINDERS[cylinder_index],
	   &SOFTNESSOFCYLINDERS[cylinder_index],
	   &NSOFTNESSOFCYLINDERS[cylinder_index],
	   &OCCUPOFCYLINDERS[cylinder_index],
	   &NOCCUPOFCYLINDERS[cylinder_index],
	   &ORIGINOFCYLINDERS[cylinder_index]);
    } /* read_cylinder_fit */


/***************************************************************************/
void read_ellipsoid_fit(FILE *infile, char *ellipsoid_name)
/***************************************************************************/
    {
    int ellipsoid_index;

    /* Read ellipsoid coordinates */
    NELLIPSOIDS++;
    ellipsoid_index = NELLIPSOIDS-1;
    strcpy(NAMEOFELLIPSOIDS[ellipsoid_index],ellipsoid_name);
    fgets(INLINE,INLLEN,infile);
    sscanf(INLINE,"%f%d%f%d%f%d%f%d%f%d%f%d",
	   &XELLIPSOIDS[ellipsoid_index],
	   &NXDISELLIPSOIDS[ellipsoid_index],
	   &YELLIPSOIDS[ellipsoid_index], 
	   &NYDISELLIPSOIDS[ellipsoid_index], 
	   &ZELLIPSOIDS[ellipsoid_index],
	   &NZDISELLIPSOIDS[ellipsoid_index],
	   &PHIELLIPSOIDS[ellipsoid_index],
	   &NPHIDISELLIPSOIDS[ellipsoid_index],
	   &CHIELLIPSOIDS[ellipsoid_index],
	   &NCHIDISELLIPSOIDS[ellipsoid_index],
	   &THELLIPSOIDS[ellipsoid_index],
	   &NTHDISELLIPSOIDS[ellipsoid_index]);
    CHIELLIPSOIDS[ellipsoid_index] /= RAD;
    THELLIPSOIDS[ellipsoid_index]  /= RAD;
    fgets(INLINE,INLLEN,infile);
    sscanf(INLINE,"%f%f%d%f%d%f%d%f%d%f%d",
	   &CHARGEOFELLIPSOIDS[ellipsoid_index],
	   &ALENGTHOFELLIPSOIDS[ellipsoid_index], 
	   &NALENGTHOFELLIPSOIDS[ellipsoid_index], 
	   &BLENGTHOFELLIPSOIDS[ellipsoid_index], 
	   &NBLENGTHOFELLIPSOIDS[ellipsoid_index], 
	   &CLENGTHOFELLIPSOIDS[ellipsoid_index], 
	   &NCLENGTHOFELLIPSOIDS[ellipsoid_index], 
	   &SOFTNESSOFELLIPSOIDS[ellipsoid_index],
	   &NSOFTNESSOFELLIPSOIDS[ellipsoid_index],
	   &OCCUPOFELLIPSOIDS[ellipsoid_index],
	   &NOCCUPOFELLIPSOIDS[ellipsoid_index]);
    } /* read_ellipsoid_fit */


/***************************************************************************/
void read_group_fit(FILE *infile, char *group_name,
		    float xorg, float yorg, float zorg, float occupancy)
/***************************************************************************/
    {
    int group_index, atom_index;  
    char keyword[20];

    /* Yes, we have found a group! */
    NGROUPSS++;
    group_index = NGROUPSS-1;
    strcpy(NAMEOFGROUPS[group_index],group_name);
    ORIGINOFATOMSINGROUPS[group_index][0] = xorg;
    ORIGINOFATOMSINGROUPS[group_index][1] = yorg;
    ORIGINOFATOMSINGROUPS[group_index][2] = zorg;
    OCCUPANCYOFGROUPS[group_index] = occupancy;
  
    /* Read group coordinates */
    fgets(INLINE,INLLEN,infile);
    sscanf(INLINE,"%f%d%f%d%f%d%f%d%f%d%f%d",
	   &XGROUPS[group_index],   
	   &NXDISGROUPS[group_index], 
	   &YGROUPS[group_index],   
	   &NYDISGROUPS[group_index],  
	   &ZGROUPS[group_index],   
	   &NZDISGROUPS[group_index],
	   &PHIGROUPS[group_index], 
	   &NPHIDISGROUPS[group_index], 
	   &CHIGROUPS[group_index], 
	   &NCHIDISGROUPS[group_index], 
	   &THGROUPS[group_index],  
	   &NTHDISGROUPS[group_index]);
    
    fgets(INLINE,INLLEN,infile);
    sscanf(INLINE,"%d%d%d%d%d%d",
    &SNEXPX[group_index],&SNEXPY[group_index],&SNEXPZ[group_index],&SNSHEARXY[group_index],&SNSHEARZX[group_index],&SNSHEARYZ[group_index]);
    
    PHIGROUPS[group_index]      /= RAD;
    CHIGROUPS[group_index]      /= RAD;
    THGROUPS[group_index]       /= RAD;
    NATOMSINGROUPS[group_index]=0;
    /* Read atom coordinates */
    fgets(INLINE,INLLEN,infile);      
    sscanf(INLINE,"%s", keyword);
    while (strncmp(keyword,"endgr",5))
	{
	NATOMSINGROUPS[group_index]++;
	atom_index = NATOMSINGROUPS[group_index]-1;
	sscanf(INLINE,"%2s%f%f%f%d",
	       ELSURFGROUPS[group_index][atom_index],
	       &XATOMINGROUPS[group_index][atom_index],
	       &YATOMINGROUPS[group_index][atom_index],
	       &ZATOMINGROUPS[group_index][atom_index],
	       &NDWSATOMINGROUPS[group_index][atom_index]);
	fgets(INLINE,INLLEN,infile);      
	sscanf(INLINE,"%s", keyword);
	}
    } /* read_group_fit */



/***************************************************************************/
int parse_symmetry_card()
/***************************************************************************/
    {
    int symm_index, parse_error, state_machine, sign, field, factor;
    float add_value;
    char *p;

    /* Parse symmetry card line */
    symm_index = 0;
    /* Find position of first character */
    p = INLINE;
    p = strchr(p, ' ');
  
    /* Loop over the three field separated by commas */
    field = 0;
    parse_error = 0;
    state_machine = 1;
    sign = 1;
    add_value = 0.0;
    while (state_machine)
	{
	switch (*p) 
	    {
	    case '\n':
	    case '\r':
	    case '\0':
		if ((state_machine == 2) || 
		    (state_machine == 4) || 
		    (state_machine == 5) ||
		    (field != 2))
		    {
		    parse_error = 1;
		    }
		SYMMTABLEADD[NSYMMCARDS][field] = add_value*sign;
		add_value = 0.0;
		state_machine = 0;
		break;
	    case ' ':
		p++;
		break;
	    case 'X':
	    case 'x':
		if ((state_machine == 1) || (state_machine == 2))
		    {
		    SYMMTABLEXYZ[NSYMMCARDS][field] = 1*sign;
		    state_machine = 3;
		    p++;
		    } else {
		    state_machine = 0;
		    parse_error = 1;
		    }
		break;
	    case 'Y':
	    case 'y':
		if ((state_machine == 1) || (state_machine == 2))
		    {
		    SYMMTABLEXYZ[NSYMMCARDS][field] = 2*sign;
		    state_machine = 3;
		    p++;
		    } else {
		    state_machine = 0;
		    parse_error = 1;
		    }
		break;
	    case 'Z':
	    case 'z':
		if ((state_machine == 1) || (state_machine == 2))
		    {
		    SYMMTABLEXYZ[NSYMMCARDS][field] = 3*sign;
		    state_machine = 3;
		    p++;
		    } else {
		    state_machine = 0;
		    parse_error = 1;
		    }
		break;
	    case '+':
		if ((state_machine == 1) || (state_machine == 3))
		    {
		    sign = 1;
		    if (state_machine == 1)
			{
			state_machine = 2;
			} else {
			state_machine = 4;
			}
		    p++;
		    } else {
		    state_machine = 0;
		    parse_error = 1;
		    }
		break;
	    case '-':
		if ((state_machine == 1) || (state_machine == 3))
		    {
		    sign = -1;
		    if (state_machine == 1)
			{
			state_machine = 2;
			} else {
			state_machine = 4;
			}
		    p++;
		    } else {
		    state_machine = 0;
		    parse_error = 1;
		    }
		break;
	    case '0':
		if (state_machine == 4)
		    {
		    state_machine = 5;
		    p++;
		    } else if (state_machine == 6)
			{
			factor *= 10;
			p++;
			} else {
			state_machine = 0;
			parse_error = 1;
			}
		break;
	    case '.':
		if ((state_machine == 4) || (state_machine == 5))
		    {
		    add_value = 0.0;
		    factor = 10;
		    state_machine = 6;
		    p++;
		    } else {
		    state_machine = 0;
		    parse_error = 1;
		    }
		break;
		break;
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
	    case '8':
	    case '9':
		if (state_machine == 6)
		    {
		    add_value += ((float)(*p-'0'))/factor;
		    factor *= 10;
		    p++;
		    } else {
		    state_machine = 0;
		    parse_error = 1;
		    }
		break;
	    case ',':
		if ((state_machine == 3) || (state_machine == 6))
		    {
		    SYMMTABLEADD[NSYMMCARDS][field] = add_value*sign;
		    add_value = 0.0;
		    field++;
		    sign = 1;
		    if (field > 2)
			{
			state_machine = 0;
			parse_error = 1;
			} else {
			state_machine = 1;
			}
		    p++;
		    } else {
		    state_machine = 0;
		    parse_error = 1;
		    }
		break;
	    default:
		state_machine = 0;
		parse_error = 1;
		break;
	    }
	}
    NSYMMCARDS++;
    return parse_error;
    }

/***************************************************************************/
void read_ellipsoid_surf(FILE *infile, char *ellipsoid_name)
/***************************************************************************/
    {
    int ellipsoid_index;

    NELLIPSOIDS++;
    ellipsoid_index = NELLIPSOIDS-1;
    strcpy(NAMEOFELLIPSOIDS[ellipsoid_index],ellipsoid_name);
    fgets(INLINE,INLLEN,infile);
    sscanf(INLINE,"%f%f%f%f%f%f",
	   &XELLIPSOIDS[ellipsoid_index],
	   &YELLIPSOIDS[ellipsoid_index], 
	   &ZELLIPSOIDS[ellipsoid_index],
	   &PHIELLIPSOIDS[ellipsoid_index],
	   &CHIELLIPSOIDS[ellipsoid_index],
	   &THELLIPSOIDS[ellipsoid_index]);
    PHIELLIPSOIDS[ellipsoid_index] /= RAD;
    CHIELLIPSOIDS[ellipsoid_index] /= RAD;
    THELLIPSOIDS[ellipsoid_index]  /= RAD;
    fgets(INLINE,INLLEN,infile);
    sscanf(INLINE,"%f%f%f%f%f%f",
	   &CHARGEOFELLIPSOIDS[ellipsoid_index],
	   &ALENGTHOFELLIPSOIDS[ellipsoid_index], 
	   &BLENGTHOFELLIPSOIDS[ellipsoid_index], 
	   &CLENGTHOFELLIPSOIDS[ellipsoid_index], 
	   &SOFTNESSOFELLIPSOIDS[ellipsoid_index],
	   &OCCUPOFELLIPSOIDS[ellipsoid_index]);
    NXDISELLIPSOIDS[ellipsoid_index] = 0;
    NYDISELLIPSOIDS[ellipsoid_index] = 0;
    NZDISELLIPSOIDS[ellipsoid_index] = 0;
    NPHIDISELLIPSOIDS[ellipsoid_index] = 0;
    NCHIDISELLIPSOIDS[ellipsoid_index] = 0;
    NTHDISELLIPSOIDS[ellipsoid_index] = 0;
    NALENGTHOFELLIPSOIDS[ellipsoid_index] = 0;
    NBLENGTHOFELLIPSOIDS[ellipsoid_index] = 0;
    NCLENGTHOFELLIPSOIDS[ellipsoid_index] = 0;
    NSOFTNESSOFELLIPSOIDS[ellipsoid_index] = 0;
    NOCCUPOFELLIPSOIDS[ellipsoid_index] = 0;
    } /* read_ellipsoid_surf */


/***************************************************************************/
void read_cylinder_surf(FILE *infile, char *cylinder_name)
/***************************************************************************/
    {
    int cylinder_index;

    /* Read cylinder coordinates */
    NCYLINDERS++;
    cylinder_index = NCYLINDERS-1;
    strcpy(NAMEOFCYLINDERS[cylinder_index],cylinder_name);
    fgets(INLINE,INLLEN,infile);
    sscanf(INLINE,"%f%f%f%f%f",
	   &XCYLINDERS[cylinder_index],
	   &YCYLINDERS[cylinder_index], 
	   &ZCYLINDERS[cylinder_index],
	   &TCYLINDERS[cylinder_index],
	   &PSICYLINDERS[cylinder_index]);
    TCYLINDERS[cylinder_index] /= RAD;
    PSICYLINDERS[cylinder_index]  /= RAD;
    fgets(INLINE,INLLEN,infile);
    sscanf(INLINE,"%f%f%f%f%f%f",
	   &CHARGEOFCYLINDERS[cylinder_index],
	   &LENGTHOFCYLINDERS[cylinder_index], 
	   &RADIUSOFCYLINDERS[cylinder_index],
	   &SOFTNESSOFCYLINDERS[cylinder_index],
	   &OCCUPOFCYLINDERS[cylinder_index],
	   &ORIGINOFCYLINDERS[cylinder_index]);
    NXDISCYLINDERS[cylinder_index] = 0;
    NYDISCYLINDERS[cylinder_index] = 0;
    NZDISCYLINDERS[cylinder_index] = 0;
    NTDISCYLINDERS[cylinder_index] = 0;
    NPSIDISCYLINDERS[cylinder_index] = 0;
    NLENGTHOFCYLINDERS[cylinder_index] = 0;
    NRADIUSOFCYLINDERS[cylinder_index] = 0;
    NSOFTNESSOFCYLINDERS[cylinder_index] = 0;
    NOCCUPOFCYLINDERS[cylinder_index] = 0;
    } /* read_cylinder_surf */


/***************************************************************************/
void read_group_surf(FILE *infile, char *group_name,
		     float xorg, float yorg, float zorg, float occupancy)
/***************************************************************************/
    {
    int group_index;
  
    NGROUPSS++;
    group_index = NGROUPSS-1;
    strcpy(NAMEOFGROUPS[group_index],group_name);
    ORIGINOFATOMSINGROUPS[group_index][0] = xorg;
    ORIGINOFATOMSINGROUPS[group_index][1] = yorg;
    ORIGINOFATOMSINGROUPS[group_index][2] = zorg;
    OCCUPANCYOFGROUPS[group_index] = occupancy;
  
    /* Read group coordinates */
    fgets(INLINE,INLLEN,infile);
    sscanf(INLINE,"%f%f%f%f%f%f",&XGROUPS[group_index],
	   &YGROUPS[group_index], &ZGROUPS[group_index],
	   &PHIGROUPS[group_index],	&CHIGROUPS[group_index],
	   &THGROUPS[group_index]);
    PHIGROUPS[group_index] /= RAD;
    CHIGROUPS[group_index] /= RAD;
    THGROUPS[group_index]  /= RAD;
    NXDISGROUPS[group_index] = 0;
    NYDISGROUPS[group_index] = 0;
    NZDISGROUPS[group_index] = 0;
    NPHIDISGROUPS[group_index] = 0;
    NCHIDISGROUPS[group_index] = 0;
    NTHDISGROUPS[group_index] = 0;
    NATOMSINGROUPS[group_index]=0;
  
    }

/***************************************************************************/
void list_symm_cards(int terminal, FILE *listfile)
/***************************************************************************/
    {
    int i, field;
    char buff[20];

    if (NSYMMCARDS > 0)
	{
	for (i = 0; i < NSYMMCARDS; i++)
	    {
	    sprintf(STRING, "SYMM ");
	    for (field = 0; field < 3; field++)
		{
		if (SYMMTABLEXYZ[i][field] == 1)
		    {
		    strcat(STRING, "+X");
		    } else if (SYMMTABLEXYZ[i][field] == -1)
			{
			strcat(STRING, "-X");
			} else if (SYMMTABLEXYZ[i][field] ==  2)
			    {
			    strcat(STRING, "+Y");
			    } else if (SYMMTABLEXYZ[i][field] == -2)
				{
				strcat(STRING, "-Y");
				} else if (SYMMTABLEXYZ[i][field] ==  3)
				    {
				    strcat(STRING, "+Z");
				    } else if (SYMMTABLEXYZ[i][field] == -3)
					{
					strcat(STRING, "-Z");
					}
		if (fabs(SYMMTABLEADD[i][field]) >0.01)
		    {
		    if (SYMMTABLEADD[i][field] > 0.0)
			{
			strcat(STRING, "+");
			}
		    sprintf(buff, "%.2f", SYMMTABLEADD[i][field]);
		    strcat(STRING, buff);
		    } 
		if (field < 2)
		    {
		    strcat(STRING, ", ");
		    if (fabs(SYMMTABLEADD[i][field]) < 0.01)
			{
			strcat(STRING, "     ");
			}
		    }
		} 
	    strcat(STRING, "\n");
	    if (terminal) type_line(STRING);
	    else fprintf(listfile,"%s",STRING);
	    }
	}
    }


/***************************************************************************/
void list_groups_cylindes_ellipsoids_smodel(int terminal, FILE *listfile)
/***************************************************************************/
    {
    int i, j;
    float xorg, yorg, zorg, occupancy;
    float b1;
  
    for (i = 0; i < NGROUPSS; i++)
	{
	xorg = ORIGINOFATOMSINGROUPSFIT[i][0];
	yorg = ORIGINOFATOMSINGROUPSFIT[i][1];
	zorg = ORIGINOFATOMSINGROUPSFIT[i][2];
	occupancy = OCCUPANCYOFGROUPS[i];
	if (terminal) 
	    {
	    sprintf(STRING,"Group name: %s\n",NAMEOFGROUPS[i]);
	    type_list(STRING,ROWS);
	    }
	else
	    { 
	    fprintf(listfile,"group %s %7.4f %7.4f %7.4f %7.4f\n",
		    NAMEOFGROUPS[i], xorg, yorg, zorg, occupancy);
	    }
	if (terminal)
	    { 
	    sprintf(STRING,"Group coordinates (x,y,z,phi,chi,th): %6.4f %6.4f %6.4f %6.4f %6.4f %6.4f\n",
		    XGROUPSFIT[i], YGROUPSFIT[i], ZGROUPSFIT[i],
		    PHIGROUPSFIT[i]*RAD, CHIGROUPSFIT[i]*RAD, THGROUPSFIT[i]*RAD);
	    type_list(STRING,ROWS);
	    }
	else
	    { 
	    sprintf(STRING,"%6.4f %6.4f %6.4f %6.4f %6.4f %6.4f\n",
		    XGROUPSFIT[i], YGROUPSFIT[i], ZGROUPSFIT[i],
		    PHIGROUPSFIT[i]*RAD, CHIGROUPSFIT[i]*RAD, THGROUPSFIT[i]*RAD);
	    fprintf(listfile,"%s",STRING);
	    }
	if (terminal)
	    {
	    sprintf(STRING, "Origin of atom positions: %7.4f %7.4f %7.4f  Occupancy: %7.4f\n", 
		    xorg, yorg, zorg, occupancy);
	    type_list(STRING,ROWS);
	    }
	for (j = 0; j < NATOMSINGROUPS[i]; j++)
	    {
	    if (NDWSATOMINGROUPS[i][j] == 0)
		b1 = 0.;
	    else
		b1 = DEBWALGROUPS[NDWSATOMINGROUPS[i][j]-1];
	    sprintf(STRING,"%2s %11.5f %11.5f %11.5f %3d %4.2f\n",
		    ELEMENT[TATOMINGROUPS[i][j]],
		    XATOMINGROUPSFIT[i][j],
		    YATOMINGROUPSFIT[i][j],
		    ZATOMINGROUPSFIT[i][j],
		    NDWSATOMINGROUPS[i][j], b1);
	    if (terminal) type_list(STRING,ROWS);
	    else fprintf(listfile,"%s",STRING);
	    }
	if (!terminal) fprintf(listfile,"endgroup\n",STRING);
	}
    for (i = 0; i < NCYLINDERS; i++)
	{
	if (terminal) 
	    {
	    sprintf(STRING,"Cylinder name: %s\n",NAMEOFCYLINDERS[i]);
	    type_list(STRING,ROWS);
	    }
	else
	    { 
	    fprintf(listfile,"cylinder %s\n", NAMEOFGROUPS[i]);
	    }
	if (terminal) 
	    {
	    sprintf(STRING,"Cylinder coordinates (x,y,z,t,psi): %6.4f %6.4f %6.4f %6.4f %6.4f\n",
		    XCYLINDERSFIT[i], YCYLINDERSFIT[i], ZCYLINDERSFIT[i],
		    TCYLINDERSFIT[i]*RAD, PSICYLINDERSFIT[i]*RAD);
	    type_list(STRING,ROWS);
	    }
	else fprintf(listfile,"%6.4f %6.4f %6.4f %6.4f %6.4f\n",
		     XCYLINDERSFIT[i], YCYLINDERSFIT[i], ZCYLINDERSFIT[i],
		     TCYLINDERSFIT[i]*RAD, PSICYLINDERSFIT[i]*RAD);
	sprintf(STRING,"%6.4f %6.4f %6.4f %6.4f %6.4f %6.4f\n",
		CHARGEOFCYLINDERS[i],
		LENGTHOFCYLINDERSFIT[i],
		RADIUSOFCYLINDERSFIT[i],
		SOFTNESSOFCYLINDERSFIT[i],
		OCCUPOFCYLINDERSFIT[i],
		ORIGINOFCYLINDERS[i]);
	if (terminal) 
	    {
	    type_line("Cylinder charge, length, radius, softness, occupancy, z-origin:\n");
	    type_list(STRING,ROWS);
	    }
	else fprintf(listfile,STRING);
	}
    for (i = 0; i < NELLIPSOIDS; i++)
	{
	if (terminal) 
	    {
	    sprintf(STRING,"Ellipsoid name: %s\n",NAMEOFELLIPSOIDS[i]);
	    type_list(STRING,ROWS);
	    }
	else
	    { 
	    fprintf(listfile,"ellipsoid %s\n", NAMEOFGROUPS[i]);
	    }
	if (terminal) 
	    {
	    sprintf(STRING,"Ellipsoid coordinates (x,y,z,phi,chi,th):\n%6.4f %6.4f %6.4f %6.4f %6.4f %6.4f\n",
		    XELLIPSOIDSFIT[i], YELLIPSOIDSFIT[i], ZELLIPSOIDSFIT[i],
		    PHIELLIPSOIDSFIT[i]*RAD, CHIELLIPSOIDSFIT[i]*RAD, THELLIPSOIDSFIT[i]*RAD);
	    type_list(STRING,ROWS);
	    }
	else fprintf(listfile,"%6.4f %6.4f %6.4f %6.4f %6.4f %6.4f\n",
		     XELLIPSOIDSFIT[i], YELLIPSOIDSFIT[i], ZELLIPSOIDSFIT[i],
		     PHIELLIPSOIDSFIT[i]*RAD, CHIELLIPSOIDSFIT[i]*RAD, THELLIPSOIDSFIT[i]*RAD);
	if (terminal) 
	    {
	    sprintf(STRING,"Ellipsoid charge, a-axis, b-axis, c-axis, softness, occupancy:\n%6.4f %6.4f %6.4f %6.4f %6.4f %6.4f\n",
		    CHARGEOFELLIPSOIDS[i],
		    ALENGTHOFELLIPSOIDSFIT[i],
		    BLENGTHOFELLIPSOIDSFIT[i],
		    CLENGTHOFELLIPSOIDSFIT[i],
		    SOFTNESSOFELLIPSOIDSFIT[i],
		    OCCUPOFELLIPSOIDSFIT[i]);
	    type_list(STRING,ROWS);
	    }
	else fprintf(listfile,"%6.4f %6.4f %6.4f %6.4f %6.4f %6.4f\n",
		     CHARGEOFELLIPSOIDS[i],
		     ALENGTHOFELLIPSOIDSFIT[i],
		     BLENGTHOFELLIPSOIDSFIT[i],
		     CLENGTHOFELLIPSOIDSFIT[i],
		     SOFTNESSOFELLIPSOIDSFIT[i],
		     OCCUPOFELLIPSOIDSFIT[i]);
	}
    }

/***************************************************************************/
void list_groups_cylindes_ellipsoids_fit(int terminal, FILE *listfile)
/***************************************************************************/
    {
    int i, j;
    float xorg, yorg, zorg, occupancy;
    float b1;
  
    for (i=0; i < NGROUPSS; i++)
	{
	xorg = ORIGINOFATOMSINGROUPS[i][0];
	yorg = ORIGINOFATOMSINGROUPS[i][1];
	zorg = ORIGINOFATOMSINGROUPS[i][2];
	occupancy = OCCUPANCYOFGROUPS[i];
	if (terminal)
	    {
	    type_line("Group name: ");
	    type_line(NAMEOFGROUPS[i]);
	    type_line("\n");
	    }
	else
	    {
	    fprintf(listfile,"group %s %7.4f %7.4f %7.4f %7.4f\n",
		    NAMEOFGROUPS[i], xorg, yorg, zorg, occupancy);
	    }
	if (terminal)
	    {
	    type_line("Group coordinates: \n");
	    }
	sprintf(STRING,"%8.5f %2d %8.5f %2d %8.5f %2d %8.5f %2d %8.5f %2d %8.5f %2d\n",
		XGROUPS[i],       NXDISGROUPS[i], 
		YGROUPS[i],       NYDISGROUPS[i],  
		ZGROUPS[i],       NZDISGROUPS[i],
		PHIGROUPS[i]*RAD, NPHIDISGROUPS[i], 
		CHIGROUPS[i]*RAD, NCHIDISGROUPS[i], 
		THGROUPS[i]*RAD,  NTHDISGROUPS[i]);
	if (terminal) type_list(STRING,ROWS);
	else fprintf(listfile,"%s",STRING);
	if (terminal)
	    {
	    sprintf(STRING, "Origin of atom positions: %7.4f %7.4f %7.4f  Occupancy: %7.4f\n", 
		    xorg, yorg, zorg, occupancy);
	    type_list(STRING,ROWS);
	    }
	for (j = 0; j < NATOMSINGROUPS[i]; j++)
	    {
	    if (NDWSATOMINGROUPS[i][j] == 0)
		b1 = 0.;
	    else
		b1 = DEBWALGROUPS[NDWSATOMINGROUPS[i][j]-1];
      
	    sprintf(STRING,"%2s %11.5f %11.5f %11.5f %3d %4.2f\n",
		    ELEMENT[TATOMINGROUPS[i][j]],
		    XATOMINGROUPS[i][j],
		    YATOMINGROUPS[i][j],
		    ZATOMINGROUPS[i][j],
		    NDWSATOMINGROUPS[i][j], b1);
	    if (terminal) type_list(STRING,ROWS);
	    else fprintf(listfile,"%s",STRING);
	    }
	if (terminal)
	    {
	    type_line("End of group ");
	    type_line(NAMEOFGROUPS[i]);
	    type_line("\n");
	    }
	else
	    {
	    fprintf(listfile,"endgr\n");
	    }
	}
    for (i = 0; i < NCYLINDERS; i++)
	{
	if (terminal) 
	    {
	    sprintf(STRING,"Cylinder name: %s\n",NAMEOFCYLINDERS[i]);
	    type_list(STRING,ROWS);
	    }
	else
	    { 
	    fprintf(listfile,"cylinder %s\n", NAMEOFGROUPS[i]);
	    }
	if (terminal)
	    {
	    type_line("Cylinder coordinates: \n");
	    }
	sprintf(STRING,"%8.5f %2d %8.5f %2d %8.5f %2d %8.5f %2d %8.5f %2d\n",
		XCYLINDERS[i],         NXDISCYLINDERS[i],
		YCYLINDERS[i],         NYDISCYLINDERS[i], 
		ZCYLINDERS[i],         NZDISCYLINDERS[i],
		TCYLINDERS[i]*RAD,     NTDISCYLINDERS[i], 
		PSICYLINDERS[i]*RAD,   NPSIDISCYLINDERS[i]);
	if (terminal) type_list(STRING,ROWS);
	else fprintf(listfile,"%s",STRING);
	if (terminal) 
	    {
	    type_line("Cylinder charge, length, radius, softness, z-origin:\n");
	    }
	sprintf(STRING,"%8.5f %2s %8.5f %2d %8.5f %2d %8.5f %2d %8.5f %2d %8.5f\n",
		CHARGEOFCYLINDERS[i], "",
		LENGTHOFCYLINDERS[i],      NLENGTHOFCYLINDERS[i],
		RADIUSOFCYLINDERS[i],      NRADIUSOFCYLINDERS[i],
		SOFTNESSOFCYLINDERS[i],    NSOFTNESSOFCYLINDERS[i],
		OCCUPOFCYLINDERS[i],       NOCCUPOFCYLINDERS[i],
		ORIGINOFCYLINDERS[i]);
	if (terminal) type_list(STRING,ROWS);
	else fprintf(listfile,"%s",STRING);
	}
    for (i = 0; i < NELLIPSOIDS; i++)
	{
	if (terminal) 
	    {
	    sprintf(STRING,"Ellipsoid name: %s\n",NAMEOFELLIPSOIDS[i]);
	    type_list(STRING,ROWS);
	    }
	else
	    { 
	    fprintf(listfile,"ellipsoid %s\n", NAMEOFGROUPS[i]);
	    }
	if (terminal)
	    {
	    type_line("Ellipsoid coordinates: \n");
	    }
	sprintf(STRING,"%8.5f %2d %8.5f %2d %8.5f %2d %8.5f %2d %8.5f %2d %8.5f %2d\n",
		XELLIPSOIDS[i],         NXDISELLIPSOIDS[i],
		YELLIPSOIDS[i],         NYDISELLIPSOIDS[i], 
		ZELLIPSOIDS[i],         NZDISELLIPSOIDS[i],
		PHIELLIPSOIDS[i]*RAD,   NPHIDISELLIPSOIDS[i], 
		CHIELLIPSOIDS[i]*RAD,   NCHIDISELLIPSOIDS[i], 
		THELLIPSOIDS[i]*RAD,    NTHDISELLIPSOIDS[i]);
	if (terminal) type_list(STRING,ROWS);
	else fprintf(listfile,"%s",STRING);
	if (terminal) 
	    {
	    type_line("Ellipsoid charge, length, radius, softness:\n");
	    }
	sprintf(STRING,"%8.5f %2s %8.5f %2d %8.5f %2d %8.5f %2d %8.5f %2d %8.5f %2d\n",
		CHARGEOFELLIPSOIDS[i], "",
		ALENGTHOFELLIPSOIDS[i],      NALENGTHOFELLIPSOIDS[i],
		BLENGTHOFELLIPSOIDS[i],      NBLENGTHOFELLIPSOIDS[i],
		CLENGTHOFELLIPSOIDS[i],      NCLENGTHOFELLIPSOIDS[i],
		SOFTNESSOFELLIPSOIDS[i],     NSOFTNESSOFELLIPSOIDS[i],
		OCCUPOFELLIPSOIDS[i],        NOCCUPOFELLIPSOIDS[i]);
	if (terminal) type_list(STRING,ROWS);
	else fprintf(listfile,"%s",STRING);
	}
    }


/***************************************************************************/
void symm_info()
/***************************************************************************/
    {
    int i, noSymmAtoms;

    sprintf(STRING,"\nNumber of symmetry operations: %d\n\n", NSYMMCARDS+1);
    type_list(STRING,ROWS);
    type_line("Atom      X           Y           Z       Multiplicity\n");
    for (i=0; i<NSURF; i++)
	{
	noSymmAtoms = calc_symm_coord(XSFIT[i], YSFIT[i], ZSFIT[i]);
	sprintf(STRING,"%2s %11.5f %11.5f %11.5f %10d\n",
		ELEMENT[TS[i]],XSFIT[i],YSFIT[i],ZSFIT[i], noSymmAtoms+1);
	type_list(STRING,ROWS);
	}
	    


    }

/***************************************************************************/
void    f_surf_svensson(float h, float k, float l, float fat[],
			float dw_par[], float dw_perp[], float dw[], float dw_group[],
			int cell, float re_surf[], float im_surf[])
/***************************************************************************/
    {
    int	        i,j,jj, istart,iend;
    float	hnew,knew,fatom;
    float       xx, yy, zz, xa, yb, zc, radius;

    calculate_transformation_matrices();
    for (j = 0; j < NDOMAIN; j++)
	{
	next_domain(h,k,&hnew,&knew,j); /* Next equivalent Miller indices */

	if (!(ZEROFRACT && ((fmod(hnew,1.) != 0) || (fmod(knew,1.) != 0))))
	    {
	    if (cell == 1)
		{
		istart = 0;
		iend = NGROUPSS - NGROUPSS2;
		}
	    else if (cell == 2)
		{
		istart = NGROUPSS - NGROUPSS2;
		iend = NGROUPSS;
		}
	    for (i = istart; i < iend; i++)
		{
		calculate_rotation_matrix(PHIGROUPSFIT[i], CHIGROUPSFIT[i], THGROUPSFIT[i]);
		for (jj = 0; jj < NATOMSINGROUPS[i]; jj++)
		    {
		    fatom = fat[TATOMINGROUPS[i][jj]]*dw_group[NDWSATOMINGROUPS[i][jj]];
		    calc_rotated_coordinates(
		    XATOMINGROUPSFIT[i][jj]-ORIGINOFATOMSINGROUPSFIT[i][0],
		    YATOMINGROUPSFIT[i][jj]-ORIGINOFATOMSINGROUPSFIT[i][1],
		    ZATOMINGROUPSFIT[i][jj]-ORIGINOFATOMSINGROUPSFIT[i][2],
					      &xx, &yy, &zz);
		    calc_crystal_coordinates(xx,yy,zz,&xa,&yb,&zc);
		    xa += XGROUPSFIT[i];
		    yb += YGROUPSFIT[i];
		    zc += ZGROUPSFIT[i];
		    re_surf[j] += OCCUPANCYOFGROUPS[i]*fatom*cos(2*PI*(hnew*xa+knew*yb+l*zc));
		    im_surf[j] += OCCUPANCYOFGROUPS[i]*fatom*sin(2*PI*(hnew*xa+knew*yb+l*zc));
		    }
		}
	    for (i = 0; i < NCYLINDERS; i++)
		{
		fatom = cylinder_scattering_factor(
		    hnew,knew,l,
		    TCYLINDERSFIT[i], PSICYLINDERSFIT[i],
		    CHARGEOFCYLINDERS[i],
		    LENGTHOFCYLINDERSFIT[i],
		    RADIUSOFCYLINDERSFIT[i],
		    SOFTNESSOFCYLINDERSFIT[i],
		    OCCUPOFCYLINDERSFIT[i]);
		radius = abs(ORIGINOFCYLINDERS[i]/DLAT[2])*sin(TCYLINDERSFIT[i]);
		xa = XCYLINDERSFIT[i]+radius*cos(PSICYLINDERSFIT[i]);
		yb = YCYLINDERSFIT[i]+radius*sin(PSICYLINDERSFIT[i]);
		zc = ZCYLINDERSFIT[i]-ORIGINOFCYLINDERS[i]/DLAT[2]*cos(TCYLINDERSFIT[i]);
		re_surf[j] += fatom*cos(2*PI*(hnew*xa+knew*yb+l*zc));
		im_surf[j] += fatom*sin(2*PI*(hnew*xa+knew*yb+l*zc));
		}
	    for (i = 0; i < NELLIPSOIDS; i++)
		{
		fatom = ellipsoid_scattering_factor(
		    hnew,knew,l,
		    PHIELLIPSOIDSFIT[i], 
		    CHIELLIPSOIDSFIT[i], 
		    THELLIPSOIDSFIT[i],
		    CHARGEOFELLIPSOIDS[i],
		    ALENGTHOFELLIPSOIDSFIT[i],
		    BLENGTHOFELLIPSOIDSFIT[i],
		    CLENGTHOFELLIPSOIDSFIT[i],
		    SOFTNESSOFELLIPSOIDSFIT[i],
		    OCCUPOFELLIPSOIDSFIT[i]);
		re_surf[j] += fatom*cos(2*PI*(hnew*XELLIPSOIDSFIT[i]+
					      knew*YELLIPSOIDSFIT[i]+
					      l*ZELLIPSOIDSFIT[i]));
		im_surf[j] += fatom*sin(2*PI*(hnew*XELLIPSOIDSFIT[i]+
					      knew*YELLIPSOIDSFIT[i]+
					      l*ZELLIPSOIDSFIT[i]));
		}
	    }
	}
    }


/***************************************************************************/
void    set_svensson_parameters(void)
/***************************************************************************/

    /*
    Set values of Svensson's extension fit parameters.
    */

    {

    /* define set_svensson_par_menu */

    static struct   MENU set_svensson_par_menu[] =
	{
	"disgroup", 1,  1,  "Value of group displacement parameter",
	"bgroup",   1,  2,  "Value of group atom DW parameter",
	"list",     1,  10, "List parameters",
	"help",     1,  20, "Display menu",
	"return",   1,  21, "Return to main menu"
	};

    /* number of commands in th_type menu */
    int set_svensson_par_length = sizeof(set_svensson_par_menu) / 
	sizeof(set_svensson_par_menu[0]);

    int     stop = FALSE,npar,i;
    char    token[100];

    while (!stop)
	{
	if (!get_token(token,"ROD.EXT.SVE.SET.PAR>")) break;
	switch (cmnd_match(token,set_svensson_par_menu,set_svensson_par_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		npar = get_int(1,
		    "Serial number of group displacement parameter: ");
		if ((npar < 1) || (npar > NDISGROUPSTOT))
		    {
		    errtype("ERROR, no such serial number in model");
		    break;
		    }
		sprintf(STRING,
		    "Value of displacement parameter %1d [%6.3f]: ",
		    npar,DISPLGROUPS[npar-1]);
		DISPLGROUPS[npar-1] = get_real(DISPLGROUPS[npar-1],STRING);
		sprintf(STRING,
		    "Lower limit of displacement %1d [%6.3f]: ",
		    npar,DISPLLIMGROUPS[npar-1][0]);
		DISPLLIMGROUPS[npar-1][0] = 
		  get_real(DISPLLIMGROUPS[npar-1][0],STRING);
		sprintf(STRING,
		    "Upper limit of displacement %1d [%6.3f]: ",
		    npar,DISPLLIMGROUPS[npar-1][1]);
		DISPLLIMGROUPS[npar-1][1] = 
		  get_real(DISPLLIMGROUPS[npar-1][1],STRING);
		sprintf(STRING,
		    "Range checking on displacement %1d [%s]: ",
		    npar,yesnostr(DISPLPENGROUPS[npar-1]));
		DISPLPENGROUPS[npar-1] = yesno(DISPLPENGROUPS[npar-1],STRING);
		break;
	    case 2:
		npar = get_int(1,
		    "Serial number of group atom Debye-Waller parameter: ");
		if ((npar < 1) || (npar > NDWGROUPSTOT))
		    {
		    errtype("ERROR, no such serial number in model");
		    break;
		    }
		sprintf(STRING,
		    "Value of group atom Debye-Waller parameter %1d [%6.3f]: ",
		    npar,DEBWALGROUPS[npar-1]);
		DEBWALGROUPS[npar-1] = get_real(DEBWALGROUPS[npar-1],STRING);
		sprintf(STRING,
		    "Lower limit of group atom Debye Waller %1d [%6.3f]: ",
		    npar,DEBWALLIM[npar-1][0]);
		DEBWALLIMGROUPS[npar-1][0] = 
		  get_real(DEBWALLIMGROUPS[npar-1][0],STRING);
		sprintf(STRING,
		    "Upper limit of group atom Debye Waller %1d [%6.3f]: ",
		    npar,DEBWALLIMGROUPS[npar-1][1]);
		DEBWALLIMGROUPS[npar-1][1] = 
		  get_real(DEBWALLIMGROUPS[npar-1][1],STRING);
		sprintf(STRING,
		    "Range checking on group atom Debye Waller %1d [%s]: ",
		    npar,yesnostr(DEBWALPEN[npar-1]));
		DEBWALPENGROUPS[npar-1] = 
		  yesno(DEBWALPENGROUPS[npar-1],STRING);
	    case 10:
		type_line("Group displacment parameters:\n");
		for (i = 0; i < NDISGROUPSTOT; i++)
		    {
		    sprintf(STRING,"%2d %8.5f  [%8.5f,%8.5f]  %s\n"
			    ,i+1,DISPLGROUPS[i],
			    DISPLLIMGROUPS[i][0],DISPLLIMGROUPS[i][1],
		    	    yesnostr(DISPLPENGROUPS[i]));
		    type_list(STRING,ROWS);
		    }
		type_line("Group atoms Debye-Waller parameters:\n");
		for (i = 0; i < NDWGROUPSTOT; i++)
		    {
		    sprintf(STRING,"%2d %8.5f  [%8.5f,%8.5f]  %s\n"
			    ,i+1,DEBWALGROUPS[i],
			    DEBWALLIMGROUPS[i][0],DEBWALLIMGROUPS[i][1],
			    yesnostr(DEBWALPENGROUPS[i]));
		    type_list(STRING,ROWS);
		    }
		break;
	    case 20:
		list_menu("SET PARAMETERS",set_svensson_par_menu,
			  set_svensson_par_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    update_model();
    }


/***************************************************************************/
void    svensson_update_model(void)
/***************************************************************************/

    {
    int i;

    for (i = 0; i < NGROUPSS; i++)
        {
	XGROUPSFIT[i] = XGROUPS[i];
	if (NXDISGROUPS[i] > 0) 
	  XGROUPSFIT[i] +=  DISPLGROUPS[NXDISGROUPS[i]-1];

	YGROUPSFIT[i] = YGROUPS[i];
	if (NYDISGROUPS[i] > 0) 
	  YGROUPSFIT[i] +=  DISPLGROUPS[NYDISGROUPS[i]-1];

	ZGROUPSFIT[i] = ZGROUPS[i];
	if (NZDISGROUPS[i] > 0) 
	  ZGROUPSFIT[i] +=  DISPLGROUPS[NZDISGROUPS[i]-1];


	PHIGROUPSFIT[i] = PHIGROUPS[i];
	if (NPHIDISGROUPS[i] > 0) 
	  PHIGROUPSFIT[i] +=  
	    DISPLGROUPS[NPHIDISGROUPS[i]-1]/RAD;

	CHIGROUPSFIT[i] = CHIGROUPS[i];
	if (NCHIDISGROUPS[i] > 0) 
	  CHIGROUPSFIT[i] +=  
	    DISPLGROUPS[NCHIDISGROUPS[i]-1]/RAD;

	THGROUPSFIT[i] = THGROUPS[i];
	if (NTHDISGROUPS[i] > 0) 
	  THGROUPSFIT[i] +=  
	    DISPLGROUPS[NTHDISGROUPS[i]-1]/RAD;
	}
    for (i = 0; i < NCYLINDERS; i++)
        {
	XCYLINDERSFIT[i] = XCYLINDERS[i];
	if (NXDISCYLINDERS[i] > 0) 
	  XCYLINDERSFIT[i] +=  DISPLCYLINDERSPAR[NXDISCYLINDERS[i]-1];

	YCYLINDERSFIT[i] = YCYLINDERS[i];
	if (NYDISCYLINDERS[i] > 0) 
	  YCYLINDERSFIT[i] +=  DISPLCYLINDERSPAR[NYDISCYLINDERS[i]-1];

	ZCYLINDERSFIT[i] = ZCYLINDERS[i];
	if (NZDISCYLINDERS[i] > 0) 
	  ZCYLINDERSFIT[i] +=  DISPLCYLINDERSPAR[NZDISCYLINDERS[i]-1];


	TCYLINDERSFIT[i] = TCYLINDERS[i];
	if (NTDISCYLINDERS[i] > 0) 
	  TCYLINDERSFIT[i] +=  
	    DISPLCYLINDERSPAR[NTDISCYLINDERS[i]-1]/RAD;

	PSICYLINDERSFIT[i] = PSICYLINDERS[i];
	if (NPSIDISCYLINDERS[i] > 0) 
	  PSICYLINDERSFIT[i] +=  
	    DISPLCYLINDERSPAR[NPSIDISCYLINDERS[i]-1]/RAD;

	LENGTHOFCYLINDERSFIT[i] = LENGTHOFCYLINDERS[i];
	if (NLENGTHOFCYLINDERS[i] > 0) 
	  LENGTHOFCYLINDERSFIT[i] +=  
	    CHARGEDENSITYOFCYLINDERSPAR[NLENGTHOFCYLINDERS[i]-1];

	RADIUSOFCYLINDERSFIT[i] = RADIUSOFCYLINDERS[i];
	if (NRADIUSOFCYLINDERS[i] > 0) 
	  RADIUSOFCYLINDERSFIT[i] +=  
	    CHARGEDENSITYOFCYLINDERSPAR[NRADIUSOFCYLINDERS[i]-1];

	SOFTNESSOFCYLINDERSFIT[i] = SOFTNESSOFCYLINDERS[i];
	if (NSOFTNESSOFCYLINDERS[i] > 0) 
	  SOFTNESSOFCYLINDERSFIT[i] +=  
	    CHARGEDENSITYOFCYLINDERSPAR[NSOFTNESSOFCYLINDERS[i]-1];

	OCCUPOFCYLINDERSFIT[i] = OCCUPOFCYLINDERS[i];
	if (NOCCUPOFCYLINDERS[i] > 0) 
	  OCCUPOFCYLINDERSFIT[i] +=  
	    CHARGEDENSITYOFCYLINDERSPAR[NOCCUPOFCYLINDERS[i]-1];
	}
    for (i = 0; i < NELLIPSOIDS; i++)
        {
	XELLIPSOIDSFIT[i] = XELLIPSOIDS[i];
	if (NXDISELLIPSOIDS[i] > 0) 
	  XELLIPSOIDSFIT[i] +=  DISPLELLIPSOIDSPAR[NXDISELLIPSOIDS[i]-1];

	YELLIPSOIDSFIT[i] = YELLIPSOIDS[i];
	if (NYDISELLIPSOIDS[i] > 0) 
	  YELLIPSOIDSFIT[i] +=  DISPLELLIPSOIDSPAR[NYDISELLIPSOIDS[i]-1];

	ZELLIPSOIDSFIT[i] = ZELLIPSOIDS[i];
	if (NZDISELLIPSOIDS[i] > 0) 
	  ZELLIPSOIDSFIT[i] +=  DISPLELLIPSOIDSPAR[NZDISELLIPSOIDS[i]-1];


	PHIELLIPSOIDSFIT[i] = PHIELLIPSOIDS[i];
	if (NPHIDISELLIPSOIDS[i] > 0) 
	  PHIELLIPSOIDSFIT[i] +=  
	    DISPLELLIPSOIDSPAR[NPHIDISELLIPSOIDS[i]-1]/RAD;

	CHIELLIPSOIDSFIT[i] = CHIELLIPSOIDS[i];
	if (NCHIDISELLIPSOIDS[i] > 0) 
	  CHIELLIPSOIDSFIT[i] +=  
	    DISPLELLIPSOIDSPAR[NCHIDISELLIPSOIDS[i]-1]/RAD;

	THELLIPSOIDSFIT[i] = THELLIPSOIDS[i];
	if (NTHDISELLIPSOIDS[i] > 0) 
	  THELLIPSOIDSFIT[i] +=  
	    DISPLELLIPSOIDSPAR[NTHDISELLIPSOIDS[i]-1]/RAD;

	ALENGTHOFELLIPSOIDSFIT[i] = ALENGTHOFELLIPSOIDS[i];
	if (NALENGTHOFELLIPSOIDS[i] > 0) 
	  ALENGTHOFELLIPSOIDSFIT[i] +=  
	    CHARGEDENSITYOFELLIPSOIDSPAR[NALENGTHOFELLIPSOIDS[i]-1];

	BLENGTHOFELLIPSOIDSFIT[i] = BLENGTHOFELLIPSOIDS[i];
	if (NBLENGTHOFELLIPSOIDS[i] > 0) 
	  BLENGTHOFELLIPSOIDSFIT[i] +=  
	    CHARGEDENSITYOFELLIPSOIDSPAR[NBLENGTHOFELLIPSOIDS[i]-1];

	CLENGTHOFELLIPSOIDSFIT[i] = CLENGTHOFELLIPSOIDS[i];
	if (NCLENGTHOFELLIPSOIDS[i] > 0) 
	  CLENGTHOFELLIPSOIDSFIT[i] +=  
	    CHARGEDENSITYOFELLIPSOIDSPAR[NCLENGTHOFELLIPSOIDS[i]-1];

	SOFTNESSOFELLIPSOIDSFIT[i] = SOFTNESSOFELLIPSOIDS[i];
	if (NSOFTNESSOFELLIPSOIDS[i] > 0) 
	  SOFTNESSOFELLIPSOIDSFIT[i] +=  
	    CHARGEDENSITYOFELLIPSOIDSPAR[NSOFTNESSOFELLIPSOIDS[i]-1];

	OCCUPOFELLIPSOIDSFIT[i] = OCCUPOFELLIPSOIDS[i];
	if (NOCCUPOFELLIPSOIDS[i] > 0) 
	  OCCUPOFELLIPSOIDSFIT[i] +=  
	    CHARGEDENSITYOFELLIPSOIDSPAR[NOCCUPOFELLIPSOIDS[i]-1];
	}
	
	mik_update_model();
	
    }


/***************************************************************************/
int svensson_write_initmac(FILE *init_mac)
/***************************************************************************/
{

  fprintf(init_mac, "! Activate Svensson's extension\n");
  fprintf(init_mac, "ext svensson activate yes return return\n");

  return TRUE;
}


#endif





