/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                         list.c                                $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: list.c,v 1.20 2007/03/19 10:51:41 wilcke Exp $

****************************************************************************/

/*
Update 06/03/2007 R. Wilcke (wilcke@esrf.fr)
                  list(): add list of z-projected electron density (from
                  standard version).
Update 27/11/2006 R. Wilcke (wilcke@esrf.fr)
                  list(): set dimension of the "menu" lists to "[]", change the 
                  corresponding "lenght" from a macro to a variable and set its
                  value dynamically;
                  list(): restructure some code (no change in functionality) in:
                  - the first "switch" statement (the one setting the variable
                    "extension"),
                  - setting the variable "terminal",
                  - case 5 of the second "switch" statement;
                  list(): add input argument "int editflag" and code to edit the
                  listfile with an online editor and read its values back into
                  the program afterwards.
Update 19/01/2004 R. Wilcke (wilcke@esrf.fr)
                  removed declarations of fopen() (is declared in "stdio.h").
Update 18/09/2003 O. Svensson (svensson@esrf.fr)
                  Added code written by Michael Dore for the "svensson"
                  extension (deformation of groups).
Update 21/02/2002 O. Svensson (svensson@esrf.fr)
                  Ported changes from standard version:
                  Changed menus to follow Rainer's scheme.
Update 25/10/2000 O. Svensson (svensson@esrf.fr)
                  Removed call to list of symmetry cards for Svensson's
		  extension.
Update 28/09/2000 O. Svensson (svensson@esrf.fr)
                  Added listing of fit parameters for Svensson's extension.
Update 27/09/2000 O. Robach (odile.robach@esrf.fr)
                  put back listing of NOCCUP2 in list fit when robach_flag=1
                  in list surface model:
			- put listing of OCCUPTOT also for Robach's extension
			- correct excess %3d in sprintf of listing
                        - add an update_model before the listing
Update 26/09/2000 O. Svensson (svensson@esrf.fr)
                  Fixed bug in list of bulk model that caused the program
                  to crash.
Update 22/09/2000 M.C. Saint Lager (stlager@polycnrs-gre.fr)
                  New parameters are added in the list (NOCCUPB etc.)
Update 19/07/2000 R. Wilcke (wilcke@esrf.fr)
                  replaced everywhere the buffer size for filenames by
                  the ISO-C defined macro FILENAME_MAX.

*/

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#include "rod.h"
#ifdef EXTENSIONS /* Wilcke */
#include <sys/stat.h>
#endif /* EXTENSIONS Wilcke */

/***************************************************************************/
void list(int editflag)
/***************************************************************************/

/*
 * List data or model parameters on terminal or file.
 *
 * The input argument "editflag" allows to open the file for editing online:
 * editflag = 0  no online editing
 *          = 1  the file will be opened in the editor.
 *               If it is a new file, list writes the actual parameter values
 *               into the file first, then opens it for editing.
 *               If the file exists, the program asks whether the values in the
 *               file should be overwritten. If not, the actual program values
 *               will not be written, and the file is opened with the values it
 *               contained.
 *
 *               If "terminal" is selected for output, no online editing is
 *               possible.
 */

{

  /* define llistmenu */

  static struct MENU llistmenu[] =
  {
    "bulk",      1,  1, "Bulk contribution",
    "surface",   3,  2, "Surface contribution",
    "sum",       1,  3, "Interference sum of bulk and surface",
    "all",       1,  4, "Above three values",
    "data",      1,  5, "Structure factor data",
    "smodel",    2,  6, "Surface model",
    "bmodel",    2,  7, "Bulk model",
    "fit",       1,  8, "Fitting model for surface structure",
    "compare",   1,  9, "Comparison between data and theory",
    "parameters",2, 10, "Values of fit parameters",
    "symmetry",  2, 11, "Symmetry-equivalent reflections of data",
    "bonds",     2, 12, "Bond lengths of surface structure",
    "zdensity",  1, 13, "Z-proj. electron density (plot first!)",
    "help",      1, 20, "Display menu",
    "return",    1, 21, "Return to main menu"
  };
  /* number of commands in list menu */
  int llistlength = sizeof(llistmenu) / sizeof(llistmenu[0]);

  int stop = FALSE;
  char token[100];
  int switch_code,i,j;
  FILE *listfile;
  int terminal;
  char filename[FILENAME_MAX],extension[10];
  float b1,b2,distance,mindist,dx,dy,dz;
#ifdef EXTENSIONS /* Wilcke */
  struct stat status;   /* Structure for file status, directory... for stat() */
#endif /* EXTENSIONS Wilcke */

  while (!stop)
  {
    if (!get_token(token,"ROD.LIST>"))
      return;
    switch_code = cmnd_match(token,llistmenu,llistlength);
    switch (switch_code)
    {
      case -1:
      case 0:
	break;
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
	stop = TRUE;
	sprintf(extension,"dat");
	break;
      case 6:
	stop = TRUE;
	sprintf(extension,"sur");
	break;
      case 7:
	stop = TRUE;
	sprintf(extension,"bul");
	break;
      case 8:
	stop = TRUE;
	sprintf(extension,"fit");
	break;
      case 9:
	stop = TRUE;
	sprintf(extension,"lis");
	break;
      case 10:
	stop = TRUE;
	sprintf(extension,"par");
	break;
      case 11:
      case 12:
      case 13:
	stop = TRUE;
	sprintf(extension,"lis");
	break;
      case 20:
	list_menu("LIST MENU",llistmenu,llistlength);
	break;
      case 21:
	return;
    }
  }

  /* Ask for filename */

  sprintf(STRING,"Filename (.%s) (type 't' or <return> for terminal): ",
    extension);
  if (!get_token(filename,STRING) || (filename[1] == '\0' &&
    (filename[0] == 't' || filename[0] == 'T')))
  {
    terminal = TRUE;
  }
    else
  {
    terminal = FALSE;
    add_extension(filename,extension);

#ifdef EXTENSIONS /* Wilcke */
    if(editflag != 0)
    {
      if(stat(filename,&status) == 0)
      {
	sprintf(STRING,
	  "File exists. Overwrite with actual program parameters? [No]: ");
	if(!yesno(FALSE,STRING))
	{
	  sprintf(STRING,"%s %s",RODEDIT,filename);
	  system(STRING);
	  sprintf(STRING,"%s %s",extension,filename);
	  put_command(STRING);
	  read_type();
	  return;
	}
      }
    }
#endif /* EXTENSIONS Wilcke */

    if((listfile = fopen(filename,"w")) == NULL)
    {
      sprintf(STRING,"Error, failed to open '%s'",filename);
      errtype(STRING);
      clear_command();
      return;
    }
    else
    {
      get_string(STRING,"Comments: ");
      if (switch_code != 10)
	fprintf(listfile,"%s\n",STRING);
      else
	fprintf(listfile,"!%s\n",STRING);
    }
  }

  /* Do the actual listing */

  if(terminal)
    type_list(STRING,0);
  switch (switch_code)
  {
    case 1:
      if (terminal)
      {
#ifdef EXTENSIONS /* Robach */
	if ((robach_flag)&&(ratio_flag==1))
	  sprintf(STRING,"%6s %6s %6s %11s\n","h","k","l","f-substrate");
	else
#endif /* EXTENSIONS Robach */
	  sprintf(STRING,"%6s %6s %6s %11s\n","h","k","l","f-bulk");
	type_list(STRING,ROWS);
      }
      for (i = 0; i < NTH; i++)
      {
	sprintf(STRING,"%6.3f %6.3f %6.3f %11.5f\n",
	  HTH[i],KTH[i],LTH[i],FTH[0][i]);
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }
      break;
    case 2:
      if (terminal)
      {
#ifdef EXTENSIONS /* Robach */
	if ((robach_flag)&&(ratio_flag==1))
	  sprintf(STRING,"%6s %6s %6s %11s\n","h","k","l","f-ads+sub");
	else
#endif /* EXTENSIONS Robach */
	  sprintf(STRING,"%6s %6s %6s %11s\n","h","k","l","f-surf");
	type_list(STRING,ROWS);
      }
      for (i = 0; i < NTH; i++)
      {
	sprintf(STRING,"%6.3f %6.3f %6.3f %11.5f\n",
	  HTH[i],KTH[i],LTH[i],FTH[1][i]);
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }
      break;
    case 3:
      if (terminal)
      {
#ifdef EXTENSIONS /* Robach */
	if ((robach_flag)&&(ratio_flag==1))
	  sprintf(STRING,"%6s %6s %6s %11s %8s\n",
	    "h","k","l","f-ratio","zero");
	else
#endif /* EXTENSIONS Robach */
	  sprintf(STRING,"%6s %6s %6s %11s %8s\n",
	    "h","k","l","f-sum","phase");
	type_list(STRING,ROWS);
      }
      for (i = 0; i < NTH; i++)
      {
	sprintf(STRING,"%6.3f %6.3f %6.3f %11.5f %8.2f\n",
	  HTH[i],KTH[i],LTH[i],FTH[2][i],PHASE[i]*RAD);
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }
      break;
    case 4:
      if (terminal)
      {
#ifdef EXTENSIONS /* Robach */
	if ((robach_flag)&&(ratio_flag==1))
	  sprintf(STRING,"%6s %6s %6s %11s %11s %11s %8s\n",
	    "h","k","l","f-sub","f-ads+sub","f-ratio","zero");
	else
#endif /* EXTENSIONS Robach */
	  sprintf(STRING,"%6s %6s %6s %11s %11s %11s %8s\n",
	    "h","k","l","f-bulk","f-surf","f-sum","phase");
	type_list(STRING,ROWS);
      }
      for (i = 0; i < NTH; i++)
      {
	sprintf(STRING,"%6.3f %6.3f %6.3f %11.5f %11.5f %11.5f %8.2f\n",
	  HTH[i],KTH[i],LTH[i],FTH[0][i],FTH[1][i],FTH[2][i],
	  PHASE[i]*RAD);
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }
      break;
    case 5:
      if(terminal)
      {
#ifdef EXTENSIONS /* Robach */ /* add220800 */
	if(robach_flag && var_nlayers == 1)
	  sprintf(STRING,"%6s %6s %6s %11s %11s %3s %6s\n",
	    "h","k","l","f-dat","sigma","lbr","nlayer");
	else
#endif
	  sprintf(STRING,"%6s %6s %6s %11s %11s %3s\n",
	    "h","k","l","f-dat","sigma","lbr");
	type_list(STRING,ROWS);
      }

      for (i = 0; i < NDAT; i++)
      {
#ifdef EXTENSIONS /* Robach */
	if ((robach_flag)&&(var_nlayers==1))
	  sprintf(STRING,"%6.3f %6.3f %6.3f %11.5f %11.5f %3.0f %3.0f\n",
	    HDAT[i],KDAT[i],LDAT[i],FDAT[i],ERRDAT[i],LBR[i],NL_OR[i]);
	else
#endif /* EXTENSIONS Robach */
	  sprintf(STRING,"%6.3f %6.3f %6.3f %11.5f %11.5f %3.0f\n",
	    HDAT[i],KDAT[i],LDAT[i],FDAT[i],ERRDAT[i],LBR[i]);
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }
      break;
    case 6:
      update_model();
      sprintf(STRING," %6.4f %6.4f %6.4f %5.1f %5.1f %5.1f\n",
	DLAT[0],DLAT[1],DLAT[2],DLAT[3]*RAD,DLAT[4]*RAD,DLAT[5]*RAD);
      if (terminal)
      {
	type_line("Lattice parameters: ");
	type_list(STRING,ROWS);
      }
      else
      {
	fprintf(listfile,"%s",STRING);
      }

#ifdef EXTENSIONS /* Mcsl */
      if(mcsl_flag)
      {
	sprintf(STRING,"%2s %7s %11s %11s %7s %7s %7s\n",
	  "el","XS","YS","ZS","debw_in","deb_out","occtot");
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }
#endif /* EXTENSIONS Mcsl */

      for (i = 0; i < NSURF; i++)
      {
	if (NDWS[i] == 0)
	  b1 = 0.;
	else
	  b1 = DEBWAL[NDWS[i]-1];
	if (NDWS2[i] == 0)
	  b2 = b1;
	else
	  b2 = DEBWAL2[NDWS2[i]-1];

#ifdef EXTENSIONS /* Mcsl or Robach*/
	if(mcsl_flag || robach_flag)
	{
	  sprintf(STRING,"%2s %11.5f %11.5f %11.5f %7.2f %7.2f %7.2f\n",
	    ELEMENT[TS[i]],XSFIT[i],YSFIT[i],ZSFIT[i],b1,b2,OCCUPTOT[i]);
	}
	else
#endif /* EXTENSIONS Mcsl */

	  sprintf(STRING,"%2s %11.5f %11.5f %11.5f %3d %4.2f %4.2f\n",
	    ELEMENT[TS[i]],XSFIT[i],YSFIT[i],ZSFIT[i],NDWS[i],b1,b2);
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }
      if (NSURF2 != 0)
      {
#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
	  if (terminal)
	    type_line("2nd unit cell\n");
	  else
	    fprintf(listfile,"!2nd unit cell\n");
	else
#endif /* EXTENSIONS Robach */
	  if (terminal)
	    type_line("\n");
	  else
	    fprintf(listfile,"\n");
      }
      for (i = NSURF; i < NSURF+NSURF2; i++)
      {
	if (NDWS[i] == 0)
	  b1 = 0.;
	else
	  b1 = DEBWAL[NDWS[i]-1];
	if (NDWS2[i] == 0)
	  b2 = b1;
	else
	  b2 = DEBWAL2[NDWS2[i]-1];

#ifdef EXTENSIONS /* Mcsl or Robach*/
	if(mcsl_flag || robach_flag)
	{
	  sprintf(STRING,"%2s %11.5f %11.5f %11.5f %7.2f %7.2f %7.2f\n",
	    ELEMENT[TS[i]],XSFIT[i],YSFIT[i],ZSFIT[i],b1,b2,OCCUPTOT[i]);
	}
	else
#endif /* EXTENSIONS Mcsl */

	  sprintf(STRING,"%2s %11.5f %11.5f %11.5f %3d %4.2f %4.2f\n",
	    ELEMENT[TS[i]],XSFIT[i],YSFIT[i],ZSFIT[i],NDWS[i],b1,b2);
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }
#ifdef EXTENSIONS /* Svensson */
      if (svensson_flag)
      {
	list_groups_cylindes_ellipsoids_smodel(terminal, listfile);
      }
#endif /* EXTENSIONS Svensson */
      break;
    case 7:
      sprintf(STRING,
	" %6.4f %6.4f %6.4f %5.1f %5.1f %5.1f\n",
	DLAT[0],DLAT[1],DLAT[2],DLAT[3]*RAD,DLAT[4]*RAD,DLAT[5]*RAD);
      if (terminal)
      {
	type_line("Lattice parameters: ");
	type_list(STRING,ROWS);
      }
      else
      {
	fprintf(listfile,"%s",STRING);
      }

#ifdef EXTENSIONS /* Mcsl */
      if((robach_flag)||(mcsl_flag))
      {
	sprintf(STRING,"%2s %8s %12s %12s %7s %3s %4s\n",
	  "el","XB","YB","ZB","NDW","debw","occ");
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }
#endif /* EXTENSIONS Mcsl */

      for (i = 0; i < NBULK; i++)
      {
	if (NDWB[i] == 0)
	  b1 = 0.;
	else
	  b1 = DEBWAL[NDWB[i]-1];

	sprintf(STRING,"%2s %12.8f %12.8f %12.8f %3d %4.2f\n",
	  ELEMENT[TB[i]],XB[i],YB[i],ZB[i],NDWB[i],b1);

#ifdef EXTENSIONS /* Mcsl */
	if (NOCCUPB[i]>0)
	{
	  b2 = OCCUP[NOCCUPB[i]-1];
	  sprintf(STRING,"%2s %12.8f %12.8f %12.8f %3d %4.2f %4.2f\n",
	    ELEMENT[TB[i]],XB[i],YB[i],ZB[i],NDWB[i],b1,b2);
	}
#endif /* EXTENSIONS Mcsl */

	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }
      break;
    case 8:
      sprintf(STRING,
	" %6.4f %6.4f %6.4f %7.3f %7.3f %7.3f\n",
	DLAT[0],DLAT[1],DLAT[2],DLAT[3]*RAD,DLAT[4]*RAD,DLAT[5]*RAD);
      if (terminal)
      {
	type_line("Lattice parameters: ");
	type_list(STRING,ROWS);
      }
      else
      {
	fprintf(listfile,"%s",STRING);
      }

#ifdef EXTENSIONS /* Mcsl */
      if ((mcsl_flag) && (NCOL[0]>0))
      {
	/*
	 * The name of the columns is witten only if the fit file has been read
	 * in the Mcsl format=> NCOL[0] >0
	 */
	if (NDELTAZS)
	  sprintf(STRING,
	    "#el XS cxl nxl cx2 nx2 YS cyl nyl cy2 ny2 NP DZS czl nzl cz2 nz2 cz3 nz3 dwl dw2 ocl oc2 \n");
	else
	  sprintf(STRING,
	    "#el XS cxl nxl cx2 nx2 YS cyl nyl cy2 ny2 ZS czl nzl cz2 nz2 cz3 nz3 dwl dw2 ocl oc2 \n");

	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }
#endif /* EXTENSIONS Mcsl */

#ifdef EXTENSIONS /* Robach */
      for (i = 0; i < NSURF+NSURF2; i++)
#else
      for (i = 0; i < NSURF; i++)
#endif /* EXTENSIONS Robach */
      {

#ifdef EXTENSIONS /* Mcsl */
	if ((mcsl_flag) && (NCOL[0]>0))
	{
	  /*
	   * The list is in this format only if the fit file has been read in
	   * the Mcsl format=> NCOL[0] >0
	   */
	  if (NDELTAZS)
	    sprintf(STRING,
	      "%2s %7.4f %5.2f %2d %5.2f%3d%8.4f%6.2f%3d%6.2f%3d%3d%8.4f%8.4f%3d%8.4f%3d%8.4f%3d%3d%3d%3d%3d\n",
	      ELEMENT[TS[i]], XS[i],XCONST[i],NXDIS[i],X2CONST[i],NX2DIS[i],
	      YS[i],YCONST[i],NYDIS[i],Y2CONST[i],NY2DIS[i],NZSPLAN[i],
	      ZS[i],ZCONST[i],NZDIS[i],Z2CONST[i],NZ2DIS[i],Z3CONST[i],
	      NZ3DIS[i],NDWS[i],NDWS2[i],NOCCUP[i],NOCCUP2[i]);
	  else
	    sprintf(STRING,
	      "%2s%7.4f %5.2f %2d %5.2f%3d%8.4f %6.2f %3d %6.2f%3d %8.4f%8.4f%3d%8.4f%3d%8.4f%3d%3d%3d%3d%3d\n",
	      ELEMENT[TS[i]],
	      XS[i], XCONST[i], NXDIS[i], X2CONST[i], NX2DIS[i], YS[i],
	      YCONST[i],NYDIS[i],Y2CONST[i],NY2DIS[i],
	      ZS[i],ZCONST[i],NZDIS[i],Z2CONST[i],NZ2DIS[i],Z3CONST[i],
	      NZ3DIS[i],NDWS[i],NDWS2[i],NOCCUP[i],NOCCUP2[i]);
	  if (terminal)
	    type_list(STRING,ROWS);
	  else
	    fprintf(listfile,"%s",STRING);
	}
#endif /* EXTENSIONS Mcsl */

#ifdef EXTENSIONS /* Robach */
	if ((robach_flag) && !(NCOL[0]>0))
	  /*
	   * Change by Mcsl => not to list a second time if it has been already
	   * done in the Mcsl format
	   */
	  sprintf (STRING,
	    "%2s %8.5f %4.1f %2d %4.1f %2d %8.5f %4.1f %2d %4.1f %2d %8.5f %4.1f %2d %4.1f %2d %2d %2d %2d %2d\n",
	    ELEMENT[TS[i]],
	    XS[i], XCONST[i], NXDIS[i], X2CONST[i], NX2DIS[i],
	    YS[i], YCONST[i], NYDIS[i], Y2CONST[i], NY2DIS[i],
	    ZS[i], ZCONST[i], NZDIS[i], Z2CONST[i], NZ2DIS[i],
	    NDWS[i], NDWS2[i], NOCCUP[i], NOCCUP2[i]);
	else
#endif /* EXTENSIONS Robach */
	  sprintf(STRING,
	    "%2s %8.5f %7.4f %2d %7.4f %2d %8.5f %7.4f %2d %7.4f %2d %8.5f %1d %1d %1d %1d\n",
	    ELEMENT[TS[i]],
	    XS[i],XCONST[i],NXDIS[i],X2CONST[i],NX2DIS[i],
	    YS[i],YCONST[i],NYDIS[i],Y2CONST[i],NY2DIS[i],
	    ZS[i],NZDIS[i],NDWS[i],NDWS2[i],NOCCUP[i]);
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
	  if ((NSURF2!=0)&&(i==NSURF-1))
	  {
	    sprintf(STRING,"\n2nd unit cell :\n");
	    if (terminal)
	      type_list(STRING,ROWS);
	    else
	      fprintf(listfile,"%s",STRING);
	  }
#endif /* EXTENSIONS Robach */
      }
#ifdef EXTENSIONS /* Svensson */
      if (svensson_flag)
      {
	list_groups_cylindes_ellipsoids_fit(terminal, listfile);
      }
#endif /* EXTENSIONS Svensson */
      break;
    case 9:
      if (NDAT != NTH)
      {
	errtype("No computation done with current data points");
	break;
      }
#ifdef EXTENSIONS /* Robach */
      if ((robach_flag)&&(ratio_flag==1))
	  sprintf(STRING,"%6s %6s %6s %11s %11s %11s %7s\n",
	    "h","k","l","ratio-th","ratio-dat","sigma","chi_sqr");
      else
#endif /* EXTENSIONS Robach */
	sprintf(STRING,"%6s %6s %6s %11s %11s %11s %7s\n",
	  "h","k","l","f-th","f-dat","sigma","chi_sqr");
      if (terminal)
	type_list(STRING,ROWS);
      else
	fprintf(listfile,"%s",STRING);
      for (i = 0; i < NDAT; i++)
      {
	sprintf(STRING,
	  "%6.3f %6.3f %6.3f %11.5f %11.5f %11.5f %7.2f\n",
	  HDAT[i],KDAT[i],LDAT[i],FTH[2][i],FDAT[i],ERRDAT[i],
	  sqr((FTH[2][i]-FDAT[i])/(ERRDAT[i]+1e-10)));
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }
      break;

    case 10:
      if (!terminal)
      {
	fprintf(listfile,"!Goto set parameter menu\n");
	fprintf(listfile,"set par\n");
      }

      sprintf(STRING,"scale       %8.4f  %8.4f  %8.4f  %s\n",
	SCALE,SCALELIM[0],SCALELIM[1],yesnostr(SCALEPEN));
      if (terminal)
	type_list(STRING,ROWS);
      else
	fprintf(listfile,"%s",STRING);

#ifdef EXTENSIONS /* robach */ /* 071100 */
      if (!robach_flag)
      {
#endif
	sprintf(STRING,"scale2      %8.4f  %8.4f  %8.4f  %s\n",
	  SCALE2,SCALE2LIM[0],SCALE2LIM[1],yesnostr(SCALE2PEN));
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
#ifdef EXTENSIONS /* robach */
      }
#endif
      sprintf(STRING,"beta        %8.4f  %8.4f  %8.4f  %s\n",
	BETA,BETALIM[0],BETALIM[1],yesnostr(BETAPEN));
      if (terminal)
	type_list(STRING,ROWS);
      else
	fprintf(listfile,"%s",STRING);

      sprintf(STRING,"surffrac    %8.4f  %8.4f  %8.4f  %s\n",
	SURFFRAC,SURFFRACLIM[0],SURFFRACLIM[1],yesnostr(SURFFRACPEN));
      if (terminal)
	type_list(STRING,ROWS);
      else
	fprintf(listfile,"%s",STRING);

      for (i = 0; i < NDISTOT; i++)
      {
	sprintf(STRING,"displace  %1d %8.4f  %8.4f  %8.4f  %s\n",
	  i+1,DISPL[i],DISPLLIM[i][0],DISPLLIM[i][1],
	  yesnostr(DISPLPEN[i]));
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }

      for (i = 0; i < NDWTOT; i++)
      {
	sprintf(STRING,"b1        %1d %8.4f  %8.4f  %8.4f  %s\n",
	  i+1,DEBWAL[i],DEBWALLIM[i][0],DEBWALLIM[i][1],
	  yesnostr(DEBWALPEN[i]));
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }

      for (i = 0; i < NDWTOT2; i++)
      {
	sprintf(STRING,"b2        %1d %8.4f  %8.4f  %8.4f  %s\n",
	  i+1,DEBWAL2[i],DEBWAL2LIM[i][0],DEBWAL2LIM[i][1],
	  yesnostr(DEBWAL2PEN[i]));
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }

      for (i = 0; i < NOCCTOT; i++)
      {
	sprintf(STRING,"occupancy %1d %8.4f  %8.4f  %8.4f  %s\n",
	  i+1,OCCUP[i],OCCUPLIM[i][0],OCCUPLIM[i][1],
	  yesnostr(OCCUPPEN[i]));
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }

#ifdef EXTENSIONS /* Svensson */
      if (svensson_flag)
      {
	for (i = 0; i < NDISGROUPSTOT; i++)
	{
	  sprintf(STRING,"group displacement %1d %8.4f  %8.4f  %8.4f  %s\n",
	    i+1,DISPLGROUPS[i],DISPLLIMGROUPS[i][0],DISPLLIMGROUPS[i][1],
	    yesnostr(DISPLPENGROUPS[i]));
	  if (terminal)
	    type_line(STRING);
	  else
	    fprintf(listfile,"%s",STRING);
	}
	for (i = 0; i < NDWGROUPSTOT; i++)
	{
	  sprintf(STRING,"group atom b %1d %8.4f  %8.4f  %8.4f  %s\n",
	    i+1,DEBWALGROUPS[i],DEBWALLIMGROUPS[i][0],DEBWALLIMGROUPS[i][1],
	    yesnostr(DISPLPENGROUPS[i]));
	  if (terminal)
	    type_line(STRING);
	  else
	    fprintf(listfile,"%s",STRING);
	}
	/* Start addition by Michael Dore */
	for (i = 0; i < NEXPANGROUPSTOT; i++)
	{
	  sprintf(STRING,"group expan %1d %8.4f  %8.4f  %8.4f  %s\n",
	    i+1,func_deform[0].defgroups[i],func_deform[0].deflimgroups[i][0],
	    func_deform[0].deflimgroups[i][1],
	    yesnostr(func_deform[0].defpengroups[i]));
	  if (terminal)
	    type_line(STRING);
	  else
	    fprintf(listfile,"%s",STRING);
	}
	for (i = 0; i < NSHEARGROUPSTOT; i++)
	{
	  sprintf(STRING,"group shear %1d %8.4f  %8.4f  %8.4f  %s\n",
	    i+1,func_deform[1].defgroups[i],func_deform[1].deflimgroups[i][0],
	    func_deform[1].deflimgroups[i][1],
	    yesnostr(func_deform[1].defpengroups[i]));
	  if (terminal)
	    type_line(STRING);
	  else
	    fprintf(listfile,"%s",STRING);
	}
	/* End addition by Michael Dore */
      }
#endif /* EXTENSIONS Svensson */

      if (!terminal)
	fprintf(listfile,"return return");

      break;
    case 11:
      if (NTRANS == 0)
      {
	errtype("No symmetry group set");
	return;
      }
      if (NDAT == 0)
      {
	errtype("No data read in");
	return;
      }

      /* Generate the equivalent reflections */

      make_symmetry_set(1);

      if (terminal)
      {
	sprintf(STRING,"%6s %6s %6s %9s %9s\n",
	  "h","k","l","f-dat","sigma");
	type_list(STRING,ROWS);
      }
      for (i = 0; i < NDAT; i++)
      {
	sprintf(STRING,"%8.5f %8.5f %8.5f %11.5f %11.5f\n",
		HDAT[i],KDAT[i],LDAT[i],FDAT[i],ERRDAT[i]);
	if (terminal)
	    type_list(STRING,ROWS);
	else
	    fprintf(listfile,"%s",STRING);
	for (j = 1; j < SYMSET[i].N; j++)
	{
	  sprintf(STRING,"(%1d,%1d) ",SYMSET[i].H[j],SYMSET[i].K[j]);
	  if (terminal)
	    type_list(STRING,ROWS);
	  else
	    fprintf(listfile,"%s",STRING);
	}
	sprintf(STRING,"\n");
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }
      break;
    case 12:
      if (NSURF < 2)
      {
	errtype("Too few atoms in surface model");
	clear_command();
	break;
      }
      mindist = get_real(3,"Minimum distance in list [3]: ");

      /* print header */

      sprintf(STRING,"%3s %4s %3s %4s %11s\n","#","elem","#","elem",
	"distance");
      if (terminal)
	type_list(STRING,ROWS);
      else
	fprintf(listfile,"%s",STRING);

      /* calculate and list all distances */

      for (i = 0; i < NSURF-1; i++)
      {
	for (j = i+1; j < NSURF; j++)
	{
	  distance = dist_calc(i,j,&dx,&dy,&dz);
	  if (distance < mindist)
	  {
	    sprintf(STRING,"%3d %4s %3d %4s %6.3f\n",i+1,
	      ELEMENT[TS[i]],j+1,ELEMENT[TS[j]],distance);
	    if (terminal)
	      type_list(STRING,ROWS);
	    else
	      fprintf(listfile,"%s",STRING);
	  }
	}
      }

      break;
    case 13:
      if (terminal)
      {
	sprintf(STRING,"%7s %11s\n","z","density");
	type_list(STRING,ROWS);
      }
      for (i = 0; i < NDENS; i++)
      {
	sprintf(STRING,"%7.3f %11.3f\n",ZDENS[i],DENS[i]);
	if (terminal)
	  type_list(STRING,ROWS);
	else
	  fprintf(listfile,"%s",STRING);
      }
      break;
  }

  if(!terminal)
  {
    fclose(listfile);
#ifdef EXTENSIONS /* Wilcke */
    if(editflag != 0)
    {
      sprintf(STRING,"%s %s",RODEDIT,filename);
      system(STRING);
      sprintf(STRING,"%s %s",extension,filename);
      put_command(STRING);
      read_type();
    }
#endif /* EXTENSIONS Wilcke */
  }

}
