/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                        util.c                                 $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/*
Update 20/02/2003 R. Wilcke (wilcke@esrf.fr)
                  get_2inoutspec(), get_in2outspec(), get_inoutspec(), and
                  get_inspec(): use the input values as default for the output
                  values if they contain legal spectrum numbers.
*/

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#define EXT	extern
#include "ana.h"
#undef EXT

static char spnumstr[30];


/***************************************************************************/
void    get_2inoutspec(int *in_spec1, int *in_spec2, int *out_spec)
/***************************************************************************/

    /*
    Get two input and one output spectrum numbers.

    If an argument contains on input a legal value for a spectrum number, then
    this value is taken as the default for its return value.

    If an input value is bigger than the maximum number of spectra available,
    the default values are 1, 2, and 3 for the first, second and third argument.

    If an input value is less than or equal to zero, the default values are:
    - for the first argument:  1;
    - for the second argument: (default value of first argument) + 1;
    - for the third argument:  (default value of second argument) + 1.
    If this leads to a value bigger than the maximum number of spectra, the
    defaults are (again) 2 and 3 for the second and third argument.
    */

    {
    int ok = FALSE;

#ifdef EXTENSIONS /* Wilcke */
    if(*in_spec1 <= 0 || *in_spec1 > MAX_SPECTRUM)
#endif /* EXTENSIONS Wilcke */
	*in_spec1 = 1;
    sprintf(spnumstr,"First input spectrum [%d]: ",*in_spec1);
    while (!ok)  /* Stay in loop until correct value read in */
	{
	*in_spec1 = get_int(*in_spec1,spnumstr);
	if ((*in_spec1 > 0) && (*in_spec1 <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}

#ifdef EXTENSIONS /* Wilcke */
    if(*in_spec2 <= 0)
	*in_spec2 = *in_spec1 + 1;
    if(*in_spec2 > MAX_SPECTRUM)
#endif /* EXTENSIONS Wilcke */
	*in_spec2 = 2;
    ok = FALSE;
    sprintf(spnumstr,"Second input spectrum [%d]: ",*in_spec2);
    while (!ok)  /* Stay in loop until correct value read in */
	{
	*in_spec2 = get_int(*in_spec2,spnumstr);
	if ((*in_spec2 > 0) && (*in_spec2 <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}

#ifdef EXTENSIONS /* Wilcke */
    if(*out_spec <= 0)
	*out_spec = *in_spec2 + 1;
    if(*out_spec > MAX_SPECTRUM)
#endif /* EXTENSIONS Wilcke */
	*out_spec = 3;
    ok = FALSE;
    sprintf(spnumstr,"Output spectrum [%d]: ",*out_spec);
    while (!ok)  /* Stay in loop until correct value read in */
	{
	*out_spec = get_int(*out_spec,spnumstr);
	if ((*out_spec > 0) && (*out_spec <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}

    /* subtract 1 from spectrum numbers to account for the way C treats
    arrays */
    *in_spec1 -= 1;
    *in_spec2 -= 1;
    *out_spec -= 1;
    }

/***************************************************************************/
void    get_in2outspec(int *in_spec, int *out_spec1, int *out_spec2)
/***************************************************************************/

    /*
    Get one input and two output spectrum numbers.

    If an argument contains on input a legal value for a spectrum number, then
    this value is taken as the default for its return value.

    If an input value is bigger than the maximum number of spectra available,
    the default values are 1, 2, and 3 for the first, second and third argument.

    If an input value is less than or equal to zero, the default values are:
    - for the first argument:  1;
    - for the second argument: (default value of first argument) + 1;
    - for the third argument:  (default value of second argument) + 1.
    If this leads to a value bigger than the maximum number of spectra, the
    defaults are (again) 2 and 3 for the second and third argument.
    */

    {
    int ok = FALSE;

#ifdef EXTENSIONS /* Wilcke */
    if(*in_spec <= 0 || *in_spec > MAX_SPECTRUM)
#endif /* EXTENSIONS Wilcke */
	*in_spec = 1;
    sprintf(spnumstr,"Input spectrum [%d]: ",*in_spec);
    while (!ok)  /* Stay in loop until correct value read in */
	{
	*in_spec = get_int(*in_spec,spnumstr);
	if ((*in_spec > 0) && (*in_spec <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}

#ifdef EXTENSIONS /* Wilcke */
    if(*out_spec1 <= 0)
	*out_spec1 = *in_spec + 1;
    if(*out_spec1 > MAX_SPECTRUM)
#endif /* EXTENSIONS Wilcke */
	*out_spec1 = 2;
    ok = FALSE;
    sprintf(spnumstr,"First output spectrum [%d]: ",*out_spec1);
    while (!ok)  /* Stay in loop until correct value read in */
	{
	*out_spec1 = get_int(*out_spec1,spnumstr);
	if ((*out_spec1 > 0) && (*out_spec1 <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}

#ifdef EXTENSIONS /* Wilcke */
    if(*out_spec2 <= 0)
	*out_spec2 = *out_spec1 + 1;
    if(*out_spec2 > MAX_SPECTRUM)
#endif /* EXTENSIONS Wilcke */
	*out_spec2 = 3;
    ok = FALSE;
    sprintf(spnumstr,"Second output spectrum [%d]: ",*out_spec2);
    while (!ok)  /* Stay in loop until correct value read in */
	{
	*out_spec2 = get_int(*out_spec2,spnumstr);
	if ((*out_spec2 > 0) && (*out_spec2 <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}

    /* subtract 1 from spectrum numbers to account for the way C treats
    arrays */
    *in_spec -= 1;
    *out_spec1 -= 1;
    *out_spec2 -= 1;
    }

/***************************************************************************/
void    get_inoutspec(int *in_spec, int *out_spec)
/***************************************************************************/

    /*
    Get input and output spectrum numbers.

    If an argument contains on input a legal value for a spectrum number, then
    this value is taken as the default for its return value.

    If an input value is bigger than the maximum number of spectra available,
    the default values are 1 and 2 for the first and second argument.

    If an input value is less than or equal to zero, the default values are:
    - for the first argument:  1;
    - for the second argument: (default value of first argument) + 1.
    If this leads to a value bigger than the maximum number of spectra, the
    default is (again) 2 for the second argument.
    */

    {
    int ok = FALSE;

#ifdef EXTENSIONS /* Wilcke */
    if(*in_spec <= 0 || *in_spec > MAX_SPECTRUM)
#endif /* EXTENSIONS Wilcke */
	*in_spec = 1;
    sprintf(spnumstr,"Input spectrum [%d]: ",*in_spec);
    while (!ok)  /* Stay in loop until correct value read in */
	{
	*in_spec = get_int(*in_spec,spnumstr);
	if ((*in_spec > 0) && (*in_spec <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}

#ifdef EXTENSIONS /* Wilcke */
    if(*out_spec <= 0)
	*out_spec = *in_spec + 1;
    if(*out_spec > MAX_SPECTRUM)
#endif /* EXTENSIONS Wilcke */
	*out_spec = 2;
    ok = FALSE;
    sprintf(spnumstr,"Output spectrum [%d]: ",*out_spec);
    while (!ok)  /* Stay in loop until correct value read in */
	{
	*out_spec = get_int(*out_spec,spnumstr);
	if ((*out_spec > 0) && (*out_spec <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}

    /* subtract 1 from spectrum numbers to account for the way C treats
    arrays */
    *in_spec -= 1;
    *out_spec -= 1;
    }

/***************************************************************************/
void    get_inspec(int *in_spec)
/***************************************************************************/

    /*
    Get spectrum number.

    If the argument contains on input a legal value for a spectrum number, then
    this value is taken as the default for its return value.

    Otherwise the default value is 1.
    */

    {
    int ok = FALSE;

#ifdef EXTENSIONS /* Wilcke */
    if(*in_spec <= 0 || *in_spec > MAX_SPECTRUM)
#endif /* EXTENSIONS Wilcke */
	*in_spec = 1;
    sprintf(spnumstr,"Spectrum number [%d]: ",*in_spec);
    while (!ok)  /* Stay in loop until correct value read in */
	{
	*in_spec = get_int(*in_spec,spnumstr);
	if ((*in_spec > 0) && (*in_spec <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}

    /* subtract 1 from spectrum number to account for the way C treats
    arrays */
    *in_spec -= 1;
    }

/***************************************************************************/
double  sqr(double value)
/***************************************************************************/

    /*
    Returns square of value.
    */

    {
    return(value*value);
    }

/***************************************************************************/
void type_header(int flag)
/***************************************************************************/

    /*
    Type header with spectrum summary.
    Some operating systems allow setting up the terminal screen with a
    lower scroll region. If this is not the case, the header has to be typed
    all the time to simulate scrolling. The subroutine therefore does the
    following:
	flag	0	Only type header when SCROLL is not defined
	flag	1	Always type full header
    */

    {

    int i;

#ifdef SCROLL
    if (flag == 0) return;
#endif

    set_cursor(1,1);
    type_line("========================================");
    type_line("=======================================\n");
    sprintf(STRING,"%s %-*s %s %13s %13s\n",
	"no.",TITLE_LENGTH,"title","points","min","max");
    type_line(STRING);
    for (i = 0; i < MAX_SPECTRUM; i++)
	{
	if ((DATA[i].MINY < 0.1 && DATA[i].MINY > 1e-10) ||
	    (DATA[i].MAXY > 1e9))
	    {
	    sprintf(STRING,"%2d  %-*s %6d %13.5e %13.5e\n",
		i+1,TITLE_LENGTH,DATA[i].TITLE,DATA[i].NPNT,
		DATA[i].MINY,DATA[i].MAXY);
		type_line(STRING);
	    }
	else
	    {
	    sprintf(STRING,"%2d  %-*s %6d %13.3f %13.3f\n",
		i+1,TITLE_LENGTH,DATA[i].TITLE,DATA[i].NPNT,
		DATA[i].MINY,DATA[i].MAXY);
		type_line(STRING);
	    }
	}
    type_line("========================================");
    type_line("=======================================\n");
    set_cursor(1,ROWS);

    flag = flag;
    }


