/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                         read.c                                $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/*
Update 13/03/2007 R. Wilcke (wilcke@esrf.fr)
                  remove preprocessor statements for "OS2" and "VMS" (no longer
                  used).
Update 09/01/2006 R. Wilcke (wilcke@esrf.fr) 
                  read_spec(): when searching for the "#L" line in the data,
                  skip the remaining parts of lines that are longer than the
                  input buffer.
Update 19/01/2004 R. Wilcke (wilcke@esrf.fr) 
                  removed declarations of fopen() (is declared in "stdio.h").
Update 12/11/2003 R. Wilcke (wilcke@esrf.fr)
                  read_spec(): add code for SPECTYPE "DUBBLE" to the part with
                  EXTENSIONS and SPECTYPE "ID32_k" to the part without.
Update 22/10/2003 R. Wilcke (wilcke@esrf.fr)
                  read_spec(): define angles for new spec type ID32_k.
Update 16/10/2003 R. Wilcke (wilcke@esrf.fr)
                  read_spec(), EXTENSIONS version: free allocated array "dummy".
Update 14/03/2003 R. Wilcke (wilcke@esrf.fr)
                  read_spec(), EXTENSIONS version: save XCOL irrespective of
                  reading "#L" data lines, as MCA files do not have "#L" lines.
Update 27/11/2001 O.Svensson (svensson@esrf.fr)
                  Changed "strcmp" to "strcasecmp" on line 852 (read_spec)
                  in order to find SPEC column names with upper case letters
                  (not for MSDOS).
Update 15/12/2000 E. Vlieg (vlieg@sci.kun.nl)
		  Add DUBBLE SPEC file type.
Update 06/10/2000 E. Vlieg (vlieg@sci.kun.nl)
                  Add (temporary) patch with label "femke" to read specular
                  data with correct indices. Activated if scan# negative.
Update 02/10/2000 R. Wilcke (wilcke@esrf.fr)
                  read_spec(), EXTENSIONS version: modify the read procedure
                  to allow for scan files that have only MCA data without point
                  detector data.
Update 25/09/2000 R. Wilcke (wilcke@esrf.fr)
                  read_spec(), non-EXTENSIONS version: make the number of format
                  specifiers in the "sscanf()" calls agree with the number of
                  variables to be read (3 instances).
Update 13/09/2000 R. Wilcke (wilcke@esrf.fr)
                  limit the length of the strings printed (with sprintf()) into
                  field TITLE of structure DATA;
                  limit the length of the strings printed (with sprintf()) into
                  fields DATATITLE and DATAINFO.
Update 09/09/2000 O. Svensson (svensson@esrf.fr)
                  read_spec(): took away the requirement that "#L" should
                  be present in order to be able to read ID32 MCA files.
Update 07/06/2000 R. Wilcke (wilcke@esrf.fr)
                  replaced everywhere the buffer size for filenames by the ISO-C
                  defined macro FILENAME_MAX.
Update 29/05/2000 R. Wilcke (wilcke@esrf.fr)
                  make scangval and scangnam arrays with dimension MAX_SPECTRUM.
Update 24/05/2000 R. Wilcke (wilcke@esrf.fr)
                  make HMIL, KMIL and LMIL arrays with dimension MAX_SPECTRUM.
Update 16/05/2000 R. Wilcke (wilcke@esrf.fr)
                  read_spec(): for MCA scans only, store the name and the value
                  of the scan angle into "scangnam" and "scangval".
Update 15/05/2000 R. Wilcke (wilcke@esrf.fr)
                  read_spec(): allocate memory for array "dummy" dynamically and
                  read data for point detector with strtod() instead sscanf() to
                  allow for an arbitrary number of data columns.
Update 12/05/2000 R. Wilcke (wilcke@esrf.fr)
                  read_spec(): modify assignment of title for x-axis in plot;
                  read_spec(): change code to add
                               - the reading of MCA spectra,
                               - the reading of point detector spectra that are
                                 interspersed with MCA spectra.
Update 09/05/2000 R. Wilcke (wilcke@esrf.fr)
                  read_type(): added new command "spmca" with command number 7,
                  assign "ftpscom" command the number 8 and change the "switch"
                  statement accordingly;
                  read_type(): make read_type_length a variable, set dimension
                  of "read_type_menu" to "[]" and set value of read_type_length
                  dynamically;
                  read_type() and read_spec(): add an argument to the funtion
                  "read_spec()" to distinguish between point detectors and MCA
                  detectors;
                  read_spec(): remove some debugging output;
                  add include for <stdlib.h>.
Update 06/04/2000 R. Wilcke (wilcke@esrf.fr)
                  read_type(): request at least 2 characters for the "srs"
                  command because of possible confusion with the commands "spec"
                  and "super".
Update 15/03/2000 R. Wilcke (wilcke@esrf.fr)
                  read_ftascom(): replace printf() calls by type_line().
Update 26/01/2000 R. Wilcke (wilcke@esrf.fr)
                  read_spec(): read names of spec variables from the data file
                  and print the variables together with these names;
                  read_spec(): store the first six spec variables in the array
                  ANGLES for later use in "comp_cor()".
*/

/******************************************************************************/

/*
 *  This version: 07-Jun-2000
 *
 *  reads :
 *
 *  - SRS data files (old and new format)
 *  - SPEC data files (ESRF ID 3 / ID 10 format; point detector and MCA spectra)
 *  - Brookhaven SUPER files
 *  - HASYLAB tascom files in single column format
 */

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#define EXT extern
#include "ana.h"
#undef EXT
#include <ctype.h>
#include <stdlib.h>

/***************************************************************************/
void    read_column(void)
/***************************************************************************/

     /*
         Read file of 'column' type:
         - HEADER_LINES header lines
         - data lines with arbirary amount of columns, with
        	XCOL         the x-values
        	YCOL         the y-values
        	ECOL         the errors in y (no error if 0).
     */

    {

    char    filename[FILENAME_MAX];
    FILE    *infile;
    int     i,in_spec = 1,items,npoints;
    int     end_of_file,error_column;
    float   dummy[DATACOLUMNS];
    int     maxcolumn;

    /* Get filename and open file, return if not successful */

    get_token(filename,"Give filename (.dat): ");
    add_extension(filename,"dat");
    if ((infile = fopen(filename,"r")) == NULL)
	{
	sprintf(STRING,"Failed to open file '%s'",filename);
	errtype(STRING);
	clear_command();
	return;
	}

    /* Get spectrum number where data has to be stored */

    get_inspec(&in_spec);
    READSPEC = in_spec;

    /* Skip header lines */

    for (i = 0; i < HEADER_LINES; i++)
	{
	if (fgets(INLINE,INLLEN,infile) == NULL)
	    {
	    errtype("ERROR, less than HEADER_LINES lines in file");
	    clear_command();
	    return;
	    }
	}

    /* Find maximum column number to be read in */

    maxcolumn = XCOL;
    if (YCOL > maxcolumn) maxcolumn = YCOL;
    if (ECOL > maxcolumn) maxcolumn = ECOL;
    if (ECOL != 0)
	error_column = TRUE;
    else
	error_column = FALSE;

    /* Read in spectrum */

    npoints = 0;
    end_of_file = FALSE;
    while ((fgets(INLINE,INLLEN,infile) != NULL) && (!end_of_file))
	{
	/* Check whether enough data is read in */
	if (sscanf(INLINE,"%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f",
	    &dummy[0],&dummy[1],&dummy[2],&dummy[3],&dummy[4],&dummy[5],
	    &dummy[6],&dummy[7],&dummy[8],&dummy[9],&dummy[10],&dummy[11])
	    >= maxcolumn)
	    {
	    if (XCOL <= 0) /* Ennumerate x-values */
		DATA[in_spec].X[npoints] = (float) npoints+1;
	    else
		DATA[in_spec].X[npoints] = dummy[XCOL-1];
	    DATA[in_spec].Y[npoints] = dummy[YCOL-1];
	    if (error_column)
		DATA[in_spec].E[npoints] = dummy[ECOL-1];
	    else
		DATA[in_spec].E[npoints] = 1;
	    npoints++;
	    }
	else
	    {
	    end_of_file = TRUE;
	    }
	}
    fclose(infile);
    if (npoints == 0)
	{
	errtype("No data in spectrum");
	clear_command();
	return;
	}
    DATA[in_spec].NPNT = npoints;
    /* Find miniumum and maximum in spectrum */

    DATA[in_spec].MINY = DATA[in_spec].Y[0];
    DATA[in_spec].MAXY = DATA[in_spec].Y[0];
    for (i = 1; i < npoints; i++)
	{
	if (DATA[in_spec].Y[i] < DATA[in_spec].MINY)
	    DATA[in_spec].MINY = DATA[in_spec].Y[i];
	if (DATA[in_spec].Y[i] > DATA[in_spec].MAXY)
	    DATA[in_spec].MAXY = DATA[in_spec].Y[i];
	}

    /* Give spectrum a title */

    sprintf(DATA[in_spec].TITLE,"%.*s",TITLE_LENGTH,filename);
    sprintf(DATATITLE,"%.*s",TITINFLN-1,filename);

    sprintf(STRING,"Range of x-axis: %10.3g to %10.3g\n",
	DATA[in_spec].X[0],DATA[in_spec].X[DATA[in_spec].NPNT-1]);
    type_line(STRING);
    type_header(1);

    }

/***************************************************************************/
void    read_ftascom()
/***************************************************************************/

/*
 *  Read HASYLAB tascom file in single column format.
 *  We assume a z-axis mode.
 */

    {

    char    filename[FILENAME_MAX],dummy_name[FILENAME_MAX],date[50],time[50];
    FILE    *infile;
    int     i,in_spec = 1,items,npoints;
    int     end_of_file,error_column;
    float   dummy[DATACOLUMNS],dummyval;
    float   monitor[MAX_DATA];
/* #ifdef EXTENSIONS Wilcke */
    float   hmil,kmil,lmil;        /* Temporary storage for Miller indices. */
/* #endif EXTENSIONS Wilcke */
    int     done,ncolumns,nheaders,xcol_save,timescan;
    char    column_name[20],name[20][20];
    float   *x,*y,*e;
    char    *spos;
    char    lastline[INLLEN];
    int     has_read_beta;
    int     digits;

    /* Get filename and open file, return if not successful */

    SCANNR = get_int(1,"Scan number: ");

    for(i=strlen(DATAFILE)-1, digits=5; i>=0; i--, digits--)
	{
	if(!isdigit(DATAFILE[i])) break;
	}

    sprintf(filename,"%s%0*d",DATAFILE,digits,SCANNR);
    add_extension(filename,"dat");
    if((infile = fopen(filename,"r")) == NULL)
	{
	sprintf(STRING,"Failed to open file '%s'",filename);
	errtype(STRING);
	clear_command();
	return;
	}

    /* Extract a few things from the header */

    /* First line contains # header lines + #columns */

    fgets(INLINE,INLLEN,infile);
    sscanf(INLINE,"%d %d",&nheaders,&ncolumns);

    /* Now get date, time from second line */

    fgets(INLINE,INLLEN,infile);
    sscanf(INLINE," %s %s",&date,&time);
    sprintf(DATAINFO,"%.*s Date: %s time: %s",TITINFLN-40,filename,date,time);
    sprintf(STRING,"Date: %s time: %s\n",date,time);
    type_line(STRING);

    /* skip blank line */

    fgets(INLINE,INLLEN,infile);

    /* Rest may contain something interesting */

    ALPHA = BETAIN = DELTA = GAMMA = 0.;
    for (i = 0; i < nheaders-ncolumns-2; i++)
	{
	fgets(INLINE,INLLEN,infile);
	sscanf(INLINE,"%s = %f",&dummy_name,&dummyval);
	strupr(dummy_name);
	if(strcmp(dummy_name,"FTR") == 0) GAMMA = dummyval;
	if(strcmp(dummy_name,"ALF") == 0) ALPHA = dummyval;
	if(strcmp(dummy_name,"2TS") == 0) DELTA = dummyval;
	/*
	 * Made HMIL, KMIL and LMIL arrays (see ana.h)
	 * As the array index (= number of the spectrum) is not yet know here,
	 * store the Miller indices in temporary variables.
	 */
	if(strcmp(dummy_name,"H") == 0) hmil = dummyval;
	if(strcmp(dummy_name,"K") == 0) kmil = dummyval;
	if(strcmp(dummy_name,"L") == 0) lmil = dummyval;
	}
    BETAIN = ALPHA; /* This is, of course, only correct for z-axis mode */
    sprintf(STRING,"ALPHA=%.3f,  DELTA=%.3f, GAMMA=%.3f\n",
	    ALPHA,DELTA,GAMMA);
    type_line(STRING);

    /* Get the 'column' names */

    for(i = 0; i < ncolumns; i++)
	{
	fgets(INLINE,INLLEN,infile);
	sscanf(INLINE," %s ",name[i]);
	strlwr(name[i]);
	}

    sprintf(DATATITLE,"  ");  /* No comments line here in HASYLAB */

    xcol_save = XCOL;

    if(XCOL < 0) /* Get name of x */
	{
	done = FALSE;
	while(!done)
	    {
	    if(!get_token(column_name,
		"Give column name (type <return> for options): "))
		{
		for (i = 0; i < ncolumns; i++)
		    {
		    type_line(name[i]);
		    }
		type_line("\n");
		}
	    else
		{
		strlwr(column_name);
		for (i = 0; i < ncolumns; i++)
		    {
		    if (strcmp(name[i],column_name) == 0)
			{
			XCOL = i+1;
			done = TRUE;
			sprintf(XCOLNAME,"%s",name[i]);
			}
		    }
		if (XCOL < 0)
		    {
		    errtype("ERROR, no matching column name found");
		    clear_command();
		    fclose(infile);
		    XCOL = xcol_save;
		    return;
		    }
		}
	    }
	}


    else if (XCOL > 0) /* Get column name of x */
	{
	sprintf(XCOLNAME,"%s",name[XCOL-1]);
	}
    else
	{
	sprintf(XCOLNAME,"x");
	}

    if (XCOL != 0) /* Put x name in graph */
	{
	sprintf(STRING,"x title %s break",XCOLNAME);
	put_command(STRING);
	plotxye(x,y,e,1);
	}

    /* Get column number of y values */

    for (i = 0; i < ncolumns; i++)
	{
	if (strcmp(name[i],YCOLNAME) == 0) YCOL = i+1;
	}

    /* Get column number of monitor values */

    if (MCOL != 0)
	{
	for (i = 0; i < ncolumns; i++)
	    {
	    if (strcmp(name[i],"mon") == 0) MCOL = i+1;
	    }
	}

    /* Get spectrum number where data has to be stored */

    get_inspec(&in_spec);
    READSPEC = in_spec;

    /* Read in spectrum */

    /* Made HMIL, KMIL and LMIL arrays (see ana.h) */
    HMIL[in_spec] = hmil;
    KMIL[in_spec] = kmil;
    LMIL[in_spec] = lmil;
    npoints = 0;
    end_of_file = FALSE;
    while (!end_of_file)
	{
	for (i = 0; i < ncolumns; i++)
	    {
	    if (fgets(INLINE,INLLEN,infile) == NULL)
		{
		end_of_file = TRUE;
		break;
		}
	    sscanf(INLINE,"%f",&dummy[i]);
	    }

	if (XCOL == 0) /* Ennumerate x-values */
	    {
	    DATA[in_spec].X[npoints] = (float) npoints+1;
	    }
	else
	    {
	    DATA[in_spec].X[npoints] = dummy[XCOL-1];
	    }
	DATA[in_spec].Y[npoints] = dummy[YCOL-1];
	if (MCOL != 0) monitor[npoints] = dummy[MCOL-1];
	npoints++;
	if (npoints == MAX_DATA)
	    {
	    errtype("ERROR, maximum number of data points exceeded");
	    break;
	    }
	} /* end of while */
    fclose(infile);

    if (npoints == 0)
	{
	errtype("No data in spectrum");
	clear_command();
	XCOL = xcol_save;
	return;
	}

    DATA[in_spec].NPNT = npoints;

    XCOL = xcol_save;

    /* Calculate statistical error */

    for (i = 0; i < npoints; i++) DATA[in_spec].E[i] = sqrt(DATA[in_spec].Y[i]);

    /* if required, normalize on monitor signal */

    if (MCOL != 0)
	{
	for (i = 0; i < npoints; i++)
	    {
	    if (monitor[i] < 1) monitor[i] = 1;
	    DATA[in_spec].Y[i] *= MONITOR_NORM/monitor[i];
	    DATA[in_spec].E[i] *= MONITOR_NORM/monitor[i];
	    }
	}

    /* Find miniumum and maximum in spectrum */

    DATA[in_spec].MINY = DATA[in_spec].Y[0];
    DATA[in_spec].MAXY = DATA[in_spec].Y[0];
    for (i = 1; i < npoints; i++)
	{
	if (DATA[in_spec].Y[i] < DATA[in_spec].MINY)
	    DATA[in_spec].MINY = DATA[in_spec].Y[i];
	if (DATA[in_spec].Y[i] > DATA[in_spec].MAXY)
	    DATA[in_spec].MAXY = DATA[in_spec].Y[i];
	}

    /* Give spectrum a title */

    sprintf(DATA[in_spec].TITLE,"%.*s",TITLE_LENGTH,filename);

    sprintf(STRING,"Range of x-axis: %10.3g to %10.3g\n",
	DATA[in_spec].X[0],DATA[in_spec].X[DATA[in_spec].NPNT-1]);
    type_line(STRING);
    type_header(1);

    }

#ifdef EXTENSIONS /* Wilcke */
/***************************************************************************/
void    read_spec(int dettype)
/***************************************************************************/

/*
 * Read scan from SPEC data file. The input argument "dettype" defines the
 * type of detector used:
 * dettype = 1  point detector
 *         = 2  MCA detector
 */

    {

    char    filename[FILENAME_MAX],par[3];
    FILE    *infile;
    int     in_spec = 1;
    int     found,end_of_scan;
    char    date[40];
    int     i,scan;
    float   monitor[MAX_DATA];
    float   *dummy;
    int     maxcolumn,npoints;
    int     ncolumns,xcol_save,nread;
    int     mcasplst,mcaspcnt,mcachtot,mcachst;
    static int mcaspec = 0;
    static int hcol,kcol,lcol;
    char    column_name[40],name[DATACOLUMNS][40];
    char    scantype[20],extension[4];
    char    *ptrn,*ptrs,*ptrm1;
    float   *x,*y,*e;

    /* Get scan number to be read in */

    sprintf(STRING,"Scan number to be read in [%1d]: ",SCANNR);
    SCANNR = get_int(SCANNR,STRING);

    /* Open SPEC file. */

    if((infile = fopen(DATAFILE,"r")) == NULL)
	{
	sprintf(STRING,"Failed to open input file '%s'",DATAFILE);
	errtype(STRING);
	clear_command();
	return;
	}

    /* Get the names of the first six spec variables from the "#O0" line. */

    found = FALSE;
    while(!found)
	{
	if(fgets(INLINE,INLLEN,infile) == NULL)
	    {
	    sprintf(STRING,"Error, emtpy scan");
	    errtype(STRING);
	    clear_command();
	    fclose(infile);
	    return;
	    }

	if((INLINE[0]=='#') && (INLINE[1] == 'O') && (INLINE[2] == '0'))
	    {
	    sscanf(INLINE,"%3c%s%s%s%s%s%s",par,name[0],name[1],name[2],name[3],
		name[4],name[5]);
	    found = TRUE;
	    }
	}
    /*
     * Search for correct scan number in the "#S n" line, where n is the scan
     * number.
     *
     * When the correct scan has been found, extract the scantype information
     * from the line and the number of scan intervals. The scantype is the 3.
     * token on the line. The number of scan intervals need not be present. If
     * it is defined, it is the last-but-one token on the line. If it is not
     * defined, it will be set to 0.
     */
    found = FALSE;
    while(!found)
	{
	if(fgets(INLINE,INLLEN,infile) == NULL)
	    {
	    sprintf(STRING,"Scan not found in file '%s'",DATAFILE);
	    errtype(STRING);
	    clear_command();
	    fclose(infile);
	    return;
	    }

	sscanf(INLINE,"%3c %d",par,&scan);
	if((par[0]=='#') && (par[1] == 'S') && (scan == SCANNR))
	    {
	    found = TRUE;
	    /*
	     * Strip trailing blanks and the terminating <NL> from the string
	     * in order to have nothing behind the last real token when parsing
	     * the string with strtok().
	     */
	    while((nread = strlen(INLINE) - 1) && (INLINE[nread] == ' ' ||
		INLINE[nread] == (char)10))
		INLINE[nread] = (char)0;
	    /*
	     * Parse the input string with strtok() to find the 3. token (this
	     * contains the scantype) and the last-but-one token (this, if
	     * present, contains the number of scan intervals).
             *
             * If there are less than 5 tokens found, then the number of scan
             * intervals cannot have been defined (because of the syntax of the
	     * "#S" line). Set the number of scan intervals to 0.
	     */
	    ptrn = strtok(INLINE," ");
	    nread = 1;
	    while((ptrn = strtok(NULL," ")) != NULL)
		{
		ptrm1 = ptrs;
		ptrs = ptrn;
		nread++;
		if(nread == 3)
		    strcpy(scantype,ptrn);
		}
	    string_tolower(scantype);
	    mcasplst = 0;
	    if(strstr(scantype,"scan") != NULL && nread > 4)
		mcasplst = atoi(ptrm1);

	    }
	}
    /*
     * We have found the correct scan number, now get the rest of the
     * information.
     *
     * Get the date and time from the "#D" line.
     */
    found = FALSE;
    while(!found)
	{
	if(fgets(INLINE,INLLEN,infile) == NULL)
	    {
	    sprintf(STRING,"Error, emtpy scan");
	    errtype(STRING);
	    clear_command();
	    fclose(infile);
	    return;
	    }

	if((INLINE[0]=='#') && (INLINE[1] == 'D'))
	    {
	    sscanf(INLINE,"%3c %24c",par,date);
	    found = TRUE;
	    }
	}

    date[24] = 0;
    sprintf(STRING,"%s\n",date);
    type_line(STRING);
    /*
     * Get the first six spec variables from the "#P0" line. They contain the
     * angles needed for computation of Lorentz factor, polarization factor,
     * area correction and cut-of-the-rod correction.
     */
    DELTA = 0;
    BETAIN = 0;
    ALPHA = 0;

    found = FALSE;
    while(!found)
	{
	if(fgets(INLINE,INLLEN,infile) == NULL)
	    {
	    sprintf(STRING,"Error, emtpy scan");
	    errtype(STRING);
	    clear_command();
	    fclose(infile);
	    return;
	    }

	if((INLINE[0]=='#') && (INLINE[1] == 'P') && (INLINE[2] == '0'))
	    {
	    sscanf(INLINE,"%3c%f%f%f%f%f%f",par,&ANGLE[0],&ANGLE[1],&ANGLE[2],
		&ANGLE[3],&ANGLE[4],&ANGLE[5]);
	    found = TRUE;
	    }
	}

    switch(SPECTYPE)
	{
	case ID03:
	    DELTA = ANGLE[0];
	    ALPHA = ANGLE[4];
	    BETAIN = ANGLE[4]; /* Z-axis mode only !! */
	    GAMMA = ANGLE[5];
	    break;
        case ID32:
	    DELTA = ANGLE[1];
	    ALPHA = ANGLE[3];
	    GAMMA = ANGLE[0];
	    BETAIN = ANGLE[3];
	    break;
        case ID32_k:
	    DELTA = ANGLE[0];
	    ALPHA = ANGLE[5];
	    GAMMA = ANGLE[4];
	    BETAIN = ANGLE[5];
	    break;
        case DUBBLE:
	    DELTA = ANGLE[1];
	    ALPHA = ANGLE[2];
	    GAMMA = ANGLE[0];
	    BETAIN = ANGLE[2];
	    break;
        default:
            sprintf(STRING,"Error, illegal SPECTYPE %d",SPECTYPE);
	    errtype(STRING);
	    clear_command();
	    fclose(infile);
	    return;
	}

    sprintf(STRING,"DELTA=%.3f, ALPHA=%.3f, GAMMA=%.3f, BETA_IN=%.3f\n",
	DELTA,ALPHA,GAMMA,BETAIN);
    type_line(STRING);
    /*
     * Get the information which data to read. This information is contained
     * in two different input lines:
     * - lines starting with "#L";
     * - lines starting with "#@CHANN".
     *
     * The "#L" line contains the names of the data for the scan. The values
     * follow on separate data lines later in the file, one line per measurement
     * point. The structure is column-based, i.e. the data values for the
     * variable the name of which is given first in the "#L" line will be in the
     * first column of the data lines, etc. The detector data in these data
     * lines are from a point detector.
     *
     * The "#@CHANN" line, if present, defines the data for a linear detector
     * (MCA spectrum).
     * Given are:
     * - the total number of MCA channels in the first token;
     * - the sequence number of the first and last MCA channel in the second and
     *   third token.
     *
     * The "#L" line must be present for point detector data, and the "#@CHANN"
     * line must be present for MCA data. Only one or both types of data may be
     * present in a given scan.
     *
     * If the "#L" line is present for MCA data, it is used to obtain the Miller
     * indices. If the "#@CHANN" line is present for point detector data, its
     * values are used to skip the MCA spectra when reading the data.
     *
     * Unfortunately, the "#@CHANN" line may be before or after the "#L" line in
     * the input file, thus one has to look for both at the same time and
     * process them then as required.
     *
     * To do so, the program loops over the input lines and looks for those
     * starting with "#L" or "#@CHANN", ignoring all the other lines. This loop
     * is terminated when the first data line is encountered, which is by
     * definition a line not starting with a "#".
     */
    xcol_save = XCOL;
    while(TRUE)
	{
	ptrn = fgets(INLINE,INLLEN,infile);
	/*
	 * If the input line is longer than INLLEN - 1 characters, the remainder
	 * would stay in the input buffer and be read with the next fgets(). 
	 * To prevent this, read in (and throw away) the rest of the line to the
	 * end-of-line character.
	 */
	if(strlen(INLINE) == INLLEN - 1 && INLINE[INLLEN - 2] != (char)10)
	    while(getc(infile) != 10)
		;

	if(ptrn == NULL)
	    {
	    sprintf(STRING,"Error, emtpy scan");
	    errtype(STRING);
	    clear_command();
	    fclose(infile);
	    return;
	    }
        /*
         * Test for data line to terminate the loop over the input lines.
         */
	if(INLINE[0] != '#')
	    break;
	/*
	 * Read column names from the "#L" line, and compare the names found
	 * with the names requested by the program. The program needs the
	 * following data:
	 * - x values;
	 * - y values (typically the detector values, but can be anything);
	 * - values for h, k, and l;
	 * - monitor values (optional).
	 */
	if((INLINE[0]=='#') && (INLINE[1] == 'L'))
	    {
	    /*
	     * SPEC column names are separated by double spaces, thus replace
	     * all single spaces (that are part of column name) by underscore
	     */
	    for(i = 3; i < strlen(INLINE)-1; i++)
		{
		if((INLINE[i] == ' ') && (INLINE[i-1] != ' ')
		    && (INLINE[i+1] != ' '))
		    INLINE[i] = '_';
		}
	    /*
	     * Extract the column information from the names given in the line.
	     */
	    hcol = 0;
	    kcol = 0;
	    lcol = 0;
	    /*
	     * Get the name for the column with the x-values:
	     * - Skip this if the column number of the x-values is given
	     *   (XCOL > 0);
	     * - if XCOL < 0, ask for name of column. Return with error if the
	     *   name is not found in the #L line;
	     * - if XCOL == 0, then the X coordinate is enumerated (1, 2, 3...).
	     */
	    if(XCOL < 0)
		{
		while(!get_token(column_name,
		    "Give column name (type <return> for options): "))
		    {
		    type_line(INLINE);
		    }
		string_tolower(column_name);
		strcpy(STRING,INLINE);
		string_tolower(STRING);
		/*
		 * Search for the string with the column name in the input line.
		 * Note that the name must be preceded and followed by a blank,
		 * thus a test for just the substring match with name is not
		 * sufficient (name = "abc" must not match "abcd" in the input).
		 */
		if((ptrn = strstr(STRING,column_name)) == NULL ||
		    *(ptrn-1) != ' ' || *(ptrn + strlen(column_name)) != ' ')
		    {
		    errtype("ERROR, no matching column name found");
		    clear_command();
		    fclose(infile);
		    return;
		    }
		}
	    /*
	     * Find the column numbers for
	     * - the x values (if a name for the x-column was obtained above);
	     * - the y values: if a name matching the string in YCOLNAME is
	     *   found, then this defines the y-column. If no such name is
	     *   found, then the value in YCOL defines the y-column;
	     * - the h, k, l values: defined by the column the name of which
	     *   matches the strings "h", "k", or "l", respectively;
	     * - the monitor values: if MCOL == 0, then no column for the
	     *   monitor values is searched for. Otherwise, the column the name
	     *   of which matches "monitor", "monitor1" or "ion_ch" is taken. If
	     *   no such name is found, then the value in MCOL defines the
	     *   monitor column.
	     *
	     * Strip the terminating <NL> from the string in order to recognize
	     * last token correctly when parsing the string with strtok().
	     */
	    if((nread = strlen(INLINE) - 1) && INLINE[nread] == (char)10)
		INLINE[nread] = (char)0;
	    ptrn = strtok(INLINE+3," ");
	    ncolumns = 0;
	    do
		{
		ncolumns++;
		if(ncolumns == 1)
		    strncpy(scantype,ptrn,sizeof(scangnam[0]) - 1);
		string_tolower(ptrn);
		if(XCOL < 0)
		    {
		    if(strcmp(ptrn,column_name) == 0)
			{
			XCOL = ncolumns;
			strcpy(XCOLNAME,ptrn);
			}
		    }
		else if(XCOL > 0 && ncolumns == XCOL)
		    strcpy(XCOLNAME,ptrn);
		if(MCOL != 0)
		    {
		    if(!strcmp(ptrn,"monitor") || !strcmp(ptrn,"monitor1")
			|| !strcmp(ptrn,"ion_ch"))
			MCOL = ncolumns;
		    }
#ifndef MSDOS
		if(strcasecmp(ptrn,YCOLNAME) == 0)
#else
		if(strcmp(ptrn,YCOLNAME) == 0)
#endif
		    YCOL = ncolumns;
		if(strcmp(ptrn,"h") == 0)
		    hcol = ncolumns;
		else if(strcmp(ptrn,"k") == 0)
		    kcol = ncolumns;
		else if(strcmp(ptrn,"l") == 0)
		    lcol = ncolumns;
		} while((ptrn = strtok(NULL," ")) != NULL);
	    }
	/*
	 * Get the total number of MCA channels and the sequence number of the
	 * first MCA channel from a line starting with "#@CHANN".
	 * This line must be present for MCA detector scans, for other scans it
	 * may be present.
	 */
	else if(strncmp(INLINE,"#@CHANN",7) == 0)
	    {
	    sscanf(INLINE,"#@CHANN%d%d",&mcachtot,&mcachst);
	    }
	}
    /*
     * Find the number of columns to read in from a valid data line.
     * Note that MCA spectra have 16 data values per data line.
     */
    maxcolumn = XCOL > YCOL ? XCOL : YCOL;
    if(MCOL > maxcolumn)
	maxcolumn = MCOL;
    if(hcol > maxcolumn)
	maxcolumn = hcol;
    if(kcol > maxcolumn)
	maxcolumn = kcol;
    if(lcol > maxcolumn)
	maxcolumn = lcol;
    if(dettype == 2 && maxcolumn < 16)
	maxcolumn = 16;
    /*
     * Assign title of x-axis in plot:
     * - for point detectors: x-column name;
     * - for MCA detectors: string "MCA Channels".
     */
    if(XCOL == 0)
	strcpy(XCOLNAME,"x");
    if(dettype == 1)
	sprintf(STRING,"x title %s break",XCOLNAME);
    else
	sprintf(STRING,"x title \"MCA Channels\" break");
    put_command(STRING);
    plotxye(x,y,e,1);
    /*
     * For scans with MCA detector, get MCA spectrum number to be read in. If
     * there is only one spectrum, then it is automatically pre-selected.
     */
    if(dettype == 2)
	{
	if(mcasplst == 0)
	    mcaspec = 0;
	sprintf(STRING,"MCA spectrum to be read in (0 to %d) [%1d]: ",mcasplst,
	    mcaspec);
	while((i = get_int(mcaspec,STRING)) < 0 || i > mcasplst)
	    {
	    errtype("Error, illegal value for MCA spectrum");
	    clear_command();
	    }
	mcaspec = i;
	}

    /* Get spectrum number where data has to be stored */

    get_inspec(&in_spec);
    READSPEC = in_spec;
    /*
     * Read data lines and compute statistical error in y-values.
     *
     * There are two types of data lines:
     *
     * - lines containing the data for point detectors. In this case, there is
     *   one line for each measurement point. The meaning of the data (i.e. the
     *   names of the corresponding physical quantities) are defined in the "#L"
     *   line that was read earlier (see above). These data lines contain just
     *   numbers, no special characters like "#" or "@" in the first column;
     *
     * - lines containing the data for linear detectors (MCA). In this case, a
     *   full MCA spectrum is given on consecutive data lines in the input file.
     *   The first line starts with "@A". Each line contains 16 data values and
     *   is terminated by a "\" (backslash), expect for the last line. The last
     *   line may contain less then 16 values and is not terminated by a "\".
     *
     *   Note that it is perfectly possible to have an MCA spectrum on only one
     *   data line - this just means that it has at most 16 points. The line in
     *   this case starts with "@A" and ends without a "\".
     *
     *   The total number of MCA channels in the spectrum and the sequence
     *   number of the first channel were defined in a line starting with
     *   "#@CHANN" which was read earlier (see above).
     *
     * These two types may be interspersed. Then there must be a data line of
     * the point detector type for each point in a scan. This line is then
     * followed by the lines for an MCA spectrum. The physical quantities given
     * on the point detector data line (e.g. h, k, l) are also valid for the MCA
     * spectrum.
     *
     * If the input argument dettype == 1, then only the point detector data are
     * read and used to fill the x and y values of the scan. The MCA spectra, if
     * present, are automatically skipped.
     *
     * If the input argument dettype == 2, then the point detector lines, if
     * present, are read to get the other physical quantities (e.g. h, k, l),
     * but the y values of the scan are filled with the MCA spectrum, and the x
     * values are the MCA channel numbers. If the point detector lines are not
     * present, the corresponding quantities are set to 0.
     *
     * There may be several MCA spectra for one scan. The information which one
     * to read has to be supplied by the user (see above).
     */
    dummy = (float *)malloc(maxcolumn * sizeof(float));
    npoints = 0;
    HMIL[in_spec] = 0;
    KMIL[in_spec] = 0;
    LMIL[in_spec] = 0;
    end_of_scan = FALSE;

    if(dettype == 1)
	/*
         * Start loop reading data for point detector.
	 */
	{
	do
	    {
	    /*
	     * Ignore lines starting with "#@".
	     */
	    if(INLINE[0] == '#' && INLINE[1] == '@')
		continue;
	    /*
	     * Lines starting with "@A" signal the beginning of a MCA spectrum.
	     * Skip all lines with values for the spectrum. They are marked by
	     * a trailing backslash, except the last one.
	     */
	    if(INLINE[0] == '@' && INLINE[1] == 'A')
		{
		while(strchr(INLINE,'\\') != NULL)
		    fgets(INLINE,INLLEN,infile);
		continue;
		}
	    /*
	     * Check whether enough data is read in. If so, it is a proper data
	     * line.
	     */
	    ptrn = INLINE;
	    ncolumns = 0;
	    do
		{
		ptrs = ptrn;
		*(dummy + ncolumns++) = strtod(ptrs,&ptrn);
		} while(ncolumns < maxcolumn && ptrn != ptrs);
	    if(ncolumns >= maxcolumn)
		{
		if(XCOL == 0) /* Ennumerate x-values */
		    DATA[in_spec].X[npoints] = (float)(npoints+1);
		else
		    DATA[in_spec].X[npoints] = dummy[XCOL-1];
		DATA[in_spec].Y[npoints] = dummy[YCOL-1];
		if(MCOL > 0)
		    monitor[npoints] = dummy[MCOL-1];
		else
		    monitor[npoints] = MONITOR_NORM;
		HMIL[in_spec] += dummy[hcol-1];
		KMIL[in_spec] += dummy[kcol-1];
		LMIL[in_spec] += dummy[lcol-1];
		if(dummy[YCOL-1] < 1e-10)
		    DATA[in_spec].E[npoints] = 1;
		else
		    DATA[in_spec].E[npoints] = sqrt(dummy[YCOL-1]);
		npoints++;
		if(npoints >= MAX_DATA)
		    {
		    errtype("Maximum number of data points exceeded");
		    break;
		    }
		}
	    /*
	     * If there was not enough data in the line, then it indicates that
	     * the end of the data lines for this scan has been reached.
	     * Terminate loop reading data file for point detector.
	     */
	    else
		end_of_scan = TRUE;
	    } while(!end_of_scan && fgets(INLINE,INLLEN,infile) != NULL);
	}
    else
	/*
         * Start loop reading data for MCA detector.
	 */
	{
	mcaspcnt = 0;
	do
            {
	    /*
	     * If the next scan is reached (line starting with "#S"), end search
	     * for MCA spectra.
             */
	    if(INLINE[0] == '#' && INLINE[1] == 'S')
		{
		sprintf(STRING,"Error, only %d MCA spectra found\n",mcaspcnt+1);
		errtype(STRING);
		break;
		}
	    /*
	     * Skip over all other lines starting with a "#".
	     */
	    else if(INLINE[0] == '#')
		continue;
	    /*
	     * Data lines (the ones corresponding to the definitions in the "#L"
	     * line) contain just the numbers, no special characters like "#" or
	     * "@" in the first column. Get the monitor and the h, k, l values.
	     */
	    else if(INLINE[0] != '@' && INLINE[1] != 'A')
		{
		/*
		 * Check whether enough data is read in. If so, it is a proper
		 * data line.
		 */
		ptrn = INLINE;
		ncolumns = 0;
		do
		    {
		    ptrs = ptrn;
		    *(dummy + ncolumns++) = strtod(ptrs,&ptrn);
		    } while(ncolumns < maxcolumn && ptrn != ptrs);
		if(ncolumns >= maxcolumn)
		    {
		    if(MCOL > 0)
			monitor[0] = dummy[MCOL-1];
		    else
			monitor[0] = MONITOR_NORM;
		    HMIL[in_spec] = dummy[hcol-1];
		    KMIL[in_spec] = dummy[kcol-1];
		    LMIL[in_spec] = dummy[lcol-1];
		    scangval[in_spec] = dummy[0];
		    }
		continue;
		}
	    /*
	     * A starting line for an MCA spectrum. Check if it is the one
	     * requested by the user. If so, read it; if not, skip the spectrum
	     * and continue the loop over the MCA spectra for this scan.
	     */
	    if(mcaspcnt != mcaspec)
		{
		while(strchr(INLINE,'\\') != NULL)
		    fgets(INLINE,INLLEN,infile);
		mcaspcnt++;
		continue;
		}
	    /*
             * Requested MCA spectrum found, read it.
             */
	    do
		{
		nread = sscanf(INLINE,
		    "%*3[@A ]%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f",
		    &dummy[0],&dummy[1],&dummy[2],&dummy[3],&dummy[4],&dummy[5],
		    &dummy[6],&dummy[7],&dummy[8],&dummy[9],&dummy[10],
		    &dummy[11],&dummy[12],&dummy[13],&dummy[14],&dummy[15]);
		for(i = 0; i < nread; npoints++,i++)
		    {
		    if(npoints >= MAX_DATA)
			{
			end_of_scan = TRUE;
			errtype("Maximum number of data points exceeded");
			break;
			}
		    DATA[in_spec].X[npoints] = mcachst + npoints;
		    DATA[in_spec].Y[npoints] = dummy[i];
		    monitor[npoints] = monitor[0];
		    if(dummy[i] < 1e-10)
			DATA[in_spec].E[npoints] = 1;
		    else
			DATA[in_spec].E[npoints] = sqrt(dummy[i]);
		    }
		/*
		 * Test for end of MCA spectrum and, if found, terminate loop
		 * reading MCA spectrum.
		 */
		if(strchr(INLINE,'\\') == NULL)
		    break;
		} while(fgets(INLINE,INLLEN,infile) != NULL);
	    /*
	     * Reading of MCA spectrum is finished.
	     * Terminate loop reading data for MCA detector.
	     */
	    end_of_scan = TRUE;
	    if(npoints != mcachtot)
		{
		sprintf(STRING,"%s: found = %d, defined = %d\n",
		    "Error, incorrect number of points in spectrum",
		    npoints,mcachtot);
		errtype(STRING);
		}
	    } while(!end_of_scan && fgets(INLINE,INLLEN,infile) != NULL);
	}
    fclose(infile);
    free(dummy);

    XCOL = xcol_save;

    if(npoints == 0)
	{
	errtype("No data in spectrum");
	clear_command();
	return;
	}
    DATA[in_spec].NPNT = npoints;
    /*
     * For point detector scans, make h, k, l the average value.
     * Mark the variable containing the scan angle as to be ignored.
     */
    if(dettype == 1)
	{
	HMIL[in_spec] = HMIL[in_spec]/npoints;
	KMIL[in_spec] = KMIL[in_spec]/npoints;
	LMIL[in_spec] = LMIL[in_spec]/npoints;
	*scangnam[in_spec] = '\0';
	}
    else
	strncpy(scangnam[in_spec],scantype,sizeof(scangnam[0]) - 1);
    sprintf(STRING,"(hkl) = (%4.2f,%4.2f,%4.2f)\n",HMIL[in_spec],KMIL[in_spec],
	LMIL[in_spec]);
    type_line(STRING);

    /* If requested, normalize data */

    if(MCOL != 0)
	{
	for(i = 0; i < npoints; i++)
	    {
	    if(monitor[i] < 1) monitor[i] = 1;
	    DATA[in_spec].Y[i] *= MONITOR_NORM/monitor[i];
	    DATA[in_spec].E[i] *= MONITOR_NORM/monitor[i];
	    }
	}

    /* Find miniumum and maximum in spectrum */

    DATA[in_spec].MINY = DATA[in_spec].Y[0];
    DATA[in_spec].MAXY = DATA[in_spec].Y[0];
    for(i = 1; i < npoints; i++)
	{
	if(DATA[in_spec].Y[i] < DATA[in_spec].MINY)
	    DATA[in_spec].MINY = DATA[in_spec].Y[i];
	if(DATA[in_spec].Y[i] > DATA[in_spec].MAXY)
	    DATA[in_spec].MAXY = DATA[in_spec].Y[i];
	}

    /* Give spectrum a title */

    sprintf(DATA[in_spec].TITLE,"%.*s #%1d",TITLE_LENGTH-7,DATAFILE,SCANNR);

    sprintf(STRING,"Range of x-axis: %10.3g to %10.3g\n",DATA[in_spec].X[0],
	DATA[in_spec].X[DATA[in_spec].NPNT-1]);
    type_line(STRING);
    type_header(1);
    }
#else

/***************************************************************************/
void    read_spec(void)
/***************************************************************************/

	 /*
	Read scan from SPEC data file.
	 */

	 {

	 char    filename[FILENAME_MAX],par[3];
	 FILE    *infile;
	 int     in_spec = 1;
	 int     found,end_of_scan;
	 char    hatch,date[40];
	 int     i,scan;
	 float   monitor[MAX_DATA];
	 float   dummy[DATACOLUMNS];
	 int     maxcolumn,npoints;
	 float   norm_corr;
	 int     done,ncolumns,xcol_save;
	 static int  hcol,kcol,lcol;
	 char    column_name[40],name[DATACOLUMNS][40];
	 char    extension[4];
	 float   *x,*y,*e;
	 char    *strndx;
	 float	 omega,alfa;

	 /* femke */
	 int	femke;

	 /* Get scan number to be read in */

	 sprintf(STRING,"Scan number to be read in [%1d]: ",SCANNR);
	 SCANNR = get_int(SCANNR,STRING);

	 /*femke*/
	 if (SCANNR < 1)
		{
		SCANNR = -SCANNR;
		femke = TRUE;
		}
	 else
		femke = FALSE;

	/* Open SPEC file. */

	if ((infile = fopen(DATAFILE,"r")) == NULL)
		 {
		 sprintf(STRING,"Failed to open input file '%s'",DATAFILE);
		 errtype(STRING);
		 clear_command();
		 return;
		 }

	/* Search for correct scan number */

	found = FALSE;
	while (!found)
		{
		if (fgets(INLINE,INLLEN,infile) == NULL)
			{
			sprintf(STRING,"Scan not found in file '%s'",DATAFILE);
			errtype(STRING);
			clear_command();
			fclose(infile);
			return;
			}

		sscanf(INLINE,"%3c %d",par,&scan);
		if ((par[0]=='#') && (par[1] == 'S') && (scan == SCANNR))
			{
			found = TRUE;
			}
		}

	/* We have found the correct scan number, now get the rest of the
	information */

	/* Get the date and time */

	found = FALSE;
	while (!found)
		{
		if (fgets(INLINE,INLLEN,infile) == NULL)
			{
			sprintf(STRING,"Error, emtpy scan");
			errtype(STRING);
			clear_command();
			fclose(infile);
			return;
			}

		if ((INLINE[0]=='#') && (INLINE[1] == 'D'))
			{
			sscanf(INLINE,"%3c %24c",par,date);
			found = TRUE;
			}
		}

	  date[24] = 0;

	sprintf(STRING,"%s\n",date);
	type_line(STRING);

	/* Get angles needed for computation of Lorentz factor,
		polarization factor and area correction */

	 DELTA = 0;
	 BETAIN = 0;
	 ALPHA = 0;

	found = FALSE;
	while (!found)
		{
		if (fgets(INLINE,INLLEN,infile) == NULL)
			{
			sprintf(STRING,"Error, emtpy scan");
			errtype(STRING);
			clear_command();
			fclose(infile);
			return;
			}

		if ((INLINE[0]=='#') && (INLINE[1] == 'P') && (INLINE[2] == '0'))
			{

			sscanf(INLINE,"%3c%f%f%f%f%f%f%f", par, &dummy[0],
			&dummy[1],&dummy[2],&dummy[3],&dummy[4],&dummy[5],
			&dummy[6]);

			found = TRUE;
			}
		}

	if (SPECTYPE == ID03)
	    {
	    DELTA = dummy[0];
	    ALPHA = dummy[4];
	    BETAIN = dummy[4]; /* Z-axis mode only !! */
	    GAMMA = dummy[5];
	    }
	if (SPECTYPE == ID32)
	    {
	    DELTA = dummy[1];
	    ALPHA = dummy[3];
	    GAMMA = dummy[0];
	    BETAIN = dummy[3];
	    }
	if(SPECTYPE == ID32_k)
	    {
	    DELTA = dummy[0];
	    ALPHA = dummy[5];
	    GAMMA = dummy[4];
	    BETAIN = dummy[5];
	    }
	if (SPECTYPE == DUBBLE)
	    {
	    DELTA = dummy[1];
	    ALPHA = dummy[2];
	    GAMMA = dummy[0];
	    BETAIN = dummy[2];
	    }

	/* femke: trick to get special specular data read in with correct
	indices */

	if (femke)
		{
		ALPHA = (ALPHA+GAMMA)/2;
		GAMMA = ALPHA;
		}

	sprintf(STRING, "DELTA=%.3f,  ALPHA=%.3f, GAMMA=%.3f, BETA_IN=%.3f\n",
		DELTA, ALPHA, GAMMA, BETAIN);
	type_line(STRING);

	/* Read line with column names. Skip this line if the column number
	of the x-values if given. If XCOL < 0, ask for name of column. */

	found = FALSE;
	while (!found)
		{
		if (fgets(INLINE,INLLEN,infile) == NULL)
			{
			sprintf(STRING,"Error, emtpy scan");
			errtype(STRING);
			clear_command();
			fclose(infile);
			return;
			}

		if ((INLINE[0]=='#') && (INLINE[1] == 'L'))
			{
			found = TRUE;

			/* SPEC column names are separated by double spaces,
			thus replace all single spaces (that are part of column
			name) by underscore */

			for (i = 3; i < strlen(INLINE)-1; i++)
				{
				if ((INLINE[i] == ' ') && (INLINE[i-1] != ' ')
				&& (INLINE[i+1] != ' '))
				INLINE[i] = '_';
				}

			/* read column headers */

			ncolumns = sscanf(INLINE,
    "%3c %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s",
			par, name[0],name[1],name[2],name[3],name[4],name[5],
			name[6],name[7],name[8],name[9],name[10],name[11],
			name[12],name[13],name[14],name[15],name[16],name[17],
			name[18]);
                        ncolumns -= 1; /* the first item doesn't count */
			if (ncolumns >= DATACOLUMNS)
			    {
			    sprintf(STRING,
				"Too many data columns, only first %d used",
				DATACOLUMNS);
			    errtype(STRING);
			    }
			}
		}

	xcol_save = XCOL;
	hcol = 0;
	kcol = 0;
	lcol = 0;
	if (XCOL < 0)
		{
		done = FALSE;
		while (!done)
			{
			if (!get_token(column_name,
				"Give column name (type <return> for options): "))
				{
				type_line(INLINE);
				}
			else
				{
				string_tolower(column_name);
				for (i = 0; i < ncolumns; i++)
					{
					string_tolower(name[i]);
					if (strcmp(name[i],column_name) == 0)
						{
						XCOL = i+1;
						done = TRUE;
						sprintf(XCOLNAME,"%s",name[i]);
						}
					}
				if (XCOL < 0)
					{
					errtype("ERROR, no matching column name found");
					clear_command();
					fclose(infile);
					return;
					}
				}
			}

		/* Assign x-column name to title of x-axis in plot */

		sprintf(STRING,"x title %s break",XCOLNAME);
		put_command(STRING);
		plotxye(x,y,e,1);
		}

	for (i = 0; i < ncolumns; i++)
		{
		string_tolower(name[i]);
		if (strcmp(name[i],YCOLNAME) == 0) YCOL = i+1;
		if (strcmp(name[i],"h") == 0) hcol = i+1;
		if (strcmp(name[i],"k") == 0) kcol = i+1;
		if (strcmp(name[i],"l") == 0) lcol = i+1;
		if (MCOL != 0)
			 {
			if ( !strcmp(name[i],"monitor") ||
				  !strcmp(name[i],"monitor1") ||
				  !strcmp(name[i],"ion_ch")
				) MCOL = i+1;
			 }
		}

	/* Get spectrum number where data has to be stored */

	get_inspec(&in_spec);
	READSPEC = in_spec;


	 /* Find maximum column number to be read in */

	 if (XCOL > YCOL)
		maxcolumn = XCOL;
	 else
		maxcolumn = YCOL;

	 /* Read data and compute statistical error in y-values */

	 npoints = 0;
	 /* Made HMIL, KMIL and LMIL arrays (see ana.h) */
	 HMIL[READSPEC] = 0;
	 KMIL[READSPEC] = 0;
	 LMIL[READSPEC] = 0;
	 end_of_scan = FALSE;
	 while ((fgets(INLINE,INLLEN,infile) != NULL) && (!end_of_scan))
	{
	/* Check whether enough data is read in */
	if (sscanf(INLINE,"%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f",
		 &dummy[0],&dummy[1],&dummy[2],&dummy[3],&dummy[4],&dummy[5],
		 &dummy[6],&dummy[7],&dummy[8],&dummy[9],&dummy[10],&dummy[11],
		 &dummy[12],&dummy[13],&dummy[14],&dummy[15],&dummy[16],
		 &dummy[17],&dummy[18])
		 >= maxcolumn)
		 {
		 if (XCOL == 0) /* Ennumerate x-values */
			DATA[in_spec].X[npoints] = (float) npoints+1;
		 else
			DATA[in_spec].X[npoints] = dummy[XCOL-1];
		DATA[in_spec].Y[npoints] = dummy[YCOL-1];
		if (MCOL > 0)
			 monitor[npoints] = dummy[MCOL-1];
		else
			 monitor[npoints] = MONITOR_NORM;
		 /* Made HMIL, KMIL and LMIL arrays (see ana.h) */
		 HMIL[READSPEC] += dummy[hcol-1];
		 KMIL[READSPEC] += dummy[kcol-1];
		 LMIL[READSPEC] += dummy[lcol-1];
		if (dummy[YCOL-1] < 1e-10)
			{
			DATA[in_spec].E[npoints] = 1;
			}
		 else
			{
			DATA[in_spec].E[npoints] =  sqrt(dummy[YCOL-1]);
			}
		npoints++;
		if (npoints >= MAX_DATA)
			{
			errtype("Maximum number of data points exceeded");
			break;
			}
		 }
	else
		 {
		 end_of_scan = TRUE;
		 }
	}
	 fclose(infile);

	 XCOL = xcol_save;

	 if (npoints == 0)
		{
		errtype("No data in spectrum");
		clear_command();
		return;
		}
	 DATA[in_spec].NPNT = npoints;

	 /* Make h, k, l and two-theta the average value */

	 /* Made HMIL, KMIL and LMIL arrays (see ana.h) */
	 HMIL[READSPEC]  = HMIL[READSPEC]/npoints;
	 KMIL[READSPEC]  = KMIL[READSPEC]/npoints;
	 LMIL[READSPEC] = LMIL[READSPEC]/npoints;

	 /* femke */

	 if (femke)
		{
		HMIL[READSPEC] = 0.;
		KMIL[READSPEC] = 0.;
		LMIL[READSPEC] = 20.369*sin(GAMMA/RAD);
		}

	 sprintf(STRING,"(hkl) = (%4.2f,%4.2f,%4.2f)\n",HMIL[READSPEC],
	     KMIL[READSPEC],LMIL[READSPEC]);
	 type_line(STRING);

	/* If requested, normalize data */

	if (MCOL != 0)
	{
	for (i = 0; i < npoints; i++)
		{
		if (monitor[i] < 1) monitor[i] = 1;
		DATA[in_spec].Y[i] *= MONITOR_NORM/monitor[i];
		DATA[in_spec].E[i] *= MONITOR_NORM/monitor[i];
		}
	}

	/* Find miniumum and maximum in spectrum */

	 DATA[in_spec].MINY = DATA[in_spec].Y[0];
	 DATA[in_spec].MAXY = DATA[in_spec].Y[0];
	 for (i = 1; i < npoints; i++)
	{
	if (DATA[in_spec].Y[i] < DATA[in_spec].MINY)
		 DATA[in_spec].MINY = DATA[in_spec].Y[i];
	if (DATA[in_spec].Y[i] > DATA[in_spec].MAXY)
		 DATA[in_spec].MAXY = DATA[in_spec].Y[i];
	}

	/* Give spectrum a title */

        sprintf(DATA[in_spec].TITLE,"%.*s #%1d",TITLE_LENGTH-7,DATAFILE,SCANNR);

	sprintf(STRING,"Range of x-axis: %10.3g to %10.3g\n",
	DATA[in_spec].X[0],DATA[in_spec].X[DATA[in_spec].NPNT-1]);
	type_line(STRING);
	type_header(1);

	}
#endif /* EXTENSIONS Wilcke */

/***************************************************************************/
void    read_srs(int version)
/***************************************************************************/

    /*
    Read Daresbury SRS file.
    Since the file format is changing every now and then, the actions
    differ somewhat according to the version flag
    version 1   before 92
    version 2   starting 92
    */

    {

    char    filename[FILENAME_MAX],dummy_name[FILENAME_MAX],datetime[50];
    FILE    *infile;
    int     i,in_spec = 1,items,npoints;
    int     end_of_file,error_column;
    float   dummy[DATACOLUMNS];
    float   monitor[MAX_DATA];
/* #ifdef EXTENSIONS Wilcke */
    float   hmil,kmil,lmil;        /* Temporary storage for Miller indices. */
/* #endif EXTENSIONS Wilcke */
    static int     maxcolumn;
    int     done,ncolumns,xcol_save,timescan;
    char    column_name[20],name[20][20];
    float   *x,*y,*e;
    char    *spos;
    char    lastline[INLLEN];
    int     has_read_beta;
    int     digits;

    /* Get filename and open file, return if not successful */

    SCANNR = get_int(1,"Scan number: ");

    for(i=strlen(DATAFILE)-1, digits=5; i>=0; i--, digits--)
	{
	if(!isdigit(DATAFILE[i])) break;
	}

    sprintf(filename,"%s%0*d",DATAFILE,digits,SCANNR);
    add_extension(filename,"dat");
    if((infile = fopen(filename,"r")) == NULL)
	{
	sprintf(STRING,"Failed to open file '%s'",filename);
	errtype(STRING);
	clear_command();
	return;
	}

    /* Extract a few things from the header */

    ALPHA = BETAIN = DELTA = 0.;
    GAMMA = GAMMA_FIX; /* Can't be found in data file */
    fgets(INLINE,INLLEN,infile);
    fgets(INLINE,INLLEN,infile);
    sprintf(DATAINFO,"%.*s Date: %.2s-%.2s-%.2s time: %.2s:%.2s:%.2s",
	TITINFLN-40,filename,&INLINE[25],&INLINE[23],&INLINE[21],&INLINE[35],
	&INLINE[37],&INLINE[39]);
    sprintf(datetime,"Date: %.2s-%.2s-%.2s time: %.2s:%.2s:%.2s",
	&INLINE[25],&INLINE[23],&INLINE[21],&INLINE[35],&INLINE[37],
	&INLINE[39]);
    fgets(INLINE,INLLEN,infile);
    fgets(INLINE,INLLEN,infile);
    /*
     * Made HMIL, KMIL and LMIL arrays (see ana.h)
     * As the array index (= number of the spectrum) is not yet known here,
     * store the Miller indices in temporary variables.
     */
    sscanf(INLINE,"%8s%f %f %f %f",dummy_name,&hmil,&kmil,&lmil,&BETAIN);
    /*
    * First two characters must be spaces and beta shouldn't be zero for
    * correct beta read from header.
    */
    if ((strstr(INLINE,"  ") != INLINE+9) || (BETAIN == 0.))
	{
	BETAIN = 0.;
	has_read_beta = FALSE;
	}
    else
	{
	has_read_beta = TRUE;
	}

    sprintf(DATATITLE,"%.40s",&INLINE[9]);

    if (version == 1)   /* that's before '92 */
	{
	for (i = 0; i < 11; i++) fgets(INLINE,INLLEN,infile);
	fgets(INLINE,INLLEN,infile);
	sscanf(INLINE,"%s%f",dummy_name,&DELTA);
	for (i = 0; i < HEADER_LINES-16; i++) fgets(INLINE,INLLEN,infile);

	/* Since alpha and beta are not necessarily correct, ignore them
    	   for the time being */

	ALPHA = BETAIN = 0;

	}

    if (version == 2)   /* this is after Gordon's great rewrite */
	{

	/* We're looking in for the magic keywords DELTA and BETA_IN
    		  somewhere in the header ... */

	ALPHA = DELTA = 0.;  /* BETAIN should still be zero if not in header */


	for(;;) /* loop until we find the start of data marker */
	    {

	    fgets(INLINE, INLLEN, infile); /* read a line from file */

	    strupr(INLINE);                /* all char's -> uppercase */

	    if (strstr(INLINE,"--------------------") != NULL)
		{
		break; /* go and read data now */
		}

	    if ((spos=strstr(INLINE,"ALPHA")) != NULL)
		{
		sscanf(spos+5,"%f",&ALPHA);    /* get alpha if you need it */
		}
	    if ((spos=strstr(INLINE,"DELTA")) != NULL)
		{
		sscanf(spos+5,"%f",&DELTA);    /* get twotheta = delta */
		}
	    if (((spos=strstr(INLINE,"BETA_IN")) != NULL) &&
		(has_read_beta == FALSE))
		{
		sscanf(spos+7,"%f",&BETAIN);   /* get incoming angle */
		}
	    if ((spos=strstr(INLINE,"DETECTOR")) != NULL)
		{
		strcpy(lastline,INLINE);    /* save this line for the headers */
		}
	    } /* end of for loop */

	sprintf(STRING,"DELTA=%.3f,  ALPHA=%.3f,  BETA_IN=%.3f\n",
		DELTA,ALPHA,BETAIN);
	type_line(STRING);

	/* look for column headers */

	if (version == 1)
	    {
	    rewind(infile);
	    for (i = 0; i < HEADER_LINES-1; i++) fgets(INLINE,INLLEN,infile);
	    }

	if (version == 2)
	    {
	    strcpy(INLINE, lastline);   /* this still has the headers */
	    }

	ncolumns = sscanf(INLINE,
	    " %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s",
	    name[0],name[1],name[2],name[3],name[4],name[5],name[6],
	    name[7],name[8],name[9],name[10],name[11],name[12]);
	for (i = 0; i < ncolumns; i++) string_tolower(name[i]);
	xcol_save = XCOL;
	if (XCOL < 0) /* Get name of x */
	    {
	    done = FALSE;
	    while (!done)
		{
		if (!get_token(column_name,
		    "Give column name (type <return> for options): "))
		    {
		    type_line(INLINE);
		    }
		else
		    {
		    string_tolower(column_name);
		    for (i = 0; i < ncolumns; i++)
			{
			if (strcmp(name[i],column_name) == 0)
			    {
			    XCOL = i+1;
			    done = TRUE;
			    sprintf(XCOLNAME,"%s",name[i]);
			    }
			}
		    if (XCOL < 0)
			{
			errtype("ERROR, no matching column name found");
			clear_command();
			fclose(infile);
			XCOL = xcol_save;
			return;
			}
		    }
    		}
	    }
	else if (XCOL > 0) /* Get column name of x */
	   {
	   sprintf(XCOLNAME,"%s",name[XCOL-1]);
	   }
	else
	   {
	   sprintf(XCOLNAME,"x");
	   }

	if (XCOL != 0)
	    {
	    sprintf(STRING,"x title %s break",XCOLNAME);
	    put_command(STRING);
	    plotxye(x,y,e,1);
	    }

	/* Get column number of y values */

	for (i = 0; i < ncolumns; i++)
	    {
	    if (strcmp(name[i],YCOLNAME) == 0) YCOL = i+1;
	    }

	/* Get column number of monitor values */

	if (MCOL != 0)
	    {
	    for (i = 0; i < ncolumns; i++)
		{
		if (strcmp(name[i],"monitor") == 0) MCOL = i+1;
		}
	    }
/* Don't know why this has to be done (SdV, 16-7-96) (old data files?):
	fgets(INLINE,INLLEN,infile);
	BETAIN = 0;*/
	}

    if (strcmp(XCOLNAME,"time") == 0)
    	timescan = TRUE;
    else
    	timescan = FALSE;

    sprintf(STRING,"%s\n",datetime);
    type_line(STRING);
    sprintf(STRING,"Title: %s\n",DATATITLE);
    type_line(STRING);

    /* Get spectrum number where data has to be stored */

    get_inspec(&in_spec);
    READSPEC = in_spec;

    /* Find maximum column number to be read in */

    maxcolumn = XCOL;
    if (YCOL > maxcolumn) maxcolumn = YCOL;
    if (MCOL > maxcolumn) maxcolumn = MCOL;

    /* Read in spectrum */

    /*
     * Made HMIL, KMIL and LMIL arrays (see ana.h)
     * Store the temporary Miller indices variables in the correct array
     * elements.
     */
    HMIL[in_spec] = hmil;
    KMIL[in_spec] = kmil;
    LMIL[in_spec] = lmil;
    npoints = 0;
    end_of_file = FALSE;
    while ((fgets(INLINE,INLLEN,infile) != NULL) && (!end_of_file))
    	{
    	/* Check whether enough data is read in */
	if (sscanf(INLINE,"%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f",
	    &dummy[0],&dummy[1],&dummy[2],&dummy[3],&dummy[4],&dummy[5],
	    &dummy[6],&dummy[7],&dummy[8],&dummy[9],&dummy[10],&dummy[11])
	    >= maxcolumn)
	    {
	    if (XCOL == 0) /* Ennumerate x-values */
		{
		DATA[in_spec].X[npoints] = (float) npoints+1;
		}
	    else
		{
		if (npoints && timescan == TRUE) /* cumulate X column if */
		    {				 /* in time scan mode    */
		    DATA[in_spec].X[npoints] = DATA[in_spec].X[npoints-1] +
			dummy[XCOL-1];
		    }
		else
		    {
		    DATA[in_spec].X[npoints] = dummy[XCOL-1];
		    }
		}
	    DATA[in_spec].Y[npoints] = dummy[YCOL-1];
	    if (MCOL != 0) monitor[npoints] = dummy[MCOL-1];
	    npoints++;
	    if (npoints == MAX_DATA)
		{
		errtype("ERROR, maximum number of data points exceeded");
		break;
		}
	    }
	else
	    {
	    end_of_file = TRUE;
	    }
	} /* end of while */
    fclose(infile);
    if (npoints == 0)
	{
	errtype("No data in spectrum");
	clear_command();
	XCOL = xcol_save;
	return;
    	}
    DATA[in_spec].NPNT = npoints;

    XCOL = xcol_save;

    /* If required, do the solid-state detector correction */

    if (SOLID_CORR)
	for (i = 0; i < npoints; i++) DATA[in_spec].Y[i] -= 1;

    /* Calculate statistical error */

    for (i = 0; i < npoints; i++) DATA[in_spec].E[i] = sqrt(DATA[in_spec].Y[i]);

    /* if required, normalize on monitor signal */

    if (MCOL != 0)
	{
	for (i = 0; i < npoints; i++)
	    {
	    if (monitor[i] < 1) monitor[i] = 1;
	    DATA[in_spec].Y[i] *= MONITOR_NORM/monitor[i];
	    DATA[in_spec].E[i] *= MONITOR_NORM/monitor[i];
	    }
	}

    /* Find miniumum and maximum in spectrum */

    DATA[in_spec].MINY = DATA[in_spec].Y[0];
    DATA[in_spec].MAXY = DATA[in_spec].Y[0];
    for (i = 1; i < npoints; i++)
	{
	if (DATA[in_spec].Y[i] < DATA[in_spec].MINY)
	DATA[in_spec].MINY = DATA[in_spec].Y[i];
	if (DATA[in_spec].Y[i] > DATA[in_spec].MAXY)
	DATA[in_spec].MAXY = DATA[in_spec].Y[i];
	}

    /* Give spectrum a title */

    sprintf(DATA[in_spec].TITLE,"%.*s",TITLE_LENGTH,filename);

    sprintf(STRING,"Range of x-axis: %10.3g to %10.3g\n",
	DATA[in_spec].X[0],DATA[in_spec].X[DATA[in_spec].NPNT-1]);
    type_line(STRING);
    type_header(1);

    }

/***************************************************************************/
void    read_super(int old)
/***************************************************************************/

/*
 *  Read scan from SUPER file. There are two modes:
 *  - old = TRUE    old style: large file with many scans
 *  - old = FALSE   new style: file with one scan
 */

     {

     char    filename[FILENAME_MAX];
     FILE    *infile;
     int     in_spec = 1;
     int     found = FALSE,end_of_scan;
     char    hatch,date[21];
     int     i,scan;
     float   monitor;
     float   dummy[DATACOLUMNS];
     int     maxcolumn,npoints;
     float   norm_corr;
     int     done,ncolumns,xcol_save;
     static int  hcol,kcol,lcol,tthcol,alpcol,betcol;
     char    column_name[20],name[20][20];
     char    extension[4];
     float   *x,*y,*e;

     /* Get scan number to be read in */

     sprintf(STRING,"Scan number to be read in [%1d]: ",SCANNR);
     SCANNR = get_int(SCANNR,STRING);

     /* Open SUPER file. Different for the two modes */

    if(old)    /* Old style SUPER file */
    {
    if((infile = fopen(DATAFILE,"r")) == NULL)
	{
	sprintf(STRING,"Failed to open input file '%s'",DATAFILE);
	errtype(STRING);
	clear_command();
	return;
	}
    }
    else        /* New style SUPER file */
    {

    /* Scannumbers > 999 get the extra digit as part of the filename */

    if(SCANNR/1000 > 0)
	{
	if(NAUTOSUB > 0)
	    sprintf(filename,"%s%1d\\%s%1d.%03d",PATHNAME,
		    SCANNR/NAUTOSUB,DATAFILE,SCANNR/1000,SCANNR%1000);
	else
	    sprintf(filename,"%s%1d.%03d",DATAFILE,SCANNR/1000,
		    SCANNR%1000);
	}
    else
	{
	if(NAUTOSUB > 0)
	    sprintf(filename,"%s%1d\\%s.%03d",PATHNAME,
		    SCANNR/NAUTOSUB,DATAFILE,SCANNR%1000);
	else
	    sprintf(filename,"%s.%03d",DATAFILE,SCANNR%1000);
	}
    if((infile = fopen(filename,"r")) == NULL)
	{
	sprintf(STRING,"Failed to open input file '%s'",filename);
	errtype(STRING);
	clear_command();
	return;
	}
    }

    /* Search for correct scan number */

    while(!found)
    {
    if(fgets(INLINE,INLLEN,infile) == NULL)
	{
	if(old)
	    sprintf(STRING,"Scan not found in file '%s'",DATAFILE);
	else
	    sprintf(STRING,"Scan not found in file '%s'",filename);
	errtype(STRING);
	clear_command();
	return;
	}
    sscanf(INLINE,"%c%d",&hatch,&scan);
    if((hatch == '#') && (scan == SCANNR))
	{
	found = TRUE;
#ifdef MSDOS
	sprintf(DATAINFO,"@%s",INLINE);     /* The @ is for GraphiC */
#endif
	sscanf(INLINE,"%80[^=]%*c%f%*6c%20c",STRING,&monitor,date);
	}
    else if(hatch == '>')
	{
	/* Remove newline character at the end */
	i = strlen(INLINE) < TITINFLN ? strlen(INLINE) : TITINFLN;
	sprintf(DATATITLE,"%.*s",i-1,INLINE);
	}
    }

    /* Read line with column names. Skip this line if the column number
    of the x-values if given. If XCOL < 0, ask for name of column. */

    if (fgets(INLINE,INLLEN,infile) == NULL)
	{
	errtype("Error, empty spectrum");
	clear_command();
	return;
	}
    xcol_save = XCOL;
    if (XCOL < 0)
    {
	hcol = 0;
	kcol = 0;
	lcol = 0;
	tthcol = 0;
	done = FALSE;
	while (!done)
	    {
	    if (!get_token(column_name,
		"Give column name (type <return> for options): "))
		{
		type_line(INLINE);
		}
	    else
		{
		string_tolower(column_name);
		ncolumns = sscanf(INLINE,
		    "%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s",
		    name[0],name[1],name[2],name[3],name[4],name[5],name[6],
		    name[7],name[8],name[9],name[10],name[11],name[12]);
		for (i = 0; i < ncolumns; i++)
		    {
		    string_tolower(name[i]);
		    if (strcmp(name[i],column_name) == 0)
			{
			XCOL = i+1;
			done = TRUE;
			sprintf(XCOLNAME,"%s",name[i]);
			}
		    if (strcmp(name[i],YCOLNAME) == 0) YCOL = i+1;
		    if (strcmp(name[i],"h") == 0) hcol = i+1;
		    if (strcmp(name[i],"k") == 0) kcol = i+1;
		    if (strcmp(name[i],"l") == 0) lcol = i+1;
		    if (strcmp(name[i],"tth") == 0) tthcol = i+1;
		    if (strcmp(name[i],"bet") == 0) betcol = i+1;
		    if (strcmp(name[i],"mcr") == 0) alpcol = i+1;
		    }
		if (XCOL < 0)
		    {
		    errtype("ERROR, no matching column name found");
		    clear_command();
		    fclose(infile);
		    return;
		    }
		}
	    }
	sprintf(STRING,"x title %s break",XCOLNAME);
	put_command(STRING);
	plotxye(x,y,e,1);
	}

    /* Get spectrum number where data has to be stored */

    get_inspec(&in_spec);
    READSPEC = in_spec;

    /* Display some information about the file */

    DATATITLE[0] = ' ';
    sprintf(STRING,"Title: %s\n",DATATITLE);
    type_line(STRING);
    date[20] = '\0';
    sprintf(STRING,"Creation date: %s\n",date);
    type_line(STRING);

    /* Find maximum column number to be read in */

    if (XCOL > YCOL)
	maxcolumn = XCOL;
    else
	maxcolumn = YCOL;

    /* Read data and compute statistical error in y-values */

    npoints = 0;
    /* Made HMIL, KMIL and LMIL arrays (see ana.h) */
    HMIL[in_spec] = 0;
    KMIL[in_spec] = 0;
    LMIL[in_spec] = 0;
    DELTA = 0;
    BETAIN = 0;
    ALPHA = 0;
    end_of_scan = FALSE;
    while ((fgets(INLINE,INLLEN,infile) != NULL) && (!end_of_scan))
	{
	/* Check whether enough data is read in */
	if (sscanf(INLINE,"%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f",
	    &dummy[0],&dummy[1],&dummy[2],&dummy[3],&dummy[4],&dummy[5],
	    &dummy[6],&dummy[7],&dummy[8],&dummy[9],&dummy[10],&dummy[11])
	    >= maxcolumn)
	    {
	    if (XCOL == 0) /* Ennumerate x-values */
		DATA[in_spec].X[npoints] = (float) npoints+1;
	    else
		DATA[in_spec].X[npoints] = dummy[XCOL-1];
	    DATA[in_spec].Y[npoints] = dummy[YCOL-1];
	    /* Made HMIL, KMIL and LMIL arrays (see ana.h) */
	    HMIL[in_spec] += dummy[hcol-1];
	    KMIL[in_spec] += dummy[kcol-1];
	    LMIL[in_spec] += dummy[lcol-1];
	    DELTA += dummy[tthcol-1];
	    if (betcol != 0) BETAIN += dummy[betcol-1];
	    if (alpcol != 0) ALPHA += dummy[alpcol-1];
	    if (dummy[YCOL-1] < 1e-10)
		{
		DATA[in_spec].E[npoints] = 1;
		}
	    else
		{
		DATA[in_spec].E[npoints] =  sqrt(dummy[YCOL-1]);
		}
	    npoints++;
	    }
	else
	    {
	    end_of_scan = TRUE;
	    }
	}
    fclose(infile);

    XCOL = xcol_save;

    if (npoints == 0)
	{
	errtype("No data in spectrum");
	clear_command();
	return;
	}
    DATA[in_spec].NPNT = npoints;

    /* Make h, k, l and two-theta the average value */

    /* Made HMIL, KMIL and LMIL arrays (see ana.h) */
    HMIL[in_spec]  = HMIL[in_spec]/npoints;
    KMIL[in_spec]  = KMIL[in_spec]/npoints;
    LMIL[in_spec] = LMIL[in_spec]/npoints;
    DELTA = DELTA/npoints;
    BETAIN = BETAIN/npoints;
    ALPHA = ALPHA/npoints;
    sprintf(STRING,"(hkl) = (%4.2f,%4.2f,%4.2f)\n",HMIL[in_spec],KMIL[in_spec],
	LMIL[in_spec]);
    type_line(STRING);

    /* If requested, normalize data */

    if ((MCOL != 0) && (monitor > 0.1))
	{
	norm_corr = MONITOR_NORM/monitor;
	for (i = 0; i < npoints; i++)
	    {
	    DATA[in_spec].Y[i] *= norm_corr;
	    DATA[in_spec].E[i] *= norm_corr;
	    }
	}

    /* Find miniumum and maximum in spectrum */

    DATA[in_spec].MINY = DATA[in_spec].Y[0];
    DATA[in_spec].MAXY = DATA[in_spec].Y[0];
    for(i = 1; i < npoints; i++)
	{
	if (DATA[in_spec].Y[i] < DATA[in_spec].MINY)
	    DATA[in_spec].MINY = DATA[in_spec].Y[i];
	if (DATA[in_spec].Y[i] > DATA[in_spec].MAXY)
	    DATA[in_spec].MAXY = DATA[in_spec].Y[i];
	}

    /* Give spectrum a title */

    if(old)
        sprintf(DATA[in_spec].TITLE,"%.*s #%1d",TITLE_LENGTH-7,DATAFILE,SCANNR);
    else
	sprintf(DATA[in_spec].TITLE,"%.*s",TITLE_LENGTH,filename);

    sprintf(STRING,"Range of x-axis: %10.3g to %10.3g\n",
	DATA[in_spec].X[0],DATA[in_spec].X[DATA[in_spec].NPNT-1]);
    type_line(STRING);
    type_header(1);

    }

/***************************************************************************/
void    read_type(void)
/***************************************************************************/

/*
 *  Get type of file to be read in.
 */

    {

    /* define read_type_menu */

#ifdef EXTENSIONS /* Wilcke */
    static struct   MENU read_type_menu[] =
	{
	"srs",      2,  1,  "SRS data file",
	"spec",     2,  6,  "SPEC data file",
	"spmca",    3,  7,  "SPEC MCA data file",
	"super",    2,  2,  "Super data file (single scan)",
	"osuper",   1,  3,  "Old super scan (in bigdata file)",
	"xye",      1,  4,  "File with x y (and opt. error) columns",
	"column",   1,  5,  "File with arbitrary amount of columns",
	"ftascom",  1,  8,  "Single column tascom data file",
	"help",     1,  20, "Display menu",
	"return",   1,  21, "Return to main menu"
	};

    /* number of commands in read_type menu */
    int read_type_length = sizeof(read_type_menu) / sizeof(read_type_menu[0]);
#else
#define read_type_length 9       /* number of commands in read_type menu */

	 static struct   MENU read_type_menu[read_type_length] =
	{
	"srs",      1,  1,  "SRS data file",
	"spec",     2,  6,  "SPEC data file",
	"super",    2,  2,  "Super data file (single scan)",
	"osuper",   1,  3,  "Old super scan (in bigdata file)",
	"xye",      1,  4,  "File with x y (and opt. error) columns",
	"column",   1,  5,  "File with arbitrary amount of columns",
	"ftascom",  1,  7,  "Single column tascom data file",
	"help",     1,  20, "Display menu",
	"return",   1,  21, "Return to main menu"
	};
#endif /* EXTENSIONS Wilcke */

    int stop = FALSE,old;
    char token[100];

    while(!stop)
	{
	type_header(0);
	if(!get_token(token,"File type: ")) return;
	switch(cmnd_match(token,read_type_menu,read_type_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		read_srs(2);
		return;
	    case 2:
		old = FALSE;
		read_super(old);
		return;
	    case 3:
		old = TRUE;
		read_super(old);
		return;
	    case 4:
		read_xye();
		return;
	    case 5:
		read_column();
		return;
	    case 6:
#ifdef EXTENSIONS /* Wilcke */
		read_spec(1);
#else
		read_spec();
#endif /* EXTENSIONS Wilcke */
		return;
	    case 7:
#ifdef EXTENSIONS /* Wilcke */
		read_spec(2);
#else
		read_ftascom();
#endif /* EXTENSIONS Wilcke */
		return;
#ifdef EXTENSIONS /* Wilcke */
	    case 8:
		read_ftascom();
		return;
#endif /* EXTENSIONS Wilcke */
	    case 20:
		list_menu("FILE TYPES",read_type_menu,read_type_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    read_xye(void)
/***************************************************************************/

/*
 *  Read xye file:
 *  - one comment line
 *  - data line with x and y values, and optionally an error in third column.
 */

    {

    char    filename[FILENAME_MAX];
    FILE    *infile;
    int     i,in_spec = 1,items,npoints;
    int     error_column,end_of_file;
    float   x,y,e;

    /* Get filename and open file, return if not successful */

    get_token(filename,"Give filename (.dat): ");
    add_extension(filename,"dat");
    if((infile = fopen(filename,"r")) == NULL)
	{
	sprintf(STRING,"Failed to open file '%s'",filename);
	errtype(STRING);
	clear_command();
	return;
	}

    /* Get spectrum number where data has to be stored */

    get_inspec(&in_spec);
    READSPEC = in_spec;

    /* Type comments */

    if(fgets(INLINE,INLLEN,infile) == NULL)
	{
	errtype("ERROR, file is empty");
	fclose(infile);
	clear_command();
	return;
	}
    else
	{
	type_line(INLINE);
	sprintf(DATATITLE,"%.*s",TITINFLN-1,INLINE);
	}

#ifdef EXTENSIONS /* Wilcke */
    /* skip extra header lines (this is due to WJ) */

    for(i=1; i<HEADER_LINES; i++)
	{
	fgets(INLINE,INLLEN,infile);
	}
#endif /* EXTENSIONS Wilcke */

    /* Find out if there is an error column in file */

    if(fgets(INLINE,INLLEN,infile) == NULL)
	{
	errtype("ERROR, file is empty");
	fclose(infile);
	clear_command();
	return;
	}
    items = sscanf(INLINE,"%f%f%f",&x,&y,&e);
    if(items == 3)
    {
	error_column = TRUE;
	DATA[in_spec].X[0] = x;
	DATA[in_spec].Y[0] = y;
	DATA[in_spec].E[0] = e;
	}
    else if(items == 2)
	{
	error_column = FALSE;
	DATA[in_spec].X[0] = x;
	DATA[in_spec].Y[0] = y;
	DATA[in_spec].E[0] = 1;
	}
    else
	{
	errtype("ERROR, when reading file");
	fclose(infile);
	clear_command();
	return;
	}

    npoints = 1;
    end_of_file = FALSE;
    while((fgets(INLINE,INLLEN,infile) != NULL) && (!end_of_file))
	{
	if(error_column)       /* read in three values */
	    {
	    if(sscanf(INLINE,"%f%f%f",&x,&y,&e) == 3)
		{
		DATA[in_spec].X[npoints] = x;
		DATA[in_spec].Y[npoints] = y;
		DATA[in_spec].E[npoints] = e;
		npoints++;
		}
	    else
		{
		end_of_file = TRUE;
		}
	    }
	else                    /* read in two values */
	    {
	    if(sscanf(INLINE,"%f%f",&x,&y) == 2)
		{
		DATA[in_spec].X[npoints] = x;
		DATA[in_spec].Y[npoints] = y;
		DATA[in_spec].E[npoints] = 1;
		npoints++;
		}
	    else
		{
		end_of_file = TRUE;
		}
	    }
	}
    fclose(infile);
    if(npoints == 0)
	{
	errtype("No data in spectrum");
	clear_command();
	return;
	}
    DATA[in_spec].NPNT = npoints;

    /* Find miniumum and maximum in spectrum */

    DATA[in_spec].MINY = DATA[in_spec].Y[0];
    DATA[in_spec].MAXY = DATA[in_spec].Y[0];
    for(i = 1; i < npoints; i++)
	{
	if(DATA[in_spec].Y[i] < DATA[in_spec].MINY)
	    DATA[in_spec].MINY = DATA[in_spec].Y[i];
	if(DATA[in_spec].Y[i] > DATA[in_spec].MAXY)
	    DATA[in_spec].MAXY = DATA[in_spec].Y[i];
	}

    /* Give spectrum a title */

    sprintf(DATA[in_spec].TITLE,"%.*s",TITLE_LENGTH,filename);

    sprintf(STRING,"Range of x-axis: %10.3g to %10.3g\n",
	DATA[in_spec].X[0],DATA[in_spec].X[DATA[in_spec].NPNT-1]);
    type_line(STRING);
    type_header(1);

    }
