/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$$$$$$                 mcsl.h                              $$$$$$$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: mcsl.h,v 1.5 2007/03/19 11:47:37 wilcke Exp $


****************************************************************************/

/****************************************************************************

  Marie-Claire SAINT-LAGER,
  laboratoire de Cristallographie-CNRS, 25 avenue des Martyrs
  BP 166 38042 Grenoble cedex FRANCE
  mail: stlager@polycnrs-gre.fr

Update 21/02/2007 Rainer Wilcke (wilcke@esrf.fr)
                  move global variable NFITAUTO here from "lsqfit/lsqfit.h".
Update 18/04/2001 M.-C. SAINT-LAGER (stlager@polycnrs-gre.fr)
                  change of plot_sfac_mcsl => plot_sfac_mcsl(int mode)
                  => 3 modes for plot_sfac_mcsl (plot magnitude of structure
                     factors as circles in reciprocal space) with drawing
                     options defined in set_plot_mcsl)
                        mode 1  theoretical structure factors
                        mode 2  experimental structure factors
                        mode 3  theoretical plus experimental structure factors
                  => induced modifications
                     - in mcsl.h for the plot_sfac_mcsl declaration
                     - plot.c for calling plot_sfac_mcsl() instead of
                       plot_sfac()

Update 19/01/2001 M.-C. SAINT-LAGER (stlager@polycnrs-gre.fr)
                  => change in the MCSL extensions: the setting of color,
                     unit... is moved to the "set plot" menu
                  => in plot.c: the call to the function plot_sfac_mcsl() only
                     do the fb plot

                  => little improvements in the output file menu

                  => in set_fit_auto()
                     - automatically save the name and the value in the output
                       file:
                       + of the loosed parametrer
                       + of the parameter choose in each loop
                       + chisq and R_factor

                     - most of the print on the screen during fitloop,
                       which slows down the program

Update 18/01/2001 M.-C. SAINT-LAGER (stlager@polycnrs-gre.fr)
                  modification for the automatic fitting
                  - to suppress the listing on the screen during the runs
                  - to give automatically the value of 1 to chi2_inc
                    not to prompt during running

                  => lsqfit.h (in the local directory lsqfit): new global
                     variable NFITAUTO

                  => mcsl.c
                     -> include "../lsqfit/lsqfit.h" instead of <lsqfit.h>
                     -> fit_auto():
                        the flag NFITAUTO = TRUE before automatic fit
                        and FALSE just after

                  => lsqfit.c: during automatic fit
                     - listing on the screen is suppressed in function lsqfit
                       (no call of the function list_fitresults )
                     - and the value of 1 is given to chi2_inc
                     - in the function COOLDOWN()
                     - and in levenberg() one

Update 25/10/2000 O. Svensson (svensson@esrf.fr)
                  Added "#ifndef _MCSL_H_" etc.
                  Added function prototype for mcsl_init().

Update 09/09/2000 M.-C. SAINT-LAGER (stlager@polycnrs-gre.fr)
                  new option in the MCSL' EXTENSION MENU:
                  loop for automatic fitting

                  => mcsl.c: 3 new functions:
                     void  loop_fit_mcsl(void);
                     void  set_loop_fit(int);
                     void  fit_auto(void);

                     -> loop_fit_mcsl: loop for doing fit by changing
                        automatically the fit parameters
                        loop[j] includes loop[j-1]
                        command "lj" (1 <= j <= 6) calls set_loop_fit(j)

                     -> set_loop_fit
                        which allow to define the 4 parameters of the loop j
                        (which are global variables declared in mcsl.h and
                        initialized in rod.c):
                        - PAR_LOOP[j]  = serial number of the FITPAR
                        - INIT_LOOP[j] = start value
                        - END_LOOP[j]  = final value
                        - STEP_LOOP[j] = iteration step

                        NP_LOOP[j] is deduced from the previously defined values

                     -> run_fit (in loop_fit_mcsl) call

                     -> fit_auto ( fit() of fit.c) modified as followed
                        the 6 loops begin just before
                        "if (rc != LSQ_NOFIT)
                        rc = lsqfit(..............."
                        and are closed just at the end of the function fit_auto

                  before coming in the loops the programm runs through the menu
                  ROD.FIT> where fit parameters can be loosed, changed, fixed...
                  the fitting itself begin when the key <run> is selected

                  !!!!!!!!!! Before defining the loops parameters !!!!!!!!!!!!
                  You need to define the file of output to save value of the
                  parameters and the results of the fit
                  for this: select the option "output file" of the ROD.EXT.MCSL>
                  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

Update 06/09/2000 M.-C. SAINT-LAGER (stlager@polycnrs-gre.fr)
                  change in the plot for the both structure factor (FB): theory
                  + data
                  => void plot_sfac_mcsl in mcsl.c
                     - color of both 1/2 circle can be choosen
                     - color of their contour
                     - the Xmin, Xmax, Ymin and Ymax
                     - the scale of the X and Y axis : cte/Angrstrm or rlu

                  => mcsl.h :4 new global PLOT variables
                     color_fth[20]       : 1/2 circle filling (theory)
                     color_fdata[20]     : 1/2 circle filling (data)
                     color_cont_fth[20]  : 1/2 circle contour (theory)
                     color_cont_fdata[20]: 1/2 circle contour (data)

                  => initilize dans rod.c ->
                     4 new global PLOT variables -> "black"

                  => in plot.c : this function is called when the MCSL'extension
                     is activated instead of plot_sfac(3)

Update 07/08/2000 M.-C. SAINT-LAGER (stlager@polycnrs-gre.fr)
                  Warning: in the menu mcsl SET: does not work

Update 03/08/2000 M.-C. SAINT-LAGER (stlager@polycnrs-gre.fr)
                  new serial number NOCCUP2 for atom occupancy in fit file
                  useful for binary alloys
                  -> for each atom: OCCUPTOT = OCCUP(NOCCUP) - OCCUP2(NOCCUP)

                  => calc.c: in calc_surf, fatom *= OCCUPTOT[i]

                  => list.c: case list_sm (case 6): add a column for the
                     occupation fraction


Update 03/08/2000 M.-C. SAINT-LAGER (stlager@polycnrs-gre.fr)
                  read.c / read_fit: when using Mcsl's extension: 2 formats of
                  lecture are possible depending on the chosen calculation of
                  ZSFIT.

                  They are reconized by the 3rd line of the .fit FILE
                  - which must begin by #
                  - the order of the names is not important
                  - a few can be omitted
                  - but the name of each column must be respected, if not they
                    are not reconized. The value array must be connected to the
                    name title

                  1: #el XS cxl nxl cx2 nx2 YS cyl nyl cy2 ny2
                         ZS czl nzl cz2 nz2 cz3 nz3 dwl dw2 ocl oc2
                     -> in that case NDELTAZS = FALSE

                  2: #el XS cxl nxl cx2 nx2 YS cyl nyl cy2 ny2
                         NP
                         DZS czl nzl cz2 nz2 cz3 nz3 dwl dw2 ocl oc2
                     -> it finds NP => switch NDELTAZS to TRUE

                  NDELTAZS determines the calculation mode of ZSFIT

                  1- ZS is defined as in the standard version from the interface
                     substrate/surf
                     => 3 additionnal columns compared to Odile Robach extension
                        Z3CONST = multiplication factor of DISPL[NZ3DIS]
                        NZ3DIS  = serial number of 3rd z-displacement parameter
                        NOCCUP2 = 2nd serial number for the atomic accupation

                     The list of columns becomes:
                     El X XCONST NXDIS X2CONST NX2DIS
                        Y YCONST NYDIS Y2CONST NY2DIS
                        Z ZCONST NZDIS Z2CONST NZ2DIS Z3CONST NZ3DIS
                        NDWS NDWS2 NOCCUP NOCCUP2

                  2- ZS is defined as the interplane distance (NDELTAZS=1)
                     => 1 additionnal column compared to the case (NDELTAZS=0)
                        NZSPLAN = serial number of the plane were the atom is
                                  (has to start at 1)

                     The list of columns becomes:
                     El X XCONST NXDIS X2CONST NX2DIS
                        Y YCONST NYDIS Y2CONST NY2DIS
                        NZSPLAN
                        Z ZCONST NZDIS Z2CONST NZ2DIS Z3CONST NZ3DIS
                        NDWS NDWS2 NOCCUP NOCCUP2

                  => read.c / read_fit:
                     - comments
                     - local variables
                     - initialization
                     - reading -> read_name() & read_auto in mcsl.c
                     - calculation of NPLAN
                     - NZ3DIS -> NDISTOT, NOCCUP2 -> NOCCTOT
                     - NSURF  -> NSURFTOT - NSURF2

                  => list.c
                     case list_fit (case 8): list of all the colums with their
                     names

                  => set.c/ update_model:
                     call mcsl_update_model (in mcsl.c) for the Mcsl's extension

                  => mcsl.c / mcsl_update_model
                     if NDELTAZS is true for the atom i which is in the plane
                     j=NZSPLAN(i):
                     - Z(i) = zmoy(j-1) +dz(i),
                     - dz = ZS + ZCONST*NZSDIS(i) + Z2CONST*N2ZSDIS(i)+
                                 Z3CONST*N3ZSDIS(i)
                     - zmoy (plan j) = Sum of <dz> from the plan 1 to j (<dz>
                       averaged over all the atom of the same plane)
                     - the average is performed for each of the 2 surface
                       fractions
                     - ZS is the interplane distance, normalized to the
                       coordinate of the surface atom

Update 03/08/2000 M.-C. SAINT-LAGER (stlager@polycnrs-gre.fr)
                  some initializations in rod.c
                  - initialze()
                  - and in case i_reset

Update 02/08/2000 M.-C. SAINT-LAGER (stlager@polycnrs-gre.fr)
                  new serial number NOCCUPB for the occupation of atom bulk
                  (useful for alloys)
                  Odile Robach has begun to introduce this in read.c
                  I have completed it, in such a way that it is common to both
                  extentions: Robach & MCSL

                  => read.c / read_bulk:
                    if (robach_flag) => ((robach_flag)||(mcsl_flag))

                  => list.c: case list_bm (case 7): add a column for the
                     occupation fraction

                  => calc.c: fatom *= OCCUP[NOCCUPB[i]-1]
                     in  calc_bulk and in calc_bulk_beta

Update 02/08/2000 M.-C. SAINT-LAGER (stlager@polycnrs-gre.fr)
                  in the menu ROD.EXT.MCSL>:
                  option to create a save file for the results of fitting

                  => void  save_fit_result(void) in mcsl.c

                  => change in fit.c
                     - for calculating chisq_norm and R_factor
                     - to write them on the screen
                     - to save the value of the selected fit parameters and
                       chisqr, r_factor ...

                  => close the file at the end of rod.c

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!! fit_auto() DOES NOT work for COOLDOWN !!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


****************************************************************************/

#ifndef _MCSL_H_
#define _MCSL_H_

SET int mcsl_flag;            /* flag for using MCSL's extensions of ROD */

FIT int NFITAUTO;             /* flag to denote if lsqfit is called by
                                 fit_auto() */
FIT int NZSPLAN[MAXATOMS];    /* Serial number of the plane where the atom is
                                 in that case NDELTAZS=1 */
FIT int NPLAN;                /* number of atomic plane read in the fit file */
FIT float Z3CONST[MAXATOMS];  /* Multiplication factor of 3rd y-displacement
                                 parameter */
FIT int NZ3DIS[MAXATOMS];     /* Serial number of 3rd y-displacement par. */
/* FIT int NOCCUP2[MAXATOMS];    Serial number of 2d occupation fraction */
/* FIT float OCCUPTOT[MAXPAR];   Values of total occupation parameters */
FIT int NDELTAZS;             /* Flag for ZSFIT calculation
                                 false -> ZS defined from surface (usual way)
                                 true  -> ZS defined from the plane just below
                                          in this case it has read NZSPLAN */

FIT int NCOL[25];             /* array of the serial number of column in the
                                 input fit file (except the 'element')
                                 NCOL[0]= number of column to read */

FIT int NPAR;                 /* Total number of parameters */
FIT int SAVPAR[MAXFIT];       /* Flag to denote a param. to save in a tab file*/
FIT int NOUTFILE;             /* flag to denote if a tab file is open */
FIT FILE *TABFILE;            /* file of parameter */
FIT char TABFILENAME[30];

#define MAXNLOOP 12           /* Maximum total number loop */

FIT int PAR_LOOP[MAXNLOOP];   /* serial number of the parameter of the loop */
FIT float INIT_LOOP[MAXNLOOP];/* initial value of the param. of the loop */
FIT float END_LOOP[MAXNLOOP]; /* final value of the param. of the loop */
FIT float STEP_LOOP[MAXNLOOP];/* Step of the loop */
FIT int NP_LOOP[MAXNLOOP];    /* number of steps in the loop */

/*
   variables used in the submenu fb: plot of both teoretical and experimental
   structure factors
 */
PLOT float X_low;             /* Min of the X axis */
PLOT float X_up;              /* Max of the X axis */
PLOT float Y_low;             /* Min of the Y axis */
PLOT float Y_up;              /* Max of the Y axis */
PLOT float X_norm;            /* unit factor of X axis (1 -> Angstrom-1) */
PLOT float Y_norm;            /* unit factor of Y axis (1 -> Angstrom-1) */

/* color of the structure factors : */
PLOT char color_fth[20];       /* 1/2 circle filling (theory) */
PLOT char color_fdata[20];     /* 1/2 circle filling (data) */
PLOT char color_cont_fth[20];  /* 1/2 circle contour (theory) */
PLOT char color_cont_fdata[20];/* 1/2 circle contour (data) */

void mcsl(void);
void mcsl_init(void);
void save_fit_result(void);
void mcsl_set_fit(void);
void read_name(void);
void read_auto(void);
void mcsl_update_model(void);
void plot_sfac_mcsl(int);
void set_plot_mcsl(void);
void loop_fit_mcsl(void);
void set_loop_fit(int);

#endif /* _MCSL_H_ */
