/* $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ */
/* $$$$$                         rod.c                                 $$$$$ */
/* $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ */

/****************************************************************************

  CVS information:

  $Id: rod.c,v 1.17 2006/03/28 15:43:39 wilcke Exp $

****************************************************************************/

/*
Update 22/03/2006 R. Wilcke (wilcke@esrf.fr)
                  Removed check for __CYGWIN__ since __unix is now defined
                  in Cygwin 1.X.
Update 22/02/2006 R. Wilcke (wilcke@esrf.fr)
                  modified code for MacIntosh MACOSX using predefined macro
                  __APPLE__ for this architecture.
Update 19/01/2004 R. Wilcke (wilcke@esrf.fr) 
                  removed declarations of fopen() (is declared in "stdio.h").
Update 26/11/2001 O. Svensson
                  Corrected mispelled comment.
Update 22/09/2001 E. Vlieg (vlieg@sci.kun.nl)
		  Add ALLOW_PLOT flag
Update 05/01/2001 E. Vlieg (vlieg@sci.kun.nl)
	          Replace "keating" by "energy" because of more general 
                  lattice-energy calculations.
Update 10/01/2001 R. Wilcke (wilcke@esrf.fr)
                  main(): to obtain proper "long jump" behaviour in the SIGINT
                  interrupt handler:
                  - declared type of "mainloop" with the macro "JMPBUF_TYPE"
                    instead of type "jmp_buf" (this macro is defined in menu.h);
                  - replaced for __unix and __CYGWIN__ call to setjmp(mainloop)
                    by call to sigsetjmp(mainloop,1).
Update 08/01/2001 E. Vlieg (vlieg@sci.kun.nl)
	          Replace ATOMRADIUS by RADIUS in set.plot menu.
Update 25/10/2000 O. Svensson (svensson@esrf.fr)
                  Added fclose at the end of write_initmac().
Update 19/07/2000 R. Wilcke (wilcke@esrf.fr)
                  define VERSIONSTR using the macro VERSION, if this is defined
                  (e.g. in the Makefile).
Update 26/06/2000 R. Wilcke (wilcke@esrf.fr)
                  replace UNIX by __unix (is defined by CPP on UNIX systems).

*/

/***************************************************************************/
/* include files                                                           */
/***************************************************************************/

#define ROD
#include "rod.h"
#include <lsqfit.h>

#if defined(__BORLANDC__)
unsigned _stklen = 20000;
#endif /* defined(__BORLANDC__) */

#if defined(VERSION)
char VERSIONSTR[] = VERSION " " __DATE__;
#else
#define VERSIONSTR __DATE__
#endif /* defined(VERSION) */

/***************************************************************************/
#ifndef VMS
int main (int argc, char *argv[])
#else
    int main(void)
#endif
/***************************************************************************/

     /* Program to analyze X-ray structure factor data, including bulk
	trunction rods.

     Written by: 	Elias Vlieg

		AT&T Bell Laboratories
		510E Brookhaven National Laboratory
		Upton, NY 11973

     address since October 1, 1990

		FOM-Institute AMOLF
		Kruislaan 407
		1098 SJ Amsterdam
		The Netherlands

     address since January 1, 1998

		RIM, dept. of Solid State Chemistry
		University of Nijmegen
		Toernooiveld 1
		6525 ED Nijmegen
		The Netherlands
		email: vlieg@sci.kun.nl

     */

    {



    /* define main_menu */

    enum idx   
	{
	i_zero,
	i_read,
	i_list,
	i_reset,
	i_calc,
#ifdef ALLOW_PLOT
	i_plot,
#endif
	i_set,
	i_fit,
	i_energy,
#ifdef INCL_REFL
	i_refl,
#endif
	i_macro,
	i_opsys,
	i_help,
	i_return
	};


    static struct MENU main_menu[i_return] =
	{
	"read", 1, i_read, "Read data/model files",
	"list", 1, i_list, "List data/model",
	"reset", 3, i_reset, "Reset all parameters",
	"calculate", 1, i_calc, "Calculate structure factors",
#ifdef ALLOW_PLOT
	"plot", 1, i_plot, "Goto plotting menu",
#endif
	"set", 1, i_set, "Set parameters",
	"fit", 1, i_fit, "Fit experimental structure factors",
	"energy", 1, i_energy, "Goto lattice energy menu",
#ifdef INCL_REFL
	"refl", 3, i_refl, "Goto reflectivity menu",
#endif
	"macro", 1, i_macro, "Run macro file",
	":", 1, i_opsys, "Execute an operating system command",
	"help", 1, i_help, "Display menu",
	"quit", 4, i_return, "Quit program"
	};

    int stop = FALSE, i;
    char token[100];
    float *x, *y, *e;
    int has_crashed = 0;

#ifdef OS2
    extern char GPC_WIN_TITLE[128];
#endif

    /* install crash handler */

#if defined(MSDOS) || defined(__unix) || defined(__APPLE__)
    JMPBUF_TYPE mainloop;
#endif /* defined(MSDOS) || defined(__unix) || defined(__APPLE__) */

    /* process command line options */

#ifndef VMS
    for (i=1; i<argc; i++)
	{
	strcpy(token, argv[i]);
	strlwr(token);
	if (!strcmp(token, "-debug"))	/* debug option on command line */
	    {
	    ROD_DEBUG = TRUE;
	    REFL_DEBUG = TRUE;
	    }
	}
#endif

    /* install crash handler */
    /*
     * Under POSIX, the setjmp() / longjmp() routines are not guaranteed to
     * restore the signal mask, which means that further occurences of signals
     * may be blocked after the first longjmp() call.
     *
     * To restore the signal mask, the sigsetjmp() / siglongjmp() routines
     * should be used under POSIX.
     *
     * For other systems (e.g. MSDOS), the availability of sigsetjmp() /
     * siglongjmp() is not known to us. Keep the old calls for the time being.
     *
     * The buffer used by sigsetjmp() / siglongjmp() has a different variable
     * type than the one for setjmp() / longjmp(). Use the macro JMPBUF_TYPE
     * (defined in menu.h) to have the correct variable type in functin of the
     * operating system.
     */

#if defined(MSDOS) || defined(__unix) || defined(__APPLE__)
#if defined(__unix) || defined(__APPLE__)
    has_crashed = sigsetjmp(mainloop,1);
#else
    has_crashed = setjmp(mainloop);
#endif /* defined(__unix) || defined(__APPLE__) */

    if (!has_crashed) install_exc_handler(mainloop);
    else {/* presumably aborted during fitting */
    //if (LSQ_LOGFILE != stdout && LSQ_LOGFILE != NULL) fclose(LSQ_LOGFILE);
    /* restore saved parameters */
    lsq_breakcontrol(LSQ_BREAK_RESTORE, NULL, NULL, 0);
    }

#endif /* defined(MSDOS) || defined(__unix) || defined(__APPLE__) */

    if (!has_crashed) initialize ();

    while (!stop)
	{
	while (!get_token (token, "ROD>"));
	switch (cmnd_match (token, main_menu, i_return))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case i_read:
		read_type ();
		break;
	    case i_list:
		list ();
		break;
	    case i_reset:
		NTYPES = 0;
		NSURF = 0;
		NSURF2 = 0;
		NBULK = 0;
		NDOMAIN = 1;
		NDISTOT = 0;
		NDWTOT = 0;
		NDWTOT2 = 0;
		NOCCTOT = 0;
		NDAT = 0;
		NTH = 0;
		ZEROFRACT = TRUE;
		for (i = 0; i < MAXPAR; i++)
		    {
		    DISPL[i] = 0.;
		    DEBWAL[i] = 0.;
		    OCCUP[i] = 1.;
		    }
		for (i = 0; i < MAXFIT; i++)
		    {
		    FIXPAR[i] = TRUE;
		    }
		break;
	    case i_calc:
		calculate ();
		break;
#ifdef ALLOW_PLOT
	    case i_plot:
		plot ();
		break;
#endif
	    case i_set:
		set ();
		break;
	    case i_fit:
		fit ();
		break;
	    case i_energy:
		energy ();
		break;
#ifdef INCL_REFL
	    case i_refl:
		Refl();
		break;
#endif
	    case i_macro:
		run_macro ();
		break;
	    case i_opsys:
		opsys ();
		break;
	    case i_help:
		list_menu ("MAIN MENU", main_menu, i_return);
		break;
	    case i_return:
		stop = TRUE;
	    }
	}


    /* Save parameters */

    write_initmac ();
#ifdef ALLOW_PLOT
    put_command ("save");
    plotxye (x, y, e, 1);
#ifdef PGPLOT
    put_command("close");
    plotxye(x, y, e, 1);
#endif
#endif
    end_menu();
    return (1);
    }


/***************************************************************************/
char * get_init_fname (void)
/***************************************************************************/

     /* Get name of initialization file This will try to read the environment
        variable ROD_INIT If this fails, it will result to the default */


    {
    static char DEF_INIT_FNAME[]= "rod_init.mac";	/* Default init file */
    char *envname;


    if ((envname = getenv ("ROD_INIT")) == NULL)
	{
	return (DEF_INIT_FNAME);
	}
    else
	{
	return (envname);
	}
    }

/***************************************************************************/
void initialize (void)
/***************************************************************************/

     /* Initialize some global parameters. */

    {

    float *x, *y, *e;
    int i;


    /* Some initialization */

    init_menu();
    set_scroll(1,ROWS);
    clear_screen();
    ROD_DEBUG = REFL_DEBUG = FALSE;
#ifdef  OS2
    strcpy(GPC_WIN_TITLE, "ROD");
#endif

    /* come up with user greetings */

    sprintf (STRING,
	     "*** Structure analysis program, version %s ***\n", VERSIONSTR);
    type_line (STRING);
#ifdef SMALL
    sprintf (STRING, "+++ Special small version +++\n");
    type_line (STRING);
#endif

    /* Reset some global parameters */

    STRUCFAC = TRUE;
    ROUGHMODEL = APPROXBETA;
    NTYPES = 0;
    NSURF = 0;
    NSURF2 = 0;
    SURFFRAC = 1;
    SURF2FRAC = 0;
    LBRAGG = 0;
    NLAYERS = 1;
    NBULK = 0;
    NDOMAIN = 1;
    NDISTOT = 0;
    NDWTOT = 0;
    NDWTOT2 = 0;
    NOCCTOT = 0;
    SCALE = 1;
    SCALE2 = 1;
    NDAT = 0;
    NTH = 0;
    ATTEN = 0.001;
    LSTART = -3.9;
    LEND = 3.9;
    NL = 200;
    COHERENTDOMAINS = FALSE;
    KEAT_PLUS_CHI = FALSE;
    POTENTIAL = VKEATING;

    for (i = 0; i < MAXDOM; i++)
	{
	DOMMAT11[i] = 1.;
	DOMMAT12[i] = 0.;
	DOMMAT21[i] = 0.;
	DOMMAT22[i] = 1.;
	}
    DOMOCCUP[0] = 1.;
    ZEROFRACT = TRUE;
    DOMEQUAL = TRUE;
    for (i = 0; i < MAXTYPES; i++)
	ATRAD[i] = 0.1;
    FSIZE = 0.05;
//  sprintf(PATFILENAME,"pat");

    /* Initialize plotting parameters */

/*  put_command("debug"); */
#ifdef ALLOW_PLOT
    put_command ("init");
    plotxye (x, y, e, 1);
#endif

    /* Initialize global parameters */


    sprintf (STRING, "macro %s", INITFILE);
    put_command (STRING);

    /* Set all occupancy parameters to 1 and fix all fit parameters */

    for (i = 0; i < MAXPAR; i++)
	{
	OCCUP[i] = 1;
	}
    for (i = 0; i < MAXFIT; i++)
	{
	FIXPAR[i] = TRUE;
	}

    }

/***************************************************************************/
void write_initmac (void)
/***************************************************************************/

     /* Write current values of parameters to macro file which can be used
	for initialization. */

    {

    FILE *init_mac;
    char *item;
    int i;

    /* Open macro file */

    if ((init_mac = fopen (INITFILE, "w+")) == NULL)
	{
	sprintf (STRING, "Failed to open %s file", INITFILE);
	errtype (STRING);
	clear_command ();
	return;
	}

    /* Save parameters for rod calculation */

    fprintf (init_mac, "!Go to set calculate menu\n");
    fprintf (init_mac, "set calculate\n");
    fprintf (init_mac, "structure %s\n", yesnostr (STRUCFAC));
    fprintf (init_mac, "lstart %10.4f\n", LSTART);
    fprintf (init_mac, "lend %10.4f\n", LEND);
    fprintf (init_mac, "npoints %4d\n", NL);
    fprintf (init_mac, "atten %10.6f\n", ATTEN);
    fprintf (init_mac, "beta %10.6f\n", BETA);
    fprintf (init_mac, "lbragg %10.6f\n", LBRAGG);
    fprintf (init_mac, "nlayers %1d\n", NLAYERS);
    fprintf (init_mac, "scale %10.6f\n", SCALE);
    fprintf (init_mac, "scale2 %10.6f\n", SCALE2);
    fprintf (init_mac, "sfraction %10.6f\n", SURFFRAC);

    switch (ROUGHMODEL)
	{
	case APPROXBETA:
	    item = "approx";
	    break;
	case EXACTBETA:
	    item = "exact";
	    break;
	case POISSONROUGH:
	    item = "poisson";
	    break;
	case NUMBETA:
	    item = "beta";
	    break;
	case GAUSSROUGH:
	    item = "gaussian";
	    break;
	case LINEARROUGH:
	    item = "linear";
	    break;
	case COSINEROUGH:
	    item = "cosine";
	    break;
	case TWOLEVEL:
	    item = "twolevel";
	    break;
	}
    fprintf (init_mac, "rough %s\n", item);
    fprintf (init_mac, "return return\n");

    /* Save space group */

    fprintf (init_mac, "!Go to set symmetry menu\n");
    fprintf (init_mac, "set symmetry %s return return\n", PLANEGROUP);

    /* Save matrices for multi-domain structure calculation */

    fprintf (init_mac, "!Go to set domain menu\n");
    fprintf (init_mac, "set domain\n");
    fprintf (init_mac, "ndomain %1d\n", NDOMAIN);
    for (i = 0; i < NDOMAIN; i++)
	{
	fprintf (init_mac, "matrix %1d %8.4f %8.4f %8.4f %8.4f\n",
		 i + 1, DOMMAT11[i], DOMMAT12[i], DOMMAT21[i], DOMMAT22[i]);
	}
    fprintf (init_mac, "fractional %s\n", yesnostr (ZEROFRACT));
    fprintf (init_mac, "equal %s\n", yesnostr (DOMEQUAL));
    if (!DOMEQUAL)
	for (i = 0; i < NDOMAIN; i++)
	    {
	    fprintf (init_mac, "occup %1d %7.4f\n", i + 1, DOMOCCUP[i]);
	    }
    fprintf (init_mac,"coherent %s\n", yesnostr(COHERENTDOMAINS));
    fprintf (init_mac, "return return\n");

    /* Save setting of fit model */

    fprintf (init_mac, "!Go to set fit menu\n");
    if (FULLMODEL)
	fprintf (init_mac, "set fit fullmodel yes return return\n");
    else
	fprintf (init_mac, "set fit fullmodel no return return\n");

    /* Save parameters for plotting */

#ifdef ALLOW_PLOT
    fprintf (init_mac, "!Go to set plot menu\n");
    fprintf (init_mac, "set plot\n");
    fprintf (init_mac, "size %7.4f\n", FSIZE);
    fprintf (init_mac, "threshold %7.4f\n", FTHRESHOLD);
    for (i = 0; i < NTYPES; i++)
	fprintf (init_mac, "radius %1d %5.3f\n", i + 1, ATRAD[i]);
    fprintf (init_mac, "xmincon %7.4f\n", XMINCON);
    fprintf (init_mac, "xmaxcon %7.4f\n", XMAXCON);
    fprintf (init_mac, "nxcon %1d\n", NXCON);
    fprintf (init_mac, "ymincon %7.4f\n", YMINCON);
    fprintf (init_mac, "ymaxcon %7.4f\n", YMAXCON);
    fprintf (init_mac, "nycon %1d\n", NYCON);
    fprintf (init_mac, "minlevel %7.4f\n", MINCON);
    fprintf (init_mac, "maxlevel %7.4f\n", MAXCON);
    fprintf (init_mac, "nlevel %1d\n", NLEVEL);
//  fprintf (init_mac, "file %s\n", PATFILENAME);
    fprintf (init_mac, "return return\n");
#endif

    /* Save parameters for Keating */

    fprintf (init_mac, "!Go to lattice energy menu\n");
    fprintf (init_mac, "energy\n");
    if (POTENTIAL == VKEATING) fprintf (init_mac, "keating\n");
    if (POTENTIAL == VLENNARDJONES) fprintf (init_mac, "lennard\n");
//  fprintf (init_mac, "chisqr %s\n",yesnostr(KEAT_PLUS_CHI));
    fprintf (init_mac, "alpha %7.4f\n", ALPHA_KEAT);
    fprintf (init_mac, "beta %7.4f\n", BETA_KEAT);
    fprintf (init_mac, "equangle %7.4f\n",EQU_ANGLE*RAD);
    for (i = 0; i < NTYPES; i++)
	{
	fprintf (init_mac, "radius %1d %8.5f\n", i + 1, ATOM_RAD[i]);
	}
    fprintf (init_mac, "return\n");

    fclose (init_mac);
    }
