/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                         list.c                                $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: list.c,v 1.6 2004/01/19 16:55:25 wilcke Exp $

****************************************************************************/

/*
Update 19/01/2004 R. Wilcke (wilcke@esrf.fr) 
                  removed declarations of fopen() (is declared in "stdio.h").
Update 15/08/2003 E. Vlieg (vlieg@sci.kun.nl)
		  Add list of z-projected electron density.
Update 05/07/2001 E. Vlieg (vlieg@sci.kun.nl)
                  Changed menus to follow Rainer's scheme.
Update 19/07/2000 R. Wilcke (wilcke@esrf.fr)
                  replaced everywhere the buffer size for filenames by
                  the ISO-C defined macro FILENAME_MAX.

*/

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#include "rod.h"

/***************************************************************************/
void    list(void)
/***************************************************************************/

    /*
    List data/model etc. on terminal or file.
    */

    {

    /* define llistmenu */

#define llistlength 15      /* number of commands in list menu */

    static struct   MENU llistmenu[llistlength] =
	{
	"bulk",     1,  1,  "Bulk contribution",
	"surface",  3,  2,  "Surface contribution",
	"sum",      1,  3,  "Interference sum of bulk and surface",
	"all",      1,  4,  "Above three values",
	"data",     1,  5,  "Structure factor data",
	"smodel",   2,  6,  "Surface model",
	"bmodel",   2,  7,  "Bulk model",
	"fit",      1,  8,  "Fitting model for surface structure",
	"compare",  1,  9,  "Comparison between data and theory",
	"parameters",2, 10, "Values of fit parameters",
	"symmetry", 2,  11, "Symmetry-equivalent reflections of data",
	"bonds",    2,  12, "Bond lengths of surface structure",
	"zdensity", 1,  13, "Z-proj. electron density (plot first!)",
	"help",     1,  20, "Display menu",
	"return",   1,  21, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];
    int     switch_code,i,j;
    FILE    *listfile;
    int     terminal;
    char    filename[FILENAME_MAX],extension[10];
    float   b1,b2,distance,mindist,dx,dy,dz;

    while (!stop)
	{
	if (!get_token(token,"ROD.LIST>")) return;
	switch_code = cmnd_match(token,llistmenu,llistlength);
	switch (switch_code)
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		stop = TRUE;
		sprintf(extension,"dat");
		break;
	    case 2:
		stop = TRUE;
		sprintf(extension,"dat");
		break;
	    case 3:
		stop = TRUE;
		sprintf(extension,"dat");
		break;
	    case 4:
		stop = TRUE;
		sprintf(extension,"dat");
		break;
	    case 5:
		stop = TRUE;
		sprintf(extension,"dat");
		break;
	    case 6:
		stop = TRUE;
		sprintf(extension,"sur");
		break;
	    case 7:
		stop = TRUE;
		sprintf(extension,"bul");
		break;
	    case 8:
		stop = TRUE;
		sprintf(extension,"fit");
		break;
	    case 9:
		stop = TRUE;
		sprintf(extension,"lis");
		break;
	    case 10:
		stop = TRUE;
		sprintf(extension,"par");
		break;
	    case 11:
		stop = TRUE;
		sprintf(extension,"lis");
		break;
	    case 12:
		stop = TRUE;
		sprintf(extension,"lis");
		break;
	    case 13:
		stop = TRUE;
		sprintf(extension,"lis");
		break;
	    case 20:
		list_menu("LIST MENU",llistmenu,llistlength);
		break;
	    case 21:
		return;
	    }
	}

    /* Ask for filename */

    sprintf(STRING,"Filename (.%s) (type 't' or <return> for terminal): ",
	    extension);
    if (!get_token(filename,STRING))
	{
	terminal = TRUE;
	}
    else if (((filename[0] == 't') || (filename[0] == 'T')) &&
	     (filename[1] == '\0'))
	{
	terminal = TRUE;
	}
    else
	{
	terminal = FALSE;
	add_extension(filename,extension);
	if ((listfile = fopen(filename,"w")) == NULL)
	    {
	    sprintf(STRING,"Error, failed to open '%s'",filename);
	    errtype(STRING);
	    clear_command();
	    return;
	    }
	else
	    {
	    get_string(STRING,"Comments: ");
	    if (switch_code != 10) fprintf(listfile,"%s\n",STRING);
	    else fprintf(listfile,"!%s\n",STRING);
	    }
	}

    /* Do the actual listing */

    if (terminal) type_list(STRING,0);
    switch (switch_code)
	{
	case 1:
	    if (terminal)
		{
		sprintf(STRING,"%6s %6s %6s %11s\n","h","k","l","f-bulk");
		type_list(STRING,ROWS);
		}
	    for (i = 0; i < NTH; i++)
		{
		sprintf(STRING,"%6.3f %6.3f %6.3f %11.5f\n",
			HTH[i],KTH[i],LTH[i],FTH[0][i]);
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}
	    break;
	case 2:
	    if (terminal)
		{
		sprintf(STRING,"%6s %6s %6s %11s\n","h","k","l","f-surf");
		type_list(STRING,ROWS);
		}
	    for (i = 0; i < NTH; i++)
		{
		sprintf(STRING,"%6.3f %6.3f %6.3f %11.5f\n",
			HTH[i],KTH[i],LTH[i],FTH[1][i]);
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}
	    break;
	case 3:
	    if (terminal)
		{
		sprintf(STRING,"%6s %6s %6s %11s %8s\n",
			"h","k","l","f-sum","phase");
		type_list(STRING,ROWS);
		}
	    for (i = 0; i < NTH; i++)
		{
		sprintf(STRING,"%6.3f %6.3f %6.3f %11.5f %8.2f\n",
			HTH[i],KTH[i],LTH[i],FTH[2][i],PHASE[i]*RAD);
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}
	    break;
	case 4:
	    if (terminal)
		{
		sprintf(STRING,"%6s %6s %6s %11s %11s %11s %8s\n",
			"h","k","l","f-bulk","f-surf","f-sum","phase");
		type_list(STRING,ROWS);
		}
	    for (i = 0; i < NTH; i++)
		{
		sprintf(STRING,"%6.3f %6.3f %6.3f %11.5f %11.5f %11.5f %8.2f\n",
			HTH[i],KTH[i],LTH[i],FTH[0][i],FTH[1][i],FTH[2][i],
			PHASE[i]*RAD);
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}
	    break;
	case 5:
	    if (terminal)
		{
		sprintf(STRING,"%6s %6s %6s %11s %11s %3s\n",
			"h","k","l","f-dat","sigma","lbr");
		type_list(STRING,ROWS);
		}
	    for (i = 0; i < NDAT; i++)
		{
		sprintf(STRING,"%6.3f %6.3f %6.3f %11.5f %11.5f %3.0f\n",
			HDAT[i],KDAT[i],LDAT[i],FDAT[i],ERRDAT[i],LBR[i]);
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}
	    break;
	case 6:
	    sprintf(STRING,
		    " %6.4f %6.4f %6.4f %5.1f %5.1f %5.1f\n",
		    DLAT[0],DLAT[1],DLAT[2],DLAT[3]*RAD,DLAT[4]*RAD,DLAT[5]*RAD);
	    if (terminal)
		{
		type_line("Lattice parameters: ");
		type_list(STRING,ROWS);
		}
	    else
		{
		fprintf(listfile,"%s",STRING);
		}
	    for (i = 0; i < NSURF; i++)
		{
		if (NDWS[i] == 0)
		    b1 = 0.;
		else
		    b1 = DEBWAL[NDWS[i]-1];
		if (NDWS2[i] == 0)
		    b2 = b1;
		else
		    b2 = DEBWAL2[NDWS2[i]-1];
		sprintf(STRING,"%2s %11.5f %11.5f %11.5f %3d %4.2f %4.2f\n",
			ELEMENT[TS[i]],XSFIT[i],YSFIT[i],ZSFIT[i],
			NDWS[i],b1,b2);
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}
	    if (NSURF2 != 0)
		{
		if (terminal) type_line("\n");
		else fprintf(listfile,"\n");
		}
	    for (i = NSURF; i < NSURF+NSURF2; i++)
		{
		if (NDWS[i] == 0)
		    b1 = 0.;
		else
		    b1 = DEBWAL[NDWS[i]-1];
		if (NDWS2[i] == 0)
		    b2 = b1;
		else
		    b2 = DEBWAL2[NDWS2[i]-1];
		sprintf(STRING,"%2s %11.5f %11.5f %11.5f %3d %4.2f %4.2f\n",
			ELEMENT[TS[i]],XSFIT[i],YSFIT[i],ZSFIT[i],
			NDWS[i],b1,b2);
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}
	    break;
	case 7:
	    sprintf(STRING,
		    " %6.4f %6.4f %6.4f %5.1f %5.1f %5.1f\n",
		    DLAT[0],DLAT[1],DLAT[2],DLAT[3]*RAD,DLAT[4]*RAD,DLAT[5]*RAD);
	    if (terminal)
		{
		type_line("Lattice parameters: ");
		type_list(STRING,ROWS);
		}
	    else
		{
		fprintf(listfile,"%s",STRING);
		}
	    for (i = 0; i < NBULK; i++)
		{
		if (NDWB[i] == 0)
		    b1 = 0.;
		else
		    b1 = DEBWAL[NDWB[i]-1];
		sprintf(STRING,"%2s %12.8f %12.8f %12.8f %3d %4.2f\n",
			ELEMENT[TB[i]],XB[i],YB[i],ZB[i],NDWB[i],b1);
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}
	    break;
	case 8:
	    sprintf(STRING,
		    " %6.4f %6.4f %6.4f %7.3f %7.3f %7.3f\n",
		    DLAT[0],DLAT[1],DLAT[2],DLAT[3]*RAD,DLAT[4]*RAD,DLAT[5]*RAD);
	    if (terminal)
		{
		type_line("Lattice parameters: ");
		type_list(STRING,ROWS);
		}
	    else
		{
		fprintf(listfile,"%s",STRING);
		}
	    for (i = 0; i < NSURF; i++)
		{
		sprintf(STRING,
			"%2s %8.5f %7.4f %2d %7.4f %2d %8.5f %7.4f %2d %7.4f %2d %8.5f %1d %1d %1d %1d\n",
			ELEMENT[TS[i]],
			XS[i],XCONST[i],NXDIS[i],X2CONST[i],NX2DIS[i],
			YS[i],YCONST[i],NYDIS[i],Y2CONST[i],NY2DIS[i],
			ZS[i],NZDIS[i],NDWS[i],NDWS2[i],NOCCUP[i]);
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}
	    break;
	case 9:
	    if (NDAT != NTH)
		{
		errtype("No computation done with current data points");
		break;
		}
	    if (terminal)
		{
		sprintf(STRING,"%6s %6s %6s %11s %11s %11s %7s\n",
			"h","k","l","f-th","f-dat","sigma","chi_sqr");
		type_list(STRING,ROWS);
		}
	    for (i = 0; i < NDAT; i++)
		{
		sprintf(STRING,
			"%6.3f %6.3f %6.3f %11.5f %11.5f %11.5f %7.2f\n",
			HDAT[i],KDAT[i],LDAT[i],FTH[2][i],FDAT[i],ERRDAT[i],
			sqr((FTH[2][i]-FDAT[i])/(ERRDAT[i]+1e-10)));
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}
	    break;
	case 10:

	    if (!terminal)
		{
		fprintf(listfile,"!Goto set parameter menu\n");
		fprintf(listfile,"set par\n");
		}

	    sprintf(STRING,"scale       %8.4f  %8.4f  %8.4f  %s\n"
		    ,SCALE,SCALELIM[0],SCALELIM[1],yesnostr(SCALEPEN));
	    if (terminal) type_list(STRING,ROWS);
	    else fprintf(listfile,"%s",STRING);

	    sprintf(STRING,"scale2      %8.4f  %8.4f  %8.4f  %s\n"
		    ,SCALE2,SCALE2LIM[0],SCALE2LIM[1],yesnostr(SCALE2PEN));
	    if (terminal) type_list(STRING,ROWS);
	    else fprintf(listfile,"%s",STRING);

	    sprintf(STRING,"beta        %8.4f  %8.4f  %8.4f  %s\n"
		    ,BETA,BETALIM[0],BETALIM[1],yesnostr(BETAPEN));
	    if (terminal) type_list(STRING,ROWS);
	    else fprintf(listfile,"%s",STRING);

	    sprintf(STRING,"surffrac    %8.4f  %8.4f  %8.4f  %s\n"
		    ,SURFFRAC,SURFFRACLIM[0],SURFFRACLIM[1],
		    yesnostr(SURFFRACPEN));
	    if (terminal) type_list(STRING,ROWS);
	    else fprintf(listfile,"%s",STRING);

	    for (i = 0; i < NDISTOT; i++)
		{
		sprintf(STRING,"displace  %1d %8.4f  %8.4f  %8.4f  %s\n"
			,i+1,DISPL[i],DISPLLIM[i][0],DISPLLIM[i][1],
			yesnostr(DISPLPEN[i]));
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}

	    for (i = 0; i < NDWTOT; i++)
		{
		sprintf(STRING,"b1        %1d %8.4f  %8.4f  %8.4f  %s\n"
			,i+1,DEBWAL[i],DEBWALLIM[i][0],DEBWALLIM[i][1],
			yesnostr(DEBWALPEN[i]));
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}

	    for (i = 0; i < NDWTOT2; i++)
		{
		sprintf(STRING,"b2        %1d %8.4f  %8.4f  %8.4f  %s\n"
			,i+1,DEBWAL2[i],DEBWAL2LIM[i][0],DEBWAL2LIM[i][1],
			yesnostr(DEBWAL2PEN[i]));
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}

	    for (i = 0; i < NOCCTOT; i++)
		{
		sprintf(STRING,"occupancy %1d %8.4f  %8.4f  %8.4f  %s\n"
			,i+1,OCCUP[i],OCCUPLIM[i][0],OCCUPLIM[i][1],
			yesnostr(OCCUPPEN[i]));
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}

	    if (!terminal) fprintf(listfile,"return return");

	    break;
	case 11:
	    if (NTRANS == 0)
		{
		errtype("No symmetry group set");
		return;
		}
	    if (NDAT == 0)
		{
		errtype("No data read in");
		return;
		}

	    /* Generate the equivalent reflections */

	    make_symmetry_set(1);

	    if (terminal)
		{
		sprintf(STRING,"%6s %6s %6s %9s %9s\n",
			"h","k","l","f-dat","sigma");
		type_list(STRING,ROWS);
		}
	    for (i = 0; i < NDAT; i++)
		{
		sprintf(STRING,"%8.5f %8.5f %8.5f %11.5f %11.5f\n",
			HDAT[i],KDAT[i],LDAT[i],FDAT[i],ERRDAT[i]);
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		for (j = 1; j < SYMSET[i].N; j++)
		    {
		    sprintf(STRING,"(%1d,%1d) ",SYMSET[i].H[j],
			    SYMSET[i].K[j]);
		    if (terminal) type_list(STRING,ROWS);
		    else fprintf(listfile,"%s",STRING);
		    }
		sprintf(STRING,"\n");
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}
	    break;
	case 12:
	    if (NSURF < 2)
		{
		errtype("Too few atoms in surface model");
		clear_command();
		break;
		}
	    mindist = get_real(3,"Minimum distance in list [3]: ");

	    /* print header */

	    sprintf(STRING,"%3s %4s %3s %4s %11s\n","#","elem","#","elem",
		    "distance");
	    if (terminal)
		type_list(STRING,ROWS);
	    else
		fprintf(listfile,"%s",STRING);

	    /* calculate and list all distances */

	    for (i = 0; i < NSURF-1; i++)
		{
		for (j = i+1; j < NSURF; j++)
		    {
		    distance = dist_calc(i,j,&dx,&dy,&dz);
		    if (distance < mindist)
			{
			sprintf(STRING,"%3d %4s %3d %4s %6.3f\n",i+1,
				ELEMENT[TS[i]],j+1,ELEMENT[TS[j]],distance);
			if (terminal)
			    type_list(STRING,ROWS);
			else
			    fprintf(listfile,"%s",STRING);
			}
		    }
		}

	    break;
	case 13:
	    if (terminal)
		{
		sprintf(STRING,"%7s %11s\n","z","density");
		type_list(STRING,ROWS);
		}
	    for (i = 0; i < NDENS; i++)
		{
		sprintf(STRING,"%7.3f %11.3f\n",
			ZDENS[i],DENS[i]);
		if (terminal) type_list(STRING,ROWS);
		else fprintf(listfile,"%s",STRING);
		}
	    break;
	}

    if (!terminal) fclose(listfile);

    }

