/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                         ave.c                                 $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: ave.c,v 1.13 2006/03/28 15:34:33 wilcke Exp $

****************************************************************************/

/*

Update 22/03/2006 R. Wilcke (wilcke@esrf.fr)
                  removed check for __CYGWIN__ since __unix is now defined
                  in Cygwin 1.X.
Update 05/07/2001 E. Vlieg (vlieg@sci.kun.nl)
                  Changed menus to follow Rainer's scheme.
Update 10/01/2001 R. Wilcke (wilcke@esrf.fr)
                  main(): to obtain proper "long jump" behaviour in the SIGINT
                  interrupt handler:
                  - declared type of "mainloop" with the macro "JMPBUF_TYPE"
                    instead of type "jmp_buf" (this macro is defined in menu.h);
                  - replaced for __unix and __CYGWIN__ call to setjmp(mainloop)
                    by call to sigsetjmp(mainloop,1).
Update 21/12/2000 E. Vlieg (vlieg@sci.kun.nl)
                  Introduced new menu item "sweight".
Update 19/07/2000 R. Wilcke (wilcke@esrf.fr)
                  define VERSIONSTR using the macro VERSION, if this is defined
                  (e.g. in the Makefile).
Update 26/06/2000 R. Wilcke (wilcke@esrf.fr)
                  remove the #ifdef SCROLL around the set_scroll() calls, the
                  required action will be taken in set_scroll() itself;
                  replace UNIX by __unix (is defined by CPP on UNIX systems).

*/

/***************************************************************************/

#if defined(VERSION)
char VERSIONSTR[] = VERSION " " __DATE__;
#else
#define VERSIONSTR __DATE__
#endif /* defined(VERSION) */

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#define EXT
#include "ave.h"
#undef EXT

/***************************************************************************/
int    main(void)
/***************************************************************************/

    /*
    Program to average and weight X-ray structure factor data

    Written by: Elias Vlieg
		AT&T Bell Laboratories
		510E Brookhaven National Laboratory
		Upton, NY 11973

    present address (since 01 Jan 1998)

	Department of Solid State Chemistry
	University of Nijmegen
	Toernooiveld 1
	6525 ED Nijmegen
	The Netherlands
	email: vlieg@sci.kun.nl
    */

    {

    /* define main_menu */

#define main_length 13      /* number of commands in main menu */

    static struct   MENU main_menu[main_length] =
	{
	"set",      1,  1,  "Set parameters",
	"read",     1,  2,  "Read in new data",
	"readmore", 5,  3,  "Read additional data",
	"manipulate",3, 4,  "Manipulate data",
	"average",  1,  5,  "Do the averaging",
	"weight",   1,  6,  "Make file with weighted data",
	"sweight",  2,  61, "Same as weight, plus scan #'s",
	"rodfile",  2,  7,  "Make separate file for each rod",
	"inplane",  1,  8,  "Make file with inplane data",
	"macro",    1,  10, "Run macro file",
	":",        1,  11, "Execute an operating system command",
	"help",     1,  20, "Display menu",
	"quit",     4,  21, "Quit program"
	};

    int     stop = FALSE,i;
    char    token[100];
    int	    has_crashed,weight_done=FALSE;

    /*
     * Under POSIX, the setjmp() / longjmp() routines are not guaranteed to
     * restore the signal mask, which means that further occurences of signals
     * may be blocked after the first longjmp() call.
     *
     * To restore the signal mask, the sigsetjmp() / siglongjmp() routines
     * should be used under POSIX.
     *
     * For other systems (e.g. MSDOS), the availability of sigsetjmp() /
     * siglongjmp() is not known to us. Keep the old calls for the time being.
     *
     * The buffer used by sigsetjmp() / siglongjmp() has a different variable
     * type than the one for setjmp() / longjmp(). Use the macro JMPBUF_TYPE
     * (defined in menu.h) to have the correct variable type in functin of the
     * operating system.
     */
#if defined(MSDOS) || defined(__unix)
    JMPBUF_TYPE mainloop;
#if defined(__unix)
    has_crashed = sigsetjmp(mainloop,1);
#else
    has_crashed = setjmp(mainloop);
#endif /* defined(__unix) */
    if(!has_crashed) install_exc_handler(mainloop);
#endif /* defined(MSDOS) || defined(__unix) */


    if (!has_crashed) initialize();

    while (!stop)
	{
	while (!get_token(token,"AVE>"));
	switch (cmnd_match(token,main_menu,main_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		set();
		break;
	    case 2:
		NIN = 0;
		read_f();
		break;
	    case 3:
		read_f();
		break;
	    case 4:
		manipulate();
		break;
	    case 5:
		average();
		break;
	    case 6:
		list_weight(WEIGHTNORMAL);
		weight_done = TRUE;
		break;
	    case 61:
		list_weight(WEIGHTSPECIAL);
		weight_done = TRUE;
		break;
	    case 7:
		if (weight_done)
		    list_rods();
		else
		    errtype("ERROR, do a weight first");
		break;
	    case 8:
		if (weight_done)
		    list_inplane();
		else
		    errtype("ERROR, do a weight first");
		break;
	    case 10:
		run_macro();
		break;
	    case 11:
		opsys();
		break;
	    case 20:
		list_menu("MAIN MENU",main_menu,main_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    end_menu();
    }

/***************************************************************************/
void    initialize(void)
/***************************************************************************/

    /*
    Initialize global parameters
    */

    {

    int i;

    init_menu();
    set_scroll(1,ROWS);
    clear_screen();
    sprintf(STRING, "Structure averaging program, version %s\n", VERSIONSTR);
    type_line(STRING);

    SIG2MODE = 0;
    EPSCUTOFF = 2;
    EPSILON = 0;
    LMULT = 1;
    EQUMIN = 100;
    LIST_LBRAGG = FALSE;
    NOINTL = TRUE;
    FRIEDEL = TRUE;

    NHEADER = 0;
    IDCOL = 1;
    HCOL = 2;
    KCOL = 3;
    LCOL = 4;
    FCOL = 5;
    SIGCOL = 6;

    }


