/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$$$$$$                   rod.h                             $$$$$$$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: rod.h,v 1.14 2006/03/28 15:56:36 wilcke Exp $

****************************************************************************/

/****************************************************************************

  Changes:

Update 22/03/2006 R. Wilcke (wilcke@esrf.fr)
                  modified code for MacIntosh MACOSX using predefined macro
                  __APPLE__ for this architecture.
Update 21/02/2002 O. Svensson (svensson@esrf.fr)
                  Ported changes from standard version: 
                    Prepare for adaptive simulated annealing code (ASA)
                    Change function calls for generation of PLOT3D output file.
                    Add generation of MSI output file.
                    Add Lennard-Jones potential for lattice energy.
                    Add POTENTIAL flag for lattice-energy calculation. 
                    Change several function names.
Update 26/11/2001 O. Svensson (svensson@esrf.fr)
                  Changed length of STRING from 100 to INLLEN.
                  Added check for C++ and 'extern "C" ' since
                  "math.h" must be included from C++ for HPUX.
 Update 18/01/2001 M.C. Saint Lager (stlager@polycnrs-gre.fr)
 			 2 new function in fit.c
 			 - init_fit() where the arrays for fitting
 			 	are initialized and return the total number of fit parameter 'ntot' to fit()
 			 -update_par() to copy  the values 'FITPAR' array
 			 	to corresponding model parameters
Update 25/10/2000 O. Svensson (svensson@esrf.fr)
                  Added "#ifndef _ROD_H_" etc.
Update 26/06/2000 R. Wilcke (wilcke@esrf.fr)
                  replace UNIX by __unix and CYGWIN by __CYGWIN__ (those are
                  defined by CPP on the corresponding systems).
Update 07/07/2000 R. Wilcke (wilcke@esrf.fr)
                  define EXTENSIONS only if it is not yet defined.

  21/10/91: Limits + penalties for fit parameters introduced
  11/11/91: Penalty factors now logicals (0 or 1)
  25/3/92 : SPEEDUP option again implemented
  2/4/92  : Allow either structure factor or intensity fitting
  15/9/92 : Add Keating-energy minimization
  15/2/93 : Allow domains that are not of equal occupancy
  JULY 94 : adaptions for OS/2 + GraphiC

****************************************************************************/

#ifndef _ROD_H_
#define _ROD_H_

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#include <math.h>

#ifdef __cplusplus
extern "C" {
#endif

#include <platform.h>
#include <stdio.h>
#include <float.h>
#include <string.h>
#include <stdlib.h>
#if defined(__unix)
#include <malloc.h>
#include <menu.h>
#include <PGmyplot.h>
#endif
#if defined(__APPLE__)
#include <menu.h>
#include <PGmyplot.h>
#endif
#ifdef MSDOS
#include <alloc.h>
#include <menu.h>
#include <myplot.h>
#endif
#ifdef OS2
#include <alloc.h>
#include <menu.h>
#include <myplot.h>
#endif
#ifdef VMS
#include "menu.h"
#include "myeg.h"
#endif

/***************************************************************************/
/*      Flags:                                                             */
/***************************************************************************/

/* include SVENSSON and ROBACH modifications */

#if !defined(EXTENSIONS)
#define EXTENSIONS
#endif /* !defined(EXTENSIONS) */

/* Speed up fitting at the cost of a somewhat large programme (~30 kbyte) */
#define SPEEDUP

//#define SMALL 	/* make low-memory version */

//#define ASA   /* include adaptive simulated annealing option */

//#define INCL_REFL       /* include reflectivity module (hasn't worked */
			  /* yet using MSDOS */

/* The following flag is needed in order to have access to
   subroutines written in C from C++ subroutines */

#ifdef __cplusplus
#define LFLAGS extern "C"
#else
#define LFLAGS
#endif

/***************************************************************************/
/*      global parameters                                                  */
/***************************************************************************/

/*
   the following defines are intended to distribute all the
   global stuff over the different modules, thereby preventing
   some of the typical MSDOS memory problems
*/

#ifndef ROD
#define ROD  	extern
#endif

#ifndef CALC
#define CALC	extern
#endif

#ifndef FIT
#define FIT	extern
#endif

#ifndef SET
#define SET     extern
#endif

#ifndef PLOT
#define PLOT	extern
#endif

#ifndef KEATING
#define KEATING	extern
#endif

/*
Throughout the program, all arrays start with index 0, thus following the
C-language convention. However, several arrays contain the serial numbers
of parameters. These serial numbers always start with 1. This means that
when getting a value of a parameter, one should subtract 1 from its serial
number.
*/

#define INLLEN          512             /* Length of buffer line */
#define INITFILE 	get_init_fname()

#define PI              3.1415926536
#define RAD             57.29578
#define PIPI16          157.91367       /* 16*PI*PI, used in Debye-Waller */

#ifdef SMALL

#define MAXTYPES        4               /* Maximum number of element types */
#define MAXATOMS        70              /* Maximum number of atoms in model */
#define MAXDATA         200             /* Maximum number of data points */
#define MAXTHEO		200		/* Maximum number of theor. data points */
#define MAXPAR          25              /* Maximum number of theoretical
					parameters */
#define MAXFIT          40              /* Maximum number of fit parameters */

#else

#define MAXTYPES        14//50          /* Maximum number of element types */
#define MAXATOMS        1000            /* Maximum number of atoms in model */
#define MAXDATA         3000//5000      /* Maximum number of data points */
#define MAXTHEO		3000//5000	/* Maximum number of theor. data points */
#define MAXPAR          300             /* Maximum number of theoretical
					//parameters of given type */
#define MAXFIT          500             /* Maximum total number of fit parameters */

#endif

#define TITLE_LENGTH    20              /* Length of fit parameter titles */
#define MAXDOM          8               /* Maximum number of rotational
					domains of reconstructed surface */
#define MAXEQU          12              /* Maximum # of symmetry-equivalent
					reflections */
#define MAXBOND		14		/* Maximum number of bonds of atom */
#define MAXANGLE	10		/* Maximum number of bond angles */
#define NSF             4               /* Number of 'single' fitting parame-
					ters: SCALE, SCALE2, BETA and
					SURFFRAC */


/* parameters describing the model */

/* general parameters */

SET float   DLAT[6];            /* Direct lattice parameters */
SET float   RLAT[6];            /* Reciprocal lattice parameters */
SET int     NTYPES;             /* Number of different atom types in model */
SET char    ELEMENT[MAXTYPES][3];   /* Element symbol of the different atoms
				    types */
SET float   F_COEFF[MAXTYPES][9];   /* Coefficients for atomic scattering
				    factor of the atom types used */
SET int	STRUCFAC;		/* Flag denoting whether structure factors
				or intensities are used */
SET int ROUGHMODEL;		/* Flat to denote roughness model used */
#define APPROXBETA      0       /* use approximation for beta roughness */
#define EXACTBETA       1       /* use exact beta roughness */
#define NUMBETA         2       /* use numberical beta model */
#define POISSONROUGH    3       /* use poisson roughness */
#define GAUSSROUGH      4       /* use Gaussian roughness */
#define LINEARROUGH	5	/* use linear decay roughness */
#define COSINEROUGH	6	/* use cosine decay roughness */
#define TWOLEVEL	7	/* use two-level roughness */

/* parameters of the surface atoms */

SET int     TS[MAXATOMS];       /* Type number of surface atom */
SET float   XS[MAXATOMS];       /* Normalized x coordinate of surface atom */
SET float   YS[MAXATOMS];       /* Normalized y coordinate of surface atom */
SET float   ZS[MAXATOMS];       /* Normalized z coordinate of surface atom */
SET int     NDWS[MAXATOMS];     /* Serial number of surface Debye-Waller
								parameter along in-plane direction */
SET int     NDWS2[MAXATOMS];    /* Serial number of surface Debye-Waller
								parameter along perpendicular direction */
SET int     NSURF;              /* Number of atoms in surface unit cell */
SET int     NSURF2;             /* Number of atoms in 2nd surface unit cell */
SET int     NSURFTOT;           /* Total # of surface atoms NSURF+NSURF2 */
SET float   SURFFRAC;           /* Fraction of reconstruced surface */
SET float   SURFFRACLIM[2];	/* Fit limits for surface fraction */
SET int	    SURFFRACPEN;	/* Penalty factor for surface fraction */
SET float   SURF2FRAC;          /* Fraction of reconstructed surface occupied
				by 2-nd surface unit cell */

/* parameters of the bulk atoms */

SET int     TB[MAXATOMS];       /* Type number of bulk atom */
SET float   XB[MAXATOMS];       /* Normalized x coordinate of bulk atom */
SET float   YB[MAXATOMS];       /* Normalized y coordinate of bulk atom */
SET float   ZB[MAXATOMS];       /* Normalized z coordinate of bulk atom */
SET int     NDWB[MAXATOMS];     /* Serial number of bulk Debye-Waller
				parameter */
SET int     NBULK;              /* Number of atoms in bulk unit cell */
SET int     NLAYERS ;           /* Total number of layers in bulk unit cell
				(used to describe surface roughness) */

/* parameters describing the domain structure of the reconstruced surface
unit cell */

SET int     NDOMAIN;            /* Number of domains */
SET float   DOMMAT11[MAXDOM];   /* Element 11 of domain transform. matrix */
SET float   DOMMAT12[MAXDOM];   /* Element 12 of domain transform. matrix */
SET float   DOMMAT21[MAXDOM];   /* Element 21 of domain transform. matrix */
SET float   DOMMAT22[MAXDOM];   /* Element 22 of domain transform. matrix */
SET int     ZEROFRACT;          /* Flag denoting whether fractional diffraction
				indices (created by the transformation)
				should be given zero weight */
SET int	    DOMEQUAL;		/* Flag denoting whether all domains have
				equal occupation or not */
SET float   DOMOCCUP[MAXDOM];	/* Fractional occupation of each domain */
SET int     COHERENTDOMAINS;    /* Flag denotes whether domains are added
                                coherently or not */

/* fit parameters */

FIT float   XSFIT[MAXATOMS];    /* Fitted x-positions of surface atoms */
FIT float   YSFIT[MAXATOMS];    /* Fitted y-positions of surface atoms */
FIT float   ZSFIT[MAXATOMS];    /* Fitted z-positions of surface atoms */
FIT float   XCONST[MAXATOMS];   /* Multiplication factor of x-displacement
				parameter */
FIT int     NXDIS[MAXATOMS];    /* Serial number of x-displacement par. */
FIT float   X2CONST[MAXATOMS];  /* Multiplication factor of 2nd
				x-displacement parameter */
FIT int     NX2DIS[MAXATOMS];   /* Serial number of 2nd x-displacement par. */
FIT float   YCONST[MAXATOMS];   /* Multiplication factor of y-displacement
				parameter */
FIT int     NYDIS[MAXATOMS];    /* Serial number of y-displacement par. */
FIT float   Y2CONST[MAXATOMS];  /* Multiplication factor of 2nd y-displacement
				parameter */
FIT int     NY2DIS[MAXATOMS];   /* Serial number of 2nd y-displacement par. */
FIT int     NZDIS[MAXATOMS];    /* Serial number of z-displacement par. */
FIT int     NOCCUP[MAXATOMS];   /* Serial number of occupation fraction */
FIT float   DISPL[MAXPAR];      /* Values of displacement parameters */
FIT float   DISPLLIM[MAXPAR][2];    /* Limits of displacement parameters */
FIT int	    DISPLPEN[MAXPAR];	/* Penalty factors for displacement pars */
FIT int     NDISTOT;            /* Total number of displacement parameters */
FIT float   DEBWAL[MAXPAR];     /* Parallel Debye-Waller parameters */
FIT float   DEBWALLIM[MAXPAR][2];   /* Limits of DW parameters */
FIT int	    DEBWALPEN[MAXPAR];	/* Penalty factors of DW's */
FIT int     NDWTOT;             /* Total no. of paral. Debye-Waller params */
FIT float   DEBWAL2[MAXPAR];    /* Perpendicular Debye-Waller parameters */
FIT float   DEBWAL2LIM[MAXPAR][2];  /* Limits of perp. DW's */
FIT int	    DEBWAL2PEN[MAXPAR];	/* Penalties of perp. DW's */
FIT int     NDWTOT2;            /* Total no. of perp. Debye-Waller params */
FIT float   OCCUP[MAXPAR];      /* Values of occupation parameters */
FIT float   OCCUPLIM[MAXPAR][2];    /* Limits of occupation parameters */
FIT int	    OCCUPPEN[MAXPAR];	/* Penalties of occupation parameters */
FIT int     NOCCTOT;            /* Total number of occupation parameters */
FIT float   FITPAR[MAXFIT];     /* Values of fit parameters */
FIT float   FITERR[MAXFIT];     /* Errors in fit parameters */
FIT int     FIXPAR[MAXFIT];     /* Flag to denote a fixed parameter */
FIT char    FITTXT[MAXFIT][TITLE_LENGTH];     /* Name of fit parameters */
FIT float   FITMIN[MAXFIT];     /* Lower bound on value of fit parameters */
FIT float   FITMAX[MAXFIT];     /* Upper bound on value of fit parameters */
FIT int	    FITPEN[MAXFIT];	/* Penalty factors for fit parameters */
FIT float   FWEIGHT[MAXDATA];   /* Weight factor of data points in fit */
FIT float   CHISQR;             /* Normalized chi-square value of fit */
FIT int     FULLMODEL;          /* Flag to set showing of extended model, i.e.
				showing 2 displacements per atom, or not */


#ifdef SPEEDUP
/* Storage of fixed values to speed up fitting */

CALC float   Q_PAR[MAXDATA];     /* Length of q_parallel vector of i-th
				data point */
CALC float   Q_PERP[MAXDATA];    /* Length of q_perpendicular vector of
				i-th data point */
CALC float   FAT[MAXDATA][MAXTYPES]; /* Atomic scattering factor for
				    all atom types of i-th data point */
CALC float   RE_BULK[MAXDATA][MAXDOM]; /* Real part of bulk structure factor */
CALC float   IM_BULK[MAXDATA][MAXDOM]; /* Imaginary part of bulk str. factor */
CALC float   FBULK_SQR[MAXDATA];   /* Square of total bulk str. factor */
#endif

/* Structure factor data */

PLOT float   HDAT[MAXDATA];      /* h-value of data */
PLOT float   KDAT[MAXDATA];      /* k-value of data */
PLOT float   LDAT[MAXDATA];      /* l-values of data */
PLOT float   LBR[MAXDATA];       /* l-values of nearest Bragg peak */
PLOT float   FDAT[MAXDATA];      /* Structure factors of data */
PLOT float   ERRDAT[MAXDATA];    /* Error in structure factors */
PLOT int     NDAT;               /* Number of data points */

/* Theoretical structure factor */

PLOT float   HTH[MAXTHEO];       /* h-values of theoretical point */
PLOT float   KTH[MAXTHEO];       /* k-values of theoretical point */
PLOT float   LTH[MAXTHEO];       /* l-values of theoretical point */
PLOT float   FTH[3][MAXTHEO];    /* Structure factors for bulk, surface and
				    interference sum */
PLOT float   PHASE[MAXTHEO];     /* The phase of the interference sum f's */
PLOT int     NTH;                /* Number of theoretical points */
PLOT float   LSTART;             /* Start value of l in rod calculation */
PLOT float   LEND;               /* End value of l in rod calculation */
PLOT int     NL;                 /* Number of computed points in rod */
PLOT float   ATTEN;              /* Attenuation factor in truncation rod */
PLOT float   BETA;               /* Roughness parameter beta */
PLOT float   BETALIM[2];	 /* Fit limits for roughness parameter */
PLOT int     BETAPEN;		 /* Penalty factor for roughness parameter */
PLOT float   LBRAGG;             /* l-value of nearest Bragg peak */
PLOT float   SCALE;              /* Scale factor of theory */
PLOT float   SCALELIM[2];	 /* Fit limits for scale parameter */
PLOT int     SCALEPEN;		 /* Penalty factor for scale parameter */
PLOT float   SCALE2;             /* 2nd scale factor of theory */
PLOT float   SCALE2LIM[2];	 /* Fit limits for scale2 parameter */
PLOT int     SCALE2PEN;		 /* Penalty factor for scale2 parameter */

/* Parameters needed for making symmetry-expanded data set for Fourier map */

CALC char    PLANEGROUP[10];     /* Name of planegroup used */
CALC float   TRANS[MAXEQU][2][2];    /* The transformation matrices between
				    symmetry-equivalent reflections */
CALC int     NTRANS;             /* Number of matrices for the space group */
CALC struct
    {
    int     H[MAXEQU];          /* Diffraction index h of symmetry set */
    int     K[MAXEQU];          /* Diffraction index k of symmetry set */
    int     N;                  /* # of symmetry equivalents */
    }
    SYMSET[MAXDATA];            /* List of symmetry-equivalent reflections
				associated with input structure factor set */

/* Plotting parameters */

PLOT float   FSIZE;              /* Size of circles in plot of structure
				    factors */
PLOT float   FTHRESHOLD;         /* Plotting threshold for structure factors */
PLOT float   ATRAD[MAXTYPES];    /* Size of atom in plot of structure model */
PLOT unsigned long NLEVEL;       /* Number of contour levels */
PLOT float   MINCON;             /* Minimum contour level */
PLOT float   MAXCON;             /* Maximum contour level */
PLOT float   XMINCON;            /* Lower bound on x range for contour plot */
PLOT float   XMAXCON;            /* Upper bound on x range for contour plot */
PLOT float   YMINCON;            /* Lower bound on y range for contour plot */
PLOT float   YMAXCON;            /* Upper bound on y range for contour plot */
PLOT unsigned long NXCON;        /* Number of steps along x direction */
PLOT unsigned long NYCON;        /* Number of steps along y direction */

/* Parameters for the lattice energy minimization */

KEATING int	KEAT_PLUS_CHI;		/* Flag to denote whether energy
					is combined with chi^2 minimization */
KEATING int	POTENTIAL;		/* Flag to denote the potential used */
#define VKEATING 1			/* Keating potential */
#define VLENNARDJONES 2                  /* Lennard-Jones potential */
KEATING float   ALPHA_KEAT;		/* Bond-length deformation parameter */
KEATING float   BETA_KEAT;		/* Bond-angle deformation parameter */
KEATING float   ATOM_RAD[MAXTYPES];	/* Atomic radii of the elements involved */
KEATING float	EQU_ANGLE;		/* Equilibrium bond angle */
KEATING int	IN_KEAT[MAXATOMS];	/* Flag to denote whether atom is part of
					   lattice  energy minimization */
KEATING int	NBOND[MAXATOMS];	/* Number of bonds of atoms i */
KEATING int     BOND_LIST[MAXATOMS][MAXBOND];	/* List of bonds */
KEATING int	XBSHIFT[MAXATOMS][MAXBOND];	/* Shift along a1 to get
						correct bond */
KEATING int	YBSHIFT[MAXATOMS][MAXBOND];	/* Shift along a2 to get
						correct bond */
KEATING int     NANGLE[MAXATOMS];	/* Number of angles of atom i */
KEATING int	ANGLE_LIST[MAXATOMS][MAXANGLE][2];	/* List of bond angles */
KEATING int	XASHIFT[MAXATOMS][MAXANGLE][2];	/* Shift along a1 to get
						correct bond angle */
KEATING int	YASHIFT[MAXATOMS][MAXANGLE][2];	/* Shift along a2 to get
						correct bond angle */

/* Various other stuff */


//PLOT char    PATFILENAME[128];   /* Patterson output file */
ROD  char    STRING[INLLEN];      /* String for general use */
ROD  char    INLINE[INLLEN];     /* Buffer line for file input */
ROD  char    ROD_DEBUG;		 /* global debug flag */
ROD  char    REFL_DEBUG;	 /* debug flag for reflectivity */

/***************************************************************************/
/*      function prototypes                                                */
/***************************************************************************/

/* in calc.c */

LFLAGS  float   angle_calc(int atom1, int atom2, int atom3);
LFLAGS  void    calculate(void);
LFLAGS  float	calc_roughness(float h, float k, float l, float lbragg);
LFLAGS  float   dist_calc(int atom1, int atom2, float *dx, float *dy, float *dz);
LFLAGS  float   f_atomic(float q_half, int natom);
LFLAGS  void	f_bulk(float h, float k, float l, float fat[], float dw[],
	    float atten, float re_bulk[], float im_bulk[]);
LFLAGS  void    f_bulk_beta(float h, float k, float l, float fat[], float dw[],
                float re_bulk[], float im_bulk[]);
LFLAGS  void    f_bulk_numerical(float h, float k, float l, float fat[], float dw[],
                float re_bulk[], float im_bulk[]);
LFLAGS  void    f_calc(float h, float k, float l, float atten, float lbragg,
	    float *fbulk, float *fsurf, float *fsum, float *phase);
LFLAGS  double  factrl(int n);
#ifdef SPEEDUP
LFLAGS  float   f_calc_fit(float h, float k, float l, float lbragg,
	    float q_par, float q_perp, float fat[],
	    float re_bulk[], float im_bulk[],float fbulk_sqr);
LFLAGS  void	f_calc_fit_init(void);
#endif
LFLAGS  void	f_surf(float h, float k, float l, float fat[],
	    float dw_par[], float dw_perp[], float dw[], int cell,
	    float re_surf[], float im_surf[]);
LFLAGS  float   fourier(float x, float y, int mode);
LFLAGS  void    generate_equivalents(int h, int k, int n);
LFLAGS  void    get_cartesian(float cart[3], float x, float y, float z);
LFLAGS  void    l_effective(void);
LFLAGS  void    make_symmetry_set(int mode);
LFLAGS  void    next_domain(float hin, float kin, float *hout, float *kout,
	    int ndomain);
LFLAGS  double  occ_calc(int k);
LFLAGS  float   q_length(float h, float k, float l);
LFLAGS  float   rms_calc(float *sum, float *mean, float *rms);
LFLAGS  double  sqr(float x);

/* in elements.c */

int     el_equal(char el1[3], char el2[3]);
float * get_coeff(char el[3], float coeff[9]);
int     get_element_number(char el[3]);

/* in fit.c */

void    ffit(float x, float a[], float *y, float dyda[], int na,
	    int derivatives);
#ifdef ASA
float	ffit_asa(float a[]);
#endif
void    fit(void);
int		init_fitpar(void);
void	update_par(void);

#ifdef EXTENSIONS /* Mcsl */
void    fit_auto(void);
#endif /* EXTENSIONS Mcsl */


/* in keating.c */

void	angle_search(void);
void	bond_search(void);
void	fit_energy(void);
void    fenergy(float x, float a[], float *y, float dyda[], int na,
	    int derivatives);
void	energy(void);
float	energy_calc(void);

/* in list.c */

void    list(void);

/* in plot.c */

void	makefile_msi(void);
void	makefile_plot3d(int mode);
void    plot(void);
void    plot_circle(float x, float y, float radius, int mode, int fill);
void    plot_model(int mode);
void    plot_fourier(int mode);
void    plot_sfac(int mode);

/* in read.c */

void    read_data(void);
void    read_bulk(void);
void    read_fit(void);
void    read_par(void);
void    read_surf(void);
void    read_type(void);

/* in rod.c */

char *	get_init_fname(void);
void    initialize(void);
void    write_initmac(void);

#ifdef EXTENSIONS
void extensions (void);
#endif

/* in set.c */

int     get_natom(char *prompt);
void    set(void);
void    set_calc(void);
void    set_domain(void);
void    set_fit_model(void);
void    set_parameters(void);
void    set_plot(void);
void	set_roughness_mode(void);
void    set_symmetry(void);
void    set_surf(void);
void    update_model(void);

/* in refl.c */

#ifdef INCL_REFL

void    Refl(void);

#endif

/* include extensions header files */

#ifdef EXTENSIONS
#include "robach.h"
#include "svensson.h"
#include "walker.h"
#include "mcsl.h"
#endif

/***************************************************************************/
/*      undefine some flags                                                */
/***************************************************************************/

#undef ROD
#undef CALC
#undef FIT
#undef SET
#undef PLOT
#undef KEATING

#ifdef __cplusplus
}
#endif


#endif /* _ROD_H_ */
