/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                        robach.c                                  $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: robach.cpp,v 1.8 2004/05/05 11:05:57 wilcke Exp $

****************************************************************************/

/***************************************************************************

   	- activates/deactivate Robach's extension
	- for this extension :
		- sets + lists the corresponding parameters
		- sets + lists the calculation options
		- sets + lists the extended model (automatic generation
			of additional planes)

****************************************************************************/

/*

Update 29/04/2004 R. Wilcke (wilcke@esrf.fr) 
                  change program to use the ISO standard for complex numbers.
                  In detail:
                  - replace the "float_complex" type declarations by
                    "complex<float>" together with a "using std::complex;"
                    statement in each concerned routine;
                  - adding a number of "float" casts in various arithmetic
                    calculations to get the complex arithmetic to work (when
                    the complex number is of type "float", the non-complex
                    number it is multiplied (divided, added, subtracted) with
                    must also be "float" because of the overloading definitions
                    of those operators in the include file <complex>;
                  - replace the "int exponent" variable in the pow() function
                    call in routine f_bulk_beta_cx() by a "double dexp" to make
                    this call work (probably another consequence of the changed
                    overloading environment for functions).
Update 19/01/2004 R. Wilcke (wilcke@esrf.fr) 
                  removed declarations of fopen() (is declared in "stdio.h").
Update 26/03/2002 R. Wilcke (wilcke@esrf.fr)
                  robach(), rob_set(), set_ads_calc(), set_ads_extended(),
                  rob_set_par(), set_slab(), rob_set_fit(), and set_anomalous():
                  changed abbreviations for menu commands to the agreed set.
Update 26/11/2001 O. Svensson (svensson@esrf.fr)
                  Moved #include "rod.h" outside extern "C".
Update 25/09/2001 O. Svensson (svensson@esrf.fr)
                  Moved definitions of dzplane, zplane, occ1plane
                  and occ2plane to this file from robach.h
Update 25/10/2000 O.Svensson (svensson@esrf.fr)
                  Added new function robach_init().
Update 02/10/2000 O.Svensson (svensson@esrf.fr)
                  Spelling mistake correction, desactivte -> deactivate
Update 19/07/2000 R. Wilcke (wilcke@esrf.fr)
                  replaced everywhere the buffer size for filenames by
                  the ISO-C defined macro FILENAME_MAX.

*/

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#define SET
#include "rod.h"

#ifdef __cplusplus
extern "C" {
#endif

#include <ctype.h>

#ifdef EXTENSIONS /* Robach */

/* main part */


/***************************************************************************/
void    robach(void)
/***************************************************************************/

    /*    Robach's extension menu.    */
{
	/* define robach menu */ 
	/* modif 270201 add reset and slab menu */
	
#define robach_length 6       /* number of commands in robach menu */

    static struct   MENU robach_menu[robach_length] =
	{
	"activate", 1,   1, "Activate/deactivate Robach's extension",
	"set",      1,   2, "Set features of Robach's extension",
	"write",    1,   3, "Write current features to macro file",
	"reset",    3,  18, "Reset all param of this extension",	
	"help",     1,	19, "Display menu",
	"return",   1,  20, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];

    while (!stop)
    {
	if (!get_token(token,"ROD.EXT.ROB>")) break;
	switch (cmnd_match(token,robach_menu,robach_length))
	{
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		sprintf(STRING,"Activate Robach's extensions ? [%s]: ", 
			yesnostr(robach_flag));
		robach_flag = yesno(robach_flag,STRING);
		break;
	    case 2:
		if (robach_flag == 0)
		{
		    errtype("ERROR, Robach's extension deactivated");
		    clear_command();
		    break;
		}
		rob_set();
		break;
	    case 3:
		if (robach_flag == 0)
		    {
		    errtype("ERROR, Robach's extension deactivated");
		    clear_command();
		    break;
		    }
		rob_write_mac();
		break;
	    case 18:
		robach_init();
		break;
	    case 19:
		list_menu("ROBACH MENU",robach_menu,robach_length);
		break;
	    case 20:
		stop = TRUE;
	    }
	}
}

/***************************************************************************/
void robach_init (void)
/***************************************************************************/
{
    int i, j, k;

    NZFUNCTOT=0;
    NOFUNCTOT=0;
    for (i=0;i<MAXATOMS;i++)
    {
	EXTAT[i].MODE=0;
	EXTAT[i].ZDIS=0;
	EXTAT[i].NSTART=0;
	EXTAT[i].NPLANS=0;
	EXTAT[i].NLAYERS=0;
	EXTAT[i].ZSHIFT = 0;
	for (j=0;j<MAXSURFLAYERS;j++) EXTAT[i].XSHIFT[j]=EXTAT[i].YSHIFT[j]=0;
	EXTAT[i].ODIS=EXTAT[i].ORIGIN=0;
	ZFUNC[i].type=0;
	for (j=0;j<4;j++)
	{
	    ZFUNC[i].ZPAR[j]=ZFUNC[i].ZPARLIM[j][0]=ZFUNC[i].ZPARLIM[j][1]=0;
	    ZFUNC[i].ZPARPEN[j]=0;
	}
	OFUNC[i].type=0;
	for (j=0;j<2;j++)
	{
	    OFUNC[i].OPAR[j]=OFUNC[i].OPARLIM[j][0]=OFUNC[i].OPARLIM[j][1]=0;
	    OFUNC[i].OPARPEN[j]=0;
	}
   }

    NSUBSTRATE = 0;
    ratio_flag = 0;
    deposit_flag = BEFORE_DEPOSIT;
    BETA2 = 0.5;
    for (i=0; i<MAXSUBSTRATEATOMS ; i++)
	sub_atom[i]=10000;
    MISFIT=0.0;
    WIDTH=0.0;
    relax_flag=0;

/* add160201 */
    roughfsurf_flag = 1;	
/*end add160201 */
    
/* add220800 */
    for (i=0;i<MAXDATA;i++) NL_OR[i]=1.0;
    var_nlayers = 0;
    SIGMA = 0.0; 
    SIGMA2 = 0.0;
/* endadd220800 */
/* add230800 */
    for (i=0;i<MAXPAR;i++)	OCCUPTOT[i] = 1.;
    for (i=0;i<MAXATOMS;i++)	NOCCUP2[i] = 0;

/* add270201 */
   	NSLAB = 0;
   	for (k=0; k<MAXSLAB ; k++)
   	{
		for (i=0; i<4 ; i++)
		{
			SLAB[k].SPAR[i]=0.0;
			SLAB[k].SPARLIM[i][0]=0.0;
			SLAB[k].SPARLIM[i][1]=0.0;
			SLAB[k].SPARPEN[i]=0;
		}
   	}
	alloy_atom[0]=10000;
	alloy_atom[1]=10000;
	dz_bulk[0]=1.0;
	dz_bulk[1]=1.0;

/* add100901 */
	anomalous_flag = REAL_fat ;
	LIII = 11569 ;
	gamma_width = 4.0 ;
	NC = -21 ;
	NCS = 5.0 ;
	NS = 6.5 ;
	NP = 4.3 ;
	MU = 0.0;
	diffraction_mode = SPECULAR ;
/* endadd100901 */	
		
}

/***************************************************************************/
void rob_write_mac (void)
/***************************************************************************/

     /* Write current values of parameters to macro file which can be used
	for initialization. */
{
  FILE *macfile;
  char *item;
  int i, atom, k, flag, ztype;

  /* Open macro file */

  if ((macfile = fopen (ROBACH_MACFILE, "w+")) == NULL)
    {
      sprintf (STRING, "Failed to open %s file", ROBACH_MACFILE);
      errtype (STRING);
      clear_command ();
      return;
    }

  /* Save parameters for Robach's extension */

  fprintf (macfile, "ext rob\n");
  fprintf (macfile, "activate %s\n", yesnostr (robach_flag));
  fprintf (macfile, "return \nreturn \n");
  fprintf (macfile, "! add read bul + read fit commands here\n\n");

  if (robach_flag)
  {
  	fprintf (macfile, "ext rob set par\n");
	if (ROUGHMODEL==APPROXERF) flag=1;
	else flag=0;
	fprintf(macfile,"erfrough %s\n",yesnostr(flag));
    	fprintf (macfile,"sc3 %8.4f %8.4f %8.4f %s\n",
		SCALE3, SCALE3LIM[0], SCALE3LIM[1], yesnostr(SCALE3PEN));
    	fprintf (macfile,"lshift %8.4f %8.4f %8.4f %s\n",
	    	LSHIFT, LSHIFTLIM[0], LSHIFTLIM[1], yesnostr(LSHIFTPEN));
    	fprintf (macfile,"s2 %8.4f %8.4f %8.4f %s\n",
	    	SURF2FRAC, SURF2FRACLIM[0], SURF2FRACLIM[1],yesnostr(SURF2FRACPEN));
	/* add160201*/
	fprintf(macfile,"fsurfrough %s\n",yesnostr(roughfsurf_flag));
	/*endadd160201*/

	/* add220800 */
	fprintf(macfile,"varnl %s\n",yesnostr(var_nlayers));
	if (var_nlayers==1)
	{
		fprintf (macfile, "!warning : this option works only with the approx beta roughness model\n");
		fprintf (macfile,"sigma %8.4f %8.4f %8.4f %s\n",
	    		SIGMA, SIGMALIM[0], SIGMALIM[1],yesnostr(SIGMAPEN));
	}
	/* endadd220800 */

	fprintf (macfile, "return return return return\n");
  	fprintf (macfile, "ext rob set fit\n");
  	fprintf (macfile, "fullmodel yes\n");
	fprintf (macfile, "return return return return\n");
	fprintf (macfile, "ext rob set ads\n");
	for (atom = 0; atom < NSURF+NSURF2; atom++)
	{
		if (EXTAT[atom].MODE!=0)
		{
			fprintf (macfile,"extended %4d \n",atom+1);
		  	fprintf (macfile, "mode yes\n");
		 	fprintf (macfile, "zdis %4d\n", EXTAT[atom].ZDIS);
		 	fprintf (macfile, "odis %4d\n", EXTAT[atom].ODIS);
		 	fprintf (macfile, "nplans %4d\n", EXTAT[atom].NPLANS);
		 	fprintf (macfile, "nlayer %4d\n", EXTAT[atom].NLAYERS);
		 	fprintf (macfile, "origin %4d\n", EXTAT[atom].ORIGIN+1);
		 	fprintf (macfile, "nstart %4d\n", EXTAT[atom].NSTART);
			fprintf (macfile, "zshift %.4f\n",EXTAT[atom].ZSHIFT);
			for (i=0;i<EXTAT[atom].NLAYERS;i++)
			{
				fprintf (macfile,"xshift %d %.4f\n",i+1,EXTAT[atom].XSHIFT[i]);
				fprintf (macfile,"yshift %d %.4f\n",i+1,EXTAT[atom].YSHIFT[i]);
			}  
		  	fprintf (macfile, "\n");
		}
	}
	fprintf (macfile, "return return return return return\n");
  	fprintf (macfile, "ext rob set ads func \n");
	fprintf (macfile,"! dz functions:\n");	
	for (i=0;i<NZFUNCTOT;i++)
	{
		fprintf (macfile, "zadd %d \n",i+1);
		fprintf (macfile, "zpar %d %d",i+1,ZFUNC[i].type);
		ztype = ZFUNC[i].type;
		for (k=0;k<4;k++)
		{
			fprintf (macfile, " %.4f %.4f %.4f %s", ZFUNC[i].ZPAR[k],
				ZFUNC[i].ZPARLIM[k][0],ZFUNC[i].ZPARLIM[k][1],
				yesnostr(ZFUNC[i].ZPARPEN[k]));
			if ((k==0)&&(ztype==0)) break;
			if ((k==1)&&(ztype==2))
			{	
				fprintf (macfile, " %.4f %.4f %.4f %s",
					OFUNC[i].OPAR[1],	OFUNC[i].OPARLIM[1][0],
					OFUNC[i].OPARLIM[1][1],yesnostr(OFUNC[i].OPARPEN[1]));
				fprintf (macfile, " %.4f %.4f %.4f %s",
					OFUNC[i].OPAR[0],OFUNC[i].OPARLIM[0][0],
					OFUNC[i].OPARLIM[0][1],yesnostr(OFUNC[i].OPARPEN[0]));
				break; 										
			}
			if ((k==2)&&(ztype==1)) break;										
		}	
	  	fprintf (macfile, "\n");
	}             
	fprintf (macfile,"! occ functions:\n");	
	for (i=0;i<NOFUNCTOT;i++)
	{
		fprintf (macfile,"oadd %d \n",i+1);
		fprintf (macfile,"opar %d %d ",i+1,OFUNC[i].type);
 		fprintf (macfile,"%.4f %.4f %.4f %s ",OFUNC[i].OPAR[0],
			OFUNC[i].OPARLIM[0][0],OFUNC[i].OPARLIM[0][1],
			yesnostr(OFUNC[i].OPARPEN[0]));
		if (OFUNC[i].type!=0)
		{
			fprintf (macfile,"%.4f %.4f %.4f %s ",OFUNC[i].OPAR[1],
				OFUNC[i].OPARLIM[1][0],OFUNC[i].OPARLIM[1][1],
				yesnostr(OFUNC[i].OPARPEN[1]));
		}
	  	fprintf (macfile, "\n");
	}
  	fprintf (macfile, "return return return return return\n");
  	fprintf (macfile, "ext rob set ads calc \n");
	if (ratio_flag == 1)
	{
		fprintf (macfile, "ratio yes \n");
		/* add220800*/
		if (var_nlayers==1)
			fprintf (macfile, "sigma2 %8.4f\n",SIGMA2);
		else if (var_nlayers==0)
			fprintf (macfile, "b2eta %8.4f\n",BETA2);
		/*endadd220800*/
		if (NSUBSTRATE > 0)
		{
			fprintf (macfile, "atoms %1d ",NSUBSTRATE);
			for (i=0; i<NSUBSTRATE ; i++)
				fprintf (macfile, " %d ",sub_atom[i]+1);			
		}
	  	fprintf (macfile, "\n");
	}	
	else 	if (ratio_flag == 0)
		fprintf (macfile, "ratio no \n");
	if (relax_flag == 1)
	{
		fprintf (macfile, "relax yes \n");
		fprintf (macfile,"misfit %8.4f\n", MISFIT);
		fprintf (macfile,"width %8.4f %8.4f %8.4f %s\n",WIDTH, 
			WIDTHLIM[0],WIDTHLIM[1], yesnostr(WIDTHPEN));
	}	
	else 	if (relax_flag == 0)
		fprintf (macfile, "relax no \n");
  fprintf (macfile, "return\nreturn\nreturn\nreturn\nreturn\n");

/* add270201 */
	if (NSLAB>0)
	{
  		fprintf (macfile, "ext rob set slab \n");
		fprintf (macfile,"atoms %d %8.4f %d %8.4f\n", 
				alloy_atom[0]+1, dz_bulk[0], alloy_atom[1]+1, dz_bulk[1]);
		fprintf (macfile, "nslab %d ",NSLAB);
		for (k=0;k<NSLAB;k++)
		{	
			fprintf (macfile,"param %d ",k+1);
			for (i=0;i<4;i++)
 				fprintf (macfile,"%.4f %.4f %.4f %s ",SLAB[k].SPAR[i],
					SLAB[k].SPARLIM[i][0],SLAB[k].SPARLIM[i][1],
					yesnostr(SLAB[k].SPARPEN[i]));
		}
		fprintf (macfile, "\nreturn return return return\n");
	}
/* endadd270201*/
  fprintf (macfile, "! add read dat command here\n\n");
  }
  fclose(macfile);
}

/* end of main part */

/* set.c part */

/***************************************************************************/
void	rob_set(void)
/***************************************************************************/

    /*   Robach's extensions set menu. */
    {

	/* define robach set menu */

#define rob_set_length  7      /* number of commands in set menu */

    static struct   MENU rob_set_menu[rob_set_length] =
	{
	"parameters", 2,  1, "Parameters for rod calculation",
	"fit",        1,  2, "Model par. for fitting of structure",
	"adsorbate",  2,  3, "Parameters describing the adsorbate",
	"slab",	      2,  4, "slab model, used for binary alloys",
	"anomalous",  2,  5, "corr. of at. scatter. factor near edges",
	"help",       1, 20, "Display menu",
	"return",     1, 21, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];

    while (!stop)
	{
	if (!get_token(token,"ROD.EXT.ROB.SET>")) break;
	switch (cmnd_match(token,rob_set_menu,rob_set_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		rob_set_par();
		break;
	    case 2:
		rob_set_fit();
		break;
	    case 3:
		set_adsorbate();
		break;
	    case 4:
		set_slab();
		break;
	    case 5:
		set_anomalous();
		break;
	    case 20:
		list_menu("ROBACH SET MENU",rob_set_menu,rob_set_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void set_adsorbate(void)
/***************************************************************************/

/*    Set adsorbate menu. */
{
    /* define set_adsorbate_menu */

#define set_ads_length 6		/* number of commands in set adsorbate menu */

    static struct MENU set_ads_menu[set_ads_length] =
    {
	"extended",  1,  1, "Parameters for extending surface atoms",
	"functions", 1,  2, "Occ(z) and dz(z) function parameters",
	"calc",      1,  3, "Options for extended model calculation",
	"list",      1,  4, "List atoms of extended model",
	"help",      1, 20, "Display menu",
	"return",    1, 21, "Return to main menu"
    };

    int stop = FALSE;
    char token[100];

    while (!stop) {
	if (!get_token(token, "ROD.EXT.ROB.SET.ADS>"))
	    break;
	switch (cmnd_match(token, set_ads_menu, set_ads_length)) {
	case -1:
	    break;
	case 0:
	    break;
	case 1:
	    set_ads_extended();
	    break;
	case 2:
	    set_ads_functions();
	    break;
	case 3:
	    set_ads_calc();
	    break;
	case 4:
		list_ext_model();
		break;
	case 20:
	    list_menu("ROBACH SET ADSORBATE MENU", set_ads_menu, set_ads_length);
	    break;
	case 21:
	    stop = TRUE;
	}
    }
}
/***************************************************************************/
void set_ads_calc(void)
/***************************************************************************/

 /*    Set options for extended model calculation.    */
/* add220800 set SIGMA2 */
{
    /* define set_ads_calc_menu */

#define set_ads_calc_length 10	/* number of commands in set_ads_calc menu */

    static struct MENU set_ads_calc_menu[set_ads_calc_length] =
    {
	"ratiomode", 2,  1, "Set calc. mode: ratio / normal",
	"b2eta",     1,  2, "In ratio mode: value of beta for Fsub",
	"atoms",     2,  3, "In ratio mode: indicate substrate atoms",
	"relaxmode", 3,  4, "Set calc. mode: pseudomorphic / relaxed",
	"width",     1,  5, "In relaxed mode: width of ads. domains",
	"misfit",    1,  6, "In relaxed mode: misfit (ads-sub)/sub",
	"sigma2",    1,  7, "In ratio + var. nl mode: sigma for Fsub",
	"list",      1, 29, "List parameters",
	"help",      1, 30, "Display menu",
	"return",    1, 31, "Return to main menu"
    };

    int stop = FALSE;
    char token[100];
    char *item;
	int i;

    while (!stop) {
	if (!get_token(token, "ROD.EXT.ROB.SET.ADS.CALC>"))
	    break;
	switch (cmnd_match(token, set_ads_calc_menu, set_ads_calc_length)) {
	case -1:
	    break;
	case 0:
	    break;
	case 1:
		sprintf(STRING,"Use ratio Fads+sub over Fsub (else Fads+sub only) [%s]: ", 
			yesnostr(ratio_flag));
		ratio_flag = yesno(ratio_flag,STRING);
		break;
	case 2:
		if (ratio_flag == 0)
		{
	    		errtype("ERROR, this works only in ratio mode ");
	    		break;
		}
		if (var_nlayers == 1)
		{
			errtype("ERROR, this works only with fixed nlayer ");
			break;
		}
		sprintf(STRING,"beta2 [%6.4f]: ",BETA2);
		BETA2=get_real(BETA2,STRING);             
		break;
	case 3:
		if (ratio_flag == 0)
		{
		    	errtype("ERROR, this works only in ratio mode ");
		    	break;
		}
		sprintf(STRING,"total number of SUBSTRATE atoms in fit file[%1d]: ",NSUBSTRATE);
		NSUBSTRATE= get_int(NSUBSTRATE,STRING);
		if (NSUBSTRATE > NSURFTOT)
		{
		    	errtype("ERROR, can't be larger than total number of surface atoms");
		    	NSUBSTRATE = 0;
		}
		if (NSUBSTRATE > 0)
		{
			for (i=0; i<NSUBSTRATE ; i++)
			{
				sub_atom[i]++;
				sprintf(STRING,"substrate atom number %d is atom number [%d] in fit file ?: ",
				i,sub_atom[i]);
				sub_atom[i]= get_int(sub_atom[i],STRING);
				if ((sub_atom[i]> NSURFTOT)||(sub_atom[i]<1))
				{
		    			errtype("ERROR, can't be zero or larger than total # of atoms");
		    			sub_atom[i] = 10000;
				}
				sub_atom[i]--;
			}
		}	
		break;
	case 4:
		sprintf(STRING,"adsorbate is RELAXED (else PSEUDOMORPHIC) [%s]: ", 
			yesnostr(relax_flag));
		relax_flag = yesno(relax_flag,STRING);
		break;
	case 5:
	    	if (relax_flag == 0)
		{
		    	errtype("ERROR, this works only in relaxed mode");
			WIDTH=0.0;
		    	break;
		}
		sprintf(STRING,
		    "width of adsorbate domains in angstroms [%4.2f]: ", WIDTH);
	    	WIDTH = get_real(WIDTH, STRING);
	    	sprintf(STRING,
		    "Lower limit of width parameter [%4.2f]: ", WIDTHLIM[0]);
	    	WIDTHLIM[0] = get_real(WIDTHLIM[0], STRING);
	    	sprintf(STRING,
		    "Upper limit of width parameter [%4.2f]: ", WIDTHLIM[1]);
	    	WIDTHLIM[1] = get_real(WIDTHLIM[1], STRING);
	    	sprintf(STRING,
	    	"Range checking on width parameter [%s]: ", yesnostr(WIDTHPEN));
	    	SCALEPEN = yesno(WIDTHPEN, STRING);
	    	break;
	case 6:
		if (relax_flag == 0)
		{
			errtype("ERROR, this works only in relaxed mode ");
			MISFIT=0.0;		
			break;
		}		
		sprintf(STRING,"misfit (aads-asub)/asub) [%6.4f]: ",MISFIT);
		MISFIT=get_real(MISFIT,STRING);             
		break;
	case 7:
		if (ratio_flag == 0)
		{
			errtype("ERROR, this works only in ratio mode ");
			break;
		}
		if (var_nlayers == 0)
		{
			errtype("ERROR, this works only with variable nlayer ");
			break;
		}
		sprintf(STRING,"sigma2 [%6.4f]: ",SIGMA2);
		SIGMA2=get_real(SIGMA2,STRING);             
		break;
	case 29:	    
		if (ratio_flag == 1)
		{
			type_line("Use ratio Fads+sub over Fsub (ratio mode)\n");
			if (var_nlayers==0)
			{
				sprintf(STRING,"Use fixed NLAYERS.\n");
				type_line(STRING);
				sprintf(STRING,"roughness parameter beta used for Fsub = %8.4f\n",BETA2);
				type_line(STRING);
			}
			else if (var_nlayers==1)
			{
				sprintf(STRING,"Use variable NLAYERS.\n");
				type_line(STRING);
				sprintf(STRING,"rms roughness sigma used for Fsub = %8.4f\n",SIGMA2);
				type_line(STRING);
			}
			sprintf(STRING,"Number of SUBSTRATE atoms in surface unit cell = %1d\n",NSUBSTRATE);
			type_line(STRING);    
			if (NSUBSTRATE > 0)
			{
				for (i=0; i<NSUBSTRATE ; i++)
				{
				sub_atom[i]++;
				sprintf(STRING,"substrate atom number %d is atom number : %d \n",
				i,sub_atom[i]);
				type_line(STRING);			
				sub_atom[i]--;
				}
			}
		}	
		else 	if (ratio_flag == 0)
		{
			type_line("Use Fads+sub (normal mode)\n");	
		}
		if (relax_flag == 1)
		{
			type_line("adsorbate is RELAXED\n");
			sprintf(STRING,"in-plane misfit between adsorbate and substrate = %8.4f\n",
				MISFIT);
			type_line(STRING);
	   		sprintf(STRING,
				    "width of adsorbate domains  = %8.4f  [%8.4f,%8.4f]  %s\n",
				    WIDTH, WIDTHLIM[0], WIDTHLIM[1], yesnostr(WIDTHPEN));
	    		type_line(STRING);
		}	
		else 	if (relax_flag == 0)
		{
			type_line("adsorbate is PSEUDOMORPHIC\n");	
		}
		break;
	case 30:
	    list_menu("ROBACH SET ADS CALC MENU",
		      set_ads_calc_menu, set_ads_calc_length);
	    break;
	case 31:
	    stop = TRUE;
	}
    }
}

/****************************************************************************/
void    set_ads_extended(void)
/****************************************************************************/

/*
			Set parameters for island mode calculation
*/
/* modif 270201 add warning */      
	{
	
	/* define set_extended menu */
	
#define set_extended_length 13       /* number of commands in set_extended menu */

	static struct MENU set_extended_menu[set_extended_length]=
	{
	"mode",    1,  1, "Extended or standard calculation mode",
        "zdis",    2,  2, "SN of dz distr. function",
	"nstart",  2,  3, "Initial atom is in plane nb NSTART",
	"nplans",  2,  4, "Total z extension (in nb of planes)",
	"nlayers", 2,  5, "Number of planes within cell height",
	"xshift",  1,  6, "X trans. between planes within cell",
	"yshift",  1,  7, "Y trans. between planes within cell",
        "odis",    2,  8, "SN of occ distr. function",
	"origin",  2,  9, "Z of 1st plane = Z orig+ NSTART*dZ ",
        "zshift",  2, 10, "Shift to subtract from zm in o.func.",
	"list",    1, 19, "List parameters",
	"help",    1, 20, "Display menu",
	"return",  1, 21, "Return to previous menu"
	};
	
	int     i,stop=FALSE;
	char    token[100]; 
	int atom;
	int orig;
	
	atom=get_int(0,"Atom number [return]: ");
	if (atom==0) return;
	atom-=1;
/* add270201 */
	if ((atom==alloy_atom[0])||(atom==alloy_atom[1]))
	{
		errtype("ERROR, an atom");
		return;
	}
/* endadd270201 */
	while (!stop)
	{    
	if (!get_token(token,"ROD.EXT.ROB.SET.ADS.EXT>")) break;
	switch (cmnd_match(token,set_extended_menu,set_extended_length))
		{
		case -1:
			break;
		case 0:
			break;
		case 1:   
			sprintf(STRING,"Extended calculation mode [%s]: ",yesnostr(EXTAT[atom].MODE));
			EXTAT[atom].MODE=yesno(EXTAT[atom].MODE,STRING);            
			break;
		case 2:
			sprintf(STRING,"Serial number of z distribution [%d]:",EXTAT[atom].ZDIS);
			EXTAT[atom].ZDIS=get_int(EXTAT[atom].ZDIS,STRING);
			break;                                   
		case 3:
			sprintf(STRING,"initial atom is in plane number [%d]: ",EXTAT[atom].NSTART);
			EXTAT[atom].NSTART=get_int(EXTAT[atom].NSTART,STRING);
			break;
		case 4:
			sprintf(STRING,"max number of planes in model [%d]: ",EXTAT[atom].NPLANS);
			EXTAT[atom].NPLANS=get_int(EXTAT[atom].NPLANS,STRING);
			break;
		case 5:
			sprintf(STRING,"Number of inequivalent planes in cell [%d]: ",EXTAT[atom].NLAYERS);
			EXTAT[atom].NLAYERS=get_int(EXTAT[atom].NLAYERS,STRING);
			break;
		case 6:
			i=get_int(2,"Layer [2]: ");
			if ((i>EXTAT[atom].NLAYERS)||(i<1))
			{
				errtype("ERROR, Layer number should be between 1 and NLAYERS");
		    		break;
			}
			i-=1;
			sprintf(STRING,"x shift for layer %d [%.4f]: ",i+1,EXTAT[atom].XSHIFT[i]);  
			EXTAT[atom].XSHIFT[i]=get_real(EXTAT[atom].XSHIFT[i],STRING);			
			break;
		case 7:                                                                                                
			i=get_int(2,"Layer [2]: ");
			if ((i>EXTAT[atom].NLAYERS)||(i<1))
			{
				errtype("ERROR, Layer number should be between 1 and NLAYERS");
		    		break;
			}
			i-=1;
			sprintf(STRING,"y shift for layer %d [%.4f]: ",i+1,EXTAT[atom].YSHIFT[i]);
			EXTAT[atom].YSHIFT[i]=get_real(EXTAT[atom].YSHIFT[i],STRING);
			break;
		case 8:
			sprintf(STRING,"Serial number of occupancy distribution [%d]: ",EXTAT[atom].ODIS);
			EXTAT[atom].ODIS=get_int(EXTAT[atom].ODIS,STRING);
			break;
		case 9:                                                                            
			orig=EXTAT[atom].ORIGIN+1;
			sprintf(STRING,"number of the atom used as z origin [%d]:",orig);
			orig=get_int(orig,STRING);
			if ((orig>NSURF+NSURF2)||(orig<1))
			{
				errtype("ERROR, atom number out of range");
		    		break;
			}
			EXTAT[atom].ORIGIN =orig-1;
			break;
		case 10:
			sprintf(STRING,"shift to substract from zm in occ func [%.4f]: ",EXTAT[atom].ZSHIFT);  
                        EXTAT[atom].ZSHIFT=get_real(EXTAT[atom].ZSHIFT,STRING);
			break;
		case 19:
			sprintf(STRING,"Atom %d parameters\n",atom+1);
			type_line(STRING);
			if (!EXTAT[atom].MODE)
				{
				sprintf (STRING,"standard mode\n");
				type_line(STRING);
				}
			else
				{
				sprintf(STRING,"extended mode\n");
				type_line(STRING); 
				sprintf(STRING,"z function: %d\n",EXTAT[atom].ZDIS);
				type_line(STRING);
				sprintf(STRING,"atom belonging to plane: %d\n",EXTAT[atom].NSTART);
				type_line(STRING);
				sprintf(STRING,"max number of planes: %d\n",EXTAT[atom].NPLANS);
				type_line(STRING);
				sprintf(STRING,"number of inequivalent planes in cell: %d\n",EXTAT[atom].NLAYERS);
				type_line(STRING);
				for (i=0;i<EXTAT[atom].NLAYERS;i++)
					{
					sprintf(STRING,"\tx shift for layer %d: %.4f\n",i+1,EXTAT[atom].XSHIFT[i]);
					type_line(STRING);
					sprintf(STRING,"\ty shift for layer %d: %.4f\n",i+1,EXTAT[atom].YSHIFT[i]);
					type_line(STRING);
					}                      
				sprintf(STRING,"occupancy function: %d\n",EXTAT[atom].ODIS);
				type_line(STRING);
				sprintf(STRING,"shift to substract from zm in occ func: %.4f\n",EXTAT[atom].ZSHIFT);  
				type_line(STRING);
				sprintf(STRING,"origin atom number: %d\n",EXTAT[atom].ORIGIN+1);
				type_line(STRING);
			}
			break;
		case 20:
			list_menu("ROBACH SET ADS EXTENDED",set_extended_menu,set_extended_length); 
			break;
		case 21:
			stop=TRUE;
		}
	}
	}
															       
/***************************************************************************/
void set_ads_functions(void)
/***************************************************************************/
	{                                            
	
#define set_functions_length 9
	static struct MENU set_functions_menu[set_functions_length]=
	{  
	"zadd",   2,  1, "Add interplanar distance dist. z func",
	"oadd",   2,  2, "Add occupancy distribution z function",
	"zdel",   2,  3, "Remove interpl. dist. dist. z func.",
	"odel",   2,  4, "Remove occup. distribution o function",
	"zpar",   2,  5, "Set z function parameter",
	"opar",   2,  6, "Set o function parameter",
	"list",   1, 19, "List parameters",
	"help",   1, 20, "Display menu",
	"return", 1, 21, "Return to previous menu"
	};
	
	int i,k,stop=FALSE;
	char token [100];
	int ztype;
	
	while (!stop)
	{    
	if (!get_token(token,"ROD.EXT.ROB.SET.ADS.FUNC>")) break;
	switch (cmnd_match(token,set_functions_menu,set_functions_length))
		{            
		case 1:
			k=get_int(0,"Serial number: ");
			if (k!=0)
				if (!(k>NZFUNCTOT+1))
					{
					for (i=NZFUNCTOT;i>k-1;i--) ZFUNC[i]=ZFUNC[i-1];
					NZFUNCTOT+=1;
					}
				else
					errtype("Error: serial number too large");
			break;
		case 2:
			k=get_int(0,"Serial number: ");
			if (k!=0)
				if (!(k>NOFUNCTOT+1))
					{
					for (i=NOFUNCTOT;i>k-1;i--) OFUNC[i]=OFUNC[i-1];
					NOFUNCTOT+=1;
					}
				else
					errtype("Error: serial number too large");
			break;
		case 3:                                                     
			k=get_int(0,"Serial number: ");
			if ((k!=0)&&(k<NZFUNCTOT+1))
				{
				 k-=1;                                                                             
				 NZFUNCTOT-=1;
				 for (i=k;i<NZFUNCTOT;i++) ZFUNC[i]=ZFUNC[i+1];
				 }
			break;                           
		case 4:
			k=get_int(0,"Serial number: ");
			if ((k!=0)&&(k<NOFUNCTOT+1))
				{
				 k-=1;                                                                             
				 NOFUNCTOT-=1;
				 for (i=k;i<NOFUNCTOT;i++) OFUNC[i]=OFUNC[i+1];
				 }
			break;
		case 5:
			k=get_int(0,"Serial number: ");
			if (k!=0)
			{
				k-=1;
				sprintf(STRING,"Function type(0: no relax; 1: exp relax; 2:erf relax v1; 3: erf relax v2) [%d]: ", ZFUNC[k].type);
				ZFUNC[k].type=get_int(ZFUNC[k].type,STRING);
				
				sprintf(FUNCTXT[0],"dz(z->+oo)");
				sprintf(FUNCTXT[1],"dz(z0)");
				sprintf(FUNCTXT[2],"sigmaz");
				sprintf(FUNCTXT[3],"zmeanz");

				ztype = ZFUNC[k].type;

				for (i=0;i<4;i++)
				{
					sprintf(STRING,"%*s [%.4f]: ",TITLE_LENGTH, FUNCTXT[i], ZFUNC[k].ZPAR[i]);
					ZFUNC[k].ZPAR[i]=get_real(ZFUNC[k].ZPAR[i],STRING);
					sprintf(STRING,"%*s low limit [%.4f]: ",TITLE_LENGTH, FUNCTXT[i], ZFUNC[k].ZPARLIM[i][0]);
					ZFUNC[k].ZPARLIM[i][0]=get_real(ZFUNC[k].ZPARLIM[i][0],STRING);
					sprintf(STRING,"%*s high limit [%.4f]: ",TITLE_LENGTH, FUNCTXT[i],ZFUNC[k].ZPARLIM[i][1]);
					ZFUNC[k].ZPARLIM[i][1]=get_real(ZFUNC[k].ZPARLIM[i][1],STRING);
					sprintf(STRING,"range checking for %*s [%s]: ",TITLE_LENGTH, FUNCTXT[i],yesnostr(ZFUNC[k].ZPARPEN[i]));
					ZFUNC[k].ZPARPEN[i]=yesno(ZFUNC[k].ZPARPEN[i],STRING);
					if ((i==0)&&(ztype==0)) break;
					if ((i==1)&&(ztype==2))
					{
						sprintf(STRING,"Here sigmaz = sigmao and zmeanz = zmeano, \n where sigmao and zmeano are the param. of the occ-function number %d. \n",k+1);
						type_line(STRING);
						break; 										
					}
					if ((i==2)&&(ztype==1)) 
					{
						if ((ZFUNC[k].ZPAR[i]>1)||(ZFUNC[k].ZPAR[i]<0))
						{
							errtype("for the exp function, sigmaz should be >0 and <1");	
						}	
						break;
					}										
				}
			}
			break;
		case 6: /* modif 070103 */
			k=get_int(0,"Serial number: ");
			if (k!=0)
			{
				k-=1;
				sprintf(STRING,"Function type (0: uniform; 1: erf with occtot; 2: gauss; 3: exp; 4: erf with occ(n=0); 5: unif then beta^n ) [%d]: ",OFUNC[k].type);
				OFUNC[k].type=get_int(OFUNC[k].type,STRING);
				switch (OFUNC[k].type)
				{
					case 0:
					case 1:
					case 2:
					case 3:
					case 4:
						sprintf(FUNCTXT[0],"zmeano");
						sprintf(FUNCTXT[1],"sigmao");
						break;
					case 5 :	
						sprintf(FUNCTXT[0],"nmean");
						sprintf(FUNCTXT[1],"beta");
						break;
				}		
				for (i=0;i<2;i++)
				{
					sprintf(STRING,"%*s [%.4f]: ",TITLE_LENGTH,FUNCTXT[i],OFUNC[k].OPAR[i]);
					OFUNC[k].OPAR[i]=get_real(OFUNC[k].OPAR[i],STRING);
					sprintf(STRING,"%*s low limit [%.4f]: ",TITLE_LENGTH,FUNCTXT[i],OFUNC[k].OPARLIM[i][0]);
					OFUNC[k].OPARLIM[i][0]=get_real(OFUNC[k].OPARLIM[i][0],STRING);
					sprintf(STRING,"%*s high limit [%.4f]: ",TITLE_LENGTH,FUNCTXT[i],OFUNC[k].OPARLIM[i][1]);
					OFUNC[k].OPARLIM[i][1]=get_real(OFUNC[k].OPARLIM[i][1],STRING);
					sprintf(STRING,"range checking for %*s [%s]: ",TITLE_LENGTH,FUNCTXT[i],yesnostr(OFUNC[k].OPARPEN[i]));
					OFUNC[k].OPARPEN[i]=yesno(OFUNC[k].OPARPEN[i],STRING);
					if (OFUNC[k].type==0) i=1;
				}			
			}	
			break;
		case 19:
			sprintf(STRING,"z functions:\n");
			type_line(STRING);
			for (i=0;i<NZFUNCTOT;i++)
			{
				switch (ZFUNC[i].type)
				{
				   case 0:
					sprintf(STRING,"%d: no relaxation\n",i+1);
					break;
				   case 1:
					sprintf(STRING,"%d: exp relaxation\n",i+1);
					break;
				   case 2:
					sprintf(STRING,"%d: erfc relaxation, param. linked to occ function \n",i+1);
					break;
				   case 3:
					sprintf(STRING,"%d: erfc relaxation, indep. param. \n",i+1);
					break;
				   default:
					sprintf(STRING,"%d: unknown\n",i+1);
					break;
				}
				type_line(STRING);

				sprintf(FUNCTXT[0],"dz(z->+oo)");
				sprintf(FUNCTXT[1],"dz(z0)");
				sprintf(FUNCTXT[2],"sigmaz");
				sprintf(FUNCTXT[3],"zmeanz");
				ztype = ZFUNC[i].type;

				for (k=0;k<4;k++)
				{
					sprintf(STRING,"\t %*s : %.4f [%.4f,%.4f] %s\n",TITLE_LENGTH,
						FUNCTXT[k], ZFUNC[i].ZPAR[k],ZFUNC[i].ZPARLIM[k][0],
						ZFUNC[i].ZPARLIM[k][1],	yesnostr(ZFUNC[i].ZPARPEN[k]));
					type_line(STRING);

					if ((k==0)&&(ztype==0)) break;
					if ((k==1)&&(ztype==2))
					{	
						sprintf(STRING,"\t sigmaz = sigmao: %.4f [%.4f,%.4f] %s\n",
							OFUNC[i].OPAR[1],	OFUNC[i].OPARLIM[1][0],
							OFUNC[i].OPARLIM[1][1],yesnostr(OFUNC[i].OPARPEN[1]));
						type_line(STRING);
						sprintf(STRING,"\t zmeanz= zmeano: %.4f [%.4f,%.4f] %s\n",
							OFUNC[i].OPAR[0],OFUNC[i].OPARLIM[0][0],
							OFUNC[i].OPARLIM[0][1],yesnostr(OFUNC[i].OPARPEN[0]));
						type_line(STRING);
						break; 										
					}
					if ((k==2)&&(ztype==1)) break;										
				}	
			}                
			sprintf(STRING,"o functions:\n");
			type_line(STRING);
			for (i=0;i<NOFUNCTOT;i++)
			{
				switch (OFUNC[i].type)
				{
				   case 0:
					sprintf(STRING,"%d: uniform occupancy\n",i+1);
					break;
				   case 1:
					sprintf(STRING,"%d: erfc occupancy with fit on total occ\n",i+1);
					break;
				   case 2:
					sprintf(STRING,"%d: gauss occupancy\n",i+1);
					break;
				   case 3:
					sprintf(STRING,"%d: exp occupancy\n",i+1);
					break;
 				   case 4:
					sprintf(STRING,"%d: erfc occupancy with fit on 1st plane occ\n",i+1);
					break;
 				   case 5:
					sprintf(STRING,"%d: uniform then beta^n occ\n",i+1);
					break;
				   default:
					sprintf(STRING,"%d: unknown\n",i+1);
					break;
				}
				type_line(STRING);
				switch (OFUNC[i].type)
				{
					case 0:
					case 1:
					case 2:
					case 3:
					case 4:
						sprintf(FUNCTXT[0],"zmeano");
						sprintf(FUNCTXT[1],"sigmao");
						break;
					case 5 :	
						sprintf(FUNCTXT[0],"nmean");
						sprintf(FUNCTXT[1],"beta");
						break;
				}
				for (k=0;k<2;k++)
				{
					sprintf(STRING,"\t %*s: %.4f [%.4f,%.4f] %s\n",
						TITLE_LENGTH,FUNCTXT[k],OFUNC[i].OPAR[k],
						OFUNC[i].OPARLIM[k][0],OFUNC[i].OPARLIM[k][1],
						yesnostr(OFUNC[i].OPARPEN[k]));
					type_line(STRING);
					if (OFUNC[i].type==0) k=1;
				}
			}
			break;
		case 20:
			list_menu("SET ADS FUNCTIONS",set_functions_menu,set_functions_length);
			break;
		case 21:
			stop=TRUE;
			break;
		}
	}
	}

/***************************************************************************/
void    rob_set_par(void)
/***************************************************************************/

    /*    Set parameters determining the rod calculation.
	Robach's extension parameters only :
	LSHIFT, ERF roughness model, SCALE3, plus range checking
	on SURF2FRAC */
	/* add220800
	new parameters : 	flag for variable NLAYERS
				rms roughness sigma
	*/
	/* add160201 : 
		 flag for multiplying or not Fsurf by roughness factor */
    {
    /* define rob_set_par_menu */

#define rob_set_par_length 10	/* nb of commands in rob_set_par menu */

    static struct   MENU rob_set_par_menu[rob_set_par_length] =
	{
	"erfrough",  1,  1, "Use approx erf model for roughness",
	"lshift",    2,  2, "Lshift between exp and theory",
	"sc3ale",    3,  3, "Scale factor for frac orders", 
	"s2urffrac", 2,  4, "Frac. of rec. surf. with 2nd unit cell",
	"varnlayer", 1,  5, "Use variable NLAYERS from data file",
	"sigma",     2,  6, "Rms roughness - only for var. NLAYERS",
 	"fsurfrough",1,  7, "apply bulk roughness to fsurf",
	"list",      1, 20, "List parameters",
	"help",      1, 30, "Display menu",
	"return",    1, 31, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];
    char    *item;
	
	int erf_rough_flag;

	while (!stop)
	{
	if (!get_token(token,"ROD.EXT.ROB.SET.PAR>")) break;
	switch (cmnd_match(token,rob_set_par_menu,rob_set_par_length))
	{
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		if (ROUGHMODEL==APPROXERF) erf_rough_flag=1;
		else erf_rough_flag=0;
		sprintf(STRING,
		    "Use approximated erf model for roughness [%s]: ",
		    yesnostr(erf_rough_flag));
		erf_rough_flag = yesno(erf_rough_flag,STRING);
		if (erf_rough_flag == 1) ROUGHMODEL=APPROXERF;
		break;
	    case 2:
		sprintf(STRING,
		"Lshift [%4.2f]: ",LSHIFT);
		LSHIFT = get_real(LSHIFT,STRING);
 		sprintf(STRING,
		    "Lower limit of lshift [%4.2f]: ", LSHIFTLIM[0]);
	    	LSHIFTLIM[0] = get_real(LSHIFTLIM[0], STRING);
	    	sprintf(STRING,
		    "Upper limit of lshift [%4.2f]: ", LSHIFTLIM[1]);
	 	LSHIFTLIM[1] = get_real(LSHIFTLIM[1], STRING);
		sprintf(STRING,
	    	"Range checking on lshift [%s]: ", yesnostr(LSHIFTPEN));
	    	LSHIFTPEN = yesno(LSHIFTPEN, STRING);
	    	break;
	    case 3:
		sprintf(STRING,
		"Scale factor of fractionnal orders [%4.2f]: ",SCALE3);
		SCALE3 = get_real(SCALE3,STRING);
		sprintf(STRING,
		    "Lower limit of scale 3 factor [%4.2f]: ", SCALE3LIM[0]);
	    	SCALE3LIM[0] = get_real(SCALE3LIM[0], STRING);
	    	sprintf(STRING,
		    "Upper limit of scale 3 factor [%4.2f]: ", SCALE3LIM[1]);
	    	SCALE3LIM[1] = get_real(SCALE3LIM[1], STRING);
	    	sprintf(STRING,
	    	"Range checking on scale 3 factor [%s]: ", yesnostr(SCALE3PEN));
	    	SCALE3PEN = yesno(SCALE3PEN, STRING);
	    	break;
	case 4:
	    	sprintf(STRING,
			"fraction S2 of rec. surface that is rec. with the 2nd unit cell [%4.2f]: ",
			SURF2FRAC);
	    	SURF2FRAC = get_real(SURF2FRAC, STRING);
	    	sprintf(STRING,
	    		"Lower limit of S2 [%4.2f]: ", SURF2FRACLIM[0]);
	    	SURF2FRACLIM[0] = get_real(SURF2FRACLIM[0], STRING);
	    	sprintf(STRING,
	    		"Upper limit of S2 [%4.2f]: ", SURF2FRACLIM[1]);
	    	SURF2FRACLIM[1] = get_real(SURF2FRACLIM[1], STRING);
	    	sprintf(STRING,
			    "Range checking on S2 [%s] ",
		yesnostr(SURF2FRACPEN));
		SURF2FRACPEN = yesno(SURF2FRACPEN, STRING);
		break;
		case 5:
			if (ROUGHMODEL != APPROXBETA)
			{
			    	errtype("ERROR, this works only with the approx beta roughness model");
				var_nlayers = 0;
			    	break;
			}
			sprintf(STRING,"use variable NLAYERS in roughness calculation [%s]: ", 
				yesnostr(var_nlayers));
			var_nlayers = yesno(var_nlayers,STRING);
			break;
		case 6:
			if (ROUGHMODEL != APPROXBETA)
			{
			    	errtype("ERROR, this works only with the approx beta roughness model");
				var_nlayers = 0;
			    	break;
			}
			if (var_nlayers == 0)
			{
			    	errtype("ERROR, this works only when using a variable NLAYERS");
				SIGMA = 0;
			    	break;
			}
			sprintf(STRING,
				"RMS Roughness parameter sigma [%4.2f]: ",SIGMA);
			SIGMA = get_real(SIGMA,STRING);
			sprintf(STRING,
				"Lower limit of rms roughness parameter [%4.2f]: ",SIGMALIM[0]);
			SIGMALIM[0] = get_real(SIGMALIM[0],STRING);
			sprintf(STRING,
				"Upper limit of rms roughness parameter [%4.2f]: ",SIGMALIM[1]);
			SIGMALIM[1] = get_real(SIGMALIM[1],STRING);
			sprintf(STRING,
				"Range checking on rms roughness parameter [%s]: ",
		    		yesnostr(SIGMAPEN));
			SIGMAPEN = yesno(SIGMAPEN,STRING);
			break;
		case 7:
			if (ROUGHMODEL == EXACTBETA)
			{
			    	errtype("ERROR, this option does not work for exact beta roughness");
				roughfsurf_flag = 1;
			    	break;
			}	
			sprintf(STRING,"multiply Fsurf by bulk roughness factor [%s]: ", 
				yesnostr(roughfsurf_flag));
			roughfsurf_flag = yesno(roughfsurf_flag,STRING);
			break;
	    	case 20:
		if (ROUGHMODEL==APPROXERF) erf_rough_flag=1;
		else erf_rough_flag=0;
		sprintf(STRING,
		    "Use approximated erf model for roughness: %s \n",
		    yesnostr(erf_rough_flag));
		type_line(STRING);
		sprintf(STRING,
		   "multiply fsurf by bulk roughness factor : %s \n",
		    yesnostr(roughfsurf_flag));
		type_line(STRING);
    		sprintf(STRING,
    			"scale factor of fractional orders: %8.4f [%8.4f,%8.4f] %s\n",
		    	SCALE3, SCALE3LIM[0], SCALE3LIM[1], yesnostr(SCALE3PEN));
    		type_line(STRING);
    		sprintf(STRING,
    			"Lshift: %8.4f [%8.4f,%8.4f] %s\n",
	    		LSHIFT, LSHIFTLIM[0], LSHIFTLIM[1], yesnostr(LSHIFTPEN));
    		type_line(STRING);
		sprintf(STRING,
    			"fract. of rec. surface rec. with 2nd unit cell: %8.4f [%8.4f,%8.4f] %s\n",
	    		SURF2FRAC, SURF2FRACLIM[0], SURF2FRACLIM[1],
	    		yesnostr(SURF2FRACPEN));
	    	type_line(STRING);
		if (var_nlayers==1)
		{
			sprintf(STRING,"Use variable NLAYERS from data file.\n");
			type_line(STRING);
	    		sprintf(STRING,
    			"rms roughness sigma : %8.4f [%8.4f,%8.4f] %s\n",
		    	SIGMA, SIGMALIM[0], SIGMALIM[1], yesnostr(SIGMAPEN));
    			type_line(STRING);
		}
		else if (var_nlayers==0)
		{
			sprintf(STRING,"Use fixed NLAYERS.\n");
			type_line(STRING);
	
		}
		break;
	case 30:
		list_menu("ROBACH SET PARAMETERS",
		    rob_set_par_menu,rob_set_par_length);
		break;
	case 31:
		stop = TRUE;
	}
	}
    }

/* add270201*/
/***************************************************************************/
void set_slab(void)
/***************************************************************************/

 /*    Set slab model for binary alloy.    */
{
    /* define set_slab_menu */

#define set_slab_length 8	/* number of commands in set_slab menu */

    static struct MENU set_slab_menu[set_slab_length] =
    {
	"atoms",     2,  1, "choose the 2 alloy atoms and their dz",
	"nslab",     1,  2, "sets the number of slabs",
	"parameters",2,  3, "set the parameters of a slab",
	"reset",     3,  4, "remove all slabs",	
	"list",      1, 28, "List parameters",
	"lmodel",    2, 29, "List slab model",
	"help",      1, 30, "Display menu",
	"return",    1, 31, "Return to main menu"
    };

    int stop = FALSE;
    char token[100];
    char *item;
	int i, k;

    while (!stop) {
	if (!get_token(token, "ROD.EXT.ROB.SET.SLA>"))
	    break;
	switch (cmnd_match(token, set_slab_menu, set_slab_length)) {
	case -1:
	    break;
	case 0:
	    break;
	case 1:
		for (i=0; i<2 ; i++)
		{
			alloy_atom[i]++;
			sprintf(STRING,"alloy atom number %d is atom number [%d] in fit file ?: ",
				i+1,alloy_atom[i]);
			alloy_atom[i]= get_int(alloy_atom[i],STRING);
			if ((alloy_atom[i]> NSURFTOT)||(alloy_atom[i]<1))
			{
		    		errtype("ERROR, can't be zero or larger than total # of atoms");
		    		alloy_atom[i] = 10000;
			}
			if (EXTAT[alloy_atom[i]].MODE)
			{
		    		errtype("ERROR, extended atoms can not be alloy atoms");
		    		alloy_atom[i] = 10000;
			}
			if ((NOCCUP[alloy_atom[i]]>0)||(NOCCUP2[alloy_atom[i]]>0))
			{
		    		errtype("ERROR, alloy atoms should have snocc1=snocc2=0");
		    		alloy_atom[i] = 10000;
			}
			alloy_atom[i]--;
			if (alloy_atom[1]==alloy_atom[0])
			{
		    		errtype("ERROR, the two alloy atoms should be distinct");
		    		alloy_atom[i] = 10000;
			}
			sprintf(STRING,"bulk interlayer spacing for alloy atom # %d [%4.4f] (in bulk units): ",
				i+1, dz_bulk[i]);
			dz_bulk[i] = get_real(dz_bulk[i],STRING);
		}
		break;
	case 2:
		sprintf(STRING,"total number of slabs [%1d]: ",NSLAB);
		NSLAB= get_int(NSLAB,STRING);
		if (NSUBSTRATE > MAXSLAB)
		{
		    	errtype("ERROR, can't be larger than max number of slabs");
		    	NSLAB = 0;
		}
		break;

	case 3:
		if (NSLAB < 1)
		{
	    		errtype("ERROR, set NSLAB>0 first");
	    		break;
		}
		k=get_int(0,"slab number: ");
		if ((k>NSLAB)||(k<1))
		{
	    		errtype("ERROR, slab number should be between 1 and NSLAB");
	    		break;
		}
		if (k!=0)
		{
			k-=1;
			sprintf(SLABTXT[0],"%2s fraction",ELEMENT[TS[alloy_atom[0]]]);
			sprintf(SLABTXT[1],"occmax (%2s + %2s)",ELEMENT[TS[alloy_atom[0]]],ELEMENT[TS[alloy_atom[1]]]);
			sprintf(SLABTXT[2],"slab thickness");
			sprintf(SLABTXT[3],"top roughness");
			for (i=0;i<4;i++)
			{
				sprintf(STRING,"%*s [%.4f]: ",TITLE_LENGTH, SLABTXT[i], SLAB[k].SPAR[i]);
				SLAB[k].SPAR[i]=get_real(SLAB[k].SPAR[i],STRING);
				if (SLAB[k].SPAR[2]<0.0)
				{
			    		errtype("WARNING : thickness is < 0, automatically reset to >0");
	    				SLAB[k].SPAR[2]=-SLAB[k].SPAR[2];
				}
				if ((SLAB[k].SPAR[0]<0.0)||(SLAB[k].SPAR[0]>1.0))
				{
			    		errtype("WARNING : x should be between 0 and 1");
	    				break;
				}
				sprintf(STRING,"%*s low limit [%.4f]: ",TITLE_LENGTH, SLABTXT[i], SLAB[k].SPARLIM[i][0]);
				SLAB[k].SPARLIM[i][0]=get_real(SLAB[k].SPARLIM[i][0],STRING);
				sprintf(STRING,"%*s high limit [%.4f]: ",TITLE_LENGTH, SLABTXT[i],SLAB[k].SPARLIM[i][1]);
				SLAB[k].SPARLIM[i][1]=get_real(SLAB[k].SPARLIM[i][1],STRING);
				sprintf(STRING,"range checking for %*s [%s]: ",TITLE_LENGTH, SLABTXT[i],yesnostr(SLAB[k].SPARPEN[i]));
				SLAB[k].SPARPEN[i]=yesno(SLAB[k].SPARPEN[i],STRING);
			}
		}
		break;
	case 4:
		NSLAB = 0;
  	 	for (k=0; k<MAXSLAB ; k++)
	   	{
			for (i=0; i<4 ; i++)
			{
				SLAB[k].SPAR[i]=0.0;
				SLAB[k].SPARLIM[i][0]=0.0;
				SLAB[k].SPARLIM[i][1]=0.0;
				SLAB[k].SPARPEN[i]=0;
			}
	   	}
		alloy_atom[0]=10000;
		alloy_atom[1]=10000;
		dz_bulk[0]=1.0;
		dz_bulk[1]=1.0;		
		break;
	case 28:	    
		if (NSLAB>0)
		{
			sprintf(STRING,"Number of slabs = %1d\n",NSLAB);
			type_line(STRING);    
			for (i=0;i<2;i++)
			{
				sprintf(STRING,"alloy atom number %d is number : %d (%2s) in fit file\n",
				i+1,alloy_atom[i]+1,ELEMENT[TS[alloy_atom[i]]]);
				type_line(STRING);
				sprintf(STRING,"dz_bulk for %2s = %.4f (in bulk units)\n",
				ELEMENT[TS[alloy_atom[i]]], dz_bulk[i]);
				type_line(STRING);
			}
			sprintf(STRING,"Units of thickness and roughness = number of planes\n");
			type_line(STRING);
			sprintf(STRING,"but thickness and roughness can have non-integer values\n");
			type_line(STRING);
			sprintf(STRING,"The roughness is for the TOP surface of the slab \n");
			type_line(STRING);
			sprintf(STRING,"In all slabs : %2s fraction = (1 - %2s fraction).\n",
					ELEMENT[TS[alloy_atom[1]]],ELEMENT[TS[alloy_atom[2]]]);
			type_line(STRING);
			sprintf(STRING,"\nSlabs:\n");
			type_line(STRING);
			sprintf(SLABTXT[0],"%2s fraction",ELEMENT[TS[alloy_atom[0]]]);
			sprintf(SLABTXT[1],"occmax (%2s + %2s)",ELEMENT[TS[alloy_atom[0]]],ELEMENT[TS[alloy_atom[1]]]);
			sprintf(SLABTXT[2],"slab thickness");
			sprintf(SLABTXT[3],"top roughness");
			for (k=0;k<NSLAB;k++)
			{
				sprintf(STRING,"slab #%d :\n",k+1);
				type_line(STRING);
				for (i=0;i<4;i++)
				{
					sprintf(STRING,"\t %*s : %.4f [%.4f,%.4f] %s\n",TITLE_LENGTH,
						SLABTXT[i], SLAB[k].SPAR[i],SLAB[k].SPARLIM[i][0],
					SLAB[k].SPARLIM[i][1],	yesnostr(SLAB[k].SPARPEN[i]));
					type_line(STRING);
				}
			}
		}                	
		else 	if (NSLAB < 1)
		{
			type_line("no slabs defined \n");	
		}
		break;
	case 29:
		if (NSLAB>0) list_slab_model();
		else	type_line("no slabs defined \n");	
		break;		
	case 30:
	    list_menu("ROBACH SET SLAB MENU", set_slab_menu, set_slab_length);
	    break;
	case 31:
	    stop = TRUE;
	}
    }
}
/* endadd270201 */

/***************************************************************************/
void    rob_set_fit(void)
/***************************************************************************/

    /*
    Set fit parameters of surface atoms.
	Robach's version includes ZCONST, Z2CONST and NZ2DIS
	for linked z-displacements
    add230800 : deal with NOCCUP2
    */

    {

    /* define rob_set_fit_menu */

#define rob_set_fit_length 26      /* number of commands in rob_set_fit menu */

    static struct   MENU rob_set_fit_menu[rob_set_fit_length] =
	{
	"element",    1,  1,	"Element type of atom",
	"xstart",     1,  2, 	"Start x-position",
	"xconstant",  2,  3, 	"Mult. factor of x-displacement",
	"xdisplace",  2,  4, 	"Serial # of x-displacement parameter",
	"x2constant", 3,  5, 	"Mult. factor of 2nd x-displ.",
	"x2displace", 3,  6, 	"Serial # of 2nd x-displacement par.",
	"ystart",     1,  7, 	"Start y-position",
	"yconstant",  2,  8, 	"Mult. factor of y-displacement",
	"ydisplace",  2,  9, 	"Serial # of y-displacement parameter",
	"y2constant", 3, 10, 	"Mult. factor of 2nd y-displ.",
	"y2displace", 3, 11, 	"Serial # of 2nd y-displacement par.",
	"zstart",     1, 12, 	"Start z-position",
	"zconstant",  2, 21, 	"Mult. factor of z-displacement",
	"zdisplace",  2, 13, 	"Serial # of z-displacement parameter",
	"z2constant", 3, 22, 	"Mult. factor of 2nd z-displ.",
	"z2displace", 3, 23, 	"Serial # of 2nd z-displacement par.",
	"b1",         2, 14, 	"Serial # of in-plane Debye-Waller par",
	"b2",         2, 15, 	"Serial # of out-of-plane D-W par",
	"occupancy",  1, 16, 	"Serial # of occupancy parameter",
	"o2ccupancy", 2, 17, 	"Serial # of 2nd occ. parameter",
	"add",        1, 18, 	"Add an atom to model",
	"delete",     1, 19, 	"Delete an atom from model",
	"fullmodel",  1, 20, 	"Show extended model yes/no",
	"list",       1, 30, 	"List atoms",
	"help",       1, 31,	"Display menu",
	"return",     1, 32,	"Return to main menu"
    };

    int stop = FALSE;
    char token[100];
    int natom, i, newtype;
    char element[3];

    while (!stop) {
	if (!get_token(token, "ROD.EXT.ROB.SET.FIT>"))
	    break;
	switch (cmnd_match(token, rob_set_fit_menu, rob_set_fit_length)) {
	case -1:
	    break;
	case 0:
	    break;
	case 1:
	    natom = get_natom("Atom number: ");
	    get_token(element, "Element type: ");
	    toupper(element[0]);
	    tolower(element[1]);

	    /* Check whether this is a new element type */

	    newtype = TRUE;
	    for (i = 0; i < NTYPES; i++) {
		if (el_equal(element, ELEMENT[i])) {
		    newtype = FALSE;
		    TS[natom - 1] = i;
		}
	    }
	    if (newtype) {
		if (NTYPES == MAXTYPES) {
		    errtype("ERROR, too many atom types");
		    break;
		}
		NTYPES++;
		get_coeff(element, F_COEFF[NTYPES - 1]);
		if (F_COEFF[NTYPES - 1][0] == 0.) {
		    NTYPES--;
		    TS[natom - 1] = 0;
		} else {
		    sprintf(ELEMENT[NTYPES - 1], "%s", element);
		    TS[natom - 1] = NTYPES - 1;
		}
	    }
	    break;
	case 2:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING, "Start x-position of surface atom [%5.3f]: ",
		    XS[natom - 1]);
	    XS[natom - 1] = get_real(XS[natom - 1], STRING);
	    break;
	case 3:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Multiplication factor of x-displacement [%5.2f]: ",
		    XCONST[natom - 1]);
	    XCONST[natom - 1] = get_real(XCONST[natom - 1], STRING);
	    break;
	case 4:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Serial number of x-displacement parameter [%1d]: ",
		    NXDIS[natom - 1]);
	    NXDIS[natom - 1] = get_int(NXDIS[natom - 1], STRING);
	    if (NXDIS[natom - 1] > NDISTOT)
		NDISTOT = NXDIS[natom - 1];
	    break;
	case 5:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		 "Multiplication factor of 2nd x-displacement [%5.2f]: ",
		    X2CONST[natom - 1]);
	    X2CONST[natom - 1] = get_real(X2CONST[natom - 1], STRING);
	    break;
	case 6:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		 "Serial number of 2nd x-displacement parameter [%1d]: ",
		    NX2DIS[natom - 1]);
	    NX2DIS[natom - 1] = get_int(NX2DIS[natom - 1], STRING);
	    if (NX2DIS[natom - 1] > NDISTOT)
		NDISTOT = NX2DIS[natom - 1];
	    break;
	case 7:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING, "Start y-position of surface atom [%5.3f]: ",
		    YS[natom - 1]);
	    YS[natom - 1] = get_real(YS[natom - 1], STRING);
	    break;
	case 8:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Multiplication factor of y-displacement [%5.2f]: ",
		    YCONST[natom - 1]);
	    YCONST[natom - 1] = get_real(YCONST[natom - 1], STRING);
	    break;
	case 9:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Serial number of y-displacement parameter [%1d]: ",
		    NYDIS[natom - 1]);
	    NYDIS[natom - 1] = get_int(NYDIS[natom - 1], STRING);
	    if (NYDIS[natom - 1] > NDISTOT)
		NDISTOT = NYDIS[natom - 1];
	    break;
	case 10:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		 "Multiplication factor of 2nd y-displacement [%5.2f]: ",
		    Y2CONST[natom - 1]);
	    Y2CONST[natom - 1] = get_real(Y2CONST[natom - 1], STRING);
	    break;
	case 11:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		 "Serial number of 2nd y-displacement parameter [%1d]: ",
		    NY2DIS[natom - 1]);
	    NY2DIS[natom - 1] = get_int(NY2DIS[natom - 1], STRING);
	    if (NY2DIS[natom - 1] > NDISTOT)
		NDISTOT = NY2DIS[natom - 1];
	    break;
	case 12:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING, "Start z-position of surface atom [%5.3f]: ",
		    ZS[natom - 1]);
	    ZS[natom - 1] = get_real(ZS[natom - 1], STRING);
	    break;
      case 21:
            natom = get_natom("Atom number: ");
            sprintf(STRING,
                    "Multiplication factor of z-displacement [%5.2f]: ",
                    ZCONST[natom - 1]);
            ZCONST[natom - 1] = get_real(ZCONST[natom - 1], STRING);
            break;
	case 13:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Serial number of z-displacement parameter [%1d]: ",
		    NZDIS[natom - 1]);
	    NZDIS[natom - 1] = get_int(NZDIS[natom - 1], STRING);
	    if (NZDIS[natom - 1] > NDISTOT)
		NDISTOT = NZDIS[natom - 1];
	    break;
        case 22:
            natom = get_natom("Atom number: ");
            sprintf(STRING,
                    "Multiplication factor of 2nd. z-displacement [%5.2f]: ",
                    Z2CONST[natom - 1]);
            Z2CONST[natom - 1] = get_real(Z2CONST[natom - 1], STRING);
            break;
        case 23:
            natom = get_natom("Atom number: ");
            sprintf(STRING,
                    "Serial number of 2nd. z-displacement parameter [%1d]: ",
                    NZ2DIS[natom - 1]);
            NZ2DIS[natom - 1] = get_int(NZ2DIS[natom - 1], STRING);
            if (NZ2DIS[natom - 1] > NDISTOT)
                NDISTOT = NZ2DIS[natom - 1];
            break;
	case 14:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
	      "Serial number of parallel Debye-Waller parameter [%1d]: ",
		    NDWS[natom - 1]);
	    NDWS[natom - 1] = get_int(NDWS[natom - 1], STRING);
	    if (NDWS[natom - 1] > NDWTOT)
		NDWTOT = NDWS[natom - 1];
	    break;
	case 15:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Serial number of perpendicular Debye-Waller parameter [%1d]: ",
		    NDWS2[natom - 1]);
	    NDWS2[natom - 1] = get_int(NDWS2[natom - 1], STRING);
	    if (NDWS2[natom - 1] > NDWTOT2)
		NDWTOT2 = NDWS2[natom - 1];
	    break;
	case 16:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Serial number of occupancy parameter [%1d]: ",
		    NOCCUP[natom - 1]);
	    NOCCUP[natom - 1] = get_int(NOCCUP[natom - 1], STRING);
	    if (NOCCUP[natom - 1] > NOCCTOT)
		NOCCTOT = NOCCUP[natom - 1];
	    break;
	case 17:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Serial number of 2nd occ. parameter [%1d]: ",
		    NOCCUP2[natom - 1]);
	    NOCCUP2[natom - 1] = get_int(NOCCUP2[natom - 1], STRING);
	    if (NOCCUP2[natom - 1] > NOCCTOT)
		NOCCTOT = NOCCUP2[natom - 1];
	    break;
	case 18:
	    if (NSURFTOT == MAXATOMS) {
		errtype("Maximum number of atoms in model reached");
		break;
	    }
	    NSURFTOT++;
	    natom = get_natom("Atom number: ");
	    if (natom <= NSURF + 1)
		NSURF++;
	    else
		NSURF2++;

	    /* Make room for new atom */

	    for (i = NSURFTOT - 1; i > natom - 1; i--) {
		TS[i] = TS[i - 1];
		XS[i] = XS[i - 1];
		XCONST[i] = XCONST[i - 1];
		NXDIS[i] = NXDIS[i - 1];
		X2CONST[i] = X2CONST[i - 1];
		NX2DIS[i] = NX2DIS[i - 1];
		YS[i] = YS[i - 1];
		YCONST[i] = YCONST[i - 1];
		NYDIS[i] = NYDIS[i - 1];
		Y2CONST[i] = Y2CONST[i - 1];
		NY2DIS[i] = NY2DIS[i - 1];
		ZS[i] = ZS[i - 1];
		ZCONST[i] = ZCONST[i - 1];
		NZDIS[i] = NZDIS[i - 1];
		Z2CONST[i] = Z2CONST[i - 1];
		NZ2DIS[i] = NZ2DIS[i - 1];
		NDWS[i] = NDWS[i - 1];
		NDWS2[i] = NDWS2[i - 1];
		NOCCUP[i] = NOCCUP[i - 1];
		NOCCUP2[i] = NOCCUP2[i - 1];
	    }

	    /* Initialize parameters for new atom */

	    TS[natom - 1] = 0;
	    XS[natom - 1] = 0;
	    XCONST[natom - 1] = 0;
	    NXDIS[natom - 1] = 0;
	    X2CONST[natom - 1] = 0;
	    NX2DIS[natom - 1] = 0;
	    YS[natom - 1] = 0;
	    YCONST[natom - 1] = 0;
	    NYDIS[natom - 1] = 0;
	    Y2CONST[natom - 1] = 0;
	    NY2DIS[natom - 1] = 0;
	    ZS[natom - 1] = 0;
	    ZCONST[natom - 1] = 0;
	    NZDIS[natom - 1] = 0;
	    Z2CONST[natom - 1] = 0;
	    NZ2DIS[natom - 1] = 0;
	    NDWS[natom - 1] = 0;
	    NDWS2[natom - 1] = 0;
	    NOCCUP[natom - 1] = 0;
	    NOCCUP2[natom - 1] = 0;
	    break;
	case 19:
	    natom = get_natom("Atom number: ");
	    if (natom <= NSURF)
		NSURF--;
	    else
		NSURF2--;
	    NSURFTOT--;

	    /* Shift atoms with higher serial numbers */

	    for (i = natom - 1; i < NSURFTOT - 1; i++) {
		TS[i] = TS[i + 1];
		XS[i] = XS[i + 1];
		XCONST[i] = XCONST[i + 1];
		NXDIS[i] = NXDIS[i + 1];
		X2CONST[i] = X2CONST[i + 1];
		NX2DIS[i] = NX2DIS[i + 1];
		YS[i] = YS[i + 1];
		YCONST[i] = YCONST[i + 1];
		NYDIS[i] = NYDIS[i + 1];
		Y2CONST[i] = Y2CONST[i + 1];
		NY2DIS[i] = NY2DIS[i + 1];
		ZS[i] = ZS[i + 1];
		ZCONST[i] = ZCONST[i + 1];
		NZDIS[i] = NZDIS[i + 1];
		Z2CONST[i] = Z2CONST[i + 1];
		NZ2DIS[i] = NZ2DIS[i + 1];
		NDWS[i] = NDWS[i + 1];
		NDWS2[i] = NDWS2[i + 1];
		NOCCUP[i] = NOCCUP[i + 1];
		NOCCUP2[i] = NOCCUP2[i + 1];
	    }
	    break;
	case 20:
	    sprintf(STRING, "Show extended model [%s]: ",
		    yesnostr(FULLMODEL));
	    FULLMODEL = yesno(FULLMODEL, STRING);
	    break;
	case 30:
	    clear_screen();
	    if (FULLMODEL) {
		sprintf(STRING,
			"%1s %2s %2s %6s %5s %7s %6s %2s %6s %5s %7s %6s %2s %6s %5s %7s %6s %4s %5s %4s %5s\n",
			"#", "el",
			"xs", "xconst", "nxdis", "x2const", "nx2dis",
			"ys", "yconst", "nydis", "y2const", "ny2dis",
			"zs", "zconst", "nzdis", "z2const", "nz2dis", "ndw", "ndw2", "nocc", "nocc2");
	    } else {
		sprintf(STRING,
			"%1s %2s %2s %6s %5s %7s %6s %2s %6s %5s %7s %6s %2s %5s %4s %5s %4s\n",
			"#", "el",
			"xs", "xconst", "nxdis", "x2const", "nx2dis",
			"ys", "yconst", "nydis", "y2const", "ny2dis",
			"zs", "nzdis", "ndw", "ndw2", "nocc");
	    }
	    type_line(STRING);
	    for (i = 0; i < NSURFTOT; i++) {
		if (FULLMODEL) {
		    sprintf(STRING,
			"%2d %2s %7.4f %5.2f %2d %5.2f %3d %8.4f %6.2f %3d %6.2f %3d %8.4f %6.2f %3d %6.2f %3d %3d %3d %3d %3d\n",
			i + 1, ELEMENT[TS[i]],
		      XS[i], XCONST[i], NXDIS[i], X2CONST[i], NX2DIS[i],
		      YS[i], YCONST[i], NYDIS[i], Y2CONST[i], NY2DIS[i],
			ZS[i], ZCONST[i], NZDIS[i], Z2CONST[i], NZ2DIS[i],
			NDWS[i], NDWS2[i], NOCCUP[i], NOCCUP2[i]);
		} else {
		    sprintf(STRING,
			    "%2d %2s %7.4f %6.3f %2d %7.4f %6.3f %2d %7.4f %2d %2d %2d %2d\n",
			    i + 1, ELEMENT[TS[i]],
			    XS[i], XCONST[i], NXDIS[i],
			    YS[i], YCONST[i], NYDIS[i],
			  ZS[i], NZDIS[i], NDWS[i], NDWS2[i], NOCCUP[i]);
		}
		type_line(STRING);
	    }
	    break;
	case 31:
	    list_menu("ROBACH SET FIT MENU",
		      rob_set_fit_menu, rob_set_fit_length);
	    break;
	case 32:
	    stop = TRUE;
	}
    }
    update_model();
}

/* add100901 */
/***************************************************************************/
void set_anomalous(void)
/***************************************************************************/

 /*    Set parameters for correcting the atomic scattering factor
	near an absorption edge.
	Now the atomic scattering factor will be a complex.
	Here the routine is designed for Pt LIII edge.    */

{
    /* define set_anomalous_menu */

#define set_anomalous_length 5	/* number of commands in set_anomalous menu */

    static struct MENU set_anomalous_menu[set_anomalous_length] =
    {
	"mode",      1,  1, "calculation in normal/anomalous mode",
	"parameters",2,  2, "set the anomalous parameters",
	"list",      1, 29, "List parameters",
	"help",      1, 30, "Display menu",
	"return",    1, 31, "Return to main menu"
    };

    int stop = FALSE;
    char token[100];
    char *item;
	int i, k;

    while (!stop) {
	if (!get_token(token, "ROD.EXT.ROB.SET.ANOM>"))
	    break;
	switch (cmnd_match(token, set_anomalous_menu, set_anomalous_length)) {
	case -1:
	    break;
	case 0:
	    break;
	case 1:
		sprintf(STRING,"Use anomalous scattering factor for Pt [%s]: ", 
			yesnostr(anomalous_flag));
		anomalous_flag = yesno(anomalous_flag,STRING);
		break;
	case 2:
		if (anomalous_flag == REAL_fat)	
		{
	    		errtype("ERROR, this works only in anomalous mode ");
	    		break;
		}
		/* need to finish writing this part */
		break;
	case 29:	    
		if (anomalous_flag == REAL_fat)
		{
			sprintf(STRING,
		  	"Use standard atomic scattering factors, far from edges\n");
			type_line(STRING);
		}
		else if (anomalous_flag == COMPLEX_fat)
		{
			sprintf(STRING,
		  	"Use anomalous atomic scattering factor for Pt\n");
			type_line(STRING);
			sprintf(STRING,"Anomalous parameters : \n");
			type_line(STRING);
    			sprintf(STRING,"x-ray energy : %8.4f eV \n",LIII);
    			type_line(STRING);
    			sprintf(STRING,"resonance width : %8.4f \n",gamma_width);
    			type_line(STRING);
    			sprintf(STRING,"nc parameter of f' : %8.4f \n",NC);
    			type_line(STRING);
    			sprintf(STRING,"ncs parameter of f' and f'' : %8.4f \n",NCS);
    			type_line(STRING);
    			sprintf(STRING,"ns parameter of f'' : %8.4f \n",NS);
    			type_line(STRING);
    			sprintf(STRING,"np parameter of ares : %8.4f \n",NP);
    			type_line(STRING);
			if (diffraction_mode == SPECULAR)
			{
				sprintf(STRING,"diffraction mode = specular\n");
				type_line(STRING);
			}
			else if (diffraction_mode == FIXED_INCIDENCE)
			{
				sprintf(STRING,"diffraction mode = fixed incidence\n");
				type_line(STRING);
			}
		}
		break;
	case 30:
	    list_menu("ROBACH SET ANOM MENU", set_anomalous_menu, set_anomalous_length);
	    break;
	case 31:
	    stop = TRUE;
	}
    }
}
/* endadd100901 */

/* end of set.c part */

/* list.c part */

/***************************************************************************/
void list_ext_model(void)
/***************************************************************************/

     /*   List atoms positions and occupancies 
		for the extended model,  on terminal or file. */
	/* add230800 OCCUPTOT */
{
  int stop = FALSE;
  char token[100];
  int switch_code, i, j;
  FILE *listfile;
  int terminal;
  char filename[FILENAME_MAX], extension[10];
  float b1, b2;
  float occ,xeff,yeff,zeff,occtot,occref;
  int n, atom;
  char    *itemo, *itemz;
 
  sprintf (extension, "isl");

  /* Ask for filename */

  sprintf (STRING, "Filename (.%s) (type 't' or <return> for terminal): ",
	   extension);
  if (!get_token (filename, STRING)) terminal = TRUE;
  else if (((filename[0] == 't') || (filename[0] == 'T')) &&
	   (filename[1] == '\0')) terminal = TRUE;
  else
  {
      terminal = FALSE;
      add_extension (filename, extension);
      if ((listfile = fopen (filename, "w")) == NULL)
	{
	  sprintf (STRING, "Error, failed to open '%s'", filename);
	  errtype (STRING);
	  clear_command ();
	  return;
	}
      else
	{
	  get_string (STRING, "Comments: ");
	  if (switch_code != 10)
	    fprintf (listfile, "%s\n", STRING);
	  else
	    fprintf (listfile, "!%s\n", STRING);
	}
  }

  /* Do the actual listing */
  sprintf(STRING,"Atom\tEl\tPlane\tX\tY \tZ\tOcc\n");
  if (terminal) type_line(STRING);
  else fprintf(listfile,STRING);
  sprintf(STRING,"first surface unit cell :\n");
  if (terminal) type_line(STRING);
  else fprintf(listfile,STRING);

  for (i=0;i<NSURFTOT;i++)
  {
	if ((NSURF2!=0)&&(i==NSURF))
	{
		sprintf(STRING,"\n");
		if (terminal) type_line(STRING);
		else fprintf(listfile,STRING);
		sprintf(STRING,"2nd surface unit cell\n");
		if (terminal) type_line(STRING);
		else fprintf(listfile,STRING);
	}
	if (EXTAT[i].MODE)
	{
		/*calculate each plane occupancy for atom i and coordinates*/
		occtot=0;
		switch (OFUNC[EXTAT[i].ODIS-1].type)
		{
			case 0: /* uniform occupancy - fit on occtot */
			case 1: /* erf(z) occupancy 1st version - fit on occtot */
			case 3:/* exp(z) occupancy  - fit on occtot */
				occtot=0;
				for (n=0;n<EXTAT[i].NPLANS;n++)
				{
                             	get(i,n,&xeff,&yeff,&zeff,&occ);
					occtot+=occ;
				}
				for (n=0;n<EXTAT[i].NPLANS;n++)
				{
      	      		get(i,n,&xeff,&yeff,&zeff,&occ);
					if (occtot>1e-6) occ*=OCCUPTOT[i]/occtot;
					else occ=0;
					sprintf(STRING,"%d\t%2s\t%d\t%.4f\t%.4f\t%.4f\t%.4f\t\n",i+1,ELEMENT[TS[i]],n,xeff,yeff,zeff,occ);
					if (terminal) type_line(STRING);
					else fprintf(listfile,STRING);
				}
				sprintf(STRING,"Total occupancy for atom %d: %.4f\n",i+1,OCCUPTOT[i]);
				if (terminal) type_line(STRING);
				else fprintf(listfile,STRING);					
				break;
			case 2: /* gauss(z) occupancy - fit on occtot */
				occtot=0;
				for (n=-EXTAT[i].NPLANS+1;n<EXTAT[i].NPLANS;n++) 
				{
                              get(i,n,&xeff,&yeff,&zeff,&occ);
					occtot+=occ;
				}
				for (n=-EXTAT[i].NPLANS+1;n<EXTAT[i].NPLANS;n++) 
				{
                       	      get(i,n,&xeff,&yeff,&zeff,&occ);
					if (occtot>1e-6) occ*=OCCUPTOT[i]/occtot;
					else occ=0;
					sprintf(STRING,"%d\t%2s\t%d\t%.4f\t%.4f\t%.4f\t%.4f\t\n",i+1,ELEMENT[TS[i]],n,xeff,yeff,zeff,occ);
					if (terminal) type_line(STRING);
					else fprintf(listfile,STRING);
				}
				sprintf(STRING,"Total occupancy for atom %d: %.4f\n",i+1,OCCUPTOT[i]);
				if (terminal) type_line(STRING);
				else fprintf(listfile,STRING);
				break;                        
			case 4: /* erf(z) occupancy 2nd version - fit on occ(n=0)*/
			case 5: /* uniform the beta^n occupancy - fit on occ(n=0)*/
			 	  /* in case 5 occref=1 all the time */
                        occref=0;
                       	get(i,0,&xeff,&yeff,&zeff,&occ);
              		occref=occ;
				for (n=0;n<EXTAT[i].NPLANS;n++)
				{
                             	get(i,n,&xeff,&yeff,&zeff,&occ);
	            		if (occref>1e-6) occ*=OCCUPTOT[i]/occref;
      	   			else occ=0;
            	     		sprintf(STRING,"%d\t%2s\t%d\t%.4f\t%.4f\t%.4f\t%.4f\t\n",i+1,ELEMENT[TS[i]],n,xeff,yeff,zeff,occ);
					if (terminal) type_line(STRING);
					else fprintf(listfile,STRING);
					occtot+=occ;
				}
				sprintf(STRING,"Total occupancy for atom %d: %.4f\n",i+1,occtot);
				if (terminal) type_line(STRING);
				else fprintf(listfile,STRING);
				break;
			default:
				errtype("Error: unknown occupancy model");
				break;
		}
		switch (OFUNC[EXTAT[i].ODIS-1].type)
		{
			case 0: itemo = "uniform occupancy"; break;
			case 1: itemo = "erfc occupancy with fit on total occ"; break;
			case 2: itemo = "gauss occupancy"; break;
			case 3: itemo = "exp occupancy"; break;
 			case 4: itemo = "erfc occupancy with fit on 1st plane occ"; break;
 			case 5: itemo = "uniform then beta^n occ with fit on 1st plane occ"; break;
			default: itemo = "unknown"; break;
		}
		switch(ZFUNC[EXTAT[i].ZDIS-1].type)
		{
	 		case 0: itemz = "no relaxation"; break;
	 		case 1: itemz = "exp relaxation"; break;
			case 2: itemz = "erfc relaxation, param. linked to occ function"; break;
			case 3: itemz = "erfc relaxation, indep. param."; break;					sprintf(STRING,"%d: erfc relaxation, indep. param. \n",i+1);
			default: itemz = "unknown";break;
		}
		sprintf(STRING,"extended atom %d :\nofunction SN %d type=%s\nzfunction SN %d type=%s\n",
				i+1,EXTAT[i].ODIS,itemo,EXTAT[i].ZDIS,itemz);
		if (terminal) type_line(STRING);
		else fprintf(listfile,STRING);
	}
	else
	{
		/* if (!NOCCUP[i]) occ=1; 
		else  */ /* removed 070103 */
		occ=OCCUPTOT[i];
		if (terminal)
		{
			sprintf(STRING,"%d\t%2s\t\t%.4f\t%.4f\t%.4f\t%.4f\n",
				i+1,ELEMENT[TS[i]],XSFIT[i],YSFIT[i],ZSFIT[i],occ);
			type_line(STRING);
		}
		else fprintf(listfile,"%d\t%2s\t\t%.4f\t%.4f\t%.4f\t%.4f\n",
				i+1,ELEMENT[TS[i]],XSFIT[i],YSFIT[i],ZSFIT[i],occ);
	}
  }
  if (!terminal) fclose (listfile);
}
/* add270201 */
/***************************************************************************/
void list_slab_model(void)
/***************************************************************************/

     /*   List atoms positions and occupancies 
		for the slab model,  on terminal or file. */
{
  int stop = FALSE;
  int switch_code;
  FILE *listfile;
  int terminal;
  char filename[FILENAME_MAX], extension[10];
  int k, nn ;
  float occ1, occ2;
  float occtot1, occtot2;	
 
  sprintf (extension, "sla");

  /* Ask for filename */

  sprintf (STRING, "Filename (.%s) (type 't' or <return> for terminal): ",
	   extension);
  if (!get_token (filename, STRING)) terminal = TRUE;
  else if (((filename[0] == 't') || (filename[0] == 'T')) &&
	   (filename[1] == '\0')) terminal = TRUE;
  else
  {
      terminal = FALSE;
      add_extension (filename, extension);
      if ((listfile = fopen (filename, "w")) == NULL)
	{
	  sprintf (STRING, "Error, failed to open '%s'", filename);
	  errtype (STRING);
	  clear_command ();
	  return;
	}
      else
	{
	  get_string (STRING, "Comments: ");
	  if (switch_code != 10) fprintf (listfile, "%s\n", STRING);
	  else fprintf (listfile, "!%s\n", STRING);
	}
  }

  /* Do the actual listing */
  sprintf(STRING,"x and y values are fixed to zero for all the atoms. \n");
  if (terminal) type_line(STRING); else fprintf(listfile,STRING);

  sprintf(STRING,"Plane\tz\tocc%2s\tocc%2s\n",ELEMENT[TS[alloy_atom[0]]],
		ELEMENT[TS[alloy_atom[1]]]);
  if (terminal) type_line(STRING); else fprintf(listfile,STRING);

  calc_all_dzs();
  calc_all_zs();		

  for (k=0;k<NSLAB;k++)
  {
	sprintf(STRING,"slab #%d :\n",k+1);
	if (terminal) type_line(STRING); else fprintf(listfile,STRING);
	occtot1=0.0;
	occtot2=0.0;
	for (nn=0; nn<MAXPLANE; nn++)
	{
		get_slab_occ(nn, k, &occ1, &occ2);
		occtot1 += occ1;
		occtot2 += occ2;
		sprintf(STRING,"%d\t%.4f\t%.4f\t%.4f\n",nn,zplane[nn],occ1,occ2);
		if (terminal) type_line(STRING); else fprintf(listfile,STRING);
	}
  	sprintf(STRING,"total of all planes for slab #%d :\n", k+1);
  	if (terminal) type_line(STRING); else fprintf(listfile,STRING);
  	sprintf(STRING,"occ%2s = %.4f occ%2s = %.4f \n",ELEMENT[TS[alloy_atom[0]]],occtot1,
			ELEMENT[TS[alloy_atom[1]]],occtot2);
  	if (terminal) type_line(STRING); else fprintf(listfile,STRING);
  }
  occtot1=0.0;
  occtot2=0.0;		
  sprintf(STRING,"total of all slabs :\n");
  if (terminal) type_line(STRING); else fprintf(listfile,STRING);
  sprintf(STRING,"Plane\tz\tocc%2s\tocc%2s\n",ELEMENT[TS[alloy_atom[0]]],
		ELEMENT[TS[alloy_atom[1]]]);
  if (terminal) type_line(STRING); else fprintf(listfile,STRING);

  for (nn=0; nn<MAXPLANE; nn++)
  {
	sprintf(STRING,"%d\t%.4f\t%.4f\t%.4f\n",nn,zplane[nn],occ1plane[nn],occ2plane[nn]);
	if (terminal) type_line(STRING); else fprintf(listfile,STRING);
	occtot1 += occ1plane[nn];
	occtot2 += occ2plane[nn];
  }		
  sprintf(STRING,"total of all planes for all slabs :\n ");
  if (terminal) type_line(STRING); else fprintf(listfile,STRING);
  sprintf(STRING,"occ%2s = %.4f occ%2s = %.4f \n",ELEMENT[TS[alloy_atom[0]]],occtot1,
			ELEMENT[TS[alloy_atom[1]]],occtot2);
  if (terminal) type_line(STRING); else fprintf(listfile,STRING);

  if (!terminal) fclose (listfile);
}
/* endadd270201 */

/* end of list.c part */

/* calc.c part */
 
/***************************************************************************/
float    f_erf_rough(float x)
/***************************************************************************/

    {
    float norm,dum,rough;
    int ord,n;
	float betarough;

	if (ratio_flag == 1)
	{
		if (deposit_flag == BEFORE_DEPOSIT)  betarough = BETA2;
		else if (deposit_flag == AFTER_DEPOSIT) betarough = BETA ;
	}
	else if (ratio_flag == 0)
		betarough = BETA;
			     
    x*=2*PI;
    ord=(int)(10*betarough);
    norm=1;
    for (n=1;n<ord;n++)
		norm+=exp(-sqr(n/betarough)/2);
    norm*=2;
    rough=1;
    for (n=1;n<ord;n++)
		{
		if (betarough>1e-10) dum=exp(-sqr(n/betarough)/2);
		else 
			{
			if (n!=0) dum=0;
			else dum=1;
			}
		rough+=2*dum*cos(x*n);
		}
    rough=fabs(rough/norm);
    return(rough);
    }

/***************************************************************************/
void    ratio_calc(float h, float k, float l, float atten, float lbragg,
	    float *fsub, float *ftot, float *asratio)
/***************************************************************************/

    /*
    Computes ratio between F(substrate + adsorbate) and F(substrate)
    */
{
	float fbulksub, fsurfsub, fsumsub, phasesub;
	float fbulktot, fsurftot, fsumtot, phasetot;

	deposit_flag = BEFORE_DEPOSIT ;
	f_calc(h,k,l,atten,lbragg,&fbulksub,&fsurfsub,&fsumsub,&phasesub);
	deposit_flag = AFTER_DEPOSIT ;
	f_calc(h,k,l,atten,lbragg,&fbulktot,&fsurftot,&fsumtot,&phasetot);
	*fsub = fsumsub ;
	*ftot = fsumtot;
	if (fsumsub > 1e-6) *asratio = fsumtot / fsumsub ;
	else *asratio = 0. ;
}

/****************************************************************************/
float erfcc(float x)
/* from NR */
/****************************************************************************/
{
	float t,z,ans;

	z=fabs(x);
	t=1.0/(1.0+0.5*z);
	ans=t*exp(-z*z-1.26551223+t*(1.00002368+t*(0.37409196+t*(0.09678418+
		t*(-0.18628806+t*(0.27886807+t*(-1.13520398+t*(1.48851587+
		t*(-0.82215223+t*0.17087277)))))))));
	return  x >= 0.0 ? ans : 2.0-ans;
}

/***************************************************************************/
void get(int i, int n, float *x, float *y, float*z, float *occ)
/***************************************************************************/
{
	int j,neff,zfunc,ofunc,zfunctype,ofunctype;
	div_t layer;
      float reduced,puiss=1,dz; 
	float zmeano,sigmao, dz0, dzinf, sigmaz, zmeanz, zorig ;

	zfunc=EXTAT[i].ZDIS-1;
	zfunctype=ZFUNC[zfunc].type;
	ofunc=EXTAT[i].ODIS-1;
	ofunctype=OFUNC[ofunc].type;

      sigmao=OFUNC[ofunc].OPAR[1]; 
      zmeano=OFUNC[ofunc].OPAR[0]-EXTAT[i].ZSHIFT;
	
	dzinf = ZFUNC[zfunc].ZPAR[0];
	dz0 = ZFUNC[zfunc].ZPAR[1];
	sigmaz = ZFUNC[zfunc].ZPAR[2];
	zmeanz = ZFUNC[zfunc].ZPAR[3];

/* OR150201 : for some reason the div function does not work
with negative n's. I add an offset NLAYERS*NPLANS on n 
to correct for that */
	
	layer=div(n+EXTAT[i].NSTART+EXTAT[i].NLAYERS*EXTAT[i].NPLANS,EXTAT[i].NLAYERS);
	*x=XSFIT[i]+EXTAT[i].XSHIFT[layer.rem];
	*y=YSFIT[i]+EXTAT[i].YSHIFT[layer.rem];

/* debug gauss occ function OR150201 
	sprintf(STRING,"plane number : %d ",n);
	type_line(STRING);
	sprintf(STRING,"x = %.4f ",*x);
	type_line(STRING);
	sprintf(STRING,"y = %.4f\n",*y);
	type_line(STRING);
end of debug 150201*/

	neff=EXTAT[i].NSTART+n;
	zorig = ZSFIT[EXTAT[i].ORIGIN]; 

	switch (zfunctype)
	{         
		case 0: /* no relaxation */
			*z= neff*dzinf;
			*z+= zorig; 
			break;
		case 1: /*exponential relaxation */
			for (j=0;j<neff;j++) puiss*=sigmaz;
			*z= neff*dzinf + (puiss-1)/(sigmaz-1)*(dz0-dzinf);
			*z+= zorig; 
			break; 
		case 2: /*erfc relaxation - 1st version */           
			/* here the z-function has the same parameters "mean z value" 
			and "roughness" as the o_function having the same serial number */

			*z = zorig ;
			dz = 0;
			for (j=0;j<neff;j++)
			{
				if (sigmao > 1e-4)
				{
					reduced=(*z-zmeano)/sqrt(2)/sigmao;
					dz = dzinf + (dz0-dzinf)*erfcc(reduced)/2;                   
				}
				else
				{
					if (*z < zmeano) dz = dz0 ;
					else dz = dzinf ;
				}     
				*z = *z + dz; 
			}
			break;  
		case 3: /*erfc relaxation - 2nd version */           
			/* in this version the parameters "mean z value" and 
			"roughness" of the z-function are independent of those of the o-function*/
	
			*z = zorig ;
			dz = 0;
			for (j=0;j<neff;j++)
			{
				if (sigmaz > 1e-4)
					{
					reduced=(*z-zmeanz)/sqrt(2)/sigmaz;
					dz = dzinf + (dz0-dzinf)*erfcc(reduced)/2;                   
				     }
				else
					{
					if (*z < zmeanz) dz = dz0 ;
					else dz = dzinf ;
					}     
				*z = *z + dz; 
			}
			break;  
		default:
			errtype("Error: unknown relaxation model");
			break;
	}
	/* put "uniform" occupancy as default */	
	if (ofunctype < 5)
	{
		if (*z<=zmeano) *occ=1.0;
		else *occ=0.0;
	}
	else if (ofunctype==5)
	{
		if (neff < (zmeano+1e-4)) *occ=1.0;
		else *occ=0.0;
	}
	switch (ofunctype)
	{
		case 0: /* uniform occupancy */
			break;
		case 1: /* erf(z) occupancy 1st version - fit on occtot */
		case 4: /* erf(z) occupancy 2nd version - fit on occ(n=0)*/
			if (sigmao > 1e-4)
			{
				reduced=(*z-zmeano)/sqrt(2)/sigmao;
				*occ=erfcc(reduced)/2;
				break;
			}			
		case 2: /* gauss(z) occupancy */
			if (sigmao > 1e-4)
			{
	                  reduced=(*z-zmeano)/sqrt(2)/sigmao;
				*occ=exp(-sqr(reduced));
				break;
			}
		case 3: /* exp occupancy */
			if (sigmao > 1e-4)
			{
	                  *occ=exp(-(*z-zmeano)/sigmao);
				break;
			}
		/* add070103 */
		case 5: /* uniform then beta^n occupancy - fit on occ(n=0) */
			  /* here zmeano is a number of plane and beta=sigmao */
			if (sigmao > 1e-4)
			{
				if (neff < (zmeano+1e-4)) *occ = 1.0;
				else *occ = exp((neff-zmeano)*log(sigmao)); /* sigmao ^ (neff-zmeano) */ 
				break;
			}
		/* endadd070103 */
		default:
			errtype("Error: unknown occupancy model");
			break;
	}
}               
/***************************************************************************/
void f_extended(int i, float h, float k, float l, float *re, float *im)
/***************************************************************************/
{
      float occ,xeff,yeff,zeff,dum;
	float occref=0.0;
	float occtot=0.0;
	int n;
	int nmin, nmax;

	float q_par, dw_relax, reduced;
	if (relax_flag==1)
	{
		q_par = q_length(h, k, 0);
		reduced = 2 * log(2) * sqr(q_par*MISFIT*WIDTH/(2*PI));
		dw_relax=exp(-reduced);
	}
	else dw_relax = 1.0;

	*re=*im=0;
	get(i,0,&xeff,&yeff,&zeff,&occ);
	ZSFIT[i]=zeff;
	occref=occ;

	switch (OFUNC[EXTAT[i].ODIS-1].type)
	{
		case 0: /* uniform occupancy - fit on occtot */
		case 1: /* erf(z) occupancy 1st version - fit on occtot */
		case 3:/* exp(z) occupancy - fit on occtot */
		case 4: /* erf(z) occupancy 2nd version - fit on occ(n=0)*/
		case 5: /* uniform then beta^n occ - fit on occ(n=0)*/
			nmin = 0;
			nmax = EXTAT[i].NPLANS;			
			break;
		case 2: /* gauss(z) occupancy */
			nmin = -EXTAT[i].NPLANS+1;
			nmax = EXTAT[i].NPLANS;
			break;
		default:
			errtype("Error: unknown occupancy model");
			break;
	}
	for (n=nmin;n<nmax;n++)
	{
		get (i,n,&xeff,&yeff,&zeff,&occ);
		dum=2*PI*(h*xeff+k*yeff+l*zeff);
		*re+=occ*cos(dum);
		*im+=occ*sin(dum);
		occtot+=occ;
	} 
	switch (OFUNC[EXTAT[i].ODIS-1].type)
	{
		case 0: /* uniform occupancy - fit on occtot */
		case 1: /* erf(z) occupancy 1st version - fit on occtot */
		case 2: /* gauss(z) occupancy - fit on occtot */
		case 3:/* exp(z) occupancy - fit on occtot */
			if (occtot>1e-5)
			{
				*re=*re/occtot;
				*im=*im/occtot;
			}
			break;
		case 4: /* erf(z) occupancy 2nd version - fit on occ(n=0)*/
		case 5: /* uniform then beta^n occ - fit on occ(n=0)*/
	           	if (occref>1e-5)
           		{
                        *re=*re/occref;
                        *im=*im/occref;
              	}
			break;
		default:
			errtype("Error: unknown occupancy model");
			break;
	}

	*re=*re*dw_relax;
	*im=*im*dw_relax;

}

/* add270201*/
/***************************************************************************/
void get_slab_occ(int planenum, int slabnum, float *occ1, float*occ2)
/***************************************************************************/
/* Warning : slabnum is from 0 to NSLAB -1 but user sees slabs from 1 to NSLAB.
Here we take only into account the contribution of slab slabnum to plane planenum.
occ1, occ2 : occupancy of alloy atoms  #1 and #2 respectively */

{
	int k;
      float reducedbot,reducedtop; 
	float nmeanbot, nmeantop, x1, sigmabot, sigmatop, occmax ;
	float occtot;
	float dumbot, dumtop;
 
/* debug 220301 
sprintf(STRING, "slab #%d\n",slabnum);
type_line(STRING);
sprintf(STRING, "plane #%d\n",planenum);
type_line(STRING);
 enddebug 220301 */

	x1 = SLAB[slabnum].SPAR[0];
	occmax = SLAB[slabnum].SPAR[1];

/* debug 220301 
sprintf(STRING, "x1= %.4f\n",x1);
type_line(STRING);
sprintf(STRING, "occmax= %.4f\n",occmax);
type_line(STRING);
 enddebug 220301 */

	if (slabnum==0)	
	{
		nmeantop = SLAB[0].SPAR[2]-1.0;
		sigmatop = SLAB[0].SPAR[3];

/* debug 220301
sprintf(STRING, "nmeantop= %4.4f\n",nmeantop);
type_line(STRING);
sprintf(STRING, "sigmatop= %4.4f\n",sigmatop);
type_line(STRING);
 enddebug 220301 */
		if (sigmatop>1e-4)
		{
            	reducedtop=(planenum-nmeantop)/sqrt(2)/sigmatop;
			occtot = occmax*erfcc(reducedtop)/2;
		}
		else if (sigmatop<=1e-4)
		{
			if (planenum > nmeantop) occtot=0.0;	
			else occtot=occmax;
		}
		*occ1=occtot*x1;
		*occ2=occtot*(1.0-x1);
	}
	else if (slabnum > 0)
	{
		nmeantop = -1.0;
		for (k=0;k<=slabnum;k++) nmeantop += SLAB[k].SPAR[2];
		nmeanbot = nmeantop-SLAB[slabnum].SPAR[2];
		sigmatop = SLAB[slabnum].SPAR[3];
		sigmabot = SLAB[slabnum-1].SPAR[3];

/* debug 220301 
sprintf(STRING, "nmeantop= %4.4f\n",nmeantop);
type_line(STRING);
sprintf(STRING, "sigmatop= %4.4f\n",sigmatop);
type_line(STRING);
sprintf(STRING, "nmeanbot= %4.4f\n",nmeanbot);
type_line(STRING);
sprintf(STRING, "sigmabot= %4.4f\n",sigmabot);
type_line(STRING);
enddebug 220301 */

		if (sigmatop>1e-4)
		{
            	reducedtop=(planenum-nmeantop)/sqrt(2)/sigmatop;
			dumtop=occmax*erfcc(reducedtop)/2;
		}
		else
		{
			if (planenum > nmeantop) dumtop=0.0;	
			else dumtop=occmax;
		}
		if (sigmabot>1e-4)
		{
            	reducedbot=(planenum-nmeanbot)/sqrt(2)/sigmabot;
			dumbot=occmax*erfcc(reducedbot)/2;
		}
		else
		{
			if (planenum > nmeanbot) dumbot=0.0;	
			else dumbot=occmax;
		}
		occtot = dumtop-dumbot;
		*occ1=occtot*x1;
		*occ2=occtot*(1.0-x1);
	}
	if (*occ1<1e-4) *occ1 = 0.0;
	if (*occ2<1e-4) *occ2 = 0.0;
}      
         
/***************************************************************************/
void calc_all_dzs(void)
/***************************************************************************/
/* calculates the dz's of all the planes of the slab model
and also the occ1's and occ2's of all the planes of the model (including all slabs) */
{
	int nn, k;
	float dumocc1, dumocc2;
 	float dz;
	float occ12plane;	

	for (nn=0; nn<MAXPLANE; nn++)
	{
		occ1plane[nn]=0.0;
		occ2plane[nn]=0.0;
		for (k=0 ; k<NSLAB ; k++)
		{
			get_slab_occ(nn,k,&dumocc1,&dumocc2);
			occ1plane[nn] += dumocc1; 			 
			occ2plane[nn] += dumocc2;
		}
		occ12plane=occ1plane[nn]+occ2plane[nn];
	      if (occ12plane > 1e-4)
			dzplane[nn] = (occ1plane[nn]*dz_bulk[0]+occ2plane[nn]*dz_bulk[1])/occ12plane;
		else dzplane[nn] = dz_bulk[1];
	}
}

/***************************************************************************/
void calc_all_zs(void)
/***************************************************************************/
/* warning : if the model has changed, one need to do a calc_all_dzs
before doing a calc_all_z */
/* planenum goes from 0 to MAXPLANE-1 */
/* occ1 (resp. occ2) : total occupancy of plane planenum, 
for alloy element #1 (resp. #2),
including the contribution of all the slabs */
/* The z coordinate of plane planenum is calculated recursively.
The dz between plane planenum-1 and plane planenum is calculated
using Vegards Law applied to the average of occ1(planenum),
occ2(planenum), occ1(planenum-1) and occ2(planenum-1) */
/* the 2 alloy atoms should be at the same ZS in the fit file */

{
	int nn1, nn2;
 	float dz;

/* debug 220301 
sprintf(STRING, "plane #%d\n",planenum);
type_line(STRING);
 enddebug 220301 */

	zplane[0]=ZSFIT[alloy_atom[0]];
	for (nn1=1; nn1<MAXPLANE; nn1++)
	{
		zplane[nn1] = ZSFIT[alloy_atom[0]];
		for (nn2=0; nn2<nn1 ; nn2++)
		{
			dz = 0.5*(dzplane[nn2] + dzplane[nn2+1]);
			zplane[nn1] = zplane[nn1] + dz;
		}
	} 
}               

/***************************************************************************/
void f_slabs(int i, float h, float k, float l, float *re, float *im)
/***************************************************************************/
/* used for each alloy atom */
{
      float dum;
	float xeff, yeff; /* not used for the moment */
	int nn;

	xeff=0.0;
	yeff=0.0;
	*re=*im=0;
	ZSFIT[i] = ZSFIT[alloy_atom[0]]; 

	calc_all_dzs();	
	calc_all_zs();

	if (i==alloy_atom[0])
	{
		for (nn=0;nn<MAXPLANE;nn++)
		{
			dum=2*PI*(h*xeff+k*yeff+l*zplane[nn]);
			*re+=occ1plane[nn]*cos(dum);
			*im+=occ1plane[nn]*sin(dum);
		}
	}
	else if (i==alloy_atom[1])
	{
		for (nn=0;nn<MAXPLANE;nn++)
		{
			dum=2*PI*(h*xeff+k*yeff+l*zplane[nn]);
			*re+=occ2plane[nn]*cos(dum);
			*im+=occ2plane[nn]*sin(dum);
		}
	}
}
/*endadd270201*/

/* add220800 */
/***************************************************************************/
float  calc_nlayer(float h, float k, float l)
/***************************************************************************/
{
	float nlayer;
	int i;
	float dh, dk, dl;
	
	nlayer = NLAYERS;
	for (i=0;i<NDAT;i++)
	{
		dh=fabs(h-HDAT[i]);
		dk=fabs(k-KDAT[i]);
		dl=fabs(l-LDAT[i]);
		if ((dh<1e-2)&&(dk<1e-2)&&(dl<1e-2)) nlayer=NL_OR[i];
	}		
	return(nlayer);
}
/* endadd220800 */

/* end of calc.c part */

#endif /* EXTENSIONS Robach */


#ifdef __cplusplus
}
#endif

/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                        robach_cx.cpp                            $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/***************************************************************************

      - source file written for C++ compilation
	- uses C++ library for dealing with complex numbers
	- the functions take and return only real numbers
	 	but inside them we use complex numbers

****************************************************************************/

#ifdef EXTENSIONS /* Robach */

#include <complex>
using std::complex;

/* variable declaration */

complex<float> ICX(0.0,1.0);	/* the "i" of complex numbers */

/* function prototypes */

void f_bulk_cx(float h, float k, float l, complex<float> fat[], float dw[],
	    float atten, complex<float> fbulk[]);
void f_surf_cx(float h, float k, float l, complex<float> fat[],
	    float dw_par[], float dw_perp[], float dw[], int cell,
	    complex<float> fsurf_cx[]);
void f_bulk_beta_cx(float h, float k, float l, complex<float> fat[], float dw[],
		     complex<float> fbulk_cx[]);

complex<float> anomalous_correction_cx(int i, float h, float k, float l, float xx,
	int epsilon, float nm);

/* calc.c part */

/* add100901 */
/***************************************************************************/
void    f_bulk_cx(float h, float k, float l, complex<float> fat_cx[], float dw[],
	    float atten, complex<float> fbulk_cx[])
/***************************************************************************/

    /*
    Calculate complex structure factor of the
    bulk unit cell for all domains present.
    */

    {
    using std::complex;

    int	i,j;
    float	hnew,knew,argument, fmult;
    complex<float> fbulk1_cx, fatom_cx;

    for (j = 0; j < NDOMAIN; j++)
	{
	fbulk_cx[j]= 0.;
	next_domain(h,k,&hnew,&knew,j);	/* Next equivalent refl. */
	if (!(!ZEROFRACT && ((fmod(hnew,1.) != 0) || (fmod(knew,1.) != 0))))
	    {
	    fbulk1_cx=0.0;
	    for (i = 0; i < NBULK; i++)
		{
		/* the exp is added to fatom in order to avoid numerical
		problems (suggestion by Yves Garreau */
		fatom_cx = fat_cx[TB[i]]*(float)(dw[NDWB[i]]*exp(atten*ZB[i]));
#ifdef EXTENSIONS /* Mcsl */
		if ((mcsl_flag)||(robach_flag))
			if (NOCCUPB[i]!=0)
				fatom_cx *= OCCUP[NOCCUPB[i]-1];
#endif /* EXTENSION Mcsl */
		argument = 2*PI*(hnew*XB[i]+knew*YB[i]+l*ZB[i]);
		fbulk1_cx += fatom_cx*exp(ICX*argument);
		}
	    fbulk_cx[j]=fbulk1_cx/(1.f-(float)exp(-atten)*exp((float)(-2.*PI)*ICX*l)+1e-20f);
	    }
	}
    }

/***************************************************************************/
void    f_surf_cx(float h, float k, float l, complex<float> fat_cx[],
	    float dw_par[], float dw_perp[], float dw[], int cell,
	    complex<float> fsurf_cx[])
/***************************************************************************/

    /*
    Calculate complex structure factor of the
    surface unit cell for all domains present. Depending on the value
    of 'cell', this is done for the first or second surface unit cell.
    */

    {
    using std::complex;

    int	i,j,istart,iend;
    float	hnew,knew;
    complex<float> fatom_cx;

#ifdef EXTENSIONS /* Robach */
	float dum;
	int ii;
	float re_dum, im_dum;
#endif /* EXTENSIONS Robach */

    if (cell == 1)
	{
	istart = 0;
	iend = NSURF;
	}
    else if (cell == 2)
	{
	istart = NSURF;
	iend = NSURF+NSURF2;
	}

    for (j = 0; j < NDOMAIN; j++)
	{
	fsurf_cx[j]=0.0;
	next_domain(h,k,&hnew,&knew,j); /* Next equivalent Miller indices */

	/* Don't compute structure factor if the transformed Miller indices
	are fractional and the corresponding flag is set */

	if (!(ZEROFRACT && ((fmod(hnew,1.) != 0) || (fmod(knew,1.) != 0))))
	    {
	    for (i = istart; i < iend; i++)
		{
/* debug260901 
	sprintf(STRING,"Calculating contribution of atom %d of fit file in f_surf_cx.\n",i);
	type_line(STRING);
	sprintf(STRING,"symbol for this atom is : %2s \n", ELEMENT[TS[i]]);
	type_line(STRING);
enddebug260901 */


		if (NDWS2[i] != 0)
		    {
		    fatom_cx = fat_cx[TS[i]]*dw_par[NDWS[i]]*dw_perp[NDWS2[i]];
		    }
		else
		    {
		    fatom_cx = fat_cx[TS[i]]*dw[NDWS[i]];
		    }
/* add230800 */
#ifdef EXTENSIONS /* Robach & Mcsl */
		if (robach_flag || mcsl_flag)
		{	
			if (NOCCUP[i] != 0) fatom_cx *= OCCUPTOT[i];
		}
		else
#endif
		if (NOCCUP[i] != 0) fatom_cx *= OCCUP[NOCCUP[i]-1];
#ifdef EXTENSIONS /* Robach */
		if (robach_flag)
		{
/* modif OR071100 */
		    if ((ratio_flag == 1)&&(deposit_flag == BEFORE_DEPOSIT))
		    {
			if (NSUBSTRATE > 0) /* if surf. unit cell contains substrate atoms */
			{
/* debug 071100
				sprintf(STRING,"found some substrate atoms in surf. unit cell. \n");
				type_line(STRING);
end debug 071100 */
				for (ii=0; ii<NSUBSTRATE ; ii++)
				{
					if (i == sub_atom[ii]) /* if atom #i is substrate atom #ii */
					{	 
						if (EXTAT[i].MODE) /* if i = extended atom */
		    				{
							f_extended(i,hnew,knew,l,&re_dum,&im_dum);
							fsurf_cx[j] += fatom_cx*(re_dum+ICX*im_dum);
						}
						else  /* if i = normal atom */
			  			{
							dum=2*PI*(hnew*XSFIT[i]+knew*YSFIT[i]+l*ZSFIT[i]); 
							fsurf_cx[j]+=fatom_cx*exp(ICX*dum);
						}
					} 		
		    		}
		    	}
/* debug 071100
			else if (NSUBSTRATE==0) 
			{			
				sprintf(STRING,"found no substrate atoms in surf. unit cell. \n");
				type_line(STRING);
			}
end debug 071100 */
		    }
		    else  /* if ((ratio_flag == 0)||((ratio_flag==1)&&(deposit_flag==AFTER_DEPOSIT))) */
		    {
			/* if i = extended atom */
			if (EXTAT[i].MODE) 
			{	
				f_extended(i,hnew,knew,l,&re_dum,&im_dum);
				fsurf_cx[j]+=fatom_cx*(re_dum+ICX*im_dum);
			}
/* add OR270201 */
			/* if i = alloy atom (in slab model)*/ 
			else if ((NSLAB>0)&&((i==alloy_atom[0])||(i==alloy_atom[1])))		
			{
				f_slabs(i,hnew,knew,l,&re_dum,&im_dum);
				fsurf_cx[j]+=fatom_cx*(re_dum+ICX*im_dum);
			}
/*endadd 270201 */
			/* if i = normal atom */
			else if ((!EXTAT[i].MODE)&&((NSLAB<1)||((i!=alloy_atom[0])&&(i!= alloy_atom[1]))))
			{
				dum=2*PI*(hnew*XSFIT[i]+knew*YSFIT[i]+l*ZSFIT[i]); 
				fsurf_cx[j]+=fatom_cx*exp(ICX*dum);
			}
		    }
		} else {		/* if (robach_flag ==0) */
/* end modif OR071100 */
#endif /* EXTENSIONS Robach */
		fsurf_cx[j] += fatom_cx*exp(ICX*(float)(2*PI*(hnew*XSFIT[i]+knew*YSFIT[i]+l*ZSFIT[i])));
#ifdef EXTENSIONS /* Robach */
		}
#endif /* EXTENSIONS Robach */
		}
	    }
	}
    }
/***************************************************************************/
void    f_bulk_beta_cx(float h, float k, float l, complex<float> fat_cx[], float dw[],
		     complex<float> fbulk_cx[])
/***************************************************************************/

    /*
    complex version of f_bulk_beta

    Robinson's beta roughness model:

    Special function to test the influence of the roughness parameter
    beta. This function does an 'exact' calculation, rather than using
    the general roughness equation. The last atom in the bulk unit cell has
    to be the deepest one (lowest z-coordinate).
    */
{
    using std::complex;

    int	i,j;
    float	hnew,knew,factor,argument;
    float	z0,betapow;
    double dexp;
    complex<float> fbulk1_cx, fatom_cx;	

    for (j = 0; j < NDOMAIN; j++)
    {
	fbulk_cx[j] = 0.0;
	next_domain(h,k,&hnew,&knew,j);	/* Next equivalent refl. */
	if (!(ZEROFRACT && ((fmod(hnew,1.) != 0) || (fmod(knew,1.) != 0))))
	{
	    fbulk1_cx = 0.0;
	    z0 = ZB[NBULK-1];
	    for (i = 0; i < NBULK; i++)
	    {
		/* Calculate layer number of element i */
		dexp = (ZB[i]-z0)*NLAYERS+1.001;
		fatom_cx = (float)pow((double)BETA,dexp)*fat_cx[TB[i]]*dw[NDWB[i]];
		argument = 2*PI*(hnew*XB[i]+knew*YB[i]+l*(ZB[i]+1));
		fbulk1_cx += fatom_cx*exp(ICX*argument);
	    }
	    betapow = pow(BETA,NLAYERS);
	    fbulk_cx[j] = fbulk1_cx / (1.f-betapow*exp(ICX*(float)(2*PI*l))+1e-20f); 	
	}
    }
}
/***************************************************************************/
void    f_calc_cx(float h, float k, float l, float atten, float lbragg,
	    float *fbulk, float *fsurf, float *fsum, float *phase)
/***************************************************************************/

    /*
	  Modified version 100901 to use complex numbers.

    Compute bulk and surface contributions to rod profile, plus the
    interference sum, including the phase, of these two.
    */

    {
    using std::complex;

    float       q,q_par,q_perp;
    float	dw[MAXPAR+1];   /* Debye-Waller factors. dw[0] contains DW
				for atoms without serial DW number, i.e.
				having serial number 0. */
    float	dw_par[MAXPAR+1],dw_perp[MAXPAR+1];
    complex<float>	fat_cx[MAXTYPES];  /* Atomic scattering factors */
    float	scale;
    volatile int i,j;
    complex<float>	fbulk_cx[MAXDOM];
    complex<float>	fsurf_cx[MAXDOM];
    complex<float>	fsurf2_cx[MAXDOM];
    complex<float>	f_bul_cx,f_sur1_cx,f_sur2_cx;
    complex<float> fdom_cx;
    float fsurf2, fsum1, fsum2;
    float	fbulk_sqr_save;
    float       roughness;
#ifdef EXTENSIONS /* Svensson */
    float     dw_group[MAXPAR+1];   /* Group Debye-Waller factors. */
#endif /* EXTENSIONS Svensson */

#ifdef EXTENSIONS /* Robach */
	if (robach_flag) 	l+=LSHIFT;
#endif /* EXTENSIONS Robach */



    /* Compute length of in-plane and out-of-plane momentum transfer */

    q_par = q_length(h,k,0);
    q_perp = q_length(0,0,l);
    // q = sqrt(q_par*q_par+q_perp*q_perp);
    q = q_length(h,k,l);

    /* Compute in-plane Debye-Waller factors */

    if (NDWTOT2 != 0)
       {
       dw_par[0] = 1.;         /* Unit factor if no parameter given */
       for (i = 1; i < NDWTOT+1; i++)
	  {
	  dw_par[i] = exp(-DEBWAL[i-1]*q_par*q_par/PIPI16);
	  }
       }

    /* Compute out-of-plane Debye-Waller factors */

    dw_perp[0] = 1.;         /* Unit factor if no parameter given */
    for (i = 1; i < NDWTOT2+1; i++)
       {
       dw_perp[i] = exp(-DEBWAL2[i-1]*q_perp*q_perp/PIPI16);
       }

    /* In case NDWS2[i] = 0, isotropic Debye-Waller parameters are assumed.
    Then the total momentum transfer is used together with the value of
    DEBWAL. */

    dw[0] = 1.;            /* Unit factor if no parameter given */
    for (i = 1; i < NDWTOT+1; i++)
       {
       dw[i] = exp(-DEBWAL[i-1]*q*q/PIPI16);
       }
#ifdef EXTENSIONS /* Svensson */
    if (svensson_flag)
    {
      dw_group[0] = 1.;            /* Unit factor if no parameter given */
      for (i = 1; i < NDWGROUPSTOT+1; i++)
      {
	dw_group[i] = exp(-DEBWALGROUPS[i-1]*q*q/PIPI16);
      }
    }
#endif /* EXTENSIONS Svensson */

    /* Compute atomic scattering factors */

    for (i = 0; i < NTYPES; i++)
       {
       fat_cx[i] = f_atomic(q/2,i)+ anomalous_correction_cx(i,h,k,l,0.0,1,0.0);
       }

    /* Compute intensity reduction due to roughness */

    roughness = calc_roughness(h,k,l,lbragg);

    /* Compute scale factor, a negative lbragg means a separate scale
    factor */

#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
	{
 		if (lbragg < 0)
		{
			scale = SCALE*SCALE3;
			roughness = 1.0;
		}
    		else	scale = SCALE;
	}
	else
#endif /* EXTENSIONS Robach */
    if (lbragg < 0)
	scale = SCALE*SCALE2;
    else
	scale = SCALE;

    /* Compute bulk structure factor */

    if (NBULK > 0)
       {
       f_bulk_cx(h,k,l,fat_cx,dw,atten,fbulk_cx);
       *fbulk = 0.0;
       for (j = 0; j < NDOMAIN; j++)
	   *fbulk += DOMOCCUP[j]*norm(fbulk_cx[j]);
       fbulk_sqr_save = *fbulk;
       *fbulk = scale*roughness*sqrt(*fbulk);
       }
    else
       {
       fbulk_sqr_save = *fbulk = 0.0;
       for (j = 0; j < NDOMAIN; j++)
	   fbulk_cx[j]=0.0;
       }

    /* Compute surface structure factor of 1st unit cell for all
    present domains */

    f_surf_cx(h,k,l,fat_cx,dw_par,dw_perp,dw,1,fsurf_cx);
#ifdef EXTENSIONS /* Svensson */
  /*  if (svensson_flag)
    {
      f_surf_svensson(h,k,l,fat,dw_par,dw_perp,dw,dw_group,1,re_surf,im_surf);
    } */
#endif /* EXTENSIONS Svensson */
#ifdef EXTENSIONS /* Robach 160201 */
	if (robach_flag)
	{
		if (!roughfsurf_flag)
		{
			for (j = 0; j < NDOMAIN; j++)
				fsurf_cx[j]= fsurf_cx[j] /roughness ;
 		}		
	}	
#endif /* EXTENSIONS Robach */
    *fsurf = 0.0;
    for (j = 0; j < NDOMAIN; j++)
	*fsurf += DOMOCCUP[j]*norm(fsurf_cx[j]);
    *fsurf = scale*roughness*sqrt(*fsurf*SURFFRAC*(1-SURF2FRAC));

    /* Calculate surface structure factor for 2nd surface unit cell */

    if (NSURF2 != 0)
	{
	f_surf_cx(h,k,l,fat_cx,dw_par,dw_perp,dw,2,fsurf2_cx);
#ifdef EXTENSIONS /* Svensson */
 /*	if (svensson_flag)
	{
	  f_surf_svensson(h,k,l,fat,dw_par,dw_perp,dw,dw_group,2,re_surf2,im_surf2);
	} */
#endif /* EXTENSIONS Svensson */
#ifdef EXTENSIONS /* Robach 160201 */
	if (robach_flag)
	{
		if (!roughfsurf_flag)
		{
			for (j = 0; j < NDOMAIN; j++)
				fsurf2_cx[j]= fsurf2_cx[j] /roughness ;
		}		
	}
#endif /* EXTENSIONS Robach */
	fsurf2 = 0.0;
	for (j = 0; j < NDOMAIN; j++)
	    fsurf2 += DOMOCCUP[j]*norm(fsurf2_cx[j]);
	fsurf2 = scale*roughness*sqrt(fsurf2*SURFFRAC*SURF2FRAC);
	*fsurf = sqrt(sqr(*fsurf)+sqr(fsurf2));
	}

    /* This is only for test purposes for the time being */
    if (ROUGHMODEL == EXACTBETA)
	f_bulk_beta_cx(h,k,l,fat_cx,dw,fsurf_cx);

    /* Compute interference sum of bulk and surface. */

    fsum1 = 0.0; 
    fdom_cx = 0.0;
    for (j = 0; j < NDOMAIN; j++)
       {
       if (COHERENTDOMAINS == FALSE)
	  {
	  fsum1 += DOMOCCUP[j]*norm(fbulk_cx[j]+fsurf_cx[j]);
	  }
       else
	  {
	  fdom_cx += DOMOCCUP[j]*(fbulk_cx[j]+fsurf_cx[j]);
	  fsum1 = norm(fdom_cx);
	  }
       }

    *fsum = scale*roughness*sqrt(fsum1*SURFFRAC*(1.0-SURF2FRAC)+
	    (1.0-SURFFRAC)*fbulk_sqr_save);

    /* Add corresponding fraction of 2nd surface unit cell to the result
    if necessary */

    if (NSURF2 != 0)
       {
       fsum2 = 0.0;
	 fdom_cx = 0.0;
       for (j = 0; j < NDOMAIN; j++)
	  {
	  if (COHERENTDOMAINS == FALSE)
	     {
	     fsum2 += DOMOCCUP[j]*norm(fbulk_cx[j]+fsurf2_cx[j]);
	     }
	  else
	     {
	     fdom_cx += DOMOCCUP[j]*(fbulk_cx[j]+fsurf2_cx[j]);
	     fsum2 = norm(fdom_cx);
	     }
	  }

	  fsum2 = scale*roughness*sqrt(fsum2*SURFFRAC*SURF2FRAC);
	  *fsum = sqrt(sqr(*fsum)+sqr(fsum2));
       }

    /* Calculate the phase factor of the interference sum */

    f_bul_cx = 0.0;
    for (i = 0; i < NDOMAIN; i++)
       {
       f_bul_cx += DOMOCCUP[i]*fbulk_cx[i];
       }

    f_sur1_cx = 0.0;
    for (i = 0; i < NDOMAIN; i++)
       {
       f_sur1_cx += DOMOCCUP[i]*fsurf_cx[i];
       }

    f_sur2_cx = 0.0;
    if (NSURF2 != 0)
       {
       for (i = 0; i < NDOMAIN; i++)
	  {
	  f_sur2_cx += DOMOCCUP[i]*fsurf2_cx[i];
	  }
       }
	/* l'expression de la phase est un peu curieuse : ailleurs
	dans le calcul on utilise toujours une
	addition INCOHERENTE des contributions des mailles 1 et 2 */

    *phase = arg(f_bul_cx+SURFFRAC*(1.f-SURF2FRAC)*f_sur1_cx+SURFFRAC*SURF2FRAC*f_sur2_cx);

    if (!STRUCFAC)
       {
       *fbulk *= *fbulk;
       *fsurf *= *fsurf;
       *fsum *= *fsum;
       }
    }

#ifdef SPEEDUP
/***************************************************************************/
float	f_calc_fit_cx(float h, float k, float l, float lbragg, float q_par,
	float q_perp, float re_fat[], float im_fat[], 
		float re_bulk[], float im_bulk[], float fbulk_sqr)
/***************************************************************************/

    /*
    Special version of f_calc that stores constant values (in particular
    the bulk structure factors) and is therefore faster when fitting.
    */

    {
    using std::complex;

    float       roughness=1.;
    float	dw[MAXPAR+1];   /* Debye-Waller factors. dw[0] contains DW
				for atoms without serial DW number, i.e.
				having serial number 0. */
    float	dw_par[MAXPAR+1],dw_perp[MAXPAR+1];
    float	scale;
    static int 	i,j;
    complex<float> fsurf_cx[MAXDOM], fdom_cx;
    complex<float> fsurf2_cx[MAXDOM];
    float fsurf2,fsum,fsum1,fsum2;
    complex<float> frough_cx;
    static float	prod, sum;

    complex<float> fbulk_cx[MAXDOM];
    complex<float> fat_cx[MAXTYPES];		

	for (j = 0; j < NTYPES; j++)
			fat_cx[j] = re_fat[j]+ICX*im_fat[j];
	for (j = 0; j < NDOMAIN; j++)
			fbulk_cx[j] = re_bulk[j]+ICX*im_bulk[j];
	
#ifdef EXTENSIONS /* Svensson */
    float     dw_group[MAXPAR+1];   /* Group Debye-Waller factors. */
#endif /* EXTENSIONS Svensson */

#ifdef EXTENSIONS /* Robach */
	if (robach_flag) l+=LSHIFT;
#endif /* EXTENSIONS Robach */

    /* Compute in-plane Debye-Waller factors */

    if (NDWTOT2 != 0)
	{
	dw_par[0] = 1.;         /* Unit factor if no parameter given */
	for (i = 1; i < NDWTOT+1; i++)
	    {
	    dw_par[i] = exp(-DEBWAL[i-1]*q_par*q_par/PIPI16);
	    }
	}

    /* Compute out-of-plane Debye-Waller factors */

    dw_perp[0] = 1.;         /* Unit factor if no parameter given */
    for (i = 1; i < NDWTOT2+1; i++)
	{
	dw_perp[i] = exp(-DEBWAL2[i-1]*q_perp*q_perp/PIPI16);
	}

    /* In case NDWS2[i] = 0, isotropic Debye-Waller parameters are assumed.
    Then the total momentum transfer is used together with the value of
    DEBWAL. */

    dw[0] = 1.;            /* Unit factor if no parameter given */
    for (i = 1; i < NDWTOT+1; i++)
	{
	prod= -DEBWAL[i-1];
	sum = q_par*q_par+q_perp*q_perp; /* Not correct for things like KDP(101) */
	prod *= sum;
	prod /= PIPI16;
	exp(1.);
	dw[i] = exp(prod);
	}

#ifdef EXTENSIONS /* Svensson */
    if (svensson_flag)
    {
      dw_group[0] = 1.;            /* Unit factor if no parameter given */
      for (i = 1; i < NDWGROUPSTOT+1; i++)
      {
	prod= -DEBWALGROUPS[i-1];
	sum = q_par*q_par+q_perp*q_perp; /* Not correct for things like KDP(101) */
	prod *= sum;
	prod /= PIPI16;
	exp(1.);
	dw_group[i] = exp(prod);
      }
    }
#endif /* EXTENSIONS Svensson */

    /* Compute intensity reduction due to roughness */

    roughness = calc_roughness(h,k,l,lbragg);

    /* Compute scale factor, a negative lbragg means a separate scale
    factor */

#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
	{
 		if (lbragg < 0)
		{
			scale = SCALE*SCALE3;
			roughness = 1.0;
		}
    		else	scale = SCALE;
	}
	else
#endif /* EXTENSIONS Robach */
    if (lbragg < 0)
	scale = SCALE*SCALE2;
    else
	scale = SCALE;


    /* Compute surface structure factor of 1st unit cell for all
    present domains */

    f_surf_cx(h,k,l,fat_cx,dw_par,dw_perp,dw,1,fsurf_cx);
#ifdef EXTENSIONS /* Svensson */
/*    if (svensson_flag)
    {
      f_surf_svensson(h,k,l,fat,dw_par,dw_perp,dw,dw_group,1,re_surf,im_surf);
    } */
#endif /* EXTENSIONS Svensson */
#ifdef EXTENSIONS /* Robach 160201 */
	if (robach_flag)
	{
		if (!roughfsurf_flag)
		{
			for (j = 0; j < NDOMAIN; j++)
			{
				fsurf_cx[j]= fsurf_cx[j] /roughness ;
			}
		}		
	}
#endif /* EXTENSIONS Robach */

    /* Calculate surface structure factor for 2nd surface unit cell */

    if (NSURF2 != 0)
	{
	  f_surf_cx(h,k,l,fat_cx,dw_par,dw_perp,dw,2,fsurf2_cx);
#ifdef EXTENSIONS /* Svensson */
/*	  if (svensson_flag)
	  {
	    f_surf_svensson(h,k,l,fat,dw_par,dw_perp,dw,dw_group,2,re_surf2,im_surf2);
	  } */
#endif /* EXTENSIONS Svensson */
#ifdef EXTENSIONS /* Robach 160201 */
	if (robach_flag)
	{
		if (!roughfsurf_flag)
		{
			for (j = 0; j < NDOMAIN; j++)
			{
				fsurf2_cx[j]= fsurf2_cx[j] /roughness ;
			}
		}		
	}
#endif /* EXTENSIONS Robach */
	}

    /* This is only for test purposes for the time being */
    if (ROUGHMODEL == EXACTBETA)
	f_bulk_beta_cx(h,k,l,fat_cx,dw,fsurf_cx);

    /* Compute interference sum of bulk and surface. */

    fsum1 = 0.0;
    fdom_cx = 0.0;
    for (j = 0; j < NDOMAIN; j++)
       {
       if (COHERENTDOMAINS == FALSE)
	  {
	  fsum1 += DOMOCCUP[j]*norm(fbulk_cx[j]+fsurf_cx[j]);
	  }
       else
	  {
	  fdom_cx += DOMOCCUP[j]*(fbulk_cx[j]+fsurf_cx[j]);
	  fsum1 = norm(fdom_cx);
	  }
       }

    fsum = scale*roughness*sqrt(fsum1*SURFFRAC*(1-SURF2FRAC)+
	    (1-SURFFRAC)*fbulk_sqr);

    /* Add corresponding fraction of 2nd surface unit cell to the result
    if necessary */

    if (NSURF2 != 0)
       {
       fsum2 = 0.0;
	 fdom_cx = 0.0;
       for (j = 0; j < NDOMAIN; j++)
	  {
	  if (COHERENTDOMAINS == FALSE)
	     {
	     fsum2 += DOMOCCUP[j]*norm(fbulk_cx[j]+fsurf2_cx[j]);
	     }
	  else
	     {
	     fdom_cx += DOMOCCUP[j]*(fbulk_cx[j]+fsurf2_cx[j]);
	     fsum2 = norm(fdom_cx);
	     }
	  }
	  fsum2 = scale*roughness*sqrt(fsum2*SURFFRAC*SURF2FRAC);
	  fsum = sqrt(sqr(fsum)+sqr(fsum2));
       }

    if (STRUCFAC)
	return(fsum);
    else
	return(fsum*fsum);

    }
/***************************************************************************/
void	f_calc_fit_init_cx(void)
/***************************************************************************/

    /*
    Store constant parameter values to speedup fitting.
		modif OR 100901 to use complex fat
    */

{
    using std::complex;
    int	i,j;
    float	q,dw[MAXPAR+1],fbulk;

    complex<float> fbulk_cx[MAXDOM];
    complex<float> fat_cx[MAXTYPES];		

	for (j = 0; j < NTYPES; j++)
				fat_cx[j] = 0.0;
	for (j = 0; j < NDOMAIN; j++)
				fbulk_cx[j] = 0.0;

    	for (i = 0; i < NDAT; i++)
	{
/* debug260901
	sprintf(STRING,"%8.4f  ",LDAT[i]);
	type_line(STRING);
enddebug260901 */
		Q_PAR[i] = q_length(HDAT[i],KDAT[i],0);
		Q_PERP[i] = q_length(0,0,LDAT[i]);
		/* q = sqrt(Q_PAR[i]*Q_PAR[i]+Q_PERP[i]*Q_PERP[i]); */
		q = q_length(HDAT[i],KDAT[i],LDAT[i]);

/* debug260901 
	sprintf(STRING,"%8.4f  ", q);
	type_line(STRING);
enddebug260901 */


		dw[0] = 1.;            /* Unit factor if no parameter given */
		for (j = 1; j < NDWTOT+1; j++)
		    {
		    dw[j] = exp(-DEBWAL[j-1]*q*q/PIPI16);
		    }

		/* Compute atomic scattering factors */

		for (j = 0; j < NTYPES; j++)
	    	{
/* debug260901 
	sprintf(STRING,"Calculating atomic scattering factor of atom type %d in f_calc_fit_init_cx.\n",j);
	type_line(STRING);
	sprintf(STRING,"symbol for this atom is : %2s \n", ELEMENT[j]);
	type_line(STRING);
 enddebug260901 */

	    		fat_cx[j] = f_atomic(q/2,j)+ anomalous_correction_cx(j,HDAT[i],KDAT[i],LDAT[i],0.0,1,0.0);
			RE_FAT[i][j] = real(fat_cx[j]);
			IM_FAT[i][j] = imag(fat_cx[j]);

/* debug260901
	sprintf(STRING,"%8.4f  %8.4f  ",RE_FAT[i][j],IM_FAT[i][j]);
	type_line(STRING);
enddebug260901 */
	    	}

/* debug260901
	sprintf(STRING,"\n");
	type_line(STRING);
enddebug260901 */

		/* Compute bulk structure factor */

		if (NBULK > 0)
    		{
	    		f_bulk_cx(HDAT[i],KDAT[i],LDAT[i],fat_cx,dw,
				ATTEN,fbulk_cx);
		    	fbulk = 0.0;
			for (j = 0; j < NDOMAIN; j++)
			{
				fbulk += norm(fbulk_cx[j]);
				RE_BULK[i][j]=real(fbulk_cx[j]);
				IM_BULK[i][j]=imag(fbulk_cx[j]);
			}
	    		FBULK_SQR[i] = fbulk/NDOMAIN;
	    	}
		else
	    	{
	    		FBULK_SQR[i] = 0.0;
			for (j = 0; j < NDOMAIN; j++)
			{
				RE_BULK[i][j] = 0.0;
				IM_BULK[i][j] = 0.0;
			}
	    	}
	}
}

#endif

/***************************************************************************/
complex<float> anomalous_correction_cx(int i, float h, float k, float l, float xx,
	int epsilon, float nm)
/***************************************************************************/

	/* applies only to Pt at resonance near LIII edge for the moment */

	/* log = logarithm with base e */
	/* expression of fmagoverfpol for FIXED_INCIDENCE mode is temporary,
	applies only to the case MU=0.0 */
	/* i : from 0 to NTYPES-1 */
{
        using std::complex;

	float fp, fs;
	float fmagoverfpol;
	float lambda, gamma, delta, q_par;
	complex<float> nonres_corr_cx;
	complex<float> ares_cx ;
	complex<float> tot_corr_cx ; 

	fp = 0.0;
	fs = 0.0;
	fmagoverfpol = 0.0;
	lambda = 0.0;
	gamma = 0.0;
	q_par = 0.0;
	nonres_corr_cx = 0.0;
	ares_cx = 0.0;
	tot_corr_cx = 0.0;	

	if (el_equal(ELEMENT[i],"Pt"))
	{
/* debug260901 
	sprintf(STRING,"Element identified as Pt.\n");
	type_line(STRING);
 enddebug260901 */
		
		lambda = 12398/(LIII-xx*gamma_width/2.0);
		
		if (diffraction_mode == SPECULAR)
		{
			gamma = asin(l*RLAT[2]*lambda/(4.0*PI));
			fmagoverfpol = -tan(2.0*gamma);
		}
		else if (diffraction_mode == FIXED_INCIDENCE)
		{
			MU = 0.0 ;	
			q_par = q_length(h,k,0);
			gamma = asin(l*RLAT[2]*lambda/(2.0*PI)- sin(MU/RAD)); 

/* modif201202 : correct error qpar*k instead of qpar divided by k in calculation of delta */

			delta = acos(
			(sqr(cos(MU/RAD))+sqr(cos(gamma))-sqr(q_par*lambda/(2.0*PI)))
			/(2.0*cos(MU/RAD)*cos(gamma))
			);
			
			fmagoverfpol = -tan(gamma)*cos(delta); 	
		}
	
/* modif201202 : take value of fPt at x=0 averaged over monochromator's energy width
instead of taking fPt at x=0 directly */

/*		fp = NC + (NS/2.0)*log(1.0+xx*xx);
		fs = NCS + (NS/PI)*(atan(-xx)+PI/2.0);
*/
		fp = -19.84;
		fs = 8.25;

		nonres_corr_cx = fp - ICX*fs;
/*	 
		ares_cx = ((ICX + xx)/(1.0 + xx*xx))*(-NP+ICX*epsilon*nm*fmagoverfpol);
*/
		ares_cx = 0.668f*ICX*(-NP+ICX*(float)(epsilon*nm*fmagoverfpol));

		tot_corr_cx = nonres_corr_cx + ares_cx;
	}
	return(tot_corr_cx);
}

/* endadd100901 */

/* end of calc.c part */

#endif /* EXTENSIONS Robach */


