/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                        mcsl.c                                  $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: mcsl.c,v 1.12 2006/03/28 15:56:36 wilcke Exp $

****************************************************************************/

/***************************************************************************
Update 22/03/2006 R. Wilcke (wilcke@esrf.fr)
                  modified code for MacIntosh MACOSX using predefined macro
                  __APPLE__ for this architecture;
                  removed check for __CYGWIN__ since __unix is now defined
                  in Cygwin 1.X.
Update 19/01/2004 R. Wilcke (wilcke@esrf.fr) 
                  removed declarations of fopen() (is declared in "stdio.h").
Update 18/12/2002 Chris Walker <walker@esrf.fr> 
                  Initialise zsplanmoy so it will always start at 0. Otherwise
                  random values taken off the stack resulting in odd z values.
Update 25/03/2002 R. Wilcke (wilcke@esrf.fr)
                  mcsl(), save_fit_result(), mcsl_set_fit(), loop_fit_mcsl(),
                  and set_loop_fit(): changed abbreviations for menu commands
                  to the agreed set.
Update 16/01/2001 M.C. Saint Lager (stlager@polycnrs-gre.fr)
                  => 2 plot functions
             	  - set_plot_mcsl : called in the menu rod.set.plot.fb>
             	  	 	    to set color, unit ... for plot of the two 
             	  		    theoretical & experimental structure factor
            	  - plot_sfac_mcsl: is called instead of plot_sfac_mcsl
             	  		    for "fb" option  in the plot menu;

 		  => little changes in the output file menu

		  => fit_auto() is transfered in fit.c
Update 25/10/2000 O.Svensson (svensson@esrf.fr)
                  Added new function mcsl_init().
Update 02/10/2000 O.Svensson (svensson@esrf.fr)
                  Spelling mistake correction, desactivte -> deactivate
Update 19/07/2000 R. Wilcke (wilcke@esrf.fr)
                  replaced everywhere the buffer size for filenames by
                  the ISO-C defined macro FILENAME_MAX.
  2000/08
   	- activates/desactivate MCSL's extension
	- for this extension :
		- open a file to save the fit results
****************************************************************************/


/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#include <ctype.h>
#define SET
#include "rod.h"


#define PLOT
#define METRIC
#define GRAPHIC
#define XL      18.             /* length of x-axis in cm */
#define YL      12.             /* length of y-axis in cm */


#define LARGE_PENALTY 1e4	/* useful penalty factor */
#define NO_PENALTY    0
#define FIT
#include "../lsqfit/lsqfit.h"

#ifdef EXTENSIONS  /* MCSL */


/* main part */

/***************************************************************************/
void    mcsl(void)
/***************************************************************************/

    /*    MCSL's extension menu.    */
    {




	/* define MCSL menu */

#define mcsl_length 6       /* number of commands in mcsl menu */

    static struct   MENU mcsl_menu[mcsl_length] =
	{
	"activate",1,  1, "activate/deactivate MCSL's extension",
	"outfile", 1,  2, "go to save fit results menu",
	"set",	   1,  3, "set fit parameters",
	"loop",	   2, 10, "automatic fitting",
	"help",    1, 20, "Display menu",
	"return",  1, 21, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];

    while (!stop)
	{
	if (!get_token(token,"ROD.EXT.MCSL>")) break;
	switch (cmnd_match(token,mcsl_menu,mcsl_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		sprintf(STRING,"Activate MCSL's extensions ? [%s]: ",
			yesnostr(mcsl_flag));
		mcsl_flag = yesno(mcsl_flag,STRING);
		break;
	    case 2:
		if (mcsl_flag == 0)
		    {
		    errtype("ERROR, MCSL's extension deactivated");
		    clear_command();
		    break;
		    }
		save_fit_result();
		break;

		case 3:
			if (mcsl_flag == 0)
				{
				 errtype("ERROR, MCSL's extension deactivated");
				 clear_command();
				 break;
				 }
			errtype("This option is not yet available");
			clear_command();
		/*	mcsl_set_fit(); */
			break;

		case 10:
			if (mcsl_flag == 0)
				{
				 errtype("ERROR, MCSL's extension deactivated");
				 clear_command();
				 break;
				 }
			loop_fit_mcsl();
			break;



	   	    case 20:
		list_menu("MCSL MENU",mcsl_menu,mcsl_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    }
/***************************************************************************/
void  mcsl_init(void)
/***************************************************************************/
    {
    int i;

    NOUTFILE = 0;
    NPAR = 0;
    NDELTAZS = 0;
    NPLAN = 0;
    for (i = 0; i < MAXFIT; i++)
		SAVPAR[i] = FALSE;
    for (i = 0; i < MAXATOMS; i++)
		NZSPLAN[i] = 0;
    for (i = 0; i < 25; i++)
		NCOL[i] = 0;
	X_low=0.;
	Y_low=0.;
	X_up=0.;
	Y_up=0.;
	X_norm=1.;
	Y_norm=1.;
    sprintf(color_fth, "black");
    sprintf(color_fdata, "black");
    sprintf(color_cont_fth, "black");
    sprintf(color_cont_fdata, "black");
    for (i = 0; i < MAXNLOOP; i++)
		{
		PAR_LOOP[i]=0;
		INIT_LOOP[i]=0.;
		END_LOOP[i]=0.;
		STEP_LOOP[i]=0.;
		NP_LOOP[i]=1;
		}
	NFITAUTO=FALSE;
    }

/***************************************************************************/
void  save_fit_result(void)
/***************************************************************************/
/* output file for saving some fit parameters */
/* define setfitpar_menu */
{
enum i_setfpar
	{
	 i_zero,
	 i_open,
	 i_fit,
	 i_save,
	 i_srange,
	 i_sall,
	 i_del,
	 i_drange,
	 i_write,
	 i_close,
	 i_list,
	 i_help,
	 i_return,
 	};
/*
#define setfpar_length 8       number of commands in setfitpar menu
*/
static struct MENU setfpar_menu[i_return]=
 	{
	 "open", 	1, i_open,  "Open a file of fit parameters",
	 "lfit",	2, i_fit,   "List of the fit parameters",
	 "save", 	2, i_save,  "Give the par to save in the file",
	 "srange", 	2, i_srange,"Make range of parameters to save",
	 "sall", 	3, i_sall,  "Save all parameters",
	 "delete", 	1, i_del,   "Delete a par. to save in the file",
	 "drange", 	2, i_drange,"Make range of parameters to delete",
	 "write", 	1, i_write, "Write param. names in the columns headers",
	 "close", 	2, i_close, "Close the file of fit parameters",
	 "list", 	1, i_list,  "List of parameter to save",
	 "help", 	1, i_help,  "Display menu",
	 "return", 	1, i_return,"Quit this menu",
 	};
int stop = FALSE;
char token[100];
int parameter, i;

if (!NPAR)
	{

	sprintf(STRING, "\n The number of fit parameters is ZERO\n");
	errtype (STRING);
	sprintf(STRING, " you need to pass trough the fit menu FIRST\n\n");
	errtype (STRING);
	clear_command();
	return;
	}

while (!stop)
	{
	if (!get_token (token, "ROD.EXT.MCSL.SAVE>")) break;
	switch (cmnd_match (token, setfpar_menu, i_return))
	{
	case -1:
		break;

	case 0:
		break;

	case i_open:     /* Ask for filename */
		sprintf (STRING, "Filename (.tab) : ");
		if (!get_token (TABFILENAME, STRING))
			break;
		else
			{
			add_extension (TABFILENAME, "tab");
			if ((TABFILE = fopen (TABFILENAME, "w"))== NULL)
				{
		 		sprintf (STRING, "Error, failed to open '%s'",TABFILENAME);
		 		errtype (STRING);
		 		clear_command();
		 		return;
	 			}
			else
				{
		 		get_string (STRING, "Comments: ");
		 		fprintf (TABFILE, "%s\n", STRING);
		 		NOUTFILE = TRUE;
	 			}
			}
		break;

	case i_fit :
		if (!NPAR)
			{
			sprintf(STRING, "ATT! there is no fit parameter, you need to pass trough the fit menu FIRST\n");
			errtype(STRING);
			clear_command();
			}
		break;
		for (i=0; i<NPAR; i++)
			{
			sprintf(STRING, " %d %s [%5.3f]\n",i+1, FITTXT[i],FITPAR[i]);
			type_list(STRING,ROWS);
			}
		break;

	case i_save:
		if (FALSE != (parameter= get_parameter ("Parameter to be saved", NPAR)))
			SAVPAR[parameter-1]=TRUE;
		break;

	case i_sall:
		for (i = 0; i < NPAR; i++)
			SAVPAR[i] = TRUE;
		break;

	case i_srange:
		{
		int rangel,range2;
		char tok_en[50];
		sprintf(STRING, "Input saved parameters range (xx.xx) : ");
		get_token(tok_en,STRING);
		if (sscanf(tok_en, "%d.%d",&rangel, &range2)==2)
			{
			for (i = rangel - 1; i < range2; i++)
				SAVPAR[i] = TRUE;
			}
		else errtype("Bad input range");
		break;
		}

	case i_del:
		if (FALSE != (parameter= get_parameter ("Parameter to be deleted", NPAR)))
			SAVPAR[parameter-1]=FALSE;
		break;

	case i_drange:
		{
		int rangel,range2;
		char tok_en[50];
		sprintf(STRING, "Input saved parameters range (xx.xx) : ");
		get_token(tok_en,STRING);
		if (sscanf(tok_en, "%d.%d",&rangel, &range2)==2)
			{
			for (i = rangel - 1; i < range2; i++)
				SAVPAR[i] = FALSE;
			}
		else errtype("Bad input range");
		break;
		}

	case i_write:
		if (!NOUTFILE) errtype("No opened file \n");
		else
			{
			for (i = 0; i < NPAR; i++)
				{
				if (SAVPAR[i])
					fprintf (TABFILE," %s",FITTXT[i]);
				}
			fprintf (TABFILE," chisqr        R-factor\n");
			fflush(TABFILE);
			}
		break;

	case i_close:
		fclose(TABFILE);
		NOUTFILE= FALSE;
		for (i = 0; i < NPAR; i++)
			SAVPAR[i] = FALSE;
		break;

	case i_list:
		if (NOUTFILE)
			sprintf(STRING,"    output file    %s\n",TABFILENAME);
		else
			sprintf(STRING,"    No output file            \n");
		type_line(STRING);
		sprintf(STRING,"saved parameters: \n");
		type_line(STRING);
		for (i = 0; i < NPAR; i++)
			{
			if (SAVPAR[i])
				{
				sprintf(STRING, " %d %s [%5.3f]\n",i+1, FITTXT[i],FITPAR[i]);
				type_list(STRING,ROWS);
				}
			}
		break;

	case i_help:
		list_menu ("SET OUTFILE PARAMETERS", setfpar_menu, i_return);
		break;

	case i_return:
		stop = TRUE;
		break;
	}
	}
}


/***************************************************************************/
void    mcsl_set_fit(void)
/***************************************************************************/

    /*
    Set fit parameters of surface atoms.
	Mcsl's version includes ZCONST, Z2CONST and NZ2DIS, Z3CONST and NZ3DIS,
	for linked z-displacements
	NOCCUPB, NOCCUP2 for binary alloys
    */
 /*


 EN DEVELOPPEMENT -> NZSPLAN et NDELTAZS
 					 calcul NPLAN
 					 sauvegarde et liste sous le bon format
 					 attention il y a un blanc
 					 dans tous les * / qui denote une fin de commentaire */
    {


 /* number of commands in mcsl_set_fit menu */

 #define mcsl_set_fit_length 32    /* define mcsl_set_fit_menu */
    static struct   MENU mcsl_set_fit_menu[mcsl_set_fit_length] =
	{
	"element",    1,  1, "Element type of atom",
	"xstart",     1,  2, "Start x-position",
	"xconstant",  2,  3, "Multiplication factor of x-displacement",
	"xdisplace",  2,  4, "Serial number of x-displacement parameter",
	"x2constant", 3,  5, "Multiplication factor of 2nd x-displ.",
	"x2displace", 3,  6, "Serial number of 2nd x-displacement par.",
	"ystart",     1,  7, "Start y-position",
	"yconstant",  2,  8, "Multiplication factor of y-displacement",
	"ydisplace",  2,  9, "Serial number of y-displacement parameter",
	"y2constant", 3, 10, "Multiplication factor of 2nd y-displ.",
	"y2displace", 3, 11, "Serial number of 2nd y-displacement par.",
	"zstart",     1, 12, "Start z-position",
	"nplan",      1, 28, "serial number of the plane of the atom",
	"zconstant",  2, 20, "Multiplication factor of z-displacement",
	"zdisplace",  2, 13, "Serial number of z-displacement parameter",
	"z2constant", 3, 21, "Multiplication factor of 2nd z-displ.",
	"z2displace", 3, 22, "Serial number of 2nd z-displacement par.",
	"z3constant", 3, 23, "Multiplication factor of 3rd z-displ.",
	"z3displace", 3, 24, "Serial number of 3rd z-displacement par.",
	"b1",         2, 14, "Serial # of in-plane Debye-Waller par",
	"b2",         2, 15, "Serial # of out-of-plane Debye-Waller par",
	"ocBcupancy", 3, 25, "Serial number of bulk occupancy parameter",
	"oc1cupancy", 3, 26, "Serial number of 1rst occupancy parameter",
	"oc2cupancy", 3, 27, "Serial number of 2nd occupancy parameter",
	"add",        1, 17, "Add an atom to model",
	"delete",     1, 18, "Delete an atom from model",
	"fullmodel",  1, 19, "Show extended model yes/no",
	"list",       1, 30, "List atoms",
	"help",       1, 31, "Display menu",
	"return",     1, 32, "Return to main menu"
    };

    int stop = FALSE;
    char token[100];
    int natom, i, newtype;
    char element[3];

    while (!stop) {
	if (!get_token(token, "ROD.EXT.MCSL.SET.FIT>"))
	    break;
	switch (cmnd_match(token, mcsl_set_fit_menu, mcsl_set_fit_length)) {
	case -1:
	    break;
	case 0:
	    break;
	case 1:
	    natom = get_natom("Atom number: ");
	    get_token(element, "Element type: ");
	    toupper(element[0]);
	    tolower(element[1]);

	    /* Check whether this is a new element type */

	    newtype = TRUE;
	    for (i = 0; i < NTYPES; i++) {
		if (el_equal(element, ELEMENT[i])) {
		    newtype = FALSE;
		    TS[natom - 1] = i;
		}
	    }
	    if (newtype) {
		if (NTYPES == MAXTYPES) {
		    errtype("ERROR, too many atom types");
		    break;
		}
		NTYPES++;
		get_coeff(element, F_COEFF[NTYPES - 1]);
		if (F_COEFF[NTYPES - 1][0] == 0.) {
		    NTYPES--;
		    TS[natom - 1] = 0;
		} else {
		    sprintf(ELEMENT[NTYPES - 1], "%s", element);
		    TS[natom - 1] = NTYPES - 1;
		}
	    }
	    break;
	case 2:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING, "Start x-position of surface atom [%5.3f]: ",
		    XS[natom - 1]);
	    XS[natom - 1] = get_real(XS[natom - 1], STRING);
	    break;
	case 3:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Multiplication factor of x-displacement [%5.2f]: ",
		    XCONST[natom - 1]);
	    XCONST[natom - 1] = get_real(XCONST[natom - 1], STRING);
	    break;
	case 4:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Serial number of x-displacement parameter [%1d]: ",
		    NXDIS[natom - 1]);
	    NXDIS[natom - 1] = get_int(NXDIS[natom - 1], STRING);
	    if (NXDIS[natom - 1] > NDISTOT)
		NDISTOT = NXDIS[natom - 1];
	    break;
	case 5:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		 "Multiplication factor of 2nd x-displacement [%5.2f]: ",
		    X2CONST[natom - 1]);
	    X2CONST[natom - 1] = get_real(X2CONST[natom - 1], STRING);
	    break;
	case 6:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		 "Serial number of 2nd x-displacement parameter [%1d]: ",
		    NX2DIS[natom - 1]);
	    NX2DIS[natom - 1] = get_int(NX2DIS[natom - 1], STRING);
	    if (NX2DIS[natom - 1] > NDISTOT)
		NDISTOT = NX2DIS[natom - 1];
	    break;
	case 7:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING, "Start y-position of surface atom [%5.3f]: ",
		    YS[natom - 1]);
	    YS[natom - 1] = get_real(YS[natom - 1], STRING);
	    break;
	case 8:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Multiplication factor of y-displacement [%5.2f]: ",
		    YCONST[natom - 1]);
	    YCONST[natom - 1] = get_real(YCONST[natom - 1], STRING);
	    break;
	case 9:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Serial number of y-displacement parameter [%1d]: ",
		    NYDIS[natom - 1]);
	    NYDIS[natom - 1] = get_int(NYDIS[natom - 1], STRING);
	    if (NYDIS[natom - 1] > NDISTOT)
		NDISTOT = NYDIS[natom - 1];
	    break;
	case 10:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		 "Multiplication factor of 2nd y-displacement [%5.2f]: ",
		    Y2CONST[natom - 1]);
	    Y2CONST[natom - 1] = get_real(Y2CONST[natom - 1], STRING);
	    break;
	case 11:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		 "Serial number of 2nd y-displacement parameter [%1d]: ",
		    NY2DIS[natom - 1]);
	    NY2DIS[natom - 1] = get_int(NY2DIS[natom - 1], STRING);
	    if (NY2DIS[natom - 1] > NDISTOT)
		NDISTOT = NY2DIS[natom - 1];
	    break;
	case 12:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING, "Start z-position of surface atom [%5.3f]: ",
		    ZS[natom - 1]);
	    ZS[natom - 1] = get_real(ZS[natom - 1], STRING);
	    break;
      case 20:
            natom = get_natom("Atom number: ");
            sprintf(STRING,
                    "Multiplication factor of z-displacement [%5.2f]: ",
                    ZCONST[natom - 1]);
            ZCONST[natom - 1] = get_real(ZCONST[natom - 1], STRING);
            break;
	case 13:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Serial number of z-displacement parameter [%1d]: ",
		    NZDIS[natom - 1]);
	    NZDIS[natom - 1] = get_int(NZDIS[natom - 1], STRING);
	    if (NZDIS[natom - 1] > NDISTOT)
		NDISTOT = NZDIS[natom - 1];
	    break;
    case 21:
        natom = get_natom("Atom number: ");
        sprintf(STRING,
               "Multiplication factor of 2nd. z-displacement [%5.2f]: ",
                Z2CONST[natom - 1]);
        Z2CONST[natom - 1] = get_real(Z2CONST[natom - 1], STRING);
        break;

    case 22:
        natom = get_natom("Atom number: ");
        sprintf(STRING,
               "Serial number of 2nd. z-displacement parameter [%1d]: ",
                NZ2DIS[natom - 1]);
        NZ2DIS[natom - 1] = get_int(NZ2DIS[natom - 1], STRING);
        if (NZ2DIS[natom - 1] > NDISTOT)
            NDISTOT = NZ2DIS[natom - 1];
        break;
 	case 23:
        natom = get_natom("Atom number: ");
	    sprintf(STRING,
	            "Multiplication factor of 3rd. z-displacement [%5.2f]: ",
	             Z3CONST[natom - 1]);
	    Z3CONST[natom - 1] = get_real(Z3CONST[natom - 1], STRING);
	    break;
	case 24:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
	           "Serial number of 3rd. z-displacement parameter [%1d]: ",
	            NZ2DIS[natom - 1]);
	    NZ3DIS[natom - 1] = get_int(NZ3DIS[natom - 1], STRING);
	    if (NZ3DIS[natom - 1] > NDISTOT)
	            NDISTOT = NZ2DIS[natom - 1];
	    break;

	case 14:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
	      "Serial number of parallel Debye-Waller parameter [%1d]: ",
		    NDWS[natom - 1]);
	    NDWS[natom - 1] = get_int(NDWS[natom - 1], STRING);
	    if (NDWS[natom - 1] > NDWTOT)
		NDWTOT = NDWS[natom - 1];
	    break;
	case 15:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Serial number of perpendicular Debye-Waller parameter [%1d]: ",
		    NDWS2[natom - 1]);
	    NDWS2[natom - 1] = get_int(NDWS2[natom - 1], STRING);
	    if (NDWS2[natom - 1] > NDWTOT2)
		NDWTOT2 = NDWS2[natom - 1];
	    break;

	case 25:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Serial number of BULK occupancy parameter [%1d]: ",
		    NOCCUPB[natom - 1]);
	    NOCCUPB[natom - 1] = get_int(NOCCUPB[natom - 1], STRING);
	    if (NOCCUPB[natom - 1] > NOCCTOT)
		NOCCTOT = NOCCUPB[natom - 1];
	    break;
	case 26:
		natom = get_natom("Atom number: ");
		sprintf(STRING,
			  "Serial number of 1rst SURF occ. parameter [%1d]: ",
			   NOCCUP[natom - 1]);
		NOCCUP[natom - 1] = get_int(NOCCUP[natom - 1], STRING);
		if (NOCCUP[natom - 1] > NOCCTOT)
		NOCCTOT = NOCCUP[natom - 1];
		break;
	case 27:
	    natom = get_natom("Atom number: ");
	    sprintf(STRING,
		    "Serial number of 2nd SURF occ.parameter [%1d]: ",
		    NOCCUP2[natom - 1]);
	    NOCCUP2[natom - 1] = get_int(NOCCUP2[natom - 1], STRING);
	    if (NOCCUP2[natom - 1] > NOCCTOT)
		NOCCTOT = NOCCUP2[natom - 1];
	    break;

	case 17:
	    if (NSURFTOT == MAXATOMS) {
		errtype("Maximum number of atoms in model reached");
		break;
	    }
	    NSURFTOT++;
	    natom = get_natom("Atom number: ");
	    if (natom <= NSURF + 1)
		NSURF++;
	    else
		NSURF2++;

	    /* Make room for new atom */

	    for (i = NSURFTOT - 1; i > natom - 1; i--) {
		TS[i] = TS[i - 1];
		XS[i] = XS[i - 1];
		XCONST[i] = XCONST[i - 1];
		NXDIS[i] = NXDIS[i - 1];
		X2CONST[i] = X2CONST[i - 1];
		NX2DIS[i] = NX2DIS[i - 1];
		YS[i] = YS[i - 1];
		YCONST[i] = YCONST[i - 1];
		NYDIS[i] = NYDIS[i - 1];
		Y2CONST[i] = Y2CONST[i - 1];
		NY2DIS[i] = NY2DIS[i - 1];
		ZS[i] = ZS[i - 1];
		ZCONST[i] = ZCONST[i - 1];
		NZDIS[i] = NZDIS[i - 1];
		Z2CONST[i] = Z2CONST[i - 1];
		NZ2DIS[i] = NZ2DIS[i - 1];
		Z3CONST[i] = Z3CONST[i - 1];
		NZ3DIS[i] = NZ3DIS[i - 1];
		NDWS[i] = NDWS[i - 1];
		NDWS2[i] = NDWS2[i - 1];
		NOCCUP[i] = NOCCUP[i - 1];
		NOCCUP2[i] = NOCCUP2[i - 1];
	    }

	    /* Initialize parameters for new atom */

	    TS[natom - 1] = 0 ;
	    XS[natom - 1] = 0.;
	    XCONST[natom - 1] = 0.;
	    NXDIS[natom - 1] = 0;
	    X2CONST[natom - 1] = 0.;
	    NX2DIS[natom - 1] = 0;
	    YS[natom - 1] = 0.;
	    YCONST[natom - 1] = 0.;
	    NYDIS[natom - 1] = 0;
	    Y2CONST[natom - 1] = 0.;
	    NY2DIS[natom - 1] = 0;
	    ZS[natom - 1] = 0.;
	    ZCONST[natom - 1] = 0;
	    NZDIS[natom - 1] = 0;
	    Z2CONST[natom - 1] = 0.;
	    NZ3DIS[natom - 1] = 0;
	    Z3CONST[natom - 1] = 0.;
	    NZ2DIS[natom - 1] = 0;
	    NDWS[natom - 1] = 0;
	    NDWS2[natom - 1] = 0;
	    NOCCUP[natom - 1] = 0;
	    NOCCUP2[natom - 1] = 0;
	    break;
	case 18:
	    natom = get_natom("Atom number: ");
	    if (natom <= NSURF)
		NSURF--;
	    else
		NSURF2--;
	    NSURFTOT--;

	    /* Shift atoms with higher serial numbers */

	    for (i = natom - 1; i < NSURFTOT - 1; i++) {
		TS[i] = TS[i + 1];
		XS[i] = XS[i + 1];
		XCONST[i] = XCONST[i + 1];
		NXDIS[i] = NXDIS[i + 1];
		X2CONST[i] = X2CONST[i + 1];
		NX2DIS[i] = NX2DIS[i + 1];
		YS[i] = YS[i + 1];
		YCONST[i] = YCONST[i + 1];
		NYDIS[i] = NYDIS[i + 1];
		Y2CONST[i] = Y2CONST[i + 1];
		NY2DIS[i] = NY2DIS[i + 1];
		ZS[i] = ZS[i + 1];
		ZCONST[i] = ZCONST[i + 1];
		NZDIS[i] = NZDIS[i + 1];
		Z2CONST[i] = Z2CONST[i + 1];
		NZ2DIS[i] = NZ2DIS[i + 1];
		Z2CONST[i] = Z2CONST[i + 1];
		NZ3DIS[i] = NZ3DIS[i + 1];
		NDWS[i] = NDWS[i + 1];
		NDWS2[i] = NDWS2[i + 1];
		NOCCUP[i] = NOCCUP[i + 1];
		NOCCUP2[i] = NOCCUP2[i + 1];
	    }
	    break;
	case 19:
	    sprintf(STRING, "Show extended model [%s]: ",
		    yesnostr(FULLMODEL));
	    FULLMODEL = yesno(FULLMODEL, STRING);
	    break;
	case 30:
	    clear_screen();
	    if (FULLMODEL) {
		sprintf(STRING,
			"%1s %2s %2s %6s %5s %7s %6s %2s %6s %5s %7s %6s %2s %6s %5s %7s %6s %4s %5s %4s\n",
			"#", "el",
			"xs", "xconst", "nxdis", "x2const", "nx2dis",
			"ys", "yconst", "nydis", "y2const", "ny2dis",
			"zs", "zconst", "nzdis", "z2const", "nz2dis", "ndwb", "ndwb2", "nocc");
	    } else {
		sprintf(STRING,
			"%1s %2s %2s %6s %5s %7s %6s %2s %6s %5s %7s %6s %2s %5s %4s %5s %4s\n",
			"#", "el",
			"xs", "xconst", "nxdis", "x2const", "nx2dis",
			"ys", "yconst", "nydis", "y2const", "ny2dis",
			"zs", "nzdis", "ndwb", "ndwb2", "nocc");
	    }
	    type_line(STRING);
	    for (i = 0; i < NSURFTOT; i++) {
		if (FULLMODEL) {
		    sprintf(STRING,
			"%2d %2s %7.4f %5.2f %2d %5.2f %3d %8.4f %6.2f %3d %6.2f %3d %8.4f %6.2f %3d %6.2f %3d %3d %3d %3d\n",
			i + 1, ELEMENT[TS[i]],
		      XS[i], XCONST[i], NXDIS[i], X2CONST[i], NX2DIS[i],
		      YS[i], YCONST[i], NYDIS[i], Y2CONST[i], NY2DIS[i],
			ZS[i], ZCONST[i], NZDIS[i], Z2CONST[i], NZ2DIS[i],
			NDWS[i], NDWS2[i], NOCCUP[i]);
		} else {
		    sprintf(STRING,
			    "%2d %2s %7.4f %6.3f %2d %7.4f %6.3f %2d %7.4f %2d %2d %2d %2d\n",
			    i + 1, ELEMENT[TS[i]],
			    XS[i], XCONST[i], NXDIS[i],
			    YS[i], YCONST[i], NYDIS[i],
			  ZS[i], NZDIS[i], NDWS[i], NDWS2[i], NOCCUP[i]);
		}
		type_line(STRING);
	    }
	    break;
	case 31:
	    list_menu("MCSL SET FIT MENU",
		      mcsl_set_fit_menu, mcsl_set_fit_length);
	    break;
	case 32:
	    stop = TRUE;
	}
    }
    mcsl_update_model();

}





#endif /* EXTENSIONS MCSL */






 /* end of main part


 __________________________________________________________________________
   read.c part */

/***************************************************************************/
void  read_name(void)
/***************************************************************************/

 /* establish the array of the column number of each fit parameter
 in the .fit file */

{
int     i,ncolumns;
char	dum[20];
char    el[10], name[25][10];

enum column_title {
					i_zero,
					xs_column,
					cx1_column,
					nx1_column,
					cx2_column,
					nx2_column,
					ys_column,
					cy1_column,
					ny1_column,
					cy2_column,
					ny2_column,
					np_column,
					zs_column,
					cz1_column,
					nz1_column,
					cz2_column,
					nz2_column,
					cz3_column,
					nz3_column,
					dw1_column,
					dw2_column,
					oc1_column,
					oc2_column
					};

for (i=0; i<25; i++)
	NCOL[i]=-1;

/* read column headers*/
#if defined(__unix) || defined(__APPLE__)
	ncolumns = sscanf(INLINE,
	"%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
	el,name[0],name[1],name[2],name[3],name[4],name[5],
	name[6],name[7],name[8],name[9],name[10],name[11],
	name[12],name[13],name[14],name[15],name[16],name[17],
	name[18],name[19],name[20],name[21],name[22],name[23],name[24]);

#else
	sscanf(INLINE,
	"%[ ]%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
	dum,el,name[0],name[1],name[2],name[3],name[4],name[5],
	name[6],name[7],name[8],name[9],name[10],name[11],
	name[12],name[13],name[14],name[15],name[16],name[17],
	name[18],name[19],name[20],name[21],name[22],name[23],name[24]);
#endif



for  (i = 0; i < ncolumns; i++)
	{
	string_tolower(name[i]);
	 	 if (strcmp(name[i], "xs") == 0) NCOL[xs_column]  = i;
	else if (strcmp(name[i],"cx1") == 0) NCOL[cx1_column] = i;
	else if (strcmp(name[i],"nx1") == 0) NCOL[nx1_column] = i;
	else if (strcmp(name[i],"cx2") == 0) NCOL[cx2_column] = i;
	else if (strcmp(name[i],"nx2") == 0) NCOL[nx2_column] = i;
	else if (strcmp(name[i], "ys") == 0) NCOL[ys_column]  = i;
	else if (strcmp(name[i],"cy1") == 0) NCOL[cy1_column] = i;
	else if (strcmp(name[i],"ny1") == 0) NCOL[ny1_column] = i;
	else if (strcmp(name[i],"cy2") == 0) NCOL[cy2_column] = i;
	else if (strcmp(name[i],"ny2") == 0) NCOL[ny2_column] = i;
	else if (strcmp(name[i],"np")  == 0)
										{
										 NCOL[np_column]  = i;
									 	 NDELTAZS=TRUE;
										}
	else if (strcmp(name[i],"zs")  == 0) NCOL[zs_column]  = i;
	else if (strcmp(name[i],"dzs") == 0) NCOL[zs_column]  = i;
	else if (strcmp(name[i],"cz1") == 0) NCOL[cz1_column] = i;
	else if (strcmp(name[i],"nz1") == 0) NCOL[nz1_column] = i;
	else if (strcmp(name[i],"cz2") == 0) NCOL[cz2_column] = i;
	else if (strcmp(name[i],"nz2") == 0) NCOL[nz2_column] = i;
	else if (strcmp(name[i],"cz3") == 0) NCOL[cz3_column] = i;
	else if (strcmp(name[i],"nz3") == 0) NCOL[nz3_column] = i;
	else if (strcmp(name[i],"dw1") == 0) NCOL[dw1_column] = i;
	else if (strcmp(name[i],"dw2") == 0) NCOL[dw2_column] = i;
	else if (strcmp(name[i],"oc1") == 0) NCOL[oc1_column] = i;
	else if (strcmp(name[i],"oc2") == 0) NCOL[oc2_column] = i;
	}

NCOL[0]=ncolumns-1;
type_line("columns of the .fit file:\n");
for (i = 1; i < ncolumns; i++)
	{
	sprintf(STRING,"%5s", name[i-1]);
	type_line(STRING);
	}
sprintf(STRING,"\nNdeltaz = %1d",    NDELTAZS);
type_line(STRING);
type_line("\n");
}


/***************************************************************************/
void  read_auto(void)
/***************************************************************************/

    /*   automatic reading in INLINE */
{
int     i, ncolumns;
float	dummy[25];
char    dum[20], el[3];

enum column_title {
					i_zero,
					xs_column,
					cx1_column,
					nx1_column,
					cx2_column,
					nx2_column,
					ys_column,
					cy1_column,
					ny1_column,
					cy2_column,
					ny2_column,
					np_column,
					zs_column,
					cz1_column,
					nz1_column,
					cz2_column,
					nz2_column,
					cz3_column,
					nz3_column,
					dw1_column,
					dw2_column,
					oc1_column,
					oc2_column,
					};



#if defined(__unix) || defined(__APPLE__)
	ncolumns = sscanf(INLINE,
	"%3c%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f",
	el,&dummy[0],&dummy[1],&dummy[2],&dummy[3],&dummy[4],&dummy[5],
	&dummy[6],&dummy[7],&dummy[8],&dummy[9],&dummy[10],&dummy[11],
	&dummy[12],&dummy[13],&dummy[14],&dummy[15],&dummy[16],&dummy[17],
	&dummy[18],&dummy[19],&dummy[20],&dummy[21],&dummy[22],&dummy[23],&dummy[24]);

#else
	sscanf(INLINE,
	"%[ ]%3c%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f",
	dum,el,&dummy[0],&dummy[1],&dummy[2],&dummy[3],&dummy[4],&dummy[5],
	&dummy[6],&dummy[7],&dummy[8],&dummy[9],&dummy[10],&dummy[11],
	&dummy[12],&dummy[13],&dummy[14],&dummy[15],&dummy[16],&dummy[17],
	&dummy[18],&dummy[19],&dummy[20],&dummy[21],&dummy[22],&dummy[23],&dummy[24]);
#endif
ncolumns -= 1;

if (ncolumns == NCOL[0])
	{
	for (i=0; i<25; i++)
		if (NCOL [i] <0)
			dummy[NCOL[i]] = 0;
	XS[NSURF]           =        dummy[NCOL[xs_column]];
	XCONST[NSURF]       =        dummy[NCOL[cx1_column]];
	NXDIS[NSURF]        =  (int)(dummy[NCOL[nx1_column]]);
	X2CONST[NSURF]      =        dummy[NCOL[cx2_column]];
	NX2DIS[NSURF]       =  (int)(dummy[NCOL[nx2_column]]);
	YS[NSURF]           =        dummy[NCOL[ys_column]];
	YCONST[NSURF]       =        dummy[NCOL[cy1_column]];
	NYDIS[NSURF]        =  (int)(dummy[NCOL[ny1_column]]);
	Y2CONST[NSURF]      =        dummy[NCOL[cy2_column]];
	NY2DIS[NSURF]       =  (int)(dummy[NCOL[ny2_column]]);
	NZSPLAN[NSURF]      =  (int)(dummy[NCOL[np_column]]);
	ZS[NSURF]           =        dummy[NCOL[zs_column]];
	ZCONST[NSURF]       =        dummy[NCOL[cz1_column]];
	NZDIS[NSURF]        =  (int)(dummy[NCOL[nz1_column]]);
	Z2CONST[NSURF]     =        dummy[NCOL[cz2_column]];
	NZ2DIS[NSURF]       =  (int)(dummy[NCOL[nz2_column]]);
	Z3CONST[NSURF]      =        dummy[NCOL[cz3_column]];
	NZ3DIS[NSURF]       =  (int)(dummy[NCOL[nz3_column]]);
	NDWS[NSURF]         =  (int)(dummy[NCOL[dw1_column]]);
	NDWS2[NSURF]        =  (int)(dummy[NCOL[dw2_column]]);
	NOCCUP[NSURF]       =  (int)(dummy[NCOL[oc1_column]]);
	NOCCUP2[NSURF]      =  (int)(dummy[NCOL[oc2_column]]);
	sscanf(INLINE,"%s",el);

/*
	sprintf(STRING,
	"%3d %2s %7.4f %5.2f %2d %5.2f%3d%8.4f%6.2f%3d%6.2f%3d%3d%8.4f%8.4f%3d%8.4f%3d%8.4f%3d%3d%3d%3d% 3d",
	NSURF, el,
	XS[NSURF],XCONST[NSURF],NXDIS[NSURF],X2CONST[NSURF],NX2DIS[NSURF],
	YS[NSURF],YCONST[NSURF],NYDIS[NSURF],Y2CONST[NSURF],NY2DIS[NSURF],
	NZSPLAN[NSURF],ZS[NSURF],ZCONST[NSURF],NZDIS[NSURF],
	Z2CONST[NSURF], NZ2DIS[NSURF],Z3CONST[NSURF],NZ3DIS[NSURF],
	NDWS[NSURF],NDWS2[NSURF],NOCCUP[NSURF],NOCCUP2[NSURF]);
	type_list(STRING,ROWS);
*/
	}
else
	{
	sprintf(STRING,
	"NSURF= '%3d': number of param. does not correspond to that of column names"
	,NSURF);
	errtype (STRING);
	}
return;
}


/* end of read.c part


 __________________________________________________________________________
  set.c part */

/***************************************************************************/
void  mcsl_update_model(void)
/***************************************************************************/
/* update the parameter o the model for Mcsl extension*/

{

int 	i,j, natomplan;
float 	DZS[MAXATOMS];

float zsplanmoy[MAXATOMS],dzsplanmoy[MAXATOMS];
/* zsplanmoy[j] : averaged position of j plane
   dzsplanmoy[j]: averaged interplane distance between j-1 et j */

for (i = 0; i < NSURF+NSURF2; i++)
	{
	XSFIT[i] = XS[i];
	if (NXDIS[i] > 0) XSFIT[i] += XCONST[i]*DISPL[NXDIS[i]-1];
	if (NX2DIS[i] > 0) XSFIT[i] +=  X2CONST[i]*DISPL[NX2DIS[i]-1];

	YSFIT[i] = YS[i];
	if (NYDIS[i] > 0) YSFIT[i] += YCONST[i]*DISPL[NYDIS[i]-1];
	if (NY2DIS[i] > 0) YSFIT[i] += Y2CONST[i]*DISPL[NY2DIS[i]-1];

/* delta Z of the element i= distance from it from the plane just below */
	DZS[i] = ZS[i];
	if  (NZDIS[i] > 0)
		DZS[i] += ZCONST[i] * DISPL[NZDIS[i] - 1];
	if  (NZ2DIS[i] > 0)
		DZS[i] += Z2CONST[i] * DISPL[NZ2DIS[i] - 1];
	if  (NZ3DIS[i] > 0)
		DZS[i] += Z3CONST[i] * DISPL[NZ3DIS[i] -1];

	OCCUPTOT[i] = 1.;
	if (NOCCUP[i] > 0)
		OCCUPTOT[i] = OCCUP[NOCCUP[i]-1];
	if (NOCCUP2[i] > 0)
		OCCUPTOT[i] += -OCCUP[NOCCUP2[i]-1];
	}

if (NDELTAZS)
/* begin of the calculation of Z : height of the element i relatively to the bulk */
/* the calcul is performed independently for the to type of surface fraction */
/* calcul of the average distance betwen the j and j+l plane */
	{
	dzsplanmoy[0]=0.;
	zsplanmoy[0]=0.;
	for (j=1; j< (NPLAN+1); j++)
		{
		natomplan = 0;
		dzsplanmoy[j]=0.;
		zsplanmoy[j]=0.;
		for (i = 0; i < NSURF; i++)
			{
			if (NZSPLAN[i]== j)
				{
				dzsplanmoy[j]+=DZS[i];
				natomplan ++;
				}
			}
		if (natomplan>0)
			{
			dzsplanmoy[j]= dzsplanmoy[j]/natomplan;
			zsplanmoy[j]= zsplanmoy[j-1]+dzsplanmoy[j];
			}
		}
/* Z   average height of plane j-1 + the distance relatively + this plane */

	for (i = 1; i < NSURF; i++)
		ZSFIT[i] = zsplanmoy[NZSPLAN[i]-1] + DZS[i];


	if (NSURF2>0)
	/* calcul for the second surface fraction*/
	dzsplanmoy[0]=0;
	for (j=1; j< (NPLAN+1); j++)
		{
		natomplan = 0;
		dzsplanmoy[j]=0.;
		for (i = NSURF; i < NSURF+NSURF2; i++)
			{
			if (NZSPLAN[i]== j)
				{
				dzsplanmoy[j]+=DZS[i];
				natomplan ++;
				}
			}

		if (natomplan>0)
			{
			dzsplanmoy[j]= dzsplanmoy[j]/natomplan;
			zsplanmoy[j]= zsplanmoy[j-1]+ dzsplanmoy[j];
			}
		}
	for (i = NSURF; i < NSURF+NSURF2; i++)
		ZSFIT[i] = zsplanmoy[NZSPLAN[i]-1] + DZS[i];

	}
else    /* NDELTAZS=FALSE -> z parameter is done from the origin */
	for (i = 0; i < NSURF+NSURF2; i++)
			ZSFIT[i] = DZS[i];

/* end of Z calculation */

}





/***************************************************************************/
void    set_plot_mcsl(void)
/***************************************************************************/

    /*
    Set parameters of the "fb" option of the plot menu
    = plot of both theoretical structure factors & experimental structure factors
    as 1/2 circles in reciprocal space.

    */
 {
	#define set_fb_length	15
	static struct MENU set_fb_menu[set_fb_length] =
	{
		"cftheory", 3,  1, "color of filled 1/2 circle fth",
		"cfdata",   3,  2, "color of filled 1/2 circle fdata",
		"cctheory", 3,  3, "contour colorof 1/2 circle fth",
		"ccdata",   3,  4, "contour colorof 1/2 circle fdata",
		"xmin",     3,  5, "X low",
		"xmax",     3,  6, "X up",
		"ymin",     3,  7, "X low",
		"ymax",     3,  8, "X up",
		"xauto",    2, 15, "automatic scale for X",
		"yauto",    2, 15, "automatic scale for Y",
		"xunit",    2,  9, "unit of X axis",
		"yunit",    2, 10, "unit of Y axis",
		"list",	    1, 12, "List parameter values",
		"help",     1, 13, "Display menu",
		"return",   1, 14, "return"

	};
    int			COLFTH, COLFDAT, COLCTH, COLCDAT;
    int			stop = FALSE;
    char 		token[50];
    float		A0, A1;
    float       fmin,fmax;
    float       xmin=0,xmax=0,ymin=0,ymax=0,xrange,yrange,ratio;
    int         i;
    float       xunit[5],yunit[5],eunit[5];
    float       x1,y1,marker_size;


	while (!stop)
		{
		if (!get_token (token, "ROD.PLOT.FB.MCSL>"))
		break;
		switch (cmnd_match(token, set_fb_menu, set_fb_length))
			{
			case -1 :
				break;

			case 0 :
				break;

			case 1 :
				sprintf(STRING, "filling color of fth  [%s]: " , color_fth);
				COLFTH = get_color (color_fth, STRING);
				break;

			case 2 :
				sprintf(STRING, "filling color of fdata [%s]: ", color_fdata);
				COLFDAT = get_color (color_fdata, STRING);
				break;

			case 3 :
				sprintf(STRING, "contour color of fth [%s]: ", color_cont_fth);
				COLCTH = get_color (color_cont_fth, STRING);
				break;

			case 4 :
				sprintf(STRING, "contour color of fdata [%s]: ", color_cont_fdata);
				COLCDAT = get_color (color_cont_fdata, STRING);
				break;

			case 5 :
				X_low= xmin;
				sprintf(STRING, "X min  [%4.2f]: ", xmin);
				X_low = get_real (X_low, STRING);
				break;

			case 6 :
				X_up = xmax;
				sprintf(STRING, "X max  [%4.2f]: ", xmax);
				X_up = get_real (X_up, STRING);
				break;

			case 7 :
				Y_low = ymin;
				sprintf(STRING, "Y min  [%4.2f]: ", ymin);
				Y_low = get_real (Y_low, STRING);
				break;

			case 8 :
				Y_up = ymax;
				sprintf(STRING, "Y max  [%4.2f]: ", ymax);
				Y_up = get_real (Y_up, STRING);
				break;

			case 9 :
				sprintf(STRING, "scale factor for X (if 1-> 1/Angstrm if 0 -> r.l.u.) [%8.4f]: ", X_norm);
				X_norm = get_real (X_norm, STRING);
				X_low=0.;
				X_up=0.;
				break;

			case 10 :
				sprintf(STRING, "scale factor for Y (if 1-> 1/Angstrm if 0 -> r.l.u.) [%8.4f]: ", Y_norm);
				Y_norm = get_real (Y_norm, STRING);
				Y_low=0.;
				Y_up=0.;
				break;

			case 12 :
				sprintf(STRING, "filling color of fth   : %s \n" , color_fth);
				type_line(STRING);
				sprintf(STRING, "filling color of fdata : %s \n", color_fdata);
				type_line(STRING);
				sprintf(STRING, "contour color of fth   : %s \n", color_cont_fth);
				type_line(STRING);
				sprintf(STRING, "contour color of fdata : %s \n", color_cont_fdata);
				type_line(STRING);
				sprintf(STRING, "Xmin : %4.2f \n", X_low);
				type_line(STRING);
				sprintf(STRING, "Xmax : %4.2f \n", X_up);
				type_line(STRING);
				sprintf(STRING, "Ymin : %4.2f \n", Y_low);
				type_line(STRING);
				sprintf(STRING, "Ymax : %4.2f \n", Y_up);
				type_line(STRING);
				sprintf(STRING, "scale factor for X : %8.4f \n", X_norm);
				type_line(STRING);
				sprintf(STRING, "scale factor for Y : %8.4f \n", Y_norm);
				type_line(STRING);
				break;

			case 13 :
				list_menu ("SET FB PLOT PARAMETERS", set_fb_menu, set_fb_length);
				break;

			case 14 :
				stop = TRUE;
				break;

			case 15 :
				X_low = 0.;
				X_up =0.;
				break;

			case 16 :
				Y_low = 0.;
				Y_up =0.;
				break;


			} /* end of switch */

		}/* end of while */



    } /* end of set_plot_mcsl */

/***************************************************************************/
void    plot_sfac_mcsl(int mode)
/***************************************************************************/

    /*
    Plot magnitude of structure factors as circles in reciprocal space.
		mode 1  theoretical structure factors
		mode 2  experimental structure factors
		mode 3  theoretical plus experimental structure factors

    */
 {
    int			COLFTH, COLFDAT, COLCTH, COLCDAT;
    int			stop = FALSE;
    char 		token[50];
    float		A0, A1;
    float       fmin,fmax;
    float       xmin=0,xmax=0,ymin=0,ymax=0,xrange,yrange,ratio;
    int         i;
    float       xunit[5],yunit[5],eunit[5];
    float       x1,y1,marker_size;


	#ifdef IMSLEG
    errtype("Not implemented");
	#endif
	#ifdef GRAPHIC

    if (X_norm == 0) A0 = 1;
    else A0 = X_norm * RLAT[0];
    if (Y_norm == 0) A1 = 1 ;
    else A1 = Y_norm * RLAT[1];

    /* Find extrema in reciprocal space and in structure factors */
    if ((mode == 1) || (mode == 3))
	{
	fmax = FTH[2][0];
	}
    else
	{
	fmax = FDAT[0];
	}

    xmin = ymin = 0.;   /* always include one unit cell */
    xmax = ymax = 1.;

    if ((mode == 1) || (mode == 3))
	{
	for (i = 0; i < NTH; i++)
	    {
	    /*if (FTH[2][i] < fmin) fmin = FTH[2][i];*/
	    if ((mode == 1) && (FTH[2][i] > fmax)) fmax = FTH[2][i];
	    if (HTH[i] < xmin) xmin = HTH[i];
	    if (HTH[i] > xmax) xmax = HTH[i];
	    if (KTH[i] < ymin) ymin = KTH[i];
	    if (KTH[i] > ymax) ymax = KTH[i];
	    }
	}
    if ((mode == 2) || (mode == 3))
	{
	for (i = 0; i < NDAT; i++)
	    {
	    /*if (FDAT[i] < fmin) fmin = FDAT[i];*/
	    if (FDAT[i] > fmax) fmax = FDAT[i];
	    if (HDAT[i] < xmin) xmin = HDAT[i];
	    if (HDAT[i] > xmax) xmax = HDAT[i];
	    if (KDAT[i] < ymin) ymin = KDAT[i];
	    if (KDAT[i] > ymax) ymax = KDAT[i];
	    }
	}

   	if (cos(RLAT[5]) < 0)
		{
		xmin = xmin*A0+ymax*A1*cos(RLAT[5]);
		xmax = xmax*A0+ymin*A1*cos(RLAT[5]);
		}
   	else
		{
		xmin = xmin*A0+ymin*A1*cos(RLAT[5]);
		xmax = xmax*A0+ymax*A1*cos(RLAT[5]);
		}
    ymin = ymin*A1*sin(RLAT[5]);
    ymax = ymax*A1*sin(RLAT[5]);

    /* make frame somewhat larger than extreme values in reciprocal space */
    xmin = xmin-1*A0;
    xmax = xmax+1*A0;
    ymin = ymin-1*A1*sin(RLAT[5]);
    ymax = ymax+1*A1*sin(RLAT[5]);
    xrange = xmax-xmin;
    yrange = ymax-ymin;

    /* Make frame such that x and y scales have same units per inch */
    if (xrange/yrange < XL/YL)
		{
		ratio = xmin/xmax;
		xmin = XL/YL*yrange/(1/ratio-1);
		xmax = XL/YL*yrange/(1-ratio);
		}
    else
		{
		ratio = ymin/ymax;
		ymin = YL/XL*xrange/((1/ratio)-1);
		ymax = YL/XL*xrange/(1-ratio);
		}

    if (X_low==0) 	X_low=xmin;
    if (X_up==0) 	X_up =xmax;
 	if (Y_low==0) 	Y_low=ymin;
    if (Y_up==0) 	Y_up =ymax;

    /* Draw frame with unit cell */
    sprintf(STRING,
    "col curve black ret x man x low %6.3f x up %6.3f x tick %10.4e ret ",
	X_low,X_up,(X_up - X_low)/100.);
    put_command(STRING);
    plotxye(xunit,yunit,eunit,1);

    sprintf(STRING,"y lin y man y low %6.3f y up %6.3f y tick %10.4e ret",
	Y_low,Y_up,(Y_up - Y_low)/100.);
    put_command(STRING);
    plotxye(xunit,yunit,eunit,1);

    sprintf(STRING,"x t \"\" y t \"\" tit \"\" ret");
    put_command(STRING);
    plotxye(xunit,yunit,eunit,1);
    sprintf(STRING,
	"layout width %6.2f height %6.2f xlen %6.2f ylen %6.2f ret ret",
	#ifdef INCHES
		XL+1.5,YL+1.5,XL,YL);
	#endif
	#ifdef METRIC
		XL+ 4, YL+ 4, XL, YL);
	#endif
    put_command(STRING);
    plotxye(xunit,yunit,eunit,1);
    xunit[0] = yunit[0] = 0.;
    xunit[1] = A0;
    yunit[1] = 0.;
    xunit[2] = A0+A1*cos(RLAT[5]);
    yunit[2] = A1*sin(RLAT[5]);
    xunit[3] = A1*cos(RLAT[5]);
    yunit[3] = A1*sin(RLAT[5]);
    xunit[4] = yunit[4] = 0.;
    put_command(
	"layout ax 1 fr 0 gr 0 sub 0 ret curve 0 line 4 pl line 1 ret ret");
    plotxye(xunit,yunit,eunit,5);


    /* Draw all structure factors in frame : first fill 1/2 circles */


if ((mode == 1) || (mode == 3))
{

	/* theoritical structure factor*/
	sprintf(STRING, "col curve %s ret", color_fth);
	put_command(STRING);
    plotxye(xunit,yunit,eunit,1);

	for (i = 0; i < NTH; i++)
	    {
	    if (FTH[2][i] > FTHRESHOLD*fmax)
			{
			x1 = HTH[i]*A0+KTH[i]*A1*cos(RLAT[5]);
			y1 = KTH[i]*A1*sin(RLAT[5]);
			/*marker_size = (MINSIZE*(fmax-FTH[2][i])+
		    MAXSIZE*(FTH[2][i]-fmin))/(fmax-fmin);*/
			marker_size = FSIZE*(xmax-xmin)*FTH[2][i]/fmax;
			if (mode == 1) plot_circle(x1,y1,marker_size,0,1);
			if (mode == 3) plot_circle(x1,y1,marker_size,-1,1);
			}
	    }

}
if ((mode == 2) || (mode == 3))
{
	/* data structure factor*/
	sprintf(STRING, "col curve %s ret ret", color_fdata);
	put_command(STRING);
	plotxye(xunit,yunit,eunit,1);
	for (i = 0; i < NDAT; i++)
	    {
	    if (FDAT[i] > FTHRESHOLD*fmax)
			{
			x1 = HDAT[i]*A0+KDAT[i]*A1*cos(RLAT[5]);
			y1 = KDAT[i]*A1*sin(RLAT[5]);
			/*marker_size = (MINSIZE*(fmax-FDAT[i])+
		    MAXSIZE*(FDAT[i]-fmin))/(fmax-fmin);*/
			marker_size = FSIZE*(xmax-xmin)*FDAT[i]/fmax;
			if (mode == 2) plot_circle(x1,y1,marker_size,0,1);
			if (mode == 3) plot_circle(x1,y1,marker_size,1,1);
			}
	    }
}



   	/* Draw contour of structure factors  */
if ((mode == 1) || (mode == 3))
{
	/* theoritical structure factor*/

	sprintf(STRING, "col curve %s ret ret", color_cont_fth);
	put_command(STRING);
	plotxye(xunit,yunit,eunit,1);
	for (i = 0; i < NTH; i++)
	    {
	    if (FTH[2][i] > FTHRESHOLD*fmax)
			{
			x1 = HTH[i]*A0+KTH[i]*A1*cos(RLAT[5]);
			y1 = KTH[i]*A1*sin(RLAT[5]);
			/*marker_size = (MINSIZE*(fmax-FTH[2][i])+
		    MAXSIZE*(FTH[2][i]-fmin))/(fmax-fmin);*/
			marker_size = FSIZE*(xmax-xmin)*FTH[2][i]/fmax;
			if (mode == 1)plot_circle(x1,y1,marker_size,1,0);
			plot_circle(x1,y1,marker_size,-1,0);
			}
	    }

}

if ((mode == 2) || (mode == 3))
{

	/* data structure factor*/

	sprintf(STRING, "col curve %s ret ret", color_cont_fdata);
	put_command(STRING);
	plotxye(xunit,yunit,eunit,1);
	for (i = 0; i < NDAT; i++)
	    {
	    if (FDAT[i] > FTHRESHOLD*fmax)
			{
			x1 = HDAT[i]*A0+KDAT[i]*A1*cos(RLAT[5]);
			y1 = KDAT[i]*A1*sin(RLAT[5]);
			/*marker_size = (MINSIZE*(fmax-FDAT[i])+
		    MAXSIZE*(FDAT[i]-fmin))/(fmax-fmin);*/
			marker_size = FSIZE*(xmax-xmin)*FDAT[i]/fmax;
			if (mode == 2) plot_circle(x1,y1,marker_size,-1,0);
			plot_circle(x1,y1,marker_size,1,0);
			}
	    }
}

	sprintf(STRING,"x auto y auto ret ");
	put_command(STRING);
	plotxye(xunit,yunit,eunit,1);


	#endif


    } /* end of plot_sfac_mcsl */

/***************************************************************************/
void    loop_fit_mcsl(void)
/***************************************************************************/

 {
	#define set_fit_length	10
	static struct MENU set_fit_menu[set_fit_length] =
	{
		"l1oop", 	2,	1,	"first loop",
		"l2oop", 	2,	2,	"second loop",
		"l3oop", 	2,	3,	"third loop",
		"l4oop", 	2,	4,	"fourth loop",
		"l5oop", 	2,	5,	"fifth loop",
		"l6oop", 	2,	6,	"sixth loop",
		"run",		2,	10,	"Start fit",
		"list",		1,	12,	"List parameter values",
		"help",		1,	13,	"Display menu",
		"return",	1,	14,	"return"
	};


 int		stop = FALSE;
 int		i, NTOTRUN;
 char 		token[50], dummy[50];


	if (!NPAR)
		{
		sprintf(STRING, "ATT! you need to pass trough the fit menu FIRST\n");
		errtype(STRING);
		clear_command();
		return;
		}

	while (!stop)
		{
		if (!get_token (token, "ROD.EXT.MCSL.LOOP>"))
		break;
		switch (cmnd_match(token, set_fit_menu, set_fit_length))
			{
			case -1 :
				break;

			case 0 :
				break;

			case 1 :
				sprintf(STRING, "\nLOOP 1 :\n");
				type_line(STRING);
				set_loop_fit(1);
				break;

			case 2 :
				sprintf(STRING, "\nLOOP 2 :\n");
				type_line(STRING);
				set_loop_fit(2);
				break;

			case 3 :
				sprintf(STRING, "\nLOOP 3 :\n");
				type_line(STRING);
				set_loop_fit(3);
				break;

			case 4 :
				sprintf(STRING, "\nLOOP 4 :\n");
				type_line(STRING);
				set_loop_fit(4);
				break;

			case 5 :
				sprintf(STRING, "\nLOOP 5 :\n");
				type_line(STRING);
				set_loop_fit(5);
				break;

			case 6 :
				sprintf(STRING, "\nLOOP 6 :\n");
				type_line(STRING);
				set_loop_fit(6);
				break;
		case 10 :
				if (!NOUTFILE)
					{
					errtype ("    No output file     ");
					clear_command();
					break;
					}
				NFITAUTO=TRUE;
				fit_auto();
				NFITAUTO=FALSE;
				break;


			case 12 :
				NTOTRUN = 1;
				for (i=1; i<7 ;i++)
					{
					sprintf(STRING, "\nLOOP %1d \n",i);
					type_list(STRING,ROWS);


					if (PAR_LOOP[i]>0)
						sprintf (dummy,FITTXT[PAR_LOOP[i]-1]);
					else sprintf (dummy, "");
					sprintf(STRING, " parameter : %d %s\n" ,PAR_LOOP[i],dummy);
					type_list(STRING,ROWS);

					sprintf(STRING, "	initial value %5.3f \n" ,INIT_LOOP[i]);
					type_list(STRING,ROWS);
					sprintf(STRING, "	final value %5.3f \n" ,END_LOOP[i]);
					type_list(STRING,ROWS);
					sprintf(STRING, "	step %5.3f \n" ,STEP_LOOP[i]);
					type_list(STRING,ROWS);
					sprintf(STRING, "	number of step %d \n" ,NP_LOOP[i]);
					type_list(STRING,ROWS);
					NTOTRUN *= NP_LOOP[i];
					}

				sprintf(STRING,"\n Total number of fits : %d\n", NTOTRUN);
				type_list(STRING,ROWS);
				if (NOUTFILE)
					sprintf(STRING,"\n output file    :%s\n",TABFILENAME);
				else
					sprintf(STRING,"    No output file            \n");
				type_list(STRING,ROWS);
				sprintf(STRING," saved parameters: \n");
				type_list(STRING,ROWS);
				for (i = 0; i < NPAR; i++)
					{
					if (SAVPAR[i])
						{
						sprintf (STRING,"	%s\n",FITTXT[i]);
						type_list(STRING,ROWS);
						}
					}
				break;

			case 13 :
				list_menu ("LOOP FOR AUTOMATIC FITTING", set_fit_menu, set_fit_length);
				break;

			case 14 :
				stop = TRUE;
				break;

			} /* end of switch */

		}/* end of while */



    } /* end of loop_fit_mcsl */


/***************************************************************************/
void    set_loop_fit(int nloop)
/***************************************************************************/

 {

 	#define set_loop_length	8
 	static struct MENU set_loop_menu[set_loop_length] =
 	{
  		"lfit",  2,	5,	"List of the fit parameters",
		"par",   2,	1,	"Number of the parameter to vary",
 		"init",  1,	2,	"Initial value",
 		"end",   1,	3,	"End value",
 		"step",  1,	4,	"Step of the iteration",
 		"list",  1,	12,	"List of par. values of the loop",
 		"help",  1,	13,	"Display menu",
 		"return",1,	14,	"return"
	};

 int		stop = FALSE;
 char 		token[50], dummy[50];
 int		i;
 float 		nstep;

	while (!stop)
		{
		if (!get_token (token, "ROD.EXT.MCSL.LOOP.SET>"))
		break;
		switch (cmnd_match(token, set_loop_menu, set_loop_length))
			{
			case -1 :
				break;

			case 0 :
				break;

			case 1 :
				sprintf(STRING, "Serial number of the parameter [%d] :" ,PAR_LOOP[nloop]);
				PAR_LOOP[nloop] = get_int(PAR_LOOP[nloop],STRING);
				INIT_LOOP[nloop] = FITPAR[PAR_LOOP[nloop]-1];
				END_LOOP[nloop]  = FITPAR[PAR_LOOP[nloop]-1];

				sprintf(STRING, " %d %s [%5.3f]\n",
					PAR_LOOP[nloop], FITTXT[PAR_LOOP[nloop]-1],FITPAR[PAR_LOOP[nloop]-1]);
				type_line(STRING);
				SAVPAR[PAR_LOOP[nloop]-1] = TRUE;
				break;

			case 2 :
				sprintf(STRING, "	initial value [%5.3f] : " ,INIT_LOOP[nloop]);
				INIT_LOOP[nloop]= get_real(INIT_LOOP[nloop],STRING);
				break;

			case 3 :
				sprintf(STRING, "	final value [%5.3f] : " ,END_LOOP[nloop]);
				END_LOOP[nloop]= get_real(END_LOOP[nloop],STRING);
				break;

			case 4 :
				sprintf(STRING, "	step [%5.3f] : " ,STEP_LOOP[nloop]);
				STEP_LOOP[nloop]= get_real(STEP_LOOP[nloop],STRING);
				break;

			case 5 :
				for (i=0; i<NPAR; i++)
					{
					sprintf(STRING, " %d %s [%5.3f]\n",i+1, FITTXT[i],FITPAR[i]);
					type_list(STRING,ROWS);
					}
				break;

			case 12 :
				sprintf(STRING, "\nLOOP %1d :\n",nloop);
				type_list(STRING,ROWS);

				if (PAR_LOOP[nloop]>0)
					sprintf (dummy,FITTXT[PAR_LOOP[nloop]-1]);
				else sprintf (dummy, "");
				sprintf(STRING, " parameter : %d %s\n" ,PAR_LOOP[nloop],dummy);
				type_list(STRING,ROWS);

				sprintf(STRING, "	initial value %5.3f \n" ,INIT_LOOP[nloop]);
				type_list(STRING,ROWS);
				sprintf(STRING, "	final value %5.3f \n" ,END_LOOP[nloop]);
				type_list(STRING,ROWS);
				sprintf(STRING, "	step %5.3f \n" ,STEP_LOOP[nloop]);
				type_list(STRING,ROWS);

				if (STEP_LOOP[nloop]<1e-6) NP_LOOP[nloop]=1;
				else
					{
					nstep = (END_LOOP[nloop] - INIT_LOOP[nloop])/STEP_LOOP[nloop];
					NP_LOOP[nloop] =  (int)(nstep) + 1;
					}
				sprintf(STRING, "	number of step %d \n" ,NP_LOOP[nloop]);
				type_list(STRING,ROWS);
				break;

			case 13 :
				sprintf(STRING, "PARAMETER FOR THE LOOP %1d",nloop);
				list_menu (STRING, set_loop_menu, set_loop_length);
				break;

			case 14 :
				stop = TRUE;
				break;


			} /* end of switch */

		}/* end of while */

	if (STEP_LOOP[nloop]<1e-6) NP_LOOP[nloop]=1;
		else
			{
			nstep = (END_LOOP[nloop] - INIT_LOOP[nloop])/STEP_LOOP[nloop];
			NP_LOOP[nloop] =  (int)(nstep + 1e-5) + 1;
			}


    } /* end of set_loop_fit */


