/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                         fit.c                                 $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: fit.c,v 1.17 2003/09/18 08:03:06 svensson Exp $

****************************************************************************/

/***************************************************************************

  Changes:

Update 18/09/2003 O. Svensson (svensson@esrf.fr)
                  Added code written by Michael Dore for the "svensson"
                  extension (deformation of groups).
                  Added #ifdef ASAROD for lsqfit calls, added ffit_asa
                  function.

Update 25/02/2002 O. Svensson (svensson@esrf.fr)
                  Ported changes from standard version: 
                    Replace keat_calc() by energy_calc().
 Update 18/01/2001 M.C. Saint Lager (stlager@polycnrs-gre.fr)
 		- Include "../lsqfit/lsqfit.h" instead of <lsqfit.h> to recognize NFITAUTO
 		- Change in fit()
 			 - before the fit :
 			 	initialization of the array for fitting parameters
 			 	are gathered in the function init_fitpar()
 			 	which return the total number of fit parameter 'ntot' to fit()
 			 -after the fit
 			 	the copy of the values 'FITPAR' array
 			 	to corresponding model parameters is performed in update_par()
 		- fit_auto() (modified) transfered from mcsl.c
 			 	to allow  coherent changes with the function fit(),
 			    when it is necessary

 Update 22/09/2000 M.C. Saint Lager (stlager@polycnrs-gre.fr)
                  Added in extension Mcsl the possibility to save
                  fit and result parameters.

  21/10/91:  Introduced penalty factors for fit parameters
  24/10/91:  Calculate "goodness" of fit
  11/11/91:  penalty factors are now always 0 or 10000

****************************************************************************/

#define LARGE_PENALTY 1e4	/* useful penalty factor */
#define NO_PENALTY    0

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#define FIT
#include "rod.h"
#ifdef EXTENSIONS /* Mcsl */
#include "../lsqfit/lsqfit.h"
#else
#include <lsqfit.h>
#endif /* EXTENSIONS Mcsl */

/***************************************************************************/
void    fit(void)
/***************************************************************************/

    /*
    Fit the experimental rod data.
    */

    {

    int 	freepar[MAXFIT],nfree;
    int 	i, ntot;
    float   chisqr,q;
    float	penalties[MAXFIT];
    int 	rc;
    float   index[MAXDATA];

#ifdef EXTENSIONS /* Mcsl */
	int		nsav;
    float   chisqr_norm, r_factor, sum_dat;
#endif /* EXTENSIONS Mcsl */

#ifdef EXTENSIONS /* Robach */
    int nsf;

    if (robach_flag) nsf = NSF_OR;
    else nsf = NSF;
#endif /* EXTENSIONS Robach */

    /* Check whether data has been read in */

    if (NDAT < 1)
	{
	errtype("ERROR, no data read in");
	clear_command();
	return;
	}

    /* Check whether model has been read in */

#ifdef EXTENSIONS /* Svensson */
    if (svensson_flag)
    {
      if ((NSURF+NBULK < 1) && (NGROUPSS < 1) &&
	  (NCYLINDERS < 1) && (NELLIPSOIDS < 1))
      {
	errtype("ERROR, no model read in");
	clear_command();
	return;
      }
      else if (NGROUPSS)
      {
	if (NATOMSINGROUPS[0] < 1)
	{
	  errtype("ERROR, no model read in");
	  clear_command();
	  return;
	}
      }
    } else
#endif /* EXTENSIONS Svensson */
    if (NSURF+NBULK < 1)
	{
	errtype("ERROR, no model read in");
	clear_command();
	return;
	}

    /* Check whether there are not too many fit parameters */

#ifdef EXTENSIONS /* Robach  & Svensson */
    if ((robach_flag) && (!svensson_flag))
    {
      if (nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT > MAXFIT)
      {
	errtype("ERROR, number of fitting parameters exceeds MAXFIT");
	clear_command();
	return;
      }
    } else if ((!robach_flag) && (svensson_flag))
    {
      if (NSF + NDISTOT + NDWTOT + NDWTOT2 + NOCCTOT +
	  NDISGROUPSTOT + NDWGROUPSTOT + 
	  NEXPANGROUPSTOT + NSHEARGROUPSTOT +  /* Added by Michael Dore */
	  NDISCYLINDERSTOT + NCHARGEDENSITYCYLINDERSTOT +
	  NDISELLIPSOIDSTOT + NCHARGEDENSITYELLIPSOIDSTOT > MAXFIT)
      {
	errtype("ERROR, number of fitting parameters exceeds MAXFIT");
	clear_command();
	return;
      }
    } else if ((robach_flag) && (svensson_flag))
    {
      if (nsf + NDISTOT + NDWTOT + NDWTOT2 + NOCCTOT +
	  NDISGROUPSTOT + NDWGROUPSTOT +
	  NEXPANGROUPSTOT + NSHEARGROUPSTOT + /* Added by Michael Dore */
	  NDISCYLINDERSTOT + NCHARGEDENSITYCYLINDERSTOT +
	  NDISELLIPSOIDSTOT + NCHARGEDENSITYELLIPSOIDSTOT > MAXFIT)
      {
	errtype("ERROR, number of fitting parameters exceeds MAXFIT");
	clear_command();
	return;
      }
    } else
#endif /* EXTENSIONS Robach & Svensson */
    if (NSF+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT > MAXFIT)
	{
	errtype("ERROR, number of fitting parameters exceeds MAXFIT");
	clear_command();
	return;
	}


    ntot= init_fitpar();

    /* Add fake data point when Keating energy is added in the
    least-squares minimization */

    if (KEAT_PLUS_CHI)
	{
	if (NDAT == MAXDATA)
	    {
	    errtype("ERROR, too many data points to add Keating");
	    KEAT_PLUS_CHI = FALSE;
	    }
	else
	    {
	    NDAT++;
	    HDAT[NDAT-1] = 100.;
	    KDAT[NDAT-1] = 0.;
	    LDAT[NDAT-1] = 0.1;
	    FDAT[NDAT-1] = 0.;
	    ERRDAT[NDAT-1] = 1.;
	    }
	}

    /* Compute weight of data points */

    for (i = 0; i < NDAT; i++)
	{
	if (ERRDAT[i] > 1e-5)
	    FWEIGHT[i] = 1/sqr(ERRDAT[i]);
	else
	    FWEIGHT[i] = 0.;
	}

    /* Generate array with index numbers of (hkl)-points to be used as
    x-values of fit */

    for (i = 0; i < NDAT; i++)
	index[i] = (float) i;

#ifdef SPEEDUP

    /* Calculate and store constant values, in order to speed up
    fitting */
#ifdef EXTENSIONS /* Robach 100901*/
	if ((robach_flag)&&(anomalous_flag == COMPLEX_fat))
		f_calc_fit_init_cx();
	else
#endif /* EXTENSIONS Robach */
    f_calc_fit_init();

#endif

#ifdef EXTENSIONS /* Mcsl */
	if(NFITAUTO)
		{
    	fit_auto();
    	return;
		}
#endif /* EXTENSIONS Mcsl */


    /* allow user to manipulate fit parameters */



    rc = set_fitpar("ROD.FIT>",
               ntot,
               FITPAR, FITMIN, FITMAX,
               FITPEN, FIXPAR,
               FITTXT[0], TITLE_LENGTH,
               index,FDAT,FWEIGHT,NDAT, ffit
               );

    /* Get number of free parameters and make array with free parameter
    numbers */

    nfree = 0;
    for (i = 0; i < ntot; i++)
	{
	if (!FIXPAR[i])
	    {
	    freepar[nfree] = i+1;
	    nfree++;
	    }
	}

    /* Prepare penalty factors for lsqfit: */

    for (i=0; i<ntot; i++)
	    penalties[i] = (FITPEN[i] == TRUE ? LARGE_PENALTY : NO_PENALTY);

    /* Do the fit */

    if (rc != LSQ_NOFIT)
	rc = lsqfit(index,FDAT,FWEIGHT,NDAT,FITPAR,ntot,
		freepar,nfree,FITERR,FITMIN,FITMAX,penalties,&chisqr,ffit,
#ifdef ASAROD
		    ffit_asa,
#endif
		FITTXT[0], TITLE_LENGTH, 0, rc, 1);

    /* Copy values in array 'FITPAR' to corresponding model parameters and
    update structure model */

    for(i=0; i<ntot; i++)
	FITPEN[i] = (penalties[i] != 0 ? TRUE : FALSE);

	update_par();
    update_model();

    /* Remove fake data point used for Keating energy */

    if (KEAT_PLUS_CHI) NDAT--;

    /* Calculate theoretical structure factors for all data points */

    for (i = 0; i < NDAT; i++)
	{
	HTH[i] = HDAT[i];
	KTH[i] = KDAT[i];
	LTH[i] = LDAT[i];
#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
	{
		if (ratio_flag == 0)
			if (anomalous_flag == REAL_fat)
				f_calc(HDAT[i],KDAT[i],LDAT[i],ATTEN,LBR[i],
			    		&FTH[0][i],&FTH[1][i],&FTH[2][i],&PHASE[i]);
			else if (anomalous_flag == COMPLEX_fat)
				f_calc_cx(HDAT[i],KDAT[i],LDAT[i],ATTEN,LBR[i],
			    		&FTH[0][i],&FTH[1][i],&FTH[2][i],&PHASE[i]);
		else if (ratio_flag == 1)
		{
			ratio_calc(HDAT[i],KDAT[i],LDAT[i],ATTEN,LBR[i],
			    &FTH[0][i],&FTH[1][i],&FTH[2][i]);
			PHASE[i]=0.;
		}
	}
	else
#endif /* EXTENSIONS Robach */
	f_calc(HDAT[i],KDAT[i],LDAT[i],ATTEN,LBR[i],
	    &FTH[0][i],&FTH[1][i],&FTH[2][i],&PHASE[i]);

	}
    NTH = NDAT;
#ifdef EXTENSIONS /* Mcsl */
if (mcsl_flag)
	{
	/* Calculate R-factor */
	r_factor = 0.;
	sum_dat =0.;
	for (i = 0; i < NDAT; i++)
		{
			r_factor += fabs(FTH[2][i]-FDAT[i]);
			sum_dat +=FDAT[i];
		}

	sprintf (STRING, "R factor = %.5f", r_factor);
	type_line (STRING);
	sprintf (STRING, ", normalized     %.5f\n", r_factor/sum_dat);
	type_line (STRING);

	/* save fit value in the tabfile */
	nsav = 0;
	if (NOUTFILE)
		{
		for (i = 0; i < NPAR; i++)
			{
			if (SAVPAR[i]==TRUE)
				{
				fprintf (TABFILE, "%8.4f", FITPAR[i]);
				nsav=1;
				}
			}
		}
	else
		type_line ("no output file \n");

	if (nsav==1)
		{
		chisqr_norm = chisqr / (NDAT - nfree + 1e-10); /* Save chisqr*/
		fprintf (TABFILE,"     %.5f    %.5f\n",chisqr_norm,r_factor/sum_dat);
		fflush(TABFILE);
		}
	}
#endif /* EXTENSIONS Mcsl */

    }


#ifdef EXTENSIONS /* Mcsl */
/***************************************************************************/
void    fit_auto(void)
/***************************************************************************/

    /*
    Automatic fit the experimental rod data.
    */

    {
    int 	i,j;
    int 	freepar[MAXFIT],nfree;
    int 	ntot;
    float   chisqr,q;
    float	penalties[MAXFIT];
    int 	rc;
    float   index[MAXDATA];


	int		NTOTRUN,Nrun,i0[10];
	int		nsav;
    float   chisqr_norm, r_factor, sum_dat;




	ntot=NPAR;
	 /* Generate array with index numbers of (hkl)-points to be used as
	    x-values of fit */

	for (i = 0; i < NDAT; i++)
		index[i] = (float) i;

		    /* allow user to manipulate fit parameters */
	 rc = set_fitpar("ROD.EXT.MCSL.LOOP.FIT>",
		  ntot,
		  FITPAR, FITMIN, FITMAX,
		  FITPEN, FIXPAR,
		  FITTXT[0], TITLE_LENGTH,
		  index,FDAT,FWEIGHT,NDAT, ffit
		  );

		    /* Get number of free parameters and make array with free parameter
		    numbers */

		    nfree = 0;
		    for (i = 0; i < ntot; i++)
			{
			if (!FIXPAR[i])
			    {
			    freepar[nfree] = i+1;
			    nfree++;
			    }
			}

		    /* Prepare penalty factors for lsqfit: */

		    for (i=0; i<ntot; i++)
			    penalties[i] = (FITPEN[i] == TRUE ? LARGE_PENALTY : NO_PENALTY);


		/* Prepare the the parameters to save
		and the columns tiltle for the output file */

    	for (i = 0; i < NPAR; i++)
			if (!FIXPAR[i])
	    		SAVPAR[i] = TRUE;

    	for (j = 1; j < 7; j++)
	    	SAVPAR[PAR_LOOP[j]-1] = TRUE;

		for (i = 0; i < NPAR; i++)
			{
			if (SAVPAR[i])
				fprintf (TABFILE,"%s    ",FITTXT[i]);
			}
			fprintf (TABFILE,"    chisqr    R-factor\n");
			fflush(TABFILE);

    	/* Enter in the loops when fit_auto */

    	NTOTRUN=1;
    	Nrun=0;
    	for (j=1; j<7; j++)
    	if (NP_LOOP[j]>0)
    		NTOTRUN *= NP_LOOP[j];
    	sprintf (STRING, "Total number of fits: %d \n", NTOTRUN);
		type_line (STRING);


		for (i0[1]=0; i0[1]< (NP_LOOP[1])  ; i0[1]++)
		{/*loop 1*/
		j=1;
		if (PAR_LOOP[j]>0)
			FITPAR[PAR_LOOP[j]-1]= INIT_LOOP[j] + i0[j]*STEP_LOOP[j];
		j++ ;
		for (i0[j]=0; i0[j]< (NP_LOOP[j]) ; i0[j]++)
			{/*loop 2*/
			j=2;
			if (PAR_LOOP[j]>0)
				FITPAR[PAR_LOOP[j]-1]= INIT_LOOP[j] + i0[j]*STEP_LOOP[j];
			j++ ;

			for (i0[j]=0; (i0[j]< (NP_LOOP[j])) ; i0[j]++)
				{/*loop 3*/
				j=3;
				if (PAR_LOOP[j]>0)
					FITPAR[PAR_LOOP[j]-1]= INIT_LOOP[j] + i0[j]*STEP_LOOP[j];
				j++ ;

				for (i0[j]=0; (i0[j]< (NP_LOOP[j]) ) ; i0[j]++)
					{/*loop 4*/
					j=4;
						if (PAR_LOOP[j]>0)
						FITPAR[PAR_LOOP[j]-1]= INIT_LOOP[j] + i0[j]*STEP_LOOP[j];
					j++ ;

					for (i0[j]=0; (i0[j]< (NP_LOOP[j])) ; i0[j]++)
						{/*loop 5*/
						j=5;
						if (PAR_LOOP[j]>0)
							FITPAR[PAR_LOOP[j]-1]= INIT_LOOP[j] + i0[j]*STEP_LOOP[j];
						j++ ;

						for (i0[j]=0; (i0[j]< (NP_LOOP[j]) ) ; i0[j]++)
							{/*loop 6*/
							j=6;
							if (PAR_LOOP[j]>0)
								FITPAR[PAR_LOOP[j]-1]= INIT_LOOP[j] + i0[j]*STEP_LOOP[j];




	Nrun++;
	sprintf (STRING, "  %d", Nrun);
	type_line (STRING);


    if (rc != LSQ_NOFIT)
	rc = lsqfit(index,FDAT,FWEIGHT,NDAT,FITPAR,ntot,
		freepar,nfree,FITERR,FITMIN,FITMAX,penalties,&chisqr,ffit,
		FITTXT[0], TITLE_LENGTH, 0, rc, 1);

    /* Copy values in array 'FITPAR' to corresponding model parameters and
    update structure model */

    for(i=0; i<ntot; i++)
	FITPEN[i] = (penalties[i] != 0 ? TRUE : FALSE);


	update_par();
    update_model();

    /* Remove fake data point used for Keating energy */

    if (KEAT_PLUS_CHI) NDAT--;

    /* Calculate theoretical structure factors for all data points */

    for (i = 0; i < NDAT; i++)
	{
	HTH[i] = HDAT[i];
	KTH[i] = KDAT[i];
	LTH[i] = LDAT[i];
#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
	{
		if (ratio_flag == 0)
			if (anomalous_flag == REAL_fat)
				f_calc(HDAT[i],KDAT[i],LDAT[i],ATTEN,LBR[i],
			    		&FTH[0][i],&FTH[1][i],&FTH[2][i],&PHASE[i]);
			else if (anomalous_flag == COMPLEX_fat)
				f_calc_cx(HDAT[i],KDAT[i],LDAT[i],ATTEN,LBR[i],
			    		&FTH[0][i],&FTH[1][i],&FTH[2][i],&PHASE[i]);
		else if (ratio_flag == 1)
		{
			ratio_calc(HDAT[i],KDAT[i],LDAT[i],ATTEN,LBR[i],
			    &FTH[0][i],&FTH[1][i],&FTH[2][i]);
			PHASE[i]=0.;
		}
	}
	else
#endif /* EXTENSIONS Robach */
	f_calc(HDAT[i],KDAT[i],LDAT[i],ATTEN,LBR[i],
	    &FTH[0][i],&FTH[1][i],&FTH[2][i],&PHASE[i]);

	}
    NTH = NDAT;


	/* Calculate R-factor */
	r_factor = 0.;
	sum_dat =0.;
	for (i = 0; i < NDAT; i++)
		{
			r_factor += fabs(FTH[2][i]-FDAT[i]);
			sum_dat +=FDAT[i];
		}

	/* save fit value in the tabfile */
	nsav = 0;
	for (i = 0; i < NPAR; i++)
		{
		if (SAVPAR[i]==TRUE)
			{
			fprintf (TABFILE, "%8.4f", FITPAR[i]);
			nsav=1;
			}
		}

	if (nsav==1)
		{
		chisqr_norm = chisqr / (NDAT - nfree + 1e-10); /* Save chisqr*/
		fprintf (TABFILE,"     %.5f    %.5f\n",chisqr_norm,r_factor/sum_dat);
		fflush(TABFILE);
		}

					}	/* end of the LOOP j=6 */
				j--;
				}	/* end of the LOOP j=5 */
			j--;
			}	/* end of the LOOP j=4 */
		j--;
		}	/* end of the LOOP j=3 */
	j--;
	}	/* end of the LOOP j=2 */
j--;
}	/* end of the LOOP j=1 */

NFITAUTO=FALSE;
type_line ("\n");

}
/***********************************************************************************/
#endif /* EXTENSIONS Mcsl */


/***************************************************************************/
void    ffit(float x, float a[], float *y, float dyda[], int na,
	    int derivatives)
/***************************************************************************/

    /*
    Function called by fitting routines to compute y-values and, optionally,
    derivatives with respect to fitting parameters.
    */

    {

    int i,j;
    float       fbulk,fsurf,phase;

#ifdef EXTENSIONS /* Svensson*/
    int ndxtot;
#endif /* EXTENSIONS Svensson*/
#ifdef EXTENSIONS /* Robach */
    float fsub, ftot;
    int nsf;

    if (robach_flag) nsf = NSF_OR;
	else	nsf = NSF;
#endif /* EXTENSIONS Robach */

    SCALE = a[0];

#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
		SCALE3= a[1];
	else
#endif /* EXTENSIONS Robach */
		SCALE2= a[1];
/* add220800*/
#ifdef EXTENSIONS /* Robach */
	if ((robach_flag)&&(var_nlayers))
		SIGMA= a[2];
	else
#endif
    		BETA = a[2];
/*endadd220800 */
    SURFFRAC = a[3];

#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
	{
		LSHIFT = a[4];
		SURF2FRAC=a[5];
		WIDTH=a[6];
	}
#endif /* EXTENSIONS Robach */

    for (j = 0; j < NDISTOT; j++)
	{
#ifdef EXTENSIONS /* Robach */
	DISPL[j] = a[j+nsf];
#else
	DISPL[j] = a[j+NSF];
#endif /* EXTENSIONS Robach */
	}
    for (j = 0; j < NDWTOT; j++)
	{
#ifdef EXTENSIONS /* Robach */
	DEBWAL[j] = a[j+nsf+NDISTOT];
#else
	DEBWAL[j] = a[j+NSF+NDISTOT];
#endif /* EXTENSIONS Robach */
	}
    for (j = 0; j < NDWTOT2; j++)
	{
#ifdef EXTENSIONS /* Robach */
	DEBWAL2[j] = a[j+nsf+NDISTOT+NDWTOT];
#else
	DEBWAL2[j] = a[j+NSF+NDISTOT+NDWTOT];
#endif /* EXTENSIONS Robach */
	}
    for (j = 0; j < NOCCTOT; j++)
	{
#ifdef EXTENSIONS /* Robach */
	OCCUP[j] = a[j+nsf+NDISTOT+NDWTOT+NDWTOT2];
#else
	OCCUP[j] = a[j+NSF+NDISTOT+NDWTOT+NDWTOT2];
#endif /* EXTENSIONS Robach */
	}
#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
	{
		for (i=0;i<NZFUNCTOT;i++)
		{
			ZFUNC[i].ZPAR[0]=a[3*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT];
			ZFUNC[i].ZPAR[1]=a[1+3*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT];
			ZFUNC[i].ZPAR[2]=a[2+3*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT];
			ZFUNC[i].ZPAR[3]=a[3+3*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT];
		}
		for (i=0;i<NOFUNCTOT;i++)
		{
			OFUNC[i].OPAR[0]=a[2*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT+4*NZFUNCTOT];
			OFUNC[i].OPAR[1]=a[1+2*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT+4*NZFUNCTOT];
		}
/* addOR050901 */
		for (i=0;i<NSLAB;i++)                                                   
		{
			SLAB[i].SPAR[0]=a[4*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT+4*NZFUNCTOT+2*NOFUNCTOT];
			SLAB[i].SPAR[1]=a[1+4*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT+4*NZFUNCTOT+2*NOFUNCTOT];
			SLAB[i].SPAR[2]=a[2+4*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT+4*NZFUNCTOT+2*NOFUNCTOT];
			SLAB[i].SPAR[3]=a[3+4*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT+4*NZFUNCTOT+2*NOFUNCTOT]; 
		}
/* endaddOR050901 */
	}
#endif /* EXTENSIONS Robach */
#ifdef EXTENSIONS /* Svensson */
	if (svensson_flag)
	{
	  ndxtot = nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT;
/* modifOR050901 */
	  if (robach_flag)
	  {
	    ndxtot = ndxtot+4*NZFUNCTOT+2*NOFUNCTOT+4*NSLAB;
	  }
/* endmodifOR050901 */
	  for (i = 0; i < NDISGROUPSTOT; i++)
	  {
	    DISPLGROUPS[i] = a[i+ndxtot];
	  }
	  ndxtot += NDISGROUPSTOT;
	  for (i = 0; i < NDWGROUPSTOT; i++)
	  {
	    DEBWALGROUPS[i] = a[i+ndxtot];
	  }
	  ndxtot += NDWGROUPSTOT;
	  for (i = 0; i < NDISCYLINDERSTOT; i++)
	  {
	    DISPLCYLINDERSPAR[i] = a[i+ndxtot];
	  }
	  ndxtot += NDISCYLINDERSTOT;
	  for (i = 0; i < NCHARGEDENSITYCYLINDERSTOT; i++)
	  {
	    CHARGEDENSITYOFCYLINDERSPAR[i] = a[i+ndxtot];
	  }
	  ndxtot += NCHARGEDENSITYCYLINDERSTOT;
	  for (i = 0; i < NDISELLIPSOIDSTOT; i++)
	  {
	    DISPLELLIPSOIDSPAR[i] = a[i+ndxtot];
	  }
	  ndxtot += NDISELLIPSOIDSTOT;
	  for (i = 0; i < NCHARGEDENSITYELLIPSOIDSTOT; i++)
	  {
	    CHARGEDENSITYOFELLIPSOIDSPAR[i] = a[i+ndxtot];
	  }
	  ndxtot += NCHARGEDENSITYELLIPSOIDSTOT;
	  /* Start addition by Michael Dore */
	  for (i = 0; i < NEXPANGROUPSTOT ; i++)
	  {
	  func_deform[0].defgroups[i]=a[ndxtot+i];
	  }
	  ndxtot +=NEXPANGROUPSTOT;
	  for (i = 0; i < NSHEARGROUPSTOT ; i++)
	  {
	  func_deform[1].defgroups[i]=a[ndxtot+i];
	  }
	  ndxtot +=NSHEARGROUPSTOT;
	  /* End addition by Michael Dore */
	 
	 }
#endif /* EXTENSIONS Svensson */

    /* Calculate structure model with new parameters */

    update_model();

    /* Calculate theoretical structure factor */

    i = (int) x; /* this is the index of the current data point */
    LBRAGG = LBR[i];

    /* Try to add keating energy */
    if (HDAT[i] > 99.)
	{
	*y = sqrt(energy_calc());
	}
    else
    {
#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
	{
   		if (ratio_flag == 0)
		{
#ifdef SPEEDUP
			if (anomalous_flag== COMPLEX_fat)
	  			*y = f_calc_fit_cx(HDAT[i], KDAT[i], LDAT[i], LBR[i], Q_PAR[i], Q_PERP[i],
				   	RE_FAT[i], IM_FAT[i], RE_BULK[i], IM_BULK[i], FBULK_SQR[i]);
			else if (anomalous_flag == REAL_fat)
  				*y = f_calc_fit (HDAT[i], KDAT[i], LDAT[i], LBR[i], Q_PAR[i], Q_PERP[i],
				   	FAT[i], RE_BULK[i], IM_BULK[i], FBULK_SQR[i]);
#else
			if (anomalous_flag== COMPLEX_fat)
		    		f_calc_cx(HDAT[i],KDAT[i],LDAT[i],ATTEN,LBR[i],&fbulk,&fsurf,y,&phase);
			else if (anomalous_flag == REAL_fat)
		    		f_calc(HDAT[i],KDAT[i],LDAT[i],ATTEN,LBR[i],&fbulk,&fsurf,y,&phase);
#endif
		}
		else if (ratio_flag == 1)
			ratio_calc(HDAT[i],KDAT[i],LDAT[i],ATTEN,LBR[i],&fsub,&ftot,y);
	}
	else
	{
#endif /* EXTENSIONS Robach */
#ifdef SPEEDUP
    *y = f_calc_fit(HDAT[i],KDAT[i],LDAT[i],LBR[i],Q_PAR[i],Q_PERP[i],
		FAT[i],RE_BULK[i],IM_BULK[i],FBULK_SQR[i]);
#else
    f_calc(HDAT[i],KDAT[i],LDAT[i],ATTEN,LBR[i],&fbulk,&fsurf,y,&phase);
#endif

#ifdef EXTENSIONS /* Robach */
    }
#endif /* EXTENSIONS Robach */
    }

    dyda=dyda; na=na; derivatives=derivatives; /* prevent compiler warning */

    }

/***************************************************************************/
int    init_fitpar(void)
/***************************************************************************/

    /*
 	Copy all fitting parameters to one array FITPAR, get starting
    values, and return the total number of fit parameters
    */

    {

    int 	i,ndx,ntot;

#ifdef EXTENSIONS /* Svensson */
    int ndxtot;
#endif /* EXTENSIONS Svensson */


#ifdef EXTENSIONS /* Robach */
    int nsf;

    if (robach_flag) nsf = NSF_OR;
    else nsf = NSF;
#endif /* EXTENSIONS Robach */

    FITPAR[0] = SCALE;
    FITMIN[0] = SCALELIM[0];
    FITMAX[0] = SCALELIM[1];
    FITPEN[0] = SCALEPEN;

#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
	{
		FITPAR[1] = SCALE3;
    		FITMIN[1] = SCALE3LIM[0];
    		FITMAX[1] = SCALE3LIM[1];
    		FITPEN[1] = SCALE3PEN;
	}
	else
#endif /* EXTENSIONS Robach */
	{
	    	FITPAR[1] = SCALE2;
	    	FITMIN[1] = SCALE2LIM[0];
		FITMAX[1] = SCALE2LIM[1];
		FITPEN[1] = SCALE2PEN;
	}
/* add220800 */
#ifdef EXTENSIONS /* Robach */
	if ((robach_flag)&&(var_nlayers))
	{
		FITPAR[2] = SIGMA;
    		FITMIN[2] = SIGMALIM[0];
		FITMAX[2] = SIGMALIM[1];
		FITPEN[2] = SIGMAPEN;
	}
	else
#endif
	{
		FITPAR[2] = BETA;
    		FITMIN[2] = BETALIM[0];
		FITMAX[2] = BETALIM[1];
		FITPEN[2] = BETAPEN;
	}
/*endadd220800*/

    FITPAR[3] = SURFFRAC;
    FITMIN[3] = SURFFRACLIM[0];
    FITMAX[3] = SURFFRACLIM[1];
    FITPEN[3] = SURFFRACPEN;

#ifdef EXTENSIONS /* Robach */
    if (robach_flag)
    {
      FITPAR[4] = LSHIFT ;
	FITMIN[4] = LSHIFTLIM[0];
	FITMAX[4] = LSHIFTLIM[1];
	FITPEN[4] = LSHIFTPEN;

	FITPAR[5] = SURF2FRAC;
	FITMIN[5] = SURF2FRACLIM[0];
	FITMAX[5] = SURF2FRACLIM[1];
	FITPEN[5] = SURF2FRACPEN;

	FITPAR[6] = WIDTH;
	FITMIN[6] = WIDTHLIM[0];
	FITMAX[6] = WIDTHLIM[1];
	FITPEN[6] = WIDTHPEN;
    }
#endif /* EXTENSIONS Robach */

    sprintf(FITTXT[0],"Scale");

#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
		sprintf(FITTXT[1],"Scale3");
	else
#endif /* EXTENSIONS Robach */
		sprintf(FITTXT[1],"Scale2");

/* add 220800 */

#ifdef EXTENSIONS /* Robach */
	if ((robach_flag)&&(var_nlayers))
		sprintf(FITTXT[2],"Sigma");
	else
#endif
    		sprintf(FITTXT[2],"Beta");
    sprintf(FITTXT[3],"Surface fraction");

/* endadd220800 */

#ifdef EXTENSIONS /* Robach */
    if (robach_flag)
    {
      sprintf(FITTXT[4],"Lshift");
	sprintf(FITTXT[5],"S2");
	sprintf(FITTXT[6],"Width");
    }
#endif /* EXTENSIONS Robach */

    for (i = 0; i < NDISTOT; i++)
	{
#ifdef EXTENSIONS /* Robach */
	ndx = i+nsf;
#else
	ndx = i+NSF;
#endif /* EXTENSIONS Robach */
	FITPAR[ndx] = DISPL[i];
	FITMIN[ndx] = DISPLLIM[i][0];
	FITMAX[ndx] = DISPLLIM[i][1];
	FITPEN[ndx] = DISPLPEN[i];
	sprintf(FITTXT[ndx],"Displacement %2d",i+1);
	}
    for (i = 0; i < NDWTOT; i++)
	{
#ifdef EXTENSIONS /* Robach */
	ndx = i+nsf+NDISTOT;
#else
	ndx = i+NSF+NDISTOT;
#endif /* EXTENSIONS Robach */
	FITPAR[ndx] = DEBWAL[i];
	FITMIN[ndx] = DEBWALLIM[i][0];
	FITMAX[ndx] = DEBWALLIM[i][1];
	FITPEN[ndx] = DEBWALPEN[i];
	sprintf(FITTXT[ndx],"In-plane DW %2d",i+1);
	}
    for (i = 0; i < NDWTOT2; i++)
	{
#ifdef EXTENSIONS /* Robach */
	ndx = i+nsf+NDISTOT+NDWTOT;
#else
	ndx = i+NSF+NDISTOT+NDWTOT;
#endif /* EXTENSIONS Robach */
	FITPAR[ndx] = DEBWAL2[i];
	FITMIN[ndx] = DEBWAL2LIM[i][0];
	FITMAX[ndx] = DEBWAL2LIM[i][1];
	FITPEN[ndx] = DEBWAL2PEN[i];
	sprintf(FITTXT[ndx],"Out-of-plane DW %2d",i+1);
	}
    for (i = 0; i < NOCCTOT; i++)
	{
#ifdef EXTENSIONS /* Robach */
	ndx = i+nsf+NDISTOT+NDWTOT+NDWTOT2;
#else
	ndx = i+NSF+NDISTOT+NDWTOT+NDWTOT2;
#endif /* EXTENSIONS Robach */
	FITPAR[ndx] = OCCUP[i];
	FITMIN[ndx] = OCCUPLIM[i][0];
	FITMAX[ndx] = OCCUPLIM[i][1];
	FITPEN[ndx] = OCCUPPEN[i];
	sprintf(FITTXT[ndx],"Occupancy %2d",i+1);
	}

#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
	{
		for (i=0;i<NZFUNCTOT;i++)
		{
			ndx=3*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT;
			FITPAR[ndx]=ZFUNC[i].ZPAR[0];
			FITMIN[ndx]=ZFUNC[i].ZPARLIM[0][0];
			FITMAX[ndx]=ZFUNC[i].ZPARLIM[0][1];
			FITPEN[ndx]=ZFUNC[i].ZPARPEN[0];
			sprintf(FITTXT[ndx],"z function %d dzinf",i+1);
			FITPAR[ndx+1]=ZFUNC[i].ZPAR[1];
			FITMIN[ndx+1]=ZFUNC[i].ZPARLIM[1][0];
			FITMAX[ndx+1]=ZFUNC[i].ZPARLIM[1][1];
			FITPEN[ndx+1]=ZFUNC[i].ZPARPEN[1];
			if (ZFUNC[i].type==0) sprintf(FITTXT[ndx+1],"not used");
			else sprintf(FITTXT[ndx+1],"z function %d dz0",i+1);
			FITPAR[ndx+2]=ZFUNC[i].ZPAR[2];
			FITMIN[ndx+2]=ZFUNC[i].ZPARLIM[2][0];
			FITMAX[ndx+2]=ZFUNC[i].ZPARLIM[2][1];
			FITPEN[ndx+2]=ZFUNC[i].ZPARPEN[2];
			if ((ZFUNC[i].type==0)||(ZFUNC[i].type==2))
				 sprintf(FITTXT[ndx+2],"not used");
			else sprintf(FITTXT[ndx+2],"z function %d sigmaz",i+1);
			FITPAR[ndx+3]=ZFUNC[i].ZPAR[3];
			FITMIN[ndx+3]=ZFUNC[i].ZPARLIM[3][0];
			FITMAX[ndx+3]=ZFUNC[i].ZPARLIM[3][1];
			FITPEN[ndx+3]=ZFUNC[i].ZPARPEN[3];
			if (ZFUNC[i].type==3) sprintf(FITTXT[ndx+3],"z function %d zmeanz",i+1);
			else sprintf(FITTXT[ndx+3],"not used");
		}
		for (i=0;i<NOFUNCTOT;i++)
		{
			ndx=2*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT+4*NZFUNCTOT;
			FITPAR[ndx]=OFUNC[i].OPAR[0];
			FITMIN[ndx]=OFUNC[i].OPARLIM[0][0];
			FITMAX[ndx]=OFUNC[i].OPARLIM[0][1];
			FITPEN[ndx]=OFUNC[i].OPARPEN[0];
			switch (OFUNC[i].type)
			{
				case 0:
					sprintf(FITTXT[ndx],"o function %d zmeano",i+1);
					sprintf(FITTXT[ndx+1],"not used",i+1);
					break;
				case 1:
				case 2:
				case 3:
				case 4:
					sprintf(FITTXT[ndx],"o function %d zmeano",i+1);
					sprintf(FITTXT[ndx+1],"o function %d sigmao",i+1);
					break;
				case 5 :	
					sprintf(FITTXT[ndx],"o function %d nmean",i+1);
					sprintf(FITTXT[ndx+1],"o function %d beta",i+1);
					break;
			}		
			FITPAR[ndx+1]=OFUNC[i].OPAR[1];
			FITMIN[ndx+1]=OFUNC[i].OPARLIM[1][0];
			FITMAX[ndx+1]=OFUNC[i].OPARLIM[1][1];
			FITPEN[ndx+1]=OFUNC[i].OPARPEN[1];
		}
/* addOR050901 */
		for (i=0;i<NSLAB;i++)
		{
			ndx=4*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT+4*NZFUNCTOT+2*NOFUNCTOT;
			sprintf(FITTXT[ndx],"%2s fraction(slab %d)",ELEMENT[TS[alloy_atom[0]]],i+1);
			sprintf(FITTXT[ndx+1],"occmax(slab %d)",i+1);
			sprintf(FITTXT[ndx+2],"thickness(slab %d)",i+1);
			sprintf(FITTXT[ndx+3],"roughness(slab %d)",i+1);
			FITPAR[ndx]=SLAB[i].SPAR[0];
			FITMIN[ndx]=SLAB[i].SPARLIM[0][0];
			FITMAX[ndx]=SLAB[i].SPARLIM[0][1];
			FITPEN[ndx]=SLAB[i].SPARPEN[0]; 
			FITPAR[ndx+1]=SLAB[i].SPAR[1];
			FITMIN[ndx+1]=SLAB[i].SPARLIM[1][0];
			FITMAX[ndx+1]=SLAB[i].SPARLIM[1][1];
			FITPEN[ndx+1]=SLAB[i].SPARPEN[1];
			FITPAR[ndx+2]=SLAB[i].SPAR[2];
			FITMIN[ndx+2]=SLAB[i].SPARLIM[2][0];
			FITMAX[ndx+2]=SLAB[i].SPARLIM[2][1];
			FITPEN[ndx+2]=SLAB[i].SPARPEN[2];
			FITPAR[ndx+3]=SLAB[i].SPAR[3];
			FITMIN[ndx+3]=SLAB[i].SPARLIM[3][0];
			FITMAX[ndx+3]=SLAB[i].SPARLIM[3][1];
			FITPEN[ndx+3]=SLAB[i].SPARPEN[3];
		}
/* endaddOR050901 */
	}
#endif /* EXTENSIONS Robach */
#ifdef EXTENSIONS /* Svensson */
	if (svensson_flag)
	{
	  ndxtot = i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT;
	/* modifOR050901 */	
	  if (robach_flag)
	  {
	    ndxtot = ndxtot+4*NZFUNCTOT+2*NOFUNCTOT+4*NSLAB;
	  }
	/* endmodifOR050901 */
	  for (i = 0; i < NDISGROUPSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    FITPAR[ndx] = DISPLGROUPS[i];
	    FITMIN[ndx] = DISPLLIMGROUPS[i][0];
	    FITMAX[ndx] = DISPLLIMGROUPS[i][1];
	    FITPEN[ndx] = DISPLPENGROUPS[i];
	    sprintf(FITTXT[ndx],"Group displ %2d",i+1);
	  }
	  ndxtot += NDISGROUPSTOT;
	  for (i = 0; i < NDWGROUPSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    FITPAR[ndx] = DEBWALGROUPS[i];
	    FITMIN[ndx] = DEBWALLIMGROUPS[i][0];
	    FITMAX[ndx] = DEBWALLIMGROUPS[i][1];
	    FITPEN[ndx] = DEBWALPENGROUPS[i];
	    sprintf(FITTXT[ndx],"Group atom DW %2d",i+1);
	  }
	  ndxtot += NDWGROUPSTOT;
	  for (i = 0; i < NDISCYLINDERSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    FITPAR[ndx] = DISPLCYLINDERSPAR[i];
	    FITMIN[ndx] = DISPLLIMCYLINDERSPAR[i][0];
	    FITMAX[ndx] = DISPLLIMCYLINDERSPAR[i][1];
	    FITPEN[ndx] = DISPLPENCYLINDERSPAR[i];
	    sprintf(FITTXT[ndx],"Cylinder displ. %2d",i+1);
	  }
	  ndxtot += NDISCYLINDERSTOT;
	  for (i = 0; i < NCHARGEDENSITYCYLINDERSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    FITPAR[ndx] = CHARGEDENSITYOFCYLINDERSPAR[i];
	    FITMIN[ndx] = CHARGEDENSITYLIMCYLINDERSPAR[i][0];
	    FITMAX[ndx] = CHARGEDENSITYLIMCYLINDERSPAR[i][1];
	    FITPEN[ndx] = CHARGEDENSITYPENCYLINDERSPAR[i];
	    sprintf(FITTXT[ndx],"Cylinder par. %2d",i+1);
	  }
	  ndxtot += NCHARGEDENSITYCYLINDERSTOT;
	  for (i = 0; i < NDISELLIPSOIDSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    FITPAR[ndx] = DISPLELLIPSOIDSPAR[i];
	    FITMIN[ndx] = DISPLLIMELLIPSOIDSPAR[i][0];
	    FITMAX[ndx] = DISPLLIMELLIPSOIDSPAR[i][1];
	    FITPEN[ndx] = DISPLPENELLIPSOIDSPAR[i];
	    sprintf(FITTXT[ndx],"Ellipsoid displ. %2d",i+1);
	  }
	  ndxtot += NDISELLIPSOIDSTOT;
	  for (i = 0; i < NCHARGEDENSITYELLIPSOIDSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    FITPAR[ndx] = CHARGEDENSITYOFELLIPSOIDSPAR[i];
	    FITMIN[ndx] = CHARGEDENSITYLIMELLIPSOIDSPAR[i][0];
	    FITMAX[ndx] = CHARGEDENSITYLIMELLIPSOIDSPAR[i][1];
	    FITPEN[ndx] = CHARGEDENSITYPENELLIPSOIDSPAR[i];
	    sprintf(FITTXT[ndx],"Ellipsoid ch. dens. %2d",i+1);
	  }
	  ndxtot += NCHARGEDENSITYELLIPSOIDSTOT;
	  /* Start addition by Michael Dore */
	  for (i = 0; i < NEXPANGROUPSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    FITPAR[ndx] = func_deform[0].defgroups[i];
	    FITMIN[ndx] = func_deform[0].deflimgroups[i][0];
	    FITMAX[ndx] = func_deform[0].deflimgroups[i][1];
	    FITPEN[ndx] = func_deform[0].defpengroups[i];
	    sprintf(FITTXT[ndx],"Group expan %2d",i+1);
	  }
	  ndxtot += NEXPANGROUPSTOT;
	  for (i = 0; i < NSHEARGROUPSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    FITPAR[ndx] = func_deform[1].defgroups[i];
	    FITMIN[ndx] = func_deform[1].deflimgroups[i][0];
	    FITMAX[ndx] = func_deform[1].deflimgroups[i][1];
	    FITPEN[ndx] = func_deform[1].defpengroups[i];
	    sprintf(FITTXT[ndx],"Group shear %2d",i+1);
	  }
	  ndxtot += NSHEARGROUPSTOT;
	  /* End addition by Michael Dore */
	   
	}
#endif /* EXTENSIONS Svensson */

	    /* total number of parameters */
#ifdef EXTENSIONS /* Robach & Svensson */
	        ntot = NSF+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT;
/* modifOR050901 */
		if (robach_flag)
		{
	  		NPARAMTOT = NSF_OR + NDISTOT + NDWTOT + NDWTOT2 +
					NOCCTOT+4*NZFUNCTOT+2*NOFUNCTOT+4*NSLAB ;
			ntot = NPARAMTOT;
		}
/* endmodifOR050901 */
		if (svensson_flag)
		{
		  ntot += NDISGROUPSTOT + NDWGROUPSTOT +
		         NDISCYLINDERSTOT +
                         NSHEARGROUPSTOT+NEXPANGROUPSTOT+ /* Added by Michael Dore */
	                 NCHARGEDENSITYCYLINDERSTOT +
	                 NCHARGEDENSITYCYLINDERSTOT;
		}
		if ((!robach_flag) && (!svensson_flag))
#endif /* EXTENSIONS Robach & Svensson */
	    ntot = NSF+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT;

#ifdef EXTENSIONS /* Mcsl */
		NPAR=ntot;
#endif /* EXTENSIONS Mcsl */

    return (ntot);


    }

/***************************************************************************/
void    update_par(void)
/***************************************************************************/

    /*
    Copy values in array 'FITPAR' to corresponding model parameters
    */

    {
    int 	i,ndx;

#ifdef EXTENSIONS /* Svensson */
    int ndxtot;
#endif /* EXTENSIONS Svensson */


#ifdef EXTENSIONS /* Robach */
    int nsf;

    if (robach_flag) nsf = NSF_OR;
    else nsf = NSF;
#endif /* EXTENSIONS Robach */


    SCALE = FITPAR[0];
    SCALELIM[0] = FITMIN[0];
    SCALELIM[1] = FITMAX[0];
    SCALEPEN = FITPEN[0];

#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
	{
	    	SCALE3 = FITPAR[1];
	  	SCALE3LIM[0] = FITMIN[1];
  		SCALE3LIM[1] = FITMAX[1];
		SCALE3PEN = FITPEN[1];
	}
	else
#endif /* EXTENSIONS Robach */
	{
	    	SCALE2 = FITPAR[1];
	    	SCALE2LIM[0] = FITMIN[1];
    		SCALE2LIM[1] = FITMAX[1];
    		SCALE2PEN = FITPEN[1];
	}

/* add 220800 */

#ifdef EXTENSIONS /* Robach */
	if ((robach_flag)&&(var_nlayers))
	{
		SIGMA = FITPAR[2];
		SIGMALIM[0] = FITMIN[2];
		SIGMALIM[1] = FITMAX[2];
		SIGMAPEN = FITPEN[2];
	}
	else
#endif
	{
		BETA = FITPAR[2];
		BETALIM[0] = FITMIN[2];
		BETALIM[1] = FITMAX[2];
		BETAPEN = FITPEN[2];
	}

/* endadd220800 */

    SURFFRAC = FITPAR[3];
    SURFFRACLIM[0] = FITMIN[3];
    SURFFRACLIM[1] = FITMAX[3];
    SURFFRACPEN = FITPEN[3];

#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
	{
    		LSHIFT = FITPAR[4];
		LSHIFTLIM[0] = FITMIN[4];
	  	LSHIFTLIM[1] = FITMAX[4];
	  	LSHIFTPEN = FITPEN[4];

	    	SURF2FRAC = FITPAR[5];
	  	SURF2FRACLIM[0] = FITMIN[5];
    		SURF2FRACLIM[1] = FITMAX[5];
    		SURF2FRACPEN = FITPEN[5];

	    	WIDTH = FITPAR[6];
		WIDTHLIM[0] = FITMIN[6];
  		WIDTHLIM[1] = FITMAX[6];
  		WIDTHPEN = FITPEN[6];
	}
#endif

    for (i = 0; i < NDISTOT; i++)
	{
#ifdef EXTENSIONS /* Robach */
	ndx = i+nsf;
#else
	ndx = i+NSF;
#endif /* EXTENSIONS Robach */
	DISPL[i] = FITPAR[ndx];
	DISPLLIM[i][0] = FITMIN[ndx];
	DISPLLIM[i][1] = FITMAX[ndx];
	DISPLPEN[i] = FITPEN[ndx];
	}
    for (i = 0; i < NDWTOT; i++)
	{
#ifdef EXTENSIONS /* Robach */
	ndx = i+nsf+NDISTOT;
#else
	ndx = i+NSF+NDISTOT;
#endif /* EXTENSIONS Robach */
	DEBWAL[i] = FITPAR[ndx];
	DEBWALLIM[i][0] = FITMIN[ndx];
	DEBWALLIM[i][1] = FITMAX[ndx];
	DEBWALPEN[i] = FITPEN[ndx];
	}
    for (i = 0; i < NDWTOT2; i++)
	{
#ifdef EXTENSIONS /* Robach */
	ndx = i+nsf+NDISTOT+NDWTOT;
#else
	ndx = i+NSF+NDISTOT+NDWTOT;
#endif /* EXTENSIONS Robach */
	DEBWAL2[i] = FITPAR[ndx];
	DEBWAL2LIM[i][0] = FITMIN[ndx];
	DEBWAL2LIM[i][1] = FITMAX[ndx];
	DEBWAL2PEN[i] = FITPEN[ndx];
	}
    for (i = 0; i < NOCCTOT; i++)
	{
#ifdef EXTENSIONS /* Robach */
	ndx = i+nsf+NDISTOT+NDWTOT+NDWTOT2;
#else
	ndx = i+NSF+NDISTOT+NDWTOT+NDWTOT2;
#endif /* EXTENSIONS Robach */
	OCCUP[i] = FITPAR[ndx];
	OCCUPLIM[i][0] = FITMIN[ndx];
	OCCUPLIM[i][1] = FITMAX[ndx];
	OCCUPPEN[i] = FITPEN[ndx];
	}

#ifdef EXTENSIONS /* Robach */
	if (robach_flag)
	{
		for (i=0;i<NZFUNCTOT;i++)
		{
			ndx=3*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT;
			ZFUNC[i].ZPAR[0]=FITPAR[ndx];
			ZFUNC[i].ZPARLIM[0][0]=FITMIN[ndx];
			ZFUNC[i].ZPARLIM[0][1]=FITMAX[ndx];
			ZFUNC[i].ZPARPEN[0]=FITPEN[ndx];
			ZFUNC[i].ZPAR[1]=FITPAR[ndx+1];
			ZFUNC[i].ZPARLIM[1][0]=FITMIN[ndx+1];
			ZFUNC[i].ZPARLIM[1][1]=FITMAX[ndx+1];
			ZFUNC[i].ZPARPEN[1]=FITPEN[ndx+1];
			ZFUNC[i].ZPAR[2]=FITPAR[ndx+2];
			ZFUNC[i].ZPARLIM[2][0]=FITMIN[ndx+2];
			ZFUNC[i].ZPARLIM[2][1]=FITMAX[ndx+2];
			ZFUNC[i].ZPARPEN[2]=FITPEN[ndx+2];
			ZFUNC[i].ZPAR[3]=FITPAR[ndx+3];
			ZFUNC[i].ZPARLIM[3][0]=FITMIN[ndx+3];
			ZFUNC[i].ZPARLIM[3][1]=FITMAX[ndx+3];
			ZFUNC[i].ZPARPEN[3]=FITPEN[ndx+3];
		}
		for (i=0;i<NOFUNCTOT;i++)
		{
			ndx=2*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT+4*NZFUNCTOT;
			OFUNC[i].OPAR[0]=FITPAR[ndx];
			OFUNC[i].OPARLIM[0][0]=FITMIN[ndx];
			OFUNC[i].OPARLIM[0][1]=FITMAX[ndx];
			OFUNC[i].OPARPEN[0]=FITPEN[ndx];
			OFUNC[i].OPAR[1]=FITPAR[ndx+1];
			OFUNC[i].OPARLIM[1][0]=FITMIN[ndx+1];
			OFUNC[i].OPARLIM[1][1]=FITMAX[ndx+1];
			OFUNC[i].OPARPEN[1]=FITPEN[ndx+1];
		}
/* addOR050901 */
		for (i=0;i<NSLAB;i++)
		{
			ndx=4*i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT+4*NZFUNCTOT+2*NOFUNCTOT;
			SLAB[i].SPAR[0]=FITPAR[ndx];
			SLAB[i].SPARLIM[0][0]=FITMIN[ndx];
			SLAB[i].SPARLIM[0][1]=FITMAX[ndx];
			SLAB[i].SPARPEN[0]=FITPEN[ndx]; 
			SLAB[i].SPAR[1]=FITPAR[ndx+1];
			SLAB[i].SPARLIM[1][0]=FITMIN[ndx+1];
			SLAB[i].SPARLIM[1][1]=FITMAX[ndx+1];
			SLAB[i].SPARPEN[1]=FITPEN[ndx+1];
			SLAB[i].SPAR[2]=FITPAR[ndx+2];
			SLAB[i].SPARLIM[2][0]=FITMIN[ndx+2];
			SLAB[i].SPARLIM[2][1]=FITMAX[ndx+2];
			SLAB[i].SPARPEN[2]=FITPEN[ndx+2];
			SLAB[i].SPAR[3]=FITPAR[ndx+3];
			SLAB[i].SPARLIM[3][0]=FITMIN[ndx+3];
			SLAB[i].SPARLIM[3][1]=FITMAX[ndx+3];
			SLAB[i].SPARPEN[3]=FITPEN[ndx+3];
		}
/* endaddOR050901 */
	}
#endif /* EXTENSIONS Robach */
#ifdef EXTENSIONS /* Svensson */
	if (svensson_flag)
	{
	  ndxtot = i+nsf+NDISTOT+NDWTOT+NDWTOT2+NOCCTOT;
	/* modifOR050901 */  
	if (robach_flag)
	  {
	    ndxtot = ndxtot+4*NZFUNCTOT+2*NOFUNCTOT+4*NSLAB;
	  }
	/* endmodifOR050901 */
	  for (i = 0; i < NDISGROUPSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    DISPLGROUPS[i] = FITPAR[ndx];
	    DISPLLIMGROUPS[i][0] = FITMIN[ndx];
	    DISPLLIMGROUPS[i][1] = FITMAX[ndx];
	    DISPLPENGROUPS[i] = FITPEN[ndx];
	  }
	  ndxtot += NDISGROUPSTOT;
	  for (i = 0; i < NDWGROUPSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    DEBWALGROUPS[i] = FITPAR[ndx];
	    DEBWALLIMGROUPS[i][0] = FITMIN[ndx];
	    DEBWALLIMGROUPS[i][1] = FITMAX[ndx];
	    DEBWALPENGROUPS[i] = FITPEN[ndx];
	  }
	  ndxtot += NDWGROUPSTOT;
	  for (i = 0; i < NDISCYLINDERSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    DISPLCYLINDERSPAR[i] = FITPAR[ndx];
	    DISPLLIMCYLINDERSPAR[i][0] = FITMIN[ndx];
	    DISPLLIMCYLINDERSPAR[i][1] = FITMAX[ndx];
	    DISPLPENCYLINDERSPAR[i] = FITPEN[ndx];
	  }
	  ndxtot += NDISCYLINDERSTOT;
	  for (i = 0; i < NCHARGEDENSITYCYLINDERSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    CHARGEDENSITYOFCYLINDERSPAR[i] = FITPAR[ndx];
	    CHARGEDENSITYLIMCYLINDERSPAR[i][0] = FITMIN[ndx];
	    CHARGEDENSITYLIMCYLINDERSPAR[i][1] = FITMAX[ndx];
	    CHARGEDENSITYPENCYLINDERSPAR[i] = FITPEN[ndx];
	  }
	  ndxtot += NCHARGEDENSITYCYLINDERSTOT;
	  for (i = 0; i < NDISELLIPSOIDSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    DISPLELLIPSOIDSPAR[i] = FITPAR[ndx];
	    DISPLLIMELLIPSOIDSPAR[i][0] = FITMIN[ndx];
	    DISPLLIMELLIPSOIDSPAR[i][1] = FITMAX[ndx];
	    DISPLPENELLIPSOIDSPAR[i] = FITPEN[ndx];
	  }
	  ndxtot += NDISELLIPSOIDSTOT;
	  for (i = 0; i < NCHARGEDENSITYELLIPSOIDSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    CHARGEDENSITYOFELLIPSOIDSPAR[i] = FITPAR[ndx];
	    CHARGEDENSITYLIMELLIPSOIDSPAR[i][0] = FITMIN[ndx];
	    CHARGEDENSITYLIMELLIPSOIDSPAR[i][1] = FITMAX[ndx];
	    CHARGEDENSITYPENELLIPSOIDSPAR[i] = FITPEN[ndx];
	  }
	  ndxtot += NCHARGEDENSITYELLIPSOIDSTOT;
	  /* Start addition by Michael Dore */
	  for (i = 0; i < NEXPANGROUPSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    func_deform[0].defgroups[i] = FITPAR[ndx];
	    func_deform[0].deflimgroups[i][0] = FITMIN[ndx];
	    func_deform[0].deflimgroups[i][1] = FITMAX[ndx];
	    func_deform[0].defpengroups[i] = FITPEN[ndx];
	  }
	  ndxtot += NEXPANGROUPSTOT;
	  for (i = 0; i < NSHEARGROUPSTOT; i++)
	  {
	    ndx = i+ndxtot;
	    func_deform[1].defgroups[i] = FITPAR[ndx];
	    func_deform[1].deflimgroups[i][0] = FITMIN[ndx];
	    func_deform[1].deflimgroups[i][1] = FITMAX[ndx];
	    func_deform[1].defpengroups[i] = FITPEN[ndx];
	  }
	  ndxtot += NSHEARGROUPSTOT;
	  /* End addition by Michael Dore */
	}
#endif /* EXTENSIONS Svensson */
    }

#ifdef ASAROD
/***************************************************************************/
float    ffit_asa(float a[], int *cost_flag)
/***************************************************************************/

    /*
    Function called by adaptive simulated annealing fitting routine.

    a[] array with parameter values
    *cost_flag some sort of flag
    function returns chi^2 value
    */

    {

    int i,j,imax;
    float	chisqr,y;
    float       fbulk,fsurf,phase;


    SCALE = a[0];
    SCALE2= a[1];
    BETA = a[2];
    SURFFRAC = a[3];
    for (j = 0; j < NDISTOT; j++)
	{
	DISPL[j] = a[j+NSF];
	}
    for (j = 0; j < NDWTOT; j++)
	{
	DEBWAL[j] = a[j+NSF+NDISTOT];
	}
    for (j = 0; j < NDWTOT2; j++)
	{
	DEBWAL2[j] = a[j+NSF+NDISTOT+NDWTOT];
	}
    for (j = 0; j < NOCCTOT; j++)
	{
	OCCUP[j] = a[j+NSF+NDISTOT+NDWTOT+NDWTOT2];
	}

    /* Calculate structure model with new parameters */

    update_model();

    /* Calculate chi^2 value */
    /* In order to combine the levenberg algorithm with a lattice enery
    calculation, a fake data point is added. This is not necessary here,
    and thus the number of data points needs to be reduced by one if this
    option is on */

    chisqr = 0.;
    if (KEAT_PLUS_CHI)
	imax = NDAT-1;
    else
	imax = NDAT;

    for (i = 0; i < imax; i++)
	{
#ifdef SPEEDUP

	y = f_calc_fit(HDAT[i],KDAT[i],LDAT[i],LBR[i],Q_PAR[i],Q_PERP[i],
		FAT[i],RE_BULK[i],IM_BULK[i],FBULK_SQR[i]);
#else
	f_calc(HDAT[i],KDAT[i],LDAT[i],ATTEN,LBR[i],&fbulk,&fsurf,&y,&phase);
#endif
	chisqr += sqr(y-FDAT[i])*FWEIGHT[i];
	}

    /* Add lattice energy to chi^2 if requested (easy in asa!) */

    if (KEAT_PLUS_CHI)
	chisqr += sqrt(energy_calc());

    *cost_flag = TRUE;
    return(chisqr);
    }
#endif /* ASAROD */
