/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$$$$$$                    lsqfit.h                         $$$$$$$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: lsqfit.h,v 1.2 2003/09/08 10:07:57 wilcke Exp $

Update 30/07/2003 Rainer Wilcke (wilcke@esrf.fr)
                  commented out declaration of LSQ_LOGFNAME (gives compilation
                  problems with the declaration in "lsqfit.c").
Update 19/01/2001 Marie-Claire Saint-Lager (stlager@polycnrs-gre.fr)
				new global variable : NFITAUTO

****************************************************************************/

/* Defines */

#define	LSQ_NOFIT	0
#define LSQ_LEVENBERG	1
#define LSQ_COOLDOWN	2
#define LSQ_BREAK_RESTORE		3

#define LSQ_FNAMETERMINAL       "<TERMINAL>"

#if !defined(EXTENSIONS)
#define EXTENSIONS
#endif  /* !defined(EXTENSIONS) */

/* Type definitions */

/*
    The function type "FitFunction" is used by lsqfit() and cooldown() for
    computing the model function f(x).

    Arguments are as follows:
	float           x-value for which the function should be computed
	float *         array of parameter values
	float *         pointer to y-value to be computed

    The following arguments are optional and only used by lsqfit():

	float *         pointer to computed analytical derivatives dy/da
	int             total number of parameters (needed for comp. of deriv.)
	int             flag denoting whether analytical derivatives should
			be computed.
*/

typedef void (*FitFunction)(float, float *, float *, float *, int, int);

/* global variables */




#ifndef LSQFIT

extern int   LSQ_NSTEPS;       /* number of steps for every temperature step */
extern int   LSQ_NLIST;        /* number of steps between lists in cooldown() */
extern int   LSQ_NACC;         /* number of steps between eval. of acc. ratio */
extern float LSQ_TSTART;       /* initial temperature */
extern float LSQ_DCHICONV;     /* norm. chi^2 convergence criterion */
extern float LSQ_NDECADE;      /* number of anneals per temperature decade */
extern FILE* LSQ_LOGFILE;      /* list file for cooldown() */
//extern char  *LSQ_LOGFNAME;    /* name of log file during fitting */
extern int   LSQ_USELOG;       /* use logarithm of data for chi^2 evaluation
                                   (cooldown only) */


#endif

#ifdef EXTENSIONS /* Mcsl */
int  NFITAUTO ; /* flag to denote if the lsqfit is called by fit_auto() */
#endif /* EXTENSIONS Mcsl */



/* Exported functions of lsqfit.c */

float	calc_chisq(float x[], float y[], float wgt[], int ndata,
		   float a[], int ma,
                   FitFunction funcs
		  );

float   calc_error(float x[], float y[], float wgt[], int ndata,
		   float a[],int ma, int par,
		   float amin[], float amax[], float apen[],
		   float chi2_inc,
                   FitFunction funcs
		  );

void    cooldown(float x[], float y[], float wgt[], int ndata,
                     float a[], int ma, int lista[], int mfit,
                     float asig[], float amin[], float amax[],
                     float acheck[], float *chisqr,
                     FitFunction funcs,char *fittxt, int txtlength);

float	fitquality(int, float);

int     lsqfit(float x[], float y[], float wgt[], int ndata,
	          float a[], int ma, int lista[], int mfit, float asig[],
  	          float amin[], float amax[], float apen[], float *chisqr,
                  FitFunction funcs,  char *fittxt, int txtlength,
		  int derivatives, int method, int calcquality);

int     levenberg(float x[], float y[], float wgt[], int ndata,
 	      float a[], int ma, int lista[], int mfit, float asig[],
	      float amin[], float amax[], float apen[], float *chisqr,
              FitFunction funcs,
	      int derivatives);

void    lsq_breakcontrol ( int command, FitFunction funcs, float *a, int na);

void    list_fitresults( int ntot, int nfree, int ndat,
                      float *fpar, float *fmin, float *fmax, float *ferr,
                      float *fstep,
                      int *check, int *fix, float chisqr,
                      char *names, int namelength);

int     set_fitpar(char *prompt, int npar,
                   float *fpar, float *fmin, float *fmax,
                   int *check, int *fix, char *names, int namelength,
                   float *xdata, float *ydata, float *wgtdata,
                   int ndata, FitFunction funcs );

float   ran3(int *idum);

void set_controlpars(char *prompt);
void write_controlpars(void);
void write_logscreen(char *string);

