PRO Xop_Load_Extension, ext1, Group=group, Browser=browser

;+
;  PRO Xop_Load_Extension, ext1, Group=group, Browser=browser
; 
;  Modified:
;  2008/09/10 srio@esrf.eu added input parameter ext1
;
;-


catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,$
        'XOP_LOAD_EXTENSION: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   RETURN
endif

IF StrCompress(Xop_GetEnv('XOP_BINARIES_DEBUG'),/Remove_All) NE '' THEN BEGIN
  idebug = 1
ENDIF ELSE BEGIN
  idebug=0
ENDELSE

IF N_ELEMENTS(ext1) EQ 0 THEN BEGIN
  ds = SDep(/ds)
  ;
  ; Get extension .sav file
  ;
  path = Xop_GetEnv('XOP_HOME')+SDep(/ds)+'extensions'
  
  ; remove double slashes (confuses dialog_pickfile)
  path = StrSubstitute(path,ds+ds,ds)
  
  IF idebug EQ 1 THEN BEGIN
    itmp = Dialog_Message(/Info,Dialog_Parent=group,$
      ['Debugging message: Looking for .sav files in directory: ',path])
  ENDIF   
  
  IF Keyword_Set(Browser) THEN BEGIN
    ext = Dialog_PickFile(Path=path,Dialog_Parent=group, Title= $
      'Select an XOP extension startup file',Filter='*.sav', /Fix_Filter)
    IF ext EQ '' THEN RETURN
    ;
    ; gets the name of the extension from the full path
    ;
    list=0
    n = StrParse(ext,ds,list)
    ext1 = StrMid(list[n],0,StrLen(list[n])-4)
  ENDIF ELSE BEGIN
    Files = File_Search(path+ds+'*'+ds+'*.sav')
    IF Files[0] EQ '' THEN BEGIN
       itmp = Dialog_Message(/Error,'No extensions installed',$
              Dialog_Parent=group)
       RETURN
    ENDIF
    FilesShort = StrArr(N_Elements(Files))
    FOR i=0L,N_Elements(Files)-1 DO BEGIN
      list=0
      n = StrParse(Files[i],ds,list)
      tmp = StrMid(list[n],0,StrLen(list[n])-4)
      FilesShort[i] = tmp
    ENDFOR
    tmp = { a:['0',FilesShort] }
    XScrMenu,tmp,/Interp,/NoType,Titles=['Installed extensions: '], $
      action=action,Dialog_Parent=group,WTitle='XOP extensions'
    IF action EQ 'DONT' THEN RETURN
    ext1 = FilesShort[ Fix( (tmp.a)[0] ) ]
  ENDELSE
ENDIF
;
; loads and starts the extension 
;

command = ext1+';'
IF idebug EQ 1 THEN BEGIN
  itmp = Dialog_Message(/Info,Dialog_Parent=group,/Cancel,$
    ['Debugging message: Executing: ',command])
  IF itmp EQ 'Cancel' THEN Return
ENDIF   
;
Widget_Control,/HourGlass
itmp = Execute(command)
IF itmp NE 1 THEN BEGIN
  itmp = Dialog_Message(/Info,Dialog_Parent=group, $
    ['XOP_LOAD_EXTENSION: Error executing: ',command])
ENDIF

END ; Xop_Load_Extension

