;+
;==================================   xF0   ====================================
;
;
; xf0 is a widget based graphical interface to calculate Elastic
; Photon-Atom Scattering versus x=sin(theta/2)/lambda.
;
; The data are taken from the DABAX data base. 
; It uses the following DABAX files:
;   f0_*.dat  (for f0 values) 
;
;   Compounds.dat   (for mixture and compounds list)
;
; CUSTOMIZATION OF XF0 DABAX PARAMETERS:
;  -If you want to add(remove) another f0_* file, just add(remove) it
;   in any(all) directory of $DABAX_PATH. 
; -If you want to modify the mixture table  list, do the following:
;     a) copy the Compounds.dat DABAX file to a given directory 
;        (e.g., current directory ".")
;     b) Modify this file to add/remove/change the entries.
;     c) Redefine $DABAX_PATH to include your new directoty:
;        setenv  DABAX_PATH = .:$DABAX_PATH
;     d) Restart the application.
;
; DESCRIPTION OF THE CONTROLS IN THE MAIN WINDOW:
;
;  File:
;    XF0 input parameters: This option allows to save the current
;		parameters to a file for later loading. It also allows
;		to save the current parameters as defaults for being
;		used when the application is initialized. In the last
;		case, the file is named "application".xop (where 
;		"application " is the name of the current XOP
;		application) and is written in the directory pointed
;		by the XOP_DEFAULTS_DIR environment variable (which
;		must be set). The parameter file is ASCII and can be
;		read and edited with care.
;  Quit: to exit from the program
;
; Set_Parameters:
;  Set Parameters: to define the parameters for the calculation.
;		The same result is obtained pressing the "Set Parameters"
;		button in the main XF0 window. 
;		After pressing the ACCEPT button, F0 starts running and
;		displays a graphical window with the results.
;
;  Help:   Shows the Xf0 help (this text).
;
;
;
;  COPYRIGHT:
; 	XF0 belongs to XOP package and it is distributed within XOP.
; 	PLEASE REFER TO THE XOP COPYRIGHT NOTICE
; 
;  REFERENCE:
; 	Published calculations made with XOP should refer:
; 
; 	M. Sanchez del Rio and R. J. Dejus 
;         "Status of XOP: an x-ray optics software toolkit"
;         SPIE Proceedings Vol. 5536 (2004) pp.171-174
; 
;         http://dx.doi.org/10.1117/12.560903
; 
;  LAST MODIFICATION: srio@esrf.eu 2008-02-01
; 
; 
;-
;
; =========================================================================
;
;	MODIFICATION HISTORY:
;       by  Manuel Sanchez del Rio. ESRF. July 1996.
;	96/12/03 srio@esrf.fr adds mixture option.
;	97/10/14 srio@esrf.fr cosmetics for xop1.9, text output for one-
;		single point.
;	98/12/14 srio@esrf.fr adapts for XOP2.0. Version 1.1
;
; =========================================================================
;
Function xf0_version
return,'1.1'
end
;
;=====================================================================
;
PRO xf0_event,event

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
     'XF0_EVENT: error caught: '+!err_string)
   Catch, /Cancel
   If Type(stateid) EQ 3 THEN $
     If Widget_Info(stateid,/Valid_Id) AND N_Elements(state) NE 0 THEN $
     Widget_Control,stateid,Set_UValue=state,/No_Copy
   On_Error,2
   RETURN
ENDIF

Widget_Control, event.id, get_UValue=eventUValue

if n_elements(eventuvalue) EQ 0 then eventuvalue = ''
if not(keyword_set(eventuvalue)) then eventuvalue = ''

stateid = Widget_Info(event.handler,/Child)
Widget_Control, stateid, get_UValue=state, /No_Copy

case eventuvalue of

  'FILEINPUT': BEGIN
    action=''
    Widget_Control,event.id, Get_Value=action
    CASE action OF
      'Load from file...': BEGIN
        if sdep() EQ 'UNIX' then filter='*.xop' else filter=0
        str_par = Xop_Input_Load(Title=$
        'Select xf0 input file...',$
        /NoConf,Filter=filter,Group=event.top)
        IF Type(str_par) EQ 8 THEN BEGIN
          tmp = state.str.parameters
          Copy_Structure,str_par, tmp, Group=event.top , /OnlyFirstField
          state.str.parameters = tmp
        ENDIF
      END
      'Save to file...': BEGIN
        str_par = state.str.parameters
        Xop_Input_Save,str_par,File='xf0.xop',$
          /Write, Group=event.top, Comment='; xop/xf0(v'+$
        xf0_version()+') input file on '+SysTime()
      END
      'Save as default': BEGIN
        str_par = state.str.parameters
        Xop_Input_Save,str_par,Group=event.top, $
          Default='xf0.xop',Comment='; xop/xf0(v'+$
        xf0_version()+') input file on '+SysTime()
      END
    ENDCASE
  END

  'QUIT':begin	
	widget_control,/destroy,event.top
	return
	end
  'HELP': xhelp,'xf0',GROUP=event.top


  'SETDEF': BEGIN
		itmp = Dialog_Message(Dialog_Parent=event.top,$
		/Question,['This option initializes the',$
		'xf0 parameters to their default values.',$
		'Then you must click Set_parameters to run the program.',$
		'Please confirm.'],title='xf0')
		if itmp eq 'No' then goto,out
		state.str.parameters = state.str_defaults
	END
  'SET':begin	
	str = state.str.parameters
        helpdir = Xop_GetEnv('DABAX_HELP')
        if helpdir EQ '' then helpcmd=0 else begin
                  helpcmd="XDisplayFile1,'"+helpdir+$
                 sdep(/ds)+"xf0_par.txt'"
        endelse
  	XScrMenu,str,/Interp,/NoType,action=action,Ncol=2, $
		titles=state.str.titles, $
		flags=state.str.flags,help=helpcmd,$
		wtitle='xF0 input parameters'
  	if  action EQ 'DONT' then goto,out
	state.str.parameters = str
  	widget_control,/hourglass
	if strcompress(str.datasets(0),/rem) EQ '0' then $
		datasets = str.datasets(2:N_elements(str.datasets)-1) else $
		datasets = str.datasets(fix(str.datasets(0))+1)
	idisplay = 0
	if strcompress(str.grid(0),/rem) EQ '1' then begin
	   if str.gridn EQ 1 then begin
		ratio = [str.gridstart]
		idisplay = 1
	   endif else begin
	   	ratio = findgen(str.gridn)/(float(str.gridn)-1) * $
	   	(str.gridend-str.gridstart) + str.gridstart
	   endelse
	endif 

	mat_flag = fix(str.mat_flag(0))
	case mat_flag of
	0: begin
	    iname = 0 
            descriptor = strcompress(str.descriptor,/rem)
            if strlen(descriptor) EQ 1 then descriptor=descriptor+' '
	    imix = 0
	   end
	1: begin
	    iname = 0 
            descriptor = strcompress(str.descriptor,/rem)
            if strlen(descriptor) EQ 1 then descriptor=descriptor+' '
	    imix = 1
	   end
	2: begin
	    iname = 1 & descriptor = str.mat_list(fix(str.mat_list(0))+1)
	    imix = 1
	   end
	endcase
  	widget_control,/hourglass
	FOR I = 0,n_elements(datasets)-1 DO BEGIN ; starts main loop
	  if imix then  f0 = f0_calc_mix(datasets(i),descriptor,ratio,$
		name=iname,group=event.top) else $
	    f0 = f0_calc(datasets(i),descriptor,ratio,group=event.top)
	  if I EQ 0 then begin
	    out = fltarr(n_elements(datasets)+1,n_elements(f0))
	    out(0,*) = ratio
	    out(1,*) = f0
	  endif else out(1+i,*) = f0
	ENDFOR ; ends main loop
	if idisplay EQ 0 then begin
	  xplot,out,coltitles=['ratio',datasets],xtitle='-1',ytitle='-1', $
	  group = event.top,title=descriptor,wtitle='xF0 results'
	endif else begin
	  text = 'ratio = '+strcompress(out(0),/rem)
	  for i=0,n_elements(datasets)-1 do $
		text = [text,datasets(i)+' = '+strcompress(out(i+1),/rem)] 
	  xdisplayfile1,text=text,title='xF0 results',$
		group = event.top
	endelse
	end
  else:
endcase

out:
Widget_Control, stateid, set_UValue=state, /No_Copy
END
;
;=======================================================================
;
PRO xf0,GROUP=group, InputFile=inputFile, No_Block=no_Block
;
Forward_Function dabax_defaults

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XF0: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF
;
wbase = widget_base(/COLUMN,TITLE='XF0 '+xf0_version(),$
        MBAR=wMenuBar)

;
;
; the blocks box
;
Bbox=widget_base(wbase,/Column) ; also to store state
 

;Menu bar
wFileMenu =  WIDGET_BUTTON(wMenuBar, VALUE='File', /MENU)
  wtmp0 = widget_button(wFileMenu,VALUE='xf0 input parameters', /Menu)
    wtmp = widget_button(wtmp0,VALUE='Load from file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save to file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save as default',UValue='FILEINPUT')
  wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Quit', Uvalue= 'QUIT',/sepa)


wSetParameters = widget_button(wMenuBar,VALUE='Set_Parameters', /MENU)
  wtmp = widget_button(wSetParameters,VALUE='Set Parameters', UVALUE='SET')
  wtmp = widget_button(wSetParameters,VALUE='Set Defaults', UVALUE='SETDEF')


wHelpMenu = WIDGET_BUTTON(wMenuBar, VALUE='Help', /HELP)
  wtmp = WIDGET_BUTTON(wHelpMenu, VALUE='xF0', UVALUE='HELP')

tmp = widget_button(Bbox,VALUE='Set Parameters',UVALUE='SET')

if sdep() EQ 'WINDOWS' then $
font = 'VERDANA*BOLD*ITALIC*24' else $
font = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'

junk = WIDGET_LABEL( Bbox, FONT=font, VALUE=' xF0')
junk = WIDGET_LABEL( Bbox, FONT=font, VALUE='Elastic Photon-Atom Scattering')


str = dabax_defaults('xf0',group=wbase)
str_defaults = str.parameters

IF KeyWord_Set(inputFile) THEN BEGIN
  str_par = Xop_Input_Load(InputFile=inputFile)
  IF Type(str_par) EQ 8 THEN BEGIN
    tmp = str.parameters
    Copy_Structure,str_par, tmp, Group=group, /OnlyFirstField
    str.parameters = tmp
  ENDIF
ENDIF

wids = {dummy:0L}
state = { wids:wids, str:str, str_defaults:str_defaults }

widget_control,Widget_Info(wbase,/Child),set_uvalue=state
widget_control,wbase,/REALIZE
xmanager,'XF0',wbase,GROUP=group, No_Block=no_Block
;
end
