;+
; NAME:
;       OPACITY.
;
; PURPOSE:
;       This procedure make opac all the Polygone of a Graphic model.
;
; CATEGORY:
;       Graphic.
;
; CALLING SEQUENCE:
;       OPACITY, Model
;
; INPUTS:
;       Model:    An IDLGrModel object.
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE
;	    OPACITY, Model
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, May 2001
;-

pro opacity, model

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'opacity: error caught: '+!error_state.msg)
   RETURN
ENDIF


	n=model->count()
	for p=0, n-1 do begin
		obj=model->get(pos=p)
		if OBJ_ISA(obj, 'IDLgrModel') then begin
			obj->getProperty, uvalue=val
			IF n_elements(val) EQ 0 then  BEGIN
			   opacity, obj 
			ENDIF ELSE BEGIN
			   IF not strcmp(string(val),'constant') THEN  opacity, obj
			   ; IF  string(val) NE 'constant' THEN  opacity, obj
			ENDELSE
		endif
		if OBJ_ISA(obj, 'IDLgrpolygon') then obj->setProperty, style=2
	endfor
end

