;
; creates an helix in 3D
;


; 
; Compute the points of the curve 
; to be used for the NURBS
;
n=25
a=4*!dpi*nrblinear(0,1,n)
b=4*!dpi*nrblinear(0,1,n)

x=10*cos(a)
y=10*sin(b)*exp(b/(4*!dpi))
z=nrblinear(-1,1,n)

;
; Computes the curve with more points (for comparison) 
;
n1=100
a1=4*!dpi*nrblinear(0,1,n1)
b1=4*!dpi*nrblinear(0,1,n1)
x1=10*cos(a1)
y1=10*sin(b1)*exp(b1/(4*!dpi))
z1=nrblinear(-1,1,n1)

;
; Creates NURBS
;
grid=[[x],[y],[z]]
knots=nrbgetknots(grid,uu=uu)
nrb=nrbstruct(grid,knots.uknots)
curv=nrbinterpcoefs(nrb,uu)


; 
; test evaluated points
;
u=nrblinear(0.,1.,n1)
p=nrbeval(curv,u)
nrbplot, p

;
; Overplots control points
;
;iplot, reform(curv.xgrid),reform(curv.ygrid),reform(curv.zgrid),/overplot, color=[255,0,0]
nrbplot,curv.coefs,/overplot,color=[255,0,0]
; 
; Overplot exact curve
;
iplot, x1,y1,z1,/overplot, color=[0,0,255]

END
