;+
;
; FUNCTION bzrsort, patch
;
;
;function for ordering all the patches from the most central 
; with respect the  u and v parameters to the most external one
;
; method: 0 (default), computes distance with respect to the origin
;         in (u,v) space. This is usually faster if the surface is not 
;         translated.
;         1, computest the distance with respect to the origin in the
;         (x,y,z) space. This is faster if the surface is stranslated. 
;
;
;-

FUNCTION bzrsort, patch,method=method

n=n_elements(patch)

IF n EQ 1 THEN RETURN,patch

IF N_Elements(method) EQ 0 THEN method=0

dis=DblArr(n)


IF method EQ 0 THEN BEGIN
  FOR ii=0L,n-1 DO BEGIN
    tmp = (patch[ii].xgrid^2+patch[ii].ygrid^2+patch[ii].zgrid^2)
    dis[ii] = total(tmp)
  ENDFOR
ENDIF ELSE BEGIN
  d1=2*(patch[0].p+1)
  d2=2*(patch[0].q+1)
  FOR ii=0L,n-1 DO BEGIN
    u=total(patch[ii].uknots)/d1
    v=total(patch[ii].vknots)/d2
    dis[ii]=sqrt((u-0.5)^2+(v-0.5)^2)
  ENDFOR
ENDELSE


a=sort(dis)

temp=patch[a]

return, temp

END
