;+
; NAME:
;       OPTICAL_PLANE__DEFINE.
;
; PURPOSE:
;       This procedure defines the 'optical_plane' object. An optical_plane 
;		is used to keep a 'beam' and draw property. It mays be 
;		range in an optical_module.
;
; FIELD:
;		t_location: relative location of tle plane
;		color: RVB color of the plane
;		show: Does the plane must be draw: 0->Yes, 1->No
;		shImage: Does the picture must be draw: 0->Yes, 1->No
;		parent:parent: ref on a module in witch the plane is inclued
;		image: a 520*520 Matrix to keep image
;		sModel: a model to draw the 3D representation
;		rays: a 'beam'
;		beam_file: a file with beam's data
;
; CATEGORY:
;       optical_plane class.
;
; CALLING SEQUENCE:
;       plane=obj_new('OPTICAL_Plane')
;
; INPUTS:
;		None
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE:
;
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, May 2001
;-
;*********************************
;purpose: the init procedure
function optical_plane::Init

self.parent=obj_new()
self.smodel.graphic=obj_new('idlgrmodel')
self.smodel.graphic->setProperty, uvalue='constant'
self.sprivateParameter.t_location=0.
self.name='undefined'
;*draw Property
self.sprivateParameter.color=[255,255,255]
self.sprivateParameter.show=0
self.sprivateParameter.beam_file='Undefined'
self.sprivateParameter.x=0
self.sprivateParameter.y=1
self.sprivateParameter.z=2
self.sprivateParameter.default_style=1
self.sprivateParameter.default_lineStyle=0
self->select_axes, x=x, y=y, z=z
plane=obj_new('idlgrpolygon',x,y,z,color=self.sprivateParameter.color, $
					style=self.sprivateParameter.default_style, name='plane', $
					lineStyle=self.sprivateParameter.default_lineStyle)
self.sModel.graphic->add, plane
self.rays=obj_new('blbeam')
self.image=intArr(256,256)
self.sPrivateParameter.shImage=1
return, 1
end
;*******************************************
;purpose: to change the plane orientation
pro optical_plane::select_axes, x=x, y=y, z=z
larg=0.23
case self.sprivateParameter.x of
	0: x=[larg, larg, -larg, -larg]
	1: x=[0.,0.,0.,0.]
	2: x=[-larg, larg, larg, -larg ]
endcase
case self.sprivateParameter.y of
	0: y=[larg, larg, -larg, -larg]
	1: y=[0.,0.,0.,0.]
	2: y=[-larg, larg, larg, -larg ]
endcase
case self.sprivateParameter.z of
	0: z=[larg, larg, -larg, -larg]
	1: z=[0.,0.,0.,0.]
	2: z=[-larg, larg, larg, -larg ]
endcase
end
;****************cleanUP*****************
;
;	PURPOSE: use to clean memory when object is destroy
pro optical_plane::cleanUp

if obj_isa(self.parent,'blv_optical_source') then $
		self.parent->remove, self

obj_destroy, self.rays
obj_destroy, self.sModel.graphic
end
;***********setProperty****************
;
;PURPOSE: modify the field of the object when the keyWord of the field is used
;
pro optical_plane::setProperty,Graphic=graphic, $
								parent=parent, $
								color=color, $
								t_location=t_location, $
								show=show, $
								shImage=shImage, $
								rays=rays, $
								beam_file=beam_file, $
								default_style=default_style, $
								default_lineStyle=default_lineStyle, $
								orientation=orientation, $
								name=name


if n_elements(graphics) NE 0 then self.smodel.graphic=graphic
if n_elements(color) NE 0 then self.sPrivateParameter.color=color
if n_elements(parent) ne 0 then self.parent=parent
if n_elements(t_location) ne 0 then self.sprivateParameter.t_location=t_location
if n_elements(show) NE 0 then self.sPrivateParameter.show=show
if n_elements(shImage) NE 0 then begin
	self.sPrivateParameter.shImage=shImage
	if self.sPrivateParameter.shImage eq 0 then self->paste_image $
								else self->unPaste_image
endif

if n_elements(beam_file) NE 0 then self.sPrivateParameter.beam_file=beam_file
if n_elements(default_style)  ne 0 then begin
		self.sPrivateParameter.default_style=default_style
		plane=self.sModel.graphic->getByName('plane')
		plane->setProperty, style=self.sPrivateParameter.default_style
endif
if n_elements(default_lineStyle)  ne 0 then begin
		self.sPrivateParameter.default_lineStyle=default_lineStyle
		plane=self.sModel.graphic->getByName('plane')
		plane->setProperty, linestyle=self.sPrivateParameter.default_linestyle
endif
if n_elements(rays) NE 0 then begin
	obj_destroy, self.rays
	self.rays=rays
endif
if n_elements(orientation) then begin
	self.sprivateParameter.x=orientation[0]
	self.sprivateParameter.y=orientation[1]
	self.sprivateParameter.z=orientation[2]
	self->select_axes, x=x, y=y, z=z
	plane=self.sModel.graphic->getbyName('plane')
	obj_destroy, plane
	plane=obj_new('idlgrpolygon',x,y,z,color=self.sprivateParameter.color, $
					style=self.sprivateParameter.default_style, name='plane', $
					lineStyle=self.sprivateParameter.default_lineStyle)
	self.sModel.graphic->add, plane
endif
if n_elements(name) ne 0 then self.name=name
self->upDate_parameter
end
;***************************************
;purpose: to change the value of the fiel 'show'
pro optical_plane::flip, show=show
if n_elements(show) NE 0 then self.sPrivateParameter.show=abs(self.sPrivateParameter.show-1)
end
;*********************************************
;PURPOSE: return the field of the object when the keyWord of the field is used
pro optical_plane::getProperty, Graphic=graphic, $
								parent=parent, $
								color=color, $
								t_location=t_location, $
								show=show, $
								rays=rays, $
								shImage=shImage, $
								beam_file=beam_file, $
								default_lineStyle=default_lineStyle, $
								x=x, y=y, z=z, $
								name=name

graphic=self.smodel.graphic
parent=self.parent
color=self.sPrivateParameter.color
t_location=self.sPrivateParameter.t_location
show=self.sPrivateParameter.show
rays=self.rays
shImage=self.sPrivateParameter.shImage
beam_file=self.sPrivateParameter.beam_file
default_lineStyle=self.sPrivateParameter.default_lineStyle
x=self.sPrivateParameter.x
y=self.sPrivateParameter.y
z=self.sPrivateParameter.z
name=self.name
end
;**********************************
;purpose: to get the 3D transformation apply on the model's optical_plane
function optical_plane::get_transform
self.smodel.graphic->getProperty, trans=T
return, T
end
;***********************************
;purpose: to change the picture associated to plane
pro optical_plane::set_image, image
self.image=image
end

;***********************************
;purpose: to get the picture associated to plane
function optical_plane::get_image
return, self.image
end
;***********************************
;purpose: to paste the actual picture on plane
pro optical_plane::paste_image
im=bytarr(128,128,4)
im[*,*,0]=255
im[*,*,1]=255
im[*,*,2]=255
im[*,*,3]=congrid(self.image[*,*], 128, 128)

imageNew=obj_new('idlgrimage',data=im, dimensions=[1.,1.], /GREYSCALE, INTERLEAVE=2)
imageNew->getProperty, data=imTest

plane=self.sModel.graphic->getbyname('plane')
plane->getProperty,texture_map=imageOld
obj_destroy, imageOld
plane->setProperty, style=2, lineStyle=0, $
					TEXTURE_COORD = [[0,0], [1,0], [1,-1], [0,-1]], $
					TEXTURE_MAP=imageNew
end
;**********************************
;purpose: to unpaste the actual picture
pro optical_plane::unpaste_image
plane=self.sModel.graphic->getbyname('plane')
plane->setProperty, style=self.sPrivateParameter.default_style, $
					lineStyle=self.sprivateParameter.default_lineStyle, $
					TEXTURE_MAP=obj_new()
end
;***********************************
;purpose: to unpaste or paste the actual picture function to the actual situation
pro optical_plane::flip_paste_image
self.sPrivateParameter.shImage=abs(self.sPrivateParameter.shImage-1)
if self.sPrivateParameter.shImage eq 0 then self->paste_image $
								else self->unPaste_image
end
;;***********trace****************
;PURPOSE: build the element necessary to the graphic representation
;		function to the current property
pro optical_plane::trace, distMax

self->update_parameter

if not obj_isa(self.parent,'optical_module') then return

self.smodel.graphic->reset
self.parent->getProperty, dimension_scale=dimension_scale
self.parent->getProperty, parent=system

if obj_isa(system,'optical_system') then begin
	system->getProperty, dimension_scale=g_dimension_scale, distEqual=distEqual, flagEqual=flagEqual
endif else g_dimension_scale=1.

if self.sprivateParameter.t_location gt 0 then self.parent->getProperty, t_image=t_distMax $
	else self.parent->getProperty, t_source=t_distMax

if flagEqual then begin
	if t_distMax ne 0 then t_location=self.sprivateParameter.t_location*distEqual/t_distMax $
	else t_location=distEqual

	t_distMax=distEqual
endif else t_location=self.sprivateParameter.t_location

location=abs(t_location)*distMax/t_distMax
if self.sprivateParameter.t_location ne 0 then location=(location-distMax)*abs(t_location)/t_location $
else location=(location-distMax)

if not strcmp(self.name,'element') then self.smodel.graphic->scale, dimension_scale*g_dimension_scale, $
										dimension_scale*g_dimension_scale, $
										dimension_scale*g_dimension_scale

self.smodel.graphic->translate, 0, location, 0
self.smodel.graphic->setProperty, hide=self.sprivateParameter.show
end
;******************************************
;purpose: to apply the actual parameter
pro optical_plane::update_parameter
color_model, self.sModel.graphic, self.sPrivateParameter.color
end
;****************************************
;purpose: to delete the actual beam
pro optical_plane::delete_beam
obj_destroy, self.rays
self.rays=obj_new('blbeam')
end
;****************Main********************
;purpose the define procedure
pro optical_plane__define

parent=obj_new()

image=intArr(256,256)
rays=obj_new()

sModel={model_plane, $
		graphic:obj_new() $
		}



flt=0.
int=0

sPrivateParameter={parameters_plane, $
			t_location:flt, $
			color:[int,int,int], $
			show:int, $
			shImage:int, $
			default_style:int, $
			default_lineStyle:int, $
			beam_file:string(''), $
			x:int, y:int, z:int $
			}

struct={optical_plane, $ ;name of the structure
		parent:parent ,$
		image:image, $
		sModel:sModel, $
		sPrivateParameter:sPrivateParameter, $
		rays:rays, $
		name:string('') $
		}
end
