
#
# GENERATED WITH PDL::PP! Don't modify!
#
package PDL::Complex;

@EXPORT_OK  = qw(  Ctan  Catan  re  im  i  cplx  real PDL::PP r2C PDL::PP i2C PDL::PP Cr2p PDL::PP Cp2r PDL::PP Cadd PDL::PP Csub PDL::PP Cmul PDL::PP Cscale PDL::PP Cdiv PDL::PP Ccmp PDL::PP Cconj PDL::PP Cabs PDL::PP Cabs2 PDL::PP Carg PDL::PP Csin PDL::PP Ccos PDL::PP Cexp PDL::PP Clog PDL::PP Cpow PDL::PP Csqrt PDL::PP Casin PDL::PP Cacos PDL::PP Csinh PDL::PP Ccosh PDL::PP Ctanh PDL::PP Casinh PDL::PP Cacosh PDL::PP Catanh PDL::PP Cproj PDL::PP Croots PDL::PP rCpolynomial );
%EXPORT_TAGS = (Func=>[@EXPORT_OK]);

use PDL::Core;
use PDL::Exporter;
use DynaLoader;


BEGIN {
   
   @ISA    = ( 'PDL::Exporter','DynaLoader','PDL' );
   push @PDL::Core::PP, __PACKAGE__;
   bootstrap PDL::Complex ;
}



=head1 NAME

PDL::Complex - handle complex numbers

=head1 SYNOPSIS

  use PDL;
  use PDL::Complex;

=head1 DESCRIPTION

This module features a growing number of functions manipulating complex
numbers. These are usually represented as a pair C<[ real imag ]> or
C<[ angle phase ]>. If not explicitly mentioned, the functions can work
inplace (not yet implemented!!!) and require rectangular form.

While there is a procedural interface available (C<$a/$b*$c <=> Cmul
(Cdiv $a, $b), $c)>), you can also opt to cast your pdl's into the
C<PDL::Complex> datatype, which works just like your normal piddles, but
with all the normal perl operators overloaded.

The latter means that C<sin($a) + $b/$c> will be evaluated using the
normal rules of complex numbers, while other pdl functions (like C<max>)
just treat the piddle as a real-valued piddle with a lowest dimension of
size 2, so C<max> will return the maximum of all real and imaginary parts,
not the "highest" (for some definition)

=head1 TIPS, TRICKS & CAVEATS

=over 4

=item *

C<i> is a constant exported by this module, which represents
C<-1**0.5>, i.e. the imaginary unit. it can be used to quickly and
conviniently write complex constants like this: C<4+3*i>.

=item *

Use C<r2C(real-values)> to convert from real to complex, as in C<$r
= Cpow $cplx, r2C 2>. The overloaded operators automatically do that for
you, all the other functions, do not. So C<Croots 1, 5> will return all
the fifths roots of 1+1*i (due to threading).

=item *

use C<cplx(real-valued-piddle)> to cast from normal piddles intot he
complex datatype. Use C<real(complex-valued-piddle)> to cast back. This
requires a copy, though.

=item *

BEWARE: This module has not been extensively tested. Watch out and
send me bugreports!

=back

=head1 EXAMPLE WALK-THROUGH

The complex constant five is equal to C<pdl(1,0)>:

   perldl> p $x = r2C 5
   [5 0]

Now calculate the three roots of of five:

   perldl> p $r = Croots $x, 3 

   [
    [  1.7099759           0]
    [-0.85498797   1.4808826]
    [-0.85498797  -1.4808826]
   ]

Check that these really are the roots of unity:

   perldl> p $r ** 3

   [
    [             5              0]
    [             5 -3.4450524e-15]
    [             5 -9.8776239e-15]
   ]

Duh! Could be better. Now try by multiplying C<$r> three times with itself:

   perldl> p $r*$r*$r

   [
    [             5              0]
    [             5 -2.8052647e-15]
    [             5 -7.5369398e-15]
   ]

Well... maybe C<Cpow> (which is used by the C<**> operator) isn't as
bad as I thought. Now multiply by C<i> and negate, which is just a very
expensive way of swapping real and imaginary parts.

   perldl> p -($r*i)

   [
    [         -0   1.7099759]
    [  1.4808826 -0.85498797]
    [ -1.4808826 -0.85498797]
   ]

Now plot the magnitude of (part of) the complex sine. First generate the
coefficients:

   perldl> $sin = i * zeroes(50)->xlinvals(2,4)
                    + zeroes(50)->xlinvals(0,7)

Now plot the imaginary part, the real part and the magnitude of the sine
into the same diagram:

   perldl> line im sin $sin; hold
   perldl> line re sin $sin
   perldl> line abs sin $sin

Sorry, but I didn't yet try to reproduce the diagram in this
text. Just run the commands yourself, making sure that you have loaded
C<PDL::Complex> (and C<PDL::Graphics::PGPLOT>).


=cut







=head1 FUNCTIONS



=cut





=head2 cplx real-valued-pdl

Cast a real-valued piddle to the complex datatype. The first dimension of
the piddle must be of size 2. After this the usual (complex) arithmetic
operators are applied to this pdl, rather than the normal elementwise pdl
operators.  Dataflow to the complex parent works. Use C<sever> on the result
if you don't want this.


=head2 real cplx-valued-pdl

Cast a complex vlaued pdl back to the "normal" pdl datatype. Afterwards
the normal elementwise pdl operators are used in operations. Dataflow
to the real parent works. Use C<sever> on the result if you don't want this.

=cut

sub cplx($) {
   bless $_[0]->slice('');
}

*PDL::cplx = \&cplx;

sub real($) {
   bless $_[0]->slice(''), 'PDL';
}





=head2 r2C

=for sig

  Signature: (r(); [o]c(m=2))

=for ref

convert real to complex, assuming an imaginary part of zero

=for bad

r2C does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut




sub PDL::r2C($) { my $r = __PACKAGE__->initialize; &PDL::_r2C_int($_[0], $r); $r }

BEGIN {*r2C = \&PDL::r2C;
}



=head2 i2C

=for sig

  Signature: (r(); [o]c(m=2))

=for ref

convert imaginary to complex, assuming a real part of zero

=for bad

i2C does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut




sub PDL::i2C($) { my $r = __PACKAGE__->initialize; &PDL::_i2C_int($_[0], $r); $r }

BEGIN {*i2C = \&PDL::i2C;
}



=head2 Cr2p

=for sig

  Signature: (r(m=2); float+ [o]p(m=2))

=for ref

convert complex numbers in rectangular form to polar (mod,arg) form

=for bad

Cr2p does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Cr2p = \&PDL::Cr2p;
}



=head2 Cp2r

=for sig

  Signature: (r(m=2); [o]p(m=2))

=for ref

convert complex numbers in polar (mod,arg) form to rectangular form

=for bad

Cp2r does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Cp2r = \&PDL::Cp2r;
}



BEGIN {*Cadd = \&PDL::Cadd;
}



BEGIN {*Csub = \&PDL::Csub;
}



=head2 Cmul

=for sig

  Signature: (a(m=2); b(m=2); [o]c(m=2))

=for ref

complex multiplication

=for bad

Cmul does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Cmul = \&PDL::Cmul;
}



=head2 Cscale

=for sig

  Signature: (a(m=2); b(); [o]c(m=2))

=for ref

mixed complex/real multiplication

=for bad

Cscale does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Cscale = \&PDL::Cscale;
}



=head2 Cdiv

=for sig

  Signature: (a(m=2); b(m=2); [o]c(m=2))

=for ref

complex division

=for bad

Cdiv does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Cdiv = \&PDL::Cdiv;
}



=head2 Ccmp

=for sig

  Signature: (a(m=2); b(m=2); [o]c())

=for ref

Complex comparison oeprator (spaceship). It orders by real first, then by imaginary.

=for bad

Ccmp does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Ccmp = \&PDL::Ccmp;
}



=head2 Cconj

=for sig

  Signature: (a(m=2); [o]c(m=2))

=for ref

complex conjugation

=for bad

Cconj does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Cconj = \&PDL::Cconj;
}



=head2 Cabs

=for sig

  Signature: (a(m=2); [o]c())

=for ref

complex C<abs()> (also known as I<modulus>)

=for bad

Cabs does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Cabs = \&PDL::Cabs;
}



=head2 Cabs2

=for sig

  Signature: (a(m=2); [o]c())

=for ref

complex squared C<abs()> (also known I<squared modulus>)

=for bad

Cabs2 does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Cabs2 = \&PDL::Cabs2;
}



=head2 Carg

=for sig

  Signature: (a(m=2); [o]c())

=for ref

complex argument function ("angle")

=for bad

Carg does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Carg = \&PDL::Carg;
}



=head2 Csin

=for sig

  Signature: (a(m=2); [o]c(m=2))

=for ref

  sin (a) = 1/(2*i) * (exp (a*i) - exp (-a*i))

=for bad

Csin does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Csin = \&PDL::Csin;
}



=head2 Ccos

=for sig

  Signature: (a(m=2); [o]c(m=2))

=for ref

  cos (a) = 1/2 * (exp (a*i) + exp (-a*i))

=for bad

Ccos does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Ccos = \&PDL::Ccos;
}


=head2 Ctan a [not inplace]

  tan (a) = -i * (exp (a*i) - exp (-a*i)) / (exp (a*i) + exp (-a*i))

=cut

sub Ctan($) { Csin($_[0]) / Ccos($_[0]) }





=head2 Cexp

=for sig

  Signature: (a(m=2); [o]c(m=2))

=for ref

exp (a) = exp (real (a)) * (cos (imag (a)) + i * sin (imag (a)))

=for bad

Cexp does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Cexp = \&PDL::Cexp;
}



=head2 Clog

=for sig

  Signature: (a(m=2); [o]c(m=2))

=for ref

log (a) = log (cabs (a)) + i * carg (a)

=for bad

Clog does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Clog = \&PDL::Clog;
}



=head2 Cpow

=for sig

  Signature: (a(m=2); b(m=2); [o]c(m=2))

=for ref

complex C<pow()> (C<**>-operator)

=for bad

Cpow does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Cpow = \&PDL::Cpow;
}



=head2 Csqrt

=for sig

  Signature: (a(m=2); [o]c(m=2))

=for ref



=for bad

Csqrt does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Csqrt = \&PDL::Csqrt;
}



=head2 Casin

=for sig

  Signature: (a(m=2); [o]c(m=2))

=for ref



=for bad

Casin does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Casin = \&PDL::Casin;
}



=head2 Cacos

=for sig

  Signature: (a(m=2); [o]c(m=2))

=for ref



=for bad

Cacos does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Cacos = \&PDL::Cacos;
}


=head2 Catan cplx [not inplace]

Return the complex C<atan()>.

=cut

sub Catan($) {
   my $z = shift;
   Cmul pdl(0, 0.5), Clog Cdiv PDL::Complex::i+$z, PDL::Complex::i-$z;
}





=head2 Csinh

=for sig

  Signature: (a(m=2); [o]c(m=2))

=for ref

  sinh (a) = (exp (a) - exp (-a)) / 2

=for bad

Csinh does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Csinh = \&PDL::Csinh;
}



=head2 Ccosh

=for sig

  Signature: (a(m=2); [o]c(m=2))

=for ref

  cosh (a) = (exp (a) + exp (-a)) / 2

=for bad

Ccosh does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Ccosh = \&PDL::Ccosh;
}



=head2 Ctanh

=for sig

  Signature: (a(m=2); [o]c(m=2))

=for ref



=for bad

Ctanh does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Ctanh = \&PDL::Ctanh;
}



=head2 Casinh

=for sig

  Signature: (a(m=2); [o]c(m=2))

=for ref



=for bad

Casinh does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Casinh = \&PDL::Casinh;
}



=head2 Cacosh

=for sig

  Signature: (a(m=2); [o]c(m=2))

=for ref



=for bad

Cacosh does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Cacosh = \&PDL::Cacosh;
}



=head2 Catanh

=for sig

  Signature: (a(m=2); [o]c(m=2))

=for ref



=for bad

Catanh does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Catanh = \&PDL::Catanh;
}



=head2 Cproj

=for sig

  Signature: (a(m=2); [o]c(m=2))

=for ref

compute the projection of a complex number to the riemann sphere

=for bad

Cproj does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*Cproj = \&PDL::Cproj;
}



=head2 Croots

=for sig

  Signature: (a(m=2); [o]c(m=2,n); int n => n)

=for ref

Compute the C<n> roots of C<a>. C<n> must be a positive integer. The result will always be a complex type!

=for bad

Croots does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut




sub PDL::Croots($$) {
           my ($pdl, $n) = @_;
           my $r = PDL->null;
           &PDL::_Croots_int($pdl, $r, $n);
           bless $r;
        }

BEGIN {*Croots = \&PDL::Croots;
}


=head2 re cplx, im cplx

Return the real or imaginary part of the complex number(s) given. These
are slicing operators, so data flow works. The real and imaginary parts
are returned as piddles (ref eq PDL).

=cut

sub re($) { bless $_[0]->slice("(0)"), 'PDL' }
sub im($) { bless $_[0]->slice("(1)"), 'PDL' }





=head2 rCpolynomial

=for sig

  Signature: (coeffs(n); x(c=2,m); [o]out(c=2,m))

=for ref

evaluate the polynomial with (real) coefficients C<coeffs> at the (complex) position(s) C<x>. C<coeffs[0]> is the constant term.

=for bad

rCpolynomial does not process bad values.
It will set the bad-value flag of all output piddles if the flag is set for any of the input piddles.


=cut






BEGIN {*rCpolynomial = \&PDL::rCpolynomial;
}

;


# overload must be here, so that all the functions can be seen

# undocumented compatibility functions
sub Catan2($$) { Catan Cdiv $_[1], $_[0] }
sub atan2($$)  { Catan Cdiv $_[1], $_[0] }

sub _gen_biop {
   local $_ = shift;
   my $sub;
   if (/(\S+)\+(\w+)/) {
      $sub = eval 'sub { '.$2.' $_[0], ref $_[1] eq __PACKAGE__ ? $_[1] : r2C $_[1] }';
   } elsif (/(\S+)\-(\w+)/) {
      $sub = eval 'sub { my $b = ref $_[1] eq __PACKAGE__ ? $_[1] : r2C $_[1];
                       $_[2] ? '.$2.' $b, $_[0] : '.$2.' $_[0], $b }';
   } else {
      die;
   }
   return ($1, $sub) if $1 eq "atan2";
   ($1, $sub, "$1=", $sub);
}

sub _gen_unop {
   my ($op, $func) = ($_[0] =~ /(.+)@(\w+)/);
   *$op = \&$func if $op =~ /\w+/; # create an alias
   ($op, eval 'sub { '.$func.' $_[0] }');
}

sub _gen_cpop {
   ($_[0], eval 'sub { my $b = ref $_[1] eq __PACKAGE__ ? $_[1] : r2C $_[1];
                 ($_[2] ? $b <=> $_[0] : $_[0] <=> $b) '.$_[0].' 0 }');
}

sub initialize {
   bless PDL->null, $_[0];
}

BEGIN { $i = bless pdl 0,1 }
sub i () { $i->copy };

use overload
   (map _gen_biop($_), qw(++Cadd --Csub *+Cmul /-Cdiv **-Cpow atan2-Catan2 <=>-Ccmp)),
   (map _gen_unop($_), qw(sin@Csin cos@Ccos exp@Cexp abs@Cabs log@Clog sqrt@Csqrt abs@Cabs)),
   (map _gen_cpop($_), qw(< <= == != => >)),
   '++' => sub { $_[0] += 1 },
   '--' => sub { $_[0] -= 1 },
;

# overwrite PDL's overloading to honour subclass methods in + - * /
{ package PDL;
        my $warningFlag;
        # This strange usage of BEGINs is to ensure the
        # warning messages get disabled and enabled in the
        # proper order. Without the BEGIN's the 'use overload'
        #  would be called first.
        BEGIN {$warningFlag = $^W; # Temporarily disable warnings caused by 
               $^W = 0;            # redefining PDL's subs
              }


sub cp(;@) {
	my $foo; 
	if (ref $_[1]
		&& (ref $_[1] ne 'PDL')
		&& defined ($foo = overload::Method($_[1],'+')))
		{ &$foo($_[1], $_[0], !$_[2])}
	else { PDL::plus (@_)}
}

sub cm(;@) {
	my $foo; 
	if (ref $_[1]
		&& (ref $_[1] ne 'PDL')
		&& defined ($foo = overload::Method($_[1],'*')))
		{ &$foo($_[1], $_[0], !$_[2])}
	else { PDL::mult (@_)}
}

sub cmi(;@) {
	my $foo; 
	if (ref $_[1]
		&& (ref $_[1] ne 'PDL')
		&& defined ($foo = overload::Method($_[1],'-')))
		{ &$foo($_[1], $_[0], !$_[2])}
	else { PDL::minus (@_)}
}

sub cd(;@) {
	my $foo; 
	if (ref $_[1]
		&& (ref $_[1] ne 'PDL')
		&& defined ($foo = overload::Method($_[1],'/')))
		{ &$foo($_[1], $_[0], !$_[2])}
	else { PDL::divide (@_)}
}


  # Used in overriding standard PDL +, -, *, / ops in the complex subclass.
  use overload (
		 '+' => \&cp,
		 '*' => \&cm,
	         '-' => \&cmi,
		 '/' => \&cd,
		);



        BEGIN{ $^W = $warningFlag;} # Put Back Warnings  
};

=head1 AUTHOR

Copyright (C) 2000 Marc Lehmann <pcg@goof.com>. 
All rights reserved. There is no warranty. You are allowed
to redistribute this software / documentation as described
in the file COPYING in the PDL distribution.

=head1 SEE ALSO

perl(1), L<PDL>.

=cut




# Exit with OK status

1;

		   