;ZipDLL include file for NSIS
;Written by Tim Kosse (mailto:tim.kosse@gmx.de)
;some improvements by deguix

;Supported languages with their translators in alphabetical order:

;Arabic translation by asdfuae
;Brazilian Portuguese translation by "deguix"
;Chinese, Simplified translation by Kii Ali <kiiali@cpatch.org>
;Chinese, Traditional traslation by "matini" and Kii Ali <kiiali@cpatch.org>
;Croatian translation by "iostriz"
;Danish translation by Claus Futtrup
;French translation by "veekee"
;German translation by Tim Kosse
;Hungarian translation by Toth Laszlo
;Korean translation by Seongab Kim
;Lithuanian translation by Vytautas Krivickas
;Polish translation by Krzysztof Galuszka
;Russion translation by Sergey
;Spanish translation by "dark_boy"

!ifndef ZIPDLL_USED

!define ZIPDLL_USED

!macro ZIPDLL_EXTRACT SOURCE DESTINATION FILE

  !define "FILE_${FILE}"

  !ifndef FILE_<ALL>
    Push "${FILE}"
  !endif

  IfFileExists "${DESTINATION}" +2
    CreateDirectory "${DESTINATION}"

  Push "${DESTINATION}"

  IfFileExists "${SOURCE}" +2
    SetErrors

  Push "${SOURCE}"

  ;The strings that will be translated are (ready to copy,
  ;remove leading semicolons in your language block):

  !ifdef LANG_ENGLISH

    ;English is default language of ZipDLL, no need to push the untranslated strings

    ;StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +1

      ;Push "  Error: %s"
      ;Push "Could not get file attributes."
      ;Push "Error: Could not get file attributes."
      ;Push "Could not extract %s"
      ;Push "  Error: Could not extract %s"

      ;!ifdef FILE_<ALL>
        ;Push "  Extract: %s"
        ;Push "  Extracting %d files and directories"
        ;Push "Extracting contents of %s to %s"
      ;!else
        ;Push "Specified file does not exist in archive."
        ;Push "Error: Specified file does not exist in archive."
        ;Push "Extracting the file %s from %s to %s"
      ;!endif

      ;Push "/TRANSLATE"

  !endif

  !ifdef LANG_HUNGARIAN

    StrCmp $LANGUAGE ${LANG_HUNGARIAN} 0 +10

      Push "  Hiba: %s"
      Push "Nem olvashat a fjl attribtumai."
      Push "Hiba: Nem olvashat a fjl attribtumai."
      Push "Nem sikerlt kicsomagolni a(z) %s"
      Push "  Hiba: Nem sikerlt kicsomagolni a(z) %s"

      !ifdef FILE_<ALL>
        Push "  Kicsomagols: %s"
        Push "  %d fjl s mappa kicsomagolsa"
        Push "%s tartalom kicsomagolsa a %s helyre"
      !else
        Push "A megadott fjl nem tallhat az arhvumban."
        Push "Hiba: A megadott fjl nem tallhat az arhvumban."
        Push "%s fjl kcsomagolsa a(z) %s fjlbl a %s helyre"
      !endif

      Push "/TRANSLATE"

  !endif

  !ifdef LANG_FRENCH

    StrCmp $LANGUAGE ${LANG_FRENCH} 0 +10

      Push "  Erreur : %s"
      Push "Impossible de rcuprer les informations sur le fichier."
      Push "Erreur : Impossible de rcuprer les informations sur le fichier."
      Push "Impossible de dcompresser %s."
      Push "  Erreur : Impossible de dcompresser %s."

      !ifdef FILE_<ALL>
        Push "  Dcompression : %s"
        Push "  Dcompression de %d fichiers et rpertoires"
        Push "Dcompression des donnes de %s vers %s"
      !else
        Push "Le fichier spcifi n'existe pas dans l'archive"
        Push "Erreur : Le fichier spcifi n'existe pas dans l'archive"
        Push "Dcompression du fichier %s depuis %s vers %s"
      !endif

      Push "/TRANSLATE"

  !endif

  !ifdef LANG_GERMAN

    StrCmp $LANGUAGE ${LANG_GERMAN} 0 +10

      Push "  Fehler: %s"
      Push "Dateiattribute konnten nicht ermittelt werden."
      Push "Fehler: Dateiattribute konnten nicht ermittelt werden."
      Push "%s konnte nicht dekomprimiert werden."
      Push "  Fehler: %s konnte nicht dekomprimiert werden."

      !ifdef FILE_<ALL>
        Push "  Dekomprimiere: %s"
        Push "  Dekomprimiere %d Dateien und Verzeichnisse"
        Push "Dekomprimiere Inhalt von %s nach %s"
      !else
        Push "Die angegebene Datei existiert nicht im Archiv"
        Push "Fehler: Die angegebene Datei existiert nicht im Archiv"
        Push "Dekomprimiere Datei %s von %s nach %s"
      !endif

      Push "/TRANSLATE"

  !endif

  !ifdef LANG_SPANISH

    StrCmp $LANGUAGE ${LANG_SPANISH} 0 +10

      Push "  Error: %s"
      Push "No se obtuvieron atributos del archivo"
      Push "Error: No se obtuvieron atributos del archivo"
      Push "No se pudo extraer %s"
      Push "  Error: No se pudo extraer %s"

      !ifdef FILE_<ALL>
        Push "  Extraer: %s"
        Push "  Extrayendo %d archivos y directorios"
        Push "Extraer archivos de %s a %s"
      !else
        Push "Archivo especificado no existe en el ZIP"
        Push "Error: El archivo especificado no existe en el ZIP"
        Push "Extrayendo el archivo %s de %s a %s"
      !endif

      Push "/TRANSLATE"

  !endif

  !ifdef LANG_PORTUGUESEBR

    StrCmp $LANGUAGE ${LANG_PORTUGUESEBR} 0 +10

      Push "  Erro: %s"
      Push "No se pode ler os atributos do arquivo"
      Push "Error: No se pode ler os atributos do arquivo"
      Push "No se pode extrair %s"
      Push "  Erro: No se pode extrair %s"

      !ifdef FILE_<ALL>
        Push "  Extraindo: %s"
        Push "  Extraindo %d arquivos e diretrios"
        Push "Extraindo arquivos de %s a %s"
      !else
        Push "O arquivo especificado no existe no ZIP"
        Push "Erro: O arquivo especificado no existe no ZIP"
        Push "Extraindo o arquivo %s de %s a %s"
      !endif

      Push "/TRANSLATE"

  !endif

  !ifdef LANG_TRADCHINESE

  StrCmp $LANGUAGE ${LANG_TRADCHINESE} 0 +11

    Push "  ~: %s"
    Push "LkoɮݩʡC"
    Push "~: LkoɮݩʡC"
    Push "LkY %s"
    Push "  ~GLkY %s"
    
    !ifdef FILE_<ALL>
      Push "  YG%s"
      Push "  bY %d ɮ׻Pؿ"
      Push "bY %s e %s"
    !else
      Push "wɮרäsbY]C"
      Push "~GwɮרäsbY]C"
      Push "bYɮ %s Aq %s  %s"
    !endif
    
    Push "/TRANSLATE"

  !endif

  !ifdef LANG_SIMPCHINESE

  StrCmp $LANGUAGE ${LANG_SIMPCHINESE} 0 +11

    Push "  : %s"
    Push "޷ȡļԡ"
    Push ": ޷ȡļԡ"
    Push "޷ѹ %s"
    Push "  ޷ѹ %s"
    
    !ifdef FILE_<ALL>
      Push "  ѹ%s"
      Push "  ڽѹ %d ļĿ¼"
      Push "ڽѹ %s ݵ %s"
    !else
      Push "ָļѹ"
      Push "ָļѹ"
      Push "ڽѹļ %s  %s  %s"
    !endif
    
    Push "/TRANSLATE"

  !endif

  !ifdef LANG_LITHUANIAN

    StrCmp $LANGUAGE ${LANG_LITHUANIAN} 0 +10

      Push "  Klaida: %s"
      Push "Negaleta gauti bylos nuorodu."
      Push "Klaida: Negaleta gauti bylos nuorodu."
      Push "Negaleta itraukti %s"
      Push "  Klaida: Negaleta itraukti %s"

      !ifdef FILE_<ALL>
        Push "  Itraukiam : %s"
        Push "  Itraukiame %d bylas ir katalogus"
        Push "Itraukiame viska is %s i %s"
      !else
        Push "Parinkta byla nesurasta iame archyve."
        Push "Klaida: Parinkta byla nesurasta iame archyve."
        Push "Itraukiame byla %s i %s i %s"
      !endif

      Push "/TRANSLATE"

  !endif

  !ifdef "LANG_POLISH"

    strcmp $LANGUAGE ${LANG_POLISH} 0 +10

      Push "  Bd: %s"
      Push "Nie moe pobra atrybutu pliku."
      Push "Bd: Nie moe pobra atrybutu pliku."
      Push "Nie moe rozpakowa %s."
      Push "  Bd: Nie moe rozpakowa %s."

      !ifdef FILE_<ALL>
        Push "  Rozpakuj: %s"
        Push "  Rozpakowywanie %d plikw i katalogw"
        Push "Rozpakowywanie zawartoci %s do %s"
      !else
        Push "Plik nie istnieje w archiwum"
        Push "Bd: Plik nie istnieje w archiwum"
        Push "Rozpakowywanie pliku %s z %s do %s"
      !endif

      Push "/TRANSLATE"

  !endif

  !ifdef "LANG_KOREAN"
    strcmp $LANGUAGE ${LANG_KOREAN} 0 +10
      Push "   : %s"
      Push "ȭ Ӽ   ϴ."
      Push ": ȭ Ӽ   ϴ."
      Push "%s() Ǯ  ϴ."
      Push "  : %s() Ǯ  ϴ."

      !ifdef FILE_<ALL>
        Push "  Ǯ : %s"
        Push "  %d ϰ  Ǫ "
        Push "%s  %s Ǫ "
      !else
        Push "    ȿ ϴ."
        Push ":     ȿ ϴ."
        Push "%s  %s %s Ǫ "
      !endif

      Push "/TRANSLATE"

  !endif

  !ifdef "LANG_RUSSIAN"

    strcmp $LANGUAGE ${LANG_RUSSIAN} 0 +10

      Push "  : %s"
      Push "    ."
      Push ":     ."
      Push "   %s"
      Push "  :    %s"

      !ifdef LANG_<ALL>
        Push "   : %s"
        Push "   %d   "
        Push "    %s  %s"
      !else
        Push "     ."
        Push ": S     ."
        Push "  %s  %s  %s"
      !endif

      Push "/TRANSLATE"

  !endif

  !ifdef LANG_ARABIC

    StrCmp $LANGUAGE ${LANG_ARABIC} 0 +10

      Push "  : %s"
      Push "    ."
      Push ":     ."
      Push "   %s"
      Push " :    %s"
  
      !ifdef FILE_<ALL>
        Push "   : %s"
        Push "      %d"
        Push "  %s  %s"
      !else
        Push "    ."
        Push ":     ."
        Push "  %s  %s  %s"
      !endif

      Push "/TRANSLATE"

  ;!endif

  !ifdef LANG_DANISH

    StrCmp $LANGUAGE ${LANG_DANISH} 0 +10

      Push "  Fejl: %s"
      Push "Kunne ikke lse fil attributter."
      Push "Fejl: Kunne ikke lse fil attributter."
      Push "Kunne ikke udpakke %s"
      Push "  Fejl: Kunne ikke udpakke %s"

      !ifdef FILE_<ALL>
        Push "  Udpakker: %s"
        Push "  Udpakker %d filer og mapper"
        Push "Udpakker indhold fra %s til %s"
      !else
        Push "Specificeret fil eksisterer ikke i filarkivet"
        Push "Fejl: Specificeret fil eksisterer ikke i filarkivet"
        Push "Udpakker fil %s fra %s til %s"
      !endif

      Push "/TRANSLATE"

  !endif 

  !ifdef LANG_CROATIAN

    StrCmp $LANGUAGE ${LANG_CROATIAN} 0 +10

      Push "  Greka: %s"
      Push "Ne mogu dohvatiti atribute datoteke."
      Push "Greka: Ne mogu dohvatiti atribute datoteke."
      Push "Ne mogu ekstrahirati %s"
      Push "  Greka: Ne mogu ekstrahirati %s"

      !ifdef FILE_<ALL>
        Push "  Ekstrakcija: %s"
        Push "  Ekstrakcija %d datoteka i mapa"
        Push "Ekstrakcija sadraja %s u %s"
      !else
        Push "Traena datoteka ne postoji u arhivi."
        Push "Greka: Traena datoteka ne postoji u arhivi."
        Push "Ekstrakcija datoteke %s iz %s u %s"
      !endif

      Push "/TRANSLATE"

  !endif

  !ifdef FILE_<ALL>
    ZipDLL::extractall
  !else
    ZipDLL::extractfile
  !endif

  !undef "FILE_${FILE}"

!macroend

!endif
