#! /usr/bin/perl
#
# Implements graphical installer for McStas / OS X
#
#
#   This file is part of the McStas neutron ray-trace simulation package
#   Copyright (C) 1997-2006, All rights reserved
#   Risoe National Laborartory, Roskilde, Denmark
#   Institut Laue Langevin, Grenoble, France
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

my $INSTDIR = $ARGV[0];

use Tk;

my $w = new MainWindow;

$w->title("McStas installer, Mac OS X");
my $f2 = $w->Frame();

my $toplabel = $f2->Label(-text => "Support tools:",
                               -anchor => 'w',
                               -justify => 'left',-fg => 'Black');
$toplabel->pack(-side => 'left');
$f2->pack(-fill => 'both');

my $f3 = $w->Frame();
my $install_Tk = $f3->Button(-text => "Install Perl-Tk",
                               -anchor => 'w',
                               -justify => 'left',-fg => 'red', -command => sub {dopTk()});
$install_Tk->pack(-side => 'left');
my $install_PGPLOT = $f3->Button(-text => "Install PGPLOT",
                               -anchor => 'w',
                               -justify => 'left',-fg => 'red', -command => sub {doPGPLOT()});
$install_PGPLOT->pack(-side => 'left');
my $install_FreeWRL = $f3->Button(-text => "Install FreeWRL",
                               -anchor => 'w',
                               -justify => 'left',-fg => 'red', -command => sub {doFreeWRL()});
$install_FreeWRL->pack(-side => 'left');
$f3->pack(-fill => 'x');

my $f4 = $w->Frame();
my $toplabel = $f4->Label(-text => "Core McStas Package:",
                               -anchor => 'w',
                               -justify => 'left',-fg => 'Black');
$toplabel->pack(-side => 'left');
$f4->pack(-fill => 'both');

my $f5= $w->Frame();
my $install_McStas = $f5->Button(-text => "Install McStas",
                               -anchor => 'w',
                               -justify => 'left',-fg => 'blue', -command => sub{doMcStas()});
$install_McStas ->pack(-side => 'left');
$f5->pack(-fill => 'x');

MainLoop;

sub dopTk() {
  system("pwd");
  print "open-x11  $INSTDIR/tools/pTkInstall.command";
  system("open-x11  $INSTDIR/tools/pTkInstall.command");
}

sub doPGPLOT() {
  my $fid=open(READ,"arch|");
  my $arch;
  while(<READ>) {
    $arch=$_;
    chomp $arch;
  }
  if ($arch eq "i386") {
    $arch = "Intel";
  } else {
    $arch = "PPC";
  }
  
  print "System type is $arch\n";
  system("open $INSTDIR/Applications/SciKarl-${arch}-v0.12.dmg");
}

sub doFreeWRL() {
  system("open $INSTDIR/Applications/FreeWRL-Universal-1.53.dmg");
}

sub doMcStas() {
  system("open-x11  $INSTDIR/tools/InstallMcStas $INSTDIR");
}
