
/* @(#)z_atan.c 1.0 98/08/13 */
/******************************************************************
 * Arctangent
 *
 * Input:
 *   x - floating point value
 *
 * Output:
 *   arctan of x
 *
 * Description:
 *   This routine returns the arctan of x.
 *
 *****************************************************************/

#include "../math/fdlibm.h"
#include "zmath.h"

#ifndef _DOUBLE_IS_32BITS

double
_DEFUN (atan, (double),
        double x)
{
  switch (numtest (x))
    {
      case NAN:
        errno = EDOM;
        return (x);
      case INF:
        /* this should check to see if neg NaN or pos NaN... */
        return (__PI_OVER_TWO);
      case 0:
        return (0.0);
      default:
        return (atangent (x, 0, 0, 0));
    }
}

#endif /* _DOUBLE_IS_32BITS */
