
#define BLUE 1
#define RED 4
#define BLACK 0
#define WHITE 7
#define GREEN 2
#define BROWN 6

#include <dos.h>
#include <errno.h>
#include <conio.h>
#include <stddef.h>
#include <stdlib.h>
#include <malloc.h>
#include <graph.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <sys/stat.h>
#include "manifest.h"
#define TOOLNAME prodname
#define RELEASE prodver
#define NEEDMB 10

char srcdrive[100] = "c:\\rel\\mips64\\disk\\disk0";

/* We're running in VGA mode - 640*480 */

#define DOTS_PER_LINE 16

#define STATUS_LINE1_X1 0
#define STATUS_LINE1_X2 639
#define STATUS_LINE1_ROW 26

#define STATUS_LINE1_Y1 (DOTS_PER_LINE * (STATUS_LINE1_ROW-1))
#define STATUS_LINE1_Y2 (DOTS_PER_LINE * (STATUS_LINE1_ROW))

#define STATUS_LINE2_ROW 27
#define STATUS_LINE2_X1 0

#define STATUS_LINE2_X2 639
#define STATUS_LINE2_Y1 (DOTS_PER_LINE * (STATUS_LINE2_ROW-1))
#define STATUS_LINE2_Y2 (DOTS_PER_LINE * (STATUS_LINE2_ROW+3))

#define BOTTOM_LINE_ROW 15
#define BOTTOM_LINES    10
#define BOTTOM_BOX_X1 0
#define BOTTOM_BOX_X2 639
#define BOTTOM_BOX_Y1 (DOTS_PER_LINE * (BOTTOM_LINE_ROW-1))
#define BOTTOM_BOX_Y2 (BOTTOM_BOX_Y1 + BOTTOM_LINES * DOTS_PER_LINE)

#define TOP_BOX_X1 0
#define TOP_BOX_X2 639

#define TOP_BOX_Y1 200
#define TOP_BOX_Y2 400

#define BX1 200
#define BY1 300
#define BX2 (639 - BX1)
#define BY2 (BY1 + 20)

char buf[200];
char buf1[200];
char prodname[100];
char prodver[100];


static int
center (char *name)
{
  return 40 - strlen (name) / 2;
}

static void
mysystem (char *what)
{
  char buf[400];
  sprintf (buf, "%s >nul", what);
  system (buf);
}

short old_mode;
short old_fgd;
long old_bgd;
struct _rccoord old_pos;
int old_cursor;
static void
clear_and_logo ()
{
  extern char bitmap[];
  short x;
  short y;

  old_fgd = _settextcolor (WHITE);
  old_bgd = _getbkcolor ();
  old_pos = _gettextposition ();
  old_cursor = _displaycursor (_GCURSOROFF);
  if (!(old_mode = _setvideomode (_VRES16COLOR)))
    exit (1);

  _setbkcolor (_BLACK);

  _clearscreen (_GCLEARSCREEN);

  /* 3 light blue */
  /* 4 bright red */
  {
    int odd = 0;

    _setcolor (RED);
    _rectangle (_GFILLINTERIOR, 125 - 3, 50 - 3, 640 - 150 + 3, 125 + 3);

    _setcolor (WHITE);
    _rectangle (_GFILLINTERIOR, 125, 50, 640 - 150, 125);

    for (y = 0; y < 65; y++)
      {
	if (y < 12)
	  _setcolor (BLACK);
	else
	  _setcolor (RED);
	odd = y & 1;
	for (x = 8 * 3; x < 48 * 8; x += 8)
	  {
	    int b;
	    int v = bitmap[y * 48 + x / 8];
	    for (b = 0; b < 8; b++)
	      {
		if (!(v & 0x80))
		  {
		    _setpixel (x + 100 + b, 100 - y + 20);
		  }
		v <<= 1;
	      }
	  }
      }
  }
  _setbkcolor (_BLACK);

  _setcolor (WHITE);
  _settextposition (10, center (TOOLNAME));
  _outtext (TOOLNAME);
  _settextposition (11, center (RELEASE));
  _outtext (RELEASE);
}

void
quit ()
{
  _setvideomode (old_mode);
  _settextcolor (old_fgd);
  _setbkcolor (old_bgd);
  _clearscreen (_GCLEARSCREEN);
  _displaycursor (old_cursor);
/*  _settextposition (old_pos.row, old_pos.col); */


  exit (1);
}




static void
status_line1 (char *line)
{
  _rectangle (_GFILLINTERIOR, STATUS_LINE1_X1, STATUS_LINE1_Y1,
	      STATUS_LINE1_X2, STATUS_LINE1_Y2);
  _settextposition (STATUS_LINE1_ROW, center (line));
  _outtext (line);
}

static void
status_line2 (char *line)
{
  _rectangle (_GFILLINTERIOR, STATUS_LINE2_X1, STATUS_LINE2_Y1,
	      STATUS_LINE2_X2, STATUS_LINE2_Y2);
  _settextposition (STATUS_LINE2_ROW, center (line));
  _outtext (line);
}

static void
error (char *a, int b)
{
  printf ("\n");
  printf (a, b);
  exit (1);
}

unsigned long
get_free (char disk)
{
  unsigned drive = toupper (disk) - 'A' + 1;
  struct _diskfree_t t;
  unsigned long x;
  if (_dos_getdiskfree (drive, &t) == 0)
    {
      x = (long) t.avail_clusters * (long) t.sectors_per_cluster * (long) t.bytes_per_sector;
    }
  else
    {
      error ("Can't work out the size of disk %c.", disk);
    }


  return x;
}


static void
fatal ()
{
  _clearscreen (_GCLEARSCREEN);
  _settextposition (1, 1);
  printf ("There has been a fatal error, installation cannot continue\n");
}


void
edit_string (int r, char *buf, int maxlen)
{
  int ch;
  int len = strlen (buf);

  _displaycursor (_GCURSORON);
  ch = 0;
  while (1)
    {
      if (len < 0)
	len = 0;
      if (len > maxlen - 1)
	len--;

      _settextposition (r, 38 - len / 2);
      _outtext (" ");
      _outtext (buf);
      _outtext (" ");
      _settextposition (r, 38 - len / 2);
      _outtext (" ");
      _outtext (buf);

      ch = _getch ();
      switch (ch)
	{
	case 0xe0:
	case 0:
	  _getch ();		/* Drop esc char */
	case 8:		/* treat like delete */
	  len--;
	  buf[len] = 0;
	  break;
	case 13:
	  _displaycursor (_GCURSOROFF);
	  return;
	case 27:
	  quit ();
	default:
	  if (ch < 127)
	    {
	      buf[len++] = toupper (ch);
	      buf[len] = 0;
	    }
	}
    }
}

static char drive[_MAX_DRIVE];
static char dir[_MAX_DIR];
static char fname[_MAX_FNAME];
static char ext[_MAX_EXT];
static char full[_MAX_PATH];

static void
qual_path (char *input)
{
  int l = strlen (input);
  if (input[l - 1] == '\\')
    {
      input[l - 1] = 0;
    }

  _fullpath (full, input, _MAX_PATH);
  _splitpath (full, drive, dir, fname, ext);
}


static void
clearbottom ()
{
  _setcolor (BLACK);
  _rectangle (_GFILLINTERIOR, BOTTOM_BOX_X1, BOTTOM_BOX_Y1,
	      BOTTOM_BOX_X2, BOTTOM_BOX_Y2);
}


static void
cleartop ()
{
  _setcolor (BLACK);
  _rectangle (_GFILLINTERIOR, TOP_BOX_X1, TOP_BOX_Y1,
	      TOP_BOX_X2, TOP_BOX_Y2);


}

static int
reallymkdir (char *path)
{
  int c;
  struct _stat stat;
  char *e = 0;
  unlink (path);
  mkdir (path);

  if (_stat (full, &stat) == -1)
    {
      e = "Can't create directory %s\n";
    }

  else if (!stat.st_mode & _S_IFDIR)
    {
      e = "There's a file already called %s and it's not a directory\n";
    }
  else
    return 1;

  sprintf (buf, e, path);

  status_line1 (buf);
  status_line2 ("Press [ENTER] to try again, or [ESC] to quit\n");

  while (1)
    {
      c = _getch ();
      status_line1 ("");
      status_line2 ("");

      if (c == '\r')
	return 0;
      if (c == 27)
	quit ();
    }
}

int
yorn ()
{
  while (1)
    {
      int c = _getch ();
      if (c == 'Y' || c == 'y')
	{
	  return 'y';
	}
      if (c == 27)
	quit ();
      if (c == 'N' || c == 'n')
	return 'n';
    }
}

static void
barchart (long part, long whole)
{
  int old = _setcolor (WHITE);
  int range = (int) ((BX2 - BX1) * (part / 1024) / (whole / 1024));
  _rectangle (_GFILLINTERIOR, BX1, BY1, BX2, BY2);
  /* 12 is bright red */
  /* 14 is yellow */
  /* 15 is white */


  if (part == 0)
    {
      range = 5;
    }

  _setcolor (RED);
  _rectangle (_GFILLINTERIOR, BX1 + 3, BY1 + 3, BX1 + range - 1, BY2 - 3);
  _setcolor (WHITE);
  _rectangle (_GFILLINTERIOR, BX1 + range + 1, BY1 + 3, BX2 - 3, BY2 - 3);


  _setcolor (old);

}
static void
tryagain ()
{
  int c;
  clearbottom ();
  _settextposition (BOTTOM_LINE_ROW, 1);
  printf ("\tThere has been an installation error. Type [Y] to try again\n");
  printf ("\tor [N] to quit from the install program.\n");
  c = yorn ();
  clearbottom ();
  if (c == 'n')
    quit ();
}
static void
install (char *root)
{
  /* Make all the directories */
  struct _stat stat;
  struct dirlist *d;
  struct filelist *f;
  long got = 0;

  status_line1 ("Building directories");

  for (d = dirs_head; d; d = d->next)
    {
      sprintf (buf, "%s%s", root, d->name);
      reallymkdir (buf);
      sprintf (buf, "Making directory %s%s", root, d->name);
      status_line2 (buf);
    }

  for (f = files_head; f; f = f->next)
    {

      int ok = 0;
      barchart (got, needed_size);

      /* Don't install the install prog */
      if (stricmp (f->name, "\\install.exe"))
	{
	  while (!ok)
	    {
	      int found = 0;

	      while (!found)
		{
		  sprintf (buf, "%s%s", srcdrive, f->name);
		  if (_stat (buf, &stat) == -1)
		    {
		      char x;
		      status_line1 ("Need next disk");
		      sprintf (buf,
			       "Please insert disk number %d and press [ENTER].", f->disk + 1);
		      printf ("%c", 7);
		      status_line2 (buf);
		      x = _getch ();
		      if (x == 27)
			quit ();
		      else if (x == 'p')
			{
			  edit_string (BOTTOM_LINE_ROW,
				       srcdrive, sizeof (srcdrive));
			}
		      else if (x == 'f')
			{
			  status_line2 (f->name);
			}
		    }
		  else
		    {
		      found = 1;
		    }
		}
	      if (f->depth == 0)
		{
		  sprintf (buf, "Copying from disk %d", f->disk + 1);
		  status_line1 (buf);

		  sprintf (buf, "copy %s%s %s%s",
			   srcdrive, f->name,
			   root, f->name);
		  status_line2 (buf);

		  mysystem (buf);
		}
	      else
		{
		  sprintf (buf, "Expanding from disk %d", f->disk + 1);
		  status_line1 (buf);

		  sprintf (buf, "%s%s", root, f->name);
		  status_line2 (buf);
		  sprintf (buf, "%s%s", root, f->name);
		  sprintf (buf1, "%s%s", srcdrive, f->name);
		  doadecompress (buf1, buf);
		  {
		    int l = strlen (f->name);
		    if (l > 5)
		      {
			char *p = f->name + l - 6;

			if (stricmp (p, "libc.a") == 0)
			  {
			    /* Make an extra copy for a libg.a */
			    char *ptr;
			    sprintf (buf, "copy %s%s %s%s", root, f->name, root, f->name);
			    /* Turn the libc into a libg */
			    *(strrchr (buf, 'c')) = 'g';
			    mysystem (buf);
			  }
		      }
		  }
		}

	      sprintf (buf, "%s%s", root, f->name);

	      if (_stat (buf, &stat) == -1)
		{
		  sprintf (buf, "Error writing %s%s.", root, f->name);
		  status_line2 (buf);
		  printf ("\n");
		  tryagain ();
		}
	      else
		{
		  ok = 1;
		  got += stat.st_size;
		}
	    }
	}
    }

}

char *
get_dest ()
{
  char buf[200];
  struct _stat buff;
  int c;
  long needed = (needed_size / (1024L * 1024L)) + 1;

  while (1)
    {
      clearbottom ();

      _settextposition (15, 1);

      printf ("\n\tThis installation will require around %d Mb of disk space.\n", needed);
      printf ("\tPlease enter the name of the directory into which you want to\n");
      printf ("\tinstall the tools. Press [ENTER] to accept, [ESC] to quit.");
      strcpy (buf, "C:\\CYGNUS");
      edit_string (20, buf, 200);

      qual_path (buf);

      if (get_free (drive[0]) < 1024L * 1024L * needed)
	{
	  printf ("\n\tThis disk has only %ldk of free space, the installation\n",
		  get_free (drive[0]) / (1024L));
	  printf ("\tcan't continue. ");
	  goto fail;
	}

      if (_stat (full, &buff) != -1)
	{
	  /* there is a file already with the name given */
	  if (!(buff.st_mode & _S_IFDIR))
	    {
	      printf ("\n\tThere is already a file with that name, and it's not\n");
	      printf ("\ta directory. The installation can't continue.\n");
	      goto fail;
	    }
	}

      printf ("\n\n\tThe installation will write into %s.\n", full);
      printf ("\tAre you sure you want to continue [Y] or [N]\n");
      c = yorn ();
      if (c == 'y')
	{
	  cleartop ();
	  clearbottom ();
	  return strdup (buf);
	}
      continue;

    fail:
      printf ("\n\tpress any key to try again or [ESC] to quit.");

      if (_getch () == 27)
	quit ();
    }
}

static void 
makescript (char *path)
{
  FILE *f;
  char *per = "%";
  sprintf (buf, "%s\\SETENV.BAT", path);
  f = fopen (buf, "w");

  fprintf (f, "REM %s", TOOLNAME);
  fprintf (f, "SET PATH=%s\\BIN;%sPATH%s\n", path, per, per);
  fprintf (f, "SET GCC_EXEC_PREFIX=%s\\LIB\\\n", path);
  fprintf (f, "SET INFOPATH=%s\\INFO\n", path);
  fprintf (f, "SET C_INCLUDE_PATH=%s\\include\n", path);
  fprintf (f, "SET CPLUS_INCLUDE_PATH=%s\\include\\cxx;%s\\include\n",
	   path, path);
  fprintf (f, "SET GO32=EMU %s\\BIN\\EMU387\n", path);
  fprintf (f, "REM Set TMPDIR to point to a ramdisk if you have one\n");
  fprintf (f, "SET TMPDIR=%s\n", path);
  fclose (f);

}


static void
done (char *path)
{
  status_line1 ("");
  status_line2 ("");
  _settextposition (BOTTOM_LINE_ROW, 1);
  clearbottom ();
  cleartop ();
  printf ("%c", 7);
  printf ("\n\tPlease read the README file which came with this release.\n");
  printf ("\tIt contains important information on how to use these tools.\n");
  printf ("\n\tIf you can't wait, then: \n");
  printf ("\t%c:\n", path[0]);
  printf ("\tcd %s\n", path);
  printf ("\tsetenv\n");
  printf ("\tcd demo\n\tmake\n");
  printf ("\n\n");
  printf ("\tPress [ENTER] to exit the install program.");
  _getch ();
}


void
main (int ac, char **av)
{
  char *path;
  char *p;

  /* Dig out the drive we've been run on, cut of the
     word install */

  strcpy (srcdrive, av[0]);

  for (p = srcdrive; *p; p++)
    {
      if (stricmp (p, "\\INSTALL.EXE") == 0)
	{
	  *p = 0;
	  break;
	}
    }

  get_manifest (srcdrive);
  clear_and_logo ();
  while (1)
    {
      path = get_dest ();
      if (reallymkdir (path))
	{
	  makescript (path);
	  install (path);

	  done (path);
	  quit ();
	}

    }
}
