//
// xmenu_init.cc: XMenu system Initialization routines for Tcl
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1994 Mumit Khan
//

#include "menu.h"
#include "beamline.h"

#include "xmenu.h"
#include "commands.h"

#if !CXX_NO_NAMESPACE
using namespace std;
#endif

/***********************************************************************/

Menu* GLB_menu = nil;
Beamline* GLB_beamline = nil;
ToolMgr* GLB_toolmgr = nil;
bool GLB_debug = false;

int Xmenu_Init(Tcl_Interp* tcl) {

    //
    // register the commands first before creating the menu
    //
    // believe it or not, the 4th and 5th argument casts are needed,
    // otherwise our cfront 3.0.1 on AIX 3.2 chokes! (cf: NULL #define in
    // AIX <stdio.h>
    //
    Tcl_CreateCommand(tcl, "xmenu", 
        reinterpret_cast<Tcl_CmdProc *>(XMenu_MenuCmd), 
	(ClientData)NULL, (Tcl_CmdDeleteProc*)NULL
    );
    Tcl_CreateCommand(tcl, "xpage", 
        reinterpret_cast<Tcl_CmdProc *>(XMenu_PageCmd), 
	(ClientData)NULL, (Tcl_CmdDeleteProc*)NULL
    );
    Tcl_CreateCommand(tcl, "xitem", 
        reinterpret_cast<Tcl_CmdProc *>(XMenu_ItemCmd), 
        (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL
    );
    Tcl_CreateCommand(tcl, "beamline", 
        reinterpret_cast<Tcl_CmdProc *>(XMenu_BeamlineCmd), 
	(ClientData)NULL, (Tcl_CmdDeleteProc*)NULL
    );
    Tcl_CreateCommand(tcl, "tool", 
        reinterpret_cast<Tcl_CmdProc *>(XMenu_ToolCmd), 
	(ClientData)NULL, (Tcl_CmdDeleteProc*)NULL
    );

    /* now create the actual menu and wait for the user */
    GLB_toolmgr = new ToolMgr();
    GLB_menu = new Menu("shadow", *GLB_toolmgr);
    GLB_beamline = new Beamline(*GLB_toolmgr, *GLB_menu->get_synonym_table());
    return TCL_OK;
}

/***********************************************************************/
