//
// menu-page.h: MENU pages interface
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1994-1996 Mumit Khan
//

#ifndef lib_menu_page_h
#define lib_menu_page_h

// =================================================================== //

#include <string>
#include <map>
#include <list>

#include "xrtypes.h"
#include "menu-item.h"

// =================================================================== //
//
// MenuPage defines a unique page in the MENU that contains the list of
// MenuItems to be edited/viewed. Typically a MENU has a list of "top
// level" MenuPage's that correspond to various tools' entry points;
// these top level pages then guide the user thru all the other lower
// level pages via navigation buttons.
//
// MenuPage as implemented is not only just a container for a list of 
// MenuItems, it also maintains the logical Relation on various MenuItems
// in the page. These relations are defined by the "SET" statements in
// the current MENU description, and there is one per page that is 
// evaluated on demand.
//
// =================================================================== //

class Menu;
class Relation;
class Beamline;

class MenuPage {
public:
    MenuPage(const Menu* menu, const std::string& name, const std::string& title, 
	const std::string& type = nil
    );
    virtual ~MenuPage();

    void add_item(MenuItem*);
    const MenuItem* find_item(const std::string& item_name) const;
    const std::list<std::string>& get_items() const;
    const char* name() const;
    const char* title() const;
    const char* type() const;

    void set_relation(Relation*);
    int evaluate_flags(const Beamline*);
    bool get_flag_value(const std::string&) const;

    void dump() const;

private:
    const Menu* menu_;
    std::string name_;
    std::string title_;
    std::string type_;
    std::map< std::string, void*, std::less<std::string> > item_tab_;
    std::list<std::string> item_list_;
    Relation* relation_;
};

// =================================================================== //

#endif/*lib_menu_page_h*/
