/* 
 * tixWinMain.c --
 *
 *	Main entry point for wish and other Tk-based applications.
 *
 * Copyright (c) 1995 Sun Microsystems, Inc.
 *
 * See the file "docs/license.tcltk" for information on usage and
 * redistribution of this file, and for a DISCLAIMER OF ALL
 * WARRANTIES.
 *
 */

#include <tk.h>
#undef Status				/* no thanks for Xlib.h */
#include <tix.h>
#include <blt.h>

extern "C" int Blt_Init (Tcl_Interp*);	/* why can't BLT get this right?? */
extern "C" int Shellexec_Init (Tcl_Interp *interp);
extern "C" int Choose_directory_Init (Tcl_Interp *interp);

#ifndef SHADOW_VERSION
# error Must define SHADOW_VERSION via Makefile.
#endif
#ifndef SHADOW_GUI_VERSION
# error MUST DEFINE SHADOW_GUI_VERSOIN
#endif

#include "xmenu.h"
#include "shdata_cmds.h"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef WIN32_LEAN_AND_MEAN
#include <string.h>
#include <locale.h>
#include <ctype.h>

/*
 * The following declarations refer to internal Tk routines.  These
 * interfaces are available for use, but are not supported.
 */

EXTERN void		TkConsoleCreate(void);
EXTERN int		TkConsoleInit(Tcl_Interp *interp);

/*
 * Forward declarations for procedures defined later in this file:
 */

static void		setargv _ANSI_ARGS_((int *argcPtr, char ***argvPtr));
static void		WishPanic _ANSI_ARGS_(TCL_VARARGS(char *,format));

extern int get_shadow_var (const char* var, char* value, size_t max_len);


/*
 * The following string is the startup script executed in new
 * interpreters.  It looks on disk in several different directories
 * for a script "shadow.tcl" that is compatible with this version
 * of Tk.  The shadow.tcl script does all of the real work of
 * initialization.
 * This script is shared among various files, so make sure "init_file"
 * is set properly for various modules (eg., shplotInit.cc).
 */

static char *initScript =
"proc shadow:init {} {\n\
    global shadow_library env errorInfo\n\
    rename shadow:init {}\n\
    set init_file shadow.tcl\n\
    set dirs {}\n\
    set errors {}\n\
    if [info exists env(SHADOW_TCL_LIBRARY)] {\n\
	lappend dirs [file nativename $env(SHADOW_TCL_LIBRARY)]\n\
    }\n\
    if [info exists env(SHADOW_GUI_ROOT)] {\n\
	lappend dirs [file join [file nativename $env(SHADOW_GUI_ROOT)] lib shadow]\n\
    }\n\
    if [info exists env(SHADOW_ROOT)] {\n\
	lappend dirs [file join [file nativename $env(SHADOW_ROOT)] lib shadow]\n\
    }\n\
    lappend dirs [file nativename $shadow_library]\n\
    lappend dirs [file join [file dirname [file dirname [info nameofexecutable]]] lib shadow]\n\
    lappend dirs [file join [file dirname [file dirname [info nameofexecutable]]] tcl]\n\
    foreach i $dirs {\n\
	set shadow_library $i\n\
	set shadowfile [file join $i $init_file]\n\
	if {[file exists $shadowfile]} {\n\
	    if ![info exists env(SHADOW_ROOT)] {\n\
		set env(SHADOW_ROOT) [file dirname [file dirname $i]]\n\
	    }\n\
	    lappend tcl_pkgPath [file dirname $i]\n\
	    if ![catch {uplevel #0 [list source $shadowfile]} msg] {\n\
		return\n\
	    } else {\n\
		append errors \"$shadowfile: $msg\n$errorInfo\n\"\n\
	    }\n\
	}\n\
    }\n\
    set msg \"Can't find a usable $init_file in the following directories: \n\"\n\
    append msg \"    $dirs\n\n\"\n\
    append msg \"$errors\n\n\"\n\
    append msg \"This probably means that SHADOW GUI wasn't installed properly.\n\"\n\
    error $msg\n\
}\n\
shadow:init";

/*
 *----------------------------------------------------------------------
 *
 * WinMain --
 *
 *	Main entry point from Windows.
 *
 * Results:
 *	Returns false if initialization fails, otherwise it never
 *	returns. 
 *
 * Side effects:
 *	Just about anything, since from here we call arbitrary Tcl code.
 *
 *----------------------------------------------------------------------
 */

int APIENTRY
WinMain(
    HINSTANCE hInstance,
    HINSTANCE hPrevInstance,
    LPSTR lpszCmdLine,
    int nCmdShow
) {
    char **argv, *p;
    int argc;
    char buffer[MAX_PATH];

    Tcl_SetPanicProc(WishPanic);

    /*
     * Set up the default locale to be standard "C" locale so parsing
     * is performed correctly.
     */

    setlocale(LC_ALL, "C");


    /*
     * Increase the application queue size from default value of 8.
     * At the default value, cross application SendMessage of WM_KILLFOCUS
     * will fail because the handler will not be able to do a PostMessage!
     * This is only needed for Windows 3.x, since NT dynamically expands
     * the queue.
     */
    SetMessageQueue(64);

    /*
     * Create the console channels and install them as the standard
     * channels.  All I/O will be discarded until TkConsoleInit is
     * called to attach the console to a text widget.
     */

    TkConsoleCreate();

    setargv(&argc, &argv);

    /*
     * Replace argv[0] with full pathname of executable, and forward
     * slashes substituted for backslashes.
     */

    GetModuleFileName(NULL, buffer, sizeof(buffer));
    argv[0] = buffer;
    for (p = buffer; *p != '\0'; p++) {
	if (*p == '\\') {
	    *p = '/';
	}
    }

    Tk_Main(argc, argv, Tcl_AppInit);
    return 1;
}

/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
Tcl_AppInit(
    Tcl_Interp *interp		/* Interpreter for application. */
)
{

    if (Tcl_Init(interp) == TCL_ERROR) {
	goto error;
    }

    if (Tk_Init(interp) == TCL_ERROR) {
	goto error;
    }
    Tcl_StaticPackage(interp, "Tk", Tk_Init, (Tcl_PackageInitProc *) NULL);

    if (Tix_Init(interp) == TCL_ERROR) {
        goto error;
    }
    Tcl_StaticPackage(interp, "Tix", Tix_Init, (Tcl_PackageInitProc *) NULL);

    if (Blt_Init(interp) == TCL_ERROR) {
        goto error;
    }
    Tcl_StaticPackage(interp, "Blt", Blt_Init, (Tcl_PackageInitProc *) NULL);

    if (Xmenu_Init(interp) == TCL_ERROR) {
	goto error;
    }
    Tcl_StaticPackage(interp, "Xmenu", Xmenu_Init, 
        (Tcl_PackageInitProc *) NULL
    );

    if (Shdata_Init(interp) == TCL_ERROR) {
	goto error;
    }
    Tcl_StaticPackage(interp, "Shdata", Shdata_Init, 
        (Tcl_PackageInitProc *) NULL
    );
    if (Shellexec_Init (interp) == TCL_ERROR) {
        goto error;
    }
    if (Choose_directory_Init (interp) == TCL_ERROR) {
        goto error;
    }

    /*
     * Initialize the shadow_library variable from the registry.
     */

    char buf[1024];
    if (get_shadow_var("SHADOW_TCL_LIBRARY", buf, sizeof(buf)) == 0) {
        Tcl_SetVar(interp, "shadow_library", buf, TCL_GLOBAL_ONLY);
    } else if (get_shadow_var("SHADOW_ROOT", buf, sizeof(buf)) == 0) {
	char *argv[3];
	argv[0] = buf;
	argv[1] = "lib/shadow";
	Tcl_DString ds;
        Tcl_DStringInit(&ds);
	Tcl_DStringSetLength(&ds, 0);
	Tcl_SetVar(interp, "shadow_library", Tcl_JoinPath(2, argv, &ds), 
		TCL_GLOBAL_ONLY);
	Tcl_DStringFree(&ds);
    } else {
        Tcl_SetVar(interp, "shadow_library", 
	    "c:/Program Files/SHADOW " SHADOW_VERSION, TCL_GLOBAL_ONLY);
    }
    Tcl_SetVar(interp, "shadow_version", SHADOW_VERSION, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "shadow_gui_version", SHADOW_GUI_VERSION, TCL_GLOBAL_ONLY);

    if (Tcl_Eval(interp, initScript) == TCL_ERROR) {
	goto error;
    }

#if 0
    /*
     * Initialize the console only if we are running as an interactive
     * application.
     */

    if (TkConsoleInit(interp) == TCL_ERROR) {
	goto error;
    }
#endif

    return TCL_OK;

error:
    WishPanic(interp->result);
    return TCL_ERROR;
}

/*
 *----------------------------------------------------------------------
 *
 * WishPanic --
 *
 *	Display a message and exit.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Exits the program.
 *
 *----------------------------------------------------------------------
 */

void
WishPanic TCL_VARARGS_DEF(char *,arg1)
{
    va_list argList;
    char buf[1024];
    char *format;
    
    format = TCL_VARARGS_START(char *,arg1,argList);
    vsprintf(buf, format, argList);

    MessageBeep(MB_ICONEXCLAMATION);
    MessageBox(NULL, buf, "Fatal Error in Wish",
	    MB_ICONSTOP | MB_OK | MB_TASKMODAL | MB_SETFOREGROUND);
#ifdef _MSC_VER
    _asm {
        int 3
    }
#endif
    ExitProcess(1);
}
/*
 *-------------------------------------------------------------------------
 *
 * setargv --
 *
 *	Parse the Windows command line string into argc/argv.  Done here
 *	because we don't trust the builtin argument parser in crt0.  
 *	Windows applications are responsible for breaking their command
 *	line into arguments.
 *
 *	2N backslashes + quote -> N backslashes + begin quoted string
 *	2N + 1 backslashes + quote -> literal
 *	N backslashes + non-quote -> literal
 *	quote + quote in a quoted string -> single quote
 *	quote + quote not in quoted string -> empty string
 *	quote -> begin quoted string
 *
 * Results:
 *	Fills argcPtr with the number of arguments and argvPtr with the
 *	array of arguments.
 *
 * Side effects:
 *	Memory allocated.
 *
 *--------------------------------------------------------------------------
 */

static void
setargv(
    int *argcPtr,		/* Filled with number of argument strings. */
    char ***argvPtr		/* Filled with argument strings (malloc'd). */
)
{
    char *cmdLine, *p, *arg, *argSpace;
    char **argv;
    int argc, size, inquote, copy, slashes;
    
    cmdLine = GetCommandLine();

    /*
     * Precompute an overly pessimistic guess at the number of arguments
     * in the command line by counting non-space spans.
     */

    size = 2;
    for (p = cmdLine; *p != '\0'; p++) {
	if (isspace(*p)) {
	    size++;
	    while (isspace(*p)) {
		p++;
	    }
	    if (*p == '\0') {
		break;
	    }
	}
    }
    argSpace = (char *) ckalloc((unsigned) (size * sizeof(char *) 
	    + strlen(cmdLine) + 1));
    argv = (char **) argSpace;
    argSpace += size * sizeof(char *);
    size--;

    p = cmdLine;
    for (argc = 0; argc < size; argc++) {
	argv[argc] = arg = argSpace;
	while (isspace(*p)) {
	    p++;
	}
	if (*p == '\0') {
	    break;
	}

	inquote = 0;
	slashes = 0;
	while (1) {
	    copy = 1;
	    while (*p == '\\') {
		slashes++;
		p++;
	    }
	    if (*p == '"') {
		if ((slashes & 1) == 0) {
		    copy = 0;
		    if ((inquote) && (p[1] == '"')) {
			p++;
			copy = 1;
		    } else {
			inquote = !inquote;
		    }
                }
                slashes >>= 1;
            }

            while (slashes) {
		*arg = '\\';
		arg++;
		slashes--;
	    }

	    if ((*p == '\0') || (!inquote && isspace(*p))) {
		break;
	    }
	    if (copy != 0) {
		*arg = *p;
		arg++;
	    }
	    p++;
        }
	*arg = '\0';
	argSpace = arg + 1;
    }
    argv[argc] = NULL;

    *argcPtr = argc;
    *argvPtr = argv;
}

